# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

# [3.15.0](https://github.com/p3ol/oak/compare/v3.14.5...v3.15.0) (2025-12-03)


### Bug Fixes

* add background preview on all elements ([737b1bb](https://github.com/p3ol/oak/commit/737b1bbb9834cb53a74f0511e0ea1906a823627b))
* import order and type fix ([2befa0f](https://github.com/p3ol/oak/commit/2befa0fd1eaafba2676e4d9b9214ca2bff36a9d9))
* import type ([6002e80](https://github.com/p3ol/oak/commit/6002e80020995b33cd904084e41b7e234ddb8bc1))
* imports ([a2fd272](https://github.com/p3ol/oak/commit/a2fd27270ef599a9d0cf5bdf79baa93bc7febedd))
* **react:** fix drag option element type & conditions ([69386d2](https://github.com/p3ol/oak/commit/69386d2a5894867933262140fe103a1600a6fc67))
* repair mutli keys setting behavior ([d20b486](https://github.com/p3ol/oak/commit/d20b48690f1b8f53186ff7872853200843311b91))
* rework serializing overrides ([dbf6a58](https://github.com/p3ol/oak/commit/dbf6a58bdd625a56cbec34a61ff0ffc0ff2583ad))
* types ([0cc7103](https://github.com/p3ol/oak/commit/0cc7103e564db24798e37538b7a18ef5b5149fc1))
* types ([3eec792](https://github.com/p3ol/oak/commit/3eec792b10bcfb2352f55c4641580ea6891b5a71))
* update snapshots ([aab92c1](https://github.com/p3ol/oak/commit/aab92c16cb4887019ff4cedd329c40aa9c0fca81))
* update various deps ([32c2dbe](https://github.com/p3ol/oak/commit/32c2dbe3eadf29f01466b2f7aa4e66df27c0a722))
* upgrade various deps ([6d82950](https://github.com/p3ol/oak/commit/6d82950c0704e00a021a7acbce25d6c620f24553))
* use FormState generic instead of useReducer generic itself ([9c1baf2](https://github.com/p3ol/oak/commit/9c1baf2ed0534f0a608d188878f95f9ba922c382))


### Features

* add keys to FieldOverrideObject ([23c9e91](https://github.com/p3ol/oak/commit/23c9e9106158c860ed962b740469d72d9a756ee3))
* allow to edit image field url ([03cb1f1](https://github.com/p3ol/oak/commit/03cb1f197ef99f33a7fe22f72c761c8061230b2e))
* **field-override:** add EOL ([ce49990](https://github.com/p3ol/oak/commit/ce49990889effa9d5c50a9ebbd3835f2011f128e))
* **field-override:** add example on story ([6ecd50e](https://github.com/p3ol/oak/commit/6ecd50ef26fa1c6f098828742d752d96bcd70079))
* **field-override:** apply serialize and unserialize on fields ([d742eb2](https://github.com/p3ol/oak/commit/d742eb29ed5c4d5fde30bafcffbd6ffb4f2eaf0a))
* **field-override:** rename unserialize to deserialize and other PR review changes ([f26276c](https://github.com/p3ol/oak/commit/f26276c51103b845ef6f69aed33e3f89cb8b26ca))
* **field-override:** rework serialize and unserialize ([66624fd](https://github.com/p3ol/oak/commit/66624fdb097310eef72ec6c83fb168978fb85acd))
* **field-override:** update example ([98fe9db](https://github.com/p3ol/oak/commit/98fe9db53efc73005a7b05c6888eee6cafbe73ce))
* **field-override:** update snapshot ([f5ec62f](https://github.com/p3ol/oak/commit/f5ec62fc39f7de34da42fb830acb870cea212995))
* **react:** add a way to disable cols addition ([e712009](https://github.com/p3ol/oak/commit/e712009b375598db3960902ec3226c1f9ece3502))
* **react:** add a way to disable the catalog ([11e1fd7](https://github.com/p3ol/oak/commit/11e1fd7b70ca2eadc1c0b8458fa6a1f0c1451c02))
* **react:** add removable as override option ([1c55cfc](https://github.com/p3ol/oak/commit/1c55cfc114b20e0e85fe6884983e70bffaa752b9))
* **react:** also disable drag in component option ([2cd2b7b](https://github.com/p3ol/oak/commit/2cd2b7b9b9dd6dac4b40670e86291420e0a5db26))
* update import with alias ([304ca6d](https://github.com/p3ol/oak/commit/304ca6d93fc899923be8393ef429c9f96b3b746e))





## [3.14.5](https://github.com/p3ol/oak/compare/v3.14.4...v3.14.5) (2025-10-23)


### Bug Fixes

* vitest compat ([dc5a951](https://github.com/p3ol/oak/commit/dc5a951745fd213ec366e4782940028f43ecf22f))





## [3.14.4](https://github.com/p3ol/oak/compare/v3.14.3...v3.14.4) (2025-10-22)


### Bug Fixes

* update various deps ([f559cce](https://github.com/p3ol/oak/commit/f559cce007bc2afc02ecb7a8701f1511030278a0))
* upgrade ckeditor to v47 ([cba35a9](https://github.com/p3ol/oak/commit/cba35a95dbd658fa2be867223bd4c1edb84283c4))





## [3.14.3](https://github.com/p3ol/oak/compare/v3.14.2...v3.14.3) (2025-09-22)


### Bug Fixes

* correctly allow to use dynamic options with react builder ([1cc925a](https://github.com/p3ol/oak/commit/1cc925ac464835b57aa6b34104a7a57b62d595b5))
* update various deps ([1866ea9](https://github.com/p3ol/oak/commit/1866ea94af7ddb5034cda6cfb6c7bd473be3741f))





## [3.14.2](https://github.com/p3ol/oak/compare/v3.14.1...v3.14.2) (2025-09-11)


### Bug Fixes

* **theme:** missing tailwind ([6b1d837](https://github.com/p3ol/oak/commit/6b1d837e76b11aa32396723e884ad799804a8649))





## [3.14.1](https://github.com/p3ol/oak/compare/v3.14.0...v3.14.1) (2025-09-11)


### Bug Fixes

* ckeditor ssr errors ([fd528d8](https://github.com/p3ol/oak/commit/fd528d8ff4ad1efa71145d91bd0108d657e49500))





# [3.14.0](https://github.com/p3ol/oak/compare/v3.13.1...v3.14.0) (2025-09-11)


### Bug Fixes

* bad condition ([a2cbb3e](https://github.com/p3ol/oak/commit/a2cbb3e6129e0092da06f88acff64c500a2ce04b))
* upgrade various deps ([9281b2f](https://github.com/p3ol/oak/commit/9281b2f7722babbdd078e0d0f1feee568adbeaa3))


### Features

* add new accessibility tab ([e527e9b](https://github.com/p3ol/oak/commit/e527e9b7d37cd50054e293e9ae678be3c75944a6))
* add role for buttons & clickables ([138bb73](https://github.com/p3ol/oak/commit/138bb737cf1f66378ff37b7083545403f50a64a3))
* **core:** allow to add defaults to builder ([417a2b9](https://github.com/p3ol/oak/commit/417a2b9ba9316a05d5ead7180ef39923778fb855))





## [3.13.1](https://github.com/p3ol/oak/compare/v3.13.0...v3.13.1) (2025-09-08)


### Bug Fixes

* **core:** missing image fields priorities ([a9318c6](https://github.com/p3ol/oak/commit/a9318c66d3d8c3e528a18392e715b93f3a6f422f))





# [3.13.0](https://github.com/p3ol/oak/compare/v3.12.5...v3.13.0) (2025-07-31)


### Bug Fixes

* **ckeditor:** required ckeditor version range ([d08b781](https://github.com/p3ol/oak/commit/d08b78120dafec728c4b7e7ccfb800266b229d70))
* **core:** types ([1fb865f](https://github.com/p3ol/oak/commit/1fb865f3270af289fe627201e011d56359ab7f5c))
* lockfile ([da3b4ce](https://github.com/p3ol/oak/commit/da3b4ceea9868155e084ccee5e1912cd7874a60b))
* migrate to eslint 9 ([fdd642c](https://github.com/p3ol/oak/commit/fdd642c757bf1c8c2c3e71a9b51069a005b31317))
* **strapi:** required strapi version range ([98a7fa7](https://github.com/p3ol/oak/commit/98a7fa72babe3b003d12012b8dbc1c15185b386b))
* type issues ([4b448ba](https://github.com/p3ol/oak/commit/4b448baf6d780866f0da5e9b89d803534948c3ef))
* type issues ([59df745](https://github.com/p3ol/oak/commit/59df745294f0b2265e51e15b651d2196dc71783d))
* update various deps ([a2e1309](https://github.com/p3ol/oak/commit/a2e1309d9cb106fb391af6a92ebaca4ba11d9696))
* upgrade various deps ([6b124a3](https://github.com/p3ol/oak/commit/6b124a31e4cbfd49b76e9bc41e5795dd1c2b68dd))
* upgrade various deps ([1889988](https://github.com/p3ol/oak/commit/1889988e03c456ee0fa03b660715b1be7cee8e06))
* upgrade various deps ([afe9fe0](https://github.com/p3ol/oak/commit/afe9fe06bf13fae2e79426a6236d28723773d22b))


### Features

* add alt setting to image block ([4fdeb65](https://github.com/p3ol/oak/commit/4fdeb65729a9eb64981237f34e063c17643e286d))
* bump node requirement to v22 ([ba9de95](https://github.com/p3ol/oak/commit/ba9de95da47ae53a49b362f598f92f5922bead84))
* extends ComponentOverrideObject interface with reactNode display return type ([c0267bd](https://github.com/p3ol/oak/commit/c0267bd6a618b782a795138f328bedfdcdd8b358))
* **fields:** add a field custom display function to personalize field display on component ([7180f01](https://github.com/p3ol/oak/commit/7180f019ea65f9802272642b63e5a166d6d431dc))
* update snapshots ([873fc6a](https://github.com/p3ol/oak/commit/873fc6ab9ad933eff749e2f81ee29bb38b2a33ee))
* upgrade to ckeditor 46 ([032eacb](https://github.com/p3ol/oak/commit/032eacbb6ef22b1e556708a42456d90de789d4cd))





## [3.12.5](https://github.com/p3ol/oak/compare/v3.12.4...v3.12.5) (2025-06-17)


### Bug Fixes

* missing field props from setting addon ([c7a034a](https://github.com/p3ol/oak/commit/c7a034afa02b525af13226e782adeb1c5b6151e5))





## [3.12.4](https://github.com/p3ol/oak/compare/v3.12.3...v3.12.4) (2025-06-11)


### Bug Fixes

* better override fallback ([c0a795d](https://github.com/p3ol/oak/commit/c0a795dc22ce6a9aa8ee82217d8b9c2bfe3c1d60))
* **react:** allow to override tabs ([3e37775](https://github.com/p3ol/oak/commit/3e37775f6d6b35b8cbd05d53a71b1f114fea27b1))





## [3.12.3](https://github.com/p3ol/oak/compare/v3.12.2...v3.12.3) (2025-06-11)


### Bug Fixes

* add story ([392c5f1](https://github.com/p3ol/oak/commit/392c5f1124798e1a086e41c8c62589448422e41a))
* force setting type to null if useless ([6ed6202](https://github.com/p3ol/oak/commit/6ed6202251eb5410be6c8f9ba540558b4f6a77e2))
* set field type optionnal, as it can be usefull just to hide it ([facdf17](https://github.com/p3ol/oak/commit/facdf170908519a505be59cd9ec237341f284b44))
* **settings:** add component overrides on setting display condition ([fa6b314](https://github.com/p3ol/oak/commit/fa6b314c7e4701a8d959ae058cf5bae8a8d3eee9))





## [3.12.2](https://github.com/p3ol/oak/compare/v3.12.1...v3.12.2) (2025-04-15)


### Bug Fixes

* **react:** remove xmlns attribute in serialized string ([b9eae32](https://github.com/p3ol/oak/commit/b9eae3220a35caa99d2fb9e21f62f78fd51d592f))





## [3.12.1](https://github.com/p3ol/oak/compare/v3.12.0...v3.12.1) (2025-03-13)


### Bug Fixes

* add story ([d810acb](https://github.com/p3ol/oak/commit/d810acbee27c94b7a2e3f3623ec55dbd47b901d4))
* **catalogue:** refresh catalogue when addon change ([c678f8a](https://github.com/p3ol/oak/commit/c678f8aa7ea55b5ad7f3938b42c9c5e8c8b04ef8))





# [3.12.0](https://github.com/p3ol/oak/compare/v3.11.2...v3.12.0) (2025-02-03)


### Bug Fixes

* update various deps ([35577a9](https://github.com/p3ol/oak/commit/35577a9de01741dd91d978db80fd7a9bd05bb5a0))


### Features

* **settings:** allow to pass function to default value prop ([c899cf1](https://github.com/p3ol/oak/commit/c899cf1921f40a1e1de04fd31329a6264adf95f4))
* **settinhs:** remove useless log ([441fec4](https://github.com/p3ol/oak/commit/441fec4952a7ce539d4dd154f52a307422d2c979))





## [3.11.2](https://github.com/p3ol/oak/compare/v3.11.1...v3.11.2) (2024-12-17)


### Bug Fixes

* **react:** type issues ([ae56c84](https://github.com/p3ol/oak/commit/ae56c843308eb8b5187c8b5476e73a0122aee978))





## [3.11.1](https://github.com/p3ol/oak/compare/v3.11.0...v3.11.1) (2024-12-17)

**Note:** Version bump only for package oak





# [3.11.0](https://github.com/p3ol/oak/compare/v3.10.9...v3.11.0) (2024-12-16)


### Bug Fixes

* **ckeditor-5-build-custom:** react version parsing ([134dc89](https://github.com/p3ol/oak/commit/134dc899909d7247e8f82ddfebe0764491e78a59))
* **react:** various type issues ([2d84333](https://github.com/p3ol/oak/commit/2d843336cbffcce598b043925ddc774229ce2fcc))
* update junipero version ([2d3aa1d](https://github.com/p3ol/oak/commit/2d3aa1d8f5002e63e1632d4bf386b16ecbe29f31))
* update react to 19 ([47bd757](https://github.com/p3ol/oak/commit/47bd75702cd18b1868a8cc01b8f8c155be4c43d1))
* upgrade a lot of deps ([2f162dd](https://github.com/p3ol/oak/commit/2f162ddfe10e2b384e4644d4828c532919158b88))
* upgrade various deps ([883baa5](https://github.com/p3ol/oak/commit/883baa541a7ab9a083f3a9b47c2fdc9cf58ab33d))


### Features

* **addon-remirror:** v3 compat ([6e329c0](https://github.com/p3ol/oak/commit/6e329c02968bf948f2fb13d396f4fc8c073ca66a))



# [3.11.0-beta.0](https://github.com/p3ol/oak/compare/v3.10.5...v3.11.0-beta.0) (2024-10-29)


### Bug Fixes

* upgrade various deps ([00dbd10](https://github.com/p3ol/oak/commit/00dbd102b0fe2b58e579756b63ad9300b5199e2d))


### Features

* handle react 19 ([fe75825](https://github.com/p3ol/oak/commit/fe75825c0ac7df4d0e8ff8a01da8838c77487c51))





## [3.10.9](https://github.com/p3ol/oak/compare/v3.10.8...v3.10.9) (2024-11-18)


### Bug Fixes

* **react:** correctly apply overrides targeting single or multiple field keys ([46d8fef](https://github.com/p3ol/oak/commit/46d8fefcc75f2a4a400b70093d38c73e98b8e3ac))
* **react:** correctly apply setting overrides ([e05c48c](https://github.com/p3ol/oak/commit/e05c48cff1f030760d4ad9501a50b6a94642ffbf))
* **react:** correctly handle field with multiple keys for component overrides ([4685ef6](https://github.com/p3ol/oak/commit/4685ef6087cc417154d7c9f9c8efc9c9ff162533))





## [3.10.8](https://github.com/p3ol/oak/compare/v3.10.7...v3.10.8) (2024-11-12)


### Bug Fixes

* title with expand option ([b43bb9d](https://github.com/p3ol/oak/commit/b43bb9d16c27257611ead5e9ad9631c60995a97b))





## [3.10.7](https://github.com/p3ol/oak/compare/v3.10.6...v3.10.7) (2024-11-12)


### Bug Fixes

* date field value not being a date ([ad2ddef](https://github.com/p3ol/oak/commit/ad2ddefe37c285eb417cb450da4e1a972c943f91))
* date menu ([c235b74](https://github.com/p3ol/oak/commit/c235b74f82133e6e9665cb44d4c846647bb4278f))





## [3.10.6](https://github.com/p3ol/oak/compare/v3.10.5...v3.10.6) (2024-11-07)


### Bug Fixes

* add root node to html sanitizer ([2f4c967](https://github.com/p3ol/oak/commit/2f4c967ddaffb28d65676dd9066b9c98f3e374b9))
* upgrade various deps ([3f01c8a](https://github.com/p3ol/oak/commit/3f01c8a202bd69a45a73ae2748bcef98e8bf1c6a))





## [3.10.5](https://github.com/p3ol/oak/compare/v3.10.4...v3.10.5) (2024-10-25)


### Bug Fixes

* make col droppable again ([d9a9439](https://github.com/p3ol/oak/commit/d9a9439402ea1318f7ea5b7c1f1625b3e5be6353))





## [3.10.4](https://github.com/p3ol/oak/compare/v3.10.3...v3.10.4) (2024-10-25)


### Bug Fixes

* **ckeditor5-react:** prevent ckeditor from loading on server side ([2d1fe1c](https://github.com/p3ol/oak/commit/2d1fe1cd1b6130c2386e58d6badf47e079504c28))
* **react:** allow to use polyfills to parse html ([c057a75](https://github.com/p3ol/oak/commit/c057a75f830eab7b47de9e8098b6b7c711b7f8e2))





## [3.10.3](https://github.com/p3ol/oak/compare/v3.10.2...v3.10.3) (2024-10-25)


### Bug Fixes

* **react:** don't pre-filter fields they are already filtered deeper ([142681c](https://github.com/p3ol/oak/commit/142681cf7b6233e5641408ac16f79f59afa25bdc))





## [3.10.2](https://github.com/p3ol/oak/compare/v3.10.1...v3.10.2) (2024-10-22)


### Bug Fixes

* modal editable option wrongly wrapped inside a div ([6f8a98c](https://github.com/p3ol/oak/commit/6f8a98cdc32acc20877a233a7a3554998116a407))





## [3.10.1](https://github.com/p3ol/oak/compare/v3.10.0...v3.10.1) (2024-10-22)


### Bug Fixes

* correctly handle drag & drop ([07ebcd0](https://github.com/p3ol/oak/commit/07ebcd0bd0a3bf202eed5d33ef50267af9574022))
* upgrade various deps ([c29eeff](https://github.com/p3ol/oak/commit/c29eeff71a9db299242bfe963689d37258e50ea6))





# [3.10.0](https://github.com/p3ol/oak/compare/v3.9.1...v3.10.0) (2024-10-15)


### Bug Fixes

* correctly handle non droppable ([a330e99](https://github.com/p3ol/oak/commit/a330e9914381f5a76c020a7369ab0e080ab552a1))
* upgrade various deps ([f23b00b](https://github.com/p3ol/oak/commit/f23b00b6c9cca4d850bc2bf5418bbd8ab2ab821c))


### Features

* allow to disallow duplication & copy ([6f47b1d](https://github.com/p3ol/oak/commit/6f47b1de621270cd24b6326d29ac1206cbc35012))
* also allow to override draggable & droppable ([08b34d9](https://github.com/p3ol/oak/commit/08b34d9cf1a0e277c6577a714777337a8668260b))





## [3.9.1](https://github.com/p3ol/oak/compare/v3.9.0...v3.9.1) (2024-10-11)


### Bug Fixes

* **react:** fix types ([7e609a3](https://github.com/p3ol/oak/commit/7e609a3537df83ac2d1d7bc3bb29cb5d44cdf613))





# [3.9.0](https://github.com/p3ol/oak/compare/v3.8.5...v3.9.0) (2024-10-11)


### Bug Fixes

* allow settings override fields to not have type ([802602c](https://github.com/p3ol/oak/commit/802602c930a6c4dcbbf59b1ac448fde10baafebd))
* **react:** correctly render element, options & fields ([ada4d56](https://github.com/p3ol/oak/commit/ada4d564e0086f469b7214912b390b5a1c3a8875))
* upgrade various deps ([9b89017](https://github.com/p3ol/oak/commit/9b890173148962f27cd8971fbb3d30dbe13021be))


### Features

* **collapse-blocks:** use context instead of value in element ([2a0d252](https://github.com/p3ol/oak/commit/2a0d252c0d7a96cfdbabb36ff4db639c36aa5da5))
* indent ([512df56](https://github.com/p3ol/oak/commit/512df56e9762c6ad51f852b0ab142998dbefad32))
* **react:** add a collapse option for inner content blocks on builder ([70cb6eb](https://github.com/p3ol/oak/commit/70cb6eb30f38c0e940bcc97039c30afddd5ec699))
* **react:** add unfold from element himself ([08df68d](https://github.com/p3ol/oak/commit/08df68dd03b71d961a4f9ddb328c568968ce0491))
* **react:** make the whole element clickable and add cursor: pointer ([8a86c5e](https://github.com/p3ol/oak/commit/8a86c5e3e25c8ad5b4b330425e302ba13d7455f1))
* rework wordings and display ([e2772aa](https://github.com/p3ol/oak/commit/e2772aa8735b0478ce1420039bb33822daf3dbd8))
* update snapshots ([f92a6c4](https://github.com/p3ol/oak/commit/f92a6c452d3b6870d12b1e62210efcf39e62c67c))
* update test snapshots ([5335e05](https://github.com/p3ol/oak/commit/5335e0582fd98d332d398247219a4fa66717e315))





## [3.8.5](https://github.com/p3ol/oak/compare/v3.8.4...v3.8.5) (2024-10-09)


### Bug Fixes

* **fields-setting:** remove key from file override ([98a1d5e](https://github.com/p3ol/oak/commit/98a1d5e68b4cf93fa46c0d6a5fd667156d90c07b))





## [3.8.4](https://github.com/p3ol/oak/compare/v3.8.3...v3.8.4) (2024-09-27)


### Bug Fixes

* correctly condition settings groups ([7c39323](https://github.com/p3ol/oak/commit/7c39323e06e3355566077d594c5fb953fc19d286))





## [3.8.3](https://github.com/p3ol/oak/compare/v3.8.2...v3.8.3) (2024-09-27)


### Bug Fixes

* don't overwrite overrides' fields with wrong fields overrides ([e06e129](https://github.com/p3ol/oak/commit/e06e129fbf4476ebe20961e5cb6316e9b52c834e))





## [3.8.2](https://github.com/p3ol/oak/compare/v3.8.1...v3.8.2) (2024-09-27)


### Bug Fixes

* fields sorting breaking rule of hooks ([cee5819](https://github.com/p3ol/oak/commit/cee5819e45d261a4f7160e95e71539f68cb28490))





## [3.8.1](https://github.com/p3ol/oak/compare/v3.8.0...v3.8.1) (2024-09-27)


### Bug Fixes

* broken settings overrides ([267b3c2](https://github.com/p3ol/oak/commit/267b3c25ebe805b1c7fd6527bd2dbc1ecc463f28))
* only display hover styles for button component ([2248dce](https://github.com/p3ol/oak/commit/2248dcebd0c4580e171cf303f2995da31fff7e00))





# [3.8.0](https://github.com/p3ol/oak/compare/v3.7.13...v3.8.0) (2024-09-26)


### Bug Fixes

* upgrade various deps ([0d4d100](https://github.com/p3ol/oak/commit/0d4d10031db6e14a399209cfa089ce38c99109b0))
* upgrade various deps ([825c9a1](https://github.com/p3ol/oak/commit/825c9a1c8bd19fe8ea85d0e8aa20f2d25b201f0d))


### Features

* add hover & active styling settings ([50c907c](https://github.com/p3ol/oak/commit/50c907c01bfcc9aae54d1f611c3d1388bfc70c51))
* upgrade ckeditor to v43 ([6fbca70](https://github.com/p3ol/oak/commit/6fbca70f1c7a41954f7052223e91858cc5e172fc))





## [3.7.13](https://github.com/p3ol/oak/compare/v3.7.12...v3.7.13) (2024-09-25)


### Bug Fixes

* **react:** wrongly displayed override missing labels ([e63cc31](https://github.com/p3ol/oak/commit/e63cc31e677b7efa744c63a2be5d97e2204f0e0c))





## [3.7.12](https://github.com/p3ol/oak/compare/v3.7.11...v3.7.12) (2024-09-24)


### Bug Fixes

* **theme:** forgot dark mode once again ([df0686c](https://github.com/p3ol/oak/commit/df0686c2b162453c7413bba7bb22e84cefc50889))





## [3.7.11](https://github.com/p3ol/oak/compare/v3.7.10...v3.7.11) (2024-09-24)


### Bug Fixes

* correctly handle custom fields from component overrides ([1fec064](https://github.com/p3ol/oak/commit/1fec06425102b735d39d2815b04400837f30cd49))
* missing tags field helper ([254eeb1](https://github.com/p3ol/oak/commit/254eeb1f7de4895211098224c5bc00ee65875df7))
* prevent incorrect displayable settings ([a0b842f](https://github.com/p3ol/oak/commit/a0b842f6e8316052c588ae84b796356a900db6fe))
* **theme:** broken tags field ([72f64b7](https://github.com/p3ol/oak/commit/72f64b7644753ad4a300319772473f2198042267))
* upgrade various deps ([67f46fd](https://github.com/p3ol/oak/commit/67f46fd85170e238738ebcf7cbb8b213612ca44f))





## [3.7.10](https://github.com/p3ol/oak/compare/v3.7.9...v3.7.10) (2024-09-17)


### Bug Fixes

* **theme:** allow to scroll inside catalogue's tabs ([0177e74](https://github.com/p3ol/oak/commit/0177e748cd9ad4a2760bbd79dfaccf8e89f051df))





## [3.7.9](https://github.com/p3ol/oak/compare/v3.7.8...v3.7.9) (2024-09-11)


### Bug Fixes

* upgrade various deps ([b1980e1](https://github.com/p3ol/oak/commit/b1980e14906244300abd58797d968b54770d9dfb))





## [3.7.8](https://github.com/p3ol/oak/compare/v3.7.7...v3.7.8) (2024-09-09)


### Bug Fixes

* also adds default priorities to responsive settings ([37e15d0](https://github.com/p3ol/oak/commit/37e15d0ee27d62efc5f79ceb61164a65d3d8fac1))
* correctly allow field type override ([9501038](https://github.com/p3ol/oak/commit/9501038a7db69c4eae5dcd338b87a97bc43ebfaa))
* upgrade various deps ([90ef401](https://github.com/p3ol/oak/commit/90ef40157ffd787cb43b2cf0fd27c30f18444c83))





## [3.7.7](https://github.com/p3ol/oak/compare/v3.7.6...v3.7.7) (2024-08-01)


### Bug Fixes

* **deps:** update dependency @floating-ui/react to v0.26.20 ([72b4e14](https://github.com/p3ol/oak/commit/72b4e14475e6d93b709eedb6ded42b32628ffdbd))
* **deps:** update poool junipero monorepo to v3.7.3 ([b23fff5](https://github.com/p3ol/oak/commit/b23fff574b17b2ebc25c1a19ee7cd30dcfa7c430))
* **drag-drop:** remove the verification on disallow for siblings on drop ([da68891](https://github.com/p3ol/oak/commit/da688919f5b34e46ccee77069fc0676af1ca28bf))
* **oak-elements:** set options ont top left for every components that have a custom inner content ([f06c8d3](https://github.com/p3ol/oak/commit/f06c8d30a3f808d5ad14b1c16f13a834b8f2fb6a))
* **options:** remove linebreaks on eof ([cd64ac0](https://github.com/p3ol/oak/commit/cd64ac0249af10be826b7970f6dcaa6dffcfd81f))
* **options:** rename className for innerContent ([a22171a](https://github.com/p3ol/oak/commit/a22171a9ec90da3e6805d2a9f3b43516f09639e5))
* remove useless linebreaks ([0c2452f](https://github.com/p3ol/oak/commit/0c2452f34b3d289e5a9f2197a6e1272243cbbcf3))





## [3.7.6](https://github.com/p3ol/oak/compare/v3.7.5...v3.7.6) (2024-07-19)


### Bug Fixes

* **deps:** update dependency styled-components to v6.1.12 ([070ae44](https://github.com/p3ol/oak/commit/070ae44e22b16252f42bf9952929424a24e72dab))
* update various deps ([a670ecb](https://github.com/p3ol/oak/commit/a670ecb49f19d1c2425330726a320bcd6685eb64))





## [3.7.5](https://github.com/p3ol/oak/compare/v3.7.4...v3.7.5) (2024-07-16)


### Bug Fixes

* **core:** add missing target to button & clickable components ([9885840](https://github.com/p3ol/oak/commit/9885840336a79395422c71ba94639733973af61e))
* upgrade various deps ([48cf2bc](https://github.com/p3ol/oak/commit/48cf2bc25a98a01cc119dac7baad812b6897db1d))





## [3.7.4](https://github.com/p3ol/oak/compare/v3.7.3...v3.7.4) (2024-07-10)


### Bug Fixes

* **react:** correctly handle disallow from overrides ([0c216aa](https://github.com/p3ol/oak/commit/0c216aa2739b9b2ecf364af33d4b5601b41c8571))





## [3.7.3](https://github.com/p3ol/oak/compare/v3.7.2...v3.7.3) (2024-07-10)

**Note:** Version bump only for package oak





## [3.7.2](https://github.com/p3ol/oak/compare/v3.7.1...v3.7.2) (2024-07-10)


### Bug Fixes

* **core:** correctly pass disallow component prop to overrides ([aedbd15](https://github.com/p3ol/oak/commit/aedbd15afef0b8363479e4e0134a6d99d940043e))
* **theme:** editable modal dark mode buttons ([44e0645](https://github.com/p3ol/oak/commit/44e0645bc0243013adac45e56c4556e3c0340c2e))





## [3.7.1](https://github.com/p3ol/oak/compare/v3.7.0...v3.7.1) (2024-07-08)


### Bug Fixes

* various modal editable style issues ([29dc187](https://github.com/p3ol/oak/commit/29dc187476e7a219780666d1443ccea3bd8fe997))





# [3.7.0](https://github.com/p3ol/oak/compare/v3.6.10...v3.7.0) (2024-07-08)


### Bug Fixes

* **core:** missing to object methods ([a49c50b](https://github.com/p3ol/oak/commit/a49c50be091eb8ce7d50d002bd44107fe9bbfd23))
* **deps:** update dependency @floating-ui/react to v0.26.18 ([e7f1448](https://github.com/p3ol/oak/commit/e7f1448f789851a48dcdd7a93d50c4d1b32856ec))
* **deps:** update dependency @floating-ui/react to v0.26.19 ([12b39ba](https://github.com/p3ol/oak/commit/12b39ba68d8e9ecb94c17876d2aff2335ab103b0))
* **editable:** clean code ([1434707](https://github.com/p3ol/oak/commit/1434707bb06132e9b5601c73428d31a697cb97d6))
* **editable:** clean import ([e223fd0](https://github.com/p3ol/oak/commit/e223fd0a1f4ebe2bb2c59d2e5853b6223b7612c2))
* **editable:** clean type of onclick function ([40c1747](https://github.com/p3ol/oak/commit/40c17476b288e64bdb35f042d2b2e956ebae7035))
* move editable to the right ([bb4c1c8](https://github.com/p3ol/oak/commit/bb4c1c8a23254e9485949089e4d6a98392ceb89e))
* **react:** correctly apply settings overrides ([4e27d9e](https://github.com/p3ol/oak/commit/4e27d9eacd282ab1e61d5c20184cfa88019d4b7e))
* **react:** correctly render displayable properties ([1a04cbb](https://github.com/p3ol/oak/commit/1a04cbb0de25aae6d84614dcb934fc7c01797858))
* update dependencies ([ad0f397](https://github.com/p3ol/oak/commit/ad0f397c1e6f4fa2d25f0bee0e1d27086d3226c1))


### Features

* add new clickable component ([f9bd61d](https://github.com/p3ol/oak/commit/f9bd61d3d2fdf968ed5ecc125d24cdcf7175a468))
* **deps:** update poool junipero monorepo to v3.7.0 ([eb81056](https://github.com/p3ol/oak/commit/eb810561d68c8072c08ccfb6e3420aedf6f15b11))
* **editable:** add editable-type props in context builder ([b3b6c62](https://github.com/p3ol/oak/commit/b3b6c629f85264cd6338ab522613dcb0092fb958))
* **editable:** add story for editable modal ([73393fc](https://github.com/p3ol/oak/commit/73393fcac71474b8b942017c98d2d76482e295ee))
* **editable:** retrieve editable-type in option of builder ([01b5e0c](https://github.com/p3ol/oak/commit/01b5e0c3d00896e30ac195527b4a35ed6ab28526))
* **editable:** update for display panel modal ([8f727cb](https://github.com/p3ol/oak/commit/8f727cb8c3ecd554d32268278c8f3a3a68dedcdd))
* **react:** add background preview to col component ([360e2b2](https://github.com/p3ol/oak/commit/360e2b2d83ac957a6e532411ef5af65638da8000))





## [3.6.10](https://github.com/p3ol/oak/compare/v3.6.9...v3.6.10) (2024-06-20)


### Bug Fixes

* **ckeditor5-build-custom:** wrong react runtime ([edc5577](https://github.com/p3ol/oak/commit/edc55773c2c65e1f9ec48ca69ec6fb1cd411c3d8))
* upgrade various deps ([9af77d7](https://github.com/p3ol/oak/commit/9af77d7efb7e10fcebf1633e273e1e4779071087))





## [3.6.9](https://github.com/p3ol/oak/compare/v3.6.8...v3.6.9) (2024-06-19)

**Note:** Version bump only for package oak





## [3.6.8](https://github.com/p3ol/oak/compare/v3.6.7...v3.6.8) (2024-06-19)


### Bug Fixes

* **core:** add missing border style ([f593f50](https://github.com/p3ol/oak/commit/f593f509f3befa8aaed16af3008cc9c366a36b6c))





## [3.6.7](https://github.com/p3ol/oak/compare/v3.6.6...v3.6.7) (2024-06-19)


### Bug Fixes

* **core:** correctly allow to override editable prop ([3ef0bbc](https://github.com/p3ol/oak/commit/3ef0bbcfec3ad43d25493b0e7e80d383c0386135))
* **react:** correctly allow to override editable prop ([a7e6092](https://github.com/p3ol/oak/commit/a7e60928ecc4581d6cfcc8af04e3adae577ee5ac))





## [3.6.6](https://github.com/p3ol/oak/compare/v3.6.5...v3.6.6) (2024-06-19)


### Bug Fixes

* **core:** wrong getText param type ([c6ec87b](https://github.com/p3ol/oak/commit/c6ec87bdf579af9ebbbd8ced4f39f168ca05401d))





## [3.6.5](https://github.com/p3ol/oak/compare/v3.6.4...v3.6.5) (2024-06-19)


### Bug Fixes

* **core:** optional parameter ([18cec71](https://github.com/p3ol/oak/commit/18cec71d04c26aa597cdfa68dbabe42d2e66b04e))
* **core:** remove some any types ([c2fb150](https://github.com/p3ol/oak/commit/c2fb1505d0569d68c8de48a117eb04440a9ea449))
* **react:** export missing type ([f2d4207](https://github.com/p3ol/oak/commit/f2d4207c4b3b45f9855a79e228d169f4f51e343b))
* **react:** wrong builder options type ([cbd9d63](https://github.com/p3ol/oak/commit/cbd9d632f18df160e543afca0481f065d4b507a1))





## [3.6.4](https://github.com/p3ol/oak/compare/v3.6.3...v3.6.4) (2024-06-14)


### Bug Fixes

* upgrade various deps ([dae1ba8](https://github.com/p3ol/oak/commit/dae1ba855b14ade39eedd28279c59473bd7f2b49))
* various type issues ([4047d6c](https://github.com/p3ol/oak/commit/4047d6c86545163a86f27cb324c8478a36e55864))





## [3.6.3](https://github.com/p3ol/oak/compare/v3.6.2...v3.6.3) (2024-06-11)


### Bug Fixes

* **core:** wrong addons export ([e1b14a4](https://github.com/p3ol/oak/commit/e1b14a48c1a8aa6ac8cab01675644d5084157dd1))
* **react:** missing forwarded export ([5d4af48](https://github.com/p3ol/oak/commit/5d4af488075b3fdc3c572c8e51717f0020e596f6))
* update junipero ([2beb16e](https://github.com/p3ol/oak/commit/2beb16e5d01c6f9ef8ebfdd08f1f65f26609720f))





## [3.6.2](https://github.com/p3ol/oak/compare/v3.6.1...v3.6.2) (2024-06-11)


### Bug Fixes

* npm ignore tsconfig ([720dbb5](https://github.com/p3ol/oak/commit/720dbb5044ba2464013504efad36f534e56169b7))





## [3.6.1](https://github.com/p3ol/oak/compare/v3.6.0...v3.6.1) (2024-06-11)


### Bug Fixes

* **react:** missing types exports ([9e9d6d5](https://github.com/p3ol/oak/commit/9e9d6d5590d32591cd6c5232f9a6c9b8c5f458e7))





# [3.6.0](https://github.com/p3ol/oak/compare/v3.5.6...v3.6.0) (2024-06-11)


### Bug Fixes

* **addon-ckeditor5-react:** update ckeditor to v41 ([ef99c10](https://github.com/p3ol/oak/commit/ef99c1002a5dba9bb318cd2c5521e7f04ed26de8))
* **core:** settings override not working ([668109a](https://github.com/p3ol/oak/commit/668109afde59a58e87dbaae26a1fb7db4ac3ca93))
* **core:** types ([0c44447](https://github.com/p3ol/oak/commit/0c44447ffced5670c112beb16ee8fea96241e00e))
* **react:** a lot of types ([8458000](https://github.com/p3ol/oak/commit/8458000b90ae59e1ce4ec081d48f2adf79deb288))
* **react:** a lot of types issues ([cdf9ef0](https://github.com/p3ol/oak/commit/cdf9ef09b737f648afbf593b067473a5de699073))
* **react:** allow more sibling fields in editable ([95a6404](https://github.com/p3ol/oak/commit/95a6404148c2758f85fb7d144b9870b2609a5be1))
* **react:** clean code ([f5079f6](https://github.com/p3ol/oak/commit/f5079f64b1d56994d251fc71fb3451b5ce721119))
* **react:** image field preview ([469391e](https://github.com/p3ol/oak/commit/469391e9cf832c87d9911feb273f51da911ba60c))
* **react:** missing exports ([51a36ed](https://github.com/p3ol/oak/commit/51a36edf9bc647d0b2a507b0193890834072c8cf))
* **react:** update and clean code ([9c19732](https://github.com/p3ol/oak/commit/9c197322c3f66f4d1247eb62151f88bf6f8267d2))
* tests typings ([f3ba27e](https://github.com/p3ol/oak/commit/f3ba27e3897f74f099b0d240ae76194f321392cc))
* **theme:** editable fields menus zindex ([0c92e1c](https://github.com/p3ol/oak/commit/0c92e1c359000d5e6ad5754f4612843541b6c049))
* update junipero ([64aeff9](https://github.com/p3ol/oak/commit/64aeff92b2add9c0262a0806748295603a929167))
* update various deps ([8b72c2a](https://github.com/p3ol/oak/commit/8b72c2a84215181363efb26e059b5056fa3e9305))
* various remaining type issues ([a975e97](https://github.com/p3ol/oak/commit/a975e975ef60e5504cef8f934ba6310560f59d07))


### Features

* add box shadow styling field ([0f635a4](https://github.com/p3ol/oak/commit/0f635a43f4a891bcc04d0892317aa5fb26e88e92))
* **core:** add border width, color & radius ([f3b990b](https://github.com/p3ol/oak/commit/f3b990bbfe2e445a8da8b1e5c9572db5983e22bf))
* **typescript-core:** lint core files ([441e4d3](https://github.com/p3ol/oak/commit/441e4d3fbf1ea1efb14cfe08dfab1ffa736c202f))
* **typescript-core:** remove react ([6ed6f20](https://github.com/p3ol/oak/commit/6ed6f2059cbca1adcfca8760a669231bc743ed4e))
* **typescript-core:** remove react ([21fa955](https://github.com/p3ol/oak/commit/21fa955ae006c01e0c849ebafd0bca160da8a7d1))
* **typescript-core:** revert react ([b973f43](https://github.com/p3ol/oak/commit/b973f437dc533c9a5ec4b795b2ee5de16aa74580))
* **typescript-react:** begin react package ([62d8dee](https://github.com/p3ol/oak/commit/62d8dee8b3cc6dae7f81653d797ca84d47daf6f8))
* **typescript-react:** rework react builder ([04bbbd7](https://github.com/p3ol/oak/commit/04bbbd7ce166114ea11f7428a5fab8ebeb131790))
* **typescript-react:** type builder react ([1ef7ff3](https://github.com/p3ol/oak/commit/1ef7ff32e962c1b256604f3bd9718a2c4bd95566))
* **typescript:** builder constructor rework ([c00ceae](https://github.com/p3ol/oak/commit/c00ceae3f3adc511ae80f13957d0d81f45493f22))
* **typescript:** rework core lib ([59a799d](https://github.com/p3ol/oak/commit/59a799d51c1e09991c9b69af06d926784df3d7a3))
* **typescript:** wip typescript ([cdd6222](https://github.com/p3ol/oak/commit/cdd6222070b88eb878579656391d7721ea1b2d28))
* **typescript:** wip typescript ([88dec47](https://github.com/p3ol/oak/commit/88dec47fce29d8e3768305b39c5fc9cdb1e67ffa))
* **typescript:** wip typescript ([1c12174](https://github.com/p3ol/oak/commit/1c12174a47c0744dcde2a8c353be6f24bef4d616))
* **typescript:** wip typescript - react package ([f4ca25f](https://github.com/p3ol/oak/commit/f4ca25f4535a6028b1ec128597cae5ad5e5f20e6))





## [3.5.6](https://github.com/p3ol/oak/compare/v3.5.5...v3.5.6) (2024-05-29)


### Bug Fixes

* **theme:** update junipero theme ([d342811](https://github.com/p3ol/oak/commit/d3428112fdac359a914350b66c111fa956df6b61))





## [3.5.5](https://github.com/p3ol/oak/compare/v3.5.4...v3.5.5) (2024-05-29)


### Bug Fixes

* **deps:** update dependency @floating-ui/react to v0.26.16 ([2c7fd0a](https://github.com/p3ol/oak/commit/2c7fd0a97a6aba55a23d97b23f8217b6ca586645))
* **deps:** update dependency remirror to v2.0.39 ([9196385](https://github.com/p3ol/oak/commit/9196385f0d181e955c8ab646f044c8f4bf941430))
* **deps:** update dependency styled-components to v6.1.11 ([4b564ad](https://github.com/p3ol/oak/commit/4b564ad6ca9c3b1fb9199f0aa5db49b40fa02415))
* **floating-ui:** add shift option to floating col and row options ([ae48220](https://github.com/p3ol/oak/commit/ae48220616fb50b66262e0950e9ccbdc160bfb20))
* **floating-ui:** add shift option to floating col and row options ([1d79726](https://github.com/p3ol/oak/commit/1d797269cc69e0c2b68fce4fb39dbfdf8a711349))
* upgrade various dependencies ([33eeb54](https://github.com/p3ol/oak/commit/33eeb547b85298cb43c324601cb0d4270358c715))





## [3.5.4](https://github.com/p3ol/oak/compare/v3.5.3...v3.5.4) (2024-04-17)


### Bug Fixes

* **theme:** junipero icons wrongly overridden ([d614c6b](https://github.com/p3ol/oak/commit/d614c6ba2af7665800988dd63b96515350ae28c0))





## [3.5.3](https://github.com/p3ol/oak/compare/v3.5.2...v3.5.3) (2024-04-17)


### Bug Fixes

* **theme:** move junipero theme to standalone file ([6d51e80](https://github.com/p3ol/oak/commit/6d51e8018418b4bbfcd97933d58196edaf36082e))





## [3.5.2](https://github.com/p3ol/oak/compare/v3.5.1...v3.5.2) (2024-04-08)


### Bug Fixes

* **types:** fix some types errors ([c3f7102](https://github.com/p3ol/oak/commit/c3f7102a9d81c9130b539cfd027f366291cefa1f))
* **types:** switch from componentObject to ElementObject ([9e29671](https://github.com/p3ol/oak/commit/9e2967169848df54bb8de5d02bf3345f2a200f8d))
* update various deps ([c1f22bd](https://github.com/p3ol/oak/commit/c1f22bd8dd647a9fbc7f637ba6cad6f931646448))





## [3.5.1](https://github.com/p3ol/oak/compare/v3.5.0...v3.5.1) (2024-02-19)

**Note:** Version bump only for package oak





# [3.5.0](https://github.com/p3ol/oak/compare/v3.4.0...v3.5.0) (2024-02-19)


### Bug Fixes

* **core:** fix merge overrides options behavior ([3f1cf61](https://github.com/p3ol/oak/commit/3f1cf617102b22c0cb944c0c7f33c275c59bfe76))
* **deps:** update dependency @floating-ui/react to v0.26.9 ([63ce76b](https://github.com/p3ol/oak/commit/63ce76bb171a882db513ad4ac1ab8fb1ff41346e))
* **deps:** update dependency remirror to v2.0.38 ([71583d5](https://github.com/p3ol/oak/commit/71583d56ec99308d81257e504116f0bfdfadef71))
* **deps:** update dependency styled-components to v6.1.8 ([5354a57](https://github.com/p3ol/oak/commit/5354a574d633a79c08e43992911b40b5cda6accb))
* **deps:** update poool junipero monorepo ([a9428e7](https://github.com/p3ol/oak/commit/a9428e74d7f6887afcabc138d612f10e624c47ab))
* fix a lot of type issues ([6ff92c0](https://github.com/p3ol/oak/commit/6ff92c02f9eaf2cf017b33a311c5504f500001e5))
* move back to yarn ([4603d57](https://github.com/p3ol/oak/commit/4603d57db927df0cc4dc9f5cd7acc348d7a03809))
* **overrides:** remove useless import ([7ef6495](https://github.com/p3ol/oak/commit/7ef64956d9d613518709b092aad383e56d325e1c))
* **react:** forward icon ref ([927e375](https://github.com/p3ol/oak/commit/927e37514be5c94f271718155a78ccc00cd43a1f))


### Features

* **ckeditor:** add Ck editor package types and enhance other ([3de5ded](https://github.com/p3ol/oak/commit/3de5dede3a92d4a7bcea9ff548eb0897d4b6cf4f))
* **core:** add info prop to field def ([c774acf](https://github.com/p3ol/oak/commit/c774acff04133c502b5ca82ac4925053ddfd836d))
* **deps:** update dependency @strapi/design-system to v1.14.1 ([9f0712c](https://github.com/p3ol/oak/commit/9f0712c64815bfeeadc709d9aaa2e4dafc8ae02e))
* **deps:** update dependency core-js to v3.36.0 ([ecd2143](https://github.com/p3ol/oak/commit/ecd214319d6e830ff0a9ef02b379cb444df139e7))
* **react:** add info tooltip to fields ([ac38c5e](https://github.com/p3ol/oak/commit/ac38c5e85e4198895d20cdf96a1207e441d6716d))





# [3.4.0](https://github.com/p3ol/oak/compare/v3.3.0...v3.4.0) (2023-11-24)


### Bug Fixes

* **deps:** update dependency core-js to v3.33.3 ([36a79b9](https://github.com/p3ol/oak/commit/36a79b98a27873778ad5a716af6faab8cc5ff5a0))
* **react:** wrong settings order ([13ac8c4](https://github.com/p3ol/oak/commit/13ac8c44a95250875483e6f0deb097d1185a0a34))
* **renovate:** extend p3ol custom Presets ([e3163d9](https://github.com/p3ol/oak/commit/e3163d916dcb87950037cd787674cddafcefcdb4))


### Features

* **deps:** update dependency @ckeditor/ckeditor5-react to v6.2.0 ([fbfcd86](https://github.com/p3ol/oak/commit/fbfcd86c551fa77f9a9f53939864952b524f9d2c))
* **react:** add priority override for settings ([0720afb](https://github.com/p3ol/oak/commit/0720afb4d0369860ee3468e6eeda51876cac6517))





# [3.3.0](https://github.com/p3ol/oak/compare/v3.2.2...v3.3.0) (2023-11-15)


### Bug Fixes

* **core:** don't re-add existing components ([9e769c2](https://github.com/p3ol/oak/commit/9e769c211f68b62a4a92656c488091098de60242))
* **core:** overrides not being added correctly ([3f6fccb](https://github.com/p3ol/oak/commit/3f6fccbdb6b40a5bc7ffde59653f7bcff5a89404))
* **deps:** update dependency @babel/runtime-corejs3 to v7.22.11 ([d5462ca](https://github.com/p3ol/oak/commit/d5462ca598474e3309a174bedc096558f08f3f1d))
* **deps:** update dependency @floating-ui/react to v0.25.2 ([b2e8892](https://github.com/p3ol/oak/commit/b2e8892c631f2d161583c0b2439e85c5a8b7d144))
* **deps:** update dependency @floating-ui/react to v0.25.3 ([8ead50e](https://github.com/p3ol/oak/commit/8ead50e3147131913d5cf0a73e17db13f6f13fb5))
* **deps:** update dependency @floating-ui/react to v0.25.4 ([c861e19](https://github.com/p3ol/oak/commit/c861e193e6c9e167937ed997035baaebd288fcf5))
* **deps:** update dependency core-js to v3.32.1 ([e0a2ba5](https://github.com/p3ol/oak/commit/e0a2ba5a046d7f69de73897ffed7dec79fe6a227))
* **deps:** update dependency core-js to v3.32.1 ([6554864](https://github.com/p3ol/oak/commit/65548645a826cf7e6087e44d2c8dbed883eb9285))
* **deps:** update dependency core-js to v3.32.2 ([41b793e](https://github.com/p3ol/oak/commit/41b793eb70b4270cea72c77a1720afd858e45416))
* **deps:** update dependency remirror to v2.0.37 ([700822e](https://github.com/p3ol/oak/commit/700822ecd75d6165a7b15d8f6cad46878b9150c6))
* **deps:** update dependency remirror to v2.0.37 ([4c620da](https://github.com/p3ol/oak/commit/4c620da13c19b5724946901a439afeeefde1e173))
* **deps:** update dependency uuid to v9.0.1 ([271ada9](https://github.com/p3ol/oak/commit/271ada9f3a0a1debf718765db611828c7f116d62))
* **react:** allow to use custom option icon classname ([c965568](https://github.com/p3ol/oak/commit/c965568045771d8f6559eea39f92dda43762f2da))
* **react:** correctly rerender on addons updates ([0d74897](https://github.com/p3ol/oak/commit/0d7489716817a6d6cce0617953dcbbb3ddc98120))
* **react:** fix wrong drag option render ([3500f73](https://github.com/p3ol/oak/commit/3500f73f858589072b73d13b943ad4e5f1f98e91))
* **strapi-plugin:** force styled-components v6 ([0516f24](https://github.com/p3ol/oak/commit/0516f2408089ba7d5a78787f48fd6c5f505308de))
* **theme:** add missing drag option icon styling ([2b17573](https://github.com/p3ol/oak/commit/2b17573f123fea98b4c4950b793c1d19dde7565f))


### Features

* **deps:** update dependency @floating-ui/react to v0.26.2 ([27b430d](https://github.com/p3ol/oak/commit/27b430d296371a251333917255ec2d7714d836c7))
* **deps:** update dependency core-js to v3.33.2 ([acf5e5f](https://github.com/p3ol/oak/commit/acf5e5f68260e93ca7c4b8dc872bd83cc9dcf32c))
* **deps:** update dependency core-js to v3.33.2 ([b9a0a1a](https://github.com/p3ol/oak/commit/b9a0a1ada4b11bcd71c6a549a3f71da48908af74))
* **deps:** update junipero monorepo ([3d7af43](https://github.com/p3ol/oak/commit/3d7af43aeb9209b23fb2c7b2ca41e50e1406f87b))
* handle addons updates/removal ([827fc20](https://github.com/p3ol/oak/commit/827fc20ec188bde86cd1b71135f62f0ca83e5106))





## [3.2.2](https://github.com/p3ol/oak/compare/v3.2.1...v3.2.2) (2023-08-15)


### Bug Fixes

* **deps:** update dependency @babel/runtime-corejs3 to v7.22.10 ([73fd824](https://github.com/p3ol/oak/commit/73fd8249be28c909694e0ad7e3b9a4850aceff13))
* **deps:** update dependency @floating-ui/react to v0.25.1 ([1b4e6bb](https://github.com/p3ol/oak/commit/1b4e6bb3f00e2fa5558acb46cb247981b343fd7a))
* **theme:** update upstream junipero with broken css fix ([a971d23](https://github.com/p3ol/oak/commit/a971d2346aed296dc3c4bd500d7ea5063e514841))





## [3.2.1](https://github.com/p3ol/oak/compare/v3.2.0...v3.2.1) (2023-08-04)


### Bug Fixes

* **ckeditor5-build-custom:** fix ckeditor versions ([011cefa](https://github.com/p3ol/oak/commit/011cefaf51962610b91dfe7cffab3b5240c40b68))
* **deps:** update dependency @remirror/pm to v2.0.8 ([0dee2af](https://github.com/p3ol/oak/commit/0dee2af9d03c936de318651e35956bc3e8c0950d))
* **deps:** update dependency @remirror/react to v2.0.35 ([4716dd7](https://github.com/p3ol/oak/commit/4716dd7f8b591bb329f4d636f8a6876d2c324264))
* **deps:** update dependency remirror to v2.0.36 ([dfe5c01](https://github.com/p3ol/oak/commit/dfe5c012eb97372cb4983e00bb469cf6ccbc21a3))
* update junipero ([c467fa1](https://github.com/p3ol/oak/commit/c467fa1826369884811d901010d9549a2f19cab5))


### Features

* **deps:** update dependency @floating-ui/react to v0.25.0 ([284b27b](https://github.com/p3ol/oak/commit/284b27b0a518f69f3b0190dca71bb394f750251d))
* **deps:** update junipero monorepo to v3.2.0 ([d3a087c](https://github.com/p3ol/oak/commit/d3a087c376cffb31284f11b559aabe314de060fa))





# [3.2.0](https://github.com/p3ol/oak/compare/v3.1.0...v3.2.0) (2023-07-20)


### Bug Fixes

* **deps:** update dependency @floating-ui/react to v0.24.4 ([6e9c789](https://github.com/p3ol/oak/commit/6e9c789e8c04396d5217ffe14faac913e6364b9d))
* **deps:** update dependency @floating-ui/react to v0.24.5 ([301a0a9](https://github.com/p3ol/oak/commit/301a0a90c79465eb56675961345f30e010eb16fc))
* **deps:** update dependency @floating-ui/react to v0.24.6 ([2fa5793](https://github.com/p3ol/oak/commit/2fa5793eec89e82380c8490aaa72604353f7f616))
* **deps:** update dependency @floating-ui/react to v0.24.7 ([baf6752](https://github.com/p3ol/oak/commit/baf675255020ba2db152f466d9d6f33df6e37f5b))
* **deps:** update dependency @floating-ui/react to v0.24.8 ([ca05037](https://github.com/p3ol/oak/commit/ca05037c6677eae51696c3d474ff3ac2a051c379))
* **deps:** update dependency @remirror/react to v2.0.30 ([cc1929a](https://github.com/p3ol/oak/commit/cc1929a8255669367117c9791ddaf4a74e51332c))
* **deps:** update dependency @remirror/react to v2.0.31 ([6c44677](https://github.com/p3ol/oak/commit/6c44677a15b53ea0dae2f53f5abe4ee04ba23d9a))
* **deps:** update dependency @remirror/react to v2.0.32 ([434590a](https://github.com/p3ol/oak/commit/434590a24fad8094a9277c6d57cfaf1d24270555))
* **deps:** update dependency @remirror/react to v2.0.33 ([34ba414](https://github.com/p3ol/oak/commit/34ba414060780036ab0b90f927a5fdb7d8d2736e))
* **deps:** update dependency @remirror/react to v2.0.34 ([47eb21e](https://github.com/p3ol/oak/commit/47eb21e353b6807126255939fa2b8763c01b9dc9))
* **deps:** update dependency @strapi/design-system to v1.8.1 ([a213445](https://github.com/p3ol/oak/commit/a2134451896da8b13bca5bad63d9a36bddeda47b))
* **deps:** update dependency @strapi/design-system to v1.8.2 ([e9f2a50](https://github.com/p3ol/oak/commit/e9f2a50ee04e92dd4d43f8006dc678831c96c3dd))
* **deps:** update dependency core-js to v3.31.1 ([cfa996d](https://github.com/p3ol/oak/commit/cfa996d41aca74a0399882c03b7ab9c7d96a8cec))
* **deps:** update dependency remirror to v2.0.33 ([0510274](https://github.com/p3ol/oak/commit/0510274156cfc9d195bda73417aa57bfad80827f))
* **deps:** update junipero monorepo ([d3b51ab](https://github.com/p3ol/oak/commit/d3b51ab21eee46bdecc73ac68762b0dd6b30aa4f))
* reorder overrides on editable ([9d5dfd4](https://github.com/p3ol/oak/commit/9d5dfd431592f87b8c9efd3bc368f41ddceca701))
* reuse getField when getting overrides ([0947dcb](https://github.com/p3ol/oak/commit/0947dcbc8522311f7893c437418f71ea55296244))


### Features

* **react:** add builder to condition callback ([5666f0c](https://github.com/p3ol/oak/commit/5666f0c3c41a7a52f427ccc605c58b4d951bdc71))





# [3.1.0](https://github.com/p3ol/oak/compare/v3.0.10...v3.1.0) (2023-06-30)


### Bug Fixes

* property name typo ([032786e](https://github.com/p3ol/oak/commit/032786e30909a17c354707bd76e1211eb77137fd))


### Features

* allow global settings overrides ([63e6822](https://github.com/p3ol/oak/commit/63e6822b6d11bd0626b11a5f03bfe204213c3cf8))
* **core:** add draft of setting overrides ([88a89a0](https://github.com/p3ol/oak/commit/88a89a01f7f1d7a294751c5891f567bd12a7bca4))
* **core:** pass component fields overrides to editable ([79235d6](https://github.com/p3ol/oak/commit/79235d60b484d7e99948fae41b0243942ce08faa))
* **deps:** update dependency @ckeditor/ckeditor5-react to v6.1.0 ([ce81ebc](https://github.com/p3ol/oak/commit/ce81ebc9d7201fd6224281c63abdf85e563ea350))
* **deps:** update dependency core-js to v3.31.0 ([9dbd14b](https://github.com/p3ol/oak/commit/9dbd14b807168595afcdc034f7024fced23254cb))
* **deps:** update junipero monorepo to v3.1.0 ([c1d7e96](https://github.com/p3ol/oak/commit/c1d7e96ae9d4e7dfdf1b3a990e39b3753e77c785))
* **react:** allow to override field settings ([368aa1a](https://github.com/p3ol/oak/commit/368aa1add530de4c546cb01b6e99d93b01a820f4))





## [3.0.10](https://github.com/p3ol/oak/compare/v3.0.9...v3.0.10) (2023-06-29)


### Bug Fixes

* **addon-ckeditor5-react:** missing new tab option ([e4578cd](https://github.com/p3ol/oak/commit/e4578cdf91b09536360681449e9870b9c88fa437))
* **ci-cd:** use yarn cache for node libraries ([633568e](https://github.com/p3ol/oak/commit/633568e412f2ce6e731fe8d90de65e7e93a7e930))
* **deps:** update dependency @floating-ui/react to v0.24.3 ([d48e6a3](https://github.com/p3ol/oak/commit/d48e6a3363f72fd764ada996a929ee6f1ee6be56))
* **deps:** update dependency @remirror/react to v2.0.29 ([8ac79e1](https://github.com/p3ol/oak/commit/8ac79e1ff14a63d19fa5a71ab7899f83398cd99e))
* **renovate:** improve config for PRs and commits ([126692e](https://github.com/p3ol/oak/commit/126692e6ecd06d79bc2338ca5067c7df66e1f278))
* **theme:** handle ckeditor text classes ([53b7351](https://github.com/p3ol/oak/commit/53b7351a2eadf695338581d9260d957da88cf8f8))





## [3.0.9](https://github.com/p3ol/oak/compare/v3.0.8...v3.0.9) (2023-06-07)


### Bug Fixes

* allow to install package on node 20 ([811ec5c](https://github.com/p3ol/oak/commit/811ec5c314d76d45c21dc9c75f3ef1c45600552c))
* **deps:** update dependency @floating-ui/react to v0.24.2 ([b56899c](https://github.com/p3ol/oak/commit/b56899c7bec8334c922d924154a8a8a24dc4adf3))
* **deps:** update dependency @remirror/pm to v2.0.6 ([ea4dddc](https://github.com/p3ol/oak/commit/ea4dddca08f9825625e7711320c35d3cae89ad7b))
* **deps:** update dependency @strapi/design-system to v1.7.10 ([c690eea](https://github.com/p3ol/oak/commit/c690eea75fc7093e40d96120a176304cc10b8e68))
* **deps:** update dependency @strapi/design-system to v1.7.7 ([3c06f9a](https://github.com/p3ol/oak/commit/3c06f9a00af4a5317b6829bc7bed537687d8a1a1))
* **deps:** update dependency @strapi/design-system to v1.8.0 ([af0e495](https://github.com/p3ol/oak/commit/af0e4959444c994d281fe784a49844d61ffddaae))
* **deps:** update dependency remirror to v2.0.32 ([9c32216](https://github.com/p3ol/oak/commit/9c322165216ea034fbc9d84963c164f8b6bfd9d1))
* **deps:** update dependency styled-components to v5.3.11 ([63d19c6](https://github.com/p3ol/oak/commit/63d19c6cad6c3623c32eee2d61b373735e77e535))
* update junipero ([50173d1](https://github.com/p3ol/oak/commit/50173d1002e54e6bd4e67a32a3a067dfd90c3496))





## [3.0.8](https://github.com/p3ol/oak/compare/v3.0.7...v3.0.8) (2023-05-19)


### Bug Fixes

* **theme:** correctly handle non floaty basis values ([11961b5](https://github.com/p3ol/oak/commit/11961b526625ba67e012e5f4ed10978d1d636b7d))





## [3.0.7](https://github.com/p3ol/oak/compare/v3.0.6...v3.0.7) (2023-05-19)


### Bug Fixes

* **react:** add col size info ([c37c8d7](https://github.com/p3ol/oak/commit/c37c8d771c108d8cda7181261194dfa60bf59c18))
* **react:** add row background info ([a66b810](https://github.com/p3ol/oak/commit/a66b8105a54b6b4950368944c393cf31afc63a1d))
* **theme:** fix flex basis gap ([a8dfcb6](https://github.com/p3ol/oak/commit/a8dfcb6ed795bea5e4f9283073d8b1f8d35bfafb))
* **theme:** fix missing tailwind base vars ([f578fb3](https://github.com/p3ol/oak/commit/f578fb30359bbd479cd15da4e0e6c2348df839dc))





## [3.0.6](https://github.com/p3ol/oak/compare/v3.0.5...v3.0.6) (2023-05-19)


### Bug Fixes

* **deps:** update dependency @strapi/design-system to v1.7.6 ([8a610b2](https://github.com/p3ol/oak/commit/8a610b257c2da14d51bdd33edd4c9bb7bb077c95))
* **react:** export junipero's useTimeout ([daef598](https://github.com/p3ol/oak/commit/daef5984b5e6d5d1689f6fbadbf4bbf04d46dd6b))
* **strapi-plugin:** simulate loading to trigger a needed rerender ([7ef9a96](https://github.com/p3ol/oak/commit/7ef9a9637ed3d831c1d721ff13899c8afa5e4265))





## [3.0.5](https://github.com/p3ol/oak/compare/v3.0.4...v3.0.5) (2023-05-18)


### Bug Fixes

* **strapi-plugin:** media library modal zindex ([14e619e](https://github.com/p3ol/oak/commit/14e619ebc9f1d2a6b244ae4d58ed5a0dfc3c0249))
* **theme:** image field preview size ([8aa9021](https://github.com/p3ol/oak/commit/8aa90219e11671e3a98cc11dce65448c0a8d51af))





## [3.0.4](https://github.com/p3ol/oak/compare/v3.0.3...v3.0.4) (2023-05-18)


### Bug Fixes

* **strapi-plugin:** switch styles for editor ([fcc5704](https://github.com/p3ol/oak/commit/fcc57046d13c6acce0464ef6c3a67dac11ce4438))
* wrong col responsive options ([c2aea91](https://github.com/p3ol/oak/commit/c2aea91d62aacae73d04d152c448c8d482526125))





## [3.0.3](https://github.com/p3ol/oak/compare/v3.0.2...v3.0.3) (2023-05-17)


### Bug Fixes

* **ckeditor5-build-custom:** react 17 & 18 compat ([174b850](https://github.com/p3ol/oak/commit/174b850a7760cff52dc23dbe5e285b2e84c5545c))
* **strapi-plugin:** missing ckeditor styling ([ad3a360](https://github.com/p3ol/oak/commit/ad3a360028337e0af683f159e3d72b3d66f5e33f))





## [3.0.2](https://github.com/p3ol/oak/compare/v3.0.1...v3.0.2) (2023-05-16)


### Bug Fixes

* **react:** correctly paste content before builder ([7dab078](https://github.com/p3ol/oak/commit/7dab078b40d4198b8141d054d7092c4d3e7d27bb))





## [3.0.1](https://github.com/p3ol/oak/compare/v3.0.0...v3.0.1) (2023-05-16)


### Bug Fixes

* **core:** other group doesn't have any name ([bef3fd0](https://github.com/p3ol/oak/commit/bef3fd0d254d08e83b49c18b5fdf2b2715ce74ae))
* **react:** add missing catalogue animation ([9056d6a](https://github.com/p3ol/oak/commit/9056d6a6c0e76ee451401c449465671383cbe145))
* **react:** fix editable overflowing on cols ([5d0620b](https://github.com/p3ol/oak/commit/5d0620b50dabaecf17a0ffeab97f39145b233e70))
* **react:** only display groups with components ([a4380d9](https://github.com/p3ol/oak/commit/a4380d9c6a9a4ef34ba6075a812ce84b0753d24b))





# [3.0.0](https://github.com/p3ol/oak/compare/v3.0.0-alpha.40...v3.0.0) (2023-05-15)


### Bug Fixes

* dedup dependencies ([0601a6d](https://github.com/p3ol/oak/commit/0601a6d9a41930f6fc49f47d7352a7ed3a45929e))
* **deps:** update dependency @junipero/core to v3.0.0-experimental-transitions.3 ([5d6c14e](https://github.com/p3ol/oak/commit/5d6c14e544e7269095bf7fc06102f86843db5e61))
* **deps:** update dependency @junipero/react to v3.0.0 ([a21f98c](https://github.com/p3ol/oak/commit/a21f98c53faf3befefff39faef403b8b8a37b6bb))
* **deps:** update dependency styled-components to v5.3.10 ([1e84339](https://github.com/p3ol/oak/commit/1e84339d0de1d76cc8e7d37c9c372e0c0f948d76))
* **react:** allow to paste multiple elements inside containers ([7efe183](https://github.com/p3ol/oak/commit/7efe183ad1cf57e8e1922110020591629294b727))
* **theme:** fix tabs content padding overflowing dropdown menus ([70e6666](https://github.com/p3ol/oak/commit/70e6666651b10aeb0d5479a539b99e1748899cfb))
* update floating ui ([7c1f08f](https://github.com/p3ol/oak/commit/7c1f08f91c14a6377c8d0a4d8fb9668f6a5fe57e))
* update junipero to major ([8515b9f](https://github.com/p3ol/oak/commit/8515b9f397ab1572fc38ae62c607d87458e68c32))
* upgrade various dependencies ([b70b8bf](https://github.com/p3ol/oak/commit/b70b8bfb968147fe8021c2075d9e5f1a9b54242e))



## [2.0.1](https://github.com/p3ol/oak/compare/v2.0.0...v2.0.1) (2023-04-21)



# [2.0.0](https://github.com/p3ol/oak/compare/v3.0.0-alpha.29...v2.0.0) (2023-04-21)


### Bug Fixes

* update various deps ([2fb85c7](https://github.com/p3ol/oak/commit/2fb85c7d50106b57c4eab32baeca4279f4084c98))



# [2.0.0-alpha.11](https://github.com/p3ol/oak/compare/v2.0.0-alpha.10...v2.0.0-alpha.11) (2023-03-17)





# [](https://github.com/p3ol/oak/compare/v1.4.0...v) (2022-11-15)



# [1.4.0](https://github.com/p3ol/oak/compare/v1.3.1...v1.4.0) (2022-11-15)


### Bug Fixes

* **deps:** update babel monorepo ([6e2be28](https://github.com/p3ol/oak/commit/6e2be28a1280c9d62e4444d7ae0cd7819879decd))
* **deps:** update dependency core-js to v3.25.4 ([4d8bac5](https://github.com/p3ol/oak/commit/4d8bac51d9c471f708cefe0f9a56e5c5621243e7))
* **deps:** update dependency core-js to v3.25.5 ([8cd9131](https://github.com/p3ol/oak/commit/8cd9131291aebd2a7b244af9039750d8e5a5316b))
* **deps:** update dependency core-js to v3.26.0 ([32d5a35](https://github.com/p3ol/oak/commit/32d5a35677f9d771a5d85199769a13ad074606b9))
* **deps:** update dependency core-js to v3.26.1 ([eef192e](https://github.com/p3ol/oak/commit/eef192e9a46fe6c014ee930bb28ad7e5c46dbfc8))
* **deps:** update dependency preact to v10.11.1 ([6419d8c](https://github.com/p3ol/oak/commit/6419d8c479b8644f08a54a9a0656ee3a432c4f37))
* **deps:** update dependency preact to v10.11.2 ([55ac082](https://github.com/p3ol/oak/commit/55ac0821ec71365606d863eb5f47cc645b295b97))
* **deps:** update dependency preact to v10.11.3 ([98ba670](https://github.com/p3ol/oak/commit/98ba670973cd441efc7dadf81237c85310828919))
* **deps:** update dependency prosemirror-model to v1.18.2 ([e19753f](https://github.com/p3ol/oak/commit/e19753f2c614ee39df1a3930aba01411008c2fd1))
* **deps:** update dependency prosemirror-state to v1.4.2 ([a97c740](https://github.com/p3ol/oak/commit/a97c74029869e59a960e523b7861ddf1fc9fcd1e))
* **deps:** update dependency prosemirror-view to v1.28.3 ([94b67ef](https://github.com/p3ol/oak/commit/94b67eff1c237e8e5854843dd09fe5c3b71a4570))
* **deps:** update dependency prosemirror-view to v1.29.0 ([c4b5139](https://github.com/p3ol/oak/commit/c4b5139ace197196ecedd4afbeb0557e85d2838f))
* **deps:** update dependency prosemirror-view to v1.29.1 ([6c1c9ad](https://github.com/p3ol/oak/commit/6c1c9add6a3da8395bc82ca538dc91d473f0cf82))
* **deps:** update dependency slate to v0.84.0 ([4d86954](https://github.com/p3ol/oak/commit/4d86954062223d7d8ef9556d02ac456b1c9aee38))
* **deps:** update dependency slate to v0.85.0 ([ec181b8](https://github.com/p3ol/oak/commit/ec181b88cb2c37365363cd7d5d9fbad84f564c6b))
* **deps:** update dependency slate-history to v0.85.0 ([c10aa26](https://github.com/p3ol/oak/commit/c10aa26b298e72d58c1ae938d974f36195848099))
* **deps:** update dependency slate-react to v0.83.1 ([ed9cc5f](https://github.com/p3ol/oak/commit/ed9cc5f3a766b2253e637faa7a61b990d13dc0bc))
* **deps:** update dependency slate-react to v0.83.2 ([4f845e9](https://github.com/p3ol/oak/commit/4f845e9c2232d870d13d43168b19b2403376e6af))
* **deps:** update poool junipero monorepo ([b8546c0](https://github.com/p3ol/oak/commit/b8546c0d348a8b847e4995efe17649e27fb40cd3))
* **oak:** editable image field width ([ee209e3](https://github.com/p3ol/oak/commit/ee209e33fff016e2f6efd9dd8cc55533f4c901c3))
* **translations:** repair FR translation for the foldable see more position ([e5e1137](https://github.com/p3ol/oak/commit/e5e1137c78ee4e180b3965de1ed8942361d01151))



## [1.3.1](https://github.com/p3ol/oak/compare/v1.3.0...v1.3.1) (2022-09-29)


### Bug Fixes

* **deps:** update dependency core-js to v3.25.3 ([0f2b5b4](https://github.com/p3ol/oak/commit/0f2b5b4c905c46d85986737f43f521a1b703f520))
* **deps:** update dependency prosemirror-view to v1.28.1 ([668a97e](https://github.com/p3ol/oak/commit/668a97eb9f1d5bea89dfb6ae62df0f9fb6e84f39))
* **deps:** update dependency prosemirror-view to v1.28.2 ([6d7fbcd](https://github.com/p3ol/oak/commit/6d7fbcd23455190c2d30368ee4a940bec1525c16))
* **oak-react:** add a setOptions method to update options ([629e4b1](https://github.com/p3ol/oak/commit/629e4b1e3a5776701df7755cbb49a025bb9e2a82))
* **oak-react:** fix typo problem ([f6f294a](https://github.com/p3ol/oak/commit/f6f294ac760b28c78789ebc8d8664dbae2dbe3e4))



# [1.3.0](https://github.com/p3ol/oak/compare/v1.2.4...v1.3.0) (2022-09-21)


### Bug Fixes

* **deps:** update dependency core-js to v3.25.2 ([8702363](https://github.com/p3ol/oak/commit/870236329053b11c1e953a9d5431551359533572))
* **deps:** update dependency preact to v10.11.0 ([07c505e](https://github.com/p3ol/oak/commit/07c505e6632faa0572bc44fa0a0efbe8e4154ace))
* **deps:** update dependency prosemirror-commands to v1.3.1 ([2f1293f](https://github.com/p3ol/oak/commit/2f1293fcca860e7d95fb7964a3373f0f0abfa6d9))
* **deps:** update dependency prosemirror-view to v1.28.0 ([f8307ef](https://github.com/p3ol/oak/commit/f8307ef4124b7419846538364516ebcf56a33db8))
* **deps:** update dependency slate-react to v0.82.2 ([9e9a9a3](https://github.com/p3ol/oak/commit/9e9a9a37b0e0b8c19ca1c0f1dec08c4eacb7dacf))
* **deps:** update dependency slate-react to v0.83.0 ([6e5f40c](https://github.com/p3ol/oak/commit/6e5f40cff0d468887a455b2aa110e9306a45b8a0))
* fuck everything up after, as always ([6604b80](https://github.com/p3ol/oak/commit/6604b801cee9cb497bbdf6b5596a01ef226c9171))
* **oak-core:** repair getComponent function ([1b7c00e](https://github.com/p3ol/oak/commit/1b7c00ee92ae7c1186967907d6c019dfab3ae059))


### Features

* **foldable:** add translations and add Foldable options ([322aad6](https://github.com/p3ol/oak/commit/322aad694cb4b0f53c0941771b368032e6cf6c73))
* **foldable:** add unit tests and hide remove cross on col when its the last one ([c93cca8](https://github.com/p3ol/oak/commit/c93cca801382ff6e65584e49d1affe5996f5916a))
* **foldable:** centerize default seeMore and seeLess text content ([875d424](https://github.com/p3ol/oak/commit/875d424433900f2f94029ff87511cc7aaad10465))
* **foldable:** learn how to translate foldable into french ([2a7486a](https://github.com/p3ol/oak/commit/2a7486aedaa9e316782417bdf8fb56ea1bf482d9))
* **foldable:** put seeMorePosition on top of Foldable settings ([39ae575](https://github.com/p3ol/oak/commit/39ae57587d85201b4a8f0e1b0c716562e8c7c6d6))
* **foldable:** regenerate font with correct icomoon json ([64b4463](https://github.com/p3ol/oak/commit/64b44639bf116dca47dba4e39559b914dcbfff55))
* **foldable:** regenerate icons json ([075f79a](https://github.com/p3ol/oak/commit/075f79af88ca459f3e6dec4416dbcaf422f10b0e))
* **foldable:** remove duplicated and useless style ([b158cbb](https://github.com/p3ol/oak/commit/b158cbb113d616f2777a7472ef586517698e4d64))
* **foldable:** remove gutters option ([874c626](https://github.com/p3ol/oak/commit/874c626e40d251df10f28381301b7044781bb3e8))
* **foldable:** remove useless options on foldable component settings ([4c0a172](https://github.com/p3ol/oak/commit/4c0a17251ab85a6c35646062f42ee6afd1a7eb1e))
* **foldable:** repair some little bugs ([db2dd6a](https://github.com/p3ol/oak/commit/db2dd6a58c24b18a5a0a31b9956df7f37f2e7e30))
* **foldable:** repair style on catalog icon ([4aeeda5](https://github.com/p3ol/oak/commit/4aeeda594a004410ea0bbd2e4eb160ccb6b3a1af))
* **foldable:** rework all the behavior of the see more component ([792089d](https://github.com/p3ol/oak/commit/792089dfb091030d6cd45007bfa5411529cbd36b))
* **foldable:** set after as default value for seeMorePosition field ([542a7d2](https://github.com/p3ol/oak/commit/542a7d273d6b981f94beb486e1673bedc9e696a0))
* **foldable:** set foldable at the bottom of the core components on catalogue: where it should be ([8f6de6c](https://github.com/p3ol/oak/commit/8f6de6c9c7b45c8ecde8dff1f092dc7b6a5e746e))
* **foldable:** translate section title and restyle itÃ ([1c08884](https://github.com/p3ol/oak/commit/1c08884cad105c9d2d86e2ccd823aa37e0e4b0d8))
* **oak-ciore:** add buttons to add elements when element list is not empty on foldable sections ([cbf2341](https://github.com/p3ol/oak/commit/cbf23415398d063e8636c216fa95efdf1e171bf7))
* **oak-core:** add unfold icon to oak-icons ([7b11794](https://github.com/p3ol/oak/commit/7b11794e2e487ac43c4060b2c569b981a7926192))
* **oak-core:** lint files ([fbe86ae](https://github.com/p3ol/oak/commit/fbe86ae5f197dab8ae5363d491a726b84fa4bb7d))
* **oak-core:** remove useless code and add foldable empty to seeMore and seeless sectiosn ([81d1d4f](https://github.com/p3ol/oak/commit/81d1d4f4fefb21f5a67e56b279747d71d111cac0))
* **oak-core:** repair some lint and add translations ([3ce9cc9](https://github.com/p3ol/oak/commit/3ce9cc984c45cdf05d10b5c60e4a83f43eff9391))
* **oak-core:** reverts all the stuff made when foldable used row ([3ac2351](https://github.com/p3ol/oak/commit/3ac23519755b09ea1e8f57f5d414274ca6086a4f))
* **oak-core:** rework foldable component again, to not use rows anymore ([51e5ffb](https://github.com/p3ol/oak/commit/51e5ffb603af36c6ea0c98f918ce4cd75134b36d))
* **oak-core:** use seeMorePosition instead of seeMorePlacement ([3d5dbf3](https://github.com/p3ol/oak/commit/3d5dbf313bcd12076ed39ca746d3057259de23c7))
* **oak:** add seeMore and seeLess sections to all the recursives functions ([37bd9de](https://github.com/p3ol/oak/commit/37bd9de7c9b2e1565e270e2d1b613a87a65949f1))
* **oak:** wip add seeMore component ([dd8c137](https://github.com/p3ol/oak/commit/dd8c137b54bf9a2a29c04f9970362b31918c53f7))



## [1.2.4](https://github.com/p3ol/oak/compare/v1.2.3...v1.2.4) (2022-09-14)


### Bug Fixes

* **lib:** prevent infinite renders due to options being real props ([8769abc](https://github.com/p3ol/oak/commit/8769abc2207ffd129e2aded2638777a48e1d16ed))



## [1.2.3](https://github.com/p3ol/oak/compare/v1.2.2...v1.2.3) (2022-09-09)


### Bug Fixes

* **deps:** update dependency core-js to v3.25.1 ([cdfb2f6](https://github.com/p3ol/oak/commit/cdfb2f6d032978ffdde46f38bf0f9f4410bb4cdb))
* **react:** avoid interfering with react diffing algo ([9974014](https://github.com/p3ol/oak/commit/9974014c912fda7abbfdd6376ff65f645f2b409d))



## [1.2.2](https://github.com/p3ol/oak/compare/v1.2.1...v1.2.2) (2022-09-07)


### Bug Fixes

* **lib:** fix components still existing between renders ([b2a66f2](https://github.com/p3ol/oak/commit/b2a66f2f0db0b530a1983fe647483521495d4f94))



## [1.2.1](https://github.com/p3ol/oak/compare/v1.2.0...v1.2.1) (2022-09-07)


### Bug Fixes

* **deps:** update dependency uuid to v9 ([7b4d98c](https://github.com/p3ol/oak/commit/7b4d98c5114a7511eff139d82c8be52019b5c024))
* **lib:** correctly handle non-ready sub react library ([f8a7f26](https://github.com/p3ol/oak/commit/f8a7f2685be881930045a5be6cc8c271aefb56c7))
* **react:** remove unneeded ref override ([befd29d](https://github.com/p3ol/oak/commit/befd29de281fd19e1f1c933c4ae01ae4d8ab07cd))



# [1.2.0](https://github.com/p3ol/oak/compare/v1.1.2...v1.2.0) (2022-08-30)


### Bug Fixes

* **deps:** update dependency @popperjs/core to v2.11.6 ([12d3bdd](https://github.com/p3ol/oak/commit/12d3bddea058cd948e7f8141cde10aec3512ccf6))
* **deps:** update dependency core-js to v3.24.0 ([078213a](https://github.com/p3ol/oak/commit/078213a698cda9bce201e870dd239807ba71ec13))
* **deps:** update dependency core-js to v3.24.1 ([168e4ce](https://github.com/p3ol/oak/commit/168e4ce17bd1d9b23021e11bdd4d28deba48e74b))
* **deps:** update dependency core-js to v3.25.0 ([cd12e0a](https://github.com/p3ol/oak/commit/cd12e0aa30f2b55efe8ea05ed7139ca480cb16fc))
* **deps:** update dependency preact to v10.10.1 ([4a7d8f7](https://github.com/p3ol/oak/commit/4a7d8f7d95ffb69cdb117a5ffcec2c94e11c61a3))
* **deps:** update dependency preact to v10.10.2 ([cee6f79](https://github.com/p3ol/oak/commit/cee6f79b6aee342cd6d1abd60325857625a6f2bd))
* **deps:** update dependency preact to v10.10.3 ([1adf033](https://github.com/p3ol/oak/commit/1adf033b055940dbd2a566729860f121f2afe22f))
* **deps:** update dependency preact to v10.10.4 ([07244ee](https://github.com/p3ol/oak/commit/07244ee1598444629cc5f00fd587e778330edd96))
* **deps:** update dependency preact to v10.10.5 ([a8b3149](https://github.com/p3ol/oak/commit/a8b314975cc03b01d8e74777168188ca84f5c931))
* **deps:** update dependency preact to v10.10.6 ([404774c](https://github.com/p3ol/oak/commit/404774ce573a727510f0871521737f62af329ed4))
* **deps:** update dependency prosemirror-view to v1.27.1 ([88136a9](https://github.com/p3ol/oak/commit/88136a95fa8c5860c5ca7e35006f345f4e9af5eb))
* **deps:** update dependency prosemirror-view to v1.27.2 ([49af1af](https://github.com/p3ol/oak/commit/49af1af08de7126feaba72f9487343da1de251cf))
* **deps:** update dependency slate to v0.82.0 ([7dce27e](https://github.com/p3ol/oak/commit/7dce27ed2cd819727bf6f83ad51b933cf15c294e))
* **deps:** update dependency slate to v0.82.1 ([fb78127](https://github.com/p3ol/oak/commit/fb78127db3ec2e447f1203514b6060419a5c059e))
* **deps:** update dependency slate-react to v0.82.0 ([26ae6b6](https://github.com/p3ol/oak/commit/26ae6b6ebd6dbd75c773b0f142837af1e1e9ae48))
* **deps:** update dependency slate-react to v0.82.1 ([c19dd68](https://github.com/p3ol/oak/commit/c19dd68e943e576f16b30acdcd65a92ab840e773))
* **oak-react:** remove useless comment section ([e09221b](https://github.com/p3ol/oak/commit/e09221b8faa0589be6cfd248923b17016c5e79b0))
* **oak-react:** remove useless export and delete options dependancy on useEffect ([8bbaea3](https://github.com/p3ol/oak/commit/8bbaea3b82faf319923b0f33cd98732f8c72d715))
* **oak-react:** stop using Builder from oak and set up a useEffect with render function ([82cb25e](https://github.com/p3ol/oak/commit/82cb25ef2524a672028b572222f4f133f7895319))
* remove useless 'use-prosemirror' dependency ([25275ac](https://github.com/p3ol/oak/commit/25275acbc34098b6d43014ef85a5b9a6e8c562cc))
* **renovate:** disallow renovate from auto-closing prosemirror dependencies ([51cf0ed](https://github.com/p3ol/oak/commit/51cf0ed9f97efb6193a57724ee5cd0db37fe43b8))
* **renovate:** use ^ pattern matcher instead of * ([e0dc3ab](https://github.com/p3ol/oak/commit/e0dc3ab03c724c0f9b915a67cfbb3bd15925fc98))


### Features

* **oak:** lint oak-react/index ([b035c5a](https://github.com/p3ol/oak/commit/b035c5a2175b09922e6aca41018e2b4384aa2e91))



## [1.1.2](https://github.com/p3ol/oak/compare/v1.1.1...v1.1.2) (2022-07-21)


### Bug Fixes

* **addon-richtext-field-prosemirror:** fix editor using new useProseMirror ([da15099](https://github.com/p3ol/oak/commit/da15099f4333ffccd1dcebade97477eccea4b61c))
* **addon-richtext-field-prosemirror:** fix hard breaks ([553e0d7](https://github.com/p3ol/oak/commit/553e0d79f7f81187c5c6ae0c88145d81b026fe3b))
* **addon-richtext-field-prosemirror:** internalize useProseMirror ([d793b2a](https://github.com/p3ol/oak/commit/d793b2a5aa06c11df4754914b15a7c9b781bc0d8))
* **deps:** update dependency core-js to v3.23.4 ([7ebbdba](https://github.com/p3ol/oak/commit/7ebbdbab0a1f00edad24f3c9cb39832e6c3cc1ac))
* **deps:** update dependency core-js to v3.23.5 ([6f5b38b](https://github.com/p3ol/oak/commit/6f5b38bf865fea301b22a403f50ac63e04c78998))
* **deps:** update dependency preact to v10.10.0 ([c3b9dd9](https://github.com/p3ol/oak/commit/c3b9dd9268920118fde10575c6e39a231e0f78b4))
* **deps:** update dependency preact to v10.9.0 ([5f8a390](https://github.com/p3ol/oak/commit/5f8a3900100b82000af32b306782a09d53fc9526))
* **deps:** update dependency prosemirror-view to v1.26.4 ([276c802](https://github.com/p3ol/oak/commit/276c80291c7ef1a3522857f1dd9ffe6cc0efa05c))
* **deps:** update dependency prosemirror-view to v1.26.5 ([10bff93](https://github.com/p3ol/oak/commit/10bff936ff42936187cbf5d7850864015680a875))
* **deps:** update dependency prosemirror-view to v1.27.0 ([fe16008](https://github.com/p3ol/oak/commit/fe16008555b85561355ec57c97f6e53153646ab8))



## [1.1.1](https://github.com/p3ol/oak/compare/v1.1.0...v1.1.1) (2022-07-02)


### Bug Fixes

* **oak:** onbeforedragstart typo ([6fe3da3](https://github.com/p3ol/oak/commit/6fe3da3af3ef7f364cbc011647fa41961dc96068))



# [1.1.0](https://github.com/p3ol/oak/compare/v1.0.2...v1.1.0) (2022-07-02)


### Bug Fixes

* **deps:** update dependency prosemirror-view to v1.26.3 ([5d8ea1d](https://github.com/p3ol/oak/commit/5d8ea1d59cbc97bace02d9902288c1fa12e91d36))
* fix wrong row drag image ([2372431](https://github.com/p3ol/oak/commit/237243182e3cbad48c183c2f1cdf8b69cb09c904))
* **oak:** add missing clipboard inside col content ([309dd72](https://github.com/p3ol/oak/commit/309dd72438e9b5cc95c30b0b754d66e114cf6b58))


### Features

* add tooltips to various options ([322aed2](https://github.com/p3ol/oak/commit/322aed2b8c873920a301da169d4be17a3c12afe2))
* **oak:** add copy & paste actions ([a3af777](https://github.com/p3ol/oak/commit/a3af7775eafaf7dd0e5ce70cce0db529afc5ef35))
* **oak:** add new paste icon ([2eaece2](https://github.com/p3ol/oak/commit/2eaece2309ae648e62311df42893e6ef40c7a571))



## [1.0.2](https://github.com/p3ol/oak/compare/v1.0.1...v1.0.2) (2022-06-29)


### Bug Fixes

* **deps:** update dependency @popperjs/core to v2.11.5 ([ffc3a15](https://github.com/p3ol/oak/commit/ffc3a15c85fa32d7bb821ef0644e1a541d3b59d6))
* **deps:** update dependency core-js to v3.22.1 ([b6eeb39](https://github.com/p3ol/oak/commit/b6eeb39923dd59752d11b76597c15a5e1775c3e0))
* **deps:** update dependency core-js to v3.22.2 ([f999a67](https://github.com/p3ol/oak/commit/f999a672e55f21ed6d0a611e383f3f5f9ee6e111))
* **deps:** update dependency core-js to v3.22.4 ([635fa05](https://github.com/p3ol/oak/commit/635fa05572afbab4e99ac184c435ebc44b90b86d))
* **deps:** update dependency core-js to v3.22.5 ([a808b1d](https://github.com/p3ol/oak/commit/a808b1d31b98ac99796b7f34626bb4b718e7a58c))
* **deps:** update dependency core-js to v3.22.7 ([5b967a9](https://github.com/p3ol/oak/commit/5b967a90e25c009075943365aea0d5ccb3dbef7a))
* **deps:** update dependency core-js to v3.22.8 ([575a4cb](https://github.com/p3ol/oak/commit/575a4cb546be725162844687fca1673f47be1ebf))
* **deps:** update dependency core-js to v3.23.1 ([e12b3ce](https://github.com/p3ol/oak/commit/e12b3ce514c0e5c1f0002326951d853d893b3d36))
* **deps:** update dependency core-js to v3.23.2 ([29fa97b](https://github.com/p3ol/oak/commit/29fa97b218fe39be67b7bccea21f9640d325c81b))
* **deps:** update dependency core-js to v3.23.3 ([ce5e45f](https://github.com/p3ol/oak/commit/ce5e45f79dd5e9d8221fa73155ae76e410d4763c))
* **deps:** update dependency preact to v10.7.0 ([3307cc5](https://github.com/p3ol/oak/commit/3307cc52372761b115dcd52c9b75ce8330db4a1d))
* **deps:** update dependency preact to v10.7.1 ([1130858](https://github.com/p3ol/oak/commit/1130858a35272ad004f7ac58477629f2f8a02c44))
* **deps:** update dependency preact to v10.7.2 ([cba3f0c](https://github.com/p3ol/oak/commit/cba3f0cddac048a12a3ccf6e34b8a35a88acb80d))
* **deps:** update dependency preact to v10.7.3 ([020d829](https://github.com/p3ol/oak/commit/020d8294aae11a940445dd1391610725203c3bec))
* **deps:** update dependency preact to v10.8.2 ([30dfd8f](https://github.com/p3ol/oak/commit/30dfd8fbafad9fabf74824be3553aa8ac1854be7))
* **deps:** update dependency prosemirror-commands to v1.2.2 ([5b7bf7a](https://github.com/p3ol/oak/commit/5b7bf7a44619ee39c11a6f85e03ab635cb75179b))
* **deps:** update dependency prosemirror-commands to v1.3.0 ([8652166](https://github.com/p3ol/oak/commit/8652166d441d2b3e40f369c86153e0b974b89ed5))
* **deps:** update dependency prosemirror-keymap to v1.2.0 ([579fd6d](https://github.com/p3ol/oak/commit/579fd6dea8d578dd68f180f6d1fba5188cd3b040))
* **deps:** update dependency prosemirror-model to v1.17.0 ([62c7085](https://github.com/p3ol/oak/commit/62c7085f240dda45af3e7f148dbd746855f1638b))
* **deps:** update dependency prosemirror-model to v1.18.0 ([9d427d5](https://github.com/p3ol/oak/commit/9d427d5587e8f46ff1585fb753e504d8e0616b18))
* **deps:** update dependency prosemirror-model to v1.18.1 ([a905d3f](https://github.com/p3ol/oak/commit/a905d3fb35e383171b16ae917c07b6c930af62a2))
* **deps:** update dependency prosemirror-schema-basic to v1.2.0 ([af7626b](https://github.com/p3ol/oak/commit/af7626bb052f5741fe52174f2c1eeea93541a6c6))
* **deps:** update dependency prosemirror-state to v1.4.0 ([9d81cdd](https://github.com/p3ol/oak/commit/9d81cdd7243e02d27f4f63e58fe5531ddf42bdcc))
* **deps:** update dependency prosemirror-state to v1.4.1 ([328030b](https://github.com/p3ol/oak/commit/328030bd33405296d633edbf3ccac59541150847))
* **deps:** update dependency prosemirror-view to v1.23.10 ([f83d759](https://github.com/p3ol/oak/commit/f83d759933441af7bf65b5a062cc897b5a7864ee))
* **deps:** update dependency prosemirror-view to v1.23.11 ([08b451a](https://github.com/p3ol/oak/commit/08b451adfe2d74f50cf486636504e8d6c5c3a001))
* **deps:** update dependency prosemirror-view to v1.23.12 ([d733883](https://github.com/p3ol/oak/commit/d7338832866c714b813efc929bd9c19f7aad3e8d))
* **deps:** update dependency prosemirror-view to v1.23.13 ([a7ee26f](https://github.com/p3ol/oak/commit/a7ee26f23f53c24fe5dbfc0feeec6545e4e0c038))
* **deps:** update dependency prosemirror-view to v1.26.0 ([c312c82](https://github.com/p3ol/oak/commit/c312c820fda94693a9e309997e7898dd81a383e7))
* **deps:** update dependency prosemirror-view to v1.26.1 ([93366a2](https://github.com/p3ol/oak/commit/93366a2ade04ee91729d5df277a41d95af3fcece))
* **deps:** update dependency prosemirror-view to v1.26.2 ([017b480](https://github.com/p3ol/oak/commit/017b4800ce45455e85a3de08c04dfab34d8e69f1))
* **deps:** update dependency react-popper to v2.3.0 ([4bfea4f](https://github.com/p3ol/oak/commit/4bfea4fdf6e341ab4abff68ef2f7239b3c37f27e))
* **deps:** update dependency slate to v0.76.0 ([8721547](https://github.com/p3ol/oak/commit/87215477600a9da5d027875968e866602e0ecbc2))
* **deps:** update dependency slate to v0.76.1 ([efa4a5d](https://github.com/p3ol/oak/commit/efa4a5d4118bd16703a94513c9ef2815377f6218))
* **deps:** update dependency slate to v0.78.0 ([ad7121b](https://github.com/p3ol/oak/commit/ad7121bd3863ae2c7a356d989f5d9dd6ef1aa35d))
* **deps:** update dependency slate to v0.81.0 ([39fdaeb](https://github.com/p3ol/oak/commit/39fdaeb44a6b3a42803f041ec83e945a2a346544))
* **deps:** update dependency slate to v0.81.1 ([1c0e684](https://github.com/p3ol/oak/commit/1c0e684f609d7a8478e4252c0a21669bf40abede))
* **deps:** update dependency slate-hyperscript to v0.77.0 ([411796e](https://github.com/p3ol/oak/commit/411796e42839d647c2a17d2732b20d92935a92f1))
* **deps:** update dependency slate-react to v0.76.0 ([05dda85](https://github.com/p3ol/oak/commit/05dda854a73bae6a64b888490d2a47b83d12d3f9))
* **deps:** update dependency slate-react to v0.76.1 ([40fad6a](https://github.com/p3ol/oak/commit/40fad6a394689ae5b24884e965040c580d5b5ae3))
* **deps:** update dependency slate-react to v0.78.1 ([3bb1e08](https://github.com/p3ol/oak/commit/3bb1e08c46a12f4564009a28db39440c618bc47e))
* **deps:** update dependency slate-react to v0.80.0 ([4147f7e](https://github.com/p3ol/oak/commit/4147f7e8ec04003ff6d30a81ffb85fc075aba6c1))
* **deps:** update dependency slate-react to v0.81.0 ([6aa15b6](https://github.com/p3ol/oak/commit/6aa15b6c49b32beef716c3acb93730bb54e3e2e8))
* **deps:** update poool junipero monorepo to v2.0.0-rc.19 ([198ebba](https://github.com/p3ol/oak/commit/198ebbabf556e3f9bdcd9964a76e45ab9350f4db))
* **deps:** update poool junipero monorepo to v2.0.0-rc.21 ([996b256](https://github.com/p3ol/oak/commit/996b2562c16ec99df6582576177dddcc41cad529))
* **oak:** fix potentially non existing oakRef inside tests ([740440c](https://github.com/p3ol/oak/commit/740440c3de422e730de280181b7a3d2df0bc55c1))
* **popper-js:** add boundary to preventOverflow to prevent popper from overflowing oak ([6f4a5f8](https://github.com/p3ol/oak/commit/6f4a5f813b413cdce9ca67963514b46c20f81dbc))


### Features

* **popper:** use ref instead of document queryselector ([fc7eb80](https://github.com/p3ol/oak/commit/fc7eb80d4da1061596117d96216120d55c6c6554))
* remove ref from context useCallback dependancy array ([c5d29ad](https://github.com/p3ol/oak/commit/c5d29ad02f7af4a8c464cbcf264ecd995b7a34d0))



## [1.0.1](https://github.com/p3ol/oak/compare/v1.0.0...v1.0.1) (2022-03-16)


### Bug Fixes

* **deps:** update dependency @poool/junipero to v2.0.0-rc.18 ([08271f2](https://github.com/p3ol/oak/commit/08271f2082f1aa4f0b65e7d719a3368a05dadcd7))
* **deps:** update dependency @popperjs/core to v2.11.3 ([6f5f2fc](https://github.com/p3ol/oak/commit/6f5f2fc7a3f69c3e37bf667240e4bb81e1721e2b))
* **deps:** update dependency @popperjs/core to v2.11.4 ([88d28d9](https://github.com/p3ol/oak/commit/88d28d9a9f5a3d4ffedb4ff60b507f368972aea8))
* **deps:** update dependency prosemirror-view to v1.23.8 ([0fbc589](https://github.com/p3ol/oak/commit/0fbc589e1d0f205ab6f9b1016f2b267ccd4f77a1))
* **deps:** update dependency prosemirror-view to v1.23.9 ([f099d15](https://github.com/p3ol/oak/commit/f099d15bd27a3190bde960b362d99bbf661694e6))
* **deps:** update dependency slate to v0.75.0 ([0ac652a](https://github.com/p3ol/oak/commit/0ac652a27aad3f077c2ccb3a168e09dd00521ea6))
* **deps:** update dependency slate-react to v0.74.2 ([c3c3cf7](https://github.com/p3ol/oak/commit/c3c3cf7af4394d2fdefd34e5c66db2324368cae6))
* **deps:** update dependency slate-react to v0.75.0 ([0c8371c](https://github.com/p3ol/oak/commit/0c8371c3beecfd3539b6f2b859a0c785859ac4c9))
* disable the possibility to update content with content props after first render ([87e5ee8](https://github.com/p3ol/oak/commit/87e5ee8ee2437fb89390ba200240490e1acb3637))



# [1.0.0](https://github.com/p3ol/oak/compare/v1.0.0-rc.22...v1.0.0) (2022-03-08)


### Bug Fixes

* **deps:** update dependency @poool/junipero to v2.0.0-rc.17 ([35f8a4f](https://github.com/p3ol/oak/commit/35f8a4f1233f5764ff8fcc077d24f346f7ad4ae0))
* **deps:** update dependency slate-react to v0.74.1 ([2efc706](https://github.com/p3ol/oak/commit/2efc7061135e932a74ea89a1ff4f0d403209110f))
* **deps:** update poool junipero monorepo to v2.0.0-rc.16 ([03a22d0](https://github.com/p3ol/oak/commit/03a22d07a1c89fb968cb64892b375177e5fcc7a7))


### Features

* begin oak-react doc ([0bcda7a](https://github.com/p3ol/oak/commit/0bcda7aaa801d03eb2106eb5c5b8d80486fdc8c2))
* **docs:** add docs base ([361119f](https://github.com/p3ol/oak/commit/361119f62361e47468dafc240a4284a78c78d5fb))



# [1.0.0-rc.22](https://github.com/p3ol/oak/compare/v1.0.0-rc.21...v1.0.0-rc.22) (2022-03-04)


### Bug Fixes

* **deps:** update dependency core-js to v3.21.0 ([40049e1](https://github.com/p3ol/oak/commit/40049e183aff3e888b88567d944863190d586f0c))
* **deps:** update dependency core-js to v3.21.1 ([197b891](https://github.com/p3ol/oak/commit/197b891ad22f5c60011a616e7482315276d58c9e))
* **deps:** update dependency preact to v10.6.5 ([a2d4bd7](https://github.com/p3ol/oak/commit/a2d4bd7e06f6b5d1c3aede1a4e0272a8f8d603bf))
* **deps:** update dependency preact to v10.6.6 ([616588d](https://github.com/p3ol/oak/commit/616588da45106bdbb22682d4bcb5fbd16fc07268))
* **deps:** update dependency prosemirror-view to v1.23.7 ([f70af24](https://github.com/p3ol/oak/commit/f70af24920cde27c6c08020462d52243df63a007))
* **deps:** update dependency slate to v0.72.8 ([34b7418](https://github.com/p3ol/oak/commit/34b7418c0627e59b94fe1c4907d551b3905d1090))
* **deps:** update dependency slate to v0.73.0 ([0688063](https://github.com/p3ol/oak/commit/0688063cbf8b6a01956b3e672e33b4abcfe8d046))
* **deps:** update dependency slate to v0.73.1 ([91e856a](https://github.com/p3ol/oak/commit/91e856a3cc69aaef4895fcec8ce96f3dc804743b))
* **deps:** update dependency slate-react to v0.72.7 ([ea183b9](https://github.com/p3ol/oak/commit/ea183b9aa961d69afd6cd1a81d89fbc4756f23a6))
* **deps:** update dependency slate-react to v0.72.8 ([4e5456e](https://github.com/p3ol/oak/commit/4e5456e4df68aae84a766402fa5c9a652a9362ef))
* **deps:** update dependency slate-react to v0.72.9 ([1b40c5d](https://github.com/p3ol/oak/commit/1b40c5d42ff7164d1136ca4400f78bf012864a83))
* **deps:** update dependency slate-react to v0.73.0 ([ebbd023](https://github.com/p3ol/oak/commit/ebbd023fb254107d50a825609d6f9b3a60f84f07))
* **deps:** update dependency slate-react to v0.74.0 ([3336a73](https://github.com/p3ol/oak/commit/3336a732bdc158b5a52d52bf74303afa66184f1a))
* fix typo problems ([6813981](https://github.com/p3ol/oak/commit/68139815507eae5ce11be727b1e1868eb4115097))
* fix typo problems ([bf99090](https://github.com/p3ol/oak/commit/bf990906a541af1a6d3d97698aa066a35b50f68f))
* remove attribute target and not _target which not exists ([bc6781d](https://github.com/p3ol/oak/commit/bc6781dfacb23d8331be653214e93a70337e2c09))


### Features

* add <Button /> unit tests ([0774357](https://github.com/p3ol/oak/commit/077435757daf784d307b856372c1d398c7dd8d3b))
* add <Droppable /> unit tests ([f39c070](https://github.com/p3ol/oak/commit/f39c0708f4490d87427f797b1206fb8d24693abf))
* add <Editable /> component unit tests ([53542e2](https://github.com/p3ol/oak/commit/53542e288b17678ee4112fd0503ec5d5beccaf01))
* add <Element /> unit tests ([e0120a5](https://github.com/p3ol/oak/commit/e0120a5a9652174a05a2308597408da7dacedc83))
* add <Icon /> unit tests ([b358c24](https://github.com/p3ol/oak/commit/b358c24500c8e4a1275ae325607ba94d27a466d9))
* add <Image /> unit tests ([6d52da3](https://github.com/p3ol/oak/commit/6d52da3a94ca5a1a0cf818d6fa3977033690708b))
* add <ImageGield /> unit tests ([107db51](https://github.com/p3ol/oak/commit/107db5146996dc561ad69c216f009a4f084fb416))
* add <Option /> unit tests ([a68fb41](https://github.com/p3ol/oak/commit/a68fb4177815f75ae500d4ada19ee96c70089333))
* add <Row /> unit tests ([c7a4c10](https://github.com/p3ol/oak/commit/c7a4c10606a7193edb98559b14ec01140df3178f))
* add <Text /> unit tests ([a5f877f](https://github.com/p3ol/oak/commit/a5f877f1e9d9cb5c9b53735d7d6fa9305450495e))
* add <Text /> unit tests ([2c36de9](https://github.com/p3ol/oak/commit/2c36de9752a8e3185acd27275c2a4a4a82b84e89))
* add <Title /> unit tests ([cbd31fe](https://github.com/p3ol/oak/commit/cbd31fe483ae8336b40549c2a7e53cc041db5b8c))
* add <Toolbar /> unit tests ([ee084ea](https://github.com/p3ol/oak/commit/ee084eaa709f909c4b060d380bc0c24bdcd08837))
* add Draggable unit tests ([1164eed](https://github.com/p3ol/oak/commit/1164eed84f1440c63d8670e6f8332c750a357ff7))
* add some unit tests to Editable ([ebda063](https://github.com/p3ol/oak/commit/ebda06386eaee500657791444d2cb738225dd62c))
* add space between all tests ([c33efef](https://github.com/p3ol/oak/commit/c33efef8109da9f79f3aed8cc3cdb1b960edea1b))
* add utils unit tests ([95ed806](https://github.com/p3ol/oak/commit/95ed8062c379b410909e0cbeb38fea86fe7e7ce3))
* build project before runnings tests ([7c2b6b6](https://github.com/p3ol/oak/commit/7c2b6b66ce3916843a2b0b567c43fd6a07f51678))
* getAlignment just return alignment ([bd2b54e](https://github.com/p3ol/oak/commit/bd2b54ee87839f7926d396c9b34b495750cead40))
* set up oak addon richtext field prosemirror tests ([c6bc1bc](https://github.com/p3ol/oak/commit/c6bc1bc39cb69abe199f8ee0f34babf45c4559ae))
* set up tests for oak addon basic components package ([88ce9fc](https://github.com/p3ol/oak/commit/88ce9fc3459e16f273616cdb0ab664cfe5e142f6))
* use jest mock instead of contexts overrides as context is an import ([9baef58](https://github.com/p3ol/oak/commit/9baef58646e86a094f98cb52ed0b3ee987fb14d3))



# [1.0.0-rc.21](https://github.com/p3ol/oak/compare/v1.0.0-rc.20...v1.0.0-rc.21) (2022-01-25)


### Bug Fixes

* **deps:** update dependency prosemirror-commands to v1.2.1 ([e4e4ed2](https://github.com/p3ol/oak/commit/e4e4ed2055c7e83d94e90001be1fe4a2cc5b054c))
* **deps:** update dependency slate-react to v0.72.5 ([c8309e1](https://github.com/p3ol/oak/commit/c8309e106179d4b0aa6f20f465bc985ecc514e83))
* **deps:** update dependency slate-react to v0.72.6 ([27735fe](https://github.com/p3ol/oak/commit/27735fe0359edbf1c3c6e7a0002bbb68f93b7d19))
* **prosemirror:** change order to apply color on underline line ([aff31f6](https://github.com/p3ol/oak/commit/aff31f66e496b0d4f3ffe34f13bceb8e1f54d8a1))



# [1.0.0-rc.20](https://github.com/p3ol/oak/compare/v1.0.0-rc.19...v1.0.0-rc.20) (2022-01-18)


### Bug Fixes

* **deps:** update dependency core-js to v3.20.3 ([477af8b](https://github.com/p3ol/oak/commit/477af8b29355b3430de46cf85a8f85fa1b7b7ae3))
* **deps:** update dependency prosemirror-commands to v1.2.0 ([62fe80a](https://github.com/p3ol/oak/commit/62fe80ae532552b4b4f675d8ddb8175efd06d936))
* **deps:** update dependency prosemirror-view to v1.23.6 ([b89438b](https://github.com/p3ol/oak/commit/b89438b16a7864d6b618eadc7fa8c93cbe59101a))
* **deps:** update dependency slate-react to v0.72.4 ([a074bda](https://github.com/p3ol/oak/commit/a074bdad2ca39dc61c30ae83c37a431aee914016))
* **deps:** update dependency use-prosemirror to v1.2.3 ([4ec0a2b](https://github.com/p3ol/oak/commit/4ec0a2b525e4bb7a8b2467ad0a8ce49a4397bdb0))
* fix dependencies duplicates (mostly prosemirror) ([42eba96](https://github.com/p3ol/oak/commit/42eba9672bf784ee5bb303268454e4b7d1b6a54c))



# [1.0.0-rc.19](https://github.com/p3ol/oak/compare/v1.0.0-rc.18...v1.0.0-rc.19) (2022-01-12)


### Bug Fixes

* **lint:** remove unecessary imports ([fb4e0bb](https://github.com/p3ol/oak/commit/fb4e0bbadde49719582f1473d20e1a666dc1d459))
* **oak:** remove oak from dependencies of all packages to avoid mismatching oak versions ([ccb219c](https://github.com/p3ol/oak/commit/ccb219c971ca091086b0329ef624a974d0b93da2))


### Features

* **ci:** add CI tests jobs ([24739a5](https://github.com/p3ol/oak/commit/24739a5a1bf1d4742399f0dd5dee7e07b5b9ac0a))
* **oak:** add unit tests set up ([f83f3aa](https://github.com/p3ol/oak/commit/f83f3aa737d96f4fe210c781a7ae338badb3ce0d))
* **test:** add getOverrides method on builder context for a test ([b2fa690](https://github.com/p3ol/oak/commit/b2fa690f69f6c2a60d6cee69682d2d6b31210982))
* **tests:** add tests on Col component ([bbad3c6](https://github.com/p3ol/oak/commit/bbad3c669658645da2372fa86e600267c99ee68c))
* **tests:** add unit tests for builder component ([dc76194](https://github.com/p3ol/oak/commit/dc76194ab68fb49d278a780d3fbbcdaeea0217db))
* **tests:** begin Col component tests ([03886da](https://github.com/p3ol/oak/commit/03886da6b86fc625a9932cd835d9cbd1c67cb998))
* **tests:** delete failing test for first merge purpose ([366c241](https://github.com/p3ol/oak/commit/366c241d8959ad0e7d048792335b08d5324a12b6))
* **unit-tests:** add tests for catalog component ([0d61065](https://github.com/p3ol/oak/commit/0d61065ea71a401103e8f258e34387143bd57805))
* **wip:** add coreimagefield component ([f2acbb8](https://github.com/p3ol/oak/commit/f2acbb8c50fb27e3e9e64775b0ed447aff3d5dfa))



# [1.0.0-rc.18](https://github.com/p3ol/oak/compare/v1.0.0-rc.17...v1.0.0-rc.18) (2022-01-06)


### Bug Fixes

* **addon-richtext-field-prosemirror:** add missing color ([4bd3323](https://github.com/p3ol/oak/commit/4bd3323570808b881a5d7779447055c4b9bc5786))



# [1.0.0-rc.17](https://github.com/p3ol/oak/compare/v1.0.0-rc.16...v1.0.0-rc.17) (2022-01-06)


### Bug Fixes

* **addon-richtext-field-prosemirror:** add missing fr locale ([6e1151b](https://github.com/p3ol/oak/commit/6e1151b1f5698a0054690bd6bb622af4fb9d6a01))
* **deps:** update dependency @popperjs/core to v2.11.2 ([3f17821](https://github.com/p3ol/oak/commit/3f17821458141746f6d2da369268b22434869531))



# [1.0.0-rc.16](https://github.com/p3ol/oak/compare/v1.0.0-rc.15...v1.0.0-rc.16) (2022-01-03)


### Bug Fixes

* **deps:** update dependency @babel/runtime-corejs3 to v7.16.5 ([0692ef9](https://github.com/p3ol/oak/commit/0692ef9168cac880cae3419e3eb1f998a427737f))
* **deps:** update dependency core-js to v3.20.2 ([d2ee936](https://github.com/p3ol/oak/commit/d2ee9361fea2c0bea322db9e6daa3d448e8142f7))
* **deps:** update dependency prosemirror-model to v1.16.1 ([c01006e](https://github.com/p3ol/oak/commit/c01006e6c562ffdb70d068345751a39ef96e07ea))
* **deps:** update dependency prosemirror-view to v1.23.3 ([bcecece](https://github.com/p3ol/oak/commit/bcececec2f9d3cd3655274095516c65014c8f060))
* **deps:** update dependency prosemirror-view to v1.23.4 ([6f1420f](https://github.com/p3ol/oak/commit/6f1420feb11b914a7e4d4d6e8ae3618eafc7fcb5))
* **deps:** update dependency prosemirror-view to v1.23.5 ([f074f74](https://github.com/p3ol/oak/commit/f074f74d412d6d0f4c1f262458aa9a4313b05fe4))
* **deps:** update dependency slate to v0.72.3 ([0bf69d5](https://github.com/p3ol/oak/commit/0bf69d5231021151b8d29cf23a3461476835aed7))
* **oak:** prevent component being added to wrong group ([7177d74](https://github.com/p3ol/oak/commit/7177d743c79555b5a0a3aaafa1b56c8438a93041))


### Features

* allow displayable field options to be shown ([03f047c](https://github.com/p3ol/oak/commit/03f047c4c353914bc8f08ed2d7d186d7213386ef))



# [1.0.0-rc.15](https://github.com/p3ol/oak/compare/v1.0.0-rc.14...v1.0.0-rc.15) (2021-12-16)


### Bug Fixes

* **addon-richtext-field-prosemirror:** allow links to span around other marks ([5fd4279](https://github.com/p3ol/oak/commit/5fd4279deeff627e900a44bbcf5509c5ed734ad6))
* **addon-richtext-field-prosemirror:** apply 79acc9e ([5ea10b0](https://github.com/p3ol/oak/commit/5ea10b067489cf43d8c5e59e0ae3365e76516995))
* **addon-richtext-field-prosemirror:** fix missing italic icon ([5914ab0](https://github.com/p3ol/oak/commit/5914ab07e6df3f521cc062693bdda00c52484642))
* **addon-richtext-field-prosemirror:** force color field to be always opened ([cedc8e3](https://github.com/p3ol/oak/commit/cedc8e347b2229fa113312228cee2b3fc5b7fc5e))
* **addon-richtext-field:** make color panel to be always opened ([e25e1ae](https://github.com/p3ol/oak/commit/e25e1ae65bbcb4df13bdafaab2acb7e4dcea71e2))
* **prosemirror:** repair path to prosemirror index ([585bd4d](https://github.com/p3ol/oak/commit/585bd4d1c8be67ac50f44f5513026f07b9093bdb))
* rename umd module name ([9a20b5e](https://github.com/p3ol/oak/commit/9a20b5ee80f19dc20385a24d826b5c0d5139ba15))
* scope editor link configuration styles into editor itself ([56ff8c4](https://github.com/p3ol/oak/commit/56ff8c4979bf2bd8bdf763b12aaf1b46e8920bd1))


### Features

* **prosemirror:** add getMarkAttrs function to know which attribute is currently active ([f1309c6](https://github.com/p3ol/oak/commit/f1309c6efcca951089c0da5f539e6c8ba383fcb7))
* **prosemirror:** add size, and use span for underline ([3e6d8b5](https://github.com/p3ol/oak/commit/3e6d8b5bb09d5983d54bada12048bc5eb9cf18f5))
* **prosemirror:** add some transforms functions and move Editor to avoid hook errors ([fdd8bda](https://github.com/p3ol/oak/commit/fdd8bda87f6d4953638e190e24a76446e79b56e7))
* **prosemirror:** add stories ([eff888f](https://github.com/p3ol/oak/commit/eff888f71302e0d3c88a1acd26666183b2cc9dc5))
* **prosemirror:** add update current link ([4ce486c](https://github.com/p3ol/oak/commit/4ce486c5840639ac37f45188b3fd762f681bf25b))
* **prosemirror:** begin horizontal text alignment and make mark replacement on toggle ([9e483e2](https://github.com/p3ol/oak/commit/9e483e203da4525ce4e1d705860ff53afc4c3f81))
* **prosemirror:** continue block type work, and allow to serialize on save ([43fff42](https://github.com/p3ol/oak/commit/43fff423823de39e7c45c990e0ce520d49e619be))
* **prosemirror:** enable horizontal alignment ([a627213](https://github.com/p3ol/oak/commit/a627213395fd50d01e6fd26b4f16a9562ed7cf92))
* **prosemirror:** fix paragraphs displays ([d9cb447](https://github.com/p3ol/oak/commit/d9cb447a76ff5ade1e245d883fc8731ed8a017dd))
* **prosemirror:** handle default with link and size ([a8e76bc](https://github.com/p3ol/oak/commit/a8e76bc666658e00f9df0a0318e60779de6d83b9))
* **prosemirror:** handle multiple initialization ([bdfaec1](https://github.com/p3ol/oak/commit/bdfaec1f6587f086a76a73b27b7707d7c58a53dc))
* **prosemirror:** handle texts size ([377a053](https://github.com/p3ol/oak/commit/377a05355c0f1ad87532566e830d4e6ead1d372c))
* **prosemirror:** link finally working ([9f5873a](https://github.com/p3ol/oak/commit/9f5873a10e5768a56d9de29d07e13962b94b235b))
* **prosemirror:** lint all files, reindent, reorganize imports, ([6a9d7a4](https://github.com/p3ol/oak/commit/6a9d7a4afbc222de94ec6e0e9c712d6c178f6b76))
* **prosemirror:** lint new files ([a356c50](https://github.com/p3ol/oak/commit/a356c508b7fbe587dc2704c83d7db8b698e5a85c))
* **prosemirror:** lint, use a real variable name ([4cce16b](https://github.com/p3ol/oak/commit/4cce16b0c941befec52340555b299c4b79d59125))
* **prosemirror:** little refactor of prosemirror schema ([b30fa0d](https://github.com/p3ol/oak/commit/b30fa0ddf6b170ac3af43c4939750297551bccd6))
* **prosemirror:** make slate and prosemirror style independant from each other ([7137ed0](https://github.com/p3ol/oak/commit/7137ed0782e758a6e1606651ca5163455454bf8b))
* **prosemirror:** prevent default event on click ([6109abc](https://github.com/p3ol/oak/commit/6109abc57a58fadeec4449ea24317188356658e7))
* **prosemirror:** remove title from link attributes ([3a4bb88](https://github.com/p3ol/oak/commit/3a4bb88340ff2ff4a1fb8e5f3b537444f821dde8))
* **prosemirror:** set activeness of menu buttons ([cd31ba1](https://github.com/p3ol/oak/commit/cd31ba1b34e8d500195a48a66068508e03bbcd98))
* **prosemirror:** set prosemirror type to richtext ([08d535b](https://github.com/p3ol/oak/commit/08d535b7f9f62779f6a07deacb8cd20665e17f62))
* **prosemirror:** size's working and color button color follow selected color ([dd9f49b](https://github.com/p3ol/oak/commit/dd9f49b518b8f1b68700bcfc7dded2554daa4d11))
* **prosemirror:** use span instead of strong and em html tags ([f773745](https://github.com/p3ol/oak/commit/f773745abb67dd6d900f35d9db742884e87a3dc9))
* **prosemirror:** wip add prosemirror text editor plugin ([062204d](https://github.com/p3ol/oak/commit/062204d613db9969b56e53ced145fb5a99268cc5))
* **prosemirror:** wip first POC of size on content ([023a970](https://github.com/p3ol/oak/commit/023a970462c1646e8cbb135c5315ad4178fdeafc))



# [1.0.0-rc.14](https://github.com/p3ol/oak/compare/v1.0.0-rc.13...v1.0.0-rc.14) (2021-12-16)


### Bug Fixes

* check type of afterConstruct ([00ba00c](https://github.com/p3ol/oak/commit/00ba00cd2c79212ccf8c2eb6f64857fc294d9b30))
* **deps:** update dependency core-js to v3.20.0 ([913ce9b](https://github.com/p3ol/oak/commit/913ce9bf3c1d1ba0885169440e8b6972428a6d4d))
* **link:** add selectors to bypass junipero override and change padding into margin to avoid placeholder positioning issue ([79acc9e](https://github.com/p3ol/oak/commit/79acc9e1d36d2ef11cd3228b60f58b58a7f8fb9e))
* pass element with content to construct ([7df44d3](https://github.com/p3ol/oak/commit/7df44d32f609bc67f21cbdafd18aac4816000f01))


### Features

* **overrides:** allow override of construct on append ([a66d5d8](https://github.com/p3ol/oak/commit/a66d5d82182fb82ed301b584d38e6978e02e6e54))



# [1.0.0-rc.13](https://github.com/p3ol/oak/compare/v1.0.0-rc.12...v1.0.0-rc.13) (2021-12-14)


### Bug Fixes

* **lib:** fix non existing overrides when options change ([362dc1c](https://github.com/p3ol/oak/commit/362dc1c7e0a66e50abc6b4be72ac027902e1f7f2))



# [1.0.0-rc.12](https://github.com/p3ol/oak/compare/v1.0.0-rc.11...v1.0.0-rc.12) (2021-12-13)


### Bug Fixes

* **deps:** update dependency @popperjs/core to v2.11.0 ([00270f5](https://github.com/p3ol/oak/commit/00270f5272ca08530c6e69f1e15f80652a7828b0))
* **deps:** update dependency core-js to v3.19.0 ([e20f658](https://github.com/p3ol/oak/commit/e20f6586866e5677e1cdbe6803e2cd66a42ab4e6))
* **deps:** update dependency core-js to v3.19.1 ([f1fe2e2](https://github.com/p3ol/oak/commit/f1fe2e2873874a16e51f205493c15cfa89c76aae))
* **deps:** update dependency core-js to v3.19.3 ([b517b45](https://github.com/p3ol/oak/commit/b517b45515284a6c41ab5233c3703b5901b4aa7e))
* **deps:** update dependency preact to v10.6.2 ([ca5780c](https://github.com/p3ol/oak/commit/ca5780cc61fa12c91edba4c6579c334cf59bffa9))
* **deps:** update dependency preact to v10.6.3 ([cb5db9b](https://github.com/p3ol/oak/commit/cb5db9b17042280db7aadc5af69b116c88268ea2))
* **deps:** update dependency preact to v10.6.4 ([41a5279](https://github.com/p3ol/oak/commit/41a5279f18d94abebfa9739a9d456c27f179062e))
* **deps:** update dependency slate to v0.70.0 ([88dba43](https://github.com/p3ol/oak/commit/88dba43b6f5922c0d85831de4c5376d7737f79a1))
* **deps:** update dependency slate to v0.71.0 ([4cf65dc](https://github.com/p3ol/oak/commit/4cf65dcde927a22965a3f643994273e6c3a4e4cd))
* **deps:** update dependency slate to v0.72.0 ([4f9e562](https://github.com/p3ol/oak/commit/4f9e562f9017d09c36632507348edf2377f08e4f))
* **deps:** update dependency slate-react to v0.69.0 ([58d4959](https://github.com/p3ol/oak/commit/58d49599c71509f88d78f37ebbe975467aa26193))
* **deps:** update dependency slate-react to v0.70.0 ([e9f0781](https://github.com/p3ol/oak/commit/e9f0781176f7441d4165c43c72822388b444e2ef))
* **deps:** update dependency slate-react to v0.71.0 ([f5681aa](https://github.com/p3ol/oak/commit/f5681aa7a34316cd5cff7372cbe54a056a582b7f))
* **deps:** update dependency slate-react to v0.72.0 ([6e0eded](https://github.com/p3ol/oak/commit/6e0ededa4c886a049642df3841849ed8d5fa1d2c))
* **deps:** update dependency slate-react to v0.72.1 ([3959c7c](https://github.com/p3ol/oak/commit/3959c7cf28c88b2d14871ed87727fd1666bc129d))


### Features

* **overides:** import mergeDeep from junipero-utils ([92a07a2](https://github.com/p3ol/oak/commit/92a07a221a8193135dd1a81b540563f28e172b5f))
* **overrides:** add overrides on duplication and enable multiple overrides for a component ([d087d4d](https://github.com/p3ol/oak/commit/d087d4d68ce0db21d2458e4613ff5944d7745ff8))


### Reverts

* Revert "chore(deps): update babel monorepo to v7.16.0" ([9c8c2fa](https://github.com/p3ol/oak/commit/9c8c2fae7583eb675238258321982d10e55c9e56))



# [1.0.0-rc.11](https://github.com/p3ol/oak/compare/v1.0.0-rc.10...v1.0.0-rc.11) (2021-10-20)


### Bug Fixes

* **deps:** update dependency core-js to v3.18.3 ([4aed489](https://github.com/p3ol/oak/commit/4aed489dabc7e75efe43dc5d2d80b4de6b354c9a))
* **deps:** update dependency slate-hyperscript to v0.67.0 ([001f420](https://github.com/p3ol/oak/commit/001f4205e01d80527748f0856b2b88ba129c7067))
* **deps:** update dependency slate-react to v0.67.0 ([256ee07](https://github.com/p3ol/oak/commit/256ee07a6cd9aada89108e8c58bdc6e36b965a25))
* **deps:** update poool junipero monorepo to v2.0.0-rc.15 ([6c5a244](https://github.com/p3ol/oak/commit/6c5a24467be1136eb97d2a282092525a2e800f0d))



# [1.0.0-rc.10](https://github.com/p3ol/oak/compare/v1.0.0-rc.9...v1.0.0-rc.10) (2021-10-12)


### Bug Fixes

* **deps:** update dependency preact to v10.5.15 ([32bfe93](https://github.com/p3ol/oak/commit/32bfe937ee312e12b9639ff8f280387dd4fcb388))



# [1.0.0-rc.9](https://github.com/p3ol/oak/compare/v1.0.0-rc.8...v1.0.0-rc.9) (2021-10-12)


### Bug Fixes

* **deps:** update dependency @popperjs/core to v2.10.2 ([4be1d49](https://github.com/p3ol/oak/commit/4be1d49f3db522a6352c8a1efe0f2c5c05600df8))
* **deps:** update dependency core-js to v3.18.2 ([5becad7](https://github.com/p3ol/oak/commit/5becad75a9117a9b3fe70141a8628aa742496e27))
* **deps:** update dependency slate-react to v0.66.6 ([99b91be](https://github.com/p3ol/oak/commit/99b91beb6f69d7c25d29e157eb449102ba850377))
* **deps:** update dependency slate-react to v0.66.7 ([9fd97af](https://github.com/p3ol/oak/commit/9fd97af89753ef650920b51d22086cadf494144b))
* **image-component:** fix misspelled trad ([b5df41a](https://github.com/p3ol/oak/commit/b5df41a41c3d80c7ba6b8721880d7d1fbb3ffc2d))
* **image:** add horizontal aligment on image component ([2613dfa](https://github.com/p3ol/oak/commit/2613dfa2ededec019222306cd66129965e63017d))



# [1.0.0-rc.8](https://github.com/p3ol/oak/compare/v1.0.0-rc.7...v1.0.0-rc.8) (2021-09-29)


### Bug Fixes

* **deps:** update dependency core-js to v3.17.3 ([b71d853](https://github.com/p3ol/oak/commit/b71d853eee64f9f472a86a4c88b89830b4ac03bf))
* **deps:** update dependency slate to v0.66.0 ([65edf2a](https://github.com/p3ol/oak/commit/65edf2a3441a11db9fd5be0f6f0b168c13166e6d))
* **deps:** update dependency slate to v0.66.1 ([f95466b](https://github.com/p3ol/oak/commit/f95466bf74f299cc6ff057c4c934d87d15769f7d))
* **deps:** update dependency slate to v0.66.5 ([0590cd3](https://github.com/p3ol/oak/commit/0590cd31514bc776efe2bcec33350eae6fbac290))
* **deps:** update dependency slate-history to v0.66.0 ([20deb28](https://github.com/p3ol/oak/commit/20deb28b3a03433734da572190c5232e1b5c9e51))
* **deps:** update dependency slate-hyperscript to v0.66.0 ([9fed053](https://github.com/p3ol/oak/commit/9fed05301a3f74076f89addc8cd078d275457ea2))
* **deps:** update dependency slate-react to v0.66.1 ([98f2a60](https://github.com/p3ol/oak/commit/98f2a60131883d50cb097cdeceb8381c6e26e50f))
* **deps:** update dependency slate-react to v0.66.4 ([0484ae8](https://github.com/p3ol/oak/commit/0484ae8efc2081db7fe243adba5cf15ea5c4f4fe))
* **deps:** update poool junipero monorepo to v2.0.0-rc.14 ([71840b8](https://github.com/p3ol/oak/commit/71840b87c57bf1019541cdcf20008d449ba37383))
* **text-editor:** fix deserialize node when element tag are in text tags ([aac15aa](https://github.com/p3ol/oak/commit/aac15aa7fecc9681095ffd0e94402e0b7a4ee37c))



# [1.0.0-rc.7](https://github.com/p3ol/oak/compare/v1.0.0-rc.6...v1.0.0-rc.7) (2021-09-06)


### Bug Fixes

* **typo:** change various traductions ([4523db6](https://github.com/p3ol/oak/commit/4523db6fdf97a31454203bac3e08bf9e58d9569a))



# [1.0.0-rc.6](https://github.com/p3ol/oak/compare/v1.0.0-rc.5...v1.0.0-rc.6) (2021-09-03)


### Bug Fixes

* **deps:** update dependency @popperjs/core to v2.10.1 ([f5b3d29](https://github.com/p3ol/oak/commit/f5b3d296f9d35d2d1d706af42a74d59469c9d760))
* **deps:** update dependency core-js to v3.17.2 ([40cc27a](https://github.com/p3ol/oak/commit/40cc27a273a06f8b18e14e19850ff1c373b0b322))
* **form:** remove . which fail with babel ([48fcf38](https://github.com/p3ol/oak/commit/48fcf38ad7fb4b8ee4c7ca9fd871702b91c824f9))
* **image-field:** set default value for image field to empty string ([4fe1df9](https://github.com/p3ol/oak/commit/4fe1df953988e84e71d6c4ceff83715faaf9779d))



# [1.0.0-rc.5](https://github.com/p3ol/oak/compare/v1.0.0-rc.4...v1.0.0-rc.5) (2021-09-01)


### Bug Fixes

* **options:** remove prevent default fuckery on options, and add it just on drag and drop button ([9ba978f](https://github.com/p3ol/oak/commit/9ba978f6ec1dc2ddf5d46eaa9e6c447e0b2a5915))



# [1.0.0-rc.4](https://github.com/p3ol/oak/compare/v1.0.0-rc.3...v1.0.0-rc.4) (2021-09-01)


### Bug Fixes

* **options:** prevent redirects on custom options ([175dd9a](https://github.com/p3ol/oak/commit/175dd9a53527a53c5bae5c06c0b71005e6c3d965))



# [1.0.0-rc.3](https://github.com/p3ol/oak/compare/v1.0.0-rc.2...v1.0.0-rc.3) (2021-08-31)


### Bug Fixes

* **deps:** update dependency core-js to v3.16.4 ([999618f](https://github.com/p3ol/oak/commit/999618f6c9901220797dbd61387f6b10220bda86))
* **forms:** use passed duplicate function if it exists ([abd65a6](https://github.com/p3ol/oak/commit/abd65a641dcaa9daf28127679d4d7cd18310a9d2))



# [1.0.0-rc.2](https://github.com/p3ol/oak/compare/v1.0.0-rc.1...v1.0.0-rc.2) (2021-08-27)


### Features

* better handle links inside html content ([6251c8a](https://github.com/p3ol/oak/commit/6251c8a4001656d3ed06cf31b005db32ac721bf7))



# [1.0.0-rc.1](https://github.com/p3ol/oak/compare/v1.0.0-rc.0...v1.0.0-rc.1) (2021-08-26)


### Bug Fixes

* **addon-richtext-field:** better handle edge cases on content render ([097476d](https://github.com/p3ol/oak/commit/097476d20099967f17891716e691fb68b6b4c198))
* **lib:** also replace translated content on col prepend/append ([3864027](https://github.com/p3ol/oak/commit/3864027733537560ebff8f8959505d6c814c2e87))



# [1.0.0-rc.0](https://github.com/p3ol/oak/compare/v1.0.0-beta.15...v1.0.0-rc.0) (2021-08-26)


### Bug Fixes

* serialize/deserialize field values instead of element itself ([3d0cb17](https://github.com/p3ol/oak/commit/3d0cb178b638046400a20c838bd27ad75bd933be))
* **text-editor:** shorten current color retrieve method ([56e8614](https://github.com/p3ol/oak/commit/56e8614fe902003fad3ae2b65c37d81d5ad52c9e))
* **text-editor:** use Slate function instead of html API selection to retrieve current text properties ([1869e72](https://github.com/p3ol/oak/commit/1869e7207eeef1478a7ec9746c3040d73da841ce))



# [1.0.0-beta.15](https://github.com/p3ol/oak/compare/v1.0.0-beta.14...v1.0.0-beta.15) (2021-08-26)


### Bug Fixes

* **addon-basic-components:** fix missing checks ([26a589d](https://github.com/p3ol/oak/commit/26a589d53e042153f377f210797cdb74d873aa73))
* fix richtext serialization issues ([f7732e5](https://github.com/p3ol/oak/commit/f7732e5a9560c6cf3f78c384b22b54d98f88956d))
* **lib:** fix element construct with translated default content ([f5b5baa](https://github.com/p3ol/oak/commit/f5b5baa84b8fcd5b08f875d0d370c9f6d1b60003))
* **lib:** fix missing text issues ([07036a3](https://github.com/p3ol/oak/commit/07036a3a6db7165a93201c8534afbbd028c4d444))


### Features

* add auto sized column (based on content) ([8733062](https://github.com/p3ol/oak/commit/873306299180062ac89f8398f693720ae5b4035f))
* add link button ([3c210ee](https://github.com/p3ol/oak/commit/3c210eeae29e1e35db5e21c7c68a647dac136850))
* add stretch flex align option ([80ce49d](https://github.com/p3ol/oak/commit/80ce49da5c5270349c1c76e5bb933f81c07b2469))
* **link:** use block instead of node for link handling ([51aaa9c](https://github.com/p3ol/oak/commit/51aaa9c91e7b1fe7dfd94c8421b8a61a12037560))
* **text-editor:** add new Icon to oak font ([44175c2](https://github.com/p3ol/oak/commit/44175c28460e65ead5267c3e563bca174c2efb35))
* **text-editor:** add styling ([b35a53c](https://github.com/p3ol/oak/commit/b35a53c1697b9c6f463324836d071ad7e5b4de00))
* **text-editor:** handle french traductions for rich text field ([3cd98a8](https://github.com/p3ol/oak/commit/3cd98a8d05f789d68e1164d83f10a51aff0f9cf5))
* **text-editor:** links working ([0151684](https://github.com/p3ol/oak/commit/0151684e93492b34866fc7da652ecaa973569035))
* **text-editor:** make requested changes ([b9fc098](https://github.com/p3ol/oak/commit/b9fc098c91c870827270a7c39410cd7fa5a9c750))
* **text-editor:** moves link button right before color button ([b66511b](https://github.com/p3ol/oak/commit/b66511bb2268e550e01323adf2350f9e0dfe8497))
* **text-editor:** removes link on leaf ([d3d8b97](https://github.com/p3ol/oak/commit/d3d8b97ac5802ee56e9c6246a7827e373e259608))
* **text-editor:** removes unecessary quote ([7322439](https://github.com/p3ol/oak/commit/73224395d9beb7cfdd96064ae8500043695f4ee1))
* **text-editor:** stop using true false on targets ([aa2ade1](https://github.com/p3ol/oak/commit/aa2ade13d1ab29bebe81f090d63ce048da5dc444))



# [1.0.0-beta.14](https://github.com/p3ol/oak/compare/v1.0.0-beta.13...v1.0.0-beta.14) (2021-08-26)


### Bug Fixes

* **deps:** update dependency core-js to v3.16.3 ([e57eedb](https://github.com/p3ol/oak/commit/e57eedbf1dfd272cc1a1a0c093f05abf6ca39148))
* fix cols not being 100% wide when row is in column mode ([e7a17ca](https://github.com/p3ol/oak/commit/e7a17ca03a3e0a98240ba6ce17854f0eb60cba29))
* fix icons layout issues ([fe45b77](https://github.com/p3ol/oak/commit/fe45b772f6e2d67d87d430c80b0404aadc44e84d))


### Features

* add duplicate ability ([d7ac36c](https://github.com/p3ol/oak/commit/d7ac36cbb9a73b9431984efea6585c3b9a11ee5e))



# [1.0.0-beta.13](https://github.com/p3ol/oak/compare/v1.0.0-beta.12...v1.0.0-beta.13) (2021-08-19)


### Bug Fixes

* **deps:** update dependency @babel/runtime-corejs3 to v7.15.3 ([5b2fba0](https://github.com/p3ol/oak/commit/5b2fba054f5e19608cdd7719c01277167c0429af))
* **deps:** update dependency @poool/junipero to v2.0.0-rc.11 ([4aca020](https://github.com/p3ol/oak/commit/4aca020b1cac7528fa5eb2cdaecf8d42fc20979f))
* **deps:** update dependency @poool/junipero to v2.0.0-rc.12 ([e4ac02a](https://github.com/p3ol/oak/commit/e4ac02a93d94e225343467ac7231cd17c99cf86d))
* **deps:** update dependency @popperjs/core to v2.9.3 ([79eabef](https://github.com/p3ol/oak/commit/79eabefd7857e3fdfeb21b2075a1ebb5f6282760))
* **deps:** update dependency core-js to v3.16.1 ([e8df7d9](https://github.com/p3ol/oak/commit/e8df7d98ea7d997051cf931cf88dbe1cc80a5140))
* **deps:** update dependency core-js to v3.16.2 ([266d547](https://github.com/p3ol/oak/commit/266d5478cb1c3596a6717a53630ea70aed091e54))
* **deps:** update dependency slate to v0.65.3 ([fe3f23d](https://github.com/p3ol/oak/commit/fe3f23dd55bfa4b33a3e8894e16807c2bd5a45cf))
* **deps:** update dependency slate-history to v0.65.3 ([cd51b1c](https://github.com/p3ol/oak/commit/cd51b1ccaad69415a01a87f4c35e62ef74f8e293))
* **deps:** update dependency slate-react to v0.65.3 ([2eab600](https://github.com/p3ol/oak/commit/2eab600f29b89547785fd6be955bcc83f6554d94))
* **text-editor:** allow multiple style on element ([5d6020c](https://github.com/p3ol/oak/commit/5d6020c9c1aa3f23ab1f5cbbf0438e318360c4ae))
* **text-editor:** make requested changes ([2818bd9](https://github.com/p3ol/oak/commit/2818bd9f1f72255f3bccc54623ec154b9439dc66))



# [1.0.0-beta.12](https://github.com/p3ol/oak/compare/v1.0.0-beta.11...v1.0.0-beta.12) (2021-08-02)


### Bug Fixes

* **addon-basic-components:** fix key ([80f4e6f](https://github.com/p3ol/oak/commit/80f4e6f1e3a1c410b3c96569e438cd95d0179d3c))
* **deps:** update dependency core-js to v3.16.0 ([6b154cb](https://github.com/p3ol/oak/commit/6b154cba999241057682a60a4603014e6318aecc))
* **deps:** update poool junipero monorepo to v2.0.0-rc.10 ([dc20ccd](https://github.com/p3ol/oak/commit/dc20ccdb26a1b118bfdc91a2d7f17c0874f79ec5))
* **editor:** add traduction for default value of editor content ([706e3ea](https://github.com/p3ol/oak/commit/706e3eae26a70263391f5deb100af1fa07196b7f))
* **editor:** avoid using restricted words ([9bdc258](https://github.com/p3ol/oak/commit/9bdc25818b210117b7b94a01fa72befdca9dfce7))
* **font-size:** set editor font size with base content size ([5099633](https://github.com/p3ol/oak/commit/5099633453a4a853372e7b04d79253a42f3fb4e2))
* **oak-editor:** add traductions for editor tooltip Texts ([35e7525](https://github.com/p3ol/oak/commit/35e75257873be21bdf567c327dd47a6a77cf79d9))
* **oak-select:** fix code ([2f40d50](https://github.com/p3ol/oak/commit/2f40d501294be2dddb58ff231bb838b091d8e717))
* **oak-select:** removes useless fragment ([37a239f](https://github.com/p3ol/oak/commit/37a239f0496214ec1dcb430ef67b73cf8e2208fe))
* **oak-select:** removes useless line break ([a139c5e](https://github.com/p3ol/oak/commit/a139c5eae32256f3ee1a16d6d4edb28229d0277d))
* **oak-select:** use field label props instead of new name one ([4068976](https://github.com/p3ol/oak/commit/4068976c4688bd776673b3469fc212c0f4d7c165))
* **oak-trads:** change english and french trads for text and title defaults ([c9d9d24](https://github.com/p3ol/oak/commit/c9d9d241d165e68046e445f144380f2bc2fd96f7))
* **oak:** fix some traductions following the trads document ([41f27f2](https://github.com/p3ol/oak/commit/41f27f293cf1ba150299e61d3c71aba6f77e6617))
* **oak:** fix trads ([162ec5d](https://github.com/p3ol/oak/commit/162ec5daf8ad9c2b37446363024b268582f94458))
* **oak:** fix trads following traductions document ([ab4a04f](https://github.com/p3ol/oak/commit/ab4a04f952404bd639898b8eafa35643c1e4bb0d))
* **select-field:** add optional name props for select and use it in design tab ([249445a](https://github.com/p3ol/oak/commit/249445ab71eac65affc36d300262fbca78c7f046))
* **text-editor:** make requested changes ([9f3e5a0](https://github.com/p3ol/oak/commit/9f3e5a09e999df0a54758f34d455c17ca5556ae9))



# [1.0.0-beta.11](https://github.com/p3ol/oak/compare/v1.0.0-beta.10...v1.0.0-beta.11) (2021-07-27)


### Bug Fixes

* **addon-basic-components:** quote image url ([135d5d9](https://github.com/p3ol/oak/commit/135d5d9629603caa9ef97b46c68ebc7c57be11a2))
* **alignments:** fix horizontal alignement ([8bb838d](https://github.com/p3ol/oak/commit/8bb838d4c350a7a7f589a04a6e778fa862e706f5))
* **alignments:** remove useless whitespace ([55f701d](https://github.com/p3ol/oak/commit/55f701dd98dc70c27c2b3f37ac89f0db5f86bd2e))
* **deps:** update poool junipero monorepo to v2.0.0-rc.9 ([94712b3](https://github.com/p3ol/oak/commit/94712b34f2bf939616607e1e243d13faf4144db6))
* **editor:** use vars to handle text editor colors ([6cc962a](https://github.com/p3ol/oak/commit/6cc962a7df57e2c3e0c488f929622be9fad8159c))
* **image:** add overflow on file name ([b644f3f](https://github.com/p3ol/oak/commit/b644f3fc417deee33754cec71314dc28d4e89672))
* **image:** re add widthon image preview ([08166c8](https://github.com/p3ol/oak/commit/08166c86beb09e9c19107703a7c44bc678761946))
* remove useless modifiers ([ed84e5d](https://github.com/p3ol/oak/commit/ed84e5daea3b9f1f2e646396ce1aa4b5504cfd4e))
* **repeat-value:** fix repeat y value ([f97f656](https://github.com/p3ol/oak/commit/f97f6568af34d37d72bc6cd6d3fa289d2a7e256d))


### Features

* add styles to the colorField of ColorButton ([fd92b62](https://github.com/p3ol/oak/commit/fd92b624c4b0dd8345e17e34fb21fb2bd6784642))
* adjust spacing ([a6aa4ce](https://github.com/p3ol/oak/commit/a6aa4cea1db737087e5e9eb12bf00a2cbb733acd))
* **image-size-field:** add trads ([29a323b](https://github.com/p3ol/oak/commit/29a323b3874dc2f746a529f4f76c841d0f985987))
* **image-size:** change EN trad ([fc59d9e](https://github.com/p3ol/oak/commit/fc59d9e28e56620253a2629c7c3d5ecc26ed0d4b))
* **image-size:** delete default value and add placeholder ([a732813](https://github.com/p3ol/oak/commit/a732813a468db6152e344c7a4aea16350afb73cf))
* **image:** add size select field and width and height if size is custom ([b8d2829](https://github.com/p3ol/oak/commit/b8d28290da389f40df177fe1caf3c7724d9ad1bd))
* **image:** switch default value to auto ([0a27b4f](https://github.com/p3ol/oak/commit/0a27b4f33f8d158fe22f13b712f1288e55d94afe))
* remove shadow and round corners of color wheel ([558e11f](https://github.com/p3ol/oak/commit/558e11ff95f055cb2a391b57af736ce78f799bb7))



# [1.0.0-beta.10](https://github.com/p3ol/oak/compare/v1.0.0-beta.9...v1.0.0-beta.10) (2021-07-07)


### Bug Fixes

* **deps:** update dependency @poool/junipero to v2.0.0-rc.7 ([033966f](https://github.com/p3ol/oak/commit/033966f2012affe37d87a0dba7809bbbf1efe6b3))
* **deps:** update dependency @poool/junipero to v2.0.0-rc.8 ([cc00c0d](https://github.com/p3ol/oak/commit/cc00c0d4ae8ca06d31d60f1937a4e49e9d4f122a))
* **deps:** update dependency preact to v10.5.14 ([87e54ac](https://github.com/p3ol/oak/commit/87e54ac17143cf96e2b74566fcdba87fce771a37))
* **deps:** update poool junipero monorepo to v2.0.0-rc.5 ([561b7f9](https://github.com/p3ol/oak/commit/561b7f9f0002aae1e707bcfe4ddeef2b74fe020b))
* **editor:** add verification on element childNodes ([9480447](https://github.com/p3ol/oak/commit/948044759a9e224e62b5ce3f107d254d62550da6))
* **editor:** change text placholder ([42ee14d](https://github.com/p3ol/oak/commit/42ee14d9bc4f9271ec44c9ef4f750d429731cdce))
* **editor:** use jsx element instead of empty string ([55435b5](https://github.com/p3ol/oak/commit/55435b5717fd26e1d6d3211f8d23a2a2a1945dc2))
* **image-component:** show add touchable zone if upload fails ([d72d8a7](https://github.com/p3ol/oak/commit/d72d8a7d734dd3e89eff40f84cc7c0e918be390a))



# [1.0.0-beta.9](https://github.com/p3ol/oak/compare/v1.0.0-beta.8...v1.0.0-beta.9) (2021-07-01)


### Bug Fixes

* **lib:** fix missing default text render value ([d536701](https://github.com/p3ol/oak/commit/d536701c96681392c6c804c22f5ae214dc621f66))



# [1.0.0-beta.8](https://github.com/p3ol/oak/compare/v1.0.0-beta.7...v1.0.0-beta.8) (2021-06-30)


### Bug Fixes

* **get-text:** fix get text with non string value ([66e4e76](https://github.com/p3ol/oak/commit/66e4e76a54be4acef63486b07e35a19f8ec5a29c))


### Features

* **lib:** allow for icon to be a function ([5633be0](https://github.com/p3ol/oak/commit/5633be07fe8f61ad3d698b01248396c36e02b529))



# [1.0.0-beta.7](https://github.com/p3ol/oak/compare/v1.0.0-beta.6...v1.0.0-beta.7) (2021-06-30)


### Bug Fixes

* **deps:** update dependency @poool/junipero to v2.0.0-rc.2 ([0a856f8](https://github.com/p3ol/oak/commit/0a856f805bb9f4007886049ccdf4a04054f9720f))
* **deps:** update dependency core-js to v3.15.2 ([12b39a0](https://github.com/p3ol/oak/commit/12b39a0137b7edd1611dc596ee73e8652c2d796d))
* **select-field:** fix default selectField parseValue ([bf56946](https://github.com/p3ol/oak/commit/bf5694608ca907bbb323cca50f34878d8b636fac))



# [1.0.0-beta.6](https://github.com/p3ol/oak/compare/v1.0.0-beta.5...v1.0.0-beta.6) (2021-06-29)


### Bug Fixes

* **lib:** add missing component to component renderer ([510f5f4](https://github.com/p3ol/oak/commit/510f5f4f6769318fdcbd0e1ee5c16b65b28aed4a))
* **lib:** fix props styling ([256fd98](https://github.com/p3ol/oak/commit/256fd98b8181354b69e99cc6d8814a321bec6dcf))



# [1.0.0-beta.5](https://github.com/p3ol/oak/compare/v1.0.0-beta.4...v1.0.0-beta.5) (2021-06-29)


### Bug Fixes

* fix overflows ([afbfa74](https://github.com/p3ol/oak/commit/afbfa74fa2bc23cd525b22cd04b0decf7594f8ba))


### Features

* **addon-basic-components:** add displayable to button props ([0868572](https://github.com/p3ol/oak/commit/08685724ed4e1c471c7790b70d558366d3414788))
* **addon-basic-components:** add element infos ([f943a25](https://github.com/p3ol/oak/commit/f943a25957e6579a6a92fa05c8be126b99099073))
* **lib:** add condition to displayable fields ([291f636](https://github.com/p3ol/oak/commit/291f636217d4b795a46e953ad6e48fb7d42c43f3))
* **lib:** display element infos ([f2cdaed](https://github.com/p3ol/oak/commit/f2cdaedd0463c40e9f5b6febd3e46650cfdba96b))



# [1.0.0-beta.4](https://github.com/p3ol/oak/compare/v1.0.0-beta.3...v1.0.0-beta.4) (2021-06-29)


### Features

* **lib:** allow to add custom fields & priorities ([2ebda53](https://github.com/p3ol/oak/commit/2ebda531f178c454a4ef66c6159127df735721f4))



# [1.0.0-beta.3](https://github.com/p3ol/oak/compare/v1.0.0-beta.2...v1.0.0-beta.3) (2021-06-28)


### Features

* **lib:** export lib & app to avoid multiple react apps when needed ([375c6f8](https://github.com/p3ol/oak/commit/375c6f8868f27393a60a24b177425d2840c391a1))
* **react:** directly use new exported builder from oak ([c828a81](https://github.com/p3ol/oak/commit/c828a819f7108f60fa978844d81007de5af8548a))



# [1.0.0-beta.2](https://github.com/p3ol/oak/compare/v1.0.0-beta.1...v1.0.0-beta.2) (2021-06-28)


### Bug Fixes

* **lib:** fix editable resizing every field out there ([8f934f9](https://github.com/p3ol/oak/commit/8f934f9ffe6061e53e458895d66be4ffac860448))
* **lib:** fix missing styles imports ([9b61de2](https://github.com/p3ol/oak/commit/9b61de24b1e801a3a1bf165e8b66b98cef562df0))



# [1.0.0-beta.1](https://github.com/p3ol/oak/compare/v1.0.0-beta.0...v1.0.0-beta.1) (2021-06-28)


### Bug Fixes

* **lib:** fix wrong field name ([75b1082](https://github.com/p3ol/oak/commit/75b1082265ff40a816287ea6abfb2fc64f5d6eb2))



# [1.0.0-beta.0](https://github.com/p3ol/oak/compare/v1.0.0-alpha.15...v1.0.0-beta.0) (2021-06-28)


### Bug Fixes

* **deps:** update dependency @poool/junipero to v2.0.0-beta.31 ([890a363](https://github.com/p3ol/oak/commit/890a363993f23356ec8dab9f7b627c1f894febc8))
* **react:** fix missing parent classname ([18c9fd6](https://github.com/p3ol/oak/commit/18c9fd647456a5204cc80b42503ec97541a9d959))


### Features

* **lib:** add date & toggle fields ([c2a3fd2](https://github.com/p3ol/oak/commit/c2a3fd2b60837603724dba17eb4082e10eeaa4e8))



# [1.0.0-alpha.15](https://github.com/p3ol/oak/compare/v1.0.0-alpha.14...v1.0.0-alpha.15) (2021-06-24)


### Bug Fixes

* **lib:** allow for multiple components groups ([617d3c3](https://github.com/p3ol/oak/commit/617d3c3245af61ff7e2993cc5c3f57a6fbe091b7))



# [1.0.0-alpha.14](https://github.com/p3ol/oak/compare/v1.0.0-alpha.13...v1.0.0-alpha.14) (2021-06-24)


### Bug Fixes

* **lib:** handle components without construct ([ff5d718](https://github.com/p3ol/oak/commit/ff5d718b57dbaaba3d1d9845410da49ff882ca72))


### Features

* **lib:** disable other tab when not needed ([b088da6](https://github.com/p3ol/oak/commit/b088da603fa9e94487dd5788ed0987a8b3074f65))
* **react:** add wrapper class ([02b2435](https://github.com/p3ol/oak/commit/02b24355c7682e7fae3b3bd32ce061fda2d976b7))



# [1.0.0-alpha.13](https://github.com/p3ol/oak/compare/v1.0.0-alpha.12...v1.0.0-alpha.13) (2021-06-23)


### Bug Fixes

* **addon-basic-components:** fix title layout ([e2b4cc2](https://github.com/p3ol/oak/commit/e2b4cc2415a46b272269c94351caeae23ff0240a))
* **lib:** fix hover states ([d7aeb5c](https://github.com/p3ol/oak/commit/d7aeb5c9b951a142b8f959e63753bd035132b9b7))
* **lib:** handle function icons ([9bd1348](https://github.com/p3ol/oak/commit/9bd13484459c94cf1aa82e7c218e25c4eff379b3))
* **oak:** fix column direction layout ([a825deb](https://github.com/p3ol/oak/commit/a825deb9f0d619f2fbfa4f7b6be4e7832edef453))



# [1.0.0-alpha.12](https://github.com/p3ol/oak/compare/v1.0.0-alpha.11...v1.0.0-alpha.12) (2021-06-23)


### Bug Fixes

* **colors:** add selector .oak on all resets - DASHV6-127 ([2a9cee2](https://github.com/p3ol/oak/commit/2a9cee28314078936f7382bf533a881364af9e3d))
* **deps:** update dependency core-js to v3.15.1 ([761b986](https://github.com/p3ol/oak/commit/761b9862b3b2e43b12c37cc13a114f51a1047915))
* **oak:** prevent oak colors from overflow on dashboard ones - DASHV6-127 ([44ee133](https://github.com/p3ol/oak/commit/44ee1338b77e51ca90f858107414796f9a514f16))



# [1.0.0-alpha.11](https://github.com/p3ol/oak/compare/v1.0.0-alpha.10...v1.0.0-alpha.11) (2021-06-22)


### Bug Fixes

* **deps:** update dependency @poool/junipero to v2.0.0-beta.30 ([513b0bd](https://github.com/p3ol/oak/commit/513b0bd1288d640dc36c43028356602332c81068))


### Features

* **addon-basic-components:** add empty space component ([86382a2](https://github.com/p3ol/oak/commit/86382a2c54fab02ce37bc4d6cd32fbb8e369cd97))
* **design:** add settings and remove options ([2b5e43c](https://github.com/p3ol/oak/commit/2b5e43c100386e3115354c8176dcc91653fc3605))
* **empty-space:** add FR traductions, use textKey instead of inline trads and make required changes ([9bdd1b8](https://github.com/p3ol/oak/commit/9bdd1b84eec1daa0e58a5af3ea0f6d044f2bcb45))
* **oak:** move empty space to oak core components ([e867f83](https://github.com/p3ol/oak/commit/e867f830420124d2557737095bd59566426c5e28))



# [1.0.0-alpha.10](https://github.com/p3ol/oak/compare/v1.0.0-alpha.9...v1.0.0-alpha.10) (2021-06-21)



# [1.0.0-alpha.9](https://github.com/p3ol/oak/compare/v1.0.0-alpha.8...v1.0.0-alpha.9) (2021-06-21)


### Bug Fixes

* **deps:** update dependency @poool/junipero to v2.0.0-beta.29 ([6c89cfe](https://github.com/p3ol/oak/commit/6c89cfe132c59297981657039f23631018d05180))
* **deps:** update dependency core-js to v3.15.0 ([0920ef4](https://github.com/p3ol/oak/commit/0920ef48fed2e414a6e2f24c631c67b43bdf0864))
* set react as external everywhere until a better solution comes to mind ([4a20a34](https://github.com/p3ol/oak/commit/4a20a344d7ff057cd092745dc1fb2991566e8d8e))



# [1.0.0-alpha.8](https://github.com/p3ol/oak/compare/v1.0.0-alpha.7...v1.0.0-alpha.8) (2021-06-18)



# [1.0.0-alpha.7](https://github.com/p3ol/oak/compare/v1.0.0-alpha.6...v1.0.0-alpha.7) (2021-06-18)


### Bug Fixes

* **addon-basic-components:** fix default font size ([cf996b0](https://github.com/p3ol/oak/commit/cf996b005c67d7e17b7a6b377ac9119d4c463386))



# [1.0.0-alpha.6](https://github.com/p3ol/oak/compare/v1.0.0-alpha.5...v1.0.0-alpha.6) (2021-06-18)


### Bug Fixes

* **addon-basic-components:** (wip) fix text-alignment serialization ([5905079](https://github.com/p3ol/oak/commit/59050791955a82e18286b6464239f9f2a3f2df33))
* **addon-basic-components:** correctly display line breaks ([509c33c](https://github.com/p3ol/oak/commit/509c33c2d02503fe16a5f51f14ff7ff572e86032))
* **addon-basic-components:** correctly handle deserialization ([6d7ba39](https://github.com/p3ol/oak/commit/6d7ba3967aacad875d72ddc19f9b62ea3cc7f12b))
* **addon-basic-components:** fix content wrapping and empty line serialization ([eef282c](https://github.com/p3ol/oak/commit/eef282c8ee7122550edea98dd0612e7067030e28))
* **addon-basic-components:** fix editor box sizing ([37c73d0](https://github.com/p3ol/oak/commit/37c73d055b398c348124ed9a9348a7727862ed74))
* **addon-basic-components:** fix eslint warnings ([34c33a2](https://github.com/p3ol/oak/commit/34c33a24fec52abcd9df58ff55aafbbaf98a4bd0))
* **addon-basic-components:** fix html serialization ([38da9dc](https://github.com/p3ol/oak/commit/38da9dc5adcaf2aa55eb6dd60d616b2564e9bc62))
* **addon-basic-components:** fix icons active color ([1fb40d3](https://github.com/p3ol/oak/commit/1fb40d32b9b67d69636828a40aea87a50e4e69ec))
* **addon-basic-components:** fix multiple uneeded div addition ([8c92475](https://github.com/p3ol/oak/commit/8c92475fa3fe04c5488fcec7f5d0f554f92cb354))
* **addon-basic-components:** fix selection check when child is an array ([6eb5f83](https://github.com/p3ol/oak/commit/6eb5f83a5b9b5e0e90b8b7f9ccec4b2cc0aacf58))
* **addon-basic-components:** fix size buttons styles ([5d1ccdd](https://github.com/p3ol/oak/commit/5d1ccdd9fce6861fb158d2dd0cb537683bde68d2))
* **addon-basic-components:** fix text not being colorized ([b511128](https://github.com/p3ol/oak/commit/b51112814cd296add09d9d665f20c710b0f8df20))
* **deps:** update dependency @poool/junipero to v2.0.0-beta.25 ([bb603fe](https://github.com/p3ol/oak/commit/bb603fe6e1d154aeb3b695119edd34329e956d10))
* **deps:** update dependency @poool/junipero to v2.0.0-beta.26 ([4569148](https://github.com/p3ol/oak/commit/4569148cdc00e2b695bbe47e69c1d8d9741ce0f5))
* **deps:** update dependency core-js to v3.14.0 ([0ae86a8](https://github.com/p3ol/oak/commit/0ae86a8cd496ae0ce961af636761786da6edff15))
* **deps:** update dependency slate-react to v0.65.2 ([f281207](https://github.com/p3ol/oak/commit/f2812073a0b1ddd037482da4670d0ef7834add0a))
* **editable:** remove useless blank line ([bb39416](https://github.com/p3ol/oak/commit/bb39416b62db7cf2496f8b9b9d67b20320f5b039))
* **editable:** use junipero button with custom colors ([0dd7d17](https://github.com/p3ol/oak/commit/0dd7d171c93810a97fa39c6b81ad394602f2110a))
* **lib:** add max height to editable dropdowns ([c9747d1](https://github.com/p3ol/oak/commit/c9747d12d034055bb1e9cad6a6bc2c07e09f8458))
* **lib:** add missing hook method ([188721c](https://github.com/p3ol/oak/commit/188721c1fb19724829b4c0f7a014bacd468aa0c4))
* **lib:** avoid losing edits when closing editable on click outside ([2cb6287](https://github.com/p3ol/oak/commit/2cb62879f2c8a3fcc3bdc59eab1be28205dc7094))
* **lib:** better multi-field settings layout ([3a31ad6](https://github.com/p3ol/oak/commit/3a31ad6dd399a403fe59e67223d2a0bfa55ed509))
* **lib:** revert changes on editable cancel ([45a216d](https://github.com/p3ol/oak/commit/45a216d6f7d6c3d983534f849b3bb9a64b527946))
* **oak:** clean code ([4f627c4](https://github.com/p3ol/oak/commit/4f627c45fa4c33fa0ec2946ce5b0aa79c304a434))
* **oak:** fix missing white space rule ([6c99956](https://github.com/p3ol/oak/commit/6c9995650a02e3d590a5493e69875662d7dcdd35))
* **oak:** prevent editable popper from bein hidden ([c3ba2a4](https://github.com/p3ol/oak/commit/c3ba2a4fddee2411420e0eae6dcbe2a9c4c81e0f))
* **oak:** stop event propagatin for selectField click ([dbd71d0](https://github.com/p3ol/oak/commit/dbd71d08e8a73b826b9979a0d682285ef3ceb8cd))
* **oak:** use given val instead of state.value to dispatch event, and remove useless function ([39369f7](https://github.com/p3ol/oak/commit/39369f7ced1dba0699f0390bddd3a2d4db9fef88))


### Features

* **addon-basic-components:** add block button component ([5073d27](https://github.com/p3ol/oak/commit/5073d27557e46450a700e30fc980f8842042007c))
* **addon-basic-components:** add junipero tooltip on icon hover ([55ff7a2](https://github.com/p3ol/oak/commit/55ff7a2571e828214649876aa94fa7226cd94287))
* **addon-basic-components:** add minus icon ([a5938de](https://github.com/p3ol/oak/commit/a5938dec833d3d42d20f92dca0aaef2e152eecce))
* **addon-basic-components:** add text alignment buttons ([822b5a8](https://github.com/p3ol/oak/commit/822b5a891da3ab91e43cc7cdbd4114bf1777957e))
* **addon-basic-components:** add text size management ([ec6410f](https://github.com/p3ol/oak/commit/ec6410f897518524d3b1e4205127e4d4ebfc187d))
* **addon-basic-components:** translate components & fields ([1bf6b95](https://github.com/p3ol/oak/commit/1bf6b9518b769078e47e2c2a90bcc63583df4a88))
* **editable:** WIP remove dangerous stopPrpagation on selectField ([25948de](https://github.com/p3ol/oak/commit/25948de9d25b37f86a20a1a93260e47c8039145c))
* **lib:** add col special responsive settings ([dc5421d](https://github.com/p3ol/oak/commit/dc5421dc73ce54cf2118ebad693ae783a3e694c6))
* **lib:** add fr translation file ([87f1dfc](https://github.com/p3ol/oak/commit/87f1dfca77068cacf1722ba7b7bf8ad70b0508b1))
* **lib:** add responsive settings for all components ([861e884](https://github.com/p3ol/oak/commit/861e8847e09e505cc9cd16384ee59eae34212c22))
* **lib:** add row style settings ([6450a1e](https://github.com/p3ol/oak/commit/6450a1e99e9034005f84296bd767141d042be335))
* **lib:** add styling settings to every component ([b0f01b4](https://github.com/p3ol/oak/commit/b0f01b4334c6deb1c5951588bc81b348c67067df))
* **lib:** allow to pass custom texts as options ([2075f00](https://github.com/p3ol/oak/commit/2075f00235ae75310d064444465acd48843a924b))
* **lib:** translate core components & fields ([6d69c79](https://github.com/p3ol/oak/commit/6d69c79483ff180f551c462f57198707f8076711))
* **oak:** add 2 booleans to know if undo or redo are possible on parent app ([15d683f](https://github.com/p3ol/oak/commit/15d683f7063e0e2251b71c2068a6a56483893b31))
* **oak:** add a way to not call onchange if its parent who required the changes - DASHV6-59 ([c102eef](https://github.com/p3ol/oak/commit/c102eef838030628cd6fd13d6f9ee5124877e21e))
* **oak:** add delay on onChange for textEditor ([16e64a2](https://github.com/p3ol/oak/commit/16e64a2a3a736e17f2717449a1b83fd5d8846ec6))
* **oak:** add isSerialized on title ([68b2809](https://github.com/p3ol/oak/commit/68b2809ca3101adbf15ab69c9a566467f9ee4ce1))
* **oak:** add little padding under undo redo - DASHV6-59 ([bd08a9b](https://github.com/p3ol/oak/commit/bd08a9ba33f3ae49042109fe5d9d83d44b3b8956))
* **oak:** add maximum on change memory ([78413e4](https://github.com/p3ol/oak/commit/78413e4899ed4a8742801d48519daa4ca3a21e4e))
* **oak:** add onChange event on oak lib ([f7bde8e](https://github.com/p3ol/oak/commit/f7bde8e491795eb470199c46f2bade9200b4b58a))
* **oak:** add redo and rework undo ([b8f7721](https://github.com/p3ol/oak/commit/b8f77217587371fdfe10c3f2520145dffad183f2))
* **oak:** add save button for all editable content ([ff46813](https://github.com/p3ol/oak/commit/ff468136224339bb4a7b887c20edb87ca99e0832))
* **oak:** add serialization into HTMl ([b041c19](https://github.com/p3ol/oak/commit/b041c199135a78517ab56fcc734af86958797232))
* **oak:** add text size icons ([90647cf](https://github.com/p3ol/oak/commit/90647cf368967ae29be9303bb05350e2aa5e9bf7))
* **oak:** add tundo/redo possibility booleans to builder ([f213493](https://github.com/p3ol/oak/commit/f2134931a6bde61733fe4dcbaa67af886d358472))
* **oak:** add type on col when dividing ([9cab0e2](https://github.com/p3ol/oak/commit/9cab0e21b8c8dd08c8833f855d84c2668b5c3fbb))
* **oak:** add undo and redo to fonticons icomoons json ([8e70a4f](https://github.com/p3ol/oak/commit/8e70a4fa99633db1927aebc5083dffdafbc12514))
* **oak:** add undo redo icons to custom fonticon DASHV6-59 ([ee03810](https://github.com/p3ol/oak/commit/ee03810649f63e5b1a04e71eb0c748dbbdeeefc4))
* **oak:** add update button on text editor ([b06c751](https://github.com/p3ol/oak/commit/b06c75132844e61fccb16e7efebfd54140c91adc))
* **oak:** change display ([39b8bfa](https://github.com/p3ol/oak/commit/39b8bfaa0ce1da8fe234419d97927062157278aa))
* **oak:** change ref of oak app ([985bace](https://github.com/p3ol/oak/commit/985bace676ea1b54eeac92f5126f8eda544faa75))
* **oak:** change serialize function ([6368154](https://github.com/p3ol/oak/commit/63681548ff1d1176a63b482335c9c7b87ab2acbc))
* **oak:** change starting content on oak story ([6075a80](https://github.com/p3ol/oak/commit/6075a80ef78071ce036e3957a2e33102c30310e1))
* **oak:** change validate button display - DASHV6-59 ([3bc7739](https://github.com/p3ol/oak/commit/3bc7739889e333e02a41534f32ddc7cdb51fc933))
* **oak:** enable storybook addon actions on oak react story ([4b031f1](https://github.com/p3ol/oak/commit/4b031f124002e00e1e1008699b268e98726dcc3f))
* **oak:** enable the undo and redo function outside of oak ([19d04f5](https://github.com/p3ol/oak/commit/19d04f5be14807f0c03cf33efe798ccbb02261da))
* **oak:** enable undo of first modification ([a5b4878](https://github.com/p3ol/oak/commit/a5b48789fdb562642b96977b1dd0c5b891e0de71))
* **oak:** first step of undo ([9ea5d8d](https://github.com/p3ol/oak/commit/9ea5d8d76ad47acf281c392cabbbf09ccdcbc397))
* **oak:** fix dumb code ([bbc7fa9](https://github.com/p3ol/oak/commit/bbc7fa97c12af11ec01c7c51b4bbcbf6ac518363))
* **oak:** fix indent ([6dab16c](https://github.com/p3ol/oak/commit/6dab16c06a6d38af69ef8bb8dbb4e3a7a030139d))
* **oak:** handle the undo/redo impossible state - DASHV6-59 ([8671a35](https://github.com/p3ol/oak/commit/8671a3521298cf54ddc71e1f669641a4ceff1eb5))
* **oak:** improve redo - DASHV6-59 ([b213c2b](https://github.com/p3ol/oak/commit/b213c2b45455047de84e17b4d0fc12b1fb1e8914))
* **oak:** override some dashboard styles ([e010a0f](https://github.com/p3ol/oak/commit/e010a0f67b4eea9d169928ac24cfbf9c8389fd77))
* **oak:** put undo redo to the left - DASHV6-55 ([b855841](https://github.com/p3ol/oak/commit/b855841f5124a0c723ae3e0dd4c393042ee87077))
* **oak:** remove console.log ([eba90af](https://github.com/p3ol/oak/commit/eba90af8bd199722b7263fb979757c3b961f157d))
* **oak:** remove console.log ([e6b94e7](https://github.com/p3ol/oak/commit/e6b94e7d8eacc9c22b64cd42f984003e25cafe93))
* **oak:** remove save button on textEditor ([8b5806b](https://github.com/p3ol/oak/commit/8b5806b8c61220b6e16c64e8ccb034a04223879f))
* **oak:** remove useless code and logs" ([7920106](https://github.com/p3ol/oak/commit/792010666ff23cf4a03f17af9693e5ee1423be83))
* **oak:** remove useless import ([950367a](https://github.com/p3ol/oak/commit/950367a54daf13b83daedcf1642105ac0d78f8b6))
* **oak:** remove useless import ([586ace7](https://github.com/p3ol/oak/commit/586ace7726b7d1fc1411621e3652e45155e962e7))
* **oak:** remove useless props and rework style ([6e90f16](https://github.com/p3ol/oak/commit/6e90f1697e1cd27ae3d687ba9db4c04972baaa56))
* **oak:** repair value not update in editable fields - DASHV6-59 ([1286af7](https://github.com/p3ol/oak/commit/1286af723dc993224932bc53fb90b1bac7efc01c))
* **oak:** rework undo redo buttons - DASHV6-59 ([aa0b4b6](https://github.com/p3ol/oak/commit/aa0b4b690f63d55a665d16196c3a3646fdeba0f9))
* **oak:** serialize object before sending it to parent app ([626f366](https://github.com/p3ol/oak/commit/626f366a475b956e574e29d76a3b66431d63fc70))
* **oak:** update story to test refresh ([34b4d07](https://github.com/p3ol/oak/commit/34b4d07f756fd9846992a6c35471a359bc2f72f4))
* **okak:** add disabled state on undo and redo buttons ([7cf58a8](https://github.com/p3ol/oak/commit/7cf58a8c54fddd4b8837ed63cc513e3b73458501))
* **text-color:** (wip) add text colorization ([844294f](https://github.com/p3ol/oak/commit/844294fa30143d0b5d887b0747e00b511d67a8dd))
* **texts:** remove useless divs when text is left aligned ([1086e0e](https://github.com/p3ol/oak/commit/1086e0e4d5f6685556af1868c430d147684d65af))
* **undo:** add guards on deserialize to avoid deserialize a deserialized object ([e92cc56](https://github.com/p3ol/oak/commit/e92cc568806a13c491a61ecbfd552c37df5f10ba))



# [1.0.0-alpha.5](https://github.com/p3ol/oak/compare/v1.0.0-alpha.4...v1.0.0-alpha.5) (2021-06-03)


### Bug Fixes

* **deps:** update dependency @poool/junipero to v2.0.0-beta.24 ([3a4a115](https://github.com/p3ol/oak/commit/3a4a115c7e1eb26cda0062a2820fb9727ad40840))
* **deps:** update dependency core-js to v3.13.1 ([ee3f5d4](https://github.com/p3ol/oak/commit/ee3f5d43c069c8f534234eaa1a8a878543ec239c))
* **deps:** update dependency slate-react to v0.65.0 ([22866b0](https://github.com/p3ol/oak/commit/22866b058f7baad17d9374a7cdfe6f5fe0e3f3d3))
* **oak:** set builder and use its setContent method on react implementation - DASHV6-59 ([d9e0616](https://github.com/p3ol/oak/commit/d9e061638e3ec10440b823ce2830fcd0f4fd1536))



# [1.0.0-alpha.4](https://github.com/p3ol/oak/compare/v1.0.0-alpha.3...v1.0.0-alpha.4) (2021-05-28)


### Bug Fixes

* **lib:** fix overflowing component name ([2a3ee72](https://github.com/p3ol/oak/commit/2a3ee727767c9384fd97245380bc3bd7972e40dd))



# [1.0.0-alpha.3](https://github.com/p3ol/oak/compare/v1.0.0-alpha.2...v1.0.0-alpha.3) (2021-05-28)


### Features

* **oak:** add width and max width for components buttons ([441cb6e](https://github.com/p3ol/oak/commit/441cb6eb2fc1d1f28fcf74b62a4a6d3b1d8e9340))



# [1.0.0-alpha.2](https://github.com/p3ol/oak/compare/v1.0.0-alpha.1...v1.0.0-alpha.2) (2021-05-27)


### Bug Fixes

* **addon-basic-components:** remove additional css modules ([bd99cf1](https://github.com/p3ol/oak/commit/bd99cf10e933873cfc776ca8cdd444d538c966a1))



# [1.0.0-alpha.1](https://github.com/p3ol/oak/compare/d7b7e8b2ffa4ab87d867559b8614925ee0cf48da...v1.0.0-alpha.1) (2021-05-27)


### Bug Fixes

* **addon-basic-components:** enable richtext in titles ([b4b0a54](https://github.com/p3ol/oak/commit/b4b0a54f3f00c89dee9cd2afc3b6beb1f3270f91))
* **addon-basic-components:** fix image field ([b069f25](https://github.com/p3ol/oak/commit/b069f25325df10c39a71c66c89d70dd2b3213443))
* **addon-basic-components:** remove useless styles ([e76b9af](https://github.com/p3ol/oak/commit/e76b9afefb30b8c2785dce3047c1750dc7616e1f))
* **builder:** lint on input json ([699895e](https://github.com/p3ol/oak/commit/699895e63f537714f0c25175b3ee26c922538151))
* **catalogue:** fix multiple components rendering on catalogue ([dfd1fad](https://github.com/p3ol/oak/commit/dfd1fade18090a00e8f41543c029d0874c933fa7))
* **cols:** add margin before and after content ([8c5af4a](https://github.com/p3ol/oak/commit/8c5af4a46586c417e5a1071ecf38061272359b1e))
* **cols:** rename class and remove useless css properties ([4571c71](https://github.com/p3ol/oak/commit/4571c71f0d638f6102e13cb71a1e9b77b2246876))
* **cols:** rename property in css too ([3078b39](https://github.com/p3ol/oak/commit/3078b393b899c9bd67669bd8376c2f0a2e370e14))
* **deps:** update dependency @popperjs/core to v2.5.1 ([113442a](https://github.com/p3ol/oak/commit/113442a43a8d49c0964300afc62aaa1f3d08a8c9))
* **deps:** update dependency @popperjs/core to v2.5.2 ([416ca0d](https://github.com/p3ol/oak/commit/416ca0dc92a00d4c0b12342b1a801c56e4ec3d43))
* **deps:** update dependency @popperjs/core to v2.5.3 ([43c0c6a](https://github.com/p3ol/oak/commit/43c0c6a26c711d9e1a6cb650f7ae5430213f26d7))
* **deps:** update dependency core-js to v3.13.0 ([ef7558d](https://github.com/p3ol/oak/commit/ef7558dca1e8de85a85d205ff812ffd37a0c2132))
* **deps:** update dependency core-js to v3.8.0 ([63bf373](https://github.com/p3ol/oak/commit/63bf37312693c4133b84b97e6bfbacccff94c415))
* **deps:** update dependency preact to v10.4.8 ([efa1f60](https://github.com/p3ol/oak/commit/efa1f602523f9eadbbf6bc5f93b7fbb1ced8c085))
* **deps:** update dependency preact to v10.5.0 ([fa20a38](https://github.com/p3ol/oak/commit/fa20a38ce9764c9fc86c88cdd65addb61cec835b))
* **deps:** update dependency preact to v10.5.2 ([746ac95](https://github.com/p3ol/oak/commit/746ac954b0364c900521a875fa265888f8848853))
* **deps:** update dependency preact to v10.5.3 ([4dee13e](https://github.com/p3ol/oak/commit/4dee13e47751a3456ad0dc7d2910c051eb7d0654))
* **deps:** update dependency preact to v10.5.4 ([bd38e8c](https://github.com/p3ol/oak/commit/bd38e8c0cbb956d20e38f9024df84b5ac3c574ae))
* **deps:** update dependency preact to v10.5.5 ([7fff196](https://github.com/p3ol/oak/commit/7fff1965b3e4af2dcfb2121021b1eebf0c16241b))
* **elements:** adjust the margin for all elements and not just rows ([5359f22](https://github.com/p3ol/oak/commit/5359f224dd59d9ccd562aab6ad3b5e15c1f4b7c2))
* fix catalogue ([f2c2f4f](https://github.com/p3ol/oak/commit/f2c2f4f127cfb048286aec8ac882a616aecb483d))
* fix crash on load ([9109a87](https://github.com/p3ol/oak/commit/9109a87169d66b7d657e2a3f344dbe754bb545ee))
* fix drag & drop fuckery ([bd482bd](https://github.com/p3ol/oak/commit/bd482bd28cc35318bf285cf301c338e8f7579dd0))
* fix editables layouts ([ee8ec94](https://github.com/p3ol/oak/commit/ee8ec94feee7efab485d5d4f1be10294db40a486))
* fix element being droppable within self children ([b7bdc37](https://github.com/p3ol/oak/commit/b7bdc371bfed3713d4926e26f5596b342edbd99a))
* fix import ([9b9ed65](https://github.com/p3ol/oak/commit/9b9ed651e0687c03bea30a06e26e3169c870f337))
* fix layout issues ([4ffe402](https://github.com/p3ol/oak/commit/4ffe402b9f799f22db02560781f682f20f022fc4))
* fix missing html parsing on paste ([ab92386](https://github.com/p3ol/oak/commit/ab923863078f3194acbb10e4873c96afb8a55607))
* fix missing row drag image ([3804cec](https://github.com/p3ol/oak/commit/3804cec44c75f677ad4092669f345ece1cc9c80e))
* fix settings poppers ([8b77ce5](https://github.com/p3ol/oak/commit/8b77ce5f882f96d96daf9965d2a9d9d990165f8a))
* fix unknown elements appearance ([0aef3c8](https://github.com/p3ol/oak/commit/0aef3c81fdfcc88dcdcea730784f1bf64c2c7af9))
* import junipero styles ([05e55b5](https://github.com/p3ol/oak/commit/05e55b527d7c3d40de435f591174d8e157d8934b))
* **lib:** allow component icon to be a function ([42b7812](https://github.com/p3ol/oak/commit/42b78124faa8bfdbaf714954dcdde9c72a1b6ec5))
* **lib:** fix catalogue layout ([8a68e5a](https://github.com/p3ol/oak/commit/8a68e5a65bf94fb567ce75c585856a01471ad3d8))
* **lib:** fix circular dependency ([a038c00](https://github.com/p3ol/oak/commit/a038c009f6ab124762f60e370af1f1687210a4fb))
* **lib:** fix icon component ([abce43e](https://github.com/p3ol/oak/commit/abce43e628690ae34a1801d63314cdad017bd53b))
* **lib:** fix loop renders on settings ref set ([14a724a](https://github.com/p3ol/oak/commit/14a724a99b83975c9d2f1da31c0d1d3a6dbb8e15))
* **lib:** fix missing edit icon ([6fd4ebc](https://github.com/p3ol/oak/commit/6fd4ebceeb438c86390c655accc0ed08f97a416a))
* **lib:** fix missing junipero styles ([d5c63b2](https://github.com/p3ol/oak/commit/d5c63b224089996f9636a4bbe7eb731ba8a47583))
* **lib:** fix various styling issues ([1be2351](https://github.com/p3ol/oak/commit/1be2351f5c65cca7f4b55e22aeb04165d2d3603b))
* **lib:** fix wrong prop ([b6fb087](https://github.com/p3ol/oak/commit/b6fb0870435def93a41c30673b600b1dd0063b72))
* **lib:** globally fix icons ([3a6bd96](https://github.com/p3ol/oak/commit/3a6bd966f84e87b9a15d560911759b865c2f263b))
* **lib:** replace nanoid with uuid (no crypto dependency) ([4ec70a5](https://github.com/p3ol/oak/commit/4ec70a54a37a81612562d206e080b9c3aee6c0ce))
* **lib:** rework icons ([8dd0f1d](https://github.com/p3ol/oak/commit/8dd0f1dd6c2a03cc604462b0c054c133c2a73e66))
* **lib:** update icons ([203633a](https://github.com/p3ol/oak/commit/203633aa9fbd32f398a137c5250fff6ffa12bdee))
* move col settings popper ([c7d3d94](https://github.com/p3ol/oak/commit/c7d3d9410d7227ca5c1d189a9a86a852c1ce6926))
* move rendering to component level ([0dccf3b](https://github.com/p3ol/oak/commit/0dccf3b742aabf8dc3d053b701d043f0bebd792d))
* **oak:** fix build system ([61607cb](https://github.com/p3ol/oak/commit/61607cb2f72186413dbd759a0a51513dc83ac8b1))
* **oak:** replace options when no displayed to avoid EditBox from being moved ([a178b09](https://github.com/p3ol/oak/commit/a178b093d8fc33b47e14eb9c8813749cb3f80dd4))
* **react:** export hooks ([1bb4647](https://github.com/p3ol/oak/commit/1bb464769dfb687f692f30223942ee83e64b8eaa))
* **react:** fix import ([f6f38af](https://github.com/p3ol/oak/commit/f6f38af2b1ad0cfb7e526907ba8188d6b0f27648))
* **rows:** remove useless css property ([16af99d](https://github.com/p3ol/oak/commit/16af99d055781085dfe3a397bcc7307989afa44d))
* **rows:** switch left and rights arrow from floating to flex ([b515faf](https://github.com/p3ol/oak/commit/b515fafa3aaab932485b0dcb95945f20e480e7ca))
* **row:** use themed colors instead of inline rgb ([4dc3554](https://github.com/p3ol/oak/commit/4dc3554d7bc41529ab4ce65a863950fb322f4902))
* **title:** change default heading Title ([220f6c9](https://github.com/p3ol/oak/commit/220f6c96236660222199808c1c8f1e3ded23e8a9))


### Features

* add basic builder interface ([d7b7e8b](https://github.com/p3ol/oak/commit/d7b7e8b2ffa4ab87d867559b8614925ee0cf48da))
* add basis for catalogue component ([2ba719e](https://github.com/p3ol/oak/commit/2ba719ec39907b065661fc52d953468aad06fcc8))
* add custom options ([4fac22d](https://github.com/p3ol/oak/commit/4fac22d2a3dfc563dba99f01556c09cf3a150d82))
* add fancy rich text editor ([b56b53e](https://github.com/p3ol/oak/commit/b56b53eb0c7b287119f2a497656adc0583aa35cc))
* add flex on rows to enable cols ([d4d8c15](https://github.com/p3ol/oak/commit/d4d8c153637351580fc3f61a91d02a9bb6d38d60))
* add hello world row component ([0d5de35](https://github.com/p3ol/oak/commit/0d5de35bb5ff3b936ab575ad3b831ab698d7fd89))
* add Id for each element ([ad0309d](https://github.com/p3ol/oak/commit/ad0309d458b6c4130591ba513f392fc3a27ce724))
* add settings forms ([604773b](https://github.com/p3ol/oak/commit/604773b6b479b93f12ff376b3a179a6d4c2417f8))
* **addon-basic-components:** add basic editor toolbar ([09ada71](https://github.com/p3ol/oak/commit/09ada7183c8e135b9b8ea28da471777ab45b2c96))
* **addon-basic-components:** add basic image component ([84f7ac8](https://github.com/p3ol/oak/commit/84f7ac8378b0a241be8501006821ed79a11b4637))
* **addon-basic-components:** add button component ([46505a2](https://github.com/p3ol/oak/commit/46505a2c86ff8f50e49711d2caf7c8badbc3b565))
* **addon-basic-components:** add hotkeys ([f8fa82c](https://github.com/p3ol/oak/commit/f8fa82c0a8636ee93a0beb9309096d8bbb78d402))
* **addon-basic-components:** add image name ([cee21e8](https://github.com/p3ol/oak/commit/cee21e8b0f200357254724e0b4bb84f25a44d275))
* baby step, add drag and drop ([4a96b75](https://github.com/p3ol/oak/commit/4a96b758ae4a5aa9243d41866176520d765f3d41))
* **catalogue:** close catalogue when clicking on the cross ([76ac26d](https://github.com/p3ol/oak/commit/76ac26d05865fb3c7b3ce1ea3c2c477a8b4bd72b))
* **catalogue:** set options to invisble instead of display: none, to prevent popper anchor from being undefined ([32eea79](https://github.com/p3ol/oak/commit/32eea79d2af53dd58453d18a35eead4d9f2b2a82))
* **catalogue:** use Aspen inside text options as wysiwyg editor ([640d213](https://github.com/p3ol/oak/commit/640d213bdf342e50fa7b47ce09ce3062091abda4))
* **catalog:** use junipero button for catalog ([95c74c3](https://github.com/p3ol/oak/commit/95c74c33db2293c0bf3c7fccb6ea807a3b909fe5))
* **col:** add min width to prevent col from bein too little ([5f7be48](https://github.com/p3ol/oak/commit/5f7be48acb14670f063061ec8e103729d7c5e5bc))
* **cols:** fix remove on top right of each cols ([687a11c](https://github.com/p3ol/oak/commit/687a11c8c787d18033da468a8943789e702ceacb))
* **cols:** set a flex: 1 for each new cols to fill all the space by default ([54efcd3](https://github.com/p3ol/oak/commit/54efcd332da0fbab7e23135c0eae01176c4e5f4a))
* **cols:** transform placeholder catalog from absolut position to flex positionning ([3c078ce](https://github.com/p3ol/oak/commit/3c078ce1ce5895301643a49906128a4834c25368))
* **css:** delete ugly css ([0d38593](https://github.com/p3ol/oak/commit/0d3859351401503a921c7d32d8085461c498c7b3))
* display all heading level ([cb96b2c](https://github.com/p3ol/oak/commit/cb96b2ca2bba818af528bb5afcd7da33312a7208))
* **DragNdrop:** add component image when dragging ([1aa4ae3](https://github.com/p3ol/oak/commit/1aa4ae36b511c742f657e52df06883b490534139))
* **dragNdrop:** add dropping on empty column ([cd33c47](https://github.com/p3ol/oak/commit/cd33c47dbde7f673b8a857807c5ee3104f707651))
* **dragNdrop:** add indicator on dragover ([6d80656](https://github.com/p3ol/oak/commit/6d806568c0f6c3bf164cae5b40c0a28b0ad81efd))
* **dragNdrop:** move functions and repair behavior ([b48d1c8](https://github.com/p3ol/oak/commit/b48d1c88e117c6d9855ddd1a451329b615e2b664))
* **edit:** bigger z-index ([c207bb4](https://github.com/p3ol/oak/commit/c207bb4c34d0099e0bfe91d4d3790ab33e1cc92a))
* **editor:** disable drop on editor ([33b3fa2](https://github.com/p3ol/oak/commit/33b3fa25c22360db29f4fcb9a289b2b78ce18c04))
* **edit:** prevent edit box from being behind content ([7c76617](https://github.com/p3ol/oak/commit/7c766170253f6eb5d25260b67cb650beb2150904))
* enable row drag & drop ([0fa68a2](https://github.com/p3ol/oak/commit/0fa68a2e2f985f4be41ac899708e11676e6553f6))
* filter by id on dropping ([d3dfd34](https://github.com/p3ol/oak/commit/d3dfd349086f78227be70a3e02ece19464c07100))
* fix colors and use html button instead of juniperos ones ([c6e0e13](https://github.com/p3ol/oak/commit/c6e0e13bd198a6b23c8c4bdac389a54249b5920e))
* **font:** add oak ico font ([d171169](https://github.com/p3ol/oak/commit/d171169709db2834a2edcd764c933b1a5cc8de7b))
* **fonts:** add Icon component ([6ff16db](https://github.com/p3ol/oak/commit/6ff16dbc868fe199d5cd09eabfec7b67f708adb4))
* **fonts:** add liga to new icons ([ea2a94b](https://github.com/p3ol/oak/commit/ea2a94b7337865c8c34b1de20d241baf2818e181))
* **fonts:** add new icons to font ([ac41f31](https://github.com/p3ol/oak/commit/ac41f31ec2e7dbbff1710806d508e1c170493f9d))
* **fonts:** material icons is unused, so preview head is too ([8691b39](https://github.com/p3ol/oak/commit/8691b39a400755115d837599f5130b132e64d6d0))
* **fonts:** use clear instead of close because its same logo ([79e793f](https://github.com/p3ol/oak/commit/79e793ffab03eea13ac76311d4dbe9461f5c5f2d))
* **fonts:** use custom fonts insead of material icons ([9dac179](https://github.com/p3ol/oak/commit/9dac179a99eb37d9e4b47ee8cc97c67a596b7961))
* **fonts:** use oak ico on catalogue ([0750bbb](https://github.com/p3ol/oak/commit/0750bbb77ed6be881f5b5d323b086d78d51e8735))
* improve title display ([b5e64a9](https://github.com/p3ol/oak/commit/b5e64a93cc8d04ab18eb7f4229bc89b1f57937f1))
* **lib:** add button icon ([05b2cd7](https://github.com/p3ol/oak/commit/05b2cd7606c80833ce5d5ec045f7203837b1c273))
* **lib:** add useElement hook ([dd589ea](https://github.com/p3ol/oak/commit/dd589eae446995566b9edfb9291b51dd3830f90a))
* **lib:** enable element de/serialization on init ([a3b0f7c](https://github.com/p3ol/oak/commit/a3b0f7ccb9f5545d1f91a77d1b878f9437813ed7))
* **lib:** enable field condition ([3076a11](https://github.com/p3ol/oak/commit/3076a112facd0ce3699a21c007620d82ecd3ef16))
* **modals:** add customization for modals, and style for differents placements ([ae1646f](https://github.com/p3ol/oak/commit/ae1646f843d85e6a4814248e2f2b970a61faf417))
* **modals:** add customize options for title ([f571605](https://github.com/p3ol/oak/commit/f571605dcc3251715f0f34e3bbd2acc543ec27d3))
* **modals:** hide modal onScroll when mouse is not hovering element to prevent it from being attached to nothing ([52270fc](https://github.com/p3ol/oak/commit/52270fcd3ce11eef87a23a43648024dbae6c71cf))
* move delete from bottom to up rightt ([33c0908](https://github.com/p3ol/oak/commit/33c09085e38b9ed92e26586de94c79faa3050081))
* move from chevron to + sign to respect figma ([a9947aa](https://github.com/p3ol/oak/commit/a9947aafb982e3e2248c140d1beef88bf90daebb))
* **oak:** add nested rows ability ([0ac2509](https://github.com/p3ol/oak/commit/0ac25093aaebacb799cd92dad2bbcd7658d70bae))
* **oak:** add preventDefault on <a> click ([ddefd57](https://github.com/p3ol/oak/commit/ddefd576f02e4100bbc98e7b196483865156c850))
* **oak:** change default font weight for titles ([5658f79](https://github.com/p3ol/oak/commit/5658f79963ad14ea7801820acf9107baad2bbda0))
* **oak:** lint catalog ([685c245](https://github.com/p3ol/oak/commit/685c245a443c603067b715adb609fae79501c5ca))
* **oak:** make edit global and use composition to populate it ([fbaa092](https://github.com/p3ol/oak/commit/fbaa092190fc386984ba04a8675dcbd448483cc1))
* **oak:** move text options ([aa78aa7](https://github.com/p3ol/oak/commit/aa78aa791fd7d1afb9719da81a98b341dc2baa69))
* **oak:** move title options ([f83631d](https://github.com/p3ol/oak/commit/f83631db2e62c0934ffe3667ed0fc538a1a8e7e6))
* **oak:** repair base content ([3a572d6](https://github.com/p3ol/oak/commit/3a572d62e7f385a1e17273d01a0e9f95df5318b6))
* **oak:** rewrite css files ([92c7aef](https://github.com/p3ol/oak/commit/92c7aef4898dd27f1b97cd2ea670f5657c153e1f))
* **options:** display option correctly whether its a row or another element ([97b7814](https://github.com/p3ol/oak/commit/97b781469ac41037d782019211646e5dde8d75ac))
* **options:** replace hovered options ([73fd707](https://github.com/p3ol/oak/commit/73fd707542f0b5fa0108de5e47a19c080bf97929))
* **page builder:** add title component ([b79ea02](https://github.com/p3ol/oak/commit/b79ea02bf8e47aa8ef1e439b79091f55956c8ce5))
* **popper:** add pedit popper on every component, for testing purposes ([e30fe8a](https://github.com/p3ol/oak/commit/e30fe8a62aa71540c5031d9f6770d38e19e98739))
* prepare wysiwyg ([dff5595](https://github.com/p3ol/oak/commit/dff5595bddb0745756f621b2f8933d96b7f42fc9))
* **react:** handle changes ([59258e1](https://github.com/p3ol/oak/commit/59258e177270964b0e2fcbb82b862e63da705bff))
* remove useless import ([77f9364](https://github.com/p3ol/oak/commit/77f936435d798f590652ace2cc60f95475dd8e1b))
* **row:** add customization on rows ([008c192](https://github.com/p3ol/oak/commit/008c192650ee30d4741f5053c77c800f818b7c2d))
* **row:** adjust vertical alignment ([75edd43](https://github.com/p3ol/oak/commit/75edd431546e450f2a2104df9c90e26f761722cf))
* **row:** change color of bean ([be85a9c](https://github.com/p3ol/oak/commit/be85a9c23a22976b4fd4bdbbc61b5d5a302bc0b5))
* **rows:** 2nd proposal for horizontal alignment, applied for all elements ([34961f2](https://github.com/p3ol/oak/commit/34961f20500506c96b08cfea74d53541091d0faa))
* **rows:** add fixed width and redesign style opstion ([a3f89ae](https://github.com/p3ol/oak/commit/a3f89ae51b4ea12220f07c1df6903504b12e3189))
* **rows:** add flex personalisation and remove min-width ([5e1ab54](https://github.com/p3ol/oak/commit/5e1ab540e8e74b4ebc06e02c86ecf90c919725b3))
* **rows:** add horizontal alignment ([68fbbdd](https://github.com/p3ol/oak/commit/68fbbdd5c1f7e695562546a2fd6c0864470ce22e))
* **rows:** add style for lateral division, arrows and allow puhing element on top and bottom ([64d21a1](https://github.com/p3ol/oak/commit/64d21a1adba7141cab9c25925fafb15d75b8023b))
* **rows:** app possibility to unshift instead of push element ([49fd436](https://github.com/p3ol/oak/commit/49fd436b0119194945280239860f6f9674059831))
* **rows:** delete rows if there is no more col inside of it ([90359ec](https://github.com/p3ol/oak/commit/90359ec30587ff9755ae9f2d580ced0ce442fd40))
* **rows:** enable horizontal alignement for rows too -  might be improved ([9a79018](https://github.com/p3ol/oak/commit/9a79018b235ca1cb8f6eeeef01e3edef71cd8aae))
* **rows:** force the edit icon to be on top ([421e8c7](https://github.com/p3ol/oak/commit/421e8c7a20f24b37c97e9715cd79aa85c87b41bd))
* **rows:** improve display ([0b96adb](https://github.com/p3ol/oak/commit/0b96adb899e2d249d6db0d81796420c458243a90))
* **rows:** improve rows display and add the possibility to switch vertical alignement of a content ([e0262de](https://github.com/p3ol/oak/commit/e0262dee3960f9089d9787aa0453016fba24ccfd))
* **rows:** move delete button from popper to rows display and close popper when outside click is fired ([3ef4cf3](https://github.com/p3ol/oak/commit/3ef4cf34fd977cd7ae75a10b30abff6af0ab4d4e))
* **rows:** put alignment on style object and delete useless code ([943f0d1](https://github.com/p3ol/oak/commit/943f0d1ddeaf9e0851b433de75d0e5aa53797ca4))
* **rows:** remove useless className ([d278331](https://github.com/p3ol/oak/commit/d27833196e919ee7a2e3badfdde601d91205f750))
* **rows:** remove useless margin and center content ([8a60562](https://github.com/p3ol/oak/commit/8a60562d3419767f7ba587520064dd049695d3db))
* **rows:** reorganize row to implement new styles ([faec54c](https://github.com/p3ol/oak/commit/faec54cea1c07cf416164875120cfb620b96cbc6))
* **rows:** switch from old absolute top and bottom rows to flex display ([a8c8211](https://github.com/p3ol/oak/commit/a8c8211fd82359187fb10db954c10771d6dab90d))
* **rows:** TEST: switch lateral gutters and horizontal borders in flex display ([503d414](https://github.com/p3ol/oak/commit/503d4140d6ae62b0566c8acb72fa96c92a17f4fc))
* **rows:** update col style to fit with figma ones ([265594c](https://github.com/p3ol/oak/commit/265594c97201f1e509f5cd396a29c3cbe2ebe8eb))
* test a big loading with custom options ([f66b429](https://github.com/p3ol/oak/commit/f66b429723ea7c966f35fc650026ed8cf650935b))
* **text:** add text component ([2638d61](https://github.com/p3ol/oak/commit/2638d61d5be27f73b2bc9f601d69c116cdc44479))
* **textEditor:** add textEditor component to oak ([a81dfe2](https://github.com/p3ol/oak/commit/a81dfe215ee487d2521cc9fb97a17d77b33622d2))
* **texts:** add customization to texts ([fcea3c1](https://github.com/p3ol/oak/commit/fcea3c1df8303a0f2e04372fdd01ab0abee7b74b))
* **title:** add customization on title modal ([48cf2d1](https://github.com/p3ol/oak/commit/48cf2d1fbb2add95c1b196c59dcfe5ef09393e7f))
* use LayoutEffect instead of useEffect to trigger on first loading ([8500aca](https://github.com/p3ol/oak/commit/8500acaa5bdb57412cdadc5a9b9f3b01adcbe793))
* **wysiwyg:** enable Aspen for title ([3d1908d](https://github.com/p3ol/oak/commit/3d1908dc39d6c4cbc98fc9d914d2b7ff1cc3d599))
* **z-index:** finally fix the broken z-index, by placing popover on root of the dom, (translate3d was the fucker) ([9890900](https://github.com/p3ol/oak/commit/98909007f3788bc3269e66eb2792609e20477e60))
