<div align="center">

<picture>
  <source media="(prefers-color-scheme: dark)" srcset="https://cdn.junipero.design/images/oak-logo-light.svg" />
  <img src="https://cdn.junipero.design/images/oak-logo.svg" height="50" />
</picture>

<br />
<br />

[![GitHub](https://img.shields.io/github/license/p3ol/oak.svg)](https://github.com/p3ol/oak)
[![CI](https://github.com/p3ol/oak/workflows/CI/badge.svg)](https://github.com/p3ol/oak/actions)
[![codecov](https://codecov.io/gh/p3ol/oak/branch/master/graph/badge.svg)](https://codecov.io/gh/p3ol/oak)

<p>A modern, lightweight &amp; modulable block-based builder for the modern web</p>

</div>

# Packages

| Name | Description | |
| :-- | :-- | :-- |
| `@oakjs/react` | A render for React | [documentation](https://github.com/p3ol/oak/blob/master/packages/react) |
| `@oakjs/theme` | A base theme for Oak | [documentation](https://github.com/p3ol/oak/blob/master/packages/theme) |
| `@oakjs/addon-remirror` | WYSIWYG text field for the React renderer using [Remirror](https://remirror.io/) | [documentation](https://github.com/p3ol/oak/blob/master/packages/addon-remirror) |
| `@oakjs/addon-ckeditor5-react` | WYSIWYG text field for the React renderer using [CKEditor 5](https://ckeditor.com/ckeditor-5/) | [documentation](https://github.com/p3ol/oak/blob/master/packages/addon-ckeditor5-react) |
| `@oakjs/strapi-plugin` | A plugin to add a custom Oak field to [Strapi](https://strapi.io/) | [documentation](https://github.com/p3ol/oak/blob/master/packages/strapi-plugin) |
| `@oakjs/core` | The core of the famous builder | [documentation](https://github.com/p3ol/oak/blob/master/packages/core) |

# Documentation

The documentation of each package is available in the `README.md` file of the said package.

# Development

Install dependencies:

```bash
yarn install
```

Run examples with Storybook:

```bash
yarn serve
```

# Contributing

[![](https://contrib.rocks/image?repo=p3ol/oak)](https://github.com/p3ol/oak/graphs/contributors)

Please check the [CONTRIBUTING.md](https://github.com/p3ol/oak/blob/master/CONTRIBUTING.md) doc for contribution guidelines.


# License

This software is licensed under [MIT](https://github.com/p3ol/oak/blob/master/LICENSE).
