# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

# [3.15.0](https://github.com/p3ol/oak/compare/v3.14.5...v3.15.0) (2025-12-03)


### Bug Fixes

* add background preview on all elements ([737b1bb](https://github.com/p3ol/oak/commit/737b1bbb9834cb53a74f0511e0ea1906a823627b))
* import order and type fix ([2befa0f](https://github.com/p3ol/oak/commit/2befa0fd1eaafba2676e4d9b9214ca2bff36a9d9))
* import type ([6002e80](https://github.com/p3ol/oak/commit/6002e80020995b33cd904084e41b7e234ddb8bc1))
* **react:** fix drag option element type & conditions ([69386d2](https://github.com/p3ol/oak/commit/69386d2a5894867933262140fe103a1600a6fc67))
* repair mutli keys setting behavior ([d20b486](https://github.com/p3ol/oak/commit/d20b48690f1b8f53186ff7872853200843311b91))
* rework serializing overrides ([dbf6a58](https://github.com/p3ol/oak/commit/dbf6a58bdd625a56cbec34a61ff0ffc0ff2583ad))
* types ([0cc7103](https://github.com/p3ol/oak/commit/0cc7103e564db24798e37538b7a18ef5b5149fc1))
* types ([3eec792](https://github.com/p3ol/oak/commit/3eec792b10bcfb2352f55c4641580ea6891b5a71))
* update various deps ([32c2dbe](https://github.com/p3ol/oak/commit/32c2dbe3eadf29f01466b2f7aa4e66df27c0a722))
* upgrade various deps ([6d82950](https://github.com/p3ol/oak/commit/6d82950c0704e00a021a7acbce25d6c620f24553))
* use FormState generic instead of useReducer generic itself ([9c1baf2](https://github.com/p3ol/oak/commit/9c1baf2ed0534f0a608d188878f95f9ba922c382))


### Features

* allow to edit image field url ([03cb1f1](https://github.com/p3ol/oak/commit/03cb1f197ef99f33a7fe22f72c761c8061230b2e))
* **field-override:** apply serialize and unserialize on fields ([d742eb2](https://github.com/p3ol/oak/commit/d742eb29ed5c4d5fde30bafcffbd6ffb4f2eaf0a))
* **field-override:** rename unserialize to deserialize and other PR review changes ([f26276c](https://github.com/p3ol/oak/commit/f26276c51103b845ef6f69aed33e3f89cb8b26ca))
* **field-override:** rework serialize and unserialize ([66624fd](https://github.com/p3ol/oak/commit/66624fdb097310eef72ec6c83fb168978fb85acd))
* **react:** add a way to disable cols addition ([e712009](https://github.com/p3ol/oak/commit/e712009b375598db3960902ec3226c1f9ece3502))
* **react:** add a way to disable the catalog ([11e1fd7](https://github.com/p3ol/oak/commit/11e1fd7b70ca2eadc1c0b8458fa6a1f0c1451c02))
* **react:** add removable as override option ([1c55cfc](https://github.com/p3ol/oak/commit/1c55cfc114b20e0e85fe6884983e70bffaa752b9))
* **react:** also disable drag in component option ([2cd2b7b](https://github.com/p3ol/oak/commit/2cd2b7b9b9dd6dac4b40670e86291420e0a5db26))





## [3.14.5](https://github.com/p3ol/oak/compare/v3.14.4...v3.14.5) (2025-10-23)


### Bug Fixes

* vitest compat ([dc5a951](https://github.com/p3ol/oak/commit/dc5a951745fd213ec366e4782940028f43ecf22f))





## [3.14.4](https://github.com/p3ol/oak/compare/v3.14.3...v3.14.4) (2025-10-22)


### Bug Fixes

* update various deps ([f559cce](https://github.com/p3ol/oak/commit/f559cce007bc2afc02ecb7a8701f1511030278a0))





## [3.14.3](https://github.com/p3ol/oak/compare/v3.14.2...v3.14.3) (2025-09-22)


### Bug Fixes

* correctly allow to use dynamic options with react builder ([1cc925a](https://github.com/p3ol/oak/commit/1cc925ac464835b57aa6b34104a7a57b62d595b5))
* update various deps ([1866ea9](https://github.com/p3ol/oak/commit/1866ea94af7ddb5034cda6cfb6c7bd473be3741f))





# [3.14.0](https://github.com/p3ol/oak/compare/v3.13.1...v3.14.0) (2025-09-11)


### Bug Fixes

* upgrade various deps ([9281b2f](https://github.com/p3ol/oak/commit/9281b2f7722babbdd078e0d0f1feee568adbeaa3))


### Features

* add new accessibility tab ([e527e9b](https://github.com/p3ol/oak/commit/e527e9b7d37cd50054e293e9ae678be3c75944a6))





# [3.13.0](https://github.com/p3ol/oak/compare/v3.12.5...v3.13.0) (2025-07-31)


### Bug Fixes

* migrate to eslint 9 ([fdd642c](https://github.com/p3ol/oak/commit/fdd642c757bf1c8c2c3e71a9b51069a005b31317))
* type issues ([59df745](https://github.com/p3ol/oak/commit/59df745294f0b2265e51e15b651d2196dc71783d))
* update various deps ([a2e1309](https://github.com/p3ol/oak/commit/a2e1309d9cb106fb391af6a92ebaca4ba11d9696))
* upgrade various deps ([afe9fe0](https://github.com/p3ol/oak/commit/afe9fe06bf13fae2e79426a6236d28723773d22b))


### Features

* bump node requirement to v22 ([ba9de95](https://github.com/p3ol/oak/commit/ba9de95da47ae53a49b362f598f92f5922bead84))
* extends ComponentOverrideObject interface with reactNode display return type ([c0267bd](https://github.com/p3ol/oak/commit/c0267bd6a618b782a795138f328bedfdcdd8b358))
* **fields:** add a field custom display function to personalize field display on component ([7180f01](https://github.com/p3ol/oak/commit/7180f019ea65f9802272642b63e5a166d6d431dc))





## [3.12.5](https://github.com/p3ol/oak/compare/v3.12.4...v3.12.5) (2025-06-17)


### Bug Fixes

* missing field props from setting addon ([c7a034a](https://github.com/p3ol/oak/commit/c7a034afa02b525af13226e782adeb1c5b6151e5))





## [3.12.4](https://github.com/p3ol/oak/compare/v3.12.3...v3.12.4) (2025-06-11)


### Bug Fixes

* better override fallback ([c0a795d](https://github.com/p3ol/oak/commit/c0a795dc22ce6a9aa8ee82217d8b9c2bfe3c1d60))
* **react:** allow to override tabs ([3e37775](https://github.com/p3ol/oak/commit/3e37775f6d6b35b8cbd05d53a71b1f114fea27b1))





## [3.12.3](https://github.com/p3ol/oak/compare/v3.12.2...v3.12.3) (2025-06-11)


### Bug Fixes

* add story ([392c5f1](https://github.com/p3ol/oak/commit/392c5f1124798e1a086e41c8c62589448422e41a))
* force setting type to null if useless ([6ed6202](https://github.com/p3ol/oak/commit/6ed6202251eb5410be6c8f9ba540558b4f6a77e2))
* **settings:** add component overrides on setting display condition ([fa6b314](https://github.com/p3ol/oak/commit/fa6b314c7e4701a8d959ae058cf5bae8a8d3eee9))





## [3.12.2](https://github.com/p3ol/oak/compare/v3.12.1...v3.12.2) (2025-04-15)


### Bug Fixes

* **react:** remove xmlns attribute in serialized string ([b9eae32](https://github.com/p3ol/oak/commit/b9eae3220a35caa99d2fb9e21f62f78fd51d592f))





## [3.12.1](https://github.com/p3ol/oak/compare/v3.12.0...v3.12.1) (2025-03-13)


### Bug Fixes

* add story ([d810acb](https://github.com/p3ol/oak/commit/d810acbee27c94b7a2e3f3623ec55dbd47b901d4))
* **catalogue:** refresh catalogue when addon change ([c678f8a](https://github.com/p3ol/oak/commit/c678f8aa7ea55b5ad7f3938b42c9c5e8c8b04ef8))





# [3.12.0](https://github.com/p3ol/oak/compare/v3.11.2...v3.12.0) (2025-02-03)


### Bug Fixes

* update various deps ([35577a9](https://github.com/p3ol/oak/commit/35577a9de01741dd91d978db80fd7a9bd05bb5a0))


### Features

* **settings:** allow to pass function to default value prop ([c899cf1](https://github.com/p3ol/oak/commit/c899cf1921f40a1e1de04fd31329a6264adf95f4))
* **settinhs:** remove useless log ([441fec4](https://github.com/p3ol/oak/commit/441fec4952a7ce539d4dd154f52a307422d2c979))





## [3.11.2](https://github.com/p3ol/oak/compare/v3.11.1...v3.11.2) (2024-12-17)


### Bug Fixes

* **react:** type issues ([ae56c84](https://github.com/p3ol/oak/commit/ae56c843308eb8b5187c8b5476e73a0122aee978))





# [3.11.0](https://github.com/p3ol/oak/compare/v3.10.9...v3.11.0) (2024-12-16)


### Bug Fixes

* **react:** various type issues ([2d84333](https://github.com/p3ol/oak/commit/2d843336cbffcce598b043925ddc774229ce2fcc))
* update junipero version ([2d3aa1d](https://github.com/p3ol/oak/commit/2d3aa1d8f5002e63e1632d4bf386b16ecbe29f31))
* upgrade a lot of deps ([2f162dd](https://github.com/p3ol/oak/commit/2f162ddfe10e2b384e4644d4828c532919158b88))
* upgrade various deps ([883baa5](https://github.com/p3ol/oak/commit/883baa541a7ab9a083f3a9b47c2fdc9cf58ab33d))



# [3.11.0-beta.0](https://github.com/p3ol/oak/compare/v3.10.5...v3.11.0-beta.0) (2024-10-29)


### Bug Fixes

* upgrade various deps ([00dbd10](https://github.com/p3ol/oak/commit/00dbd102b0fe2b58e579756b63ad9300b5199e2d))


### Features

* handle react 19 ([fe75825](https://github.com/p3ol/oak/commit/fe75825c0ac7df4d0e8ff8a01da8838c77487c51))





## [3.10.9](https://github.com/p3ol/oak/compare/v3.10.8...v3.10.9) (2024-11-18)


### Bug Fixes

* **react:** correctly apply overrides targeting single or multiple field keys ([46d8fef](https://github.com/p3ol/oak/commit/46d8fefcc75f2a4a400b70093d38c73e98b8e3ac))
* **react:** correctly apply setting overrides ([e05c48c](https://github.com/p3ol/oak/commit/e05c48cff1f030760d4ad9501a50b6a94642ffbf))
* **react:** correctly handle field with multiple keys for component overrides ([4685ef6](https://github.com/p3ol/oak/commit/4685ef6087cc417154d7c9f9c8efc9c9ff162533))





## [3.10.8](https://github.com/p3ol/oak/compare/v3.10.7...v3.10.8) (2024-11-12)


### Bug Fixes

* title with expand option ([b43bb9d](https://github.com/p3ol/oak/commit/b43bb9d16c27257611ead5e9ad9631c60995a97b))





## [3.10.7](https://github.com/p3ol/oak/compare/v3.10.6...v3.10.7) (2024-11-12)


### Bug Fixes

* date field value not being a date ([ad2ddef](https://github.com/p3ol/oak/commit/ad2ddefe37c285eb417cb450da4e1a972c943f91))





## [3.10.6](https://github.com/p3ol/oak/compare/v3.10.5...v3.10.6) (2024-11-07)


### Bug Fixes

* add root node to html sanitizer ([2f4c967](https://github.com/p3ol/oak/commit/2f4c967ddaffb28d65676dd9066b9c98f3e374b9))
* upgrade various deps ([3f01c8a](https://github.com/p3ol/oak/commit/3f01c8a202bd69a45a73ae2748bcef98e8bf1c6a))





## [3.10.5](https://github.com/p3ol/oak/compare/v3.10.4...v3.10.5) (2024-10-25)


### Bug Fixes

* make col droppable again ([d9a9439](https://github.com/p3ol/oak/commit/d9a9439402ea1318f7ea5b7c1f1625b3e5be6353))





## [3.10.4](https://github.com/p3ol/oak/compare/v3.10.3...v3.10.4) (2024-10-25)


### Bug Fixes

* **react:** allow to use polyfills to parse html ([c057a75](https://github.com/p3ol/oak/commit/c057a75f830eab7b47de9e8098b6b7c711b7f8e2))





## [3.10.3](https://github.com/p3ol/oak/compare/v3.10.2...v3.10.3) (2024-10-25)


### Bug Fixes

* **react:** don't pre-filter fields they are already filtered deeper ([142681c](https://github.com/p3ol/oak/commit/142681cf7b6233e5641408ac16f79f59afa25bdc))





## [3.10.2](https://github.com/p3ol/oak/compare/v3.10.1...v3.10.2) (2024-10-22)


### Bug Fixes

* modal editable option wrongly wrapped inside a div ([6f8a98c](https://github.com/p3ol/oak/commit/6f8a98cdc32acc20877a233a7a3554998116a407))





## [3.10.1](https://github.com/p3ol/oak/compare/v3.10.0...v3.10.1) (2024-10-22)


### Bug Fixes

* correctly handle drag & drop ([07ebcd0](https://github.com/p3ol/oak/commit/07ebcd0bd0a3bf202eed5d33ef50267af9574022))
* upgrade various deps ([c29eeff](https://github.com/p3ol/oak/commit/c29eeff71a9db299242bfe963689d37258e50ea6))





# [3.10.0](https://github.com/p3ol/oak/compare/v3.9.1...v3.10.0) (2024-10-15)


### Bug Fixes

* correctly handle non droppable ([a330e99](https://github.com/p3ol/oak/commit/a330e9914381f5a76c020a7369ab0e080ab552a1))
* upgrade various deps ([f23b00b](https://github.com/p3ol/oak/commit/f23b00b6c9cca4d850bc2bf5418bbd8ab2ab821c))


### Features

* allow to disallow duplication & copy ([6f47b1d](https://github.com/p3ol/oak/commit/6f47b1de621270cd24b6326d29ac1206cbc35012))
* also allow to override draggable & droppable ([08b34d9](https://github.com/p3ol/oak/commit/08b34d9cf1a0e277c6577a714777337a8668260b))





## [3.9.1](https://github.com/p3ol/oak/compare/v3.9.0...v3.9.1) (2024-10-11)


### Bug Fixes

* **react:** fix types ([7e609a3](https://github.com/p3ol/oak/commit/7e609a3537df83ac2d1d7bc3bb29cb5d44cdf613))





# [3.9.0](https://github.com/p3ol/oak/compare/v3.8.5...v3.9.0) (2024-10-11)


### Bug Fixes

* **react:** correctly render element, options & fields ([ada4d56](https://github.com/p3ol/oak/commit/ada4d564e0086f469b7214912b390b5a1c3a8875))


### Features

* **collapse-blocks:** use context instead of value in element ([2a0d252](https://github.com/p3ol/oak/commit/2a0d252c0d7a96cfdbabb36ff4db639c36aa5da5))
* indent ([512df56](https://github.com/p3ol/oak/commit/512df56e9762c6ad51f852b0ab142998dbefad32))
* **react:** add a collapse option for inner content blocks on builder ([70cb6eb](https://github.com/p3ol/oak/commit/70cb6eb30f38c0e940bcc97039c30afddd5ec699))
* **react:** add unfold from element himself ([08df68d](https://github.com/p3ol/oak/commit/08df68dd03b71d961a4f9ddb328c568968ce0491))
* **react:** make the whole element clickable and add cursor: pointer ([8a86c5e](https://github.com/p3ol/oak/commit/8a86c5e3e25c8ad5b4b330425e302ba13d7455f1))
* rework wordings and display ([e2772aa](https://github.com/p3ol/oak/commit/e2772aa8735b0478ce1420039bb33822daf3dbd8))
* update snapshots ([f92a6c4](https://github.com/p3ol/oak/commit/f92a6c452d3b6870d12b1e62210efcf39e62c67c))
* update test snapshots ([5335e05](https://github.com/p3ol/oak/commit/5335e0582fd98d332d398247219a4fa66717e315))





## [3.8.5](https://github.com/p3ol/oak/compare/v3.8.4...v3.8.5) (2024-10-09)


### Bug Fixes

* **fields-setting:** remove key from file override ([98a1d5e](https://github.com/p3ol/oak/commit/98a1d5e68b4cf93fa46c0d6a5fd667156d90c07b))





## [3.8.4](https://github.com/p3ol/oak/compare/v3.8.3...v3.8.4) (2024-09-27)


### Bug Fixes

* correctly condition settings groups ([7c39323](https://github.com/p3ol/oak/commit/7c39323e06e3355566077d594c5fb953fc19d286))





## [3.8.3](https://github.com/p3ol/oak/compare/v3.8.2...v3.8.3) (2024-09-27)


### Bug Fixes

* don't overwrite overrides' fields with wrong fields overrides ([e06e129](https://github.com/p3ol/oak/commit/e06e129fbf4476ebe20961e5cb6316e9b52c834e))





## [3.8.2](https://github.com/p3ol/oak/compare/v3.8.1...v3.8.2) (2024-09-27)


### Bug Fixes

* fields sorting breaking rule of hooks ([cee5819](https://github.com/p3ol/oak/commit/cee5819e45d261a4f7160e95e71539f68cb28490))





# [3.8.0](https://github.com/p3ol/oak/compare/v3.7.13...v3.8.0) (2024-09-26)


### Bug Fixes

* upgrade various deps ([825c9a1](https://github.com/p3ol/oak/commit/825c9a1c8bd19fe8ea85d0e8aa20f2d25b201f0d))


### Features

* add hover & active styling settings ([50c907c](https://github.com/p3ol/oak/commit/50c907c01bfcc9aae54d1f611c3d1388bfc70c51))





## [3.7.13](https://github.com/p3ol/oak/compare/v3.7.12...v3.7.13) (2024-09-25)


### Bug Fixes

* **react:** wrongly displayed override missing labels ([e63cc31](https://github.com/p3ol/oak/commit/e63cc31e677b7efa744c63a2be5d97e2204f0e0c))





## [3.7.11](https://github.com/p3ol/oak/compare/v3.7.10...v3.7.11) (2024-09-24)


### Bug Fixes

* correctly handle custom fields from component overrides ([1fec064](https://github.com/p3ol/oak/commit/1fec06425102b735d39d2815b04400837f30cd49))
* missing tags field helper ([254eeb1](https://github.com/p3ol/oak/commit/254eeb1f7de4895211098224c5bc00ee65875df7))
* prevent incorrect displayable settings ([a0b842f](https://github.com/p3ol/oak/commit/a0b842f6e8316052c588ae84b796356a900db6fe))
* upgrade various deps ([67f46fd](https://github.com/p3ol/oak/commit/67f46fd85170e238738ebcf7cbb8b213612ca44f))





## [3.7.10](https://github.com/p3ol/oak/compare/v3.7.9...v3.7.10) (2024-09-17)


### Bug Fixes

* **theme:** allow to scroll inside catalogue's tabs ([0177e74](https://github.com/p3ol/oak/commit/0177e748cd9ad4a2760bbd79dfaccf8e89f051df))





## [3.7.9](https://github.com/p3ol/oak/compare/v3.7.8...v3.7.9) (2024-09-11)


### Bug Fixes

* upgrade various deps ([b1980e1](https://github.com/p3ol/oak/commit/b1980e14906244300abd58797d968b54770d9dfb))





## [3.7.8](https://github.com/p3ol/oak/compare/v3.7.7...v3.7.8) (2024-09-09)


### Bug Fixes

* correctly allow field type override ([9501038](https://github.com/p3ol/oak/commit/9501038a7db69c4eae5dcd338b87a97bc43ebfaa))
* upgrade various deps ([90ef401](https://github.com/p3ol/oak/commit/90ef40157ffd787cb43b2cf0fd27c30f18444c83))





## [3.7.7](https://github.com/p3ol/oak/compare/v3.7.6...v3.7.7) (2024-08-01)


### Bug Fixes

* **deps:** update dependency @floating-ui/react to v0.26.20 ([72b4e14](https://github.com/p3ol/oak/commit/72b4e14475e6d93b709eedb6ded42b32628ffdbd))
* **deps:** update poool junipero monorepo to v3.7.3 ([b23fff5](https://github.com/p3ol/oak/commit/b23fff574b17b2ebc25c1a19ee7cd30dcfa7c430))
* **drag-drop:** remove the verification on disallow for siblings on drop ([da68891](https://github.com/p3ol/oak/commit/da688919f5b34e46ccee77069fc0676af1ca28bf))
* **oak-elements:** set options ont top left for every components that have a custom inner content ([f06c8d3](https://github.com/p3ol/oak/commit/f06c8d30a3f808d5ad14b1c16f13a834b8f2fb6a))
* **options:** rename className for innerContent ([a22171a](https://github.com/p3ol/oak/commit/a22171a9ec90da3e6805d2a9f3b43516f09639e5))





## [3.7.6](https://github.com/p3ol/oak/compare/v3.7.5...v3.7.6) (2024-07-19)


### Bug Fixes

* update various deps ([a670ecb](https://github.com/p3ol/oak/commit/a670ecb49f19d1c2425330726a320bcd6685eb64))





## [3.7.5](https://github.com/p3ol/oak/compare/v3.7.4...v3.7.5) (2024-07-16)


### Bug Fixes

* upgrade various deps ([48cf2bc](https://github.com/p3ol/oak/commit/48cf2bc25a98a01cc119dac7baad812b6897db1d))





## [3.7.4](https://github.com/p3ol/oak/compare/v3.7.3...v3.7.4) (2024-07-10)


### Bug Fixes

* **react:** correctly handle disallow from overrides ([0c216aa](https://github.com/p3ol/oak/commit/0c216aa2739b9b2ecf364af33d4b5601b41c8571))





## [3.7.3](https://github.com/p3ol/oak/compare/v3.7.2...v3.7.3) (2024-07-10)

**Note:** Version bump only for package @oakjs/react





## [3.7.1](https://github.com/p3ol/oak/compare/v3.7.0...v3.7.1) (2024-07-08)


### Bug Fixes

* various modal editable style issues ([29dc187](https://github.com/p3ol/oak/commit/29dc187476e7a219780666d1443ccea3bd8fe997))





# [3.7.0](https://github.com/p3ol/oak/compare/v3.6.10...v3.7.0) (2024-07-08)


### Bug Fixes

* **deps:** update dependency @floating-ui/react to v0.26.18 ([e7f1448](https://github.com/p3ol/oak/commit/e7f1448f789851a48dcdd7a93d50c4d1b32856ec))
* **deps:** update dependency @floating-ui/react to v0.26.19 ([12b39ba](https://github.com/p3ol/oak/commit/12b39ba68d8e9ecb94c17876d2aff2335ab103b0))
* **editable:** clean code ([1434707](https://github.com/p3ol/oak/commit/1434707bb06132e9b5601c73428d31a697cb97d6))
* **editable:** clean import ([e223fd0](https://github.com/p3ol/oak/commit/e223fd0a1f4ebe2bb2c59d2e5853b6223b7612c2))
* **editable:** clean type of onclick function ([40c1747](https://github.com/p3ol/oak/commit/40c17476b288e64bdb35f042d2b2e956ebae7035))
* **react:** correctly apply settings overrides ([4e27d9e](https://github.com/p3ol/oak/commit/4e27d9eacd282ab1e61d5c20184cfa88019d4b7e))
* **react:** correctly render displayable properties ([1a04cbb](https://github.com/p3ol/oak/commit/1a04cbb0de25aae6d84614dcb934fc7c01797858))


### Features

* add new clickable component ([f9bd61d](https://github.com/p3ol/oak/commit/f9bd61d3d2fdf968ed5ecc125d24cdcf7175a468))
* **deps:** update poool junipero monorepo to v3.7.0 ([eb81056](https://github.com/p3ol/oak/commit/eb810561d68c8072c08ccfb6e3420aedf6f15b11))
* **editable:** add editable-type props in context builder ([b3b6c62](https://github.com/p3ol/oak/commit/b3b6c629f85264cd6338ab522613dcb0092fb958))
* **editable:** add story for editable modal ([73393fc](https://github.com/p3ol/oak/commit/73393fcac71474b8b942017c98d2d76482e295ee))
* **editable:** retrieve editable-type in option of builder ([01b5e0c](https://github.com/p3ol/oak/commit/01b5e0c3d00896e30ac195527b4a35ed6ab28526))
* **editable:** update for display panel modal ([8f727cb](https://github.com/p3ol/oak/commit/8f727cb8c3ecd554d32268278c8f3a3a68dedcdd))
* **react:** add background preview to col component ([360e2b2](https://github.com/p3ol/oak/commit/360e2b2d83ac957a6e532411ef5af65638da8000))





## [3.6.10](https://github.com/p3ol/oak/compare/v3.6.9...v3.6.10) (2024-06-20)


### Bug Fixes

* upgrade various deps ([9af77d7](https://github.com/p3ol/oak/commit/9af77d7efb7e10fcebf1633e273e1e4779071087))





## [3.6.9](https://github.com/p3ol/oak/compare/v3.6.8...v3.6.9) (2024-06-19)

**Note:** Version bump only for package @oakjs/react





## [3.6.7](https://github.com/p3ol/oak/compare/v3.6.6...v3.6.7) (2024-06-19)


### Bug Fixes

* **react:** correctly allow to override editable prop ([a7e6092](https://github.com/p3ol/oak/commit/a7e60928ecc4581d6cfcc8af04e3adae577ee5ac))





## [3.6.5](https://github.com/p3ol/oak/compare/v3.6.4...v3.6.5) (2024-06-19)


### Bug Fixes

* **react:** export missing type ([f2d4207](https://github.com/p3ol/oak/commit/f2d4207c4b3b45f9855a79e228d169f4f51e343b))
* **react:** wrong builder options type ([cbd9d63](https://github.com/p3ol/oak/commit/cbd9d632f18df160e543afca0481f065d4b507a1))





## [3.6.4](https://github.com/p3ol/oak/compare/v3.6.3...v3.6.4) (2024-06-14)


### Bug Fixes

* upgrade various deps ([dae1ba8](https://github.com/p3ol/oak/commit/dae1ba855b14ade39eedd28279c59473bd7f2b49))
* various type issues ([4047d6c](https://github.com/p3ol/oak/commit/4047d6c86545163a86f27cb324c8478a36e55864))





## [3.6.3](https://github.com/p3ol/oak/compare/v3.6.2...v3.6.3) (2024-06-11)


### Bug Fixes

* **react:** missing forwarded export ([5d4af48](https://github.com/p3ol/oak/commit/5d4af488075b3fdc3c572c8e51717f0020e596f6))
* update junipero ([2beb16e](https://github.com/p3ol/oak/commit/2beb16e5d01c6f9ef8ebfdd08f1f65f26609720f))





## [3.6.2](https://github.com/p3ol/oak/compare/v3.6.1...v3.6.2) (2024-06-11)

**Note:** Version bump only for package @oakjs/react





## [3.6.1](https://github.com/p3ol/oak/compare/v3.6.0...v3.6.1) (2024-06-11)


### Bug Fixes

* **react:** missing types exports ([9e9d6d5](https://github.com/p3ol/oak/commit/9e9d6d5590d32591cd6c5232f9a6c9b8c5f458e7))





# [3.6.0](https://github.com/p3ol/oak/compare/v3.5.6...v3.6.0) (2024-06-11)


### Bug Fixes

* **react:** a lot of types ([8458000](https://github.com/p3ol/oak/commit/8458000b90ae59e1ce4ec081d48f2adf79deb288))
* **react:** a lot of types issues ([cdf9ef0](https://github.com/p3ol/oak/commit/cdf9ef09b737f648afbf593b067473a5de699073))
* **react:** allow more sibling fields in editable ([95a6404](https://github.com/p3ol/oak/commit/95a6404148c2758f85fb7d144b9870b2609a5be1))
* **react:** clean code ([f5079f6](https://github.com/p3ol/oak/commit/f5079f64b1d56994d251fc71fb3451b5ce721119))
* **react:** image field preview ([469391e](https://github.com/p3ol/oak/commit/469391e9cf832c87d9911feb273f51da911ba60c))
* **react:** missing exports ([51a36ed](https://github.com/p3ol/oak/commit/51a36edf9bc647d0b2a507b0193890834072c8cf))
* **react:** update and clean code ([9c19732](https://github.com/p3ol/oak/commit/9c197322c3f66f4d1247eb62151f88bf6f8267d2))
* update junipero ([64aeff9](https://github.com/p3ol/oak/commit/64aeff92b2add9c0262a0806748295603a929167))
* update various deps ([8b72c2a](https://github.com/p3ol/oak/commit/8b72c2a84215181363efb26e059b5056fa3e9305))
* various remaining type issues ([a975e97](https://github.com/p3ol/oak/commit/a975e975ef60e5504cef8f934ba6310560f59d07))


### Features

* add box shadow styling field ([0f635a4](https://github.com/p3ol/oak/commit/0f635a43f4a891bcc04d0892317aa5fb26e88e92))
* **typescript-core:** remove react ([6ed6f20](https://github.com/p3ol/oak/commit/6ed6f2059cbca1adcfca8760a669231bc743ed4e))
* **typescript-core:** remove react ([21fa955](https://github.com/p3ol/oak/commit/21fa955ae006c01e0c849ebafd0bca160da8a7d1))
* **typescript-core:** revert react ([b973f43](https://github.com/p3ol/oak/commit/b973f437dc533c9a5ec4b795b2ee5de16aa74580))
* **typescript-react:** begin react package ([62d8dee](https://github.com/p3ol/oak/commit/62d8dee8b3cc6dae7f81653d797ca84d47daf6f8))
* **typescript-react:** rework react builder ([04bbbd7](https://github.com/p3ol/oak/commit/04bbbd7ce166114ea11f7428a5fab8ebeb131790))
* **typescript-react:** type builder react ([1ef7ff3](https://github.com/p3ol/oak/commit/1ef7ff32e962c1b256604f3bd9718a2c4bd95566))
* **typescript:** wip typescript ([cdd6222](https://github.com/p3ol/oak/commit/cdd6222070b88eb878579656391d7721ea1b2d28))
* **typescript:** wip typescript ([88dec47](https://github.com/p3ol/oak/commit/88dec47fce29d8e3768305b39c5fc9cdb1e67ffa))
* **typescript:** wip typescript - react package ([f4ca25f](https://github.com/p3ol/oak/commit/f4ca25f4535a6028b1ec128597cae5ad5e5f20e6))





## [3.5.5](https://github.com/p3ol/oak/compare/v3.5.4...v3.5.5) (2024-05-29)


### Bug Fixes

* **deps:** update dependency @floating-ui/react to v0.26.16 ([2c7fd0a](https://github.com/p3ol/oak/commit/2c7fd0a97a6aba55a23d97b23f8217b6ca586645))
* upgrade various dependencies ([33eeb54](https://github.com/p3ol/oak/commit/33eeb547b85298cb43c324601cb0d4270358c715))





## [3.5.2](https://github.com/p3ol/oak/compare/v3.5.1...v3.5.2) (2024-04-08)


### Bug Fixes

* **types:** fix some types errors ([c3f7102](https://github.com/p3ol/oak/commit/c3f7102a9d81c9130b539cfd027f366291cefa1f))
* update various deps ([c1f22bd](https://github.com/p3ol/oak/commit/c1f22bd8dd647a9fbc7f637ba6cad6f931646448))





## [3.5.1](https://github.com/p3ol/oak/compare/v3.5.0...v3.5.1) (2024-02-19)

**Note:** Version bump only for package @oakjs/react





# [3.5.0](https://github.com/p3ol/oak/compare/v3.4.0...v3.5.0) (2024-02-19)


### Bug Fixes

* **core:** fix merge overrides options behavior ([3f1cf61](https://github.com/p3ol/oak/commit/3f1cf617102b22c0cb944c0c7f33c275c59bfe76))
* **deps:** update dependency @floating-ui/react to v0.26.9 ([63ce76b](https://github.com/p3ol/oak/commit/63ce76bb171a882db513ad4ac1ab8fb1ff41346e))
* **deps:** update poool junipero monorepo ([a9428e7](https://github.com/p3ol/oak/commit/a9428e74d7f6887afcabc138d612f10e624c47ab))
* fix a lot of type issues ([6ff92c0](https://github.com/p3ol/oak/commit/6ff92c02f9eaf2cf017b33a311c5504f500001e5))
* **react:** forward icon ref ([927e375](https://github.com/p3ol/oak/commit/927e37514be5c94f271718155a78ccc00cd43a1f))


### Features

* **ckeditor:** add Ck editor package types and enhance other ([3de5ded](https://github.com/p3ol/oak/commit/3de5dede3a92d4a7bcea9ff548eb0897d4b6cf4f))
* **deps:** update dependency core-js to v3.36.0 ([ecd2143](https://github.com/p3ol/oak/commit/ecd214319d6e830ff0a9ef02b379cb444df139e7))
* **react:** add info tooltip to fields ([ac38c5e](https://github.com/p3ol/oak/commit/ac38c5e85e4198895d20cdf96a1207e441d6716d))





# [3.4.0](https://github.com/p3ol/oak/compare/v3.3.0...v3.4.0) (2023-11-24)


### Bug Fixes

* **deps:** update dependency core-js to v3.33.3 ([36a79b9](https://github.com/p3ol/oak/commit/36a79b98a27873778ad5a716af6faab8cc5ff5a0))
* **react:** wrong settings order ([13ac8c4](https://github.com/p3ol/oak/commit/13ac8c44a95250875483e6f0deb097d1185a0a34))


### Features

* **react:** add priority override for settings ([0720afb](https://github.com/p3ol/oak/commit/0720afb4d0369860ee3468e6eeda51876cac6517))





# [3.3.0](https://github.com/p3ol/oak/compare/v3.2.2...v3.3.0) (2023-11-15)


### Bug Fixes

* **deps:** update dependency @floating-ui/react to v0.25.2 ([b2e8892](https://github.com/p3ol/oak/commit/b2e8892c631f2d161583c0b2439e85c5a8b7d144))
* **deps:** update dependency @floating-ui/react to v0.25.3 ([8ead50e](https://github.com/p3ol/oak/commit/8ead50e3147131913d5cf0a73e17db13f6f13fb5))
* **deps:** update dependency @floating-ui/react to v0.25.4 ([c861e19](https://github.com/p3ol/oak/commit/c861e193e6c9e167937ed997035baaebd288fcf5))
* **deps:** update dependency core-js to v3.32.1 ([6554864](https://github.com/p3ol/oak/commit/65548645a826cf7e6087e44d2c8dbed883eb9285))
* **deps:** update dependency core-js to v3.32.2 ([41b793e](https://github.com/p3ol/oak/commit/41b793eb70b4270cea72c77a1720afd858e45416))
* **deps:** update dependency uuid to v9.0.1 ([271ada9](https://github.com/p3ol/oak/commit/271ada9f3a0a1debf718765db611828c7f116d62))
* **react:** allow to use custom option icon classname ([c965568](https://github.com/p3ol/oak/commit/c965568045771d8f6559eea39f92dda43762f2da))
* **react:** correctly rerender on addons updates ([0d74897](https://github.com/p3ol/oak/commit/0d7489716817a6d6cce0617953dcbbb3ddc98120))
* **react:** fix wrong drag option render ([3500f73](https://github.com/p3ol/oak/commit/3500f73f858589072b73d13b943ad4e5f1f98e91))


### Features

* **deps:** update dependency @floating-ui/react to v0.26.2 ([27b430d](https://github.com/p3ol/oak/commit/27b430d296371a251333917255ec2d7714d836c7))
* **deps:** update dependency core-js to v3.33.2 ([b9a0a1a](https://github.com/p3ol/oak/commit/b9a0a1ada4b11bcd71c6a549a3f71da48908af74))
* **deps:** update junipero monorepo ([3d7af43](https://github.com/p3ol/oak/commit/3d7af43aeb9209b23fb2c7b2ca41e50e1406f87b))
* handle addons updates/removal ([827fc20](https://github.com/p3ol/oak/commit/827fc20ec188bde86cd1b71135f62f0ca83e5106))





## [3.2.2](https://github.com/p3ol/oak/compare/v3.2.1...v3.2.2) (2023-08-15)


### Bug Fixes

* **deps:** update dependency @floating-ui/react to v0.25.1 ([1b4e6bb](https://github.com/p3ol/oak/commit/1b4e6bb3f00e2fa5558acb46cb247981b343fd7a))
* **theme:** update upstream junipero with broken css fix ([a971d23](https://github.com/p3ol/oak/commit/a971d2346aed296dc3c4bd500d7ea5063e514841))





## [3.2.1](https://github.com/p3ol/oak/compare/v3.2.0...v3.2.1) (2023-08-04)


### Bug Fixes

* update junipero ([c467fa1](https://github.com/p3ol/oak/commit/c467fa1826369884811d901010d9549a2f19cab5))


### Features

* **deps:** update junipero monorepo to v3.2.0 ([d3a087c](https://github.com/p3ol/oak/commit/d3a087c376cffb31284f11b559aabe314de060fa))





# [3.2.0](https://github.com/p3ol/oak/compare/v3.1.0...v3.2.0) (2023-07-20)


### Bug Fixes

* **deps:** update dependency @floating-ui/react to v0.24.4 ([6e9c789](https://github.com/p3ol/oak/commit/6e9c789e8c04396d5217ffe14faac913e6364b9d))
* **deps:** update dependency @floating-ui/react to v0.24.5 ([301a0a9](https://github.com/p3ol/oak/commit/301a0a90c79465eb56675961345f30e010eb16fc))
* **deps:** update dependency @floating-ui/react to v0.24.6 ([2fa5793](https://github.com/p3ol/oak/commit/2fa5793eec89e82380c8490aaa72604353f7f616))
* **deps:** update dependency @floating-ui/react to v0.24.7 ([baf6752](https://github.com/p3ol/oak/commit/baf675255020ba2db152f466d9d6f33df6e37f5b))
* **deps:** update dependency @floating-ui/react to v0.24.8 ([ca05037](https://github.com/p3ol/oak/commit/ca05037c6677eae51696c3d474ff3ac2a051c379))
* **deps:** update dependency core-js to v3.31.1 ([cfa996d](https://github.com/p3ol/oak/commit/cfa996d41aca74a0399882c03b7ab9c7d96a8cec))
* **deps:** update junipero monorepo ([d3b51ab](https://github.com/p3ol/oak/commit/d3b51ab21eee46bdecc73ac68762b0dd6b30aa4f))
* reorder overrides on editable ([9d5dfd4](https://github.com/p3ol/oak/commit/9d5dfd431592f87b8c9efd3bc368f41ddceca701))


### Features

* **react:** add builder to condition callback ([5666f0c](https://github.com/p3ol/oak/commit/5666f0c3c41a7a52f427ccc605c58b4d951bdc71))





# [3.1.0](https://github.com/p3ol/oak/compare/v3.0.10...v3.1.0) (2023-06-30)


### Bug Fixes

* property name typo ([032786e](https://github.com/p3ol/oak/commit/032786e30909a17c354707bd76e1211eb77137fd))


### Features

* allow global settings overrides ([63e6822](https://github.com/p3ol/oak/commit/63e6822b6d11bd0626b11a5f03bfe204213c3cf8))
* **core:** add draft of setting overrides ([88a89a0](https://github.com/p3ol/oak/commit/88a89a01f7f1d7a294751c5891f567bd12a7bca4))
* **deps:** update dependency core-js to v3.31.0 ([9dbd14b](https://github.com/p3ol/oak/commit/9dbd14b807168595afcdc034f7024fced23254cb))
* **deps:** update junipero monorepo to v3.1.0 ([c1d7e96](https://github.com/p3ol/oak/commit/c1d7e96ae9d4e7dfdf1b3a990e39b3753e77c785))
* **react:** allow to override field settings ([368aa1a](https://github.com/p3ol/oak/commit/368aa1add530de4c546cb01b6e99d93b01a820f4))





## [3.0.10](https://github.com/p3ol/oak/compare/v3.0.9...v3.0.10) (2023-06-29)


### Bug Fixes

* **deps:** update dependency @floating-ui/react to v0.24.3 ([d48e6a3](https://github.com/p3ol/oak/commit/d48e6a3363f72fd764ada996a929ee6f1ee6be56))





## [3.0.9](https://github.com/p3ol/oak/compare/v3.0.8...v3.0.9) (2023-06-07)


### Bug Fixes

* allow to install package on node 20 ([811ec5c](https://github.com/p3ol/oak/commit/811ec5c314d76d45c21dc9c75f3ef1c45600552c))
* **deps:** update dependency @floating-ui/react to v0.24.2 ([b56899c](https://github.com/p3ol/oak/commit/b56899c7bec8334c922d924154a8a8a24dc4adf3))
* update junipero ([50173d1](https://github.com/p3ol/oak/commit/50173d1002e54e6bd4e67a32a3a067dfd90c3496))





## [3.0.7](https://github.com/p3ol/oak/compare/v3.0.6...v3.0.7) (2023-05-19)


### Bug Fixes

* **react:** add col size info ([c37c8d7](https://github.com/p3ol/oak/commit/c37c8d771c108d8cda7181261194dfa60bf59c18))
* **react:** add row background info ([a66b810](https://github.com/p3ol/oak/commit/a66b8105a54b6b4950368944c393cf31afc63a1d))





## [3.0.6](https://github.com/p3ol/oak/compare/v3.0.5...v3.0.6) (2023-05-19)


### Bug Fixes

* **react:** export junipero's useTimeout ([daef598](https://github.com/p3ol/oak/commit/daef5984b5e6d5d1689f6fbadbf4bbf04d46dd6b))





## [3.0.4](https://github.com/p3ol/oak/compare/v3.0.3...v3.0.4) (2023-05-18)


### Bug Fixes

* wrong col responsive options ([c2aea91](https://github.com/p3ol/oak/commit/c2aea91d62aacae73d04d152c448c8d482526125))





## [3.0.2](https://github.com/p3ol/oak/compare/v3.0.1...v3.0.2) (2023-05-16)


### Bug Fixes

* **react:** correctly paste content before builder ([7dab078](https://github.com/p3ol/oak/commit/7dab078b40d4198b8141d054d7092c4d3e7d27bb))





## [3.0.1](https://github.com/p3ol/oak/compare/v3.0.0...v3.0.1) (2023-05-16)


### Bug Fixes

* **react:** add missing catalogue animation ([9056d6a](https://github.com/p3ol/oak/commit/9056d6a6c0e76ee451401c449465671383cbe145))
* **react:** fix editable overflowing on cols ([5d0620b](https://github.com/p3ol/oak/commit/5d0620b50dabaecf17a0ffeab97f39145b233e70))
* **react:** only display groups with components ([a4380d9](https://github.com/p3ol/oak/commit/a4380d9c6a9a4ef34ba6075a812ce84b0753d24b))





# [3.0.0](https://github.com/p3ol/oak/compare/v3.0.0-alpha.40...v3.0.0) (2023-05-15)


### Bug Fixes

* **react:** allow to paste multiple elements inside containers ([7efe183](https://github.com/p3ol/oak/commit/7efe183ad1cf57e8e1922110020591629294b727))
* update floating ui ([7c1f08f](https://github.com/p3ol/oak/commit/7c1f08f91c14a6377c8d0a4d8fb9668f6a5fe57e))
* update junipero to major ([8515b9f](https://github.com/p3ol/oak/commit/8515b9f397ab1572fc38ae62c607d87458e68c32))
* upgrade various dependencies ([b70b8bf](https://github.com/p3ol/oak/commit/b70b8bfb968147fe8021c2075d9e5f1a9b54242e))
