/*
 * This sketch is useful to find the EEPROM device I2C bus address. 
 * Use the Serial Monitor.
 */

#include <Wire.h>
 
void setup() {

  pinMode(12, OUTPUT);
  digitalWrite(12, LOW);
  delay(300);
  digitalWrite(12, HIGH);
  delay(300);
  
  Wire.begin();
  Serial.begin(9600);
  Serial.println("\nI2C Scanner");
}
 
void loop() {
  byte error, address;
  int nDevices;
  Serial.println("Scanning...");
  nDevices = 0;
  for(address = 1; address < 127; address++ ) {
    Wire.beginTransmission(address);
    error = Wire.endTransmission();
    if (error == 0) {
      Serial.print("I2C device found at address 0x");
      if (address<16) {
        Serial.print("0");
      }
      Serial.println(address,HEX);
      nDevices++;
    }
    else if (error==4) {
      Serial.print("Unknow error at address 0x");
      if (address<16) {
        Serial.print("0");
      }
      Serial.println(address,HEX);
    }    
  }
  if (nDevices == 0) {
    Serial.println("No I2C devices found\n");
  }
  else {
    Serial.println("done\n");
  }
  delay(5000);          
}
