# Examples of using the Si4735 Arduino Library on ATtiny85

This folder shows how you can use de Si4735 Arduino Library on the very small ATtiny85.
See the examples below. 


## SI47XX 01 - SI47XX_01_ATTINY85_LCD_16x2_I2C - AM/FM receiver with ATtiny85  

This example implements an AM and FM receiver using the ATtiny85 as the master MCU.

The Attiny core board/plataform can be installed using the Arduino IDE boards manager. Insert the URL http://drazzy.com/package_drazzy.com_index.json on board manager.

On menu Preferences, enter the above URL in "Additional Boards Manager URLs;
To setup ATtiny85 on Arduino IDE, go to Tools Menu, Board, Board Manager and install "ATTinyCore by Spence Konde". See also the video [How to "SI4735 Arduino Library and ATtiny85"](https://youtu.be/zb9TZtYVu-s).

See [ATTiny Core - 1634, x313, x4, x41, x5, x61, x7, x8 and 828 for Arduino](https://github.com/SpenceKonde/ATTinyCore).

See also [ATtiny85 pinout](https://ww1.microchip.com/downloads/en/DeviceDoc/Atmel-2586-AVR-8-bit-Microcontroller-ATtiny25-ATtiny45-ATtiny85_Datasheet.pdf).


## EEPROM - SI47XX_03_SSB_Tiny4kOLED - SI4735-D60 SSB patch from an external EEPROM 

This example shows the use of the external EEPROM. 
It will transfer the SSB patch content stored in an EEPROM to SI4735-D60.
To run this sketch you must have a external I2C EEPROM device configured with your ATtiny85 and the Si4735 devices via i2C bus. The EEPROM must have the patch content generated by the sketch  SI47XX_09_SAVE_SSB_PATCH_EEPROM. [See folder examples/TOOLS](https://github.com/pu2clr/SI4735/tree/master/examples/TOOLS/SI47XX_09_SAVE_SSB_PATCH_EEPROM).


### ATtiny85 Schematic

The pull-up resistor values may vary depending on the devices connected to the I2C bus. Select the lowest possible resistors. The schematic below show 4.7K for pull-up resistors. However, it can be lower than it.

![Schematic ATtiny85 and Si4735](../../extras/images/schematic_attiny85_basic.png)



#### ATtiny85 AND EXTERNAL EEPROM SETUP 

![Schematic ATtiny85 and Si4735](../../extras/images/schematic_attiny85_ssb_external_eeprom.png)



### Photo

The photo below show the Si4730 on adapter board with the basic components suggested by Silicon Labs.

![Photo ATtiny85 and Si4730 on Adapter](https://github.com/pu2clr/SI4735/blob/master/extras/images/SI4730_on_adapterA.png)

<BR> 

The photo below shows the Si4730 on adapter board connect attached on a mini breadboard.

![Photo ATtiny85 and Si4730 on mini breadboard](https://github.com/pu2clr/SI4735/blob/master/extras/images/SI4730_on_BreadboardA.png)

<BR>

The Si4730 and ATtiny85 FM radio prototype. 

![Photo ATtiny85 and Si4730](https://github.com/pu2clr/SI4735/blob/master/extras/images/SI4730_attiny85A.png)





## Videos

* [How to "SI4735 Arduino Library and ATtiny85"](https://youtu.be/zb9TZtYVu-s)
* [SI4735 Arduino Library working with ATtiny85](https://youtu.be/U9Xpqh3K4e0)

