# Прошивка ATS_EX для приёмника ATS-20
## Общее описание
Это расширенная прошивка для приёмников **ATS-20**, которые работают на **Arduino Nano** и чипе DSP приёмника **Si473x**. 
Прошивка ATS_EX создана мной, **Goshante**, основана на наработках прошивки **PU2CLR** и вдохновлена прошивкой от **swling.ru** с закрытым исходным кодом.


**Последняя версия:** v1.18 (03.04.2024)

**Ссылка на скачивание готового .hex файла прошивки:** [>>> Нажмите здесь <<<](https://github.com/goshante/ats20_ats_ex/releases/download/v1.18/ATS_EX_v1.18.hex)

Задонатить автору можно здесь :) https://t.me/tribute/app?startapp=d7vv
<p align="center">
    <img src="../img/ats20.png" alt="Icon" />
</p>

# Особенности

 - Полностью **переработан интерфейс**. Больше никаких растянутых шрифтов. Минималистичный и читабельный интерфейс. Семисегмантный шрифт частоты был воссоздан мной таким, каким он был в прошивке от swling.
 - Полностью **переработаны элементы управления**. Краткое руководство пользователя находится здесь, ниже.
 - **BFO теперь часть общей частоты приёмника, пока активен SSB** и регулируется общим шагом частоты, больше никаких выделенных отдельных настроек BFO, которые только путают и делают ход по частоте неудобным и ужасным. В режиме SSB доступны более точные шаги.
 - **LW** Диапазон: От **153** до **520** KГц
 - **MW** Диапазон: От **520** до **1710** KГц
 - **SW** Диапазон: От **1710** до **30000** КГц (С большим количеством поддиапазонов)
 - **FM** Диапазон: От **64** до **108** МГц.
 - **Динамический RDS** для **FM** радиостанций с возможностью переключения строк информации (Отображает до 16 символов).
 - **Сканирование станций** в AM/FM режимах.
 - Добавлена **CW модуляция**.
 - **RSSI** с плохим дизайном был удалён и заменен на опционально отображаемую шкалу, подобную **S-метру**.
 - Все **КВ (SW) диапазоны** теперь ощущаются как один большой диапазон **от 1710 до 30000 КГц**. Всё еще можно переключаться между SW диапазонами, но они больше не ограничивают шаг частоты пределами поддиапазона.
 - **Настройка частот стала максимально плавной** в режиме SSB благодаря объединению частоты приема с BFO. Грубое переключение частот теперь происходит каждые 16 КГц (**бесшовная настройка в обоих направлениях покрывает полные 32 КГц, намного меньше "пшиков".**). В не-SSB режимах теперь вы также можете настраивать частоту быстрее, **энкодер должен реагировать более отзывчиво**.
 - **Доступно множество шагов для каждого режима**. В AM у вас есть шаги 1/5/9/10/50/100k/1M, в SSB есть шаги 1/5/9/10k и шаги 10/25/50/100/500Гц для более точной настройки. В режиме FM у вас есть шаги 10k/100k/1M.
 - Добавлена страница настроек. Вы можете настроить **Управление усилением и ATT**, **Мягкое выключение звука**, **Автоматическое управление громкостью** (AVC), Включить или Выключить **AVC для режима SSB**, **Деэмфазис** для режима FM и включить или выключить **режим синхронизации SSB**, и прочие другие полезные настройки.
 - **Калибровка** сдвига частоты **BFO**.
 - Регулируемая **яркость экрана**.
 - Регулируемая **частота процессора**, возможность снизить её на 50% для большего энергосбережения батареи и уменьшения помех.
 - Добавлена **кнопка выключения звука** и **кнопка включения/выключения дисплея**.
 - Добавлено **отображение состояния заряда батареи** (Требуется небольшой мод: Сделать **делитель напряжения** из двух резисторов по 10 КОм и припаять его среднюю точку к пину **A2**)
 - Добавлен **S-метр**
 - **Контроллер Atm328p теперь работает на полной частоте**. Управление должно быть более отзывчивым. (Не знаю, как это влияет на расход батареи.)
 - Рефакторинг кода, оптимизации
 - Исправлены некоторые баги

## О просьбах нового функционала...
Пожалуйста, не просите добавлять новый функционал. Эта прошивка достигла предела максимального размера flash-памяти и оптимизирована настолько, насколько это было вообще возможно и для нового функционала буквально не хватит места. В ней также имеется бутлоадер, и я не собираюсь его вырезать.
Я принимаю только тикеты об ошибках и багах. Эта прошивка уже работает на грани возможностей приёмника ATS-20.

Если вы хотите добавить новый функционал - вы можете сделать это сами. Исходный код открыт и доступен в этом репозитории.

 # Как прошить мой приёмник?
 Вы можете использовать любой софт, способный прошивать .hex файл прошивки на Arduino. Вам понадобится только Micro USB кабель и **драйвер USB UART** (вероятнее всего, это будет драйвер для контроллера **CH341**). Я рекомендую использовать программу **AVRDUDESS**, если вы используете Windows. Это простой инструмент с графическим интерфейсом, который может дампить и прошивать файлы прошивок на микроконтроллеры Atmel(Ардуино). 
 
 **Есть два типа ATS-20 приёмников**: Те, которые на **Arduino Nano** и на **Arduino Uno**. Их довольно просто отличить. Нужно разобрать и посмотреть. Те, что на Nano - у них Arduino распаяна отдельной платой сверху в основную плату. Если внутри нет распаянной платы и сразу распаян чип ATMega368, все компоненты находятся на одной плате, то у вас ревизия на Arduino Uno. Это важно знать перед прошивкой. 
 
 Нужно выбрать в AVRDUDESS из раздела **Presets** либо **"Arduino Nano (ATmega328P)"**, либо **"Arduino Uno (ATmega328P)"** , затем выбрать ваш фактический **COM порт** и в разделе **"Flash"** указать **путь к файлу прошивки .hex** . Выберите режим режим **Write** и нажать рядом кнопку **Go**. После чего пойдет прошивка. В случае чего не бойтесь, если вы выбрали неправильные настройки у вас просто не получится его прошить и на приёмнике останется старая прошивка.

Или можно собрать прошивку самостоятельно из исходников, которые лежат в этом репозитории. Я использую Visual Studio 2022 с расширением VSMicro, которое использует Arduino IDE 1.8. Вы можете просто использовать Arduino IDE, собрать скетч самостоятельно и загрузить его в контроллер прямо из IDE.

## У меня не прошивается, что делать?
Такое бывает, если вы прошиваете через USB порт, который не способен отдавать достаточный ток для запитывания контроллера вместе со всем устройством. Если **включить приёмник** перед подключением к ПК и подключить его к порту **USB 3.0**, то шансов на успех будет куда больше. Да, приёмник не использует USB 3.0, там версия 2.0, но порты третьей версии способны отдавать больший ток. И если не помогает всё равно, попробуйте перепрошить приёмник через Arduino IDE **пустой прошивкой**, соберите пустой проект без логики и зашейте в приёмник. Если вы прошиваете Arduino Nano, убедитесь, что вы выбрали версию платы со старым загрузчиком (**Old Bootloader**). После этого попробуйте снова зашить туда саму прошивку.

# Руководство пользователя
**ВНИМАНИЕ:** После прошивки настоятельно **рекомендуется сбросить память EEPROM**. Для этого просто удерживайте **Кнопку Энкодера** при включении приемника.

### Функционал кнопок
#### Кнопка **BAND+** 
 1. **Выбор диапазона** : Короткое нажатие для входа в режим выбора диапазона. Выберите диапазон с помощью **Вращения Энкодера** и подтвердите с помощью **Кнопки Энкодера** или повторным нажатием кнопки **BAND+**. Либо зажмите **BAND+** для быстрой прокрутки диапазонов вперёд. В **SW диапазоне** листает к ближайшему поддиапазону. После крайнего SW поддиапазона переключает на следующий (либо предыдущий) диапазон.
 2. **Переключение страницы настроек** : Данная кнопка переключает **страницы настроек** во время того, как открыты настройки.
#### Кнопка **BAND-** 
 1. **Меню настроек** : Короткое нажатие для открытия/закрытия **меню настроек**. При **закрытии** настроек, все настройки **сохраняются в EEPROM**.
 2. **Выбор диапазона** : Долгое нажатие **BAND-** быстро прокручивает диапазоны назад.
#### Кнопка **VOL+** 
 1. **Регулировка громкости** : Короткое нажатие для входа в режим **регулировки громкости**. Установите громкость с помощью **Вращения Энкодера** и подтвердите с помощью **Кнопки Энкодера** или повторным нажатием кнопки **VOL+**. 
 2. **Быстрое увеличение громкости** : Зажмите для быстрого увеличения громкости.
#### Кнопка **VOL-** 
 1. **Mute (приглушение громкости)** : Короткое нажатие для **включения и выключения беззвучного режима**.
 2. **Быстрое уменьшение громкости** : Зажмите для быстрого уменьшения громкости.
#### Кнопка **STEP**
 1. **Регулировка шага** : Короткое нажатие для входа в режим **регулировки шага**. Установите шаг с помощью **Вращения Энкодера** и подтвердите с помощью **Кнопки Энкодера** или повторным нажатием кнопки **STEP**.
 2. **Шкала уровня сигнала** : Длинное нажатие клавиши показывает снизу полосу уровня сигнала, **подобную S-метру**. Можно выключить повторным длинным или коротким нажатием. Либо сменой диапазона.
#### Кнопка **AGC** 
 1. **Включение/выключение дисплея** : Короткое нажатие работает как выключатель дисплея. 
 2. **Sync режим для SSB**: Долгое нажатие для переключения режима **Sync** при активной **SSB** модуляции.
#### Кнопка **BW** 
 1. **Регулировка полосы пропускания** : Короткое нажатие для входа в режим **регулировки ширины полосы пропускания**. Установите шаг с помощью **Вращения Энкодера** и подтвердите с помощью **Кнопки Энкодера** или повторным нажатием кнопки **BW**. Для каждой модуляции свой набор шагов.
#### Кнопка **MODE** 
 1. **Выбор модуляции в AM/SSB режиме** : Короткое нажатие для **переключения между модуляциями** в AM/SSB режиме. На диапазоне **FM** единственная доступная модуляция - **WFM** (FM с широкой полосой) и переключать модуляцию в FM диапазоне нельзя (ограничения микросхемы Si4735). На всех остальных диапазонах доступны следующие модуляции: **AM/USB/LSB/CW**. Во всех модуляциях(Особенно в SSB) улучшенная настройка частоты без прерывания на каждом шаге.
 2. **RDS в FM диапазоне** : Короткое нажатие позволяет в нижней строке под частотой отображать **строку с метаданными**, декодированную из RDS трафика текущей радиостанции. Пока не утеряна синхронизация, надпись может **динамически обновляться**, если FM радиостанция циклически выводит туда различную информацию. В этом режиме при помощи **Кнопки Энкодера** можно переключать **3 различных режима информации RDS**: **Название станции**, **Информация о станции** и **Информация о программе**. Если какая-то из ячеек информации не декодировалась или отсутствует, то будут отобрадаться три точки - **...**. Если при включении RDS не отобразились данные, то нужно выключить его и включить снова либо переместиться энкодером на другую частоту и вернуться обратно, чтобы микросхема Si4735 могла синхронизироваться с потоком RDS трафика. Если синхронизация сбилась она восстанавливается автоматически только после переключения частоты.
#### **Вращение Энкодера** 
1. **Настройка Частоты** : В режиме радио (обычный режим) вращение делает ход по частоте с указанным внизу экрана шагом.
2. **навигация по настройкам** : В режиме настроек при помощи энкодера можно выбирать нужную настройку и после выбора изменять её значение.
#### **Кнопка Энкодера**
1. **Сканирование частоты** : Работает **только в FM и АМ** модуляциях и только если в настройках параметр **Sca** включен (**On**). Нажмите, чтобы сканировать станции по частоте в последнем направлении с заданным шагом. Вращайте энкодер либо нажмите на него, чтобы **остановить сканирование**.
2. **Универсальная кнопка** : Подтверждает настройки, делает выбор, переключает режимы RDS.
3. **Сброс EEPROM** : Важный функционал, позволяющий **сбросить настройки к стандартным**. Для этого включите приёмник с заранее зажатой кнопкой энкодера. После этого должна появиться надпись **EEPROM RESET**.
4. **Быстрая настройка шага** : Только для **SSB режима** - нажатие позволяет сразу перейти в режим настройки шага. Также работает и в **FM/AM** режимах, если в настройках параметр **Sca** выключен (**Off**).

### Настройки
Навигация в настройках с помощью **Вращения Энкодера**, подтверждение выбора с помощью **Кнопки Энкодера**, изменение значения с помощью **Вращения Энкодера** и сохранение его с помощью снова той же **Кнопки Энкодера**. Закрыть настройки можно кнопкой **BAND-**. Переключаться между **страницами настроек** можно при помощи кнопки **BAND+**.

<p align="center">
    <img src="../img/ats20_settings.png" alt="Icon" />
</p>

**ATT** : Значение **аттенюации**. **AUT** означает **Автоматическое управление усилением**. Этот параметр может быть либо **AUT**, либо числом от **1** до **37**. **Важно:** AGC режим (он же **AUT**) в любой из SSB модуляций добавит постоянный шум на фон (Так во всех прошивках). Он не сильно заметен, но это стоит принять к сведению.

**SM** : **Soft Mute** (Софт мьют). Это число от **0** до **32**.

**AVC** : **Automatic Volue Control** (Автоматическая регулировка громкости). Это число от **12** до **90**.

**SVC** : Включает либо отключает **AVC режим для SSB**.

**DeE** : Только для режима **FM**. Это значение **DeEmphasis** в микросекундах. Может быть либо **50**, либо **75**.

**Syn** : Включить либо выключить **режим Sync для SSB**.

**Scr** : **Регулировка яркости** дисплея. Это число от **5** до **125**.

**SW** : **Единицы частоты** для AM модуляции в SW(КВ) диапазоне. Может быть либо **KHz**, либо **MHz**. В режиме MHz мегагерцы отделяются от частоты точкой.

**SSM** : **SSB Soft Mute Mode**. Режим работы Soft Mute для SSB. Может быть либо  **RSS** (SM зависит от значения RSSI) или **SNR** (SM зависит от соотношения сигнал/шум).

**COF**: Фильтр отсечения боковых полос (**SSB Cutoff Filter**). Имеет 3 режима: **On** - полосовой фильтр для подавления обеих нежелательных частей боковой полосы и компонентов высокой частоты. **Off** - Фильтр с низким прохождением для подавления нежелательной боковой полосы. И **AUT** режим: автоматически включается и выключается в зависимости от Ширины полосы(**Bandwidth**) (выключен, когда ширина полосы выше **2.0 КГц**).

**CPU**: **Частота процессора** (ATMega328p). Это полезно для **экономии заряда батареи**. Может быть либо **100**, либо **50%**. 100% - процессор работает на х1 от своей частоты, используя свой полный потенциал. 50% - процессор **работает на половине своей частоты**, он медленнее, но позволяет сэкономить больше заряда батареи.

**RDS** : Порог **допустимости ошибок декодирования RDS**. Чем ниже это число, тем более точным будет декодирование RDS. Текст будет выглядеть лучше, но меньше шансов на успешную синхронизацию. Чем выше этот номер, тем проще будет синхронизироваться со стримом RDS данных, но текст может выглядеть искаженно. Это число от **0** до **3**.

**BFO** : **Калибровка сдвига частоты BFO**. Одна единица этого параметра равна **1 Гц * 10** или **0.01 КГц**. Это значение отвечает за сдвиг частоты **BFO для SSB** на указанное количество единиц частоты. Если вам кажется, что частота SSB недостаточно точная, то вы можете откалибровать её при помощи этого значения. Допустимый диапазон значений от **-60 до 60 единиц**, что равнозначно значениям от **-0.60 КГц до 0.60 КГц**.

**Uni** : Показать/Скрыть **отображение единиц измерения частоты**.

**Sca** : Включить либо выключить **функцию сканирования** в режиме AM и FM при нажатии **кнопки энкодера**. В выключеном состоянии кнопка всегда **будет регулировать шаг**.

**CW** : **Режим работы CW**. Базируется либо на **LSB**, либо на **USB** модуляции.

### Описание элементов на дисплее

<p align="center">
    <img src="../img/ats20_display.png" alt="Icon" />
</p>

**1**. **Текущая модуляция**. От **149** до **30000** КГц доступны модуляции **AM/LSB/USB/CW**. Когда активен **Sync** в режимах **SSB**, рядом со статусом модуляции появится буква **S**. В диапазоне **FM** доступна только модуляция **FM** (или **WFM**). У меня нет патча **NBFM** (FM с узкой полосой пропускания) для **Si473x**, поэтому сейчас эта модуляция недоступна.

**2**. **Ширина полосы приёма**. Может быть **AUTO** в режиме **FM**. Недоступно в режиме **CW**.

**3**. **Частота**. В режимах **FM** и **SSB** показывается дробную часть для более точной настройки.

**4**. **Диапазон**. Доступны такие диапазоны, как **LW, MW, SW, CB** и **FM**.

**5**. **Значение шага**. Оно различно для всех модуляций, **SSB имеет более точные шаги**, но не имеет крупных. AM же имеет крупные шаги, но не имеет точных. Если после значения шага нет суффикса единиц измерения, это означает, что шаг отображается в **герцах**.

**6**. **Единицы частоты**. Единицы измерения всегда отображаются, кроме случаев, когда десятичная часть частоты в **SSB** режиме длиной в **5 цифр**.

**7**. **Громкость**. Это уровень громкости приемника. Может быть значением между **0** и **63**. Когда включен беззвучный режим (Mute), вместо уровня громкости будет отображаться буква **M**.

**8**.  **Уровень заряда батареи** in percents. Требует подключения пайкой **делителя напряжения** к пину **A2**. Не отображается если не подключено. Когда уровень заряда слишком низкий или USB кабель подсоединен (на некоторых ревизиях приёмника), то индикатор заряда будет отображать **---**.

# Как сделать так, чтобы отображался уровень заряда батареи?

Вам потребуется паяльник и два резистора по **10 КОм** каждый. Припаяйте один резистор к минусу(земле), второй напрямую к плюсу литиевой батареи. И спаяйте их вместе, это будет их средняя точка. Её нужно припаять к пину **A2** на контроллере. Таким образом на него будет подаваться половина напряжения батареи. Сделав такую простую модификацию **ATX_EX** прошивка автоматически определит подключенный пин напряжения батареи и начнет показывать заряд.
