
# do not edit, generated by pymoca

from __future__ import print_function, division
import sympy
import sympy.physics.mechanics as mech
from pymoca.backends.sympy.runtime import OdeModel
from sympy import sin, cos, tan


class Aircraft(OdeModel):

    def __init__(self):

        super(Aircraft, self).__init__()

        # states
        body__x, body__v_x = mech.dynamicsymbols('body.x, body.v_x')
        self.x = sympy.Matrix([body__x, body__v_x])
        self.x0 = {
            body__x : 0,
            body__v_x : 0,
            }

        # variables
        body__f_x, body__a_x, accel__a_x, accel__ma_x, accel__b_x__u, accel__b_x__y = mech.dynamicsymbols('body.f_x, body.a_x, accel.a_x, accel.ma_x, accel.b_x.u, accel.b_x.y')
        self.v = sympy.Matrix([body__f_x, body__a_x, accel__a_x, accel__ma_x, accel__b_x__u, accel__b_x__y])

        # constants
        self.c = sympy.Matrix([])
        self.c0 = {
            }

        # parameters
        body__g, body__c, body__m, accel__b_x__b = sympy.symbols('body.g, body.c, body.m, accel.b_x.b')
        self.p = sympy.Matrix([body__g, body__c, body__m, accel__b_x__b])
        self.p0 = {
            body__g : 9.81,
            body__c : 0.9,
            body__m : 1.0,
            accel__b_x__b : 0,
            }

        # inputs
        self.u = sympy.Matrix([])
        self.u0 = {
            }

        # outputs
        self.y = sympy.Matrix([])

        # equations
        self.eqs = [
            body__f_x - (1.0),
            (body__x).diff(self.t) - (body__v_x),
            (body__v_x).diff(self.t) - (body__a_x),
            body__f_x - (body__m * body__a_x),
            accel__b_x__y - (accel__b_x__u + accel__b_x__b),
            accel__b_x__u - (accel__a_x),
            accel__ma_x - (accel__b_x__y),
            body__a_x - (accel__a_x),
            ]

        self.compute_fg()