
# do not edit, generated by pymoca

from __future__ import print_function, division
import sympy
import sympy.physics.mechanics as mech
from pymoca.backends.sympy.runtime import OdeModel
from sympy import sin, cos, tan


class SpringSystem(OdeModel):

    def __init__(self):

        super(SpringSystem, self).__init__()

        # states
        x, v_x = mech.dynamicsymbols('x, v_x')
        self.x = sympy.Matrix([x, v_x])
        self.x0 = {
            x : 1.0,
            v_x : 1.0,
            }

        # variables
        spring__x, spring__f, damper__v, damper__f = mech.dynamicsymbols('spring.x, spring.f, damper.v, damper.f')
        self.v = sympy.Matrix([spring__x, spring__f, damper__v, damper__f])

        # constants
        self.c = sympy.Matrix([])
        self.c0 = {
            }

        # parameters
        spring__k, damper__c = sympy.symbols('spring.k, damper.c')
        self.p = sympy.Matrix([spring__k, damper__c])
        self.p0 = {
            spring__k : 2.0,
            damper__c : 0.2,
            }

        # inputs
        u = mech.dynamicsymbols('u')
        self.u = sympy.Matrix([u])
        self.u0 = {
            u : 0,
            }

        # outputs
        x, v_x = mech.dynamicsymbols('x, v_x')
        self.y = sympy.Matrix([x, v_x])

        # equations
        self.eqs = [
            spring__f - (- spring__k * spring__x),
            damper__f - (- damper__c * damper__v),
            spring__x - (x),
            damper__v - (v_x),
            (x).diff(self.t) - (v_x),
            (v_x).diff(self.t) - (spring__f + damper__f - u),
            ]

        self.compute_fg()