<div id="elevated_login_container" class="fullpage_backdrop">
    <div class="fullpage_backdrop_content">
        <div class="backdrop_box login_page login_popup" id="login_popup">
            <div id="backdrop_detail_content" class="backdrop_detail_content rounded_top login_content">
                <div class="logindiv form-container active" id="regular_login_container">
                    <form accept-charset="<?= \pachno\core\framework\Context::getI18n()->getCharset(); ?>" action="<?= make_url('auth_user_verify_2fa'); ?>" method="post" id="login_form" data-simple-submit>
                        <div class="form-row">
                            <h3><?= __('Two-factor authentication required'); ?></h3>
                        </div>
                        <div class="form-row">
                            <div class="helper-text">
                                <?= __('Thanks for making the internet safer by enabling two-factor authentication.'); ?>
                            </div>
                            <div class="helper-text">
                                <?= __('Please enter the one-time code generated by your authenticator app'); ?>
                            </div>
                        </div>
                        <div class="form-row centered">
                            <input type="hidden" id="pachno_username" name="username" value="<?= $pachno_user->getUsername(); ?>">
                            <input type="hidden" name="session_token" value="<?= $session_token; ?>">
                            <input type="hidden" name="forward_login_on_ok" value="1">
                            <input type="text" id="pachno_2fa_code" name="2fa_code" class="code-input-6 name-input-enhance" pattern="\d{6}">
                            <label for="pachno_2fa_code"><?= __('Generated code'); ?></label>
                        </div>
                        <div class="form-row" id="login-error-container">
                            <div class="error" id="login-error-message"></div>
                        </div>
                        <div class="form-row submit-container">
                            <a href="<?= make_url('auth_logout'); ?>" class="button secondary"><?= __('Never mind'); ?></a>
                            <button type="submit" id="login_button" class="button primary"><span><?= __('Authenticate'); ?></span><?= fa_image_tag('spinner', ['class' => 'fa-spin icon indicator']); ?></button>
                        </div>
                    </form>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    Pachno.on(Pachno.EVENTS.ready, () => {
        $('#pachno_2fa_code').focus();
    });
</script>
