<?php

    namespace pachno\core\modules\main\cli\entities\tbg;

    use pachno\core\entities\BoardColumn;
    use pachno\core\entities\common\IdentifiableScoped;
    use pachno\core\entities\Issuetype;
    use pachno\core\entities\Project;
    use pachno\core\entities\SavedSearch;

    /**
     * Agile board class
     *
     * @package pachno
     * @subpackage agile
     *
     * @Table(name="\pachno\core\modules\main\cli\entities\tbg\tables\AgileBoards")
     */
    class AgileBoard extends IdentifiableScoped
    {

        public const TYPE_GENERIC = 0;

        public const TYPE_SCRUM = 1;

        public const TYPE_KANBAN = 2;

        public const SWIMLANES_ISSUES = 'issues';

        public const SWIMLANES_GROUPING = 'grouping';

        public const SWIMLANES_EXPEDITE = 'expedite';

        /**
         * The name of the board
         *
         * @var string
         * @Column(type="string", length=200)
         */
        protected $_name;

        /**
         * Board description
         *
         * @var string
         * @Column(type="string", length=200)
         */
        protected $_description;

        /**
         * Whether this board is the private
         *
         * @var boolean
         * @Column(type="boolean", default=1)
         */
        protected $_is_private = true;

        /**
         * @var User
         * @Column(type="integer", length=10)
         * @Relates(class="\pachno\core\entities\User")
         */
        protected $_user_id;

        /**
         * @var Project
         * @Column(type="integer", length=10)
         * @Relates(class="\pachno\core\entities\Project")
         */
        protected $_project_id;

        /**
         * @var Issuetype
         * @Column(type="integer", length=10)
         * @Relates(class="\pachno\core\entities\Issuetype")
         */
        protected $_epic_issuetype_id;

        /**
         * @var Issuetype
         * @Column(type="integer", length=10)
         * @Relates(class="\pachno\core\entities\Issuetype")
         */
        protected $_task_issuetype_id;

        /**
         * @var SavedSearch
         * @Column(type="integer", length=10)
         * @Relates(class="\pachno\core\entities\SavedSearch")
         */
        protected $_backlog_search_id;

        /**
         * @var integer
         * @Column(type="integer", length=10)
         */
        protected $_autogenerated_search = SavedSearch::PREDEFINED_SEARCH_PROJECT_OPEN_ISSUES_INCLUDING_SUBPROJECTS;

        /**
         * The board type
         *
         * @var integer
         * @Column(type="integer", length=10)
         */
        protected $_type = self::TYPE_SCRUM;

        /**
         * Whether to use swimlanes
         *
         * @var boolean
         * @Column(type="boolean", default=false)
         */
        protected $_use_swimlanes = false;

        protected $_swimlanes = [];

        /**
         * Swimlane type
         *
         * @var string
         * @Column(type="string", length=50, default="issuetype")
         */
        protected $_swimlane_type = self::SWIMLANES_ISSUES;

        /**
         * Swimlane identifier field
         *
         * @var string
         * @Column(type="string", length=50, default="issuetype")
         */
        protected $_swimlane_identifier = "issuetype";

        /**
         * Swimlane field value
         *
         * @var array
         * @Column(type="serializable", length=500)
         */
        protected $_swimlane_field_values = [];

        /**
         * Cached search object
         * @var SavedSearch
         */
        protected $_search_object;

        /**
         * Array of epic issues
         *
         * @var array|Issue
         */
        protected $_epic_issues = null;

        /**
         * Board columns
         *
         * @var array|BoardColumn
         * @Relates(class="\pachno\core\entities\BoardColumn", collection=true, foreign_column="board_id", orderby="sort_order")
         */
        protected $_board_columns = null;

        /**
         * Issue field value
         *
         * @var array
         * @Column(type="serializable", length=500)
         */
        protected $_issue_field_values = [];

    }
