/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./js/index.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./i18n/en_US/strings.json":
/*!*********************************!*\
  !*** ./i18n/en_US/strings.json ***!
  \*********************************/
/*! exports provided: agile, default */
/***/ (function(module) {

module.exports = JSON.parse("{\"agile\":{\"add_card\":\"Add card\",\"add_card_here\":\"Add card here\"}}");

/***/ }),

/***/ "./js/classes/board.js":
/*!*****************************!*\
  !*** ./js/classes/board.js ***!
  \*****************************/
/*! exports provided: SwimlaneTypes, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function($) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SwimlaneTypes", function() { return SwimlaneTypes; });
/* harmony import */ var _tools_tools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../tools/tools */ "./js/tools/tools.js");
/* harmony import */ var _swimlane__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./swimlane */ "./js/classes/swimlane.js");
/* harmony import */ var _helpers_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../helpers/ui */ "./js/helpers/ui.js");
/* harmony import */ var _widgets_editor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../widgets/editor */ "./js/widgets/editor.js");
function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }





var SwimlaneTypes = {
  NONE: '',
  ISSUES: 'issues',
  GROUPING: 'grouping',
  EXPEDITE: 'expedite'
};
var BoardTypes = {
  GENERIC: 0,
  SCRUM: 1,
  KANBAN: 2
};

var Board = /*#__PURE__*/function () {
  function Board(board_json) {
    _classCallCheck(this, Board);

    this.id = undefined;
    this.background_color = undefined;
    this.background_file_url = undefined;
    this.name = undefined;
    this.type = undefined;
    this.whiteboardUrl = undefined;
    this.swimlane_type = undefined;
    this.swimlane_identifier = undefined;
    this.swimlane_field_values = undefined;
    this.report_issue_url = undefined;
    /**
     * Swimlanes
     * @type {Swimlane[]}
     */

    this.swimlanes = undefined;
    this.columns = undefined;
    this.users = new Set();
    this.selected_milestone_id = 0;
    this.updateSelectedMilestone();
    this.setJson(board_json);
    this.setupListeners();
    $('#planning_indicator').hide();
    $('#planning_filter_title_input').prop('disabled', false);
  }

  _createClass(Board, [{
    key: "setJson",
    value: function setJson(board_json) {
      var _this = this;

      var fetchSwimlanes = this.type !== board_json.type || this.swimlane_type !== board_json.swimlane_type || this.swimlane_identifier !== board_json.swimlane_identifier || this.swimlane_field_values.length !== board_json.swimlane_field_values.length;

      if (!fetchSwimlanes) {
        if (this.swimlane_field_values.length || board_json.swimlane_field_values.length) {
          var difference = this.swimlane_field_values.filter(function (x) {
            return !board_json.swimlane_field_values.includes(x);
          }).concat(board_json.swimlane_field_values.filter(function (x) {
            return !_this.swimlane_field_values.includes(x);
          }));
          fetchSwimlanes = difference.length > 0;
        }
      }

      this.id = board_json.id;
      this.background_color = board_json.background_color;
      this.background_file_url = board_json.background_file_url;
      this.name = board_json.name;
      this.type = parseInt(board_json.type);
      this.whiteboardUrl = board_json.url;
      this.swimlane_type = board_json.swimlane_type;
      this.swimlane_identifier = board_json.swimlane_identifier;
      this.swimlane_field_values = board_json.swimlane_field_values;
      this.columns = board_json.columns;
      this.report_issue_url = board_json.report_issue_url;
      this.updateBackgroundColor();
      this.updateBoardClass();
      this.updateVisibleWhiteboard();

      if (fetchSwimlanes && this.columns.length) {
        this.fetchSwimlanes();
      } else {
        $('#whiteboard_indicator').hide();
      }
    }
  }, {
    key: "updateVisibleWhiteboard",
    value: function updateVisibleWhiteboard(selected_milestone_id) {
      selected_milestone_id = selected_milestone_id || this.selected_milestone_id;
      $('#onboarding-no-board-columns').addClass('hidden');
      $('#onboarding-no-milestones').addClass('hidden');
      $('#onboarding-no-active-sprint').addClass('hidden');
      $('#whiteboard').hide();

      if (!this.columns || !this.columns.length || selected_milestone_id === 0 && this.type === BoardTypes.SCRUM) {
        if (selected_milestone_id === 0 && this.type === BoardTypes.SCRUM) {
          if ($('#selected_milestone_input > .list-item').length > 3) {
            $('#onboarding-no-active-sprint').removeClass('hidden');
          } else {
            $('#onboarding-no-milestones').removeClass('hidden');
          }
        } else {
          $('#onboarding-no-board-columns').removeClass('hidden');
        }
      } else {
        $('#whiteboard').show();
      }
    }
  }, {
    key: "updateBoardClass",
    value: function updateBoardClass() {
      var $container = $('#project_planning');
      $container.removeClass('type-generic');
      $container.removeClass('type-kanban');
      $container.removeClass('type-scrum');

      switch (this.type) {
        case BoardTypes.SCRUM:
          $container.addClass('type-scrum');
          break;

        case BoardTypes.KANBAN:
          $container.addClass('type-kanban');
          break;

        case BoardTypes.GENERIC:
          $container.addClass('type-generic');
          break;
      }
    }
  }, {
    key: "updateSelectedMilestone",
    value: function updateSelectedMilestone() {
      var trigger_reload = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var $selectedInput = $('input[name=selected_milestone]:checked');
      var previous_milestone_id = this.selected_milestone_id;
      this.selected_milestone_id = $selectedInput.length ? parseInt($selectedInput.val()) : 0;
      this.updateVisibleWhiteboard();

      if (this.selected_milestone_id !== previous_milestone_id && trigger_reload) {
        this.fetchSwimlanes();
      }
    }
  }, {
    key: "fetchSwimlanes",
    value: function fetchSwimlanes() {
      var _this2 = this;

      $('#whiteboard .row.swimlane').remove();

      if (this.swimlanes) {
        var _iterator = _createForOfIteratorHelper(this.swimlanes),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var swimlane = _step.value;

            var _iterator2 = _createForOfIteratorHelper(swimlane.issues),
                _step2;

            try {
              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                var issue = _step2.value;
                issue.processed = false;
              }
            } catch (err) {
              _iterator2.e(err);
            } finally {
              _iterator2.f();
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }

      this.users.clear();
      $('#whiteboard_indicator').show();

      if (this.selected_milestone_id !== 0 || this.type !== BoardTypes.SCRUM) {
        Pachno.fetch("".concat(this.whiteboardUrl, "&milestone_id=").concat(this.selected_milestone_id), {
          method: 'GET'
        }).then(function (json) {
          return _this2.setSwimlanes(json.swimlanes);
        });
      } else {
        $('#whiteboard_indicator').hide();
      }
    }
  }, {
    key: "setSwimlanes",
    value: function setSwimlanes(swimlanes) {
      var _this3 = this;

      var $whiteboard_indicator = $('#whiteboard_indicator');

      if (swimlanes.length) {
        this.swimlanes = swimlanes.map(function (json) {
          return new _swimlane__WEBPACK_IMPORTED_MODULE_1__["default"](json, _this3.id);
        });
        this.updateWhiteboard();
      } else {
        this.swimlanes = swimlanes;
        $whiteboard_indicator.hide();
      }
    }
  }, {
    key: "updateBackgroundColor",
    value: function updateBackgroundColor(_color) {
      var color = _color !== null && _color !== void 0 ? _color : this.background_color;
      var $main_container = $('#main_container');

      if (this.background_file_url !== '' || color !== '') {
        $main_container.css({
          backgroundColor: color
        });
        $main_container.addClass('shaded');
        $('.shadeable').addClass('shaded');
      } else {
        $main_container.css({
          backgroundColor: '#FFF'
        });
        $main_container.removeClass('shaded');
        $('.shadeable').removeClass('shaded');
      }
    }
  }, {
    key: "verifySwimlanes",
    value: function verifySwimlanes() {
      var $whiteboard_content = $('#whiteboard-content');
      var has_swimlanes = false;

      var _iterator3 = _createForOfIteratorHelper(this.swimlanes),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var swimlane = _step3.value;

          if ($(".swimlane[data-swimlane-identifier=".concat(swimlane.identifier, "]")).length) {
            has_swimlanes = true;
            continue;
          }

          var swimlane_html = "<div class=\"row swimlane empty\" data-swimlane-identifier=\"".concat(swimlane.identifier, "\"></div>");
          var $swimlane = $(swimlane_html);

          if (this.swimlane_type !== SwimlaneTypes.NONE) {
            var header_name = '';

            if (swimlane.identifier_issue) {
              var closed_class = swimlane.identifier_issue.closed ? 'closed' : '';
              header_name = '<span class="issue-container">';
              header_name += "<a class=\"issue-number\" href=\"".concat(swimlane.identifier_issue.href, "\">").concat(swimlane.identifier_issue.issue_no, "</a>");
              header_name += "<span class=\"name issue_header ".concat(closed_class, "\">").concat(swimlane.identifier_issue.title, "</span>");
              header_name += '</span>';
              header_name += "<button class=\"button secondary highlight button-report-issue trigger-backdrop\" data-additional-params=\"parent_issue_id=".concat(swimlane.identifier_issue.id, "\">").concat(Pachno.T.agile.add_card_here, "</button>");
            } else {
              header_name = "<span class=\"name\">".concat(swimlane.name, "</span>");
            }

            var header_html = "<div class=\"swimlane-header\"><div class=\"header\">".concat(header_name, "</div>");
            $swimlane.append(header_html);
          }

          $swimlane.append("<div class=\"columns-container scroll-sync\" id=\"".concat(swimlane.identifier, "-columns\"><div class=\"columns\"></div></div>"));

          if (has_swimlanes && $(".swimlane[data-swimlane-identifier=\"swimlane_0\"]").length) {
            $(".swimlane[data-swimlane-identifier=\"swimlane_0\"]").prepend($swimlane);
          } else {
            $whiteboard_content.append($swimlane);
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
    }
  }, {
    key: "verifyColumns",
    value: function verifyColumns() {
      var _iterator4 = _createForOfIteratorHelper(this.swimlanes),
          _step4;

      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var swimlane = _step4.value;
          var $swimlane = $(".swimlane[data-swimlane-identifier=".concat(swimlane.identifier, "]"));
          var columnCount = this.columns.length;
          var paddingCount = columnCount - 1;
          $swimlane.css({
            width: "calc(300px * ".concat(columnCount, " + .5em * ").concat(paddingCount, ")")
          });
          var $swimlaneColumnsContainer = $(".swimlane[data-swimlane-identifier=".concat(swimlane.identifier, "] .columns"));

          var _iterator5 = _createForOfIteratorHelper(this.columns),
              _step5;

          try {
            for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
              var column = _step5.value;
              var status_ids = column.status_ids.join(',');
              var column_id = "swimlane_".concat(swimlane.identifier, "_column_").concat(column.id);

              if ($("#".concat(column_id)).length) {
                continue;
              }

              var html = "<div class=\"column\" id=\"".concat(column_id, "\" data-swimlane-identifier=\"").concat(swimlane.identifier, "\" data-column-id=\"").concat(column.id, "\" data-status-ids=\"").concat(status_ids, "\">");

              if (this.swimlane_type === SwimlaneTypes.NONE) {
                html += "\n                            <div class=\"form-container\">\n                                <div class=\"row\">\n                                    <div class=\"form name\">\n                                        <div class=\"form-row\">\n                                            <span class=\"input invisible trigger-report-issue\" data-status-ids=\"".concat(status_ids, "\">\n                                                <span class=\"placeholder\">").concat(_helpers_ui__WEBPACK_IMPORTED_MODULE_2__["default"].fa_image_tag('plus'), "<span>").concat(Pachno.T.agile.add_card, "</span></span>\n                                            </span>\n                                        </div>\n                                    </div>\n                                </div>\n                            </div>\n                        ");
              }

              html += '</div>';
              $swimlaneColumnsContainer.append(html);
            }
          } catch (err) {
            _iterator5.e(err);
          } finally {
            _iterator5.f();
          }
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }
    }
  }, {
    key: "verifyIssues",
    value: function verifyIssues() {
      var _this4 = this;

      var _iterator6 = _createForOfIteratorHelper(this.columns),
          _step6;

      try {
        var _loop = function _loop() {
          var column = _step6.value;

          var isInColumn = function isInColumn(issue) {
            return issue.status.id && column.status_ids.includes(issue.status.id);
          };

          var num_issues = {};

          var _iterator7 = _createForOfIteratorHelper(column.status_ids),
              _step7;

          try {
            for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
              var status_id = _step7.value;
              num_issues["status_".concat(status_id)] = 0;
            }
          } catch (err) {
            _iterator7.e(err);
          } finally {
            _iterator7.f();
          }

          var _iterator8 = _createForOfIteratorHelper(_this4.swimlanes),
              _step8;

          try {
            for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
              var swimlane = _step8.value;
              var $swimlane = $("#swimlane_".concat(swimlane.identifier, "_column_").concat(column.id));
              var $add_card_form = $("#swimlane_".concat(swimlane.identifier, "_column_").concat(column.id, " .form-container"));
              var $swimlaneContainer = $swimlane.parents('.swimlane');

              var _iterator10 = _createForOfIteratorHelper(swimlane.issues),
                  _step10;

              try {
                for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
                  var issue = _step10.value;
                  if (!isInColumn(issue)) continue;
                  num_issues["status_".concat(issue.status.id)] += 1;
                  if (issue.processed) continue;

                  if (issue.assignee && issue.assignee.type == 'user') {
                    _this4.users.add(JSON.stringify(issue.assignee));
                  }

                  $swimlaneContainer.removeClass('empty');

                  if (_this4.swimlane_type == SwimlaneTypes.NONE) {
                    $add_card_form.before(issue.element);
                  } else {
                    $swimlane.append(issue.element);
                  }

                  issue.processed = true;
                }
              } catch (err) {
                _iterator10.e(err);
              } finally {
                _iterator10.f();
              }
            }
          } catch (err) {
            _iterator8.e(err);
          } finally {
            _iterator8.f();
          }

          var count_total = 0;
          var $primary_count = $(".column[data-column-id=".concat(column.id, "] .column-count.primary"));

          var _iterator9 = _createForOfIteratorHelper(column.status_ids),
              _step9;

          try {
            for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
              var _status_id = _step9.value;
              $(".column-count[data-status-id=".concat(_status_id, "]")).html(num_issues["status_".concat(_status_id)]);
              count_total += parseInt(num_issues["status_".concat(_status_id)]);
            }
          } catch (err) {
            _iterator9.e(err);
          } finally {
            _iterator9.f();
          }

          if ($primary_count.length) {
            $primary_count.html(count_total);
          }
        };

        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          _loop();
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }
    }
  }, {
    key: "updateWhiteboard",
    value: function updateWhiteboard() {
      try {
        var $whiteboard_indicator = $('#whiteboard_indicator');
        var $whiteboard = $('#whiteboard');

        if (!$whiteboard.length) {
          $whiteboard_indicator.hide();
          return;
        }

        $whiteboard.removeClass('initialized');

        if (this.swimlane_type !== SwimlaneTypes.NONE) {
          $whiteboard.removeClass('no-swimlanes');
          $whiteboard.addClass('swimlanes');
        } else {
          $whiteboard.removeClass('swimlanes');
          $whiteboard.addClass('no-swimlanes');
        }

        $whiteboard.addClass('initialized');
        this.verifySwimlanes();
        this.verifyColumns();
        this.verifyIssues();
        this.updateAssigneesList();
        var $buttons = $('.button-report-issue');
        var url = this.selected_milestone_id ? this.report_issue_url + "&milestone_id=".concat(this.selected_milestone_id) : this.report_issue_url;
        $buttons.each(function () {
          var $button = $(this);
          $button.data('original-url', $button.data('url'));

          if ($button.data('additional-params')) {
            $button.data('url', url + '&' + $button.data('additional-params'));
          } else {
            $button.data('url', url);
          }
        });
        $whiteboard_indicator.hide();
      } catch (error) {
        console.trace(error);
        console.error(error);
      }
    }
  }, {
    key: "updateAssigneesList",
    value: function updateAssigneesList() {
      var $avatar_container = $('#board-assignees-list');
      $avatar_container.html('');

      var _iterator11 = _createForOfIteratorHelper(this.users),
          _step11;

      try {
        for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
          var assignee = _step11.value;
          var assignee_json = JSON.parse(assignee);
          $avatar_container.append("<span class=\"avatar-container\"><span class=\"avatar medium\"><img src=\"".concat(assignee_json.avatar_url_small, "\"></span><span class=\"name-container\"><span class=\"name\">").concat(assignee_json.display_name, "</span><span class=\"username\">@").concat(assignee_json.username, "</span></span></span>"));
        }
      } catch (err) {
        _iterator11.e(err);
      } finally {
        _iterator11.f();
      }
    }
  }, {
    key: "filterInput",
    value: function filterInput(event) {
      var $filter_input = $(event.target);
      var value = $filter_input.val();

      if (value.length >= 3 || value.length == 0) {
        var $planning_indicator = $('#planning_indicator');
        $planning_indicator.show();
        var $project_planning = $('#project_planning');

        if (value !== '') {
          var matching = new RegExp(value, "i");
          $project_planning.addClass('issue_title_filtered');
          $('.issue-card').each(function () {
            var $issue_card = $(this);

            if ($issue_card.down('.value').innerHTML.search(matching) !== -1) {
              $issue_card.addClass('title_unfiltered');
            } else {
              $issue_card.removeClass('title_unfiltered');
            }
          });
        } else {
          $project_planning.removeClass('issue_title_filtered');
          $('.issue-card').each().removeClass('title_unfiltered');
        }

        $planning_indicator.hide();
      }
    }
  }, {
    key: "retrieveMilestoneStatus",
    value: function retrieveMilestoneStatus() {
      var $milestone_input = $('#selected_milestone_input');
      var milestone_id = $milestone_input.data('selected-value');

      if (milestone_id) {
        Pachno.fetch($milestone_input.data('status-url'), {
          additional_params: 'milestone_id=' + parseInt(milestone_id) + '&board_id=' + this.id,
          method: 'GET',
          loading: {
            hide: 'selected_milestone_status_details',
            indicator: '#selected_milestone_status_indicator'
          },
          success: {
            update: '#selected_milestone_status_details',
            show: 'selected_milestone_status_details',
            callback: function callback() {
              $('#reportissue_button').data('milestone-id', milestone_id);
            }
          }
        });
      }
    }
  }, {
    key: "addIssue",
    value: function addIssue(issue_json) {
      var issue = new Issue(issue_json, this.id);

      if (this.swimlane_type === SwimlaneTypes.ISSUES && this.swimlane_identifier === "issuetype" && this.swimlane_field_values.includes(issue.issue_type.id)) {
        var swimlane = new _swimlane__WEBPACK_IMPORTED_MODULE_1__["default"]({
          issues: [],
          name: issue.title,
          identifier_type: "issues",
          identifier_grouping: "issuetype",
          has_identifiables: true,
          identifier_issue: issue_json,
          identifier: 'swimlane_' + issue.id
        }, this.id);
        this.swimlanes.splice(this.swimlanes.length - 1, 0, swimlane);
      } else {
        var _iterator12 = _createForOfIteratorHelper(this.swimlanes),
            _step12;

        try {
          for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
            var _swimlane = _step12.value;

            if (_swimlane.has(issue)) {
              _swimlane.addIssue(issue);
            }
          }
        } catch (err) {
          _iterator12.e(err);
        } finally {
          _iterator12.f();
        }
      }

      this.updateWhiteboard();
    }
  }, {
    key: "addColumn",
    value: function addColumn(column, swimlanes) {
      var _this5 = this;

      this.columns.push(column);

      if (this.swimlanes === undefined || !this.swimlanes.length) {
        this.setSwimlanes(swimlanes);
      } else {
        var _iterator13 = _createForOfIteratorHelper(swimlanes),
            _step13;

        try {
          var _loop2 = function _loop2() {
            var swimlane = _step13.value;

            var board_swimlane = _this5.swimlanes.find(function (lane) {
              return lane.identifier == swimlane.identifier;
            });

            board_swimlane.addIssues(swimlane.issues);
          };

          for (_iterator13.s(); !(_step13 = _iterator13.n()).done;) {
            _loop2();
          }
        } catch (err) {
          _iterator13.e(err);
        } finally {
          _iterator13.f();
        }
      }

      var _iterator14 = _createForOfIteratorHelper(this.columns),
          _step14;

      try {
        for (_iterator14.s(); !(_step14 = _iterator14.n()).done;) {
          var _column = _step14.value;

          var _iterator15 = _createForOfIteratorHelper(_column.status_ids),
              _step15;

          try {
            for (_iterator15.s(); !(_step15 = _iterator15.n()).done;) {
              var status_id = _step15.value;
              $("#add_next_column_status_".concat(status_id)).attr('disabled', true);
              $("label[for=add_next_column_status_".concat(status_id, "]")).addClass('disabled');
            }
          } catch (err) {
            _iterator15.e(err);
          } finally {
            _iterator15.f();
          }
        }
      } catch (err) {
        _iterator14.e(err);
      } finally {
        _iterator14.f();
      }

      this.updateWhiteboard();
    }
  }, {
    key: "setupListeners",
    value: function setupListeners() {
      var board = this;
      var $body = $('body');
      $body.on('click', '#selected_milestone_input li', function (event) {
        var $input = $(event.target);
        var milestone_id = $input.data('input-value');
        board.retrieveMilestoneStatus(board.id, milestone_id);
      });
      $body.on('click', '.trigger-whiteboard-toggle-add-first-column', function (event) {
        var $container = $('#add-first-column-button-container');
        $container.toggleClass('active');

        if ($container.hasClass('active')) {
          $('#first-column-name').focus();
        }
      });
      $body.on('click', '.trigger-whiteboard-toggle-add-next-column', function (event) {
        var $container = $('#add-next-column-input-container');
        $container.toggleClass('toggle-card');

        if ($container.hasClass('toggle-card')) {
          $('#next-column-name').focus();
        }
      });
      $body.on('mouseover', '.backdrop_box .color-picker', function () {
        $('#fullpage_backdrop').addClass('see-through');
      });
      $body.on('mouseout', '.backdrop_box .color-picker', function () {
        $('#fullpage_backdrop').removeClass('see-through');
      });
      $body.on('change', '.backdrop_box .color-picker input', function (event) {
        var checkbox = $(event.target);

        if (checkbox.prop('checked')) {
          board.updateBackgroundColor(checkbox.val());
        }
      });
      var watchedForms = new Set();
      $body.off('click', '#issue-card-popup .formatted-text-container');
      $body.on('click', '#issue-card-popup .formatted-text-container', function () {
        var $editorContainer = $(this).next();
        var $textarea = $editorContainer.find('textarea');
        var $form = $(this).parents('form');
        var editor = Object(_widgets_editor__WEBPACK_IMPORTED_MODULE_3__["getEditor"])($textarea.attr('id')); // debugger;
        // editor.focus();

        editor.codemirror.off('blur');
        editor.codemirror.on('blur', function () {
          $editorContainer.parents('form').submit();
        });
        $form.addClass('editing');
        watchedForms.add($form.attr('id'));
        setTimeout(function () {
          editor.codemirror.focus();
        }, 250);
      });
      Pachno.on(Pachno.EVENTS.formSubmitResponse, function (PachnoApplication, data) {
        var json = data.json;

        if (watchedForms.has(data.form)) {
          var $form = $("#".concat(data.form));
          $form.find('.formatted-text-container').html(json.changed[$form.data('field')].value);
          $form.removeClass('editing');
        }
      });
      var $filter_input = $('#planning_filter_title_input');
      $filter_input.on('keyup', Object(_tools_tools__WEBPACK_IMPORTED_MODULE_0__["debounce"])(this.filterInput, 250).bind(this));
      Pachno.on(Pachno.EVENTS.formSubmitResponse, function (PachnoApplication, data) {
        var json = data.json;

        switch (data.form) {
          case 'edit-agileboard-form':
            board.setJson(json.board);
            break;

          case 'report_issue_form':
            board.addIssue(json.issue);
            break;

          case 'add-first-column-form':
          case 'add-another-column-form':
            var $container = $('#add-next-column-input-container');
            $container.before(json.component);
            $container.removeClass('toggle-card');
            board.addColumn(json.column, json.swimlanes);
            $('#add-another-column-form').trigger("reset");
            board.updateVisibleWhiteboard();
            break;

          case 'edit_milestone_form':
            $('#milestone-list-no-milestones').hide();
            $('#milestone-list-separator').after(json.component);
            $("#selected_milestone_".concat(json.milestone.id)).prop('checked', true);
            board.updateSelectedMilestone(true);
            break;
        }
      });
    }
  }]);

  return Board;
}();

/* harmony default export */ __webpack_exports__["default"] = (Board);
window.Board = Board;
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./js/classes/debugger.js":
/*!********************************!*\
  !*** ./js/classes/debugger.js ***!
  \********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_fetch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/fetch */ "./js/helpers/fetch.js");
/* harmony import */ var _pachno__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./pachno */ "./js/classes/pachno.js");
function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }





var Debugger = /*#__PURE__*/function () {
  function Debugger(debug_url) {
    _classCallCheck(this, Debugger);

    this.debug_url = debug_url;
    this.calls = [];
    Object(_helpers_fetch__WEBPACK_IMPORTED_MODULE_1__["setFetchDebugger"])(this);
  }

  _createClass(Debugger, [{
    key: "loadDebugInfo",
    value: function loadDebugInfo(debug_id, cb) {
      var url = this.debug_url.replace('___debugid___', debug_id);
      _pachno__WEBPACK_IMPORTED_MODULE_2__["default"].fetch(url, {
        method: 'GET',
        loading: {
          indicator: '#___PACHNO_DEBUG_INFO___indicator'
        },
        success: {
          update: '#___PACHNO_DEBUG_INFO___'
        },
        complete: {
          callback: cb,
          show: '#___PACHNO_DEBUG_INFO___'
        },
        debug: false
      });
    }
  }, {
    key: "updateDebugInfo",
    value: function updateDebugInfo(information) {
      this.calls.push(information);
      var $logAjaxItems = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#log_ajax_items');

      if ($logAjaxItems) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#log_ajax_items').html('');

        if (jquery__WEBPACK_IMPORTED_MODULE_0___default()('#debug_ajax_count')) {
          jquery__WEBPACK_IMPORTED_MODULE_0___default()('#debug_ajax_count').html(this.calls.length);
        }

        var ct = function ct(time) {
          return time < 10 ? '0' + time : time;
        };

        var _iterator = _createForOfIteratorHelper(this.calls),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var info = _step.value;
            var content = '<li><span class="badge timestamp">' + ct(info.time.getHours()) + ':' + ct(info.time.getMinutes()) + ':' + ct(info.time.getSeconds()) + '.' + ct(info.time.getMilliseconds()) + '</span><span class="badge timing"><i class="far fa-clock"></i>' + info.loadtime + '</span><span class="badge timing session" title="Time spent by php loading session data"><i class="far fa-hdd"></i>' + info.session_loadtime + '</span><span class="badge timing calculated" title="Calculated load time, excluding session load time"><i class="fa fa-calculator"></i>' + info.calculated_loadtime + '</span><span class="partial">' + info.location + '</span> <a class="button" style="float: right;" href="javascript:void(0);" onclick="Pachno.loadDebugInfo(\'' + info.debug_id + '\');">Debug</a></li>';
            $logAjaxItems.prepend(content, 'top');
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
    }
  }]);

  return Debugger;
}();

/* harmony default export */ __webpack_exports__["default"] = (Debugger);

/***/ }),

/***/ "./js/classes/issue.js":
/*!*****************************!*\
  !*** ./js/classes/issue.js ***!
  \*****************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _helpers_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../helpers/ui */ "./js/helpers/ui.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_1__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }




var Issue = /*#__PURE__*/function () {
  function Issue(json, board_id) {
    _classCallCheck(this, Issue);

    this.id = json.id;
    this.board_id = board_id;
    this.href = json.href;
    this.title = json.title;
    this.issue_no = json.issue_no;
    this.state = json.state;
    this.closed = json.closed;
    this.deleted = json.deleted;
    this.created_at = json.created_at;
    this.created_at_iso = json.created_at_iso;
    this.updated_at = json.updated_at;
    this.updated_at_iso = json.updated_at_iso;
    this.category = json.category;
    this.priority = json.priority;
    this.severity = json.severity;
    this.more_actions_url = json.more_actions_url;
    this.posted_by = json.posted_by;
    this.assignee = json.assignee;
    this.status = json.status;
    this.card_url = json.card_url;
    this.blocking = json.blocking;
    this.milestone = json.milestone;
    this.number_of_files = json.number_of_files;
    this.number_of_comments = json.number_of_comments;
    this.issue_type = json.issue_type;
    this.parent_issue_id = json.parent_issue_id;
    this.processed = false;
    this.element = this.createHtmlElement();
  }

  _createClass(Issue, [{
    key: "createHtmlElement",
    value: function createHtmlElement() {
      var classes = [];
      if (this.closed) classes.push('issue_closed');
      if (this.blocking) classes.push('blocking');
      var html = "\n<div id=\"whiteboard_issue_".concat(this.id, "\" class=\"whiteboard-issue trigger-backdrop ").concat(classes.join(','), "\" data-issue-id=\"").concat(this.id, "\" data-url=\"").concat(this.card_url, "/board_id/").concat(this.board_id, "\">\n    <div class=\"issue-header\">\n        <span class=\"issue-number\">").concat(this.issue_no, "</span>\n        <span class=\"issue-title\">").concat(this.title, "</span>\n        <div class=\"dropper-container\">\n            <button class=\"button icon dropper dynamic_menu_link\" type=\"button\">").concat(_helpers_ui__WEBPACK_IMPORTED_MODULE_0__["default"].fa_image_tag('ellipsis-v'), "</button>\n            <div class=\"dropdown-container dynamic_menu\" data-menu-url=\"").concat(this.more_actions_url, "\">\n                <div class=\"list-mode\">\n                    <div class=\"list-item disabled\">\n                        <span class=\"icon\">").concat(_helpers_ui__WEBPACK_IMPORTED_MODULE_0__["default"].fa_image_tag('spinner', {
        'classes': 'fa-spin'
      }), "</span>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class=\"issue-info\">\n    </div>\n</div>\n");
      var $html = jquery__WEBPACK_IMPORTED_MODULE_1___default()(html);
      var $info = $html.find('.issue-info');

      if (this.number_of_files > 0) {
        $info.append("<span class=\"attachments\">".concat(_helpers_ui__WEBPACK_IMPORTED_MODULE_0__["default"].fa_image_tag('paperclip'), "<span>").concat(this.number_of_files, "</span></span>"));
      }

      if (this.number_of_comments > 0) {
        $info.append("<span class=\"attachments\">".concat(_helpers_ui__WEBPACK_IMPORTED_MODULE_0__["default"].fa_image_tag('comments', [], 'far'), "<span>").concat(this.number_of_comments, "</span></span>"));
      }

      if (this.assignee !== undefined) {
        if (this.assignee.type == 'user') {
          $info.append("<span class=\"assignee\"><span class=\"avatar medium\"><img src=\"".concat(this.assignee.avatar_url_small, "\"></span></span>"));
        }
      }

      return $html;
    }
  }]);

  return Issue;
}();

/* harmony default export */ __webpack_exports__["default"] = (Issue);
window.Issue = Issue;

/***/ }),

/***/ "./js/classes/issuereporter.js":
/*!*************************************!*\
  !*** ./js/classes/issuereporter.js ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function($) {/* harmony import */ var _helpers_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../helpers/ui */ "./js/helpers/ui.js");
function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }



var IssueReporter = /*#__PURE__*/function () {
  function IssueReporter() {
    _classCallCheck(this, IssueReporter);

    this.setupListeners();
  }

  _createClass(IssueReporter, [{
    key: "updateFields",
    value: function updateFields() {
      var url = $('#report_form').data('fields-url');
      var issue_type_id = document.querySelector('input[name="issuetype_id"]:checked').value;

      if (issue_type_id != 0) {
        $('#report_form_issue_type_selector').addClass('hidden');
      }

      if ($('#project_id').val() != 0 && issue_type_id != 0) {
        $('#report_form').removeClass('hidden');
        Pachno.fetch(url, {
          loading: {
            indicator: '#report_issue_more_options_indicator'
          },
          additional_params: 'issuetype_id=' + issue_type_id
        }).then(function (json) {
          var _iterator = _createForOfIteratorHelper(json.available_fields),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var fieldname = _step.value;
              var $field_container = $("#".concat(fieldname, "_div"));

              if ($field_container.length) {
                if (json.fields[fieldname]) {
                  $field_container.removeClass('hidden');

                  if ($("#".concat(fieldname, "_id"))) {
                    $("#".concat(fieldname, "_id")).prop('disabled', false);
                  }

                  if ($("#".concat(fieldname, "_value"))) {
                    $("#".concat(fieldname, "_value")).prop('disabled', false);
                  }

                  if (json.fields[fieldname].values) {
                    var container = $("#".concat(fieldname, "_div")).find('.dropdown-container');

                    if (container) {
                      container.html('');
                      var markup = "<input type=\"radio\" value=\"\" name=\"".concat(fieldname, "_id\" id=\"report_issue_").concat(fieldname, "_id_0\" class=\"fancy-checkbox\">\n                                                        <label for=\"report_issue_").concat(fieldname, "_id_0\" class=\"list-item\">\n                                                        <span class=\"name value\">Not selected</span>\n                                                        </label>");
                      container.append(markup);

                      for (var opt in json.fields[fieldname].values) {
                        var value = opt.substr(1);
                        var description = json.fields[fieldname].values[opt];

                        var _markup = "<input type=\"radio\" value=\"".concat(value, "\" name=\"").concat(fieldname, "_id\" id=\"report_issue_").concat(fieldname, "_id_").concat(value, "\" class=\"fancy-checkbox\">\n                                                        <label for=\"report_issue_").concat(fieldname, "_id_").concat(value, "\" class=\"list-item\">\n                                                        <span class=\"name value\">").concat(description, "</span>\n                                                        </label>");

                        container.append(_markup);
                      }
                    }
                  }

                  json.fields[fieldname].required ? $("#".concat(fieldname, "_label")).addClass('required') : $("#".concat(fieldname, "_label")).removeClass('required');
                } else {
                  if ($("#".concat(fieldname, "_div"))) {
                    $("#".concat(fieldname, "_div")).addClass('hidden');
                  }

                  if ($("#".concat(fieldname, "_id"))) {
                    $("#".concat(fieldname, "_id")).prop('disabled', true);
                  }

                  if ($("#".concat(fieldname, "_value"))) {
                    $("#".concat(fieldname, "_value")).prop('disabled', true);
                  }
                }
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }

          $('#report_issue_title_input').focus();
          $('#report_issue_more_options_indicator').hide();
        });
      } else {
        $('#report_form_issue_type_selector').removeClass('hidden');
        $('#report_form').addClass('hidden');
        var $reportissueContainer = $('#reportissue_container');
        $reportissueContainer.removeClass('huge');
        $reportissueContainer.addClass('large');
      }
    }
  }, {
    key: "setupListeners",
    value: function setupListeners() {
      var $body = $('body');
      var reporter = this;
      $body.off('click', 'input[type=radio].report-issue-type-selector');
      $body.on('click', 'input[type=radio].report-issue-type-selector', function (event) {
        reporter.updateFields();
      });
      $body.off('click', '.restart-reportissue-form');
      $body.on('click', '.restart-reportissue-form', function (event) {
        event.preventDefault();
        $('#issue-reported-confirmation').addClass('hidden');
        $('#report_form_issue_type_selector').removeClass('hidden');
        $('#report_form').addClass('hidden');
      });
      $body.off('click', '#issuetype_list .list-item');
      $body.on('click', '#issuetype_list .list-item', function (event) {
        event.preventDefault();
        var $issueType = $(this);
        var $reportissueContainer = $('#reportissue_container');
        $('#report_issue_issue_type_' + $issueType.data('id')).click();
        $reportissueContainer.addClass('huge');
        $reportissueContainer.removeClass('large');
      });
      Pachno.on(Pachno.EVENTS.formSubmitResponse, function (PachnoApplication, data) {
        var json = data.json;

        switch (data.form) {
          case 'report_issue_form':
            $('#report_issue_form')[0].reset();
            $('#report_form').addClass('hidden');
            $('#issue-reported-confirmation').removeClass('hidden');
            var $reportissueContainer = $('#reportissue_container');
            $reportissueContainer.removeClass('huge');
            $reportissueContainer.addClass('large');
            var $reportedIssueLink = $('#reported-issue-container');
            var issue = json.issue;
            $reportedIssueLink.attr('href', issue.href);
            $reportedIssueLink.html("".concat(_helpers_ui__WEBPACK_IMPORTED_MODULE_0__["default"].fa_image_tag(issue.issue_type.fa_icon, {
              classes: "icon issuetype-icon issuetype-".concat(issue.issue_type.type)
            }), "<span class=\"name\">").concat(issue.issue_no, " - ").concat(issue.title, "</span>").concat(_helpers_ui__WEBPACK_IMPORTED_MODULE_0__["default"].fa_image_tag('external-link-alt')));
            break;
        }
      });
    }
  }]);

  return IssueReporter;
}();

/* harmony default export */ __webpack_exports__["default"] = (IssueReporter);
window.IssueReporter = IssueReporter;
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./js/classes/milestone.js":
/*!*********************************!*\
  !*** ./js/classes/milestone.js ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _helpers_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../helpers/ui */ "./js/helpers/ui.js");
/* harmony import */ var _issue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./issue */ "./js/classes/issue.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_2__);
function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }





var Milestone = /*#__PURE__*/function () {
  function Milestone(json) {
    _classCallCheck(this, Milestone);

    this.id = json.id;
    this.is_closed = json.closed;
    this.is_sprint = json.is_sprint;
    this.name = json.name;
    this.starting_date = json.starting_date;
    this.scheduled_date = json.scheduled_date;
    this.percentage_complete = json.percentage_complete;
    this.issues_count = json.issues_count;
    this.url = json.url;
    /**
     * @type {Issue[]}
     */

    this.issues = [];
    this.element = this.createHtmlElement();
  }

  _createClass(Milestone, [{
    key: "createHtmlElement",
    value: function createHtmlElement() {
      var classes = [];
      if (this.is_closed) classes.push('milestone-closed');
      var html = "\n<div class=\"milestone-container ".concat(classes.join(','), "\" data-milestone-id=\"").concat(this.id, "\">\n    <div class=\"milestone milestone-card\">\n        <div class=\"header\">\n            <span class=\"name\">").concat(this.name, "</span>\n            <span class=\"info\">\n                <span class=\"info-item\">").concat(_helpers_ui__WEBPACK_IMPORTED_MODULE_0__["default"].fa_image_tag('file-alt', {}, 'far'), "&nbsp;").concat(this.issues_count, "</span>\n                <span class=\"icon expander\">").concat(_helpers_ui__WEBPACK_IMPORTED_MODULE_0__["default"].fa_image_tag('spinner', {
        classes: 'fa-spin indicator'
      }, 'far')).concat(_helpers_ui__WEBPACK_IMPORTED_MODULE_0__["default"].fa_image_tag('chevron-down'), "</span>\n            </span>\n        </div>\n        <div class=\"issues\"></div>\n    </div>\n</div>\n");
      var $html = jquery__WEBPACK_IMPORTED_MODULE_2___default()(html);
      return $html;
    }
  }, {
    key: "addIssues",
    value: function addIssues(issues) {
      var _iterator = _createForOfIteratorHelper(issues),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var issue_json = _step.value;
          this.issues.push(new _issue__WEBPACK_IMPORTED_MODULE_1__["default"](issue_json));
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
  }, {
    key: "addIssue",
    value: function addIssue(issue) {
      this.issues.push(issue);
    }
  }, {
    key: "fetchIssues",
    value: function fetchIssues() {
      var _this = this;

      Pachno.fetch(this.url, {
        method: 'GET'
      }).then(function (json) {
        _this.addIssues(json.milestone.issues);

        _this.verifyIssues();
      });
    }
  }, {
    key: "verifyIssues",
    value: function verifyIssues() {
      var _iterator2 = _createForOfIteratorHelper(this.issues),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var issue = _step2.value;

          if (issue.processed) {
            continue;
          }

          this.element.find('.issues').append(issue.element);
          issue.processed = true;
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  }, {
    key: "getHtmlElement",
    value: function getHtmlElement() {
      return this.element;
    }
  }]);

  return Milestone;
}();

window.Milestone = Milestone;
/* harmony default export */ __webpack_exports__["default"] = (Milestone);

/***/ }),

/***/ "./js/classes/pachno.js":
/*!******************************!*\
  !*** ./js/classes/pachno.js ***!
  \******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_openid__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/openid */ "./js/helpers/openid.js");
/* harmony import */ var _debugger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./debugger */ "./js/classes/debugger.js");
/* harmony import */ var _helpers_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../helpers/ui */ "./js/helpers/ui.js");
/* harmony import */ var _helpers_fetch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../helpers/fetch */ "./js/helpers/fetch.js");
/* harmony import */ var _widgets__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../widgets */ "./js/widgets/index.js");
/* harmony import */ var _helpers_profile__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../helpers/profile */ "./js/helpers/profile.js");
/* harmony import */ var _helpers_dashboard__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../helpers/dashboard */ "./js/helpers/dashboard.js");
/* harmony import */ var _board__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./board */ "./js/classes/board.js");
/* harmony import */ var _search__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./search */ "./js/classes/search.js");
/* harmony import */ var _issuereporter__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./issuereporter */ "./js/classes/issuereporter.js");
/* harmony import */ var _uploader__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./uploader */ "./js/classes/uploader.js");
/* harmony import */ var _roadmap__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./roadmap */ "./js/classes/roadmap.js");
/* harmony import */ var _i18n_en_US_strings_json__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../i18n/en_US/strings.json */ "./i18n/en_US/strings.json");
var _i18n_en_US_strings_json__WEBPACK_IMPORTED_MODULE_13___namespace = /*#__PURE__*/__webpack_require__.t(/*! ../../i18n/en_US/strings.json */ "./i18n/en_US/strings.json", 1);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }















var translations = {
  en_US: _i18n_en_US_strings_json__WEBPACK_IMPORTED_MODULE_13__
};

var PachnoApplication = /*#__PURE__*/function () {
  _createClass(PachnoApplication, [{
    key: "EVENTS",
    get: function get() {
      return {
        ready: 'pachno-ready',
        formSubmit: 'form-submit',
        formSubmitResponse: 'form-submit-response',
        formSubmitError: 'form-submit-error'
      };
    }
  }, {
    key: "TRIGGERS",
    get: function get() {
      return {
        showLogin: '.trigger-show-login'
      };
    }
  }, {
    key: "T",
    get: function get() {
      return translations[this.language] || translations.en_US;
    }
  }]);

  function PachnoApplication() {
    _classCallCheck(this, PachnoApplication);

    this.debug = false;
    this.basepath = '';
    this.data_url = '';
    this.autocompleter_url = '';
    this["debugger"] = undefined;
    this.listeners = {};
    this.language = document.body.dataset.language;
  }

  _createClass(PachnoApplication, [{
    key: "initialize",
    value: function initialize(options) {
      this.debug = options.debug;
      this.basepath = options.basepath;
      this.data_url = options.dataUrl;
      this.autocompleter_url = options.autocompleterUrl;

      if (this.debug) {
        this["debugger"] = new _debugger__WEBPACK_IMPORTED_MODULE_2__["default"](options.debugUrl);
      }

      this._initialize();
    }
  }, {
    key: "fetch",
    value: function fetch(url, options) {
      return Object(_helpers_fetch__WEBPACK_IMPORTED_MODULE_4__["fetchHelper"])(url, options);
    }
  }, {
    key: "submit",
    value: function submit(url, form_id) {
      return Object(_helpers_fetch__WEBPACK_IMPORTED_MODULE_4__["formSubmitHelper"])(url, form_id);
    }
  }, {
    key: "on",
    value: function on(key, callback) {
      if (this.listeners[key] === undefined) {
        this.listeners[key] = [];
      }

      this.listeners[key].push(callback);
    }
  }, {
    key: "trigger",
    value: function trigger(key, data) {
      var _this = this;

      return new Promise(function (resolve, reject) {
        if (_this.listeners[key] === undefined) {
          return resolve();
        }

        try {
          var promises = [];

          var _iterator = _createForOfIteratorHelper(_this.listeners[key]),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var callback = _step.value;
              promises.push(callback(_this, data));
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }

          Promise.all(promises).then(resolve)["catch"](reject);
        } catch (error) {
          reject(error);
        }
      });
    }
  }, {
    key: "setupListeners",
    value: function setupListeners() {
      // $(window).on('resize', Core._resizeWatcher);
      // $(document).on('keydown', Core._escapeWatcher);
      Object(_widgets__WEBPACK_IMPORTED_MODULE_5__["default"])();
      Object(_helpers_fetch__WEBPACK_IMPORTED_MODULE_4__["setupListeners"])();
      Object(_helpers_profile__WEBPACK_IMPORTED_MODULE_6__["default"])(); // $('#fullpage_backdrop_content').on('click', Core._resizeWatcher);
    }
  }, {
    key: "_initialize",
    value: function _initialize() {
      this.setupListeners(); // Core._initializeAutocompleter();
      // $(window).on('scroll', Pachno.Core._scrollWatcher);
      // Core._resizeWatcher();
      // Core._scrollWatcher();

      Object(_helpers_dashboard__WEBPACK_IMPORTED_MODULE_7__["initializeDashboards"])().then(function () {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()('html').css({
          'cursor': 'default'
        });
      });
      _helpers_openid__WEBPACK_IMPORTED_MODULE_1__["default"].init();
    }
  }, {
    key: "loadComponentOptions",
    value: function loadComponentOptions(options, $item) {
      return new Promise(function (resolve, reject) {
        var $container = jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.container),
            $options = jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.options),
            url = $item.data('options-url');
        $options.html('<div><i class="fas fa-spin fa-spinner"></i></div>');
        $container.addClass('active');
        $container.find(options.component).removeClass('active');
        $item.addClass('active');
        Object(_helpers_fetch__WEBPACK_IMPORTED_MODULE_4__["fetchHelper"])(url);
        fetch(url, {
          method: 'GET'
        }).then(function (response) {
          response.json().then(function (json) {
            if (response.ok) {
              $options.html(json.content);
              Pachno.Main.updateWidgets().then(resolve);
            }
          });
        });
      });
    }
  }, {
    key: "UI",
    get: function get() {
      return _objectSpread(_objectSpread({}, _helpers_ui__WEBPACK_IMPORTED_MODULE_3__["default"]), {}, {
        calendars: _widgets__WEBPACK_IMPORTED_MODULE_5__["calendars"]
      });
    }
  }]);

  return PachnoApplication;
}();

var Pachno = new PachnoApplication();
window.Pachno = Pachno;
jquery__WEBPACK_IMPORTED_MODULE_0___default()(document).ready(function () {
  var $body = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno-body');
  var debug = $body.data('debug-mode') == 1;
  var webroot = $body.data('webroot');
  var dataUrl = $body.data('data-url');
  var debugUrl = $body.data('debug-url');
  var autocompleterUrl = $body.data('autocompleter-url');
  Pachno.initialize({
    debug: debug,
    webroot: webroot,
    dataUrl: dataUrl,
    debugUrl: debugUrl,
    autocompleterUrl: autocompleterUrl
  });
  Pachno.trigger(Pachno.EVENTS.ready);
});
/* harmony default export */ __webpack_exports__["default"] = (Pachno);

/***/ }),

/***/ "./js/classes/roadmap.js":
/*!*******************************!*\
  !*** ./js/classes/roadmap.js ***!
  \*******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function($) {/* harmony import */ var _milestone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./milestone */ "./js/classes/milestone.js");
function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }



var Roadmap = /*#__PURE__*/function () {
  function Roadmap(options) {
    _classCallCheck(this, Roadmap);

    this.milestones_url = options.milestones_url;
    /**
     * @type {Milestone[]}
     */

    this.milestones = [];
    this.milestone_types = 'regular';
    this.fetchMilestones();
    this.setupListeners();
  }

  _createClass(Roadmap, [{
    key: "setupListeners",
    value: function setupListeners() {
      var roadmap = this;
      $('input[name=milestone_type]').on('click', function () {
        roadmap.milestone_types = $(this).val();
        roadmap.fetchMilestones();
      });
    }
  }, {
    key: "fetchMilestones",
    value: function fetchMilestones() {
      var _this = this;

      $('#project_roadmap').addClass('loading');
      $('#milestone-cards-container').html('');
      this.milestones = [];
      Pachno.fetch(this.milestones_url + "?milestone_type=".concat(this.milestone_types), {
        method: 'GET'
      }).then(function (json) {
        var _iterator = _createForOfIteratorHelper(json.milestones),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var milestone_json = _step.value;
            var milestone = new _milestone__WEBPACK_IMPORTED_MODULE_0__["default"](milestone_json);

            _this.milestones.push(milestone);
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }

        _this.createMilestoneHtml();
      });
    }
  }, {
    key: "createMilestoneHtml",
    value: function createMilestoneHtml() {
      if (this.milestones.length === 0) {
        $('#onboarding-no-milestones').show();
      } else {
        var $milestones_container = $('#milestone-cards-container');

        var _iterator2 = _createForOfIteratorHelper(this.milestones),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var milestone = _step2.value;

            if ($(".milestone-container[data-milestone-id=".concat(this.id, "]")).length > 0) {
              continue;
            }

            $milestones_container.append(milestone.getHtmlElement());

            if (!milestone.closed) {
              milestone.fetchIssues();
            }
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      }

      $('#project_roadmap').removeClass('loading');
    }
  }]);

  return Roadmap;
}();

window.Roadmap = Roadmap;
/* harmony default export */ __webpack_exports__["default"] = (Roadmap);
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./js/classes/search.js":
/*!******************************!*\
  !*** ./js/classes/search.js ***!
  \******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function($) {function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Search = /*#__PURE__*/function () {
  function Search(options) {
    var _this = this;

    _classCallCheck(this, Search);

    this.save_columns_url = options.save_columns_url;
    this.history_url = options.history_url;
    this.dynamic_callback_url = options.dynamic_callback_url;
    this.project_id = options.project_id;
    this.is_saved = false;
    this.results_loaded = false;
    this.sort_field = undefined;
    this.sort_direction = undefined;
    this.is_dirty = false;
    this.current_result_view = undefined;
    this.result_views = {};
    this.setupListeners().then(function () {
      if (options.show_results) {
        _this.updateResults(true);
      } else {
        _this.updateSavedSearchCounts();
      }
    });
  }

  _createClass(Search, [{
    key: "toggleColumn",
    value: function toggleColumn(column) {
      $('.sc_' + column).toggleClass('hidden');
    }
  }, {
    key: "updateColumnVisibility",
    value: function updateColumnVisibility(event) {
      var $input = $(event.target);
      this.toggleColumn($input.val());
      this.saveColumnVisibility(true);
    }
  }, {
    key: "saveColumnVisibility",
    value: function saveColumnVisibility(force) {
      if (!this.is_saved || force) {
        Pachno.fetch(this.save_columns_url, {
          form: 'find_issues_form',
          method: 'POST'
        });
      }
    }
  }, {
    key: "setGrouping",
    value: function setGrouping(event) {
      event.stopPropagation();
      var $input = $(event.target); // Pachno.Search.setFilterSelectionGroupSelections(this);
      // Pachno.Search.setFilterValue(element, true);

      if ($input.data('groupby') == '') {
        $('#filter_grouping_options .grouporder').addClass('hidden');
      } else {
        $('#filter_grouping_options .grouporder').removeClass('hidden');
      }

      this.updateResults();
    }
  }, {
    key: "updateSavedSearchCounts",
    value: function updateSavedSearchCounts() {
      var search_ids = '';
      var searchitems = $('.savedsearch-item');
      searchitems.each(function (searchitem) {
        search_ids += '&search_ids[]=' + $(searchitem).data('search-id');
      });
      Pachno.fetch(Pachno.data_url, {
        method: 'GET',
        params: "&say=getsearchcounts&project_id=".concat(this.project_id).concat(search_ids),
        success: {
          callback: function callback(json) {
            searchitems.each(function (searchitem) {
              var $badge = $(searchitem).down('.count-badge');

              if ($badge !== undefined) {
                $badge.html(json[$(searchitem).data('search-id')]);
              }
            });
          }
        }
      });
    }
  }, {
    key: "loadDynamicChoices",
    value: function loadDynamicChoices() {
      var filters_containers = [];
      var parameters = '&project_id=' + $('#filter_project_id_value_input').val();
      var $filter_subprojects_value_input = $('#filter_subprojects_value_input');

      if ($filter_subprojects_value_input) {
        parameters += '&subprojects=' + $filter_subprojects_value_input.val();
      }

      ['build', 'component', 'edition', 'milestone'].each(function (elm) {
        var $filter_element = $('#interactive_filter_' + elm);
        var $results_container = $($filter_element.find('.interactive_menu_values'));
        $results_container.find('input[type=checkbox]').each(function () {
          if (this.is(':checked')) {
            parameters += '&existing_ids[' + $filter_element.data('filterkey') + '][' + this.val() + ']=' + this.val();
          }
        });
        filters_containers.push({
          filter: $filter_element,
          container: $results_container
        });
      });
      Pachno.fetch(this.dynamic_callback_url, {
        params: parameters,
        loading: {
          callback: function callback() {
            filters_containers.each(function (details) {
              details['container'].addClass('updating');
            });
          }
        },
        success: {
          callback: function callback(json) {
            filters_containers.each(function (details) {
              details['container'].html(json.results[details['filter'].data('filterkey')]); // window.setTimeout(function () {
              //     var si = details['filter'].down('input[type=search]');
              //     if (si != undefined) {
              //         si.data('previous-value') = '';
              //         Pachno.Search.filterFilterOptionsElement(si);
              //     }
              // }, 250);

              details['container'].removeClass('updating');
            });
          }
        }
      });
    }
  }, {
    key: "checkToggledCheckboxes",
    value: function checkToggledCheckboxes() {
      var num_checked = $('#search-results input[type=checkbox]:checked').length;

      if (num_checked == 0) {
        $('#search-bulk-actions').addClass('unavailable');
        $('#bulk_action_submit').addClass('disabled');
      } else {
        $('#search-bulk-actions').removeClass('unavailable');
        var selected_radio_value = $('#search-bulk-action-form input[name=search_bulk_action]:checked', '#search-bulk-action-form').val();

        if (selected_radio_value) {
          $('#bulk_action_submit').removeClass('disabled');
        }
      }
    }
  }, {
    key: "toggleCheckboxes",
    value: function toggleCheckboxes(event) {
      var $input = $(event.target);
      var do_check = true;

      if ($input.hasClass('semi-checked')) {
        $input.removeClass('semi-checked');
        $input.prop('checked', true);
        do_check = true;
      } else {
        do_check = $input.is(':checked');
      }

      $($input.parents('.results_container')).find('.results_body input[type=checkbox]').each(function () {
        $(this).prop('checked', do_check);
      });
      this.checkToggledCheckboxes();
    }
  }, {
    key: "toggleCheckbox",
    value: function toggleCheckbox(event) {
      var $input = $(event.target);
      var num_unchecked = $($input.parents('.results_container')).find('input[type=checkbox]:not(:checked)').length;
      var num_checked = $($input.parents('.results_container')).find('input[type=checkbox]:checked').length;
      var $header_checkbox = $($input.parents('.results_body')).find('.row.header input[type=checkbox]');

      if (num_unchecked == 0) {
        $header_checkbox.prop('checked', true);
        $header_checkbox.removeClass('semi-checked');
      } else if (num_checked > 0) {
        $header_checkbox.prop('checked', true);
        $header_checkbox.addClass('semi-checked');
      } else {
        $header_checkbox.prop('checked', false);
        $header_checkbox.removeClass('semi-checked');
      }

      this.checkToggledCheckboxes();
    }
  }, {
    key: "setColumns",
    value: function setColumns(template, available_columns, visible_columns, default_columns, template_parameter, filters) {
      this.current_result_view = template.name;
      this.result_views[template.name] = {
        available_columns: available_columns,
        visible_columns: visible_columns,
        default_visible_columns: default_columns
      };

      var _iterator = _createForOfIteratorHelper(this.result_views[template.name].available_columns),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var column = _step.value;

          if (this.result_views[template.name].visible_columns.indexOf(column) != -1) {
            $('#search_column_' + column + '_toggler_checkbox').prop('checked', true);
          } else {
            $('#search_column_' + column + '_toggler_checkbox').prop('checked', false);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      $("#filter_selected_template_".concat(template.name)).prop('checked', true);

      if (template.parameter !== '') {
        $('#search_template_parameter_container_header').html(template.parameter_header);
        $('#search_filter_parameter_input').attr('placeholder', template.parameter_text);
        $('#search_filter_parameter_input').val(template_parameter);
        $('#search_template_parameter_container').removeClass('hidden');
      } else {
        $('#search_template_parameter_container').addClass('hidden');
      }

      var _iterator2 = _createForOfIteratorHelper(filters),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var filter = _step2.value;
          var $filter_element = $('#additional_filter_' + filter + '_link');
          $filter_element.addClass('disabled');
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  }, {
    key: "updateResults",
    value: function updateResults(force) {
      var $find_issues_form = $('#find_issues_form');
      var url = $find_issues_form.prop('action');
      var parameters = $find_issues_form.serialize();
      var search = this;

      if (force === true || this.results_loaded) {
        $('nav.sidebar').addClass('collapsed');
        Pachno.fetch(url, {
          form: 'find_issues_form',
          method: 'POST',
          loading: {
            indicator: '#search_results_loading_indicator',
            callback: function callback() {
              if (history.pushState) {
                history.pushState({
                  caller: 'liveUpdate'
                }, '', search.history_url + '?' + parameters);
              }
            }
          },
          success: {
            update: '#search-results'
          }
        }).then(function (json) {
          if (!search.results_loaded) {
            search.updateSavedSearchCounts();
          }

          search.setColumns(json.template, json.available_columns, json.visible_columns, json.default_columns, json.template_parameter, json.applied_filters);
          $('#findissues_num_results_span').html(json.num_issues); // if (! $('#findissues_search_title').visible() && ! $('#findissues_search_generictitle').visible()) {
          //     $('#findissues_search_generictitle').show();
          // }

          $('#findissues_num_results').show();
          $('#interactive_save_button').show();
          search.results_loaded = true;
          search.is_saved = false;

          if (search.is_dirty) {
            search.loadDynamicChoices();
            search.is_dirty = false;
          }
        });
      }
    }
  }, {
    key: "sortResults",
    value: function sortResults(event) {
      var $input = $(event.target);

      if ($input.data('sort-field') !== undefined) {
        var direction = $input.data('sort-direction') == 'asc' ? 'desc' : 'asc';
        $('#search_sortfields_input').value($input.data('sort-field') + '=' + direction);
        this.updateResults(true);
      }
    }
  }, {
    key: "pickTemplate",
    value: function pickTemplate(event, element) {
      event.stopPropagation();
      var is_selected = this.hasClass('selected');
      var current_elm = this;

      if (!is_selected) {
        $('.template-picker').each(function (element) {
          if (element == current_elm) {
            current_elm.addClass('selected');
            $('#filter_selected_template').value(current_elm.dataset.templateName);

            if (current_elm.dataset.grouping == '1') {
              $('#search_grouping_container').removeClass('nogrouping');
              $('#search_grouping_container').removeClass('parameter');
              $('#search_filter_parameter_input').prop('disabled', true);
            } else {
              $('#search_grouping_container').addClass('nogrouping');

              if (current_elm.dataset.parameter == '1') {
                $('#search_grouping_container').addClass('parameter');
                $('#search_filter_parameter_description').html(current_elm.dataset.parameterText);
                $('#search_filter_parameter_input').prop('disabled', false);
              } else {
                $('#search_grouping_container').removeClass('parameter');
              }
            }
          } else {
            element.removeClass('selected');
          }
        });
      }

      $('.filter,.interactive_plus_button').each(function (element) {
        if (element != this) element.removeClass('selected');
      });
      if (is_selected) this.removeClass('selected');else this.addClass('selected');
      Pachno.Search.liveUpdate();
    }
  }, {
    key: "bulkContainerChanger",
    value: function bulkContainerChanger() {
      var selected_radio_value = $('input[name=search_bulk_action]:checked').val(),
          sub_container_id = '#bulk_action_subcontainer_' + selected_radio_value;
      $('.bulk_action_subcontainer').addClass('hidden');

      if ($(sub_container_id)) {
        $(sub_container_id).removeClass('hidden');
        $('#bulk_action_submit').removeClass('disabled');
        var $dropdown_element = $(sub_container_id).find('.focusable');
        if ($dropdown_element != undefined) $dropdown_element.focus();
      } else {
        $('#bulk_action_submit').addClass('disabled');
      }
    }
  }, {
    key: "setupListeners",
    value: function setupListeners() {
      var _this2 = this;

      return new Promise(function (resolve, reject) {
        var search = _this2;
        var $body = $('body');
        var $find_issues_form = $('#find_issues_form');
        $find_issues_form.trigger("reset");
        $body.on('click', '.search_column_toggler', function (event) {
          search.updateColumnVisibility(event);
        });
        $body.on('click', '#search_grouping_container li', function (event) {
          search.updateColumnVisibility(event);
        });
        $body.on('click', '#search-results th:not(.nosort)', function (event) {
          search.sortResults(event);
        }); //     $('.template-picker').each(function (element) {
        //         element.on('click', Pachno.Search.pickTemplate);
        //     });
        //

        $body.on('click', '.sca_actions input[type="checkbox"]', function (event) {
          search.toggleCheckbox(event);
        }); // issue checkboxes select all

        $body.on('click', '.sca_action_selector input[type="checkbox"]', function (event) {
          search.toggleCheckboxes(event);
        });
        $body.on('click', 'input[type=radio].bulk-action-checkbox', function (event) {
          search.bulkContainerChanger();
        });
        $body.on('click', '.search-trigger-reload', function (event) {
          search.updateResults(true);
        });
        $body.on('click', '#search-filters .remove-button', function () {
          var $filter = $(this).parents('.filter');
          var filter = $filter.data('filterkey');
          var do_update = $("#filter_".concat(filter, "_value_input")).val() != '';
          $('#additional_filter_' + filter + '_link').removeClass('disabled');
          $('#search-filters-hidden-container').append($filter.remove());

          if (do_update) {
            search.updateResults(true);
          }
        });
        $body.on('click', '.trigger-add-filter:not(.disabled)', function (event) {
          var $filter_link = $(this);
          $filter_link.addClass('disabled');
          var filter = $filter_link.data('filter');
          var $filter_element = $('#interactive_filter_' + filter);
          $('#search-filters').append($filter_element.remove());
          setTimeout(function () {
            $('#interactive_filter_' + filter).find('.fancy-dropdown').addClass('active');
          }, 150);
        });
        $body.on('click', '.filter .fancy-dropdown input[type=checkbox],.filter .fancy-dropdown input[type=radio]', function () {
          // var filter = $(this);
          // if ($('.filter_' + filter.data('filterkey'), filter).length) {
          //     $('.filter_' + filter.data('filterkey'), filter).data('dirty', 'dirty');
          // }
          // else {
          //     $('#filter_' + filter.data('filterkey')).data('dirty', 'dirty');
          // }
          search.updateResults(true);
        }); //
        //     Pachno.Search.initializeIssuesPerPageSlider();
        //
        //     var sff = $('#search-filters');
        //     $('#add-search-filter-button').find('.list-item').each(function (element) {
        //         element.on('click', Pachno.Search.addFilter);
        //         if (sff.down('#interactive_filter_' + element.dataset.filter)) {
        //             element.addClass('disabled');
        //         }
        //     });
        //     var ifts = $('.filter_searchfield');
        //     Pachno.ift_observers = {};
        //     ifts.each(function (ift) {
        //         ift.data('last-value', '');
        //         ift.on('keyup', function (event, element) {
        //             if (Pachno.ift_observers[ift.id])
        //                 clearTimeout(Pachno.ift_observers[ift.id]);
        //             if ((ift.val().length >= 3 || ift.val().length == 0 || (ift.dataset.maxlength && ift.val().length > parseInt(ift.dataset.maxlength))) && ift.val() != ift.data('last-value')) {
        //                 Pachno.ift_observers[ift.id] = setTimeout(function () {
        //                     Pachno.Search.liveUpdate(true);
        //                     ift.data('last-value', ift.val());
        //                     var flt = ift.parents('.filter');
        //                     if (flt !== undefined) {
        //                         Pachno.Search.updateFilterVisibleValue(flt, ift.val());
        //                     }
        //                 }, 1000);
        //             }
        //         });
        //
        //     });

        resolve();
      });
    }
  }]);

  return Search;
}();

/* harmony default export */ __webpack_exports__["default"] = (Search);
window.Search = Search;
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./js/classes/swimlane.js":
/*!********************************!*\
  !*** ./js/classes/swimlane.js ***!
  \********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _issue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./issue */ "./js/classes/issue.js");
/* harmony import */ var _board__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./board */ "./js/classes/board.js");
function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }




var Swimlane = /*#__PURE__*/function () {
  function Swimlane(json, board_id) {
    _classCallCheck(this, Swimlane);

    /**
     * @type {Issue[]}
     */
    this.issues = [];
    this.name = json.name;
    this.board_id = board_id;
    this.has_identifiables = json.has_identifiables;
    this.identifier_issue = json.identifier_issue;
    this.identifier_grouping = json.identifier_grouping;
    this.identifier_type = json.identifier_type;
    this.identifiables = json.identifiables;
    this.identifier = json.identifier;

    var _iterator = _createForOfIteratorHelper(json.issues),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var issue_json = _step.value;
        this.issues.push(new _issue__WEBPACK_IMPORTED_MODULE_0__["default"](issue_json, this.board_id));
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
  }

  _createClass(Swimlane, [{
    key: "addIssues",
    value: function addIssues(issues) {
      var _iterator2 = _createForOfIteratorHelper(issues),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var issue_json = _step2.value;
          this.issues.push(new _issue__WEBPACK_IMPORTED_MODULE_0__["default"](issue_json, this.board_id));
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  }, {
    key: "addIssue",
    value: function addIssue(issue) {
      this.issues.push(issue);
    }
    /**
     * Check if an issue is inside this swimlane
     * @param {Issue} issue
     * @returns {boolean}
     */

  }, {
    key: "has",
    value: function has(issue) {
      if (this.identifier === 'swimlane_0') {
        return true;
      }

      switch (this.identifier_type) {
        case _board__WEBPACK_IMPORTED_MODULE_1__["SwimlaneTypes"].ISSUES:
          return this.identifier_issue.id === issue.parent_issue_id;

        case _board__WEBPACK_IMPORTED_MODULE_1__["SwimlaneTypes"].GROUPING:
        case _board__WEBPACK_IMPORTED_MODULE_1__["SwimlaneTypes"].EXPEDITE:
          if (!this.identifiables) {
            return false;
          } // debugger;


          for (var identifiable_id in this.identifiables) {
            if (!this.identifiables.hasOwnProperty(identifiable_id)) continue;

            if (issue[this.identifier_grouping] !== undefined && identifiable_id === issue[this.identifier_grouping].id) {
              return true;
            }
          }

          break;
      }

      return false;
    }
  }]);

  return Swimlane;
}();

/* harmony default export */ __webpack_exports__["default"] = (Swimlane);
window.Swimlane = Swimlane;

/***/ }),

/***/ "./js/classes/uploader.js":
/*!********************************!*\
  !*** ./js/classes/uploader.js ***!
  \********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function($) {/* harmony import */ var _helpers_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../helpers/ui */ "./js/helpers/ui.js");
function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }



var Uploader = /*#__PURE__*/function () {
  function Uploader(options) {
    var _this = this;

    _classCallCheck(this, Uploader);

    this.uploader_container = options.uploader_container;
    this.mode = options.mode;
    this.dropzone = options.dropzone;
    this.input_name = options.input_name;
    this.file_upload_list = options.file_upload_list;
    this.only_images = options.only_images;
    this.type = options.type;
    this.form_data = options.data;
    this.file_input_element = $('#file_upload_dummy');
    this.upload_url = options.url || this.file_input_element.data('upload-url');
    var $body = $('body');

    if (this.dropzone !== undefined && 'ondrop' in document.createElement('span')) {
      $body.on('dragover', function (event) {
        return _this.dragOverFiles(event);
      });
      $body.on('dragleave', function (event) {
        return _this.dragOverFiles(event);
      });
      this.dropzone.on('drop', function (event) {
        return _this.dropFiles(event);
      });
    }

    $body.on('change', '#file_upload_dummy', function (event) {
      return _this.selectFiles(event);
    });
    this.uploader_container.on('click', '.trigger-file-upload', function (event) {
      event.preventDefault();

      _this.file_input_element.trigger('click');
    });
  }

  _createClass(Uploader, [{
    key: "dragOverFiles",
    value: function dragOverFiles(event) {
      if (event !== undefined) {
        event.stopPropagation();
        event.preventDefault();
      }

      if (event !== undefined && event.type === "dragover") {
        this.dropzone.removeClass("hidden");
        event.originalEvent.dataTransfer.dropEffect = 'copy'; // Explicitly show this is a copy.
      } else {
        this.dropzone.addClass("hidden");
      }
    }
  }, {
    key: "dropFiles",
    value: function dropFiles(event) {
      var files = event.originalEvent.target.files || event.originalEvent.dataTransfer.files;
      this.dragOverFiles(event);
      this.uploadFiles(files);
    }
  }, {
    key: "selectFiles",
    value: function selectFiles(event) {
      var files = $(event.target)[0].files;

      if (files !== undefined) {
        this.uploadFiles(files, true);
      }
    }
  }, {
    key: "uploadFile",
    value: function uploadFile(url, file) {
      var _this2 = this;

      return new Promise(function (resolve, reject) {
        var is_image = file.type.indexOf("image") == 0;

        if (_this2.only_images && !is_image) {
          console.error('Not an image', file);
        } // $upload_status_container.addClass('active');
        // $upload_status_container.addClass('expanded');


        var fileSize = 'unknown';

        if (file.size > 1024 * 1024) {
          fileSize = (Math.round(file.size * 100 / (1024 * 1024)) / 100).toString() + 'MB';
        } else {
          fileSize = (Math.round(file.size * 100 / 1024) / 100).toString() + 'KB';
        } // <input type="radio" name="project_icon" value="<?= $icon; ?>" id="project_icon_<?= $index; ?>" <?php if ($icon == $project->getIconName()) echo ' checked'; ?>>
        // <label for="project_icon_<?= $index; ?>"><?= image_tag($icon, [], true); ?></label>


        var $input_element = $("<input type=\"radio\" name=\"".concat(_this2.input_name, "\">"));
        var $label_element = $("<label><img class=\"icon_preview\" src=\"\"><i class=\"fa-spin fas fa-circle-notch indicator\"></i></label>");
        $input_element.insertBefore(_this2.uploader_container.find('.trigger-file-upload'));
        $label_element.insertBefore(_this2.uploader_container.find('.trigger-file-upload'));

        if (is_image) {
          var $image_preview = $label_element.find('img');
          var reader = new FileReader();

          reader.onload = function (e) {
            $image_preview.attr('src', e.target.result);
          };

          reader.readAsDataURL(file);
        }

        var formData = new FormData();
        formData.append(file.name.replace('[', '(').replace(']', ')'), file);
        formData.append('type', _this2.type);
        var options = {
          body: formData,
          method: 'POST'
        };

        if (_this2.form_data !== undefined) {
          if (_this2.form_data.project_id !== undefined) {
            formData.append('project_id', _this2.form_data.project_id);
          }
        }

        fetch(url, options).then(function (_response) {
          var contentType = _response.headers.get("content-type");

          var is_json = contentType && contentType.indexOf("application/json") !== -1;
          return new Promise(function (_resolve, _reject) {
            if (_response.ok && is_json) {
              _response.json().then(function (json) {
                _resolve(json);
              });
            } else {
              _response.json().then(function (json) {
                _helpers_ui__WEBPACK_IMPORTED_MODULE_0__["default"].Message.error(json.error, json.message);

                if (options.failure && options.failure.callback) {
                  options.failure.callback(json);
                }
              });

              _reject(_response);
            }
          });
        }).then(function (json, responseText) {
          var data = json.file;
          $label_element.addClass('confirmed');
          $label_element.find('.indicator').remove();
          $input_element.attr('value', data.id);
          $input_element.attr('id', "".concat(_this2.input_name, "_").concat(data.id));
          $label_element.attr('for', "".concat(_this2.input_name, "_").concat(data.id));
          resolve();
        })["catch"](function (error) {
          reject(error);
        });
      });
    }
  }, {
    key: "uploadFiles",
    value: function uploadFiles(files, show_hint) {
      var url = $('#file_upload_dummy').data('upload-url');
      var uploads = [];

      if (show_hint === true) {
        $('#upload_drop_hint').addClass('active');
      }

      if (files.length > 0) {
        var _iterator = _createForOfIteratorHelper(files),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var file = _step.value;
            uploads.push(this.uploadFile(url, file));
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }

      Promise.all(uploads)["catch"](function (error) {
        return Pachno.UI.Message.error;
      });
    }
  }]);

  return Uploader;
}();

/* harmony default export */ __webpack_exports__["default"] = (Uploader);
window.Uploader = Uploader;
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./js/helpers/dashboard.js":
/*!*********************************!*\
  !*** ./js/helpers/dashboard.js ***!
  \*********************************/
/*! exports provided: initializeDashboards, setupDashboardListeners */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "initializeDashboards", function() { return initializeDashboards; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setupDashboardListeners", function() { return setupDashboardListeners; });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _classes_pachno__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../classes/pachno */ "./js/classes/pachno.js");



var initDashboard = function initDashboard($view) {
  var view_id = parseInt($view.data('view-id'));
  var dashboard_container = $view.parents('.dashboard');
  var url = dashboard_container.data('url').replace('{view_id}', view_id);

  if ($view.data('preloaded') == "0") {
    _classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].fetch(url, {
      method: 'GET',
      loading: {
        indicator: '#dashboard_view_' + view_id + '_indicator'
      },
      success: {
        update: '#dashboard_view_' + view_id
      }
    });
  }
};

var addViewPopup = function addViewPopup(event, element) {
  event.stopPropagation();
  var backdrop_url = element.parents('.dashboard').data('add-view-url') + '&column=' + element.parents('.dashboard_column').data('column');
  _classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].UI.Backdrop.show(backdrop_url);
};

var initializeDashboards = function initializeDashboards() {
  var dashboardPromises = [];
  jquery__WEBPACK_IMPORTED_MODULE_0___default()('.dashboard_view_container').each(function () {
    var $view = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);

    if ($view.data('view-id')) {
      dashboardPromises.push(initDashboard($view));
    }
  });
  return Promise.all(dashboardPromises);
};

var setupDashboardListeners = function setupDashboardListeners() {
  jquery__WEBPACK_IMPORTED_MODULE_0___default()('body').on('click', '.dashboard_add_view_container', addViewPopup);
};



/***/ }),

/***/ "./js/helpers/fetch.js":
/*!*****************************!*\
  !*** ./js/helpers/fetch.js ***!
  \*****************************/
/*! exports provided: EVENTS, fetchHelper, formSubmitHelper, setFetchDebugger, setupListeners */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EVENTS", function() { return EVENTS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fetchHelper", function() { return fetchHelper; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "formSubmitHelper", function() { return formSubmitHelper; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setFetchDebugger", function() { return setFetchDebugger; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setupListeners", function() { return setupListeners; });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _tools_tools__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../tools/tools */ "./js/tools/tools.js");
/* harmony import */ var _ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ui */ "./js/helpers/ui.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }




var fetch_debugger = undefined;
var EVENTS = {
  updated: 'fetch-dom-updated'
};

var processCommonAjaxPostEvents = function processCommonAjaxPostEvents(options) {
  if (options.remove) {
    if (Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(options.remove)) {
      if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.remove)) jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.remove).remove();
    } else {
      options.remove.each(function (s) {
        if (Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(s) && jquery__WEBPACK_IMPORTED_MODULE_0___default()(s)) jquery__WEBPACK_IMPORTED_MODULE_0___default()(s).remove();else if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(s)) s.remove();
      });
    }
  }

  if (options.hide) {
    if (Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(options.hide)) {
      if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.hide)) jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.hide).hide();
    } else {
      options.hide.each(function (s) {
        if (Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(s) && jquery__WEBPACK_IMPORTED_MODULE_0___default()(s)) jquery__WEBPACK_IMPORTED_MODULE_0___default()(s).hide();else if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(s)) s.hide();
      });
    }
  }

  if (options.show) {
    if (Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(options.show)) {
      if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.show)) jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.show).show();
    } else {
      options.show.each(function (s) {
        if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(s)) jquery__WEBPACK_IMPORTED_MODULE_0___default()(s).show();
      });
    }
  }

  if (options.enable) {
    if (Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(options.enable)) {
      if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.enable)) jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.enable).prop('disabled', false);
    } else {
      options.enable.each(function (s) {
        if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(s)) jquery__WEBPACK_IMPORTED_MODULE_0___default()(s).prop('disabled', false);
      });
    }
  }

  if (options.disable) {
    if (Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(options.disable)) {
      if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.disable)) jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.disable).prop('disabled', true);
    } else {
      options.disable.each(function (s) {
        if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(s)) jquery__WEBPACK_IMPORTED_MODULE_0___default()(s).prop('disabled', true);
      });
    }
  }

  if (options.reset) {
    if (Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(options.reset)) {
      if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.reset)) jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.reset).reset();
    } else {
      options.reset.each(function (s) {
        if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(s)) jquery__WEBPACK_IMPORTED_MODULE_0___default()(s).reset();
      });
    }
  }

  if (options.clear) {
    if (Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(options.clear)) {
      if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.clear)) jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.clear).clear();
    } else {
      options.clear.each(function (s) {
        if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(s)) jquery__WEBPACK_IMPORTED_MODULE_0___default()(s).clear();
      });
    }
  }
};

var fetchHelper = function fetchHelper(url, options) {
  return new Promise(function (resolve, reject) {
    var method = options.method ? options.method : 'GET';
    var $form = options.form ? jquery__WEBPACK_IMPORTED_MODULE_0___default()('#' + options.form) : undefined;

    if (options.form !== undefined && method === 'GET') {
      throw new Error('Cannot send form data when using GET method');
    }

    var onLoading = function onLoading() {
      if (options.loading) {
        if (fetch_debugger !== undefined) {
          jquery__WEBPACK_IMPORTED_MODULE_0___default()('#___PACHNO_DEBUG_INFO___indicator').show();
        }

        if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.loading.indicator)) {
          jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.loading.indicator).show();
        }

        if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.loading.disable)) {
          jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.loading.disabled).prop('disabled', true);
        }

        processCommonAjaxPostEvents(options.loading);

        if (options.loading.callback) {
          options.loading.callback();
        }
      }

      if ($form !== undefined) {
        $form.addClass('submitting');
        $form.find('button[type=submit]').each(function () {
          var $button = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
          $button.addClass('auto-disabled');
          $button.prop('disabled', true);
        });
      }
    };

    onLoading();
    var response;
    var fetch_options = {
      method: method,
      headers: {
        "Accept": "application/json"
      }
    };

    if (['POST', 'PUT'].indexOf(method) !== -1) {
      var data;

      if ($form !== undefined && $form.length) {
        data = new FormData($form[0]);
      } else {
        data = new FormData();
      }

      if (options.additional_params) {
        for (var param in options.additional_params) {
          if (options.additional_params.hasOwnProperty(param)) {
            data.append(param, options.additional_params[param]);
          }
        }
      }

      fetch_options.body = data;
    } else if (method === 'GET') {
      if (options.additional_params) {
        var concatenator = url.indexOf('?') !== -1 ? '&' : '?';
        url += concatenator + options.additional_params;
      }
    }

    fetch(url, fetch_options).then(function (_response) {
      response = _response;
      var contentType = response.headers.get("content-type");
      var is_json = contentType && contentType.indexOf("application/json") !== -1;
      return new Promise(function (_resolve, _reject) {
        if (response.ok && is_json) {
          response.json().then(function (json) {
            _resolve(json);
          });
        } else {
          if (options.failure) {
            processCommonAjaxPostEvents(options.failure);
          }

          response.json().then(function (json) {
            _ui__WEBPACK_IMPORTED_MODULE_2__["default"].Message.error(json.error, json.message);

            if (options.failure && options.failure.callback) {
              options.failure.callback(json);
            }
          });

          _reject(response);
        }
      });
    }).then(function (json, responseText) {
      if (json || options.success && options.success.update) {
        if (json && json.forward != undefined) {
          document.location = json.forward;
        } else {
          if (options.success && options.success.update) {
            var _json_content_element = Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(options.success.update) || options.success.update.from == undefined ? 'content' : options.success.update.from;

            var _content = json ? json[_json_content_element] : responseText;

            var update_element = Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(options.success.update) ? options.success.update : options.success.update.element;

            if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(update_element).length) {
              var insertion = Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(options.success.update) ? false : options.success.update.insertion ? options.success.update.insertion : false;
              var replace = Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(options.success.update) ? false : options.success.update.replace ? options.success.update.replace : false;

              if (insertion) {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()(update_element).append(_content);
              } else if (replace) {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()(update_element).replaceWith(_content);
              } else {
                jquery__WEBPACK_IMPORTED_MODULE_0___default()(update_element).html(_content);
              }
            } else {
              console.error('Trying to update element ' + options.success.update + ' but it does not exist in markup');
              console.error(options);
              console.trace();
            }

            if (json && json.message) {
              _ui__WEBPACK_IMPORTED_MODULE_2__["default"].Message.success(json.message);
            }
          } else if (options.success && options.success.replace) {
            var json_content_element = Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(options.success.replace) || options.success.replace.from == undefined ? 'content' : options.success.replace.from;
            var content = json ? json[json_content_element] : responseText;
            var replace_element = Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["is_string"])(options.success.replace) ? options.success.replace : options.success.replace.element;

            if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(replace_element)) {
              Element.replace(replace_element, content);
            }

            if (json && json.message) {
              _ui__WEBPACK_IMPORTED_MODULE_2__["default"].Message.success(json.message);
            }
          } else if (json && json.title && json.content) {
            _ui__WEBPACK_IMPORTED_MODULE_2__["default"].Message.success(json.title, json.content);
          } else if (json && json.message) {
            _ui__WEBPACK_IMPORTED_MODULE_2__["default"].Message.success(json.message);
          }

          if (options.success) {
            processCommonAjaxPostEvents(options.success);

            if (options.success.callback) {
              options.success.callback(json);
            }
          }
        }
      }

      return json;
    }).then(function (json) {
      if (fetch_debugger !== undefined) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#___PACHNO_DEBUG_INFO___indicator').hide();
        var d = new Date(),
            d_id = response.headers.get('x-pachno-debugid'),
            d_time = response.headers.get('x-pachno-loadtime'),
            d_session_time = response.headers.get('x-pachno-sessiontime'),
            d_calculated_time = response.headers.get('x-pachno-calculatedtime');
        fetch_debugger.updateDebugInfo({
          location: url,
          time: d,
          debug_id: d_id,
          loadtime: d_time,
          session_loadtime: d_session_time,
          calculated_loadtime: d_calculated_time
        });
      }

      if (options.loading) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.loading.indicator).hide();

        if (jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.loading.disable)) {
          jquery__WEBPACK_IMPORTED_MODULE_0___default()(options.loading.disabled).prop('disabled', false);
        }
      }

      if (options.complete) {
        processCommonAjaxPostEvents(options.complete);

        if (options.complete.callback) {
          var json = response.responseJSON ? response.responseJSON : undefined;
          options.complete.callback(json);
        }
      }

      if ($form !== undefined && $form.data('reset-backdrop') !== undefined) {
        _ui__WEBPACK_IMPORTED_MODULE_2__["default"].Backdrop.reset();
      }

      Pachno.trigger(EVENTS.updated);
      resolve(json);
    })["catch"](function (error) {
      console.error(error);
      console.error('OPTIONS', options);
      Object(_tools_tools__WEBPACK_IMPORTED_MODULE_1__["clearFormSubmit"])($form);
    });
  });
};
var formSubmitHelper = function formSubmitHelper(url, form_id, options) {
  var fetchOptions = {
    form: form_id,
    method: 'POST',
    loading: {
      indicator: form_id + '_indicator',
      disable: form_id + '_button'
    },
    success: {
      enable: form_id + '_button'
    },
    failure: {
      enable: form_id + '_button'
    }
  };

  if (options !== undefined) {
    if (options.success !== undefined) {
      fetchOptions.success = _objectSpread(_objectSpread({}, fetchOptions.success), options.success);
    }
  }

  return fetchHelper(url, fetchOptions);
};
var setFetchDebugger = function setFetchDebugger(_fetch_debugger) {
  fetch_debugger = _fetch_debugger;
};
var setupListeners = function setupListeners() {};

/***/ }),

/***/ "./js/helpers/openid.js":
/*!******************************!*\
  !*** ./js/helpers/openid.js ***!
  \******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function($) {var OpenID = {
  version: '1.3',
  // version constant
  demo: false,
  demo_text: null,
  cookie_expires: 6 * 30,
  // 6 months.
  cookie_name: 'openid_provider',
  cookie_path: '/',
  img_path: 'images/',
  locale: 'en',
  // is set in openid-<locale>.js
  sprite: 'en',
  // usually equals to locale, is set in
  // openid-<locale>.js
  signin_text: null,
  // text on submit button on the form
  all_small: false,
  // output large providers w/ small icons
  image_title: '%openid_provider_name',
  // for image title
  input_id: 'openid_identifier',
  provider_url: null,
  provider_id: null,
  providers_small: null,
  providers_large: null,

  /**
   * Class constructor
   *
   * @return {Void}
   */
  init: function init() {
    var openid_btns = $('#openid_btns');

    if ($('#openid_choice')) {
      $('#openid_choice').css({
        display: 'block'
      });
    }

    if ($('#openid_input_area')) {
      $('#openid_input_area').innerHTML = "";
    }

    var i = 0; // add box for each provider

    for (id in this.providers_large) {
      box = this.getBoxHTML(id, this.providers_large[id], this.all_small ? 'small' : 'large', i++);
      openid_btns.append(box);
    }

    if (this.providers_small) {
      openid_btns.append('<br/>');

      for (id in this.providers_small) {
        box = this.getBoxHTML(id, this.providers_small[id], 'small', i++);
        openid_btns.append(box);
      }
    } //		$('#openid_form').submit = this.submit;
    //		var box_id = this.readCookie();
    //		if (box_id) {
    //			this.signin(box_id, true);
    //		}

  },

  /**
   * @return {String}
   */
  getBoxHTML: function getBoxHTML(box_id, provider, box_size, index) {
    var image_ext = box_size == 'small' ? '.ico.png' : '.png';
    return '<a title="' + this.image_title.replace('%openid_provider_name', provider["name"]) + '" href="javascript:Pachno.OpenID.signin(\'' + box_id + '\');"' + 'class="' + box_id + ' openid_' + box_size + '_btn button"><img src="' + Pachno.basepath + 'images/openid_providers.' + box_size + '/' + box_id + image_ext + '"></a>';
  },

  /**
   * Provider image click
   *
   * @return {Void}
   */
  signin: function signin(box_id) {
    var provider = this.providers_large[box_id] ? this.providers_large[box_id] : this.providers_small[box_id];

    if (!provider) {
      return;
    }

    this.highlight(box_id);
    this.provider_id = box_id;
    this.provider_url = provider['url']; // prompt user for input?

    if (provider['label']) {
      this.useInputBox(provider);
    } else {
      $('#openid_input_area').innerHTML = '';
      this.submit();
      $('#openid_form').submit();
    }
  },

  /**
   * Sign-in button click
   *
   * @return {Boolean}
   */
  submit: function submit() {
    var url = this.provider_url;
    var username_field = $('#openid_username');
    var username = username_field ? $('#openid_username').val() : '';

    if (url) {
      url = url.replace('{username}', username);
      this.setOpenIdUrl(url);
    }

    return true;
  },

  /**
   * @return {Void}
   */
  setOpenIdUrl: function setOpenIdUrl(url) {
    var hidden = document.getElementById(this.input_id);

    if (hidden != null) {
      hidden.val(url);
    } else {
      $('#openid_form').append('<input type="hidden" id="' + this.input_id + '" name="' + this.input_id + '" value="' + url + '"/>');
    }
  },

  /**
   * @return {Void}
   */
  highlight: function highlight(box_id) {
    // remove previous highlight.
    var highlight = $('.openid_highlight');

    if (highlight[0]) {
      highlight[0].removeClass('button-pressed');
      highlight[0].removeClass('openid_highlight');
    } // add new highlight.


    var box = $('.' + box_id)[0];
    box.addClass('openid_highlight');
    box.addClass('button-pressed');
  },
  setCookie: function setCookie(value) {
    var date = new Date();
    date.setTime(date.getTime() + this.cookie_expires * 24 * 60 * 60 * 1000);
    var expires = "; expires=" + date.toGMTString();
    document.cookie = this.cookie_name + "=" + value + expires + "; path=" + this.cookie_path;
  },
  readCookie: function readCookie() {
    var nameEQ = this.cookie_name + "=";
    var ca = document.cookie.split(';');

    for (var i = 0; i < ca.length; i++) {
      var c = ca[i];

      while (c.charAt(0) == ' ') {
        c = c.substring(1, c.length);
      }

      if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
    }

    return null;
  },

  /**
   * @return {Void}
   */
  useInputBox: function useInputBox(provider) {
    var input_area = $('#openid_input_area');
    var html = '';
    var id = 'openid_username';
    var value = '';
    var label = provider['label'];
    var style = '';

    if (provider['name'] == 'OpenID') {
      id = this.input_id;
      value = 'http://';
      style = 'background: #FFF url(' + Pachno.basepath + 'images/openid-inputicon.gif) no-repeat scroll 0 50%; padding-left:18px;';
    }

    html = '<input id="' + id + '" type="text" style="' + style + '" name="' + id + '" value="' + value + '" />';

    if (label) {
      html += '<label for="' + id + '">' + label + '</label>';
    }

    input_area.innerHTML = html;
    $('#openid_submit_button').show(); //		$('#openid_submit').onclick = this.submit;

    $(id).focus();
  },
  setDemoMode: function setDemoMode(demoMode) {
    this.demo = demoMode;
  }
};
/* harmony default export */ __webpack_exports__["default"] = (OpenID);
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./js/helpers/profile.js":
/*!*******************************!*\
  !*** ./js/helpers/profile.js ***!
  \*******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _classes_pachno__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../classes/pachno */ "./js/classes/pachno.js");



var showLogin = function showLogin() {
  var $trigger = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
  var section = $trigger.data('login-section');
  var $login_backdrop = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#login_backdrop');
  $login_backdrop.find('.logindiv').removeClass('active');
  jquery__WEBPACK_IMPORTED_MODULE_0___default()(section).addClass('active');

  if (section !== '#register' && jquery__WEBPACK_IMPORTED_MODULE_0___default()('#registration-button-container')) {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()('#registration-button-container').addClass('active');
  }

  $login_backdrop.show();
  setTimeout(function () {
    if (section === '#register') {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#fieldusername').focus();
    } else if (section === '#regular_login_container') {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno_username').focus();
    }
  }, 250);
};

var doLogin = function doLogin() {//     var $form = $('#login_form'),
  //         $login_button = $('#login_button'),
  //         url = $form.attr('action');
  //
  //     $('#login-error-container').removeClass('invalid');
  //     $login_button.addClass('submitting');
  //     $login_button.prop('disabled', true);
  //
  //     fetch(url, {
  //         method: 'POST',
  //         body: new FormData($form[0])
  //     })
  //         .then(function (response) {
  //             response.json().then(function (json) {
  //                 $login_button.removeClass('submitting');
  //                 $login_button.prop('disabled', false);
  //
  //                 if (response.ok) {
  //                     if (json.forward) {
  //                         window.location = json.forward;
  //                     } else {
  //                         window.location.reload();
  //                     }
  //                 } else {
  //                     console.error(json);
  //                     $('#login-error-message').html(json.error);
  //                     $('#login-error-container').addClass('invalid');
  //                 }
  //             });
  //         })
  //         .catch(function (error) {
  //             $('#login-error-message').html(error);
  //             $('#login-error-container').addClass('invalid');
  //             console.error(error);
  //         });
  //
};

var setupListeners = function setupListeners() {
  var $body = jquery__WEBPACK_IMPORTED_MODULE_0___default()('body');
  $body.on('click', _classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].TRIGGERS.showLogin, showLogin);
};

/* harmony default export */ __webpack_exports__["default"] = (setupListeners);

/***/ }),

/***/ "./js/helpers/ui.js":
/*!**************************!*\
  !*** ./js/helpers/ui.js ***!
  \**************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./fetch */ "./js/helpers/fetch.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }




var tabSwitcher = function tabSwitcher($tab, target, $tabSwitcher, change_hash) {
  if (!change_hash) {
    change_hash = false;
  }

  $tabSwitcher.children().removeClass('selected');
  $tab.addClass('selected');
  jquery__WEBPACK_IMPORTED_MODULE_0___default()('#' + $tabSwitcher.prop('id') + '_panes').children().each(function () {
    var $pane = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);

    if ($pane.data('tab-id') == target) {
      $pane.show();
    } else {
      $pane.hide();
    }
  });

  if (change_hash) {
    if (history.replaceState) {
      window.history.replaceState(null, null, '#' + target);
    } else {
      window.location.hash = target;
    }
  }
};

var UI = {
  Message: {
    /**
     * Clears all popup messages from the effect queue
     */
    clear: function clear() {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno_successmessage').hide();
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno_failuremessage').hide();
    },

    /**
     * Shows an error popup message
     *
     * @param title string The title to show
     * @param content string Error details
     */
    error: function error(title, content) {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno_failuremessage').hide();
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno_failuremessage_title').html(title);
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno_failuremessage_content').html(content);
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno_failuremessage').show();
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno_successmessage').hide();
    },

    /**
     * Shows a "success"-style popup message
     *
     * @param title string The title to show
     * @param content string Message details
     */
    success: function success(title, content) {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno_successmessage').hide();
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno_successmessage_title').html(title);
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno_successmessage_content').html(content);
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno_successmessage').show();
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno_failuremessage').hide();
      setTimeout(function () {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#pachno_successmessage').hide();
      }, 5000);
    }
  },
  Dialog: {
    show: function show(title, content, options) {
      UI.Message.clear();
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_title').html(title);
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_content').html(content);
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_yes').attr('href', 'javascript:void(0)');
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_no').attr('href', 'javascript:void(0)');
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_yes').off('click');
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_no').off('click');
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_yes').removeClass('disabled');
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_no').removeClass('disabled');

      if (options.yes.click) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_yes').on('click', options.yes.click);
      }

      if (options.yes.href) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_yes').attr('href', options.yes.href);
      }

      if (options.no.click) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_no').on('click', options.no.click);
      }

      if (options.no.href) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_no').attr('href', options.no.href);
      }

      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_backdrop_content').show();
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_backdrop').show();
    },
    showModal: function showModal(title, content) {
      UI.Message.clear();
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_modal_title').html(title);
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_modal_content').html(content);
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_backdrop_modal_content').show();
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_backdrop_modal').show();
    },
    dismiss: function dismiss() {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_backdrop_content').hide();
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_backdrop').hide();
    },
    dismissModal: function dismissModal() {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_backdrop_modal_content').hide();
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#dialog_backdrop_modal').hide();
    }
  },
  Backdrop: {
    show: function show(url, _callback, docked) {
      return new Promise(function (resolve) {
        var showBackdrop = function showBackdrop(docked) {
          return new Promise(function (_resolve) {
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('#fullpage_backdrop_content').hide();
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('#fullpage_backdrop').removeClass('docked-left');
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('#fullpage_backdrop').removeClass('docked-right');

            if (docked !== undefined) {
              jquery__WEBPACK_IMPORTED_MODULE_0___default()('#fullpage_backdrop').addClass('docked-' + docked);
            }

            jquery__WEBPACK_IMPORTED_MODULE_0___default()('#fullpage_backdrop').show();
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('body').css({
              'overflow': 'hidden'
            });
            jquery__WEBPACK_IMPORTED_MODULE_0___default()('#fullpage_backdrop_indicator').show();

            _resolve();
          });
        };

        showBackdrop(docked).then(function () {
          if (url != undefined) {
            Object(_fetch__WEBPACK_IMPORTED_MODULE_1__["fetchHelper"])(url, {
              method: 'GET',
              loading: {
                indicator: '#fullpage_backdrop_indicator'
              },
              success: {
                update: '#fullpage_backdrop_content',
                callback: function callback() {
                  jquery__WEBPACK_IMPORTED_MODULE_0___default()('#fullpage_backdrop_content').show();
                  jquery__WEBPACK_IMPORTED_MODULE_0___default()('#fullpage_backdrop_indicator').hide(); // Pachno.Helpers.MarkitUp($('#textarea.markuppable'));

                  if (_callback) setTimeout(_callback(), 300);
                }
              },
              failure: {
                hide: '#fullpage_backdrop'
              }
            });
          } else {
            console.error('Trying to show backdrop but no url');
            console.trace();
          }
        }).then(resolve);
      });
    },
    reset: function reset(callback) {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('body').css({
        'overflow': 'auto'
      });
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('#fullpage_backdrop').hide(); // Pachno.Core._resizeWatcher();

      if (callback) callback();
    }
  },
  tabSwitcher: tabSwitcher,
  parseHtmlOptions: function parseHtmlOptions(options) {
    var option_strings = [];

    for (var _i = 0, _Object$entries = Object.entries(options); _i < _Object$entries.length; _i++) {
      var _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
          key = _Object$entries$_i[0],
          value = _Object$entries$_i[1];

      if (Array.isArray(value)) {
        value = value.join(' ');
      }

      if (key === 'classes') key = 'class';
      option_strings.push("".concat(key, "=\"").concat(value, "\""));
    }

    return option_strings.join(' ');
  },
  fa_image_tag: function fa_image_tag(image) {
    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var mode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'fas';

    if (params.classes === undefined) {
      params.classes = [];
    } else if (!Array.isArray(params.classes)) {
      params.classes = [params.classes];
    }

    params.classes.push(mode);
    params.classes.push("fa-".concat(image));
    return "<i ".concat(this.parseHtmlOptions(params), "></i>");
  }
};

var tabSwitchFromHash = function tabSwitchFromHash(menu) {
  var hash = window.location.hash;

  if (hash != undefined && hash.indexOf('tab_') == 1) {
    tabSwitcher(hash.substr(1), menu);
  }
};

var loadComponentOptions = function loadComponentOptions($item) {
  new Promise(function (resolve, reject) {
    var $container = $item.parents('.configurable-components-container'),
        $optionsContainer = jquery__WEBPACK_IMPORTED_MODULE_0___default()('body').find('.configurable-component-options').first(),
        url = $item.data('options-url');
    $optionsContainer.html('<div><i class="fas fa-spin fa-spinner"></i></div>');
    $container.addClass('active');
    $container.find('.configurable-component').removeClass('active');
    $item.addClass('active');
    Object(_fetch__WEBPACK_IMPORTED_MODULE_1__["fetchHelper"])(url, {
      success: {
        update: '#' + $optionsContainer.attr('id')
      }
    }).then(resolve);
  });
};

var autoBackdropLink = function autoBackdropLink(event) {
  if (event) {
    event.preventDefault();
  }

  var $button = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
  $button.prop('disabled', true);
  $button.addClass('disabled');
  $button.addClass('submitting');
  UI.Backdrop.show($button.data('url'), undefined, $button.data('docked-backdrop')).then(function () {
    $button.prop('disabled', false);
    $button.removeClass('submitting');
    $button.removeClass('disabled');
  })["catch"](function (error) {
    console.error(error);
    UI.Backdrop.reset();
  });
};

var autoSubmitForm = function autoSubmitForm(event) {
  var $form = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
  event.preventDefault();
  return submitForm($form);
};

var submitForm = function submitForm($form) {
  var url = $form.attr('action');
  var options;

  if ($form.data('update-container')) {
    if ($form.data('update-insert') !== undefined) {
      options = {
        success: {
          update: {
            element: $form.data('update-container'),
            insertion: true
          }
        }
      };
    } else if ($form.data('update-replace') !== undefined) {
      options = {
        success: {
          update: {
            element: $form.data('update-container'),
            replace: true
          }
        }
      };
    } else {
      options = {
        success: {
          update: $form.data('update-container')
        }
      };
    }
  }

  return Object(_fetch__WEBPACK_IMPORTED_MODULE_1__["formSubmitHelper"])(url, $form.attr('id'), options).then(function (json) {
    $form.removeClass('submitting');
    $form.find('button[type=submit]').each(function () {
      var $button = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
      $button.removeClass('auto-disabled');
      $button.prop('disabled', false);
    });

    if ($form.data('auto-close') !== undefined) {
      UI.Backdrop.reset();
    } else if ($form.data('auto-close-container') !== undefined) {
      $form.parents('.fullpage_backdrop').hide();
    }

    Pachno.trigger(Pachno.EVENTS.formSubmitResponse, {
      form: $form.attr('id'),
      json: json
    });
  });
};

var submitInteractiveForm = function submitInteractiveForm(event, $form) {
  $form.addClass('submitting');
  event.preventDefault();
  submitForm($form).then(function () {
    $form.removeClass('submitting');
  })["catch"](function (error) {
    console.error(error);
    $form.removeClass('submitting');
  });
};

jquery__WEBPACK_IMPORTED_MODULE_0___default()(document).ready(function () {
  var $body = jquery__WEBPACK_IMPORTED_MODULE_0___default()('body');
  $body.on('click', '.tab-switcher .tab-switcher-trigger', function () {
    var $tabSwitcher = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).parent('.tab-switcher');
    var $tab = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
    var target = $tab.data('tab-target');
    tabSwitcher($tab, target, $tabSwitcher);
  });
  $body.on('click', '.fullpage_backdrop_content .closer', function () {
    return UI.Backdrop.reset();
  });
  $body.on('click', '.trigger-backdrop', autoBackdropLink);
  $body.on('submit', 'form[data-simple-submit]', autoSubmitForm);
  $body.on('click', '.trigger-open-component', function (event) {
    event.preventDefault();
    event.stopPropagation();
    var $item = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).parents('.configurable-component');
    loadComponentOptions($item);
  });
  $body.on("click", ".collapser", function (e) {
    var collapser_item = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this),
        is_visible = collapser_item.hasClass('active'),
        collapseItem = function collapseItem(item) {
      var target = item.data('target');

      if (target) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(target).removeClass('active');
      }

      item.removeClass('active');
    },
        expandItem = function expandItem(item) {
      var target = item.data('target');

      if (target) {
        jquery__WEBPACK_IMPORTED_MODULE_0___default()(target).addClass('active');
      }

      item.addClass('active');
    };

    if (collapser_item.data('exclusive')) {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()('.collapser.active').each(function () {
        collapseItem(collapser_item);
      });
    }

    if (!is_visible) {
      expandItem(collapser_item);
    } else {
      collapseItem(collapser_item);
    }

    e.stopPropagation();
    e.preventDefault();
  });
  $body.on('submit', 'form[data-interactive-form]', function (event) {
    return submitInteractiveForm(event, jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target));
  });
  $body.on('blur', 'form[data-interactive-form] input[type=text], form[data-interactive-form] textarea', function (event) {
    return submitInteractiveForm(event, jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).parents('form'));
  });
  $body.on('change', 'form[data-interactive-form] input[type=radio], form[data-interactive-form] input[type=checkbox]', function (event) {
    return submitInteractiveForm(event, jquery__WEBPACK_IMPORTED_MODULE_0___default()(event.target).parents('form'));
  });
});
/* harmony default export */ __webpack_exports__["default"] = (UI);

/***/ }),

/***/ "./js/index.js":
/*!*********************!*\
  !*** ./js/index.js ***!
  \*********************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _classes_pachno__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./classes/pachno */ "./js/classes/pachno.js");

 // Pachno.Main.updatePercentageLayout = function (arg1, arg2) {
//     if (isNaN(arg1))
//     {
//         $(arg1).style.width = arg2 + "%";
//     } else {
//         $('#percent_complete_content').find('.percent_filled').first().style.width = arg1 + '%';
//     }
// };
//
// Pachno.Main.updateAttachments = function (form) {
//     var url = form.action;
//     Pachno.Helpers.fetch(url, {
//         form: form,
//         method: 'POST',
//         loading: {
//             indicator: '#attachments_indicator',
//             callback: function () {
//                 $('#dynamic_uploader_submit').addClass('disabled');
//                 $('#dynamic_uploader_submit').prop('disabled', true);
//                 $('#report_issue_submit_button').addClass('disabled');
//                 $('#report_issue_submit_button').prop('disabled', true);
//             }
//         },
//         success: {
//             callback: function (json) {
//                 Pachno.Helpers.Backdrop.reset();
//                 var base = $(json.container_id);
//                 if (base !== undefined) {
//                     base.html('');
//                     json.files.each(function (file_elm) {
//                         base.append(file_elm);
//                     });
//                     if (json.files.length) {
//                         if ($('#viewissue_uploaded_attachments_count')) $('#viewissue_uploaded_attachments_count').html(json.files.length);
//                         $('#viewissue_no_uploaded_files').hide();
//                     }
//                 }
//                 $('#comments_box').prepend(json.comments);
//             }
//         },
//         complete: {
//             callback: function () {
//                 $('#dynamic_uploader_submit').addClass('disabled');
//                 $('#dynamic_uploader_submit').prop('disabled', false);
//                 $('#report_issue_submit_button').addClass('disabled');
//                 $('#report_issue_submit_button').prop('disabled', false);
//             }
//         }
//     });
//
// };
//
// Pachno.Main.Link.add = function (url, target_type, target_id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'attach_link_' + target_type + '_' + target_id + '_form',
//         loading: {
//             indicator: '#attach_link_' + target_type + '_' + target_id + '_indicator',
//             callback: function () {
//                 $('#attach_link_' + target_type + '_' + target_id + '_submit').prop('disabled', true);
//             }
//         },
//         success: {
//             reset: 'attach_link_' + target_type + '_' + target_id + '_form',
//             hide: ['attach_link_' + target_type + '_' + target_id, target_type + '_' + target_id + '_no_links'],
//             update: {element: target_type + '_' + target_id + '_links', insertion: true},
//             callback: function () {
//                 if ($(target_type + '_' + target_id + '_container').hasClass('menu_editing')) {
//                     $('#toggle_' + target_type + '_' + target_id +'_edit_mode').trigger('click');
//                     $('#toggle_' + target_type + '_' + target_id +'_edit_mode').trigger('click');
//                 }
//             }
//         },
//         complete: {
//             callback: function () {
//                 $('#attach_link_' + target_type + '_' + target_id + '_submit').prop('disabled', false);
//             }
//         }
//     });
// };
//
// Pachno.Main.Link.remove = function (url, target_type, target_id, link_id) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             hide: target_type + '_' + target_id + '_links_' + link_id + '_remove_link',
//             indicator: '#dialog_indicator'
//         },
//         success: {
//             remove: [target_type + '_' + target_id + '_links_' + link_id, target_type + '_' + target_id + '_links_' + link_id + '_remove_confirm'],
//             callback: function (json) {
//                 Pachno.Helpers.Dialog.dismiss();
//                 if ($(json.target_type + '_' + json.target_id + '_links').children().length == 0) {
//                     $(json.target_type + '_' + json.target_id + '_no_links').show();
//                 }
//             }
//         },
//         failure: {
//             show: target_type + '_' + target_id + '_links_' + link_id + '_remove_link'
//         }
//     });
// };
//
// Pachno.Main.Menu.toggleEditMode = function (target_type, target_id, url) {
//     if ($(target_type + '_' + target_id + '_container').hasClass('menu_editing')) {
//         Sortable.destroy(target_type + '_' + target_id + '_links');
//     } else {
//         Sortable.create(target_type + '_' + target_id + '_links', {constraint: '', onUpdate: function (container) {
//             Pachno.Main.Menu.saveOrder(container, target_type, target_id, url);
//         }});
//     }
//     $(target_type + '_' + target_id + '_container').toggleClass('menu_editing');
// };
//
// Pachno.Main.Menu.saveOrder = function (container, target_type, target_id, url) {
//     Pachno.Helpers.fetch(url, {
//         additional_params: Sortable.serialize(container),
//         loading: {
//             indicator: target_type + '_' + target_id + '_indicator'
//         }
//     });
// };
//
// Pachno.Main.detachFileFromArticle = function (url, file_id, article_id) {
//     Pachno.Core._detachFile(url, file_id, 'article_' + article_id + '_files_', 'dialog_indicator');
// };
//
// Pachno.Main.toggleFavouriteArticle = function (url, article_id)
// {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#article_favourite_indicator_' + article_id,
//             hide: ['article_favourite_normal_' + article_id, 'article_favourite_faded_' + article_id]
//         },
//         success: {
//             callback: function (json) {
//                 if ($('#article_favourite_faded_' + article_id)) {
//                     if (json.starred) {
//                         $('#article_favourite_faded_' + article_id).hide();
//                         $('#article_favourite_indicator_' + article_id).hide();
//                         $('#article_favourite_normal_' + article_id).show();
//                     } else {
//                         $('#article_favourite_normal_' + article_id).hide();
//                         $('#article_favourite_indicator_' + article_id).hide();
//                         $('#article_favourite_faded_' + article_id).show();
//                     }
//                 } else if (json.subscriber != '') {
//                     $('#subscribers_list').append(json.subscriber);
//                 }
//             }
//         }
//     });
// };
//
// Pachno.Main.deleteArticle = function (url) {
//     Pachno.Helpers.fetch(url, {
//         method: 'POST',
//         loading: {
//             indicator: '#fullpage_backdrop',
//             show: 'fullpage_backdrop_indicator',
//             hide: ['fullpage_backdrop_content', 'dialog_backdrop']
//         },
//         success: {
//             callback: function () {
//                 location.reload();
//             }
//         }
//     });
// };
//
// Pachno.Main.Profile.changePassword = function (url) {
//     Pachno.Helpers.fetch(url, {
//         form: 'change_password_form',
//         loading: {indicator: '#change_password_indicator'},
//         success: {reset: 'change_password_form', hide: 'change_password_div'}
//     });
// };
//
// Pachno.Main.Profile.addApplicationPassword = function (url) {
//     Pachno.Helpers.fetch(url, {
//         form: 'add_application_password_form',
//         loading: {indicator: '#add_application_password_indicator'},
//         success: {
//             hide: 'add_application_password_container',
//             update: {element: 'application_password_preview', from: 'password'},
//             show: 'add_application_password_response'
//         }
//     });
// };
//
// Pachno.Main.Profile.removeApplicationPassword = function (url, p_id) {
//     Pachno.Helpers.fetch(url, {
//         method: 'POST',
//         loading: {
//             callback: function () {
//                 $('#application_password_' + p_id).down('button').prop('disabled', true);
//             }
//         },
//         success: {
//             remove: 'application_password_' + p_id,
//             callback: function () {
//                 Pachno.Helpers.Dialog.dismiss();
//             }
//         },
//         failure: {
//             callback: function () {
//                 $('#application_password_' + p_id).down('button').prop('disabled', false);
//             }
//         }
//     });
// };
//
// Pachno.Main.Profile.checkUsernameAvailability = function (url) {
//     Pachno.Helpers.fetch(url, {
//         form: 'check_username_form',
//         loading: {
//             indicator: '#pick_username_indicator',
//             hide: 'username_unavailable'
//         },
//         complete: {
//             callback: function (json) {
//                 if (json.available) {
//                     Pachno.Helpers.Backdrop.show(json.url);
//                 } else {
//                     $('#username_unavailable').show();
//                     $('#username_unavailable').pulsate({pulses: 3, duration: 1});
//                 }
//             }
//         }
//     });
// };
//
// Pachno.Main.Profile.toggleNotificationSettings = function (preset) {
//     if (preset == 'custom') {
//         $('#notification_settings_selectors').show();
//     } else {
//         $('#notification_settings_selectors').hide();
//     }
// };
//
// Pachno.Main.Profile.removeOpenIDIdentity = function (url, oid) {
//     Pachno.Helpers.fetch(url, {
//         loading: {indicator: '#dialog_indicator'},
//         success: {
//             remove: 'openid_account_' + oid,
//             callback: function () {
//                 if ($('#openid_accounts_list').children().length == 0)
//                     $('#no_openid_accounts').show();
//                 if ($('#openid_accounts_list').children().length == 1 && $('#pick_username_button'))
//                     $('#openid_accounts_list').down('.button').remove();
//                 Pachno.Helpers.Dialog.dismiss();
//             }
//         }
//     });
// };
//
// Pachno.Main.Profile.cancelScopeMembership = function (url, sid) {
//     Pachno.Helpers.fetch(url, {
//         loading: {indicator: '#dialog_indicator'},
//         success: {
//             remove: 'account_scope_' + sid,
//             callback: function () {
//                 if ($('#pending_scope_memberships').children().length == 0)
//                     $('#no_pending_scope_memberships').show();
//                 Pachno.Helpers.Dialog.dismiss();
//             }
//         }
//     });
// };
//
// Pachno.Main.Profile.confirmScopeMembership = function (url, sid) {
//     Pachno.Helpers.fetch(url, {
//         loading: {indicator: '#dialog_indicator'},
//         success: {
//             callback: function () {
//                 $('#confirmed_scope_memberships').append($('#account_scope_' + sid).remove());
//                 $('#account_scope_' + sid).down('.button-green').remove();
//                 $('#account_scope_' + sid).down('.button-red').show();
//                 if ($('#pending_scope_memberships').children().length == 0)
//                     $('#no_pending_scope_memberships').show();
//                 Pachno.Helpers.Dialog.dismiss();
//             }
//         }
//     });
// };
//
// Pachno.Main.Dashboard.View.init = function (view_id) {
//     var dashboard_element = $('#dashboard_container_' + view_id),
//         dashboard_container = dashboard_element.parents('.dashboard'),
//         url = dashboard_container.data('url').replace('{view_id}', view_id);
//
//     if (dashboard_element.data('preloaded') == "0") {
//         Pachno.Helpers.fetch(url, {
//             method: 'GET',
//             loading: {indicator: '#dashboard_view_' + view_id + '_indicator'},
//             success: {update: '#dashboard_view_' + view_id},
//             complete: {
//                 callback: function () {
//                     Pachno.Core._resizeWatcher();
//                     Pachno.Main.Dashboard.views.splice(0, 1);
//                     if (Pachno.Main.Dashboard.views.length == 0) {
//                         $('html').css({'cursor': 'default'});
//                     }
//                 }
//             }
//         });
//     }
// };
//
// Pachno.Main.Dashboard.sort = function (event) {
//     var list = $(event.target);
//     var url = list.parents('.dashboard').data('sort-url');
//     var items = '&column=' + list.data('column');
//     list.children().each(function (view) {
//         if (view.data('view-id') !== undefined) {
//             items += '&view_ids[]=' + view.data('view-id');
//         }
//     });
//     Pachno.Helpers.fetch(url, {
//         additional_params: items,
//         loading: {indicator: list.down('.dashboard_indicator')}
//     });
// };
//
// Pachno.Main.Dashboard.initializeSorting = function ($) {
//     $('.dashboard_column.jsortable').sortable({
//         handle: '.dashboardhandle',
//         connectWith: '.dashboard_column',
//         items: '.dashboard_view_container',
//         helper: function(event, ui){
//             var $clone =  $(ui).clone();
//             $clone .css('position','absolute');
//             return $clone.get(0);
//         }
//     }).bind('sortupdate', Pachno.Main.Dashboard.sort);
// };
//
// Pachno.Main.Dashboard.addView = function (element) {
//     var dashboard_element = element.parents('.dashboard_view');
//     element.prop('disabled', true);
//     var dashboard_views_container = dashboard_element.parents('.available_views_container');
//     var dashboard_container = $('#dashboard_' + dashboard_views_container.data('dashboard-id'));
//     var url = dashboard_container.data('post-url');
//     var column = dashboard_views_container.data('column');
//     Pachno.Helpers.fetch(url, {
//         method: 'POST',
//         params: 'mode=add_view&view_type=' + dashboard_element.data('view-type') + '&view_subtype=' + dashboard_element.data('view-subtype') + '&column=' + column,
//         loading: {
//             indicator: dashboard_element.down('.view_indicator'),
//         },
//         success: {
//             callback: function (json) {
//                 var column_container = dashboard_container.down('.dashboard_column.column_' + column);
//                 column_container.append(json.view_content);
//                 Pachno.Main.Dashboard.views.push(json.view_id);
//                 Pachno.Main.Dashboard.View.init(json.view_id);
//                 element.prop('disabled', false);
//                 Pachno.Main.Dashboard.initializeSorting(jQuery);
//             }
//         }
//     });
// };
//
// Pachno.Main.Dashboard.removeView = function (event, element) {
//     var view_id = element.parents('.dashboard_view_container').data('view-id');
//     var column = element.parents('.dashboard_column');
//     var dashboard_container = element.parents('.dashboard');
//     var url = dashboard_container.data('post-url');
//     Pachno.Helpers.fetch(url, {
//         params: '&mode=remove_view&view_id=' + view_id,
//         loading: {indicator: element.parents('.dashboard_view_container').down('.dashboard_indicator')},
//         success: {
//             remove: 'dashboard_container_' + view_id
//         }
//     });
// };
//
// Pachno.Main.Dashboard.toggleMenu = function (link) {
//     var section = $(link).data('section');
//     $(link).parents('ul').children().each(function (menu_elm) {
//         menu_elm.removeClass('selected');
//     })
//     $(link).parents('li').addClass('selected');
//     $(link).parents('.backdrop_detail_content').down('.available_views_container').children().each(function (view_list) {
//         ($(view_list).data('section') == section) ? $(view_list).show() : $(view_list).hide();
//     });
//
// };
//
// Pachno.Main.Dashboard.sidebar = function (url, id)
// {
//     Pachno.Main.setToggleState(url, !$(id).hasClass('collapsed'));
//     $(id).toggleClass('collapsed');
//     Pachno.Core._resizeWatcher();
//     Pachno.Core._scrollWatcher();
// }
//
// Pachno.Main.Profile.setState = function (url, ind) {
//     Pachno.Helpers.fetch(url, {
//         loading: {indicator: ind},
//         success: {
//             callback: function (json) {
//                 $('.current_userstate').each(function (element) {
//                     $(element).html(json.userstate);
//                 });
//             }
//         }
//     });
// }
//
// Pachno.Main.Profile.addFriend = function (url, user_id, rnd_no) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#toggle_friend_' + user_id + '_' + rnd_no + '_indicator',
//             hide: ['add_friend_' + user_id + '_' + rnd_no, 'user_' + user_id + '_more_actions']
//         },
//         success: {
//             show: ['remove_friend_' + user_id + '_' + rnd_no, 'user_' + user_id + '_more_actions']
//         },
//         failure: {
//             show: ['add_friend_' + user_id + '_' + rnd_no, 'user_' + user_id + '_more_actions']
//         }
//     });
// }
//
// Pachno.Main.Profile.removeFriend = function (url, user_id, rnd_no) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#toggle_friend_' + user_id + '_' + rnd_no + '_indicator',
//             hide: ['remove_friend_' + user_id + '_' + rnd_no, 'user_' + user_id + '_more_actions']
//         },
//         success: {
//             show: ['add_friend_' + user_id + '_' + rnd_no, 'user_' + user_id + '_more_actions']
//         },
//         failure: {
//             show: ['remove_friend_' + user_id + '_' + rnd_no, 'user_' + user_id + '_more_actions']
//         }
//     });
// };
//
// Pachno.Main.hideInfobox = function (url, boxkey) {
//     if ($('#close_me_' + boxkey).checked) {
//         var $form = $('#close_me_' + boxkey + '_form');
//         $form.addClass('submitting');
//         $form.find('.button.primary').prop('disabled', true);
//
//         fetch(url)
//             .then(function (response) {
//                 setTimeout(function () {
//                     $form.removeClass('submitting');
//                     $form.find('.button.primary').prop('disabled', false);
//                 }, 300);
//                 $('#infobox_' + boxkey).fade({duration: 0.25});
//             });
//     } else {
//         $('#infobox_' + boxkey).fade({duration: 0.3});
//     }
// };
//
// Pachno.Main.setToggleState = function (url, state) {
//     url += '/' + (state ? '1' : 0);
//     Pachno.Helpers.fetch(url, {});
// };
//
// Pachno.Main.Comment.showPost = function () {
//     $('.comment-editor').each(Element.hide);
//     $('#comment_add_button').hide();
//     $('#comment_add').show();
//     $('#comment_bodybox').focus();
// };
//
// Pachno.Main.Comment.toggleOrder = function (target_type, target_id) {
//     Pachno.Helpers.fetch($('#main_container').data('url'), {
//         method: 'POST',
//         loading: {
//             indicator: '#comments_loading_indicator'
//         },
//         params: '&say=togglecommentsorder',
//         success: {
//             callback: function () {
//                 Pachno.Main.Comment.reloadAll(target_type, target_id);
//             }
//         }
//     });
// };
//
// Pachno.Main.Comment.reloadAll = function (target_type, target_id) {
//     Pachno.Helpers.fetch($('#main_container').data('url'), {
//         method: 'GET',
//         loading: {
//             indicator: '#comments_loading_indicator'
//         },
//         params: '&say=loadcomments&target_type='+target_type+'&target_id='+target_id,
//         success: {
//             callback: function (json) {
//                 $('#comments_box').html(json.comments);
//             }
//         }
//     });
// };
//
// Pachno.Main.Comment.remove = function (url, comment_id, commentcount_span) {
//     $('#dialog_indicator').show();
//     fetch(url, {
//         method: 'DELETE'
//     })
//         .then(function (response) {
//             response.json()
//                 .then(function () {
//                     if (response.ok) {
//                         $('#comment_' + comment_id).remove();
//                         Pachno.Helpers.Dialog.dismiss();
//                         $('#dialog_indicator').hide();
//                         if ($('#comments_box').children().length == 0) {
//                             $('#comments-list-none').show();
//                         }
//                         $(commentcount_span).html($('#comments_box').children().length);
//                     }
//                 });
//         });
//     // Pachno.Helpers.fetch(url, {
//     //     method: 'DELETE'
//     //     loading: {
//     //         indicator: '#dialog_indicator'
//     //     },
//     //     success: {
//     //         remove: 'comment_' + comment_id,
//     //         callback: function () {
//     //             Pachno.Helpers.Dialog.dismiss();
//     //             if ($('#comments_box').children().length == 0) {
//     //                 $('#comments-list-none').show();
//     //             }
//     //             $(commentcount_span).html($('#comments_box').children().length);
//     //         }
//     //     }
//     // });
// };
//
// Pachno.Main.Comment.update = function (comment_id) {
//     var $form = $('#comment_edit_form_' + comment_id),
//         data = new FormData($form[0]),
//         $comment_container = $('#comment_' + comment_id + '_content');
//
//     $form.find('.error-container').removeClass('invalid');
//     $form.find('.error-container > .error').html('');
//     $form.addClass('submitting');
//     $form.find('.button.primary').prop('disabled', true);
//
//     fetch($form.attr('action'), {
//         method: 'POST',
//         body: data
//     })
//         .then(function (response) {
//             response.json().then(function (json) {
//                 if (response.ok) {
//                     $comment_container.html(json.comment_data);
//                     $('#comment_edit_' + comment_id).removeClass('active');
//                     $('#comment_' + comment_id + '_body').show();
//                     $('#comment_view_' + comment_id).show();
//                 } else {
//                     $form.find('.error-container > .error').html(json.error);
//                     $form.find('.error-container').addClass('invalid');
//                 }
//
//                 $form.removeClass('submitting');
//                 $form.find('.button.primary').prop('disabled', false);
//             });
//         });
//
//     // Pachno.Helpers.fetch(url, {
//     //     form: 'comment_edit_form_' + comment_id,
//     //     loading: {
//     //         indicator: '#comment_edit_indicator_' + comment_id,
//     //         hide: 'comment_edit_controls_' + comment_id
//     //     },
//     //     success: {
//     //         hide: ['comment_edit_indicator_' + comment_id],
//     //         show: ['comment_view_' + comment_id, 'comment_edit_controls_' + comment_id, 'comment_add_button'],
//     //         update: {element: 'comment_' + comment_id + '_content', from: 'comment_body'},
//     //         callback: function () {
//     //             $('#comment_edit_' + comment_id).removeClass('active');
//     //             $('#comment_' + comment_id + '_body').show();
//     //         }
//     //     },
//     //     failure: {
//     //         show: ['comment_edit_controls_' + comment_id]
//     //     }
//     // });
// };
//
// Pachno.Main.Comment.add = function (url, commentcount_span) {
//     var $form = $('#add-comment-form'),
//         data = new FormData($form[0]),
//         $count_span = $('#' + commentcount_span),
//         $comments_container = $('#comments_box');
//
//     $form.find('.error-container').removeClass('invalid');
//     $form.find('.error-container > .error').html('');
//     $form.addClass('submitting');
//     $form.find('.button.primary').prop('disabled', true);
//
//     fetch($form.attr('action'), {
//         method: 'POST',
//         body: data
//     })
//         .then(function (response) {
//             response.json().then(function (json) {
//                 if (response.ok) {
//                     $comments_container.append(json.comment_data);
//                     $('#comments-list-none').remove();
//                     window.location.hash = "#comment_" + json.comment_id;
//                     $count_span.html(json.commentcount);
//                     $form[0].reset();
//
//                     $('#comment_add').hide();
//                     $('#comment_add_button').show();
//                 } else {
//                     $form.find('.error-container > .error').html(json.error);
//                     $form.find('.error-container').addClass('invalid');
//                 }
//
//                 $form.removeClass('submitting');
//                 $form.find('.button.primary').prop('disabled', false);
//             });
//         });
// };
//
// Pachno.Main.Comment.reply = function (reply_comment_id) {
//     var $form = $('#comment_reply_form_' + reply_comment_id),
//         data = new FormData($form[0]),
//         $comments_container = $('#comment_' + reply_comment_id + '_replies');
//
//     $form.find('.error-container').removeClass('invalid');
//     $form.find('.error-container > .error').html('');
//     $form.addClass('submitting');
//     $form.find('.button.primary').prop('disabled', true);
//
//     fetch($form.attr('action'), {
//         method: 'POST',
//         body: data
//     })
//         .then(function (response) {
//             response.json().then(function (json) {
//                 if (response.ok) {
//                     $comments_container.append(json.comment_data);
//                     window.location.hash = "#comment_" + json.comment_id;
//                     $form[0].reset();
//
//                     $('#comment_reply_controls_' + reply_comment_id).show();
//                     $('#comment_reply_' + reply_comment_id).removeClass('active');
//                 } else {
//                     $form.find('.error-container > .error').html(json.error);
//                     $form.find('.error-container').addClass('invalid');
//                 }
//
//                 $form.removeClass('submitting');
//                 $form.find('.button.primary').prop('disabled', false);
//             });
//         });
// };
//
// Pachno.Main.Login.register = function (url)
// {
//     Pachno.Helpers.fetch(url, {
//         form: 'register_form',
//         loading: {
//             indicator: '#register_indicator',
//             hide: 'register_button',
//             callback: function () {
//                 $('#input.required').each(function (field) {
//                     $(field).css({backgroundColor: ''});
//                 });
//             }
//         },
//         success: {
//             hide: 'register_form',
//             update: {element: 'register_message', from: 'loginmessage'},
//             callback: function (json) {
//                 if (json.activated) {
//                     $('#register_username_hidden').value($('#fieldusername').val());
//                     $('#register_password_hidden').value(json.one_time_password);
//                     $('#register_auto_form').show();
//                 } else {
//                     $('#register_confirm_back').show();
//                 }
//                 $('#register_confirmation').show();
//             }
//         },
//         failure: {
//             show: 'register_button',
//             callback: function (json) {
//                 json.fields.each(function (field) {
//                     $(field).css({backgroundColor: '#FBB'});
//                 });
//             }
//         }
//     });
// };
//
// Pachno.Main.Login.checkUsernameAvailability = function (url)
// {
//     var $username_row = $('#row-register-username'),
//         data = new FormData();
//
//     data.append('username', $('#fieldusername').val());
//     $username_row.addClass('submitting');
//
//     fetch(url, {
//         method: 'POST',
//         body: data
//     })
//         .then((_) => _.json())
//         .then(function (json) {
//             $username_row.removeClass('submitting');
//             if (json.available) {
//                 $username_row.removeClass('invalid');
//             } else {
//                 $username_row.addClass('invalid');
//             }
//         });
// };
//
// Pachno.Main.Login.registerAutologin = function (url)
// {
//     Pachno.Helpers.fetch(url, {
//         form: 'register_auto_form',
//         loading: {
//             indicator: '#register_autologin_indicator',
//             callback: function () {
//                 $('#register_autologin_button').prop('disabled', true);
//                 $('#register_autologin_indicator').show();
//             }
//         },
//         complete: {
//             callback: function () {
//                 $('#register_autologin_indicator').hide();
//                 $('#register_autologin_button').prop('disabled', false);
//             }
//         }
//     });
// };
//
// Pachno.Main.Login.login = function ()
// {
//     var $form = $('#login_form'),
//         $login_button = $('#login_button'),
//         url = $form.attr('action');
//
//     $('#login-error-container').removeClass('invalid');
//     $login_button.addClass('submitting');
//     $login_button.prop('disabled', true);
//
//     fetch(url, {
//         method: 'POST',
//         body: new FormData($form[0])
//     })
//         .then(function (response) {
//             response.json().then(function (json) {
//                 $login_button.removeClass('submitting');
//                 $login_button.prop('disabled', false);
//
//                 if (response.ok) {
//                     if (json.forward) {
//                         window.location = json.forward;
//                     } else {
//                         window.location.reload();
//                     }
//                 } else {
//                     console.error(json);
//                     $('#login-error-message').html(json.error);
//                     $('#login-error-container').addClass('invalid');
//                 }
//             });
//         })
//         .catch(function (error) {
//             $('#login-error-message').html(error);
//             $('#login-error-container').addClass('invalid');
//             console.error(error);
//         });
//
//     // Pachno.Helpers.fetch(url, {
//     //     form: 'login_form',
//     //     loading: {
//     //         indicator: '#login_indicator',
//     //         callback: function () {
//     //             $('#login_button').prop('disabled', true);
//     //             $('#login_indicator').show();
//     //         }
//     //     },
//     //     complete: {
//     //         callback: function () {
//     //             $('#login_indicator').hide();
//     //             $('#login_button').prop('disabled', false);
//     //         }
//     //     }
//     // });
// };
//
// Pachno.Main.Login.verify2FaTokenWithLogin = function (form) {
//     Pachno.Core.fetchPostHelper(form)
//         .then(Pachno.Core.fetchPostDefaultFormHandler)
//         .then(([$form, response]) => {
//             if (response.ok) {
//                 response.json().then(function (json) {
//                     window.location = json.forward;
//                 });
//             }
//         })
// };
//
// Pachno.Main.Login.elevatedLogin = function (url)
// {
//     Pachno.Helpers.fetch(url, {
//         form: 'login_form',
//         loading: {
//             indicator: '#elevated_login_indicator',
//             callback: function () {
//                 $('#login_button').prop('disabled', true);
//                 $('#elevated_login_indicator').show();
//             }
//         },
//         complete: {
//             callback: function (json) {
//                 $('#elevated_login_indicator').hide();
//                 if (json.elevated) {
//                     window.location.reload(true);
//                 } else {
//                     Pachno.Helpers.Message.error(json.error);
//                     $('#login_button').prop('disabled', false);
//                 }
//             }
//         }
//     });
// };
//
// Pachno.Main.Login.resetForgotPassword = function (url) {
//     Pachno.Helpers.fetch(url, {
//         form: 'forgot_password_form',
//         loading: {
//             indicator: '#forgot_password_indicator',
//             hide: 'forgot_password_button'
//         },
//         failure: {
//             reset: 'forgot_password_form'
//         },
//         complete: {
//             show: 'forgot_password_button',
//             callback: function () {
//                 $('#regular_login_container').parents().find('.logindiv').each(function (elm) {
//                     elm.removeClass('active');
//                 });
//                 $('#regular_login_container').addClass('active');
//             }
//         }
//     });
// };
//
// Pachno.Main.Login.showLogin = function (section) {
//     $('#login_backdrop').find('.logindiv').removeClass('active');
//     $(section).addClass('active');
//     if (section != 'register' && $('#registration-button-container')) {
//         $('#registration-button-container').addClass('active');
//     }
//     $('#login_backdrop').show();
//     setTimeout(function () {
//         if (section == 'register') {
//             $('#fieldusername').focus();
//         } else if (section == 'regular_login_container') {
//             $('#pachno_username').focus();
//         }
//     }, 250);
// };
//
// Pachno.Main.Login.forgotToggle = function () {
//     $('#regular_login_container').parents().find('.logindiv').each(function () {
//         $(this).removeClass('active');
//     });
//     $('#forgot_password_container').addClass('active');
// };
//
// Pachno.Project.Statistics.get = function (url, section) {
//     $('#statistics_selector').children().each(function () {
//         $(this).removeClass('selected');
//     });
//     $('#statistics_per_' + section + '_selector').addClass('selected');
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             show: 'statistics_main',
//             hide: 'statistics_help',
//             callback: function () {
//                 $('#statistics_main_image').src = '';
//                 for (var cc = 1; cc <= 3; cc++) {
//                     $('#statistics_mini_image_' + cc).src = '';
//                 }
//             }
//         },
//         success: {
//             callback: function (json) {
//                 $('#statistics_main_image').src = json.images.main;
//                 ecc = 1;
//                 for (var cc = 1; cc <= 3; cc++) {
//                     var small_name = 'mini_' + cc + '_small';
//                     var large_name = 'mini_' + cc + '_large';
//                     if (json.images[small_name]) {
//                         $('#statistics_mini_image_' + cc).show();
//                         $('#statistics_mini_image_' + cc).src = json.images[small_name];
//                         $('#statistics_mini_' + cc + '_main').value(json.images[large_name]);
//                     } else {
//                         $('#statistics_mini_image_' + cc).hide();
//                         $('#statistics_mini_' + cc + '_main').value('');
//                         ecc++;
//                     }
//                 }
//                 if (ecc == cc) {
//                     $('#statistics_main_image_div').next().hide();
//                     $('#statistics_main_image_div').next().next().hide();
//                 }
//                 else {
//                     $('#statistics_main_image_div').next().show();
//                     $('#statistics_main_image_div').next().next().show();
//                 }
//             }
//         },
//         failure: {show: 'statistics_help'}
//     });
// };
//
// Pachno.Project.Statistics.toggleImage = function (image) {
//     $('#statistics_main_image').src = '';
//     $('#statistics_main_image').src = $('#statistics_mini_' + image + '_main').val();
// };
//
// Pachno.Project.Milestone.refresh = function (url, milestone_id) {
//     var m_id = milestone_id;
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#milestone_' + milestone_id + '_indicator'
//         },
//         success: {
//             callback: function (json) {
//                 var must_reload_issue_list = false;
//                 if (json.percent) {
//                     Pachno.Main.updatePercentageLayout('milestone_' + m_id + '_percent', json.percent);
//                     delete json.percent;
//                 }
//                 for (var item in json)
//                 {
//                     var existing = $('#milestone_' + m_id + '_' + item);
//                     if (existing)
//                     {
//                         if (existing.innerHTML != json[item])
//                         {
//                             existing.html(json[item]);
//                             must_reload_issue_list = true;
//                         }
//                     }
//                 }
//                 if (must_reload_issue_list) {
//                     $('#milestone_' + m_id + '_changed').show();
//                     $('#milestone_' + m_id + '_issues').html('');
//                 }
//
//             }
//         }
//     });
// };
//
// Pachno.Project.Timeline.update = function (url) {
//     Pachno.Helpers.fetch(url, {
//         method: 'GET',
//         additional_params: "offset=" + $('#timeline_offset').val(),
//         loading: {
//             indicator: '#timeline_indicator',
//             hide: 'timeline_more_link'
//         },
//         success: {
//             update: {element: 'timeline', insertion: true},
//             show: 'timeline_more_link',
//             callback: function (json) {
//                 $('#timeline_offset').value(json.offset)
//             }
//         }
//     });
// };
//
// Pachno.Project.showBranchCommits = function (url, branch) {
//     Pachno.Helpers.fetch(url, {
//         method: 'POST',
//         additional_params: "branch=" + branch,
//         loading: {
//             indicator: '#fullpage_backdrop',
//             show: 'fullpage_backdrop_indicator',
//             hide: ['fullpage_backdrop_content', 'project_commits_box']
//         },
//         success: {
//             show: 'project_commits_box',
//             update: '#project_commits'
//         }
//     });
// };
//
// Pachno.Project.Commits.update = function (url, branch) {
//     Pachno.Helpers.fetch(url, {
//         method: 'POST',
//         additional_params: "from_commit=" + $('#from_commit').val() + "&branch=" + branch,
//         loading: {
//             indicator: '#commits_indicator',
//             hide: 'commits_more_link'
//         },
//         success: {
//             update: {element: 'commits', insertion: true},
//             show: 'commits_more_link',
//             callback: function (json) {
//                 $('#from_commit').value(json.last_commit)
//             }
//         }
//     });
// };
//
// Pachno.Project.Commits.viewIssueUpdate = function (url) {
//     Pachno.Helpers.fetch(url, {
//         method: 'POST',
//         additional_params: "offset=" + $('#commits_offset').val() + "&limit=" + $('#commits_limit').val(),
//         loading: {
//             indicator: '#commits_indicator',
//             hide: 'commits_more_link'
//         },
//         success: {
//             update: {element: 'viewissue_vcs_integration_commits', insertion: true}
//         }
//     });
// };
//
// Pachno.Project.Scrum.Sprint.add = function (url, assign_url)
// {
//     Pachno.Helpers.fetch(url, {
//         form: 'add_sprint_form',
//         loading: {indicator: '#sprint_add_indicator'},
//         success: {
//             reset: 'add_sprint_form',
//             hide: 'no_sprints',
//             update: {element: 'scrum_sprints', insertion: true}
//         }
//     });
// }
//
// Pachno.Project.Scrum.Story.setColor = function (url, story_id, color, event)
// {
//     event.stopPropagation();
//     Pachno.Helpers.fetch(url, {
//         params: {color: color},
//         loading: {indicator: '#color_selector_' + story_id + '_indicator'},
//         success: {
//             callback: function (json) {
//                 $('#story_color_' + story_id).style.backgroundColor = color;
//                 $('#story_color_' + story_id).style.color = json.text_color;
//                 $('.epic_badge').each(function (badge) {
//                     if (badge.data('parent-epic-id') == story_id) {
//                         badge.style.backgroundColor = color;
//                         badge.style.color = json.text_color;
//                     }
//                 });
//             }
//         },
//         complete: {
//             callback: function () {
//                 Pachno.Main.Profile.clearPopupsAndButtons();
//             }
//         }
//     });
// }
//
// Pachno.Project.updateLinks = function (json) {
//     if ($('#current_project_num_count'))
//         $('#current_project_num_count').html(json.total_count);
//     (json.more_available) ? $('#add_project_div').show() : $('#add_project_div').hide();
// }
//
// Pachno.Project.resetIcons = function (url) {
//     Pachno.Helpers.fetch(url, {
//         method: 'POST',
//         additional_params: '&clear_icons=1'
//     });
// };
//
// Pachno.Project.initializeFilterSearch = function () {
//     var si = filter.down('input[type=search]');
//     if (si != undefined)
//     {
//         si.data('previous-value', '');
//         if (si.data('callback-url') !== undefined) {
//             var fk = filter.data('filter-key');
//             si.on('keyup', function (event, element) {
//                 if (Pachno.ift_observers[fk])
//                     clearTimeout(Pachno.ift_observers[fk]);
//                 if ((si.val().length >= 3 || si.val().length == 0) && si.val() != si.data('last-value')) {
//                     Pachno.ift_observers[fk] = setTimeout(function () {
//                         Pachno.Search.getFilterValues(si);
//                         si.data('last-value', si.val());
//                     }, 1000);
//                 }
//             });
//         } else {
//             si.on('keyup', Pachno.Search.filterFilterOptions);
//         }
//         si.on('click', function (event, element) {
//             event.stopPropagation();
//             event.preventDefault();
//         });
//         filter.addClass('searchable');
//     }
// };
//
// Pachno.Project.remove = function (url, pid) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#fullpage_backdrop',
//             show: 'fullpage_backdrop_indicator',
//             hide: ['fullpage_backdrop_content', 'dialog_backdrop', 'project_delete_controls_' + pid]
//         },
//         success: {
//             remove: 'project_box_' + pid,
//             callback: function (json) {
//                 if ($('#project_table').children().length == 0)
//                     $('#noprojects_tr').show();
//                 if ($('#project_table_archived').children().length == 0)
//                     $('#noprojects_tr_archived').show();
//                 Pachno.Project.updateLinks(json);
//                 Pachno.Helpers.Dialog.dismiss();
//             }
//         },
//         failure: {
//             show: 'project_delete_error_' + pid
//         },
//         complete: {
//             show: 'project_delete_controls_' + pid
//         }
//     });
// }
//
// Pachno.Project.archive = function (url, pid) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#project_' + pid + '_archive_indicator'
//         },
//         success: {
//             remove: 'project_box_' + pid,
//             hide: 'noprojects_tr_archived',
//             callback: function (json) {
//                 if ($('#project_table').children().length == 0)
//                     $('#noprojects_tr').show();
//                 $('#project_table_archived').prepend(json.box);
//                 Pachno.Helpers.Dialog.dismiss();
//             }
//         }
//     });
// }
//
// Pachno.Project.unarchive = function (url, pid) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#project_' + pid + '_archive_indicator'
//         },
//         success: {
//             remove: 'project_box_' + pid,
//             hide: 'noprojects_tr',
//             callback: function (json) {
//                 if ($('#project_table_archived').children().length == 0)
//                     $('#noprojects_tr_archived').show();
//                 if (json.parent_id != 0) {
//                     $('#project_' + json.parent_id + '_children').append(json.box);
//                 } else {
//                     $('#project_table').append(json.box);
//                 }
//             }
//         },
//         failure: {
//             show: 'project_' + pid + '_unarchive'
//         }
//     });
// };
//
// Pachno.Project.Planning.initializeMilestoneDragDropSorting = function (milestone) {
//     var milestone_issues = $(milestone).find('.milestone-issues.jsortable');
//     if (milestone_issues.hasClass('ui-sortable')) {
//         milestone_issues.sortable('destroy');
//     }
//     milestone_issues.sortable({
//         handle: '.draggable',
//         connectWith: '.jsortable.intersortable',
//         update: Pachno.Project.Planning.sortMilestoneIssues,
//         receive: Pachno.Project.Planning.moveIssue,
//         sort: Pachno.Project.Planning.calculateNewBacklogMilestoneDetails,
//         start: function (event) {
//             $('.milestone-issues-container').each(function (index) {
//                 $(this).addClass('issue-drop-target');
//             })
//         },
//         stop: function (event) {
//             $('.milestone-issues-container').each(function (index) {
//                 $(this).removeClass('issue-drop-target');
//             })
//         },
//         over: function (event) { $(this).addClass('drop-hover'); },
//         out: function (event) { $(this).removeClass('drop-hover'); },
//         tolerance: 'pointer',
//         helper: function(event, ui) {
//             var $clone =  $(ui).clone();
//             $clone .css('position','absolute');
//             return $clone.get(0);
//         }
//     });
// };
//
// Pachno.Project.Planning.initializeReleaseDroptargets = function () {
//     $('#builds-list .release').not('ui-droppable').droppable({
//         drop: Pachno.Project.Planning.assignRelease,
//         accept: '.milestone-issue',
//         tolerance: 'pointer',
//         hoverClass: 'drop-hover'
//     });
// };
//
// Pachno.Project.Planning.initializeEpicDroptargets = function () {
//     $('#epics-list .epic').not('.ui-droppable').droppable({
//         drop: Pachno.Project.Planning.assignEpic,
//         accept: '.milestone-issue',
//         tolerance: 'pointer',
//         hoverClass: 'drop-hover'
//     });
// };
//
// Pachno.Project.Planning.toggleReleaseFilter = function (release) {
//     if (release !== 'auto' && $('#epics-list') && $('#epics-list').hasClass('filtered'))
//         Pachno.Project.Planning.toggleEpicFilter('auto');
//     if ($('#builds-list').hasClass('filtered') && (release == 'auto' || ($(release) && $(release).hasClass('selected')))) {
//         $('#builds-list').removeClass('filtered');
//         $('#builds-list').children().each(function (rel) {
//             rel.removeClass('selected');
//         });
//         $('.milestone-issue').each(function (issue) {
//             issue.removeClass('filtered');
//         });
//     } else if ($(release)) {
//         $('#builds-list').addClass('filtered');
//         $('#builds-list').children().each(function (rel) {
//             rel.removeClass('selected');
//         });
//         $(release).addClass('selected');
//         var release_id = $(release).data('release-id');
//         $('.milestone-issue').each(function (issue) {
//             (issue.data('release-' + release_id) === undefined) ? issue.addClass('filtered') : issue.removeClass('filtered');
//         });
//     }
//
//     Pachno.Project.Planning.calculateAllMilestonesVisibilityDetails();
// };
//
// Pachno.Project.Planning.toggleEpicFilter = function (epic) {
//     if (epic !== 'auto' && $('#builds-list') && $('#builds-list').hasClass('filtered'))
//         Pachno.Project.Planning.toggleReleaseFilter('auto');
//     if ($('#epics-list').hasClass('filtered') && (epic == 'auto' || ($(epic) && $(epic).hasClass('selected')))) {
//         $('#epics-list').removeClass('filtered');
//         $('#epics-list').children().each(function (ep) {
//             ep.removeClass('selected');
//         });
//         $('.milestone-issue').each(function (issue) {
//             issue.removeClass('filtered');
//         });
//     } else if ($(epic)) {
//         $('#epics-list').addClass('filtered');
//         $('#epics-list').children().each(function (ep) {
//             ep.removeClass('selected');
//         });
//         $(epic).addClass('selected');
//         var epic_id = $(epic).data('issue-id');
//         $('.milestone-issue').each(function (issue) {
//             (issue.data('parent-' + epic_id) === undefined) ? issue.addClass('filtered') : issue.removeClass('filtered');
//         });
//     }
//
//     Pachno.Project.Planning.calculateAllMilestonesVisibilityDetails();
// };
//
// Pachno.Project.Planning.toggleClosedIssues = function () {
//     $('#milestones-list').toggleClass('show_closed');
//     Pachno.Project.Planning.calculateAllMilestonesVisibilityDetails();
//     Pachno.Project.Planning.calculateNewBacklogMilestoneDetails();
//     Pachno.Main.Profile.clearPopupsAndButtons();
// };
//
// Pachno.Project.Planning.assignRelease = function (event, ui) {
//     var issue = $(ui.draggable[0]);
//     issue.data('sort-cancel', true);
//     if (issue.hasClass('milestone-issue')) {
//         var release = $(event.target);
//         var release_id = $(event.target).data('release-id');
//         var url = release.data('assign-issue-url');
//         Pachno.Helpers.fetch(url, {
//             additional_params: 'issue_id=' + issue.data('issue-id'),
//             loading: {indicator: release.down('.planning_indicator')},
//             complete: {
//                 callback: function (json) {
//                     $('#release_' + release_id + '_percentage_filler').css({width: json.closed_pct + '%'});
//                     Pachno.Core.Pollers.Callbacks.planningPoller();
//                     issue.data('release-' + release_id, true);
//                 }
//             }
//         });
//     }
// };
//
// Pachno.Project.Planning.updateNewMilestoneIssues = function () {
//     var num_issues = $('.milestone-issue.included').length;
//     $('#milestone_include_num_issues').html(num_issues);
//     $('#milestone_include_issues').show();
//     $('#include_selected_issues').value(1);
// };
//
// Pachno.Project.Planning.addEpic = function (form) {
//     var url = form.action;
//     Pachno.Helpers.fetch(url, {
//         form: form,
//         loading: {indicator: '#new_epic_indicator'},
//         success: {
//             callback: function (json) {
//                 $(form).reset();
//                 $(form).parents('li').removeClass('selected');
//                 Pachno.Core.Pollers.Callbacks.planningPoller();
//             }
//         }
//     });
// };
//
// Pachno.Project.Planning.assignEpic = function (event, ui) {
//     var issue = $(ui.draggable[0]);
//     issue.data('sort-cancel', true);
//     if (issue.hasClass('milestone-issue')) {
//         var epic = $(event.target);
//         var epic_id = $(event.target).data('issue-id');
//         var url = epic.data('assign-issue-url');
//         Pachno.Helpers.fetch(url, {
//             additional_params: 'issue_id=' + issue.data('issue-id'),
//             loading: {indicator: epic.down('.planning_indicator')},
//             complete: {
//                 callback: function (json) {
//                     $('#epic_' + epic_id + '_percentage_filler').css({width: json.closed_pct + '%'});
//                     $('#epic_' + epic_id + '_estimate').html(json.estimate);
//                     $('#epic_' + epic_id + '_child_issues_count').html(json.num_child_issues);
//                     issue.data('parent-' + epic_id, true);
//                     Pachno.Core.Pollers.Callbacks.planningPoller();
//                 }
//             }
//         });
//     }
// };
//
// Pachno.Project.Planning.destroyMilestoneDropSorting = function (milestone) {
//     if (milestone === undefined) {
//         $('.milestone-issues.ui-sortable').sortable('destroy');
//     } else {
//         $(milestone).find('.milestone-issues.ui-sortable').sortable('destroy');
//     }
// };
//
// Pachno.Project.Planning.getMilestoneIssues = function (milestone) {
//     if (milestone.hasClass('initialized')) {
//         return Promise.resolve();
//     }
//
//     let updateMilestoneIssuesContent = function (response) {
//         $('#milestone_' + milestone_id + '_issues').html(response.content);
//         return response;
//     };
//
//     let ti_button = milestone.down('.toggle-issues');
//
//     if (ti_button) {
//         ti_button.addClass('disabled');
//         ti_button.addClass('submitting');
//     }
//
//     var milestone_id = milestone.data('milestone-id');
//
//     return new Promise(function (resolve, reject) {
//         fetch(milestone.data('issues-url'))
//             .then((_) => _.json())
//             .then(updateMilestoneIssuesContent)
//             .then(function (response) {
//                 milestone.addClass('initialized');
//
//                 if (Pachno.Project.Planning.options.dragdrop) {
//                     Pachno.Project.Planning.initializeMilestoneDragDropSorting(milestone);
//                 }
//
//                 if (milestone.hasClass('available')) {
//                     var completed_milestones = $('.milestone-box.available.initialized');
//                     var multiplier = 100 / Pachno.Project.Planning.options.milestone_count;
//                     var pct = Math.floor(completed_milestones.length * multiplier);
//                     $('#planning_percentage_filler').css({width: pct + '%'});
//
//                     if (completed_milestones.length == (Pachno.Project.Planning.options.milestone_count - 1)) {
//                         $('#planning_loading_progress_indicator').hide();
//                         if (!Pachno.Core.Pollers.planningpoller)
//                             Pachno.Core.Pollers.planningpoller = new PeriodicalExecuter(Pachno.Core.Pollers.Callbacks.planningPoller, 15);
//
//                         $('#planning_indicator').hide();
//                         $('#planning_filter_title_input').prop('disabled', false);
//                     }
//                 }
//
//                 if (! milestone.down('.planning_indicator').hidden) milestone.down('.planning_indicator').hide();
//             })
//             .then(Pachno.Project.Planning.calculateAllMilestonesVisibilityDetails)
//             .then(function () {
//                 if (ti_button) {
//                     ti_button.removeClass('disabled');
//                     ti_button.removeClass('submitting');
//                 }
//
//                 resolve();
//             })
//             .catch(function (error) {
//                 milestone.addClass('initialized');
//                 milestone.find('.milestone_error_issues').each(Element.show);
//
//                 reject(error);
//             });
//     });
// };
//
// Pachno.Project.Planning.Whiteboard.addColumn = function(button) {
//     Pachno.Helpers.fetch(button.data('url'), {
//         loading: {
//             indicator: '#planning_indicator'
//         },
//         method: 'POST',
//         success: {
//             callback: function(json) {
//                 $('#planning_whiteboard_columns_form_row').append(json.component);
//                 Pachno.Project.Planning.Whiteboard.setSortOrder();
//             }
//         }
//     });
// };
//
// Pachno.Project.Planning.Whiteboard.toggleEditMode = function() {
//     $('#project_planning').toggleClass('edit-mode');
//     var $onboarding = $('#onboarding-no-board-columns');
//     if ($onboarding) {
//         $onboarding.hide();
//     }
//     Pachno.Main.Profile.clearPopupsAndButtons();
// };
//
// Pachno.Project.Planning.Whiteboard.saveColumns = function() {
//     var url = $('#planning_whiteboard_columns_form').action;
//
//     $('#planning_indicator').show();
//     Pachno.Helpers.fetch(url, {
//         method: 'POST',
//         form: 'planning_whiteboard_columns_form',
//         failure: {
//             hide: 'planning_indicator'
//         }
//     });
// };
//
// Pachno.Project.Planning.Whiteboard.calculateColumnCounts = function() {
//     $('##whiteboard-content .td').each(function (column, index) {
//         var counts = 0;
//         var status_counts = [];
//         column.find('.status-badge').each(function (status) {
//             status_counts[parseInt(status.dataset.statusId)] = 0;
//         });
//         $('##whiteboard .tbody .tr').each(function (row) {
//             row.children().each(function (subcolumn, subindex) {
//                 if (subindex == index) {
//                     var issues = subcolumn.find('.whiteboard-issue');
//                     issues.each(function (issue) {
//                         status_counts[parseInt(issue.dataset.statusId)]++;
//                     });
//                     counts += issues.length;
//                 }
//             });
//         });
//         if (column.down('.column_count.primary')) column.down('.column_count.primary').html(counts);
//         if (column.down('.column_count .count')) column.down('.column_count .count').html(counts);
//         column.find('.status-badge').each(function (status) {
//             status.html(status_counts[parseInt(status.dataset.statusId)]);
//         });
//         if ($('#project_planning').hasClass('type-kanban')) {
//             var min_wi = parseInt(column.dataset.minWorkitems);
//             var max_wi = parseInt(column.dataset.maxWorkitems);
//             if (min_wi !== 0 && counts < min_wi) {
//                 column.down('.under_count').html(counts);
//                 column.removeClass('over-workitems');
//                 column.addClass('under-workitems');
//                 $('##whiteboard .tbody .tr').each(function (row) {
//                     row.children().each(function (subcolumn, subindex) {
//                         if (!subcolumn.hasClass('swimlane-header') && subindex == index) {
//                             subcolumn.removeClass('over-workitems');
//                             subcolumn.addClass('under-workitems');
//                         }
//                     });
//                 });
//             }
//             if (max_wi !== 0 && counts > max_wi) {
//                 column.down('.over_count').html(counts);
//                 column.removeClass('under-workitems');
//                 column.addClass('over-workitems');
//                 $('##whiteboard .tbody .tr').each(function (row) {
//                     row.children().each(function (subcolumn, subindex) {
//                         if (!subcolumn.hasClass('swimlane-header') && subindex == index) {
//                             subcolumn.removeClass('under-workitems');
//                             subcolumn.addClass('over-workitems');
//                         }
//                     });
//                 });
//             }
//         }
//     });
// }
//
// Pachno.Project.Planning.Whiteboard.calculateSwimlaneCounts = function(new_issue_retrieved) {
//     var new_issue_retrieved = new_issue_retrieved || false;
//
//     $('##whiteboard .tbody').each(function (swimlane) {
//         swimlane_rows = swimlane.find('.tr');
//
//         if (swimlane_rows.length != 2) return;
//
//         swimlane_rows[0].down('.swimlane_count').html(swimlane_rows[1].find('.whiteboard-issue').length);
//
//         if (swimlane_rows[1].find('.whiteboard-issue').length == 0) {
//             swimlane.addClass('collapsed');
//         }
//         else if (new_issue_retrieved && swimlane_rows[1].find('.whiteboard-issue').length > 0) {
//             swimlane.removeClass('collapsed');
//         }
//     });
// }
//
// Pachno.Project.Planning.Whiteboard.retrieveWhiteboard = function() {
//     var wb = $('#whiteboard');
//     if (!wb) {
//         $('#whiteboard_indicator').hide();
//         return;
//     }
//
//     wb.removeClass('initialized');
//     var mi = $('#selected_milestone_input');
//     var milestone_id = (mi.dataset.selectedValue) ? parseInt(mi.dataset.selectedValue) : 0;
//
//     Pachno.Helpers.fetch(wb.dataset.whiteboardUrl, {
//         additional_params: '&milestone_id=' + milestone_id,
//         method: 'GET',
//         loading: {
//             indicator: '#whiteboard_indicator',
//             callback: function() {
//                 $('#whiteboard').find('.thead .column_count.primary').each(function (cc) {
//                     cc.html('-');
//                 });
//                 wb.data('milestone-id', milestone_id);
//             }
//         },
//         success: {
//             callback: function(json) {
//                 if (json.swimlanes) {
//                     wb.removeClass('no-swimlanes');
//                     wb.addClass('swimlanes');
//                 }
//                 else {
//                     wb.removeClass('swimlanes');
//                     wb.addClass('no-swimlanes');
//                 }
//                 wb.addClass('initialized');
//                 wb.find('.tbody').each(Element.remove);
//                 $('#whiteboard-content').append(json.component);
//                 setTimeout(function () {
//                     Pachno.Project.Planning.Whiteboard.calculateColumnCounts();
//                     Pachno.Project.Planning.Whiteboard.calculateSwimlaneCounts();
//                     Pachno.Project.Planning.Whiteboard.initializeDragDrop();
//                 }, 250);
//             }
//         }
//     });
// };
//
// Pachno.Project.Planning.Whiteboard.retrieveMilestoneStatus = function(event, item) {
//     var mi = $('#selected_milestone_input');
//     var milestone_id = (event) ? $(item).dataset.inputValue : mi.dataset.selectedValue;
//     var board_id = (event) ? $(item).dataset.boardValue : mi.dataset.selectedBoardValue;
//     Pachno.Helpers.fetch(mi.dataset.statusUrl, {
//         additional_params: '&milestone_id=' + parseInt(milestone_id) + '&board_id=' + parseInt(board_id),
//         method: 'GET',
//         loading: {
//             hide: 'selected_milestone_status_details',
//             indicator: '#selected_milestone_status_indicator'
//         },
//         success: {
//             update: '#selected_milestone_status_details',
//             show: 'selected_milestone_status_details',
//             callback: function () {
//                 $('#reportissue_button').data('milestone-id', milestone_id);
//             }
//         }
//     });
// };
//
// Pachno.Project.Planning.Whiteboard.setSortOrder = function() {
//     $('#planning_whiteboard_columns_form_row').children().each(function(column, index) {
//         column.down('input.sortorder').value(index + 1);
//     });
// };
//
// Pachno.Project.Planning.Whiteboard.updateIssueColumn = function(event, issue, column, startCoordinates) {
//     Pachno.Project.Planning.Whiteboard.moveIssueColumn(issue, column, undefined, undefined, undefined, startCoordinates);
// };
//
// Pachno.Project.Planning.Whiteboard.moveIssueColumn = function(issue, column, transition_id, original_column, issue_index, startCoordinates) {
//     if (! original_column) var original_column = issue.parents('.column');
//     if (! issue_index) var issue_index = issue.index();
//
//     if (issue) {
//         issue.detach().css({left: '0', top: '0', transform: 'inherit'}).prependTo(column);
//     }
//
//     var wb = $('#whiteboard');
//     var parameters = '&issue_id=' + parseInt(issue.data('issue-id')) + '&column_id=' + parseInt(column.data('column-id')) + '&milestone_id=' + parseInt($('#selected_milestone_input').data('selected-value')) + '&swimlane_identifier=' + issue.parents('.tbody').data('swimlane-identifier');
//     var revertIssuePosition = function () {
//         TweenMax.to(issue, .3, startCoordinates);
//
//         if (issue_index <= 0) {
//             issue.prependTo(original_column);
//         }
//         else {
//             issue.insertAfter(original_column.children().eq(issue_index - 1));
//         }
//     };
//     var customEscapeWatcher = function (event) {
//         if (event.keyCode != undefined && event.keyCode != 0 && Event.KEY_ESC != event.keyCode) return;
//         Pachno.Helpers.Backdrop.reset(revertIssuePosition);
//         if ($('#workflow_transition_fullpage')) $('#workflow_transition_fullpage').hide();
//         setTimeout(function() {
//             document.stopObserving('keydown', customEscapeWatcher);
//             $(document).on('keydown', Pachno.Core._escapeWatcher);
//         }, 350);
//     };
//
//     if (transition_id) parameters += '&transition_id=' + transition_id;
//
//     Pachno.Helpers.fetch($('#whiteboard').dataset.whiteboardUrl, {
//         additional_params: parameters,
//         method: 'POST',
//         loading: {
//             indicator: '#fullpage_backdrop',
//             show: 'fullpage_backdrop_indicator',
//             hide: ['fullpage_backdrop_content', 'dialog_backdrop']
//         },
//         success: {
//             callback: function(json) {
//                 if (json.transition_id && json.component) {
//                     document.stopObserving('keydown', Pachno.Core._escapeWatcher);
//                     $(document).on('keydown', customEscapeWatcher);
//                     $('#fullpage_backdrop').show();
//                     $('#fullpage_backdrop_content').html(json.component);
//                     $('#fullpage_backdrop_content').show();
//                     $('#fullpage_backdrop_indicator').fade({duration: 0.2});
//                     Pachno.Issues.showWorkflowTransition(json.transition_id);
//                     $('#transition_working_' + json.transition_id + '_cancel').on('click', function (event) {
//                         Event.stop(event);
//                         customEscapeWatcher(event);
//                     });
//                     $('#transition_working_' + json.transition_id + '_submit').on('click', function (event) {
//                         Event.stop(event);
//                         Pachno.Issues.submitWorkflowTransition($('#workflow_transition_' + json.transition_id + '_form'), function () {
//                             Pachno.Core.Pollers.Callbacks.whiteboardPlanningPoller();
//                         });
//                     });
//                 } else if (json.component) {
//                     document.stopObserving('keydown', Pachno.Core._escapeWatcher);
//                     $(document).on('keydown', customEscapeWatcher);
//                     $('#fullpage_backdrop').show();
//                     $('#fullpage_backdrop_content').html(json.component);
//                     $('#fullpage_backdrop_content').show();
//                     $('#fullpage_backdrop_indicator').fade({duration: 0.2});
//                     $('#transition-selector-close-link').on('click', customEscapeWatcher);
//                     $('.transition-selector-button').each(function (elem) {
//                         elem.observe('click', function (event) {
//                             Pachno.Project.Planning.Whiteboard.moveIssueColumn($('#whiteboard_issue_' + elem.data('issue-id')), $('#swimlane_' + elem.dataset.swimlaneIdentifier + '_column_' + elem.data('column-id')), elem.dataset.transitionId, original_column, issue_index, startCoordinates);
//                         });
//                     });
//                 } else {
//                     $('#fullpage_backdrop_content').html('');
//                     $('#fullpage_backdrop').fade({duration: 0.2});
//                     if (!issue) {
//                         $(json.issue).prependTo(column);
//                     }
//                     Pachno.Core.Pollers.Callbacks.whiteboardPlanningPoller();
//                 }
//             }
//         },
//         failure: {
//             show: issue,
//             callback: function(json) {
//                 if (json.error != undefined && typeof(json.error) == 'string' && json.error.length) {
//                     revertIssuePosition();
//                 }
//             }
//         }
//     });
//
// };
//
// Pachno.Project.Planning.Whiteboard.resetAvailableDropColumns = function(event) {
//     $('.column.drop-valid').each(function (index) {
//         $(this).removeClass('drop-valid');
//         $(this).removeClass('drop-hover');
//     });
// };
//
// Pachno.Project.Planning.Whiteboard.detectAvailableDropColumns = function(event, issue) {
//     var issue = $(issue);
//     var issue_statuses = issue.dataset.validStatusIds.split(',');
//     issue.parents('.row').children().each(function (column) {
//         var column_statuses = column.dataset.statusIds.split(',');
//         var has_status = false;
//         issue_statuses.each(function (status) {
//             if (column_statuses.indexOf(status) != -1) {
//                 has_status = true;
//             }
//         });
//
//         if (!has_status) {
//             $(column).removeClass('gs-droppable');
//         } else {
//             column.addClass('drop-valid');
//             column.addClass('gs-droppable');
//         }
//     });
// };
//
// Pachno.Project.Planning.Whiteboard.initializeDragDrop = function () {
//     if ($('.whiteboard-issue').length > 0) {
//         var overlapThreshold = '30%';
//         var droppablesSelector = '.gs-droppable';
//         GSDraggable.create($('.whiteboard-issue'), {
//             type: 'x',
//             bounds: $('#whiteboard'),
//             onPress: function() {
//                 this.startX = this.x;
//                 this.startY = this.y;
//             },
//             onDragStart: function(ev) {
//                 $(this.target).addClass('gs-draggable');
//                 Pachno.Project.Planning.Whiteboard.detectAvailableDropColumns(ev, this.target);
//             },
//             onDrag: function(ev) {
//                 var droppables = $(droppablesSelector);
//                 var i = droppables.length;
//                 while (--i > -1) {
//                     if (this.hitTest(droppables[i], overlapThreshold)) {
//                         $(droppables[i]).addClass('drop-hover');
//                     } else {
//                         $(droppables[i]).removeClass('drop-hover');
//                     }
//                 }
//             },
//             onDragEnd:function(ev) {
//                 $(this.target).removeClass('gs-draggable');
//                 var droppables = $(droppablesSelector);
//                 var i = droppables.length;
//                 var column_found = false;
//                 while (--i > -1) {
//                     if (this.hitTest(droppables[i], overlapThreshold)) {
//                         Pachno.Project.Planning.Whiteboard.updateIssueColumn(ev, $(this.target), $(droppables[i]), {x: this.startX, y: this.startY});
//                         column_found = true;
//                     }
//                 }
//                 if (! column_found) TweenMax.to(this.target, .3, {x: this.startX, y: this.startY});
//                 Pachno.Project.Planning.Whiteboard.resetAvailableDropColumns(ev);
//             },
//             zIndexBoost: false
//         });
//         var highZIndex = 1010;
//         $('#whiteboard .whiteboard-issue').each(function () {
//             $(this).css('z-index', highZIndex--);
//         });
//     }
//
//     if (!Pachno.Core.Pollers.planningpoller)
//         Pachno.Core.Pollers.planningpoller = new PeriodicalExecuter(Pachno.Core.Pollers.Callbacks.whiteboardPlanningPoller, 6);
// };
//
// Pachno.Project.Planning.Whiteboard.retrieveIssue = function (issue_id, url, existing_element) {
//     var milestone_id = $('#whiteboard').data('milestone-id');
//     var swimlane_type = $('#whiteboard').dataset.swimlaneType;
//     var column_id = ($(existing_element) != null && $(existing_element).data('column-id') != undefined) ? $(existing_element).data('column-id') : '';
//
//     if ($(existing_element) != null) {
//         if ($(existing_element).hasClass('tbody')) {
//             var swimlane_identifier = $(existing_element).dataset.swimlaneIdentifier;
//         }
//         else {
//             var swimlane_identifier = $(existing_element).parents('.tbody').dataset.swimlaneIdentifier;
//         }
//     }
//     else {
//         var swimlane_identifier = $('#whiteboard').down('.tbody').dataset.swimlaneIdentifier;
//     }
//
//     Pachno.Helpers.fetch(url, {
//         params: 'issue_id=' + issue_id + '&milestone_id=' + milestone_id + '&swimlane_type=' + swimlane_type + '&column_id=' + column_id + '&swimlane_identifier=' + swimlane_identifier,
//         method: 'GET',
//         loading: {indicator: (!$(existing_element)) ? 'retrieve_indicator' : 'issue_' + issue_id + '_indicator'},
//         success: {
//             callback: function (json) {
//                 if (swimlane_type != json.swimlane_type) {
//                     Pachno.Project.Planning.Whiteboard.retrieveMilestoneStatus();
//                     Pachno.Project.Planning.Whiteboard.retrieveWhiteboard();
//                     return;
//                 }
//                 if (json.deleted == '1') {
//                     if ($(existing_element)) $(existing_element).remove();
//                 }
//                 else if (!$(existing_element)) {
//                     if (json.issue_details.milestone && json.issue_details.milestone.id == milestone_id && json.component != '') {
//                         if ($('#whiteboard').hasClass('initialized')) {
//                             if ($('#swimlane_'+json.swimlane_identifier+'_column_'+json.column_id)) {
//                                 $('#swimlane_'+json.swimlane_identifier+'_column_'+json.column_id).prepend(json.component);
//                             } else {
//                                 if (json.child_issue == '0') {
//                                     $('#whiteboard-content').append(json.component);
//                                 }
//                             }
//                             Pachno.Project.Planning.Whiteboard.initializeDragDrop();
//                             Pachno.Project.Planning.Whiteboard.calculateColumnCounts();
//                             Pachno.Project.Planning.Whiteboard.calculateSwimlaneCounts(true);
//                             Pachno.Project.Planning.Whiteboard.retrieveMilestoneStatus();
//                         }
//                     }
//                 } else {
//                     var json_milestone_id = (json.issue_details.milestone && json.issue_details.milestone.id != undefined) ? parseInt(json.issue_details.milestone.id) : 0;
//                     if (json_milestone_id == 0 || json.component == '') {
//                         $(existing_element).remove();
//                         Pachno.Project.Planning.Whiteboard.calculateColumnCounts();
//                         Pachno.Project.Planning.Whiteboard.calculateSwimlaneCounts();
//                         Pachno.Project.Planning.Whiteboard.retrieveMilestoneStatus();
//                     } else if (json_milestone_id != milestone_id || json.swimlane_identifier != swimlane_identifier || json.column_id != column_id) {
//                         $(existing_element).remove();
//                         if ($('#whiteboard').hasClass('initialized')) {
//                             if ($('#swimlane_'+json.swimlane_identifier+'_column_'+json.column_id)) {
//                                 $('#swimlane_'+json.swimlane_identifier+'_column_'+json.column_id).prepend(json.component);
//                             } else {
//                                 if (json.child_issue == '0') {
//                                     $('#whiteboard-content').append(json.component);
//                                 }
//                             }
//                             Pachno.Project.Planning.Whiteboard.initializeDragDrop();
//                         }
//                         Pachno.Project.Planning.Whiteboard.calculateColumnCounts();
//                         Pachno.Project.Planning.Whiteboard.calculateSwimlaneCounts();
//                         Pachno.Project.Planning.Whiteboard.retrieveMilestoneStatus();
//                     } else {
//                         $(existing_element).replace(json.component);
//                         Pachno.Project.Planning.Whiteboard.initializeDragDrop();
//                         Pachno.Project.Planning.Whiteboard.calculateColumnCounts();
//                         Pachno.Project.Planning.Whiteboard.calculateSwimlaneCounts();
//                         Pachno.Project.Planning.Whiteboard.retrieveMilestoneStatus();
//                     }
//                 }
//             }
//         }
//     });
// };
//
// Pachno.Core.Pollers.Callbacks.whiteboardPlanningPoller = function () {
//     if (!Pachno.Core.Pollers.Locks.planningpoller && $('#whiteboard').hasClass('initialized')) {
//         Pachno.Core.Pollers.Locks.planningpoller = true;
//         var pc = $('#project_planning');
//         var wb = $('#whiteboard');
//         var data_url = pc.dataset.pollUrl;
//         var retrieve_url = pc.dataset.retrieveIssueUrl;
//         var last_refreshed = pc.dataset.lastRefreshed;
//         Pachno.Helpers.fetch(data_url, {
//             method: 'GET',
//             params: 'last_refreshed=' + last_refreshed + '&milestone_id=' + wb.data('milestone-id'),
//             success: {
//                 callback: function (json) {
//                     if (parseInt(json.milestone_id) == parseInt(wb.data('milestone-id'))) {
//                         for (var i in json.ids) {
//                             if (json.ids.hasOwnProperty(i)) {
//                                 var issue_details = json.ids[i];
//                                 var issue_element = $('#whiteboard_issue_' + issue_details.issue_id);
//                                 if (!issue_element || parseInt(issue_element.dataset.lastUpdated) < parseInt(issue_details.last_updated)) {
//                                     Pachno.Project.Planning.Whiteboard.retrieveIssue(issue_details.issue_id, retrieve_url, 'whiteboard_issue_' + issue_details.issue_id);
//                                 }
//                             }
//                         }
//                         for (var i in json.backlog_ids) {
//                             if (json.backlog_ids.hasOwnProperty(i)) {
//                                 var issue_details = json.backlog_ids[i];
//                                 var issue_element = $('#whiteboard_issue_' + issue_details.issue_id);
//                                 if (!issue_element || parseInt(issue_element.dataset.lastUpdated) < parseInt(issue_details.last_updated)) {
//                                     Pachno.Project.Planning.Whiteboard.retrieveIssue(issue_details.issue_id, retrieve_url, 'whiteboard_issue_' + issue_details.issue_id);
//                                 }
//                             }
//                         }
//                     }
//
//                     pc.dataset.lastRefreshed = get_current_timestamp();
//                     wb.dataset.whiteboardUrl = json.whiteboard_url;
//                     Pachno.Core.Pollers.Locks.planningpoller = false;
//                 }
//             },
//             exception: {
//                 callback: function () {
//                     Pachno.Core.Pollers.Locks.planningpoller = false;
//                 }
//             }
//         });
//     }
// };
//
// Pachno.Project.Planning.Whiteboard.checkNav = function() {
//     if (window.location.hash) {
//         if (parseInt($('#selected_milestone_input').dataset.selectedValue) != parseInt(window.location.hash)) {
//             var hasharray = window.location.hash.substr(1).split('/');
//             var milestone_id = parseInt(hasharray[0]);
//             $('#selected_milestone_input').children().each(function(milestone_li) {
//                 if (parseInt(milestone_li.dataset.inputValue) == milestone_id) {
//                     Pachno.Main.setFancyDropdownValue(milestone_li);
//                     setTimeout(function () {
//                         Pachno.Project.Planning.Whiteboard.retrieveMilestoneStatus();
//                         Pachno.Project.Planning.Whiteboard.retrieveWhiteboard();
//                     }, 150);
//                 }
//             });
//         }
//     }
// }
//
// Pachno.Project.Planning.Whiteboard.initialize = function (options) {
//     $('body').on('click', '#selected_milestone_input li', Pachno.Project.Planning.Whiteboard.retrieveMilestoneStatus);
//     $(window).on('hashchange', Pachno.Project.Planning.Whiteboard.checkNav);
//     Pachno.Project.Planning._initializeFilterSearch(true);
//     if (window.location.hash) {
//         Pachno.Project.Planning.Whiteboard.checkNav();
//     } else {
//         Pachno.Project.Planning.Whiteboard.retrieveMilestoneStatus();
//         Pachno.Project.Planning.Whiteboard.retrieveWhiteboard();
//     }
//
//     $('#planning_whiteboard_columns_form_row').sortable({
//         handle: '.draggable',
//         axis: 'x',
//         update: Pachno.Project.Planning.Whiteboard.setSortOrder
//     });
//
//     $('#planning_indicator').hide();
//     $('#planning_filter_title_input').prop('disabled', false);
// };
//
// Pachno.Project.Planning._initializeFilterSearch = function(whiteboard) {
//     Pachno.ift_observers = {};
//     var pfti = $('#planning_filter_title_input');
//     pfti.data('previous-value', '');
//     var fk = 'pfti';
//     if (whiteboard == undefined) whiteboard = false;
//     pfti.on('keyup', function (event, element) {
//         if (Pachno.ift_observers[fk])
//             clearTimeout(Pachno.ift_observers[fk]);
//         if ((pfti.val().length >= 3 || pfti.val().length == 0) && pfti.val() != pfti.data('last-value')) {
//             Pachno.ift_observers[fk] = setTimeout(function () {
//                 Pachno.Project.Planning.filterTitles(pfti.val(), whiteboard);
//                 pfti.data('last-value', pfti.val());
//             }, 500);
//         }
//     });
// };
//
// Pachno.Project.Planning.toggleMilestoneIssues = function(milestone_id) {
//     var mi_issues = $('#milestone_'+milestone_id+'_issues');
//     var mi = $('#milestone_'+milestone_id);
//     mi.down('.toggle-issues').toggleClass('button-pressed');
//     if (!mi.hasClass('initialized')) {
//         mi.down('.toggle-issues').prop('disabled', true);
//         mi_issues.removeClass('collapsed');
//         Pachno.Project.Planning.getMilestoneIssues(mi);
//     } else {
//         $('#milestone_'+milestone_id+'_issues').toggleClass('collapsed');
//     }
// };
//
// Pachno.Project.Planning.toggleMilestoneSorting = function() {
//     if ($('#project_planning').hasClass('milestone-sort')) {
//         $('#project_planning').removeClass('milestone-sort left_toggled');
//         $('#milestones-list').sortable("destroy");
//         $('.milestone-issues.ui-sortable').sortable('enable');
//     } else {
//         $('#project_planning').addClass('milestone-sort left_toggled');
//
//         $('.milestone-issues.ui-sortable').sortable('disable');
//
//         $('#milestones-list').sortable({
//             update: Pachno.Project.Planning.sortMilestones,
//             axis: 'y',
//             items: '> .milestone-box',
//             helper: 'original',
//             tolerance: 'intersect'
//         });
//     }
// };
//
// Pachno.Project.Planning.initialize = function (options) {
//     Pachno.Project.Planning.options = options;
//
//     $('.milestone-box.unavailable').each(Pachno.Project.Planning.initializeMilestoneDragDropSorting);
//     var milestone_boxes = $('.milestone-box.available');
//     Pachno.Project.Planning.options.milestone_count = milestone_boxes.length + 1;
//     milestone_boxes.each(Pachno.Project.Planning.getMilestoneIssues);
//
//     Pachno.Project.Planning._initializeFilterSearch();
//
//     if ($('#epics-list')) {
//         Pachno.Helpers.fetch($('#epics-list').dataset.epicsUrl, {
//             method: 'GET',
//             success: {
//                 update: '#epics-list',
//                 callback: function (json) {
//                     var completed_milestones = $('.milestone-box.available.initialized');
//                     var multiplier = 100 / Pachno.Project.Planning.options.milestone_count;
//                     var pct = Math.floor((completed_milestones.length + 1) * multiplier);
//                     $('#planning_percentage_filler').css({width: pct + '%'});
//
//                     $('#epics_toggler_button').prop('disabled', false);
//                     Pachno.Project.Planning.initializeEpicDroptargets();
//                     $('body').on('click', '.epic', function (e) {
//                         Pachno.Project.Planning.toggleEpicFilter(this);
//                     });
//                 }
//             }
//         });
//     }
//
//     if ($('#builds-list')) {
//         Pachno.Helpers.fetch($('#builds-list').dataset.releasesUrl, {
//             method: 'GET',
//             success: {
//                 update: '#builds-list',
//                 callback: function (json) {
//                     Pachno.Project.Planning.initializeReleaseDroptargets();
//                     $('body').on('click', '.release', function (e) {
//                         Pachno.Project.Planning.toggleReleaseFilter(this);
//                     });
//                 }
//             }
//         });
//     }
// };
//
// Pachno.Project.Planning.filterTitles = function (title, whiteboard) {
//     $('#planning_indicator').show();
//     if (title !== '') {
//         var matching = new RegExp(title, "i");
//         $('#project_planning').addClass('issue_title_filtered');
//         $(whiteboard ? '.whiteboard-issue' : '.milestone-issue').each(function (issue) {
//             if (whiteboard) {
//                 if (issue.down('.issue_header').innerHTML.search(matching) !== -1) {
//                     issue.addClass('title_unfiltered');
//                 } else {
//                     issue.removeClass('title_unfiltered');
//                 }
//             }
//             else {
//                 if (issue.down('.issue_link').down('a').innerHTML.search(matching) !== -1) {
//                     issue.addClass('title_unfiltered');
//                 } else {
//                     issue.removeClass('title_unfiltered');
//                 }
//             }
//         });
//     } else {
//         $('#project_planning').removeClass('issue_title_filtered');
//         $(whiteboard ? '.whiteboard-issue' : '.milestone-issue').each(function (issue) {
//             issue.removeClass('title_unfiltered');
//         });
//     }
//     $('#planning_indicator').hide();
// };
//
// Pachno.Project.Planning.insertIntoMilestone = function (milestone_id, content, recalculate) {
//     var milestone_list = $('#milestone_' + milestone_id + '_issues');
//     var $milestone_list_container = milestone_list.parents('.milestone-issues-container');
//     $milestone_list_container.removeClass('empty');
//     $('#milestone_' + milestone_id + '_unassigned').hide();
//     if (milestone_id == 0) {
//         milestone_list.append(content);
//     } else {
//         milestone_list.prepend(content);
//     }
//     if (recalculate == 'all') {
//         Pachno.Project.Planning.calculateAllMilestonesVisibilityDetails();
//     } else {
//         Pachno.Project.Planning.calculateMilestoneIssueVisibilityDetails(milestone_list);
//     }
//     Pachno.Project.Planning.calculateNewBacklogMilestoneDetails();
//     if (milestone_id != 0) {
//         setTimeout(Pachno.Project.Planning.sortMilestoneIssues({target: 'milestone_' + milestone_id + '_issues'}), 250);
//     }
// };
//
// Pachno.Project.Planning.retrieveIssue = function (issue_id, url, existing_element) {
//     Pachno.Helpers.fetch(url, {
//         params: 'issue_id=' + issue_id,
//         method: 'GET',
//         loading: {indicator: (!$(existing_element)) ? 'retrieve_indicator' : 'issue_' + issue_id + '_indicator'},
//         success: {
//             callback: function (json) {
//                 if (json.deleted == '1') {
//                     if ($(existing_element)) $(existing_element).parents('.milestone-issue').remove();
//                 }
//                 else if (json.epic) {
//                     if (!$(existing_element)) {
//                         $('#add_epic_container').prepend(json.component);
//                         setTimeout(Pachno.Project.Planning.initializeEpicDroptargets, 250);
//                     } else {
//                         $(existing_element).parents('.milestone-issue').replace(json.component);
//                     }
//                 } else {
//                     if (!$(existing_element)) {
//                         if (json.issue_details.milestone && json.issue_details.milestone.id) {
//                             if ($('#milestone_'+json.issue_details.milestone.id).hasClass('initialized')) {
//                                 Pachno.Project.Planning.insertIntoMilestone(json.issue_details.milestone.id, json.component);
//                             }
//                         } else {
//                             Pachno.Project.Planning.insertIntoMilestone(0, json.component);
//                         }
//                     } else {
//                         var json_milestone_id = (json.issue_details.milestone && json.issue_details.milestone.id != undefined) ? parseInt(json.issue_details.milestone.id) : 0;
//                         if (parseInt($(existing_element).parents('.milestone-box').data('milestone-id')) == json_milestone_id) {
//                             $(existing_element).parents('.milestone-issue').replace(json.component);
//                             Pachno.Project.Planning.calculateMilestoneIssueVisibilityDetails($('#milestone_' + json_milestone_id + '_issues'));
//                             Pachno.Project.Planning.calculateNewBacklogMilestoneDetails();
//                         } else {
//                             $(existing_element).parents('.milestone-issue').remove();
//                             Pachno.Project.Planning.insertIntoMilestone(json_milestone_id, json.component, 'all');
//                         }
//                     }
//                 }
//                 if (json.issue_details.milestone && json.issue_details.milestone.id && json.milestone_percent_complete != null) {
//                     $('#milestone_' + json.issue_details.milestone.id + '_percentage_filler').css({width: json.milestone_percent_complete + '%'});
//                 }
//                 Pachno.Project.Planning.filterTitles($('#planning_filter_title_input').val());
//             }
//         }
//     });
// };
//
// Pachno.Core.Pollers.Callbacks.planningPoller = function () {
//     var pc = $('#project_planning');
//     if (!Pachno.Core.Pollers.Locks.planningpoller && pc) {
//         Pachno.Core.Pollers.Locks.planningpoller = true;
//         var data_url = pc.dataset.pollUrl;
//         var retrieve_url = pc.dataset.retrieveIssueUrl;
//         var last_refreshed = pc.dataset.lastRefreshed;
//         Pachno.Helpers.fetch(data_url, {
//             method: 'GET',
//             params: 'last_refreshed=' + last_refreshed,
//             success: {
//                 callback: function (json) {
//                     pc.dataset.lastRefreshed = get_current_timestamp();
//                     for (var i in json.ids) {
//                         if (json.ids.hasOwnProperty(i)) {
//                             var issue_details = json.ids[i];
//                             var issue_element = $('#issue_' + issue_details.issue_id);
//                             if (!issue_element || parseInt(issue_element.dataset.lastUpdated) < parseInt(issue_details.last_updated)) {
//                                 Pachno.Project.Planning.retrieveIssue(issue_details.issue_id, retrieve_url, 'issue_' + issue_details.issue_id);
//                             }
//                         }
//                     }
//                     for (var i in json.backlog_ids) {
//                         if (json.backlog_ids.hasOwnProperty(i)) {
//                             var issue_details = json.backlog_ids[i];
//                             var issue_element = $('#issue_' + issue_details.issue_id);
//                             if (!issue_element || parseInt(issue_element.dataset.lastUpdated) < parseInt(issue_details.last_updated)) {
//                                 Pachno.Project.Planning.retrieveIssue(issue_details.issue_id, retrieve_url, 'issue_' + issue_details.issue_id);
//                             }
//                         }
//                     }
//                     for (var i in json.epic_ids) {
//                         if (json.epic_ids.hasOwnProperty(i)) {
//                             var issue_details = json.epic_ids[i];
//                             var issue_element = $('#epic_' + issue_details.issue_id);
//                             if (!issue_element || parseInt(issue_element.dataset.lastUpdated) < parseInt(issue_details.last_updated)) {
//                                 Pachno.Project.Planning.retrieveIssue(issue_details.issue_id, retrieve_url, 'epic_' + issue_details.issue_id);
//                             }
//                         }
//                     }
//                     Pachno.Core.Pollers.Locks.planningpoller = false;
//                 }
//             },
//             exception: {
//                 callback: function () {
//                     Pachno.Core.Pollers.Locks.planningpoller = false;
//                 }
//             }
//         });
//     }
// };
//
// Pachno.Project.Planning.calculateMilestoneIssueVisibilityDetails = function (list) {
//     var list_issues = $(list).find('.issue-container').not('.child_issue');
//     var closed_issues = $(list).find('.issue-container.issue_closed').not('.child_issue');
//     var visible_issues = list_issues.filter(':visible');
//     var sum_estimated_points = 0;
//     var sum_estimated_hours = 0;
//     var sum_estimated_minutes = 0;
//     var sum_spent_points = 0;
//     var sum_spent_hours = 0;
//     var sum_spent_minutes = 0;
//     visible_issues.each(function (index) {
//         var elm = $(this);
//         if (!elm.hasClass('child_issue')) {
//             if (elm.dataset.estimatedPoints !== undefined)
//                 sum_estimated_points += parseInt(elm.dataset.estimatedPoints);
//             if (elm.dataset.estimatedHours !== undefined)
//                 sum_estimated_hours += parseInt(elm.dataset.estimatedHours);
//             if (elm.dataset.estimatedMinutes !== undefined)
//                 sum_estimated_minutes += parseInt(elm.dataset.estimatedMinutes);
//             if (elm.dataset.spentPoints !== undefined)
//                 sum_spent_points += parseInt(elm.dataset.spentPoints);
//             if (elm.dataset.spentHours !== undefined)
//                 sum_spent_hours += parseInt(elm.dataset.spentHours);
//             if (elm.dataset.spentMinutes !== undefined)
//                 sum_spent_minutes += parseInt(elm.dataset.spentMinutes);
//         }
//     });
//     var num_visible_issues = visible_issues.length;
//     var milestone_id = $(list).parents('.milestone-box').data('milestone-id');
//
//     if (num_visible_issues === 0) {
//         if (list_issues.length > 0) {
//             $('#milestone_' + milestone_id + '_unassigned').hide();
//             $('#milestone_' + milestone_id + '_unassigned_filtered').show();
//         } else {
//             $('#milestone_' + milestone_id + '_unassigned').show();
//             $('#milestone_' + milestone_id + '_unassigned_filtered').hide();
//         }
//         $(list).parents('.milestone-issues-container').addClass('empty');
//     } else {
//         $('#milestone_' + milestone_id + '_unassigned').hide();
//         $('#milestone_' + milestone_id + '_unassigned_filtered').hide();
//         $(list).parents('.milestone-issues-container').removeClass('empty');
//     }
//     if (num_visible_issues !== list_issues.length && milestone_id != '0') {
//         $('#milestone_' + milestone_id + '_issues_count').html(num_visible_issues + ' (' + list_issues.length + ')');
//     } else {
//         $('#milestone_' + milestone_id + '_issues_count').html(num_visible_issues);
//     }
//     sum_spent_hours += Math.floor(sum_spent_minutes / 60);
//     sum_estimated_hours += Math.floor(sum_estimated_minutes / 60);
//     sum_spent_minutes = sum_spent_minutes % 60;
//     sum_estimated_minutes = sum_estimated_minutes % 60;
//     $('#milestone_' + milestone_id + '_points_count').html(sum_spent_points + ' / ' + sum_estimated_points);
//     if (sum_spent_minutes != 0) {
//         sum_spent_hours += ':' + ((sum_spent_minutes.toString().length == 1) ? '0' : '') + sum_spent_minutes;
//     }
//     if (sum_estimated_minutes != 0) {
//         sum_estimated_hours += ':' + ((sum_estimated_minutes.toString().length == 1) ? '0' : '') + sum_estimated_minutes;
//     }
//     $('#milestone_' + milestone_id + '_hours_count').html(sum_spent_hours + ' / ' + sum_estimated_hours);
// };
//
// Pachno.Project.Planning.calculateAllMilestonesVisibilityDetails = function () {
//     $('.milestone-box.initialized').find('.milestone-issues').each(function (index) {
//         var was_collapsed = $(this).hasClass('collapsed');
//         $(this).removeClass('collapsed');
//         Pachno.Project.Planning.calculateMilestoneIssueVisibilityDetails(this);
//         if (was_collapsed && parseInt($(this).parents('.milestone-box').data('milestone-id')) !== 0) $(this).addClass('collapsed');
//     });
// };
//
// Pachno.Project.Planning.calculateNewBacklogMilestoneDetails = function (event, ui) {
//     if (event === undefined || $(ui.item).hasClass('new_milestone_marker')) {
//         var nbmm = (event === undefined) ? $('#new_backlog_milestone_marker') : $(ui.placeholder[0]);
//         var num_issues = 0;
//         var sum_points = 0;
//         var sum_hours = 0;
//         var sum_minutes = 0;
//         var include_closed = $('#milestones-list').hasClass('show_closed');
//         $('.milestone-issue').removeClass('included');
//         nbmm.parents('.milestone-issues').children().each(function (elm) {
//             elm.addClass('included');
//             if (!(elm.hasClass('new_milestone_marker') && !elm.hasClass('ui-sortable-helper')) && !elm.hasClass('ui-element-placeholder')) {
//                 if (!elm.hasClass('new_milestone_marker')) {
//                     if (include_closed || !elm.hasClass('issue_closed'))
//                         num_issues++;
//                     if (!elm.hasClass('child_issue')) {
//                         if (elm.down('.issue-container').dataset.estimatedPoints !== undefined)
//                             sum_points += parseInt(elm.down('.issue-container').dataset.estimatedPoints);
//                         if (elm.down('.issue-container').dataset.estimatedHours !== undefined)
//                             sum_hours += parseInt(elm.down('.issue-container').dataset.estimatedHours);
//                         if (elm.down('.issue-container').dataset.estimatedMinutes !== undefined)
//                             sum_minutes += parseInt(elm.down('.issue-container').dataset.estimatedMinutes);
//                     }
//                 }
//             } else {
//                 throw $break;
//             }
//         });
//         sum_hours += Math.floor(sum_minutes / 60);
//         sum_minutes = sum_minutes % 60;
//         $('#new_backlog_milestone_issues_count').html(num_issues);
//         $('#new_backlog_milestone_points_count').html(sum_points);
//         if (sum_minutes != 0) {
//             sum_hours += ':' + ((sum_minutes.toString().length == 1) ? '0' : '') + sum_minutes;
//         }
//         $('#new_backlog_milestone_hours_count').html(sum_hours);
//     }
// };
//
// Pachno.Project.Planning.sortMilestones = function (event, ui) {
//     var list = $(event.target);
//     var url = list.data('sort-url');
//     var items = '';
//     list.children().each(function (milestone, index) {
//         if (milestone.data('milestone-id') !== undefined) {
//             items += '&milestone_ids['+index+']=' + milestone.data('milestone-id');
//         }
//     });
//     Pachno.Helpers.fetch(url, {
//         method: 'POST',
//         additional_params: items,
//         loading: {indicator: '#planning_indicator'}
//     });
// };
//
// Pachno.Project.Planning.doSortMilestoneIssues = function (list) {
//     var url = list.parents('.milestone-box').data('issues-url');
//     var items = '';
//     list.children().each(function (issue) {
//         if (issue.data('issue-id') !== undefined) {
//             items += '&issue_ids[]=' + issue.data('issue-id');
//         }
//     });
//     Pachno.Helpers.fetch(url, {
//         method: 'POST',
//         additional_params: items,
//         loading: {indicator: list.parents('.milestone-box').down('.planning_indicator')}
//     });
// };
//
// Pachno.Project.Planning.sortMilestoneIssues = function (event, ui) {
//     var list = $(event.target);
//     var issue = $(ui.item[0]);
//     if (issue.dataset.sortCancel) {
//         issue.dataset.sortCancel = null;
//         $(this).sortable("cancel");
//     } else {
//         if (ui !== undefined && ui.item.hasClass('new_milestone_marker')) {
//             Pachno.Project.Planning.calculateNewBacklogMilestoneDetails();
//         } else {
//             Pachno.Project.Planning.doSortMilestoneIssues(list);
//         }
//     }
// };
//
// Pachno.Project.Planning.moveIssue = function (event, ui) {
//     var issue = $(ui.item[0]);
//     if (issue.dataset.sortCancel) {
//         issue.dataset.sortCancel = null;
//         $(this).sortable("cancel");
//     } else {
//         if (issue.hasClass('milestone-issue')) {
//             var list = $(event.target);
//             var url = list.parents('.milestone-box').data('assign-issue-url');
//             var original_list = $(ui.sender[0]);
//             Pachno.Helpers.fetch(url, {
//                 additional_params: 'issue_id=' + issue.data('issue-id'),
//                 loading: {indicator: list.parents('.milestone-box').down('.planning_indicator')},
//                 complete: {
//                     callback: function (json) {
//                         if (list.parents('.milestone-box').hasClass('initialized')) {
//                             issue.down('.issue-container').dataset.lastUpdated = get_current_timestamp();
//                             Pachno.Project.Planning.doSortMilestoneIssues(list);
//                             Pachno.Core.Pollers.Callbacks.planningPoller();
//                             Pachno.Project.Planning.calculateMilestoneIssueVisibilityDetails(list);
//                             Pachno.Project.Planning.calculateMilestoneIssueVisibilityDetails(original_list);
//                         } else {
//                             issue.remove();
//                             var milestone_id = list.parents('.milestone-box').data('milestone-id');
//                             $('#milestone_' + milestone_id + '_issues_count').html(json.issues);
//                             $('#milestone_' + milestone_id + '_points_count').html(json.points);
//                             $('#milestone_' + milestone_id + '_hours_count').html(json.hours);
//                         }
//                     }
//                 }
//             });
//         }
//     }
// };
//
// Pachno.Project.Planning.toggleSwimlaneDetails = function (selected_item) {
//     $('#agileboard-swimlane-details-container').children().each(Element.hide);
//     $('#agileboard_swimlane_' + $(selected_item).val() + '_container').show();
// };
//
// Pachno.Project.Planning.toggleSwimlaneExpediteDetails = function(selected_item) {
//     $('#agileboard_swimlane_expedite_container_details').children().each(Element.hide);
//     $('#swimlane_expedite_identifier_' + $(selected_item).val() + '_values').show();
// };
//
// Pachno.Project.Planning.removeAgileBoard = function (url) {
//     Pachno.Helpers.fetch(url, {
//         method: 'delete',
//         loading: {
//             indicator: '#dialog_indicator',
//             callback: function () {
//                 ['dialog_yes', 'dialog_no'].each(function (elm) {
//                     elm.addClass('disabled');
//                 });
//             }
//         },
//         success: {
//             callback: function (json) {
//                 $('#agileboard_' + json.board_id).remove();
//                 Pachno.Helpers.Dialog.dismiss();
//                 if ($('#agileboards').children().length == 0) {
//                     $('#onboarding-no-boards').show();
//                 }
//             }
//         }
//     });
// };
//
// Pachno.Project.Planning.saveAgileBoard = function (item) {
//     var url = item.action;
//     Pachno.Helpers.fetch(url, {
//         form: 'edit-agileboard-form',
//         success: {
//             callback: function (json) {
//                 if ($('#agileboards')) {
//                     if ($('#agileboard_' + json.id)) {
//                         $('#agileboard_' + json.id).replace(json.component);
//                     } else {
//                         $('#onboarding-no-boards').hide();
//                         var container = $('#agileboards');
//                         container.append(json.component);
//                     }
//                     clearFormSubmit($(item));
//                     Pachno.Helpers.Backdrop.reset();
//                 } else if ($('#project_planning') && parseInt($('#project_planning').dataset.boardId) == parseInt(json.id) && $('#project_planning').hasClass('whiteboard')) {
//                     Pachno.Helpers.Backdrop.reset();
//                     Pachno.Project.Planning.Whiteboard.retrieveMilestoneStatus();
//                     Pachno.Project.Planning.Whiteboard.retrieveWhiteboard();
//                 } else if ($('#project_planning') && parseInt($('#project_planning').dataset.boardId) == parseInt(json.id)) {
//                     var backlog = $('#milestone_0');
//                     Pachno.Helpers.Backdrop.reset();
//                     if (backlog.dataset.backlogSearch != json.backlog_search) {
//                         $('#planning_indicator').show();
//                         window.location.reload(true);
//                     } else {
//                         backlog.removeClass('initialized');
//                         $('#milestone_0_issues').html('');
//                         $('#milestone_0_issues').removeClass('ui-sortable');
//                         backlog.down('.planning_indicator').show();
//                         Pachno.Project.Planning.initialize(Pachno.Project.Planning.options);
//                     }
//                 }
//             }
//         }
//     });
// };
//
// Pachno.Main.updateFancyDropdownLabel = function ($dropdown) {
//     var $label = $dropdown.find('> .value');
//     if ($label.length > 0) {
//         var auto_close = false;
//         var values = [];
//         $dropdown.find('input[type=checkbox],input[type=radio]').each(function () {
//             var $input = $(this);
//
//             if ($input.attr('type') == 'radio') {
//                 auto_close = true;
//             }
//
//             if ($input.is(':checked')) {
//                 var $label = $($input.next('label')),
//                     $value = $($label.find('.value')[0]);
//
//                 if ($value.text() != '') {
//                     values.push($value.text());
//                 }
//             }
//         });
//
//         if (values.length > 0) {
//             $dropdown.removeClass('no-value');
//             $label.html(values.join(', '));
//         } else {
//             $dropdown.addClass('no-value');
//             $label.html($dropdown.data('default-label'));
//         }
//
//         if (auto_close) {
//             $dropdown.removeClass('active');
//         }
//     }
// };
//
// Pachno.Project.Milestone.markFinished = function (form) {
//     var url = form.action;
//     var milestone_id = form.data('milestone-id');
//     Pachno.Helpers.fetch(url, {
//         form: form,
//         loading: {
//             indicator: '#milestone_edit_indicator',
//             callback: function () {
//                 $('#mark_milestone_finished_form').find('input.button').each(Element.disable);
//             }
//         },
//         success: {
//             remove: 'milestone_' + milestone_id,
//             callback: function (json) {
//                 Pachno.Helpers.Backdrop.reset();
//                 if (json.component) {
//                     $('#milestones-list').append(json.component);
//                     setTimeout(function () {
//                         Pachno.Project.Planning.getMilestoneIssues($('#milestone_' + json.new_milestone_id), Pachno.Project.Planning.initializeDragDropSorting);
//                     }, 250);
//                 } else {
//                     Pachno.Core.Pollers.Callbacks.planningPoller();
//                 }
//             }
//         },
//         failure: {
//             callback: function () {
//                 $('#mark_milestone_finished_form').find('input.button').each(Element.enable);
//             }
//         }
//     });
// };
//
// Pachno.Project.Milestone.save = function (form, on_board) {
//     var submit_button = $(form).find('.form-row.submit-container button[type=submit]');
//
//     if (submit_button.length) {
//         submit_button.prop('disabled', true);
//         submit_button.addClass('submitting');
//     }
//
//     var url = form.action;
//     var include_selected_issues = $('#include_selected_issues').val() == 1;
//
//     var data = new FormData(form);
//     if (include_selected_issues) {
//         $('.milestone-issue.included').each(function (issue) {
//             data.append( "issues[]", issue.data('issue-id'));
//         });
//     }
//
//     return new Promise(function (resolve, reject) {
//         fetch(url, {
//                 method: 'POST',
//                 body: data
//             })
//             .then((_) => _.json())
//             .then(function (json) {
//                 if ($('#no_milestones')) {
//                     $('#no_milestones').hide();
//                 }
//
//                 $('.milestone-issue.included').each(function (issue) { issue.remove(); });
//                 Pachno.Helpers.Backdrop.reset();
//                 if ($('#milestones-list').length) {
//                     $('#milestones-list').append(json.component);
//                 }
//
//                 if (on_board) {
//                     if (!include_selected_issues) {
//                         setTimeout(function () {
//                             Pachno.Project.Planning.getMilestoneIssues($('#milestone_' + json.milestone_id));
//                         }, 250);
//                     } else {
//                         Pachno.Project.Planning.calculateMilestoneIssueVisibilityDetails($('#milestone_0_issues'));
//                         // Pachno.Project.Planning.initializeDragDropSorting();
//                     }
//                 }
//             });
//     });
//     // Pachno.Helpers.fetch(url, {
//     //     form: form,
//     //     additional_params: issues,
//     //     loading: {indicator: '#milestone_edit_indicator'},
//     //     success: {
//     //         reset: 'edit_milestone_form',
//     //         hide: 'no_milestones',
//     //         callback: function (json) {
//     //             $('.milestone-issue.included').each(function (issue) { issue.remove(); });
//     //             Pachno.Helpers.Backdrop.reset();
//     //             if ($('#milestone_' + json.milestone_id)) {
//     //                 $('#milestone_' + json.milestone_id).replace(json.component);
//     //             } else {
//     //                 $('#milestones-list').append(json.component);
//     //             }
//     //             if (on_board) {
//     //                 if (!include_selected_issues) {
//     //                     setTimeout(function () {
//     //                         Pachno.Project.Planning.getMilestoneIssues($('#milestone_' + json.milestone_id), Pachno.Project.Planning.initializeDragDropSorting);
//     //                     }, 250);
//     //                 } else {
//     //                     Pachno.Project.Planning.calculateMilestoneIssueVisibilityDetails($('#milestone_0_issues'));
//     //                     Pachno.Project.Planning.initializeDragDropSorting();
//     //                 }
//     //             }
//     //             Pachno.Project.Milestone.selectFromHash();
//     //         }
//     //     }
//     // });
// }
//
// Pachno.Project.Milestone.remove = function (url, milestone_id) {
//     Pachno.Helpers.fetch(url, {
//         method: 'delete',
//         loading: {
//             indicator: '#dialog_indicator',
//         },
//         success: {
//             callback: function (json) {
//                 $('#milestone_' + milestone_id).remove();
//                 Pachno.Helpers.Dialog.dismiss();
//                 Pachno.Helpers.Backdrop.reset();
//                 if ($('#milestones-list').children().length == 0)
//                     $('#no_milestones').show();
//                 Pachno.Core.Pollers.Callbacks.planningPoller();
//             }
//         }
//     });
// }
//
// Pachno.Project.Build.remove = function (url, bid, b_type, edition_id) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             show: 'fullpage_backdrop_indicator',
//             indicator: '#fullpage_backdrop',
//             hide: ['fullpage_backdrop_content', 'dialog_backdrop', 'build_' + bid + '_info'],
//             callback: function () {
//                 $('#build_' + bid + '_indicator').addClass('selected_red');
//             }
//         },
//         success: {
//             remove: ['show_build_' + bid],
//             callback: function () {
//                 Pachno.Helpers.Dialog.dismiss();
//                 if ($(b_type + '_builds_' + edition_id).children().length == 0) {
//                     $('#no_' + b_type + '_builds_' + edition_id).show();
//                 }
//             }
//         },
//         failure: {
//             show: 'build_' + bid + '_info',
//             hide: 'del_build_' + bid,
//             callback: function () {
//                 $('#build_' + bid + '_indicator').removeClass('selected_red');
//             }
//         }
//     });
// };
//
// Pachno.Project.Build.add = function (url, edition_id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'add_build_form',
//         loading: {indicator: '#build_add_indicator'},
//         success: {
//             reset: 'add_build_form',
//             hide: 'no_builds_' + edition_id,
//             update: {element: 'builds_' + edition_id, insertion: true, from: 'html'}
//         }
//     });
// };
//
// Pachno.Project.Component.remove = function (url, id) {
//     fetch(url, { method: 'DELETE' })
//         .then(function (response) {
//             response.json().then(function (json) {
//                 Pachno.Helpers.Dialog.dismiss();
//                 if (response.ok) {
//                     $('#[data-component][data-id=' + id + ']').remove();
//                 } else {
//                     Pachno.Helpers.Message.error(json.error);
//                 }
//             })
//                 .catch(function (error) {
//                     Pachno.Helpers.Dialog.dismiss();
//                     Pachno.Helpers.Message.error(error);
//                 });
//         });
// }
//
// Pachno.Project.Edition.remove = function (url, id) {
//     fetch(url, { method: 'DELETE' })
//         .then(function (response) {
//             response.json().then(function (json) {
//                 Pachno.Helpers.Dialog.dismiss();
//                 if (response.ok) {
//                     $('#[data-edition][data-id=' + id + ']').remove();
//                     $('#project-editions-list-container').removeClass('active');
//                     $('#selected-edition-options').html('');
//                 } else {
//                     Pachno.Helpers.Message.error(json.error);
//                 }
//             })
//                 .catch(function (error) {
//                     Pachno.Helpers.Dialog.dismiss();
//                     Pachno.Helpers.Message.error(error);
//                 });
//         });
// }
//
// Pachno.Project.findDevelopers = function (url) {
//     Pachno.Helpers.fetch(url, {
//         form: 'find_dev_form',
//         loading: {indicator: '#find_dev_indicator'},
//         success: {
//             update: '#find_dev_results',
//             callback: function () {
//                 let $form = $('#find_dev_form');
//                 $form.removeClass('submitting');
//                 $form.find('button[type=submit]').each(function () {
//                     var $button = $(this);
//                     $button.removeClass('auto-disabled');
//                     $button.prop('disabled', false);
//                 })
//             }
//         }
//     });
// }
//
// Pachno.Project._updateUserFromJSON = function (object, field) {
//     if (object.id == 0) {
//         $(field + '_name').hide();
//         $('#no_' + field).show();
//     } else {
//         $(field + '_name').html(object.name);
//         $('#no_' + field).hide();
//         $(field + '_name').show();
//     }
// }
//
// Pachno.Project.setUser = function (url, field) {
//     Pachno.Helpers.fetch(url, {
//         loading: {indicator: field + '_spinning'},
//         success: {
//             hide: field + '_change',
//             callback: function (json) {
//                 Pachno.Project._updateUserFromJSON(json.field, field);
//             }
//         }
//     });
// }
//
// Pachno.Project.assign = function (url, container_id) {
//     var role_id = $(container_id).down('select').val();
//     var parameters = "&role_id=" + role_id;
//     Pachno.Helpers.fetch(url, {
//         params: parameters,
//         loading: {indicator: '#assign_dev_indicator'},
//         success: {update: '#assignees_list'}
//     });
// }
//
// Pachno.Project.removeAssignee = function (url, type, id) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#remove_assignee_' + type + '_' + id + '_indicator',
//             hide: 'assignee_' + type + '_' + id + '_link'
//         },
//         success: {
//             remove: 'assignee_' + type + '_' + id + '_row',
//             callback: function () {
//                 if ($('#project_team_' + type + 's').children().length == 0) {
//                     $('#project_team_' + type + 's').hide();
//                     $('#no_project_team_' + type + 's').show();
//                 }
//             }
//         }
//     });
// }
//
// Pachno.Project.workflow = function (url) {
//     Pachno.Helpers.fetch(url, {
//         form: 'workflow_form2',
//         loading: {indicator: '#update_workflow_indicator'},
//         success: {callback: function () {
//             Pachno.Helpers.Backdrop.reset();
//         }}
//     });
// };
//
// Pachno.Project.workflowtable = function (url) {
//     Pachno.Helpers.fetch(url, {
//         form: 'workflow_form',
//         loading: {
//             indicator: '#change_workflow_indicator'
//         },
//         success: {
//             update: '#change_workflow_table',
//             hide: 'change_workflow_box',
//             show: 'change_workflow_table'
//         }
//     });
// };
//
// Pachno.Project.updatePrefix = function (url, project_id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'project_info',
//         success: {
//             update: '#project_key_input',
//             callback: function () {
//                 clearFormSubmit($('#project_info'));
//             }
//         }
//     });
// };
//
// Pachno.Project.clearReleaseCenterFilters = function () {
//     var prcc = $('#project_release_center_container');
//     ['only_archived', 'only_active', 'only_downloads'].each(function (cn) {
//         prcc.removeClass(cn);
//     });
// };
//
// Pachno.Project.checkAndToggleNoBuildsMessage = function () {
//     $('.simple-list').each(function (elem) {
//         // If this list does not contain builds continue.
//         if (elem.id.indexOf('active_builds_') !== 0) return;
//
//         // We assume no build is visible.
//         var one_build_visible = false;
//
//         $(elem).children().each(function (elem) {
//             // If this child - build is not visible continue.
//             if (! $('#' + elem.id).is(':visible')) return;
//
//             // Once we find visible build set flag and break this loop.
//             one_build_visible = true;
//             return false;
//         });
//
//         // Hide or show no builds message based on one build visible flag.
//         if (one_build_visible) {
//             $('#no_' + elem.id).hide();
//         }
//         else {
//             $('#no_' + elem.id).show();
//         }
//     });
// };
//
// Pachno.Project.clearRoadmapFilters = function () {
//     var prp = $('#project_roadmap_page');
//     ['upcoming', 'past'].each(function (cn) {
//         prp.removeClass(cn);
//     });
//
//     var hash = window.location.hash;
//
//     if (hash != undefined && hash.indexOf('roadmap_milestone_') == 1) {
//         window.location.hash = '';
//     }
// };
//
// Pachno.Project.showRoadmap = function () {
//     $('#milestone_details_overview').hide();
//     $('#project_roadmap').show();
//     $('#planning_board_settings_gear').show();
// }
//
// Pachno.Project.showMilestoneDetails = function (url, milestone_id, force) {
//     $('body')[0].css({'overflow': 'auto'});
//
//     var force = force || false;
//
//     if (force && $('#milestone_details_' + milestone_id)) {
//         $('#milestone_details_' + milestone_id).remove();
//     }
//
//     $('#project_planning_action_strip .more_actions_dropdown, #planning_board_settings_gear').hide();
//
//     if (!$('#milestone_details_' + milestone_id)) {
//         window.location.hash = 'roadmap_milestone_' + milestone_id;
//
//         Pachno.Helpers.fetch(url, {
//             method: 'GET',
//             loading: {
//                 indicator: '#fullpage_backdrop',
//                 show: 'fullpage_backdrop_indicator',
//                 hide: ['fullpage_backdrop_content', 'project_roadmap']
//             },
//             success: {
//                 show: 'milestone_details_overview',
//                 update: '#milestone_details_overview'
//             }
//         });
//     } else {
//         $('#project_roadmap').hide();
//         $('#milestone_details_overview').show();
//     }
// }
//
// Pachno.Project.toggleLeftSelection = function (item) {
//     $(item).parents('.list-mode').children().each(function (elm) {
//         elm.removeClass('selected');
//     });
//     $(item).addClass('selected');
// };
//
// Pachno.Config.Import.importCSV = function (url) {
//     Pachno.Helpers.fetch(url, {
//         form: 'import_csv_form',
//         loading: {
//             indicator: '#csv_import_indicator',
//             hide: 'csv_import_error'
//         },
//         failure: {
//             show: 'csv_import_error',
//             callback: function (json) {
//                 $('#csv_import_error_detail').html(json.errordetail);
//             }
//         }
//     });
// }
//
// Pachno.Config.Import.getImportCsvIds = function (url) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#id_zone_indicator',
//             hide: 'id_zone_content'
//         },
//         success: {
//             update: '#id_zone_content',
//             show: 'id_zone_content'
//         }
//     });
// }
//
// Pachno.Config.updateCheck = function (url) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#update_spinner',
//             hide: 'update_button'
//         },
//         success: {
//             callback: function (json) {
//                 (json.uptodate) ?
//                     Pachno.Helpers.Message.success(json.title, json.message) :
//                     Pachno.Helpers.Message.error(json.title, json.message);
//             }
//         },
//         complete: {
//             show: 'update_button'
//         }
//     });
// }
//
// Pachno.Config.Issuetype.remove = function (url, id) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#fullpage_backdrop',
//             show: 'fullpage_backdrop_indicator',
//             hide: ['fullpage_backdrop_content', 'dialog_backdrop']
//         },
//         success: {
//             remove: 'issuetype_' + id + '_box',
//             callback: Pachno.Helpers.Dialog.dismiss
//         }
//     });
// }
//
// Pachno.Config.IssuetypeScheme.save = function (form) {
//     const $form = $(form),
//         data = new FormData($form[0]);
//
//     $form.find('.error-container').removeClass('invalid');
//     $form.find('.error-container > .error').html('');
//     $form.addClass('submitting');
//
//     fetch($form.attr('action'), {
//         method: 'POST',
//         body: data
//     })
//         .then(function (response) {
//             response.json().then(function (json) {
//                 if (!response.ok) {
//                     $form.find('.error-container > .error').html(json.error);
//                     $form.find('.error-container').addClass('invalid');
//                 }
//                 $form.removeClass('submitting');
//             });
//         });
// };
//
// Pachno.Config.IssuetypeScheme.addField = function (url, key) {
//     const $container = $('#issue-type-fields-list'),
//         $add_list = $('#add-issue-field-list');
//
//     fetch(url, {
//         method: 'GET'
//     })
//         .then(function (response) {
//             response.json().then(function (json) {
//                 if (response.ok) {
//                     $container.append(json.content);
//                     $('.list-item[data-issue-field][data-id=' + key + ']').addClass('disabled');
//                 } else {
//                     Pachno.Helpers.Message.error(json.error);
//                 }
//             });
//         });
// };
//
// Pachno.Config.IssuetypeScheme.saveOptions = function (form) {
//     const $container = $('#issue-type-configuration-container'),
//         $form = $(form),
//         data = new FormData($form[0]),
//         $options = $('#selected-issue-type-options');
//
//     $form.find('.error-container').removeClass('invalid');
//     $form.find('.error-container > .error').html('');
//     $form.addClass('submitting');
//     $form.find('.button.primary').prop('disabled', true);
//
//     fetch($form.attr('action'), {
//         method: 'POST',
//         body: data
//     })
//         .then(function (response) {
//             response.json().then(function (json) {
//                 if (response.ok) {
//                     $container.removeClass('active');
//                     $container.find('.issue-type-scheme-issue-type').removeClass('active');
//                     $options.html('');
//                 } else {
//                     $form.find('.error-container > .error').html(json.error);
//                     $form.find('.error-container').addClass('invalid');
//                 }
//             });
//         });
// };
//
// Pachno.Config.IssuetypeScheme.copy = function (url, scheme_id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'copy_issuetype_scheme_' + scheme_id + '_form',
//         loading: {
//             indicator: '#copy_issuetype_scheme_' + scheme_id + '_indicator'
//         },
//         success: {
//             hide: 'copy_scheme_' + scheme_id + '_popup',
//             update: {element: 'issuetype_schemes_list', insertion: true}
//         }
//     });
// }
//
// Pachno.Config.IssuetypeScheme.remove = function (url, scheme_id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'delete_issuetype_scheme_' + scheme_id + '_form',
//         loading: {
//             indicator: '#delete_issuetype_scheme_' + scheme_id + '_indicator'
//         },
//         success: {
//             remove: ['delete_scheme_' + scheme_id + '_popup', 'copy_scheme_' + scheme_id + '_popup', 'issuetype_scheme_' + scheme_id],
//             update: {element: 'issuetype_schemes_list', insertion: true},
//             callback: function () {
//                 Pachno.Helpers.Dialog.dismiss();
//             }
//         }
//     });
// }
//
// Pachno.Config.Issuefields.saveOrder = function (container, type, url) {
//     Pachno.Helpers.fetch(url, {
//         additional_params: Sortable.serialize(container),
//         loading: {
//             indicator: type + '_sort_indicator'
//         }
//     });
// };
//
// Pachno.Config.Issuefields.Options.save = function (form) {
//     var $form = $(form),
//         data = new FormData($form[0]);
//
//     if ($form.hasClass('submitting')) return;
//
//     $form.find('.error-container').removeClass('invalid');
//     $form.find('.error-container > .error').html('');
//     $form.addClass('submitting');
//
//     fetch($form.attr('action'), {
//         method: 'POST',
//         body: data
//     })
//         .then(function (response) {
//             response.json().then(function (json) {
//                 if (response.ok) {
//                     const $issue_option_container = $('#[data-issue-field-option][data-id='+json.item.id+']');
//                     if ($issue_option_container.length > 0) {
//                         $issue_option_container.replaceWith(json.component);
//                     } else {
//                         const $issue_options_container = $('#field-options-list');
//                         if ($issue_options_container.length > 0) {
//                             $issue_options_container.append(json.component);
//                         }
//                         if (sortable_options != undefined) {
//                             Sortable.destroy('field-options-list');
//                             Sortable.create('field-options-list', sortable_options);
//                         }
//                         Pachno.Helpers.initializeColorPicker();
//                     }
//                     $form[0].reset();
//                 } else {
//                     $form.find('.error-container > .error').html(json.error);
//                     $form.find('.error-container').addClass('invalid');
//                 }
//
//                 $form.removeClass('submitting');
//                 $form.find('.button.primary').prop('disabled', false);
//             })
//                 .catch(function (error) {
//                     $form.find('.error-container > .error').html(error);
//                     $form.find('.error-container').addClass('invalid');
//
//                     $form.removeClass('submitting');
//                 });
//         });
// }
//
// Pachno.Config.Issuefields.Options.update = function (url, type, id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'edit_' + type + '_' + id + '_form',
//         loading: {indicator: '#edit_' + type + '_' + id + '_indicator'},
//         success: {
//             show: 'item_option_' + type + '_' + id + '_content',
//             hide: 'edit_item_option_' + id,
//             callback: function (json) {
//                 $(type + '_' + id + '_name').html($(type + '_' + id + '_name_input').val());
//                 if ($(type + '_' + id + '_itemdata_input') && $(type + '_' + id + '_itemdata'))
//                     $(type + '_' + id + '_itemdata').style.backgroundColor = $(type + '_' + id + '_itemdata_input').val();
//                 if ($(type + '_' + id + '_value_input') && $(type + '_' + id + '_value'))
//                     $(type + '_' + id + '_value').html($(type + '_' + id + '_value_input').val());
//             }
//         }
//     });
// }
//
// Pachno.Config.Issuefields.Options.remove = function (url, id) {
//     fetch(url, { method: 'POST' })
//         .then(function (response) {
//             response.json().then(function (json) {
//                 Pachno.Helpers.Dialog.dismiss();
//                 if (response.ok) {
//                     $('#[data-issue-field-option][data-id=' + id + ']').remove();
//                 } else {
//                     Pachno.Helpers.Message.error(json.error);
//                 }
//             })
//             .catch(function (error) {
//                 Pachno.Helpers.Dialog.dismiss();
//                 Pachno.Helpers.Message.error(error);
//             });
//         });
// }
//
// Pachno.Config.Issuefields.Custom.update = function (url, type) {
//     Pachno.Helpers.fetch(url, {
//         form: 'edit_custom_type_' + type + '_form',
//         loading: {indicator: '#edit_custom_type_' + type + '_indicator'},
//         success: {
//             hide: 'edit_custom_type_' + type + '_form',
//             callback: function (json) {
//                 $('#custom_type_' + type + '_description_span').html(json.description);
//                 $('#custom_type_' + type + '_instructions_span').html(json.instructions);
//                 if (json.instructions != '') {
//                     $('#custom_type_' + type + '_instructions_div').show();
//                     $('#custom_type_' + type + '_no_instructions_div').hide();
//                 } else {
//                     $('#custom_type_' + type + '_instructions_div').hide();
//                     $('#custom_type_' + type + '_no_instructions_div').show();
//                 }
//                 $('#custom_type_' + type + '_name').html(json.name);
//             },
//             show: 'custom_type_' + type + '_info'
//         }
//     });
// }
//
// Pachno.Config.Issuefields.Custom.remove = function (url, id) {
//     fetch(url, { method: 'POST' })
//         .then(function (response) {
//             response.json().then(function (json) {
//                 Pachno.Helpers.Dialog.dismiss();
//                 if (response.ok) {
//                     $('#[data-issue-field][data-id=' + id + ']').remove();
//                     const $container = $('#issue-fields-configuration-container'),
//                         $options = $('#selected-issue-field-options');
//
//                     $container.removeClass('active');
//                     $container.find('.issue-type-scheme-issue-type').removeClass('active');
//                     $options.html('');
//                 } else {
//                     Pachno.Helpers.Message.error(json.error);
//                 }
//             })
//                 .catch(function (error) {
//                     Pachno.Helpers.Dialog.dismiss();
//                     Pachno.Helpers.Message.error(error);
//                 });
//         });
// };
//
// Pachno.Config.Permissions.set = function (url, field) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: field + '_indicator',
//             callback: function (json) {
//                 $('##' + field + ' .image img').each(function (element) {
//                     $(element).hide();
//                 });
//             }
//         },
//         success: {update: field + '_wrapper'}
//     });
// };
//
// Pachno.Config.Permissions.getOptions = function (url, field) {
//     $(field).toggle();
//     if ($(field).children().length == 0) {
//         Pachno.Helpers.fetch(url, {
//             loading: {indicator: field + '_indicator'},
//             success: {update: field}
//         });
//     }
// }
//
// Pachno.Config.Roles.update = function (url, role_id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'role_' + role_id + '_form',
//         loading: {indicator: '#role_' + role_id + '_form_indicator'},
//         success: {
//             hide: 'role_' + role_id + '_permissions_edit',
//             callback: function (json) {
//                 $('#role_' + role_id + '_permissions_count').html(json.permissions_count);
//                 $('#role_' + role_id + '_permissions_list').html('');
//                 $('#role_' + role_id + '_permissions_list').hide();
//                 $('#role_' + role_id + '_name').html(json.role_name);
//             }
//         }
//     });
// }
//
// Pachno.Config.Roles.remove = function (url, role_id) {
//     Pachno.Helpers.fetch(url, {
//         method: 'POST',
//         loading: {
//             indicator: '#fullpage_backdrop',
//             show: 'fullpage_backdrop_indicator',
//             hide: ['fullpage_backdrop_content', 'dialog_backdrop']
//         },
//         success: {
//             callback: function () {
//                 var rc = $('#role_' + role_id + '_container');
//                 if (rc.parents('ul').children().length == 2) {
//                     rc.parents('ul').down('li.no_roles').show();
//                 }
//                 rc.remove();
//             }
//         }
//     });
// }
//
// Pachno.Config.Roles.add = function (url) {
//     Pachno.Helpers.fetch(url, {
//         form: 'new_role_form',
//         loading: {indicator: '#new_role_form_indicator'},
//         success: {
//             update: {element: 'global_roles_list', insertion: true},
//             hide: ['global_roles_no_roles'],
//             callback: function  () {
//                 $('#add_new_role_input').value('');
//             }
//         }
//     });
// };
//
// Pachno.Project.Roles.add = function (url, pid) {
//     Pachno.Helpers.fetch(url, {
//         form: 'new_project' + pid + '_role_form',
//         loading: {indicator: '#new_project' + pid + '_role_form_indicator'},
//         success: {
//             update: {element: 'project' + pid + '_roles_list', insertion: true},
//             hide: ['project' + pid + '_roles_no_roles', 'new_project' + pid + '_role']
//         }
//     });
// };
//
// Pachno.Config.User.show = function (url, findstring) {
//     Pachno.Helpers.fetch(url, {
//         params: '&findstring=' + findstring,
//         loading: {indicator: '#find_users_indicator'},
//         success: {update: '#users_results'}
//     });
// };
//
// Pachno.Config.User.add = function (url, callback_function_for_import, form) {
//     f = (form !== undefined) ? form : 'createuser_form';
//     Pachno.Helpers.fetch(url, {
//         form: f,
//         loading: {
//             indicator: '#createuser_form_indicator'
//         },
//         success: {
//             hide: ['createuser_form_indicator', 'createuser_form_quick_indicator'],
//             update: '#users_results',
//             callback: function (json) {
//                 $('#adduser_div').hide();
//                 Pachno.Config.User._updateLinks(json);
//                 $(f).reset();
//             }
//         },
//         failure: {
//             hide: ['createuser_form_indicator', 'createuser_form_quick_indicator'],
//             callback: function (json) {
//                 if (json.allow_import || false) {
//                     callback_function_for_import();
//                 }
//             }
//         }
//     });
// };
//
// Pachno.Config.User.addToScope = function (url) {
//     Pachno.Helpers.fetch(url, {
//         form: 'createuser_form',
//         loading: {indicator: '#dialog_indicator'},
//         success: {
//             update: '#users_results',
//             callback: function (json) {
//                 Pachno.Helpers.Dialog.dismiss();
//                 Pachno.Config.User._updateLinks(json);
//             }
//         }
//     });
// };
//
// Pachno.Config.User.remove = function (url, user_id) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#fullpage_backdrop',
//             show: 'fullpage_backdrop_indicator',
//             hide: ['fullpage_backdrop_content', 'dialog_backdrop']
//         },
//         success: {
//             remove: ['users_results_user_' + user_id, 'user_' + user_id + '_edit_spinning', 'user_' + user_id + '_edit_tr', 'users_results_user_' + user_id + '_permissions_row'],
//             callback: Pachno.Config.User._updateLinks
//         }
//     });
// };
//
// Pachno.Config.User._updateLinks = function (json) {
//     if (json == null) return;
//     if ($('#current_user_num_count'))
//         $('#current_user_num_count').html(json.total_count);
//     (json.more_available) ? $('#adduser_form_container').show() : $('#adduser_form_container').hide();
//     Pachno.Config.Collection.updateDetailsFromJSON(json);
// };
//
// Pachno.Config.User.update = function (url, user_id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'edit_user_' + user_id + '_form',
//         loading: {indicator: '#edit_user_' + user_id + '_indicator'},
//         success: {
//             update: '#users_results_user_' + user_id,
//             show: 'users_results_user_' + user_id,
//             hide: 'user_' + user_id + '_edit_tr',
//             callback: function (json) {
//                 $('#password_' + user_id + '_leave').checked = true;
//                 $('#new_password_' + user_id + '_1').val('');
//                 $('#new_password_' + user_id + '_2').val('');
//                 Pachno.Config.Collection.updateDetailsFromJSON(json);
//             }
//         }
//     });
// };
//
// Pachno.Config.User.updateScopes = function (url, user_id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'edit_user_' + user_id + '_scopes_form',
//         loading: {indicator: '#edit_user_' + user_id + '_scopes_form_indicator'},
//         success: {
//             callback: Pachno.Helpers.Backdrop.reset
//         }
//     });
// };
//
// Pachno.Config.User.getPermissionsBlock = function (url, user_id) {
//     $('#users_results_user_' + user_id + '_permissions_row').toggle();
//     if ($('#users_results_user_' + user_id + '_permissions').innerHTML == '') {
//         Pachno.Helpers.fetch(url, {
//             loading: {
//                 indicator: '#permissions_' + user_id + '_indicator'
//             },
//             success: {
//                 update: '#users_results_user_' + user_id + '_permissions',
//                 show: 'users_results_user_' + user_id + '_permissions'
//             }
//         });
//     }
// };
//
// Pachno.Config.Collection.add = function (url, type, callback_function) {
//     Pachno.Helpers.fetch(url, {
//         form: 'create_' + type + '_form',
//         loading: {indicator: '#create_' + type + '_indicator'},
//         success: {
//             update: {element: type + 'config_list', insertion: true},
//             callback: callback_function
//         }
//     });
// };
//
// Pachno.Config.Collection.remove = function (url, type, cid, callback_function) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#fullpage_backdrop',
//             show: 'fullpage_backdrop_indicator',
//             hide: ['fullpage_backdrop_content', 'dialog_backdrop']
//         },
//         success: {
//             remove: type + 'box_' + cid,
//             callback: function (json) {
//                 if (callback_function)
//                     callback_function(json);
//             }
//         }
//     });
// };
//
// Pachno.Config.Collection.clone = function (url, type, cid, callback_function) {
//     Pachno.Helpers.fetch(url, {
//         form: 'clone_' + type + '_' + cid + '_form',
//         loading: {indicator: '#clone_' + type + '_' + cid + '_indicator'},
//         success: {
//             update: {element: type + 'config_list', insertion: true},
//             hide: 'clone_' + type + '_' + cid,
//             callback: callback_function
//         }
//     });
// };
//
// Pachno.Config.Collection.showMembers = function (url, type, cid) {
//     $(type + '_members_' + cid + '_container').toggle();
//     if ($(type + '_members_' + cid + '_list').innerHTML == '') {
//         Pachno.Helpers.fetch(url, {
//             loading: {indicator: type + '_members_' + cid + '_indicator'},
//             success: {update: type + '_members_' + cid + '_list'},
//             failure: {hide: type + '_members_' + cid + '_container'}
//         });
//     }
// };
//
// Pachno.Config.Collection.removeMember = function (url, type, cid, user_id) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: type + '_members_' + cid + '_indicator',
//             hide: 'dialog_backdrop'
//         },
//         success: {
//             callback: function (json) {
//                 $(type + '_' + cid + '_' + user_id + '_item').remove();
//                 Pachno.Config.Collection.updateDetailsFromJSON(json, false);
//                 var ul = $(type + '_members_' + cid + '_list').down('ul');
//                 if (ul != undefined && ul.children().length == 0)
//                     $(type + '_members_' + cid + '_no_users').show();
//             }
//         }
//     });
// };
//
// Pachno.Config.Collection.addMember = function (url, type, cid, user_id) {
//     Pachno.Helpers.fetch(url, {
//         loading: {indicator: type + '_members_' + cid + '_indicator'},
//         success: {
//             callback: function (json) {
//                 Pachno.Config.Collection.updateDetailsFromJSON(json, false);
//                 var ul = $(type + '_members_' + cid + '_list').down('ul');
//                 if (ul != undefined && ul.children().length == 0) {
//                     $(type + '_members_' + cid + '_no_users').hide();
//                 }
//                 $(type + '_members_' + cid + '_list').down('ul').append(json[type + 'listitem']);
//             }
//         }
//     });
// };
//
// Pachno.Config.Collection.updateDetailsFromJSON = function (json, clear) {
//     if (json.update_groups) {
//         json.update_groups.ids.each(function (group_id) {
//             if ($('#group_' + group_id + '_membercount'))
//                 $('#group_' + group_id + '_membercount').html(json.update_groups.membercounts[group_id]);
//             if (clear == undefined || clear == true) {
//                 $('#group_members_' + group_id + '_container').hide();
//                 $('#group_members_' + group_id + '_list').html('');
//             }
//         });
//     }
//     if (json.update_teams) {
//         json.update_teams.ids.each(function (team_id) {
//             if ($('#team_' + team_id + '_membercount'))
//                 $('#team_' + team_id + '_membercount').html(json.update_teams.membercounts[team_id]);
//             if (clear == undefined || clear == true) {
//                 $('#team_members_' + team_id + '_container').hide();
//                 $('#team_members_' + team_id + '_list').html('');
//             }
//         });
//     }
//     if (json.update_clients) {
//         json.update_clients.ids.each(function (client_id) {
//             if ($('#client_' + client_id + '_membercount'))
//                 $('#client_' + client_id + '_membercount').html(json.update_clients.membercounts[client_id]);
//             if (clear == undefined || clear == true) {
//                 $('#client_members_' + client_id + '_container').hide();
//                 $('#client_members_' + client_id + '_list').html('');
//             }
//         });
//     }
// };
//
// Pachno.Config.Group.add = function (url) {
//     Pachno.Config.Collection.add(url, 'group');
// };
//
// Pachno.Config.Group.remove = function (url, group_id) {
//     Pachno.Config.Collection.remove(url, 'group', group_id);
// };
//
// Pachno.Config.Group.clone = function (url, group_id) {
//     Pachno.Config.Collection.clone(url, 'group', group_id);
// };
//
// Pachno.Config.Group.showMembers = function (url, group_id) {
//     Pachno.Config.Collection.showMembers(url, 'group', group_id);
// }
//
// Pachno.Config.Team.updateLinks = function (json) {
//     if ($('#current_team_num_count'))
//         $('#current_team_num_count').html(json.total_count);
//     $('.copy_team_link').each(function (element) {
//         (json.more_available) ? $(element).show() : $(element).hide();
//     });
//     (json.more_available) ? $('#add_team_div').show() : $('#add_team_div').hide();
// }
//
// Pachno.Config.Team.getPermissionsBlock = function (url, team_id) {
//     if ($('#team_' + team_id + '_permissions').innerHTML == '') {
//         Pachno.Helpers.fetch(url, {
//             loading: {
//                 show: 'team_' + team_id + '_permissions_container',
//                 indicator: '#team_' + team_id + '_permissions_indicator'
//             },
//             success: {
//                 update: '#team_' + team_id + '_permissions',
//             }
//         });
//     }
//     else {
//         $('#team_' + team_id + '_permissions_container').show();
//     }
// };
//
// Pachno.Config.Team.add = function (url) {
//     Pachno.Config.Collection.add(url, 'team', Pachno.Config.Team.updateLinks);
// }
//
// Pachno.Config.Team.remove = function (url, team_id) {
//     Pachno.Config.Collection.remove(url, 'team', team_id, Pachno.Config.Team.updateLinks);
// };
//
// Pachno.Config.Team.clone = function (url, team_id) {
//     Pachno.Config.Collection.clone(url, 'team', team_id, Pachno.Config.Team.updateLinks);
// }
//
// Pachno.Config.Team.showMembers = function (url, team_id) {
//     Pachno.Config.Collection.showMembers(url, 'team', team_id);
// }
//
// Pachno.Config.Team.removeMember = function (url, team_id, member_id) {
//     Pachno.Config.Collection.removeMember(url, 'team', team_id, member_id);
// }
//
// Pachno.Config.Team.addMember = function (url, team_id, member_id) {
//     Pachno.Config.Collection.addMember(url, 'team', team_id, member_id);
// }
//
// Pachno.Config.Client.add = function (url) {
//     Pachno.Config.Collection.add(url, 'client');
// }
//
// Pachno.Config.Client.remove = function (url, client_id) {
//     Pachno.Config.Collection.remove(url, 'client', client_id);
// }
//
// Pachno.Config.Client.showMembers = function (url, client_id) {
//     Pachno.Config.Collection.showMembers(url, 'client', client_id);
// }
//
// Pachno.Config.Client.removeMember = function (url, client_id, member_id) {
//     Pachno.Config.Collection.removeMember(url, 'client', client_id, member_id);
// }
//
// Pachno.Config.Client.addMember = function (url, client_id, member_id) {
//     Pachno.Config.Collection.addMember(url, 'client', client_id, member_id);
// }
//
// Pachno.Config.Client.update = function (url, client_id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'edit_client_' + client_id + '_form',
//         loading: {indicator: '#edit_client_' + client_id + '_indicator'},
//         success: {
//             hide: 'edit_client_' + client_id,
//             update: '#client_' + client_id + '_item'
//         }
//     });
// };
//
// Pachno.Config.fetchComponentUpdateHandler = function (type) {
//     return function ([$form, response]) {
//         response.json().then(function (json) {
//             if (response.ok) {
//                 const $scheme_container = $('#[data-' + type + '][data-id='+json.item.id+']');
//                 if ($scheme_container.length > 0) {
//                     $scheme_container.replaceWith(json.component);
//                 } else {
//                     const $schemes_container = $('#workflow-schemes-list');
//                     if ($schemes_container.length > 0) {
//                         $schemes_container.append(json.component);
//                     }
//                 }
//                 $form[0].reset();
//                 Pachno.Helpers.Backdrop.reset();
//             } else {
//                 $form.find('.error-container > .error').html(json.error);
//                 $form.find('.error-container').addClass('invalid');
//             }
//
//             $form.removeClass('submitting');
//             $form.find('.button.primary').prop('disabled', false);
//         })
//             .catch(function (error) {
//                 $form.find('.error-container > .error').html(error);
//                 $form.find('.error-container').addClass('invalid');
//
//                 $form.removeClass('submitting');
//                 $form.find('.button.primary').prop('disabled', false);
//             });
//     };
// };
//
// Pachno.Config.loadComponentOptions = function (options, $item) {
//     return new Promise(function (resolve, reject) {
//         const $container = $(options.container),
//             $options = $(options.options),
//             url = $item.data('options-url');
//
//         $options.html('<div><i class="fas fa-spin fa-spinner"></i></div>');
//         $container.addClass('active');
//         $container.find(options.component).removeClass('active');
//         $item.addClass('active');
//
//         fetch(url, {
//             method: 'GET'
//         })
//             .then(function (response) {
//                 response.json().then(function (json) {
//                     if (response.ok) {
//                         $options.html(json.content);
//                         Pachno.Main.updateWidgets()
//                             .then(resolve);
//                     }
//                 });
//             });
//     });
// };
//
// Pachno.Config.Workflows.Scheme.save = function (form) {
//     Pachno.Core.fetchPostHelper(form)
//         .then(Pachno.Config.fetchComponentUpdateHandler('workflow-scheme'));
// };
//
// Pachno.Config.Workflows.Scheme.remove = function (url, id) {
//     fetch(url, { method: 'POST' })
//         .then(function (response) {
//             response.json().then(function (json) {
//                 Pachno.Helpers.Dialog.dismiss();
//                 if (response.ok) {
//                     $('#[data-workflow-scheme][data-id=' + id + ']').remove();
//                 } else {
//                     Pachno.Helpers.Message.error(json.error);
//                 }
//             })
//                 .catch(function (error) {
//                     Pachno.Helpers.Dialog.dismiss();
//                     Pachno.Helpers.Message.error(error);
//                 });
//         });
// };
//
// Pachno.Config.Workflows.Workflow.save = function (form) {
//     Pachno.Core.fetchPostHelper(form)
//         .then(Pachno.Core.fetchPostDefaultFormHandler);
// };
//
// Pachno.Config.Workflows.Workflow.copy = function (url, workflow_id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'copy_workflow_' + workflow_id + '_form',
//         loading: {indicator: '#copy_workflow_' + workflow_id + '_indicator'},
//         success: {
//             hide: 'copy_workflow_' + workflow_id + '_popup',
//             update: {element: 'workflows_list', insertion: true},
//             callback: Pachno.Config.Workflows._updateLinks
//         }
//     });
// };
//
// Pachno.Config.Workflows.Workflow.remove = function (url, workflow_id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'delete_workflow_' + workflow_id + '_form',
//         loading: {indicator: '#delete_workflow_' + workflow_id + '_indicator'},
//         success: {
//             remove: ['delete_workflow_' + workflow_id + '_popup', 'copy_workflow_' + workflow_id + '_popup', 'workflow_' + workflow_id],
//             update: {element: 'workflows_list', insertion: true},
//             callback: Pachno.Config.Workflows._updateLinks
//         }
//     });
// };
//
// Pachno.Config.Workflows.Workflow.Step.show = function ($item) {
//     Pachno.Config.loadComponentOptions(
//         {
//             container: '#workflow-steps-container',
//             options: '#selected-workflow-step-options',
//             component: '.workflow-step'
//         },
//         $item
//     );
// };
//
// Pachno.Config.Workflows.Workflow.Step.save = function (form) {
//     Pachno.Core.fetchPostHelper(form)
//         .then(Pachno.Core.fetchPostDefaultFormHandler);
// };
//
// Pachno.Config.Workflows.Transition.save = function (form) {
//     Pachno.Core.fetchPostHelper(form)
//         .then(Pachno.Core.fetchPostDefaultFormHandler);
// };
//
// Pachno.Config.Workflows.Transition.remove = function (url, transition_id, direction) {
//     $('#transition_' + transition_id + '_delete_form').submit();
// };
//
// Pachno.Config.Workflows.Transition.Validations.add = function (url, mode, key) {
//     Pachno.Helpers.fetch(url, {
//         loading: {indicator: '#workflowtransition' + mode + 'validationrule_add_indicator'},
//         success: {
//             hide: ['no_workflowtransition' + mode + 'validationrules', 'add_workflowtransition' + mode + 'validationrule_' + key],
//             update: {element: 'workflowtransition' + mode + 'validationrules_list', insertion: true}
//         }
//     });
// }
//
// Pachno.Config.Workflows.Transition.Validations.update = function (url, rule_id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'workflowtransitionvalidationrule_' + rule_id + '_form',
//         loading: {indicator: '#workflowtransitionvalidationrule_' + rule_id + '_indicator'},
//         success: {
//             hide: ['workflowtransitionvalidationrule_' + rule_id + '_cancel_button', 'workflowtransitionvalidationrule_' + rule_id + '_edit'],
//             update: '#workflowtransitionvalidationrule_' + rule_id + '_value',
//             show: ['workflowtransitionvalidationrule_' + rule_id + '_edit_button', 'workflowtransitionvalidationrule_' + rule_id + '_delete_button', 'workflowtransitionvalidationrule_' + rule_id + '_description']
//         }
//     });
// }
//
// Pachno.Config.Workflows.Transition.Validations.remove = function (url, rule_id, type, mode) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#fullpage_backdrop',
//             show: 'fullpage_backdrop_indicator',
//             hide: ['fullpage_backdrop_content', 'dialog_backdrop']
//         },
//         success: {
//             remove: ['workflowtransitionvalidationrule_' + rule_id],
//             show: ['add_workflowtransition' + type + 'validationrule_' + mode],
//             callback: function () {
//                 Pachno.Helpers.Dialog.dismiss();
//             }
//         }
//     });
// }
//
// Pachno.Config.Workflows.Transition.Actions.add = function (url, key) {
//     Pachno.Helpers.fetch(url, {
//         loading: {indicator: '#workflowtransitionaction_add_indicator'},
//         success: {
//             hide: ['no_workflowtransitionactions', 'add_workflowtransitionaction_' + key],
//             update: {element: 'workflowtransitionactions_list', insertion: true}
//         }
//     });
// }
//
// Pachno.Config.Workflows.Transition.Actions.update = function (url, action_id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'workflowtransitionaction_' + action_id + '_form',
//         loading: {indicator: '#workflowtransitionaction_' + action_id + '_indicator'},
//         success: {
//             hide: ['workflowtransitionaction_' + action_id + '_cancel_button', 'workflowtransitionaction_' + action_id + '_edit'],
//             update: '#workflowtransitionaction_' + action_id + '_value',
//             show: ['workflowtransitionaction_' + action_id + '_edit_button', 'workflowtransitionaction_' + action_id + '_delete_button', 'workflowtransitionaction_' + action_id + '_description']
//         }
//     });
// }
//
// Pachno.Config.Workflows.Transition.Actions.remove = function (url, action_id, type) {
//     Pachno.Helpers.fetch(url, {
//         loading: {indicator: '#workflowtransitionaction_' + action_id + '_delete_indicator'},
//         success: {
//             hide: ['workflowtransitionaction_' + action_id + '_delete', 'workflowtransitionaction_' + action_id],
//             show: ['add_workflowtransitionaction_' + type],
//             callback: function () {
//                 Pachno.Helpers.Dialog.dismiss();
//             }
//         }
//     });
// }
//
// /**
//  * Displays the workflow transition popup dialog
//  */
// Pachno.Issues.showWorkflowTransition = function (transition_id) {
//     var existing_container = $('#workflow_transition_fullpage').down('.workflow_transition');
//     if (existing_container) {
//         existing_container.hide();
//         $('#workflow_transition_container').append(existing_container);
//     }
//     var workflow_div = $('#issue_transition_container_' + transition_id);
//     $('#workflow_transition_fullpage').append(workflow_div);
//     $('#workflow_transition_fullpage').show();
//     workflow_div.appear({duration: 0.2, afterFinish: function () {
//         if ($('#duplicate_finder_transition_' + transition_id)) {
//             $('#viewissue_find_issue_' + transition_id + '_input').on('keypress', function (event) {
//                 if (event.keyCode == Event.KEY_RETURN) {
//                     Pachno.Issues.findDuplicate($('#duplicate_finder_transition_' + transition_id).val(), transition_id);
//                     event.stop();
//                 }
//             });
//         }
//
//     }});
// };
//
// Pachno.Issues.submitWorkflowTransition = function (form, callback) {
//     Pachno.Helpers.fetch(form.action, {
//         form: form,
//         loading: {
//             indicator: '#fullpage_backdrop',
//             show: 'fullpage_backdrop_indicator',
//             hide: ['fullpage_backdrop_content', 'dialog_backdrop', 'workflow_transition_fullpage']
//         },
//         success: {
//             hide: 'workflow_transition_fullpage',
//             callback: callback
//         },
//         failure: {
//             show: 'workflow_transition_fullpage'
//         }
//     });
// };
//
// Pachno.Issues.refreshRelatedIssues = function (url) {
//     if ($('#related_child_issues_inline')) {
//         Pachno.Helpers.fetch(url, {
//             loading: {indicator: '#related_issues_indicator'},
//             success: {
//                 hide: 'no_child_issues',
//                 update: {element: 'related_child_issues_inline'},
//                 callback: function () {
//                     $('#viewissue_related_issues_count').html($('#related_child_issues_inline').children().length);
//                 }
//             }
//         });
//     }
// };
//
// Pachno.Issues.findRelated = function (url) {
//     Pachno.Helpers.fetch(url, {
//         form: 'viewissue_find_issue_form',
//         loading: {indicator: '#viewissue_find_issue_indicator'},
//         success: {update: '#viewissue_relation_results'}
//     });
//     return false;
// };
//
// Pachno.Issues.findDuplicate = function (url, transition_id) {
//     Pachno.Helpers.fetch(url, {
//         additional_params: 'searchfor=' + $('#viewissue_find_issue_' + transition_id + '_input').val(),
//         loading: {indicator: '#viewissue_find_issue_' + transition_id + '_indicator'},
//         success: {update: '#viewissue_' + transition_id + '_duplicate_results'}
//     });
// };
//
// Pachno.Issues.editTimeEntry = function (form) {
//     var url = form.action;
//     Pachno.Helpers.fetch(url, {
//         form: form,
//         loading: {
//             indicator: '#fullpage_backdrop_indicator',
//             hide: 'fullpage_backdrop_content'
//         },
//         success: {
//             callback: function (json) {
//                 $('#fullpage_backdrop_content').html(json.timeentries);
//                 $('#fullpage_backdrop_content').show();
//                 if (json.timesum == 0) {
//                     $('#no_spent_time_' + json.issue_id).show();
//                     $('#spent_time_' + json.issue_id + '_name').hide();
//                 } else {
//                     $('#no_spent_time_' + json.issue_id).hide();
//                     $('#spent_time_' + json.issue_id + '_name').show();
//                     $('#spent_time_' + json.issue_id + '_value').html(json.spenttime);
//                 }
//                 Pachno.Issues.Field.updateEstimatedPercentbar(json);
//             }
//         }
//     });
// };
//
// Pachno.Issues.deleteTimeEntry = function (url, entry_id) {
//     Pachno.Helpers.fetch(url, {
//         loading: {indicator: '#dialog_indicator'},
//         success: {
//             callback: function (json) {
//                 Pachno.Helpers.Dialog.dismiss();
//                 $('#issue_spenttime_' + entry_id).remove();
//                 if ($('#issue_spenttime_' + entry_id + '_comment'))
//                     $('#issue_spenttime_' + entry_id + '_comment').remove();
//                 if (json.timesum == 0) {
//                     $('#no_spent_time_' + json.issue_id).show();
//                     $('#spent_time_' + json.issue_id + '_name').hide();
//                 } else {
//                     $('#no_spent_time_' + json.issue_id).hide();
//                     $('#spent_time_' + json.issue_id + '_name').show();
//                     $('#spent_time_' + json.issue_id + '_value').html(json.spenttime);
//                 }
//                 Pachno.Issues.Field.updateEstimatedPercentbar(json);
//             }
//         }
//     });
// };
//
// Pachno.Issues.Field.updateEstimatedPercentbar = function (data) {
//     $('#estimated_percentbar').html(data.percentbar);
//     if ($('#no_estimated_time_' + data.issue_id).visible()) {
//         $('#estimated_percentbar').hide();
//     }
//     else {
//         $('#estimated_percentbar').show();
//     }
// };
//
// Pachno.Issues.Add = function (url, btn) {
//     var btn = btn != undefined ? $(btn) : $('#reportissue_button');
//     var additional_params_query = '';
//
//     if (btn.dataset != undefined && btn.data('milestone-id') != undefined && parseInt(btn.data('milestone-id')) > 0) {
//         additional_params_query += '/milestone_id/' + btn.data('milestone-id');
//     }
//
//     if (url.indexOf('issuetype') !== -1) {
//         Pachno.Helpers.Backdrop.show(url +  additional_params_query, function () {
//             $('#reportissue_container').addClass('huge');
//             $('#reportissue_container').removeClass('large');
//         });
//     }
//     else {
//         Pachno.Helpers.Backdrop.show(url +  additional_params_query);
//     }
// };
//
// Pachno.Issues.relate = function (url) {
//
//     Pachno.Helpers.fetch(url, {
//         form: 'viewissue_relate_issues_form',
//         loading: {indicator: '#relate_issues_indicator'},
//         success: {
//             update: {element: 'related_child_issues_inline', insertion: true},
//             hide: 'no_child_issues',
//             callback: function (json) {
//                 if ($('.milestone_details_link.selected').eq(0).find('> a:first-child').length) {
//                     $('.milestone_details_link.selected').eq(0).find('> a:first-child').trigger('click');
//                 }
//                 else {
//                     Pachno.Helpers.Backdrop.reset();
//                 }
//                 if ($('#viewissue_related_issues_count')) $('#viewissue_related_issues_count').html(json.count);
//                 if (json.count > 0 && $('#no_related_issues').visible()) $('#no_related_issues').hide();
//             }
//         }
//     });
//     return false;
// };
//
// Pachno.Issues.removeRelated = function (url, issue_id) {
//     Pachno.Helpers.fetch(url, {
//         loading: {indicator: '#related_issues_indicator'},
//         success: {
//             remove: 'related_issue_' + issue_id,
//             callback: function () {
//                 var childcount = $('#related_child_issues_inline').children().length;
//                 $('#viewissue_related_issues_count').html(childcount);
//                 if (childcount == 0) {
//                     $('#no_related_issues').show();
//                 }
//             }
//         }
//     });
// };
//
// Pachno.Issues.removeDuplicated = function (url, issue_id) {
//     Pachno.Helpers.fetch(url, {
//         loading: {indicator: '#duplicate_issues_indicator'},
//         success: {
//             remove: 'duplicated_issue_' + issue_id,
//             callback: function () {
//                 var childcount = $('#related_duplicate_issues_inline').children().length;
//                 $('#viewissue_duplicate_issues_count').html(childcount);
//                 if (childcount == 0) {
//                     $('#no_duplicated_issues').show();
//                 }
//             }
//         }
//     });
// };
//
// Pachno.Issues.move = function (form, issue_id) {
//     Pachno.Helpers.fetch(form.action, {
//         form: form,
//         loading: {
//             indicator: '#move_issue_indicator'
//         },
//         success: {
//             remove: 'issue_' + issue_id,
//             update: '#viewissue_move_issue_div'
//         }
//     });
// };
//
// Pachno.Issues._addVote = function (url, direction) {
//     var opp_direction = (direction == 'up') ? 'down' : 'up';
//
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#vote_' + direction + '_indicator',
//             hide: 'vote_' + direction + '_link'},
//         success: {
//             update: '#issue_votes',
//             hide: ['vote_' + direction + '_link', 'vote_' + opp_direction + '_faded'],
//             show: ['vote_' + direction + '_faded', 'vote_' + opp_direction + '_link']
//         }
//     });
// };
//
// Pachno.Issues.voteUp = function (url) {
//     Pachno.Issues._addVote(url, 'up');
// };
//
// Pachno.Issues.voteDown = function (url) {
//     Pachno.Issues._addVote(url, 'down');
// };
//
// Pachno.Issues.toggleFavourite = function (url, issue_id_user_id)
// {
//     var issue_id = new String(issue_id_user_id).indexOf('_') !== -1
//         ? issue_id_user_id.substr(0, issue_id_user_id.indexOf('_'))
//         : issue_id_user_id;
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             callback: function () {
//                 if ($('#popup_find_subscriber_' + issue_id) != null && $('#popup_find_subscriber_' + issue_id).visible() && $('#popup_find_subscriber_' + issue_id + '_spinning')) {
//                     $('#popup_find_subscriber_' + issue_id + '_spinning').show();
//                 }
//                 else {
//                     Pachno.Core._processCommonAjaxPostEvents({
//                         show: 'issue_favourite_indicator_' + issue_id_user_id,
//                         hide: ['issue_favourite_normal_' + issue_id_user_id, 'issue_favourite_faded_' + issue_id_user_id]
//                     });
//                 }
//             }
//         },
//         success: {
//             hide: 'popup_find_subscriber_' + issue_id,
//             callback: function (json) {
//                 if ($('#popup_find_subscriber_' + issue_id + '_spinning')) {
//                     $('#popup_find_subscriber_' + issue_id + '_spinning').hide();
//                 }
//                 else {
//                     Pachno.Core._processCommonAjaxPostEvents({
//                         hide: 'issue_favourite_indicator_' + issue_id_user_id,
//                     });
//                 }
//                 if ($('#issue_favourite_faded_' + issue_id_user_id)) {
//                     if (json.starred) {
//                         $('#issue_favourite_faded_' + issue_id_user_id).hide();
//                         $('#issue_favourite_indicator_' + issue_id_user_id).hide();
//                         $('#issue_favourite_normal_' + issue_id_user_id).show();
//                     } else {
//                         $('#issue_favourite_normal_' + issue_id_user_id).hide();
//                         $('#issue_favourite_indicator_' + issue_id_user_id).hide();
//                         $('#issue_favourite_faded_' + issue_id_user_id).show();
//                     }
//                 } else if (json.subscriber != '') {
//                     $('#subscribers_list').append(json.subscriber);
//                 }
//                 if (json.count != undefined && $('#subscribers_field_count')) {
//                     $('#subscribers_field_count').html(json.count);
//                 }
//             }
//         }
//     });
// }
//
// Pachno.Issues.toggleBlocking = function (url, issue_id)
// {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#fullpage_backdrop',
//             show: 'fullpage_backdrop_indicator',
//             hide: 'fullpage_backdrop_content'
//         },
//         success: {
//             callback: function (json) {
//                 $('#more_actions_mark_notblocking_link_' + issue_id).toggle();
//                 $('#more_actions_mark_blocking_link_' + issue_id).toggle();
//
//                 if ($('#blocking_div')) {
//                     $('#blocking_div').toggle();
//                 }
//                 if ($('#issue_' + issue_id)) {
//                     $('#issue_' + issue_id).toggleClass('blocking');
//                 }
//             }
//         }
//     });
// }
//
// Pachno.Issues.Link.add = function (url) {
//     Pachno.Helpers.fetch(url, {
//         form: 'attach_link_form',
//         loading: {
//             indicator: '#attach_link_indicator',
//             callback: function () {
//                 $('#attach_link_submit').prop('disabled', true);
//             }
//         },
//         success: {
//             reset: 'attach_link_form',
//             hide: ['attach_link', 'viewissue_no_uploaded_files'],
//             update: {element: 'viewissue_uploaded_links', insertion: true},
//             callback: function (json) {
//                 if ($('#viewissue_uploaded_attachments_count'))
//                     $('#viewissue_uploaded_attachments_count').html(json.attachmentcount);
//                 Pachno.Helpers.Backdrop.reset();
//             }
//         },
//         complete: {
//             callback: function () {
//                 $('#attach_link_submit').prop('disabled', false);
//             }
//         }
//     });
// }
//
// Pachno.Issues.Link.remove = function (url, link_id) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#viewissue_links_' + link_id + '_remove_indicator',
//             hide: link_id + '_remove_link',
//             callback: Pachno.Helpers.Dialog.dismiss
//         },
//         success: {
//             remove: ['viewissue_links_' + link_id, 'viewissue_links_' + link_id + '_remove_confirm'],
//             callback: function (json) {
//                 if (json.attachmentcount == 0 && $('#viewissue_no_uploaded_files')) $('#viewissue_no_uploaded_files').show();
//                 if ($('#viewissue_uploaded_attachments_count')) $('#viewissue_uploaded_attachments_count').html(json.attachmentcount);
//             }
//         },
//         failure: {
//             show: link_id + '_remove_link'
//         }
//     });
// }
//
// Pachno.Issues.File.remove = function (url, file_id) {
//     Pachno.Core._detachFile(url, file_id, 'viewissue_files_', 'dialog_indicator');
// }
//
// Pachno.Issues.Field.setPercent = function (url, mode) {
//     Pachno.Helpers.fetch(url, {
//         loading: {indicator: '#percent_complete_spinning'},
//         success: {
//             callback: function (json) {
//                 Pachno.Main.updatePercentageLayout(json.percent);
//                 (mode == 'set') ? Pachno.Issues.markAsChanged('percent_complete') : Pachno.Issues.markAsUnchanged('percent_complete');
//             },
//             hide: 'percent_complete_change'
//         }
//     });
// }
//
// Pachno.Issues.Field.Updaters.dualFromJSON = function (issue_id, dualfield, field) {
//     if (dualfield.id == 0) {
//         $(field + '_table').hide();
//         $('#no_' + field).show();
//     } else {
//         $(field + '_content').html(dualfield.name);
//         if (field == 'status')
//             $('#status_' + issue_id + '_color').css({backgroundColor: dualfield.color});
//         else if (field == 'issuetype')
//             $('#issuetype_image').src = dualfield.src;
//         if ($('#no_' + field))
//             $('#no_' + field).hide();
//         if ($(field + '_table'))
//             $(field + '_table').show();
//     }
// }
//
// Pachno.Issues.Field.Updaters.fromObject = function (issue_id, object, field) {
//     var fn = field + '_' + issue_id + '_name';
//     var nf = 'no_' + field + '_' + issue_id;
//     if (!$(fn)) {
//         fn = field + '_name';
//         nf = 'no_' + field;
//     }
//     if ((Object.isUndefined(object.id) == false && object.id == 0) || (object.value && object.value == '')) {
//         $(fn).hide();
//         $(nf).show();
//     } else {
//         $(fn).html(object.name);
//         if (object.url)
//             $(fn).href = object.url;
//         $(nf).hide();
//         $(fn).show();
//     }
// }
//
// Pachno.Issues.Field.Updaters.timeFromObject = function (issue_id, object, values, field) {
//     var fn = field + '_' + issue_id + '_name';
//     var nf = 'no_' + field + '_' + issue_id;
//     if ($(fn) && $(nf)) {
//         if (object.id == 0) {
//             $(fn).hide();
//             $(nf).show();
//         } else {
//             $(fn).html(object.name);
//             $(nf).hide();
//             $(fn).show();
//         }
//     }
//     ['points', 'minutes', 'hours', 'days', 'weeks', 'months'].each(function (unit) {
//         if (field != 'spent_time' && $(field + '_' + issue_id + '_' + unit + '_input'))
//             $(field + '_' + issue_id + '_' + unit + '_input').value(values[unit]);
//
//         if ($(field + '_' + issue_id + '_' + unit)) {
//             $(field + '_' + issue_id + '_' + unit).html(values[unit]);
//             if (values[unit] == 0) {
//                 $(field + '_' + issue_id + '_' + unit).addClass('faded_out');
//             } else {
//                 $(field + '_' + issue_id + '_' + unit).removeClass('faded_out');
//             }
//         }
//     });
// }
//
// Pachno.Issues.Field.Updaters.allVisible = function (visible_fields) {
//     Pachno.available_fields.each(function (field)
//     {
//         if ($(field + '_field')) {
//             if (visible_fields[field] != undefined) {
//                 $(field + '_field').show();
//                 if ($(field + '_additional'))
//                     $(field + '_additional').show();
//             } else {
//                 $(field + '_field').hide();
//                 if ($(field + '_additional'))
//                     $(field + '_additional').hide();
//             }
//         }
//     });
// }
//
// /**
//  * This function is triggered every time an issue is updated via the web interface
//  * It sends a request that performs the update, and gets JSON back
//  *
//  * Depending on the JSON return value, it updates fields, shows/hides boxes on the
//  * page, and sets some class values
//  *
//  * @param url The URL to request
//  * @param field The field that is being changed
//  * @param serialize_form Whether a form is being serialized
//  */
// Pachno.Issues.Field.set = function (url, field, serialize_form) {
//     var post_form = undefined;
//     if (['description', 'reproduction_steps', 'title', 'shortname'].indexOf(field) != -1) {
//         post_form = field + '_form';
//     } else if (serialize_form != undefined) {
//         post_form = serialize_form + '_form';
//     }
//
//     var loading_show = (field == 'issuetype') ? 'issuetype_indicator_fullpage' : undefined;
//
//     Pachno.Helpers.fetch(url, {
//         form: post_form,
//         loading: {
//             indicator: loading_show != undefined ? loading_show : field + '_spinning',
//             clear: field + '_change_error',
//             hide: field + '_change_error'
//         },
//         success: {
//             callback: function (json) {
//                 if (json.field != undefined)
//                 {
//                     if (field == 'status' || field == 'issuetype')
//                         Pachno.Issues.Field.Updaters.dualFromJSON(json.issue_id, json.field, field);
//                     else if (field == 'percent_complete')
//                         Pachno.Main.updatePercentageLayout(json.percent);
//                     else if (field == 'estimated_time') {
//                         Pachno.Issues.Field.Updaters.timeFromObject(json.issue_id, json.field, json.values, field);
//                         $(field + '_' + json.issue_id + '_change').hide();
//                         Pachno.Issues.Field.updateEstimatedPercentbar(json);
//                     }
//                     else if (field == 'spent_time') {
//                         Pachno.Issues.Field.Updaters.timeFromObject(json.issue_id, json.field, json.values, field);
//                         $(field + '_' + json.issue_id + '_change').hide();
//                     }
//                     else
//                         Pachno.Issues.Field.Updaters.fromObject(json.issue_id, json.field, field);
//
//                     if (field == 'issuetype')
//                         Pachno.Issues.Field.Updaters.allVisible(json.visible_fields);
//                     else if (field == 'pain_bug_type' || field == 'pain_likelihood' || field == 'pain_effect')
//                     {
//                         $('#issue_user_pain').html(json.user_pain);
//                         if (json.user_pain_diff_text != '') {
//                             $('#issue_user_pain_calculated').html(json.user_pain_diff_text);
//                             $('#issue_user_pain_calculated').show();
//                         } else {
//                             $('#issue_user_pain_calculated').hide();
//                         }
//                     }
//                 }
//                 (json.changed == true) ? Pachno.Issues.markAsChanged(field) : Pachno.Issues.markAsUnchanged(field);
//                 if (field == 'description' && $('#description_edit')) {
//                     $('#description_edit').style.display = '';
//                 }
//                 else if (field == 'title') {
//                     $('#title-field').toggleClass('editing');
//                 }
//             },
//             hide: field + '_change'
//         },
//         failure: {
//             update: field + '_change_error',
//             show: field + '_change_error',
//             callback: function (json) {
//                 new Effect.Pulsate($(field + '_change_error'));
//             }
//         }
//     });
// }
//
// Pachno.Issues.Field.setTime = function (url, field, issue_id) {
//     Pachno.Helpers.fetch(url, {
//         form: field + '_' + issue_id + '_form',
//         loading: {
//             indicator: field + '_' + issue_id + '_spinning',
//             clear: field + '_' + issue_id + '_change_error',
//             hide: field + '_' + issue_id + '_change_error'
//         },
//         success: {
//             callback: function (json) {
//                 Pachno.Issues.Field.Updaters.timeFromObject(json.issue_id, json.field, json.values, field);
//                 (json.changed == true) ? Pachno.Issues.markAsChanged(field) : Pachno.Issues.markAsUnchanged(field);
//                 if ($('#issue_' + issue_id)) {
//                     ['points', 'hours', 'minutes'].each(function (unit) {
//                         if (field == 'estimated_time') {
//                             Pachno.Issues.Field.updateEstimatedPercentbar(json);
//                             $('#issue_' + issue_id).attr('data-estimated-' + unit, json.values[unit]);
//                             $('#issue_' + issue_id).down('.issue_estimate.' + unit).html(json.values[unit]);
//                             (parseInt(json.values[unit]) > 0) ? $('#issue_' + issue_id).down('.issue_estimate.' + unit).show() : $('#issue_' + issue_id).down('.issue_estimate.' + unit).hide();
//                         } else {
//                             $('#issue_' + issue_id).attr('data-spent-' + unit, json.values[unit]);
//                             $('#issue_' + issue_id).down('.issue_spent.' + unit).html(json.values[unit]);
//                             (parseInt(json.values[unit]) > 0) ? $('#issue_' + issue_id).down('.issue_spent.' + unit).show() : $('#issue_' + issue_id).down('.issue_spent.' + unit).hide();
//                         }
//                         $('#issue_' + issue_id).dataset.lastUpdated = get_current_timestamp();
//                     });
//                     var fields = $('#issue_' + issue_id).find('.sc_' + field);
//                     if (fields.length > 0) {
//                         fields.each(function (sc_element) {
//                             if (json.field.name) {
//                                 $(sc_element).html(json.field.name);
//                                 $(sc_element).removeClass('faded_out');
//                             } else {
//                                 $(sc_element).html('-');
//                                 $(sc_element).addClass('faded_out');
//                             }
//                         });
//                     }
//                 }
//                 if ($('#milestones-list')) {
//                     Pachno.Project.Planning.calculateMilestoneIssueVisibilityDetails($('#issue_' + issue_id).parents('.milestone-issues'));
//                     Pachno.Project.Planning.calculateNewBacklogMilestoneDetails();
//                 }
//             },
//             hide: field + '_' + issue_id + '_change'
//         },
//         failure: {
//             update: field + '_' + issue_id + '_change_error',
//             show: field + '_' + issue_id + '_change_error',
//             callback: function (json) {
//                 new Effect.Pulsate($(field + '_' + issue_id + '_change_error'));
//             }
//         }
//     });
// }
//
// Pachno.Issues.Field.revert = function (url, field)
// {
//     var loading_show = (field == 'issuetype') ? 'issuetype_indicator_fullpage' : undefined;
//
//     Pachno.Issues.markAsUnchanged(field);
//
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: loading_show != undefined ? loading_show : field + '_undo_spinning'
//         },
//         success: {
//             callback: function (json) {
//                 if (json.field != undefined) {
//                     if (field == 'status' || field == 'issuetype')
//                         Pachno.Issues.Field.Updaters.dualFromJSON(json.issue_id, json.field, field);
//                     else if (field == 'estimated_time') {
//                         Pachno.Issues.Field.Updaters.timeFromObject(json.issue_id, json.field, json.values, field);
//                         Pachno.Issues.Field.updateEstimatedPercentbar(json);
//                     }
//                     else if (field == 'spent_time')
//                         Pachno.Issues.Field.Updaters.timeFromObject(json.issue_id, json.field, json.values, field);
//                     else if (field == 'percent_complete')
//                         Pachno.Main.updatePercentageLayout(json.field);
//                     else
//                         Pachno.Issues.Field.Updaters.fromObject(json.issue_id, json.field, field);
//
//                     if (field == 'issuetype')
//                         Pachno.Issues.Field.Updaters.allVisible(json.visible_fields);
//                     else if (field == 'description' || field == 'reproduction_steps')
//                         $(field + '_form_value').html(json.field.form_value);
//                     else if (field == 'pain_bug_type' || field == 'pain_likelihood' || field == 'pain_effect')
//                         $('#issue_user_pain').html(json.field.user_pain);
//
//                     if (field == 'description') {
//                         $('#description_edit').style.display = '';
//                         $('#description_change').hide();
//                     }
//                 }
//
//             }
//         },
//         failure: {
//             callback: function () {
//                 Pachno.Issues.markAsChanged(field);
//             }
//         }
//     });
// }
//
// Pachno.Issues.Field.incrementTimeMinutes = function (minutes, input)
// {
//     if (minutes > 60 || minutes < 0) return;
//
//     var hour_input = input.replace('minutes', 'hours');
//
//     // Increment hour by one for 60 minutes
//     if (minutes == 60 && $(hour_input)) {
//       $(hour_input).value((parseInt($(hour_input).val()) || 0) + 1);
//       return;
//     }
//
//     if (! $(input)) return;
//
//     var new_minutes = (parseInt($(input).val()) || 0) + minutes;
//
//     if (new_minutes >= 60 && $(hour_input)) {
//         $(hour_input).value((parseInt($(hour_input).val()) || 0) + 1);
//         new_minutes = new_minutes - 60;
//     }
//
//     $(input).value(new_minutes);
// }
//
// Pachno.Issues.markAsChanged = function (field)
// {
//     if ($('#viewissue_changed') != undefined) {
//         if (!$('#viewissue_changed').visible()) {
//             $('#viewissue_changed').show();
//             Effect.Pulsate($('#issue-messages-container'), {pulses: 3, duration: 2});
//         }
//
//         $(field + '_field').addClass('issue_detail_changed');
//         if (field == 'issuetype') {
//             $("#workflow-actions input[type='submit'], #workflow-actions input[type='button']").prop("disabled", true);
//             $("#workflow-actions a").off('click');
//         }
//     }
//
//     if ($('#comment_save_changes'))
//         $('#comment_save_changes').checked = true;
// }
//
// Pachno.Issues.markAsUnchanged = function (field)
// {
//     if ($(field + '_field') && $('#issue_view')) {
//         $(field + '_field').removeClass('issue_detail_changed');
//         $(field + '_field').removeClass('issue_detail_unmerged');
//         if ($('#issue_view').find('.issue_detail_changed').length == 0) {
//             $('#viewissue_changed').hide();
//             $('#viewissue_merge_errors').hide();
//             $('#viewissue_unsaved').hide();
//             if ($('#comment_save_changes'))
//                 $('#comment_save_changes').checked = false;
//         }
//         if (field == 'issuetype') {
//             $("#workflow-actions input[type='submit'], #workflow-actions input[type='button']").prop("disabled", false);
//             $("#workflow-actions a").on('click');
//         }
//     }
// }
//
// Pachno.Issues.ACL.toggle_checkboxes = function (element, issue_id, val) {
//     if (! $(element).is(':checked')) return;
//
//     switch (val) {
//         case 'public':
//             $('#acl_' + issue_id + '_public').show();
//             $('#acl_' + issue_id + '_restricted').hide();
//             $('#issue_' + issue_id + '_public_category_access_list').hide();
//             $('#issue_access_public_category_input').prop('disabled', true);
//             $('#acl-users-teams-selector').hide();
//             break;
//         case 'public_category':
//             $('#acl_' + issue_id + '_public').show();
//             $('#acl_' + issue_id + '_restricted').hide();
//             $('#issue_' + issue_id + '_public_category_access_list').show();
//             $('#issue_access_public_category_input').prop('disabled', false);
//             $('#acl-users-teams-selector').show();
//             break;
//         case 'restricted':
//             $('#acl_' + issue_id + '_public').hide();
//             $('#acl_' + issue_id + '_restricted').show();
//             $('#acl-users-teams-selector').show();
//             break;
//     }
// };
//
// Pachno.Issues.ACL.toggle_custom_access = function (element) {
//     if ($(element).is(':checked')) {
//         $('.report-issue-custom-access-container').show();
//         $('.report-issue-custom-access-container input[name=issue_access]').trigger('change');
//     }
//     else {
//         $('.report-issue-custom-access-container').hide();
//     }
// };
//
// Pachno.Issues.ACL.addTarget = function (url, issue_id) {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#popup_find_acl_' + issue_id + '_spinning'
//         },
//         success: {
//             update: {},
//             callback: function(json) {
//                 $('#issue_' + issue_id + '_restricted_access_list').append(json.content);
//                 $('#issue_' + issue_id + '_public_category_access_list').append(json.content);
//                 $('#issue_' + issue_id + '_restricted_access_list_none').hide();
//                 $('#issue_' + issue_id + '_public_category_access_list_none').hide();
//             },
//             hide: 'popup_find_acl_' + issue_id
//         }
//     });
// };
//
// Pachno.Issues.ACL.set = function (url, issue_id, mode) {
//     Pachno.Helpers.fetch(url, {
//         form: 'acl_' + issue_id + '_' + mode + 'form',
//         loading: {
//             indicator: '#fullpage_backdrop',
//             show: 'fullpage_backdrop_indicator',
//             hide: ['fullpage_backdrop_content', 'dialog_backdrop']
//         },
//         success: {
//             callback: Pachno.Helpers.Backdrop.reset
//         }
//     });
// };
//
// Pachno.Issues.Affected.toggleConfirmed = function (url, affected)
// {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             callback: function () {
//                 $('#affected_' + affected + '_state').parents('.affected-state').addClass('loading');
//             }
//         },
//         success: {
//             callback: function (json) {
//                 $('#affected_' + affected + '_state').html(json.text);
//                 $('#affected_' + affected + '_state').parents('.affected-state').toggleClass('unconfirmed');
//                 $('#affected_' + affected + '_state').parents('.affected-state').toggleClass('confirmed');
//                 $('#affected_' + affected + '_state').parents('.affected-state').removeClass('loading');
//             }
//         },
//         complete: {
//             callback: function () {
//                 $('#affected_' + affected + '_state').parents('.affected-state').removeClass('loading');
//             }
//         }
//     });
// }
//
// Pachno.Issues.Affected.remove = function (url, affected)
// {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#fullpage_backdrop',
//             show: 'fullpage_backdrop_indicator',
//             hide: ['fullpage_backdrop_content', 'dialog_backdrop']
//         },
//         success: {
//             update: {element: 'viewissue_affects_count', from: 'itemcount'},
//             remove: ['affected_' + affected + '_delete', 'affected_' + affected],
//             callback: function (json) {
//                 if (json.itemcount == 0)
//                     $('#no_affected').show();
//             }
//         }
//     });
// }
//
// Pachno.Issues.Affected.setStatus = function (url, affected)
// {
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#affected_' + affected + '_status_spinning'
//         },
//         success: {
//             callback: function (json) {
//                 $('#affected_' + affected + '_status').css({
//                     backgroundColor: json.colour,
//                 });
//             },
//             update: {element: 'affected_' + affected + '_status', from: 'name'},
//             hide: 'affected_' + affected + '_status_change'
//         },
//         failure: {
//             update: {element: 'affected_' + affected + '_status_error', from: 'error'},
//             show: 'affected_' + affected + '_status_error',
//             callback: function (json) {
//                 new Effect.Pulsate($('#affected_' + affected + '_status_error'));
//             }
//         }
//     });
// }
//
// Pachno.Issues.Affected.add = function (url)
// {
//     Pachno.Helpers.fetch(url, {
//         form: 'viewissue_add_item_form',
//         loading: {
//             indicator: '#add_affected_spinning'
//         },
//         success: {
//             callback: function (json) {
//                 if ($('#viewissue_affects_count'))
//                     $('#viewissue_affects_count').html(json.itemcount);
//                 if (json.itemcount != 0 && $('#no_affected'))
//                     $('#no_affected').hide();
//                 Pachno.Helpers.Backdrop.reset();
//             },
//             update: {element: 'affected_list', insertion: true},
//         }
//     });
// }
//
// Pachno.Issues.updateWorkflowAssignee = function (url, assignee_id, assignee_type, transition_id, teamup)
// {
//     teamup = (teamup == undefined) ? 0 : 1;
//     Pachno.Helpers.fetch(url, {
//         loading: {
//             indicator: '#popup_assigned_to_name_indicator_' + transition_id,
//             hide: 'popup_no_assigned_to_' + transition_id,
//             show: 'popup_assigned_to_name_' + transition_id
//         },
//         success: {
//             update: '#popup_assigned_to_name_' + transition_id
//         },
//         complete: {
//             callback: function () {
//                 $('#popup_assigned_to_id_' + transition_id).value(assignee_id);
//                 $('#popup_assigned_to_type_' + transition_id).value(assignee_type);
//                 $('#popup_assigned_to_teamup_' + transition_id).value(teamup);
//                 if (teamup) {
//                     $('#popup_assigned_to_teamup_info_' + transition_id).show();
//                 } else {
//                     $('#popup_assigned_to_teamup_info_' + transition_id).hide();
//                 }
//             },
//             hide: ['popup_assigned_to_teamup_info_' + transition_id, 'popup_assigned_to_change_' + transition_id]
//         }
//     });
// }
//
// Pachno.Issues.updateWorkflowAssigneeTeamup = function (url, assignee_id, assignee_type, transition_id)
// {
//     Pachno.Issues.updateWorkflowAssignee(url, assignee_id, assignee_type, transition_id, true);
// }
//
// Pachno.Search.deleteSavedSearch = function (url, id) {
//     Pachno.Helpers.fetch(url, {
//         loading: {indicator: '#delete_search_' + id + '_indicator'},
//         success: {hide: 'saved_search_' + id + '_container'}
//     });
// };
//
// Pachno.Search.toPage = function (url, parameters, offset, button) {
//     parameters += '&offset=' + offset;
//     Pachno.Helpers.fetch(url, {
//         params: parameters,
//         loading: {
//             callback: function() {
//                 $(this).addClass('submitting');
//             }
//         },
//         success: {
//             update: '#search-results',
//             callback: function() {
//                 $(this).removeClass('submitting');
//             }
//         }
//     });
// };
//
// Pachno.Search.bulkContainerChanger = function () {
//     var selected_radio_value = $('#input[name=search_bulk_action]:checked', '#search-bulk-action-form').val(),
//         sub_container_id = 'bulk_action_subcontainer_' + selected_radio_value;
//
//     $('.bulk_action_subcontainer').each(function (element) {
//         element.hide();
//     });
//     if ($(sub_container_id)) {
//         $(sub_container_id).show();
//         $('#bulk_action_submit').removeClass('disabled');
//         var dropdown_element = $(sub_container_id + '').down('.focusable');
//         if (dropdown_element != undefined)
//             dropdown_element.focus();
//     } else {
//         $('#bulk_action_submit').addClass('disabled');
//     }
// };
//
// Pachno.Search.bulkChanger = function (mode) {
//     var sub_container_id = 'bulk_action_' + $('#bulk_action_selector_' + mode).val();
//     var opp_mode = (mode == 'top') ? 'bottom' : 'top';
//
//     if ($('#bulk_action_selector_' + mode).val() == '') {
//         $('#bulk_action_submit_' + mode).addClass('disabled');
//         $('#bulk_action_submit_' + opp_mode).addClass('disabled');
//     } else if (!$('#search-bulk-actions_' + mode).hasClass('unavailable')) {
//         $('#bulk_action_submit_' + mode).removeClass('disabled');
//         $('#bulk_action_submit_' + opp_mode).removeClass('disabled');
//     }
//     $(sub_container_id + '_' + opp_mode).val($(sub_container_id + '_' + mode).val());
// }
//
// Pachno.Search.bulkPostProcess = function (json) {
//     if (json.last_updated) {
//         if (json.milestone_name != undefined && json.milestone_id) {
//             if ($('#milestones-list') != undefined) {
//                 if ($('#milestone_' + json.milestone_id) == undefined) {
//                     Pachno.Project.Milestone.retrieve(json.milestone_url, json.milestone_id, json.issue_ids);
//                 }
//             }
//             if ($('#bulk_action_assign_milestone_top') != undefined && $('#bulk_action_assign_milestone_top_' + json.milestone_id) == undefined) {
//                 $('#bulk_action_assign_milestone_top').append('<option value="' + json.milestone_id + '" id="bulk_action_assign_milestone_top_' + json.milestone_id + '">' + json.milestone_name + '</option>');
//                 $('#bulk_action_assign_milestone_top').value(json.milestone_id);
//                 $('#bulk_action_assign_milestone_top_name').hide();
//             }
//             if ($('#bulk_action_assign_milestone_bottom') != undefined && $('#bulk_action_assign_milestone_bottom_' + json.milestone_id) == undefined) {
//                 $('#bulk_action_assign_milestone_bottom').append('<option value="' + json.milestone_id + '" id="bulk_action_assign_milestone_bottom_' + json.milestone_id + '">' + json.milestone_name + '</option>');
//                 $('#bulk_action_assign_milestone_bottom').value(json.milestone_id);
//                 $('#bulk_action_assign_milestone_bottom_name').hide();
//             }
//         }
//         json.issue_ids.each(function (issue_id) {
//             var issue_elm = $('#issue_' + issue_id);
//             if (issue_elm != undefined) {
//                 if (json.milestone_name != undefined) {
//                     var milestone_container = issue_elm.down('.sc_milestone');
//                     if (milestone_container != undefined) {
//                         milestone_container.html(json.milestone_name);
//                         if (json.milestone_name != '-') {
//                             milestone_container.removeClass('faded_out');
//                         } else {
//                             milestone_container.addClass('faded_out');
//                         }
//                     }
//                 }
//                 if (json.status != undefined) {
//                     var status_container = issue_elm.down('.sc_status');
//                     if (status_container != undefined) {
//                         status_container.down('.sc_status_name').html(json.status['name']);
//                         var status_color_item = status_container.down('.sc_status_color');
//                         if (status_color_item)
//                             status_color_item.css({backgroundColor: json.status['color']});
//                     }
//                 }
//                 ['resolution', 'priority', 'category', 'severity'].each(function (action) {
//                     if (json[action] != undefined) {
//                         var data_container = issue_elm.down('.sc_' + action);
//                         if (data_container != undefined) {
//                             data_container.html(json[action]['name']);
//                             if (json[action]['name'] != '-') {
//                                 data_container.removeClass('faded_out');
//                             } else {
//                                 data_container.addClass('faded_out');
//                             }
//                         }
//                         if ($(action + '_selector_' + issue_id) != undefined) {
//                             $(action + '_selector_' + issue_id).value(json[action]['id']);
//                         }
//                     }
//                 });
//                 var last_updated_container = issue_elm.down('.sc_last_updated');
//                 if (last_updated_container != undefined) {
//                     last_updated_container.html(json.last_updated);
//                 }
//                 if (json.closed != undefined) {
//                     if (json.closed) {
//                         issue_elm.addClass('closed');
//                     } else {
//                         issue_elm.removeClass('closed');
//                     }
//                 }
//             }
//         });
//         Pachno.Search.liveUpdate(true);
//     }
// }
//
// Pachno.Search.interactiveWorkflowTransition = function (url, transition_id, form) {
//     Pachno.Helpers.fetch(url, {
//         form: form,
//         loading: {
//             indicator: '#transition_working_' + transition_id + '_indicator',
//             callback: function () {
//                 $('.workflow_transition_submit_button').each(function (element) {
//                     $(element).addClass('disabled');
//                     $(element).writeAttribute('disabled');
//                 });
//             }
//         },
//         success: {
//             callback: function (json) {
//                 Pachno.Core.Pollers.Callbacks.planningPoller();
//                 Pachno.Helpers.Backdrop.reset();
//                 Pachno.Search.liveUpdate(true);
//             }
//         },
//         complete: {
//             callback: function () {
//                 $('.workflow_transition_submit_button').each(function (element) {
//                     $(element).removeClass('disabled');
//                     $(element).writeAttribute('disabled', false);
//                 });
//             }
//         }
//     });
// }
//
// Pachno.Search.nonInteractiveWorkflowTransition = function () {
//     // No need to remove 'disabled' class and attribute since form that is submitted
//     // will refresh page.
//     $('.workflow_transition_submit_button').each(function (element) {
//         $(element).addClass('disabled');
//         $(element).writeAttribute('disabled');
//     });
// }
//
// Pachno.Search.bulkWorkflowTransition = function (url, transition_id) {
//     Pachno.Helpers.fetch(url, {
//         form: 'bulk_workflow_transition_form',
//         loading: {
//             indicator: '#transition_working_' + transition_id + '_indicator',
//             callback: function () {
//                 $('.workflow_transition_submit_button').each(function (element) {
//                     $(element).addClass('disabled');
//                     $(element).writeAttribute('disabled');
//                 });
//             }
//         },
//         success: {
//             callback: function (json) {
//                 Pachno.Search.bulkPostProcess(json)
//                 Pachno.Helpers.Backdrop.reset();
//             }
//         },
//         complete: {
//             callback: function () {
//                 $('.workflow_transition_submit_button').each(function (element) {
//                     $(element).removeClass('disabled');
//                     $(element).writeAttribute('disabled', false);
//                 });
//             }
//         }
//     });
// };
//
// Pachno.Search.bulkUpdate = function (url) {
//     if ($('#bulk_action_selector').val() == '')
//         return;
//     var issues = '';
//     $('#search-results').find('tbody input[type=checkbox]').each(function (element) {
//         if (element.checked)
//             issues += '&issue_ids[' + element.val() + ']=' + element.val();
//     });
//
//     if ($('#bulk_action_selector').val() == 'perform_workflow_step') {
//         Pachno.Helpers.Backdrop.show($('#bulk_action_subcontainer_perform_workflow_step_url').val() + issues);
//     } else {
//         Pachno.Helpers.fetch(url, {
//             form: 'search-bulk-action-form',
//             additional_params: issues,
//             loading: {
//                 indicator: '#fullpage_backdrop',
//                 show: 'fullpage_backdrop_indicator',
//                 hide: 'fullpage_backdrop_content'
//             },
//             success: {
//                 callback: Pachno.Search.bulkPostProcess
//             }
//         });
//     }
// };
//
// Pachno.Search.download = function (format) {
//     var fif = $('#find_issues_form');
//     var parameters = fif.serialize();
//     window.location = fif.dataset.historyUrl + '?' + parameters + '&format=' + format;
// };
//
// Pachno.Search.saveSearch = function () {
//     var fif = $('#find_issues_form');
//     var find_parameters = fif.serialize();
//     var ssf = $('#save_search_form');
//     var p = find_parameters + '&' + ssf.serialize();
//
//     var button = ssf.down('input[type=submit]');
//     Pachno.Helpers.fetch(ssf.action, {
//         params: p,
//         loading: {
//             indicator: '#save_search_indicator',
//             callback: function () {
//                 button.prop('disabled', true);
//             }
//         },
//         complete: {
//             callback: function () {
//                 button.prop('disabled', false);
//             }
//         }
//     });
// };
//
// Pachno.Main.loadParentArticles = function (form) {
//     Pachno.Helpers.fetch(form.action, {
//         params: $(form).serialize(),
//         loading: {
//             indicator: '#parent_selector_container_indicator',
//         },
//         complete: {
//             callback: function (json) {
//                 $('#parent_articles_list').html(json.list);
//             }
//         }
//     });
// };
//
// Pachno.Main.initializeMentionable = function (textarea) {
//     if ($(textarea).hasClass('mentionable') && !$(textarea).hasClass('mentionable-initialized')) {
//         Pachno.Helpers.fetch(Pachno.data_url, {
//             method: 'GET',
//             params: 'say=get_mentionables&target_type=' + $(textarea).dataset.targetType + '&target_id=' + $(textarea).dataset.targetId,
//             success: {
//                 callback: function (json) {
//                     $('#' + textarea.id).mention({
//                         delimiter: '@',
//                         sensitive: true,
//                         emptyQuery: true,
//                         queryBy: ['name', 'username'],
//                         typeaheadOpts: {
//                             items: 10 // Max number of items you want to show
//                         },
//                         users: json.mentionables
//                     });
//                     $(textarea).addClass('mentionable-initialized');
//                 }
//             }
//         });
//     }
//     ;
// };
//
// Pachno.Helpers.initializeColorPicker = function () {
//     $('#input.color').each(function (index, element) {
//         var input = $(element);
//         input.spectrum({
//             cancelText: input.data('cancel-text'),
//             chooseText: input.data('choose-text'),
//             showInput: true,
//             preferredFormat: 'hex'
//         });
//     });
// };
//
// Pachno.Core.getPluginUpdates = function (type) {
//     var params = '',
//         plugins = $('#installed-'+type+'s-list').children();
//     plugins.each(function (plugin) {
//         if (type == 'theme' || !plugin.hasClass('disabled')) {
//             params += '&addons[]=' + plugin.dataset[type+'Key'];
//         }
//     });
//     Pachno.Helpers.fetch($('#main_container').data('url'), {
//         method: 'GET',
//         params: 'say=get_'+type+'_updates' + params,
//         loading: {
//             indicator: '#installed_'+type+'s_indicator'
//         },
//         success: {
//             update: '#installed_'+type+'s_indicator',
//             callback: function (json) {
//                 plugins.each(function (plugin) {
//                     if (json[plugin.dataset[type+'Key']] !== undefined) {
//                         if (plugin.dataset.version != json[plugin.dataset[type+'Key']].version) {
//                             plugin.addClass('can-update');
//                             var link = $(type + '_'+plugin.dataset[type+'Key']+'_download_location');
//                             link.attr('href', json[plugin.dataset[type+'Key']].download);
//                             $('body').on('click', '.update-'+type+'-menu-item', function (e) {
//                                 var pluginbox = $(this).parents('li.'+type);
//                                 $('#update_'+type+'_help_' + pluginbox.data('id')).show();
//                                 if (!Pachno.Core.Pollers.pluginupdatepoller)
//                                     Pachno.Core.Pollers.pluginupdatepoller = new PeriodicalExecuter(Pachno.Core.validatePluginUpdateUploadedPoller(type, pluginbox.data('module-key')), 5);
//                             });
//                         }
//                     }
//                 })
//             }
//         },
//         failure: {
//             callback: function (response) {
//             }
//         }
//     });
// };
//
// Pachno.Core.cancelManualUpdatePoller = function () {
//     Pachno.Core.Pollers.Locks.pluginupdatepoller = false;
//     if (Pachno.Core.Pollers.pluginupdatepoller) {
//         Pachno.Core.Pollers.pluginupdatepoller.stop();
//         Pachno.Core.Pollers.pluginupdatepoller = undefined;
//     }
// };
//
// Pachno.Core.validatePluginUpdateUploadedPoller = function (type, pluginkey) {
//     return function () {
//         if (!Pachno.Core.Pollers.Locks.pluginupdatepoller) {
//             Pachno.Core.Pollers.Locks.pluginupdatepoller = true;
//             Pachno.Helpers.fetch($('#main_container').data('url'), {
//                 method: 'GET',
//                 params: '&say=verify_'+type+'_update_file&'+type+'_key='+pluginkey,
//                 success: {
//                     callback: function (json) {
//                         if (json.verified == '1') {
//                             $('#'+type+'_'+pluginkey+'_perform_update').children('input[type=submit]').prop('disabled', false);
//                             Pachno.Core.cancelManualUpdatePoller();
//                         }
//                         Pachno.Core.Pollers.Locks.pluginupdatepoller = false;
//                     }
//                 },
//                 exception: {
//                     callback: function () {
//                         Pachno.Core.Pollers.Locks.pluginupdatepoller = false;
//                     }
//                 }
//             });
//         }
//     }
// };
//
// Pachno.Core.getAvailablePlugins = function (type, callback) {
//     Pachno.Helpers.fetch($('#main_container').data('url'), {
//         method: 'GET',
//         params: '&say=get_'+type,
//         loading: {
//             indicator: '#available_'+type+'_loading_indicator'
//         },
//         success: {
//             update: '#available_'+type+'_container',
//             callback: function () {
//                 $('body').on('click', '.install-button', callback);
//             }
//         }
//     });
// };
//
// Pachno.Core.installPlugin = function (button, type) {
//     button = $(button);
//     button.addClass('installing');
//     button.prop('disabled', true);
//     Pachno.Helpers.fetch($('#main_container').data('url'), {
//         method: 'POST',
//         params: '&say=install-'+type+'&'+type+'_key='+button.data('key'),
//         success: {
//             callback: function (json) {
//                 if (json.installed) {
//                     $('#online-'+type+'-' + json[type+'_key']).addClass('installed');
//                     $('#installed-'+type+'s-list').append(json[type]);
//                 }
//             }
//         },
//         failure: {
//             callback: function () {
//                 button.removeClass('installing');
//                 button.prop('disabled', false);
//             }
//         }
//     });
// };
//
// Pachno.Modules.getModuleUpdates = function () {
//     Pachno.Core.getPluginUpdates('module');
// };
//
// Pachno.Modules.getAvailableOnline = function () {
//     Pachno.Core.getAvailablePlugins('modules', Pachno.Modules.install);
// };
//
// Pachno.Modules.install = function (event) {
//     Pachno.Core.installPlugin(this, 'module');
// };
//
// Pachno.Themes.getThemeUpdates = function () {
//     Pachno.Core.getPluginUpdates('theme');
// };
//
// Pachno.Themes.getAvailableOnline = function () {
//     Pachno.Core.getAvailablePlugins('themes', Pachno.Themes.install);
// };
//
// Pachno.Themes.install = function (event) {
//     Pachno.Core.installPlugin(this, 'theme');
// };

/***/ }),

/***/ "./js/tools/tools.js":
/*!***************************!*\
  !*** ./js/tools/tools.js ***!
  \***************************/
/*! exports provided: is_string, get_current_timestamp, clearFormSubmit, debounce */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "is_string", function() { return is_string; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "get_current_timestamp", function() { return get_current_timestamp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "clearFormSubmit", function() { return clearFormSubmit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "debounce", function() { return debounce; });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);

var is_string = function is_string(element) {
  return typeof element == 'string';
};
var get_current_timestamp = function get_current_timestamp() {
  return Math.round(Date.now() / 1000);
};
var clearFormSubmit = function clearFormSubmit($form) {
  if ($form !== undefined) {
    $form.removeClass('submitting');
    $form.find('button[type=submit].auto-disabled').each(function () {
      var $button = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
      $button.prop("disabled", false);
      $button.removeClass('auto-disabled');
    });
  }
};
var debounce = function debounce(func, wait, immediate) {
  var timeout;
  return function () {
    var context = this,
        args = arguments;

    var later = function later() {
      timeout = null;
      if (!immediate) func.apply(context, args);
    };

    var callNow = immediate && !timeout;
    clearTimeout(timeout);
    timeout = setTimeout(later, wait);
    if (callNow) func.apply(context, args);
  };
};

/***/ }),

/***/ "./js/widgets/dynamic-menu.js":
/*!************************************!*\
  !*** ./js/widgets/dynamic-menu.js ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _classes_pachno__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../classes/pachno */ "./js/classes/pachno.js");



var loadDynamicMenu = function loadDynamicMenu($menu) {
  if ($menu.hasClass('populate-once') && $menu.data('is-loaded')) {
    return;
  }

  var url = $menu.data('menu-url');
  _classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].fetch(url, {
    method: 'GET',
    success: {
      callback: function callback(json) {
        $menu.replaceWith(json.menu);
      }
    }
  });
};

var setupListeners = function setupListeners() {
  jquery__WEBPACK_IMPORTED_MODULE_0___default()("body").on("click", ".dynamic_menu_link", function (e) {
    var $menu = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).next();

    if (!$menu.length) {
      $menu = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).parent().next();
    }

    if ($menu.length && $menu.hasClass('dynamic_menu')) {
      loadDynamicMenu($menu);
    }
  });
};

/* harmony default export */ __webpack_exports__["default"] = (setupListeners);

/***/ }),

/***/ "./js/widgets/dynamic-toggle.js":
/*!**************************************!*\
  !*** ./js/widgets/dynamic-toggle.js ***!
  \**************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_fetch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/fetch */ "./js/helpers/fetch.js");



var setupListeners = function setupListeners() {
  jquery__WEBPACK_IMPORTED_MODULE_0___default()("body").on("click", ".dynamic-toggle", function (event) {
    event.preventDefault();
    var $item = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
    $item.addClass('submitting');
    Object(_helpers_fetch__WEBPACK_IMPORTED_MODULE_1__["fetchHelper"])($item.data('url'), {
      method: 'POST'
    }).then(function (json) {
      $item.removeClass('submitting');
      $item.prop('checked', json.value == 1);
    })["catch"](function (error) {
      console.error(error);
      $item.removeClass('submitting');
    });
  });
};

/* harmony default export */ __webpack_exports__["default"] = (setupListeners);

/***/ }),

/***/ "./js/widgets/editor.js":
/*!******************************!*\
  !*** ./js/widgets/editor.js ***!
  \******************************/
/*! exports provided: getEditor, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getEditor", function() { return getEditor; });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _classes_pachno__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../classes/pachno */ "./js/classes/pachno.js");
/* harmony import */ var _editorjs_editorjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @editorjs/editorjs */ "./node_modules/@editorjs/editorjs/dist/editor.js");
/* harmony import */ var _editorjs_editorjs__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_editorjs_editorjs__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _editorjs_header__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @editorjs/header */ "./node_modules/@editorjs/header/dist/bundle.js");
/* harmony import */ var _editorjs_header__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_editorjs_header__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _editorjs_list__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @editorjs/list */ "./node_modules/@editorjs/list/dist/bundle.js");
/* harmony import */ var _editorjs_list__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_editorjs_list__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _editorjs_link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @editorjs/link */ "./node_modules/@editorjs/link/dist/bundle.js");
/* harmony import */ var _editorjs_link__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_editorjs_link__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _editorjs_checklist__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @editorjs/checklist */ "./node_modules/@editorjs/checklist/dist/bundle.js");
/* harmony import */ var _editorjs_checklist__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_editorjs_checklist__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _editorjs_quote__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @editorjs/quote */ "./node_modules/@editorjs/quote/dist/bundle.js");
/* harmony import */ var _editorjs_quote__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_editorjs_quote__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _editorjs_code__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @editorjs/code */ "./node_modules/@editorjs/code/dist/bundle.js");
/* harmony import */ var _editorjs_code__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_editorjs_code__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _editorjs_table__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @editorjs/table */ "./node_modules/@editorjs/table/dist/bundle.js");
/* harmony import */ var _editorjs_table__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_editorjs_table__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _editorjs_warning__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @editorjs/warning */ "./node_modules/@editorjs/warning/dist/bundle.js");
/* harmony import */ var _editorjs_warning__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_editorjs_warning__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _editorjs_inline_code__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @editorjs/inline-code */ "./node_modules/@editorjs/inline-code/dist/bundle.js");
/* harmony import */ var _editorjs_inline_code__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_editorjs_inline_code__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _editorjs_delimiter__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @editorjs/delimiter */ "./node_modules/@editorjs/delimiter/dist/bundle.js");
/* harmony import */ var _editorjs_delimiter__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_editorjs_delimiter__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var easymde__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! easymde */ "./node_modules/easymde/src/js/easymde.js");
/* harmony import */ var easymde__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(easymde__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./index */ "./js/widgets/index.js");















var editors = {};

var initializeEditorJsArea = function initializeEditorJsArea() {
  var $editor_element = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
  var editor_element = $editor_element[0];

  if ($editor_element.data('processed')) {
    return;
  }

  $editor_element.data('processed', true);
  var $form = $editor_element.parents('form');
  var form_id = $form.attr('id');
  var content_html = $editor_element.html();
  $editor_element.html('');
  $editor_element.addClass('active');
  var content;

  try {
    content = content_html != '' ? JSON.parse(content_html) : {};
  } catch (error) {
    console.error('Error parsing existing content:', content_html);
    content = {};
  }

  var input_name = $editor_element.data('input-name');
  var $buttons = $form.find(".enable-on-editor-ready");
  var editor = new _editorjs_editorjs__WEBPACK_IMPORTED_MODULE_2___default.a({
    holder: editor_element,
    autofocus: false,
    data: content,
    placeholder: $editor_element.data('placeholder'),
    tools: {
      header: _editorjs_header__WEBPACK_IMPORTED_MODULE_3___default.a,
      link: _editorjs_link__WEBPACK_IMPORTED_MODULE_5___default.a,
      inlineCode: _editorjs_inline_code__WEBPACK_IMPORTED_MODULE_11___default.a,
      delimiter: _editorjs_delimiter__WEBPACK_IMPORTED_MODULE_12___default.a,
      warning: {
        "class": _editorjs_warning__WEBPACK_IMPORTED_MODULE_10___default.a,
        inlineToolbar: true,
        config: {
          titlePlaceholder: $editor_element.data('warning-title-placeholder'),
          messagePlaceholder: $editor_element.data('warning-message-placeholder')
        }
      },
      checklist: {
        "class": _editorjs_checklist__WEBPACK_IMPORTED_MODULE_6___default.a,
        inlineToolbar: true
      },
      list: {
        "class": _editorjs_list__WEBPACK_IMPORTED_MODULE_4___default.a,
        inlineToolbar: true
      },
      code: {
        "class": _editorjs_code__WEBPACK_IMPORTED_MODULE_8___default.a,
        inlineToolbar: false
      },
      table: {
        "class": _editorjs_table__WEBPACK_IMPORTED_MODULE_9___default.a,
        inlineToolbar: true
      },
      quote: {
        "class": _editorjs_quote__WEBPACK_IMPORTED_MODULE_7___default.a,
        inlineToolbar: true,
        config: {
          quotePlaceholder: $editor_element.data('quote-placeholder'),
          captionPlaceholder: $editor_element.data('quote-caption-placeholder')
        }
      }
    }
  });
  editor.isReady.then(function () {
    $buttons.removeProp('disabled');
    editors[$editor_element.attr('id')] = editor;
    _classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].on(_classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].EVENTS.formSubmit, function (PachnoApplication, data) {
      return new Promise(function (resolve) {
        if (data.form_id != form_id) {
          return resolve();
        }

        editor.save().then(function (data) {
          resolve({
            form_data: {
              input_name: input_name,
              data: data
            }
          });
        });
      });
    });
  });
};

var initializeEasyMde = function initializeEasyMde() {
  var $editor_element = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
  var editor_element = $editor_element[0];

  if ($editor_element.data('processed')) {
    return;
  }

  $editor_element.data('processed', true);
  var editor = new easymde__WEBPACK_IMPORTED_MODULE_13___default.a({
    element: editor_element,
    forceSync: true,
    status: [{
      className: "statustext",
      defaultValue: function defaultValue(el) {
        el.innerHTML = $editor_element.data('status-text');
      }
    }, {
      className: "markdown-help",
      defaultValue: function defaultValue(el) {
        el.innerHTML = "<a href='https://guides.github.com/features/mastering-markdown/' target='_blank'><i class='fab fa-markdown'></i></a>";
      }
    }],
    uploadImage: true,
    imageUploadEndpoint: $editor_element.data('upload-url'),
    toolbar: ["heading", "bold", "italic", "|", "unordered-list", "ordered-list", "|", "quote", "code", "link", "|", "image"]
  });
  editors[$editor_element.attr('id')] = editor;
};
/**
 *
 * @param editor
 * @returns {EasyMDE}
 */


var getEditor = function getEditor(editor) {
  return editors[editor];
};

var setupListeners = function setupListeners() {
  _classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].on(_classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].EVENTS.ready, function () {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()('.wysiwyg-editor:not([data-processed])').each(initializeEditorJsArea);
    jquery__WEBPACK_IMPORTED_MODULE_0___default()('.markuppable:not([data-processed])').each(initializeEasyMde);
  });
  _classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].on(_index__WEBPACK_IMPORTED_MODULE_14__["EVENTS"].update, function () {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()('.markuppable:not([data-processed])').each(initializeEasyMde);
  });
};

/* harmony default export */ __webpack_exports__["default"] = (setupListeners);

/***/ }),

/***/ "./js/widgets/fancydropdown.js":
/*!*************************************!*\
  !*** ./js/widgets/fancydropdown.js ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function(jQuery) {/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _classes_pachno__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../classes/pachno */ "./js/classes/pachno.js");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./index */ "./js/widgets/index.js");




var updateFancyDropdownLabel = function updateFancyDropdownLabel($dropdown) {
  var $label = $dropdown.find('> .value');

  if ($label.length > 0) {
    var auto_close = false;
    var values = [];
    $dropdown.find('input[type=checkbox],input[type=radio]').each(function () {
      var $input = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);

      if ($input.attr('type') == 'radio') {
        auto_close = true;
      }

      if ($input.is(':checked')) {
        var _$label = jquery__WEBPACK_IMPORTED_MODULE_0___default()($input.next('label'));

        var $value = jquery__WEBPACK_IMPORTED_MODULE_0___default()(_$label.find('.value').first());

        if ($value.text() != '') {
          values.push($value.text());
        } else {
          console.error('Could not find a .value for item', $input);
        }
      }
    });

    if (values.length > 0) {
      $dropdown.removeClass('no-value');
      $label.html(values.join(', '));
    } else {
      $dropdown.addClass('no-value');
      $label.html($dropdown.data('default-label'));
    }

    if (auto_close) {
      $dropdown.removeClass('active');
    }
  }
};

var updateFancyDropdownValues = function updateFancyDropdownValues(event) {
  event.stopPropagation();
  event.stopImmediatePropagation();
  event.preventDefault();
  var $dropdown = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).closest('.fancy-dropdown');
  updateFancyDropdownLabel($dropdown);
};

var updateFancyDropdowns = function updateFancyDropdowns() {
  jquery__WEBPACK_IMPORTED_MODULE_0___default()('.fancy-dropdown').each(function () {
    updateFancyDropdownLabel(jquery__WEBPACK_IMPORTED_MODULE_0___default()(this));
  });
};

var toggleFancyDropdown = function toggleFancyDropdown(event) {
  var $dropdown = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
  var is_visible = $dropdown.hasClass('active');
  Object(_index__WEBPACK_IMPORTED_MODULE_2__["clearPopupsAndButtons"])(event);

  if (!is_visible) {
    $dropdown.toggleClass('active');
  }

  event.stopPropagation();
};

var filterFilterOptionsElement = function filterFilterOptionsElement(element) {
  var filtervalue = element.val().toLowerCase(),
      $filterContainer = jquery__WEBPACK_IMPORTED_MODULE_0___default()(element.closest('.filter-container').siblings('.filter-values-container'));

  if (filtervalue !== element.data('previousValue')) {
    if (filtervalue !== '') {
      $filterContainer.addClass('filtered');
    } else {
      $filterContainer.removeClass('filtered');
    }

    $filterContainer.find('.filtervalue').each(function () {
      var $filterElement = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
      if ($filterElement.hasClass('sticky')) return;

      if (filtervalue !== '') {
        if ($filterElement.text().toLowerCase().indexOf(filtervalue) !== -1 || $filterElement.hasClass('selected')) {
          $filterElement.addClass('visible');
        } else {
          $filterElement.removeClass('visible');
        }
      } else {
        $filterElement.addClass('visible');
      }

      $filterElement.removeClass('highlighted');
    });
    element.data('previousValue', filtervalue);
  }
};

var setupListeners = function setupListeners() {
  var $body = jquery__WEBPACK_IMPORTED_MODULE_0___default()('body');
  $body.on('change', '.fancy-dropdown input[type=checkbox]', updateFancyDropdownValues);
  $body.on('change', '.fancy-dropdown input[type=radio]', updateFancyDropdownValues);
  $body.on("click", ".fancy-dropdown", toggleFancyDropdown);
  $body.on("keyup", ".fancy-dropdown .filter-container input[type=search]", function (e) {
    var $filterInput = jQuery(this);
    $filterInput.data('previousValue', '');
    filterFilterOptionsElement($filterInput);
  });
  _classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].on(_index__WEBPACK_IMPORTED_MODULE_2__["EVENTS"].update, updateFancyDropdowns);
};

/* harmony default export */ __webpack_exports__["default"] = (setupListeners);
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./js/widgets/fancytaginput.js":
/*!*************************************!*\
  !*** ./js/widgets/fancytaginput.js ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _classes_pachno__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../classes/pachno */ "./js/classes/pachno.js");
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./index */ "./js/widgets/index.js");




var setupListeners = function setupListeners() {
  _classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].on(_index__WEBPACK_IMPORTED_MODULE_2__["EVENTS"].update, function () {
    jquery__WEBPACK_IMPORTED_MODULE_0___default()('.fancy-tag-input-container').each(function () {
      var $container = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
      var $input = jquery__WEBPACK_IMPORTED_MODULE_0___default()($container.find('input[type=text]')[0]);
      var values = $input.val().split(',');
      values.each(function (value) {
        var real_value = value.trim();
      });
    });
  });
};

/* harmony default export */ __webpack_exports__["default"] = (setupListeners);

/***/ }),

/***/ "./js/widgets/index.js":
/*!*****************************!*\
  !*** ./js/widgets/index.js ***!
  \*****************************/
/*! exports provided: EVENTS, default, calendars, clearPopupsAndButtons */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function(jQuery) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EVENTS", function() { return EVENTS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "calendars", function() { return calendars; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "clearPopupsAndButtons", function() { return clearPopupsAndButtons; });
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _fancydropdown__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./fancydropdown */ "./js/widgets/fancydropdown.js");
/* harmony import */ var _fancytaginput__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./fancytaginput */ "./js/widgets/fancytaginput.js");
/* harmony import */ var _editor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./editor */ "./js/widgets/editor.js");
/* harmony import */ var _dynamic_menu__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./dynamic-menu */ "./js/widgets/dynamic-menu.js");
/* harmony import */ var _dynamic_toggle__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./dynamic-toggle */ "./js/widgets/dynamic-toggle.js");
/* harmony import */ var _notifications__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./notifications */ "./js/widgets/notifications.js");
/* harmony import */ var _classes_pachno__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../classes/pachno */ "./js/classes/pachno.js");
/* harmony import */ var _helpers_fetch__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../helpers/fetch */ "./js/helpers/fetch.js");
/* harmony import */ var simplebar__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! simplebar */ "./node_modules/simplebar/dist/simplebar.esm.js");
/* harmony import */ var simplebar_dist_simplebar_css__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! simplebar/dist/simplebar.css */ "./node_modules/simplebar/dist/simplebar.css");
/* harmony import */ var simplebar_dist_simplebar_css__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(simplebar_dist_simplebar_css__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var air_datepicker_dist_js_datepicker__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! air-datepicker/dist/js/datepicker */ "./node_modules/air-datepicker/dist/js/datepicker.js");
/* harmony import */ var air_datepicker_dist_js_datepicker__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(air_datepicker_dist_js_datepicker__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var air_datepicker_dist_js_i18n_datepicker_en__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! air-datepicker/dist/js/i18n/datepicker.en */ "./node_modules/air-datepicker/dist/js/i18n/datepicker.en.js");
/* harmony import */ var air_datepicker_dist_js_i18n_datepicker_en__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(air_datepicker_dist_js_i18n_datepicker_en__WEBPACK_IMPORTED_MODULE_12__);













var EVENTS = {
  update: 'widgets-update'
};
var calendars = {};

var updateWidgets = function updateWidgets() {
  return new Promise(function (resolve, reject) {
    var self = this;
    jquery__WEBPACK_IMPORTED_MODULE_0___default()("img[data-src]:not([data-src-processed])").each(function () {
      var $img = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
      $img.attr('src', $img.data('src')).data('src-processed', true);
    });
    jquery__WEBPACK_IMPORTED_MODULE_0___default()('.auto-calendar:not([data-processed])').each(function () {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).datepicker({
        inline: true,
        language: 'en'
      });
      calendars[jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).attr('id')] = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).data('datepicker');
      jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).data('processed', true);
    });
    _classes_pachno__WEBPACK_IMPORTED_MODULE_7__["default"].trigger(EVENTS.update);
    resolve();
  });
};

var clearPopupsAndButtons = function clearPopupsAndButtons(event) {
  if (event !== undefined) {
    if (['INPUT'].indexOf(event.target.nodeName) !== -1) {
      return;
    }
  }

  jquery__WEBPACK_IMPORTED_MODULE_0___default()('.dropper.active').removeClass('active');
  jquery__WEBPACK_IMPORTED_MODULE_0___default()('.fancy-dropdown.active').removeClass('active');
};

var toggleExpander = function toggleExpander(event) {
  event.preventDefault();
  jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).closest('.expandable').toggleClass('expanded');
};

var toggleSidebar = function toggleSidebar(event) {
  event.stopPropagation();
  event.preventDefault();
  jquery__WEBPACK_IMPORTED_MODULE_0___default()(this).closest('.sidebar').toggleClass('collapsed');
};

var toggleDropper = function toggleDropper(e) {
  e.stopPropagation();
  e.preventDefault();

  var toggleDropdown = function toggleDropdown($element) {
    if ($element.data('target')) {
      jquery__WEBPACK_IMPORTED_MODULE_0___default()($element.data('target')).toggleClass('force-active');
    } else {
      $element.toggleClass("active");
    }
  };

  var $element = jquery__WEBPACK_IMPORTED_MODULE_0___default()(this);
  var is_visible = $element.hasClass('active');
  clearPopupsAndButtons();

  if (!is_visible) {
    toggleDropdown($element);
  }
};

var setupListeners = function setupListeners() {
  Object(_dynamic_menu__WEBPACK_IMPORTED_MODULE_4__["default"])();
  Object(_dynamic_toggle__WEBPACK_IMPORTED_MODULE_5__["default"])();
  Object(_editor__WEBPACK_IMPORTED_MODULE_3__["default"])();
  Object(_fancydropdown__WEBPACK_IMPORTED_MODULE_1__["default"])();
  Object(_fancytaginput__WEBPACK_IMPORTED_MODULE_2__["default"])();
  Object(_notifications__WEBPACK_IMPORTED_MODULE_6__["default"])();
  var $body = jquery__WEBPACK_IMPORTED_MODULE_0___default()('body');
  $body.on('click', '.expandable .expander', toggleExpander);
  $body.on('click', '.sidebar .collapser a', toggleSidebar);
  $body.on('click', '.dropper', toggleDropper);
  $body.on("click", function (e) {
    if (['INPUT'].indexOf(e.target.nodeName) !== -1) {
      return;
    } else if (e.target && jquery__WEBPACK_IMPORTED_MODULE_0___default()(e.target).parents('.popup_box').length) {
      return;
    } else if (e.target && typeof e.target.hasAttribute == 'function' && e.target.hasAttribute('onclick')) {
      return;
    } else if (e.target && typeof e.target.hasAttribute == 'function' && e.target.hasAttribute('onclick')) {
      return;
    }

    clearPopupsAndButtons();
    if (e.target && jQuery(e.target).parents('#searchfor_autocomplete_choices').length > 0) return; // if (Pachno.autocompleter !== undefined) {
    //     Pachno.autocompleter.options.forceHide();
    // }

    e.stopPropagation();
  });
  _classes_pachno__WEBPACK_IMPORTED_MODULE_7__["default"].on(_helpers_fetch__WEBPACK_IMPORTED_MODULE_8__["EVENTS"].updated, updateWidgets);
  _classes_pachno__WEBPACK_IMPORTED_MODULE_7__["default"].on(_classes_pachno__WEBPACK_IMPORTED_MODULE_7__["default"].EVENTS.ready, updateWidgets);
};

/* harmony default export */ __webpack_exports__["default"] = (setupListeners);

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")))

/***/ }),

/***/ "./js/widgets/notifications.js":
/*!*************************************!*\
  !*** ./js/widgets/notifications.js ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
/* harmony import */ var jquery__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jquery__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _classes_pachno__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../classes/pachno */ "./js/classes/pachno.js");



var loadMoreNotifications = function loadMoreNotifications(event, _loadToTop) {
  var loadToTop = _loadToTop || false;

  if (Main.Notifications.loadingLocked !== true || loadToTop) {
    if (!loadToTop) Main.Notifications.loadingLocked = true;
    var unl = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#user_notifications_list'),
        unl_data = unl.dataset;

    if (unl) {
      if (loadToTop && unl.find('li').length) {
        var url = unl_data.notificationsUrl + '&first_notification_id=' + unl.find('li:not(.disabled)')[0].data('notification-id');
      } else if (!loadToTop && unl.find("li:not(.disabled):last-child") != undefined && unl.find("li:not(.disabled):last-child")[0] != undefined) {
        var url = unl_data.notificationsUrl + '&last_notification_id=' + unl.find("li:not(.disabled):last-child")[0].data('notification-id');
      }

      if (url != undefined) {
        _classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].fetch(url, {
          method: 'GET',
          loading: {
            indicator: '#user_notifications_loading_indicator'
          },
          success: {
            update: {
              element: '',
              insertion: true
            },
            callback: function callback(json) {
              if (loadToTop) {
                if (jquery__WEBPACK_IMPORTED_MODULE_0___default()('.faded_out', unl).length) {
                  unl.html(json.content);
                } else {
                  unl.prepend(json.content);
                }
              } else {
                if (jquery__WEBPACK_IMPORTED_MODULE_0___default()('.faded_out', unl).length) {
                  unl.html(json.content);
                } else {
                  unl.append(json.content);
                }
              }

              if (jquery__WEBPACK_IMPORTED_MODULE_0___default()('#user_notifications_list_wrapper_nano')) jquery__WEBPACK_IMPORTED_MODULE_0___default()("#user_notifications_list_wrapper_nano").nanoScroller();
              if (!loadToTop) Main.Notifications.loadingLocked = false;
            }
          },
          exception: {
            callback: function callback() {
              if (!loadToTop) Main.Notifications.loadingLocked = false;
            }
          }
        });
      }
    }
  }
};

var loadNotifications = function loadNotifications() {
  if (jquery__WEBPACK_IMPORTED_MODULE_0___default()('#user_notifications_list').children().length == 0) {
    _classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].fetch(jquery__WEBPACK_IMPORTED_MODULE_0___default()('#user_notifications_list').data('notifications-url'), {
      method: 'GET',
      loading: {
        indicator: '#user_notifications_loading_indicator'
      },
      success: {
        update: '#user_notifications_list',
        callback: function callback() {
          jquery__WEBPACK_IMPORTED_MODULE_0___default()('#user_notifications_list_wrapper_nano').on('scrollend', loadMoreNotifications);
        }
      }
    });
  }
};

var toggleNotifications = function toggleNotifications(toggle_classes) {
  var $user_notifications = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#user_notifications');
  var $user_notifications_container = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#user_notifications_container');

  if (!$user_notifications.length || !$user_notifications_container.length) {
    return false;
  }

  if (toggle_classes == null) toggle_classes = true;
  if (toggle_classes) $user_notifications_container.toggleClass('active');

  if ($user_notifications.hasClass('active')) {
    $user_notifications.removeClass('active');
  } else {
    if (toggle_classes) $user_notifications.addClass('active');
    loadNotifications();
  }
};

var setupListeners = function setupListeners() {
  jquery__WEBPACK_IMPORTED_MODULE_0___default()("body").on("click", "#user_notifications_container", toggleNotifications);
  _classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].fetch(_classes_pachno__WEBPACK_IMPORTED_MODULE_1__["default"].data_url, {
    method: 'GET',
    success: {
      callback: function callback(json) {
        var $user_notifications_count = jquery__WEBPACK_IMPORTED_MODULE_0___default()('#user_notifications_count');

        if ($user_notifications_count.length) {
          $user_notifications_count.html(json.unread_notifications_count);

          if (parseInt(json.unread_notifications_count) > 0) {
            $user_notifications_count.addClass('unread');
          }
        }
      }
    }
  });
}; // Pachno.Main.Notifications.Web.GrantPermissionOrSendTest = function (title, body, icon) {
//     if (!Notify.needsPermission) {
//         Pachno.Main.Notifications.Web.Send(title, body, 'test', icon);
//     } else if (Notify.isSupported()) {
//         Notify.requestPermission();
//     }
// }
//
// Pachno.Main.Notifications.Web.Send = function (title, body, tag, icon, click_callback) {
//     if (Notify.needsPermission) return;
//
//     new Notify(title, {
//         body: body,
//         tag: tag,
//         icon: icon,
//         timeout: 8,
//         closeOnClick: true,
//         notifyClick: click_callback
//     }).show();
// }
//


/* harmony default export */ __webpack_exports__["default"] = (setupListeners);

/***/ }),

/***/ "./node_modules/@editorjs/checklist/dist/bundle.js":
/*!*********************************************************!*\
  !*** ./node_modules/@editorjs/checklist/dist/bundle.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

!function(e,t){ true?module.exports=t():undefined}(window,function(){return function(e){var t={};function n(r){if(t[r])return t[r].exports;var i=t[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,n),i.l=!0,i.exports}return n.m=e,n.c=t,n.d=function(e,t,r){n.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:r})},n.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},n.t=function(e,t){if(1&t&&(e=n(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var i in e)n.d(r,i,function(t){return e[t]}.bind(null,i));return r},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,"a",t),t},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.p="/",n(n.s=0)}([function(e,t,n){function r(e){return function(e){if(Array.isArray(e)){for(var t=0,n=new Array(e.length);t<e.length;t++)n[t]=e[t];return n}}(e)||function(e){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e))return Array.from(e)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()}function i(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}function o(e,t,n){return t&&i(e.prototype,t),n&&i(e,n),e}n(1).toString(),n(6);var s=function(){function e(t){var n=t.data,r=(t.config,t.api),i=t.readOnly;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this._elements={wrapper:null,items:[]},this.readOnly=i,this._data={items:[]},this.api=r,this.data=n}return o(e,null,[{key:"isReadOnlySupported",get:function(){return!0}},{key:"enableLineBreaks",get:function(){return!0}},{key:"toolbox",get:function(){return{icon:'<svg width="15" height="15" viewBox="0 0 15 15" xmlns="http://www.w3.org/2000/svg"><path d="M7.5 15a7.5 7.5 0 1 1 0-15 7.5 7.5 0 0 1 0 15zm0-2.394a5.106 5.106 0 1 0 0-10.212 5.106 5.106 0 0 0 0 10.212zm-.675-4.665l2.708-2.708 1.392 1.392-2.708 2.708-1.392 1.391-2.971-2.971L5.245 6.36l1.58 1.58z"/></svg>',title:"Checklist"}}}]),o(e,[{key:"render",value:function(){var e=this;if(this._elements.wrapper=this._make("div",[this.CSS.baseBlock,this.CSS.wrapper]),this._data.items.length)this._data.items.forEach(function(t){var n=e.createChecklistItem(t);e._elements.items.push(n),e._elements.wrapper.appendChild(n)});else{var t=this.createChecklistItem();this._elements.items.push(t),this._elements.wrapper.appendChild(t)}return this.readOnly?this._elements.wrapper:(this._elements.wrapper.addEventListener("keydown",function(t){switch(t.keyCode){case 13:e.appendNewElement(t);break;case 8:e.backspace(t)}},!1),this._elements.wrapper.addEventListener("click",function(t){e.toggleCheckbox(t)}),this._elements.wrapper)}},{key:"validate",value:function(e){return!!e.items.length}},{key:"toggleCheckbox",value:function(e){var t=e.target.closest(".".concat(this.CSS.item));t.querySelector(".".concat(this.CSS.checkbox)).contains(e.target)&&t.classList.toggle(this.CSS.itemChecked)}},{key:"createChecklistItem",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},t=this._make("div",this.CSS.item),n=this._make("span",this.CSS.checkbox),r=this._make("div",this.CSS.textField,{innerHTML:e.text?e.text:"",contentEditable:!this.readOnly});return e.checked&&t.classList.add(this.CSS.itemChecked),t.appendChild(n),t.appendChild(r),t}},{key:"appendNewElement",value:function(e){e.preventDefault();var t=window.getSelection().anchorNode,n=this._elements.items[this._elements.items.length-1].querySelector(".".concat(this.CSS.textField)),r=n.innerHTML.replace("<br>"," ").trim();if(t===n&&!r)return this.api.blocks.insertNewBlock(),void e.stopPropagation();var i=this.createChecklistItem(),o=t.parentNode.closest(".".concat(this.CSS.item));this._elements.wrapper.insertBefore(i,o.nextSibling);var s=this._elements.items.indexOf(o)+1;this._elements.items.splice(s,0,i),this.moveCaretToEnd(i.querySelector(".".concat(this.CSS.textField)))}},{key:"backspace",value:function(e){var t=e.target.closest(".".concat(this.CSS.item)),n=this._elements.items.indexOf(t),r=t.querySelector(".".concat(this.CSS.textField)).innerHTML.replace("<br>"," ").trim();this._elements.items[0].querySelector(".".concat(this.CSS.textField)).innerHTML.replace("<br>"," ").trim()&&n&&!r&&(e.preventDefault(),t.remove(),this._elements.items.splice(n,1),"undefined"!==this._elements.items[n-1]&&this.moveCaretToEnd(this._elements.items[n-1].querySelector(".".concat(this.CSS.textField))))}},{key:"save",value:function(){return this.data}},{key:"_make",value:function(e){var t,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o=document.createElement(e);Array.isArray(n)?(t=o.classList).add.apply(t,r(n)):n&&o.classList.add(n);for(var s in i)o[s]=i[s];return o}},{key:"moveCaretToEnd",value:function(e){var t=document.createRange(),n=window.getSelection();t.selectNodeContents(e),t.collapse(!1),n.removeAllRanges(),n.addRange(t)}},{key:"CSS",get:function(){return{baseBlock:this.api.styles.block,wrapper:"cdx-checklist",item:"cdx-checklist__item",itemChecked:"cdx-checklist__item--checked",checkbox:"cdx-checklist__item-checkbox",textField:"cdx-checklist__item-text"}}},{key:"data",set:function(e){this._data.items=e.items||[];var t=this._elements.wrapper;t&&t.parentNode.replaceChild(this.render(),t)},get:function(){this._data.items=[];for(var e=0;e<this._elements.items.length;e++){var t=this._elements.items[e].querySelector(".".concat(this.CSS.textField)).innerHTML.replace("<br>"," ").trim();t&&this._data.items.push({text:t,checked:this._elements.items[e].classList.contains(this.CSS.itemChecked)})}return this._data}}]),e}();e.exports=s},function(e,t,n){var r=n(2);"string"==typeof r&&(r=[[e.i,r,""]]);var i={hmr:!0,transform:void 0,insertInto:void 0};n(4)(r,i);r.locals&&(e.exports=r.locals)},function(e,t,n){(e.exports=n(3)(!1)).push([e.i,".cdx-checklist__item {\n        display: flex;\n        padding: 0 10px;\n        box-sizing: content-box;\n    }\n\n        .cdx-checklist__item-text {\n            outline: none;\n            flex-grow: 1;\n            padding: 10px 0;\n        }\n\n        .cdx-checklist__item-checkbox {\n            display: inline-block;\n            flex-shrink: 0;\n            position: relative;\n            width: 20px;\n            height: 20px;\n            margin: 10px 10px 10px 0;\n            border-radius: 50%;\n            border: 1px solid #d0d0d0;\n            background: #fff;\n            cursor: pointer;\n            user-select: none;\n        }\n\n        .cdx-checklist__item-checkbox:hover {\n                border-color: #b5b5b5;\n            }\n\n        .cdx-checklist__item-checkbox::after {\n                position: absolute;\n                top: 5px;\n                left: 5px;\n                width: 8px;\n                height: 5px;\n                border: 2px solid #fcfff4;\n                border-top: none;\n                border-right: none;\n                background: transparent;\n                content: '';\n                opacity: 0;\n                transform: rotate(-45deg);\n            }\n\n        .cdx-checklist__item--checked .cdx-checklist__item-checkbox {\n                background: #388ae5;\n                border-color: #388ae5;\n            }\n\n        .cdx-checklist__item--checked .cdx-checklist__item-checkbox:hover {\n                    background: #307cd1;\n                }\n\n        .cdx-checklist__item--checked .cdx-checklist__item-checkbox::after {\n                    opacity: 1;\n                }\n",""])},function(e,t){e.exports=function(e){var t=[];return t.toString=function(){return this.map(function(t){var n=function(e,t){var n=e[1]||"",r=e[3];if(!r)return n;if(t&&"function"==typeof btoa){var i=(s=r,"/*# sourceMappingURL=data:application/json;charset=utf-8;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(s))))+" */"),o=r.sources.map(function(e){return"/*# sourceURL="+r.sourceRoot+e+" */"});return[n].concat(o).concat([i]).join("\n")}var s;return[n].join("\n")}(t,e);return t[2]?"@media "+t[2]+"{"+n+"}":n}).join("")},t.i=function(e,n){"string"==typeof e&&(e=[[null,e,""]]);for(var r={},i=0;i<this.length;i++){var o=this[i][0];"number"==typeof o&&(r[o]=!0)}for(i=0;i<e.length;i++){var s=e[i];"number"==typeof s[0]&&r[s[0]]||(n&&!s[2]?s[2]=n:n&&(s[2]="("+s[2]+") and ("+n+")"),t.push(s))}},t}},function(e,t,n){var r,i,o={},s=(r=function(){return window&&document&&document.all&&!window.atob},function(){return void 0===i&&(i=r.apply(this,arguments)),i}),c=function(e){var t={};return function(e){if("function"==typeof e)return e();if(void 0===t[e]){var n=function(e){return document.querySelector(e)}.call(this,e);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(e){n=null}t[e]=n}return t[e]}}(),a=null,l=0,u=[],d=n(5);function f(e,t){for(var n=0;n<e.length;n++){var r=e[n],i=o[r.id];if(i){i.refs++;for(var s=0;s<i.parts.length;s++)i.parts[s](r.parts[s]);for(;s<r.parts.length;s++)i.parts.push(y(r.parts[s],t))}else{var c=[];for(s=0;s<r.parts.length;s++)c.push(y(r.parts[s],t));o[r.id]={id:r.id,refs:1,parts:c}}}}function p(e,t){for(var n=[],r={},i=0;i<e.length;i++){var o=e[i],s=t.base?o[0]+t.base:o[0],c={css:o[1],media:o[2],sourceMap:o[3]};r[s]?r[s].parts.push(c):n.push(r[s]={id:s,parts:[c]})}return n}function h(e,t){var n=c(e.insertInto);if(!n)throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");var r=u[u.length-1];if("top"===e.insertAt)r?r.nextSibling?n.insertBefore(t,r.nextSibling):n.appendChild(t):n.insertBefore(t,n.firstChild),u.push(t);else if("bottom"===e.insertAt)n.appendChild(t);else{if("object"!=typeof e.insertAt||!e.insertAt.before)throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");var i=c(e.insertInto+" "+e.insertAt.before);n.insertBefore(t,i)}}function m(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e);var t=u.indexOf(e);t>=0&&u.splice(t,1)}function v(e){var t=document.createElement("style");return void 0===e.attrs.type&&(e.attrs.type="text/css"),b(t,e.attrs),h(e,t),t}function b(e,t){Object.keys(t).forEach(function(n){e.setAttribute(n,t[n])})}function y(e,t){var n,r,i,o;if(t.transform&&e.css){if(!(o=t.transform(e.css)))return function(){};e.css=o}if(t.singleton){var s=l++;n=a||(a=v(t)),r=k.bind(null,n,s,!1),i=k.bind(null,n,s,!0)}else e.sourceMap&&"function"==typeof URL&&"function"==typeof URL.createObjectURL&&"function"==typeof URL.revokeObjectURL&&"function"==typeof Blob&&"function"==typeof btoa?(n=function(e){var t=document.createElement("link");return void 0===e.attrs.type&&(e.attrs.type="text/css"),e.attrs.rel="stylesheet",b(t,e.attrs),h(e,t),t}(t),r=function(e,t,n){var r=n.css,i=n.sourceMap,o=void 0===t.convertToAbsoluteUrls&&i;(t.convertToAbsoluteUrls||o)&&(r=d(r));i&&(r+="\n/*# sourceMappingURL=data:application/json;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(i))))+" */");var s=new Blob([r],{type:"text/css"}),c=e.href;e.href=URL.createObjectURL(s),c&&URL.revokeObjectURL(c)}.bind(null,n,t),i=function(){m(n),n.href&&URL.revokeObjectURL(n.href)}):(n=v(t),r=function(e,t){var n=t.css,r=t.media;r&&e.setAttribute("media",r);if(e.styleSheet)e.styleSheet.cssText=n;else{for(;e.firstChild;)e.removeChild(e.firstChild);e.appendChild(document.createTextNode(n))}}.bind(null,n),i=function(){m(n)});return r(e),function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap)return;r(e=t)}else i()}}e.exports=function(e,t){if("undefined"!=typeof DEBUG&&DEBUG&&"object"!=typeof document)throw new Error("The style-loader cannot be used in a non-browser environment");(t=t||{}).attrs="object"==typeof t.attrs?t.attrs:{},t.singleton||"boolean"==typeof t.singleton||(t.singleton=s()),t.insertInto||(t.insertInto="head"),t.insertAt||(t.insertAt="bottom");var n=p(e,t);return f(n,t),function(e){for(var r=[],i=0;i<n.length;i++){var s=n[i];(c=o[s.id]).refs--,r.push(c)}e&&f(p(e,t),t);for(i=0;i<r.length;i++){var c;if(0===(c=r[i]).refs){for(var a=0;a<c.parts.length;a++)c.parts[a]();delete o[c.id]}}}};var x,g=(x=[],function(e,t){return x[e]=t,x.filter(Boolean).join("\n")});function k(e,t,n,r){var i=n?"":r.css;if(e.styleSheet)e.styleSheet.cssText=g(t,i);else{var o=document.createTextNode(i),s=e.childNodes;s[t]&&e.removeChild(s[t]),s.length?e.insertBefore(o,s[t]):e.appendChild(o)}}},function(e,t){e.exports=function(e){var t="undefined"!=typeof window&&window.location;if(!t)throw new Error("fixUrls requires window.location");if(!e||"string"!=typeof e)return e;var n=t.protocol+"//"+t.host,r=n+t.pathname.replace(/\/[^\/]*$/,"/");return e.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi,function(e,t){var i,o=t.trim().replace(/^"(.*)"$/,function(e,t){return t}).replace(/^'(.*)'$/,function(e,t){return t});return/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/|\s*$)/i.test(o)?e:(i=0===o.indexOf("//")?o:0===o.indexOf("/")?n+o:r+o.replace(/^\.\//,""),"url("+JSON.stringify(i)+")")})}},function(e,t,n){"use strict";Element.prototype.matches||(Element.prototype.matches=Element.prototype.msMatchesSelector||Element.prototype.webkitMatchesSelector),Element.prototype.closest||(Element.prototype.closest=function(e){var t=this;if(!document.documentElement.contains(t))return null;do{if(t.matches(e))return t;t=t.parentElement||t.parentNode}while(null!==t&&1===t.nodeType);return null})}])});

/***/ }),

/***/ "./node_modules/@editorjs/code/dist/bundle.js":
/*!****************************************************!*\
  !*** ./node_modules/@editorjs/code/dist/bundle.js ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

!function(e,t){ true?module.exports=t():undefined}(window,(function(){return function(e){var t={};function n(r){if(t[r])return t[r].exports;var o=t[r]={i:r,l:!1,exports:{}};return e[r].call(o.exports,o,o.exports,n),o.l=!0,o.exports}return n.m=e,n.c=t,n.d=function(e,t,r){n.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:r})},n.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},n.t=function(e,t){if(1&t&&(e=n(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var o in e)n.d(r,o,function(t){return e[t]}.bind(null,o));return r},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,"a",t),t},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.p="/",n(n.s=0)}([function(e,t,n){function r(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}function o(e,t,n){return t&&r(e.prototype,t),n&&r(e,n),e}n(1).toString();
/**
 * CodeTool for Editor.js
 *
 * @author CodeX (team@ifmo.su)
 * @copyright CodeX 2018
 * @license MIT
 * @version 2.0.0
 */
var a=function(){function e(t){var n=t.data,r=t.config,o=t.api,a=t.readOnly;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.api=o,this.readOnly=a,this.placeholder=this.api.i18n.t(r.placeholder||e.DEFAULT_PLACEHOLDER),this.CSS={baseClass:this.api.styles.block,input:this.api.styles.input,wrapper:"ce-code",textarea:"ce-code__textarea"},this.nodes={holder:null,textarea:null},this.data={code:n.code||""},this.nodes.holder=this.drawView()}return o(e,null,[{key:"isReadOnlySupported",get:function(){return!0}},{key:"enableLineBreaks",get:function(){return!0}}]),o(e,[{key:"drawView",value:function(){var e=document.createElement("div"),t=document.createElement("textarea");return e.classList.add(this.CSS.baseClass,this.CSS.wrapper),t.classList.add(this.CSS.textarea,this.CSS.input),t.textContent=this.data.code,t.placeholder=this.placeholder,this.readOnly&&(t.disabled=!0),e.appendChild(t),this.nodes.textarea=t,e}},{key:"render",value:function(){return this.nodes.holder}},{key:"save",value:function(e){return{code:e.querySelector("textarea").value}}},{key:"onPaste",value:function(e){var t=e.detail.data;this.data={code:t.textContent}}},{key:"data",get:function(){return this._data},set:function(e){this._data=e,this.nodes.textarea&&(this.nodes.textarea.textContent=e.code)}}],[{key:"toolbox",get:function(){return{icon:'<svg width="14" height="14" viewBox="0 -1 14 14" xmlns="http://www.w3.org/2000/svg" > <path d="M3.177 6.852c.205.253.347.572.427.954.078.372.117.844.117 1.417 0 .418.01.725.03.92.02.18.057.314.107.396.046.075.093.117.14.134.075.027.218.056.42.083a.855.855 0 0 1 .56.297c.145.167.215.38.215.636 0 .612-.432.934-1.216.934-.457 0-.87-.087-1.233-.262a1.995 1.995 0 0 1-.853-.751 2.09 2.09 0 0 1-.305-1.097c-.014-.648-.029-1.168-.043-1.56-.013-.383-.034-.631-.06-.733-.064-.263-.158-.455-.276-.578a2.163 2.163 0 0 0-.505-.376c-.238-.134-.41-.256-.519-.371C.058 6.76 0 6.567 0 6.315c0-.37.166-.657.493-.846.329-.186.56-.342.693-.466a.942.942 0 0 0 .26-.447c.056-.2.088-.42.097-.658.01-.25.024-.85.043-1.802.015-.629.239-1.14.672-1.522C2.691.19 3.268 0 3.977 0c.783 0 1.216.317 1.216.921 0 .264-.069.48-.211.643a.858.858 0 0 1-.563.29c-.249.03-.417.076-.498.126-.062.04-.112.134-.139.291-.031.187-.052.562-.061 1.119a8.828 8.828 0 0 1-.112 1.378 2.24 2.24 0 0 1-.404.963c-.159.212-.373.406-.64.583.25.163.454.342.612.538zm7.34 0c.157-.196.362-.375.612-.538a2.544 2.544 0 0 1-.641-.583 2.24 2.24 0 0 1-.404-.963 8.828 8.828 0 0 1-.112-1.378c-.009-.557-.03-.932-.061-1.119-.027-.157-.077-.251-.14-.29-.08-.051-.248-.096-.496-.127a.858.858 0 0 1-.564-.29C8.57 1.401 8.5 1.185 8.5.921 8.5.317 8.933 0 9.716 0c.71 0 1.286.19 1.72.574.432.382.656.893.671 1.522.02.952.033 1.553.043 1.802.009.238.041.458.097.658a.942.942 0 0 0 .26.447c.133.124.364.28.693.466a.926.926 0 0 1 .493.846c0 .252-.058.446-.183.58-.109.115-.281.237-.52.371-.21.118-.377.244-.504.376-.118.123-.212.315-.277.578-.025.102-.045.35-.06.733-.013.392-.027.912-.042 1.56a2.09 2.09 0 0 1-.305 1.097c-.2.323-.486.574-.853.75a2.811 2.811 0 0 1-1.233.263c-.784 0-1.216-.322-1.216-.934 0-.256.07-.47.214-.636a.855.855 0 0 1 .562-.297c.201-.027.344-.056.418-.083.048-.017.096-.06.14-.134a.996.996 0 0 0 .107-.396c.02-.195.031-.502.031-.92 0-.573.039-1.045.117-1.417.08-.382.222-.701.427-.954z" /> </svg>',title:"Code"}}},{key:"DEFAULT_PLACEHOLDER",get:function(){return"Enter a code"}},{key:"pasteConfig",get:function(){return{tags:["pre"]}}},{key:"sanitize",get:function(){return{code:!0}}}]),e}();e.exports=a},function(e,t,n){var r=n(2),o=n(3);"string"==typeof(o=o.__esModule?o.default:o)&&(o=[[e.i,o,""]]);var a={insert:"head",singleton:!1};r(o,a);e.exports=o.locals||{}},function(e,t,n){"use strict";var r,o=function(){return void 0===r&&(r=Boolean(window&&document&&document.all&&!window.atob)),r},a=function(){var e={};return function(t){if(void 0===e[t]){var n=document.querySelector(t);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(e){n=null}e[t]=n}return e[t]}}(),i=[];function c(e){for(var t=-1,n=0;n<i.length;n++)if(i[n].identifier===e){t=n;break}return t}function u(e,t){for(var n={},r=[],o=0;o<e.length;o++){var a=e[o],u=t.base?a[0]+t.base:a[0],s=n[u]||0,l="".concat(u," ").concat(s);n[u]=s+1;var d=c(l),f={css:a[1],media:a[2],sourceMap:a[3]};-1!==d?(i[d].references++,i[d].updater(f)):i.push({identifier:l,updater:y(f,t),references:1}),r.push(l)}return r}function s(e){var t=document.createElement("style"),r=e.attributes||{};if(void 0===r.nonce){var o=n.nc;o&&(r.nonce=o)}if(Object.keys(r).forEach((function(e){t.setAttribute(e,r[e])})),"function"==typeof e.insert)e.insert(t);else{var i=a(e.insert||"head");if(!i)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");i.appendChild(t)}return t}var l,d=(l=[],function(e,t){return l[e]=t,l.filter(Boolean).join("\n")});function f(e,t,n,r){var o=n?"":r.media?"@media ".concat(r.media," {").concat(r.css,"}"):r.css;if(e.styleSheet)e.styleSheet.cssText=d(t,o);else{var a=document.createTextNode(o),i=e.childNodes;i[t]&&e.removeChild(i[t]),i.length?e.insertBefore(a,i[t]):e.appendChild(a)}}function p(e,t,n){var r=n.css,o=n.media,a=n.sourceMap;if(o?e.setAttribute("media",o):e.removeAttribute("media"),a&&btoa&&(r+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(a))))," */")),e.styleSheet)e.styleSheet.cssText=r;else{for(;e.firstChild;)e.removeChild(e.firstChild);e.appendChild(document.createTextNode(r))}}var h=null,v=0;function y(e,t){var n,r,o;if(t.singleton){var a=v++;n=h||(h=s(t)),r=f.bind(null,n,a,!1),o=f.bind(null,n,a,!0)}else n=s(t),r=p.bind(null,n,t),o=function(){!function(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e)}(n)};return r(e),function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap)return;r(e=t)}else o()}}e.exports=function(e,t){(t=t||{}).singleton||"boolean"==typeof t.singleton||(t.singleton=o());var n=u(e=e||[],t);return function(e){if(e=e||[],"[object Array]"===Object.prototype.toString.call(e)){for(var r=0;r<n.length;r++){var o=c(n[r]);i[o].references--}for(var a=u(e,t),s=0;s<n.length;s++){var l=c(n[s]);0===i[l].references&&(i[l].updater(),i.splice(l,1))}n=a}}}},function(e,t,n){(t=n(4)(!1)).push([e.i,".ce-code__textarea {\n    min-height: 200px;\n    font-family: Menlo, Monaco, Consolas, Courier New, monospace;\n    color: #41314e;\n    line-height: 1.6em;\n    font-size: 12px;\n    background: #f8f7fa;\n    border: 1px solid #f1f1f4;\n    box-shadow: none;\n    white-space: pre;\n    word-wrap: normal;\n    overflow-x: auto;\n    resize: vertical;\n}\n",""]),e.exports=t},function(e,t,n){"use strict";e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var n=function(e,t){var n=e[1]||"",r=e[3];if(!r)return n;if(t&&"function"==typeof btoa){var o=(i=r,c=btoa(unescape(encodeURIComponent(JSON.stringify(i)))),u="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(c),"/*# ".concat(u," */")),a=r.sources.map((function(e){return"/*# sourceURL=".concat(r.sourceRoot||"").concat(e," */")}));return[n].concat(a).concat([o]).join("\n")}var i,c,u;return[n].join("\n")}(t,e);return t[2]?"@media ".concat(t[2]," {").concat(n,"}"):n})).join("")},t.i=function(e,n,r){"string"==typeof e&&(e=[[null,e,""]]);var o={};if(r)for(var a=0;a<this.length;a++){var i=this[a][0];null!=i&&(o[i]=!0)}for(var c=0;c<e.length;c++){var u=[].concat(e[c]);r&&o[u[0]]||(n&&(u[2]?u[2]="".concat(n," and ").concat(u[2]):u[2]=n),t.push(u))}},t}}])}));

/***/ }),

/***/ "./node_modules/@editorjs/delimiter/dist/bundle.js":
/*!*********************************************************!*\
  !*** ./node_modules/@editorjs/delimiter/dist/bundle.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

!function(e,t){ true?module.exports=t():undefined}(window,function(){return function(e){var t={};function n(r){if(t[r])return t[r].exports;var o=t[r]={i:r,l:!1,exports:{}};return e[r].call(o.exports,o,o.exports,n),o.l=!0,o.exports}return n.m=e,n.c=t,n.d=function(e,t,r){n.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:r})},n.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},n.t=function(e,t){if(1&t&&(e=n(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var o in e)n.d(r,o,function(t){return e[t]}.bind(null,o));return r},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,"a",t),t},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.p="/",n(n.s=0)}([function(e,t,n){function r(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}function o(e,t,n){return t&&r(e.prototype,t),n&&r(e,n),e}n(1).toString();
/**
 * Delimiter Block for the Editor.js.
 *
 * @author CodeX (team@ifmo.su)
 * @copyright CodeX 2018
 * @license The MIT License (MIT)
 * @version 2.0.0
 */
var i=function(){function e(t){var n=t.data,r=(t.config,t.api);!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.api=r,this._CSS={block:this.api.styles.block,wrapper:"ce-delimiter"},this._data={},this._element=this.drawView(),this.data=n}return o(e,null,[{key:"isReadOnlySupported",get:function(){return!0}},{key:"contentless",get:function(){return!0}}]),o(e,[{key:"drawView",value:function(){var e=document.createElement("DIV");return e.classList.add(this._CSS.wrapper,this._CSS.block),e}},{key:"render",value:function(){return this._element}},{key:"save",value:function(e){return{}}}],[{key:"toolbox",get:function(){return{icon:'<svg width="19" height="4" viewBox="0 0 19 4" xmlns="http://www.w3.org/2000/svg"><path d="M1.25 0H7a1.25 1.25 0 1 1 0 2.5H1.25a1.25 1.25 0 1 1 0-2.5zM11 0h5.75a1.25 1.25 0 0 1 0 2.5H11A1.25 1.25 0 0 1 11 0z"/></svg>',title:"Delimiter"}}}]),e}();e.exports=i},function(e,t,n){var r=n(2);"string"==typeof r&&(r=[[e.i,r,""]]);var o={hmr:!0,transform:void 0,insertInto:void 0};n(4)(r,o);r.locals&&(e.exports=r.locals)},function(e,t,n){(e.exports=n(3)(!1)).push([e.i,'.ce-delimiter {\n    line-height: 1.6em;\n    width: 100%;\n    text-align: center;\n}\n\n.ce-delimiter:before {\n    display: inline-block;\n    content: "***";\n    font-size: 30px;\n    line-height: 65px;\n    height: 30px;\n    letter-spacing: 0.2em;\n}',""])},function(e,t){e.exports=function(e){var t=[];return t.toString=function(){return this.map(function(t){var n=function(e,t){var n=e[1]||"",r=e[3];if(!r)return n;if(t&&"function"==typeof btoa){var o=(a=r,"/*# sourceMappingURL=data:application/json;charset=utf-8;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(a))))+" */"),i=r.sources.map(function(e){return"/*# sourceURL="+r.sourceRoot+e+" */"});return[n].concat(i).concat([o]).join("\n")}var a;return[n].join("\n")}(t,e);return t[2]?"@media "+t[2]+"{"+n+"}":n}).join("")},t.i=function(e,n){"string"==typeof e&&(e=[[null,e,""]]);for(var r={},o=0;o<this.length;o++){var i=this[o][0];"number"==typeof i&&(r[i]=!0)}for(o=0;o<e.length;o++){var a=e[o];"number"==typeof a[0]&&r[a[0]]||(n&&!a[2]?a[2]=n:n&&(a[2]="("+a[2]+") and ("+n+")"),t.push(a))}},t}},function(e,t,n){var r,o,i={},a=(r=function(){return window&&document&&document.all&&!window.atob},function(){return void 0===o&&(o=r.apply(this,arguments)),o}),s=function(e){var t={};return function(e){if("function"==typeof e)return e();if(void 0===t[e]){var n=function(e){return document.querySelector(e)}.call(this,e);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(e){n=null}t[e]=n}return t[e]}}(),u=null,c=0,f=[],l=n(5);function p(e,t){for(var n=0;n<e.length;n++){var r=e[n],o=i[r.id];if(o){o.refs++;for(var a=0;a<o.parts.length;a++)o.parts[a](r.parts[a]);for(;a<r.parts.length;a++)o.parts.push(m(r.parts[a],t))}else{var s=[];for(a=0;a<r.parts.length;a++)s.push(m(r.parts[a],t));i[r.id]={id:r.id,refs:1,parts:s}}}}function d(e,t){for(var n=[],r={},o=0;o<e.length;o++){var i=e[o],a=t.base?i[0]+t.base:i[0],s={css:i[1],media:i[2],sourceMap:i[3]};r[a]?r[a].parts.push(s):n.push(r[a]={id:a,parts:[s]})}return n}function h(e,t){var n=s(e.insertInto);if(!n)throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");var r=f[f.length-1];if("top"===e.insertAt)r?r.nextSibling?n.insertBefore(t,r.nextSibling):n.appendChild(t):n.insertBefore(t,n.firstChild),f.push(t);else if("bottom"===e.insertAt)n.appendChild(t);else{if("object"!=typeof e.insertAt||!e.insertAt.before)throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");var o=s(e.insertInto+" "+e.insertAt.before);n.insertBefore(t,o)}}function v(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e);var t=f.indexOf(e);t>=0&&f.splice(t,1)}function b(e){var t=document.createElement("style");return void 0===e.attrs.type&&(e.attrs.type="text/css"),y(t,e.attrs),h(e,t),t}function y(e,t){Object.keys(t).forEach(function(n){e.setAttribute(n,t[n])})}function m(e,t){var n,r,o,i;if(t.transform&&e.css){if(!(i=t.transform(e.css)))return function(){};e.css=i}if(t.singleton){var a=c++;n=u||(u=b(t)),r=x.bind(null,n,a,!1),o=x.bind(null,n,a,!0)}else e.sourceMap&&"function"==typeof URL&&"function"==typeof URL.createObjectURL&&"function"==typeof URL.revokeObjectURL&&"function"==typeof Blob&&"function"==typeof btoa?(n=function(e){var t=document.createElement("link");return void 0===e.attrs.type&&(e.attrs.type="text/css"),e.attrs.rel="stylesheet",y(t,e.attrs),h(e,t),t}(t),r=function(e,t,n){var r=n.css,o=n.sourceMap,i=void 0===t.convertToAbsoluteUrls&&o;(t.convertToAbsoluteUrls||i)&&(r=l(r));o&&(r+="\n/*# sourceMappingURL=data:application/json;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(o))))+" */");var a=new Blob([r],{type:"text/css"}),s=e.href;e.href=URL.createObjectURL(a),s&&URL.revokeObjectURL(s)}.bind(null,n,t),o=function(){v(n),n.href&&URL.revokeObjectURL(n.href)}):(n=b(t),r=function(e,t){var n=t.css,r=t.media;r&&e.setAttribute("media",r);if(e.styleSheet)e.styleSheet.cssText=n;else{for(;e.firstChild;)e.removeChild(e.firstChild);e.appendChild(document.createTextNode(n))}}.bind(null,n),o=function(){v(n)});return r(e),function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap)return;r(e=t)}else o()}}e.exports=function(e,t){if("undefined"!=typeof DEBUG&&DEBUG&&"object"!=typeof document)throw new Error("The style-loader cannot be used in a non-browser environment");(t=t||{}).attrs="object"==typeof t.attrs?t.attrs:{},t.singleton||"boolean"==typeof t.singleton||(t.singleton=a()),t.insertInto||(t.insertInto="head"),t.insertAt||(t.insertAt="bottom");var n=d(e,t);return p(n,t),function(e){for(var r=[],o=0;o<n.length;o++){var a=n[o];(s=i[a.id]).refs--,r.push(s)}e&&p(d(e,t),t);for(o=0;o<r.length;o++){var s;if(0===(s=r[o]).refs){for(var u=0;u<s.parts.length;u++)s.parts[u]();delete i[s.id]}}}};var g,w=(g=[],function(e,t){return g[e]=t,g.filter(Boolean).join("\n")});function x(e,t,n,r){var o=n?"":r.css;if(e.styleSheet)e.styleSheet.cssText=w(t,o);else{var i=document.createTextNode(o),a=e.childNodes;a[t]&&e.removeChild(a[t]),a.length?e.insertBefore(i,a[t]):e.appendChild(i)}}},function(e,t){e.exports=function(e){var t="undefined"!=typeof window&&window.location;if(!t)throw new Error("fixUrls requires window.location");if(!e||"string"!=typeof e)return e;var n=t.protocol+"//"+t.host,r=n+t.pathname.replace(/\/[^\/]*$/,"/");return e.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi,function(e,t){var o,i=t.trim().replace(/^"(.*)"$/,function(e,t){return t}).replace(/^'(.*)'$/,function(e,t){return t});return/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/|\s*$)/i.test(i)?e:(o=0===i.indexOf("//")?i:0===i.indexOf("/")?n+i:r+i.replace(/^\.\//,""),"url("+JSON.stringify(o)+")")})}}])});

/***/ }),

/***/ "./node_modules/@editorjs/editorjs/dist/editor.js":
/*!********************************************************!*\
  !*** ./node_modules/@editorjs/editorjs/dist/editor.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

/*! For license information please see editor.js.LICENSE.txt */
!function(t,e){ true?module.exports=e():undefined}(window,(function(){return function(t){var e={};function n(o){if(e[o])return e[o].exports;var r=e[o]={i:o,l:!1,exports:{}};return t[o].call(r.exports,r,r.exports,n),r.l=!0,r.exports}return n.m=t,n.c=e,n.d=function(t,e,o){n.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:o})},n.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var o=Object.create(null);if(n.r(o),Object.defineProperty(o,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var r in t)n.d(o,r,function(e){return t[e]}.bind(null,r));return o},n.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return n.d(e,"a",e),e},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.p="",n(n.s=183)}([function(t,e,n){var o=n(9),r=n(17),i=n(27),a=n(23),s=n(30),c=function(t,e,n){var l,u,f,d,p=t&c.F,h=t&c.G,v=t&c.S,y=t&c.P,g=t&c.B,b=h?o:v?o[e]||(o[e]={}):(o[e]||{}).prototype,m=h?r:r[e]||(r[e]={}),k=m.prototype||(m.prototype={});for(l in h&&(n=e),n)f=((u=!p&&b&&void 0!==b[l])?b:n)[l],d=g&&u?s(f,o):y&&"function"==typeof f?s(Function.call,f):f,b&&a(b,l,f,t&c.U),m[l]!=f&&i(m,l,d),y&&k[l]!=f&&(k[l]=f)};o.core=r,c.F=1,c.G=2,c.S=4,c.P=8,c.B=16,c.W=32,c.U=64,c.R=128,t.exports=c},function(t,e){t.exports=function(t){return t&&t.__esModule?t:{default:t}}},function(t,e){t.exports=function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}},function(t,e){function n(t,e){for(var n=0;n<e.length;n++){var o=e[n];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(t,o.key,o)}}t.exports=function(t,e,o){return e&&n(t.prototype,e),o&&n(t,o),t}},function(t,e){function n(e){return t.exports=n=Object.setPrototypeOf?Object.getPrototypeOf:function(t){return t.__proto__||Object.getPrototypeOf(t)},n(e)}t.exports=n},function(t,e,n){var o=n(108);t.exports=function(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Super expression must either be null or a function");t.prototype=Object.create(e&&e.prototype,{constructor:{value:t,writable:!0,configurable:!0}}),e&&o(t,e)}},function(t,e,n){var o=n(52),r=n(368);t.exports=function(t,e){return!e||"object"!==o(e)&&"function"!=typeof e?r(t):e}},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3)],void 0===(i="function"==typeof(o=function(o,r,i){"use strict";var a=n(1);function s(t){if("undefined"==typeof Symbol||null==t[Symbol.iterator]){if(Array.isArray(t)||(t=function(t,e){if(t){if("string"==typeof t)return c(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);return"Object"===n&&t.constructor&&(n=t.constructor.name),"Map"===n||"Set"===n?Array.from(n):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?c(t,e):void 0}}(t))){var e=0,n=function(){};return{s:n,n:function(){return e>=t.length?{done:!0}:{done:!1,value:t[e++]}},e:function(t){throw t},f:n}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,r,i=!0,a=!1;return{s:function(){o=t[Symbol.iterator]()},n:function(){var t=o.next();return i=t.done,t},e:function(t){a=!0,r=t},f:function(){try{i||null==o.return||o.return()}finally{if(a)throw r}}}}function c(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,o=new Array(e);n<e;n++)o[n]=t[n];return o}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=a(r),i=a(i);var l=function(){function t(e){var n=this,o=e.config;if((0,r.default)(this,t),this.nodes={},this.readOnlyMutableListeners={on:function(t,e,o){var r=arguments.length>3&&void 0!==arguments[3]&&arguments[3],i=n.Editor.Listeners;n.mutableListenerIds.push(i.on(t,e,o,r))},clearAll:function(){var t,e=n.Editor.Listeners,o=s(n.mutableListenerIds);try{for(o.s();!(t=o.n()).done;){var r=t.value;e.offById(r)}}catch(t){o.e(t)}finally{o.f()}n.mutableListenerIds=[]}},this.mutableListenerIds=[],(this instanceof t?this.constructor:void 0)===t)throw new TypeError("Constructors for abstract class Module are not allowed.");this.config=o}return(0,i.default)(t,[{key:"removeAllNodes",value:function(){for(var t in this.nodes){var e=this.nodes[t];e instanceof HTMLElement&&e.remove()}}},{key:"state",set:function(t){this.Editor=t}},{key:"isRtl",get:function(){return"rtl"===this.config.i18n.direction}}]),t}();o.default=l,l.displayName="Module",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(21),n(367),n(22),n(15)],void 0===(i="function"==typeof(o=function(t,e,o,r,i){"use strict";var a,s=n(1);function c(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"log",o=arguments.length>3?arguments[3]:void 0,r=arguments.length>4&&void 0!==arguments[4]?arguments[4]:"color: inherit";if("console"in window&&window.console[n]){var i=["info","log","warn","error"].includes(n),s=[];switch(c.logLevel){case a.ERROR:if("error"!==n)return;break;case a.WARN:if(!["error","warn"].includes(n))return;break;case a.INFO:if(!i||t)return}o&&s.push(o);var l="Editor.js ".concat("2.19.0"),u="line-height: 1em;\n            color: #006FEA;\n            display: inline-block;\n            font-size: 11px;\n            line-height: 1em;\n            background-color: #fff;\n            padding: 4px 9px;\n            border-radius: 30px;\n            border: 1px solid rgba(56, 138, 229, 0.16);\n            margin: 4px 5px 4px 0;";t&&(i?(s.unshift(u,r),e="%c".concat(l,"%c ").concat(e)):e="( ".concat(l," )").concat(e));try{if(i)if(o){var f;(f=console)[n].apply(f,["".concat(e," %o")].concat(s))}else{var d;(d=console)[n].apply(d,[e].concat(s))}else console[n](e)}catch(t){}}}Object.defineProperty(t,"__esModule",{value:!0}),t.setLogLevel=function(t){c.logLevel=t},t.isPrintableKey=function(t){return t>47&&t<58||32===t||13===t||229===t||t>64&&t<91||t>95&&t<112||t>185&&t<193||t>218&&t<223},t.sequence=function(t){return f.apply(this,arguments)},t.array=function(t){return Array.prototype.slice.call(t)},t.isFunction=d,t.isClass=function(t){return d(t)&&/^\s*class\s+/.test(t.toString())},t.isEmpty=function(t){return!t||0===Object.keys(t).length&&t.constructor===Object},t.isPromise=function(t){return Promise.resolve(t)===t},t.delay=function(t,e){return function(){var n=this,o=arguments;window.setTimeout((function(){return t.apply(n,o)}),e)}},t.getFileExtension=function(t){return t.name.split(".").pop()},t.isValidMimeType=function(t){return/^[-\w]+\/([-+\w]+|\*)$/.test(t)},t.debounce=function(t,e,n){var o,r=arguments,i=this;return function(){var a=i,s=r,c=n&&!o;window.clearTimeout(o),o=window.setTimeout((function(){o=null,n||t.apply(a,s)}),e),c&&t.apply(a,s)}},t.copyTextToClipboard=function(t){var e=i.default.make("div","codex-editor-clipboard",{innerHTML:t});document.body.appendChild(e);var n=window.getSelection(),o=document.createRange();o.selectNode(e),window.getSelection().removeAllRanges(),n.addRange(o),document.execCommand("copy"),document.body.removeChild(e)},t.getUserOS=p,t.capitalize=function(t){return t[0].toUpperCase()+t.slice(1)},t.typeOf=h,t.deepMerge=function t(e){for(var n=function(t){return t&&"object"===h(t)},r=arguments.length,i=new Array(r>1?r-1:0),a=1;a<r;a++)i[a-1]=arguments[a];if(!i.length)return e;var s=i.shift();if(n(e)&&n(s))for(var c in s)n(s[c])?(e[c]||Object.assign(e,(0,o.default)({},c,{})),t(e[c],s[c])):Object.assign(e,(0,o.default)({},c,s[c]));return t.apply(void 0,[e].concat(i))},t.beautifyShortcut=function(t){var e=p();return t=t.replace(/shift/gi,"⇧").replace(/backspace/gi,"⌫").replace(/enter/gi,"⏎").replace(/up/gi,"↑").replace(/left/gi,"→").replace(/down/gi,"↓").replace(/right/gi,"←").replace(/escape/gi,"⎋").replace(/insert/gi,"Ins").replace(/delete/gi,"␡").replace(/\+/gi," + "),t=e.mac?t.replace(/ctrl|cmd/gi,"⌘").replace(/alt/gi,"⌥"):t.replace(/cmd/gi,"Ctrl").replace(/windows/gi,"WIN")},t.getValidUrl=function(t){try{return new URL(t).href}catch(t){}return"//"===t.substring(0,2)?window.location.protocol+t:window.location.origin+t},t.openTab=function(t){window.open(t,"_blank")},t.generateId=function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"";return"".concat(t).concat(Math.floor(1e8*Math.random()).toString(16))},t.deprecationAssert=function(t,e,n){var o="«".concat(e,"» is deprecated and will be removed in the next major release. Please use the «").concat(n,"» instead.");t&&u(o,"warn")},t.isTouchSupported=t.logLabeled=t.log=t.mouseButtons=t.keyCodes=t.LogLevels=void 0,e=s(e),o=s(o),r=s(r),i=s(i),t.LogLevels=a,function(t){t.VERBOSE="VERBOSE",t.INFO="INFO",t.WARN="WARN",t.ERROR="ERROR"}(a||(t.LogLevels=a={})),t.keyCodes={BACKSPACE:8,TAB:9,ENTER:13,SHIFT:16,CTRL:17,ALT:18,ESC:27,SPACE:32,LEFT:37,UP:38,DOWN:40,RIGHT:39,DELETE:46,META:91},t.mouseButtons={LEFT:0,WHEEL:1,RIGHT:2,BACKWARD:3,FORWARD:4},c.logLevel=a.VERBOSE;var l=c.bind(window,!1);t.log=l;var u=c.bind(window,!0);function f(){return(f=(0,r.default)(e.default.mark((function t(n){var o,i,a,s,c=arguments;return e.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return s=function(){return(s=(0,r.default)(e.default.mark((function t(n,o,r){return e.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return t.prev=0,t.next=3,n.function(n.data);case 3:return t.next=5,o(void 0!==n.data?n.data:{});case 5:t.next=10;break;case 7:t.prev=7,t.t0=t.catch(0),r(void 0!==n.data?n.data:{});case 10:case"end":return t.stop()}}),t,null,[[0,7]])})))).apply(this,arguments)},a=function(t,e,n){return s.apply(this,arguments)},o=c.length>1&&void 0!==c[1]?c[1]:function(){},i=c.length>2&&void 0!==c[2]?c[2]:function(){},t.abrupt("return",n.reduce(function(){var t=(0,r.default)(e.default.mark((function t(n,r){return e.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,n;case 2:return t.abrupt("return",a(r,o,i));case 3:case"end":return t.stop()}}),t)})));return function(e,n){return t.apply(this,arguments)}}(),Promise.resolve()));case 5:case"end":return t.stop()}}),t)})))).apply(this,arguments)}function d(t){return"function"==typeof t}function p(){var t={win:!1,mac:!1,x11:!1,linux:!1},e=Object.keys(t).find((function(t){return-1!==navigator.appVersion.toLowerCase().indexOf(t)}));return e?(t[e]=!0,t):t}function h(t){return Object.prototype.toString.call(t).match(/\s([a-zA-Z]+)/)[1].toLowerCase()}t.logLabeled=u;var v="ontouchstart"in document.documentElement;t.isTouchSupported=v})?o.apply(e,r):o)||(t.exports=i)},function(t,e){var n=t.exports="undefined"!=typeof window&&window.Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=n)},function(t,e){t.exports=function(t){try{return!!t()}catch(t){return!0}}},function(t,e,n){var o=n(12);t.exports=function(t){if(!o(t))throw TypeError(t+" is not an object!");return t}},function(t,e){t.exports=function(t){return"object"==typeof t?null!==t:"function"==typeof t}},function(t,e,n){var o=n(52);function r(){if("function"!=typeof WeakMap)return null;var t=new WeakMap;return r=function(){return t},t}t.exports=function(t){if(t&&t.__esModule)return t;if(null===t||"object"!==o(t)&&"function"!=typeof t)return{default:t};var e=r();if(e&&e.has(t))return e.get(t);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var a in t)if(Object.prototype.hasOwnProperty.call(t,a)){var s=i?Object.getOwnPropertyDescriptor(t,a):null;s&&(s.get||s.set)?Object.defineProperty(n,a,s):n[a]=t[a]}return n.default=t,e&&e.set(t,n),n}},function(t,e,n){var o=n(68)("wks"),r=n(43),i=n(9).Symbol,a="function"==typeof i;(t.exports=function(t){return o[t]||(o[t]=a&&i[t]||(a?i:r)("Symbol."+t))}).store=o},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(52),n(66),n(2),n(3),n(8)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c){"use strict";var l=n(13),u=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=u(a),s=u(s),c=l(c);var f=function(){function t(){(0,a.default)(this,t)}return(0,s.default)(t,null,[{key:"isSingleTag",value:function(t){return t.tagName&&["AREA","BASE","BR","COL","COMMAND","EMBED","HR","IMG","INPUT","KEYGEN","LINK","META","PARAM","SOURCE","TRACK","WBR"].includes(t.tagName)}},{key:"isLineBreakTag",value:function(t){return t&&t.tagName&&["BR","WBR"].includes(t.tagName)}},{key:"make",value:function(t){var e,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,o=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=document.createElement(t);for(var a in Array.isArray(n)?(e=r.classList).add.apply(e,(0,i.default)(n)):n&&r.classList.add(n),o)Object.prototype.hasOwnProperty.call(o,a)&&(r[a]=o[a]);return r}},{key:"text",value:function(t){return document.createTextNode(t)}},{key:"svg",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:14,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:14,o=document.createElementNS("http://www.w3.org/2000/svg","svg");return o.classList.add("icon","icon--"+t),o.setAttribute("width",e+"px"),o.setAttribute("height",n+"px"),o.innerHTML='<use xmlns:xlink="http://www.w3.org/1999/xlink" xlink:href="#'.concat(t,'"></use>'),o}},{key:"append",value:function(t,e){Array.isArray(e)?e.forEach((function(e){return t.appendChild(e)})):t.appendChild(e)}},{key:"prepend",value:function(t,e){Array.isArray(e)?(e=e.reverse()).forEach((function(e){return t.prepend(e)})):t.prepend(e)}},{key:"swap",value:function(t,e){var n=document.createElement("div"),o=t.parentNode;o.insertBefore(n,t),o.insertBefore(t,e),o.insertBefore(e,n),o.removeChild(n)}},{key:"find",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:document,e=arguments.length>1?arguments[1]:void 0;return t.querySelector(e)}},{key:"get",value:function(t){return document.getElementById(t)}},{key:"findAll",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:document,e=arguments.length>1?arguments[1]:void 0;return t.querySelectorAll(e)}},{key:"findAllInputs",value:function(e){return c.array(e.querySelectorAll(t.allInputsSelector)).reduce((function(e,n){return t.isNativeInput(n)||t.containsOnlyInlineElements(n)?[].concat((0,i.default)(e),[n]):[].concat((0,i.default)(e),(0,i.default)(t.getDeepestBlockElements(n)))}),[])}},{key:"getDeepestNode",value:function(e){var n=arguments.length>1&&void 0!==arguments[1]&&arguments[1],o=n?"lastChild":"firstChild",r=n?"previousSibling":"nextSibling";if(e&&e.nodeType===Node.ELEMENT_NODE&&e[o]){var i=e[o];if(t.isSingleTag(i)&&!t.isNativeInput(i)&&!t.isLineBreakTag(i))if(i[r])i=i[r];else{if(!i.parentNode[r])return i.parentNode;i=i.parentNode[r]}return this.getDeepestNode(i,n)}return e}},{key:"isElement",value:function(t){return t&&"object"===(0,r.default)(t)&&t.nodeType&&t.nodeType===Node.ELEMENT_NODE}},{key:"isFragment",value:function(t){return t&&"object"===(0,r.default)(t)&&t.nodeType&&t.nodeType===Node.DOCUMENT_FRAGMENT_NODE}},{key:"isContentEditable",value:function(t){return"true"===t.contentEditable}},{key:"isNativeInput",value:function(t){return!(!t||!t.tagName)&&["INPUT","TEXTAREA"].includes(t.tagName)}},{key:"canSetCaret",value:function(e){var n=!0;if(t.isNativeInput(e))switch(e.type){case"file":case"checkbox":case"radio":case"hidden":case"submit":case"button":case"image":case"reset":n=!1}else n=t.isContentEditable(e);return n}},{key:"isNodeEmpty",value:function(t){return!(this.isSingleTag(t)&&!this.isLineBreakTag(t))&&0===(this.isElement(t)&&this.isNativeInput(t)?t.value:t.textContent.replace("​","")).trim().length}},{key:"isLeaf",value:function(t){return!!t&&0===t.childNodes.length}},{key:"isEmpty",value:function(t){t.normalize();for(var e=[t];e.length>0;)if(t=e.shift()){if(this.isLeaf(t)&&!this.isNodeEmpty(t))return!1;t.childNodes&&e.push.apply(e,(0,i.default)(Array.from(t.childNodes)))}return!0}},{key:"isHTMLString",value:function(e){var n=t.make("div");return n.innerHTML=e,n.childElementCount>0}},{key:"getContentLength",value:function(e){return t.isNativeInput(e)?e.value.length:e.nodeType===Node.TEXT_NODE?e.length:e.textContent.length}},{key:"containsOnlyInlineElements",value:function(e){var n;return"string"==typeof e?(n=document.createElement("div")).innerHTML=e:n=e,Array.from(n.children).every((function e(n){return!t.blockElements.includes(n.tagName.toLowerCase())&&Array.from(n.children).every(e)}))}},{key:"getDeepestBlockElements",value:function(e){return t.containsOnlyInlineElements(e)?[e]:Array.from(e.children).reduce((function(e,n){return[].concat((0,i.default)(e),(0,i.default)(t.getDeepestBlockElements(n)))}),[])}},{key:"getHolder",value:function(t){return"string"==typeof t?document.getElementById(t):t}},{key:"isExtensionNode",value:function(t){return t&&["GRAMMARLY-EXTENSION"].includes(t.nodeName)}},{key:"isAnchor",value:function(t){return"a"===t.tagName.toLowerCase()}},{key:"allInputsSelector",get:function(){return"[contenteditable], textarea, input:not([type]), "+["text","password","email","number","search","tel","url"].map((function(t){return'input[type="'.concat(t,'"]')})).join(", ")}},{key:"blockElements",get:function(){return["address","article","aside","blockquote","canvas","div","dl","dt","fieldset","figcaption","figure","footer","form","h1","h2","h3","h4","h5","h6","header","hgroup","hr","li","main","nav","noscript","ol","output","p","pre","ruby","section","table","tr","tfoot","ul","video"]}}]),t}();o.default=f,f.displayName="Dom",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o=n(32),r=Math.min;t.exports=function(t){return t>0?r(o(t),9007199254740991):0}},function(t,e){var n=t.exports={version:"2.6.10"};"number"==typeof __e&&(__e=n)},function(t,e,n){t.exports=!n(10)((function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a}))},function(t,e,n){var o=n(11),r=n(109),i=n(40),a=Object.defineProperty;e.f=n(18)?Object.defineProperty:function(t,e,n){if(o(t),e=i(e,!0),o(n),r)try{return a(t,e,n)}catch(t){}if("get"in n||"set"in n)throw TypeError("Accessors not supported!");return"value"in n&&(t[e]=n.value),t}},function(t,e,n){var o=n(37);t.exports=function(t){return Object(o(t))}},function(t,e,n){t.exports=n(140)},function(t,e){function n(t,e,n,o,r,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(o,r)}t.exports=function(t){return function(){var e=this,o=arguments;return new Promise((function(r,i){var a=t.apply(e,o);function s(t){n(a,r,i,s,c,"next",t)}function c(t){n(a,r,i,s,c,"throw",t)}s(void 0)}))}}},function(t,e,n){var o=n(9),r=n(27),i=n(26),a=n(43)("src"),s=n(188),c=(""+s).split("toString");n(17).inspectSource=function(t){return s.call(t)},(t.exports=function(t,e,n,s){var l="function"==typeof n;l&&(i(n,"name")||r(n,"name",e)),t[e]!==n&&(l&&(i(n,a)||r(n,a,t[e]?""+t[e]:c.join(String(e)))),t===o?t[e]=n:s?t[e]?t[e]=n:r(t,e,n):(delete t[e],r(t,e,n)))})(Function.prototype,"toString",(function(){return"function"==typeof this&&this[a]||s.call(this)}))},function(t,e,n){var o=n(0),r=n(10),i=n(37),a=/"/g,s=function(t,e,n,o){var r=String(i(t)),s="<"+e;return""!==n&&(s+=" "+n+'="'+String(o).replace(a,"&quot;")+'"'),s+">"+r+"</"+e+">"};t.exports=function(t,e){var n={};n[t]=e(s),o(o.P+o.F*r((function(){var e=""[t]('"');return e!==e.toLowerCase()||e.split('"').length>3})),"String",n)}},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(8),n(15)],void 0===(i="function"==typeof(o=function(o,r,i,a,s){"use strict";var c=n(13),l=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=l(r),i=l(i),a=c(a),s=l(s);var u=function(){function t(){(0,r.default)(this,t),this.instance=null,this.selection=null,this.savedSelectionRange=null,this.isFakeBackgroundEnabled=!1,this.commandBackground="backColor",this.commandRemoveFormat="removeFormat"}return(0,i.default)(t,[{key:"removeFakeBackground",value:function(){this.isFakeBackgroundEnabled&&(this.isFakeBackgroundEnabled=!1,document.execCommand(this.commandRemoveFormat))}},{key:"setFakeBackground",value:function(){document.execCommand(this.commandBackground,!1,"#a8d6ff"),this.isFakeBackgroundEnabled=!0}},{key:"save",value:function(){this.savedSelectionRange=t.range}},{key:"restore",value:function(){if(this.savedSelectionRange){var t=window.getSelection();t.removeAllRanges(),t.addRange(this.savedSelectionRange)}}},{key:"clearSaved",value:function(){this.savedSelectionRange=null}},{key:"collapseToEnd",value:function(){var t=window.getSelection(),e=document.createRange();e.selectNodeContents(t.focusNode),e.collapse(!1),t.removeAllRanges(),t.addRange(e)}},{key:"findParentTag",value:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:10,o=window.getSelection(),r=null;if(!o||!o.anchorNode||!o.focusNode)return null;var i=[o.anchorNode,o.focusNode];return i.forEach((function(o){for(var i=n;i>0&&o.parentNode&&(o.tagName!==t||(r=o,e&&o.classList&&!o.classList.contains(e)&&(r=null),!r));)o=o.parentNode,i--})),r}},{key:"expandToTag",value:function(t){var e=window.getSelection();e.removeAllRanges();var n=document.createRange();n.selectNodeContents(t),e.addRange(n)}}],[{key:"get",value:function(){return window.getSelection()}},{key:"setCursor",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,n=document.createRange(),o=window.getSelection();if(s.default.isNativeInput(t)){if(!s.default.canSetCaret(t))return;return t.focus(),t.selectionStart=t.selectionEnd=e,t.getBoundingClientRect()}return n.setStart(t,e),n.setEnd(t,e),o.removeAllRanges(),o.addRange(n),n.getBoundingClientRect()}},{key:"CSS",get:function(){return{editorWrapper:"codex-editor",editorZone:"codex-editor__redactor"}}},{key:"anchorNode",get:function(){var t=window.getSelection();return t?t.anchorNode:null}},{key:"anchorElement",get:function(){var t=window.getSelection();if(!t)return null;var e=t.anchorNode;return e?s.default.isElement(e)?e:e.parentElement:null}},{key:"anchorOffset",get:function(){var t=window.getSelection();return t?t.anchorOffset:null}},{key:"isCollapsed",get:function(){var t=window.getSelection();return t?t.isCollapsed:null}},{key:"isAtEditor",get:function(){var e=t.get(),n=e.anchorNode||e.focusNode;n&&n.nodeType===Node.TEXT_NODE&&(n=n.parentNode);var o=null;return n&&(o=n.closest(".".concat(t.CSS.editorZone))),o&&o.nodeType===Node.ELEMENT_NODE}},{key:"isSelectionExists",get:function(){return!!t.get().anchorNode}},{key:"range",get:function(){var t=window.getSelection();return t&&t.rangeCount?t.getRangeAt(0):null}},{key:"rect",get:function(){var t,e=document.selection,n={x:0,y:0,width:0,height:0};if(e&&"Control"!==e.type)return t=(e=e).createRange(),n.x=t.boundingLeft,n.y=t.boundingTop,n.width=t.boundingWidth,n.height=t.boundingHeight,n;if(!window.getSelection)return a.log("Method window.getSelection is not supported","warn"),n;if(null===(e=window.getSelection()).rangeCount||isNaN(e.rangeCount))return a.log("Method SelectionUtils.rangeCount is not supported","warn"),n;if(0===e.rangeCount)return n;if((t=e.getRangeAt(0).cloneRange()).getBoundingClientRect&&(n=t.getBoundingClientRect()),0===n.x&&0===n.y){var o=document.createElement("span");if(o.getBoundingClientRect){o.appendChild(document.createTextNode("​")),t.insertNode(o),n=o.getBoundingClientRect();var r=o.parentNode;r.removeChild(o),r.normalize()}}return n}},{key:"text",get:function(){return window.getSelection?window.getSelection().toString():""}}]),t}();o.default=u,u.displayName="SelectionUtils",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e){var n={}.hasOwnProperty;t.exports=function(t,e){return n.call(t,e)}},function(t,e,n){var o=n(19),r=n(42);t.exports=n(18)?function(t,e,n){return o.f(t,e,r(1,n))}:function(t,e,n){return t[e]=n,t}},function(t,e,n){var o=n(62),r=n(37);t.exports=function(t){return o(r(t))}},function(t,e,n){"use strict";var o=n(10);t.exports=function(t,e){return!!t&&o((function(){e?t.call(null,(function(){}),1):t.call(null)}))}},function(t,e,n){var o=n(31);t.exports=function(t,e,n){if(o(t),void 0===e)return t;switch(n){case 1:return function(n){return t.call(e,n)};case 2:return function(n,o){return t.call(e,n,o)};case 3:return function(n,o,r){return t.call(e,n,o,r)}}return function(){return t.apply(e,arguments)}}},function(t,e){t.exports=function(t){if("function"!=typeof t)throw TypeError(t+" is not a function!");return t}},function(t,e){var n=Math.ceil,o=Math.floor;t.exports=function(t){return isNaN(t=+t)?0:(t>0?o:n)(t)}},function(t,e,n){var o=n(63),r=n(42),i=n(28),a=n(40),s=n(26),c=n(109),l=Object.getOwnPropertyDescriptor;e.f=n(18)?l:function(t,e){if(t=i(t),e=a(e,!0),c)try{return l(t,e)}catch(t){}if(s(t,e))return r(!o.f.call(t,e),t[e])}},function(t,e,n){var o=n(0),r=n(17),i=n(10);t.exports=function(t,e){var n=(r.Object||{})[t]||Object[t],a={};a[t]=e(n),o(o.S+o.F*i((function(){n(1)})),"Object",a)}},function(t,e,n){var o=n(30),r=n(62),i=n(20),a=n(16),s=n(125);t.exports=function(t,e){var n=1==t,c=2==t,l=3==t,u=4==t,f=6==t,d=5==t||f,p=e||s;return function(e,s,h){for(var v,y,g=i(e),b=r(g),m=o(s,h,3),k=a(b.length),x=0,S=n?p(e,k):c?p(e,0):void 0;k>x;x++)if((d||x in b)&&(y=m(v=b[x],x,g),t))if(n)S[x]=y;else if(y)switch(t){case 3:return!0;case 5:return v;case 6:return x;case 2:S.push(v)}else if(u)return!1;return f?-1:l||u?u:S}}},function(t,e){var n={}.toString;t.exports=function(t){return n.call(t).slice(8,-1)}},function(t,e){t.exports=function(t){if(null==t)throw TypeError("Can't call method on  "+t);return t}},function(t,e,n){"use strict";if(n(18)){var o=n(44),r=n(9),i=n(10),a=n(0),s=n(79),c=n(107),l=n(30),u=n(57),f=n(42),d=n(27),p=n(58),h=n(32),v=n(16),y=n(136),g=n(46),b=n(40),m=n(26),k=n(64),x=n(12),S=n(20),w=n(99),E=n(47),T=n(49),C=n(48).f,B=n(101),_=n(43),O=n(14),I=n(35),N=n(69),R=n(65),M=n(103),L=n(55),A=n(72),P=n(56),D=n(102),j=n(127),F=n(19),U=n(33),H=F.f,z=U.f,W=r.RangeError,G=r.TypeError,X=r.Uint8Array,V=Array.prototype,Y=c.ArrayBuffer,K=c.DataView,Z=I(0),q=I(2),J=I(3),$=I(4),Q=I(5),tt=I(6),et=N(!0),nt=N(!1),ot=M.values,rt=M.keys,it=M.entries,at=V.lastIndexOf,st=V.reduce,ct=V.reduceRight,lt=V.join,ut=V.sort,ft=V.slice,dt=V.toString,pt=V.toLocaleString,ht=O("iterator"),vt=O("toStringTag"),yt=_("typed_constructor"),gt=_("def_constructor"),bt=s.CONSTR,mt=s.TYPED,kt=s.VIEW,xt=I(1,(function(t,e){return Ct(R(t,t[gt]),e)})),St=i((function(){return 1===new X(new Uint16Array([1]).buffer)[0]})),wt=!!X&&!!X.prototype.set&&i((function(){new X(1).set({})})),Et=function(t,e){var n=h(t);if(n<0||n%e)throw W("Wrong offset!");return n},Tt=function(t){if(x(t)&&mt in t)return t;throw G(t+" is not a typed array!")},Ct=function(t,e){if(!x(t)||!(yt in t))throw G("It is not a typed array constructor!");return new t(e)},Bt=function(t,e){return _t(R(t,t[gt]),e)},_t=function(t,e){for(var n=0,o=e.length,r=Ct(t,o);o>n;)r[n]=e[n++];return r},Ot=function(t,e,n){H(t,e,{get:function(){return this._d[n]}})},It=function(t){var e,n,o,r,i,a,s=S(t),c=arguments.length,u=c>1?arguments[1]:void 0,f=void 0!==u,d=B(s);if(null!=d&&!w(d)){for(a=d.call(s),o=[],e=0;!(i=a.next()).done;e++)o.push(i.value);s=o}for(f&&c>2&&(u=l(u,arguments[2],2)),e=0,n=v(s.length),r=Ct(this,n);n>e;e++)r[e]=f?u(s[e],e):s[e];return r},Nt=function(){for(var t=0,e=arguments.length,n=Ct(this,e);e>t;)n[t]=arguments[t++];return n},Rt=!!X&&i((function(){pt.call(new X(1))})),Mt=function(){return pt.apply(Rt?ft.call(Tt(this)):Tt(this),arguments)},Lt={copyWithin:function(t,e){return j.call(Tt(this),t,e,arguments.length>2?arguments[2]:void 0)},every:function(t){return $(Tt(this),t,arguments.length>1?arguments[1]:void 0)},fill:function(t){return D.apply(Tt(this),arguments)},filter:function(t){return Bt(this,q(Tt(this),t,arguments.length>1?arguments[1]:void 0))},find:function(t){return Q(Tt(this),t,arguments.length>1?arguments[1]:void 0)},findIndex:function(t){return tt(Tt(this),t,arguments.length>1?arguments[1]:void 0)},forEach:function(t){Z(Tt(this),t,arguments.length>1?arguments[1]:void 0)},indexOf:function(t){return nt(Tt(this),t,arguments.length>1?arguments[1]:void 0)},includes:function(t){return et(Tt(this),t,arguments.length>1?arguments[1]:void 0)},join:function(t){return lt.apply(Tt(this),arguments)},lastIndexOf:function(t){return at.apply(Tt(this),arguments)},map:function(t){return xt(Tt(this),t,arguments.length>1?arguments[1]:void 0)},reduce:function(t){return st.apply(Tt(this),arguments)},reduceRight:function(t){return ct.apply(Tt(this),arguments)},reverse:function(){for(var t,e=Tt(this).length,n=Math.floor(e/2),o=0;o<n;)t=this[o],this[o++]=this[--e],this[e]=t;return this},some:function(t){return J(Tt(this),t,arguments.length>1?arguments[1]:void 0)},sort:function(t){return ut.call(Tt(this),t)},subarray:function(t,e){var n=Tt(this),o=n.length,r=g(t,o);return new(R(n,n[gt]))(n.buffer,n.byteOffset+r*n.BYTES_PER_ELEMENT,v((void 0===e?o:g(e,o))-r))}},At=function(t,e){return Bt(this,ft.call(Tt(this),t,e))},Pt=function(t){Tt(this);var e=Et(arguments[1],1),n=this.length,o=S(t),r=v(o.length),i=0;if(r+e>n)throw W("Wrong length!");for(;i<r;)this[e+i]=o[i++]},Dt={entries:function(){return it.call(Tt(this))},keys:function(){return rt.call(Tt(this))},values:function(){return ot.call(Tt(this))}},jt=function(t,e){return x(t)&&t[mt]&&"symbol"!=typeof e&&e in t&&String(+e)==String(e)},Ft=function(t,e){return jt(t,e=b(e,!0))?f(2,t[e]):z(t,e)},Ut=function(t,e,n){return!(jt(t,e=b(e,!0))&&x(n)&&m(n,"value"))||m(n,"get")||m(n,"set")||n.configurable||m(n,"writable")&&!n.writable||m(n,"enumerable")&&!n.enumerable?H(t,e,n):(t[e]=n.value,t)};bt||(U.f=Ft,F.f=Ut),a(a.S+a.F*!bt,"Object",{getOwnPropertyDescriptor:Ft,defineProperty:Ut}),i((function(){dt.call({})}))&&(dt=pt=function(){return lt.call(this)});var Ht=p({},Lt);p(Ht,Dt),d(Ht,ht,Dt.values),p(Ht,{slice:At,set:Pt,constructor:function(){},toString:dt,toLocaleString:Mt}),Ot(Ht,"buffer","b"),Ot(Ht,"byteOffset","o"),Ot(Ht,"byteLength","l"),Ot(Ht,"length","e"),H(Ht,vt,{get:function(){return this[mt]}}),t.exports=function(t,e,n,c){var l=t+((c=!!c)?"Clamped":"")+"Array",f="get"+t,p="set"+t,h=r[l],g=h||{},b=h&&T(h),m=!h||!s.ABV,S={},w=h&&h.prototype,B=function(t,n){H(t,n,{get:function(){return function(t,n){var o=t._d;return o.v[f](n*e+o.o,St)}(this,n)},set:function(t){return function(t,n,o){var r=t._d;c&&(o=(o=Math.round(o))<0?0:o>255?255:255&o),r.v[p](n*e+r.o,o,St)}(this,n,t)},enumerable:!0})};m?(h=n((function(t,n,o,r){u(t,h,l,"_d");var i,a,s,c,f=0,p=0;if(x(n)){if(!(n instanceof Y||"ArrayBuffer"==(c=k(n))||"SharedArrayBuffer"==c))return mt in n?_t(h,n):It.call(h,n);i=n,p=Et(o,e);var g=n.byteLength;if(void 0===r){if(g%e)throw W("Wrong length!");if((a=g-p)<0)throw W("Wrong length!")}else if((a=v(r)*e)+p>g)throw W("Wrong length!");s=a/e}else s=y(n),i=new Y(a=s*e);for(d(t,"_d",{b:i,o:p,l:a,e:s,v:new K(i)});f<s;)B(t,f++)})),w=h.prototype=E(Ht),d(w,"constructor",h)):i((function(){h(1)}))&&i((function(){new h(-1)}))&&A((function(t){new h,new h(null),new h(1.5),new h(t)}),!0)||(h=n((function(t,n,o,r){var i;return u(t,h,l),x(n)?n instanceof Y||"ArrayBuffer"==(i=k(n))||"SharedArrayBuffer"==i?void 0!==r?new g(n,Et(o,e),r):void 0!==o?new g(n,Et(o,e)):new g(n):mt in n?_t(h,n):It.call(h,n):new g(y(n))})),Z(b!==Function.prototype?C(g).concat(C(b)):C(g),(function(t){t in h||d(h,t,g[t])})),h.prototype=w,o||(w.constructor=h));var _=w[ht],O=!!_&&("values"==_.name||null==_.name),I=Dt.values;d(h,yt,!0),d(w,mt,l),d(w,kt,!0),d(w,gt,h),(c?new h(1)[vt]==l:vt in w)||H(w,vt,{get:function(){return l}}),S[l]=h,a(a.G+a.W+a.F*(h!=g),S),a(a.S,l,{BYTES_PER_ELEMENT:e}),a(a.S+a.F*i((function(){g.of.call(h,1)})),l,{from:It,of:Nt}),"BYTES_PER_ELEMENT"in w||d(w,"BYTES_PER_ELEMENT",e),a(a.P,l,Lt),P(l),a(a.P+a.F*wt,l,{set:Pt}),a(a.P+a.F*!O,l,Dt),o||w.toString==dt||(w.toString=dt),a(a.P+a.F*i((function(){new h(1).slice()})),l,{slice:At}),a(a.P+a.F*(i((function(){return[1,2].toLocaleString()!=new h([1,2]).toLocaleString()}))||!i((function(){w.toLocaleString.call([1,2])}))),l,{toLocaleString:Mt}),L[l]=O?_:I,o||O||d(w,ht,I)}}else t.exports=function(){}},function(t,e,n){var o=n(357),r=n(358),i=n(141),a=n(359);t.exports=function(t,e){return o(t)||r(t,e)||i(t,e)||a()}},function(t,e,n){var o=n(12);t.exports=function(t,e){if(!o(t))return t;var n,r;if(e&&"function"==typeof(n=t.toString)&&!o(r=n.call(t)))return r;if("function"==typeof(n=t.valueOf)&&!o(r=n.call(t)))return r;if(!e&&"function"==typeof(n=t.toString)&&!o(r=n.call(t)))return r;throw TypeError("Can't convert object to primitive value")}},function(t,e,n){var o=n(43)("meta"),r=n(12),i=n(26),a=n(19).f,s=0,c=Object.isExtensible||function(){return!0},l=!n(10)((function(){return c(Object.preventExtensions({}))})),u=function(t){a(t,o,{value:{i:"O"+ ++s,w:{}}})},f=t.exports={KEY:o,NEED:!1,fastKey:function(t,e){if(!r(t))return"symbol"==typeof t?t:("string"==typeof t?"S":"P")+t;if(!i(t,o)){if(!c(t))return"F";if(!e)return"E";u(t)}return t[o].i},getWeak:function(t,e){if(!i(t,o)){if(!c(t))return!0;if(!e)return!1;u(t)}return t[o].w},onFreeze:function(t){return l&&f.NEED&&c(t)&&!i(t,o)&&u(t),t}}},function(t,e){t.exports=function(t,e){return{enumerable:!(1&t),configurable:!(2&t),writable:!(4&t),value:e}}},function(t,e){var n=0,o=Math.random();t.exports=function(t){return"Symbol(".concat(void 0===t?"":t,")_",(++n+o).toString(36))}},function(t,e){t.exports=!1},function(t,e,n){var o=n(111),r=n(86);t.exports=Object.keys||function(t){return o(t,r)}},function(t,e,n){var o=n(32),r=Math.max,i=Math.min;t.exports=function(t,e){return(t=o(t))<0?r(t+e,0):i(t,e)}},function(t,e,n){var o=n(11),r=n(112),i=n(86),a=n(85)("IE_PROTO"),s=function(){},c=function(){var t,e=n(83)("iframe"),o=i.length;for(e.style.display="none",n(87).appendChild(e),e.src="javascript:",(t=e.contentWindow.document).open(),t.write("<script>document.F=Object<\/script>"),t.close(),c=t.F;o--;)delete c.prototype[i[o]];return c()};t.exports=Object.create||function(t,e){var n;return null!==t?(s.prototype=o(t),n=new s,s.prototype=null,n[a]=t):n=c(),void 0===e?n:r(n,e)}},function(t,e,n){var o=n(111),r=n(86).concat("length","prototype");e.f=Object.getOwnPropertyNames||function(t){return o(t,r)}},function(t,e,n){var o=n(26),r=n(20),i=n(85)("IE_PROTO"),a=Object.prototype;t.exports=Object.getPrototypeOf||function(t){return t=r(t),o(t,i)?t[i]:"function"==typeof t.constructor&&t instanceof t.constructor?t.constructor.prototype:t instanceof Object?a:null}},function(t,e,n){var o=n(14)("unscopables"),r=Array.prototype;null==r[o]&&n(27)(r,o,{}),t.exports=function(t){r[o][t]=!0}},function(t,e,n){var o=n(12);t.exports=function(t,e){if(!o(t)||t._t!==e)throw TypeError("Incompatible receiver, "+e+" required!");return t}},function(t,e){function n(e){return"function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?t.exports=n=function(t){return typeof t}:t.exports=n=function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},n(e)}t.exports=n},function(t,e,n){var o=n(19).f,r=n(26),i=n(14)("toStringTag");t.exports=function(t,e,n){t&&!r(t=n?t:t.prototype,i)&&o(t,i,{configurable:!0,value:e})}},function(t,e,n){var o=n(0),r=n(37),i=n(10),a=n(89),s="["+a+"]",c=RegExp("^"+s+s+"*"),l=RegExp(s+s+"*$"),u=function(t,e,n){var r={},s=i((function(){return!!a[t]()||"​"!="​"[t]()})),c=r[t]=s?e(f):a[t];n&&(r[n]=c),o(o.P+o.F*s,"String",r)},f=u.trim=function(t,e){return t=String(r(t)),1&e&&(t=t.replace(c,"")),2&e&&(t=t.replace(l,"")),t};t.exports=u},function(t,e){t.exports={}},function(t,e,n){"use strict";var o=n(9),r=n(19),i=n(18),a=n(14)("species");t.exports=function(t){var e=o[t];i&&e&&!e[a]&&r.f(e,a,{configurable:!0,get:function(){return this}})}},function(t,e){t.exports=function(t,e,n,o){if(!(t instanceof e)||void 0!==o&&o in t)throw TypeError(n+": incorrect invocation!");return t}},function(t,e,n){var o=n(23);t.exports=function(t,e,n){for(var r in e)o(t,r,e[r],n);return t}},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(143)],void 0===(i="function"==typeof(o=function(o,r,i,a){"use strict";var s=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=s(r),i=s(i),a=s(a);var c=function(){function t(){(0,r.default)(this,t)}return(0,i.default)(t,null,[{key:"ui",value:function(e,n){return t._t(e,n)}},{key:"t",value:function(e,n){return t._t(e,n)}},{key:"setDictionary",value:function(e){t.currentDictionary=e}},{key:"_t",value:function(e,n){var o=t.getNamespace(e);return o&&o[n]?o[n]:n}},{key:"getNamespace",value:function(e){return e.split(".").reduce((function(t,e){return t&&Object.keys(t).length?t[e]:{}}),t.currentDictionary)}}]),t}();o.default=c,c.displayName="I18n",c.currentDictionary=a.default,t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(379),n(8)],void 0===(i="function"==typeof(o=function(o,r,i,a,s){"use strict";var c=n(13),l=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=l(r),i=l(i),a=l(a),s=c(s);var u=function(){function t(e){var n=this;(0,r.default)(this,t),this.iterator=null,this.activated=!1,this.allowArrows=!0,this.onKeyDown=function(e){if(n.isEventReadyForHandling(e))switch(t.usedKeys.includes(e.keyCode)&&e.preventDefault(),e.keyCode){case s.keyCodes.TAB:n.handleTabPress(e);break;case s.keyCodes.LEFT:case s.keyCodes.UP:n.flipLeft();break;case s.keyCodes.RIGHT:case s.keyCodes.DOWN:n.flipRight();break;case s.keyCodes.ENTER:n.handleEnterPress(e)}},this.allowArrows="boolean"!=typeof e.allowArrows||e.allowArrows,this.iterator=new a.default(e.items,e.focusedItemClass),this.activateCallback=e.activateCallback}return(0,i.default)(t,[{key:"activate",value:function(t){this.activated=!0,t&&this.iterator.setItems(t),document.addEventListener("keydown",this.onKeyDown)}},{key:"deactivate",value:function(){this.activated=!1,this.dropCursor(),document.removeEventListener("keydown",this.onKeyDown)}},{key:"focusFirst",value:function(){this.dropCursor(),this.flipRight()}},{key:"flipLeft",value:function(){this.iterator.previous()}},{key:"flipRight",value:function(){this.iterator.next()}},{key:"dropCursor",value:function(){this.iterator.dropCursor()}},{key:"isEventReadyForHandling",value:function(t){var e=[s.keyCodes.TAB,s.keyCodes.ENTER],n=this.iterator.currentItem==document.activeElement;return this.allowArrows&&!n&&e.push(s.keyCodes.LEFT,s.keyCodes.RIGHT,s.keyCodes.UP,s.keyCodes.DOWN),this.activated&&-1!==e.indexOf(t.keyCode)}},{key:"handleTabPress",value:function(t){switch(t.shiftKey?a.default.directions.LEFT:a.default.directions.RIGHT){case a.default.directions.RIGHT:this.flipRight();break;case a.default.directions.LEFT:this.flipLeft()}}},{key:"handleEnterPress",value:function(t){this.activated&&(this.iterator.currentItem&&this.iterator.currentItem.click(),s.isFunction(this.activateCallback)&&this.activateCallback(this.iterator.currentItem),t.preventDefault(),t.stopPropagation())}},{key:"currentItem",get:function(){return this.iterator.currentItem}}],[{key:"usedKeys",get:function(){return[s.keyCodes.TAB,s.keyCodes.LEFT,s.keyCodes.RIGHT,s.keyCodes.ENTER,s.keyCodes.UP,s.keyCodes.DOWN]}}]),t}();o.default=u,u.displayName="Flipper",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(21),n(22),n(2),n(3),n(15),n(8),n(146),n(67),n(380),n(381),n(382),n(25)],void 0===(i="function"==typeof(o=function(t,e,o,r,i,a,s,c,l,u,f,d,p){"use strict";var h,v=n(13),y=n(1);Object.defineProperty(t,"__esModule",{value:!0}),t.default=t.BlockToolAPI=void 0,e=y(e),o=y(o),r=y(r),i=y(i),a=y(a),s=v(s),c=y(c),u=y(u),f=y(f),d=y(d),p=y(p),t.BlockToolAPI=h,function(t){t.APPEND_CALLBACK="appendCallback",t.RENDERED="rendered",t.MOVED="moved",t.UPDATED="updated",t.REMOVED="removed",t.ON_PASTE="onPaste"}(h||(t.BlockToolAPI=h={}));var g=function(){function t(e){var n=this,o=e.name,i=e.data,a=e.Tool,u=e.settings,f=e.api,d=e.readOnly;(0,r.default)(this,t),this.cachedInputs=[],this.inputIndex=0,this.modificationDebounceTimer=450,this.didMutated=s.debounce((function(){n.cachedInputs=[],n.updateCurrentInput(),n.call(h.UPDATED)}),this.modificationDebounceTimer),this.handleFocus=function(){n.cachedInputs=[],n.updateCurrentInput()},this.name=o,this.class=a,this.settings=u,this.config=u.config||{},this.api=f,this.blockAPI=new c.default(this),this.mutationObserver=new MutationObserver(this.didMutated),this.tool=new a({data:i,config:this.config,api:this.api.getMethodsForTool(o,l.ToolType.Block),block:this.blockAPI,readOnly:d}),this.holder=this.compose(),this.tunes=this.makeTunes()}var n,v,y;return(0,i.default)(t,[{key:"mergeable",value:function(){return s.isFunction(this.tool.merge)}},{key:"call",value:function(t,e){if(this.tool[t]&&this.tool[t]instanceof Function){t===h.APPEND_CALLBACK&&s.log("`appendCallback` hook is deprecated and will be removed in the next major release. Use `rendered` hook instead","warn");try{this.tool[t].call(this.tool,e)}catch(e){s.log("Error during '".concat(t,"' call: ").concat(e.message),"error")}}}},{key:"mergeWith",value:(y=(0,o.default)(e.default.mark((function t(n){return e.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,this.tool.merge(n);case 2:case"end":return t.stop()}}),t,this)}))),function(t){return y.apply(this,arguments)})},{key:"save",value:(v=(0,o.default)(e.default.mark((function t(){var n,o,r,i=this;return e.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,this.tool.save(this.pluginsContent);case 2:return n=t.sent,o=window.performance.now(),t.abrupt("return",Promise.resolve(n).then((function(t){return r=window.performance.now(),{tool:i.name,data:t,time:r-o}})).catch((function(t){s.log("Saving proccess for ".concat(i.name," tool failed due to the ").concat(t),"log","red")})));case 5:case"end":return t.stop()}}),t,this)}))),function(){return v.apply(this,arguments)})},{key:"validate",value:(n=(0,o.default)(e.default.mark((function t(n){var o;return e.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:if(o=!0,!(this.tool.validate instanceof Function)){t.next=5;break}return t.next=4,this.tool.validate(n);case 4:o=t.sent;case 5:return t.abrupt("return",o);case 6:case"end":return t.stop()}}),t,this)}))),function(t){return n.apply(this,arguments)})},{key:"makeTunes",value:function(){var t=this;return[{name:"moveUp",Tune:u.default},{name:"delete",Tune:f.default},{name:"moveDown",Tune:d.default}].map((function(e){var n=e.name;return new(0,e.Tune)({api:t.api.getMethodsForTool(n,l.ToolType.Tune),settings:t.config})}))}},{key:"renderTunes",value:function(){var t=document.createDocumentFragment();return this.tunes.forEach((function(e){a.default.append(t,e.render())})),t}},{key:"updateCurrentInput",value:function(){this.currentInput=a.default.isNativeInput(document.activeElement)||!p.default.anchorNode?document.activeElement:p.default.anchorNode}},{key:"willSelect",value:function(){this.mutationObserver.observe(this.holder.firstElementChild,{childList:!0,subtree:!0,characterData:!0,attributes:!0}),this.addInputEvents()}},{key:"willUnselect",value:function(){this.mutationObserver.disconnect(),this.removeInputEvents()}},{key:"compose",value:function(){var e=a.default.make("div",t.CSS.wrapper),n=a.default.make("div",t.CSS.content),o=this.tool.render();return n.appendChild(o),e.appendChild(n),e}},{key:"addInputEvents",value:function(){var t=this;this.inputs.forEach((function(e){e.addEventListener("focus",t.handleFocus)}))}},{key:"removeInputEvents",value:function(){var t=this;this.inputs.forEach((function(e){e.removeEventListener("focus",t.handleFocus)}))}},{key:"inputs",get:function(){if(0!==this.cachedInputs.length)return this.cachedInputs;var t=a.default.findAllInputs(this.holder);return this.inputIndex>t.length-1&&(this.inputIndex=t.length-1),this.cachedInputs=t,t}},{key:"currentInput",get:function(){return this.inputs[this.inputIndex]},set:function(t){var e=this.inputs.findIndex((function(e){return e===t||e.contains(t)}));-1!==e&&(this.inputIndex=e)}},{key:"firstInput",get:function(){return this.inputs[0]}},{key:"lastInput",get:function(){var t=this.inputs;return t[t.length-1]}},{key:"nextInput",get:function(){return this.inputs[this.inputIndex+1]}},{key:"previousInput",get:function(){return this.inputs[this.inputIndex-1]}},{key:"data",get:function(){return this.save().then((function(t){return t&&!s.isEmpty(t.data)?t.data:{}}))}},{key:"sanitize",get:function(){return this.tool.sanitize}},{key:"isEmpty",get:function(){var t=a.default.isEmpty(this.pluginsContent),e=!this.hasMedia;return t&&e}},{key:"hasMedia",get:function(){return!!this.holder.querySelector(["img","iframe","video","audio","source","input","textarea","twitterwidget"].join(","))}},{key:"focused",set:function(e){this.holder.classList.toggle(t.CSS.focused,e)},get:function(){return this.holder.classList.contains(t.CSS.focused)}},{key:"selected",set:function(e){e?this.holder.classList.add(t.CSS.selected):this.holder.classList.remove(t.CSS.selected)},get:function(){return this.holder.classList.contains(t.CSS.selected)}},{key:"stretched",set:function(e){this.holder.classList.toggle(t.CSS.wrapperStretched,e)},get:function(){return this.holder.classList.contains(t.CSS.wrapperStretched)}},{key:"dropTarget",set:function(e){this.holder.classList.toggle(t.CSS.dropTarget,e)}},{key:"pluginsContent",get:function(){var e=this.holder.querySelector(".".concat(t.CSS.content));if(e&&e.childNodes.length)for(var n=e.childNodes.length-1;n>=0;n--){var o=e.childNodes[n];if(!a.default.isExtensionNode(o))return o}return null}}],[{key:"CSS",get:function(){return{wrapper:"ce-block",wrapperStretched:"ce-block--stretched",content:"ce-block__content",focused:"ce-block--focused",selected:"ce-block--selected",dropTarget:"ce-block--drop-target"}}}]),t}();t.default=g,g.displayName="Block"})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o=n(36);t.exports=Object("z").propertyIsEnumerable(0)?Object:function(t){return"String"==o(t)?t.split(""):Object(t)}},function(t,e){e.f={}.propertyIsEnumerable},function(t,e,n){var o=n(36),r=n(14)("toStringTag"),i="Arguments"==o(function(){return arguments}());t.exports=function(t){var e,n,a;return void 0===t?"Undefined":null===t?"Null":"string"==typeof(n=function(t,e){try{return t[e]}catch(t){}}(e=Object(t),r))?n:i?o(e):"Object"==(a=o(e))&&"function"==typeof e.callee?"Arguments":a}},function(t,e,n){var o=n(11),r=n(31),i=n(14)("species");t.exports=function(t,e){var n,a=o(t).constructor;return void 0===a||null==(n=o(a)[i])?e:r(n)}},function(t,e,n){var o=n(364),r=n(365),i=n(141),a=n(366);t.exports=function(t){return o(t)||r(t)||i(t)||a()}},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(39),n(21),n(22),n(52),n(2),n(3),n(5),n(6),n(4),n(374),n(7),n(8),n(375),n(376),n(377),n(378)],void 0===(i="function"==typeof(o=function(t,e,o,r,i,a,s,c,l,u,f,d,p,h,v,y,g){"use strict";var b=n(13),m=n(1);function k(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(t,"__esModule",{value:!0}),t.ToolType=t.default=void 0,e=m(e),o=m(o),r=m(r),i=m(i),a=m(a),s=m(s),c=m(c),l=m(l),u=m(u),f=m(f),d=m(d),p=b(p),h=m(h),v=m(v),y=m(y),g=m(g);var x,S=function(t){(0,c.default)(b,t);var n,d=(n=b,function(){var t,e=(0,u.default)(n);if(k()){var o=(0,u.default)(this).constructor;t=Reflect.construct(e,arguments,o)}else t=e.apply(this,arguments);return(0,l.default)(this,t)});function b(t){var e,n=t.config;return(0,a.default)(this,b),(e=d.call(this,{config:n})).stubTool="stub",e.toolsClasses={},e.toolsAvailable={},e.toolsUnavailable={},e.toolsSettings={},e._inlineTools={},e.toolsClasses={},e.toolsSettings={},e.toolsAvailable={},e.toolsUnavailable={},e._inlineTools=null,e}return(0,s.default)(b,[{key:"prepare",value:function(){var t=this;if(this.validateTools(),this.config.tools=p.deepMerge({},this.internalTools,this.config.tools),!Object.prototype.hasOwnProperty.call(this.config,"tools")||0===Object.keys(this.config.tools).length)throw Error("Can't start without tools");for(var e in this.config.tools)"object"===(0,i.default)(this.config.tools[e])?(this.toolsClasses[e]=this.config.tools[e].class,this.toolsSettings[e]=this.config.tools[e],delete this.toolsSettings[e].class):(this.toolsClasses[e]=this.config.tools[e],this.toolsSettings[e]={class:this.config.tools[e]});var n=this.getListOfPrepareFunctions();return 0===n.length?Promise.resolve():p.sequence(n,(function(e){t.success(e)}),(function(e){t.fallback(e)}))}},{key:"success",value:function(t){this.toolsAvailable[t.toolName]=this.toolsClasses[t.toolName]}},{key:"fallback",value:function(t){this.toolsUnavailable[t.toolName]=this.toolsClasses[t.toolName]}},{key:"constructInline",value:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o={api:this.Editor.API.getMethodsForTool(e),config:n[this.USER_SETTINGS.CONFIG]||{}};return new t(o)}},{key:"isDefault",value:function(t){return t instanceof this.available[this.config.defaultBlock]}},{key:"getToolSettings",value:function(t){var e=this.toolsSettings[t],n=e[this.USER_SETTINGS.CONFIG]||{};return t!==this.config.defaultBlock||n.placeholder||(n.placeholder=this.config.placeholder,e[this.USER_SETTINGS.CONFIG]=n),e}},{key:"isReadOnlySupported",value:function(t){return!0===t[this.INTERNAL_SETTINGS.IS_READ_ONLY_SUPPORTED]}},{key:"destroy",value:function(){Object.values(this.available).forEach(function(){var t=(0,r.default)(o.default.mark((function t(e){return o.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:if(!p.isFunction(e.reset)){t.next=3;break}return t.next=3,e.reset();case 3:case"end":return t.stop()}}),t)})));return function(e){return t.apply(this,arguments)}}())}},{key:"getListOfPrepareFunctions",value:function(){var t=[];for(var e in this.toolsClasses)if(Object.prototype.hasOwnProperty.call(this.toolsClasses,e)){var n=this.toolsClasses[e],o=this.toolsSettings[e][this.USER_SETTINGS.CONFIG];t.push({function:p.isFunction(n.prepare)?n.prepare:function(){},data:{toolName:e,config:o}})}return t}},{key:"validateTools",value:function(){for(var t in this.config.tools)if(Object.prototype.hasOwnProperty.call(this.config.tools,t)){if(t in this.internalTools)return;var e=this.config.tools[t];if(!p.isFunction(e)&&!p.isFunction(e.class))throw Error("Tool «".concat(t,"» must be a constructor function or an object with function in the «class» property"))}}},{key:"available",get:function(){return this.toolsAvailable}},{key:"unavailable",get:function(){return this.toolsUnavailable}},{key:"inline",get:function(){var t=this;if(this._inlineTools)return this._inlineTools;var n=Object.entries(this.available).filter((function(n){var o=(0,e.default)(n,2),r=o[0],i=o[1];if(!i[t.INTERNAL_SETTINGS.IS_INLINE])return!1;var a=["render","surround","checkState"].filter((function(e){return!t.constructInline(i,r)[e]}));return!a.length||(p.log("Incorrect Inline Tool: ".concat(i.name,". Some of required methods is not implemented %o"),"warn",a),!1)})),o={};return n.forEach((function(t){var n=(0,e.default)(t,2),r=n[0],i=n[1];o[r]=i})),this._inlineTools=o,this._inlineTools}},{key:"blockTools",get:function(){var t=this,n=Object.entries(this.available).filter((function(n){return!(0,e.default)(n,2)[1][t.INTERNAL_SETTINGS.IS_INLINE]})),o={};return n.forEach((function(t){var n=(0,e.default)(t,2),r=n[0],i=n[1];o[r]=i})),o}},{key:"INTERNAL_SETTINGS",get:function(){return{IS_ENABLED_LINE_BREAKS:"enableLineBreaks",IS_INLINE:"isInline",TITLE:"title",SHORTCUT:"shortcut",TOOLBOX:"toolbox",SANITIZE_CONFIG:"sanitize",CONVERSION_CONFIG:"conversionConfig",IS_READ_ONLY_SUPPORTED:"isReadOnlySupported"}}},{key:"USER_SETTINGS",get:function(){return{SHORTCUT:"shortcut",TOOLBOX:"toolbox",ENABLED_INLINE_TOOLS:"inlineToolbar",CONFIG:"config"}}},{key:"internalTools",get:function(){return{bold:{class:h.default},italic:{class:v.default},link:{class:y.default},paragraph:{class:f.default,inlineToolbar:!0},stub:{class:g.default}}}}]),b}(d.default);t.default=S,S.displayName="Tools",t.ToolType=x,function(t){t[t.Block=0]="Block",t[t.Inline=1]="Inline",t[t.Tune=2]="Tune"}(x||(t.ToolType=x={}))})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o=n(17),r=n(9),i=r["__core-js_shared__"]||(r["__core-js_shared__"]={});(t.exports=function(t,e){return i[t]||(i[t]=void 0!==e?e:{})})("versions",[]).push({version:o.version,mode:n(44)?"pure":"global",copyright:"© 2019 Denis Pushkarev (zloirock.ru)"})},function(t,e,n){var o=n(28),r=n(16),i=n(46);t.exports=function(t){return function(e,n,a){var s,c=o(e),l=r(c.length),u=i(a,l);if(t&&n!=n){for(;l>u;)if((s=c[u++])!=s)return!0}else for(;l>u;u++)if((t||u in c)&&c[u]===n)return t||u||0;return!t&&-1}}},function(t,e){e.f=Object.getOwnPropertySymbols},function(t,e,n){var o=n(36);t.exports=Array.isArray||function(t){return"Array"==o(t)}},function(t,e,n){var o=n(14)("iterator"),r=!1;try{var i=[7][o]();i.return=function(){r=!0},Array.from(i,(function(){throw 2}))}catch(t){}t.exports=function(t,e){if(!e&&!r)return!1;var n=!1;try{var i=[7],a=i[o]();a.next=function(){return{done:n=!0}},i[o]=function(){return a},t(i)}catch(t){}return n}},function(t,e,n){"use strict";var o=n(11);t.exports=function(){var t=o(this),e="";return t.global&&(e+="g"),t.ignoreCase&&(e+="i"),t.multiline&&(e+="m"),t.unicode&&(e+="u"),t.sticky&&(e+="y"),e}},function(t,e,n){"use strict";var o=n(64),r=RegExp.prototype.exec;t.exports=function(t,e){var n=t.exec;if("function"==typeof n){var i=n.call(t,e);if("object"!=typeof i)throw new TypeError("RegExp exec method returned something other than an Object or null");return i}if("RegExp"!==o(t))throw new TypeError("RegExp#exec called on incompatible receiver");return r.call(t,e)}},function(t,e,n){"use strict";n(129);var o=n(23),r=n(27),i=n(10),a=n(37),s=n(14),c=n(104),l=s("species"),u=!i((function(){var t=/./;return t.exec=function(){var t=[];return t.groups={a:"7"},t},"7"!=="".replace(t,"$<a>")})),f=function(){var t=/(?:)/,e=t.exec;t.exec=function(){return e.apply(this,arguments)};var n="ab".split(t);return 2===n.length&&"a"===n[0]&&"b"===n[1]}();t.exports=function(t,e,n){var d=s(t),p=!i((function(){var e={};return e[d]=function(){return 7},7!=""[t](e)})),h=p?!i((function(){var e=!1,n=/a/;return n.exec=function(){return e=!0,null},"split"===t&&(n.constructor={},n.constructor[l]=function(){return n}),n[d](""),!e})):void 0;if(!p||!h||"replace"===t&&!u||"split"===t&&!f){var v=/./[d],y=n(a,d,""[t],(function(t,e,n,o,r){return e.exec===c?p&&!r?{done:!0,value:v.call(e,n,o)}:{done:!0,value:t.call(n,e,o)}:{done:!1}})),g=y[0],b=y[1];o(String.prototype,t,g),r(RegExp.prototype,d,2==e?function(t,e){return b.call(t,this,e)}:function(t){return b.call(t,this)})}}},function(t,e,n){var o=n(30),r=n(124),i=n(99),a=n(11),s=n(16),c=n(101),l={},u={};(e=t.exports=function(t,e,n,f,d){var p,h,v,y,g=d?function(){return t}:c(t),b=o(n,f,e?2:1),m=0;if("function"!=typeof g)throw TypeError(t+" is not iterable!");if(i(g)){for(p=s(t.length);p>m;m++)if((y=e?b(a(h=t[m])[0],h[1]):b(t[m]))===l||y===u)return y}else for(v=g.call(t);!(h=v.next()).done;)if((y=r(v,b,h.value,e))===l||y===u)return y}).BREAK=l,e.RETURN=u},function(t,e,n){var o=n(9).navigator;t.exports=o&&o.userAgent||""},function(t,e,n){"use strict";var o=n(9),r=n(0),i=n(23),a=n(58),s=n(41),c=n(76),l=n(57),u=n(12),f=n(10),d=n(72),p=n(53),h=n(90);t.exports=function(t,e,n,v,y,g){var b=o[t],m=b,k=y?"set":"add",x=m&&m.prototype,S={},w=function(t){var e=x[t];i(x,t,"delete"==t||"has"==t?function(t){return!(g&&!u(t))&&e.call(this,0===t?0:t)}:"get"==t?function(t){return g&&!u(t)?void 0:e.call(this,0===t?0:t)}:"add"==t?function(t){return e.call(this,0===t?0:t),this}:function(t,n){return e.call(this,0===t?0:t,n),this})};if("function"==typeof m&&(g||x.forEach&&!f((function(){(new m).entries().next()})))){var E=new m,T=E[k](g?{}:-0,1)!=E,C=f((function(){E.has(1)})),B=d((function(t){new m(t)})),_=!g&&f((function(){for(var t=new m,e=5;e--;)t[k](e,e);return!t.has(-0)}));B||((m=e((function(e,n){l(e,m,t);var o=h(new b,e,m);return null!=n&&c(n,y,o[k],o),o}))).prototype=x,x.constructor=m),(C||_)&&(w("delete"),w("has"),y&&w("get")),(_||T)&&w(k),g&&x.clear&&delete x.clear}else m=v.getConstructor(e,t,y,k),a(m.prototype,n),s.NEED=!0;return p(m,t),S[t]=m,r(r.G+r.W+r.F*(m!=b),S),g||v.setStrong(m,t,y),m}},function(t,e,n){for(var o,r=n(9),i=n(27),a=n(43),s=a("typed_array"),c=a("view"),l=!(!r.ArrayBuffer||!r.DataView),u=l,f=0,d="Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array".split(",");f<9;)(o=r[d[f++]])?(i(o.prototype,s,!0),i(o.prototype,c,!0)):u=!1;t.exports={ABV:l,CONSTR:u,TYPED:s,VIEW:c}},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7),n(67)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u){"use strict";var f=n(1);function d(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=f(r),i=f(i),a=f(a),s=f(s),c=f(c);var p=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(d()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"getMethodsForTool",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:u.ToolType.Block;return Object.assign(this.methods,{i18n:this.Editor.I18nAPI.getMethodsForTool(t,e)})}},{key:"methods",get:function(){return{blocks:this.Editor.BlocksAPI.methods,caret:this.Editor.CaretAPI.methods,events:this.Editor.EventsAPI.methods,listeners:this.Editor.ListenersAPI.methods,notifier:this.Editor.NotifierAPI.methods,sanitizer:this.Editor.SanitizerAPI.methods,saver:this.Editor.SaverAPI.methods,selection:this.Editor.SelectionAPI.methods,styles:this.Editor.StylesAPI.classes,toolbar:this.Editor.ToolbarAPI.methods,inlineToolbar:this.Editor.InlineToolbarAPI.methods,tooltip:this.Editor.TooltipAPI.methods,i18n:this.Editor.I18nAPI.methods,readOnly:this.Editor.ReadOnlyAPI.methods}}}]),o}((l=f(l)).default);o.default=p,p.displayName="API",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7),n(15),n(8),n(59),n(82)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d,p){"use strict";var h=n(13),v=n(1);function y(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=v(r),i=v(i),a=v(a),s=v(s),c=v(c),l=v(l),u=v(u),f=h(f),d=v(d);var g=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(y()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"toggleReadOnly",value:function(t){t?(this.destroy(),this.disableModuleBindings()):(this.drawUI(),this.enableModuleBindings())}},{key:"move",value:function(){var t=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];t&&(this.Editor.Toolbox.close(),this.Editor.BlockSettings.close());var e=this.Editor.BlockManager.currentBlock.holder;if(e){var n=this.Editor.UI.isMobile,o=e.offsetHeight,r=e.offsetTop;if(n)r+=o;else{var i=Math.floor(o/2);this.nodes.plusButton.style.transform="translate3d(0, calc(".concat(i,"px - 50%), 0)"),this.Editor.Toolbox.nodes.toolbox.style.transform="translate3d(0, calc(".concat(i,"px - 50%), 0)")}this.nodes.wrapper.style.transform="translate3D(0, ".concat(Math.floor(r),"px, 0)")}}},{key:"open",value:function(){var t=this,e=!(arguments.length>0&&void 0!==arguments[0])||arguments[0],n=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];f.delay((function(){t.move(n),t.nodes.wrapper.classList.add(t.CSS.toolbarOpened),e?t.blockActions.show():t.blockActions.hide()}),50)()}},{key:"close",value:function(){this.nodes.wrapper.classList.remove(this.CSS.toolbarOpened),this.blockActions.hide(),this.Editor.Toolbox.close(),this.Editor.BlockSettings.close()}},{key:"make",value:function(){var t=this;this.nodes.wrapper=u.default.make("div",this.CSS.toolbar),["content","actions"].forEach((function(e){t.nodes[e]=u.default.make("div",t.CSS[e])})),u.default.append(this.nodes.wrapper,this.nodes.content),u.default.append(this.nodes.content,this.nodes.actions),this.nodes.plusButton=u.default.make("div",this.CSS.plusButton),u.default.append(this.nodes.plusButton,u.default.svg("plus",14,14)),u.default.append(this.nodes.content,this.nodes.plusButton),this.readOnlyMutableListeners.on(this.nodes.plusButton,"click",(function(){t.plusButtonClicked()}),!1);var e=u.default.make("div");e.appendChild(document.createTextNode(d.default.ui(p.I18nInternalNS.ui.toolbar.toolbox,"Add"))),e.appendChild(u.default.make("div",this.CSS.plusButtonShortcut,{textContent:"⇥ Tab"})),this.Editor.Tooltip.onHover(this.nodes.plusButton,e),this.nodes.blockActionsButtons=u.default.make("div",this.CSS.blockActionsButtons),this.nodes.settingsToggler=u.default.make("span",this.CSS.settingsToggler);var n=u.default.svg("dots",8,8);u.default.append(this.nodes.settingsToggler,n),u.default.append(this.nodes.blockActionsButtons,this.nodes.settingsToggler),u.default.append(this.nodes.actions,this.nodes.blockActionsButtons),this.Editor.Tooltip.onHover(this.nodes.settingsToggler,d.default.ui(p.I18nInternalNS.ui.blockTunes.toggler,"Click to tune"),{placement:"top"}),u.default.append(this.nodes.content,this.Editor.Toolbox.nodes.toolbox),u.default.append(this.nodes.actions,this.Editor.BlockSettings.nodes.wrapper),u.default.append(this.Editor.UI.nodes.wrapper,this.nodes.wrapper)}},{key:"plusButtonClicked",value:function(){this.Editor.Toolbox.toggle()}},{key:"enableModuleBindings",value:function(){var t=this;this.readOnlyMutableListeners.on(this.nodes.settingsToggler,"click",(function(){t.settingsTogglerClicked()}))}},{key:"disableModuleBindings",value:function(){this.readOnlyMutableListeners.clearAll()}},{key:"settingsTogglerClicked",value:function(){this.Editor.BlockSettings.opened?this.Editor.BlockSettings.close():this.Editor.BlockSettings.open()}},{key:"drawUI",value:function(){this.Editor.BlockSettings.make(),this.Editor.Toolbox.make(),this.make()}},{key:"destroy",value:function(){this.Editor.Toolbox.destroy(),this.Editor.BlockSettings.destroy(),this.removeAllNodes()}},{key:"CSS",get:function(){return{toolbar:"ce-toolbar",content:"ce-toolbar__content",actions:"ce-toolbar__actions",actionsOpened:"ce-toolbar__actions--opened",toolbarOpened:"ce-toolbar--opened",plusButton:"ce-toolbar__plus",plusButtonShortcut:"ce-toolbar__plus-shortcut",plusButtonHidden:"ce-toolbar__plus--hidden",blockActionsButtons:"ce-toolbar__actions-buttons",settingsToggler:"ce-toolbar__settings-btn"}}},{key:"opened",get:function(){return this.nodes.wrapper.classList.contains(this.CSS.toolbarOpened)}},{key:"plusButton",get:function(){var t=this;return{hide:function(){return t.nodes.plusButton.classList.add(t.CSS.plusButtonHidden)},show:function(){t.Editor.Toolbox.isEmpty||t.nodes.plusButton.classList.remove(t.CSS.plusButtonHidden)}}}},{key:"blockActions",get:function(){var t=this;return{hide:function(){t.nodes.actions.classList.remove(t.CSS.actionsOpened)},show:function(){t.nodes.actions.classList.add(t.CSS.actionsOpened)}}}}]),o}(l.default);o.default=g,g.displayName="Toolbar",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(39),n(143),n(8)],void 0===(i="function"==typeof(o=function(t,e,o,r){"use strict";var i=n(1);Object.defineProperty(t,"__esModule",{value:!0}),t.I18nInternalNS=void 0,e=i(e);var a=function t(n,o){var i={};return Object.entries(n).forEach((function(n){var a=(0,e.default)(n,2),s=a[0],c=a[1];if("object"!==(0,r.typeOf)(c))i[s]=c;else{var l=o?"".concat(o,".").concat(s):s,u=Object.values(c).every((function(t){return"string"===(0,r.typeOf)(t)}));i[s]=u?l:t(c,l)}})),i}((o=i(o)).default);t.I18nInternalNS=a})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o=n(12),r=n(9).document,i=o(r)&&o(r.createElement);t.exports=function(t){return i?r.createElement(t):{}}},function(t,e,n){e.f=n(14)},function(t,e,n){var o=n(68)("keys"),r=n(43);t.exports=function(t){return o[t]||(o[t]=r(t))}},function(t,e){t.exports="constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf".split(",")},function(t,e,n){var o=n(9).document;t.exports=o&&o.documentElement},function(t,e,n){var o=n(12),r=n(11),i=function(t,e){if(r(t),!o(e)&&null!==e)throw TypeError(e+": can't set as prototype!")};t.exports={set:Object.setPrototypeOf||("__proto__"in{}?function(t,e,o){try{(o=n(30)(Function.call,n(33).f(Object.prototype,"__proto__").set,2))(t,[]),e=!(t instanceof Array)}catch(t){e=!0}return function(t,n){return i(t,n),e?t.__proto__=n:o(t,n),t}}({},!1):void 0),check:i}},function(t,e){t.exports="\t\n\v\f\r   ᠎             　\u2028\u2029\ufeff"},function(t,e,n){var o=n(12),r=n(88).set;t.exports=function(t,e,n){var i,a=e.constructor;return a!==n&&"function"==typeof a&&(i=a.prototype)!==n.prototype&&o(i)&&r&&r(t,i),t}},function(t,e,n){"use strict";var o=n(32),r=n(37);t.exports=function(t){var e=String(r(this)),n="",i=o(t);if(i<0||i==1/0)throw RangeError("Count can't be negative");for(;i>0;(i>>>=1)&&(e+=e))1&i&&(n+=e);return n}},function(t,e){t.exports=Math.sign||function(t){return 0==(t=+t)||t!=t?t:t<0?-1:1}},function(t,e){var n=Math.expm1;t.exports=!n||n(10)>22025.465794806718||n(10)<22025.465794806718||-2e-17!=n(-2e-17)?function(t){return 0==(t=+t)?t:t>-1e-6&&t<1e-6?t+t*t/2:Math.exp(t)-1}:n},function(t,e,n){var o=n(32),r=n(37);t.exports=function(t){return function(e,n){var i,a,s=String(r(e)),c=o(n),l=s.length;return c<0||c>=l?t?"":void 0:(i=s.charCodeAt(c))<55296||i>56319||c+1===l||(a=s.charCodeAt(c+1))<56320||a>57343?t?s.charAt(c):i:t?s.slice(c,c+2):a-56320+(i-55296<<10)+65536}}},function(t,e,n){"use strict";var o=n(44),r=n(0),i=n(23),a=n(27),s=n(55),c=n(123),l=n(53),u=n(49),f=n(14)("iterator"),d=!([].keys&&"next"in[].keys()),p=function(){return this};t.exports=function(t,e,n,h,v,y,g){c(n,e,h);var b,m,k,x=function(t){if(!d&&t in T)return T[t];switch(t){case"keys":case"values":return function(){return new n(this,t)}}return function(){return new n(this,t)}},S=e+" Iterator",w="values"==v,E=!1,T=t.prototype,C=T[f]||T["@@iterator"]||v&&T[v],B=C||x(v),_=v?w?x("entries"):B:void 0,O="Array"==e&&T.entries||C;if(O&&(k=u(O.call(new t)))!==Object.prototype&&k.next&&(l(k,S,!0),o||"function"==typeof k[f]||a(k,f,p)),w&&C&&"values"!==C.name&&(E=!0,B=function(){return C.call(this)}),o&&!g||!d&&!E&&T[f]||a(T,f,B),s[e]=B,s[S]=p,v)if(b={values:w?B:x("values"),keys:y?B:x("keys"),entries:_},g)for(m in b)m in T||i(T,m,b[m]);else r(r.P+r.F*(d||E),e,b);return b}},function(t,e,n){var o=n(97),r=n(37);t.exports=function(t,e,n){if(o(e))throw TypeError("String#"+n+" doesn't accept regex!");return String(r(t))}},function(t,e,n){var o=n(12),r=n(36),i=n(14)("match");t.exports=function(t){var e;return o(t)&&(void 0!==(e=t[i])?!!e:"RegExp"==r(t))}},function(t,e,n){var o=n(14)("match");t.exports=function(t){var e=/./;try{"/./"[t](e)}catch(n){try{return e[o]=!1,!"/./"[t](e)}catch(t){}}return!0}},function(t,e,n){var o=n(55),r=n(14)("iterator"),i=Array.prototype;t.exports=function(t){return void 0!==t&&(o.Array===t||i[r]===t)}},function(t,e,n){"use strict";var o=n(19),r=n(42);t.exports=function(t,e,n){e in t?o.f(t,e,r(0,n)):t[e]=n}},function(t,e,n){var o=n(64),r=n(14)("iterator"),i=n(55);t.exports=n(17).getIteratorMethod=function(t){if(null!=t)return t[r]||t["@@iterator"]||i[o(t)]}},function(t,e,n){"use strict";var o=n(20),r=n(46),i=n(16);t.exports=function(t){for(var e=o(this),n=i(e.length),a=arguments.length,s=r(a>1?arguments[1]:void 0,n),c=a>2?arguments[2]:void 0,l=void 0===c?n:r(c,n);l>s;)e[s++]=t;return e}},function(t,e,n){"use strict";var o=n(50),r=n(128),i=n(55),a=n(28);t.exports=n(95)(Array,"Array",(function(t,e){this._t=a(t),this._i=0,this._k=e}),(function(){var t=this._t,e=this._k,n=this._i++;return!t||n>=t.length?(this._t=void 0,r(1)):r(0,"keys"==e?n:"values"==e?t[n]:[n,t[n]])}),"values"),i.Arguments=i.Array,o("keys"),o("values"),o("entries")},function(t,e,n){"use strict";var o,r,i=n(73),a=RegExp.prototype.exec,s=String.prototype.replace,c=a,l=(o=/a/,r=/b*/g,a.call(o,"a"),a.call(r,"a"),0!==o.lastIndex||0!==r.lastIndex),u=void 0!==/()??/.exec("")[1];(l||u)&&(c=function(t){var e,n,o,r,c=this;return u&&(n=new RegExp("^"+c.source+"$(?!\\s)",i.call(c))),l&&(e=c.lastIndex),o=a.call(c,t),l&&o&&(c.lastIndex=c.global?o.index+o[0].length:e),u&&o&&o.length>1&&s.call(o[0],n,(function(){for(r=1;r<arguments.length-2;r++)void 0===arguments[r]&&(o[r]=void 0)})),o}),t.exports=c},function(t,e,n){"use strict";var o=n(94)(!0);t.exports=function(t,e,n){return e+(n?o(t,e).length:1)}},function(t,e,n){var o,r,i,a=n(30),s=n(117),c=n(87),l=n(83),u=n(9),f=u.process,d=u.setImmediate,p=u.clearImmediate,h=u.MessageChannel,v=u.Dispatch,y=0,g={},b=function(){var t=+this;if(g.hasOwnProperty(t)){var e=g[t];delete g[t],e()}},m=function(t){b.call(t.data)};d&&p||(d=function(t){for(var e=[],n=1;arguments.length>n;)e.push(arguments[n++]);return g[++y]=function(){s("function"==typeof t?t:Function(t),e)},o(y),y},p=function(t){delete g[t]},"process"==n(36)(f)?o=function(t){f.nextTick(a(b,t,1))}:v&&v.now?o=function(t){v.now(a(b,t,1))}:h?(i=(r=new h).port2,r.port1.onmessage=m,o=a(i.postMessage,i,1)):u.addEventListener&&"function"==typeof postMessage&&!u.importScripts?(o=function(t){u.postMessage(t+"","*")},u.addEventListener("message",m,!1)):o="onreadystatechange"in l("script")?function(t){c.appendChild(l("script")).onreadystatechange=function(){c.removeChild(this),b.call(t)}}:function(t){setTimeout(a(b,t,1),0)}),t.exports={set:d,clear:p}},function(t,e,n){"use strict";var o=n(9),r=n(18),i=n(44),a=n(79),s=n(27),c=n(58),l=n(10),u=n(57),f=n(32),d=n(16),p=n(136),h=n(48).f,v=n(19).f,y=n(102),g=n(53),b=o.ArrayBuffer,m=o.DataView,k=o.Math,x=o.RangeError,S=o.Infinity,w=b,E=k.abs,T=k.pow,C=k.floor,B=k.log,_=k.LN2,O=r?"_b":"buffer",I=r?"_l":"byteLength",N=r?"_o":"byteOffset";function R(t,e,n){var o,r,i,a=new Array(n),s=8*n-e-1,c=(1<<s)-1,l=c>>1,u=23===e?T(2,-24)-T(2,-77):0,f=0,d=t<0||0===t&&1/t<0?1:0;for((t=E(t))!=t||t===S?(r=t!=t?1:0,o=c):(o=C(B(t)/_),t*(i=T(2,-o))<1&&(o--,i*=2),(t+=o+l>=1?u/i:u*T(2,1-l))*i>=2&&(o++,i/=2),o+l>=c?(r=0,o=c):o+l>=1?(r=(t*i-1)*T(2,e),o+=l):(r=t*T(2,l-1)*T(2,e),o=0));e>=8;a[f++]=255&r,r/=256,e-=8);for(o=o<<e|r,s+=e;s>0;a[f++]=255&o,o/=256,s-=8);return a[--f]|=128*d,a}function M(t,e,n){var o,r=8*n-e-1,i=(1<<r)-1,a=i>>1,s=r-7,c=n-1,l=t[c--],u=127&l;for(l>>=7;s>0;u=256*u+t[c],c--,s-=8);for(o=u&(1<<-s)-1,u>>=-s,s+=e;s>0;o=256*o+t[c],c--,s-=8);if(0===u)u=1-a;else{if(u===i)return o?NaN:l?-S:S;o+=T(2,e),u-=a}return(l?-1:1)*o*T(2,u-e)}function L(t){return t[3]<<24|t[2]<<16|t[1]<<8|t[0]}function A(t){return[255&t]}function P(t){return[255&t,t>>8&255]}function D(t){return[255&t,t>>8&255,t>>16&255,t>>24&255]}function j(t){return R(t,52,8)}function F(t){return R(t,23,4)}function U(t,e,n){v(t.prototype,e,{get:function(){return this[n]}})}function H(t,e,n,o){var r=p(+n);if(r+e>t[I])throw x("Wrong index!");var i=t[O]._b,a=r+t[N],s=i.slice(a,a+e);return o?s:s.reverse()}function z(t,e,n,o,r,i){var a=p(+n);if(a+e>t[I])throw x("Wrong index!");for(var s=t[O]._b,c=a+t[N],l=o(+r),u=0;u<e;u++)s[c+u]=l[i?u:e-u-1]}if(a.ABV){if(!l((function(){b(1)}))||!l((function(){new b(-1)}))||l((function(){return new b,new b(1.5),new b(NaN),"ArrayBuffer"!=b.name}))){for(var W,G=(b=function(t){return u(this,b),new w(p(t))}).prototype=w.prototype,X=h(w),V=0;X.length>V;)(W=X[V++])in b||s(b,W,w[W]);i||(G.constructor=b)}var Y=new m(new b(2)),K=m.prototype.setInt8;Y.setInt8(0,2147483648),Y.setInt8(1,2147483649),!Y.getInt8(0)&&Y.getInt8(1)||c(m.prototype,{setInt8:function(t,e){K.call(this,t,e<<24>>24)},setUint8:function(t,e){K.call(this,t,e<<24>>24)}},!0)}else b=function(t){u(this,b,"ArrayBuffer");var e=p(t);this._b=y.call(new Array(e),0),this[I]=e},m=function(t,e,n){u(this,m,"DataView"),u(t,b,"DataView");var o=t[I],r=f(e);if(r<0||r>o)throw x("Wrong offset!");if(r+(n=void 0===n?o-r:d(n))>o)throw x("Wrong length!");this[O]=t,this[N]=r,this[I]=n},r&&(U(b,"byteLength","_l"),U(m,"buffer","_b"),U(m,"byteLength","_l"),U(m,"byteOffset","_o")),c(m.prototype,{getInt8:function(t){return H(this,1,t)[0]<<24>>24},getUint8:function(t){return H(this,1,t)[0]},getInt16:function(t){var e=H(this,2,t,arguments[1]);return(e[1]<<8|e[0])<<16>>16},getUint16:function(t){var e=H(this,2,t,arguments[1]);return e[1]<<8|e[0]},getInt32:function(t){return L(H(this,4,t,arguments[1]))},getUint32:function(t){return L(H(this,4,t,arguments[1]))>>>0},getFloat32:function(t){return M(H(this,4,t,arguments[1]),23,4)},getFloat64:function(t){return M(H(this,8,t,arguments[1]),52,8)},setInt8:function(t,e){z(this,1,t,A,e)},setUint8:function(t,e){z(this,1,t,A,e)},setInt16:function(t,e){z(this,2,t,P,e,arguments[2])},setUint16:function(t,e){z(this,2,t,P,e,arguments[2])},setInt32:function(t,e){z(this,4,t,D,e,arguments[2])},setUint32:function(t,e){z(this,4,t,D,e,arguments[2])},setFloat32:function(t,e){z(this,4,t,F,e,arguments[2])},setFloat64:function(t,e){z(this,8,t,j,e,arguments[2])}});g(b,"ArrayBuffer"),g(m,"DataView"),s(m.prototype,a.VIEW,!0),e.ArrayBuffer=b,e.DataView=m},function(t,e){function n(e,o){return t.exports=n=Object.setPrototypeOf||function(t,e){return t.__proto__=e,t},n(e,o)}t.exports=n},function(t,e,n){t.exports=!n(18)&&!n(10)((function(){return 7!=Object.defineProperty(n(83)("div"),"a",{get:function(){return 7}}).a}))},function(t,e,n){var o=n(9),r=n(17),i=n(44),a=n(84),s=n(19).f;t.exports=function(t){var e=r.Symbol||(r.Symbol=i?{}:o.Symbol||{});"_"==t.charAt(0)||t in e||s(e,t,{value:a.f(t)})}},function(t,e,n){var o=n(26),r=n(28),i=n(69)(!1),a=n(85)("IE_PROTO");t.exports=function(t,e){var n,s=r(t),c=0,l=[];for(n in s)n!=a&&o(s,n)&&l.push(n);for(;e.length>c;)o(s,n=e[c++])&&(~i(l,n)||l.push(n));return l}},function(t,e,n){var o=n(19),r=n(11),i=n(45);t.exports=n(18)?Object.defineProperties:function(t,e){r(t);for(var n,a=i(e),s=a.length,c=0;s>c;)o.f(t,n=a[c++],e[n]);return t}},function(t,e,n){var o=n(28),r=n(48).f,i={}.toString,a="object"==typeof window&&window&&Object.getOwnPropertyNames?Object.getOwnPropertyNames(window):[];t.exports.f=function(t){return a&&"[object Window]"==i.call(t)?function(t){try{return r(t)}catch(t){return a.slice()}}(t):r(o(t))}},function(t,e,n){"use strict";var o=n(18),r=n(45),i=n(70),a=n(63),s=n(20),c=n(62),l=Object.assign;t.exports=!l||n(10)((function(){var t={},e={},n=Symbol(),o="abcdefghijklmnopqrst";return t[n]=7,o.split("").forEach((function(t){e[t]=t})),7!=l({},t)[n]||Object.keys(l({},e)).join("")!=o}))?function(t,e){for(var n=s(t),l=arguments.length,u=1,f=i.f,d=a.f;l>u;)for(var p,h=c(arguments[u++]),v=f?r(h).concat(f(h)):r(h),y=v.length,g=0;y>g;)p=v[g++],o&&!d.call(h,p)||(n[p]=h[p]);return n}:l},function(t,e){t.exports=Object.is||function(t,e){return t===e?0!==t||1/t==1/e:t!=t&&e!=e}},function(t,e,n){"use strict";var o=n(31),r=n(12),i=n(117),a=[].slice,s={},c=function(t,e,n){if(!(e in s)){for(var o=[],r=0;r<e;r++)o[r]="a["+r+"]";s[e]=Function("F,a","return new F("+o.join(",")+")")}return s[e](t,n)};t.exports=Function.bind||function(t){var e=o(this),n=a.call(arguments,1),s=function(){var o=n.concat(a.call(arguments));return this instanceof s?c(e,o.length,o):i(e,o,t)};return r(e.prototype)&&(s.prototype=e.prototype),s}},function(t,e){t.exports=function(t,e,n){var o=void 0===n;switch(e.length){case 0:return o?t():t.call(n);case 1:return o?t(e[0]):t.call(n,e[0]);case 2:return o?t(e[0],e[1]):t.call(n,e[0],e[1]);case 3:return o?t(e[0],e[1],e[2]):t.call(n,e[0],e[1],e[2]);case 4:return o?t(e[0],e[1],e[2],e[3]):t.call(n,e[0],e[1],e[2],e[3])}return t.apply(n,e)}},function(t,e,n){var o=n(9).parseInt,r=n(54).trim,i=n(89),a=/^[-+]?0[xX]/;t.exports=8!==o(i+"08")||22!==o(i+"0x16")?function(t,e){var n=r(String(t),3);return o(n,e>>>0||(a.test(n)?16:10))}:o},function(t,e,n){var o=n(9).parseFloat,r=n(54).trim;t.exports=1/o(n(89)+"-0")!=-1/0?function(t){var e=r(String(t),3),n=o(e);return 0===n&&"-"==e.charAt(0)?-0:n}:o},function(t,e,n){var o=n(36);t.exports=function(t,e){if("number"!=typeof t&&"Number"!=o(t))throw TypeError(e);return+t}},function(t,e,n){var o=n(12),r=Math.floor;t.exports=function(t){return!o(t)&&isFinite(t)&&r(t)===t}},function(t,e){t.exports=Math.log1p||function(t){return(t=+t)>-1e-8&&t<1e-8?t-t*t/2:Math.log(1+t)}},function(t,e,n){"use strict";var o=n(47),r=n(42),i=n(53),a={};n(27)(a,n(14)("iterator"),(function(){return this})),t.exports=function(t,e,n){t.prototype=o(a,{next:r(1,n)}),i(t,e+" Iterator")}},function(t,e,n){var o=n(11);t.exports=function(t,e,n,r){try{return r?e(o(n)[0],n[1]):e(n)}catch(e){var i=t.return;throw void 0!==i&&o(i.call(t)),e}}},function(t,e,n){var o=n(278);t.exports=function(t,e){return new(o(t))(e)}},function(t,e,n){var o=n(31),r=n(20),i=n(62),a=n(16);t.exports=function(t,e,n,s,c){o(e);var l=r(t),u=i(l),f=a(l.length),d=c?f-1:0,p=c?-1:1;if(n<2)for(;;){if(d in u){s=u[d],d+=p;break}if(d+=p,c?d<0:f<=d)throw TypeError("Reduce of empty array with no initial value")}for(;c?d>=0:f>d;d+=p)d in u&&(s=e(s,u[d],d,l));return s}},function(t,e,n){"use strict";var o=n(20),r=n(46),i=n(16);t.exports=[].copyWithin||function(t,e){var n=o(this),a=i(n.length),s=r(t,a),c=r(e,a),l=arguments.length>2?arguments[2]:void 0,u=Math.min((void 0===l?a:r(l,a))-c,a-s),f=1;for(c<s&&s<c+u&&(f=-1,c+=u-1,s+=u-1);u-- >0;)c in n?n[s]=n[c]:delete n[s],s+=f,c+=f;return n}},function(t,e){t.exports=function(t,e){return{value:e,done:!!t}}},function(t,e,n){"use strict";var o=n(104);n(0)({target:"RegExp",proto:!0,forced:o!==/./.exec},{exec:o})},function(t,e,n){n(18)&&"g"!=/./g.flags&&n(19).f(RegExp.prototype,"flags",{configurable:!0,get:n(73)})},function(t,e,n){"use strict";var o,r,i,a,s=n(44),c=n(9),l=n(30),u=n(64),f=n(0),d=n(12),p=n(31),h=n(57),v=n(76),y=n(65),g=n(106).set,b=n(298)(),m=n(132),k=n(299),x=n(77),S=n(133),w=c.TypeError,E=c.process,T=E&&E.versions,C=T&&T.v8||"",B=c.Promise,_="process"==u(E),O=function(){},I=r=m.f,N=!!function(){try{var t=B.resolve(1),e=(t.constructor={})[n(14)("species")]=function(t){t(O,O)};return(_||"function"==typeof PromiseRejectionEvent)&&t.then(O)instanceof e&&0!==C.indexOf("6.6")&&-1===x.indexOf("Chrome/66")}catch(t){}}(),R=function(t){var e;return!(!d(t)||"function"!=typeof(e=t.then))&&e},M=function(t,e){if(!t._n){t._n=!0;var n=t._c;b((function(){for(var o=t._v,r=1==t._s,i=0,a=function(e){var n,i,a,s=r?e.ok:e.fail,c=e.resolve,l=e.reject,u=e.domain;try{s?(r||(2==t._h&&P(t),t._h=1),!0===s?n=o:(u&&u.enter(),n=s(o),u&&(u.exit(),a=!0)),n===e.promise?l(w("Promise-chain cycle")):(i=R(n))?i.call(n,c,l):c(n)):l(o)}catch(t){u&&!a&&u.exit(),l(t)}};n.length>i;)a(n[i++]);t._c=[],t._n=!1,e&&!t._h&&L(t)}))}},L=function(t){g.call(c,(function(){var e,n,o,r=t._v,i=A(t);if(i&&(e=k((function(){_?E.emit("unhandledRejection",r,t):(n=c.onunhandledrejection)?n({promise:t,reason:r}):(o=c.console)&&o.error&&o.error("Unhandled promise rejection",r)})),t._h=_||A(t)?2:1),t._a=void 0,i&&e.e)throw e.v}))},A=function(t){return 1!==t._h&&0===(t._a||t._c).length},P=function(t){g.call(c,(function(){var e;_?E.emit("rejectionHandled",t):(e=c.onrejectionhandled)&&e({promise:t,reason:t._v})}))},D=function(t){var e=this;e._d||(e._d=!0,(e=e._w||e)._v=t,e._s=2,e._a||(e._a=e._c.slice()),M(e,!0))},j=function(t){var e,n=this;if(!n._d){n._d=!0,n=n._w||n;try{if(n===t)throw w("Promise can't be resolved itself");(e=R(t))?b((function(){var o={_w:n,_d:!1};try{e.call(t,l(j,o,1),l(D,o,1))}catch(t){D.call(o,t)}})):(n._v=t,n._s=1,M(n,!1))}catch(t){D.call({_w:n,_d:!1},t)}}};N||(B=function(t){h(this,B,"Promise","_h"),p(t),o.call(this);try{t(l(j,this,1),l(D,this,1))}catch(t){D.call(this,t)}},(o=function(t){this._c=[],this._a=void 0,this._s=0,this._d=!1,this._v=void 0,this._h=0,this._n=!1}).prototype=n(58)(B.prototype,{then:function(t,e){var n=I(y(this,B));return n.ok="function"!=typeof t||t,n.fail="function"==typeof e&&e,n.domain=_?E.domain:void 0,this._c.push(n),this._a&&this._a.push(n),this._s&&M(this,!1),n.promise},catch:function(t){return this.then(void 0,t)}}),i=function(){var t=new o;this.promise=t,this.resolve=l(j,t,1),this.reject=l(D,t,1)},m.f=I=function(t){return t===B||t===a?new i(t):r(t)}),f(f.G+f.W+f.F*!N,{Promise:B}),n(53)(B,"Promise"),n(56)("Promise"),a=n(17).Promise,f(f.S+f.F*!N,"Promise",{reject:function(t){var e=I(this);return(0,e.reject)(t),e.promise}}),f(f.S+f.F*(s||!N),"Promise",{resolve:function(t){return S(s&&this===a?B:this,t)}}),f(f.S+f.F*!(N&&n(72)((function(t){B.all(t).catch(O)}))),"Promise",{all:function(t){var e=this,n=I(e),o=n.resolve,r=n.reject,i=k((function(){var n=[],i=0,a=1;v(t,!1,(function(t){var s=i++,c=!1;n.push(void 0),a++,e.resolve(t).then((function(t){c||(c=!0,n[s]=t,--a||o(n))}),r)})),--a||o(n)}));return i.e&&r(i.v),n.promise},race:function(t){var e=this,n=I(e),o=n.reject,r=k((function(){v(t,!1,(function(t){e.resolve(t).then(n.resolve,o)}))}));return r.e&&o(r.v),n.promise}})},function(t,e,n){"use strict";var o=n(31);function r(t){var e,n;this.promise=new t((function(t,o){if(void 0!==e||void 0!==n)throw TypeError("Bad Promise constructor");e=t,n=o})),this.resolve=o(e),this.reject=o(n)}t.exports.f=function(t){return new r(t)}},function(t,e,n){var o=n(11),r=n(12),i=n(132);t.exports=function(t,e){if(o(t),r(e)&&e.constructor===t)return e;var n=i.f(t);return(0,n.resolve)(e),n.promise}},function(t,e,n){"use strict";var o=n(19).f,r=n(47),i=n(58),a=n(30),s=n(57),c=n(76),l=n(95),u=n(128),f=n(56),d=n(18),p=n(41).fastKey,h=n(51),v=d?"_s":"size",y=function(t,e){var n,o=p(e);if("F"!==o)return t._i[o];for(n=t._f;n;n=n.n)if(n.k==e)return n};t.exports={getConstructor:function(t,e,n,l){var u=t((function(t,o){s(t,u,e,"_i"),t._t=e,t._i=r(null),t._f=void 0,t._l=void 0,t[v]=0,null!=o&&c(o,n,t[l],t)}));return i(u.prototype,{clear:function(){for(var t=h(this,e),n=t._i,o=t._f;o;o=o.n)o.r=!0,o.p&&(o.p=o.p.n=void 0),delete n[o.i];t._f=t._l=void 0,t[v]=0},delete:function(t){var n=h(this,e),o=y(n,t);if(o){var r=o.n,i=o.p;delete n._i[o.i],o.r=!0,i&&(i.n=r),r&&(r.p=i),n._f==o&&(n._f=r),n._l==o&&(n._l=i),n[v]--}return!!o},forEach:function(t){h(this,e);for(var n,o=a(t,arguments.length>1?arguments[1]:void 0,3);n=n?n.n:this._f;)for(o(n.v,n.k,this);n&&n.r;)n=n.p},has:function(t){return!!y(h(this,e),t)}}),d&&o(u.prototype,"size",{get:function(){return h(this,e)[v]}}),u},def:function(t,e,n){var o,r,i=y(t,e);return i?i.v=n:(t._l=i={i:r=p(e,!0),k:e,v:n,p:o=t._l,n:void 0,r:!1},t._f||(t._f=i),o&&(o.n=i),t[v]++,"F"!==r&&(t._i[r]=i)),t},getEntry:y,setStrong:function(t,e,n){l(t,e,(function(t,n){this._t=h(t,e),this._k=n,this._l=void 0}),(function(){for(var t=this._k,e=this._l;e&&e.r;)e=e.p;return this._t&&(this._l=e=e?e.n:this._t._f)?u(0,"keys"==t?e.k:"values"==t?e.v:[e.k,e.v]):(this._t=void 0,u(1))}),n?"entries":"values",!n,!0),f(e)}}},function(t,e,n){"use strict";var o=n(58),r=n(41).getWeak,i=n(11),a=n(12),s=n(57),c=n(76),l=n(35),u=n(26),f=n(51),d=l(5),p=l(6),h=0,v=function(t){return t._l||(t._l=new y)},y=function(){this.a=[]},g=function(t,e){return d(t.a,(function(t){return t[0]===e}))};y.prototype={get:function(t){var e=g(this,t);if(e)return e[1]},has:function(t){return!!g(this,t)},set:function(t,e){var n=g(this,t);n?n[1]=e:this.a.push([t,e])},delete:function(t){var e=p(this.a,(function(e){return e[0]===t}));return~e&&this.a.splice(e,1),!!~e}},t.exports={getConstructor:function(t,e,n,i){var l=t((function(t,o){s(t,l,e,"_i"),t._t=e,t._i=h++,t._l=void 0,null!=o&&c(o,n,t[i],t)}));return o(l.prototype,{delete:function(t){if(!a(t))return!1;var n=r(t);return!0===n?v(f(this,e)).delete(t):n&&u(n,this._i)&&delete n[this._i]},has:function(t){if(!a(t))return!1;var n=r(t);return!0===n?v(f(this,e)).has(t):n&&u(n,this._i)}}),l},def:function(t,e,n){var o=r(i(e),!0);return!0===o?v(t).set(e,n):o[t._i]=n,t},ufstore:v}},function(t,e,n){var o=n(32),r=n(16);t.exports=function(t){if(void 0===t)return 0;var e=o(t),n=r(e);if(e!==n)throw RangeError("Wrong length!");return n}},function(t,e,n){var o=n(48),r=n(70),i=n(11),a=n(9).Reflect;t.exports=a&&a.ownKeys||function(t){var e=o.f(i(t)),n=r.f;return n?e.concat(n(t)):e}},function(t,e,n){var o=n(16),r=n(91),i=n(37);t.exports=function(t,e,n,a){var s=String(i(t)),c=s.length,l=void 0===n?" ":String(n),u=o(e);if(u<=c||""==l)return s;var f=u-c,d=r.call(l,Math.ceil(f/l.length));return d.length>f&&(d=d.slice(0,f)),a?d+s:s+d}},function(t,e,n){var o=n(18),r=n(45),i=n(28),a=n(63).f;t.exports=function(t){return function(e){for(var n,s=i(e),c=r(s),l=c.length,u=0,f=[];l>u;)n=c[u++],o&&!a.call(s,n)||f.push(t?[n,s[n]]:s[n]);return f}}},function(t,e,n){var o=function(t){"use strict";var e=Object.prototype,n=e.hasOwnProperty,o="function"==typeof Symbol?Symbol:{},r=o.iterator||"@@iterator",i=o.asyncIterator||"@@asyncIterator",a=o.toStringTag||"@@toStringTag";function s(t,e,n,o){var r=e&&e.prototype instanceof u?e:u,i=Object.create(r.prototype),a=new S(o||[]);return i._invoke=function(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return E()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=m(a,n);if(s){if(s===l)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var u=c(t,e,n);if("normal"===u.type){if(o=n.done?"completed":"suspendedYield",u.arg===l)continue;return{value:u.arg,done:n.done}}"throw"===u.type&&(o="completed",n.method="throw",n.arg=u.arg)}}}(t,n,a),i}function c(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=s;var l={};function u(){}function f(){}function d(){}var p={};p[r]=function(){return this};var h=Object.getPrototypeOf,v=h&&h(h(w([])));v&&v!==e&&n.call(v,r)&&(p=v);var y=d.prototype=u.prototype=Object.create(p);function g(t){["next","throw","return"].forEach((function(e){t[e]=function(t){return this._invoke(e,t)}}))}function b(t,e){var o;this._invoke=function(r,i){function a(){return new e((function(o,a){!function o(r,i,a,s){var l=c(t[r],t,i);if("throw"!==l.type){var u=l.arg,f=u.value;return f&&"object"==typeof f&&n.call(f,"__await")?e.resolve(f.__await).then((function(t){o("next",t,a,s)}),(function(t){o("throw",t,a,s)})):e.resolve(f).then((function(t){u.value=t,a(u)}),(function(t){return o("throw",t,a,s)}))}s(l.arg)}(r,i,o,a)}))}return o=o?o.then(a,a):a()}}function m(t,e){var n=t.iterator[e.method];if(void 0===n){if(e.delegate=null,"throw"===e.method){if(t.iterator.return&&(e.method="return",e.arg=void 0,m(t,e),"throw"===e.method))return l;e.method="throw",e.arg=new TypeError("The iterator does not provide a 'throw' method")}return l}var o=c(n,t.iterator,e.arg);if("throw"===o.type)return e.method="throw",e.arg=o.arg,e.delegate=null,l;var r=o.arg;return r?r.done?(e[t.resultName]=r.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,l):r:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,l)}function k(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function x(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function S(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(k,this),this.reset(!0)}function w(t){if(t){var e=t[r];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,i=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return i.next=i}}return{next:E}}function E(){return{value:void 0,done:!0}}return f.prototype=y.constructor=d,d.constructor=f,d[a]=f.displayName="GeneratorFunction",t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===f||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,d):(t.__proto__=d,a in t||(t[a]="GeneratorFunction")),t.prototype=Object.create(y),t},t.awrap=function(t){return{__await:t}},g(b.prototype),b.prototype[i]=function(){return this},t.AsyncIterator=b,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new b(s(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},g(y),y[a]="Generator",y[r]=function(){return this},y.toString=function(){return"[object Generator]"},t.keys=function(t){var e=[];for(var n in t)e.push(n);return e.reverse(),function n(){for(;e.length;){var o=e.pop();if(o in t)return n.value=o,n.done=!1,n}return n.done=!0,n}},t.values=w,S.prototype={constructor:S,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(x),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,l):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),l},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),x(n),l}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;x(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:w(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),l}},t}(t.exports);try{regeneratorRuntime=o}catch(t){Function("r","regeneratorRuntime = r")(o)}},function(t,e,n){var o=n(142);t.exports=function(t,e){if(t){if("string"==typeof t)return o(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);return"Object"===n&&t.constructor&&(n=t.constructor.name),"Map"===n||"Set"===n?Array.from(n):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?o(t,e):void 0}}},function(t,e){t.exports=function(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,o=new Array(e);n<e;n++)o[n]=t[n];return o}},function(t){t.exports=JSON.parse('{"ui":{"blockTunes":{"toggler":{"Click to tune":"","or drag to move":""}},"inlineToolbar":{"converter":{"Convert to":""}},"toolbar":{"toolbox":{"Add":""}}},"toolNames":{"Text":"","Link":"","Bold":"","Italic":""},"tools":{"link":{"Add a link":""},"stub":{"The block can not be displayed correctly.":""}},"blockTunes":{"delete":{"Delete":""},"moveUp":{"Move up":""},"moveDown":{"Move down":""}}}')},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(5),n(6),n(4),n(369)],void 0===(i="function"==typeof(o=function(t,e,o,r,i,a){"use strict";var s=n(1);function c(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(t,"__esModule",{value:!0}),t.CriticalError=void 0,e=s(e),o=s(o),r=s(r),i=s(i);var l=function(t){(0,o.default)(s,t);var n,a=(n=s,function(){var t,e=(0,i.default)(n);if(c()){var o=(0,i.default)(this).constructor;t=Reflect.construct(e,arguments,o)}else t=e.apply(this,arguments);return(0,r.default)(this,t)});function s(){return(0,e.default)(this,s),a.apply(this,arguments)}return s}((0,(a=s(a)).default)(Error));t.CriticalError=l,l.displayName="CriticalError"})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(8),n(146),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f){"use strict";var d=n(13),p=n(1);function h(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=p(r),i=p(i),a=p(a),s=p(s),c=p(c),l=d(l),u=p(u);var v=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(h()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){var t;return(0,r.default)(this,o),(t=n.apply(this,arguments)).insert=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:t.config.defaultBlock,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},o=(arguments.length>2&&void 0!==arguments[2]&&arguments[2],arguments.length>3?arguments[3]:void 0),r=arguments.length>4?arguments[4]:void 0;t.Editor.BlockManager.insert({tool:e,data:n,index:o,needToFocus:r})},t}return(0,i.default)(o,[{key:"getBlocksCount",value:function(){return this.Editor.BlockManager.blocks.length}},{key:"getCurrentBlockIndex",value:function(){return this.Editor.BlockManager.currentBlockIndex}},{key:"getBlockByIndex",value:function(t){var e=this.Editor.BlockManager.getBlockByIndex(t);if(void 0!==e)return new u.default(e);l.logLabeled("There is no block at index `"+t+"`","warn")}},{key:"swap",value:function(t,e){l.log("`blocks.swap()` method is deprecated and will be removed in the next major release. Use `block.move()` method instead","info"),this.Editor.BlockManager.swap(t,e),this.Editor.Toolbar.move(!1)}},{key:"move",value:function(t,e){this.Editor.BlockManager.move(t,e),this.Editor.Toolbar.move(!1)}},{key:"delete",value:function(t){try{this.Editor.BlockManager.removeBlock(t)}catch(t){return void l.logLabeled(t,"warn")}0===this.Editor.BlockManager.blocks.length&&this.Editor.BlockManager.insert(),this.Editor.BlockManager.currentBlock&&this.Editor.Caret.setToBlock(this.Editor.BlockManager.currentBlock,this.Editor.Caret.positions.END),this.Editor.Toolbar.close()}},{key:"clear",value:function(){this.Editor.BlockManager.clear(!0),this.Editor.InlineToolbar.close()}},{key:"render",value:function(t){return this.Editor.BlockManager.clear(),this.Editor.Renderer.render(t.blocks)}},{key:"renderFromHTML",value:function(t){return this.Editor.BlockManager.clear(),this.Editor.Paste.processText(t,!0)}},{key:"stretchBlock",value:function(t){var e=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];l.deprecationAssert(!0,"blocks.stretchBlock()","BlockAPI");var n=this.Editor.BlockManager.getBlockByIndex(t);n&&(n.stretched=e)}},{key:"insertNewBlock",value:function(){l.log("Method blocks.insertNewBlock() is deprecated and it will be removed in the next major release. Use blocks.insert() instead.","warn"),this.insert()}},{key:"methods",get:function(){var t=this;return{clear:function(){return t.clear()},render:function(e){return t.render(e)},renderFromHTML:function(e){return t.renderFromHTML(e)},delete:function(e){return t.delete(e)},swap:function(e,n){return t.swap(e,n)},move:function(e,n){return t.move(e,n)},getBlockByIndex:function(e){return t.getBlockByIndex(e)},getCurrentBlockIndex:function(){return t.getCurrentBlockIndex()},getBlocksCount:function(){return t.getBlocksCount()},stretchBlock:function(e){var n=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];return t.stretchBlock(e,n)},insertNewBlock:function(){return t.insertNewBlock()},insert:this.insert}}}]),o}((f=p(f)).default);o.default=v,v.displayName="BlocksAPI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e],void 0===(i="function"==typeof(o=function(n){"use strict";Object.defineProperty(n,"__esModule",{value:!0}),n.default=void 0;var o=function(t){var e={get name(){return t.name},get config(){return t.config},get holder(){return t.holder},get isEmpty(){return t.isEmpty},get selected(){return t.selected},set stretched(e){t.stretched=e},get stretched(){return t.stretched},call:function(e,n){return t.call(e,n)},save:function(){return t.save()},validate:function(e){return t.validate(e)}};Object.setPrototypeOf(this,e)};n.default=o,t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l){"use strict";var u=n(1);function f(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=u(a),s=u(s),c=u(c);var d=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(f()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){var t;return(0,r.default)(this,o),(t=n.apply(this,arguments)).setToFirstBlock=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:t.Editor.Caret.positions.DEFAULT,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return!!t.Editor.BlockManager.firstBlock&&(t.Editor.Caret.setToBlock(t.Editor.BlockManager.firstBlock,e,n),!0)},t.setToLastBlock=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:t.Editor.Caret.positions.DEFAULT,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return!!t.Editor.BlockManager.lastBlock&&(t.Editor.Caret.setToBlock(t.Editor.BlockManager.lastBlock,e,n),!0)},t.setToPreviousBlock=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:t.Editor.Caret.positions.DEFAULT,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return!!t.Editor.BlockManager.previousBlock&&(t.Editor.Caret.setToBlock(t.Editor.BlockManager.previousBlock,e,n),!0)},t.setToNextBlock=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:t.Editor.Caret.positions.DEFAULT,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return!!t.Editor.BlockManager.nextBlock&&(t.Editor.Caret.setToBlock(t.Editor.BlockManager.nextBlock,e,n),!0)},t.setToBlock=function(e){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:t.Editor.Caret.positions.DEFAULT,o=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0;return!!t.Editor.BlockManager.blocks[e]&&(t.Editor.Caret.setToBlock(t.Editor.BlockManager.blocks[e],n,o),!0)},t.focus=function(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];return e?t.setToLastBlock(t.Editor.Caret.positions.END):t.setToFirstBlock(t.Editor.Caret.positions.START)},t}return(0,i.default)(o,[{key:"methods",get:function(){return{setToFirstBlock:this.setToFirstBlock,setToLastBlock:this.setToLastBlock,setToPreviousBlock:this.setToPreviousBlock,setToNextBlock:this.setToNextBlock,setToBlock:this.setToBlock,focus:this.focus}}}]),o}((l=u(l)).default);o.default=d,d.displayName="CaretAPI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l){"use strict";var u=n(1);function f(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=u(a),s=u(s),c=u(c);var d=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(f()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"on",value:function(t,e){this.Editor.Events.on(t,e)}},{key:"emit",value:function(t,e){this.Editor.Events.emit(t,e)}},{key:"off",value:function(t,e){this.Editor.Events.off(t,e)}},{key:"methods",get:function(){var t=this;return{emit:function(e,n){return t.emit(e,n)},off:function(e,n){return t.off(e,n)},on:function(e,n){return t.on(e,n)}}}}]),o}((l=u(l)).default);o.default=d,d.displayName="EventsAPI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(59),n(67),n(8),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d){"use strict";var p=n(1);function h(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=p(r),i=p(i),a=p(a),s=p(s),c=p(c),l=p(l);var v=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(h()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"getMethodsForTool",value:function(t,e){return Object.assign(this.methods,{t:function(n){return l.default.t(o.getNamespace(t,e),n)}})}},{key:"methods",get:function(){return{t:function(){(0,f.logLabeled)("I18n.t() method can be accessed only from Tools","warn")}}}}],[{key:"getNamespace",value:function(t,e){switch(e){case u.ToolType.Block:case u.ToolType.Inline:return"tools.".concat(t);case u.ToolType.Tune:return"blockTunes.".concat(t)}}}]),o}((d=p(d)).default);o.default=v,v.displayName="I18nAPI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l){"use strict";var u=n(1);function f(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=u(a),s=u(s),c=u(c);var d=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(f()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"open",value:function(){this.Editor.InlineToolbar.tryToShow()}},{key:"close",value:function(){this.Editor.InlineToolbar.close()}},{key:"methods",get:function(){var t=this;return{close:function(){return t.close()},open:function(){return t.open()}}}}]),o}((l=u(l)).default);o.default=d,d.displayName="InlineToolbarAPI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l){"use strict";var u=n(1);function f(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=u(a),s=u(s),c=u(c);var d=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(f()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"on",value:function(t,e,n,o){this.Editor.Listeners.on(t,e,n,o)}},{key:"off",value:function(t,e,n,o){this.Editor.Listeners.off(t,e,n,o)}},{key:"methods",get:function(){var t=this;return{on:function(e,n,o,r){return t.on(e,n,o,r)},off:function(e,n,o,r){return t.off(e,n,o,r)}}}}]),o}((l=u(l)).default);o.default=d,d.displayName="ListenersAPI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l){"use strict";var u=n(1);function f(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=u(a),s=u(s),c=u(c);var d=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(f()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"show",value:function(t){return this.Editor.Notifier.show(t)}},{key:"methods",get:function(){var t=this;return{show:function(e){return t.show(e)}}}}]),o}((l=u(l)).default);o.default=d,d.displayName="NotifierAPI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l){"use strict";var u=n(1);function f(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=u(a),s=u(s),c=u(c);var d=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(f()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"toggle",value:function(t){return this.Editor.ReadOnly.toggle(t)}},{key:"methods",get:function(){var t=this;return{toggle:function(e){return t.toggle(e)}}}}]),o}((l=u(l)).default);o.default=d,d.displayName="ReadOnlyAPI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l){"use strict";var u=n(1);function f(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=u(a),s=u(s),c=u(c);var d=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(f()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"clean",value:function(t,e){return this.Editor.Sanitizer.clean(t,e)}},{key:"methods",get:function(){var t=this;return{clean:function(e,n){return t.clean(e,n)}}}}]),o}((l=u(l)).default);o.default=d,d.displayName="SanitizerAPI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(8),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u){"use strict";var f=n(13),d=n(1);function p(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=d(r),i=d(i),a=d(a),s=d(s),c=d(c),l=f(l);var h=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(p()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"save",value:function(){var t="Editor's content can not be saved in read-only mode";return this.Editor.ReadOnly.isEnabled?(l.logLabeled(t,"warn"),Promise.reject(new Error(t))):this.Editor.Saver.save()}},{key:"methods",get:function(){var t=this;return{save:function(){return t.save()}}}}]),o}((u=d(u)).default);o.default=h,h.displayName="SaverAPI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(25),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u){"use strict";var f=n(1);function d(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=f(r),i=f(i),a=f(a),s=f(s),c=f(c),l=f(l);var p=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(d()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"findParentTag",value:function(t,e){return(new l.default).findParentTag(t,e)}},{key:"expandToTag",value:function(t){(new l.default).expandToTag(t)}},{key:"methods",get:function(){var t=this;return{findParentTag:function(e,n){return t.findParentTag(e,n)},expandToTag:function(e){return t.expandToTag(e)}}}}]),o}((u=f(u)).default);o.default=p,p.displayName="SelectionAPI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l){"use strict";var u=n(1);function f(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=u(a),s=u(s),c=u(c);var d=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(f()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"classes",get:function(){return{block:"cdx-block",inlineToolButton:"ce-inline-tool",inlineToolButtonActive:"ce-inline-tool--active",input:"cdx-input",loader:"cdx-loader",button:"cdx-button",settingsButton:"cdx-settings-button",settingsButtonActive:"cdx-settings-button--active"}}}]),o}((l=u(l)).default);o.default=d,d.displayName="StylesAPI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l){"use strict";var u=n(1);function f(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=u(a),s=u(s),c=u(c);var d=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(f()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"open",value:function(){this.Editor.Toolbar.open()}},{key:"close",value:function(){this.Editor.Toolbar.close()}},{key:"methods",get:function(){var t=this;return{close:function(){return t.close()},open:function(){return t.open()}}}}]),o}((l=u(l)).default);o.default=d,d.displayName="ToolbarAPI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l){"use strict";var u=n(1);function f(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=u(a),s=u(s),c=u(c);var d=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(f()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"show",value:function(t,e,n){this.Editor.Tooltip.show(t,e,n)}},{key:"hide",value:function(){this.Editor.Tooltip.hide()}},{key:"onHover",value:function(t,e,n){this.Editor.Tooltip.onHover(t,e,n)}},{key:"methods",get:function(){var t=this;return{show:function(e,n,o){return t.show(e,n,o)},hide:function(){return t.hide()},onHover:function(e,n,o){return t.onHover(e,n,o)}}}}]),o}((l=u(l)).default);o.default=d,d.displayName="TooltipAPI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7),n(8),n(25),n(60)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d){"use strict";var p=n(13),h=n(1);function v(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=h(r),i=h(i),a=h(a),s=h(s),c=h(c),l=h(l),u=p(u),f=h(f),d=h(d);var y=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(v()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"keydown",value:function(t){switch(this.beforeKeydownProcessing(t),t.keyCode){case u.keyCodes.BACKSPACE:this.backspace(t);break;case u.keyCodes.ENTER:this.enter(t);break;case u.keyCodes.DOWN:case u.keyCodes.RIGHT:this.arrowRightAndDown(t);break;case u.keyCodes.UP:case u.keyCodes.LEFT:this.arrowLeftAndUp(t);break;case u.keyCodes.TAB:this.tabPressed(t)}}},{key:"beforeKeydownProcessing",value:function(t){this.needToolbarClosing(t)&&u.isPrintableKey(t.keyCode)&&(this.Editor.Toolbar.close(),this.Editor.ConversionToolbar.close(),t.ctrlKey||t.metaKey||t.altKey||t.shiftKey||(this.Editor.BlockManager.clearFocused(),this.Editor.BlockSelection.clearSelection(t)))}},{key:"keyup",value:function(t){t.shiftKey||this.Editor.UI.checkEmptiness()}},{key:"tabPressed",value:function(t){this.Editor.BlockSelection.clearSelection(t);var e=this.Editor,n=e.BlockManager,o=e.Tools,r=e.InlineToolbar,i=e.ConversionToolbar,a=n.currentBlock;if(a){var s=o.isDefault(a.tool)&&a.isEmpty,c=!a.isEmpty&&i.opened,l=!a.isEmpty&&!f.default.isCollapsed&&r.opened;s?this.activateToolbox():c||l||this.activateBlockSettings()}}},{key:"dragOver",value:function(t){this.Editor.BlockManager.getBlockByChildNode(t.target).dropTarget=!0}},{key:"dragLeave",value:function(t){this.Editor.BlockManager.getBlockByChildNode(t.target).dropTarget=!1}},{key:"handleCommandC",value:function(t){var e=this.Editor.BlockSelection;e.anyBlockSelected&&e.copySelectedBlocks(t)}},{key:"handleCommandX",value:function(t){var e=this.Editor,n=e.BlockSelection,o=e.BlockManager,r=e.Caret;if(n.anyBlockSelected){n.copySelectedBlocks(t);var i=o.removeSelectedBlocks();r.setToBlock(o.insertDefaultBlockAtIndex(i,!0),r.positions.START),n.clearSelection(t)}}},{key:"enter",value:function(t){var e=this.Editor,n=e.BlockManager,o=e.Tools,r=e.UI,i=n.currentBlock,a=o.available[i.name];if(!(a&&a[o.INTERNAL_SETTINGS.IS_ENABLED_LINE_BREAKS]||r.someToolbarOpened&&r.someFlipperButtonFocused||t.shiftKey)){var s=this.Editor.BlockManager.currentBlock;this.Editor.Caret.isAtStart&&!this.Editor.BlockManager.currentBlock.hasMedia?this.Editor.BlockManager.insertDefaultBlockAtIndex(this.Editor.BlockManager.currentBlockIndex):s=this.Editor.BlockManager.split(),this.Editor.Caret.setToBlock(s),this.Editor.Tools.isDefault(s.tool)&&s.isEmpty&&(this.Editor.Toolbar.open(!1),this.Editor.Toolbar.plusButton.show()),t.preventDefault()}}},{key:"backspace",value:function(t){var e=this.Editor,n=e.BlockManager,o=e.BlockSelection,r=e.Caret,i=n.currentBlock,a=this.Editor.Tools.available[i.name];if(i.selected||i.isEmpty&&i.currentInput===i.firstInput){t.preventDefault();var s=n.currentBlockIndex;return n.previousBlock&&0===n.previousBlock.inputs.length?n.removeBlock(s-1):n.removeBlock(),r.setToBlock(n.currentBlock,s?r.positions.END:r.positions.START),this.Editor.Toolbar.close(),void o.clearSelection(t)}if(!a||!a[this.Editor.Tools.INTERNAL_SETTINGS.IS_ENABLED_LINE_BREAKS]||r.isAtStart){var c=0===n.currentBlockIndex;r.isAtStart&&f.default.isCollapsed&&i.currentInput===i.firstInput&&!c&&(t.preventDefault(),this.mergeBlocks())}}},{key:"mergeBlocks",value:function(){var t=this.Editor,e=t.BlockManager,n=t.Caret,o=t.Toolbar,r=e.previousBlock,i=e.currentBlock;if(i.name!==r.name||!r.mergeable)return 0===r.inputs.length||r.isEmpty?(e.removeBlock(e.currentBlockIndex-1),n.setToBlock(e.currentBlock),void o.close()):void(n.navigatePrevious()&&o.close());n.createShadow(r.pluginsContent),e.mergeBlocks(r,i).then((function(){n.restoreCaret(r.pluginsContent),r.pluginsContent.normalize(),o.close()}))}},{key:"arrowRightAndDown",value:function(t){var e=this,n=d.default.usedKeys.includes(t.keyCode)&&(!t.shiftKey||t.keyCode===u.keyCodes.TAB);if(!this.Editor.UI.someToolbarOpened||!n){this.Editor.BlockManager.clearFocused(),this.Editor.Toolbar.close();var o=this.Editor.Caret.isAtEnd||this.Editor.BlockSelection.anyBlockSelected;t.shiftKey&&t.keyCode===u.keyCodes.DOWN&&o?this.Editor.CrossBlockSelection.toggleBlockSelectedState():((t.keyCode===u.keyCodes.DOWN||t.keyCode===u.keyCodes.RIGHT&&!this.isRtl?this.Editor.Caret.navigateNext():this.Editor.Caret.navigatePrevious())?t.preventDefault():u.delay((function(){e.Editor.BlockManager.currentBlock&&e.Editor.BlockManager.currentBlock.updateCurrentInput()}),20)(),this.Editor.BlockSelection.clearSelection(t))}}},{key:"arrowLeftAndUp",value:function(t){var e=this;if(this.Editor.UI.someToolbarOpened){if(d.default.usedKeys.includes(t.keyCode)&&(!t.shiftKey||t.keyCode===u.keyCodes.TAB))return;this.Editor.UI.closeAllToolbars()}this.Editor.BlockManager.clearFocused(),this.Editor.Toolbar.close();var n=this.Editor.Caret.isAtStart||this.Editor.BlockSelection.anyBlockSelected;t.shiftKey&&t.keyCode===u.keyCodes.UP&&n?this.Editor.CrossBlockSelection.toggleBlockSelectedState(!1):((t.keyCode===u.keyCodes.UP||t.keyCode===u.keyCodes.LEFT&&!this.isRtl?this.Editor.Caret.navigatePrevious():this.Editor.Caret.navigateNext())?t.preventDefault():u.delay((function(){e.Editor.BlockManager.currentBlock&&e.Editor.BlockManager.currentBlock.updateCurrentInput()}),20)(),this.Editor.BlockSelection.clearSelection(t))}},{key:"needToolbarClosing",value:function(t){var e=t.keyCode===u.keyCodes.ENTER&&this.Editor.Toolbox.opened,n=t.keyCode===u.keyCodes.ENTER&&this.Editor.BlockSettings.opened,o=t.keyCode===u.keyCodes.ENTER&&this.Editor.InlineToolbar.opened,r=t.keyCode===u.keyCodes.ENTER&&this.Editor.ConversionToolbar.opened,i=t.keyCode===u.keyCodes.TAB;return!(t.shiftKey||i||e||n||o||r)}},{key:"activateToolbox",value:function(){this.Editor.Toolbar.opened||(this.Editor.Toolbar.open(!1,!1),this.Editor.Toolbar.plusButton.show()),this.Editor.Toolbox.open()}},{key:"activateBlockSettings",value:function(){this.Editor.Toolbar.opened||(this.Editor.BlockManager.currentBlock.focused=!0,this.Editor.Toolbar.open(!0,!1),this.Editor.Toolbar.plusButton.hide()),this.Editor.BlockSettings.opened||this.Editor.BlockSettings.open()}}]),o}(l.default);o.default=y,y.displayName="BlockEvents",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(21),n(22),n(2),n(3),n(5),n(6),n(4),n(61),n(7),n(15),n(8),n(383)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d,p,h,v){"use strict";var y=n(13),g=n(1);function b(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=g(r),i=g(i),a=g(a),s=g(s),c=g(c),l=g(l),u=g(u),f=y(f),d=g(d),p=g(p),h=y(h),v=g(v);var m=function(t){(0,c.default)(y,t);var e,n,o,d=(e=y,function(){var t,n=(0,u.default)(e);if(b()){var o=(0,u.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,l.default)(this,t)});function y(){var t;return(0,a.default)(this,y),(t=d.apply(this,arguments))._currentBlockIndex=-1,t._blocks=null,t}return(0,s.default)(y,[{key:"prepare",value:function(){var t=this,e=new v.default(this.Editor.UI.nodes.redactor);this._blocks=new Proxy(e,{set:v.default.set,get:v.default.get}),this.Editor.Listeners.on(document,"copy",(function(e){return t.Editor.BlockEvents.handleCommandC(e)}))}},{key:"toggleReadOnly",value:function(t){t?this.disableModuleBindings():this.enableModuleBindings()}},{key:"composeBlock",value:function(t){var e=t.tool,n=t.data,o=void 0===n?{}:n,r=this.Editor.ReadOnly.isEnabled,i=this.Editor.Tools.getToolSettings(e),a=this.Editor.Tools.available[e],s=new f.default({name:e,data:o,Tool:a,settings:i,api:this.Editor.API,readOnly:r});return r||this.bindBlockEvents(s),s}},{key:"insert",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=t.tool,n=void 0===e?this.config.defaultBlock:e,o=t.data,r=void 0===o?{}:o,i=t.index,a=t.needToFocus,s=void 0===a||a,c=t.replace,l=void 0!==c&&c,u=i;void 0===u&&(u=this.currentBlockIndex+(l?0:1));var f=this.composeBlock({tool:n,data:r});return this._blocks.insert(u,f,l),s?this.currentBlockIndex=u:u<=this.currentBlockIndex&&this.currentBlockIndex++,f}},{key:"replace",value:function(t){var e=t.tool,n=void 0===e?this.config.defaultBlock:e,o=t.data,r=void 0===o?{}:o;return this.insert({tool:n,data:r,index:this.currentBlockIndex,replace:!0})}},{key:"paste",value:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],o=this.insert({tool:t,replace:n});try{o.call(f.BlockToolAPI.ON_PASTE,e)}catch(e){h.log("".concat(t,": onPaste callback call is failed"),"error",e)}return o}},{key:"insertDefaultBlockAtIndex",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=this.composeBlock({tool:this.config.defaultBlock});return this._blocks[t]=n,e?this.currentBlockIndex=t:t<=this.currentBlockIndex&&this.currentBlockIndex++,n}},{key:"insertAtEnd",value:function(){return this.currentBlockIndex=this.blocks.length-1,this.insert()}},{key:"mergeBlocks",value:(o=(0,i.default)(r.default.mark((function t(e,n){var o,i;return r.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:if(o=this._blocks.indexOf(n),!n.isEmpty){t.next=3;break}return t.abrupt("return");case 3:return t.next=5,n.data;case 5:if(i=t.sent,h.isEmpty(i)){t.next=9;break}return t.next=9,e.mergeWith(i);case 9:this.removeBlock(o),this.currentBlockIndex=this._blocks.indexOf(e);case 11:case"end":return t.stop()}}),t,this)}))),function(t,e){return o.apply(this,arguments)})},{key:"removeBlock",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.currentBlockIndex;if(!this.validateIndex(t))throw new Error("Can't find a Block to remove");this._blocks.remove(t),this.currentBlockIndex>=t&&this.currentBlockIndex--,this.blocks.length?0===t&&(this.currentBlockIndex=0):(this.currentBlockIndex=-1,this.insert())}},{key:"removeSelectedBlocks",value:function(){for(var t,e=this.blocks.length-1;e>=0;e--)this.blocks[e].selected&&(this.removeBlock(e),t=e);return t}},{key:"removeAllBlocks",value:function(){for(var t=this.blocks.length-1;t>=0;t--)this._blocks.remove(t);this.currentBlockIndex=-1,this.insert(),this.currentBlock.firstInput.focus()}},{key:"split",value:function(){var t=this.Editor.Caret.extractFragmentFromCaretPosition(),e=p.default.make("div");e.appendChild(t);var n={text:p.default.isEmpty(e)?"":e.innerHTML};return this.insert({data:n})}},{key:"getBlockByIndex",value:function(t){return this._blocks[t]}},{key:"getBlock",value:function(t){p.default.isElement(t)||(t=t.parentNode);var e=this._blocks.nodes,n=t.closest(".".concat(f.default.CSS.wrapper)),o=e.indexOf(n);if(o>=0)return this._blocks[o]}},{key:"highlightCurrentNode",value:function(){this.clearFocused(),this.currentBlock.focused=!0}},{key:"clearFocused",value:function(){this.blocks.forEach((function(t){t.focused=!1}))}},{key:"setCurrentBlockByChildNode",value:function(t){p.default.isElement(t)||(t=t.parentNode);var e=t.closest(".".concat(f.default.CSS.wrapper));if(e)return this.currentBlockIndex=this._blocks.nodes.indexOf(e),this.currentBlock.updateCurrentInput(),this.currentBlock;throw new Error("Can not find a Block from this child Node")}},{key:"getBlockByChildNode",value:function(t){p.default.isElement(t)||(t=t.parentNode);var e=t.closest(".".concat(f.default.CSS.wrapper));return this.blocks.find((function(t){return t.holder===e}))}},{key:"swap",value:function(t,e){this._blocks.swap(t,e),this.currentBlockIndex=e}},{key:"move",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.currentBlockIndex;isNaN(t)||isNaN(e)?h.log("Warning during 'move' call: incorrect indices provided.","warn"):this.validateIndex(t)&&this.validateIndex(e)?(this._blocks.move(t,e),this.currentBlockIndex=t):h.log("Warning during 'move' call: indices cannot be lower than 0 or greater than the amount of blocks.","warn")}},{key:"dropPointer",value:function(){this.currentBlockIndex=-1,this.clearFocused()}},{key:"clear",value:function(){var t=arguments.length>0&&void 0!==arguments[0]&&arguments[0];this._blocks.removeAll(),this.dropPointer(),t&&this.insert(),this.Editor.UI.checkEmptiness()}},{key:"destroy",value:(n=(0,i.default)(r.default.mark((function t(){return r.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,Promise.all(this.blocks.map((function(t){if(h.isFunction(t.tool.destroy))return t.tool.destroy()})));case 2:case"end":return t.stop()}}),t,this)}))),function(){return n.apply(this,arguments)})},{key:"bindBlockEvents",value:function(t){var e=this.Editor.BlockEvents;this.readOnlyMutableListeners.on(t.holder,"keydown",(function(t){e.keydown(t)}),!0),this.readOnlyMutableListeners.on(t.holder,"keyup",(function(t){e.keyup(t)})),this.readOnlyMutableListeners.on(t.holder,"dragover",(function(t){e.dragOver(t)})),this.readOnlyMutableListeners.on(t.holder,"dragleave",(function(t){e.dragLeave(t)}))}},{key:"disableModuleBindings",value:function(){this.readOnlyMutableListeners.clearAll()}},{key:"enableModuleBindings",value:function(){var t=this;this.readOnlyMutableListeners.on(document,"cut",(function(e){return t.Editor.BlockEvents.handleCommandX(e)})),this.blocks.forEach((function(e){t.bindBlockEvents(e)}))}},{key:"validateIndex",value:function(t){return!(t<0||t>=this._blocks.length)}},{key:"currentBlockIndex",get:function(){return this._currentBlockIndex},set:function(t){this._blocks[this._currentBlockIndex]&&this._blocks[this._currentBlockIndex].willUnselect(),this._blocks[t]&&this._blocks[t].willSelect(),this._currentBlockIndex=t}},{key:"firstBlock",get:function(){return this._blocks[0]}},{key:"lastBlock",get:function(){return this._blocks[this._blocks.length-1]}},{key:"currentBlock",get:function(){return this._blocks[this.currentBlockIndex]}},{key:"nextBlock",get:function(){return this.currentBlockIndex===this._blocks.length-1?null:this._blocks[this.currentBlockIndex+1]}},{key:"nextContentfulBlock",get:function(){return this.blocks.slice(this.currentBlockIndex+1).find((function(t){return!!t.inputs.length}))}},{key:"previousContentfulBlock",get:function(){return this.blocks.slice(0,this.currentBlockIndex).reverse().find((function(t){return!!t.inputs.length}))}},{key:"previousBlock",get:function(){return 0===this.currentBlockIndex?null:this._blocks[this.currentBlockIndex-1]}},{key:"blocks",get:function(){return this._blocks.array}},{key:"isEditorEmpty",get:function(){return this.blocks.every((function(t){return t.isEmpty}))}}]),y}(d.default);o.default=m,m.displayName="BlockManager",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(21),n(22),n(2),n(3),n(5),n(6),n(4),n(7),n(8),n(15),n(25)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d,p,h){"use strict";var v=n(13),y=n(1);function g(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=y(r),i=y(i),a=y(a),s=y(s),c=y(c),l=y(l),u=y(u),f=y(f),d=v(d),p=y(p),h=y(h);var b=function(t){(0,c.default)(f,t);var e,n,o=(e=f,function(){var t,n=(0,u.default)(e);if(g()){var o=(0,u.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,l.default)(this,t)});function f(){var t;return(0,a.default)(this,f),(t=o.apply(this,arguments)).anyBlockSelectedCache=null,t.needToSelectAll=!1,t.nativeInputSelected=!1,t.readyToBlockSelection=!1,t}return(0,s.default)(f,[{key:"prepare",value:function(){var t=this,e=this.Editor.Shortcuts;this.selection=new h.default,e.add({name:"CMD+A",handler:function(e){var n=t.Editor,o=n.BlockManager;if(n.ReadOnly.isEnabled)return e.preventDefault(),void t.selectAllBlocks();o.currentBlock&&t.handleCommandA(e)}})}},{key:"toggleReadOnly",value:function(t){h.default.get().removeAllRanges(),this.allBlocksSelected=!1}},{key:"unSelectBlockByIndex",value:function(t){var e=this.Editor.BlockManager;(isNaN(t)?e.currentBlock:e.getBlockByIndex(t)).selected=!1,this.clearCache()}},{key:"clearSelection",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=this.Editor,o=n.BlockManager,r=n.Caret,i=n.RectangleSelection;this.needToSelectAll=!1,this.nativeInputSelected=!1,this.readyToBlockSelection=!1;var a=t&&t instanceof KeyboardEvent,s=a&&d.isPrintableKey(t.keyCode);if(this.anyBlockSelected&&a&&s&&!h.default.isSelectionExists){var c=o.removeSelectedBlocks();o.insertDefaultBlockAtIndex(c,!0),r.setToBlock(o.currentBlock),d.delay((function(){var e=t.key;r.insertContentAtCaretPosition(e.length>1?"":e)}),20)()}this.Editor.CrossBlockSelection.clear(t),this.anyBlockSelected&&!i.isRectActivated()?(e&&this.selection.restore(),this.allBlocksSelected=!1):this.Editor.RectangleSelection.clearSelection()}},{key:"copySelectedBlocks",value:(n=(0,i.default)(r.default.mark((function t(e){var n,o,i,a,s=this;return r.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return e.preventDefault(),n=p.default.make("div"),this.selectedBlocks.forEach((function(t){var e=s.Editor.Sanitizer.clean(t.holder.innerHTML,s.sanitizerConfig),o=p.default.make("p");o.innerHTML=e,n.appendChild(o)})),t.next=5,Promise.all(this.selectedBlocks.map((function(t){return t.save()})));case 5:o=t.sent,i=Array.from(n.childNodes).map((function(t){return t.textContent})).join("\n\n"),a=n.innerHTML,e.clipboardData.setData("text/plain",i),e.clipboardData.setData("text/html",a),e.clipboardData.setData(this.Editor.Paste.MIME_TYPE,JSON.stringify(o));case 11:case"end":return t.stop()}}),t,this)}))),function(t){return n.apply(this,arguments)})},{key:"selectBlockByIndex",value:function(t){var e,n=this.Editor.BlockManager;n.clearFocused(),e=isNaN(t)?n.currentBlock:n.getBlockByIndex(t),this.selection.save(),h.default.get().removeAllRanges(),e.selected=!0,this.clearCache(),this.Editor.InlineToolbar.close()}},{key:"clearCache",value:function(){this.anyBlockSelectedCache=null}},{key:"destroy",value:function(){this.Editor.Shortcuts.remove("CMD+A")}},{key:"handleCommandA",value:function(t){if(this.Editor.RectangleSelection.clearSelection(),!p.default.isNativeInput(t.target)||this.readyToBlockSelection){var e=this.Editor.BlockManager.getBlock(t.target).inputs;e.length>1&&!this.readyToBlockSelection?this.readyToBlockSelection=!0:1!==e.length||this.needToSelectAll?this.needToSelectAll?(t.preventDefault(),this.selectAllBlocks(),this.needToSelectAll=!1,this.readyToBlockSelection=!1,this.Editor.ConversionToolbar.close()):this.readyToBlockSelection&&(t.preventDefault(),this.selectBlockByIndex(),this.needToSelectAll=!0):this.needToSelectAll=!0}else this.readyToBlockSelection=!0}},{key:"selectAllBlocks",value:function(){this.selection.save(),h.default.get().removeAllRanges(),this.allBlocksSelected=!0,this.Editor.InlineToolbar.close()}},{key:"sanitizerConfig",get:function(){return{p:{},h1:{},h2:{},h3:{},h4:{},h5:{},h6:{},ol:{},ul:{},li:{},br:!0,img:{src:!0,width:!0,height:!0},a:{href:!0},b:{},i:{},u:{}}}},{key:"allBlocksSelected",get:function(){return this.Editor.BlockManager.blocks.every((function(t){return!0===t.selected}))},set:function(t){this.Editor.BlockManager.blocks.forEach((function(e){e.selected=t})),this.clearCache()}},{key:"anyBlockSelected",get:function(){var t=this.Editor.BlockManager;return null===this.anyBlockSelectedCache&&(this.anyBlockSelectedCache=t.blocks.some((function(t){return!0===t.selected}))),this.anyBlockSelectedCache}},{key:"selectedBlocks",get:function(){return this.Editor.BlockManager.blocks.filter((function(t){return t.selected}))}}]),f}(f.default);o.default=b,b.displayName="BlockSelection",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(25),n(7),n(15),n(8)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d){"use strict";var p=n(13),h=n(1);function v(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=h(r),i=h(i),a=h(a),s=h(s),c=h(c),l=h(l),u=h(u),f=h(f),d=p(d);var y=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(v()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"setToBlock",value:function(t){var e,n=this,o=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.positions.DEFAULT,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,i=this.Editor.BlockManager;switch(o){case this.positions.START:e=t.firstInput;break;case this.positions.END:e=t.lastInput;break;default:e=t.currentInput}if(e){var a=f.default.getDeepestNode(e,o===this.positions.END),s=f.default.getContentLength(a);switch(!0){case o===this.positions.START:r=0;break;case o===this.positions.END:case r>s:r=s}d.delay((function(){n.set(a,r)}),20)(),i.setCurrentBlockByChildNode(t.holder),i.currentBlock.currentInput=e}}},{key:"setToInput",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.positions.DEFAULT,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0,o=this.Editor.BlockManager.currentBlock,r=f.default.getDeepestNode(t);switch(e){case this.positions.START:this.set(r,0);break;case this.positions.END:this.set(r,f.default.getContentLength(r));break;default:n&&this.set(r,n)}o.currentInput=t}},{key:"set",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,n=l.default.setCursor(t,e),o=n.top,r=n.bottom,i=window,a=i.innerHeight;o<0&&window.scrollBy(0,o),r>a&&window.scrollBy(0,r-a)}},{key:"setToTheLastBlock",value:function(){var t=this.Editor.BlockManager.lastBlock;if(t)if(this.Editor.Tools.isDefault(t.tool)&&t.isEmpty)this.setToBlock(t);else{var e=this.Editor.BlockManager.insertAtEnd();this.setToBlock(e)}}},{key:"extractFragmentFromCaretPosition",value:function(){var t=l.default.get();if(t.rangeCount){var e=t.getRangeAt(0),n=this.Editor.BlockManager.currentBlock.currentInput;if(e.deleteContents(),n){if(f.default.isNativeInput(n)){var o=n,r=document.createDocumentFragment(),i=o.value.substring(0,o.selectionStart),a=o.value.substring(o.selectionStart);return r.textContent=a,o.value=i,r}var s=e.cloneRange();return s.selectNodeContents(n),s.setStart(e.endContainer,e.endOffset),s.extractContents()}}}},{key:"navigateNext",value:function(){var t=arguments.length>0&&void 0!==arguments[0]&&arguments[0],e=this.Editor,n=e.BlockManager,o=e.Tools,r=n.currentBlock,i=n.nextContentfulBlock,a=r.nextInput,s=i;if(!s&&!a){if(o.isDefault(r.tool))return!1;s=n.insertAtEnd()}return!(!t&&!this.isAtEnd||(a?this.setToInput(a,this.positions.START):this.setToBlock(s,this.positions.START),0))}},{key:"navigatePrevious",value:function(){var t=arguments.length>0&&void 0!==arguments[0]&&arguments[0],e=this.Editor.BlockManager,n=e.currentBlock,o=e.previousContentfulBlock;if(!n)return!1;var r=n.previousInput;return!(!o&&!r||!t&&!this.isAtStart||(r?this.setToInput(r,this.positions.END):this.setToBlock(o,this.positions.END),0))}},{key:"createShadow",value:function(t){var e=document.createElement("span");e.classList.add(o.CSS.shadowCaret),t.insertAdjacentElement("beforeend",e)}},{key:"restoreCaret",value:function(t){var e=t.querySelector(".".concat(o.CSS.shadowCaret));e&&((new l.default).expandToTag(e),setTimeout((function(){var t=document.createRange();t.selectNode(e),t.extractContents()}),50))}},{key:"insertContentAtCaretPosition",value:function(t){var e=document.createDocumentFragment(),n=document.createElement("div"),o=l.default.get(),r=l.default.range;n.innerHTML=t,Array.from(n.childNodes).forEach((function(t){return e.appendChild(t)})),0===e.childNodes.length&&e.appendChild(new Text(""));var i=e.lastChild;r.deleteContents(),r.insertNode(e);var a=document.createRange();a.setStart(i,i.textContent.length),o.removeAllRanges(),o.addRange(a)}},{key:"getHigherLevelSiblings",value:function(t,e){for(var n=t,o=[];n.parentNode&&"true"!==n.parentNode.contentEditable;)n=n.parentNode;for(var r="left"===e?"previousSibling":"nextSibling";n[r];)n=n[r],o.push(n);return o}},{key:"positions",get:function(){return{START:"start",END:"end",DEFAULT:"default"}}},{key:"isAtStart",get:function(){var t=l.default.get(),e=f.default.getDeepestNode(this.Editor.BlockManager.currentBlock.currentInput),n=t.focusNode;if(f.default.isNativeInput(e))return 0===e.selectionEnd;if(!t.anchorNode)return!1;var o=n.textContent.search(/\S/);-1===o&&(o=0);var r=t.focusOffset;return n.nodeType!==Node.TEXT_NODE&&n.childNodes.length&&(n.childNodes[r]?(n=n.childNodes[r],r=0):r=(n=n.childNodes[r-1]).textContent.length),!(!f.default.isLineBreakTag(e)&&!f.default.isEmpty(e)||!this.getHigherLevelSiblings(n,"left").every((function(t){var e=f.default.isLineBreakTag(t),n=1===t.children.length&&f.default.isLineBreakTag(t.children[0]),o=e||n;return f.default.isEmpty(t)&&!o}))||r!==o)||(null===e||n===e&&r<=o)}},{key:"isAtEnd",get:function(){var t=l.default.get(),e=t.focusNode,n=f.default.getDeepestNode(this.Editor.BlockManager.currentBlock.currentInput,!0);if(f.default.isNativeInput(n))return n.selectionEnd===n.value.length;if(!t.focusNode)return!1;var o=t.focusOffset;if(e.nodeType!==Node.TEXT_NODE&&e.childNodes.length&&(e.childNodes[o-1]?o=(e=e.childNodes[o-1]).textContent.length:(e=e.childNodes[0],o=0)),f.default.isLineBreakTag(n)||f.default.isEmpty(n)){var r=this.getHigherLevelSiblings(e,"right");if(r.every((function(t,e){return e===r.length-1&&f.default.isLineBreakTag(t)||f.default.isEmpty(t)&&!f.default.isLineBreakTag(t)}))&&o===e.textContent.length)return!0}var i=n.textContent.replace(/\s+$/,"");return e===n&&o>=i.length}}],[{key:"CSS",get:function(){return{shadowCaret:"cdx-shadow-caret"}}}]),o}(u.default);o.default=y,y.displayName="Caret",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(21),n(22),n(2),n(3),n(5),n(6),n(4),n(7),n(25),n(8)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d,p){"use strict";var h=n(13),v=n(1);function y(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=v(r),i=v(i),a=v(a),s=v(s),c=v(c),l=v(l),u=v(u),f=v(f),d=v(d),p=h(p);var g=function(t){(0,c.default)(f,t);var e,n,o=(e=f,function(){var t,n=(0,u.default)(e);if(y()){var o=(0,u.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,l.default)(this,t)});function f(){var t;return(0,a.default)(this,f),(t=o.apply(this,arguments)).onMouseUp=function(){var e=t.Editor.Listeners;e.off(document,"mouseover",t.onMouseOver),e.off(document,"mouseup",t.onMouseUp)},t.onMouseOver=function(e){var n=t.Editor,o=n.BlockManager,r=n.BlockSelection,i=o.getBlockByChildNode(e.relatedTarget)||t.lastSelectedBlock,a=o.getBlockByChildNode(e.target);if(i&&a&&a!==i){if(i===t.firstSelectedBlock)return d.default.get().removeAllRanges(),i.selected=!0,a.selected=!0,void r.clearCache();if(a===t.firstSelectedBlock)return i.selected=!1,a.selected=!1,void r.clearCache();t.Editor.InlineToolbar.close(),t.toggleBlocksSelectedState(i,a),t.lastSelectedBlock=a}},t}return(0,s.default)(f,[{key:"prepare",value:(n=(0,i.default)(r.default.mark((function t(){var e=this;return r.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:this.Editor.Listeners.on(document,"mousedown",(function(t){e.enableCrossBlockSelection(t)}));case 2:case"end":return t.stop()}}),t,this)}))),function(){return n.apply(this,arguments)})},{key:"watchSelection",value:function(t){if(t.button===p.mouseButtons.LEFT){var e=this.Editor,n=e.BlockManager,o=e.Listeners;this.firstSelectedBlock=n.getBlock(t.target),this.lastSelectedBlock=this.firstSelectedBlock,o.on(document,"mouseover",this.onMouseOver),o.on(document,"mouseup",this.onMouseUp)}}},{key:"toggleBlockSelectedState",value:function(){var t=!(arguments.length>0&&void 0!==arguments[0])||arguments[0],e=this.Editor,n=e.BlockManager,o=e.BlockSelection;this.lastSelectedBlock||(this.lastSelectedBlock=this.firstSelectedBlock=n.currentBlock),this.firstSelectedBlock===this.lastSelectedBlock&&(this.firstSelectedBlock.selected=!0,o.clearCache(),d.default.get().removeAllRanges());var r=n.blocks.indexOf(this.lastSelectedBlock)+(t?1:-1),i=n.blocks[r];i&&(this.lastSelectedBlock.selected!==i.selected?(i.selected=!0,o.clearCache()):(this.lastSelectedBlock.selected=!1,o.clearCache()),this.lastSelectedBlock=i,this.Editor.InlineToolbar.close())}},{key:"clear",value:function(t){var e=this.Editor,n=e.BlockManager,o=e.BlockSelection,r=e.Caret,i=n.blocks.indexOf(this.firstSelectedBlock),a=n.blocks.indexOf(this.lastSelectedBlock);if(o.anyBlockSelected&&i>-1&&a>-1)if(t&&t instanceof KeyboardEvent)switch(t.keyCode){case p.keyCodes.DOWN:case p.keyCodes.RIGHT:r.setToBlock(n.blocks[Math.max(i,a)],r.positions.END);break;case p.keyCodes.UP:case p.keyCodes.LEFT:r.setToBlock(n.blocks[Math.min(i,a)],r.positions.START);break;default:r.setToBlock(n.blocks[Math.max(i,a)],r.positions.END)}else r.setToBlock(n.blocks[Math.max(i,a)],r.positions.END);this.firstSelectedBlock=this.lastSelectedBlock=null}},{key:"enableCrossBlockSelection",value:function(t){var e=this.Editor.UI;d.default.isCollapsed||this.Editor.BlockSelection.clearSelection(t),e.nodes.redactor.contains(t.target)?this.watchSelection(t):this.Editor.BlockSelection.clearSelection(t)}},{key:"toggleBlocksSelectedState",value:function(t,e){for(var n=this.Editor,o=n.BlockManager,r=n.BlockSelection,i=o.blocks.indexOf(t),a=o.blocks.indexOf(e),s=t.selected!==e.selected,c=Math.min(i,a);c<=Math.max(i,a);c++){var l=o.blocks[c];l!==this.firstSelectedBlock&&l!==(s?t:e)&&(o.blocks[c].selected=!o.blocks[c].selected,r.clearCache())}}},{key:"isCrossBlockSelectionStarted",get:function(){return!!this.firstSelectedBlock&&!!this.lastSelectedBlock}}]),f}(f.default);o.default=g,g.displayName="CrossBlockSelection",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(21),n(22),n(2),n(3),n(5),n(6),n(4),n(25),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d){"use strict";var p=n(1);function h(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=p(r),i=p(i),a=p(a),s=p(s),c=p(c),l=p(l),u=p(u),f=p(f);var v=function(t){(0,c.default)(d,t);var e,n,o=(e=d,function(){var t,n=(0,u.default)(e);if(h()){var o=(0,u.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,l.default)(this,t)});function d(){var t;return(0,a.default)(this,d),(t=o.apply(this,arguments)).isStartedAtEditor=!1,t}return(0,s.default)(d,[{key:"toggleReadOnly",value:function(t){t?this.disableModuleBindings():this.enableModuleBindings()}},{key:"enableModuleBindings",value:function(){var t=this,e=this.Editor.UI;this.readOnlyMutableListeners.on(e.nodes.holder,"drop",function(){var e=(0,i.default)(r.default.mark((function e(n){return r.default.wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,t.processDrop(n);case 2:case"end":return e.stop()}}),e)})));return function(t){return e.apply(this,arguments)}}(),!0),this.readOnlyMutableListeners.on(e.nodes.holder,"dragstart",(function(){t.processDragStart()})),this.readOnlyMutableListeners.on(e.nodes.holder,"dragover",(function(e){t.processDragOver(e)}),!0)}},{key:"disableModuleBindings",value:function(){this.readOnlyMutableListeners.clearAll()}},{key:"processDrop",value:(n=(0,i.default)(r.default.mark((function t(e){var n,o,i,a,s,c;return r.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:n=this.Editor,o=n.BlockManager,i=n.Caret,a=n.Paste,e.preventDefault(),o.blocks.forEach((function(t){t.dropTarget=!1})),f.default.isAtEditor&&!f.default.isCollapsed&&this.isStartedAtEditor&&document.execCommand("delete"),this.isStartedAtEditor=!1;try{s=o.setCurrentBlockByChildNode(e.target),this.Editor.Caret.setToBlock(s,i.positions.END)}catch(t){c=o.setCurrentBlockByChildNode(o.lastBlock.holder),this.Editor.Caret.setToBlock(c,i.positions.END)}return t.next=8,a.processDataTransfer(e.dataTransfer,!0);case 8:case"end":return t.stop()}}),t,this)}))),function(t){return n.apply(this,arguments)})},{key:"processDragStart",value:function(){f.default.isAtEditor&&!f.default.isCollapsed&&(this.isStartedAtEditor=!0),this.Editor.InlineToolbar.close()}},{key:"processDragOver",value:function(t){t.preventDefault()}}]),d}((d=p(d)).default);o.default=v,v.displayName="DragNDrop",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l){"use strict";var u=n(1);function f(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=u(a),s=u(s),c=u(c);var d=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(f()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){var t;return(0,r.default)(this,o),(t=n.apply(this,arguments)).subscribers={},t}return(0,i.default)(o,[{key:"on",value:function(t,e){t in this.subscribers||(this.subscribers[t]=[]),this.subscribers[t].push(e)}},{key:"once",value:function(t,e){var n=this;t in this.subscribers||(this.subscribers[t]=[]),this.subscribers[t].push((function o(r){var i=e(r),a=n.subscribers[t].indexOf(o);return-1!==a&&n.subscribers[t].splice(a,1),i}))}},{key:"emit",value:function(t,e){this.subscribers[t]&&this.subscribers[t].reduce((function(t,e){return e(t)||t}),e)}},{key:"off",value:function(t,e){for(var n=0;n<this.subscribers[t].length;n++)if(this.subscribers[t][n]===e){delete this.subscribers[t][n];break}}},{key:"destroy",value:function(){this.subscribers=null}}]),o}((l=u(l)).default);o.default=d,d.displayName="Events",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7),n(8)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u){"use strict";var f=n(13),d=n(1);function p(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=d(r),i=d(i),a=d(a),s=d(s),c=d(c),l=d(l),u=f(u);var h=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(p()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){var t;return(0,r.default)(this,o),(t=n.apply(this,arguments)).allListeners=[],t}return(0,i.default)(o,[{key:"on",value:function(t,e,n){var o=arguments.length>3&&void 0!==arguments[3]&&arguments[3],r=u.generateId("l"),i={id:r,element:t,eventType:e,handler:n,options:o},a=this.findOne(t,e,n);if(!a)return this.allListeners.push(i),t.addEventListener(e,n,o),r}},{key:"off",value:function(t,e,n,o){var r=this,i=this.findAll(t,e,n);i.forEach((function(t,e){var n=r.allListeners.indexOf(i[e]);n>0&&(r.allListeners.splice(n,1),t.element.removeEventListener(t.eventType,t.handler,t.options))}))}},{key:"offById",value:function(t){var e=this.findById(t);e&&e.element.removeEventListener(e.eventType,e.handler,e.options)}},{key:"findOne",value:function(t,e,n){var o=this.findAll(t,e,n);return o.length>0?o[0]:null}},{key:"findAll",value:function(t,e,n){var o=t?this.findByEventTarget(t):[];return t&&e&&n?o.filter((function(t){return t.eventType===e&&t.handler===n})):t&&e?o.filter((function(t){return t.eventType===e})):o}},{key:"removeAll",value:function(){this.allListeners.map((function(t){t.element.removeEventListener(t.eventType,t.handler,t.options)})),this.allListeners=[]}},{key:"destroy",value:function(){this.removeAll()}},{key:"findByEventTarget",value:function(t){return this.allListeners.filter((function(e){if(e.element===t)return e}))}},{key:"findByType",value:function(t){return this.allListeners.filter((function(e){if(e.eventType===t)return e}))}},{key:"findByHandler",value:function(t){return this.allListeners.filter((function(e){if(e.handler===t)return e}))}},{key:"findById",value:function(t){return this.allListeners.find((function(e){return e.id===t}))}}]),o}(l.default);o.default=h,h.displayName="Listeners",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7),n(8),n(61)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f){"use strict";var d=n(13),p=n(1);function h(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=p(r),i=p(i),a=p(a),s=p(s),c=p(c),l=p(l),u=d(u),f=p(f);var v=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(h()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){var t;return(0,r.default)(this,o),(t=n.apply(this,arguments)).disabled=!1,t.mutationDebouncer=u.debounce((function(){t.updateNativeInputs(),u.isFunction(t.config.onChange)&&t.config.onChange(t.Editor.API.methods)}),o.DebounceTimer),t.nativeInputs=[],t}return(0,i.default)(o,[{key:"destroy",value:function(){var t=this;this.mutationDebouncer=null,this.observer&&this.observer.disconnect(),this.observer=null,this.nativeInputs.forEach((function(e){return t.Editor.Listeners.off(e,"input",t.mutationDebouncer)})),this.mutationDebouncer=null}},{key:"toggleReadOnly",value:function(t){t?this.disableModule():this.enableModule()}},{key:"disable",value:function(){this.disabled=!0}},{key:"enable",value:function(){this.disabled=!1}},{key:"setObserver",value:function(){var t=this,e=this.Editor.UI;this.observer=new MutationObserver((function(e,n){t.mutationHandler(e,n)})),this.observer.observe(e.nodes.redactor,{childList:!0,attributes:!0,subtree:!0,characterData:!0,characterDataOldValue:!0})}},{key:"mutationHandler",value:function(t,e){if(!this.disabled){var n=!1;t.forEach((function(t){switch(t.type){case"childList":case"characterData":n=!0;break;case"attributes":t.target.classList.contains(f.default.CSS.wrapper)||(n=!0)}})),n&&this.mutationDebouncer()}}},{key:"updateNativeInputs",value:function(){var t=this;this.nativeInputs&&this.nativeInputs.forEach((function(e){t.Editor.Listeners.off(e,"input")})),this.nativeInputs=Array.from(this.Editor.UI.nodes.redactor.querySelectorAll("textarea, input, select")),this.nativeInputs.forEach((function(e){return t.Editor.Listeners.on(e,"input",t.mutationDebouncer)}))}},{key:"enableModule",value:function(){var t=this;window.setTimeout((function(){t.setObserver(),t.updateNativeInputs(),t.enable()}),1e3)}},{key:"disableModule",value:function(){this.disable()}}]),o}(l.default);o.default=v,v.displayName="ModificationsObserver",v.DebounceTimer=450,t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7),n(384)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u){"use strict";var f=n(1);function d(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=f(r),i=f(i),a=f(a),s=f(s),c=f(c),l=f(l),u=f(u);var p=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(d()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){return(0,r.default)(this,o),n.apply(this,arguments)}return(0,i.default)(o,[{key:"show",value:function(t){u.default.show(t)}}]),o}(l.default);o.default=p,p.displayName="Notifier",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(66),n(21),n(22),n(39),n(2),n(3),n(5),n(6),n(4),n(7),n(15),n(8)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d,p,h,v){"use strict";var y=n(13),g=n(1);function b(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=g(r),i=g(i),a=g(a),s=g(s),c=g(c),l=g(l),u=g(u),f=g(f),d=g(d),p=g(p),h=g(h),v=y(v);var m=function(t){(0,u.default)(w,t);var e,n,o,p,y,g,m,k,x,S=(e=w,function(){var t,n=(0,d.default)(e);if(b()){var o=(0,d.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,f.default)(this,t)});function w(){var t;return(0,c.default)(this,w),(t=S.apply(this,arguments)).MIME_TYPE="application/x-editor-js",t.toolsTags={},t.tagsByTool={},t.toolsPatterns=[],t.toolsFiles={},t.exceptionList=[],t.processTool=function(e){var n=(0,s.default)(e,2),o=n[0],r=n[1];try{var i=new t.Editor.Tools.blockTools[o]({api:t.Editor.API.getMethodsForTool(o),config:{},data:{},readOnly:!1});if(!1===r.pasteConfig)return void t.exceptionList.push(o);if("function"!=typeof i.onPaste)return;var a=r.pasteConfig||{};t.getTagsConfig(o,a),t.getFilesConfig(o,a),t.getPatternsConfig(o,a)}catch(t){v.log("Paste handling for «".concat(o,"» Tool hasn't been set up because of the error"),"warn",t)}},t.handlePasteEvent=function(){var e=(0,a.default)(i.default.mark((function e(n){var o,r,a;return i.default.wrap((function(e){for(;;)switch(e.prev=e.next){case 0:if(o=t.Editor,r=o.BlockManager,a=o.Toolbar,r.currentBlock&&(!t.isNativeBehaviour(n.target)||n.clipboardData.types.includes("Files"))){e.next=3;break}return e.abrupt("return");case 3:if(!r.currentBlock||!t.exceptionList.includes(r.currentBlock.name)){e.next=5;break}return e.abrupt("return");case 5:n.preventDefault(),t.processDataTransfer(n.clipboardData),r.clearFocused(),a.close();case 9:case"end":return e.stop()}}),e)})));return function(t){return e.apply(this,arguments)}}(),t}return(0,l.default)(w,[{key:"prepare",value:(x=(0,a.default)(i.default.mark((function t(){return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:this.processTools();case 1:case"end":return t.stop()}}),t,this)}))),function(){return x.apply(this,arguments)})},{key:"toggleReadOnly",value:function(t){t?this.unsetCallback():this.setCallback()}},{key:"processDataTransfer",value:(k=(0,a.default)(i.default.mark((function t(e){var n,o,r,a,s,c,l,u,f,d=arguments;return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:if(n=d.length>1&&void 0!==d[1]&&d[1],o=this.Editor.Sanitizer,!((r=e.types).includes?r.includes("Files"):r.contains("Files"))){t.next=8;break}return t.next=7,this.processFiles(e.files);case 7:return t.abrupt("return");case 8:if(a=e.getData(this.MIME_TYPE),s=e.getData("text/plain"),c=e.getData("text/html"),!a){t.next=19;break}return t.prev=12,this.insertEditorJSData(JSON.parse(a)),t.abrupt("return");case 17:t.prev=17,t.t0=t.catch(12);case 19:if(n&&s.trim()&&c.trim()&&(c="<p>"+(c.trim()?c:s)+"</p>"),l=Object.keys(this.toolsTags).reduce((function(t,e){return t[e.toLowerCase()]=!0,t}),{}),u=Object.assign({},l,o.getAllInlineToolsConfig(),{br:{}}),(f=o.clean(c,u)).trim()&&f.trim()!==s&&h.default.isHTMLString(f)){t.next=28;break}return t.next=26,this.processText(s);case 26:t.next=30;break;case 28:return t.next=30,this.processText(f,!0);case 30:case"end":return t.stop()}}),t,this,[[12,17]])}))),function(t){return k.apply(this,arguments)})},{key:"processText",value:(m=(0,a.default)(i.default.mark((function t(e){var n,o,r,s,c,l,u,f,d=this,p=arguments;return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:if(n=p.length>1&&void 0!==p[1]&&p[1],o=this.Editor,r=o.Caret,s=o.BlockManager,c=o.Tools,(l=n?this.processHTML(e):this.processPlain(e)).length){t.next=5;break}return t.abrupt("return");case 5:if(1!==l.length){t.next=8;break}return l[0].isBlock?this.processSingleBlock(l.pop()):this.processInlinePaste(l.pop()),t.abrupt("return");case 8:u=s.currentBlock&&c.isDefault(s.currentBlock.tool),f=u&&s.currentBlock.isEmpty,l.map(function(){var t=(0,a.default)(i.default.mark((function t(e,n){return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return t.abrupt("return",d.insertBlock(e,0===n&&f));case 1:case"end":return t.stop()}}),t)})));return function(e,n){return t.apply(this,arguments)}}()),s.currentBlock&&r.setToBlock(s.currentBlock,r.positions.END);case 12:case"end":return t.stop()}}),t,this)}))),function(t){return m.apply(this,arguments)})},{key:"setCallback",value:function(){this.Editor.Listeners.on(this.Editor.UI.nodes.holder,"paste",this.handlePasteEvent)}},{key:"unsetCallback",value:function(){this.Editor.Listeners.off(this.Editor.UI.nodes.holder,"paste",this.handlePasteEvent)}},{key:"processTools",value:function(){var t=this.Editor.Tools.blockTools;Object.entries(t).forEach(this.processTool)}},{key:"getTagsConfig",value:function(t,e){var n=this,o=e.tags||[];o.forEach((function(e){Object.prototype.hasOwnProperty.call(n.toolsTags,e)?v.log("Paste handler for «".concat(t,"» Tool on «").concat(e,"» tag is skipped ")+"because it is already used by «".concat(n.toolsTags[e].tool,"» Tool."),"warn"):n.toolsTags[e.toUpperCase()]={tool:t}})),this.tagsByTool[t]=o.map((function(t){return t.toUpperCase()}))}},{key:"getFilesConfig",value:function(t,e){var n=e.files,o=void 0===n?{}:n,r=o.extensions,i=o.mimeTypes;(r||i)&&(r&&!Array.isArray(r)&&(v.log("«extensions» property of the onDrop config for «".concat(t,"» Tool should be an array")),r=[]),i&&!Array.isArray(i)&&(v.log("«mimeTypes» property of the onDrop config for «".concat(t,"» Tool should be an array")),i=[]),i&&(i=i.filter((function(e){return!!v.isValidMimeType(e)||(v.log("MIME type value «".concat(e,"» for the «").concat(t,"» Tool is not a valid MIME type"),"warn"),!1)}))),this.toolsFiles[t]={extensions:r||[],mimeTypes:i||[]})}},{key:"getPatternsConfig",value:function(t,e){var n=this;e.patterns&&!v.isEmpty(e.patterns)&&Object.entries(e.patterns).forEach((function(e){var o=(0,s.default)(e,2),r=o[0],i=o[1];i instanceof RegExp||v.log("Pattern ".concat(i," for «").concat(t,"» Tool is skipped because it should be a Regexp instance."),"warn"),n.toolsPatterns.push({key:r,pattern:i,tool:t})}))}},{key:"isNativeBehaviour",value:function(t){return h.default.isNativeInput(t)}},{key:"processFiles",value:(g=(0,a.default)(i.default.mark((function t(e){var n,o,r,a,s,c,l=this;return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return n=this.Editor,o=n.BlockManager,r=n.Tools,t.next=3,Promise.all(Array.from(e).map((function(t){return l.processFile(t)})));case 3:a=(a=t.sent).filter((function(t){return!!t})),s=r.isDefault(o.currentBlock.tool),c=s&&o.currentBlock.isEmpty,a.forEach((function(t,e){o.paste(t.type,t.event,0===e&&c)}));case 8:case"end":return t.stop()}}),t,this)}))),function(t){return g.apply(this,arguments)})},{key:"processFile",value:(y=(0,a.default)(i.default.mark((function t(e){var n,o,r,a,c;return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:if(n=v.getFileExtension(e),o=Object.entries(this.toolsFiles).find((function(t){var o=(0,s.default)(t,2),r=(o[0],o[1]),i=r.mimeTypes,a=r.extensions,c=e.type.split("/"),l=(0,s.default)(c,2),u=l[0],f=l[1],d=a.find((function(t){return t.toLowerCase()===n.toLowerCase()})),p=i.find((function(t){var e=t.split("/"),n=(0,s.default)(e,2),o=n[0],r=n[1];return o===u&&(r===f||"*"===r)}));return!!d||!!p}))){t.next=4;break}return t.abrupt("return");case 4:return r=(0,s.default)(o,1),a=r[0],c=this.composePasteEvent("file",{file:e}),t.abrupt("return",{event:c,type:a});case 7:case"end":return t.stop()}}),t,this)}))),function(t){return y.apply(this,arguments)})},{key:"processHTML",value:function(t){var e=this,n=this.Editor,o=n.Tools,r=n.Sanitizer,i=this.config.defaultBlock,a=h.default.make("DIV");return a.innerHTML=t,this.getNodes(a).map((function(t){var n,a=i,s=!1;switch(t.nodeType){case Node.DOCUMENT_FRAGMENT_NODE:(n=h.default.make("div")).appendChild(t);break;case Node.ELEMENT_NODE:n=t,s=!0,e.toolsTags[n.tagName]&&(a=e.toolsTags[n.tagName].tool)}var c=o.blockTools[a].pasteConfig.tags.reduce((function(t,e){return t[e.toLowerCase()]={},t}),{}),l=Object.assign({},c,r.getInlineToolsConfig(a));return n.innerHTML=r.clean(n.innerHTML,l),{content:n,isBlock:s,tool:a,event:e.composePasteEvent("tag",{data:n})}})).filter((function(t){return!h.default.isNodeEmpty(t.content)||h.default.isSingleTag(t.content)}))}},{key:"processPlain",value:function(t){var e=this,n=this.config.defaultBlock;if(!t)return[];var o=n;return t.split(/\r?\n/).filter((function(t){return t.trim()})).map((function(t){var n=h.default.make("div");n.textContent=t;var r=e.composePasteEvent("tag",{data:n});return{content:n,tool:o,isBlock:!1,event:r}}))}},{key:"processSingleBlock",value:(p=(0,a.default)(i.default.mark((function t(e){var n,o,r,a,s;return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:if(n=this.Editor,o=n.Caret,r=n.BlockManager,a=n.Tools,(s=r.currentBlock)&&e.tool===s.name&&h.default.containsOnlyInlineElements(e.content.innerHTML)){t.next=5;break}return this.insertBlock(e,s&&a.isDefault(s.tool)&&s.isEmpty),t.abrupt("return");case 5:o.insertContentAtCaretPosition(e.content.innerHTML);case 6:case"end":return t.stop()}}),t,this)}))),function(t){return p.apply(this,arguments)})},{key:"processInlinePaste",value:(o=(0,a.default)(i.default.mark((function t(e){var n,o,r,a,s,c,l,u,f,d;return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:if(n=this.Editor,o=n.BlockManager,r=n.Caret,a=n.Sanitizer,s=n.Tools,c=e.content,!(o.currentBlock&&s.isDefault(o.currentBlock.tool)&&c.textContent.length<w.PATTERN_PROCESSING_MAX_LENGTH)){t.next=12;break}return t.next=6,this.processPattern(c.textContent);case 6:if(!(l=t.sent)){t.next=12;break}return u=o.currentBlock&&s.isDefault(o.currentBlock.tool)&&o.currentBlock.isEmpty,f=o.paste(l.tool,l.event,u),r.setToBlock(f,r.positions.END),t.abrupt("return");case 12:o.currentBlock&&o.currentBlock.currentInput?(d=a.getInlineToolsConfig(o.currentBlock.name),document.execCommand("insertHTML",!1,a.clean(c.innerHTML,d))):this.insertBlock(e);case 13:case"end":return t.stop()}}),t,this)}))),function(t){return o.apply(this,arguments)})},{key:"processPattern",value:(n=(0,a.default)(i.default.mark((function t(e){var n,o;return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:if(n=this.toolsPatterns.find((function(t){var n=t.pattern.exec(e);return!!n&&e===n.shift()}))){t.next=3;break}return t.abrupt("return");case 3:return o=this.composePasteEvent("pattern",{key:n.key,data:e}),t.abrupt("return",{event:o,tool:n.tool});case 5:case"end":return t.stop()}}),t,this)}))),function(t){return n.apply(this,arguments)})},{key:"insertBlock",value:function(t){var e,n=arguments.length>1&&void 0!==arguments[1]&&arguments[1],o=this.Editor,r=o.BlockManager,i=o.Caret,a=r.currentBlock;if(n&&a&&a.isEmpty)return e=r.paste(t.tool,t.event,!0),void i.setToBlock(e,i.positions.END);e=r.paste(t.tool,t.event),i.setToBlock(e,i.positions.END)}},{key:"insertEditorJSData",value:function(t){var e=this.Editor,n=e.BlockManager,o=e.Tools;t.forEach((function(t,e){var r=t.tool,i=t.data,a=!1;0===e&&(a=n.currentBlock&&o.isDefault(n.currentBlock.tool)&&n.currentBlock.isEmpty),n.insert({tool:r,data:i,replace:a})}))}},{key:"processElementNode",value:function(t,e,n){var o=Object.keys(this.toolsTags),i=t,a=(this.toolsTags[i.tagName]||{}).tool,s=void 0===a?"":a,c=this.tagsByTool[s]||[],l=o.includes(i.tagName),u=h.default.blockElements.includes(i.tagName.toLowerCase()),f=Array.from(i.children).some((function(t){var e=t.tagName;return o.includes(e)&&!c.includes(e)})),d=Array.from(i.children).some((function(t){var e=t.tagName;return h.default.blockElements.includes(e.toLowerCase())}));return u||l||f?l&&!f||u&&!d&&!f?[].concat((0,r.default)(e),[n,i]):void 0:(n.appendChild(i),[].concat((0,r.default)(e),[n]))}},{key:"getNodes",value:function(t){var e,n=this;return Array.from(t.childNodes).reduce((function t(o,i){if(h.default.isEmpty(i)&&!h.default.isSingleTag(i))return o;var a=o[o.length-1],s=new DocumentFragment;switch(a&&h.default.isFragment(a)&&(s=o.pop()),i.nodeType){case Node.ELEMENT_NODE:if(e=n.processElementNode(i,o,s))return e;break;case Node.TEXT_NODE:return s.appendChild(i),[].concat((0,r.default)(o),[s]);default:return[].concat((0,r.default)(o),[s])}return[].concat((0,r.default)(o),(0,r.default)(Array.from(i.childNodes).reduce(t,[])))}),[])}},{key:"composePasteEvent",value:function(t,e){return new CustomEvent(t,{detail:e})}}]),w}(p.default);o.default=m,m.displayName="Paste",m.PATTERN_PROCESSING_MAX_LENGTH=450,t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(21),n(39),n(22),n(2),n(3),n(5),n(6),n(4),n(7),n(144)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d,p){"use strict";var h=n(1);function v(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=h(r),i=h(i),a=h(a),s=h(s),c=h(c),l=h(l),u=h(u),f=h(f);var y=function(t){(0,l.default)(h,t);var e,n,o,d=(e=h,function(){var t,n=(0,f.default)(e);if(v()){var o=(0,f.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,u.default)(this,t)});function h(){var t;return(0,s.default)(this,h),(t=d.apply(this,arguments)).toolsDontSupportReadOnly=[],t.readOnlyEnabled=!1,t}return(0,c.default)(h,[{key:"prepare",value:(o=(0,a.default)(r.default.mark((function t(){var e,n,o;return r.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:e=this.Editor.Tools,n=e.blockTools,o=[],Object.entries(n).forEach((function(t){var n=(0,i.default)(t,2),r=n[0],a=n[1];e.isReadOnlySupported(a)||o.push(r)})),this.toolsDontSupportReadOnly=o,this.config.readOnly&&o.length>0&&this.throwCriticalError(),this.toggle(this.config.readOnly);case 7:case"end":return t.stop()}}),t,this)}))),function(){return o.apply(this,arguments)})},{key:"toggle",value:(n=(0,a.default)(r.default.mark((function t(){var e,n,o,i,a=arguments;return r.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:(e=a.length>0&&void 0!==a[0]?a[0]:!this.readOnlyEnabled)&&this.toolsDontSupportReadOnly.length>0&&this.throwCriticalError(),n=this.readOnlyEnabled,this.readOnlyEnabled=e,t.t0=r.default.keys(this.Editor);case 5:if((t.t1=t.t0()).done){t.next=12;break}if(o=t.t1.value,this.Editor[o].toggleReadOnly){t.next=9;break}return t.abrupt("continue",5);case 9:this.Editor[o].toggleReadOnly(e),t.next=5;break;case 12:if(n!==e){t.next=14;break}return t.abrupt("return",this.readOnlyEnabled);case 14:return t.next=16,this.Editor.Saver.save();case 16:return i=t.sent,t.next=19,this.Editor.BlockManager.clear();case 19:return t.next=21,this.Editor.Renderer.render(i.blocks);case 21:return t.abrupt("return",this.readOnlyEnabled);case 22:case"end":return t.stop()}}),t,this)}))),function(){return n.apply(this,arguments)})},{key:"throwCriticalError",value:function(){throw new p.CriticalError("To enable read-only mode all connected tools should support it. Tools ".concat(this.toolsDontSupportReadOnly.join(", ")," don't support read-only mode."))}},{key:"isEnabled",get:function(){return this.readOnlyEnabled}}]),h}((d=h(d)).default);o.default=y,y.displayName="ReadOnly",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7),n(15),n(25),n(61)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d){"use strict";var p=n(1);function h(t){if("undefined"==typeof Symbol||null==t[Symbol.iterator]){if(Array.isArray(t)||(t=function(t,e){if(t){if("string"==typeof t)return v(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);return"Object"===n&&t.constructor&&(n=t.constructor.name),"Map"===n||"Set"===n?Array.from(n):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?v(t,e):void 0}}(t))){var e=0,n=function(){};return{s:n,n:function(){return e>=t.length?{done:!0}:{done:!1,value:t[e++]}},e:function(t){throw t},f:n}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,r,i=!0,a=!1;return{s:function(){o=t[Symbol.iterator]()},n:function(){var t=o.next();return i=t.done,t},e:function(t){a=!0,r=t},f:function(){try{i||null==o.return||o.return()}finally{if(a)throw r}}}}function v(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,o=new Array(e);n<e;n++)o[n]=t[n];return o}function y(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=p(r),i=p(i),a=p(a),s=p(s),c=p(c),l=p(l),u=p(u),f=p(f),d=p(d);var g=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(y()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){var t;return(0,r.default)(this,o),(t=n.apply(this,arguments)).isRectSelectionActivated=!1,t.SCROLL_SPEED=3,t.HEIGHT_OF_SCROLL_ZONE=40,t.BOTTOM_SCROLL_ZONE=1,t.TOP_SCROLL_ZONE=2,t.MAIN_MOUSE_BUTTON=0,t.mousedown=!1,t.isScrolling=!1,t.inScrollZone=null,t.startX=0,t.startY=0,t.mouseX=0,t.mouseY=0,t.stackOfSelected=[],t.listenerIds=[],t}return(0,i.default)(o,[{key:"prepare",value:function(){this.enableModuleBindings()}},{key:"startSelection",value:function(t,e){var n=document.elementFromPoint(t-window.pageXOffset,e-window.pageYOffset);n.closest(".".concat(this.Editor.Toolbar.CSS.toolbar))||(this.Editor.BlockSelection.allBlocksSelected=!1,this.clearSelection(),this.stackOfSelected=[]);var o=[".".concat(d.default.CSS.content),".".concat(this.Editor.Toolbar.CSS.toolbar),".".concat(this.Editor.InlineToolbar.CSS.inlineToolbar)],r=n.closest("."+this.Editor.UI.CSS.editorWrapper),i=o.some((function(t){return!!n.closest(t)}));r&&!i&&(this.mousedown=!0,this.startX=t,this.startY=e)}},{key:"endSelection",value:function(){this.mousedown=!1,this.startX=0,this.startY=0,this.overlayRectangle.style.display="none"}},{key:"isRectActivated",value:function(){return this.isRectSelectionActivated}},{key:"clearSelection",value:function(){this.isRectSelectionActivated=!1}},{key:"enableModuleBindings",value:function(){var t=this,e=this.Editor.Listeners,n=this.genHTML().container;e.on(n,"mousedown",(function(e){t.processMouseDown(e)}),!1),e.on(document.body,"mousemove",(function(e){t.processMouseMove(e)}),!1),e.on(document.body,"mouseleave",(function(){t.processMouseLeave()})),e.on(window,"scroll",(function(e){t.processScroll(e)}),!1),e.on(document.body,"mouseup",(function(){t.processMouseUp()}),!1)}},{key:"processMouseDown",value:function(t){t.button===this.MAIN_MOUSE_BUTTON&&this.startSelection(t.pageX,t.pageY)}},{key:"processMouseMove",value:function(t){this.changingRectangle(t),this.scrollByZones(t.clientY)}},{key:"processMouseLeave",value:function(){this.clearSelection(),this.endSelection()}},{key:"processScroll",value:function(t){this.changingRectangle(t)}},{key:"processMouseUp",value:function(){this.endSelection()}},{key:"scrollByZones",value:function(t){this.inScrollZone=null,t<=this.HEIGHT_OF_SCROLL_ZONE&&(this.inScrollZone=this.TOP_SCROLL_ZONE),document.documentElement.clientHeight-t<=this.HEIGHT_OF_SCROLL_ZONE&&(this.inScrollZone=this.BOTTOM_SCROLL_ZONE),this.inScrollZone?this.isScrolling||(this.scrollVertical(this.inScrollZone===this.TOP_SCROLL_ZONE?-this.SCROLL_SPEED:this.SCROLL_SPEED),this.isScrolling=!0):this.isScrolling=!1}},{key:"genHTML",value:function(){var t=this.Editor.UI,e=t.nodes.holder.querySelector("."+t.CSS.editorWrapper),n=u.default.make("div",o.CSS.overlay,{}),r=u.default.make("div",o.CSS.overlayContainer,{}),i=u.default.make("div",o.CSS.rect,{});return r.appendChild(i),n.appendChild(r),e.appendChild(n),this.overlayRectangle=i,{container:e,overlay:n}}},{key:"scrollVertical",value:function(t){var e=this;if(this.inScrollZone&&this.mousedown){var n=window.pageYOffset;window.scrollBy(0,t),this.mouseY+=window.pageYOffset-n,setTimeout((function(){e.scrollVertical(t)}),0)}}},{key:"changingRectangle",value:function(t){if(this.mousedown){void 0!==t.pageY&&(this.mouseX=t.pageX,this.mouseY=t.pageY);var e=this.genInfoForMouseSelection(),n=e.rightPos,o=e.leftPos,r=e.index,i=this.startX>n&&this.mouseX>n,a=this.startX<o&&this.mouseX<o;this.rectCrossesBlocks=!(i||a),this.isRectSelectionActivated||(this.rectCrossesBlocks=!1,this.isRectSelectionActivated=!0,this.shrinkRectangleToPoint(),this.overlayRectangle.style.display="block"),this.updateRectangleSize(),void 0!==r&&(this.trySelectNextBlock(r),this.inverseSelection(),f.default.get().removeAllRanges(),t.preventDefault())}}},{key:"shrinkRectangleToPoint",value:function(){this.overlayRectangle.style.left="".concat(this.startX-window.pageXOffset,"px"),this.overlayRectangle.style.top="".concat(this.startY-window.pageYOffset,"px"),this.overlayRectangle.style.bottom="calc(100% - ".concat(this.startY-window.pageYOffset,"px"),this.overlayRectangle.style.right="calc(100% - ".concat(this.startX-window.pageXOffset,"px")}},{key:"inverseSelection",value:function(){var t=this.Editor.BlockManager.getBlockByIndex(this.stackOfSelected[0]).selected;if(this.rectCrossesBlocks&&!t){var e,n=h(this.stackOfSelected);try{for(n.s();!(e=n.n()).done;){var o=e.value;this.Editor.BlockSelection.selectBlockByIndex(o)}}catch(t){n.e(t)}finally{n.f()}}if(!this.rectCrossesBlocks&&t){var r,i=h(this.stackOfSelected);try{for(i.s();!(r=i.n()).done;){var a=r.value;this.Editor.BlockSelection.unSelectBlockByIndex(a)}}catch(t){i.e(t)}finally{i.f()}}}},{key:"updateRectangleSize",value:function(){this.mouseY>=this.startY?(this.overlayRectangle.style.top="".concat(this.startY-window.pageYOffset,"px"),this.overlayRectangle.style.bottom="calc(100% - ".concat(this.mouseY-window.pageYOffset,"px")):(this.overlayRectangle.style.bottom="calc(100% - ".concat(this.startY-window.pageYOffset,"px"),this.overlayRectangle.style.top="".concat(this.mouseY-window.pageYOffset,"px")),this.mouseX>=this.startX?(this.overlayRectangle.style.left="".concat(this.startX-window.pageXOffset,"px"),this.overlayRectangle.style.right="calc(100% - ".concat(this.mouseX-window.pageXOffset,"px")):(this.overlayRectangle.style.right="calc(100% - ".concat(this.startX-window.pageXOffset,"px"),this.overlayRectangle.style.left="".concat(this.mouseX-window.pageXOffset,"px"))}},{key:"genInfoForMouseSelection",value:function(){var t,e=document.body.offsetWidth/2,n=this.mouseY-window.pageYOffset,o=document.elementFromPoint(e,n),r=this.Editor.BlockManager.getBlockByChildNode(o);void 0!==r&&(t=this.Editor.BlockManager.blocks.findIndex((function(t){return t.holder===r.holder})));var i=this.Editor.BlockManager.lastBlock.holder.querySelector("."+d.default.CSS.content),a=Number.parseInt(window.getComputedStyle(i).width,10)/2;return{index:t,leftPos:e-a,rightPos:e+a}}},{key:"addBlockInSelection",value:function(t){this.rectCrossesBlocks&&this.Editor.BlockSelection.selectBlockByIndex(t),this.stackOfSelected.push(t)}},{key:"trySelectNextBlock",value:function(t){var e=this,n=this.stackOfSelected[this.stackOfSelected.length-1]===t,o=this.stackOfSelected.length;if(!n){var r=this.stackOfSelected[o-1]-this.stackOfSelected[o-2]>0,i=0;o>1&&(i=r?1:-1);var a=t>this.stackOfSelected[o-1]&&1===i,s=t<this.stackOfSelected[o-1]&&-1===i,c=!(a||s||0===i);if(c||!(t>this.stackOfSelected[o-1]||void 0===this.stackOfSelected[o-1])){if(!c&&t<this.stackOfSelected[o-1])for(var l=this.stackOfSelected[o-1]-1;l>=t;l--)this.addBlockInSelection(l);else if(c){var u,f=o-1;for(u=t>this.stackOfSelected[o-1]?function(){return t>e.stackOfSelected[f]}:function(){return t<e.stackOfSelected[f]};u();)this.rectCrossesBlocks&&this.Editor.BlockSelection.unSelectBlockByIndex(this.stackOfSelected[f]),this.stackOfSelected.pop(),f--}}else for(var d=this.stackOfSelected[o-1]+1||t;d<=t;d++)this.addBlockInSelection(d)}}}],[{key:"CSS",get:function(){return{overlay:"codex-editor-overlay",overlayContainer:"codex-editor-overlay__container",rect:"codex-editor-overlay__rectangle",topScrollZone:"codex-editor-overlay__scroll-zone--top",bottomScrollZone:"codex-editor-overlay__scroll-zone--bottom"}}}]),o}(l.default);o.default=g,g.displayName="RectangleSelection",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(21),n(22),n(2),n(3),n(5),n(6),n(4),n(7),n(8)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d){"use strict";var p=n(13),h=n(1);function v(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=h(r),i=h(i),a=h(a),s=h(s),c=h(c),l=h(l),u=h(u),f=h(f),d=p(d);var y=function(t){(0,c.default)(p,t);var e,n,o,f=(e=p,function(){var t,n=(0,u.default)(e);if(v()){var o=(0,u.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,l.default)(this,t)});function p(){return(0,a.default)(this,p),f.apply(this,arguments)}return(0,s.default)(p,[{key:"render",value:(o=(0,i.default)(r.default.mark((function t(e){var n,o,i=this;return r.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return n=e.map((function(t){return{function:function(){return i.insertBlock(t)}}})),t.next=3,d.sequence(n);case 3:return o=t.sent,this.Editor.UI.checkEmptiness(),t.abrupt("return",o);case 6:case"end":return t.stop()}}),t,this)}))),function(t){return o.apply(this,arguments)})},{key:"insertBlock",value:(n=(0,i.default)(r.default.mark((function t(e){var n,o,i,a,s,c,l,u;return r.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:if(n=this.Editor,o=n.Tools,i=n.BlockManager,a=e.type,s=e.data,!(a in o.available)){t.next=14;break}t.prev=4,i.insert({tool:a,data:s}),t.next=12;break;case 8:throw t.prev=8,t.t0=t.catch(4),d.log("Block «".concat(a,"» skipped because of plugins error"),"warn",s),Error(t.t0);case 12:t.next=19;break;case 14:c={savedData:{type:a,data:s},title:a},a in o.unavailable&&(l=o.unavailable[a].toolbox,u=o.getToolSettings(a).toolbox,c.title=l.title||u&&u.title||c.title),i.insert({tool:o.stubTool,data:c}).stretched=!0,d.log("Tool «".concat(a,"» is not found. Check 'tools' property at your initial Editor.js config."),"warn");case 19:case"end":return t.stop()}}),t,this,[[4,8]])}))),function(t){return n.apply(this,arguments)})}]),p}(f.default);o.default=y,y.displayName="Renderer",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(39),n(52),n(2),n(3),n(5),n(6),n(4),n(7),n(8),n(385)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d,p){"use strict";var h=n(13),v=n(1);function y(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=v(r),i=v(i),a=v(a),s=v(s),c=v(c),l=v(l),u=v(u),f=v(f),d=h(d),p=v(p);var g=function(t){(0,c.default)(o,t);var e,n=(e=o,function(){var t,n=(0,u.default)(e);if(y()){var o=(0,u.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,l.default)(this,t)});function o(){var t;return(0,a.default)(this,o),(t=n.apply(this,arguments)).configCache={},t.inlineToolsConfigCache=null,t}return(0,s.default)(o,[{key:"sanitizeBlocks",value:function(t){var e=this;return t.map((function(t){var n=e.composeToolConfig(t.tool);return d.isEmpty(n)||(t.data=e.deepSanitize(t.data,n)),t}))}},{key:"deepSanitize",value:function(t,e){return Array.isArray(t)?this.cleanArray(t,e):"object"===(0,i.default)(t)?this.cleanObject(t,e):"string"==typeof t?this.cleanOneItem(t,e):t}},{key:"clean",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n={tags:e},o=this.createHTMLJanitorInstance(n);return o.clean(t)}},{key:"composeToolConfig",value:function(t){if(this.configCache[t])return this.configCache[t];var e=this.Editor.Tools.INTERNAL_SETTINGS.SANITIZE_CONFIG,n=this.Editor.Tools.available[t],o=this.getInlineToolsConfig(t);if(!n.sanitize||n[e]&&d.isEmpty(n[e]))return o;var r=n.sanitize,a={};for(var s in r)if(Object.prototype.hasOwnProperty.call(r,s)){var c=r[s];"object"===(0,i.default)(c)?a[s]=Object.assign({},o,c):a[s]=c}return this.configCache[t]=a,a}},{key:"getInlineToolsConfig",value:function(t){var e=this.Editor.Tools,n=e.getToolSettings(t).inlineToolbar||[],o={};return"boolean"==typeof n&&n?o=this.getAllInlineToolsConfig():n.map((function(t){o=Object.assign(o,e.inline[t][e.INTERNAL_SETTINGS.SANITIZE_CONFIG])})),o.br=!0,o.wbr=!0,o}},{key:"getAllInlineToolsConfig",value:function(){var t=this.Editor.Tools;if(this.inlineToolsConfigCache)return this.inlineToolsConfigCache;var e={};return Object.entries(t.inline).forEach((function(n){var o=(0,r.default)(n,2)[1];Object.assign(e,o[t.INTERNAL_SETTINGS.SANITIZE_CONFIG])})),this.inlineToolsConfigCache=e,this.inlineToolsConfigCache}},{key:"cleanArray",value:function(t,e){var n=this;return t.map((function(t){return n.deepSanitize(t,e)}))}},{key:"cleanObject",value:function(t,e){var n={};for(var o in t)if(Object.prototype.hasOwnProperty.call(t,o)){var r=t[o],i=this.isRule(e[o])?e[o]:e;n[o]=this.deepSanitize(r,i)}return n}},{key:"cleanOneItem",value:function(t,e){return"object"===(0,i.default)(e)?this.clean(t,e):!1===e?this.clean(t,{}):t}},{key:"isRule",value:function(t){return"object"===(0,i.default)(t)||"boolean"==typeof t||d.isFunction(t)}},{key:"createHTMLJanitorInstance",value:function(t){return t?new p.default(t):null}}]),o}(f.default);o.default=g,g.displayName="Sanitizer",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(21),n(22),n(2),n(3),n(5),n(6),n(4),n(7),n(8)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d){"use strict";var p=n(13),h=n(1);function v(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=h(r),i=h(i),a=h(a),s=h(s),c=h(c),l=h(l),u=h(u),f=h(f),d=p(d);var y=function(t){(0,c.default)(p,t);var e,n,o,f=(e=p,function(){var t,n=(0,u.default)(e);if(v()){var o=(0,u.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,l.default)(this,t)});function p(){return(0,a.default)(this,p),f.apply(this,arguments)}return(0,s.default)(p,[{key:"save",value:(o=(0,i.default)(r.default.mark((function t(){var e,n,o,i,a,s,c,l,u=this;return r.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return e=this.Editor,n=e.BlockManager,o=e.Sanitizer,i=e.ModificationsObserver,a=n.blocks,s=[],i.disable(),t.prev=3,a.forEach((function(t){s.push(u.getSavedData(t))})),t.next=7,Promise.all(s);case 7:return c=t.sent,t.next=10,o.sanitizeBlocks(c);case 10:return l=t.sent,t.abrupt("return",this.makeOutput(l));case 12:return t.prev=12,i.enable(),t.finish(12);case 15:case"end":return t.stop()}}),t,this,[[3,,12,15]])}))),function(){return o.apply(this,arguments)})},{key:"getSavedData",value:(n=(0,i.default)(r.default.mark((function t(e){var n,o;return r.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,e.save();case 2:if(n=t.sent,t.t0=n,!t.t0){t.next=8;break}return t.next=7,e.validate(n.data);case 7:t.t0=t.sent;case 8:return o=t.t0,t.abrupt("return",Object.assign(Object.assign({},n),{isValid:o}));case 10:case"end":return t.stop()}}),t)}))),function(t){return n.apply(this,arguments)})},{key:"makeOutput",value:function(t){var e=this,n=0,o=[];return d.log("[Editor.js saving]:","groupCollapsed"),t.forEach((function(t){var r=t.tool,i=t.data,a=t.time,s=t.isValid;if(n+=a,d.log("".concat(r.charAt(0).toUpperCase()+r.slice(1)),"group"),!s)return d.log("Block «".concat(r,"» skipped because saved data is invalid")),void d.log(void 0,"groupEnd");d.log(i),d.log(void 0,"groupEnd"),r!==e.Editor.Tools.stubTool?o.push({type:r,data:i}):o.push(i)})),d.log("Total","log",n),d.log(void 0,"groupEnd"),{time:+new Date,blocks:o,version:"2.19.0"}}}]),p}(f.default);o.default=y,y.displayName="Saver",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(386),n(7)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u){"use strict";var f=n(1);function d(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=f(r),i=f(i),a=f(a),s=f(s),c=f(c),l=f(l);var p=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(d()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){var t;return(0,r.default)(this,o),(t=n.apply(this,arguments)).registeredShortcuts=[],t}return(0,i.default)(o,[{key:"add",value:function(t){var e=new l.default({name:t.name,on:document,callback:t.handler});this.registeredShortcuts.push(e)}},{key:"remove",value:function(t){var e=this.registeredShortcuts.findIndex((function(e){return e.name===t}));-1!==e&&this.registeredShortcuts[e]&&(this.registeredShortcuts[e].remove(),this.registeredShortcuts.splice(e,1))}}]),o}((u=f(u)).default);o.default=p,p.displayName="Shortcuts",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7),n(15),n(60),n(8),n(25)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d,p){"use strict";var h=n(13),v=n(1);function y(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=v(r),i=v(i),a=v(a),s=v(s),c=v(c),l=v(l),u=v(u),f=v(f),d=h(d),p=v(p);var g=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(y()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){var t;return(0,r.default)(this,o),(t=n.apply(this,arguments)).buttons=[],t.flipper=null,t.selection=new p.default,t}return(0,i.default)(o,[{key:"make",value:function(){this.nodes.wrapper=u.default.make("div",this.CSS.wrapper),this.nodes.toolSettings=u.default.make("div",this.CSS.toolSettings),this.nodes.defaultSettings=u.default.make("div",this.CSS.defaultSettings),u.default.append(this.nodes.wrapper,[this.nodes.toolSettings,this.nodes.defaultSettings]),this.enableFlipper()}},{key:"destroy",value:function(){this.flipper.deactivate(),this.flipper=null,this.removeAllNodes()}},{key:"open",value:function(){this.nodes.wrapper.classList.add(this.CSS.wrapperOpened),this.selection.save(),this.Editor.BlockManager.currentBlock.selected=!0,this.Editor.BlockSelection.clearCache(),this.addToolSettings(),this.addDefaultSettings(),this.Editor.Events.emit(this.events.opened),this.flipper.activate(this.blockTunesButtons)}},{key:"close",value:function(){this.nodes.wrapper.classList.remove(this.CSS.wrapperOpened),p.default.isAtEditor||this.selection.restore(),this.selection.clearSaved(),this.nodes.toolSettings.innerHTML="",this.nodes.defaultSettings.innerHTML="",this.Editor.Events.emit(this.events.closed),this.buttons=[],this.flipper.deactivate()}},{key:"addToolSettings",value:function(){d.isFunction(this.Editor.BlockManager.currentBlock.tool.renderSettings)&&u.default.append(this.nodes.toolSettings,this.Editor.BlockManager.currentBlock.tool.renderSettings())}},{key:"addDefaultSettings",value:function(){u.default.append(this.nodes.defaultSettings,this.Editor.BlockManager.currentBlock.renderTunes())}},{key:"enableFlipper",value:function(){var t=this;this.flipper=new f.default({focusedItemClass:this.CSS.focusedButton,activateCallback:function(e){e&&u.default.canSetCaret(e)?t.close():d.delay((function(){t.Editor.Caret.setToBlock(t.Editor.BlockManager.currentBlock)}),50)()}})}},{key:"events",get:function(){return{opened:"block-settings-opened",closed:"block-settings-closed"}}},{key:"CSS",get:function(){return{wrapper:"ce-settings",wrapperOpened:"ce-settings--opened",toolSettings:"ce-settings__plugin-zone",defaultSettings:"ce-settings__default-zone",button:"ce-settings__button",focusedButton:"ce-settings__button--focused",focusedButtonAnimated:"ce-settings__button--focused-animated"}}},{key:"opened",get:function(){return this.nodes.wrapper.classList.contains(this.CSS.wrapperOpened)}},{key:"blockTunesButtons",get:function(){var t=this,e=this.Editor.StylesAPI;if(0!==this.buttons.length)return this.buttons;var n=this.nodes.toolSettings.querySelectorAll(".".concat(e.classes.settingsButton,", ").concat(u.default.allInputsSelector)),o=this.nodes.defaultSettings.querySelectorAll(".".concat(this.CSS.button));return n.forEach((function(e){t.buttons.push(e)})),o.forEach((function(e){t.buttons.push(e)})),this.buttons}}]),o}(l.default);o.default=g,g.displayName="BlockSettings",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(39),n(21),n(22),n(66),n(2),n(3),n(5),n(6),n(4),n(7),n(15),n(8),n(60),n(59),n(82)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d,p,h,v,y,g,b){"use strict";var m=n(13),k=n(1);function x(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=k(r),i=k(i),a=k(a),s=k(s),c=k(c),l=k(l),u=k(u),f=k(f),d=k(d),p=k(p),h=k(h),v=m(v),y=k(y),g=k(g);var S=function(t){(0,u.default)(p,t);var e,n,o=(e=p,function(){var t,n=(0,d.default)(e);if(x()){var o=(0,d.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,f.default)(this,t)});function p(){var t;return(0,c.default)(this,p),(t=o.apply(this,arguments)).opened=!1,t.tools={},t.flipper=null,t.togglingCallback=null,t}return(0,l.default)(p,[{key:"make",value:function(){this.nodes.wrapper=h.default.make("div",[p.CSS.conversionToolbarWrapper].concat((0,s.default)(this.isRtl?[this.Editor.UI.CSS.editorRtlFix]:[]))),this.nodes.tools=h.default.make("div",p.CSS.conversionToolbarTools);var t=h.default.make("div",p.CSS.conversionToolbarLabel,{textContent:g.default.ui(b.I18nInternalNS.ui.inlineToolbar.converter,"Convert to")});return this.addTools(),this.enableFlipper(),h.default.append(this.nodes.wrapper,t),h.default.append(this.nodes.wrapper,this.nodes.tools),this.nodes.wrapper}},{key:"destroy",value:function(){this.flipper.deactivate(),this.flipper=null,this.removeAllNodes()}},{key:"toggle",value:function(t){this.opened?this.close():this.open(),v.isFunction(t)&&(this.togglingCallback=t)}},{key:"open",value:function(){var t=this;this.filterTools(),this.opened=!0,this.nodes.wrapper.classList.add(p.CSS.conversionToolbarShowed),setTimeout((function(){t.flipper.activate(Object.values(t.tools).filter((function(t){return!t.classList.contains(p.CSS.conversionToolHidden)}))),t.flipper.focusFirst(),v.isFunction(t.togglingCallback)&&t.togglingCallback(!0)}),50)}},{key:"close",value:function(){this.opened=!1,this.flipper.deactivate(),this.nodes.wrapper.classList.remove(p.CSS.conversionToolbarShowed),v.isFunction(this.togglingCallback)&&this.togglingCallback(!1)}},{key:"hasTools",value:function(){var t=Object.keys(this.tools);return!(1===t.length&&t.shift()===this.config.defaultBlock)}},{key:"replaceWithBlock",value:(n=(0,a.default)(i.default.mark((function t(e){var n,o,r,a,s,c,l,u,f,d,p,h=this;return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return n=this.Editor.BlockManager.currentBlock.class,o=this.Editor.BlockManager.currentBlock.name,t.next=4,this.Editor.BlockManager.currentBlock.save();case 4:if(r=t.sent,a=this.Editor.Tools.INTERNAL_SETTINGS,s=r.data,o===e&&(e=this.config.defaultBlock),c=this.Editor.Tools.toolsClasses[e],l="",u=n[a.CONVERSION_CONFIG].export,!v.isFunction(u)){t.next=15;break}l=u(s),t.next=21;break;case 15:if("string"!=typeof u){t.next=19;break}l=s[u],t.next=21;break;case 19:return v.log("Conversion «export» property must be a string or function. String means key of saved data object to export. Function should export processed string to export."),t.abrupt("return");case 21:if(f=this.Editor.Sanitizer.clean(l,c.sanitize),d={},p=c[a.CONVERSION_CONFIG].import,!v.isFunction(p)){t.next=28;break}d=p(f),t.next=34;break;case 28:if("string"!=typeof p){t.next=32;break}d[p]=f,t.next=34;break;case 32:return v.log("Conversion «import» property must be a string or function. String means key of tool data to import. Function accepts a imported string and return composed tool data."),t.abrupt("return");case 34:this.Editor.BlockManager.replace({tool:e,data:d}),this.Editor.BlockSelection.clearSelection(),this.close(),this.Editor.InlineToolbar.close(),v.delay((function(){h.Editor.Caret.setToBlock(h.Editor.BlockManager.currentBlock)}),10)();case 39:case"end":return t.stop()}}),t,this)}))),function(t){return n.apply(this,arguments)})},{key:"addTools",value:function(){var t=this.Editor.Tools.blockTools;for(var e in t)if(Object.prototype.hasOwnProperty.call(t,e)){var n=this.Editor.Tools.INTERNAL_SETTINGS,o=t[e],r=o[n.TOOLBOX],i=o[n.CONVERSION_CONFIG],a=this.Editor.Tools.USER_SETTINGS,s=this.Editor.Tools.getToolSettings(e)[a.TOOLBOX],c=null!=s?s:r;!v.isEmpty(c)&&c.icon&&i&&i.import&&this.addTool(e,c.icon,c.title)}}},{key:"addTool",value:function(t,e,n){var o=this,r=h.default.make("div",[p.CSS.conversionTool]),s=h.default.make("div",[p.CSS.conversionToolIcon]);r.dataset.tool=t,s.innerHTML=e,h.default.append(r,s),h.default.append(r,h.default.text(g.default.t(b.I18nInternalNS.toolNames,n||v.capitalize(t)))),h.default.append(this.nodes.tools,r),this.tools[t]=r,this.Editor.Listeners.on(r,"click",(0,a.default)(i.default.mark((function e(){return i.default.wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,o.replaceWithBlock(t);case 2:case"end":return e.stop()}}),e)}))))}},{key:"filterTools",value:function(){var t=this.Editor.BlockManager.currentBlock;Object.entries(this.tools).forEach((function(e){var n=(0,r.default)(e,2),o=n[0],i=n[1];i.hidden=!1,i.classList.toggle(p.CSS.conversionToolHidden,o===t.name)}))}},{key:"enableFlipper",value:function(){this.flipper=new y.default({focusedItemClass:p.CSS.conversionToolFocused})}}],[{key:"CSS",get:function(){return{conversionToolbarWrapper:"ce-conversion-toolbar",conversionToolbarShowed:"ce-conversion-toolbar--showed",conversionToolbarTools:"ce-conversion-toolbar__tools",conversionToolbarLabel:"ce-conversion-toolbar__label",conversionTool:"ce-conversion-tool",conversionToolHidden:"ce-conversion-tool--hidden",conversionToolIcon:"ce-conversion-tool__icon",conversionToolFocused:"ce-conversion-tool--focused",conversionToolActive:"ce-conversion-tool--active"}}}]),p}(p.default);o.default=S,S.displayName="ConversionToolbar",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(66),n(39),n(2),n(3),n(5),n(6),n(4),n(7),n(15),n(25),n(8),n(60),n(59),n(82)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d,p,h,v,y,g){"use strict";var b=n(13),m=n(1);function k(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=m(r),i=m(i),a=m(a),s=m(s),c=m(c),l=m(l),u=m(u),f=m(f),d=m(d),p=m(p),h=b(h),v=m(v),y=m(y);var x=function(t){(0,c.default)(o,t);var e,n=(e=o,function(){var t,n=(0,u.default)(e);if(k()){var o=(0,u.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,l.default)(this,t)});function o(){var t;return(0,a.default)(this,o),(t=n.apply(this,arguments)).CSS={inlineToolbar:"ce-inline-toolbar",inlineToolbarShowed:"ce-inline-toolbar--showed",inlineToolbarLeftOriented:"ce-inline-toolbar--left-oriented",inlineToolbarRightOriented:"ce-inline-toolbar--right-oriented",inlineToolbarShortcut:"ce-inline-toolbar__shortcut",buttonsWrapper:"ce-inline-toolbar__buttons",actionsWrapper:"ce-inline-toolbar__actions",inlineToolButton:"ce-inline-tool",inputField:"cdx-input",focusedButton:"ce-inline-tool--focused",conversionToggler:"ce-inline-toolbar__dropdown",conversionTogglerHidden:"ce-inline-toolbar__dropdown--hidden",conversionTogglerContent:"ce-inline-toolbar__dropdown-content",togglerAndButtonsWrapper:"ce-inline-toolbar__toggler-and-button-wrapper"},t.opened=!1,t.toolbarVerticalMargin=5,t.buttonsList=null,t.width=0,t.flipper=null,t}return(0,s.default)(o,[{key:"toggleReadOnly",value:function(t){t?this.destroy():this.make()}},{key:"tryToShow",value:function(){var t=arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.allowedToShow()?(this.move(),this.open(),this.Editor.Toolbar.close()):t&&this.close()}},{key:"move",value:function(){var t=p.default.rect,e=this.Editor.UI.nodes.wrapper.getBoundingClientRect(),n={x:t.x-e.left,y:t.y+t.height-e.top+this.toolbarVerticalMargin};t.width&&(n.x+=Math.floor(t.width/2));var o=n.x-this.width/2,r=n.x+this.width/2;this.nodes.wrapper.classList.toggle(this.CSS.inlineToolbarLeftOriented,o<this.Editor.UI.contentRect.left),this.nodes.wrapper.classList.toggle(this.CSS.inlineToolbarRightOriented,r>this.Editor.UI.contentRect.right),this.nodes.wrapper.style.left=Math.floor(n.x)+"px",this.nodes.wrapper.style.top=Math.floor(n.y)+"px"}},{key:"close",value:function(){this.opened&&(this.Editor.ReadOnly.isEnabled||(this.nodes.wrapper.classList.remove(this.CSS.inlineToolbarShowed),this.toolsInstances.forEach((function(t){h.isFunction(t.clear)&&t.clear()})),this.opened=!1,this.flipper.deactivate(),this.Editor.ConversionToolbar.close()))}},{key:"open",value:function(){if(!this.opened){this.addToolsFiltered(),this.nodes.wrapper.classList.add(this.CSS.inlineToolbarShowed),this.buttonsList=this.nodes.buttons.querySelectorAll(".".concat(this.CSS.inlineToolButton)),this.opened=!0,this.Editor.ConversionToolbar.hasTools()?this.setConversionTogglerContent():this.nodes.conversionToggler.hidden=!0;var t=Array.from(this.buttonsList);t.unshift(this.nodes.conversionToggler),t=t.filter((function(t){return!t.hidden})),this.flipper.activate(t)}}},{key:"containsNode",value:function(t){return this.nodes.wrapper.contains(t)}},{key:"destroy",value:function(){this.flipper.deactivate(),this.flipper=null,this.Editor.ConversionToolbar.destroy()}},{key:"getInlineToolbarSettings",value:function(t){var e=this,n=this.Editor.Tools.getToolSettings(t)[this.Editor.Tools.USER_SETTINGS.ENABLED_INLINE_TOOLS];if(!0!==n&&!Array.isArray(n))return!1;if(Array.isArray(n))return n;var o=this.config.inlineToolbar;return Array.isArray(o)?o:!0===o&&Object.entries(this.Editor.Tools.available).filter((function(t){var n=(0,i.default)(t,2);return n[0],n[1][e.Editor.Tools.INTERNAL_SETTINGS.IS_INLINE]})).map((function(t){var e=(0,i.default)(t,2),n=e[0];return e[1],n}))}},{key:"make",value:function(){var t=this;this.nodes.wrapper=d.default.make("div",[this.CSS.inlineToolbar].concat((0,r.default)(this.isRtl?[this.Editor.UI.CSS.editorRtlFix]:[]))),this.nodes.togglerAndButtonsWrapper=d.default.make("div",this.CSS.togglerAndButtonsWrapper),this.nodes.buttons=d.default.make("div",this.CSS.buttonsWrapper),this.nodes.actions=d.default.make("div",this.CSS.actionsWrapper),this.Editor.Listeners.on(this.nodes.wrapper,"mousedown",(function(e){e.target.closest(".".concat(t.CSS.actionsWrapper))||e.preventDefault()})),d.default.append(this.nodes.wrapper,[this.nodes.togglerAndButtonsWrapper,this.nodes.actions]),d.default.append(this.Editor.UI.nodes.wrapper,this.nodes.wrapper),this.addConversionToggler(),d.default.append(this.nodes.togglerAndButtonsWrapper,this.nodes.buttons),this.prepareConversionToolbar(),this.recalculateWidth(),this.enableFlipper()}},{key:"allowedToShow",value:function(){var t=p.default.get(),e=p.default.text;if(!t||!t.anchorNode)return!1;if(t.isCollapsed||e.length<1)return!1;var n=d.default.isElement(t.anchorNode)?t.anchorNode:t.anchorNode.parentElement;if(t&&["IMG","INPUT"].includes(n.tagName))return!1;if(null===n.closest('[contenteditable="true"]'))return!1;var o=this.Editor.BlockManager.getBlock(t.anchorNode);return!!o&&!1!==this.getInlineToolbarSettings(o.name)}},{key:"recalculateWidth",value:function(){this.width=this.nodes.wrapper.offsetWidth}},{key:"addConversionToggler",value:function(){var t=this;this.nodes.conversionToggler=d.default.make("div",this.CSS.conversionToggler),this.nodes.conversionTogglerContent=d.default.make("div",this.CSS.conversionTogglerContent);var e=d.default.svg("toggler-down",13,13);this.nodes.conversionToggler.appendChild(this.nodes.conversionTogglerContent),this.nodes.conversionToggler.appendChild(e),this.nodes.togglerAndButtonsWrapper.appendChild(this.nodes.conversionToggler),this.Editor.Listeners.on(this.nodes.conversionToggler,"click",(function(){t.Editor.ConversionToolbar.toggle((function(e){!e&&t.opened?t.flipper.activate():t.opened&&t.flipper.deactivate()}))})),this.Editor.Tooltip.onHover(this.nodes.conversionToggler,y.default.ui(g.I18nInternalNS.ui.inlineToolbar.converter,"Convert to"),{placement:"top",hidingDelay:100})}},{key:"setConversionTogglerContent",value:function(){var t=this.Editor,e=t.BlockManager,n=t.Tools,o=e.currentBlock.name,r=n.available[o][n.INTERNAL_SETTINGS.CONVERSION_CONFIG]||{},i=r&&r.export;this.nodes.conversionToggler.hidden=!i,this.nodes.conversionToggler.classList.toggle(this.CSS.conversionTogglerHidden,!i);var a=n.getToolSettings(o),s=n.available[o][n.INTERNAL_SETTINGS.TOOLBOX]||{},c=a.toolbox||{};this.nodes.conversionTogglerContent.innerHTML=c.icon||s.icon||c.title||s.title||h.capitalize(o)}},{key:"prepareConversionToolbar",value:function(){var t=this.Editor.ConversionToolbar.make();d.default.append(this.nodes.wrapper,t)}},{key:"addToolsFiltered",value:function(){var t=this,e=p.default.get(),n=this.Editor.BlockManager.getBlock(e.anchorNode);this.nodes.buttons.innerHTML="",this.nodes.actions.innerHTML="",this.toolsInstances=new Map,this.getInlineToolbarSettings(n.name).forEach((function(e){var n=t.Editor.Tools.getToolSettings(e),o=t.Editor.Tools.constructInline(t.Editor.Tools.inline[e],e,n);t.addTool(e,o),o.checkState(p.default.get())})),this.recalculateWidth()}},{key:"addTool",value:function(t,e){var n=this,o=this.Editor,r=o.Listeners,a=o.Tools,s=o.Tooltip,c=e.render();if(c){if(c.dataset.tool=t,this.nodes.buttons.appendChild(c),this.toolsInstances.set(t,e),h.isFunction(e.renderActions)){var l=e.renderActions();this.nodes.actions.appendChild(l)}r.on(c,"click",(function(t){n.toolClicked(e),t.preventDefault()}));var u=a.getToolSettings(t),f=null;Object.entries(a.internalTools).filter((function(t){var e=(0,i.default)(t,2)[1];return h.isFunction(e)?e[a.INTERNAL_SETTINGS.IS_INLINE]:e.class[a.INTERNAL_SETTINGS.IS_INLINE]})).map((function(t){return(0,i.default)(t,1)[0]})).includes(t)?f=this.inlineTools[t][a.INTERNAL_SETTINGS.SHORTCUT]:u&&u[a.USER_SETTINGS.SHORTCUT]?f=u[a.USER_SETTINGS.SHORTCUT]:e.shortcut&&(f=e.shortcut),f&&this.enableShortcuts(e,f);var p=d.default.make("div"),v=y.default.t(g.I18nInternalNS.toolNames,a.toolsClasses[t][a.INTERNAL_SETTINGS.TITLE]||h.capitalize(t));p.appendChild(d.default.text(v)),f&&p.appendChild(d.default.make("div",this.CSS.inlineToolbarShortcut,{textContent:h.beautifyShortcut(f)})),s.onHover(c,p,{placement:"top",hidingDelay:100})}else h.log("Render method must return an instance of Node","warn",t)}},{key:"enableShortcuts",value:function(t,e){var n=this;this.Editor.Shortcuts.add({name:e,handler:function(e){var o=n.Editor.BlockManager.currentBlock;if(o){var r=n.Editor.Tools.getToolSettings(o.name);r&&r[n.Editor.Tools.USER_SETTINGS.ENABLED_INLINE_TOOLS]&&(e.preventDefault(),n.toolClicked(t))}}})}},{key:"toolClicked",value:function(t){var e=p.default.range;t.surround(e),this.checkToolsState()}},{key:"checkToolsState",value:function(){this.toolsInstances.forEach((function(t){t.checkState(p.default.get())}))}},{key:"enableFlipper",value:function(){this.flipper=new v.default({focusedItemClass:this.CSS.focusedButton,allowArrows:!1})}},{key:"inlineTools",get:function(){var t={};for(var e in this.Editor.Tools.inline)if(Object.prototype.hasOwnProperty.call(this.Editor.Tools.inline,e)){var n=this.Editor.Tools.getToolSettings(e);t[e]=this.Editor.Tools.constructInline(this.Editor.Tools.inline[e],e,n)}return t}}]),o}(f.default);o.default=x,x.displayName="InlineToolbar",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7),n(15),n(8),n(60),n(61),n(59),n(82)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d,p,h,v){"use strict";var y=n(13),g=n(1);function b(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=g(r),i=g(i),a=g(a),s=g(s),c=g(c),l=g(l),u=g(u),f=y(f),d=g(d),h=g(h);var m=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(b()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(){var t;return(0,r.default)(this,o),(t=n.apply(this,arguments)).nodes={toolbox:null,buttons:[]},t.opened=!1,t.displayedToolsCount=0,t.flipper=null,t}return(0,i.default)(o,[{key:"make",value:function(){this.nodes.toolbox=u.default.make("div",this.CSS.toolbox),this.addTools(),this.enableFlipper()}},{key:"destroy",value:function(){this.flipper.deactivate(),this.flipper=null,this.removeAllNodes(),this.removeAllShortcuts()}},{key:"toolButtonActivate",value:function(t,e){var n=this.Editor.Tools.toolsClasses[e];this.insertNewBlock(n,e)}},{key:"open",value:function(){this.isEmpty||(this.Editor.UI.nodes.wrapper.classList.add(this.CSS.openedToolbarHolderModifier),this.nodes.toolbox.classList.add(this.CSS.toolboxOpened),this.opened=!0,this.flipper.activate())}},{key:"close",value:function(){this.nodes.toolbox.classList.remove(this.CSS.toolboxOpened),this.Editor.UI.nodes.wrapper.classList.remove(this.CSS.openedToolbarHolderModifier),this.opened=!1,this.flipper.deactivate()}},{key:"toggle",value:function(){this.opened?this.close():this.open()}},{key:"addTools",value:function(){var t=this.Editor.Tools.available;for(var e in t)Object.prototype.hasOwnProperty.call(t,e)&&this.addTool(e,t[e])}},{key:"addTool",value:function(t,e){var n=this,o=this.Editor.Tools.INTERNAL_SETTINGS,r=this.Editor.Tools.USER_SETTINGS,i=e[o.TOOLBOX];if(!f.isEmpty(i))if(!i||i.icon){var a=this.Editor.Tools.getToolSettings(t)[r.TOOLBOX];if(!1!==(null!=a?a:i)){var s=u.default.make("li",[this.CSS.toolboxButton]);s.dataset.tool=t,s.innerHTML=a&&a.icon||i.icon,u.default.append(this.nodes.toolbox,s),this.nodes.toolbox.appendChild(s),this.nodes.buttons.push(s),this.Editor.Listeners.on(s,"click",(function(e){n.toolButtonActivate(e,t)}));var c=this.drawTooltip(t);this.Editor.Tooltip.onHover(s,c,{placement:"bottom",hidingDelay:200});var l=this.getToolShortcut(t,e);l&&this.enableShortcut(e,t,l),this.displayedToolsCount++}}else f.log("Toolbar icon is missed. Tool %o skipped","warn",t)}},{key:"getToolShortcut",value:function(t,e){var n=this.Editor.Tools.getToolSettings(t),o=e[this.Editor.Tools.INTERNAL_SETTINGS.SHORTCUT];return(n?n[this.Editor.Tools.USER_SETTINGS.SHORTCUT]:null)||o}},{key:"drawTooltip",value:function(t){var e=this.Editor.Tools.available[t],n=this.Editor.Tools.getToolSettings(t),o=this.Editor.Tools.available[t][this.Editor.Tools.INTERNAL_SETTINGS.TOOLBOX]||{},r=n.toolbox||{},i=h.default.t(v.I18nInternalNS.toolNames,r.title||o.title||t),a=this.getToolShortcut(t,e),s=u.default.make("div",this.CSS.buttonTooltip),c=document.createTextNode(f.capitalize(i));return s.appendChild(c),a&&(a=f.beautifyShortcut(a),s.appendChild(u.default.make("div",this.CSS.buttonShortcut,{textContent:a}))),s}},{key:"enableShortcut",value:function(t,e,n){var o=this;this.Editor.Shortcuts.add({name:n,handler:function(n){n.preventDefault(),o.insertNewBlock(t,e)}})}},{key:"removeAllShortcuts",value:function(){var t=this.Editor.Tools.available;for(var e in t)if(Object.prototype.hasOwnProperty.call(t,e)){var n=this.getToolShortcut(e,t[e]);n&&this.Editor.Shortcuts.remove(n)}}},{key:"enableFlipper",value:function(){var t=Array.from(this.nodes.toolbox.childNodes);this.flipper=new d.default({items:t,focusedItemClass:this.CSS.toolboxButtonActive})}},{key:"insertNewBlock",value:function(t,e){var n=this.Editor,o=n.BlockManager,r=n.Caret,i=o.currentBlock,a=o.insert({tool:e,replace:i.isEmpty});a.call(p.BlockToolAPI.APPEND_CALLBACK),this.Editor.Caret.setToBlock(a),0===a.inputs.length&&(a===o.lastBlock?(o.insertAtEnd(),r.setToBlock(o.lastBlock)):r.setToBlock(o.nextBlock)),this.Editor.Toolbar.close()}},{key:"CSS",get:function(){return{toolbox:"ce-toolbox",toolboxButton:"ce-toolbox__button",toolboxButtonActive:"ce-toolbox__button--active",toolboxOpened:"ce-toolbox--opened",openedToolbarHolderModifier:"codex-editor--toolbox-opened",buttonTooltip:"ce-toolbox-button-tooltip",buttonShortcut:"ce-toolbox-button-tooltip__shortcut"}}},{key:"isEmpty",get:function(){return 0===this.displayedToolsCount}}]),o}(l.default);o.default=m,m.displayName="Toolbox",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(5),n(6),n(4),n(7),n(387)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u){"use strict";var f=n(1);function d(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=f(r),i=f(i),a=f(a),s=f(s),c=f(c),l=f(l),u=f(u);var p=function(t){(0,a.default)(o,t);var e,n=(e=o,function(){var t,n=(0,c.default)(e);if(d()){var o=(0,c.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,s.default)(this,t)});function o(t){var e,i=t.config;return(0,r.default)(this,o),(e=n.call(this,{config:i})).lib=new u.default,e}return(0,i.default)(o,[{key:"show",value:function(t,e,n){this.lib.show(t,e,n)}},{key:"hide",value:function(){this.lib.hide()}},{key:"onHover",value:function(t,e,n){this.lib.onHover(t,e,n)}}]),o}(l.default);o.default=p,p.displayName="Tooltip",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(39),n(66),n(21),n(22),n(2),n(3),n(5),n(6),n(4),n(388),n(7),n(15),n(8),n(25),n(61),n(60)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d,p,h,v,y,g,b,m){"use strict";var k=n(13),x=n(1);function S(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=x(r),i=x(i),a=x(a),s=x(s),c=x(c),l=x(l),u=x(u),f=x(f),d=x(d),p=x(p),h=x(h),v=x(v),y=k(y),g=x(g),b=x(b),m=x(m);var w=function(t){(0,u.default)(k,t);var e,o,h=(e=k,function(){var t,n=(0,d.default)(e);if(S()){var o=(0,d.default)(this).constructor;t=Reflect.construct(n,arguments,o)}else t=n.apply(this,arguments);return(0,f.default)(this,t)});function k(){var t;return(0,c.default)(this,k),(t=h.apply(this,arguments)).isMobile=!1,t.contentRectCache=void 0,t.resizeDebouncer=y.debounce((function(){t.windowResize()}),200),t}return(0,l.default)(k,[{key:"addLoader",value:function(){this.nodes.loader=v.default.make("div",this.CSS.editorLoader),this.nodes.wrapper.prepend(this.nodes.loader),this.nodes.redactor.classList.add(this.CSS.editorZoneHidden)}},{key:"removeLoader",value:function(){this.nodes.loader.remove(),this.nodes.redactor.classList.remove(this.CSS.editorZoneHidden)}},{key:"prepare",value:(o=(0,s.default)(a.default.mark((function t(){return a.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:this.checkIsMobile(),this.make(),this.addLoader(),this.appendSVGSprite(),this.loadStyles();case 5:case"end":return t.stop()}}),t,this)}))),function(){return o.apply(this,arguments)})},{key:"toggleReadOnly",value:function(t){t?this.disableModuleBindings():this.enableModuleBindings()}},{key:"checkEmptiness",value:function(){var t=this.Editor.BlockManager;this.nodes.wrapper.classList.toggle(this.CSS.editorEmpty,t.isEditorEmpty)}},{key:"destroy",value:function(){this.nodes.holder.innerHTML=""}},{key:"closeAllToolbars",value:function(){var t=this.Editor,e=t.Toolbox,n=t.BlockSettings,o=t.InlineToolbar,r=t.ConversionToolbar;n.close(),o.close(),r.close(),e.close()}},{key:"checkIsMobile",value:function(){this.isMobile=window.innerWidth<650}},{key:"make",value:function(){this.nodes.holder=v.default.getHolder(this.config.holder),this.nodes.wrapper=v.default.make("div",[this.CSS.editorWrapper].concat((0,i.default)(this.isRtl?[this.CSS.editorRtlFix]:[]))),this.nodes.redactor=v.default.make("div",this.CSS.editorZone),this.nodes.holder.offsetWidth<this.contentRect.width&&this.nodes.wrapper.classList.add(this.CSS.editorWrapperNarrow),this.nodes.redactor.style.paddingBottom=this.config.minHeight+"px",this.nodes.wrapper.appendChild(this.nodes.redactor),this.nodes.holder.appendChild(this.nodes.wrapper)}},{key:"loadStyles",value:function(){var t=n(389);if(!v.default.get("editor-js-styles")){var e=v.default.make("style",null,{id:"editor-js-styles",textContent:t.toString()});v.default.prepend(document.head,e)}}},{key:"enableModuleBindings",value:function(){var t=this;this.readOnlyMutableListeners.on(this.nodes.redactor,"click",(function(e){t.redactorClicked(e)}),!1),this.readOnlyMutableListeners.on(this.nodes.redactor,"mousedown",(function(e){t.documentTouched(e)}),!0),this.readOnlyMutableListeners.on(this.nodes.redactor,"touchstart",(function(e){t.documentTouched(e)}),!0),this.readOnlyMutableListeners.on(document,"keydown",(function(e){t.documentKeydown(e)}),!0),this.readOnlyMutableListeners.on(document,"click",(function(e){t.documentClicked(e)}),!0),this.readOnlyMutableListeners.on(document,"selectionchange",(function(e){t.selectionChanged(e)}),!0),this.readOnlyMutableListeners.on(window,"resize",(function(){t.resizeDebouncer()}),{passive:!0})}},{key:"disableModuleBindings",value:function(){this.readOnlyMutableListeners.clearAll()}},{key:"windowResize",value:function(){this.contentRectCache=null,this.checkIsMobile()}},{key:"documentKeydown",value:function(t){switch(t.keyCode){case y.keyCodes.ENTER:this.enterPressed(t);break;case y.keyCodes.BACKSPACE:this.backspacePressed(t);break;case y.keyCodes.ESC:this.escapePressed(t);break;default:this.defaultBehaviour(t)}}},{key:"defaultBehaviour",value:function(t){var e=this.Editor.BlockManager.currentBlock,n=t.target.closest(".".concat(this.CSS.editorWrapper)),o=t.altKey||t.ctrlKey||t.metaKey||t.shiftKey;void 0===e||null!==n?n||e&&o||(this.Editor.BlockManager.dropPointer(),this.Editor.Toolbar.close()):this.Editor.BlockEvents.keydown(t)}},{key:"backspacePressed",value:function(t){var e=this.Editor,n=e.BlockManager,o=e.BlockSelection,r=e.Caret;if(o.anyBlockSelected&&!g.default.isSelectionExists){var i=n.removeSelectedBlocks();r.setToBlock(n.insertDefaultBlockAtIndex(i,!0),r.positions.START),o.clearSelection(t),t.preventDefault(),t.stopPropagation(),t.stopImmediatePropagation()}}},{key:"escapePressed",value:function(t){this.Editor.BlockSelection.clearSelection(t),this.Editor.Toolbox.opened?this.Editor.Toolbox.close():this.Editor.BlockSettings.opened?this.Editor.BlockSettings.close():this.Editor.ConversionToolbar.opened?this.Editor.ConversionToolbar.close():this.Editor.InlineToolbar.opened?this.Editor.InlineToolbar.close():this.Editor.Toolbar.close()}},{key:"enterPressed",value:function(t){var e=this.Editor,n=e.BlockManager,o=e.BlockSelection,r=(e.Caret,n.currentBlockIndex>=0);if(o.anyBlockSelected&&!g.default.isSelectionExists)return o.clearSelection(t),t.preventDefault(),t.stopImmediatePropagation(),void t.stopPropagation();if(!this.someToolbarOpened&&r&&"BODY"===t.target.tagName){var i=this.Editor.BlockManager.insert();this.Editor.Caret.setToBlock(i),this.Editor.BlockManager.highlightCurrentNode(),this.Editor.Toolbar.move(),this.Editor.Toolbar.plusButton.show()}this.Editor.BlockSelection.clearSelection(t)}},{key:"documentClicked",value:function(t){if(t.isTrusted){var e=t.target;this.nodes.holder.contains(e)||g.default.isAtEditor||(this.Editor.BlockManager.dropPointer(),this.Editor.InlineToolbar.close(),this.Editor.Toolbar.close(),this.Editor.ConversionToolbar.close()),this.Editor.CrossBlockSelection.isCrossBlockSelectionStarted||this.Editor.BlockSelection.clearSelection(t)}}},{key:"documentTouched",value:function(t){var e=t.target;if(e===this.nodes.redactor){var n=t instanceof MouseEvent?t.clientX:t.touches[0].clientX,o=t instanceof MouseEvent?t.clientY:t.touches[0].clientY;e=document.elementFromPoint(n,o)}try{this.Editor.BlockManager.setCurrentBlockByChildNode(e),this.Editor.BlockManager.highlightCurrentNode()}catch(t){this.Editor.RectangleSelection.isRectActivated()||this.Editor.Caret.setToTheLastBlock()}this.Editor.Toolbar.open(),this.Editor.Toolbar.plusButton.hide()}},{key:"redactorClicked",value:function(t){if(g.default.isCollapsed){var e=function(){t.stopImmediatePropagation(),t.stopPropagation()},n=t.target,o=t.metaKey||t.ctrlKey;if(v.default.isAnchor(n)&&o){e();var r=n.getAttribute("href"),i=y.getValidUrl(r);y.openTab(i)}else this.Editor.BlockManager.currentBlock||(e(),this.Editor.BlockManager.insert()),this.Editor.Tools.isDefault(this.Editor.BlockManager.currentBlock.tool)&&(e(),this.Editor.BlockManager.currentBlock.isEmpty&&this.Editor.Toolbar.plusButton.show())}}},{key:"selectionChanged",value:function(t){var e=this.Editor,n=e.CrossBlockSelection,o=e.BlockSelection,r=g.default.anchorElement;n.isCrossBlockSelectionStarted&&o.anyBlockSelected&&g.default.get().removeAllRanges(),r&&r.closest(".".concat(b.default.CSS.content))?this.Editor.InlineToolbar.tryToShow(!0):this.Editor.InlineToolbar.containsNode(r)||this.Editor.InlineToolbar.close()}},{key:"appendSVGSprite",value:function(){var t=v.default.make("div");t.hidden=!0,t.style.display="none",t.innerHTML=p.default,v.default.append(this.nodes.wrapper,t)}},{key:"CSS",get:function(){return{editorWrapper:"codex-editor",editorWrapperNarrow:"codex-editor--narrow",editorZone:"codex-editor__redactor",editorZoneHidden:"codex-editor__redactor--hidden",editorLoader:"codex-editor__loader",editorEmpty:"codex-editor--empty",editorRtlFix:"codex-editor--rtl"}}},{key:"contentRect",get:function(){if(this.contentRectCache)return this.contentRectCache;var t=this.nodes.wrapper.querySelector(".".concat(b.default.CSS.content));return t?(this.contentRectCache=t.getBoundingClientRect(),this.contentRectCache):{width:650,left:0,right:0}}},{key:"someToolbarOpened",get:function(){var t=this.Editor,e=t.Toolbox,n=t.BlockSettings,o=t.InlineToolbar,r=t.ConversionToolbar;return n.opened||o.opened||r.opened||e.opened}},{key:"someFlipperButtonFocused",get:function(){return Object.entries(this.Editor).filter((function(t){var e=(0,r.default)(t,2);return e[0],e[1].flipper instanceof m.default})).some((function(t){var e=(0,r.default)(t,2);return e[0],e[1].flipper.currentItem}))}}]),k}(h.default);o.default=w,w.displayName="UI",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){n(184),t.exports=n(356)},function(t,e,n){n(185)},function(t,e,n){"use strict";n(186),n(329),n(331),n(334),n(336),n(338),n(340),n(342),n(344),n(346),n(348),n(350),n(352),n(140)},function(t,e,n){n(187),n(190),n(191),n(192),n(193),n(194),n(195),n(196),n(197),n(198),n(199),n(200),n(201),n(202),n(203),n(204),n(205),n(206),n(207),n(208),n(209),n(210),n(211),n(212),n(213),n(214),n(215),n(216),n(217),n(218),n(219),n(220),n(221),n(222),n(223),n(224),n(225),n(226),n(227),n(228),n(229),n(230),n(231),n(233),n(234),n(235),n(236),n(237),n(238),n(239),n(240),n(241),n(242),n(243),n(244),n(245),n(246),n(247),n(248),n(249),n(250),n(251),n(252),n(253),n(254),n(255),n(256),n(257),n(258),n(259),n(260),n(261),n(262),n(263),n(264),n(265),n(266),n(268),n(269),n(271),n(272),n(273),n(274),n(275),n(276),n(277),n(279),n(280),n(281),n(282),n(283),n(284),n(285),n(286),n(287),n(288),n(289),n(290),n(291),n(103),n(292),n(129),n(293),n(130),n(294),n(295),n(296),n(297),n(131),n(300),n(301),n(302),n(303),n(304),n(305),n(306),n(307),n(308),n(309),n(310),n(311),n(312),n(313),n(314),n(315),n(316),n(317),n(318),n(319),n(320),n(321),n(322),n(323),n(324),n(325),n(326),n(327),n(328),t.exports=n(17)},function(t,e,n){"use strict";var o=n(9),r=n(26),i=n(18),a=n(0),s=n(23),c=n(41).KEY,l=n(10),u=n(68),f=n(53),d=n(43),p=n(14),h=n(84),v=n(110),y=n(189),g=n(71),b=n(11),m=n(12),k=n(20),x=n(28),S=n(40),w=n(42),E=n(47),T=n(113),C=n(33),B=n(70),_=n(19),O=n(45),I=C.f,N=_.f,R=T.f,M=o.Symbol,L=o.JSON,A=L&&L.stringify,P=p("_hidden"),D=p("toPrimitive"),j={}.propertyIsEnumerable,F=u("symbol-registry"),U=u("symbols"),H=u("op-symbols"),z=Object.prototype,W="function"==typeof M&&!!B.f,G=o.QObject,X=!G||!G.prototype||!G.prototype.findChild,V=i&&l((function(){return 7!=E(N({},"a",{get:function(){return N(this,"a",{value:7}).a}})).a}))?function(t,e,n){var o=I(z,e);o&&delete z[e],N(t,e,n),o&&t!==z&&N(z,e,o)}:N,Y=function(t){var e=U[t]=E(M.prototype);return e._k=t,e},K=W&&"symbol"==typeof M.iterator?function(t){return"symbol"==typeof t}:function(t){return t instanceof M},Z=function(t,e,n){return t===z&&Z(H,e,n),b(t),e=S(e,!0),b(n),r(U,e)?(n.enumerable?(r(t,P)&&t[P][e]&&(t[P][e]=!1),n=E(n,{enumerable:w(0,!1)})):(r(t,P)||N(t,P,w(1,{})),t[P][e]=!0),V(t,e,n)):N(t,e,n)},q=function(t,e){b(t);for(var n,o=y(e=x(e)),r=0,i=o.length;i>r;)Z(t,n=o[r++],e[n]);return t},J=function(t){var e=j.call(this,t=S(t,!0));return!(this===z&&r(U,t)&&!r(H,t))&&(!(e||!r(this,t)||!r(U,t)||r(this,P)&&this[P][t])||e)},$=function(t,e){if(t=x(t),e=S(e,!0),t!==z||!r(U,e)||r(H,e)){var n=I(t,e);return!n||!r(U,e)||r(t,P)&&t[P][e]||(n.enumerable=!0),n}},Q=function(t){for(var e,n=R(x(t)),o=[],i=0;n.length>i;)r(U,e=n[i++])||e==P||e==c||o.push(e);return o},tt=function(t){for(var e,n=t===z,o=R(n?H:x(t)),i=[],a=0;o.length>a;)!r(U,e=o[a++])||n&&!r(z,e)||i.push(U[e]);return i};W||(s((M=function(){if(this instanceof M)throw TypeError("Symbol is not a constructor!");var t=d(arguments.length>0?arguments[0]:void 0),e=function(n){this===z&&e.call(H,n),r(this,P)&&r(this[P],t)&&(this[P][t]=!1),V(this,t,w(1,n))};return i&&X&&V(z,t,{configurable:!0,set:e}),Y(t)}).prototype,"toString",(function(){return this._k})),C.f=$,_.f=Z,n(48).f=T.f=Q,n(63).f=J,B.f=tt,i&&!n(44)&&s(z,"propertyIsEnumerable",J,!0),h.f=function(t){return Y(p(t))}),a(a.G+a.W+a.F*!W,{Symbol:M});for(var et="hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables".split(","),nt=0;et.length>nt;)p(et[nt++]);for(var ot=O(p.store),rt=0;ot.length>rt;)v(ot[rt++]);a(a.S+a.F*!W,"Symbol",{for:function(t){return r(F,t+="")?F[t]:F[t]=M(t)},keyFor:function(t){if(!K(t))throw TypeError(t+" is not a symbol!");for(var e in F)if(F[e]===t)return e},useSetter:function(){X=!0},useSimple:function(){X=!1}}),a(a.S+a.F*!W,"Object",{create:function(t,e){return void 0===e?E(t):q(E(t),e)},defineProperty:Z,defineProperties:q,getOwnPropertyDescriptor:$,getOwnPropertyNames:Q,getOwnPropertySymbols:tt});var it=l((function(){B.f(1)}));a(a.S+a.F*it,"Object",{getOwnPropertySymbols:function(t){return B.f(k(t))}}),L&&a(a.S+a.F*(!W||l((function(){var t=M();return"[null]"!=A([t])||"{}"!=A({a:t})||"{}"!=A(Object(t))}))),"JSON",{stringify:function(t){for(var e,n,o=[t],r=1;arguments.length>r;)o.push(arguments[r++]);if(n=e=o[1],(m(e)||void 0!==t)&&!K(t))return g(e)||(e=function(t,e){if("function"==typeof n&&(e=n.call(this,t,e)),!K(e))return e}),o[1]=e,A.apply(L,o)}}),M.prototype[D]||n(27)(M.prototype,D,M.prototype.valueOf),f(M,"Symbol"),f(Math,"Math",!0),f(o.JSON,"JSON",!0)},function(t,e,n){t.exports=n(68)("native-function-to-string",Function.toString)},function(t,e,n){var o=n(45),r=n(70),i=n(63);t.exports=function(t){var e=o(t),n=r.f;if(n)for(var a,s=n(t),c=i.f,l=0;s.length>l;)c.call(t,a=s[l++])&&e.push(a);return e}},function(t,e,n){var o=n(0);o(o.S,"Object",{create:n(47)})},function(t,e,n){var o=n(0);o(o.S+o.F*!n(18),"Object",{defineProperty:n(19).f})},function(t,e,n){var o=n(0);o(o.S+o.F*!n(18),"Object",{defineProperties:n(112)})},function(t,e,n){var o=n(28),r=n(33).f;n(34)("getOwnPropertyDescriptor",(function(){return function(t,e){return r(o(t),e)}}))},function(t,e,n){var o=n(20),r=n(49);n(34)("getPrototypeOf",(function(){return function(t){return r(o(t))}}))},function(t,e,n){var o=n(20),r=n(45);n(34)("keys",(function(){return function(t){return r(o(t))}}))},function(t,e,n){n(34)("getOwnPropertyNames",(function(){return n(113).f}))},function(t,e,n){var o=n(12),r=n(41).onFreeze;n(34)("freeze",(function(t){return function(e){return t&&o(e)?t(r(e)):e}}))},function(t,e,n){var o=n(12),r=n(41).onFreeze;n(34)("seal",(function(t){return function(e){return t&&o(e)?t(r(e)):e}}))},function(t,e,n){var o=n(12),r=n(41).onFreeze;n(34)("preventExtensions",(function(t){return function(e){return t&&o(e)?t(r(e)):e}}))},function(t,e,n){var o=n(12);n(34)("isFrozen",(function(t){return function(e){return!o(e)||!!t&&t(e)}}))},function(t,e,n){var o=n(12);n(34)("isSealed",(function(t){return function(e){return!o(e)||!!t&&t(e)}}))},function(t,e,n){var o=n(12);n(34)("isExtensible",(function(t){return function(e){return!!o(e)&&(!t||t(e))}}))},function(t,e,n){var o=n(0);o(o.S+o.F,"Object",{assign:n(114)})},function(t,e,n){var o=n(0);o(o.S,"Object",{is:n(115)})},function(t,e,n){var o=n(0);o(o.S,"Object",{setPrototypeOf:n(88).set})},function(t,e,n){"use strict";var o=n(64),r={};r[n(14)("toStringTag")]="z",r+""!="[object z]"&&n(23)(Object.prototype,"toString",(function(){return"[object "+o(this)+"]"}),!0)},function(t,e,n){var o=n(0);o(o.P,"Function",{bind:n(116)})},function(t,e,n){var o=n(19).f,r=Function.prototype,i=/^\s*function ([^ (]*)/;"name"in r||n(18)&&o(r,"name",{configurable:!0,get:function(){try{return(""+this).match(i)[1]}catch(t){return""}}})},function(t,e,n){"use strict";var o=n(12),r=n(49),i=n(14)("hasInstance"),a=Function.prototype;i in a||n(19).f(a,i,{value:function(t){if("function"!=typeof this||!o(t))return!1;if(!o(this.prototype))return t instanceof this;for(;t=r(t);)if(this.prototype===t)return!0;return!1}})},function(t,e,n){var o=n(0),r=n(118);o(o.G+o.F*(parseInt!=r),{parseInt:r})},function(t,e,n){var o=n(0),r=n(119);o(o.G+o.F*(parseFloat!=r),{parseFloat:r})},function(t,e,n){"use strict";var o=n(9),r=n(26),i=n(36),a=n(90),s=n(40),c=n(10),l=n(48).f,u=n(33).f,f=n(19).f,d=n(54).trim,p=o.Number,h=p,v=p.prototype,y="Number"==i(n(47)(v)),g="trim"in String.prototype,b=function(t){var e=s(t,!1);if("string"==typeof e&&e.length>2){var n,o,r,i=(e=g?e.trim():d(e,3)).charCodeAt(0);if(43===i||45===i){if(88===(n=e.charCodeAt(2))||120===n)return NaN}else if(48===i){switch(e.charCodeAt(1)){case 66:case 98:o=2,r=49;break;case 79:case 111:o=8,r=55;break;default:return+e}for(var a,c=e.slice(2),l=0,u=c.length;l<u;l++)if((a=c.charCodeAt(l))<48||a>r)return NaN;return parseInt(c,o)}}return+e};if(!p(" 0o1")||!p("0b1")||p("+0x1")){p=function(t){var e=arguments.length<1?0:t,n=this;return n instanceof p&&(y?c((function(){v.valueOf.call(n)})):"Number"!=i(n))?a(new h(b(e)),n,p):b(e)};for(var m,k=n(18)?l(h):"MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,EPSILON,isFinite,isInteger,isNaN,isSafeInteger,MAX_SAFE_INTEGER,MIN_SAFE_INTEGER,parseFloat,parseInt,isInteger".split(","),x=0;k.length>x;x++)r(h,m=k[x])&&!r(p,m)&&f(p,m,u(h,m));p.prototype=v,v.constructor=p,n(23)(o,"Number",p)}},function(t,e,n){"use strict";var o=n(0),r=n(32),i=n(120),a=n(91),s=1..toFixed,c=Math.floor,l=[0,0,0,0,0,0],u="Number.toFixed: incorrect invocation!",f=function(t,e){for(var n=-1,o=e;++n<6;)o+=t*l[n],l[n]=o%1e7,o=c(o/1e7)},d=function(t){for(var e=6,n=0;--e>=0;)n+=l[e],l[e]=c(n/t),n=n%t*1e7},p=function(){for(var t=6,e="";--t>=0;)if(""!==e||0===t||0!==l[t]){var n=String(l[t]);e=""===e?n:e+a.call("0",7-n.length)+n}return e},h=function(t,e,n){return 0===e?n:e%2==1?h(t,e-1,n*t):h(t*t,e/2,n)};o(o.P+o.F*(!!s&&("0.000"!==8e-5.toFixed(3)||"1"!==.9.toFixed(0)||"1.25"!==1.255.toFixed(2)||"1000000000000000128"!==(0xde0b6b3a7640080).toFixed(0))||!n(10)((function(){s.call({})}))),"Number",{toFixed:function(t){var e,n,o,s,c=i(this,u),l=r(t),v="",y="0";if(l<0||l>20)throw RangeError(u);if(c!=c)return"NaN";if(c<=-1e21||c>=1e21)return String(c);if(c<0&&(v="-",c=-c),c>1e-21)if(n=(e=function(t){for(var e=0,n=t;n>=4096;)e+=12,n/=4096;for(;n>=2;)e+=1,n/=2;return e}(c*h(2,69,1))-69)<0?c*h(2,-e,1):c/h(2,e,1),n*=4503599627370496,(e=52-e)>0){for(f(0,n),o=l;o>=7;)f(1e7,0),o-=7;for(f(h(10,o,1),0),o=e-1;o>=23;)d(1<<23),o-=23;d(1<<o),f(1,1),d(2),y=p()}else f(0,n),f(1<<-e,0),y=p()+a.call("0",l);return y=l>0?v+((s=y.length)<=l?"0."+a.call("0",l-s)+y:y.slice(0,s-l)+"."+y.slice(s-l)):v+y}})},function(t,e,n){"use strict";var o=n(0),r=n(10),i=n(120),a=1..toPrecision;o(o.P+o.F*(r((function(){return"1"!==a.call(1,void 0)}))||!r((function(){a.call({})}))),"Number",{toPrecision:function(t){var e=i(this,"Number#toPrecision: incorrect invocation!");return void 0===t?a.call(e):a.call(e,t)}})},function(t,e,n){var o=n(0);o(o.S,"Number",{EPSILON:Math.pow(2,-52)})},function(t,e,n){var o=n(0),r=n(9).isFinite;o(o.S,"Number",{isFinite:function(t){return"number"==typeof t&&r(t)}})},function(t,e,n){var o=n(0);o(o.S,"Number",{isInteger:n(121)})},function(t,e,n){var o=n(0);o(o.S,"Number",{isNaN:function(t){return t!=t}})},function(t,e,n){var o=n(0),r=n(121),i=Math.abs;o(o.S,"Number",{isSafeInteger:function(t){return r(t)&&i(t)<=9007199254740991}})},function(t,e,n){var o=n(0);o(o.S,"Number",{MAX_SAFE_INTEGER:9007199254740991})},function(t,e,n){var o=n(0);o(o.S,"Number",{MIN_SAFE_INTEGER:-9007199254740991})},function(t,e,n){var o=n(0),r=n(119);o(o.S+o.F*(Number.parseFloat!=r),"Number",{parseFloat:r})},function(t,e,n){var o=n(0),r=n(118);o(o.S+o.F*(Number.parseInt!=r),"Number",{parseInt:r})},function(t,e,n){var o=n(0),r=n(122),i=Math.sqrt,a=Math.acosh;o(o.S+o.F*!(a&&710==Math.floor(a(Number.MAX_VALUE))&&a(1/0)==1/0),"Math",{acosh:function(t){return(t=+t)<1?NaN:t>94906265.62425156?Math.log(t)+Math.LN2:r(t-1+i(t-1)*i(t+1))}})},function(t,e,n){var o=n(0),r=Math.asinh;o(o.S+o.F*!(r&&1/r(0)>0),"Math",{asinh:function t(e){return isFinite(e=+e)&&0!=e?e<0?-t(-e):Math.log(e+Math.sqrt(e*e+1)):e}})},function(t,e,n){var o=n(0),r=Math.atanh;o(o.S+o.F*!(r&&1/r(-0)<0),"Math",{atanh:function(t){return 0==(t=+t)?t:Math.log((1+t)/(1-t))/2}})},function(t,e,n){var o=n(0),r=n(92);o(o.S,"Math",{cbrt:function(t){return r(t=+t)*Math.pow(Math.abs(t),1/3)}})},function(t,e,n){var o=n(0);o(o.S,"Math",{clz32:function(t){return(t>>>=0)?31-Math.floor(Math.log(t+.5)*Math.LOG2E):32}})},function(t,e,n){var o=n(0),r=Math.exp;o(o.S,"Math",{cosh:function(t){return(r(t=+t)+r(-t))/2}})},function(t,e,n){var o=n(0),r=n(93);o(o.S+o.F*(r!=Math.expm1),"Math",{expm1:r})},function(t,e,n){var o=n(0);o(o.S,"Math",{fround:n(232)})},function(t,e,n){var o=n(92),r=Math.pow,i=r(2,-52),a=r(2,-23),s=r(2,127)*(2-a),c=r(2,-126);t.exports=Math.fround||function(t){var e,n,r=Math.abs(t),l=o(t);return r<c?l*(r/c/a+1/i-1/i)*c*a:(n=(e=(1+a/i)*r)-(e-r))>s||n!=n?l*(1/0):l*n}},function(t,e,n){var o=n(0),r=Math.abs;o(o.S,"Math",{hypot:function(t,e){for(var n,o,i=0,a=0,s=arguments.length,c=0;a<s;)c<(n=r(arguments[a++]))?(i=i*(o=c/n)*o+1,c=n):i+=n>0?(o=n/c)*o:n;return c===1/0?1/0:c*Math.sqrt(i)}})},function(t,e,n){var o=n(0),r=Math.imul;o(o.S+o.F*n(10)((function(){return-5!=r(4294967295,5)||2!=r.length})),"Math",{imul:function(t,e){var n=+t,o=+e,r=65535&n,i=65535&o;return 0|r*i+((65535&n>>>16)*i+r*(65535&o>>>16)<<16>>>0)}})},function(t,e,n){var o=n(0);o(o.S,"Math",{log10:function(t){return Math.log(t)*Math.LOG10E}})},function(t,e,n){var o=n(0);o(o.S,"Math",{log1p:n(122)})},function(t,e,n){var o=n(0);o(o.S,"Math",{log2:function(t){return Math.log(t)/Math.LN2}})},function(t,e,n){var o=n(0);o(o.S,"Math",{sign:n(92)})},function(t,e,n){var o=n(0),r=n(93),i=Math.exp;o(o.S+o.F*n(10)((function(){return-2e-17!=!Math.sinh(-2e-17)})),"Math",{sinh:function(t){return Math.abs(t=+t)<1?(r(t)-r(-t))/2:(i(t-1)-i(-t-1))*(Math.E/2)}})},function(t,e,n){var o=n(0),r=n(93),i=Math.exp;o(o.S,"Math",{tanh:function(t){var e=r(t=+t),n=r(-t);return e==1/0?1:n==1/0?-1:(e-n)/(i(t)+i(-t))}})},function(t,e,n){var o=n(0);o(o.S,"Math",{trunc:function(t){return(t>0?Math.floor:Math.ceil)(t)}})},function(t,e,n){var o=n(0),r=n(46),i=String.fromCharCode,a=String.fromCodePoint;o(o.S+o.F*(!!a&&1!=a.length),"String",{fromCodePoint:function(t){for(var e,n=[],o=arguments.length,a=0;o>a;){if(e=+arguments[a++],r(e,1114111)!==e)throw RangeError(e+" is not a valid code point");n.push(e<65536?i(e):i(55296+((e-=65536)>>10),e%1024+56320))}return n.join("")}})},function(t,e,n){var o=n(0),r=n(28),i=n(16);o(o.S,"String",{raw:function(t){for(var e=r(t.raw),n=i(e.length),o=arguments.length,a=[],s=0;n>s;)a.push(String(e[s++])),s<o&&a.push(String(arguments[s]));return a.join("")}})},function(t,e,n){"use strict";n(54)("trim",(function(t){return function(){return t(this,3)}}))},function(t,e,n){"use strict";var o=n(94)(!0);n(95)(String,"String",(function(t){this._t=String(t),this._i=0}),(function(){var t,e=this._t,n=this._i;return n>=e.length?{value:void 0,done:!0}:(t=o(e,n),this._i+=t.length,{value:t,done:!1})}))},function(t,e,n){"use strict";var o=n(0),r=n(94)(!1);o(o.P,"String",{codePointAt:function(t){return r(this,t)}})},function(t,e,n){"use strict";var o=n(0),r=n(16),i=n(96),a="".endsWith;o(o.P+o.F*n(98)("endsWith"),"String",{endsWith:function(t){var e=i(this,t,"endsWith"),n=arguments.length>1?arguments[1]:void 0,o=r(e.length),s=void 0===n?o:Math.min(r(n),o),c=String(t);return a?a.call(e,c,s):e.slice(s-c.length,s)===c}})},function(t,e,n){"use strict";var o=n(0),r=n(96);o(o.P+o.F*n(98)("includes"),"String",{includes:function(t){return!!~r(this,t,"includes").indexOf(t,arguments.length>1?arguments[1]:void 0)}})},function(t,e,n){var o=n(0);o(o.P,"String",{repeat:n(91)})},function(t,e,n){"use strict";var o=n(0),r=n(16),i=n(96),a="".startsWith;o(o.P+o.F*n(98)("startsWith"),"String",{startsWith:function(t){var e=i(this,t,"startsWith"),n=r(Math.min(arguments.length>1?arguments[1]:void 0,e.length)),o=String(t);return a?a.call(e,o,n):e.slice(n,n+o.length)===o}})},function(t,e,n){"use strict";n(24)("anchor",(function(t){return function(e){return t(this,"a","name",e)}}))},function(t,e,n){"use strict";n(24)("big",(function(t){return function(){return t(this,"big","","")}}))},function(t,e,n){"use strict";n(24)("blink",(function(t){return function(){return t(this,"blink","","")}}))},function(t,e,n){"use strict";n(24)("bold",(function(t){return function(){return t(this,"b","","")}}))},function(t,e,n){"use strict";n(24)("fixed",(function(t){return function(){return t(this,"tt","","")}}))},function(t,e,n){"use strict";n(24)("fontcolor",(function(t){return function(e){return t(this,"font","color",e)}}))},function(t,e,n){"use strict";n(24)("fontsize",(function(t){return function(e){return t(this,"font","size",e)}}))},function(t,e,n){"use strict";n(24)("italics",(function(t){return function(){return t(this,"i","","")}}))},function(t,e,n){"use strict";n(24)("link",(function(t){return function(e){return t(this,"a","href",e)}}))},function(t,e,n){"use strict";n(24)("small",(function(t){return function(){return t(this,"small","","")}}))},function(t,e,n){"use strict";n(24)("strike",(function(t){return function(){return t(this,"strike","","")}}))},function(t,e,n){"use strict";n(24)("sub",(function(t){return function(){return t(this,"sub","","")}}))},function(t,e,n){"use strict";n(24)("sup",(function(t){return function(){return t(this,"sup","","")}}))},function(t,e,n){var o=n(0);o(o.S,"Date",{now:function(){return(new Date).getTime()}})},function(t,e,n){"use strict";var o=n(0),r=n(20),i=n(40);o(o.P+o.F*n(10)((function(){return null!==new Date(NaN).toJSON()||1!==Date.prototype.toJSON.call({toISOString:function(){return 1}})})),"Date",{toJSON:function(t){var e=r(this),n=i(e);return"number"!=typeof n||isFinite(n)?e.toISOString():null}})},function(t,e,n){var o=n(0),r=n(267);o(o.P+o.F*(Date.prototype.toISOString!==r),"Date",{toISOString:r})},function(t,e,n){"use strict";var o=n(10),r=Date.prototype.getTime,i=Date.prototype.toISOString,a=function(t){return t>9?t:"0"+t};t.exports=o((function(){return"0385-07-25T07:06:39.999Z"!=i.call(new Date(-50000000000001))}))||!o((function(){i.call(new Date(NaN))}))?function(){if(!isFinite(r.call(this)))throw RangeError("Invalid time value");var t=this,e=t.getUTCFullYear(),n=t.getUTCMilliseconds(),o=e<0?"-":e>9999?"+":"";return o+("00000"+Math.abs(e)).slice(o?-6:-4)+"-"+a(t.getUTCMonth()+1)+"-"+a(t.getUTCDate())+"T"+a(t.getUTCHours())+":"+a(t.getUTCMinutes())+":"+a(t.getUTCSeconds())+"."+(n>99?n:"0"+a(n))+"Z"}:i},function(t,e,n){var o=Date.prototype,r=o.toString,i=o.getTime;new Date(NaN)+""!="Invalid Date"&&n(23)(o,"toString",(function(){var t=i.call(this);return t==t?r.call(this):"Invalid Date"}))},function(t,e,n){var o=n(14)("toPrimitive"),r=Date.prototype;o in r||n(27)(r,o,n(270))},function(t,e,n){"use strict";var o=n(11),r=n(40);t.exports=function(t){if("string"!==t&&"number"!==t&&"default"!==t)throw TypeError("Incorrect hint");return r(o(this),"number"!=t)}},function(t,e,n){var o=n(0);o(o.S,"Array",{isArray:n(71)})},function(t,e,n){"use strict";var o=n(30),r=n(0),i=n(20),a=n(124),s=n(99),c=n(16),l=n(100),u=n(101);r(r.S+r.F*!n(72)((function(t){Array.from(t)})),"Array",{from:function(t){var e,n,r,f,d=i(t),p="function"==typeof this?this:Array,h=arguments.length,v=h>1?arguments[1]:void 0,y=void 0!==v,g=0,b=u(d);if(y&&(v=o(v,h>2?arguments[2]:void 0,2)),null==b||p==Array&&s(b))for(n=new p(e=c(d.length));e>g;g++)l(n,g,y?v(d[g],g):d[g]);else for(f=b.call(d),n=new p;!(r=f.next()).done;g++)l(n,g,y?a(f,v,[r.value,g],!0):r.value);return n.length=g,n}})},function(t,e,n){"use strict";var o=n(0),r=n(100);o(o.S+o.F*n(10)((function(){function t(){}return!(Array.of.call(t)instanceof t)})),"Array",{of:function(){for(var t=0,e=arguments.length,n=new("function"==typeof this?this:Array)(e);e>t;)r(n,t,arguments[t++]);return n.length=e,n}})},function(t,e,n){"use strict";var o=n(0),r=n(28),i=[].join;o(o.P+o.F*(n(62)!=Object||!n(29)(i)),"Array",{join:function(t){return i.call(r(this),void 0===t?",":t)}})},function(t,e,n){"use strict";var o=n(0),r=n(87),i=n(36),a=n(46),s=n(16),c=[].slice;o(o.P+o.F*n(10)((function(){r&&c.call(r)})),"Array",{slice:function(t,e){var n=s(this.length),o=i(this);if(e=void 0===e?n:e,"Array"==o)return c.call(this,t,e);for(var r=a(t,n),l=a(e,n),u=s(l-r),f=new Array(u),d=0;d<u;d++)f[d]="String"==o?this.charAt(r+d):this[r+d];return f}})},function(t,e,n){"use strict";var o=n(0),r=n(31),i=n(20),a=n(10),s=[].sort,c=[1,2,3];o(o.P+o.F*(a((function(){c.sort(void 0)}))||!a((function(){c.sort(null)}))||!n(29)(s)),"Array",{sort:function(t){return void 0===t?s.call(i(this)):s.call(i(this),r(t))}})},function(t,e,n){"use strict";var o=n(0),r=n(35)(0),i=n(29)([].forEach,!0);o(o.P+o.F*!i,"Array",{forEach:function(t){return r(this,t,arguments[1])}})},function(t,e,n){var o=n(12),r=n(71),i=n(14)("species");t.exports=function(t){var e;return r(t)&&("function"!=typeof(e=t.constructor)||e!==Array&&!r(e.prototype)||(e=void 0),o(e)&&null===(e=e[i])&&(e=void 0)),void 0===e?Array:e}},function(t,e,n){"use strict";var o=n(0),r=n(35)(1);o(o.P+o.F*!n(29)([].map,!0),"Array",{map:function(t){return r(this,t,arguments[1])}})},function(t,e,n){"use strict";var o=n(0),r=n(35)(2);o(o.P+o.F*!n(29)([].filter,!0),"Array",{filter:function(t){return r(this,t,arguments[1])}})},function(t,e,n){"use strict";var o=n(0),r=n(35)(3);o(o.P+o.F*!n(29)([].some,!0),"Array",{some:function(t){return r(this,t,arguments[1])}})},function(t,e,n){"use strict";var o=n(0),r=n(35)(4);o(o.P+o.F*!n(29)([].every,!0),"Array",{every:function(t){return r(this,t,arguments[1])}})},function(t,e,n){"use strict";var o=n(0),r=n(126);o(o.P+o.F*!n(29)([].reduce,!0),"Array",{reduce:function(t){return r(this,t,arguments.length,arguments[1],!1)}})},function(t,e,n){"use strict";var o=n(0),r=n(126);o(o.P+o.F*!n(29)([].reduceRight,!0),"Array",{reduceRight:function(t){return r(this,t,arguments.length,arguments[1],!0)}})},function(t,e,n){"use strict";var o=n(0),r=n(69)(!1),i=[].indexOf,a=!!i&&1/[1].indexOf(1,-0)<0;o(o.P+o.F*(a||!n(29)(i)),"Array",{indexOf:function(t){return a?i.apply(this,arguments)||0:r(this,t,arguments[1])}})},function(t,e,n){"use strict";var o=n(0),r=n(28),i=n(32),a=n(16),s=[].lastIndexOf,c=!!s&&1/[1].lastIndexOf(1,-0)<0;o(o.P+o.F*(c||!n(29)(s)),"Array",{lastIndexOf:function(t){if(c)return s.apply(this,arguments)||0;var e=r(this),n=a(e.length),o=n-1;for(arguments.length>1&&(o=Math.min(o,i(arguments[1]))),o<0&&(o=n+o);o>=0;o--)if(o in e&&e[o]===t)return o||0;return-1}})},function(t,e,n){var o=n(0);o(o.P,"Array",{copyWithin:n(127)}),n(50)("copyWithin")},function(t,e,n){var o=n(0);o(o.P,"Array",{fill:n(102)}),n(50)("fill")},function(t,e,n){"use strict";var o=n(0),r=n(35)(5),i=!0;"find"in[]&&Array(1).find((function(){i=!1})),o(o.P+o.F*i,"Array",{find:function(t){return r(this,t,arguments.length>1?arguments[1]:void 0)}}),n(50)("find")},function(t,e,n){"use strict";var o=n(0),r=n(35)(6),i="findIndex",a=!0;i in[]&&Array(1)[i]((function(){a=!1})),o(o.P+o.F*a,"Array",{findIndex:function(t){return r(this,t,arguments.length>1?arguments[1]:void 0)}}),n(50)(i)},function(t,e,n){n(56)("Array")},function(t,e,n){var o=n(9),r=n(90),i=n(19).f,a=n(48).f,s=n(97),c=n(73),l=o.RegExp,u=l,f=l.prototype,d=/a/g,p=/a/g,h=new l(d)!==d;if(n(18)&&(!h||n(10)((function(){return p[n(14)("match")]=!1,l(d)!=d||l(p)==p||"/a/i"!=l(d,"i")})))){l=function(t,e){var n=this instanceof l,o=s(t),i=void 0===e;return!n&&o&&t.constructor===l&&i?t:r(h?new u(o&&!i?t.source:t,e):u((o=t instanceof l)?t.source:t,o&&i?c.call(t):e),n?this:f,l)};for(var v=function(t){t in l||i(l,t,{configurable:!0,get:function(){return u[t]},set:function(e){u[t]=e}})},y=a(u),g=0;y.length>g;)v(y[g++]);f.constructor=l,l.prototype=f,n(23)(o,"RegExp",l)}n(56)("RegExp")},function(t,e,n){"use strict";n(130);var o=n(11),r=n(73),i=n(18),a=/./.toString,s=function(t){n(23)(RegExp.prototype,"toString",t,!0)};n(10)((function(){return"/a/b"!=a.call({source:"a",flags:"b"})}))?s((function(){var t=o(this);return"/".concat(t.source,"/","flags"in t?t.flags:!i&&t instanceof RegExp?r.call(t):void 0)})):"toString"!=a.name&&s((function(){return a.call(this)}))},function(t,e,n){"use strict";var o=n(11),r=n(16),i=n(105),a=n(74);n(75)("match",1,(function(t,e,n,s){return[function(n){var o=t(this),r=null==n?void 0:n[e];return void 0!==r?r.call(n,o):new RegExp(n)[e](String(o))},function(t){var e=s(n,t,this);if(e.done)return e.value;var c=o(t),l=String(this);if(!c.global)return a(c,l);var u=c.unicode;c.lastIndex=0;for(var f,d=[],p=0;null!==(f=a(c,l));){var h=String(f[0]);d[p]=h,""===h&&(c.lastIndex=i(l,r(c.lastIndex),u)),p++}return 0===p?null:d}]}))},function(t,e,n){"use strict";var o=n(11),r=n(20),i=n(16),a=n(32),s=n(105),c=n(74),l=Math.max,u=Math.min,f=Math.floor,d=/\$([$&`']|\d\d?|<[^>]*>)/g,p=/\$([$&`']|\d\d?)/g;n(75)("replace",2,(function(t,e,n,h){return[function(o,r){var i=t(this),a=null==o?void 0:o[e];return void 0!==a?a.call(o,i,r):n.call(String(i),o,r)},function(t,e){var r=h(n,t,this,e);if(r.done)return r.value;var f=o(t),d=String(this),p="function"==typeof e;p||(e=String(e));var y=f.global;if(y){var g=f.unicode;f.lastIndex=0}for(var b=[];;){var m=c(f,d);if(null===m)break;if(b.push(m),!y)break;""===String(m[0])&&(f.lastIndex=s(d,i(f.lastIndex),g))}for(var k,x="",S=0,w=0;w<b.length;w++){m=b[w];for(var E=String(m[0]),T=l(u(a(m.index),d.length),0),C=[],B=1;B<m.length;B++)C.push(void 0===(k=m[B])?k:String(k));var _=m.groups;if(p){var O=[E].concat(C,T,d);void 0!==_&&O.push(_);var I=String(e.apply(void 0,O))}else I=v(E,d,T,C,_,e);T>=S&&(x+=d.slice(S,T)+I,S=T+E.length)}return x+d.slice(S)}];function v(t,e,o,i,a,s){var c=o+t.length,l=i.length,u=p;return void 0!==a&&(a=r(a),u=d),n.call(s,u,(function(n,r){var s;switch(r.charAt(0)){case"$":return"$";case"&":return t;case"`":return e.slice(0,o);case"'":return e.slice(c);case"<":s=a[r.slice(1,-1)];break;default:var u=+r;if(0===u)return n;if(u>l){var d=f(u/10);return 0===d?n:d<=l?void 0===i[d-1]?r.charAt(1):i[d-1]+r.charAt(1):n}s=i[u-1]}return void 0===s?"":s}))}}))},function(t,e,n){"use strict";var o=n(11),r=n(115),i=n(74);n(75)("search",1,(function(t,e,n,a){return[function(n){var o=t(this),r=null==n?void 0:n[e];return void 0!==r?r.call(n,o):new RegExp(n)[e](String(o))},function(t){var e=a(n,t,this);if(e.done)return e.value;var s=o(t),c=String(this),l=s.lastIndex;r(l,0)||(s.lastIndex=0);var u=i(s,c);return r(s.lastIndex,l)||(s.lastIndex=l),null===u?-1:u.index}]}))},function(t,e,n){"use strict";var o=n(97),r=n(11),i=n(65),a=n(105),s=n(16),c=n(74),l=n(104),u=n(10),f=Math.min,d=[].push,p="length",h=!u((function(){RegExp(4294967295,"y")}));n(75)("split",2,(function(t,e,n,u){var v;return v="c"=="abbc".split(/(b)*/)[1]||4!="test".split(/(?:)/,-1)[p]||2!="ab".split(/(?:ab)*/)[p]||4!=".".split(/(.?)(.?)/)[p]||".".split(/()()/)[p]>1||"".split(/.?/)[p]?function(t,e){var r=String(this);if(void 0===t&&0===e)return[];if(!o(t))return n.call(r,t,e);for(var i,a,s,c=[],u=(t.ignoreCase?"i":"")+(t.multiline?"m":"")+(t.unicode?"u":"")+(t.sticky?"y":""),f=0,h=void 0===e?4294967295:e>>>0,v=new RegExp(t.source,u+"g");(i=l.call(v,r))&&!((a=v.lastIndex)>f&&(c.push(r.slice(f,i.index)),i[p]>1&&i.index<r[p]&&d.apply(c,i.slice(1)),s=i[0][p],f=a,c[p]>=h));)v.lastIndex===i.index&&v.lastIndex++;return f===r[p]?!s&&v.test("")||c.push(""):c.push(r.slice(f)),c[p]>h?c.slice(0,h):c}:"0".split(void 0,0)[p]?function(t,e){return void 0===t&&0===e?[]:n.call(this,t,e)}:n,[function(n,o){var r=t(this),i=null==n?void 0:n[e];return void 0!==i?i.call(n,r,o):v.call(String(r),n,o)},function(t,e){var o=u(v,t,this,e,v!==n);if(o.done)return o.value;var l=r(t),d=String(this),p=i(l,RegExp),y=l.unicode,g=(l.ignoreCase?"i":"")+(l.multiline?"m":"")+(l.unicode?"u":"")+(h?"y":"g"),b=new p(h?l:"^(?:"+l.source+")",g),m=void 0===e?4294967295:e>>>0;if(0===m)return[];if(0===d.length)return null===c(b,d)?[d]:[];for(var k=0,x=0,S=[];x<d.length;){b.lastIndex=h?x:0;var w,E=c(b,h?d:d.slice(x));if(null===E||(w=f(s(b.lastIndex+(h?0:x)),d.length))===k)x=a(d,x,y);else{if(S.push(d.slice(k,x)),S.length===m)return S;for(var T=1;T<=E.length-1;T++)if(S.push(E[T]),S.length===m)return S;x=k=w}}return S.push(d.slice(k)),S}]}))},function(t,e,n){var o=n(9),r=n(106).set,i=o.MutationObserver||o.WebKitMutationObserver,a=o.process,s=o.Promise,c="process"==n(36)(a);t.exports=function(){var t,e,n,l=function(){var o,r;for(c&&(o=a.domain)&&o.exit();t;){r=t.fn,t=t.next;try{r()}catch(o){throw t?n():e=void 0,o}}e=void 0,o&&o.enter()};if(c)n=function(){a.nextTick(l)};else if(!i||o.navigator&&o.navigator.standalone)if(s&&s.resolve){var u=s.resolve(void 0);n=function(){u.then(l)}}else n=function(){r.call(o,l)};else{var f=!0,d=document.createTextNode("");new i(l).observe(d,{characterData:!0}),n=function(){d.data=f=!f}}return function(o){var r={fn:o,next:void 0};e&&(e.next=r),t||(t=r,n()),e=r}}},function(t,e){t.exports=function(t){try{return{e:!1,v:t()}}catch(t){return{e:!0,v:t}}}},function(t,e,n){"use strict";var o=n(134),r=n(51);t.exports=n(78)("Map",(function(t){return function(){return t(this,arguments.length>0?arguments[0]:void 0)}}),{get:function(t){var e=o.getEntry(r(this,"Map"),t);return e&&e.v},set:function(t,e){return o.def(r(this,"Map"),0===t?0:t,e)}},o,!0)},function(t,e,n){"use strict";var o=n(134),r=n(51);t.exports=n(78)("Set",(function(t){return function(){return t(this,arguments.length>0?arguments[0]:void 0)}}),{add:function(t){return o.def(r(this,"Set"),t=0===t?0:t,t)}},o)},function(t,e,n){"use strict";var o,r=n(9),i=n(35)(0),a=n(23),s=n(41),c=n(114),l=n(135),u=n(12),f=n(51),d=n(51),p=!r.ActiveXObject&&"ActiveXObject"in r,h=s.getWeak,v=Object.isExtensible,y=l.ufstore,g=function(t){return function(){return t(this,arguments.length>0?arguments[0]:void 0)}},b={get:function(t){if(u(t)){var e=h(t);return!0===e?y(f(this,"WeakMap")).get(t):e?e[this._i]:void 0}},set:function(t,e){return l.def(f(this,"WeakMap"),t,e)}},m=t.exports=n(78)("WeakMap",g,b,l,!0,!0);d&&p&&(c((o=l.getConstructor(g,"WeakMap")).prototype,b),s.NEED=!0,i(["delete","has","get","set"],(function(t){var e=m.prototype,n=e[t];a(e,t,(function(e,r){if(u(e)&&!v(e)){this._f||(this._f=new o);var i=this._f[t](e,r);return"set"==t?this:i}return n.call(this,e,r)}))})))},function(t,e,n){"use strict";var o=n(135),r=n(51);n(78)("WeakSet",(function(t){return function(){return t(this,arguments.length>0?arguments[0]:void 0)}}),{add:function(t){return o.def(r(this,"WeakSet"),t,!0)}},o,!1,!0)},function(t,e,n){"use strict";var o=n(0),r=n(79),i=n(107),a=n(11),s=n(46),c=n(16),l=n(12),u=n(9).ArrayBuffer,f=n(65),d=i.ArrayBuffer,p=i.DataView,h=r.ABV&&u.isView,v=d.prototype.slice,y=r.VIEW;o(o.G+o.W+o.F*(u!==d),{ArrayBuffer:d}),o(o.S+o.F*!r.CONSTR,"ArrayBuffer",{isView:function(t){return h&&h(t)||l(t)&&y in t}}),o(o.P+o.U+o.F*n(10)((function(){return!new d(2).slice(1,void 0).byteLength})),"ArrayBuffer",{slice:function(t,e){if(void 0!==v&&void 0===e)return v.call(a(this),t);for(var n=a(this).byteLength,o=s(t,n),r=s(void 0===e?n:e,n),i=new(f(this,d))(c(r-o)),l=new p(this),u=new p(i),h=0;o<r;)u.setUint8(h++,l.getUint8(o++));return i}}),n(56)("ArrayBuffer")},function(t,e,n){var o=n(0);o(o.G+o.W+o.F*!n(79).ABV,{DataView:n(107).DataView})},function(t,e,n){n(38)("Int8",1,(function(t){return function(e,n,o){return t(this,e,n,o)}}))},function(t,e,n){n(38)("Uint8",1,(function(t){return function(e,n,o){return t(this,e,n,o)}}))},function(t,e,n){n(38)("Uint8",1,(function(t){return function(e,n,o){return t(this,e,n,o)}}),!0)},function(t,e,n){n(38)("Int16",2,(function(t){return function(e,n,o){return t(this,e,n,o)}}))},function(t,e,n){n(38)("Uint16",2,(function(t){return function(e,n,o){return t(this,e,n,o)}}))},function(t,e,n){n(38)("Int32",4,(function(t){return function(e,n,o){return t(this,e,n,o)}}))},function(t,e,n){n(38)("Uint32",4,(function(t){return function(e,n,o){return t(this,e,n,o)}}))},function(t,e,n){n(38)("Float32",4,(function(t){return function(e,n,o){return t(this,e,n,o)}}))},function(t,e,n){n(38)("Float64",8,(function(t){return function(e,n,o){return t(this,e,n,o)}}))},function(t,e,n){var o=n(0),r=n(31),i=n(11),a=(n(9).Reflect||{}).apply,s=Function.apply;o(o.S+o.F*!n(10)((function(){a((function(){}))})),"Reflect",{apply:function(t,e,n){var o=r(t),c=i(n);return a?a(o,e,c):s.call(o,e,c)}})},function(t,e,n){var o=n(0),r=n(47),i=n(31),a=n(11),s=n(12),c=n(10),l=n(116),u=(n(9).Reflect||{}).construct,f=c((function(){function t(){}return!(u((function(){}),[],t)instanceof t)})),d=!c((function(){u((function(){}))}));o(o.S+o.F*(f||d),"Reflect",{construct:function(t,e){i(t),a(e);var n=arguments.length<3?t:i(arguments[2]);if(d&&!f)return u(t,e,n);if(t==n){switch(e.length){case 0:return new t;case 1:return new t(e[0]);case 2:return new t(e[0],e[1]);case 3:return new t(e[0],e[1],e[2]);case 4:return new t(e[0],e[1],e[2],e[3])}var o=[null];return o.push.apply(o,e),new(l.apply(t,o))}var c=n.prototype,p=r(s(c)?c:Object.prototype),h=Function.apply.call(t,p,e);return s(h)?h:p}})},function(t,e,n){var o=n(19),r=n(0),i=n(11),a=n(40);r(r.S+r.F*n(10)((function(){Reflect.defineProperty(o.f({},1,{value:1}),1,{value:2})})),"Reflect",{defineProperty:function(t,e,n){i(t),e=a(e,!0),i(n);try{return o.f(t,e,n),!0}catch(t){return!1}}})},function(t,e,n){var o=n(0),r=n(33).f,i=n(11);o(o.S,"Reflect",{deleteProperty:function(t,e){var n=r(i(t),e);return!(n&&!n.configurable)&&delete t[e]}})},function(t,e,n){"use strict";var o=n(0),r=n(11),i=function(t){this._t=r(t),this._i=0;var e,n=this._k=[];for(e in t)n.push(e)};n(123)(i,"Object",(function(){var t,e=this._k;do{if(this._i>=e.length)return{value:void 0,done:!0}}while(!((t=e[this._i++])in this._t));return{value:t,done:!1}})),o(o.S,"Reflect",{enumerate:function(t){return new i(t)}})},function(t,e,n){var o=n(33),r=n(49),i=n(26),a=n(0),s=n(12),c=n(11);a(a.S,"Reflect",{get:function t(e,n){var a,l,u=arguments.length<3?e:arguments[2];return c(e)===u?e[n]:(a=o.f(e,n))?i(a,"value")?a.value:void 0!==a.get?a.get.call(u):void 0:s(l=r(e))?t(l,n,u):void 0}})},function(t,e,n){var o=n(33),r=n(0),i=n(11);r(r.S,"Reflect",{getOwnPropertyDescriptor:function(t,e){return o.f(i(t),e)}})},function(t,e,n){var o=n(0),r=n(49),i=n(11);o(o.S,"Reflect",{getPrototypeOf:function(t){return r(i(t))}})},function(t,e,n){var o=n(0);o(o.S,"Reflect",{has:function(t,e){return e in t}})},function(t,e,n){var o=n(0),r=n(11),i=Object.isExtensible;o(o.S,"Reflect",{isExtensible:function(t){return r(t),!i||i(t)}})},function(t,e,n){var o=n(0);o(o.S,"Reflect",{ownKeys:n(137)})},function(t,e,n){var o=n(0),r=n(11),i=Object.preventExtensions;o(o.S,"Reflect",{preventExtensions:function(t){r(t);try{return i&&i(t),!0}catch(t){return!1}}})},function(t,e,n){var o=n(19),r=n(33),i=n(49),a=n(26),s=n(0),c=n(42),l=n(11),u=n(12);s(s.S,"Reflect",{set:function t(e,n,s){var f,d,p=arguments.length<4?e:arguments[3],h=r.f(l(e),n);if(!h){if(u(d=i(e)))return t(d,n,s,p);h=c(0)}if(a(h,"value")){if(!1===h.writable||!u(p))return!1;if(f=r.f(p,n)){if(f.get||f.set||!1===f.writable)return!1;f.value=s,o.f(p,n,f)}else o.f(p,n,c(0,s));return!0}return void 0!==h.set&&(h.set.call(p,s),!0)}})},function(t,e,n){var o=n(0),r=n(88);r&&o(o.S,"Reflect",{setPrototypeOf:function(t,e){r.check(t,e);try{return r.set(t,e),!0}catch(t){return!1}}})},function(t,e,n){n(330),t.exports=n(17).Array.includes},function(t,e,n){"use strict";var o=n(0),r=n(69)(!0);o(o.P,"Array",{includes:function(t){return r(this,t,arguments.length>1?arguments[1]:void 0)}}),n(50)("includes")},function(t,e,n){n(332),t.exports=n(17).Array.flatMap},function(t,e,n){"use strict";var o=n(0),r=n(333),i=n(20),a=n(16),s=n(31),c=n(125);o(o.P,"Array",{flatMap:function(t){var e,n,o=i(this);return s(t),e=a(o.length),n=c(o,0),r(n,o,o,e,0,1,t,arguments[1]),n}}),n(50)("flatMap")},function(t,e,n){"use strict";var o=n(71),r=n(12),i=n(16),a=n(30),s=n(14)("isConcatSpreadable");t.exports=function t(e,n,c,l,u,f,d,p){for(var h,v,y=u,g=0,b=!!d&&a(d,p,3);g<l;){if(g in c){if(h=b?b(c[g],g,n):c[g],v=!1,r(h)&&(v=void 0!==(v=h[s])?!!v:o(h)),v&&f>0)y=t(e,n,h,i(h.length),y,f-1)-1;else{if(y>=9007199254740991)throw TypeError();e[y]=h}y++}g++}return y}},function(t,e,n){n(335),t.exports=n(17).String.padStart},function(t,e,n){"use strict";var o=n(0),r=n(138),i=n(77),a=/Version\/10\.\d+(\.\d+)?( Mobile\/\w+)? Safari\//.test(i);o(o.P+o.F*a,"String",{padStart:function(t){return r(this,t,arguments.length>1?arguments[1]:void 0,!0)}})},function(t,e,n){n(337),t.exports=n(17).String.padEnd},function(t,e,n){"use strict";var o=n(0),r=n(138),i=n(77),a=/Version\/10\.\d+(\.\d+)?( Mobile\/\w+)? Safari\//.test(i);o(o.P+o.F*a,"String",{padEnd:function(t){return r(this,t,arguments.length>1?arguments[1]:void 0,!1)}})},function(t,e,n){n(339),t.exports=n(17).String.trimLeft},function(t,e,n){"use strict";n(54)("trimLeft",(function(t){return function(){return t(this,1)}}),"trimStart")},function(t,e,n){n(341),t.exports=n(17).String.trimRight},function(t,e,n){"use strict";n(54)("trimRight",(function(t){return function(){return t(this,2)}}),"trimEnd")},function(t,e,n){n(343),t.exports=n(84).f("asyncIterator")},function(t,e,n){n(110)("asyncIterator")},function(t,e,n){n(345),t.exports=n(17).Object.getOwnPropertyDescriptors},function(t,e,n){var o=n(0),r=n(137),i=n(28),a=n(33),s=n(100);o(o.S,"Object",{getOwnPropertyDescriptors:function(t){for(var e,n,o=i(t),c=a.f,l=r(o),u={},f=0;l.length>f;)void 0!==(n=c(o,e=l[f++]))&&s(u,e,n);return u}})},function(t,e,n){n(347),t.exports=n(17).Object.values},function(t,e,n){var o=n(0),r=n(139)(!1);o(o.S,"Object",{values:function(t){return r(t)}})},function(t,e,n){n(349),t.exports=n(17).Object.entries},function(t,e,n){var o=n(0),r=n(139)(!0);o(o.S,"Object",{entries:function(t){return r(t)}})},function(t,e,n){"use strict";n(131),n(351),t.exports=n(17).Promise.finally},function(t,e,n){"use strict";var o=n(0),r=n(17),i=n(9),a=n(65),s=n(133);o(o.P+o.R,"Promise",{finally:function(t){var e=a(this,r.Promise||i.Promise),n="function"==typeof t;return this.then(n?function(n){return s(e,t()).then((function(){return n}))}:t,n?function(n){return s(e,t()).then((function(){throw n}))}:t)}})},function(t,e,n){n(353),n(354),n(355),t.exports=n(17)},function(t,e,n){var o=n(9),r=n(0),i=n(77),a=[].slice,s=/MSIE .\./.test(i),c=function(t){return function(e,n){var o=arguments.length>2,r=!!o&&a.call(arguments,2);return t(o?function(){("function"==typeof e?e:Function(e)).apply(this,r)}:e,n)}};r(r.G+r.B+r.F*s,{setTimeout:c(o.setTimeout),setInterval:c(o.setInterval)})},function(t,e,n){var o=n(0),r=n(106);o(o.G+o.B,{setImmediate:r.set,clearImmediate:r.clear})},function(t,e,n){for(var o=n(103),r=n(45),i=n(23),a=n(9),s=n(27),c=n(55),l=n(14),u=l("iterator"),f=l("toStringTag"),d=c.Array,p={CSSRuleList:!0,CSSStyleDeclaration:!1,CSSValueList:!1,ClientRectList:!1,DOMRectList:!1,DOMStringList:!1,DOMTokenList:!0,DataTransferItemList:!1,FileList:!1,HTMLAllCollection:!1,HTMLCollection:!1,HTMLFormElement:!1,HTMLSelectElement:!1,MediaList:!0,MimeTypeArray:!1,NamedNodeMap:!1,NodeList:!0,PaintRequestList:!1,Plugin:!1,PluginArray:!1,SVGLengthList:!1,SVGNumberList:!1,SVGPathSegList:!1,SVGPointList:!1,SVGStringList:!1,SVGTransformList:!1,SourceBufferList:!1,StyleSheetList:!0,TextTrackCueList:!1,TextTrackList:!1,TouchList:!1},h=r(p),v=0;v<h.length;v++){var y,g=h[v],b=p[g],m=a[g],k=m&&m.prototype;if(k&&(k[u]||s(k,u,d),k[f]||s(k,f,g),c[g]=d,b))for(y in o)k[y]||i(k,y,o[y],!0)}},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(39),n(52),n(2),n(3),n(360),n(362),n(363),n(8)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f){"use strict";var d=n(13),p=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=p(r),i=p(i),a=p(a),s=p(s),u=p(u),f=d(f);var h=function(){function t(e){var n=this;(0,a.default)(this,t);var o=function(){};"object"===(0,i.default)(e)&&f.isFunction(e.onReady)&&(o=e.onReady);var r=new u.default(e);this.isReady=r.isReady.then((function(){n.exportAPI(r),o()}))}return(0,s.default)(t,[{key:"exportAPI",value:function(t){var e=this;["configuration"].forEach((function(n){e[n]=t[n]})),this.destroy=function(){for(var n in Object.values(t.moduleInstances).forEach((function(t){f.isFunction(t.destroy)&&t.destroy()})),t=null,e)Object.prototype.hasOwnProperty.call(e,n)&&delete e[n];Object.setPrototypeOf(e,null)},Object.setPrototypeOf(this,t.moduleInstances.API.methods),delete this.exportAPI,Object.entries({blocks:{clear:"clear",render:"render"},caret:{focus:"focus"},events:{on:"on",off:"off",emit:"emit"},saver:{save:"save"}}).forEach((function(n){var o=(0,r.default)(n,2),i=o[0],a=o[1];Object.entries(a).forEach((function(n){var o=(0,r.default)(n,2),a=o[0],s=o[1];e[s]=t.moduleInstances.API.methods[i][a]}))}))}}],[{key:"version",get:function(){return"2.19.0"}}]),t}();o.default=h,h.displayName="EditorJS",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e){t.exports=function(t){if(Array.isArray(t))return t}},function(t,e){t.exports=function(t,e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(t)){var n=[],o=!0,r=!1,i=void 0;try{for(var a,s=t[Symbol.iterator]();!(o=(a=s.next()).done)&&(n.push(a.value),!e||n.length!==e);o=!0);}catch(t){r=!0,i=t}finally{try{o||null==s.return||s.return()}finally{if(r)throw i}}return n}}},function(t,e){t.exports=function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}},function(t,e,n){(e=t.exports=function(...t){return r(...t)}).__esModule=!0;const o=n(361),r=o.default;Object.assign(e,o)},function(t,e,n){"use strict";Object.defineProperty(e,"__esModule",{value:!0}),e.default=function(){},e.revert=function(){}},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[],void 0===(i="function"==typeof(o=function(){"use strict";Element.prototype.matches||(Element.prototype.matches=Element.prototype.matchesSelector||Element.prototype.mozMatchesSelector||Element.prototype.msMatchesSelector||Element.prototype.oMatchesSelector||Element.prototype.webkitMatchesSelector||function(t){for(var e=(this.document||this.ownerDocument).querySelectorAll(t),n=e.length;--n>=0&&e.item(n)!==this;);return n>-1}),Element.prototype.closest||(Element.prototype.closest=function(t){var e=this;if(!document.documentElement.contains(e))return null;do{if(e.matches(t))return e;e=e.parentElement||e.parentNode}while(null!==e);return null}),Element.prototype.prepend||(Element.prototype.prepend=function(t){var e=document.createDocumentFragment();Array.isArray(t)||(t=[t]),t.forEach((function(t){var n=t instanceof Node;e.appendChild(n?t:document.createTextNode(t))})),this.insertBefore(e,this.firstChild)})})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(52),n(21),n(22),n(2),n(3),n(15),n(8),n(59),n(144)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c,l,u,f,d){"use strict";var p=n(13),h=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=h(r),i=h(i),a=h(a),s=h(s),c=h(c),l=h(l),u=p(u),f=h(f);var v=n(373),y=[];v.keys().forEach((function(t){t.match(/^\.\/[^_][\w/]*\.([tj])s$/)&&y.push(v(t))}));var g=function(){function t(e){var n,o,r=this;(0,s.default)(this,t),this.moduleInstances={},this.isReady=new Promise((function(t,e){n=t,o=e})),Promise.resolve().then((0,a.default)(i.default.mark((function t(){return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return r.configuration=e,t.next=3,r.validate();case 3:return t.next=5,r.init();case 5:return t.next=7,r.start();case 7:u.logLabeled("I'm ready! (ﾉ◕ヮ◕)ﾉ*:･ﾟ✧","log","","color: #E24A75"),setTimeout((0,a.default)(i.default.mark((function t(){var e,o,a;return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,r.render();case 2:r.configuration.autofocus&&(e=r.moduleInstances,o=e.BlockManager,(a=e.Caret).setToBlock(o.blocks[0],a.positions.START),o.highlightCurrentNode()),r.moduleInstances.UI.removeLoader(),n();case 5:case"end":return t.stop()}}),t)}))),500);case 9:case"end":return t.stop()}}),t)})))).catch((function(t){u.log("Editor.js is not ready because of ".concat(t),"error"),o(t)}))}var e,n;return(0,c.default)(t,[{key:"validate",value:(n=(0,a.default)(i.default.mark((function t(){var e,n,o;return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:if(e=this.config,n=e.holderId,o=e.holder,!n||!o){t.next=3;break}throw Error("«holderId» and «holder» param can't assign at the same time.");case 3:if("string"!=typeof o||l.default.get(o)){t.next=5;break}throw Error("element with ID «".concat(o,"» is missing. Pass correct holder's ID."));case 5:if(!o||"object"!==(0,r.default)(o)||l.default.isElement(o)){t.next=7;break}throw Error("holder as HTMLElement if provided must be inherit from Element class.");case 7:case"end":return t.stop()}}),t,this)}))),function(){return n.apply(this,arguments)})},{key:"init",value:function(){this.constructModules(),this.configureModules()}},{key:"start",value:(e=(0,a.default)(i.default.mark((function t(){var e,n=this;return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return e=["Tools","UI","BlockManager","Paste","BlockSelection","RectangleSelection","CrossBlockSelection","ReadOnly"],t.next=3,e.reduce((function(t,e){return t.then((0,a.default)(i.default.mark((function t(){return i.default.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return t.prev=0,t.next=3,n.moduleInstances[e].prepare();case 3:t.next=10;break;case 5:if(t.prev=5,t.t0=t.catch(0),!(t.t0 instanceof d.CriticalError)){t.next=9;break}throw new Error(t.t0.message);case 9:u.log("Module ".concat(e," was skipped because of %o"),"warn",t.t0);case 10:case"end":return t.stop()}}),t,null,[[0,5]])}))))}),Promise.resolve());case 3:case"end":return t.stop()}}),t)}))),function(){return e.apply(this,arguments)})},{key:"render",value:function(){return this.moduleInstances.Renderer.render(this.config.data.blocks)}},{key:"constructModules",value:function(){var t=this;y.forEach((function(e){var n=u.isFunction(e)?e:e.default;try{t.moduleInstances[n.displayName]=new n({config:t.configuration})}catch(t){u.log("Module ".concat(n.displayName," skipped because"),"warn",t)}}))}},{key:"configureModules",value:function(){for(var t in this.moduleInstances)Object.prototype.hasOwnProperty.call(this.moduleInstances,t)&&(this.moduleInstances[t].state=this.getModulesDiff(t))}},{key:"getModulesDiff",value:function(t){var e={};for(var n in this.moduleInstances)n!==t&&(e[n]=this.moduleInstances[n]);return e}},{key:"configuration",set:function(t){var e,n;"object"!==(0,r.default)(t)&&(t={holder:t}),u.deprecationAssert(!!t.holderId,"config.holderId","config.holder"),t.holderId&&!t.holder&&(t.holder=t.holderId,t.holderId=null),this.config=t,null==this.config.holder&&(this.config.holder="editorjs"),this.config.logLevel||(this.config.logLevel=u.LogLevels.VERBOSE),u.setLogLevel(this.config.logLevel),u.deprecationAssert(Boolean(this.config.initialBlock),"config.initialBlock","config.defaultBlock"),this.config.defaultBlock=this.config.defaultBlock||this.config.initialBlock||"paragraph",this.config.minHeight=void 0!==this.config.minHeight?this.config.minHeight:300;var o={type:this.config.defaultBlock,data:{}};this.config.placeholder=this.config.placeholder||!1,this.config.sanitizer=this.config.sanitizer||{p:!0,b:!0,a:!0},this.config.hideToolbar=!!this.config.hideToolbar&&this.config.hideToolbar,this.config.tools=this.config.tools||{},this.config.i18n=this.config.i18n||{},this.config.data=this.config.data||{},this.config.onReady=this.config.onReady||function(){},this.config.onChange=this.config.onChange||function(){},this.config.inlineToolbar=void 0===this.config.inlineToolbar||this.config.inlineToolbar,u.isEmpty(this.config.data)?(this.config.data={},this.config.data.blocks=[o]):this.config.data.blocks&&0!==this.config.data.blocks.length||(this.config.data.blocks=[o]),this.config.readOnly=this.config.readOnly||!1,(null===(e=t.i18n)||void 0===e?void 0:e.messages)&&f.default.setDictionary(t.i18n.messages),this.config.i18n.direction=(null===(n=t.i18n)||void 0===n?void 0:n.direction)||"ltr"},get:function(){return this.config}}]),t}();o.default=g,g.displayName="Core",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o=n(142);t.exports=function(t){if(Array.isArray(t))return o(t)}},function(t,e){t.exports=function(t){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(t))return Array.from(t)}},function(t,e){t.exports=function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}},function(t,e){t.exports=function(t,e,n){return e in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t}},function(t,e){t.exports=function(t){if(void 0===t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return t}},function(t,e,n){var o=n(4),r=n(108),i=n(370),a=n(371);function s(e){var n="function"==typeof Map?new Map:void 0;return t.exports=s=function(t){if(null===t||!i(t))return t;if("function"!=typeof t)throw new TypeError("Super expression must either be null or a function");if(void 0!==n){if(n.has(t))return n.get(t);n.set(t,e)}function e(){return a(t,arguments,o(this).constructor)}return e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),r(e,t)},s(e)}t.exports=s},function(t,e){t.exports=function(t){return-1!==Function.toString.call(t).indexOf("[native code]")}},function(t,e,n){var o=n(108),r=n(372);function i(e,n,a){return r()?t.exports=i=Reflect.construct:t.exports=i=function(t,e,n){var r=[null];r.push.apply(r,e);var i=new(Function.bind.apply(t,r));return n&&o(i,n.prototype),i},i.apply(null,arguments)}t.exports=i},function(t,e){t.exports=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(t){return!1}}},function(t,e,n){var o={"./api":80,"./api/":80,"./api/blocks":145,"./api/blocks.ts":145,"./api/caret":147,"./api/caret.ts":147,"./api/events":148,"./api/events.ts":148,"./api/i18n":149,"./api/i18n.ts":149,"./api/index":80,"./api/index.ts":80,"./api/inlineToolbar":150,"./api/inlineToolbar.ts":150,"./api/listeners":151,"./api/listeners.ts":151,"./api/notifier":152,"./api/notifier.ts":152,"./api/readonly":153,"./api/readonly.ts":153,"./api/sanitizer":154,"./api/sanitizer.ts":154,"./api/saver":155,"./api/saver.ts":155,"./api/selection":156,"./api/selection.ts":156,"./api/styles":157,"./api/styles.ts":157,"./api/toolbar":158,"./api/toolbar.ts":158,"./api/tooltip":159,"./api/tooltip.ts":159,"./blockEvents":160,"./blockEvents.ts":160,"./blockManager":161,"./blockManager.ts":161,"./blockSelection":162,"./blockSelection.ts":162,"./caret":163,"./caret.ts":163,"./crossBlockSelection":164,"./crossBlockSelection.ts":164,"./dragNDrop":165,"./dragNDrop.ts":165,"./events":166,"./events.ts":166,"./listeners":167,"./listeners.ts":167,"./modificationsObserver":168,"./modificationsObserver.ts":168,"./notifier":169,"./notifier.ts":169,"./paste":170,"./paste.ts":170,"./readonly":171,"./readonly.ts":171,"./rectangleSelection":172,"./rectangleSelection.ts":172,"./renderer":173,"./renderer.ts":173,"./sanitizer":174,"./sanitizer.ts":174,"./saver":175,"./saver.ts":175,"./shortcuts":176,"./shortcuts.ts":176,"./toolbar":81,"./toolbar/":81,"./toolbar/blockSettings":177,"./toolbar/blockSettings.ts":177,"./toolbar/conversion":178,"./toolbar/conversion.ts":178,"./toolbar/index":81,"./toolbar/index.ts":81,"./toolbar/inline":179,"./toolbar/inline.ts":179,"./toolbar/toolbox":180,"./toolbar/toolbox.ts":180,"./tools":67,"./tools.ts":67,"./tooltip":181,"./tooltip.ts":181,"./ui":182,"./ui.ts":182};function r(t){var e=i(t);return n(e)}function i(t){if(!n.o(o,t)){var e=new Error("Cannot find module '"+t+"'");throw e.code="MODULE_NOT_FOUND",e}return o[t]}r.keys=function(){return Object.keys(o)},r.resolve=i,t.exports=r,r.id=373},function(t,e,n){window,t.exports=function(t){var e={};function n(o){if(e[o])return e[o].exports;var r=e[o]={i:o,l:!1,exports:{}};return t[o].call(r.exports,r,r.exports,n),r.l=!0,r.exports}return n.m=t,n.c=e,n.d=function(t,e,o){n.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:o})},n.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var o=Object.create(null);if(n.r(o),Object.defineProperty(o,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var r in t)n.d(o,r,function(e){return t[e]}.bind(null,r));return o},n.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return n.d(e,"a",e),e},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.p="/",n(n.s=0)}([function(t,e,n){function o(t,e){for(var n=0;n<e.length;n++){var o=e[n];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(t,o.key,o)}}function r(t,e,n){return e&&o(t.prototype,e),n&&o(t,n),t}n(1).toString();var i=function(){function t(e){var n=e.data,o=e.config,r=e.api,i=e.readOnly;!function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}(this,t),this.api=r,this.readOnly=i,this._CSS={block:this.api.styles.block,wrapper:"ce-paragraph"},this.readOnly||(this.onKeyUp=this.onKeyUp.bind(this)),this._placeholder=o.placeholder?o.placeholder:t.DEFAULT_PLACEHOLDER,this._data={},this._element=this.drawView(),this._preserveBlank=void 0!==o.preserveBlank&&o.preserveBlank,this.data=n}return r(t,null,[{key:"DEFAULT_PLACEHOLDER",get:function(){return""}}]),r(t,[{key:"onKeyUp",value:function(t){"Backspace"!==t.code&&"Delete"!==t.code||""===this._element.textContent&&(this._element.innerHTML="")}},{key:"drawView",value:function(){var t=document.createElement("DIV");return t.classList.add(this._CSS.wrapper,this._CSS.block),t.contentEditable=!1,t.dataset.placeholder=this.api.i18n.t(this._placeholder),this.readOnly||(t.contentEditable=!0,t.addEventListener("keyup",this.onKeyUp)),t}},{key:"render",value:function(){return this._element}},{key:"merge",value:function(t){var e={text:this.data.text+t.text};this.data=e}},{key:"validate",value:function(t){return!(""===t.text.trim()&&!this._preserveBlank)}},{key:"save",value:function(t){return{text:t.innerHTML}}},{key:"onPaste",value:function(t){var e={text:t.detail.data.innerHTML};this.data=e}},{key:"data",get:function(){var t=this._element.innerHTML;return this._data.text=t,this._data},set:function(t){this._data=t||{},this._element.innerHTML=this._data.text||""}}],[{key:"conversionConfig",get:function(){return{export:"text",import:"text"}}},{key:"sanitize",get:function(){return{text:{br:!0}}}},{key:"isReadOnlySupported",get:function(){return!0}},{key:"pasteConfig",get:function(){return{tags:["P"]}}},{key:"toolbox",get:function(){return{icon:n(5).default,title:"Text"}}}]),t}();t.exports=i},function(t,e,n){var o=n(2),r=n(3);"string"==typeof(r=r.__esModule?r.default:r)&&(r=[[t.i,r,""]]),o(r,{insert:"head",singleton:!1}),t.exports=r.locals||{}},function(t,e,n){"use strict";var o,r=function(){var t={};return function(e){if(void 0===t[e]){var n=document.querySelector(e);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(t){n=null}t[e]=n}return t[e]}}(),i=[];function a(t){for(var e=-1,n=0;n<i.length;n++)if(i[n].identifier===t){e=n;break}return e}function s(t,e){for(var n={},o=[],r=0;r<t.length;r++){var s=t[r],c=e.base?s[0]+e.base:s[0],l=n[c]||0,u="".concat(c," ").concat(l);n[c]=l+1;var f=a(u),d={css:s[1],media:s[2],sourceMap:s[3]};-1!==f?(i[f].references++,i[f].updater(d)):i.push({identifier:u,updater:v(d,e),references:1}),o.push(u)}return o}function c(t){var e=document.createElement("style"),o=t.attributes||{};if(void 0===o.nonce){var i=n.nc;i&&(o.nonce=i)}if(Object.keys(o).forEach((function(t){e.setAttribute(t,o[t])})),"function"==typeof t.insert)t.insert(e);else{var a=r(t.insert||"head");if(!a)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");a.appendChild(e)}return e}var l,u=(l=[],function(t,e){return l[t]=e,l.filter(Boolean).join("\n")});function f(t,e,n,o){var r=n?"":o.media?"@media ".concat(o.media," {").concat(o.css,"}"):o.css;if(t.styleSheet)t.styleSheet.cssText=u(e,r);else{var i=document.createTextNode(r),a=t.childNodes;a[e]&&t.removeChild(a[e]),a.length?t.insertBefore(i,a[e]):t.appendChild(i)}}function d(t,e,n){var o=n.css,r=n.media,i=n.sourceMap;if(r?t.setAttribute("media",r):t.removeAttribute("media"),i&&btoa&&(o+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(i))))," */")),t.styleSheet)t.styleSheet.cssText=o;else{for(;t.firstChild;)t.removeChild(t.firstChild);t.appendChild(document.createTextNode(o))}}var p=null,h=0;function v(t,e){var n,o,r;if(e.singleton){var i=h++;n=p||(p=c(e)),o=f.bind(null,n,i,!1),r=f.bind(null,n,i,!0)}else n=c(e),o=d.bind(null,n,e),r=function(){!function(t){if(null===t.parentNode)return!1;t.parentNode.removeChild(t)}(n)};return o(t),function(e){if(e){if(e.css===t.css&&e.media===t.media&&e.sourceMap===t.sourceMap)return;o(t=e)}else r()}}t.exports=function(t,e){(e=e||{}).singleton||"boolean"==typeof e.singleton||(e.singleton=(void 0===o&&(o=Boolean(window&&document&&document.all&&!window.atob)),o));var n=s(t=t||[],e);return function(t){if(t=t||[],"[object Array]"===Object.prototype.toString.call(t)){for(var o=0;o<n.length;o++){var r=a(n[o]);i[r].references--}for(var c=s(t,e),l=0;l<n.length;l++){var u=a(n[l]);0===i[u].references&&(i[u].updater(),i.splice(u,1))}n=c}}}},function(t,e,n){(e=n(4)(!1)).push([t.i,".ce-paragraph {\n    line-height: 1.6em;\n    outline: none;\n}\n\n.ce-paragraph[data-placeholder]:empty::before{\n  content: attr(data-placeholder);\n  color: #707684;\n  font-weight: normal;\n  opacity: 0;\n}\n\n/** Show placeholder at the first paragraph if Editor is empty */\n.codex-editor--empty .ce-block:first-child .ce-paragraph[data-placeholder]:empty::before {\n  opacity: 1;\n}\n\n.codex-editor--toolbox-opened .ce-block:first-child .ce-paragraph[data-placeholder]:empty::before,\n.codex-editor--empty .ce-block:first-child .ce-paragraph[data-placeholder]:empty:focus::before {\n  opacity: 0;\n}\n\n.ce-paragraph p:first-of-type{\n    margin-top: 0;\n}\n\n.ce-paragraph p:last-of-type{\n    margin-bottom: 0;\n}\n",""]),t.exports=e},function(t,e,n){"use strict";t.exports=function(t){var e=[];return e.toString=function(){return this.map((function(e){var n=function(t,e){var n,o,r,i=t[1]||"",a=t[3];if(!a)return i;if(e&&"function"==typeof btoa){var s=(n=a,o=btoa(unescape(encodeURIComponent(JSON.stringify(n)))),r="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(o),"/*# ".concat(r," */")),c=a.sources.map((function(t){return"/*# sourceURL=".concat(a.sourceRoot||"").concat(t," */")}));return[i].concat(c).concat([s]).join("\n")}return[i].join("\n")}(e,t);return e[2]?"@media ".concat(e[2]," {").concat(n,"}"):n})).join("")},e.i=function(t,n,o){"string"==typeof t&&(t=[[null,t,""]]);var r={};if(o)for(var i=0;i<this.length;i++){var a=this[i][0];null!=a&&(r[a]=!0)}for(var s=0;s<t.length;s++){var c=[].concat(t[s]);o&&r[c[0]]||(n&&(c[2]?c[2]="".concat(n," and ").concat(c[2]):c[2]=n),e.push(c))}},e}},function(t,e,n){"use strict";n.r(e),e.default='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0.2 -0.3 9 11.4" width="12" height="14">\n  <path d="M0 2.77V.92A1 1 0 01.2.28C.35.1.56 0 .83 0h7.66c.28.01.48.1.63.28.14.17.21.38.21.64v1.85c0 .26-.08.48-.23.66-.15.17-.37.26-.66.26-.28 0-.5-.09-.64-.26a1 1 0 01-.21-.66V1.69H5.6v7.58h.5c.25 0 .45.08.6.23.17.16.25.35.25.6s-.08.45-.24.6a.87.87 0 01-.62.22H3.21a.87.87 0 01-.61-.22.78.78 0 01-.24-.6c0-.25.08-.44.24-.6a.85.85 0 01.61-.23h.5V1.7H1.73v1.08c0 .26-.08.48-.23.66-.15.17-.37.26-.66.26-.28 0-.5-.09-.64-.26A1 1 0 010 2.77z"/>\n</svg>\n'}])},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(15)],void 0===(i="function"==typeof(o=function(o,r,i,a){"use strict";var s=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=s(r),i=s(i),a=s(a);var c=function(){function t(){(0,r.default)(this,t),this.commandName="bold",this.CSS={button:"ce-inline-tool",buttonActive:"ce-inline-tool--active",buttonModifier:"ce-inline-tool--bold"},this.nodes={button:void 0}}return(0,i.default)(t,[{key:"render",value:function(){return this.nodes.button=document.createElement("button"),this.nodes.button.type="button",this.nodes.button.classList.add(this.CSS.button,this.CSS.buttonModifier),this.nodes.button.appendChild(a.default.svg("bold",12,14)),this.nodes.button}},{key:"surround",value:function(t){document.execCommand(this.commandName)}},{key:"checkState",value:function(t){var e=document.queryCommandState(this.commandName);return this.nodes.button.classList.toggle(this.CSS.buttonActive,e),e}},{key:"shortcut",get:function(){return"CMD+B"}}],[{key:"sanitize",get:function(){return{b:{}}}}]),t}();o.default=c,c.displayName="BoldInlineTool",c.isInline=!0,c.title="Bold",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(15)],void 0===(i="function"==typeof(o=function(o,r,i,a){"use strict";var s=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=s(r),i=s(i),a=s(a);var c=function(){function t(){(0,r.default)(this,t),this.commandName="italic",this.CSS={button:"ce-inline-tool",buttonActive:"ce-inline-tool--active",buttonModifier:"ce-inline-tool--italic"},this.nodes={button:null}}return(0,i.default)(t,[{key:"render",value:function(){return this.nodes.button=document.createElement("button"),this.nodes.button.type="button",this.nodes.button.classList.add(this.CSS.button,this.CSS.buttonModifier),this.nodes.button.appendChild(a.default.svg("italic",4,11)),this.nodes.button}},{key:"surround",value:function(t){document.execCommand(this.commandName)}},{key:"checkState",value:function(t){var e=document.queryCommandState(this.commandName);return this.nodes.button.classList.toggle(this.CSS.buttonActive,e),e}},{key:"shortcut",get:function(){return"CMD+I"}}],[{key:"sanitize",get:function(){return{i:{}}}}]),t}();o.default=c,c.displayName="ItalicInlineTool",c.isInline=!0,c.title="Italic",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(25),n(15),n(8)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c){"use strict";var l=n(13),u=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=u(a),s=u(s),c=l(c);var f=function(){function t(e){var n=e.api;(0,r.default)(this,t),this.commandLink="createLink",this.commandUnlink="unlink",this.ENTER_KEY=13,this.CSS={button:"ce-inline-tool",buttonActive:"ce-inline-tool--active",buttonModifier:"ce-inline-tool--link",buttonUnlink:"ce-inline-tool--unlink",input:"ce-inline-tool-input",inputShowed:"ce-inline-tool-input--showed"},this.nodes={button:null,input:null},this.inputOpened=!1,this.toolbar=n.toolbar,this.inlineToolbar=n.inlineToolbar,this.notifier=n.notifier,this.i18n=n.i18n,this.selection=new a.default}return(0,i.default)(t,[{key:"render",value:function(){return this.nodes.button=document.createElement("button"),this.nodes.button.type="button",this.nodes.button.classList.add(this.CSS.button,this.CSS.buttonModifier),this.nodes.button.appendChild(s.default.svg("link",14,10)),this.nodes.button.appendChild(s.default.svg("unlink",15,11)),this.nodes.button}},{key:"renderActions",value:function(){var t=this;return this.nodes.input=document.createElement("input"),this.nodes.input.placeholder=this.i18n.t("Add a link"),this.nodes.input.classList.add(this.CSS.input),this.nodes.input.addEventListener("keydown",(function(e){e.keyCode===t.ENTER_KEY&&t.enterPressed(e)})),this.nodes.input}},{key:"surround",value:function(t){if(t){this.inputOpened?(this.selection.restore(),this.selection.removeFakeBackground()):(this.selection.setFakeBackground(),this.selection.save());var e=this.selection.findParentTag("A");if(e)return this.selection.expandToTag(e),this.unlink(),this.closeActions(),this.checkState(),void this.toolbar.close()}this.toggleActions()}},{key:"checkState",value:function(t){var e=this.selection.findParentTag("A");if(e){this.nodes.button.classList.add(this.CSS.buttonUnlink),this.nodes.button.classList.add(this.CSS.buttonActive),this.openActions();var n=e.getAttribute("href");this.nodes.input.value="null"!==n?n:"",this.selection.save()}else this.nodes.button.classList.remove(this.CSS.buttonUnlink),this.nodes.button.classList.remove(this.CSS.buttonActive);return!!e}},{key:"clear",value:function(){this.closeActions()}},{key:"toggleActions",value:function(){this.inputOpened?this.closeActions(!1):this.openActions(!0)}},{key:"openActions",value:function(){var t=arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.nodes.input.classList.add(this.CSS.inputShowed),t&&this.nodes.input.focus(),this.inputOpened=!0}},{key:"closeActions",value:function(){var t=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];if(this.selection.isFakeBackgroundEnabled){var e=new a.default;e.save(),this.selection.restore(),this.selection.removeFakeBackground(),e.restore()}this.nodes.input.classList.remove(this.CSS.inputShowed),this.nodes.input.value="",t&&this.selection.clearSaved(),this.inputOpened=!1}},{key:"enterPressed",value:function(t){var e=this.nodes.input.value||"";if(e.trim()||(this.selection.restore(),this.unlink(),t.preventDefault(),this.closeActions()),!this.validateURL(e))return this.notifier.show({message:"Pasted link is not valid.",style:"error"}),void c.log("Incorrect Link pasted","warn",e);e=this.prepareLink(e),this.selection.restore(),this.selection.removeFakeBackground(),this.insertLink(e),t.preventDefault(),t.stopPropagation(),t.stopImmediatePropagation(),this.selection.collapseToEnd(),this.inlineToolbar.close()}},{key:"validateURL",value:function(t){return!/\s/.test(t)}},{key:"prepareLink",value:function(t){return t=t.trim(),t=this.addProtocol(t)}},{key:"addProtocol",value:function(t){if(/^(\w+):(\/\/)?/.test(t))return t;var e=/^\/[^/\s]/.test(t),n="#"===t.substring(0,1),o=/^\/\/[^/\s]/.test(t);return e||n||o||(t="http://"+t),t}},{key:"insertLink",value:function(t){var e=this.selection.findParentTag("A");e&&this.selection.expandToTag(e),document.execCommand(this.commandLink,!1,t)}},{key:"unlink",value:function(){document.execCommand(this.commandUnlink)}},{key:"shortcut",get:function(){return"CMD+K"}}],[{key:"sanitize",get:function(){return{a:{href:!0,target:"_blank",rel:"nofollow"}}}}]),t}();o.default=f,f.displayName="LinkInlineTool",f.isInline=!0,f.title="Link",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(15)],void 0===(i="function"==typeof(o=function(o,r,i,a){"use strict";var s=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=s(r),i=s(i),a=s(a);var c=function(){function t(e){var n=e.data,o=e.api;(0,r.default)(this,t),this.CSS={wrapper:"ce-stub",info:"ce-stub__info",title:"ce-stub__title",subtitle:"ce-stub__subtitle"},this.api=o,this.title=n.title||this.api.i18n.t("Error"),this.subtitle=this.api.i18n.t("The block can not be displayed correctly."),this.savedData=n.savedData,this.wrapper=this.make()}return(0,i.default)(t,[{key:"render",value:function(){return this.wrapper}},{key:"save",value:function(){return this.savedData}},{key:"make",value:function(){var t=a.default.make("div",this.CSS.wrapper),e=a.default.svg("sad-face",52,52),n=a.default.make("div",this.CSS.info),o=a.default.make("div",this.CSS.title,{textContent:this.title}),r=a.default.make("div",this.CSS.subtitle,{textContent:this.subtitle});return t.appendChild(e),n.appendChild(o),n.appendChild(r),t.appendChild(n),t}}]),t}();o.default=c,c.displayName="Stub",c.isReadOnlySupported=!0,t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(15),n(8),n(25)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c){"use strict";var l=n(13),u=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=u(a),s=l(s),c=u(c);var f=function(){function t(e,n){(0,r.default)(this,t),this.cursor=-1,this.items=[],this.items=e||[],this.focusedCssClass=n}return(0,i.default)(t,[{key:"setItems",value:function(t){this.items=t}},{key:"next",value:function(){this.cursor=this.leafNodesAndReturnIndex(t.directions.RIGHT)}},{key:"previous",value:function(){this.cursor=this.leafNodesAndReturnIndex(t.directions.LEFT)}},{key:"dropCursor",value:function(){-1!==this.cursor&&(this.items[this.cursor].classList.remove(this.focusedCssClass),this.cursor=-1)}},{key:"leafNodesAndReturnIndex",value:function(e){var n=this;if(0===this.items.length)return this.cursor;var o=this.cursor;return-1===o?o=e===t.directions.RIGHT?-1:0:this.items[o].classList.remove(this.focusedCssClass),o=e===t.directions.RIGHT?(o+1)%this.items.length:(this.items.length+o-1)%this.items.length,a.default.canSetCaret(this.items[o])&&s.delay((function(){return c.default.setCursor(n.items[o])}),50)(),this.items[o].classList.add(this.focusedCssClass),o}},{key:"currentItem",get:function(){return-1===this.cursor?null:this.items[this.cursor]}}]),t}();o.default=f,f.displayName="DomIterator",f.directions={RIGHT:"right",LEFT:"left"},t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(15)],void 0===(i="function"==typeof(o=function(o,r,i,a){"use strict";var s=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=s(r),i=s(i),a=s(a);var c=function(){function t(e){var n=e.api;(0,r.default)(this,t),this.CSS={button:"ce-settings__button",wrapper:"ce-tune-move-up",animation:"wobble"},this.api=n}return(0,i.default)(t,[{key:"render",value:function(){var t=this,e=a.default.make("div",[this.CSS.button,this.CSS.wrapper],{});return e.appendChild(a.default.svg("arrow-up",14,14)),this.api.listeners.on(e,"click",(function(n){return t.handleClick(n,e)}),!1),this.api.tooltip.onHover(e,this.api.i18n.t("Move up")),e}},{key:"handleClick",value:function(t,e){var n=this,o=this.api.blocks.getCurrentBlockIndex(),r=this.api.blocks.getBlockByIndex(o),i=this.api.blocks.getBlockByIndex(o-1);if(0===o||!r||!i)return e.classList.add(this.CSS.animation),void window.setTimeout((function(){e.classList.remove(n.CSS.animation)}),500);var a,s=r.holder,c=i.holder,l=s.getBoundingClientRect(),u=c.getBoundingClientRect();a=u.top>0?Math.abs(l.top)-Math.abs(u.top):window.innerHeight-Math.abs(l.top)+Math.abs(u.top),window.scrollBy(0,-1*a),this.api.blocks.move(o-1),this.api.tooltip.hide()}}]),t}();o.default=c,c.displayName="MoveUpTune",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(15)],void 0===(i="function"==typeof(o=function(o,r,i,a){"use strict";var s=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=s(r),i=s(i),a=s(a);var c=function(){function t(e){var n=this,o=e.api;(0,r.default)(this,t),this.CSS={button:"ce-settings__button",buttonDelete:"ce-settings__button--delete",buttonConfirm:"ce-settings__button--confirm"},this.nodes={button:null},this.api=o,this.resetConfirmation=function(){n.setConfirmation(!1)}}return(0,i.default)(t,[{key:"render",value:function(){var t=this;return this.nodes.button=a.default.make("div",[this.CSS.button,this.CSS.buttonDelete],{}),this.nodes.button.appendChild(a.default.svg("cross",12,12)),this.api.listeners.on(this.nodes.button,"click",(function(e){return t.handleClick(e)}),!1),this.api.tooltip.onHover(this.nodes.button,this.api.i18n.t("Delete")),this.nodes.button}},{key:"handleClick",value:function(t){this.needConfirmation?(this.api.events.off("block-settings-closed",this.resetConfirmation),this.api.blocks.delete(),this.api.toolbar.close(),this.api.tooltip.hide(),t.stopPropagation()):(this.setConfirmation(!0),this.api.events.on("block-settings-closed",this.resetConfirmation))}},{key:"setConfirmation",value:function(t){this.needConfirmation=t,this.nodes.button.classList.add(this.CSS.buttonConfirm)}}]),t}();o.default=c,c.displayName="DeleteTune",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(15)],void 0===(i="function"==typeof(o=function(o,r,i,a){"use strict";var s=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=s(r),i=s(i),a=s(a);var c=function(){function t(e){var n=e.api;(0,r.default)(this,t),this.CSS={button:"ce-settings__button",wrapper:"ce-tune-move-down",animation:"wobble"},this.api=n}return(0,i.default)(t,[{key:"render",value:function(){var t=this,e=a.default.make("div",[this.CSS.button,this.CSS.wrapper],{});return e.appendChild(a.default.svg("arrow-down",14,14)),this.api.listeners.on(e,"click",(function(n){return t.handleClick(n,e)}),!1),this.api.tooltip.onHover(e,this.api.i18n.t("Move down")),e}},{key:"handleClick",value:function(t,e){var n=this,o=this.api.blocks.getCurrentBlockIndex(),r=this.api.blocks.getBlockByIndex(o+1);if(!r)return e.classList.add(this.CSS.animation),void window.setTimeout((function(){e.classList.remove(n.CSS.animation)}),500);var i=r.holder,a=i.getBoundingClientRect(),s=Math.abs(window.innerHeight-i.offsetHeight);a.top<window.innerHeight&&(s=window.scrollY+i.offsetHeight),window.scrollTo(0,s),this.api.blocks.move(o+1),this.api.tooltip.hide()}}]),t}();o.default=c,c.displayName="MoveDownTune",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){var o,r,i;"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self&&self,r=[e,n(2),n(3),n(8),n(15),n(61)],void 0===(i="function"==typeof(o=function(o,r,i,a,s,c){"use strict";var l=n(13),u=n(1);Object.defineProperty(o,"__esModule",{value:!0}),o.default=void 0,r=u(r),i=u(i),a=l(a),s=u(s);var f=function(){function t(e){(0,r.default)(this,t),this.blocks=[],this.workingArea=e}return(0,i.default)(t,[{key:"push",value:function(t){this.blocks.push(t),this.insertToDOM(t)}},{key:"swap",value:function(t,e){var n=this.blocks[e];s.default.swap(this.blocks[t].holder,n.holder),this.blocks[e]=this.blocks[t],this.blocks[t]=n}},{key:"move",value:function(t,e){var n=this.blocks.splice(e,1)[0],o=t-1,r=Math.max(0,o),i=this.blocks[r];t>0?this.insertToDOM(n,"afterend",i):this.insertToDOM(n,"beforebegin",i),this.blocks.splice(t,0,n);var a=this.composeBlockEvent("move",{fromIndex:e,toIndex:t});n.call(c.BlockToolAPI.MOVED,a)}},{key:"insert",value:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2];if(this.length){t>this.length&&(t=this.length),n&&(this.blocks[t].holder.remove(),this.blocks[t].call(c.BlockToolAPI.REMOVED));var o=n?1:0;if(this.blocks.splice(t,o,e),t>0){var r=this.blocks[t-1];this.insertToDOM(e,"afterend",r)}else{var i=this.blocks[t+1];i?this.insertToDOM(e,"beforebegin",i):this.insertToDOM(e)}}else this.push(e)}},{key:"remove",value:function(t){isNaN(t)&&(t=this.length-1),this.blocks[t].holder.remove(),this.blocks[t].call(c.BlockToolAPI.REMOVED),this.blocks.splice(t,1)}},{key:"removeAll",value:function(){this.workingArea.innerHTML="",this.blocks.forEach((function(t){return t.call(c.BlockToolAPI.REMOVED)})),this.blocks.length=0}},{key:"insertAfter",value:function(t,e){var n=this.blocks.indexOf(t);this.insert(n+1,e)}},{key:"get",value:function(t){return this.blocks[t]}},{key:"indexOf",value:function(t){return this.blocks.indexOf(t)}},{key:"insertToDOM",value:function(t,e,n){e?n.holder.insertAdjacentElement(e,t.holder):this.workingArea.appendChild(t.holder),t.call(c.BlockToolAPI.RENDERED)}},{key:"composeBlockEvent",value:function(t,e){return new CustomEvent(t,{detail:e})}},{key:"length",get:function(){return this.blocks.length}},{key:"array",get:function(){return this.blocks}},{key:"nodes",get:function(){return a.array(this.workingArea.children)}}],[{key:"set",value:function(t,e,n){return isNaN(Number(e))?(Reflect.set(t,e,n),!0):(t.insert(+e,n),!0)}},{key:"get",value:function(t,e){return isNaN(Number(e))?Reflect.get(t,e):t.get(+e)}}]),t}();o.default=f,f.displayName="Blocks",t.exports=e.default})?o.apply(e,r):o)||(t.exports=i)},function(t,e,n){window,t.exports=function(t){var e={};function n(o){if(e[o])return e[o].exports;var r=e[o]={i:o,l:!1,exports:{}};return t[o].call(r.exports,r,r.exports,n),r.l=!0,r.exports}return n.m=t,n.c=e,n.d=function(t,e,o){n.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:o})},n.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var o=Object.create(null);if(n.r(o),Object.defineProperty(o,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var r in t)n.d(o,r,function(e){return t[e]}.bind(null,r));return o},n.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return n.d(e,"a",e),e},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.p="/",n(n.s=0)}([function(t,e,n){"use strict";n(1),t.exports=function(){var t=n(6),e=null;return{show:function(n){if(n.message){!function(){if(e)return!0;e=t.getWrapper(),document.body.appendChild(e)}();var o=null,r=n.time||8e3;switch(n.type){case"confirm":o=t.confirm(n);break;case"prompt":o=t.prompt(n);break;default:o=t.alert(n),window.setTimeout((function(){o.remove()}),r)}e.appendChild(o),o.classList.add("cdx-notify--bounce-in")}}}}()},function(t,e,n){var o=n(2);"string"==typeof o&&(o=[[t.i,o,""]]),n(4)(o,{hmr:!0,transform:void 0,insertInto:void 0}),o.locals&&(t.exports=o.locals)},function(t,e,n){(t.exports=n(3)(!1)).push([t.i,'.cdx-notify--error{background:#fffbfb!important}.cdx-notify--error::before{background:#fb5d5d!important}.cdx-notify__input{max-width:130px;padding:5px 10px;background:#f7f7f7;border:0;border-radius:3px;font-size:13px;color:#656b7c;outline:0}.cdx-notify__input:-ms-input-placeholder{color:#656b7c}.cdx-notify__input::placeholder{color:#656b7c}.cdx-notify__input:focus:-ms-input-placeholder{color:rgba(101,107,124,.3)}.cdx-notify__input:focus::placeholder{color:rgba(101,107,124,.3)}.cdx-notify__button{border:none;border-radius:3px;font-size:13px;padding:5px 10px;cursor:pointer}.cdx-notify__button:last-child{margin-left:10px}.cdx-notify__button--cancel{background:#f2f5f7;box-shadow:0 2px 1px 0 rgba(16,19,29,0);color:#656b7c}.cdx-notify__button--cancel:hover{background:#eee}.cdx-notify__button--confirm{background:#34c992;box-shadow:0 1px 1px 0 rgba(18,49,35,.05);color:#fff}.cdx-notify__button--confirm:hover{background:#33b082}.cdx-notify__btns-wrapper{display:-ms-flexbox;display:flex;-ms-flex-flow:row nowrap;flex-flow:row nowrap;margin-top:5px}.cdx-notify__cross{position:absolute;top:5px;right:5px;width:10px;height:10px;padding:5px;opacity:.54;cursor:pointer}.cdx-notify__cross::after,.cdx-notify__cross::before{content:\'\';position:absolute;left:9px;top:5px;height:12px;width:2px;background:#575d67}.cdx-notify__cross::before{transform:rotate(-45deg)}.cdx-notify__cross::after{transform:rotate(45deg)}.cdx-notify__cross:hover{opacity:1}.cdx-notifies{position:fixed;z-index:2;bottom:20px;left:20px;font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Ubuntu,Cantarell,"Fira Sans","Droid Sans","Helvetica Neue",sans-serif}.cdx-notify{position:relative;width:220px;margin-top:15px;padding:13px 16px;background:#fff;box-shadow:0 11px 17px 0 rgba(23,32,61,.13);border-radius:5px;font-size:14px;line-height:1.4em;word-wrap:break-word}.cdx-notify::before{content:\'\';position:absolute;display:block;top:0;left:0;width:3px;height:calc(100% - 6px);margin:3px;border-radius:5px;background:0 0}@keyframes bounceIn{0%{opacity:0;transform:scale(.3)}50%{opacity:1;transform:scale(1.05)}70%{transform:scale(.9)}100%{transform:scale(1)}}.cdx-notify--bounce-in{animation-name:bounceIn;animation-duration:.6s;animation-iteration-count:1}.cdx-notify--success{background:#fafffe!important}.cdx-notify--success::before{background:#41ffb1!important}',""])},function(t,e){t.exports=function(t){var e=[];return e.toString=function(){return this.map((function(e){var n=function(t,e){var n,o=t[1]||"",r=t[3];if(!r)return o;if(e&&"function"==typeof btoa){var i=(n=r,"/*# sourceMappingURL=data:application/json;charset=utf-8;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(n))))+" */"),a=r.sources.map((function(t){return"/*# sourceURL="+r.sourceRoot+t+" */"}));return[o].concat(a).concat([i]).join("\n")}return[o].join("\n")}(e,t);return e[2]?"@media "+e[2]+"{"+n+"}":n})).join("")},e.i=function(t,n){"string"==typeof t&&(t=[[null,t,""]]);for(var o={},r=0;r<this.length;r++){var i=this[r][0];"number"==typeof i&&(o[i]=!0)}for(r=0;r<t.length;r++){var a=t[r];"number"==typeof a[0]&&o[a[0]]||(n&&!a[2]?a[2]=n:n&&(a[2]="("+a[2]+") and ("+n+")"),e.push(a))}},e}},function(t,e,n){var o,r,i={},a=(o=function(){return window&&document&&document.all&&!window.atob},function(){return void 0===r&&(r=o.apply(this,arguments)),r}),s=function(t){var e={};return function(t){if("function"==typeof t)return t();if(void 0===e[t]){var n=function(t){return document.querySelector(t)}.call(this,t);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(t){n=null}e[t]=n}return e[t]}}(),c=null,l=0,u=[],f=n(5);function d(t,e){for(var n=0;n<t.length;n++){var o=t[n],r=i[o.id];if(r){r.refs++;for(var a=0;a<r.parts.length;a++)r.parts[a](o.parts[a]);for(;a<o.parts.length;a++)r.parts.push(b(o.parts[a],e))}else{var s=[];for(a=0;a<o.parts.length;a++)s.push(b(o.parts[a],e));i[o.id]={id:o.id,refs:1,parts:s}}}}function p(t,e){for(var n=[],o={},r=0;r<t.length;r++){var i=t[r],a=e.base?i[0]+e.base:i[0],s={css:i[1],media:i[2],sourceMap:i[3]};o[a]?o[a].parts.push(s):n.push(o[a]={id:a,parts:[s]})}return n}function h(t,e){var n=s(t.insertInto);if(!n)throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");var o=u[u.length-1];if("top"===t.insertAt)o?o.nextSibling?n.insertBefore(e,o.nextSibling):n.appendChild(e):n.insertBefore(e,n.firstChild),u.push(e);else if("bottom"===t.insertAt)n.appendChild(e);else{if("object"!=typeof t.insertAt||!t.insertAt.before)throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");var r=s(t.insertInto+" "+t.insertAt.before);n.insertBefore(e,r)}}function v(t){if(null===t.parentNode)return!1;t.parentNode.removeChild(t);var e=u.indexOf(t);e>=0&&u.splice(e,1)}function y(t){var e=document.createElement("style");return void 0===t.attrs.type&&(t.attrs.type="text/css"),g(e,t.attrs),h(t,e),e}function g(t,e){Object.keys(e).forEach((function(n){t.setAttribute(n,e[n])}))}function b(t,e){var n,o,r,i;if(e.transform&&t.css){if(!(i=e.transform(t.css)))return function(){};t.css=i}if(e.singleton){var a=l++;n=c||(c=y(e)),o=x.bind(null,n,a,!1),r=x.bind(null,n,a,!0)}else t.sourceMap&&"function"==typeof URL&&"function"==typeof URL.createObjectURL&&"function"==typeof URL.revokeObjectURL&&"function"==typeof Blob&&"function"==typeof btoa?(n=function(t){var e=document.createElement("link");return void 0===t.attrs.type&&(t.attrs.type="text/css"),t.attrs.rel="stylesheet",g(e,t.attrs),h(t,e),e}(e),o=function(t,e,n){var o=n.css,r=n.sourceMap,i=void 0===e.convertToAbsoluteUrls&&r;(e.convertToAbsoluteUrls||i)&&(o=f(o)),r&&(o+="\n/*# sourceMappingURL=data:application/json;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(r))))+" */");var a=new Blob([o],{type:"text/css"}),s=t.href;t.href=URL.createObjectURL(a),s&&URL.revokeObjectURL(s)}.bind(null,n,e),r=function(){v(n),n.href&&URL.revokeObjectURL(n.href)}):(n=y(e),o=function(t,e){var n=e.css,o=e.media;if(o&&t.setAttribute("media",o),t.styleSheet)t.styleSheet.cssText=n;else{for(;t.firstChild;)t.removeChild(t.firstChild);t.appendChild(document.createTextNode(n))}}.bind(null,n),r=function(){v(n)});return o(t),function(e){if(e){if(e.css===t.css&&e.media===t.media&&e.sourceMap===t.sourceMap)return;o(t=e)}else r()}}t.exports=function(t,e){if("undefined"!=typeof DEBUG&&DEBUG&&"object"!=typeof document)throw new Error("The style-loader cannot be used in a non-browser environment");(e=e||{}).attrs="object"==typeof e.attrs?e.attrs:{},e.singleton||"boolean"==typeof e.singleton||(e.singleton=a()),e.insertInto||(e.insertInto="head"),e.insertAt||(e.insertAt="bottom");var n=p(t,e);return d(n,e),function(t){for(var o=[],r=0;r<n.length;r++){var a=n[r];(s=i[a.id]).refs--,o.push(s)}for(t&&d(p(t,e),e),r=0;r<o.length;r++){var s;if(0===(s=o[r]).refs){for(var c=0;c<s.parts.length;c++)s.parts[c]();delete i[s.id]}}}};var m,k=(m=[],function(t,e){return m[t]=e,m.filter(Boolean).join("\n")});function x(t,e,n,o){var r=n?"":o.css;if(t.styleSheet)t.styleSheet.cssText=k(e,r);else{var i=document.createTextNode(r),a=t.childNodes;a[e]&&t.removeChild(a[e]),a.length?t.insertBefore(i,a[e]):t.appendChild(i)}}},function(t,e){t.exports=function(t){var e="undefined"!=typeof window&&window.location;if(!e)throw new Error("fixUrls requires window.location");if(!t||"string"!=typeof t)return t;var n=e.protocol+"//"+e.host,o=n+e.pathname.replace(/\/[^\/]*$/,"/");return t.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi,(function(t,e){var r,i=e.trim().replace(/^"(.*)"$/,(function(t,e){return e})).replace(/^'(.*)'$/,(function(t,e){return e}));return/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/|\s*$)/i.test(i)?t:(r=0===i.indexOf("//")?i:0===i.indexOf("/")?n+i:o+i.replace(/^\.\//,""),"url("+JSON.stringify(r)+")")}))}},function(t,e,n){"use strict";var o,r,i,a,s,c;t.exports=(o="cdx-notify",r="cdx-notify__cross",i="cdx-notify__button--confirm",a="cdx-notify__button",s="cdx-notify__btns-wrapper",{alert:c=function(t){var e=document.createElement("DIV"),n=document.createElement("DIV"),i=t.message,a=t.style;return e.classList.add(o),a&&e.classList.add(o+"--"+a),e.innerHTML=i,n.classList.add(r),n.addEventListener("click",e.remove.bind(e)),e.appendChild(n),e},confirm:function(t){var e=c(t),n=document.createElement("div"),o=document.createElement("button"),l=document.createElement("button"),u=e.querySelector("."+r),f=t.cancelHandler,d=t.okHandler;return n.classList.add(s),o.innerHTML=t.okText||"Confirm",l.innerHTML=t.cancelText||"Cancel",o.classList.add(a),l.classList.add(a),o.classList.add(i),l.classList.add("cdx-notify__button--cancel"),f&&"function"==typeof f&&(l.addEventListener("click",f),u.addEventListener("click",f)),d&&"function"==typeof d&&o.addEventListener("click",d),o.addEventListener("click",e.remove.bind(e)),l.addEventListener("click",e.remove.bind(e)),n.appendChild(o),n.appendChild(l),e.appendChild(n),e},prompt:function(t){var e=c(t),n=document.createElement("div"),o=document.createElement("button"),l=document.createElement("input"),u=e.querySelector("."+r),f=t.cancelHandler,d=t.okHandler;return n.classList.add(s),o.innerHTML=t.okText||"Ok",o.classList.add(a),o.classList.add(i),l.classList.add("cdx-notify__input"),t.placeholder&&l.setAttribute("placeholder",t.placeholder),t.default&&(l.value=t.default),t.inputType&&(l.type=t.inputType),f&&"function"==typeof f&&u.addEventListener("click",f),d&&"function"==typeof d&&o.addEventListener("click",(function(){d(l.value)})),o.addEventListener("click",e.remove.bind(e)),n.appendChild(l),n.appendChild(o),e.appendChild(n),e},getWrapper:function(){var t=document.createElement("DIV");return t.classList.add("cdx-notifies"),t}})}])},function(t,e,n){var o,r;void 0===(r="function"==typeof(o=function(){function t(t){var e=t.tags;if(!Object.keys(e).map((function(t){return typeof e[t]})).every((function(t){return"object"===t||"boolean"===t||"function"===t})))throw new Error("The configuration was invalid");this.config=t}var e=["P","LI","TD","TH","DIV","H1","H2","H3","H4","H5","H6","PRE"];function n(t){return-1!==e.indexOf(t.nodeName)}var o=["A","B","STRONG","I","EM","SUB","SUP","U","STRIKE"];function r(t){return-1!==o.indexOf(t.nodeName)}function i(t,e,n){return"function"==typeof t.tags[e]?t.tags[e](n):t.tags[e]}function a(t,e){return void 0===e||"boolean"==typeof e&&!e}function s(t,e,n){var o=t.name.toLowerCase();return!0!==e&&("function"==typeof e[o]?!e[o](t.value,n):void 0===e[o]||!1===e[o]||"string"==typeof e[o]&&e[o]!==t.value)}return t.prototype.clean=function(t){const e=document.implementation.createHTMLDocument(),n=e.createElement("div");return n.innerHTML=t,this._sanitize(e,n),n.innerHTML},t.prototype._sanitize=function(t,e){var o=function(t,e){return t.createTreeWalker(e,NodeFilter.SHOW_TEXT|NodeFilter.SHOW_ELEMENT|NodeFilter.SHOW_COMMENT,null,!1)}(t,e),c=o.firstChild();if(c)do{if(c.nodeType!==Node.TEXT_NODE){if(c.nodeType===Node.COMMENT_NODE){e.removeChild(c),this._sanitize(t,e);break}var l,u=r(c);u&&(l=Array.prototype.some.call(c.childNodes,n));var f=!!e.parentNode,d=n(e)&&n(c)&&f,p=c.nodeName.toLowerCase(),h=i(this.config,p,c);if(u&&l||a(0,h)||!this.config.keepNestedBlockElements&&d){if("SCRIPT"!==c.nodeName&&"STYLE"!==c.nodeName)for(;c.childNodes.length>0;)e.insertBefore(c.childNodes[0],c);e.removeChild(c),this._sanitize(t,e);break}for(var v=0;v<c.attributes.length;v+=1){var y=c.attributes[v];s(y,h,c)&&(c.removeAttribute(y.name),v-=1)}this._sanitize(t,c)}else if(""===c.data.trim()&&(c.previousElementSibling&&n(c.previousElementSibling)||c.nextElementSibling&&n(c.nextElementSibling))){e.removeChild(c),this._sanitize(t,e);break}}while(c=o.nextSibling())},t})?o.call(e,n,e,t):o)||(t.exports=r)},function(t,e,n){window,t.exports=function(t){var e={};function n(o){if(e[o])return e[o].exports;var r=e[o]={i:o,l:!1,exports:{}};return t[o].call(r.exports,r,r.exports,n),r.l=!0,r.exports}return n.m=t,n.c=e,n.d=function(t,e,o){n.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:o})},n.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var o=Object.create(null);if(n.r(o),Object.defineProperty(o,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var r in t)n.d(o,r,function(e){return t[e]}.bind(null,r));return o},n.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return n.d(e,"a",e),e},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.p="",n(n.s=0)}([function(t,e,n){"use strict";function o(t,e){for(var n=0;n<e.length;n++){var o=e[n];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(t,o.key,o)}}function r(t,e,n){return e&&o(t.prototype,e),n&&o(t,n),t}n.r(e);var i=function(){function t(e){var n=this;!function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}(this,t),this.commands={},this.keys={},this.name=e.name,this.parseShortcutName(e.name),this.element=e.on,this.callback=e.callback,this.executeShortcut=function(t){n.execute(t)},this.element.addEventListener("keydown",this.executeShortcut,!1)}return r(t,null,[{key:"supportedCommands",get:function(){return{SHIFT:["SHIFT"],CMD:["CMD","CONTROL","COMMAND","WINDOWS","CTRL"],ALT:["ALT","OPTION"]}}},{key:"keyCodes",get:function(){return{0:48,1:49,2:50,3:51,4:52,5:53,6:54,7:55,8:56,9:57,A:65,B:66,C:67,D:68,E:69,F:70,G:71,H:72,I:73,J:74,K:75,L:76,M:77,N:78,O:79,P:80,Q:81,R:82,S:83,T:84,U:85,V:86,W:87,X:88,Y:89,Z:90,BACKSPACE:8,ENTER:13,ESCAPE:27,LEFT:37,UP:38,RIGHT:39,DOWN:40,INSERT:45,DELETE:46}}}]),r(t,[{key:"parseShortcutName",value:function(e){e=e.split("+");for(var n=0;n<e.length;n++){e[n]=e[n].toUpperCase();var o=!1;for(var r in t.supportedCommands)if(t.supportedCommands[r].includes(e[n])){o=this.commands[r]=!0;break}o||(this.keys[e[n]]=!0)}for(var i in t.supportedCommands)this.commands[i]||(this.commands[i]=!1)}},{key:"execute",value:function(e){var n,o={CMD:e.ctrlKey||e.metaKey,SHIFT:e.shiftKey,ALT:e.altKey},r=!0;for(n in this.commands)this.commands[n]!==o[n]&&(r=!1);var i,a=!0;for(i in this.keys)a=a&&e.keyCode===t.keyCodes[i];r&&a&&this.callback(e)}},{key:"remove",value:function(){this.element.removeEventListener("keydown",this.executeShortcut)}}]),t}();e.default=i}]).default},function(t,e,n){window,t.exports=function(t){var e={};function n(o){if(e[o])return e[o].exports;var r=e[o]={i:o,l:!1,exports:{}};return t[o].call(r.exports,r,r.exports,n),r.l=!0,r.exports}return n.m=t,n.c=e,n.d=function(t,e,o){n.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:o})},n.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var o=Object.create(null);if(n.r(o),Object.defineProperty(o,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var r in t)n.d(o,r,function(e){return t[e]}.bind(null,r));return o},n.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return n.d(e,"a",e),e},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.p="",n(n.s=0)}([function(t,e,n){t.exports=n(1)},function(t,e,n){"use strict";n.r(e),n.d(e,"default",(function(){return o}));class o{constructor(){this.nodes={wrapper:null,content:null},this.showed=!1,this.offsetTop=10,this.offsetLeft=10,this.offsetRight=10,this.hidingDelay=0,this.loadStyles(),this.prepare(),window.addEventListener("scroll",()=>{this.showed&&this.hide(!0)},{passive:!0})}get CSS(){return{tooltip:"ct",tooltipContent:"ct__content",tooltipShown:"ct--shown",placement:{left:"ct--left",bottom:"ct--bottom",right:"ct--right",top:"ct--top"}}}show(t,e,n){this.nodes.wrapper||this.prepare(),this.hidingTimeout&&clearTimeout(this.hidingTimeout);const o=Object.assign({placement:"bottom",marginTop:0,marginLeft:0,marginRight:0,marginBottom:0,delay:70,hidingDelay:0},n);if(o.hidingDelay&&(this.hidingDelay=o.hidingDelay),this.nodes.content.innerHTML="","string"==typeof e)this.nodes.content.appendChild(document.createTextNode(e));else{if(!(e instanceof Node))throw Error("[CodeX Tooltip] Wrong type of «content» passed. It should be an instance of Node or String. But "+typeof e+" given.");this.nodes.content.appendChild(e)}switch(this.nodes.wrapper.classList.remove(...Object.values(this.CSS.placement)),o.placement){case"top":this.placeTop(t,o);break;case"left":this.placeLeft(t,o);break;case"right":this.placeRight(t,o);break;case"bottom":default:this.placeBottom(t,o)}o&&o.delay?this.showingTimeout=setTimeout(()=>{this.nodes.wrapper.classList.add(this.CSS.tooltipShown),this.showed=!0},o.delay):(this.nodes.wrapper.classList.add(this.CSS.tooltipShown),this.showed=!0)}hide(t=!1){if(this.hidingDelay&&!t)return this.hidingTimeout&&clearTimeout(this.hidingTimeout),void(this.hidingTimeout=setTimeout(()=>{this.hide(!0)},this.hidingDelay));this.nodes.wrapper.classList.remove(this.CSS.tooltipShown),this.showed=!1,this.showingTimeout&&clearTimeout(this.showingTimeout)}onHover(t,e,n){t.addEventListener("mouseenter",()=>{this.show(t,e,n)}),t.addEventListener("mouseleave",()=>{this.hide()})}prepare(){this.nodes.wrapper=this.make("div",this.CSS.tooltip),this.nodes.content=this.make("div",this.CSS.tooltipContent),this.append(this.nodes.wrapper,this.nodes.content),this.append(document.body,this.nodes.wrapper)}loadStyles(){const t="codex-tooltips-style";if(document.getElementById(t))return;const e=n(2),o=this.make("style",null,{textContent:e.toString(),id:t});this.prepend(document.head,o)}placeBottom(t,e){const n=t.getBoundingClientRect(),o=n.left+t.clientWidth/2-this.nodes.wrapper.offsetWidth/2,r=n.bottom+window.pageYOffset+this.offsetTop+e.marginTop;this.applyPlacement("bottom",o,r)}placeTop(t,e){const n=t.getBoundingClientRect(),o=n.left+t.clientWidth/2-this.nodes.wrapper.offsetWidth/2,r=n.top+window.pageYOffset-this.nodes.wrapper.clientHeight-this.offsetTop;this.applyPlacement("top",o,r)}placeLeft(t,e){const n=t.getBoundingClientRect(),o=n.left-this.nodes.wrapper.offsetWidth-this.offsetLeft-e.marginLeft,r=n.top+window.pageYOffset+t.clientHeight/2-this.nodes.wrapper.offsetHeight/2;this.applyPlacement("left",o,r)}placeRight(t,e){const n=t.getBoundingClientRect(),o=n.right+this.offsetRight+e.marginRight,r=n.top+window.pageYOffset+t.clientHeight/2-this.nodes.wrapper.offsetHeight/2;this.applyPlacement("right",o,r)}applyPlacement(t,e,n){this.nodes.wrapper.classList.add(this.CSS.placement[t]),this.nodes.wrapper.style.left=e+"px",this.nodes.wrapper.style.top=n+"px"}make(t,e=null,n={}){const o=document.createElement(t);Array.isArray(e)?o.classList.add(...e):e&&o.classList.add(e);for(const t in n)n.hasOwnProperty(t)&&(o[t]=n[t]);return o}append(t,e){Array.isArray(e)?e.forEach(e=>t.appendChild(e)):t.appendChild(e)}prepend(t,e){Array.isArray(e)?(e=e.reverse()).forEach(e=>t.prepend(e)):t.prepend(e)}}},function(t,e){t.exports='.ct{z-index:999;opacity:0;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;pointer-events:none;-webkit-transition:opacity 50ms ease-in,-webkit-transform 70ms cubic-bezier(.215,.61,.355,1);transition:opacity 50ms ease-in,-webkit-transform 70ms cubic-bezier(.215,.61,.355,1);transition:opacity 50ms ease-in,transform 70ms cubic-bezier(.215,.61,.355,1);transition:opacity 50ms ease-in,transform 70ms cubic-bezier(.215,.61,.355,1),-webkit-transform 70ms cubic-bezier(.215,.61,.355,1);will-change:opacity,top,left;-webkit-box-shadow:0 8px 12px 0 rgba(29,32,43,.17),0 4px 5px -3px rgba(5,6,12,.49);box-shadow:0 8px 12px 0 rgba(29,32,43,.17),0 4px 5px -3px rgba(5,6,12,.49);border-radius:9px}.ct,.ct:before{position:absolute;top:0;left:0}.ct:before{content:"";bottom:0;right:0;background-color:#1d202b;z-index:-1;border-radius:4px}@supports(-webkit-mask-box-image:url("")){.ct:before{border-radius:0;-webkit-mask-box-image:url(\'data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"><path d="M10.71 0h2.58c3.02 0 4.64.42 6.1 1.2a8.18 8.18 0 013.4 3.4C23.6 6.07 24 7.7 24 10.71v2.58c0 3.02-.42 4.64-1.2 6.1a8.18 8.18 0 01-3.4 3.4c-1.47.8-3.1 1.21-6.11 1.21H10.7c-3.02 0-4.64-.42-6.1-1.2a8.18 8.18 0 01-3.4-3.4C.4 17.93 0 16.3 0 13.29V10.7c0-3.02.42-4.64 1.2-6.1a8.18 8.18 0 013.4-3.4C6.07.4 7.7 0 10.71 0z"/></svg>\') 48% 41% 37.9% 53.3%}}@media (--mobile){.ct{display:none}}.ct__content{padding:6px 10px;color:#cdd1e0;font-size:12px;text-align:center;letter-spacing:.02em;line-height:1em}.ct:after{content:"";width:8px;height:8px;position:absolute;background-color:#1d202b;z-index:-1}.ct--bottom{-webkit-transform:translateY(5px);transform:translateY(5px)}.ct--bottom:after{top:-3px;left:50%;-webkit-transform:translateX(-50%) rotate(-45deg);transform:translateX(-50%) rotate(-45deg)}.ct--top{-webkit-transform:translateY(-5px);transform:translateY(-5px)}.ct--top:after{top:auto;bottom:-3px;left:50%;-webkit-transform:translateX(-50%) rotate(-45deg);transform:translateX(-50%) rotate(-45deg)}.ct--left{-webkit-transform:translateX(-5px);transform:translateX(-5px)}.ct--left:after{top:50%;left:auto;right:0;-webkit-transform:translate(41.6%,-50%) rotate(-45deg);transform:translate(41.6%,-50%) rotate(-45deg)}.ct--right{-webkit-transform:translateX(5px);transform:translateX(5px)}.ct--right:after{top:50%;left:0;-webkit-transform:translate(-41.6%,-50%) rotate(-45deg);transform:translate(-41.6%,-50%) rotate(-45deg)}.ct--shown{opacity:1;-webkit-transform:none;transform:none}'}]).default},function(t,e,n){"use strict";n.r(e),e.default='<?xml version="1.0" encoding="utf-8"?>\n<svg xmlns="http://www.w3.org/2000/svg">\n<symbol id="arrow-down" viewBox="0 0 14 14">\n  <path transform="matrix(1 0 0 -1 0 14)" d="M8.024 4.1v8.6a1.125 1.125 0 0 1-2.25 0V4.1L2.18 7.695A1.125 1.125 0 1 1 .59 6.104L6.103.588c.44-.439 1.151-.439 1.59 0l5.516 5.516a1.125 1.125 0 0 1-1.59 1.59L8.023 4.1z"/>\n\n</symbol>\n<symbol id="arrow-up" viewBox="0 0 14 14">\n    <path d="M8.024 4.1v8.6a1.125 1.125 0 0 1-2.25 0V4.1L2.18 7.695A1.125 1.125 0 1 1 .59 6.104L6.103.588c.44-.439 1.151-.439 1.59 0l5.516 5.516a1.125 1.125 0 0 1-1.59 1.59L8.023 4.1z"/>\n\n</symbol>\n<symbol id="bold" viewBox="0 0 12 14"><path d="M5.997 14H1.72c-.618 0-1.058-.138-1.323-.415C.132 13.308 0 12.867 0 12.262V1.738C0 1.121.135.676.406.406.676.136 1.114 0 1.719 0h4.536c.669 0 1.248.041 1.738.124.49.083.93.242 1.318.478a3.458 3.458 0 0 1 1.461 1.752c.134.366.2.753.2 1.16 0 1.401-.7 2.426-2.1 3.075 1.84.586 2.76 1.726 2.76 3.42 0 .782-.2 1.487-.602 2.114a3.61 3.61 0 0 1-1.623 1.39 5.772 5.772 0 0 1-1.471.377c-.554.073-1.2.11-1.939.11zm-.21-6.217h-2.95v4.087h3.046c1.916 0 2.874-.69 2.874-2.072 0-.707-.248-1.22-.745-1.537-.496-.319-1.238-.478-2.225-.478zM2.837 2.13v3.619h2.597c.707 0 1.252-.067 1.638-.2.385-.134.68-.389.883-.765.16-.267.239-.566.239-.897 0-.707-.252-1.176-.755-1.409-.503-.232-1.27-.348-2.301-.348H2.836z"/>\n</symbol>\n<symbol id="cross" viewBox="0 0 237 237">\n  <path transform="rotate(45 280.675 51.325)" d="M191 191V73c0-5.523 4.477-10 10-10h25c5.523 0 10 4.477 10 10v118h118c5.523 0 10 4.477 10 10v25c0 5.523-4.477 10-10 10H236v118c0 5.523-4.477 10-10 10h-25c-5.523 0-10-4.477-10-10V236H73c-5.523 0-10-4.477-10-10v-25c0-5.523 4.477-10 10-10h118z"/>\n\n</symbol>\n<symbol id="dots" viewBox="0 0 8 8">\n  <circle cx="6.5" cy="1.5" r="1.5"/>\n  <circle cx="6.5" cy="6.5" r="1.5"/>\n  <circle cx="1.5" cy="1.5" r="1.5"/>\n  <circle cx="1.5" cy="6.5" r="1.5"/>\n\n</symbol>\n<symbol id="italic" viewBox="0 0 4 11">\n    <path d="M3.289 4.17L2.164 9.713c-.078.384-.238.674-.48.87-.243.198-.52.296-.831.296-.312 0-.545-.1-.699-.302-.153-.202-.192-.49-.116-.864L1.15 4.225c.077-.38.232-.665.466-.857a1.25 1.25 0 01.818-.288c.312 0 .55.096.713.288.163.192.21.46.141.801zm-.667-2.09c-.295 0-.53-.09-.706-.273-.176-.181-.233-.439-.173-.77.055-.302.207-.55.457-.745C2.45.097 2.716 0 3 0c.273 0 .5.088.68.265.179.176.238.434.177.771-.06.327-.21.583-.45.767-.24.185-.502.277-.785.277z"/>\n\n</symbol>\n<symbol id="link" viewBox="0 0 14 10">\n  <path d="M6 0v2H5a3 3 0 000 6h1v2H5A5 5 0 115 0h1zm2 0h1a5 5 0 110 10H8V8h1a3 3 0 000-6H8V0zM5 4h4a1 1 0 110 2H5a1 1 0 110-2z"/>\n\n</symbol>\n<symbol id="plus" viewBox="0 0 14 14">\n    <path d="M8.05 5.8h4.625a1.125 1.125 0 0 1 0 2.25H8.05v4.625a1.125 1.125 0 0 1-2.25 0V8.05H1.125a1.125 1.125 0 0 1 0-2.25H5.8V1.125a1.125 1.125 0 0 1 2.25 0V5.8z"/>\n\n</symbol>\n<symbol id="sad-face" viewBox="0 0 52 52">\n    <path fill="#D76B6B" fill-rule="nonzero" d="M26 52C11.64 52 0 40.36 0 26S11.64 0 26 0s26 11.64 26 26-11.64 26-26 26zm0-3.25c12.564 0 22.75-10.186 22.75-22.75S38.564 3.25 26 3.25 3.25 13.436 3.25 26 13.436 48.75 26 48.75zM15.708 33.042a2.167 2.167 0 1 1 0-4.334 2.167 2.167 0 0 1 0 4.334zm23.834 0a2.167 2.167 0 1 1 0-4.334 2.167 2.167 0 0 1 0 4.334zm-15.875 5.452a1.083 1.083 0 1 1-1.834-1.155c1.331-2.114 3.49-3.179 6.334-3.179 2.844 0 5.002 1.065 6.333 3.18a1.083 1.083 0 1 1-1.833 1.154c-.913-1.45-2.366-2.167-4.5-2.167s-3.587.717-4.5 2.167z"/>\n\n</symbol>\n<symbol id="toggler-down">\n  <path d="M6.5 9.294a.792.792 0 01-.562-.232L2.233 5.356a.794.794 0 011.123-1.123L6.5 7.377l3.144-3.144a.794.794 0 011.123 1.123L7.062 9.062a.792.792 0 01-.562.232z"/>\n\n</symbol>\n<symbol id="unlink" viewBox="0 0 15 11">\n  <path d="M13.073 2.099l-1.448 1.448A3 3 0 009 2H8V0h1c1.68 0 3.166.828 4.073 2.099zM6.929 4l-.879.879L7.172 6H5a1 1 0 110-2h1.929zM6 0v2H5a3 3 0 100 6h1v2H5A5 5 0 115 0h1zm6.414 7l2.122 2.121-1.415 1.415L11 8.414l-2.121 2.122L7.464 9.12 9.586 7 7.464 4.879 8.88 3.464 11 5.586l2.121-2.122 1.415 1.415L12.414 7z"/>\n\n</symbol></svg>'},function(t,e){t.exports='.codex-editor{position:relative;-webkit-box-sizing:border-box;box-sizing:border-box;z-index:1}.codex-editor .hide,.codex-editor__redactor--hidden{display:none}.codex-editor__redactor [contenteditable]:empty:after{content:"\\feff "}@media (min-width:651px){.codex-editor--narrow .codex-editor__redactor{margin-right:50px}}@media (min-width:651px){.codex-editor--narrow.codex-editor--rtl .codex-editor__redactor{margin-left:50px;margin-right:0}}@media (min-width:651px){.codex-editor--narrow .ce-toolbar__actions{right:-5px}}.codex-editor__loader{position:relative;height:30vh}.codex-editor__loader:before{content:"";position:absolute;left:50%;top:50%;width:30px;height:30px;margin-top:-15px;margin-left:-15px;border-radius:50%;border:2px solid rgba(201,201,204,.48);border-top-color:transparent;-webkit-box-sizing:border-box;box-sizing:border-box;-webkit-animation:editor-loader-spin .8s linear infinite;animation:editor-loader-spin .8s linear infinite;will-change:transform}.codex-editor-copyable{position:absolute;height:1px;width:1px;top:-400%;opacity:.001}.codex-editor-overlay{position:fixed;top:0;left:0;right:0;bottom:0;z-index:999;pointer-events:none;overflow:hidden}.codex-editor-overlay__container{position:relative;pointer-events:auto;z-index:0}.codex-editor-overlay__rectangle{position:absolute;pointer-events:none;background-color:rgba(46,170,220,.2);border:1px solid transparent}.codex-editor svg{fill:currentColor;vertical-align:middle;max-height:100%}::-moz-selection{background-color:#d4ecff}::selection{background-color:#d4ecff}.codex-editor--toolbox-opened [contentEditable=true][data-placeholder]:focus:before{opacity:0!important}@-webkit-keyframes editor-loader-spin{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}to{-webkit-transform:rotate(1turn);transform:rotate(1turn)}}@keyframes editor-loader-spin{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}to{-webkit-transform:rotate(1turn);transform:rotate(1turn)}}.ce-toolbar{position:absolute;left:0;right:0;top:0;-webkit-transition:opacity .1s ease;transition:opacity .1s ease;will-change:opacity,transform;display:none}@media (max-width:650px){.ce-toolbar{position:absolute;background-color:#fff;border:1px solid #eaeaea;-webkit-box-shadow:0 3px 15px -3px rgba(13,20,33,.13);box-shadow:0 3px 15px -3px rgba(13,20,33,.13);border-radius:4px;z-index:2}}@media (max-width:650px) and (max-width:650px){.ce-toolbar{-webkit-box-shadow:0 13px 7px -5px rgba(26,38,49,.09),6px 15px 34px -6px rgba(33,48,73,.29);box-shadow:0 13px 7px -5px rgba(26,38,49,.09),6px 15px 34px -6px rgba(33,48,73,.29);border-bottom-color:#d5d7db}}@media (max-width:650px){.ce-toolbar{padding:3px;margin-top:5px}.ce-toolbar--left-oriented:before{left:15px;margin-left:0}.ce-toolbar--right-oriented:before{left:auto;right:15px;margin-left:0}}.ce-toolbar--opened{display:block}@media (max-width:650px){.ce-toolbar--opened{display:-webkit-box;display:-ms-flexbox;display:flex}}.ce-toolbar__content{max-width:650px;margin:0 auto;position:relative}@media (max-width:650px){.ce-toolbar__content{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-line-pack:center;align-content:center;margin:0;max-width:calc(100% - 35px)}}.ce-toolbar__plus{color:#707684;cursor:pointer;width:34px;height:34px;display:-webkit-inline-box;display:-ms-inline-flexbox;display:inline-flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;position:absolute;left:-34px;-ms-flex-negative:0;flex-shrink:0}.ce-toolbar__plus--active,.ce-toolbar__plus:hover{color:#388ae5}.ce-toolbar__plus--active{-webkit-animation:bounceIn .75s 1;animation:bounceIn .75s 1;-webkit-animation-fill-mode:forwards;animation-fill-mode:forwards}.ce-toolbar__plus-shortcut{opacity:.6;word-spacing:-2px;margin-top:5px}.ce-toolbar__plus--hidden{display:none}@media (max-width:650px){.ce-toolbar__plus{display:-webkit-inline-box!important;display:-ms-inline-flexbox!important;display:inline-flex!important;position:static;-webkit-transform:none!important;transform:none!important}}.ce-toolbar .ce-toolbox,.ce-toolbar__plus{top:50%;-webkit-transform:translateY(-50%);transform:translateY(-50%)}.ce-toolbar__actions{position:absolute;right:-30px;top:5px;opacity:0}@media (max-width:650px){.ce-toolbar__actions{position:absolute;right:-28px;top:50%;-webkit-transform:translateY(-50%);transform:translateY(-50%);display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center}}.ce-toolbar__actions--opened{opacity:1}.ce-toolbar__actions-buttons{text-align:right}.ce-toolbar__settings-btn{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;width:18px;height:18px;color:#707684;cursor:pointer;background:#eff2f5;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.ce-toolbar__settings-btn:hover{color:#1d202b}@media (max-width:650px){.ce-toolbar__settings-btn{background:transparent}}@media (min-width:651px){.codex-editor--narrow .ce-toolbar__plus{left:5px}}.ce-toolbox{position:absolute;visibility:hidden;-webkit-transition:opacity .1s ease;transition:opacity .1s ease;will-change:opacity;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:horizontal;-webkit-box-direction:normal;-ms-flex-direction:row;flex-direction:row}@media (max-width:650px){.ce-toolbox{position:static;-webkit-transform:none!important;transform:none!important;-webkit-box-align:center;-ms-flex-align:center;align-items:center;overflow-x:auto}}.ce-toolbox--opened{opacity:1;visibility:visible}.ce-toolbox__button{color:#707684;cursor:pointer;width:34px;height:34px;display:-webkit-inline-box;display:-ms-inline-flexbox;display:inline-flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-ms-flex-negative:0;flex-shrink:0}.ce-toolbox__button--active,.ce-toolbox__button:hover{color:#388ae5}.ce-toolbox__button--active{-webkit-animation:bounceIn .75s 1;animation:bounceIn .75s 1;-webkit-animation-fill-mode:forwards;animation-fill-mode:forwards}.ce-toolbox-button-tooltip__shortcut{opacity:.6;word-spacing:-3px;margin-top:3px}@media (min-width:651px){.codex-editor--narrow .ce-toolbox{background:#fff;z-index:2}}.ce-inline-toolbar{position:absolute;background-color:#fff;border:1px solid #eaeaea;-webkit-box-shadow:0 3px 15px -3px rgba(13,20,33,.13);box-shadow:0 3px 15px -3px rgba(13,20,33,.13);border-radius:4px;z-index:2}@media (max-width:650px){.ce-inline-toolbar{-webkit-box-shadow:0 13px 7px -5px rgba(26,38,49,.09),6px 15px 34px -6px rgba(33,48,73,.29);box-shadow:0 13px 7px -5px rgba(26,38,49,.09),6px 15px 34px -6px rgba(33,48,73,.29);border-bottom-color:#d5d7db}}.ce-inline-toolbar{-webkit-transform:translateX(-50%) translateY(8px) scale(.9);transform:translateX(-50%) translateY(8px) scale(.9);opacity:0;visibility:hidden;-webkit-transition:opacity .25s ease,-webkit-transform .15s ease;transition:opacity .25s ease,-webkit-transform .15s ease;transition:transform .15s ease,opacity .25s ease;transition:transform .15s ease,opacity .25s ease,-webkit-transform .15s ease;will-change:transform,opacity;top:0;left:0}.ce-inline-toolbar--left-oriented:before{left:15px;margin-left:0}.ce-inline-toolbar--right-oriented:before{left:auto;right:15px;margin-left:0}.ce-inline-toolbar--showed{opacity:1;visibility:visible;-webkit-transform:translateX(-50%);transform:translateX(-50%)}.ce-inline-toolbar--left-oriented{-webkit-transform:translateX(-23px) translateY(8px) scale(.9);transform:translateX(-23px) translateY(8px) scale(.9)}.ce-inline-toolbar--left-oriented.ce-inline-toolbar--showed{-webkit-transform:translateX(-23px);transform:translateX(-23px)}.ce-inline-toolbar--right-oriented{-webkit-transform:translateX(-100%) translateY(8px) scale(.9);transform:translateX(-100%) translateY(8px) scale(.9);margin-left:23px}.ce-inline-toolbar--right-oriented.ce-inline-toolbar--showed{-webkit-transform:translateX(-100%);transform:translateX(-100%)}.ce-inline-toolbar [hidden]{display:none!important}.ce-inline-toolbar__toggler-and-button-wrapper{width:100%;padding:0 6px}.ce-inline-toolbar__buttons,.ce-inline-toolbar__toggler-and-button-wrapper{display:-webkit-box;display:-ms-flexbox;display:flex}.ce-inline-toolbar__dropdown{display:-webkit-inline-box;display:-ms-inline-flexbox;display:inline-flex;height:34px;padding:0 9px 0 10px;margin:0 6px 0 -6px;-webkit-box-align:center;-ms-flex-align:center;align-items:center;cursor:pointer;border-right:1px solid rgba(201,201,204,.48)}.ce-inline-toolbar__dropdown:hover{background:#eff2f5}.ce-inline-toolbar__dropdown--hidden{display:none}.ce-inline-toolbar__dropdown-content{display:-webkit-box;display:-ms-flexbox;display:flex;font-weight:500;font-size:14px}.ce-inline-toolbar__dropdown-content svg{height:12px}.ce-inline-toolbar__dropdown .icon--toggler-down{margin-left:4px}.ce-inline-toolbar__shortcut{opacity:.6;word-spacing:-3px;margin-top:3px}.ce-inline-tool{display:-webkit-inline-box;display:-ms-inline-flexbox;display:inline-flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;width:34px;height:34px;line-height:34px;padding:0!important;text-align:center;border-radius:3px;cursor:pointer;border:0;outline:none;background-color:transparent;vertical-align:bottom;color:#000;margin:0}.ce-inline-tool:hover{background-color:#eff2f5}.ce-inline-tool{border-radius:0;line-height:normal;width:auto;padding:0 5px!important;min-width:24px}.ce-inline-tool--active{color:#388ae5}.ce-inline-tool--focused{-webkit-box-shadow:inset 0 0 0 1px rgba(7,161,227,.08);box-shadow:inset 0 0 0 1px rgba(7,161,227,.08);background:rgba(34,186,255,.08)!important}.ce-inline-tool--focused-animated{-webkit-animation-name:buttonClicked;animation-name:buttonClicked;-webkit-animation-duration:.25s;animation-duration:.25s}.ce-inline-tool:not(:last-of-type){margin-right:2px}.ce-inline-tool .icon{height:12px}.ce-inline-tool--link .icon--unlink,.ce-inline-tool--unlink .icon--link{display:none}.ce-inline-tool--unlink .icon--unlink{display:inline-block;margin-bottom:-1px}.ce-inline-tool-input{outline:none;border:0;border-radius:0 0 4px 4px;margin:0;font-size:13px;padding:10px;width:100%;-webkit-box-sizing:border-box;box-sizing:border-box;display:none;font-weight:500;border-top:1px solid rgba(201,201,204,.48)}.ce-inline-tool-input::-webkit-input-placeholder{color:#707684}.ce-inline-tool-input::-moz-placeholder{color:#707684}.ce-inline-tool-input:-ms-input-placeholder{color:#707684}.ce-inline-tool-input::-ms-input-placeholder{color:#707684}.ce-inline-tool-input::placeholder{color:#707684}.ce-inline-tool-input--showed{display:block}.ce-conversion-toolbar{position:absolute;background-color:#fff;border:1px solid #eaeaea;-webkit-box-shadow:0 3px 15px -3px rgba(13,20,33,.13);box-shadow:0 3px 15px -3px rgba(13,20,33,.13);border-radius:4px;z-index:2}@media (max-width:650px){.ce-conversion-toolbar{-webkit-box-shadow:0 13px 7px -5px rgba(26,38,49,.09),6px 15px 34px -6px rgba(33,48,73,.29);box-shadow:0 13px 7px -5px rgba(26,38,49,.09),6px 15px 34px -6px rgba(33,48,73,.29);border-bottom-color:#d5d7db}}.ce-conversion-toolbar{opacity:0;visibility:hidden;will-change:transform,opacity;-webkit-transition:opacity .1s ease,-webkit-transform .1s ease;transition:opacity .1s ease,-webkit-transform .1s ease;transition:transform .1s ease,opacity .1s ease;transition:transform .1s ease,opacity .1s ease,-webkit-transform .1s ease;-webkit-transform:translateY(-8px);transform:translateY(-8px);left:-1px;width:150px;margin-top:5px;-webkit-box-sizing:content-box;box-sizing:content-box}.ce-conversion-toolbar--left-oriented:before{left:15px;margin-left:0}.ce-conversion-toolbar--right-oriented:before{left:auto;right:15px;margin-left:0}.ce-conversion-toolbar--showed{opacity:1;visibility:visible;-webkit-transform:none;transform:none}.ce-conversion-toolbar [hidden]{display:none!important}.ce-conversion-toolbar__buttons{display:-webkit-box;display:-ms-flexbox;display:flex}.ce-conversion-toolbar__label{color:#707684;font-size:11px;font-weight:500;letter-spacing:.33px;padding:10px 10px 5px;text-transform:uppercase}.ce-conversion-tool{display:-webkit-box;display:-ms-flexbox;display:flex;padding:5px 10px;font-size:14px;line-height:20px;font-weight:500;cursor:pointer;-webkit-box-align:center;-ms-flex-align:center;align-items:center}.ce-conversion-tool--hidden{display:none}.ce-conversion-tool--focused{-webkit-box-shadow:inset 0 0 0 1px rgba(7,161,227,.08);box-shadow:inset 0 0 0 1px rgba(7,161,227,.08);background:rgba(34,186,255,.08)!important}.ce-conversion-tool--focused-animated{-webkit-animation-name:buttonClicked;animation-name:buttonClicked;-webkit-animation-duration:.25s;animation-duration:.25s}.ce-conversion-tool:hover{background:#eff2f5}.ce-conversion-tool__icon{display:-webkit-inline-box;display:-ms-inline-flexbox;display:inline-flex;width:20px;height:20px;border:1px solid rgba(201,201,204,.48);border-radius:3px;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;margin-right:10px;background:#fff}.ce-conversion-tool__icon svg{width:11px;height:11px}.ce-conversion-tool--last{margin-right:0!important}.ce-conversion-tool--active{color:#388ae5!important;-webkit-animation:bounceIn .75s 1;animation:bounceIn .75s 1;-webkit-animation-fill-mode:forwards;animation-fill-mode:forwards}.ce-settings{position:absolute;background-color:#fff;border:1px solid #eaeaea;-webkit-box-shadow:0 3px 15px -3px rgba(13,20,33,.13);box-shadow:0 3px 15px -3px rgba(13,20,33,.13);border-radius:4px;z-index:2}@media (max-width:650px){.ce-settings{-webkit-box-shadow:0 13px 7px -5px rgba(26,38,49,.09),6px 15px 34px -6px rgba(33,48,73,.29);box-shadow:0 13px 7px -5px rgba(26,38,49,.09),6px 15px 34px -6px rgba(33,48,73,.29);border-bottom-color:#d5d7db}}.ce-settings{right:-1px;top:30px;min-width:114px;-webkit-box-sizing:content-box;box-sizing:content-box}.ce-settings--left-oriented:before{left:15px;margin-left:0}.ce-settings--right-oriented:before{left:auto;right:15px;margin-left:0}@media (max-width:650px){.ce-settings{bottom:40px;right:-11px;top:auto}}.ce-settings:before{left:auto;right:12px}@media (max-width:650px){.ce-settings:before{bottom:-5px;top:auto}}.ce-settings{display:none}.ce-settings--opened{display:block;-webkit-animation-duration:.1s;animation-duration:.1s;-webkit-animation-name:panelShowing;animation-name:panelShowing}.ce-settings__plugin-zone:not(:empty){padding:3px 3px 0}.ce-settings__default-zone:not(:empty){padding:3px}.ce-settings__button{display:-webkit-inline-box;display:-ms-inline-flexbox;display:inline-flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;width:34px;height:34px;line-height:34px;padding:0!important;text-align:center;border-radius:3px;cursor:pointer;border:0;outline:none;background-color:transparent;vertical-align:bottom;color:#000;margin:0}.ce-settings__button:hover{background-color:#eff2f5}.ce-settings__button--active{color:#388ae5}.ce-settings__button--focused{-webkit-box-shadow:inset 0 0 0 1px rgba(7,161,227,.08);box-shadow:inset 0 0 0 1px rgba(7,161,227,.08);background:rgba(34,186,255,.08)!important}.ce-settings__button--focused-animated{-webkit-animation-name:buttonClicked;animation-name:buttonClicked;-webkit-animation-duration:.25s;animation-duration:.25s}.ce-settings__button:not(:nth-child(3n+3)){margin-right:3px}.ce-settings__button:nth-child(n+4){margin-top:3px}.ce-settings__button{line-height:32px}.ce-settings__button--disabled{cursor:not-allowed!important;opacity:.3}.ce-settings__button--selected{color:#388ae5}.ce-settings__button--delete{-webkit-transition:background-color .3s ease;transition:background-color .3s ease;will-change:background-color}.ce-settings__button--delete .icon{-webkit-transition:-webkit-transform .2s ease-out;transition:-webkit-transform .2s ease-out;transition:transform .2s ease-out;transition:transform .2s ease-out,-webkit-transform .2s ease-out;will-change:transform}.ce-settings__button--confirm{background-color:#e24a4a!important;color:#fff}.ce-settings__button--confirm:hover{background-color:#d54a4a!important}.ce-settings__button--confirm .icon{-webkit-transform:rotate(90deg);transform:rotate(90deg)}.ce-block:first-of-type{margin-top:0}.ce-block--selected .ce-block__content{background:#e1f2ff}.ce-block--selected .ce-block__content [contenteditable]{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.ce-block--selected .ce-block__content .ce-stub,.ce-block--selected .ce-block__content img{opacity:.55}.ce-block--stretched .ce-block__content{max-width:none}.ce-block__content{position:relative;max-width:650px;margin:0 auto;-webkit-transition:background-color .15s ease;transition:background-color .15s ease}.ce-block--drop-target .ce-block__content:before{content:"";position:absolute;top:100%;left:-20px;margin-top:-1px;height:8px;width:8px;border:solid #388ae5;border-width:1px 1px 0 0;-webkit-transform-origin:right;transform-origin:right;-webkit-transform:rotate(45deg);transform:rotate(45deg)}.ce-block--drop-target .ce-block__content:after{content:"";position:absolute;top:100%;height:1px;width:100%;color:#388ae5;background:repeating-linear-gradient(90deg,#388ae5,#388ae5 1px,#fff 0,#fff 6px)}.ce-block a{cursor:pointer;text-decoration:underline}.ce-block b{font-weight:700}.ce-block i{font-style:italic}@media (min-width:651px){.codex-editor--narrow .ce-block--focused{margin-right:-50px;padding-right:50px}}.wobble{-webkit-animation-name:wobble;animation-name:wobble;-webkit-animation-duration:.4s;animation-duration:.4s}@-webkit-keyframes wobble{0%{-webkit-transform:translateZ(0);transform:translateZ(0)}15%{-webkit-transform:translate3d(-5%,0,0) rotate(-5deg);transform:translate3d(-5%,0,0) rotate(-5deg)}30%{-webkit-transform:translate3d(2%,0,0) rotate(3deg);transform:translate3d(2%,0,0) rotate(3deg)}45%{-webkit-transform:translate3d(-3%,0,0) rotate(-3deg);transform:translate3d(-3%,0,0) rotate(-3deg)}60%{-webkit-transform:translate3d(2%,0,0) rotate(2deg);transform:translate3d(2%,0,0) rotate(2deg)}75%{-webkit-transform:translate3d(-1%,0,0) rotate(-1deg);transform:translate3d(-1%,0,0) rotate(-1deg)}to{-webkit-transform:translateZ(0);transform:translateZ(0)}}@keyframes wobble{0%{-webkit-transform:translateZ(0);transform:translateZ(0)}15%{-webkit-transform:translate3d(-5%,0,0) rotate(-5deg);transform:translate3d(-5%,0,0) rotate(-5deg)}30%{-webkit-transform:translate3d(2%,0,0) rotate(3deg);transform:translate3d(2%,0,0) rotate(3deg)}45%{-webkit-transform:translate3d(-3%,0,0) rotate(-3deg);transform:translate3d(-3%,0,0) rotate(-3deg)}60%{-webkit-transform:translate3d(2%,0,0) rotate(2deg);transform:translate3d(2%,0,0) rotate(2deg)}75%{-webkit-transform:translate3d(-1%,0,0) rotate(-1deg);transform:translate3d(-1%,0,0) rotate(-1deg)}to{-webkit-transform:translateZ(0);transform:translateZ(0)}}@-webkit-keyframes bounceIn{0%,20%,40%,60%,80%,to{-webkit-animation-timing-function:cubic-bezier(.215,.61,.355,1);animation-timing-function:cubic-bezier(.215,.61,.355,1)}0%{-webkit-transform:scale3d(.9,.9,.9);transform:scale3d(.9,.9,.9)}20%{-webkit-transform:scale3d(1.03,1.03,1.03);transform:scale3d(1.03,1.03,1.03)}60%{-webkit-transform:scaleX(1);transform:scaleX(1)}}@keyframes bounceIn{0%,20%,40%,60%,80%,to{-webkit-animation-timing-function:cubic-bezier(.215,.61,.355,1);animation-timing-function:cubic-bezier(.215,.61,.355,1)}0%{-webkit-transform:scale3d(.9,.9,.9);transform:scale3d(.9,.9,.9)}20%{-webkit-transform:scale3d(1.03,1.03,1.03);transform:scale3d(1.03,1.03,1.03)}60%{-webkit-transform:scaleX(1);transform:scaleX(1)}}@-webkit-keyframes selectionBounce{0%,20%,40%,60%,80%,to{-webkit-animation-timing-function:cubic-bezier(.215,.61,.355,1);animation-timing-function:cubic-bezier(.215,.61,.355,1)}50%{-webkit-transform:scale3d(1.01,1.01,1.01);transform:scale3d(1.01,1.01,1.01)}70%{-webkit-transform:scaleX(1);transform:scaleX(1)}}@keyframes selectionBounce{0%,20%,40%,60%,80%,to{-webkit-animation-timing-function:cubic-bezier(.215,.61,.355,1);animation-timing-function:cubic-bezier(.215,.61,.355,1)}50%{-webkit-transform:scale3d(1.01,1.01,1.01);transform:scale3d(1.01,1.01,1.01)}70%{-webkit-transform:scaleX(1);transform:scaleX(1)}}@-webkit-keyframes buttonClicked{0%,20%,40%,60%,80%,to{-webkit-animation-timing-function:cubic-bezier(.215,.61,.355,1);animation-timing-function:cubic-bezier(.215,.61,.355,1)}0%{-webkit-transform:scale3d(.95,.95,.95);transform:scale3d(.95,.95,.95)}60%{-webkit-transform:scale3d(1.02,1.02,1.02);transform:scale3d(1.02,1.02,1.02)}80%{-webkit-transform:scaleX(1);transform:scaleX(1)}}@keyframes buttonClicked{0%,20%,40%,60%,80%,to{-webkit-animation-timing-function:cubic-bezier(.215,.61,.355,1);animation-timing-function:cubic-bezier(.215,.61,.355,1)}0%{-webkit-transform:scale3d(.95,.95,.95);transform:scale3d(.95,.95,.95)}60%{-webkit-transform:scale3d(1.02,1.02,1.02);transform:scale3d(1.02,1.02,1.02)}80%{-webkit-transform:scaleX(1);transform:scaleX(1)}}@-webkit-keyframes panelShowing{0%{opacity:0;-webkit-transform:translateY(-8px) scale(.9);transform:translateY(-8px) scale(.9)}70%{opacity:1;-webkit-transform:translateY(2px);transform:translateY(2px)}to{-webkit-transform:translateY(0);transform:translateY(0)}}@keyframes panelShowing{0%{opacity:0;-webkit-transform:translateY(-8px) scale(.9);transform:translateY(-8px) scale(.9)}70%{opacity:1;-webkit-transform:translateY(2px);transform:translateY(2px)}to{-webkit-transform:translateY(0);transform:translateY(0)}}.cdx-block{padding:.4em 0}.cdx-input{border:1px solid rgba(201,201,204,.48);-webkit-box-shadow:inset 0 1px 2px 0 rgba(35,44,72,.06);box-shadow:inset 0 1px 2px 0 rgba(35,44,72,.06);border-radius:3px;padding:10px 12px;outline:none;width:100%;-webkit-box-sizing:border-box;box-sizing:border-box}.cdx-input[data-placeholder]:before{position:static!important;display:inline-block;width:0;white-space:nowrap;pointer-events:none}.cdx-settings-button{display:-webkit-inline-box;display:-ms-inline-flexbox;display:inline-flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;width:34px;height:34px;line-height:34px;padding:0!important;text-align:center;border-radius:3px;cursor:pointer;border:0;outline:none;background-color:transparent;vertical-align:bottom;color:#000;margin:0}.cdx-settings-button:hover{background-color:#eff2f5}.cdx-settings-button--focused{-webkit-box-shadow:inset 0 0 0 1px rgba(7,161,227,.08);box-shadow:inset 0 0 0 1px rgba(7,161,227,.08);background:rgba(34,186,255,.08)!important}.cdx-settings-button--focused-animated{-webkit-animation-name:buttonClicked;animation-name:buttonClicked;-webkit-animation-duration:.25s;animation-duration:.25s}.cdx-settings-button:not(:nth-child(3n+3)){margin-right:3px}.cdx-settings-button:nth-child(n+4){margin-top:3px}.cdx-settings-button--active{color:#388ae5}.cdx-loader{position:relative;border:1px solid rgba(201,201,204,.48)}.cdx-loader:before{content:"";position:absolute;left:50%;top:50%;width:18px;height:18px;margin:-11px 0 0 -11px;border:2px solid rgba(201,201,204,.48);border-left-color:#388ae5;border-radius:50%;-webkit-animation:cdxRotation 1.2s linear infinite;animation:cdxRotation 1.2s linear infinite}@-webkit-keyframes cdxRotation{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}to{-webkit-transform:rotate(1turn);transform:rotate(1turn)}}@keyframes cdxRotation{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}to{-webkit-transform:rotate(1turn);transform:rotate(1turn)}}.cdx-button{padding:13px;border-radius:3px;border:1px solid rgba(201,201,204,.48);font-size:14.9px;background:#fff;-webkit-box-shadow:0 2px 2px 0 rgba(18,30,57,.04);box-shadow:0 2px 2px 0 rgba(18,30,57,.04);color:#707684;text-align:center;cursor:pointer}.cdx-button:hover{background:#fbfcfe;-webkit-box-shadow:0 1px 3px 0 rgba(18,30,57,.08);box-shadow:0 1px 3px 0 rgba(18,30,57,.08)}.cdx-button svg{height:20px;margin-right:.2em;margin-top:-2px}.ce-stub{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;width:100%;padding:3.5em 0;margin:17px 0;border-radius:3px;background:#fcf7f7;color:#b46262}.ce-stub__info{margin-left:20px}.ce-stub__title{margin-bottom:3px;font-weight:600;font-size:18px;text-transform:capitalize}.ce-stub__subtitle{font-size:16px}.codex-editor.codex-editor--rtl{direction:rtl}.codex-editor.codex-editor--rtl .cdx-list{padding-left:0;padding-right:40px}.codex-editor.codex-editor--rtl .ce-toolbar__plus{right:-34px;left:auto}.codex-editor.codex-editor--rtl .ce-toolbar__actions{right:auto;left:-34px}@media (max-width:650px){.codex-editor.codex-editor--rtl .ce-toolbar__actions{margin-left:0;margin-right:auto;padding-right:0;padding-left:10px}}.codex-editor.codex-editor--rtl .ce-settings{left:5px;right:auto}.codex-editor.codex-editor--rtl .ce-settings:before{right:auto;left:25px}.codex-editor.codex-editor--rtl .ce-settings__button:not(:nth-child(3n+3)){margin-left:3px;margin-right:0}.codex-editor.codex-editor--rtl .ce-conversion-tool__icon{margin-right:0;margin-left:10px}.codex-editor.codex-editor--rtl .ce-inline-toolbar__dropdown{border-right:0 solid transparent;border-left:1px solid rgba(201,201,204,.48);margin:0 -6px 0 6px}.codex-editor.codex-editor--rtl .ce-inline-toolbar__dropdown .icon--toggler-down{margin-left:0;margin-right:4px}@media (min-width:651px){.codex-editor--narrow.codex-editor--rtl .ce-toolbar__plus{left:0;right:5px}}@media (min-width:651px){.codex-editor--narrow.codex-editor--rtl .ce-toolbar__actions{left:-5px}}'}])}));

/***/ }),

/***/ "./node_modules/@editorjs/header/dist/bundle.js":
/*!******************************************************!*\
  !*** ./node_modules/@editorjs/header/dist/bundle.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

!function(e,t){ true?module.exports=t():undefined}(window,(function(){return function(e){var t={};function n(r){if(t[r])return t[r].exports;var i=t[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,n),i.l=!0,i.exports}return n.m=e,n.c=t,n.d=function(e,t,r){n.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:r})},n.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},n.t=function(e,t){if(1&t&&(e=n(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var i in e)n.d(r,i,function(t){return e[t]}.bind(null,i));return r},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,"a",t),t},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.p="/",n(n.s=0)}([function(e,t,n){function r(e){return(r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function i(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}n(1).toString();
/**
 * Header block for the Editor.js.
 *
 * @author CodeX (team@ifmo.su)
 * @copyright CodeX 2018
 * @license MIT
 * @version 2.0.0
 */
var a=function(){function e(t){var n=t.data,r=t.config,i=t.api,a=t.readOnly;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.api=i,this.readOnly=a,this._CSS={block:this.api.styles.block,settingsButton:this.api.styles.settingsButton,settingsButtonActive:this.api.styles.settingsButtonActive,wrapper:"ce-header"},this._settings=r,this._data=this.normalizeData(n),this.settingsButtons=[],this._element=this.getTag()}var t,a,o;return t=e,o=[{key:"conversionConfig",get:function(){return{export:"text",import:"text"}}},{key:"sanitize",get:function(){return{level:!1,text:{}}}},{key:"isReadOnlySupported",get:function(){return!0}},{key:"pasteConfig",get:function(){return{tags:["H1","H2","H3","H4","H5","H6"]}}},{key:"toolbox",get:function(){return{icon:n(6).default,title:"Heading"}}}],(a=[{key:"normalizeData",value:function(e){var t={};return"object"!==r(e)&&(e={}),t.text=e.text||"",t.level=parseInt(e.level)||this.defaultLevel.number,t}},{key:"render",value:function(){return this._element}},{key:"renderSettings",value:function(){var e=this,t=document.createElement("DIV");return this.levels.length<=1||this.levels.forEach((function(n){var r=document.createElement("SPAN");r.classList.add(e._CSS.settingsButton),e.currentLevel.number===n.number&&r.classList.add(e._CSS.settingsButtonActive),r.innerHTML=n.svg,r.dataset.level=n.number,r.addEventListener("click",(function(){e.setLevel(n.number)})),t.appendChild(r),e.settingsButtons.push(r)})),t}},{key:"setLevel",value:function(e){var t=this;this.data={level:e,text:this.data.text},this.settingsButtons.forEach((function(n){n.classList.toggle(t._CSS.settingsButtonActive,parseInt(n.dataset.level)===e)}))}},{key:"merge",value:function(e){var t={text:this.data.text+e.text,level:this.data.level};this.data=t}},{key:"validate",value:function(e){return""!==e.text.trim()}},{key:"save",value:function(e){return{text:e.innerHTML,level:this.currentLevel.number}}},{key:"getTag",value:function(){var e=document.createElement(this.currentLevel.tag);return e.innerHTML=this._data.text||"",e.classList.add(this._CSS.wrapper),e.contentEditable=this.readOnly?"false":"true",e.dataset.placeholder=this.api.i18n.t(this._settings.placeholder||""),e}},{key:"onPaste",value:function(e){var t=e.detail.data,n=this.defaultLevel.number;switch(t.tagName){case"H1":n=1;break;case"H2":n=2;break;case"H3":n=3;break;case"H4":n=4;break;case"H5":n=5;break;case"H6":n=6}this._settings.levels&&(n=this._settings.levels.reduce((function(e,t){return Math.abs(t-n)<Math.abs(e-n)?t:e}))),this.data={level:n,text:t.innerHTML}}},{key:"data",get:function(){return this._data.text=this._element.innerHTML,this._data.level=this.currentLevel.number,this._data},set:function(e){if(this._data=this.normalizeData(e),void 0!==e.level&&this._element.parentNode){var t=this.getTag();t.innerHTML=this._element.innerHTML,this._element.parentNode.replaceChild(t,this._element),this._element=t}void 0!==e.text&&(this._element.innerHTML=this._data.text||"")}},{key:"currentLevel",get:function(){var e=this,t=this.levels.find((function(t){return t.number===e._data.level}));return t||(t=this.defaultLevel),t}},{key:"defaultLevel",get:function(){var e=this;if(this._settings.defaultLevel){var t=this.levels.find((function(t){return t.number===e._settings.defaultLevel}));if(t)return t;console.warn("(ง'̀-'́)ง Heading Tool: the default level specified was not found in available levels")}return this.levels[1]}},{key:"levels",get:function(){var e=this,t=[{number:1,tag:"H1",svg:'<svg width="16" height="14" xmlns="http://www.w3.org/2000/svg"><path d="M2.14 1.494V4.98h4.62V1.494c0-.498.098-.871.293-1.12A.927.927 0 0 1 7.82 0c.322 0 .583.123.782.37.2.246.3.62.3 1.124v9.588c0 .503-.101.88-.303 1.128a.957.957 0 0 1-.779.374.921.921 0 0 1-.77-.378c-.193-.251-.29-.626-.29-1.124V6.989H2.14v4.093c0 .503-.1.88-.302 1.128a.957.957 0 0 1-.778.374.921.921 0 0 1-.772-.378C.096 11.955 0 11.58 0 11.082V1.494C0 .996.095.623.285.374A.922.922 0 0 1 1.06 0c.321 0 .582.123.782.37.199.246.299.62.299 1.124zm11.653 9.985V5.27c-1.279.887-2.14 1.33-2.583 1.33a.802.802 0 0 1-.563-.228.703.703 0 0 1-.245-.529c0-.232.08-.402.241-.511.161-.11.446-.25.854-.424.61-.259 1.096-.532 1.462-.818a5.84 5.84 0 0 0 .97-.962c.282-.355.466-.573.552-.655.085-.082.246-.123.483-.123.267 0 .481.093.642.28.161.186.242.443.242.77v7.813c0 .914-.345 1.371-1.035 1.371-.307 0-.554-.093-.74-.28-.187-.186-.28-.461-.28-.825z"/></svg>'},{number:2,tag:"H2",svg:'<svg width="18" height="14" xmlns="http://www.w3.org/2000/svg"><path d="M2.152 1.494V4.98h4.646V1.494c0-.498.097-.871.293-1.12A.934.934 0 0 1 7.863 0c.324 0 .586.123.786.37.2.246.301.62.301 1.124v9.588c0 .503-.101.88-.304 1.128a.964.964 0 0 1-.783.374.928.928 0 0 1-.775-.378c-.194-.251-.29-.626-.29-1.124V6.989H2.152v4.093c0 .503-.101.88-.304 1.128a.964.964 0 0 1-.783.374.928.928 0 0 1-.775-.378C.097 11.955 0 11.58 0 11.082V1.494C0 .996.095.623.286.374A.929.929 0 0 1 1.066 0c.323 0 .585.123.786.37.2.246.3.62.3 1.124zm10.99 9.288h3.527c.351 0 .62.072.804.216.185.144.277.34.277.588 0 .22-.073.408-.22.56-.146.154-.368.23-.665.23h-4.972c-.338 0-.601-.093-.79-.28a.896.896 0 0 1-.284-.659c0-.162.06-.377.182-.645s.255-.478.399-.631a38.617 38.617 0 0 1 1.621-1.598c.482-.444.827-.735 1.034-.875.369-.261.676-.523.922-.787.245-.263.432-.534.56-.81.129-.278.193-.549.193-.815 0-.288-.069-.546-.206-.773a1.428 1.428 0 0 0-.56-.53 1.618 1.618 0 0 0-.774-.19c-.59 0-1.054.26-1.392.777-.045.068-.12.252-.226.554-.106.302-.225.534-.358.696-.133.162-.328.243-.585.243a.76.76 0 0 1-.56-.223c-.149-.148-.223-.351-.223-.608 0-.31.07-.635.21-.972.139-.338.347-.645.624-.92a3.093 3.093 0 0 1 1.054-.665c.426-.169.924-.253 1.496-.253.69 0 1.277.108 1.764.324.315.144.592.343.83.595.24.252.425.544.558.875.133.33.2.674.2 1.03 0 .558-.14 1.066-.416 1.523-.277.457-.56.815-.848 1.074-.288.26-.771.666-1.45 1.22-.677.554-1.142.984-1.394 1.29a3.836 3.836 0 0 0-.331.44z"/></svg>'},{number:3,tag:"H3",svg:'<svg width="18" height="14" xmlns="http://www.w3.org/2000/svg"><path d="M2.152 1.494V4.98h4.646V1.494c0-.498.097-.871.293-1.12A.934.934 0 0 1 7.863 0c.324 0 .586.123.786.37.2.246.301.62.301 1.124v9.588c0 .503-.101.88-.304 1.128a.964.964 0 0 1-.783.374.928.928 0 0 1-.775-.378c-.194-.251-.29-.626-.29-1.124V6.989H2.152v4.093c0 .503-.101.88-.304 1.128a.964.964 0 0 1-.783.374.928.928 0 0 1-.775-.378C.097 11.955 0 11.58 0 11.082V1.494C0 .996.095.623.286.374A.929.929 0 0 1 1.066 0c.323 0 .585.123.786.37.2.246.3.62.3 1.124zm11.61 4.919c.418 0 .778-.123 1.08-.368.301-.245.452-.597.452-1.055 0-.35-.12-.65-.36-.902-.241-.252-.566-.378-.974-.378-.277 0-.505.038-.684.116a1.1 1.1 0 0 0-.426.306 2.31 2.31 0 0 0-.296.49c-.093.2-.178.388-.255.565a.479.479 0 0 1-.245.225.965.965 0 0 1-.409.081.706.706 0 0 1-.5-.22c-.152-.148-.228-.345-.228-.59 0-.236.071-.484.214-.745a2.72 2.72 0 0 1 .627-.746 3.149 3.149 0 0 1 1.024-.568 4.122 4.122 0 0 1 1.368-.214c.44 0 .842.06 1.205.18.364.12.679.294.947.52.267.228.47.49.606.79.136.3.204.622.204.967 0 .454-.099.843-.296 1.168-.198.324-.48.64-.848.95.354.19.653.408.895.653.243.245.426.516.548.813.123.298.184.619.184.964 0 .413-.083.812-.248 1.198-.166.386-.41.73-.732 1.031a3.49 3.49 0 0 1-1.147.708c-.443.17-.932.256-1.467.256a3.512 3.512 0 0 1-1.464-.293 3.332 3.332 0 0 1-1.699-1.64c-.142-.314-.214-.573-.214-.777 0-.263.085-.475.255-.636a.89.89 0 0 1 .637-.242c.127 0 .25.037.367.112a.53.53 0 0 1 .232.27c.236.63.489 1.099.759 1.405.27.306.65.46 1.14.46a1.714 1.714 0 0 0 1.46-.824c.17-.273.256-.588.256-.947 0-.53-.145-.947-.436-1.249-.29-.302-.694-.453-1.212-.453-.09 0-.231.01-.422.028-.19.018-.313.027-.367.027-.25 0-.443-.062-.579-.187-.136-.125-.204-.299-.204-.521 0-.218.081-.394.245-.528.163-.134.406-.2.728-.2h.28z"/></svg>'},{number:4,tag:"H4",svg:'<svg width="20" height="14" xmlns="http://www.w3.org/2000/svg"><path d="M2.152 1.494V4.98h4.646V1.494c0-.498.097-.871.293-1.12A.934.934 0 0 1 7.863 0c.324 0 .586.123.786.37.2.246.301.62.301 1.124v9.588c0 .503-.101.88-.304 1.128a.964.964 0 0 1-.783.374.928.928 0 0 1-.775-.378c-.194-.251-.29-.626-.29-1.124V6.989H2.152v4.093c0 .503-.101.88-.304 1.128a.964.964 0 0 1-.783.374.928.928 0 0 1-.775-.378C.097 11.955 0 11.58 0 11.082V1.494C0 .996.095.623.286.374A.929.929 0 0 1 1.066 0c.323 0 .585.123.786.37.2.246.3.62.3 1.124zm13.003 10.09v-1.252h-3.38c-.427 0-.746-.097-.96-.29-.213-.193-.32-.456-.32-.788 0-.085.016-.171.048-.259.031-.088.078-.18.141-.276.063-.097.128-.19.195-.28.068-.09.15-.2.25-.33l3.568-4.774a5.44 5.44 0 0 1 .576-.683.763.763 0 0 1 .542-.212c.682 0 1.023.39 1.023 1.171v5.212h.29c.346 0 .623.047.832.142.208.094.313.3.313.62 0 .26-.086.45-.256.568-.17.12-.427.179-.768.179h-.41v1.252c0 .346-.077.603-.23.771-.152.168-.356.253-.612.253a.78.78 0 0 1-.61-.26c-.154-.173-.232-.427-.232-.764zm-2.895-2.76h2.895V4.91L12.26 8.823z"/></svg>'},{number:5,tag:"H5",svg:'<svg width="18" height="14" xmlns="http://www.w3.org/2000/svg"><path d="M2.152 1.494V4.98h4.646V1.494c0-.498.097-.871.293-1.12A.934.934 0 0 1 7.863 0c.324 0 .586.123.786.37.2.246.301.62.301 1.124v9.588c0 .503-.101.88-.304 1.128a.964.964 0 0 1-.783.374.928.928 0 0 1-.775-.378c-.194-.251-.29-.626-.29-1.124V6.989H2.152v4.093c0 .503-.101.88-.304 1.128a.964.964 0 0 1-.783.374.928.928 0 0 1-.775-.378C.097 11.955 0 11.58 0 11.082V1.494C0 .996.095.623.286.374A.929.929 0 0 1 1.066 0c.323 0 .585.123.786.37.2.246.3.62.3 1.124zm14.16 2.645h-3.234l-.388 2.205c.644-.344 1.239-.517 1.783-.517.436 0 .843.082 1.222.245.38.164.712.39.998.677.286.289.51.63.674 1.025.163.395.245.82.245 1.273 0 .658-.148 1.257-.443 1.797-.295.54-.72.97-1.276 1.287-.556.318-1.197.477-1.923.477-.813 0-1.472-.15-1.978-.45-.506-.3-.865-.643-1.076-1.031-.21-.388-.316-.727-.316-1.018 0-.177.073-.345.22-.504a.725.725 0 0 1 .556-.238c.381 0 .665.22.85.66.182.404.427.719.736.943.309.225.654.337 1.035.337.35 0 .656-.09.919-.272.263-.182.466-.431.61-.749.142-.318.214-.678.214-1.082 0-.436-.078-.808-.232-1.117a1.607 1.607 0 0 0-.62-.69 1.674 1.674 0 0 0-.864-.229c-.39 0-.67.048-.837.143-.168.095-.41.262-.725.5-.316.239-.576.358-.78.358a.843.843 0 0 1-.592-.242c-.173-.16-.259-.344-.259-.548 0-.022.025-.177.075-.463l.572-3.26c.063-.39.181-.675.354-.852.172-.177.454-.265.844-.265h3.595c.708 0 1.062.27 1.062.81a.711.711 0 0 1-.26.572c-.172.145-.426.218-.762.218z"/></svg>'},{number:6,tag:"H6",svg:'<svg width="18" height="14" xmlns="http://www.w3.org/2000/svg"><path d="M2.152 1.494V4.98h4.646V1.494c0-.498.097-.871.293-1.12A.934.934 0 0 1 7.863 0c.324 0 .586.123.786.37.2.246.301.62.301 1.124v9.588c0 .503-.101.88-.304 1.128a.964.964 0 0 1-.783.374.928.928 0 0 1-.775-.378c-.194-.251-.29-.626-.29-1.124V6.989H2.152v4.093c0 .503-.101.88-.304 1.128a.964.964 0 0 1-.783.374.928.928 0 0 1-.775-.378C.097 11.955 0 11.58 0 11.082V1.494C0 .996.095.623.286.374A.929.929 0 0 1 1.066 0c.323 0 .585.123.786.37.2.246.3.62.3 1.124zM12.53 7.058a3.093 3.093 0 0 1 1.004-.814 2.734 2.734 0 0 1 1.214-.264c.43 0 .827.08 1.19.24.365.161.684.39.957.686.274.296.485.645.635 1.048a3.6 3.6 0 0 1 .223 1.262c0 .637-.145 1.216-.437 1.736-.292.52-.699.926-1.221 1.218-.522.292-1.114.438-1.774.438-.76 0-1.416-.186-1.967-.557-.552-.37-.974-.919-1.265-1.645-.292-.726-.438-1.613-.438-2.662 0-.855.088-1.62.265-2.293.176-.674.43-1.233.76-1.676.33-.443.73-.778 1.2-1.004.47-.226 1.006-.339 1.608-.339.579 0 1.089.113 1.53.34.44.225.773.506.997.84.224.335.335.656.335.964 0 .185-.07.354-.21.505a.698.698 0 0 1-.536.227.874.874 0 0 1-.529-.18 1.039 1.039 0 0 1-.36-.498 1.42 1.42 0 0 0-.495-.655 1.3 1.3 0 0 0-.786-.247c-.24 0-.479.069-.716.207a1.863 1.863 0 0 0-.6.56c-.33.479-.525 1.333-.584 2.563zm1.832 4.213c.456 0 .834-.186 1.133-.56.298-.373.447-.862.447-1.468 0-.412-.07-.766-.21-1.062a1.584 1.584 0 0 0-.577-.678 1.47 1.47 0 0 0-.807-.234c-.28 0-.548.074-.804.224-.255.149-.461.365-.617.647a2.024 2.024 0 0 0-.234.994c0 .61.158 1.12.475 1.527.316.407.714.61 1.194.61z"/></svg>'}];return this._settings.levels?t.filter((function(t){return e._settings.levels.includes(t.number)})):t}}])&&i(t.prototype,a),o&&i(t,o),e}();e.exports=a},function(e,t,n){var r=n(2);"string"==typeof r&&(r=[[e.i,r,""]]);var i={hmr:!0,transform:void 0,insertInto:void 0};n(4)(r,i);r.locals&&(e.exports=r.locals)},function(e,t,n){(e.exports=n(3)(!1)).push([e.i,"/**\n * Plugin styles\n */\n.ce-header {\n  padding: 1em 0;\n  margin: 0;\n  margin-bottom: -0.9em;\n  line-height: 1.5em;\n  outline: none;\n}\n\n.ce-header p,\n.ce-header div{\n  padding: 0 !important;\n  margin: 0 !important;\n}\n\n/**\n * Styles for Plugin icon in Toolbar\n */\n.ce-header__icon {}\n\n.ce-header[contentEditable=true][data-placeholder]::before{\n  position: absolute;\n  content: attr(data-placeholder);\n  color: #707684;\n  font-weight: normal;\n  display: none;\n}\n\n.ce-header[contentEditable=true][data-placeholder]:empty::before {\n  display: block;\n}\n\n.ce-header[contentEditable=true][data-placeholder]:empty:focus::before {\n  display: none;\n}\n",""])},function(e,t){e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var n=function(e,t){var n=e[1]||"",r=e[3];if(!r)return n;if(t&&"function"==typeof btoa){var i=(o=r,"/*# sourceMappingURL=data:application/json;charset=utf-8;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(o))))+" */"),a=r.sources.map((function(e){return"/*# sourceURL="+r.sourceRoot+e+" */"}));return[n].concat(a).concat([i]).join("\n")}var o;return[n].join("\n")}(t,e);return t[2]?"@media "+t[2]+"{"+n+"}":n})).join("")},t.i=function(e,n){"string"==typeof e&&(e=[[null,e,""]]);for(var r={},i=0;i<this.length;i++){var a=this[i][0];"number"==typeof a&&(r[a]=!0)}for(i=0;i<e.length;i++){var o=e[i];"number"==typeof o[0]&&r[o[0]]||(n&&!o[2]?o[2]=n:n&&(o[2]="("+o[2]+") and ("+n+")"),t.push(o))}},t}},function(e,t,n){var r,i,a={},o=(r=function(){return window&&document&&document.all&&!window.atob},function(){return void 0===i&&(i=r.apply(this,arguments)),i}),s=function(e){return document.querySelector(e)},c=function(e){var t={};return function(e){if("function"==typeof e)return e();if(void 0===t[e]){var n=s.call(this,e);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(e){n=null}t[e]=n}return t[e]}}(),l=null,u=0,f=[],d=n(5);function h(e,t){for(var n=0;n<e.length;n++){var r=e[n],i=a[r.id];if(i){i.refs++;for(var o=0;o<i.parts.length;o++)i.parts[o](r.parts[o]);for(;o<r.parts.length;o++)i.parts.push(y(r.parts[o],t))}else{var s=[];for(o=0;o<r.parts.length;o++)s.push(y(r.parts[o],t));a[r.id]={id:r.id,refs:1,parts:s}}}}function v(e,t){for(var n=[],r={},i=0;i<e.length;i++){var a=e[i],o=t.base?a[0]+t.base:a[0],s={css:a[1],media:a[2],sourceMap:a[3]};r[o]?r[o].parts.push(s):n.push(r[o]={id:o,parts:[s]})}return n}function p(e,t){var n=c(e.insertInto);if(!n)throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");var r=f[f.length-1];if("top"===e.insertAt)r?r.nextSibling?n.insertBefore(t,r.nextSibling):n.appendChild(t):n.insertBefore(t,n.firstChild),f.push(t);else if("bottom"===e.insertAt)n.appendChild(t);else{if("object"!=typeof e.insertAt||!e.insertAt.before)throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");var i=c(e.insertInto+" "+e.insertAt.before);n.insertBefore(t,i)}}function g(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e);var t=f.indexOf(e);t>=0&&f.splice(t,1)}function m(e){var t=document.createElement("style");return void 0===e.attrs.type&&(e.attrs.type="text/css"),b(t,e.attrs),p(e,t),t}function b(e,t){Object.keys(t).forEach((function(n){e.setAttribute(n,t[n])}))}function y(e,t){var n,r,i,a;if(t.transform&&e.css){if(!(a=t.transform(e.css)))return function(){};e.css=a}if(t.singleton){var o=u++;n=l||(l=m(t)),r=L.bind(null,n,o,!1),i=L.bind(null,n,o,!0)}else e.sourceMap&&"function"==typeof URL&&"function"==typeof URL.createObjectURL&&"function"==typeof URL.revokeObjectURL&&"function"==typeof Blob&&"function"==typeof btoa?(n=function(e){var t=document.createElement("link");return void 0===e.attrs.type&&(e.attrs.type="text/css"),e.attrs.rel="stylesheet",b(t,e.attrs),p(e,t),t}(t),r=_.bind(null,n,t),i=function(){g(n),n.href&&URL.revokeObjectURL(n.href)}):(n=m(t),r=H.bind(null,n),i=function(){g(n)});return r(e),function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap)return;r(e=t)}else i()}}e.exports=function(e,t){if("undefined"!=typeof DEBUG&&DEBUG&&"object"!=typeof document)throw new Error("The style-loader cannot be used in a non-browser environment");(t=t||{}).attrs="object"==typeof t.attrs?t.attrs:{},t.singleton||"boolean"==typeof t.singleton||(t.singleton=o()),t.insertInto||(t.insertInto="head"),t.insertAt||(t.insertAt="bottom");var n=v(e,t);return h(n,t),function(e){for(var r=[],i=0;i<n.length;i++){var o=n[i];(s=a[o.id]).refs--,r.push(s)}e&&h(v(e,t),t);for(i=0;i<r.length;i++){var s;if(0===(s=r[i]).refs){for(var c=0;c<s.parts.length;c++)s.parts[c]();delete a[s.id]}}}};var w,x=(w=[],function(e,t){return w[e]=t,w.filter(Boolean).join("\n")});function L(e,t,n,r){var i=n?"":r.css;if(e.styleSheet)e.styleSheet.cssText=x(t,i);else{var a=document.createTextNode(i),o=e.childNodes;o[t]&&e.removeChild(o[t]),o.length?e.insertBefore(a,o[t]):e.appendChild(a)}}function H(e,t){var n=t.css,r=t.media;if(r&&e.setAttribute("media",r),e.styleSheet)e.styleSheet.cssText=n;else{for(;e.firstChild;)e.removeChild(e.firstChild);e.appendChild(document.createTextNode(n))}}function _(e,t,n){var r=n.css,i=n.sourceMap,a=void 0===t.convertToAbsoluteUrls&&i;(t.convertToAbsoluteUrls||a)&&(r=d(r)),i&&(r+="\n/*# sourceMappingURL=data:application/json;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(i))))+" */");var o=new Blob([r],{type:"text/css"}),s=e.href;e.href=URL.createObjectURL(o),s&&URL.revokeObjectURL(s)}},function(e,t){e.exports=function(e){var t="undefined"!=typeof window&&window.location;if(!t)throw new Error("fixUrls requires window.location");if(!e||"string"!=typeof e)return e;var n=t.protocol+"//"+t.host,r=n+t.pathname.replace(/\/[^\/]*$/,"/");return e.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi,(function(e,t){var i,a=t.trim().replace(/^"(.*)"$/,(function(e,t){return t})).replace(/^'(.*)'$/,(function(e,t){return t}));return/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/|\s*$)/i.test(a)?e:(i=0===a.indexOf("//")?a:0===a.indexOf("/")?n+a:r+a.replace(/^\.\//,""),"url("+JSON.stringify(i)+")")}))}},function(e,t,n){"use strict";n.r(t),t.default='<svg width="10" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 10 14">\n  <path d="M7.6 8.15H2.25v4.525a1.125 1.125 0 0 1-2.25 0V1.125a1.125 1.125 0 1 1 2.25 0V5.9H7.6V1.125a1.125 1.125 0 0 1 2.25 0v11.55a1.125 1.125 0 0 1-2.25 0V8.15z"/>\n</svg>\n'}])}));

/***/ }),

/***/ "./node_modules/@editorjs/inline-code/dist/bundle.js":
/*!***********************************************************!*\
  !*** ./node_modules/@editorjs/inline-code/dist/bundle.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

!function(t,e){ true?module.exports=e():undefined}(window,function(){return function(t){var e={};function n(r){if(e[r])return e[r].exports;var o=e[r]={i:r,l:!1,exports:{}};return t[r].call(o.exports,o,o.exports,n),o.l=!0,o.exports}return n.m=t,n.c=e,n.d=function(t,e,r){n.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:r})},n.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var o in t)n.d(r,o,function(e){return t[e]}.bind(null,o));return r},n.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return n.d(e,"a",e),e},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.p="/",n(n.s=0)}([function(t,e,n){function r(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,r.key,r)}}function o(t,e,n){return e&&r(t.prototype,e),n&&r(t,n),t}n(1).toString();var i=function(){function t(e){var n=e.api;!function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}(this,t),this.api=n,this.button=null,this.tag="CODE",this.iconClasses={base:this.api.styles.inlineToolButton,active:this.api.styles.inlineToolButtonActive}}return o(t,null,[{key:"CSS",get:function(){return"inline-code"}}]),o(t,[{key:"render",value:function(){return this.button=document.createElement("button"),this.button.type="button",this.button.classList.add(this.iconClasses.base),this.button.innerHTML=this.toolboxIcon,this.button}},{key:"surround",value:function(e){if(e){var n=this.api.selection.findParentTag(this.tag,t.CSS);n?this.unwrap(n):this.wrap(e)}}},{key:"wrap",value:function(e){var n=document.createElement(this.tag);n.classList.add(t.CSS),n.appendChild(e.extractContents()),e.insertNode(n),this.api.selection.expandToTag(n)}},{key:"unwrap",value:function(t){this.api.selection.expandToTag(t);var e=window.getSelection(),n=e.getRangeAt(0),r=n.extractContents();t.parentNode.removeChild(t),n.insertNode(r),e.removeAllRanges(),e.addRange(n)}},{key:"checkState",value:function(){var e=this.api.selection.findParentTag(this.tag,t.CSS);this.button.classList.toggle(this.iconClasses.active,!!e)}},{key:"toolboxIcon",get:function(){return n(6).default}}],[{key:"isInline",get:function(){return!0}},{key:"sanitize",get:function(){return{code:{class:t.CSS}}}}]),t}();t.exports=i},function(t,e,n){var r=n(2);"string"==typeof r&&(r=[[t.i,r,""]]);var o={hmr:!0,transform:void 0,insertInto:void 0};n(4)(r,o);r.locals&&(t.exports=r.locals)},function(t,e,n){(t.exports=n(3)(!1)).push([t.i,".inline-code {\n  background: rgba(250, 239, 240, 0.78);\n  color: #b44437;\n  padding: 3px 4px;\n  border-radius: 5px;\n  margin: 0 1px;\n  font-family: inherit;\n  font-size: 0.86em;\n  font-weight: 500;\n  letter-spacing: 0.3px;\n}\n",""])},function(t,e){t.exports=function(t){var e=[];return e.toString=function(){return this.map(function(e){var n=function(t,e){var n=t[1]||"",r=t[3];if(!r)return n;if(e&&"function"==typeof btoa){var o=(a=r,"/*# sourceMappingURL=data:application/json;charset=utf-8;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(a))))+" */"),i=r.sources.map(function(t){return"/*# sourceURL="+r.sourceRoot+t+" */"});return[n].concat(i).concat([o]).join("\n")}var a;return[n].join("\n")}(e,t);return e[2]?"@media "+e[2]+"{"+n+"}":n}).join("")},e.i=function(t,n){"string"==typeof t&&(t=[[null,t,""]]);for(var r={},o=0;o<this.length;o++){var i=this[o][0];"number"==typeof i&&(r[i]=!0)}for(o=0;o<t.length;o++){var a=t[o];"number"==typeof a[0]&&r[a[0]]||(n&&!a[2]?a[2]=n:n&&(a[2]="("+a[2]+") and ("+n+")"),e.push(a))}},e}},function(t,e,n){var r,o,i={},a=(r=function(){return window&&document&&document.all&&!window.atob},function(){return void 0===o&&(o=r.apply(this,arguments)),o}),s=function(t){var e={};return function(t){if("function"==typeof t)return t();if(void 0===e[t]){var n=function(t){return document.querySelector(t)}.call(this,t);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(t){n=null}e[t]=n}return e[t]}}(),u=null,c=0,f=[],l=n(5);function p(t,e){for(var n=0;n<t.length;n++){var r=t[n],o=i[r.id];if(o){o.refs++;for(var a=0;a<o.parts.length;a++)o.parts[a](r.parts[a]);for(;a<r.parts.length;a++)o.parts.push(g(r.parts[a],e))}else{var s=[];for(a=0;a<r.parts.length;a++)s.push(g(r.parts[a],e));i[r.id]={id:r.id,refs:1,parts:s}}}}function d(t,e){for(var n=[],r={},o=0;o<t.length;o++){var i=t[o],a=e.base?i[0]+e.base:i[0],s={css:i[1],media:i[2],sourceMap:i[3]};r[a]?r[a].parts.push(s):n.push(r[a]={id:a,parts:[s]})}return n}function h(t,e){var n=s(t.insertInto);if(!n)throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");var r=f[f.length-1];if("top"===t.insertAt)r?r.nextSibling?n.insertBefore(e,r.nextSibling):n.appendChild(e):n.insertBefore(e,n.firstChild),f.push(e);else if("bottom"===t.insertAt)n.appendChild(e);else{if("object"!=typeof t.insertAt||!t.insertAt.before)throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");var o=s(t.insertInto+" "+t.insertAt.before);n.insertBefore(e,o)}}function v(t){if(null===t.parentNode)return!1;t.parentNode.removeChild(t);var e=f.indexOf(t);e>=0&&f.splice(e,1)}function b(t){var e=document.createElement("style");return void 0===t.attrs.type&&(t.attrs.type="text/css"),y(e,t.attrs),h(t,e),e}function y(t,e){Object.keys(e).forEach(function(n){t.setAttribute(n,e[n])})}function g(t,e){var n,r,o,i;if(e.transform&&t.css){if(!(i=e.transform(t.css)))return function(){};t.css=i}if(e.singleton){var a=c++;n=u||(u=b(e)),r=x.bind(null,n,a,!1),o=x.bind(null,n,a,!0)}else t.sourceMap&&"function"==typeof URL&&"function"==typeof URL.createObjectURL&&"function"==typeof URL.revokeObjectURL&&"function"==typeof Blob&&"function"==typeof btoa?(n=function(t){var e=document.createElement("link");return void 0===t.attrs.type&&(t.attrs.type="text/css"),t.attrs.rel="stylesheet",y(e,t.attrs),h(t,e),e}(e),r=function(t,e,n){var r=n.css,o=n.sourceMap,i=void 0===e.convertToAbsoluteUrls&&o;(e.convertToAbsoluteUrls||i)&&(r=l(r));o&&(r+="\n/*# sourceMappingURL=data:application/json;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(o))))+" */");var a=new Blob([r],{type:"text/css"}),s=t.href;t.href=URL.createObjectURL(a),s&&URL.revokeObjectURL(s)}.bind(null,n,e),o=function(){v(n),n.href&&URL.revokeObjectURL(n.href)}):(n=b(e),r=function(t,e){var n=e.css,r=e.media;r&&t.setAttribute("media",r);if(t.styleSheet)t.styleSheet.cssText=n;else{for(;t.firstChild;)t.removeChild(t.firstChild);t.appendChild(document.createTextNode(n))}}.bind(null,n),o=function(){v(n)});return r(t),function(e){if(e){if(e.css===t.css&&e.media===t.media&&e.sourceMap===t.sourceMap)return;r(t=e)}else o()}}t.exports=function(t,e){if("undefined"!=typeof DEBUG&&DEBUG&&"object"!=typeof document)throw new Error("The style-loader cannot be used in a non-browser environment");(e=e||{}).attrs="object"==typeof e.attrs?e.attrs:{},e.singleton||"boolean"==typeof e.singleton||(e.singleton=a()),e.insertInto||(e.insertInto="head"),e.insertAt||(e.insertAt="bottom");var n=d(t,e);return p(n,e),function(t){for(var r=[],o=0;o<n.length;o++){var a=n[o];(s=i[a.id]).refs--,r.push(s)}t&&p(d(t,e),e);for(o=0;o<r.length;o++){var s;if(0===(s=r[o]).refs){for(var u=0;u<s.parts.length;u++)s.parts[u]();delete i[s.id]}}}};var m,w=(m=[],function(t,e){return m[t]=e,m.filter(Boolean).join("\n")});function x(t,e,n,r){var o=n?"":r.css;if(t.styleSheet)t.styleSheet.cssText=w(e,o);else{var i=document.createTextNode(o),a=t.childNodes;a[e]&&t.removeChild(a[e]),a.length?t.insertBefore(i,a[e]):t.appendChild(i)}}},function(t,e){t.exports=function(t){var e="undefined"!=typeof window&&window.location;if(!e)throw new Error("fixUrls requires window.location");if(!t||"string"!=typeof t)return t;var n=e.protocol+"//"+e.host,r=n+e.pathname.replace(/\/[^\/]*$/,"/");return t.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi,function(t,e){var o,i=e.trim().replace(/^"(.*)"$/,function(t,e){return e}).replace(/^'(.*)'$/,function(t,e){return e});return/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/|\s*$)/i.test(i)?t:(o=0===i.indexOf("//")?i:0===i.indexOf("/")?n+i:r+i.replace(/^\.\//,""),"url("+JSON.stringify(o)+")")})}},function(t,e,n){"use strict";n.r(e),e.default='<svg width="17" height="12" viewBox="1 -1 16 15" xmlns="http://www.w3.org/2000/svg"><path d="M17.839 5.525a1.105 1.105 0 0 1-.015 1.547l-4.943 4.943a1.105 1.105 0 1 1-1.562-1.562l4.137-4.137-4.078-4.078A1.125 1.125 0 1 1 12.97.648l4.796 4.796c.026.026.05.053.074.08zm-14.952.791l4.137 4.137a1.105 1.105 0 1 1-1.562 1.562L.519 7.072a1.105 1.105 0 0 1-.015-1.547c.023-.028.048-.055.074-.081L5.374.647a1.125 1.125 0 0 1 1.591 1.591L2.887 6.316z" id="a"/></svg>\n'}])});

/***/ }),

/***/ "./node_modules/@editorjs/link/dist/bundle.js":
/*!****************************************************!*\
  !*** ./node_modules/@editorjs/link/dist/bundle.js ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

!function(t,e){ true?module.exports=e():undefined}(window,(function(){return function(t){var e={};function n(r){if(e[r])return e[r].exports;var o=e[r]={i:r,l:!1,exports:{}};return t[r].call(o.exports,o,o.exports,n),o.l=!0,o.exports}return n.m=t,n.c=e,n.d=function(t,e,r){n.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:r})},n.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var o in t)n.d(r,o,function(e){return t[e]}.bind(null,o));return r},n.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return n.d(e,"a",e),e},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.p="/",n(n.s=8)}([function(t,e,n){t.exports=n(13)},function(t,e){function n(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,r.key,r)}}t.exports=function(t,e,r){return e&&n(t.prototype,e),r&&n(t,r),t}},function(t,e){t.exports=function(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,r=new Array(e);n<e;n++)r[n]=t[n];return r}},function(t,e,n){var r=n(9),o=n(10),i=n(11),a=n(12);t.exports=function(t){return r(t)||o(t)||i(t)||a()}},function(t,e){function n(t,e,n,r,o,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(r,o)}t.exports=function(t){return function(){var e=this,r=arguments;return new Promise((function(o,i){var a=t.apply(e,r);function s(t){n(a,o,i,s,c,"next",t)}function c(t){n(a,o,i,s,c,"throw",t)}s(void 0)}))}}},function(t,e){t.exports=function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}},function(t,e){t.exports='<svg width="13" height="14" xmlns="http://www.w3.org/2000/svg"><path d="M8.567 13.629c.728.464 1.581.65 2.41.558l-.873.873A3.722 3.722 0 1 1 4.84 9.794L6.694 7.94a3.722 3.722 0 0 1 5.256-.008L10.484 9.4a5.209 5.209 0 0 1-.017.016 1.625 1.625 0 0 0-2.29.009l-1.854 1.854a1.626 1.626 0 0 0 2.244 2.35zm2.766-7.358a3.722 3.722 0 0 0-2.41-.558l.873-.873a3.722 3.722 0 1 1 5.264 5.266l-1.854 1.854a3.722 3.722 0 0 1-5.256.008L9.416 10.5a5.2 5.2 0 0 1 .017-.016 1.625 1.625 0 0 0 2.29-.009l1.854-1.854a1.626 1.626 0 0 0-2.244-2.35z" transform="translate(-3.667 -2.7)"></path></svg>'},function(t,e,n){window,t.exports=function(t){var e={};function n(r){if(e[r])return e[r].exports;var o=e[r]={i:r,l:!1,exports:{}};return t[r].call(o.exports,o,o.exports,n),o.l=!0,o.exports}return n.m=t,n.c=e,n.d=function(t,e,r){n.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:r})},n.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var o in t)n.d(r,o,function(e){return t[e]}.bind(null,o));return r},n.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return n.d(e,"a",e),e},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.p="",n(n.s=3)}([function(t,e){var n;n=function(){return this}();try{n=n||new Function("return this")()}catch(t){"object"==typeof window&&(n=window)}t.exports=n},function(t,e,n){"use strict";(function(t){var r=n(2),o=setTimeout;function i(){}function a(t){if(!(this instanceof a))throw new TypeError("Promises must be constructed via new");if("function"!=typeof t)throw new TypeError("not a function");this._state=0,this._handled=!1,this._value=void 0,this._deferreds=[],h(t,this)}function s(t,e){for(;3===t._state;)t=t._value;0!==t._state?(t._handled=!0,a._immediateFn((function(){var n=1===t._state?e.onFulfilled:e.onRejected;if(null!==n){var r;try{r=n(t._value)}catch(t){return void u(e.promise,t)}c(e.promise,r)}else(1===t._state?c:u)(e.promise,t._value)}))):t._deferreds.push(e)}function c(t,e){try{if(e===t)throw new TypeError("A promise cannot be resolved with itself.");if(e&&("object"==typeof e||"function"==typeof e)){var n=e.then;if(e instanceof a)return t._state=3,t._value=e,void l(t);if("function"==typeof n)return void h((r=n,o=e,function(){r.apply(o,arguments)}),t)}t._state=1,t._value=e,l(t)}catch(e){u(t,e)}var r,o}function u(t,e){t._state=2,t._value=e,l(t)}function l(t){2===t._state&&0===t._deferreds.length&&a._immediateFn((function(){t._handled||a._unhandledRejectionFn(t._value)}));for(var e=0,n=t._deferreds.length;e<n;e++)s(t,t._deferreds[e]);t._deferreds=null}function f(t,e,n){this.onFulfilled="function"==typeof t?t:null,this.onRejected="function"==typeof e?e:null,this.promise=n}function h(t,e){var n=!1;try{t((function(t){n||(n=!0,c(e,t))}),(function(t){n||(n=!0,u(e,t))}))}catch(t){if(n)return;n=!0,u(e,t)}}a.prototype.catch=function(t){return this.then(null,t)},a.prototype.then=function(t,e){var n=new this.constructor(i);return s(this,new f(t,e,n)),n},a.prototype.finally=r.a,a.all=function(t){return new a((function(e,n){if(!t||void 0===t.length)throw new TypeError("Promise.all accepts an array");var r=Array.prototype.slice.call(t);if(0===r.length)return e([]);var o=r.length;function i(t,a){try{if(a&&("object"==typeof a||"function"==typeof a)){var s=a.then;if("function"==typeof s)return void s.call(a,(function(e){i(t,e)}),n)}r[t]=a,0==--o&&e(r)}catch(t){n(t)}}for(var a=0;a<r.length;a++)i(a,r[a])}))},a.resolve=function(t){return t&&"object"==typeof t&&t.constructor===a?t:new a((function(e){e(t)}))},a.reject=function(t){return new a((function(e,n){n(t)}))},a.race=function(t){return new a((function(e,n){for(var r=0,o=t.length;r<o;r++)t[r].then(e,n)}))},a._immediateFn="function"==typeof t&&function(e){t(e)}||function(t){o(t,0)},a._unhandledRejectionFn=function(t){"undefined"!=typeof console&&console&&console.warn("Possible Unhandled Promise Rejection:",t)},e.a=a}).call(this,n(5).setImmediate)},function(t,e,n){"use strict";e.a=function(t){var e=this.constructor;return this.then((function(n){return e.resolve(t()).then((function(){return n}))}),(function(n){return e.resolve(t()).then((function(){return e.reject(n)}))}))}},function(t,e,n){"use strict";function r(t){return(r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}n(4);var o,i,a,s,c,u,l=n(8),f=(i=function(t){return new Promise((function(e,n){t=s(t),t=c(t);var r=window.XMLHttpRequest?new window.XMLHttpRequest:new window.ActiveXObject("Microsoft.XMLHTTP");r.open(t.method,t.url),r.setRequestHeader("X-Requested-With","XMLHttpRequest"),Object.keys(t.headers).forEach((function(e){var n=t.headers[e];r.setRequestHeader(e,n)}));var o=t.ratio;r.upload.addEventListener("progress",(function(e){var n=Math.round(e.loaded/e.total*100),r=Math.ceil(n*o/100);t.progress(r)}),!1),r.addEventListener("progress",(function(e){var n=Math.round(e.loaded/e.total*100),r=Math.ceil(n*(100-o)/100)+o;t.progress(r)}),!1),r.onreadystatechange=function(){if(4===r.readyState){var t=r.response;try{t=JSON.parse(t)}catch(t){}var o=l.parseHeaders(r.getAllResponseHeaders()),i={body:t,code:r.status,headers:o};200===r.status?e(i):n(i)}},r.send(t.data)}))},a=function(t){return t.method="POST",i(t)},s=function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if(t.url&&"string"!=typeof t.url)throw new Error("Url must be a string");if(t.url=t.url||"",t.method&&"string"!=typeof t.method)throw new Error("`method` must be a string or null");if(t.method=t.method?t.method.toUpperCase():"GET",t.headers&&"object"!==r(t.headers))throw new Error("`headers` must be an object or null");if(t.headers=t.headers||{},t.type&&("string"!=typeof t.type||!Object.values(o).includes(t.type)))throw new Error("`type` must be taken from module's «contentType» library");if(t.progress&&"function"!=typeof t.progress)throw new Error("`progress` must be a function or null");if(t.progress=t.progress||function(t){},t.beforeSend=t.beforeSend||function(t){},t.ratio&&"number"!=typeof t.ratio)throw new Error("`ratio` must be a number");if(t.ratio<0||t.ratio>100)throw new Error("`ratio` must be in a 0-100 interval");if(t.ratio=t.ratio||90,t.accept&&"string"!=typeof t.accept)throw new Error("`accept` must be a string with a list of allowed mime-types");if(t.accept=t.accept||"*/*",t.multiple&&"boolean"!=typeof t.multiple)throw new Error("`multiple` must be a true or false");if(t.multiple=t.multiple||!1,t.fieldName&&"string"!=typeof t.fieldName)throw new Error("`fieldName` must be a string");return t.fieldName=t.fieldName||"files",t},c=function(t){switch(t.method){case"GET":var e=u(t.data,o.URLENCODED);delete t.data,t.url=/\?/.test(t.url)?t.url+"&"+e:t.url+"?"+e;break;case"POST":case"PUT":case"DELETE":case"UPDATE":var n=function(){return(arguments.length>0&&void 0!==arguments[0]?arguments[0]:{}).type||o.JSON}(t);(l.isFormData(t.data)||l.isFormElement(t.data))&&(n=o.FORM),t.data=u(t.data,n),n!==f.contentType.FORM&&(t.headers["content-type"]=n)}return t},u=function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};switch(arguments.length>1?arguments[1]:void 0){case o.URLENCODED:return l.urlEncode(t);case o.JSON:return l.jsonEncode(t);case o.FORM:return l.formEncode(t);default:return t}},{contentType:o={URLENCODED:"application/x-www-form-urlencoded; charset=utf-8",FORM:"multipart/form-data",JSON:"application/json; charset=utf-8"},request:i,get:function(t){return t.method="GET",i(t)},post:a,transport:function(t){return t=s(t),l.selectFiles(t).then((function(e){for(var n=new FormData,r=0;r<e.length;r++)n.append(t.fieldName,e[r],e[r].name);return l.isObject(t.data)&&Object.keys(t.data).forEach((function(e){var r=t.data[e];n.append(e,r)})),t.beforeSend&&t.beforeSend(e),t.data=n,a(t)}))},selectFiles:function(t){return delete(t=s(t)).beforeSend,l.selectFiles(t)}});t.exports=f},function(t,e,n){"use strict";n.r(e);var r=n(1);window.Promise=window.Promise||r.a},function(t,e,n){(function(t){var r=void 0!==t&&t||"undefined"!=typeof self&&self||window,o=Function.prototype.apply;function i(t,e){this._id=t,this._clearFn=e}e.setTimeout=function(){return new i(o.call(setTimeout,r,arguments),clearTimeout)},e.setInterval=function(){return new i(o.call(setInterval,r,arguments),clearInterval)},e.clearTimeout=e.clearInterval=function(t){t&&t.close()},i.prototype.unref=i.prototype.ref=function(){},i.prototype.close=function(){this._clearFn.call(r,this._id)},e.enroll=function(t,e){clearTimeout(t._idleTimeoutId),t._idleTimeout=e},e.unenroll=function(t){clearTimeout(t._idleTimeoutId),t._idleTimeout=-1},e._unrefActive=e.active=function(t){clearTimeout(t._idleTimeoutId);var e=t._idleTimeout;e>=0&&(t._idleTimeoutId=setTimeout((function(){t._onTimeout&&t._onTimeout()}),e))},n(6),e.setImmediate="undefined"!=typeof self&&self.setImmediate||void 0!==t&&t.setImmediate||this&&this.setImmediate,e.clearImmediate="undefined"!=typeof self&&self.clearImmediate||void 0!==t&&t.clearImmediate||this&&this.clearImmediate}).call(this,n(0))},function(t,e,n){(function(t,e){!function(t,n){"use strict";if(!t.setImmediate){var r,o,i,a,s,c=1,u={},l=!1,f=t.document,h=Object.getPrototypeOf&&Object.getPrototypeOf(t);h=h&&h.setTimeout?h:t,"[object process]"==={}.toString.call(t.process)?r=function(t){e.nextTick((function(){p(t)}))}:function(){if(t.postMessage&&!t.importScripts){var e=!0,n=t.onmessage;return t.onmessage=function(){e=!1},t.postMessage("","*"),t.onmessage=n,e}}()?(a="setImmediate$"+Math.random()+"$",s=function(e){e.source===t&&"string"==typeof e.data&&0===e.data.indexOf(a)&&p(+e.data.slice(a.length))},t.addEventListener?t.addEventListener("message",s,!1):t.attachEvent("onmessage",s),r=function(e){t.postMessage(a+e,"*")}):t.MessageChannel?((i=new MessageChannel).port1.onmessage=function(t){p(t.data)},r=function(t){i.port2.postMessage(t)}):f&&"onreadystatechange"in f.createElement("script")?(o=f.documentElement,r=function(t){var e=f.createElement("script");e.onreadystatechange=function(){p(t),e.onreadystatechange=null,o.removeChild(e),e=null},o.appendChild(e)}):r=function(t){setTimeout(p,0,t)},h.setImmediate=function(t){"function"!=typeof t&&(t=new Function(""+t));for(var e=new Array(arguments.length-1),n=0;n<e.length;n++)e[n]=arguments[n+1];var o={callback:t,args:e};return u[c]=o,r(c),c++},h.clearImmediate=d}function d(t){delete u[t]}function p(t){if(l)setTimeout(p,0,t);else{var e=u[t];if(e){l=!0;try{!function(t){var e=t.callback,n=t.args;switch(n.length){case 0:e();break;case 1:e(n[0]);break;case 2:e(n[0],n[1]);break;case 3:e(n[0],n[1],n[2]);break;default:e.apply(void 0,n)}}(e)}finally{d(t),l=!1}}}}}("undefined"==typeof self?void 0===t?this:t:self)}).call(this,n(0),n(7))},function(t,e){var n,r,o=t.exports={};function i(){throw new Error("setTimeout has not been defined")}function a(){throw new Error("clearTimeout has not been defined")}function s(t){if(n===setTimeout)return setTimeout(t,0);if((n===i||!n)&&setTimeout)return n=setTimeout,setTimeout(t,0);try{return n(t,0)}catch(e){try{return n.call(null,t,0)}catch(e){return n.call(this,t,0)}}}!function(){try{n="function"==typeof setTimeout?setTimeout:i}catch(t){n=i}try{r="function"==typeof clearTimeout?clearTimeout:a}catch(t){r=a}}();var c,u=[],l=!1,f=-1;function h(){l&&c&&(l=!1,c.length?u=c.concat(u):f=-1,u.length&&d())}function d(){if(!l){var t=s(h);l=!0;for(var e=u.length;e;){for(c=u,u=[];++f<e;)c&&c[f].run();f=-1,e=u.length}c=null,l=!1,function(t){if(r===clearTimeout)return clearTimeout(t);if((r===a||!r)&&clearTimeout)return r=clearTimeout,clearTimeout(t);try{r(t)}catch(e){try{return r.call(null,t)}catch(e){return r.call(this,t)}}}(t)}}function p(t,e){this.fun=t,this.array=e}function m(){}o.nextTick=function(t){var e=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)e[n-1]=arguments[n];u.push(new p(t,e)),1!==u.length||l||s(d)},p.prototype.run=function(){this.fun.apply(null,this.array)},o.title="browser",o.browser=!0,o.env={},o.argv=[],o.version="",o.versions={},o.on=m,o.addListener=m,o.once=m,o.off=m,o.removeListener=m,o.removeAllListeners=m,o.emit=m,o.prependListener=m,o.prependOnceListener=m,o.listeners=function(t){return[]},o.binding=function(t){throw new Error("process.binding is not supported")},o.cwd=function(){return"/"},o.chdir=function(t){throw new Error("process.chdir is not supported")},o.umask=function(){return 0}},function(t,e,n){function r(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,r.key,r)}}var o=n(9);t.exports=function(){function t(){!function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}(this,t)}var e,n;return e=t,(n=[{key:"urlEncode",value:function(t){return o(t)}},{key:"jsonEncode",value:function(t){return JSON.stringify(t)}},{key:"formEncode",value:function(t){if(this.isFormData(t))return t;if(this.isFormElement(t))return new FormData(t);if(this.isObject(t)){var e=new FormData;return Object.keys(t).forEach((function(n){var r=t[n];e.append(n,r)})),e}throw new Error("`data` must be an instance of Object, FormData or <FORM> HTMLElement")}},{key:"isObject",value:function(t){return"[object Object]"===Object.prototype.toString.call(t)}},{key:"isFormData",value:function(t){return t instanceof FormData}},{key:"isFormElement",value:function(t){return t instanceof HTMLFormElement}},{key:"selectFiles",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return new Promise((function(e,n){var r=document.createElement("INPUT");r.type="file",t.multiple&&r.setAttribute("multiple","multiple"),t.accept&&r.setAttribute("accept",t.accept),r.style.display="none",document.body.appendChild(r),r.addEventListener("change",(function(t){var n=t.target.files;e(n),document.body.removeChild(r)}),!1),r.click()}))}},{key:"parseHeaders",value:function(t){var e=t.trim().split(/[\r\n]+/),n={};return e.forEach((function(t){var e=t.split(": "),r=e.shift(),o=e.join(": ");r&&(n[r]=o)})),n}}])&&r(e,n),t}()},function(t,e){var n=function(t){return encodeURIComponent(t).replace(/[!'()*]/g,escape).replace(/%20/g,"+")},r=function(t,e,o,i){return e=e||null,o=o||"&",i=i||null,t?function(t){for(var e=new Array,n=0;n<t.length;n++)t[n]&&e.push(t[n]);return e}(Object.keys(t).map((function(a){var s,c,u=a;if(i&&(u=i+"["+u+"]"),"object"==typeof t[a]&&null!==t[a])s=r(t[a],null,o,u);else{e&&(c=u,u=!isNaN(parseFloat(c))&&isFinite(c)?e+Number(u):u);var l=t[a];l=(l=0===(l=!1===(l=!0===l?"1":l)?"0":l)?"0":l)||"",s=n(u)+"="+n(l)}return s}))).join(o).replace(/[!'()*]/g,""):""};t.exports=r}])},function(t,e,n){"use strict";n.r(e),n.d(e,"default",(function(){return y}));var r=n(3),o=n.n(r),i=n(0),a=n.n(i),s=n(4),c=n.n(s),u=n(5),l=n.n(u),f=n(1),h=n.n(f),d=(n(14),n(6)),p=n.n(d),m=n(7),v=n.n(m),y=(n(18),function(){function t(e){var n=e.data,r=e.config,o=e.api,i=e.readOnly;l()(this,t),this.api=o,this.readOnly=i,this.config={endpoint:r.endpoint||""},this.nodes={wrapper:null,container:null,progress:null,input:null,inputHolder:null,linkContent:null,linkImage:null,linkTitle:null,linkDescription:null,linkText:null},this._data={link:"",meta:{}},this.data=n}var e;return h()(t,null,[{key:"isReadOnlySupported",get:function(){return!0}},{key:"toolbox",get:function(){return{icon:p.a,title:"Link"}}},{key:"enableLineBreaks",get:function(){return!0}}]),h()(t,[{key:"render",value:function(){return this.nodes.wrapper=this.make("div",this.CSS.baseClass),this.nodes.container=this.make("div",this.CSS.container),this.nodes.inputHolder=this.makeInputHolder(),this.nodes.linkContent=this.prepareLinkPreview(),Object.keys(this.data.meta).length?(this.nodes.container.appendChild(this.nodes.linkContent),this.showLinkPreview(this.data.meta)):this.nodes.container.appendChild(this.nodes.inputHolder),this.nodes.wrapper.appendChild(this.nodes.container),this.nodes.wrapper}},{key:"save",value:function(){return this.data}},{key:"validate",value:function(){return""!==this.data.link.trim()}},{key:"makeInputHolder",value:function(){var t=this,e=this.make("div",this.CSS.inputHolder);return this.nodes.progress=this.make("label",this.CSS.progress),this.nodes.input=this.make("div",[this.CSS.input,this.CSS.inputEl],{contentEditable:!this.readOnly}),this.nodes.input.dataset.placeholder=this.api.i18n.t("Link"),this.readOnly||(this.nodes.input.addEventListener("paste",(function(e){t.startFetching(e)})),this.nodes.input.addEventListener("keydown",(function(e){var n=e.ctrlKey||e.metaKey;switch(e.keyCode){case 13:e.preventDefault(),e.stopPropagation(),t.startFetching(e);break;case 65:n&&t.selectLinkUrl(e)}}))),e.appendChild(this.nodes.progress),e.appendChild(this.nodes.input),e}},{key:"startFetching",value:function(t){var e=this.nodes.input.textContent;"paste"===t.type&&(e=(t.clipboardData||window.clipboardData).getData("text")),this.removeErrorStyle(),this.fetchLinkData(e)}},{key:"removeErrorStyle",value:function(){this.nodes.inputHolder.classList.remove(this.CSS.inputError),this.nodes.inputHolder.insertBefore(this.nodes.progress,this.nodes.input)}},{key:"selectLinkUrl",value:function(t){t.preventDefault(),t.stopPropagation();var e=window.getSelection(),n=new Range,r=e.anchorNode.parentNode.closest(".".concat(this.CSS.inputHolder)).querySelector(".".concat(this.CSS.inputEl));n.selectNodeContents(r),e.removeAllRanges(),e.addRange(n)}},{key:"prepareLinkPreview",value:function(){var t=this.make("a",this.CSS.linkContent,{target:"_blank",rel:"nofollow noindex noreferrer"});return this.nodes.linkImage=this.make("div",this.CSS.linkImage),this.nodes.linkTitle=this.make("div",this.CSS.linkTitle),this.nodes.linkDescription=this.make("p",this.CSS.linkDescription),this.nodes.linkText=this.make("span",this.CSS.linkText),t}},{key:"showLinkPreview",value:function(t){var e=t.image,n=t.title,r=t.description;this.nodes.container.appendChild(this.nodes.linkContent),e&&e.url&&(this.nodes.linkImage.style.backgroundImage="url("+e.url+")",this.nodes.linkContent.appendChild(this.nodes.linkImage)),n&&(this.nodes.linkTitle.textContent=n,this.nodes.linkContent.appendChild(this.nodes.linkTitle)),r&&(this.nodes.linkDescription.textContent=r,this.nodes.linkContent.appendChild(this.nodes.linkDescription)),this.nodes.linkContent.classList.add(this.CSS.linkContentRendered),this.nodes.linkContent.setAttribute("href",this.data.link),this.nodes.linkContent.appendChild(this.nodes.linkText);try{this.nodes.linkText.textContent=new URL(this.data.link).hostname}catch(t){this.nodes.linkText.textContent=this.data.link}}},{key:"showProgress",value:function(){this.nodes.progress.classList.add(this.CSS.progressLoading)}},{key:"hideProgress",value:function(){var t=this;return new Promise((function(e){t.nodes.progress.classList.remove(t.CSS.progressLoading),t.nodes.progress.classList.add(t.CSS.progressLoaded),setTimeout(e,500)}))}},{key:"applyErrorStyle",value:function(){this.nodes.inputHolder.classList.add(this.CSS.inputError),this.nodes.progress.remove()}},{key:"fetchLinkData",value:(e=c()(a.a.mark((function t(e){var n,r;return a.a.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return this.showProgress(),this.data={link:e},t.prev=2,t.next=5,v.a.get({url:this.config.endpoint,data:{url:e}});case 5:n=t.sent,r=n.body,this.onFetch(r),t.next=13;break;case 10:t.prev=10,t.t0=t.catch(2),this.fetchingFailed(this.api.i18n.t("Couldn't fetch the link data"));case 13:case"end":return t.stop()}}),t,this,[[2,10]])}))),function(t){return e.apply(this,arguments)})},{key:"onFetch",value:function(t){var e=this;if(t&&t.success){var n=t.meta;this.data={meta:n},n?this.hideProgress().then((function(){e.nodes.inputHolder.remove(),e.showLinkPreview(n)})):this.fetchingFailed(this.api.i18n.t("Wrong response format from the server"))}else this.fetchingFailed(this.api.i18n.t("Couldn't get this link data, try the other one"))}},{key:"fetchingFailed",value:function(t){this.api.notifier.show({message:t,style:"error"}),this.applyErrorStyle()}},{key:"make",value:function(t){var e,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},i=document.createElement(t);Array.isArray(n)?(e=i.classList).add.apply(e,o()(n)):n&&i.classList.add(n);for(var a in r)i[a]=r[a];return i}},{key:"data",set:function(t){this._data=Object.assign({},{link:t.link||this._data.link,meta:t.meta||this._data.meta})},get:function(){return this._data}},{key:"CSS",get:function(){return{baseClass:this.api.styles.block,input:this.api.styles.input,container:"link-tool",inputEl:"link-tool__input",inputHolder:"link-tool__input-holder",inputError:"link-tool__input-holder--error",linkContent:"link-tool__content",linkContentRendered:"link-tool__content--rendered",linkImage:"link-tool__image",linkTitle:"link-tool__title",linkDescription:"link-tool__description",linkText:"link-tool__anchor",progress:"link-tool__progress",progressLoading:"link-tool__progress--loading",progressLoaded:"link-tool__progress--loaded"}}}]),t}())},function(t,e,n){var r=n(2);t.exports=function(t){if(Array.isArray(t))return r(t)}},function(t,e){t.exports=function(t){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(t))return Array.from(t)}},function(t,e,n){var r=n(2);t.exports=function(t,e){if(t){if("string"==typeof t)return r(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);return"Object"===n&&t.constructor&&(n=t.constructor.name),"Map"===n||"Set"===n?Array.from(t):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?r(t,e):void 0}}},function(t,e){t.exports=function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}},function(t,e,n){var r=function(t){"use strict";var e=Object.prototype,n=e.hasOwnProperty,r="function"==typeof Symbol?Symbol:{},o=r.iterator||"@@iterator",i=r.asyncIterator||"@@asyncIterator",a=r.toStringTag||"@@toStringTag";function s(t,e,n,r){var o=e&&e.prototype instanceof l?e:l,i=Object.create(o.prototype),a=new _(r||[]);return i._invoke=function(t,e,n){var r="suspendedStart";return function(o,i){if("executing"===r)throw new Error("Generator is already running");if("completed"===r){if("throw"===o)throw i;return x()}for(n.method=o,n.arg=i;;){var a=n.delegate;if(a){var s=b(a,n);if(s){if(s===u)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===r)throw r="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);r="executing";var l=c(t,e,n);if("normal"===l.type){if(r=n.done?"completed":"suspendedYield",l.arg===u)continue;return{value:l.arg,done:n.done}}"throw"===l.type&&(r="completed",n.method="throw",n.arg=l.arg)}}}(t,n,a),i}function c(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=s;var u={};function l(){}function f(){}function h(){}var d={};d[o]=function(){return this};var p=Object.getPrototypeOf,m=p&&p(p(E([])));m&&m!==e&&n.call(m,o)&&(d=m);var v=h.prototype=l.prototype=Object.create(d);function y(t){["next","throw","return"].forEach((function(e){t[e]=function(t){return this._invoke(e,t)}}))}function g(t,e){var r;this._invoke=function(o,i){function a(){return new e((function(r,a){!function r(o,i,a,s){var u=c(t[o],t,i);if("throw"!==u.type){var l=u.arg,f=l.value;return f&&"object"==typeof f&&n.call(f,"__await")?e.resolve(f.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(f).then((function(t){l.value=t,a(l)}),(function(t){return r("throw",t,a,s)}))}s(u.arg)}(o,i,r,a)}))}return r=r?r.then(a,a):a()}}function b(t,e){var n=t.iterator[e.method];if(void 0===n){if(e.delegate=null,"throw"===e.method){if(t.iterator.return&&(e.method="return",e.arg=void 0,b(t,e),"throw"===e.method))return u;e.method="throw",e.arg=new TypeError("The iterator does not provide a 'throw' method")}return u}var r=c(n,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,u;var o=r.arg;return o?o.done?(e[t.resultName]=o.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,u):o:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,u)}function w(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function k(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function _(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(w,this),this.reset(!0)}function E(t){if(t){var e=t[o];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var r=-1,i=function e(){for(;++r<t.length;)if(n.call(t,r))return e.value=t[r],e.done=!1,e;return e.value=void 0,e.done=!0,e};return i.next=i}}return{next:x}}function x(){return{value:void 0,done:!0}}return f.prototype=v.constructor=h,h.constructor=f,h[a]=f.displayName="GeneratorFunction",t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===f||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,h):(t.__proto__=h,a in t||(t[a]="GeneratorFunction")),t.prototype=Object.create(v),t},t.awrap=function(t){return{__await:t}},y(g.prototype),g.prototype[i]=function(){return this},t.AsyncIterator=g,t.async=function(e,n,r,o,i){void 0===i&&(i=Promise);var a=new g(s(e,n,r,o),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},y(v),v[a]="Generator",v[o]=function(){return this},v.toString=function(){return"[object Generator]"},t.keys=function(t){var e=[];for(var n in t)e.push(n);return e.reverse(),function n(){for(;e.length;){var r=e.pop();if(r in t)return n.value=r,n.done=!1,n}return n.done=!0,n}},t.values=E,_.prototype={constructor:_,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(k),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function r(n,r){return a.type="throw",a.arg=t,e.next=n,r&&(e.method="next",e.arg=void 0),!!r}for(var o=this.tryEntries.length-1;o>=0;--o){var i=this.tryEntries[o],a=i.completion;if("root"===i.tryLoc)return r("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return r(i.catchLoc,!0);if(this.prev<i.finallyLoc)return r(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return r(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return r(i.finallyLoc)}}}},abrupt:function(t,e){for(var r=this.tryEntries.length-1;r>=0;--r){var o=this.tryEntries[r];if(o.tryLoc<=this.prev&&n.call(o,"finallyLoc")&&this.prev<o.finallyLoc){var i=o;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,u):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),u},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),k(n),u}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var r=n.completion;if("throw"===r.type){var o=r.arg;k(n)}return o}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:E(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),u}},t}(t.exports);try{regeneratorRuntime=r}catch(t){Function("r","regeneratorRuntime = r")(r)}},function(t,e,n){var r=n(15),o=n(16);"string"==typeof(o=o.__esModule?o.default:o)&&(o=[[t.i,o,""]]);var i={insert:"head",singleton:!1};r(o,i);t.exports=o.locals||{}},function(t,e,n){"use strict";var r,o=function(){return void 0===r&&(r=Boolean(window&&document&&document.all&&!window.atob)),r},i=function(){var t={};return function(e){if(void 0===t[e]){var n=document.querySelector(e);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(t){n=null}t[e]=n}return t[e]}}(),a=[];function s(t){for(var e=-1,n=0;n<a.length;n++)if(a[n].identifier===t){e=n;break}return e}function c(t,e){for(var n={},r=[],o=0;o<t.length;o++){var i=t[o],c=e.base?i[0]+e.base:i[0],u=n[c]||0,l="".concat(c," ").concat(u);n[c]=u+1;var f=s(l),h={css:i[1],media:i[2],sourceMap:i[3]};-1!==f?(a[f].references++,a[f].updater(h)):a.push({identifier:l,updater:v(h,e),references:1}),r.push(l)}return r}function u(t){var e=document.createElement("style"),r=t.attributes||{};if(void 0===r.nonce){var o=n.nc;o&&(r.nonce=o)}if(Object.keys(r).forEach((function(t){e.setAttribute(t,r[t])})),"function"==typeof t.insert)t.insert(e);else{var a=i(t.insert||"head");if(!a)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");a.appendChild(e)}return e}var l,f=(l=[],function(t,e){return l[t]=e,l.filter(Boolean).join("\n")});function h(t,e,n,r){var o=n?"":r.media?"@media ".concat(r.media," {").concat(r.css,"}"):r.css;if(t.styleSheet)t.styleSheet.cssText=f(e,o);else{var i=document.createTextNode(o),a=t.childNodes;a[e]&&t.removeChild(a[e]),a.length?t.insertBefore(i,a[e]):t.appendChild(i)}}function d(t,e,n){var r=n.css,o=n.media,i=n.sourceMap;if(o?t.setAttribute("media",o):t.removeAttribute("media"),i&&btoa&&(r+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(i))))," */")),t.styleSheet)t.styleSheet.cssText=r;else{for(;t.firstChild;)t.removeChild(t.firstChild);t.appendChild(document.createTextNode(r))}}var p=null,m=0;function v(t,e){var n,r,o;if(e.singleton){var i=m++;n=p||(p=u(e)),r=h.bind(null,n,i,!1),o=h.bind(null,n,i,!0)}else n=u(e),r=d.bind(null,n,e),o=function(){!function(t){if(null===t.parentNode)return!1;t.parentNode.removeChild(t)}(n)};return r(t),function(e){if(e){if(e.css===t.css&&e.media===t.media&&e.sourceMap===t.sourceMap)return;r(t=e)}else o()}}t.exports=function(t,e){(e=e||{}).singleton||"boolean"==typeof e.singleton||(e.singleton=o());var n=c(t=t||[],e);return function(t){if(t=t||[],"[object Array]"===Object.prototype.toString.call(t)){for(var r=0;r<n.length;r++){var o=s(n[r]);a[o].references--}for(var i=c(t,e),u=0;u<n.length;u++){var l=s(n[u]);0===a[l].references&&(a[l].updater(),a.splice(l,1))}n=i}}}},function(t,e,n){(e=n(17)(!1)).push([t.i,".link-tool {\n  position: relative;\n}\n\n  .link-tool__input {\n    padding-left: 38px;\n    background-image: url(\"data:image/svg+xml,%3Csvg width='13' height='14' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M8.567 13.629c.728.464 1.581.65 2.41.558l-.873.873A3.722 3.722 0 1 1 4.84 9.794L6.694 7.94a3.722 3.722 0 0 1 5.256-.008L10.484 9.4a5.209 5.209 0 0 1-.017.016 1.625 1.625 0 0 0-2.29.009l-1.854 1.854a1.626 1.626 0 0 0 2.244 2.35zm2.766-7.358a3.722 3.722 0 0 0-2.41-.558l.873-.873a3.722 3.722 0 1 1 5.264 5.266l-1.854 1.854a3.722 3.722 0 0 1-5.256.008L9.416 10.5a5.2 5.2 0 0 1 .017-.016 1.625 1.625 0 0 0 2.29-.009l1.854-1.854a1.626 1.626 0 0 0-2.244-2.35z' fill='rgba(0, 0, 0, 0.6)' transform='translate(-3.667 -2.7)'/%3E%3C/svg%3E%0A\");\n    background-repeat: no-repeat;\n    background-position: 15px;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n  }\n\n  .link-tool__input-holder {\n      position: relative;\n    }\n\n  .link-tool__input-holder--error .link-tool__input {\n          background-image: url(\"data:image/svg+xml,%3Csvg width='13' height='14' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M8.567 13.629c.728.464 1.581.65 2.41.558l-.873.873A3.722 3.722 0 1 1 4.84 9.794L6.694 7.94a3.722 3.722 0 0 1 5.256-.008L10.484 9.4a5.209 5.209 0 0 1-.017.016 1.625 1.625 0 0 0-2.29.009l-1.854 1.854a1.626 1.626 0 0 0 2.244 2.35zm2.766-7.358a3.722 3.722 0 0 0-2.41-.558l.873-.873a3.722 3.722 0 1 1 5.264 5.266l-1.854 1.854a3.722 3.722 0 0 1-5.256.008L9.416 10.5a5.2 5.2 0 0 1 .017-.016 1.625 1.625 0 0 0 2.29-.009l1.854-1.854a1.626 1.626 0 0 0-2.244-2.35z' fill='rgb(224, 147, 147)' transform='translate(-3.667 -2.7)'/%3E%3C/svg%3E%0A\");\n          background-color: #fff3f6;\n          border-color: #f3e0e0;\n          color: #a95a5a;\n          box-shadow: inset 0 1px 3px 0 rgba(146, 62, 62, .05);\n        }\n\n  .link-tool__input[contentEditable=true][data-placeholder]::before{\n      position: absolute;\n      content: attr(data-placeholder);\n      color: #707684;\n      font-weight: normal;\n      opacity: 0;\n    }\n\n  .link-tool__input[contentEditable=true][data-placeholder]:empty::before {\n        opacity: 1;\n      }\n\n  .link-tool__input[contentEditable=true][data-placeholder]:empty:focus::before {\n         opacity: 0;\n       }\n\n  .link-tool__progress {\n    position: absolute;\n    box-shadow: inset 0 1px 3px 0 rgba(102, 85, 107, 0.04);\n    height: 100%;\n    width: 0;\n    background-color: #f4f5f7;\n    z-index: -1;\n  }\n\n  .link-tool__progress--loading {\n      -webkit-animation: progress 500ms ease-in;\n      -webkit-animation-fill-mode: forwards;\n    }\n\n  .link-tool__progress--loaded {\n      width: 100%;\n    }\n\n  .link-tool__content {\n    display: block;\n    padding: 25px;\n    border-radius: 2px;\n    box-shadow: 0 0 0 2px #fff;\n    color: initial !important;\n    text-decoration: none !important;\n  }\n\n  .link-tool__content::after {\n      content: \"\";\n      clear: both;\n      display: table;\n    }\n\n  .link-tool__content--rendered {\n      background: #fff;\n      border: 1px solid rgba(201, 201, 204, 0.48);\n      box-shadow: 0 1px 3px rgba(0,0,0, .1);\n      border-radius: 6px;\n      will-change: filter;\n      animation: link-in 450ms 1 cubic-bezier(0.215, 0.61, 0.355, 1);\n    }\n\n  .link-tool__content--rendered:hover {\n        box-shadow: 0 0 3px rgba(0,0,0, .16);\n      }\n\n  .link-tool__image {\n    background-position: center center;\n    background-repeat: no-repeat;\n    background-size: cover;\n    margin: 0 0 0 30px;\n    width: 65px;\n    height: 65px;\n    border-radius: 3px;\n    float: right;\n  }\n\n  .link-tool__title {\n    font-size: 17px;\n    font-weight: 600;\n    line-height: 1.5em;\n    margin: 0 0 10px 0;\n  }\n\n  .link-tool__title + .link-tool__anchor {\n      margin-top: 25px;\n    }\n\n  .link-tool__description {\n    margin: 0 0 20px 0;\n    font-size: 15px;\n    line-height: 1.55em;\n    display: -webkit-box;\n    -webkit-line-clamp: 3;\n    -webkit-box-orient: vertical;\n    overflow: hidden;\n  }\n\n  .link-tool__anchor {\n    display: block;\n    font-size: 15px;\n    line-height: 1em;\n    color: #888 !important;\n    border: 0 !important;\n    padding: 0 !important;\n  }\n\n@keyframes link-in {\n  from {\n    filter: blur(5px);\n  }\n\n  to {\n    filter: none;\n  }\n}\n\n.codex-editor--narrow .link-tool__image {\n  display: none;\n}\n\n@-webkit-keyframes progress {\n  0% {\n    width: 0;\n  }\n  100% {\n    width: 85%;\n  }\n}\n",""]),t.exports=e},function(t,e,n){"use strict";t.exports=function(t){var e=[];return e.toString=function(){return this.map((function(e){var n=function(t,e){var n=t[1]||"",r=t[3];if(!r)return n;if(e&&"function"==typeof btoa){var o=(a=r,s=btoa(unescape(encodeURIComponent(JSON.stringify(a)))),c="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(s),"/*# ".concat(c," */")),i=r.sources.map((function(t){return"/*# sourceURL=".concat(r.sourceRoot||"").concat(t," */")}));return[n].concat(i).concat([o]).join("\n")}var a,s,c;return[n].join("\n")}(e,t);return e[2]?"@media ".concat(e[2]," {").concat(n,"}"):n})).join("")},e.i=function(t,n,r){"string"==typeof t&&(t=[[null,t,""]]);var o={};if(r)for(var i=0;i<this.length;i++){var a=this[i][0];null!=a&&(o[a]=!0)}for(var s=0;s<t.length;s++){var c=[].concat(t[s]);r&&o[c[0]]||(n&&(c[2]?c[2]="".concat(n," and ").concat(c[2]):c[2]=n),e.push(c))}},e}},function(t,e,n){(function(t){!function(t){var e=function(){try{return!!Symbol.iterator}catch(t){return!1}}(),n=function(t){var n={next:function(){var e=t.shift();return{done:void 0===e,value:e}}};return e&&(n[Symbol.iterator]=function(){return n}),n},r=function(t){return encodeURIComponent(t).replace(/%20/g,"+")},o=function(t){return decodeURIComponent(String(t).replace(/\+/g," "))};(function(){try{var e=t.URLSearchParams;return"a=1"===new e("?a=1").toString()&&"function"==typeof e.prototype.set}catch(t){return!1}})()||function(){var o=function(t){Object.defineProperty(this,"_entries",{writable:!0,value:{}});var e=typeof t;if("undefined"===e);else if("string"===e)""!==t&&this._fromString(t);else if(t instanceof o){var n=this;t.forEach((function(t,e){n.append(e,t)}))}else{if(null===t||"object"!==e)throw new TypeError("Unsupported input's type for URLSearchParams");if("[object Array]"===Object.prototype.toString.call(t))for(var r=0;r<t.length;r++){var i=t[r];if("[object Array]"!==Object.prototype.toString.call(i)&&2===i.length)throw new TypeError("Expected [string, any] as entry at index "+r+" of URLSearchParams's input");this.append(i[0],i[1])}else for(var a in t)t.hasOwnProperty(a)&&this.append(a,t[a])}},i=o.prototype;i.append=function(t,e){t in this._entries?this._entries[t].push(String(e)):this._entries[t]=[String(e)]},i.delete=function(t){delete this._entries[t]},i.get=function(t){return t in this._entries?this._entries[t][0]:null},i.getAll=function(t){return t in this._entries?this._entries[t].slice(0):[]},i.has=function(t){return t in this._entries},i.set=function(t,e){this._entries[t]=[String(e)]},i.forEach=function(t,e){var n;for(var r in this._entries)if(this._entries.hasOwnProperty(r)){n=this._entries[r];for(var o=0;o<n.length;o++)t.call(e,n[o],r,this)}},i.keys=function(){var t=[];return this.forEach((function(e,n){t.push(n)})),n(t)},i.values=function(){var t=[];return this.forEach((function(e){t.push(e)})),n(t)},i.entries=function(){var t=[];return this.forEach((function(e,n){t.push([n,e])})),n(t)},e&&(i[Symbol.iterator]=i.entries),i.toString=function(){var t=[];return this.forEach((function(e,n){t.push(r(n)+"="+r(e))})),t.join("&")},t.URLSearchParams=o}();var i=t.URLSearchParams.prototype;"function"!=typeof i.sort&&(i.sort=function(){var t=this,e=[];this.forEach((function(n,r){e.push([r,n]),t._entries||t.delete(r)})),e.sort((function(t,e){return t[0]<e[0]?-1:t[0]>e[0]?1:0})),t._entries&&(t._entries={});for(var n=0;n<e.length;n++)this.append(e[n][0],e[n][1])}),"function"!=typeof i._fromString&&Object.defineProperty(i,"_fromString",{enumerable:!1,configurable:!1,writable:!1,value:function(t){if(this._entries)this._entries={};else{var e=[];this.forEach((function(t,n){e.push(n)}));for(var n=0;n<e.length;n++)this.delete(e[n])}var r,i=(t=t.replace(/^\?/,"")).split("&");for(n=0;n<i.length;n++)r=i[n].split("="),this.append(o(r[0]),r.length>1?o(r[1]):"")}})}(void 0!==t?t:"undefined"!=typeof window?window:"undefined"!=typeof self?self:this),function(t){if(function(){try{var e=new t.URL("b","http://a");return e.pathname="c d","http://a/c%20d"===e.href&&e.searchParams}catch(t){return!1}}()||function(){var e=t.URL,n=function(e,n){"string"!=typeof e&&(e=String(e));var r,o=document;if(n&&(void 0===t.location||n!==t.location.href)){(r=(o=document.implementation.createHTMLDocument("")).createElement("base")).href=n,o.head.appendChild(r);try{if(0!==r.href.indexOf(n))throw new Error(r.href)}catch(t){throw new Error("URL unable to set base "+n+" due to "+t)}}var i=o.createElement("a");i.href=e,r&&(o.body.appendChild(i),i.href=i.href);var a=o.createElement("input");if(a.type="url",a.value=e,":"===i.protocol||!/:/.test(i.href)||!a.checkValidity()&&!n)throw new TypeError("Invalid URL");Object.defineProperty(this,"_anchorElement",{value:i});var s=new t.URLSearchParams(this.search),c=!0,u=!0,l=this;["append","delete","set"].forEach((function(t){var e=s[t];s[t]=function(){e.apply(s,arguments),c&&(u=!1,l.search=s.toString(),u=!0)}})),Object.defineProperty(this,"searchParams",{value:s,enumerable:!0});var f=void 0;Object.defineProperty(this,"_updateSearchParams",{enumerable:!1,configurable:!1,writable:!1,value:function(){this.search!==f&&(f=this.search,u&&(c=!1,this.searchParams._fromString(this.search),c=!0))}})},r=n.prototype;["hash","host","hostname","port","protocol"].forEach((function(t){!function(t){Object.defineProperty(r,t,{get:function(){return this._anchorElement[t]},set:function(e){this._anchorElement[t]=e},enumerable:!0})}(t)})),Object.defineProperty(r,"search",{get:function(){return this._anchorElement.search},set:function(t){this._anchorElement.search=t,this._updateSearchParams()},enumerable:!0}),Object.defineProperties(r,{toString:{get:function(){var t=this;return function(){return t.href}}},href:{get:function(){return this._anchorElement.href.replace(/\?$/,"")},set:function(t){this._anchorElement.href=t,this._updateSearchParams()},enumerable:!0},pathname:{get:function(){return this._anchorElement.pathname.replace(/(^\/?)/,"/")},set:function(t){this._anchorElement.pathname=t},enumerable:!0},origin:{get:function(){var t={"http:":80,"https:":443,"ftp:":21}[this._anchorElement.protocol],e=this._anchorElement.port!=t&&""!==this._anchorElement.port;return this._anchorElement.protocol+"//"+this._anchorElement.hostname+(e?":"+this._anchorElement.port:"")},enumerable:!0},password:{get:function(){return""},set:function(t){},enumerable:!0},username:{get:function(){return""},set:function(t){},enumerable:!0}}),n.createObjectURL=function(t){return e.createObjectURL.apply(e,arguments)},n.revokeObjectURL=function(t){return e.revokeObjectURL.apply(e,arguments)},t.URL=n}(),void 0!==t.location&&!("origin"in t.location)){var e=function(){return t.location.protocol+"//"+t.location.hostname+(t.location.port?":"+t.location.port:"")};try{Object.defineProperty(t.location,"origin",{get:e,enumerable:!0})}catch(n){setInterval((function(){t.location.origin=e()}),100)}}}(void 0!==t?t:"undefined"!=typeof window?window:"undefined"!=typeof self?self:this)}).call(this,n(19))},function(t,e){var n;n=function(){return this}();try{n=n||new Function("return this")()}catch(t){"object"==typeof window&&(n=window)}t.exports=n}]).default}));

/***/ }),

/***/ "./node_modules/@editorjs/list/dist/bundle.js":
/*!****************************************************!*\
  !*** ./node_modules/@editorjs/list/dist/bundle.js ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

!function(e,t){ true?module.exports=t():undefined}(window,(function(){return function(e){var t={};function n(r){if(t[r])return t[r].exports;var i=t[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,n),i.l=!0,i.exports}return n.m=e,n.c=t,n.d=function(e,t,r){n.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:r})},n.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},n.t=function(e,t){if(1&t&&(e=n(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var i in e)n.d(r,i,function(t){return e[t]}.bind(null,i));return r},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,"a",t),t},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.p="/",n(n.s=0)}([function(e,t,n){function r(e){return function(e){if(Array.isArray(e))return i(e)}(e)||function(e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e))return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return i(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return i(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function i(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}function a(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}function o(e,t,n){return t&&a(e.prototype,t),n&&a(e,n),e}n(1).toString();var s=function(){function e(t){var n=t.data,r=(t.config,t.api),i=t.readOnly;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this._elements={wrapper:null},this.api=r,this.readOnly=i,this.settings=[{name:"unordered",title:this.api.i18n.t("Unordered"),icon:'<svg width="17" height="13" viewBox="0 0 17 13" xmlns="http://www.w3.org/2000/svg"> <path d="M5.625 4.85h9.25a1.125 1.125 0 0 1 0 2.25h-9.25a1.125 1.125 0 0 1 0-2.25zm0-4.85h9.25a1.125 1.125 0 0 1 0 2.25h-9.25a1.125 1.125 0 0 1 0-2.25zm0 9.85h9.25a1.125 1.125 0 0 1 0 2.25h-9.25a1.125 1.125 0 0 1 0-2.25zm-4.5-5a1.125 1.125 0 1 1 0 2.25 1.125 1.125 0 0 1 0-2.25zm0-4.85a1.125 1.125 0 1 1 0 2.25 1.125 1.125 0 0 1 0-2.25zm0 9.85a1.125 1.125 0 1 1 0 2.25 1.125 1.125 0 0 1 0-2.25z"/></svg>',default:!1},{name:"ordered",title:this.api.i18n.t("Ordered"),icon:'<svg width="17" height="13" viewBox="0 0 17 13" xmlns="http://www.w3.org/2000/svg"><path d="M5.819 4.607h9.362a1.069 1.069 0 0 1 0 2.138H5.82a1.069 1.069 0 1 1 0-2.138zm0-4.607h9.362a1.069 1.069 0 0 1 0 2.138H5.82a1.069 1.069 0 1 1 0-2.138zm0 9.357h9.362a1.069 1.069 0 0 1 0 2.138H5.82a1.069 1.069 0 0 1 0-2.137zM1.468 4.155V1.33c-.554.404-.926.606-1.118.606a.338.338 0 0 1-.244-.104A.327.327 0 0 1 0 1.59c0-.107.035-.184.105-.234.07-.05.192-.114.369-.192.264-.118.475-.243.633-.373.158-.13.298-.276.42-.438a3.94 3.94 0 0 1 .238-.298C1.802.019 1.872 0 1.975 0c.115 0 .208.042.277.127.07.085.105.202.105.351v3.556c0 .416-.15.624-.448.624a.421.421 0 0 1-.32-.127c-.08-.085-.121-.21-.121-.376zm-.283 6.664h1.572c.156 0 .275.03.358.091a.294.294 0 0 1 .123.25.323.323 0 0 1-.098.238c-.065.065-.164.097-.296.097H.629a.494.494 0 0 1-.353-.119.372.372 0 0 1-.126-.28c0-.068.027-.16.081-.273a.977.977 0 0 1 .178-.268c.267-.264.507-.49.722-.678.215-.188.368-.312.46-.371.165-.11.302-.222.412-.334.109-.112.192-.226.25-.344a.786.786 0 0 0 .085-.345.6.6 0 0 0-.341-.553.75.75 0 0 0-.345-.08c-.263 0-.47.11-.62.329-.02.029-.054.107-.101.235a.966.966 0 0 1-.16.295c-.059.069-.145.103-.26.103a.348.348 0 0 1-.25-.094.34.34 0 0 1-.099-.258c0-.132.031-.27.093-.413.063-.143.155-.273.279-.39.123-.116.28-.21.47-.282.189-.072.411-.107.666-.107.307 0 .569.045.786.137a1.182 1.182 0 0 1 .618.623 1.18 1.18 0 0 1-.096 1.083 2.03 2.03 0 0 1-.378.457c-.128.11-.344.282-.646.517-.302.235-.509.417-.621.547a1.637 1.637 0 0 0-.148.187z"/></svg>',default:!0}],this._data={style:this.settings.find((function(e){return!0===e.default})).name,items:[]},this.data=n}return o(e,null,[{key:"isReadOnlySupported",get:function(){return!0}},{key:"enableLineBreaks",get:function(){return!0}},{key:"toolbox",get:function(){return{icon:'<svg width="17" height="13" viewBox="0 0 17 13" xmlns="http://www.w3.org/2000/svg"> <path d="M5.625 4.85h9.25a1.125 1.125 0 0 1 0 2.25h-9.25a1.125 1.125 0 0 1 0-2.25zm0-4.85h9.25a1.125 1.125 0 0 1 0 2.25h-9.25a1.125 1.125 0 0 1 0-2.25zm0 9.85h9.25a1.125 1.125 0 0 1 0 2.25h-9.25a1.125 1.125 0 0 1 0-2.25zm-4.5-5a1.125 1.125 0 1 1 0 2.25 1.125 1.125 0 0 1 0-2.25zm0-4.85a1.125 1.125 0 1 1 0 2.25 1.125 1.125 0 0 1 0-2.25zm0 9.85a1.125 1.125 0 1 1 0 2.25 1.125 1.125 0 0 1 0-2.25z"/></svg>',title:"List"}}}]),o(e,[{key:"render",value:function(){var e=this,t="ordered"===this._data.style?this.CSS.wrapperOrdered:this.CSS.wrapperUnordered;return this._elements.wrapper=this._make("ul",[this.CSS.baseBlock,this.CSS.wrapper,t],{contentEditable:!this.readOnly}),this._data.items.length?this._data.items.forEach((function(t){e._elements.wrapper.appendChild(e._make("li",e.CSS.item,{innerHTML:t}))})):this._elements.wrapper.appendChild(this._make("li",this.CSS.item)),this.readOnly||this._elements.wrapper.addEventListener("keydown",(function(t){switch(t.keyCode){case 13:e.getOutofList(t);break;case 8:e.backspace(t)}}),!1),this._elements.wrapper}},{key:"save",value:function(){return this.data}},{key:"renderSettings",value:function(){var e=this,t=this._make("div",[this.CSS.settingsWrapper],{});return this.settings.forEach((function(n){var r=e._make("div",e.CSS.settingsButton,{innerHTML:n.icon});r.addEventListener("click",(function(){e.toggleTune(n.name);var t=r.parentNode.querySelectorAll("."+e.CSS.settingsButton);Array.from(t).forEach((function(t){return t.classList.remove(e.CSS.settingsButtonActive)})),r.classList.toggle(e.CSS.settingsButtonActive)})),e.api.tooltip.onHover(r,n.title,{placement:"top",hidingDelay:500}),e._data.style===n.name&&r.classList.add(e.CSS.settingsButtonActive),t.appendChild(r)})),t}},{key:"onPaste",value:function(e){var t=e.detail.data;this.data=this.pasteHandler(t)}},{key:"toggleTune",value:function(e){this._elements.wrapper.classList.toggle(this.CSS.wrapperOrdered,"ordered"===e),this._elements.wrapper.classList.toggle(this.CSS.wrapperUnordered,"unordered"===e),this._data.style=e}},{key:"_make",value:function(e){var t,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=document.createElement(e);Array.isArray(n)?(t=a.classList).add.apply(t,r(n)):n&&a.classList.add(n);for(var o in i)a[o]=i[o];return a}},{key:"getOutofList",value:function(e){var t=this._elements.wrapper.querySelectorAll("."+this.CSS.item);if(!(t.length<2)){var n=t[t.length-1],r=this.currentItem;r!==n||n.textContent.trim().length||(r.parentElement.removeChild(r),this.api.blocks.insert(void 0,void 0,void 0,void 0,!0),e.preventDefault(),e.stopPropagation())}}},{key:"backspace",value:function(e){var t=this._elements.wrapper.querySelectorAll("."+this.CSS.item),n=t[0];n&&t.length<2&&!n.innerHTML.replace("<br>"," ").trim()&&e.preventDefault()}},{key:"selectItem",value:function(e){e.preventDefault();var t=window.getSelection(),n=t.anchorNode.parentNode.closest("."+this.CSS.item),r=new Range;r.selectNodeContents(n),t.removeAllRanges(),t.addRange(r)}},{key:"pasteHandler",value:function(e){var t,n=e.tagName;switch(n){case"OL":t="ordered";break;case"UL":case"LI":t="unordered"}var r={style:t,items:[]};if("LI"===n)r.items=[e.innerHTML];else{var i=Array.from(e.querySelectorAll("LI"));r.items=i.map((function(e){return e.innerHTML})).filter((function(e){return!!e.trim()}))}return r}},{key:"CSS",get:function(){return{baseBlock:this.api.styles.block,wrapper:"cdx-list",wrapperOrdered:"cdx-list--ordered",wrapperUnordered:"cdx-list--unordered",item:"cdx-list__item",settingsWrapper:"cdx-list-settings",settingsButton:this.api.styles.settingsButton,settingsButtonActive:this.api.styles.settingsButtonActive}}},{key:"data",set:function(e){e||(e={}),this._data.style=e.style||this.settings.find((function(e){return!0===e.default})).name,this._data.items=e.items||[];var t=this._elements.wrapper;t&&t.parentNode.replaceChild(this.render(),t)},get:function(){this._data.items=[];for(var e=this._elements.wrapper.querySelectorAll(".".concat(this.CSS.item)),t=0;t<e.length;t++){e[t].innerHTML.replace("<br>"," ").trim()&&this._data.items.push(e[t].innerHTML)}return this._data}},{key:"currentItem",get:function(){var e=window.getSelection().anchorNode;return e.nodeType!==Node.ELEMENT_NODE&&(e=e.parentNode),e.closest(".".concat(this.CSS.item))}}],[{key:"conversionConfig",get:function(){return{export:function(e){return e.items.join(". ")},import:function(e){return{items:[e],style:"unordered"}}}}},{key:"sanitize",get:function(){return{style:{},items:{br:!0}}}},{key:"pasteConfig",get:function(){return{tags:["OL","UL","LI"]}}}]),e}();e.exports=s},function(e,t,n){var r=n(2),i=n(3);"string"==typeof(i=i.__esModule?i.default:i)&&(i=[[e.i,i,""]]);var a={insert:"head",singleton:!1};r(i,a);e.exports=i.locals||{}},function(e,t,n){"use strict";var r,i=function(){return void 0===r&&(r=Boolean(window&&document&&document.all&&!window.atob)),r},a=function(){var e={};return function(t){if(void 0===e[t]){var n=document.querySelector(t);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(e){n=null}e[t]=n}return e[t]}}(),o=[];function s(e){for(var t=-1,n=0;n<o.length;n++)if(o[n].identifier===e){t=n;break}return t}function c(e,t){for(var n={},r=[],i=0;i<e.length;i++){var a=e[i],c=t.base?a[0]+t.base:a[0],l=n[c]||0,u="".concat(c," ").concat(l);n[c]=l+1;var d=s(u),f={css:a[1],media:a[2],sourceMap:a[3]};-1!==d?(o[d].references++,o[d].updater(f)):o.push({identifier:u,updater:v(f,t),references:1}),r.push(u)}return r}function l(e){var t=document.createElement("style"),r=e.attributes||{};if(void 0===r.nonce){var i=n.nc;i&&(r.nonce=i)}if(Object.keys(r).forEach((function(e){t.setAttribute(e,r[e])})),"function"==typeof e.insert)e.insert(t);else{var o=a(e.insert||"head");if(!o)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");o.appendChild(t)}return t}var u,d=(u=[],function(e,t){return u[e]=t,u.filter(Boolean).join("\n")});function f(e,t,n,r){var i=n?"":r.media?"@media ".concat(r.media," {").concat(r.css,"}"):r.css;if(e.styleSheet)e.styleSheet.cssText=d(t,i);else{var a=document.createTextNode(i),o=e.childNodes;o[t]&&e.removeChild(o[t]),o.length?e.insertBefore(a,o[t]):e.appendChild(a)}}function p(e,t,n){var r=n.css,i=n.media,a=n.sourceMap;if(i?e.setAttribute("media",i):e.removeAttribute("media"),a&&btoa&&(r+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(a))))," */")),e.styleSheet)e.styleSheet.cssText=r;else{for(;e.firstChild;)e.removeChild(e.firstChild);e.appendChild(document.createTextNode(r))}}var h=null,m=0;function v(e,t){var n,r,i;if(t.singleton){var a=m++;n=h||(h=l(t)),r=f.bind(null,n,a,!1),i=f.bind(null,n,a,!0)}else n=l(t),r=p.bind(null,n,t),i=function(){!function(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e)}(n)};return r(e),function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap)return;r(e=t)}else i()}}e.exports=function(e,t){(t=t||{}).singleton||"boolean"==typeof t.singleton||(t.singleton=i());var n=c(e=e||[],t);return function(e){if(e=e||[],"[object Array]"===Object.prototype.toString.call(e)){for(var r=0;r<n.length;r++){var i=s(n[r]);o[i].references--}for(var a=c(e,t),l=0;l<n.length;l++){var u=s(n[l]);0===o[u].references&&(o[u].updater(),o.splice(u,1))}n=a}}}},function(e,t,n){(t=n(4)(!1)).push([e.i,".cdx-list {\n    margin: 0;\n    padding-left: 40px;\n    outline: none;\n}\n\n    .cdx-list__item {\n        padding: 5.5px 0 5.5px 3px;\n        line-height: 1.6em;\n    }\n\n    .cdx-list--unordered {\n        list-style: disc;\n    }\n\n    .cdx-list--ordered {\n        list-style: decimal;\n    }\n\n    .cdx-list-settings {\n        display: flex;\n    }\n\n    .cdx-list-settings .cdx-settings-button {\n            width: 50%;\n        }\n",""]),e.exports=t},function(e,t,n){"use strict";e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var n=function(e,t){var n=e[1]||"",r=e[3];if(!r)return n;if(t&&"function"==typeof btoa){var i=(o=r,s=btoa(unescape(encodeURIComponent(JSON.stringify(o)))),c="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(s),"/*# ".concat(c," */")),a=r.sources.map((function(e){return"/*# sourceURL=".concat(r.sourceRoot||"").concat(e," */")}));return[n].concat(a).concat([i]).join("\n")}var o,s,c;return[n].join("\n")}(t,e);return t[2]?"@media ".concat(t[2]," {").concat(n,"}"):n})).join("")},t.i=function(e,n,r){"string"==typeof e&&(e=[[null,e,""]]);var i={};if(r)for(var a=0;a<this.length;a++){var o=this[a][0];null!=o&&(i[o]=!0)}for(var s=0;s<e.length;s++){var c=[].concat(e[s]);r&&i[c[0]]||(n&&(c[2]?c[2]="".concat(n," and ").concat(c[2]):c[2]=n),t.push(c))}},t}}])}));

/***/ }),

/***/ "./node_modules/@editorjs/quote/dist/bundle.js":
/*!*****************************************************!*\
  !*** ./node_modules/@editorjs/quote/dist/bundle.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

!function(t,e){ true?module.exports=e():undefined}(window,function(){return function(t){var e={};function n(r){if(e[r])return e[r].exports;var o=e[r]={i:r,l:!1,exports:{}};return t[r].call(o.exports,o,o.exports,n),o.l=!0,o.exports}return n.m=t,n.c=e,n.d=function(t,e,r){n.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:r})},n.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var o in t)n.d(r,o,function(e){return t[e]}.bind(null,o));return r},n.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return n.d(e,"a",e),e},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.p="/",n(n.s=0)}([function(t,e,n){function r(t){return function(t){if(Array.isArray(t)){for(var e=0,n=new Array(t.length);e<t.length;e++)n[e]=t[e];return n}}(t)||function(t){if(Symbol.iterator in Object(t)||"[object Arguments]"===Object.prototype.toString.call(t))return Array.from(t)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()}function o(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,r.key,r)}}function i(t,e,n){return e&&o(t.prototype,e),n&&o(t,n),t}n(1).toString();var a=function(){function t(e){var n=e.data,r=e.config,o=e.api,i=e.readOnly;!function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}(this,t);var a=t.ALIGNMENTS,s=t.DEFAULT_ALIGNMENT;this.api=o,this.readOnly=i,this.quotePlaceholder=r.quotePlaceholder||t.DEFAULT_QUOTE_PLACEHOLDER,this.captionPlaceholder=r.captionPlaceholder||t.DEFAULT_CAPTION_PLACEHOLDER,this.data={text:n.text||"",caption:n.caption||"",alignment:Object.values(a).includes(n.alignment)&&n.alignment||r.defaultAlignment||s}}return i(t,[{key:"CSS",get:function(){return{baseClass:this.api.styles.block,wrapper:"cdx-quote",text:"cdx-quote__text",input:this.api.styles.input,caption:"cdx-quote__caption",settingsWrapper:"cdx-quote-settings",settingsButton:this.api.styles.settingsButton,settingsButtonActive:this.api.styles.settingsButtonActive}}},{key:"settings",get:function(){return[{name:"left",icon:'<svg width="16" height="11" viewBox="0 0 16 11" xmlns="http://www.w3.org/2000/svg" ><path d="M1.069 0H13.33a1.069 1.069 0 0 1 0 2.138H1.07a1.069 1.069 0 1 1 0-2.138zm0 4.275H9.03a1.069 1.069 0 1 1 0 2.137H1.07a1.069 1.069 0 1 1 0-2.137zm0 4.275h9.812a1.069 1.069 0 0 1 0 2.137H1.07a1.069 1.069 0 0 1 0-2.137z" /></svg>'},{name:"center",icon:'<svg width="16" height="11" viewBox="0 0 16 11" xmlns="http://www.w3.org/2000/svg" ><path d="M1.069 0H13.33a1.069 1.069 0 0 1 0 2.138H1.07a1.069 1.069 0 1 1 0-2.138zm3.15 4.275h5.962a1.069 1.069 0 0 1 0 2.137H4.22a1.069 1.069 0 1 1 0-2.137zM1.069 8.55H13.33a1.069 1.069 0 0 1 0 2.137H1.07a1.069 1.069 0 0 1 0-2.137z"/></svg>'}]}}],[{key:"isReadOnlySupported",get:function(){return!0}},{key:"toolbox",get:function(){return{icon:'<svg width="15" height="14" viewBox="0 0 15 14" xmlns="http://www.w3.org/2000/svg"><path d="M13.53 6.185l.027.025a1.109 1.109 0 0 1 0 1.568l-5.644 5.644a1.109 1.109 0 1 1-1.569-1.568l4.838-4.837L6.396 2.23A1.125 1.125 0 1 1 7.986.64l5.52 5.518.025.027zm-5.815 0l.026.025a1.109 1.109 0 0 1 0 1.568l-5.644 5.644a1.109 1.109 0 1 1-1.568-1.568l4.837-4.837L.58 2.23A1.125 1.125 0 0 1 2.171.64L7.69 6.158l.025.027z" /></svg>',title:"Quote"}}},{key:"contentless",get:function(){return!0}},{key:"enableLineBreaks",get:function(){return!0}},{key:"DEFAULT_QUOTE_PLACEHOLDER",get:function(){return"Enter a quote"}},{key:"DEFAULT_CAPTION_PLACEHOLDER",get:function(){return"Enter a caption"}},{key:"ALIGNMENTS",get:function(){return{left:"left",center:"center"}}},{key:"DEFAULT_ALIGNMENT",get:function(){return t.ALIGNMENTS.left}},{key:"conversionConfig",get:function(){return{import:"text",export:function(t){return t.caption?"".concat(t.text," — ").concat(t.caption):t.text}}}}]),i(t,[{key:"render",value:function(){var t=this._make("blockquote",[this.CSS.baseClass,this.CSS.wrapper]),e=this._make("div",[this.CSS.input,this.CSS.text],{contentEditable:!this.readOnly,innerHTML:this.data.text}),n=this._make("div",[this.CSS.input,this.CSS.caption],{contentEditable:!this.readOnly,innerHTML:this.data.caption});return e.dataset.placeholder=this.quotePlaceholder,n.dataset.placeholder=this.captionPlaceholder,t.appendChild(e),t.appendChild(n),t}},{key:"save",value:function(t){var e=t.querySelector(".".concat(this.CSS.text)),n=t.querySelector(".".concat(this.CSS.caption));return Object.assign(this.data,{text:e.innerHTML,caption:n.innerHTML})}},{key:"renderSettings",value:function(){var t=this,e=this._make("div",[this.CSS.settingsWrapper],{});return this.settings.map(function(n){var r,o=t._make("div",t.CSS.settingsButton,{innerHTML:n.icon,title:"".concat((r=n.name,r[0].toUpperCase()+r.substr(1))," alignment")});return o.classList.toggle(t.CSS.settingsButtonActive,n.name===t.data.alignment),e.appendChild(o),o}).forEach(function(e,n,r){e.addEventListener("click",function(){t._toggleTune(t.settings[n].name),r.forEach(function(e,n){var r=t.settings[n].name;e.classList.toggle(t.CSS.settingsButtonActive,r===t.data.alignment)})})}),e}},{key:"_toggleTune",value:function(t){this.data.alignment=t}},{key:"_make",value:function(t){var e,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,o=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},i=document.createElement(t);Array.isArray(n)?(e=i.classList).add.apply(e,r(n)):n&&i.classList.add(n);for(var a in o)i[a]=o[a];return i}}],[{key:"sanitize",get:function(){return{text:{br:!0},caption:{br:!0},alignment:{}}}}]),t}();t.exports=a},function(t,e,n){var r=n(2);"string"==typeof r&&(r=[[t.i,r,""]]);var o={hmr:!0,transform:void 0,insertInto:void 0};n(4)(r,o);r.locals&&(t.exports=r.locals)},function(t,e,n){(t.exports=n(3)(!1)).push([t.i,".cdx-quote-icon svg {\n  transform: rotate(180deg);\n}\n\n.cdx-quote {\n  margin: 0;\n}\n\n.cdx-quote__text {\n  min-height: 158px;\n  margin-bottom: 10px;\n}\n\n.cdx-quote__caption {}\n\n.cdx-quote [contentEditable=true][data-placeholder]::before{\n  position: absolute;\n  content: attr(data-placeholder);\n  color: #707684;\n  font-weight: normal;\n  opacity: 0;\n}\n\n.cdx-quote [contentEditable=true][data-placeholder]:empty::before {\n  opacity: 1;\n}\n\n.cdx-quote [contentEditable=true][data-placeholder]:empty:focus::before {\n  opacity: 0;\n}\n\n\n.cdx-quote-settings {\n  display: flex;\n}\n\n.cdx-quote-settings .cdx-settings-button {\n  width: 50%;\n}\n",""])},function(t,e){t.exports=function(t){var e=[];return e.toString=function(){return this.map(function(e){var n=function(t,e){var n=t[1]||"",r=t[3];if(!r)return n;if(e&&"function"==typeof btoa){var o=(a=r,"/*# sourceMappingURL=data:application/json;charset=utf-8;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(a))))+" */"),i=r.sources.map(function(t){return"/*# sourceURL="+r.sourceRoot+t+" */"});return[n].concat(i).concat([o]).join("\n")}var a;return[n].join("\n")}(e,t);return e[2]?"@media "+e[2]+"{"+n+"}":n}).join("")},e.i=function(t,n){"string"==typeof t&&(t=[[null,t,""]]);for(var r={},o=0;o<this.length;o++){var i=this[o][0];"number"==typeof i&&(r[i]=!0)}for(o=0;o<t.length;o++){var a=t[o];"number"==typeof a[0]&&r[a[0]]||(n&&!a[2]?a[2]=n:n&&(a[2]="("+a[2]+") and ("+n+")"),e.push(a))}},e}},function(t,e,n){var r,o,i={},a=(r=function(){return window&&document&&document.all&&!window.atob},function(){return void 0===o&&(o=r.apply(this,arguments)),o}),s=function(t){var e={};return function(t){if("function"==typeof t)return t();if(void 0===e[t]){var n=function(t){return document.querySelector(t)}.call(this,t);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(t){n=null}e[t]=n}return e[t]}}(),c=null,u=0,l=[],f=n(5);function p(t,e){for(var n=0;n<t.length;n++){var r=t[n],o=i[r.id];if(o){o.refs++;for(var a=0;a<o.parts.length;a++)o.parts[a](r.parts[a]);for(;a<r.parts.length;a++)o.parts.push(m(r.parts[a],e))}else{var s=[];for(a=0;a<r.parts.length;a++)s.push(m(r.parts[a],e));i[r.id]={id:r.id,refs:1,parts:s}}}}function d(t,e){for(var n=[],r={},o=0;o<t.length;o++){var i=t[o],a=e.base?i[0]+e.base:i[0],s={css:i[1],media:i[2],sourceMap:i[3]};r[a]?r[a].parts.push(s):n.push(r[a]={id:a,parts:[s]})}return n}function h(t,e){var n=s(t.insertInto);if(!n)throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");var r=l[l.length-1];if("top"===t.insertAt)r?r.nextSibling?n.insertBefore(e,r.nextSibling):n.appendChild(e):n.insertBefore(e,n.firstChild),l.push(e);else if("bottom"===t.insertAt)n.appendChild(e);else{if("object"!=typeof t.insertAt||!t.insertAt.before)throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");var o=s(t.insertInto+" "+t.insertAt.before);n.insertBefore(e,o)}}function g(t){if(null===t.parentNode)return!1;t.parentNode.removeChild(t);var e=l.indexOf(t);e>=0&&l.splice(e,1)}function v(t){var e=document.createElement("style");return void 0===t.attrs.type&&(t.attrs.type="text/css"),y(e,t.attrs),h(t,e),e}function y(t,e){Object.keys(e).forEach(function(n){t.setAttribute(n,e[n])})}function m(t,e){var n,r,o,i;if(e.transform&&t.css){if(!(i=e.transform(t.css)))return function(){};t.css=i}if(e.singleton){var a=u++;n=c||(c=v(e)),r=w.bind(null,n,a,!1),o=w.bind(null,n,a,!0)}else t.sourceMap&&"function"==typeof URL&&"function"==typeof URL.createObjectURL&&"function"==typeof URL.revokeObjectURL&&"function"==typeof Blob&&"function"==typeof btoa?(n=function(t){var e=document.createElement("link");return void 0===t.attrs.type&&(t.attrs.type="text/css"),t.attrs.rel="stylesheet",y(e,t.attrs),h(t,e),e}(e),r=function(t,e,n){var r=n.css,o=n.sourceMap,i=void 0===e.convertToAbsoluteUrls&&o;(e.convertToAbsoluteUrls||i)&&(r=f(r));o&&(r+="\n/*# sourceMappingURL=data:application/json;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(o))))+" */");var a=new Blob([r],{type:"text/css"}),s=t.href;t.href=URL.createObjectURL(a),s&&URL.revokeObjectURL(s)}.bind(null,n,e),o=function(){g(n),n.href&&URL.revokeObjectURL(n.href)}):(n=v(e),r=function(t,e){var n=e.css,r=e.media;r&&t.setAttribute("media",r);if(t.styleSheet)t.styleSheet.cssText=n;else{for(;t.firstChild;)t.removeChild(t.firstChild);t.appendChild(document.createTextNode(n))}}.bind(null,n),o=function(){g(n)});return r(t),function(e){if(e){if(e.css===t.css&&e.media===t.media&&e.sourceMap===t.sourceMap)return;r(t=e)}else o()}}t.exports=function(t,e){if("undefined"!=typeof DEBUG&&DEBUG&&"object"!=typeof document)throw new Error("The style-loader cannot be used in a non-browser environment");(e=e||{}).attrs="object"==typeof e.attrs?e.attrs:{},e.singleton||"boolean"==typeof e.singleton||(e.singleton=a()),e.insertInto||(e.insertInto="head"),e.insertAt||(e.insertAt="bottom");var n=d(t,e);return p(n,e),function(t){for(var r=[],o=0;o<n.length;o++){var a=n[o];(s=i[a.id]).refs--,r.push(s)}t&&p(d(t,e),e);for(o=0;o<r.length;o++){var s;if(0===(s=r[o]).refs){for(var c=0;c<s.parts.length;c++)s.parts[c]();delete i[s.id]}}}};var b,x=(b=[],function(t,e){return b[t]=e,b.filter(Boolean).join("\n")});function w(t,e,n,r){var o=n?"":r.css;if(t.styleSheet)t.styleSheet.cssText=x(e,o);else{var i=document.createTextNode(o),a=t.childNodes;a[e]&&t.removeChild(a[e]),a.length?t.insertBefore(i,a[e]):t.appendChild(i)}}},function(t,e){t.exports=function(t){var e="undefined"!=typeof window&&window.location;if(!e)throw new Error("fixUrls requires window.location");if(!t||"string"!=typeof t)return t;var n=e.protocol+"//"+e.host,r=n+e.pathname.replace(/\/[^\/]*$/,"/");return t.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi,function(t,e){var o,i=e.trim().replace(/^"(.*)"$/,function(t,e){return e}).replace(/^'(.*)'$/,function(t,e){return e});return/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/|\s*$)/i.test(i)?t:(o=0===i.indexOf("//")?i:0===i.indexOf("/")?n+i:r+i.replace(/^\.\//,""),"url("+JSON.stringify(o)+")")})}}])});

/***/ }),

/***/ "./node_modules/@editorjs/table/dist/bundle.js":
/*!*****************************************************!*\
  !*** ./node_modules/@editorjs/table/dist/bundle.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

!function(t,e){ true?module.exports=e():undefined}(window,function(){return function(t){var e={};function o(n){if(e[n])return e[n].exports;var i=e[n]={i:n,l:!1,exports:{}};return t[n].call(i.exports,i,i.exports,o),i.l=!0,i.exports}return o.m=t,o.c=e,o.d=function(t,e,n){o.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:n})},o.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},o.t=function(t,e){if(1&e&&(t=o(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var n=Object.create(null);if(o.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var i in t)o.d(n,i,function(e){return t[e]}.bind(null,i));return n},o.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return o.d(e,"a",e),e},o.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},o.p="",o(o.s=3)}([function(t,e){t.exports=function(t){var e=[];return e.toString=function(){return this.map(function(e){var o=function(t,e){var o=t[1]||"",n=t[3];if(!n)return o;if(e&&"function"==typeof btoa){var i=(l=n,"/*# sourceMappingURL=data:application/json;charset=utf-8;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(l))))+" */"),r=n.sources.map(function(t){return"/*# sourceURL="+n.sourceRoot+t+" */"});return[o].concat(r).concat([i]).join("\n")}var l;return[o].join("\n")}(e,t);return e[2]?"@media "+e[2]+"{"+o+"}":o}).join("")},e.i=function(t,o){"string"==typeof t&&(t=[[null,t,""]]);for(var n={},i=0;i<this.length;i++){var r=this[i][0];"number"==typeof r&&(n[r]=!0)}for(i=0;i<t.length;i++){var l=t[i];"number"==typeof l[0]&&n[l[0]]||(o&&!l[2]?l[2]=o:o&&(l[2]="("+l[2]+") and ("+o+")"),e.push(l))}},e}},function(t,e,o){var n,i,r={},l=(n=function(){return window&&document&&document.all&&!window.atob},function(){return void 0===i&&(i=n.apply(this,arguments)),i}),s=function(t){var e={};return function(t,o){if("function"==typeof t)return t();if(void 0===e[t]){var n=function(t,e){return e?e.querySelector(t):document.querySelector(t)}.call(this,t,o);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(t){n=null}e[t]=n}return e[t]}}(),a=null,c=0,h=[],d=o(6);function u(t,e){for(var o=0;o<t.length;o++){var n=t[o],i=r[n.id];if(i){i.refs++;for(var l=0;l<i.parts.length;l++)i.parts[l](n.parts[l]);for(;l<n.parts.length;l++)i.parts.push(g(n.parts[l],e))}else{var s=[];for(l=0;l<n.parts.length;l++)s.push(g(n.parts[l],e));r[n.id]={id:n.id,refs:1,parts:s}}}}function f(t,e){for(var o=[],n={},i=0;i<t.length;i++){var r=t[i],l=e.base?r[0]+e.base:r[0],s={css:r[1],media:r[2],sourceMap:r[3]};n[l]?n[l].parts.push(s):o.push(n[l]={id:l,parts:[s]})}return o}function p(t,e){var o=s(t.insertInto);if(!o)throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");var n=h[h.length-1];if("top"===t.insertAt)n?n.nextSibling?o.insertBefore(e,n.nextSibling):o.appendChild(e):o.insertBefore(e,o.firstChild),h.push(e);else if("bottom"===t.insertAt)o.appendChild(e);else{if("object"!=typeof t.insertAt||!t.insertAt.before)throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");var i=s(t.insertAt.before,o);o.insertBefore(e,i)}}function _(t){if(null===t.parentNode)return!1;t.parentNode.removeChild(t);var e=h.indexOf(t);e>=0&&h.splice(e,1)}function b(t){var e=document.createElement("style");if(void 0===t.attrs.type&&(t.attrs.type="text/css"),void 0===t.attrs.nonce){var n=function(){0;return o.nc}();n&&(t.attrs.nonce=n)}return v(e,t.attrs),p(t,e),e}function v(t,e){Object.keys(e).forEach(function(o){t.setAttribute(o,e[o])})}function g(t,e){var o,n,i,r;if(e.transform&&t.css){if(!(r="function"==typeof e.transform?e.transform(t.css):e.transform.default(t.css)))return function(){};t.css=r}if(e.singleton){var l=c++;o=a||(a=b(e)),n=w.bind(null,o,l,!1),i=w.bind(null,o,l,!0)}else t.sourceMap&&"function"==typeof URL&&"function"==typeof URL.createObjectURL&&"function"==typeof URL.revokeObjectURL&&"function"==typeof Blob&&"function"==typeof btoa?(o=function(t){var e=document.createElement("link");return void 0===t.attrs.type&&(t.attrs.type="text/css"),t.attrs.rel="stylesheet",v(e,t.attrs),p(t,e),e}(e),n=function(t,e,o){var n=o.css,i=o.sourceMap,r=void 0===e.convertToAbsoluteUrls&&i;(e.convertToAbsoluteUrls||r)&&(n=d(n));i&&(n+="\n/*# sourceMappingURL=data:application/json;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(i))))+" */");var l=new Blob([n],{type:"text/css"}),s=t.href;t.href=URL.createObjectURL(l),s&&URL.revokeObjectURL(s)}.bind(null,o,e),i=function(){_(o),o.href&&URL.revokeObjectURL(o.href)}):(o=b(e),n=function(t,e){var o=e.css,n=e.media;n&&t.setAttribute("media",n);if(t.styleSheet)t.styleSheet.cssText=o;else{for(;t.firstChild;)t.removeChild(t.firstChild);t.appendChild(document.createTextNode(o))}}.bind(null,o),i=function(){_(o)});return n(t),function(e){if(e){if(e.css===t.css&&e.media===t.media&&e.sourceMap===t.sourceMap)return;n(t=e)}else i()}}t.exports=function(t,e){if("undefined"!=typeof DEBUG&&DEBUG&&"object"!=typeof document)throw new Error("The style-loader cannot be used in a non-browser environment");(e=e||{}).attrs="object"==typeof e.attrs?e.attrs:{},e.singleton||"boolean"==typeof e.singleton||(e.singleton=l()),e.insertInto||(e.insertInto="head"),e.insertAt||(e.insertAt="bottom");var o=f(t,e);return u(o,e),function(t){for(var n=[],i=0;i<o.length;i++){var l=o[i];(s=r[l.id]).refs--,n.push(s)}t&&u(f(t,e),e);for(i=0;i<n.length;i++){var s;if(0===(s=n[i]).refs){for(var a=0;a<s.parts.length;a++)s.parts[a]();delete r[s.id]}}}};var m,y=(m=[],function(t,e){return m[t]=e,m.filter(Boolean).join("\n")});function w(t,e,o,n){var i=o?"":n.css;if(t.styleSheet)t.styleSheet.cssText=y(e,i);else{var r=document.createTextNode(i),l=t.childNodes;l[e]&&t.removeChild(l[e]),l.length?t.insertBefore(r,l[e]):t.appendChild(r)}}},function(t,e){t.exports='<svg viewBox="0 0 20 20"><circle cx="10" cy="10" r="10" fill="#388AE5"></circle><path fill="#FFF" d="M10.9 9.1h3.7a.9.9 0 1 1 0 1.8h-3.7v3.7a.9.9 0 1 1-1.8 0v-3.7H5.4a.9.9 0 0 1 0-1.8h3.7V5.4a.9.9 0 0 1 1.8 0v3.7z"></path></svg>'},function(t,e,o){const n=o(12).TableConstructor,i=o(11),r={input:"tc-table__inp"};t.exports=class{static get isReadOnlySupported(){return!0}static get enableLineBreaks(){return!0}static get toolbox(){return{icon:i,title:"Table"}}constructor({data:t,config:e,api:o,readOnly:i}){this.api=o,this.readOnly=i,this._tableConstructor=new n(t,e,o,i)}render(){return this._tableConstructor.htmlElement}save(t){const e=[],o=t.querySelector("table").rows;for(let t=0;t<o.length;t++){const n=o[t],i=Array.from(n.cells).map(t=>t.querySelector("."+r.input));i.every(this._isEmpty)||e.push(i.map(t=>t.innerHTML))}return{content:e}}_isEmpty(t){return!t.textContent.trim()}}},function(t,e,o){var n=o(5);"string"==typeof n&&(n=[[t.i,n,""]]);var i={hmr:!0,transform:void 0,insertInto:void 0};o(1)(n,i);n.locals&&(t.exports=n.locals)},function(t,e,o){(t.exports=o(0)(!1)).push([t.i,".tc-editor{padding:10px;position:relative;box-sizing:content-box;width:100%;left:-10px}",""])},function(t,e){t.exports=function(t){var e="undefined"!=typeof window&&window.location;if(!e)throw new Error("fixUrls requires window.location");if(!t||"string"!=typeof t)return t;var o=e.protocol+"//"+e.host,n=o+e.pathname.replace(/\/[^\/]*$/,"/");return t.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi,function(t,e){var i,r=e.trim().replace(/^"(.*)"$/,function(t,e){return e}).replace(/^'(.*)'$/,function(t,e){return e});return/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/|\s*$)/i.test(r)?t:(i=0===r.indexOf("//")?r:0===r.indexOf("/")?o+r:n+r.replace(/^\.\//,""),"url("+JSON.stringify(i)+")")})}},function(t,e,o){var n=o(8);"string"==typeof n&&(n=[[t.i,n,""]]);var i={hmr:!0,transform:void 0,insertInto:void 0};o(1)(n,i);n.locals&&(t.exports=n.locals)},function(t,e,o){(t.exports=o(0)(!1)).push([t.i,".tc-toolbar{background:#368be6;}.tc-toolbar--hidden{visibility:hidden}.tc-toolbar--hor{width:100%;height:21px;flex-direction:row;left:0;top:1px}.tc-toolbar--hor,.tc-toolbar--ver{display:flex;align-items:center;position:absolute;z-index:100}.tc-toolbar--ver{height:100%;width:21px;flex-direction:column;top:0;left:-1px}.tc-toolbar__plus{height:21px;width:21px;margin-top:0;}.tc-toolbar__plus--hor{margin-left:-10px}.tc-toolbar__plus--ver{margin-top:-10px}.tc-toolbar__shine-line--hor{min-height:1px;width:100%}.tc-toolbar__shine-line--ver{min-width:1px;height:100%}",""])},function(t,e,o){var n=o(10);"string"==typeof n&&(n=[[t.i,n,""]]);var i={hmr:!0,transform:void 0,insertInto:void 0};o(1)(n,i);n.locals&&(t.exports=n.locals)},function(t,e,o){(t.exports=o(0)(!1)).push([t.i,".tc-table{width:100%;height:100%;border-collapse:collapse;table-layout:fixed;}.tc-table__wrap{border:1px solid #dbdbe2;border-radius:3px;position:relative;height:100%;width:100%;box-sizing:border-box}.tc-table__cell{border:1px solid #dbdbe2;padding:0;vertical-align:top}.tc-table__area{padding:10px;height:100%}.tc-table__inp{outline:none;flex-grow:100;min-height:1.5em;height:100%;overflow:hidden}.tc-table tbody tr:first-child td{border-top:none}.tc-table tbody tr:last-child td{border-bottom:none}.tc-table tbody tr td:last-child{border-right:none}.tc-table tbody tr td:first-child{border-left:none}",""])},function(t,e){t.exports='<svg width="18" height="14"><path d="M2.833 8v1.95a1.7 1.7 0 0 0 1.7 1.7h3.45V8h-5.15zm0-2h5.15V2.35h-3.45a1.7 1.7 0 0 0-1.7 1.7V6zm12.3 2h-5.15v3.65h3.45a1.7 1.7 0 0 0 1.7-1.7V8zm0-2V4.05a1.7 1.7 0 0 0-1.7-1.7h-3.45V6h5.15zM4.533.1h8.9a3.95 3.95 0 0 1 3.95 3.95v5.9a3.95 3.95 0 0 1-3.95 3.95h-8.9a3.95 3.95 0 0 1-3.95-3.95v-5.9A3.95 3.95 0 0 1 4.533.1z"></path></svg>'},function(t,e,o){"use strict";o.r(e);o(4);function n(t){return!(null==t)}function i(t,e=null,o=null,i=null){const r=document.createElement(t);if(n(e))for(let t=0;t<e.length;t++)n(e[t])&&r.classList.add(e[t]);if(n(o))for(let t in o)r.setAttribute(t,o[t]);if(n(i))for(let t=0;t<i.length;t++)n(i[t])&&r.appendChild(i[t]);return r}function r(t){const e=t.getBoundingClientRect();return{y1:Math.floor(e.top+window.pageYOffset),x1:Math.floor(e.left+window.pageXOffset),x2:Math.floor(e.right+window.pageXOffset),y2:Math.floor(e.bottom+window.pageYOffset)}}function l(t,e,o){let n;return e-t.x1>=-1&&e-t.x1<=11&&(n="left"),t.x2-e>=-1&&t.x2-e<=11&&(n="right"),o-t.y1>=-1&&o-t.y1<=11&&(n="top"),t.y2-o>=-1&&t.y2-o<=11&&(n="bottom"),n}o(7);var s=o(2),a=o.n(s);const c={highlightingLine:"tc-toolbar",hidden:"tc-toolbar--hidden",horizontalToolBar:"tc-toolbar--hor",horizontalHighlightingLine:"tc-toolbar__shine-line--hor",verticalToolBar:"tc-toolbar--ver",verticalHighlightingLine:"tc-toolbar__shine-line--ver",plusButton:"tc-toolbar__plus",horizontalPlusButton:"tc-toolbar__plus--hor",verticalPlusButton:"tc-toolbar__plus--ver",area:"tc-table__area"};class h{constructor(){this._plusButton=this._generatePlusButton(),this._highlightingLine=this._generateHighlightingLine(),this._toolbar=this._generateToolBar([this._plusButton,this._highlightingLine])}hide(){this._toolbar.classList.add(c.hidden)}show(){this._toolbar.classList.remove(c.hidden),this._highlightingLine.classList.remove(c.hidden)}hideLine(){this._highlightingLine.classList.add(c.hidden)}get htmlElement(){return this._toolbar}_generatePlusButton(){const t=i("div",[c.plusButton]);return t.innerHTML=a.a,t.addEventListener("click",t=>{t.stopPropagation();const e=new CustomEvent("click",{detail:{x:t.pageX,y:t.pageY},bubbles:!0});this._toolbar.dispatchEvent(e)}),t}_generateHighlightingLine(){const t=i("div",[c.highlightingLine]);return t.addEventListener("click",t=>{t.stopPropagation();const e=new CustomEvent("click",{bubbles:!0});this._toolbar.dispatchEvent(e)}),t}_generateToolBar(t){const e=i("div",[c.hidden],null,t);return e.addEventListener("mouseleave",t=>{this._recalcMousePos(t)}),e}_recalcMousePos(t){this.hide();const e=document.elementFromPoint(t.pageX,t.pageY);if(null!==e&&e.classList.contains(c.area)){const o=new MouseEvent("mouseover",{clientX:t.pageX,clientY:t.pageY});e.dispatchEvent(o)}}}class d extends h{constructor(){super(),this._toolbar.classList.add(c.horizontalToolBar),this._plusButton.classList.add(c.horizontalPlusButton),this._highlightingLine.classList.add(c.horizontalHighlightingLine)}showIn(t){const e=Math.floor(Number.parseInt(window.getComputedStyle(this._toolbar).height)/2);this._toolbar.style.top=t-e+"px",this.show()}}class u extends h{constructor(){super(),this._toolbar.classList.add(c.verticalToolBar),this._plusButton.classList.add(c.verticalPlusButton),this._highlightingLine.classList.add(c.verticalHighlightingLine)}showIn(t){const e=Math.floor(Number.parseInt(window.getComputedStyle(this._toolbar).width)/2);this._toolbar.style.left=t-e+"px",this.show()}}o(9);const f={table:"tc-table",inputField:"tc-table__inp",cell:"tc-table__cell",wrapper:"tc-table__wrap",area:"tc-table__area"};class p{constructor(t){this.readOnly=t,this._numberOfColumns=0,this._numberOfRows=0,this._element=this._createTableWrapper(),this._table=this._element.querySelector("table"),this.readOnly||this._hangEvents()}addColumn(t=-1){this._numberOfColumns++;const e=this._table.rows;for(let o=0;o<e.length;o++){const n=e[o].insertCell(t);this._fillCell(n)}}addRow(t=-1){this._numberOfRows++;const e=this._table.insertRow(t);return this._fillRow(e),e}get htmlElement(){return this._element}get body(){return this._table}get selectedCell(){return this._selectedCell}_createTableWrapper(){return i("div",[f.wrapper],null,[i("table",[f.table])])}_createContenteditableArea(){return i("div",[f.inputField],{contenteditable:!this.readOnly})}_fillCell(t){t.classList.add(f.cell);const e=this._createContenteditableArea();t.appendChild(i("div",[f.area],null,[e]))}_fillRow(t){for(let e=0;e<this._numberOfColumns;e++){const e=t.insertCell();this._fillCell(e)}}_hangEvents(){this._table.addEventListener("focus",t=>{this._focusEditField(t)},!0),this._table.addEventListener("blur",t=>{this._blurEditField(t)},!0),this._table.addEventListener("keydown",t=>{this._pressedEnterInEditField(t)}),this._table.addEventListener("click",t=>{this._clickedOnCell(t)}),this._table.addEventListener("mouseover",t=>{this._mouseEnterInDetectArea(t),t.stopPropagation()},!0)}_focusEditField(t){t.target.classList.contains(f.inputField)&&(this._selectedCell=t.target.closest("."+f.cell))}_blurEditField(t){t.target.classList.contains(f.inputField)&&(this._selectedCell=null)}_pressedEnterInEditField(t){t.target.classList.contains(f.inputField)&&(13!==t.keyCode||t.shiftKey||t.preventDefault())}_clickedOnCell(t){if(!t.target.classList.contains(f.cell))return;t.target.querySelector("."+f.inputField).focus()}_mouseEnterInDetectArea(t){if(!t.target.classList.contains(f.area))return;const e=l(r(t.target.closest("TD")),t.pageX,t.pageY);t.target.dispatchEvent(new CustomEvent("mouseInActivatingArea",{detail:{side:e},bubbles:!0}))}}o.d(e,"TableConstructor",function(){return b});const _={editor:"tc-editor",toolBarHor:"tc-toolbar--hor",toolBarVer:"tc-toolbar--ver",inputField:"tc-table__inp"};class b{constructor(t,e,o,n){this.readOnly=n,this._table=new p(n);const r=this._resizeTable(t,e);this._fillTable(t,r),this._container=i("div",[_.editor,o.styles.block],null,[this._table.htmlElement]),this._verticalToolBar=new u,this._horizontalToolBar=new d,this._table.htmlElement.appendChild(this._horizontalToolBar.htmlElement),this._table.htmlElement.appendChild(this._verticalToolBar.htmlElement),this._hoveredCell=null,this._activatedToolBar=null,this._hoveredCellSide=null,this._plusButDelay=null,this._toolbarShowDelay=null,this.readOnly||this._hangEvents()}get htmlElement(){return this._container}_fillTable(t,e){if(void 0!==t.content)for(let o=0;o<e.rows&&o<t.content.length;o++)for(let n=0;n<e.cols&&n<t.content[o].length;n++){this._table.body.rows[o].cells[n].querySelector("."+_.inputField).innerHTML=t.content[o][n]}}_resizeTable(t,e){const o=Array.isArray(t.content),n=!!o&&t.content.length,i=o?t.content.length:void 0,r=n?t.content[0].length:void 0,l=Number.parseInt(e.rows),s=Number.parseInt(e.cols),a=!isNaN(l)&&l>0?l:void 0,c=!isNaN(s)&&s>0?s:void 0,h=i||a||2,d=r||c||2;for(let t=0;t<h;t++)this._table.addRow();for(let t=0;t<d;t++)this._table.addColumn();return{rows:h,cols:d}}_showToolBar(t,e){this._hideToolBar(),this._activatedToolBar=t,t.showIn(e)}_hideToolBar(){null!==this._activatedToolBar&&this._activatedToolBar.hide()}_hangEvents(){this._container.addEventListener("mouseInActivatingArea",t=>{this._toolbarCalling(t)}),this._container.addEventListener("click",t=>{this._clickToolbar(t)}),this._container.addEventListener("input",()=>{this._hideToolBar()}),this._container.addEventListener("keydown",t=>{this._containerKeydown(t)}),this._container.addEventListener("mouseout",t=>{this._leaveDetectArea(t)}),this._container.addEventListener("mouseover",t=>{this._mouseEnterInDetectArea(t)})}_mouseInActivatingAreaListener(t){this._hoveredCellSide=t.detail.side;const e=r(t.target),o=r(this._table.htmlElement);if(this._hoveredCell=t.target.closest("TD"),null===this._hoveredCell){const t=11;this._hoveredCell=this._container,e.x1+=t,e.y1+=t,e.x2-=t,e.y2-=t}"top"===this._hoveredCellSide&&this._showToolBar(this._horizontalToolBar,e.y1-o.y1-2),"bottom"===this._hoveredCellSide&&this._showToolBar(this._horizontalToolBar,e.y2-o.y1-1),"left"===this._hoveredCellSide&&this._showToolBar(this._verticalToolBar,e.x1-o.x1-2),"right"===this._hoveredCellSide&&this._showToolBar(this._verticalToolBar,e.x2-o.x1-1)}_isToolbar(t){return!(!t.closest("."+_.toolBarHor)&&!t.closest("."+_.toolBarVer))}_leaveDetectArea(t){this._isToolbar(t.relatedTarget)||(clearTimeout(this._toolbarShowDelay),this._hideToolBar())}_toolbarCalling(t){this._isToolbar(t.target)||(clearTimeout(this._toolbarShowDelay),this._toolbarShowDelay=setTimeout(()=>{this._mouseInActivatingAreaListener(t)},125))}_clickToolbar(t){if(!this._isToolbar(t.target))return;let e;if(this._activatedToolBar===this._horizontalToolBar?(this._addRow(),e="y"):(this._addColumn(),e="x"),isNaN(t.detail)&&null!==t.detail){const o=r(this._table.htmlElement);let n;n="x"===e?t.detail.x-o.x1:t.detail.y-o.y1,this._delayAddButtonForMultiClickingNearMouse(n)}else this._hideToolBar()}_containerKeydown(t){13===t.keyCode&&this._containerEnterPressed(t)}_delayAddButtonForMultiClickingNearMouse(t){this._showToolBar(this._activatedToolBar,t),this._activatedToolBar.hideLine(),clearTimeout(this._plusButDelay),this._plusButDelay=setTimeout(()=>{this._hideToolBar()},500)}_getHoveredSideOfContainer(){return this._hoveredCell===this._container?this._isBottomOrRight()?0:-1:1}_isBottomOrRight(){return"bottom"===this._hoveredCellSide||"right"===this._hoveredCellSide}_addRow(){const t=this._hoveredCell.closest("TR");let e=this._getHoveredSideOfContainer();1===e&&(e=t.sectionRowIndex,e+=this._isBottomOrRight()),this._table.addRow(e)}_addColumn(){let t=this._getHoveredSideOfContainer();1===t&&(t=this._hoveredCell.cellIndex,t+=this._isBottomOrRight()),this._table.addColumn(t)}_containerEnterPressed(t){if(null===this._table.selectedCell||t.shiftKey)return;const e=this._table.selectedCell.closest("TR");let o=this._getHoveredSideOfContainer();1===o&&(o=e.sectionRowIndex+1),this._table.addRow(o).cells[0].click()}_mouseEnterInDetectArea(t){let e=l(r(this._container),t.pageX,t.pageY);t.target.dispatchEvent(new CustomEvent("mouseInActivatingArea",{detail:{side:e},bubbles:!0}))}}}])});

/***/ }),

/***/ "./node_modules/@editorjs/warning/dist/bundle.js":
/*!*******************************************************!*\
  !*** ./node_modules/@editorjs/warning/dist/bundle.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

!function(t,e){ true?module.exports=e():undefined}(window,function(){return function(t){var e={};function n(r){if(e[r])return e[r].exports;var o=e[r]={i:r,l:!1,exports:{}};return t[r].call(o.exports,o,o.exports,n),o.l=!0,o.exports}return n.m=t,n.c=e,n.d=function(t,e,r){n.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:r})},n.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},n.t=function(t,e){if(1&e&&(t=n(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var o in t)n.d(r,o,function(e){return t[e]}.bind(null,o));return r},n.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return n.d(e,"a",e),e},n.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},n.p="/",n(n.s=1)}([function(t,e){t.exports='<svg width="16" height="17" viewBox="0 0 320 294" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M160.5 97c12.426 0 22.5 10.074 22.5 22.5v28c0 12.426-10.074 22.5-22.5 22.5S138 159.926 138 147.5v-28c0-12.426 10.074-22.5 22.5-22.5zm0 83c14.636 0 26.5 11.864 26.5 26.5S175.136 233 160.5 233 134 221.136 134 206.5s11.864-26.5 26.5-26.5zm-.02-135c-6.102 0-14.05 8.427-23.842 25.28l-74.73 127.605c-12.713 21.444-17.806 35.025-15.28 40.742 2.527 5.717 8.519 9.175 17.974 10.373h197.255c5.932-1.214 10.051-4.671 12.357-10.373 2.307-5.702-1.812-16.903-12.357-33.603L184.555 70.281C174.608 53.427 166.583 45 160.48 45zm154.61 165.418c2.216 6.027 3.735 11.967 4.393 18.103.963 8.977.067 18.035-3.552 26.98-7.933 19.612-24.283 33.336-45.054 37.586l-4.464.913H61.763l-2.817-.357c-10.267-1.3-19.764-4.163-28.422-9.16-11.051-6.377-19.82-15.823-25.055-27.664-4.432-10.03-5.235-19.952-3.914-29.887.821-6.175 2.486-12.239 4.864-18.58 3.616-9.64 9.159-20.55 16.718-33.309L97.77 47.603c6.469-11.125 12.743-20.061 19.436-27.158 4.62-4.899 9.562-9.07 15.206-12.456C140.712 3.01 150.091 0 160.481 0c10.358 0 19.703 2.99 27.989 7.933 5.625 3.356 10.563 7.492 15.193 12.354 6.735 7.072 13.08 15.997 19.645 27.12l.142.24 76.986 134.194c6.553 10.46 11.425 19.799 14.654 28.577z"></path></svg>'},function(t,e,n){"use strict";n.r(e),n.d(e,"default",function(){return c});var r=n(0),o=n.n(r);function i(t){return function(t){if(Array.isArray(t)){for(var e=0,n=new Array(t.length);e<t.length;e++)n[e]=t[e];return n}}(t)||function(t){if(Symbol.iterator in Object(t)||"[object Arguments]"===Object.prototype.toString.call(t))return Array.from(t)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()}function a(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,r.key,r)}}function s(t,e,n){return e&&a(t.prototype,e),n&&a(t,n),t}n(2).toString();var c=function(){function t(e){var n=e.data,r=e.config,o=e.api,i=e.readOnly;!function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}(this,t),this.api=o,this.readOnly=i,this.titlePlaceholder=r.titlePlaceholder||t.DEFAULT_TITLE_PLACEHOLDER,this.messagePlaceholder=r.messagePlaceholder||t.DEFAULT_MESSAGE_PLACEHOLDER,this.data={title:n.title||"",message:n.message||""}}return s(t,[{key:"CSS",get:function(){return{baseClass:this.api.styles.block,wrapper:"cdx-warning",title:"cdx-warning__title",input:this.api.styles.input,message:"cdx-warning__message"}}}],[{key:"isReadOnlySupported",get:function(){return!0}},{key:"toolbox",get:function(){return{icon:o.a,title:"Warning"}}},{key:"enableLineBreaks",get:function(){return!0}},{key:"DEFAULT_TITLE_PLACEHOLDER",get:function(){return"Title"}},{key:"DEFAULT_MESSAGE_PLACEHOLDER",get:function(){return"Message"}}]),s(t,[{key:"render",value:function(){var t=this._make("div",[this.CSS.baseClass,this.CSS.wrapper]),e=this._make("div",[this.CSS.input,this.CSS.title],{contentEditable:!this.readOnly,innerHTML:this.data.title}),n=this._make("div",[this.CSS.input,this.CSS.message],{contentEditable:!this.readOnly,innerHTML:this.data.message});return e.dataset.placeholder=this.titlePlaceholder,n.dataset.placeholder=this.messagePlaceholder,t.appendChild(e),t.appendChild(n),t}},{key:"save",value:function(t){var e=t.querySelector(".".concat(this.CSS.title)),n=t.querySelector(".".concat(this.CSS.message));return Object.assign(this.data,{title:e.innerHTML,message:n.innerHTML})}},{key:"_make",value:function(t){var e,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o=document.createElement(t);Array.isArray(n)?(e=o.classList).add.apply(e,i(n)):n&&o.classList.add(n);for(var a in r)o[a]=r[a];return o}}],[{key:"sanitize",get:function(){return{title:{},message:{}}}}]),t}()},function(t,e,n){var r=n(3);"string"==typeof r&&(r=[[t.i,r,""]]);var o={hmr:!0,transform:void 0,insertInto:void 0};n(5)(r,o);r.locals&&(t.exports=r.locals)},function(t,e,n){(t.exports=n(4)(!1)).push([t.i,".cdx-warning {\n  position: relative;\n}\n\n.cdx-warning [contentEditable=true][data-placeholder]::before{\n  position: absolute;\n  content: attr(data-placeholder);\n  color: #707684;\n  font-weight: normal;\n  opacity: 0;\n}\n\n.cdx-warning [contentEditable=true][data-placeholder]:empty::before {\n  opacity: 1;\n}\n\n.cdx-warning [contentEditable=true][data-placeholder]:empty:focus::before {\n  opacity: 0;\n}\n\n\n.cdx-warning::before {\n  content: '';\n  background-image: url(\"data:image/svg+xml,%3Csvg width='16' height='17' viewBox='0 0 320 294' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink'%3E%3Cpath fill='%237B7E89' d='M160.5 97c12.426 0 22.5 10.074 22.5 22.5v28c0 12.426-10.074 22.5-22.5 22.5S138 159.926 138 147.5v-28c0-12.426 10.074-22.5 22.5-22.5zm0 83c14.636 0 26.5 11.864 26.5 26.5S175.136 233 160.5 233 134 221.136 134 206.5s11.864-26.5 26.5-26.5zm-.02-135c-6.102 0-14.05 8.427-23.842 25.28l-74.73 127.605c-12.713 21.444-17.806 35.025-15.28 40.742 2.527 5.717 8.519 9.175 17.974 10.373h197.255c5.932-1.214 10.051-4.671 12.357-10.373 2.307-5.702-1.812-16.903-12.357-33.603L184.555 70.281C174.608 53.427 166.583 45 160.48 45zm154.61 165.418c2.216 6.027 3.735 11.967 4.393 18.103.963 8.977.067 18.035-3.552 26.98-7.933 19.612-24.283 33.336-45.054 37.586l-4.464.913H61.763l-2.817-.357c-10.267-1.3-19.764-4.163-28.422-9.16-11.051-6.377-19.82-15.823-25.055-27.664-4.432-10.03-5.235-19.952-3.914-29.887.821-6.175 2.486-12.239 4.864-18.58 3.616-9.64 9.159-20.55 16.718-33.309L97.77 47.603c6.469-11.125 12.743-20.061 19.436-27.158 4.62-4.899 9.562-9.07 15.206-12.456C140.712 3.01 150.091 0 160.481 0c10.358 0 19.703 2.99 27.989 7.933 5.625 3.356 10.563 7.492 15.193 12.354 6.735 7.072 13.08 15.997 19.645 27.12l.142.24 76.986 134.194c6.553 10.46 11.425 19.799 14.654 28.577z'/%3E%3C/svg%3E\");\n  width: 18px;\n  height: 18px;\n  background-size: 18px 18px;\n  position: absolute;\n  margin-top: 12px;\n  left: -30px;\n}\n\n@media all and (max-width: 735px) {\n  .cdx-warning::before {\n    display: none;\n  }\n}\n\n.cdx-warning__message {\n  min-height: 85px;\n}\n\n.cdx-warning__title {\n  margin-bottom: 6px;\n}\n",""])},function(t,e,n){"use strict";t.exports=function(t){var e=[];return e.toString=function(){return this.map(function(e){var n=function(t,e){var n=t[1]||"",r=t[3];if(!r)return n;if(e&&"function"==typeof btoa){var o=(a=r,"/*# sourceMappingURL=data:application/json;charset=utf-8;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(a))))+" */"),i=r.sources.map(function(t){return"/*# sourceURL="+r.sourceRoot+t+" */"});return[n].concat(i).concat([o]).join("\n")}var a;return[n].join("\n")}(e,t);return e[2]?"@media "+e[2]+"{"+n+"}":n}).join("")},e.i=function(t,n){"string"==typeof t&&(t=[[null,t,""]]);for(var r={},o=0;o<this.length;o++){var i=this[o][0];null!=i&&(r[i]=!0)}for(o=0;o<t.length;o++){var a=t[o];null!=a[0]&&r[a[0]]||(n&&!a[2]?a[2]=n:n&&(a[2]="("+a[2]+") and ("+n+")"),e.push(a))}},e}},function(t,e,n){var r,o,i={},a=(r=function(){return window&&document&&document.all&&!window.atob},function(){return void 0===o&&(o=r.apply(this,arguments)),o}),s=function(t){var e={};return function(t,n){if("function"==typeof t)return t();if(void 0===e[t]){var r=function(t,e){return e?e.querySelector(t):document.querySelector(t)}.call(this,t,n);if(window.HTMLIFrameElement&&r instanceof window.HTMLIFrameElement)try{r=r.contentDocument.head}catch(t){r=null}e[t]=r}return e[t]}}(),c=null,l=0,u=[],f=n(6);function d(t,e){for(var n=0;n<t.length;n++){var r=t[n],o=i[r.id];if(o){o.refs++;for(var a=0;a<o.parts.length;a++)o.parts[a](r.parts[a]);for(;a<r.parts.length;a++)o.parts.push(y(r.parts[a],e))}else{var s=[];for(a=0;a<r.parts.length;a++)s.push(y(r.parts[a],e));i[r.id]={id:r.id,refs:1,parts:s}}}}function p(t,e){for(var n=[],r={},o=0;o<t.length;o++){var i=t[o],a=e.base?i[0]+e.base:i[0],s={css:i[1],media:i[2],sourceMap:i[3]};r[a]?r[a].parts.push(s):n.push(r[a]={id:a,parts:[s]})}return n}function h(t,e){var n=s(t.insertInto);if(!n)throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");var r=u[u.length-1];if("top"===t.insertAt)r?r.nextSibling?n.insertBefore(e,r.nextSibling):n.appendChild(e):n.insertBefore(e,n.firstChild),u.push(e);else if("bottom"===t.insertAt)n.appendChild(e);else{if("object"!=typeof t.insertAt||!t.insertAt.before)throw new Error("[Style Loader]\n\n Invalid value for parameter 'insertAt' ('options.insertAt') found.\n Must be 'top', 'bottom', or Object.\n (https://github.com/webpack-contrib/style-loader#insertat)\n");var o=s(t.insertAt.before,n);n.insertBefore(e,o)}}function v(t){if(null===t.parentNode)return!1;t.parentNode.removeChild(t);var e=u.indexOf(t);e>=0&&u.splice(e,1)}function g(t){var e=document.createElement("style");if(void 0===t.attrs.type&&(t.attrs.type="text/css"),void 0===t.attrs.nonce){var r=function(){0;return n.nc}();r&&(t.attrs.nonce=r)}return m(e,t.attrs),h(t,e),e}function m(t,e){Object.keys(e).forEach(function(n){t.setAttribute(n,e[n])})}function y(t,e){var n,r,o,i;if(e.transform&&t.css){if(!(i="function"==typeof e.transform?e.transform(t.css):e.transform.default(t.css)))return function(){};t.css=i}if(e.singleton){var a=l++;n=c||(c=g(e)),r=x.bind(null,n,a,!1),o=x.bind(null,n,a,!0)}else t.sourceMap&&"function"==typeof URL&&"function"==typeof URL.createObjectURL&&"function"==typeof URL.revokeObjectURL&&"function"==typeof Blob&&"function"==typeof btoa?(n=function(t){var e=document.createElement("link");return void 0===t.attrs.type&&(t.attrs.type="text/css"),t.attrs.rel="stylesheet",m(e,t.attrs),h(t,e),e}(e),r=function(t,e,n){var r=n.css,o=n.sourceMap,i=void 0===e.convertToAbsoluteUrls&&o;(e.convertToAbsoluteUrls||i)&&(r=f(r));o&&(r+="\n/*# sourceMappingURL=data:application/json;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(o))))+" */");var a=new Blob([r],{type:"text/css"}),s=t.href;t.href=URL.createObjectURL(a),s&&URL.revokeObjectURL(s)}.bind(null,n,e),o=function(){v(n),n.href&&URL.revokeObjectURL(n.href)}):(n=g(e),r=function(t,e){var n=e.css,r=e.media;r&&t.setAttribute("media",r);if(t.styleSheet)t.styleSheet.cssText=n;else{for(;t.firstChild;)t.removeChild(t.firstChild);t.appendChild(document.createTextNode(n))}}.bind(null,n),o=function(){v(n)});return r(t),function(e){if(e){if(e.css===t.css&&e.media===t.media&&e.sourceMap===t.sourceMap)return;r(t=e)}else o()}}t.exports=function(t,e){if("undefined"!=typeof DEBUG&&DEBUG&&"object"!=typeof document)throw new Error("The style-loader cannot be used in a non-browser environment");(e=e||{}).attrs="object"==typeof e.attrs?e.attrs:{},e.singleton||"boolean"==typeof e.singleton||(e.singleton=a()),e.insertInto||(e.insertInto="head"),e.insertAt||(e.insertAt="bottom");var n=p(t,e);return d(n,e),function(t){for(var r=[],o=0;o<n.length;o++){var a=n[o];(s=i[a.id]).refs--,r.push(s)}t&&d(p(t,e),e);for(o=0;o<r.length;o++){var s;if(0===(s=r[o]).refs){for(var c=0;c<s.parts.length;c++)s.parts[c]();delete i[s.id]}}}};var b,w=(b=[],function(t,e){return b[t]=e,b.filter(Boolean).join("\n")});function x(t,e,n,r){var o=n?"":r.css;if(t.styleSheet)t.styleSheet.cssText=w(e,o);else{var i=document.createTextNode(o),a=t.childNodes;a[e]&&t.removeChild(a[e]),a.length?t.insertBefore(i,a[e]):t.appendChild(i)}}},function(t,e){t.exports=function(t){var e="undefined"!=typeof window&&window.location;if(!e)throw new Error("fixUrls requires window.location");if(!t||"string"!=typeof t)return t;var n=e.protocol+"//"+e.host,r=n+e.pathname.replace(/\/[^\/]*$/,"/");return t.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi,function(t,e){var o,i=e.trim().replace(/^"(.*)"$/,function(t,e){return e}).replace(/^'(.*)'$/,function(t,e){return e});return/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/|\s*$)/i.test(i)?t:(o=0===i.indexOf("//")?i:0===i.indexOf("/")?n+i:r+i.replace(/^\.\//,""),"url("+JSON.stringify(o)+")")})}}]).default});

/***/ }),

/***/ "./node_modules/air-datepicker/dist/js/datepicker.js":
/*!***********************************************************!*\
  !*** ./node_modules/air-datepicker/dist/js/datepicker.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(jQuery) {;(function (window, $, undefined) { ;(function () {
    var VERSION = '2.2.3',
        pluginName = 'datepicker',
        autoInitSelector = '.datepicker-here',
        $body, $datepickersContainer,
        containerBuilt = false,
        baseTemplate = '' +
            '<div class="datepicker">' +
            '<i class="datepicker--pointer"></i>' +
            '<nav class="datepicker--nav"></nav>' +
            '<div class="datepicker--content"></div>' +
            '</div>',
        defaults = {
            classes: '',
            inline: false,
            language: 'ru',
            startDate: new Date(),
            firstDay: '',
            weekends: [6, 0],
            dateFormat: '',
            altField: '',
            altFieldDateFormat: '@',
            toggleSelected: true,
            keyboardNav: true,

            position: 'bottom left',
            offset: 12,

            view: 'days',
            minView: 'days',

            showOtherMonths: true,
            selectOtherMonths: true,
            moveToOtherMonthsOnSelect: true,

            showOtherYears: true,
            selectOtherYears: true,
            moveToOtherYearsOnSelect: true,

            minDate: '',
            maxDate: '',
            disableNavWhenOutOfRange: true,

            multipleDates: false, // Boolean or Number
            multipleDatesSeparator: ',',
            range: false,

            todayButton: false,
            clearButton: false,

            showEvent: 'focus',
            autoClose: false,

            // navigation
            monthsField: 'monthsShort',
            prevHtml: '<svg><path d="M 17,12 l -5,5 l 5,5"></path></svg>',
            nextHtml: '<svg><path d="M 14,12 l 5,5 l -5,5"></path></svg>',
            navTitles: {
                days: 'MM, <i>yyyy</i>',
                months: 'yyyy',
                years: 'yyyy1 - yyyy2'
            },

            // timepicker
            timepicker: false,
            onlyTimepicker: false,
            dateTimeSeparator: ' ',
            timeFormat: '',
            minHours: 0,
            maxHours: 24,
            minMinutes: 0,
            maxMinutes: 59,
            hoursStep: 1,
            minutesStep: 1,

            // events
            onSelect: '',
            onShow: '',
            onHide: '',
            onChangeMonth: '',
            onChangeYear: '',
            onChangeDecade: '',
            onChangeView: '',
            onRenderCell: ''
        },
        hotKeys = {
            'ctrlRight': [17, 39],
            'ctrlUp': [17, 38],
            'ctrlLeft': [17, 37],
            'ctrlDown': [17, 40],
            'shiftRight': [16, 39],
            'shiftUp': [16, 38],
            'shiftLeft': [16, 37],
            'shiftDown': [16, 40],
            'altUp': [18, 38],
            'altRight': [18, 39],
            'altLeft': [18, 37],
            'altDown': [18, 40],
            'ctrlShiftUp': [16, 17, 38]
        },
        datepicker;

    var Datepicker  = function (el, options) {
        this.el = el;
        this.$el = $(el);

        this.opts = $.extend(true, {}, defaults, options, this.$el.data());

        if ($body == undefined) {
            $body = $('body');
        }

        if (!this.opts.startDate) {
            this.opts.startDate = new Date();
        }

        if (this.el.nodeName == 'INPUT') {
            this.elIsInput = true;
        }

        if (this.opts.altField) {
            this.$altField = typeof this.opts.altField == 'string' ? $(this.opts.altField) : this.opts.altField;
        }

        this.inited = false;
        this.visible = false;
        this.silent = false; // Need to prevent unnecessary rendering

        this.currentDate = this.opts.startDate;
        this.currentView = this.opts.view;
        this._createShortCuts();
        this.selectedDates = [];
        this.views = {};
        this.keys = [];
        this.minRange = '';
        this.maxRange = '';
        this._prevOnSelectValue = '';

        this.init()
    };

    datepicker = Datepicker;

    datepicker.prototype = {
        VERSION: VERSION,
        viewIndexes: ['days', 'months', 'years'],

        init: function () {
            if (!containerBuilt && !this.opts.inline && this.elIsInput) {
                this._buildDatepickersContainer();
            }
            this._buildBaseHtml();
            this._defineLocale(this.opts.language);
            this._syncWithMinMaxDates();

            if (this.elIsInput) {
                if (!this.opts.inline) {
                    // Set extra classes for proper transitions
                    this._setPositionClasses(this.opts.position);
                    this._bindEvents()
                }
                if (this.opts.keyboardNav && !this.opts.onlyTimepicker) {
                    this._bindKeyboardEvents();
                }
                this.$datepicker.on('mousedown', this._onMouseDownDatepicker.bind(this));
                this.$datepicker.on('mouseup', this._onMouseUpDatepicker.bind(this));
            }

            if (this.opts.classes) {
                this.$datepicker.addClass(this.opts.classes)
            }

            if (this.opts.timepicker) {
                this.timepicker = new $.fn.datepicker.Timepicker(this, this.opts);
                this._bindTimepickerEvents();
            }

            if (this.opts.onlyTimepicker) {
                this.$datepicker.addClass('-only-timepicker-');
            }

            this.views[this.currentView] = new $.fn.datepicker.Body(this, this.currentView, this.opts);
            this.views[this.currentView].show();
            this.nav = new $.fn.datepicker.Navigation(this, this.opts);
            this.view = this.currentView;

            this.$el.on('clickCell.adp', this._onClickCell.bind(this));
            this.$datepicker.on('mouseenter', '.datepicker--cell', this._onMouseEnterCell.bind(this));
            this.$datepicker.on('mouseleave', '.datepicker--cell', this._onMouseLeaveCell.bind(this));

            this.inited = true;
        },

        _createShortCuts: function () {
            this.minDate = this.opts.minDate ? this.opts.minDate : new Date(-8639999913600000);
            this.maxDate = this.opts.maxDate ? this.opts.maxDate : new Date(8639999913600000);
        },

        _bindEvents : function () {
            this.$el.on(this.opts.showEvent + '.adp', this._onShowEvent.bind(this));
            this.$el.on('mouseup.adp', this._onMouseUpEl.bind(this));
            this.$el.on('blur.adp', this._onBlur.bind(this));
            this.$el.on('keyup.adp', this._onKeyUpGeneral.bind(this));
            $(window).on('resize.adp', this._onResize.bind(this));
            $('body').on('mouseup.adp', this._onMouseUpBody.bind(this));
        },

        _bindKeyboardEvents: function () {
            this.$el.on('keydown.adp', this._onKeyDown.bind(this));
            this.$el.on('keyup.adp', this._onKeyUp.bind(this));
            this.$el.on('hotKey.adp', this._onHotKey.bind(this));
        },

        _bindTimepickerEvents: function () {
            this.$el.on('timeChange.adp', this._onTimeChange.bind(this));
        },

        isWeekend: function (day) {
            return this.opts.weekends.indexOf(day) !== -1;
        },

        _defineLocale: function (lang) {
            if (typeof lang == 'string') {
                this.loc = $.fn.datepicker.language[lang];
                if (!this.loc) {
                    console.warn('Can\'t find language "' + lang + '" in Datepicker.language, will use "ru" instead');
                    this.loc = $.extend(true, {}, $.fn.datepicker.language.ru)
                }

                this.loc = $.extend(true, {}, $.fn.datepicker.language.ru, $.fn.datepicker.language[lang])
            } else {
                this.loc = $.extend(true, {}, $.fn.datepicker.language.ru, lang)
            }

            if (this.opts.dateFormat) {
                this.loc.dateFormat = this.opts.dateFormat
            }

            if (this.opts.timeFormat) {
                this.loc.timeFormat = this.opts.timeFormat
            }

            if (this.opts.firstDay !== '') {
                this.loc.firstDay = this.opts.firstDay
            }

            if (this.opts.timepicker) {
                this.loc.dateFormat = [this.loc.dateFormat, this.loc.timeFormat].join(this.opts.dateTimeSeparator);
            }

            if (this.opts.onlyTimepicker) {
                this.loc.dateFormat = this.loc.timeFormat;
            }

            var boundary = this._getWordBoundaryRegExp;
            if (this.loc.timeFormat.match(boundary('aa')) ||
                this.loc.timeFormat.match(boundary('AA'))
            ) {
               this.ampm = true;
            }
        },

        _buildDatepickersContainer: function () {
            containerBuilt = true;
            $body.append('<div class="datepickers-container" id="datepickers-container"></div>');
            $datepickersContainer = $('#datepickers-container');
        },

        _buildBaseHtml: function () {
            var $appendTarget,
                $inline = $('<div class="datepicker-inline">');

            if(this.el.nodeName == 'INPUT') {
                if (!this.opts.inline) {
                    $appendTarget = $datepickersContainer;
                } else {
                    $appendTarget = $inline.insertAfter(this.$el)
                }
            } else {
                $appendTarget = $inline.appendTo(this.$el)
            }

            this.$datepicker = $(baseTemplate).appendTo($appendTarget);
            this.$content = $('.datepicker--content', this.$datepicker);
            this.$nav = $('.datepicker--nav', this.$datepicker);
        },

        _triggerOnChange: function () {
            if (!this.selectedDates.length) {
                // Prevent from triggering multiple onSelect callback with same argument (empty string) in IE10-11
                if (this._prevOnSelectValue === '') return;
                this._prevOnSelectValue = '';
                return this.opts.onSelect('', '', this);
            }

            var selectedDates = this.selectedDates,
                parsedSelected = datepicker.getParsedDate(selectedDates[0]),
                formattedDates,
                _this = this,
                dates = new Date(
                    parsedSelected.year,
                    parsedSelected.month,
                    parsedSelected.date,
                    parsedSelected.hours,
                    parsedSelected.minutes
                );

                formattedDates = selectedDates.map(function (date) {
                    return _this.formatDate(_this.loc.dateFormat, date)
                }).join(this.opts.multipleDatesSeparator);

            // Create new dates array, to separate it from original selectedDates
            if (this.opts.multipleDates || this.opts.range) {
                dates = selectedDates.map(function(date) {
                    var parsedDate = datepicker.getParsedDate(date);
                    return new Date(
                        parsedDate.year,
                        parsedDate.month,
                        parsedDate.date,
                        parsedDate.hours,
                        parsedDate.minutes
                    );
                })
            }

            this._prevOnSelectValue = formattedDates;
            this.opts.onSelect(formattedDates, dates, this);
        },

        next: function () {
            var d = this.parsedDate,
                o = this.opts;
            switch (this.view) {
                case 'days':
                    this.date = new Date(d.year, d.month + 1, 1);
                    if (o.onChangeMonth) o.onChangeMonth(this.parsedDate.month, this.parsedDate.year);
                    break;
                case 'months':
                    this.date = new Date(d.year + 1, d.month, 1);
                    if (o.onChangeYear) o.onChangeYear(this.parsedDate.year);
                    break;
                case 'years':
                    this.date = new Date(d.year + 10, 0, 1);
                    if (o.onChangeDecade) o.onChangeDecade(this.curDecade);
                    break;
            }
        },

        prev: function () {
            var d = this.parsedDate,
                o = this.opts;
            switch (this.view) {
                case 'days':
                    this.date = new Date(d.year, d.month - 1, 1);
                    if (o.onChangeMonth) o.onChangeMonth(this.parsedDate.month, this.parsedDate.year);
                    break;
                case 'months':
                    this.date = new Date(d.year - 1, d.month, 1);
                    if (o.onChangeYear) o.onChangeYear(this.parsedDate.year);
                    break;
                case 'years':
                    this.date = new Date(d.year - 10, 0, 1);
                    if (o.onChangeDecade) o.onChangeDecade(this.curDecade);
                    break;
            }
        },

        formatDate: function (string, date) {
            date = date || this.date;
            var result = string,
                boundary = this._getWordBoundaryRegExp,
                locale = this.loc,
                leadingZero = datepicker.getLeadingZeroNum,
                decade = datepicker.getDecade(date),
                d = datepicker.getParsedDate(date),
                fullHours = d.fullHours,
                hours = d.hours,
                ampm = string.match(boundary('aa')) || string.match(boundary('AA')),
                dayPeriod = 'am',
                replacer = this._replacer,
                validHours;

            if (this.opts.timepicker && this.timepicker && ampm) {
                validHours = this.timepicker._getValidHoursFromDate(date, ampm);
                fullHours = leadingZero(validHours.hours);
                hours = validHours.hours;
                dayPeriod = validHours.dayPeriod;
            }

            switch (true) {
                case /@/.test(result):
                    result = result.replace(/@/, date.getTime());
                case /aa/.test(result):
                    result = replacer(result, boundary('aa'), dayPeriod);
                case /AA/.test(result):
                    result = replacer(result, boundary('AA'), dayPeriod.toUpperCase());
                case /dd/.test(result):
                    result = replacer(result, boundary('dd'), d.fullDate);
                case /d/.test(result):
                    result = replacer(result, boundary('d'), d.date);
                case /DD/.test(result):
                    result = replacer(result, boundary('DD'), locale.days[d.day]);
                case /D/.test(result):
                    result = replacer(result, boundary('D'), locale.daysShort[d.day]);
                case /mm/.test(result):
                    result = replacer(result, boundary('mm'), d.fullMonth);
                case /m/.test(result):
                    result = replacer(result, boundary('m'), d.month + 1);
                case /MM/.test(result):
                    result = replacer(result, boundary('MM'), this.loc.months[d.month]);
                case /M/.test(result):
                    result = replacer(result, boundary('M'), locale.monthsShort[d.month]);
                case /ii/.test(result):
                    result = replacer(result, boundary('ii'), d.fullMinutes);
                case /i/.test(result):
                    result = replacer(result, boundary('i'), d.minutes);
                case /hh/.test(result):
                    result = replacer(result, boundary('hh'), fullHours);
                case /h/.test(result):
                    result = replacer(result, boundary('h'), hours);
                case /yyyy/.test(result):
                    result = replacer(result, boundary('yyyy'), d.year);
                case /yyyy1/.test(result):
                    result = replacer(result, boundary('yyyy1'), decade[0]);
                case /yyyy2/.test(result):
                    result = replacer(result, boundary('yyyy2'), decade[1]);
                case /yy/.test(result):
                    result = replacer(result, boundary('yy'), d.year.toString().slice(-2));
            }

            return result;
        },

        _replacer: function (str, reg, data) {
            return str.replace(reg, function (match, p1,p2,p3) {
                return p1 + data + p3;
            })
        },

        _getWordBoundaryRegExp: function (sign) {
            var symbols = '\\s|\\.|-|/|\\\\|,|\\$|\\!|\\?|:|;';

            return new RegExp('(^|>|' + symbols + ')(' + sign + ')($|<|' + symbols + ')', 'g');
        },


        selectDate: function (date) {
            var _this = this,
                opts = _this.opts,
                d = _this.parsedDate,
                selectedDates = _this.selectedDates,
                len = selectedDates.length,
                newDate = '';

            if (Array.isArray(date)) {
                date.forEach(function (d) {
                    _this.selectDate(d)
                });
                return;
            }

            if (!(date instanceof Date)) return;

            this.lastSelectedDate = date;

            // Set new time values from Date
            if (this.timepicker) {
                this.timepicker._setTime(date);
            }

            // On this step timepicker will set valid values in it's instance
            _this._trigger('selectDate', date);

            // Set correct time values after timepicker's validation
            // Prevent from setting hours or minutes which values are lesser then `min` value or
            // greater then `max` value
            if (this.timepicker) {
                date.setHours(this.timepicker.hours);
                date.setMinutes(this.timepicker.minutes)
            }

            if (_this.view == 'days') {
                if (date.getMonth() != d.month && opts.moveToOtherMonthsOnSelect) {
                    newDate = new Date(date.getFullYear(), date.getMonth(), 1);
                }
            }

            if (_this.view == 'years') {
                if (date.getFullYear() != d.year && opts.moveToOtherYearsOnSelect) {
                    newDate = new Date(date.getFullYear(), 0, 1);
                }
            }

            if (newDate) {
                _this.silent = true;
                _this.date = newDate;
                _this.silent = false;
                _this.nav._render()
            }

            if (opts.multipleDates && !opts.range) { // Set priority to range functionality
                if (len === opts.multipleDates) return;
                if (!_this._isSelected(date)) {
                    _this.selectedDates.push(date);
                }
            } else if (opts.range) {
                if (len == 2) {
                    _this.selectedDates = [date];
                    _this.minRange = date;
                    _this.maxRange = '';
                } else if (len == 1) {
                    _this.selectedDates.push(date);
                    if (!_this.maxRange){
                        _this.maxRange = date;
                    } else {
                        _this.minRange = date;
                    }
                    // Swap dates if they were selected via dp.selectDate() and second date was smaller then first
                    if (datepicker.bigger(_this.maxRange, _this.minRange)) {
                        _this.maxRange = _this.minRange;
                        _this.minRange = date;
                    }
                    _this.selectedDates = [_this.minRange, _this.maxRange]

                } else {
                    _this.selectedDates = [date];
                    _this.minRange = date;
                }
            } else {
                _this.selectedDates = [date];
            }

            _this._setInputValue();

            if (opts.onSelect) {
                _this._triggerOnChange();
            }

            if (opts.autoClose && !this.timepickerIsActive) {
                if (!opts.multipleDates && !opts.range) {
                    _this.hide();
                } else if (opts.range && _this.selectedDates.length == 2) {
                    _this.hide();
                }
            }

            _this.views[this.currentView]._render()
        },

        removeDate: function (date) {
            var selected = this.selectedDates,
                _this = this;

            if (!(date instanceof Date)) return;

            return selected.some(function (curDate, i) {
                if (datepicker.isSame(curDate, date)) {
                    selected.splice(i, 1);

                    if (!_this.selectedDates.length) {
                        _this.minRange = '';
                        _this.maxRange = '';
                        _this.lastSelectedDate = '';
                    } else {
                        _this.lastSelectedDate = _this.selectedDates[_this.selectedDates.length - 1];
                    }

                    _this.views[_this.currentView]._render();
                    _this._setInputValue();

                    if (_this.opts.onSelect) {
                        _this._triggerOnChange();
                    }

                    return true
                }
            })
        },

        today: function () {
            this.silent = true;
            this.view = this.opts.minView;
            this.silent = false;
            this.date = new Date();

            if (this.opts.todayButton instanceof Date) {
                this.selectDate(this.opts.todayButton)
            }
        },

        clear: function () {
            this.selectedDates = [];
            this.minRange = '';
            this.maxRange = '';
            this.views[this.currentView]._render();
            this._setInputValue();
            if (this.opts.onSelect) {
                this._triggerOnChange()
            }
        },

        /**
         * Updates datepicker options
         * @param {String|Object} param - parameter's name to update. If object then it will extend current options
         * @param {String|Number|Object} [value] - new param value
         */
        update: function (param, value) {
            var len = arguments.length,
                lastSelectedDate = this.lastSelectedDate;

            if (len == 2) {
                this.opts[param] = value;
            } else if (len == 1 && typeof param == 'object') {
                this.opts = $.extend(true, this.opts, param)
            }

            this._createShortCuts();
            this._syncWithMinMaxDates();
            this._defineLocale(this.opts.language);
            this.nav._addButtonsIfNeed();
            if (!this.opts.onlyTimepicker) this.nav._render();
            this.views[this.currentView]._render();

            if (this.elIsInput && !this.opts.inline) {
                this._setPositionClasses(this.opts.position);
                if (this.visible) {
                    this.setPosition(this.opts.position)
                }
            }

            if (this.opts.classes) {
                this.$datepicker.addClass(this.opts.classes)
            }

            if (this.opts.onlyTimepicker) {
                this.$datepicker.addClass('-only-timepicker-');
            }

            if (this.opts.timepicker) {
                if (lastSelectedDate) this.timepicker._handleDate(lastSelectedDate);
                this.timepicker._updateRanges();
                this.timepicker._updateCurrentTime();
                // Change hours and minutes if it's values have been changed through min/max hours/minutes
                if (lastSelectedDate) {
                    lastSelectedDate.setHours(this.timepicker.hours);
                    lastSelectedDate.setMinutes(this.timepicker.minutes);
                }
            }

            this._setInputValue();

            return this;
        },

        _syncWithMinMaxDates: function () {
            var curTime = this.date.getTime();
            this.silent = true;
            if (this.minTime > curTime) {
                this.date = this.minDate;
            }

            if (this.maxTime < curTime) {
                this.date = this.maxDate;
            }
            this.silent = false;
        },

        _isSelected: function (checkDate, cellType) {
            var res = false;
            this.selectedDates.some(function (date) {
                if (datepicker.isSame(date, checkDate, cellType)) {
                    res = date;
                    return true;
                }
            });
            return res;
        },

        _setInputValue: function () {
            var _this = this,
                opts = _this.opts,
                format = _this.loc.dateFormat,
                altFormat = opts.altFieldDateFormat,
                value = _this.selectedDates.map(function (date) {
                    return _this.formatDate(format, date)
                }),
                altValues;

            if (opts.altField && _this.$altField.length) {
                altValues = this.selectedDates.map(function (date) {
                    return _this.formatDate(altFormat, date)
                });
                altValues = altValues.join(this.opts.multipleDatesSeparator);
                this.$altField.val(altValues);
            }

            value = value.join(this.opts.multipleDatesSeparator);

            this.$el.val(value)
        },

        /**
         * Check if date is between minDate and maxDate
         * @param date {object} - date object
         * @param type {string} - cell type
         * @returns {boolean}
         * @private
         */
        _isInRange: function (date, type) {
            var time = date.getTime(),
                d = datepicker.getParsedDate(date),
                min = datepicker.getParsedDate(this.minDate),
                max = datepicker.getParsedDate(this.maxDate),
                dMinTime = new Date(d.year, d.month, min.date).getTime(),
                dMaxTime = new Date(d.year, d.month, max.date).getTime(),
                types = {
                    day: time >= this.minTime && time <= this.maxTime,
                    month: dMinTime >= this.minTime && dMaxTime <= this.maxTime,
                    year: d.year >= min.year && d.year <= max.year
                };
            return type ? types[type] : types.day
        },

        _getDimensions: function ($el) {
            var offset = $el.offset();

            return {
                width: $el.outerWidth(),
                height: $el.outerHeight(),
                left: offset.left,
                top: offset.top
            }
        },

        _getDateFromCell: function (cell) {
            var curDate = this.parsedDate,
                year = cell.data('year') || curDate.year,
                month = cell.data('month') == undefined ? curDate.month : cell.data('month'),
                date = cell.data('date') || 1;

            return new Date(year, month, date);
        },

        _setPositionClasses: function (pos) {
            pos = pos.split(' ');
            var main = pos[0],
                sec = pos[1],
                classes = 'datepicker -' + main + '-' + sec + '- -from-' + main + '-';

            if (this.visible) classes += ' active';

            this.$datepicker
                .removeAttr('class')
                .addClass(classes);
        },

        setPosition: function (position) {
            position = position || this.opts.position;

            var dims = this._getDimensions(this.$el),
                selfDims = this._getDimensions(this.$datepicker),
                pos = position.split(' '),
                top, left,
                offset = this.opts.offset,
                main = pos[0],
                secondary = pos[1];

            switch (main) {
                case 'top':
                    top = dims.top - selfDims.height - offset;
                    break;
                case 'right':
                    left = dims.left + dims.width + offset;
                    break;
                case 'bottom':
                    top = dims.top + dims.height + offset;
                    break;
                case 'left':
                    left = dims.left - selfDims.width - offset;
                    break;
            }

            switch(secondary) {
                case 'top':
                    top = dims.top;
                    break;
                case 'right':
                    left = dims.left + dims.width - selfDims.width;
                    break;
                case 'bottom':
                    top = dims.top + dims.height - selfDims.height;
                    break;
                case 'left':
                    left = dims.left;
                    break;
                case 'center':
                    if (/left|right/.test(main)) {
                        top = dims.top + dims.height/2 - selfDims.height/2;
                    } else {
                        left = dims.left + dims.width/2 - selfDims.width/2;
                    }
            }

            this.$datepicker
                .css({
                    left: left,
                    top: top
                })
        },

        show: function () {
            var onShow = this.opts.onShow;

            this.setPosition(this.opts.position);
            this.$datepicker.addClass('active');
            this.visible = true;

            if (onShow) {
                this._bindVisionEvents(onShow)
            }
        },

        hide: function () {
            var onHide = this.opts.onHide;

            this.$datepicker
                .removeClass('active')
                .css({
                    left: '-100000px'
                });

            this.focused = '';
            this.keys = [];

            this.inFocus = false;
            this.visible = false;
            this.$el.blur();

            if (onHide) {
                this._bindVisionEvents(onHide)
            }
        },

        down: function (date) {
            this._changeView(date, 'down');
        },

        up: function (date) {
            this._changeView(date, 'up');
        },

        _bindVisionEvents: function (event) {
            this.$datepicker.off('transitionend.dp');
            event(this, false);
            this.$datepicker.one('transitionend.dp', event.bind(this, this, true))
        },

        _changeView: function (date, dir) {
            date = date || this.focused || this.date;

            var nextView = dir == 'up' ? this.viewIndex + 1 : this.viewIndex - 1;
            if (nextView > 2) nextView = 2;
            if (nextView < 0) nextView = 0;

            this.silent = true;
            this.date = new Date(date.getFullYear(), date.getMonth(), 1);
            this.silent = false;
            this.view = this.viewIndexes[nextView];

        },

        _handleHotKey: function (key) {
            var date = datepicker.getParsedDate(this._getFocusedDate()),
                focusedParsed,
                o = this.opts,
                newDate,
                totalDaysInNextMonth,
                monthChanged = false,
                yearChanged = false,
                decadeChanged = false,
                y = date.year,
                m = date.month,
                d = date.date;

            switch (key) {
                case 'ctrlRight':
                case 'ctrlUp':
                    m += 1;
                    monthChanged = true;
                    break;
                case 'ctrlLeft':
                case 'ctrlDown':
                    m -= 1;
                    monthChanged = true;
                    break;
                case 'shiftRight':
                case 'shiftUp':
                    yearChanged = true;
                    y += 1;
                    break;
                case 'shiftLeft':
                case 'shiftDown':
                    yearChanged = true;
                    y -= 1;
                    break;
                case 'altRight':
                case 'altUp':
                    decadeChanged = true;
                    y += 10;
                    break;
                case 'altLeft':
                case 'altDown':
                    decadeChanged = true;
                    y -= 10;
                    break;
                case 'ctrlShiftUp':
                    this.up();
                    break;
            }

            totalDaysInNextMonth = datepicker.getDaysCount(new Date(y,m));
            newDate = new Date(y,m,d);

            // If next month has less days than current, set date to total days in that month
            if (totalDaysInNextMonth < d) d = totalDaysInNextMonth;

            // Check if newDate is in valid range
            if (newDate.getTime() < this.minTime) {
                newDate = this.minDate;
            } else if (newDate.getTime() > this.maxTime) {
                newDate = this.maxDate;
            }

            this.focused = newDate;

            focusedParsed = datepicker.getParsedDate(newDate);
            if (monthChanged && o.onChangeMonth) {
                o.onChangeMonth(focusedParsed.month, focusedParsed.year)
            }
            if (yearChanged && o.onChangeYear) {
                o.onChangeYear(focusedParsed.year)
            }
            if (decadeChanged && o.onChangeDecade) {
                o.onChangeDecade(this.curDecade)
            }
        },

        _registerKey: function (key) {
            var exists = this.keys.some(function (curKey) {
                return curKey == key;
            });

            if (!exists) {
                this.keys.push(key)
            }
        },

        _unRegisterKey: function (key) {
            var index = this.keys.indexOf(key);

            this.keys.splice(index, 1);
        },

        _isHotKeyPressed: function () {
            var currentHotKey,
                found = false,
                _this = this,
                pressedKeys = this.keys.sort();

            for (var hotKey in hotKeys) {
                currentHotKey = hotKeys[hotKey];
                if (pressedKeys.length != currentHotKey.length) continue;

                if (currentHotKey.every(function (key, i) { return key == pressedKeys[i]})) {
                    _this._trigger('hotKey', hotKey);
                    found = true;
                }
            }

            return found;
        },

        _trigger: function (event, args) {
            this.$el.trigger(event, args)
        },

        _focusNextCell: function (keyCode, type) {
            type = type || this.cellType;

            var date = datepicker.getParsedDate(this._getFocusedDate()),
                y = date.year,
                m = date.month,
                d = date.date;

            if (this._isHotKeyPressed()){
                return;
            }

            switch(keyCode) {
                case 37: // left
                    type == 'day' ? (d -= 1) : '';
                    type == 'month' ? (m -= 1) : '';
                    type == 'year' ? (y -= 1) : '';
                    break;
                case 38: // up
                    type == 'day' ? (d -= 7) : '';
                    type == 'month' ? (m -= 3) : '';
                    type == 'year' ? (y -= 4) : '';
                    break;
                case 39: // right
                    type == 'day' ? (d += 1) : '';
                    type == 'month' ? (m += 1) : '';
                    type == 'year' ? (y += 1) : '';
                    break;
                case 40: // down
                    type == 'day' ? (d += 7) : '';
                    type == 'month' ? (m += 3) : '';
                    type == 'year' ? (y += 4) : '';
                    break;
            }

            var nd = new Date(y,m,d);
            if (nd.getTime() < this.minTime) {
                nd = this.minDate;
            } else if (nd.getTime() > this.maxTime) {
                nd = this.maxDate;
            }

            this.focused = nd;

        },

        _getFocusedDate: function () {
            var focused  = this.focused || this.selectedDates[this.selectedDates.length - 1],
                d = this.parsedDate;

            if (!focused) {
                switch (this.view) {
                    case 'days':
                        focused = new Date(d.year, d.month, new Date().getDate());
                        break;
                    case 'months':
                        focused = new Date(d.year, d.month, 1);
                        break;
                    case 'years':
                        focused = new Date(d.year, 0, 1);
                        break;
                }
            }

            return focused;
        },

        _getCell: function (date, type) {
            type = type || this.cellType;

            var d = datepicker.getParsedDate(date),
                selector = '.datepicker--cell[data-year="' + d.year + '"]',
                $cell;

            switch (type) {
                case 'month':
                    selector = '[data-month="' + d.month + '"]';
                    break;
                case 'day':
                    selector += '[data-month="' + d.month + '"][data-date="' + d.date + '"]';
                    break;
            }
            $cell = this.views[this.currentView].$el.find(selector);

            return $cell.length ? $cell : $('');
        },

        destroy: function () {
            var _this = this;
            _this.$el
                .off('.adp')
                .data('datepicker', '');

            _this.selectedDates = [];
            _this.focused = '';
            _this.views = {};
            _this.keys = [];
            _this.minRange = '';
            _this.maxRange = '';

            if (_this.opts.inline || !_this.elIsInput) {
                _this.$datepicker.closest('.datepicker-inline').remove();
            } else {
                _this.$datepicker.remove();
            }
        },

        _handleAlreadySelectedDates: function (alreadySelected, selectedDate) {
            if (this.opts.range) {
                if (!this.opts.toggleSelected) {
                    // Add possibility to select same date when range is true
                    if (this.selectedDates.length != 2) {
                        this._trigger('clickCell', selectedDate);
                    }
                } else {
                    this.removeDate(selectedDate);
                }
            } else if (this.opts.toggleSelected){
                this.removeDate(selectedDate);
            }

            // Change last selected date to be able to change time when clicking on this cell
            if (!this.opts.toggleSelected) {
                this.lastSelectedDate = alreadySelected;
                if (this.opts.timepicker) {
                    this.timepicker._setTime(alreadySelected);
                    this.timepicker.update();
                }
            }
        },

        _onShowEvent: function (e) {
            if (!this.visible) {
                this.show();
            }
        },

        _onBlur: function () {
            if (!this.inFocus && this.visible) {
                this.hide();
            }
        },

        _onMouseDownDatepicker: function (e) {
            this.inFocus = true;
        },

        _onMouseUpDatepicker: function (e) {
            this.inFocus = false;
            e.originalEvent.inFocus = true;
            if (!e.originalEvent.timepickerFocus) this.$el.focus();
        },

        _onKeyUpGeneral: function (e) {
            var val = this.$el.val();

            if (!val) {
                this.clear();
            }
        },

        _onResize: function () {
            if (this.visible) {
                this.setPosition();
            }
        },

        _onMouseUpBody: function (e) {
            if (e.originalEvent.inFocus) return;

            if (this.visible && !this.inFocus) {
                this.hide();
            }
        },

        _onMouseUpEl: function (e) {
            e.originalEvent.inFocus = true;
            setTimeout(this._onKeyUpGeneral.bind(this),4);
        },

        _onKeyDown: function (e) {
            var code = e.which;
            this._registerKey(code);

            // Arrows
            if (code >= 37 && code <= 40) {
                e.preventDefault();
                this._focusNextCell(code);
            }

            // Enter
            if (code == 13) {
                if (this.focused) {
                    if (this._getCell(this.focused).hasClass('-disabled-')) return;
                    if (this.view != this.opts.minView) {
                        this.down()
                    } else {
                        var alreadySelected = this._isSelected(this.focused, this.cellType);

                        if (!alreadySelected) {
                            if (this.timepicker) {
                                this.focused.setHours(this.timepicker.hours);
                                this.focused.setMinutes(this.timepicker.minutes);
                            }
                            this.selectDate(this.focused);
                            return;
                        }
                        this._handleAlreadySelectedDates(alreadySelected, this.focused)
                    }
                }
            }

            // Esc
            if (code == 27) {
                this.hide();
            }
        },

        _onKeyUp: function (e) {
            var code = e.which;
            this._unRegisterKey(code);
        },

        _onHotKey: function (e, hotKey) {
            this._handleHotKey(hotKey);
        },

        _onMouseEnterCell: function (e) {
            var $cell = $(e.target).closest('.datepicker--cell'),
                date = this._getDateFromCell($cell);

            // Prevent from unnecessary rendering and setting new currentDate
            this.silent = true;

            if (this.focused) {
                this.focused = ''
            }

            $cell.addClass('-focus-');

            this.focused = date;
            this.silent = false;

            if (this.opts.range && this.selectedDates.length == 1) {
                this.minRange = this.selectedDates[0];
                this.maxRange = '';
                if (datepicker.less(this.minRange, this.focused)) {
                    this.maxRange = this.minRange;
                    this.minRange = '';
                }
                this.views[this.currentView]._update();
            }
        },

        _onMouseLeaveCell: function (e) {
            var $cell = $(e.target).closest('.datepicker--cell');

            $cell.removeClass('-focus-');

            this.silent = true;
            this.focused = '';
            this.silent = false;
        },

        _onTimeChange: function (e, h, m) {
            var date = new Date(),
                selectedDates = this.selectedDates,
                selected = false;

            if (selectedDates.length) {
                selected = true;
                date = this.lastSelectedDate;
            }

            date.setHours(h);
            date.setMinutes(m);

            if (!selected && !this._getCell(date).hasClass('-disabled-')) {
                this.selectDate(date);
            } else {
                this._setInputValue();
                if (this.opts.onSelect) {
                    this._triggerOnChange();
                }
            }
        },

        _onClickCell: function (e, date) {
            if (this.timepicker) {
                date.setHours(this.timepicker.hours);
                date.setMinutes(this.timepicker.minutes);
            }
            this.selectDate(date);
        },

        set focused(val) {
            if (!val && this.focused) {
                var $cell = this._getCell(this.focused);

                if ($cell.length) {
                    $cell.removeClass('-focus-')
                }
            }
            this._focused = val;
            if (this.opts.range && this.selectedDates.length == 1) {
                this.minRange = this.selectedDates[0];
                this.maxRange = '';
                if (datepicker.less(this.minRange, this._focused)) {
                    this.maxRange = this.minRange;
                    this.minRange = '';
                }
            }
            if (this.silent) return;
            this.date = val;
        },

        get focused() {
            return this._focused;
        },

        get parsedDate() {
            return datepicker.getParsedDate(this.date);
        },

        set date (val) {
            if (!(val instanceof Date)) return;

            this.currentDate = val;

            if (this.inited && !this.silent) {
                this.views[this.view]._render();
                this.nav._render();
                if (this.visible && this.elIsInput) {
                    this.setPosition();
                }
            }
            return val;
        },

        get date () {
            return this.currentDate
        },

        set view (val) {
            this.viewIndex = this.viewIndexes.indexOf(val);

            if (this.viewIndex < 0) {
                return;
            }

            this.prevView = this.currentView;
            this.currentView = val;

            if (this.inited) {
                if (!this.views[val]) {
                    this.views[val] = new  $.fn.datepicker.Body(this, val, this.opts)
                } else {
                    this.views[val]._render();
                }

                this.views[this.prevView].hide();
                this.views[val].show();
                this.nav._render();

                if (this.opts.onChangeView) {
                    this.opts.onChangeView(val)
                }
                if (this.elIsInput && this.visible) this.setPosition();
            }

            return val
        },

        get view() {
            return this.currentView;
        },

        get cellType() {
            return this.view.substring(0, this.view.length - 1)
        },

        get minTime() {
            var min = datepicker.getParsedDate(this.minDate);
            return new Date(min.year, min.month, min.date).getTime()
        },

        get maxTime() {
            var max = datepicker.getParsedDate(this.maxDate);
            return new Date(max.year, max.month, max.date).getTime()
        },

        get curDecade() {
            return datepicker.getDecade(this.date)
        }
    };

    //  Utils
    // -------------------------------------------------

    datepicker.getDaysCount = function (date) {
        return new Date(date.getFullYear(), date.getMonth() + 1, 0).getDate();
    };

    datepicker.getParsedDate = function (date) {
        return {
            year: date.getFullYear(),
            month: date.getMonth(),
            fullMonth: (date.getMonth() + 1) < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1, // One based
            date: date.getDate(),
            fullDate: date.getDate() < 10 ? '0' + date.getDate() : date.getDate(),
            day: date.getDay(),
            hours: date.getHours(),
            fullHours:  date.getHours() < 10 ? '0' + date.getHours() :  date.getHours() ,
            minutes: date.getMinutes(),
            fullMinutes:  date.getMinutes() < 10 ? '0' + date.getMinutes() :  date.getMinutes()
        }
    };

    datepicker.getDecade = function (date) {
        var firstYear = Math.floor(date.getFullYear() / 10) * 10;

        return [firstYear, firstYear + 9];
    };

    datepicker.template = function (str, data) {
        return str.replace(/#\{([\w]+)\}/g, function (source, match) {
            if (data[match] || data[match] === 0) {
                return data[match]
            }
        });
    };

    datepicker.isSame = function (date1, date2, type) {
        if (!date1 || !date2) return false;
        var d1 = datepicker.getParsedDate(date1),
            d2 = datepicker.getParsedDate(date2),
            _type = type ? type : 'day',

            conditions = {
                day: d1.date == d2.date && d1.month == d2.month && d1.year == d2.year,
                month: d1.month == d2.month && d1.year == d2.year,
                year: d1.year == d2.year
            };

        return conditions[_type];
    };

    datepicker.less = function (dateCompareTo, date, type) {
        if (!dateCompareTo || !date) return false;
        return date.getTime() < dateCompareTo.getTime();
    };

    datepicker.bigger = function (dateCompareTo, date, type) {
        if (!dateCompareTo || !date) return false;
        return date.getTime() > dateCompareTo.getTime();
    };

    datepicker.getLeadingZeroNum = function (num) {
        return parseInt(num) < 10 ? '0' + num : num;
    };

    /**
     * Returns copy of date with hours and minutes equals to 0
     * @param date {Date}
     */
    datepicker.resetTime = function (date) {
        if (typeof date != 'object') return;
        date = datepicker.getParsedDate(date);
        return new Date(date.year, date.month, date.date)
    };

    $.fn.datepicker = function ( options ) {
        return this.each(function () {
            if (!$.data(this, pluginName)) {
                $.data(this,  pluginName,
                    new Datepicker( this, options ));
            } else {
                var _this = $.data(this, pluginName);

                _this.opts = $.extend(true, _this.opts, options);
                _this.update();
            }
        });
    };

    $.fn.datepicker.Constructor = Datepicker;

    $.fn.datepicker.language = {
        ru: {
            days: ['Воскресенье', 'Понедельник', 'Вторник', 'Среда', 'Четверг', 'Пятница', 'Суббота'],
            daysShort: ['Вос','Пон','Вто','Сре','Чет','Пят','Суб'],
            daysMin: ['Вс','Пн','Вт','Ср','Чт','Пт','Сб'],
            months: ['Январь', 'Февраль', 'Март', 'Апрель', 'Май', 'Июнь', 'Июль', 'Август', 'Сентябрь', 'Октябрь', 'Ноябрь', 'Декабрь'],
            monthsShort: ['Янв', 'Фев', 'Мар', 'Апр', 'Май', 'Июн', 'Июл', 'Авг', 'Сен', 'Окт', 'Ноя', 'Дек'],
            today: 'Сегодня',
            clear: 'Очистить',
            dateFormat: 'dd.mm.yyyy',
            timeFormat: 'hh:ii',
            firstDay: 1
        }
    };

    $(function () {
        $(autoInitSelector).datepicker();
    })

})();

;(function () {
    var templates = {
        days:'' +
        '<div class="datepicker--days datepicker--body">' +
        '<div class="datepicker--days-names"></div>' +
        '<div class="datepicker--cells datepicker--cells-days"></div>' +
        '</div>',
        months: '' +
        '<div class="datepicker--months datepicker--body">' +
        '<div class="datepicker--cells datepicker--cells-months"></div>' +
        '</div>',
        years: '' +
        '<div class="datepicker--years datepicker--body">' +
        '<div class="datepicker--cells datepicker--cells-years"></div>' +
        '</div>'
        },
        datepicker = $.fn.datepicker,
        dp = datepicker.Constructor;

    datepicker.Body = function (d, type, opts) {
        this.d = d;
        this.type = type;
        this.opts = opts;
        this.$el = $('');

        if (this.opts.onlyTimepicker) return;
        this.init();
    };

    datepicker.Body.prototype = {
        init: function () {
            this._buildBaseHtml();
            this._render();

            this._bindEvents();
        },

        _bindEvents: function () {
            this.$el.on('click', '.datepicker--cell', $.proxy(this._onClickCell, this));
        },

        _buildBaseHtml: function () {
            this.$el = $(templates[this.type]).appendTo(this.d.$content);
            this.$names = $('.datepicker--days-names', this.$el);
            this.$cells = $('.datepicker--cells', this.$el);
        },

        _getDayNamesHtml: function (firstDay, curDay, html, i) {
            curDay = curDay != undefined ? curDay : firstDay;
            html = html ? html : '';
            i = i != undefined ? i : 0;

            if (i > 7) return html;
            if (curDay == 7) return this._getDayNamesHtml(firstDay, 0, html, ++i);

            html += '<div class="datepicker--day-name' + (this.d.isWeekend(curDay) ? " -weekend-" : "") + '">' + this.d.loc.daysMin[curDay] + '</div>';

            return this._getDayNamesHtml(firstDay, ++curDay, html, ++i);
        },

        _getCellContents: function (date, type) {
            var classes = "datepicker--cell datepicker--cell-" + type,
                currentDate = new Date(),
                parent = this.d,
                minRange = dp.resetTime(parent.minRange),
                maxRange = dp.resetTime(parent.maxRange),
                opts = parent.opts,
                d = dp.getParsedDate(date),
                render = {},
                html = d.date;

            switch (type) {
                case 'day':
                    if (parent.isWeekend(d.day)) classes += " -weekend-";
                    if (d.month != this.d.parsedDate.month) {
                        classes += " -other-month-";
                        if (!opts.selectOtherMonths) {
                            classes += " -disabled-";
                        }
                        if (!opts.showOtherMonths) html = '';
                    }
                    break;
                case 'month':
                    html = parent.loc[parent.opts.monthsField][d.month];
                    break;
                case 'year':
                    var decade = parent.curDecade;
                    html = d.year;
                    if (d.year < decade[0] || d.year > decade[1]) {
                        classes += ' -other-decade-';
                        if (!opts.selectOtherYears) {
                            classes += " -disabled-";
                        }
                        if (!opts.showOtherYears) html = '';
                    }
                    break;
            }

            if (opts.onRenderCell) {
                render = opts.onRenderCell(date, type) || {};
                html = render.html ? render.html : html;
                classes += render.classes ? ' ' + render.classes : '';
            }

            if (opts.range) {
                if (dp.isSame(minRange, date, type)) classes += ' -range-from-';
                if (dp.isSame(maxRange, date, type)) classes += ' -range-to-';

                if (parent.selectedDates.length == 1 && parent.focused) {
                    if (
                        (dp.bigger(minRange, date) && dp.less(parent.focused, date)) ||
                        (dp.less(maxRange, date) && dp.bigger(parent.focused, date)))
                    {
                        classes += ' -in-range-'
                    }

                    if (dp.less(maxRange, date) && dp.isSame(parent.focused, date)) {
                        classes += ' -range-from-'
                    }
                    if (dp.bigger(minRange, date) && dp.isSame(parent.focused, date)) {
                        classes += ' -range-to-'
                    }

                } else if (parent.selectedDates.length == 2) {
                    if (dp.bigger(minRange, date) && dp.less(maxRange, date)) {
                        classes += ' -in-range-'
                    }
                }
            }


            if (dp.isSame(currentDate, date, type)) classes += ' -current-';
            if (parent.focused && dp.isSame(date, parent.focused, type)) classes += ' -focus-';
            if (parent._isSelected(date, type)) classes += ' -selected-';
            if (!parent._isInRange(date, type) || render.disabled) classes += ' -disabled-';

            return {
                html: html,
                classes: classes
            }
        },

        /**
         * Calculates days number to render. Generates days html and returns it.
         * @param {object} date - Date object
         * @returns {string}
         * @private
         */
        _getDaysHtml: function (date) {
            var totalMonthDays = dp.getDaysCount(date),
                firstMonthDay = new Date(date.getFullYear(), date.getMonth(), 1).getDay(),
                lastMonthDay = new Date(date.getFullYear(), date.getMonth(), totalMonthDays).getDay(),
                daysFromPevMonth = firstMonthDay - this.d.loc.firstDay,
                daysFromNextMonth = 6 - lastMonthDay + this.d.loc.firstDay;

            daysFromPevMonth = daysFromPevMonth < 0 ? daysFromPevMonth + 7 : daysFromPevMonth;
            daysFromNextMonth = daysFromNextMonth > 6 ? daysFromNextMonth - 7 : daysFromNextMonth;

            var startDayIndex = -daysFromPevMonth + 1,
                m, y,
                html = '';

            for (var i = startDayIndex, max = totalMonthDays + daysFromNextMonth; i <= max; i++) {
                y = date.getFullYear();
                m = date.getMonth();

                html += this._getDayHtml(new Date(y, m, i))
            }

            return html;
        },

        _getDayHtml: function (date) {
           var content = this._getCellContents(date, 'day');

            return '<div class="' + content.classes + '" ' +
                'data-date="' + date.getDate() + '" ' +
                'data-month="' + date.getMonth() + '" ' +
                'data-year="' + date.getFullYear() + '">' + content.html + '</div>';
        },

        /**
         * Generates months html
         * @param {object} date - date instance
         * @returns {string}
         * @private
         */
        _getMonthsHtml: function (date) {
            var html = '',
                d = dp.getParsedDate(date),
                i = 0;

            while(i < 12) {
                html += this._getMonthHtml(new Date(d.year, i));
                i++
            }

            return html;
        },

        _getMonthHtml: function (date) {
            var content = this._getCellContents(date, 'month');

            return '<div class="' + content.classes + '" data-month="' + date.getMonth() + '">' + content.html + '</div>'
        },

        _getYearsHtml: function (date) {
            var d = dp.getParsedDate(date),
                decade = dp.getDecade(date),
                firstYear = decade[0] - 1,
                html = '',
                i = firstYear;

            for (i; i <= decade[1] + 1; i++) {
                html += this._getYearHtml(new Date(i , 0));
            }

            return html;
        },

        _getYearHtml: function (date) {
            var content = this._getCellContents(date, 'year');

            return '<div class="' + content.classes + '" data-year="' + date.getFullYear() + '">' + content.html + '</div>'
        },

        _renderTypes: {
            days: function () {
                var dayNames = this._getDayNamesHtml(this.d.loc.firstDay),
                    days = this._getDaysHtml(this.d.currentDate);

                this.$cells.html(days);
                this.$names.html(dayNames)
            },
            months: funct