<?php

    namespace pachno\core\modules\configuration\controllers;

    if (!class_exists('\\b2db\\Core')) require PACHNO_CORE_PATH . 'tests/b2dbmock.php';
    if (!class_exists('\\pachno\\core\\framework\\Parameterholder')) require PACHNO_CORE_PATH . 'framework/Parameterholder.php';
    if (!class_exists('\\pachno\\core\\framework\\Action')) require PACHNO_CORE_PATH . 'framework/Action.php';
    if (!class_exists('\\pachno\\core\\framework\\Context')) require PACHNO_CORE_PATH . 'framework/Context.php';
    if (!class_exists('\\pachno\\core\\framework\\Event')) require PACHNO_CORE_PATH . 'framework/Event.php';
    if (!class_exists('\\pachno\\core\\framework\\Settings')) require PACHNO_CORE_PATH . 'framework/Settings.php';
    if (!class_exists('\\pachno\\core\\framework\\Logging')) require PACHNO_CORE_PATH . 'framework/Logging.php';
    if (!class_exists('\\pachno\\core\\framework\\Request')) require PACHNO_CORE_PATH . 'framework/Request.php';
    if (!class_exists('\\pachno\\core\\entities\\common\\Identifiable')) require PACHNO_CORE_PATH . 'entities/common/Identifiable.php';
    if (!class_exists('\\pachno\\core\\entities\\common\\IdentifiableEventContainer')) require PACHNO_CORE_PATH . 'entities/common/IdentifiableEventContainer.php';
    if (!class_exists('\\pachno\\core\\entities\\User')) require PACHNO_CORE_PATH . 'entities/User.php';
    if (!class_exists('\\pachno\\core\\entities\\tables\\ScopedTable')) require PACHNO_CORE_PATH . 'entities/tables/ScopedTable.php';
    if (!class_exists('\\pachno\\core\\entities\\tables\\UserScopes')) require PACHNO_CORE_PATH . 'entities/tables/UserScopes.php';
    if (!class_exists('\\pachno\\core\\modules\\configuration\\controllers\\Main')) require PACHNO_INTERNAL_MODULES_PATH . '/configuration/controllers/Main.php';

    /**
     * Generated by PHPUnit_SkeletonGenerator on 2015-01-30 at 07:34:14.
     */
    class MainTest extends \PHPUnit_Framework_TestCase
    {

        /**
         * @var Actions
         */
        protected $object;

        protected $response;

        protected $i18n;

        /**
         * Sets up the fixture, for example, opens a network connection.
         * This method is called before a test is executed.
         */
        protected function setUp()
        {
            $this->response = $this->getMockBuilder('\\pachno\\core\\framework\\Response')
                             ->setMethods(array('setHttpStatus', 'setContentType', 'setDecoration', 'renderText', 'renderComponent', 'setTemplate'))
                             ->getMock();

            $this->i18n = $this->getMockBuilder('\\pachno\\core\\framework\\I18n')
                             ->disableOriginalConstructor()
                             ->setMethods(array('__', 'getCharset'))
                             ->getMock();

            $this->i18n->method('__')->will($this->returnArgument(0));
            $this->i18n->method('getCharset')->will($this->returnValue('utf-8'));

            $this->object = $this->getMockBuilder('\\pachno\\core\\modules\\configuration\\controllers\\Main')
                                 ->setMethods(array('getResponse', 'getI18n', 'renderJSON'))
                                 ->getMock();

            $this->object->method('getResponse')->willReturn($this->response);
            $this->object->method('renderJSON')->willReturn($this->returnArgument(0));
            $this->object->method('getI18n')->willReturn($this->i18n);
        }

        /**
         * Tears down the fixture, for example, closes a network connection.
         * This method is called after a test is executed.
         */
        protected function tearDown()
        {
            \b2db\Core::resetMocks();
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::getAuthenticationMethodForAction
         * @todo   Implement testGetAuthenticationMethodForAction().
         */
        public function testGetAuthenticationMethodForAction()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::preExecute
         * @todo   Implement testPreExecute().
         */
        public function testPreExecute()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runIndex
         * @todo   Implement testRunIndex().
         */
        public function testRunIndex()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runCheckUpdates
         * @todo   Implement testRunCheckUpdates().
         */
        public function testRunCheckUpdates()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runImport
         * @todo   Implement testRunImport().
         */
        public function testRunImport()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runSettings
         * @todo   Implement testRunSettings().
         */
        public function testRunSettings()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureProjects
         * @todo   Implement testRunConfigureProjects().
         */
        public function testRunConfigureProjects()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureIssuefields
         * @todo   Implement testRunConfigureIssuefields().
         */
        public function testRunConfigureIssuefields()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureIssuetypes
         * @todo   Implement testRunConfigureIssuetypes().
         */
        public function testRunConfigureIssuetypes()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureIssuetypesGetOptionsForScheme
         * @todo   Implement testRunConfigureIssuetypesGetOptionsForScheme().
         */
        public function testRunConfigureIssuetypesGetOptionsForScheme()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureIssuetypesAction
         * @todo   Implement testRunConfigureIssuetypesAction().
         */
        public function testRunConfigureIssuetypesAction()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureIssuefieldsGetOptions
         * @todo   Implement testRunConfigureIssuefieldsGetOptions().
         */
        public function testRunConfigureIssuefieldsGetOptions()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureIssuefieldsAction
         * @todo   Implement testRunConfigureIssuefieldsAction().
         */
        public function testRunConfigureIssuefieldsAction()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureIssuefieldsCustomTypeAction
         * @todo   Implement testRunConfigureIssuefieldsCustomTypeAction().
         */
        public function testRunConfigureIssuefieldsCustomTypeAction()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureModules
         * @todo   Implement testRunConfigureModules().
         */
        public function testRunConfigureModules()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runAddProject
         * @todo   Implement testRunAddProject().
         */
        public function testRunAddProject()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runGetUserEditForm
         * @todo   Implement testRunGetUserEditForm().
         */
        public function testRunGetUserEditForm()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runDeleteProject
         * @todo   Implement testRunDeleteProject().
         */
        public function testRunDeleteProject()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runArchiveProject
         * @todo   Implement testRunArchiveProject().
         */
        public function testRunArchiveProject()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runUnarchiveProject
         * @todo   Implement testRunUnarchiveProject().
         */
        public function testRunUnarchiveProject()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runModuleAction
         * @todo   Implement testRunModuleAction().
         */
        public function testRunModuleAction()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runGetPermissionsInfo
         * @todo   Implement testRunGetPermissionsInfo().
         */
        public function testRunGetPermissionsInfo()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runSetPermission
         * @todo   Implement testRunSetPermission().
         */
        public function testRunSetPermission()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureModule
         * @todo   Implement testRunConfigureModule().
         */
        public function testRunConfigureModule()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigurePermissions
         * @todo   Implement testRunConfigurePermissions().
         */
        public function testRunConfigurePermissions()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureUploads
         * @todo   Implement testRunConfigureUploads().
         */
        public function testRunConfigureUploads()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureAuthentication
         * @todo   Implement testRunConfigureAuthentication().
         */
        public function testRunConfigureAuthentication()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runSaveAuthentication
         * @todo   Implement testRunSaveAuthentication().
         */
        public function testRunSaveAuthentication()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureUsers
         * @todo   Implement testRunConfigureUsers().
         */
        public function testRunConfigureUsers()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runDeleteGroup
         * @todo   Implement testRunDeleteGroup().
         */
        public function testRunDeleteGroup()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runAddGroup
         * @todo   Implement testRunAddGroup().
         */
        public function testRunAddGroup()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runGetGroupMembers
         * @todo   Implement testRunGetGroupMembers().
         */
        public function testRunGetGroupMembers()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runDeleteUser
         * @todo   Implement testRunDeleteUser().
         */
        public function testRunDeleteUser()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runDeleteTeam
         * @todo   Implement testRunDeleteTeam().
         */
        public function testRunDeleteTeam()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runAddTeam
         * @todo   Implement testRunAddTeam().
         */
        public function testRunAddTeam()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runGetTeamMembers
         * @todo   Implement testRunGetTeamMembers().
         */
        public function testRunGetTeamMembers()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runRemoveTeamMember
         * @todo   Implement testRunRemoveTeamMember().
         */
        public function testRunRemoveTeamMember()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runAddTeamMember
         * @todo   Implement testRunAddTeamMember().
         */
        public function testRunAddTeamMember()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runFindUsers
         * @todo   Implement testRunFindUsers().
         */
        public function testRunFindUsers()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runAddUser
         */
        public function testRunAddUserWithNoMoreUsersInScopeThrowsException()
        {
            $scope = $this->getMockBuilder('\\pachno\\core\\entities\\Scope')
                          ->setMethods(array('hasUsersAvailable'))
                          ->getMock();
            $scope->method('hasUsersAvailable')->willReturn(false);

            \pachno\core\framework\Context::setScope($scope);

            $request = new \pachno\core\framework\Request();
            $this->object->expects($this->once())
                           ->method('renderJSON')
                           ->with($this->equalTo(array('error' => 'This instance of Pachno cannot add more users')));

            $this->object->runAddUser($request);
        }

        public function addUserRequestProvider()
        {
            return array(
                array('john', 'the john', 'john@example.com', '1234', 1),
                array('jane', 'the jane', 'jane@example.com', '', 1),
                array('Sean Connery', 'thshe shean', 'sean.connery@example.com', 's-words-400', 2),
            );
        }

        /**
         * Makes sure adding a user happens without errors
         * 
         * @link http://projects.pachno.com/pachno/issues/2494
         *
         * @covers pachno\core\modules\configuration\controllers\Main::runAddUser
         * @dataProvider addUserRequestProvider
         */
        public function testRunAddUser($username, $buddyname, $email, $password, $group_id)
        {
            \b2db\Core::resetMocks();
            $scope = $this->getMockBuilder('pachno\core\entities\Scope')
                          ->setMethods(array('hasUsersAvailable'))
                          ->getMock();
            $scope->method('hasUsersAvailable')->willReturn(true);

            \pachno\core\framework\Context::setScope($scope);

            $request = new \pachno\core\framework\Request();
            $request->setParameter('username', $username);
            $request->setParameter('buddyname', $buddyname);
            $request->setParameter('email', $email);
            $request->setParameter('password', $password);
            $request->setParameter('password_repeat', $password);
            $request->setParameter('group_id', $group_id);

            $usertablestub = $this->getMockBuilder('b2db\Table')
                         ->setMethods(array('isUsernameAvailable'))
                         ->getMock();
            $userscopestablestub = $this->getMockBuilder('b2db\Table')
                         ->getMock();

            \b2db\Core::setTableMock('pachno\core\entities\tables\UserScopes', $userscopestablestub);
            \b2db\Core::setTableMock('pachno\core\entities\User', $usertablestub);
            \b2db\Core::setTableMock('pachno\core\entities\tables\Users', $usertablestub);

            $usertablestub->method('isUsernameAvailable')->will($this->returnValue(true));

            // Expect action to verify that username is available
            $usertablestub->expects($this->once())->method('isUsernameAvailable')->with($username);
            $userscopestablestub->expects($this->once())->method('countUsers');

            $this->object->runAddUser($request);
            $userobject = \b2db\Core::getTable('pachno\core\entities\tables\Users')->getLastMockObject();

            // Expect action to set correct user properties
            $this->assertEquals($userobject->getUsername(), $username);
            $this->assertEquals($userobject->getBuddyname(), $buddyname);
            $this->assertEquals($userobject->getRealname(), $username);
            $this->assertEquals($userobject->getEmail(), $email);
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runUpdateUser
         * @todo   Implement testRunUpdateUser().
         */
        public function testRunUpdateUser()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runUpdateUserScopes
         * @todo   Implement testRunUpdateUserScopes().
         */
        public function testRunUpdateUserScopes()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runGetPermissionsConfigurator
         * @todo   Implement testRunGetPermissionsConfigurator().
         */
        public function testRunGetPermissionsConfigurator()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureWorkflowSchemes
         * @todo   Implement testRunConfigureWorkflowSchemes().
         */
        public function testRunConfigureWorkflowSchemes()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureWorkflows
         * @todo   Implement testRunConfigureWorkflows().
         */
        public function testRunConfigureWorkflows()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureWorkflowScheme
         * @todo   Implement testRunConfigureWorkflowScheme().
         */
        public function testRunConfigureWorkflowScheme()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureWorkflowSteps
         * @todo   Implement testRunConfigureWorkflowSteps().
         */
        public function testRunConfigureWorkflowSteps()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureWorkflowStep
         * @todo   Implement testRunConfigureWorkflowStep().
         */
        public function testRunConfigureWorkflowStep()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureWorkflowTransition
         * @todo   Implement testRunConfigureWorkflowTransition().
         */
        public function testRunConfigureWorkflowTransition()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::getAccessLevel
         * @todo   Implement testGetAccessLevel().
         */
        public function testGetAccessLevel()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runAddClient
         * @todo   Implement testRunAddClient().
         */
        public function testRunAddClient()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runDeleteClient
         * @todo   Implement testRunDeleteClient().
         */
        public function testRunDeleteClient()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runGetClientMembers
         * @todo   Implement testRunGetClientMembers().
         */
        public function testRunGetClientMembers()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runRemoveClientMember
         * @todo   Implement testRunRemoveClientMember().
         */
        public function testRunRemoveClientMember()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runAddClientMember
         * @todo   Implement testRunAddClientMember().
         */
        public function testRunAddClientMember()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runEditClient
         * @todo   Implement testRunEditClient().
         */
        public function testRunEditClient()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runImportCSV
         * @todo   Implement testRunImportCSV().
         */
        public function testRunImportCSV()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runGetIDsForImportCSV
         * @todo   Implement testRunGetIDsForImportCSV().
         */
        public function testRunGetIDsForImportCSV()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runDoImportCSV
         * @todo   Implement testRunDoImportCSV().
         */
        public function testRunDoImportCSV()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runScopes
         * @todo   Implement testRunScopes().
         */
        public function testRunScopes()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runScope
         * @todo   Implement testRunScope().
         */
        public function testRunScope()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureRole
         * @todo   Implement testRunConfigureRole().
         */
        public function testRunConfigureRole()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runConfigureRoles
         * @todo   Implement testRunConfigureRoles().
         */
        public function testRunConfigureRoles()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

        /**
         * @covers pachno\core\modules\configuration\controllers\Main::runSiteIcons
         * @todo   Implement testRunSiteIcons().
         */
        public function testRunSiteIcons()
        {
            // Remove the following lines when you implement this test.
            $this->markTestIncomplete(
                    'This test has not been implemented yet.'
            );
        }

    }
