#region License
/* FNA - XNA4 Reimplementation for Desktop Platforms
 * Copyright 2009-2015 Ethan Lee and the MonoGame Team
 *
 * Released under the Microsoft Public License.
 * See LICENSE for details.
 */
#endregion

namespace Microsoft.Xna.Framework.Graphics
{
	/// <summary>
	/// Defines the faces in a cube map for the <see cref="TextureCube"/> class.
	/// </summary>
	public enum CubeMapFace
	{
		/// <summary>
		/// Positive X face in the cube map.
		/// </summary>
		PositiveX,
		/// <summary>
		/// Negative X face in the cube map.
		/// </summary>
		NegativeX,
		/// <summary>
		/// Positive Y face in the cube map.
		/// </summary>
		PositiveY,
		/// <summary>
		/// Negative Y face in the cube map.
		/// </summary>
		NegativeY,
		/// <summary>
		/// Positive Z face in the cube map.
		/// </summary>
		PositiveZ,
		/// <summary>
		/// Negative Z face in the cube map.
		/// </summary>
		NegativeZ
	}
}
