/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	cephrookiov1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCephObjectStoreUsers implements CephObjectStoreUserInterface
type FakeCephObjectStoreUsers struct {
	Fake *FakeCephV1
	ns   string
}

var cephobjectstoreusersResource = schema.GroupVersionResource{Group: "ceph.rook.io", Version: "v1", Resource: "cephobjectstoreusers"}

var cephobjectstoreusersKind = schema.GroupVersionKind{Group: "ceph.rook.io", Version: "v1", Kind: "CephObjectStoreUser"}

// Get takes name of the cephObjectStoreUser, and returns the corresponding cephObjectStoreUser object, and an error if there is any.
func (c *FakeCephObjectStoreUsers) Get(name string, options v1.GetOptions) (result *cephrookiov1.CephObjectStoreUser, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(cephobjectstoreusersResource, c.ns, name), &cephrookiov1.CephObjectStoreUser{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephObjectStoreUser), err
}

// List takes label and field selectors, and returns the list of CephObjectStoreUsers that match those selectors.
func (c *FakeCephObjectStoreUsers) List(opts v1.ListOptions) (result *cephrookiov1.CephObjectStoreUserList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(cephobjectstoreusersResource, cephobjectstoreusersKind, c.ns, opts), &cephrookiov1.CephObjectStoreUserList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &cephrookiov1.CephObjectStoreUserList{ListMeta: obj.(*cephrookiov1.CephObjectStoreUserList).ListMeta}
	for _, item := range obj.(*cephrookiov1.CephObjectStoreUserList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested cephObjectStoreUsers.
func (c *FakeCephObjectStoreUsers) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(cephobjectstoreusersResource, c.ns, opts))

}

// Create takes the representation of a cephObjectStoreUser and creates it.  Returns the server's representation of the cephObjectStoreUser, and an error, if there is any.
func (c *FakeCephObjectStoreUsers) Create(cephObjectStoreUser *cephrookiov1.CephObjectStoreUser) (result *cephrookiov1.CephObjectStoreUser, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(cephobjectstoreusersResource, c.ns, cephObjectStoreUser), &cephrookiov1.CephObjectStoreUser{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephObjectStoreUser), err
}

// Update takes the representation of a cephObjectStoreUser and updates it. Returns the server's representation of the cephObjectStoreUser, and an error, if there is any.
func (c *FakeCephObjectStoreUsers) Update(cephObjectStoreUser *cephrookiov1.CephObjectStoreUser) (result *cephrookiov1.CephObjectStoreUser, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(cephobjectstoreusersResource, c.ns, cephObjectStoreUser), &cephrookiov1.CephObjectStoreUser{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephObjectStoreUser), err
}

// Delete takes name of the cephObjectStoreUser and deletes it. Returns an error if one occurs.
func (c *FakeCephObjectStoreUsers) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(cephobjectstoreusersResource, c.ns, name), &cephrookiov1.CephObjectStoreUser{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCephObjectStoreUsers) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(cephobjectstoreusersResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &cephrookiov1.CephObjectStoreUserList{})
	return err
}

// Patch applies the patch and returns the patched cephObjectStoreUser.
func (c *FakeCephObjectStoreUsers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *cephrookiov1.CephObjectStoreUser, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(cephobjectstoreusersResource, c.ns, name, data, subresources...), &cephrookiov1.CephObjectStoreUser{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephObjectStoreUser), err
}
