# Azure Maps Open Source Projects

## Official Microsoft Projects

These are open-source, community-driven initiatives, created and maintained by the Azure Maps team, but are not part of the standard product or service offerings.

**Bots**

| Project Name | Description |
|-|-|
| [Bot Framework - Point of Interest skill](https://github.com/microsoft/botframework-solutions/tree/488093ac2fddf16096171f6a926315aa45e199e7/skills/csharp/pointofinterestskill) | The Point of Interest Skill provides POI related capabilities to a Virtual Assistant using Azure Maps with Azure Bot Service and Bot Framework. |
| [BotBuilder Location](https://github.com/Microsoft/BotBuilder-Location) | An open-source location picker control for Microsoft Bot Framework powered by Bing Maps REST services. |

**Open Web SDK modules**
<a href="#open-web-sdk-modules"></a>

The following is a list of open-source projects that extend the capabilities of the Azure Maps Web SDK.

| Project Name | Description |
|-|-|
| [Azure Maps Animation module](https://github.com/Azure-Samples/azure-maps-animations) | A rich library of animations for use with the Azure Maps Web SDK. |
| [Azure Maps Geolocation Control module](https://github.com/Azure-Samples/azure-maps-geolocation-control) | An Azure Maps Web SDK module that provides a control that uses the browser's geolocation API to locate the user on the map. |
| [Azure Maps Gridded Data Source module](https://github.com/Azure-Samples/azure-maps-gridded-data-source) | A module for the Azure Maps Web SDK that provides a data source that clusters data points into cells of a grid area. This operation is also known by many names such as tessellations, data binning, or hex bins.  |
| [Azure Maps Fullscreen Control module](https://github.com/Azure-Samples/azure-maps-fullscreen-control) | An Azure Maps Web SDK module that provides a control to display the map in fullscreen mode. |
| [Azure Maps Selection Control module](https://github.com/Azure-Samples/azure-maps-selection-control) | An Azure Maps Web SDK module that provides controls for selecting data in a data source using drawing tools or by requesting a route range polygon. |
| [Azure Maps Sync Map module](https://github.com/Azure-Samples/azure-maps-sync-maps) | An Azure Maps Web SDK module that synchronizes the cameras of two or more maps. |
| [Azure Maps Services UI module](https://github.com/Azure-Samples/azure-maps-services-ui) | A set of web UI controls that wrap the Azure Maps REST services. |

**Samples**

| Project Name | Description |
|-|-|
| [Azure Maps Code Samples](https://github.com/Azure-Samples/AzureMapsCodeSamples) | A collection of code samples for using Azure Maps in web based apps. |
| [Azure Maps Gov Cloud Code Samples](https://github.com/Azure-Samples/AzureMapsCodeSamples) | A collection of code samples for using Azure Maps through Azure Government Cloud. |
| [Azure Maps & Azure Active Directory Samples](https://github.com/Azure-Samples/Azure-Maps-AzureAD-Samples) | A collection of samples that show how to use Azure Active Directory with Azure Maps. | 
| [Azure Maps Jupyter Notebook samples](https://github.com/Azure-Samples/Azure-Maps-Jupyter-Notebook) | A collection of python samples using the Azure Maps REST services. |
| [Azure Maps .NET UWP IoT Remote Control](https://github.com/Azure-Samples/azure-maps-dotnet-webgl-uwp-iot-remote-control) | This is a sample application which shows how to build a remotely controlled map using Azure Maps and IoT hub services. |
| [Implement IoT spatial analytics using Azure Maps](https://github.com/Azure-Samples/iothub-to-azure-maps-geofencing) | Tracking and capturing relevant events that occur in space and time is a common IoT scenario. |

**Tools and resources**

| Project Name | Description |
|-|-|
| [Azure Maps Docs](https://github.com/MicrosoftDocs/azure-docs/tree/master/articles/azure-maps) | Source for all Azure Location Based Services documentation. |
| [Azure Maps Creator Tools](https://github.com/Azure-Samples/AzureMapsCreator) | Python tools for Azure Maps Creator Tools. |

## Related Community Projects

These are open-source, community-driven initiatives, some of which the Azure Maps team contributes to, but are not part of the standard product or service offerings.

**Angular**

| Project Name | Description |
|-|-|
| [ng Azure Maps](https://github.com/arnaudleclerc/ng-azure-maps) |  An Angular 10 Azure Maps component. | 
| [Angular Azure Maps](https://github.com/Acaisoft/angular-azure-maps) | An Angular 6 Azure Maps component. |
| [Angular Azure Map Wrapper](https://github.com/srednicki95/am_samples) | Angular 6.0+ Azure Map Samples. |

**Blazor**

| Project Name | Description |
|-|-|
| [AzureMapsControl.Components](https://github.com/arnaudleclerc/AzureMapsControl.Components) | An Azure Maps Blazor component. WIP of azure-maps-controls Razor Components. |

**Flutter**

| Project Name | Description |
|-|-|
| [Flutter_map](https://github.com/johnpryan/flutter_map) | Use Azure Maps with the flutter UI toolkit. |

**Internet of Things (IoT)**

| Project Name | Description |
|-|-|
| [Azure IoT Real-time asset tracking workshop](http://aka.ms/iot-workshop/asset-tracking) | A step by step workshop for create a real-time device asset tracking application. |

**PowerApps PCF components**

| Project Name | Description |
|-|-|
| [Azure Maps PowerApps PCF Search Control component](https://github.com/mkcgphy/Azure-Maps-Get-Search-Address-TypeAhead) | A PowerApps component that provides a search bar control powered by Azure Maps.
| [Azure Maps PowerApps PCF component](https://github.com/jenschristianschroder/pcfAzureMaps) | A PowerApps PCF control that displays a dataset as pins on Azure Map. |
| [Azure Maps PowerApps PCF spider cluster control](https://github.com/alano444/PCFAzureMapCluststerSpider) | A PowerApps PCF control for displaying points as clusters that expand into a spider cluster layout. [Video](https://www.youtube.com/watch?v=9ehWIk2l4Tc&feature=youtu.be) |

**Python**

| Project Name | Description |
|-|-|
| [Azure Maps for Retail, Jupyter Notebooks](https://github.com/5h15h/Azure-Maps-Jupyter-Notebooks) | A colleciton of Python samples using Azure Maps in retail scenarios. |
| [Azure Maps Python Sample](https://github.com/eavanvalkenburg/azuremaps-python-sample) | Sample code for calling Azure Maps from Python. |

**Samples**

| Project Name | Description |
|-|-|
| [Azure Region Map](https://github.com/BuildAzure/azure-region-map) | An Interactive Microsoft Azure Regions Map |
| [Azure Maps Bus Demo](https://github.com/DibranMulder/Azure-Maps-Bus-Demo) | Animating an electric bus ride. |
| [Azure Maps Geofence Demo](https://github.com/jimbobbennett/AzureMapsGeofenceDemo) | Demo code for creating and querying a geofence. |
| [Coronavirus COVID-19 Dashboard](https://github.com/rovin-ms/covid19) | A dashboard showing Covid-19 stats over time on a map. |
| [Real-time flight map with Azure functions, CosmosDB and SignalR](https://github.com/davetheunissen/Global-Azure-Bootcamp-2019-Workshop) | Visualize real-time data on Azure Maps. |
| [Pubs of London](https://github.com/deeja/PubsOfLondon) | A pub finder app using Azure Maps. |
| [San Francisco Food Truck Explorer](https://github.com/joaquinrz/sf-foodtrucks) | A prototype application written in TypeScript and React.js to easily visualize in Microsoft Azure Maps all the current active food trucks in the city of San Francisco, CA. |
| [Pollution Tracker](https://github.com/jimbobbennett/PollutionTracker) | Azure Maps based pollution tracker. |

**Tools and extensions**

| Project Name | Description |
|-|-|
| [A-Maps](https://github.com/riccardoklinger/amaps) | A QGIS plugin for the Azure Maps REST services. |
| [AirMap Azure Maps plugin](https://github.com/airmap/js-azure-maps-plugin) | Azure Maps JS plugin to view and interact with AirMap's Contextual Airspace Rules  |
| [AzMapOps](https://github.com/jonsatchwell/AzMapOps) | Powershell module for working with the Azure Maps API. |
| [Azure Maps GeoJSON Admin Portal](https://github.com/richorama/azure-maps-admin-portal) | A portal for managing GeoJSON data with the Azure Maps Data Services. |
| [Azure Maps .NET REST Client](https://github.com/perfahlen/AzureMapsRestServices) | .Net Standard 2.0 library to access AzureMaps Services |
| [PHP Azure Maps Provider](https://github.com/max-langerman/azure-maps-provider) | A PHP Azure Maps Geocoder Provider. | 

**React**

| Project Name | Description |
|-|-|
| [Azure Maps React Component](https://github.com/WiredSolutions/react-azure-maps) | A react wrapper for the Azure Maps control. |

**Xamarin**

| Project Name | Description |
|-|-|
| [XaMaps](https://github.com/AlexPshul/XaMaps) | Xamarin + Azure Maps |
| [XFAzureMapTrials](https://github.com/Druffl3/XFAzureMapTrials) | Use Azure Maps Creator in Xamarin.Forms. |

**Vue.js**

| Project Name | Description |
|-|-|
| [Vue Azure Maps](https://github.com/rickyruiz/vue-azure-maps) | Integrate Azure Maps in your Vue application |
