# Bing Maps Open Source Projects

## Official Microsoft Projects

| Project Name | Description |
|-|-|
| [Bing Maps Fleet Tracker](https://github.com/Microsoft/Bing-Maps-Fleet-Tracker) | The Bing Maps Fleet Tracker is a tracking solution for small to medium sized teams. Easily track vehicles and mobile devices. Previously known as "Project Hurghada". | 
| [Bing Maps REST Toolkit](https://github.com/Microsoft/BingMapsRESTToolkit) | This is a portable class library which makes it easy to access the Bing Maps REST services from .NET. |
| [Bing Maps Spatial Data Services Toolkit](https://github.com/Microsoft/BingMapsSDSToolkit) | This toolkit makes it easy to use the Bing Maps Spatial Data Services (SDS) in .NET |
| [Bing Maps V8 TypeScript Definitions](https://github.com/Microsoft/Bing-Maps-V8-TypeScript-Definitions) | This project contains the TypeScript definitions for the Bing Maps V8 Web Control. |
| [Bing Maps V8 Code Samples](https://github.com/Microsoft/BingMapsV8CodeSamples) | This is a collection of over two hundred code samples an growing for the Bing Maps V8 web control. |
| [BotBuilder Location](https://github.com/Microsoft/BotBuilder-Location) | An open-source location picker control for Microsoft Bot Framework powered by Bing Maps REST services. |
| [Bing Maps Unity SDK](https://github.com/microsoft/MapsSDK-Unity) | This repository contains samples, documentation, and supporting scripts for Maps SDK, a Microsoft Garage project.  |
| [Bing Maps native SDKs](https://github.com/microsoft/MapsSDK-Native) | This repository contains samples, documentation and releases history for the Bing Maps SDK for Android and iOS.  |

## Related Community Projects

| Project Name | Description |
|-|-|
| [Angular Bing Maps](https://github.com/Credera/angular-bing-maps) | Set of angular directives to wrap the Bing Maps JS API. |
| [Angular Maps](https://github.com/infusion-code/angular-maps) | Angular Maps (X-Map) is a set of components and services to provide map functionality in angular 2+ apps. |
| [A Simple World Composer using Unity](https://github.com/zjwzjw369/A-Simple-World-Composer-using-Unity) | A Simple World Composer using Unity and Bing Maps. Easily Generate realistic terrain. |
| [Bing Maps Android SDK](https://github.com/pengan1987/BingMapsAndroidSDK) | A native Android wrapper around the Bing Maps V8 web control. |
| [Bing Maps V6.3 To V8 Shim](https://github.com/rbrundritt/BingMapsV63ToV8Shim) | This project provides a shim for applications that use the Bing Maps (formerly known as Virtual Earth) V6.x web control which wraps Bing Maps V8 web control. |
| [Bing Maps REST Services (Python)](https://github.com/bharadwajyarlagadda/bingmaps) | This project is a Python implementation of retrieving data from Bing maps API services (REST services)  |
| [Bing Maps REST Services Ruby client](https://github.com/thorstadt/periplus) | Bing Maps REST Client for Ruby |
| [CesiumJS](https://github.com/AnalyticalGraphicsInc/cesium) | An open-source JavaScript library for world-class 3D globes and maps. |
| [Geobing (REST Node Wrapper)](https://github.com/drynaski/geobing) | Node wrapper around the Bing Maps REST Services. |
| [InteractiveDataDisplay.WPF ]() | Interactive Data Display for WPF is a set of controls for adding interactive visualization of dynamic data to your application. Integrates well with Bing Maps WPF control to show data on a geographic map in latitude/longitude coordinates. |
| [Leaflet Bing Layer](https://github.com/digidem/leaflet-bing-layer) | A Bing Maps layer for Leaflet. |
| [React Cartographer](https://github.com/yahoo/react-cartographer) | A react component for Bing Maps. |
