---
currentMenu: dev-hooks
---
# Tagged hook services

In order to provide or subscribe to hooks, a module must implement a service implementing the corresponding interfaces (see below).

Note all these classes need to implement a method named `getAreaName()`.
The returned area name must be unique and should follow the naming scheme:

- `<type>.<name>.<category>.<areaname>`
    - `<type>` must be 'subscriber' or 'provider'
    - `<name>` should be the module name (e.g. 'zikulafoohookmodule')
    - `<category>` must be a defined hook category (e.g. 'form_aware_hook')
    - `<areaname>` should be unique to the module but is typically related to the entity being hooked to (e.g. 'pages')
        for subscribers or descriptive of the content being hooked for provides (e.g. 'comments')

The service class must implement the appropriate Interface

- \Zikula\Bundle\HookBundle\HookSubscriberInterface (extends HookInterface)
- \Zikula\Bundle\HookBundle\HookProviderInterface (extends HookInterface)
- \Zikula\Bundle\HookBundle\HookSelfAllowedProviderInterface (extends HookProverInterface)
- \Zikula\Bundle\HookBundle\HookInterface (not for implementation, provided here for reference only)

See the extended docs `3a.TaggedHookServices.Subscriber.md`, `3b.TaggedHookServices.Provider.md`
`3c.TaggedHookServices.SelfAllowedProvider.md` for more information about the implementation of these service classes.
