---
currentMenu: dev-hooks
---
# Tagged hook services

## HookSubscriberInterface

Interface: `\Zikula\Bundle\HookBundle\HookSubscriberInterface`

Extends: `\Zikula\Bundle\HookBundle\HookInterface`

Example:

```php
class FormAwareHookSubscriber implements HookSubscriberInterface
{
    /**
     * @var TranslatorInterface
     */
    private $translator;

    /**
     * @param TranslatorInterface $translator
     */
    public function __construct(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }

    public function getOwner()
    {
        return 'ZikulaFooHookModule';
    }

    public function getCategory()
    {
        return FormAwareCategory::NAME;
    }

    public function getTitle()
    {
        return $this->translator->trans('FooHook FormAware Subscribers');
    }

    public function getEvents()
    {
        return [
            FormAwareCategory::TYPE_EDIT => 'zikulafoohookmodule.form_aware_hook.foo.edit',
            FormAwareCategory::TYPE_PROCESS_EDIT => 'zikulafoohookmodule.form_aware_hook.foo.process_edit'
        ];
    }

    public function getAreaName()
    {
        return 'subscriber.zikulafoomodule.form_aware_hook.foo';
    }
```
