---
currentMenu: dev-hooks
---
# Tagged hook services

## HookProviderInterface

A HookProvider is very much like a Symfony EventSubscriber and so, the interface has a similar look and implementation -
The most obvious is the similarity between `HookProviderInterface::getProviderTypes` and `EventSubscriberInterface::getSubscribedEvents`
There are some obvious difference to account for the special needs of hooks over events.

Interface: `\Zikula\Bundle\HookBundle\HookProviderInterface`

Extends: `\Zikula\Bundle\HookBundle\HookInterface`

Example:

```php
class FormAwareHookProvider implements HookProviderInterface
{
    private $session;
    private $translator;
    private $formFactory;

    public function __construct(
        SessionInterface $session,
        TranslatorInterface $translator,
        FormFactoryInterface $formFactory
    ) {
        $this->session = $session;
        $this->translator = $translator;
        $this->formFactory = $formFactory;
    }

    public function getOwner()
    {
        return 'ZikulaFooHookModule';
    }

    public function getCategory()
    {
        return FormAwareCategory::NAME;
    }

    public function getTitle()
    {
        return $this->translator->trans('FooHook Provider');
    }

    public function getProviderTypes()
    {
        return [
            FormAwareCategory::TYPE_EDIT => 'edit',
            FormAwareCategory::TYPE_PROCESS_EDIT => 'processEdit',
        ];
    }

    public function edit(FormAwareHook $hook)
    {
        $myForm = $this->formFactory->create(FooType::class, null, [
            'auto_initialize' => false, // required
            'mapped' => false // required
        ]);
        $hook
            ->formAdd($myForm)
            ->addTemplate(('@ZikulaFooHookModule/Hook/test_fooform.html.twig'))
        ;
    }

    public function processEdit(FormAwareResponse $hook)
    {
        $fooForm = $hook->getFormData('zikulafoomodule_fooform');
        $this->session->getFlashBag()->add('success', sprintf('The FormAwareHookProvider foo form was processed and the answer was %s', $fooForm['textField']));
    }

    public function getAreaName()
    {
        return 'provider.zikulafoomodule.form_aware_hook.foo';
    }
}
```
