---
currentMenu: dev-hooks
---
# Zikula hook naming

By convention we use lower case letters and numbers, with full-stop and underscore
characters only.  The full-stop is used to separate out logically separate items
(a kind of namespacing) while the underscore is used in place of a space character
to punctuate logically connected items.

## Area naming

Areas must all be unique, please use this format:

```
<type>.<name>.<category>.<areaname>
```

Type can be 'subscriber' or 'provider'

For example:

```
provider.ratings.ui_hooks.rating (the provider area in 'ui_hooks' category)
subscriber.blog.ui_hooks.articles  (the subscriber area in 'ui_hooks' category)

provider.ratings.filter_hooks.rating (the provider area in 'filter_hooks' category)
subscriber.blog.filter_hooks.articles  (the subscriber area in 'filter_hooks' category)
```

## Hook events

In this section we will discuss the actual hookable event that is triggered by
a subscriber module.  The hook event object encapsulates information about the
hookable event. First, we need the hook event name, e.g. `<module>.<category>.<area>.<type>`.

### Naming convention

Hook events should be named as follows:

```
<module>.<category>.<area>.<type>
```

### Event Trigger

To create a hookable event, create an appropriate hook object and then notify that
hook using hook's `notify()` method.
