---
currentMenu: contributing
---
# Mentoring Program

The Zikula Core development team has found that providing a mentor to new members of the team has resulted in a smoother integration of the new member into the processes we use to develop the project. Because of this success, mentoring is being made a more formal part of inducting a new member into the team. New members will be assigned one or two mentors--an existing team member who has volunteered to sponsor the new member. While these volunteers are the new member's assigned sponsors, all members are still highly encouraged to help new members (and each other) understand and implement our processes better.

Members who would like to volunteer to sponsor a new addition to the team need only make the project lead aware of their desire during the discussion regarding the addition of the new member. It is neither necessary to know the new member beforehand, nor to be in the same part of the world as the new member. We are, after all, a truly global team. All that is required is an adequate knowledge of the process of developing Zikula, and a desire to help.

## Mentor Responsibilities

A mentor…

- …helps the new member understand our ticketing, QA, version control, commit, and merge processes and procedures.
- …points out where the new member can find documentation, tools that we use, and other tools that may be helpful.
- …initially keeps an eye on commits and other activities of the new member to ensure that the correct processes and procedures are followed. If anything was missed or done out of order, the mentor helps the new member understand what went wrong and why, and then helps the new member correct his or her own work.
- …is available to the new member to answer any questions he or she might have, and will answer those questions in a friendly, nonjudgmental, non-threatening manner. No question is a "dumb question." If the mentor cannot answer the question, he or she will help point the new member to the correct resource to find the answer.

A mentor…

- …is not an expert on the entire process, but is willing to help the new member find the answer to a question when he does not know himself.
- …is not the "code police," or the "process boss" of the new member. Assistance should be given in the spirit of friendly collaboration.
- …is not responsible for teaching the new member the fundamentals of programming, or other similar basic concepts--but can help the new member where and when he can.

## New Member Responsibilities

A new member…

- …asks questions when he or she is not sure of how to proceed with something. No question is a "dumb question" if you don't know the answer.
- …acts boldly, and takes the initiative. His or her mentor is there to help, not there to direct.
- …relies on both his or her mentor ''and'' the rest of the team for information and assistance. His or her mentor a primary source of help, but not the ''only'' source of help.

## Responsibilities of both

The process of mentoring and of becoming a member of the team will, at times, make you aware of areas of the wiki or other documentation that could be improved. Take the initiative, when able, to update the wiki or other documentation with your knowledge or new things you have learned so that it is available to future mentors and new members.

Sometimes commitments or other circumstances outside the project take us away from Zikula for periods of time. Each should ensure that the other is aware of these circumstances.

Mentoring is intended to be a positive experience for both the mentor and the new member. Sometimes personalities don't work well together, or communication styles clash. Mentors and new members are encouraged to work through these things together. If, however, a mentor and new member find that they do not collaborate well together and cannot work through their differences, then do not let things go so far that feelings get hurt or egos get bruised. It's no big deal… sometimes things just don't work out, and you're not stuck together forever. Let the project lead know, and work with him to find a better way forward. The important thing to remember is that we're all after the same goal, so find a way to resolve things amicably.
