---
currentMenu: contributing
---
# Contributing to Zikula Core

Contributions can be made to Zikula in a number of ways:

1. By using our software!
2. Assisting other users at our [Slack channels](https://zikula.slack.com/)
3. [Contributing translations](../../Translation/Contributing.md) for Zikula.
4. Creating [themes](../../LayoutDesign/Themes/README.md) for Zikula.
5. Authoring additional extensions for Zikula.
6. Contributing bug fixes and patches to the Core.

## Contributing code

Everyone is welcome to contribute code to the project. Pull requests are appreciated!

This section explains our contribution workflow and guidelines which help us manage the project smoothly and maintain standards.

### Prerequisites

All contributors need to have an account at [GitHub](https://github.com).

### Basic information about code contributions

- [Setting up a core development environment](SetupDevEnv.md)
- [Contribution workflows](ContributionWorkflows.md)
- [Mentoring Program](MentoringProgram.md)

### Guidelines

Please follow these guidelines when contributing:

- [Rules for Developers](RulesForDevelopers.md)
- [Developer Guidelines](DeveloperGuidelines.md)
- [Commit Guidelines](CommitGuidelines.md)
- [Coding Standards](CodingStandards.md)
