---
currentMenu: contributing
---
# Rules governing developers

These are the rules and guidelines governing all Zikula projects.

- Please follow the [code style guidelines](CodingStandards.md).
- All contributions must be committed against approved tickets in the project tracker. Ad hoc contributions are not allowed. Feature requests are marked with status 'approved' and assigned to milestones by the project lead. Developers may use their discretion with bug tickets and assign the ticket to most appropriate milestone.
- You are encouraged to discuss ideas and providing challenging and stimulating relevent debate.
- Developers should work in a team, or with a team spirit.
- All issues (features, bugs and tasks) must be logged in the issue tracker. Tasks and Features will be either accepted and assigned to a milestone or rejected by the project lead or appointee. Developer can begin working on bugs generally without any approval including assigning them to a milestone at their discretion.
- The project lead developer will have the final say in any matter.
- Developers are expected to follow the QA processes set out.
  - Test your work before you commit;
  - Write unit tests for your work;
  - Perform a diff before you commit;
  - Commit your work regularly and in small increments;
  - Commit against a ticket number;
  - Merge work to other branches as required immediately;
  - Please update the changelogs with each completed feature/task/bugfix;
  - Do not break the codebase between commits (unless by agreement).
- Developers should all keep an eye on commits to the codebase looking for any obvious mistakes and errors from others - doing so helps the whole QA process. Everyone makes mistakes at some point, regardless of their experience or how careful they are. If someone makes a mistake just point it out in private, it's no big deal.
- Please do not drink and code - the ideas are never as good as you thought the next morning.
- As a general rule, if you feel unsure about anything, please ask.
- All developers should be willing to help eachother and willing to receive mentoring.
- Developers are expected to do their fair share of not-so-fun things like fixing bugs.
- If you are assigned a bug or task please do your best to complete it. If you dont know how, ask for help or see if someone else can take it.
- Please try to communicate your availability and be mindful of when you are unable to devote time to the project so other arrangements can be made to cover any commitments you have.
- Being a developer is a privilege and not a right. Developers who are unable to follow the guidelines or are continually disruptive may lose their privilege at the discretion of the project lead.
