---
currentMenu: templating
---
# Templating

Zikula uses the Twig template engine, like Symfony does.

## Basic topics

### General information about template and asset handling

- [Locations of Templates and Assets](TemplateAndAssetLocations.md)
- [Page assets](PageAssets.md)
- [Asset combination](AssetCombination.md)

### Twig extensions

- [Twig functions provided by Zikula Core](Functions.md)
- [Twig filters provided by Zikula Core](Filters.md)
- [Twig tags provided by Zikula Core](Tags.md)

### Additional topics

- [Twig template global variables](GlobalVariables.md)
- [Debugging Twig templates](DebuggingTwig.md)
- [Image manipulation with Imagine](Imagine.md)
- [Errors](Errors.md)

## External resources

- [Twig docs](https://twig.symfony.com/doc/3.x/)
- [Twig extensions provided by Twig](https://twig.symfony.com/doc/3.x/#reference)
- [Twig extensions provided by Symfony](https://symfony.com/doc/current/reference/twig_reference.html)
- [Bootstrap 4](https://getbootstrap.com/)
- [Font Awesome 5](https://fontawesome.com/)

## For developers

- [PageAssetApi](Dev/PageAssetApi.md)
- [Pagination of large result sets](Dev/Pagination.md)
- [Display an Alpha filter](Dev/AlphaFilter.md)
