<?php

/**
 * Routes.
 *
 * @copyright Zikula contributors (Zikula)
 * @license http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
 * @author Zikula contributors <info@ziku.la>.
 * @see https://ziku.la
 * @version Generated by ModuleStudio 1.4.0 (https://modulestudio.de).
 */

declare(strict_types=1);

namespace Zikula\RoutesModule\Controller;

use Zikula\RoutesModule\Controller\Base\AbstractRouteController;
use Psr\Log\LoggerInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Routing\RouterInterface;
use Zikula\ThemeModule\Engine\Annotation\Theme;
use Zikula\UsersModule\Api\ApiInterface\CurrentUserApiInterface;
use Zikula\RoutesModule\Entity\RouteEntity;
use Zikula\RoutesModule\Entity\Factory\EntityFactory;
use Zikula\RoutesModule\Form\Handler\Route\EditHandler;
use Zikula\RoutesModule\Helper\ControllerHelper;
use Zikula\RoutesModule\Helper\PermissionHelper;
use Zikula\RoutesModule\Helper\ViewHelper;
use Zikula\RoutesModule\Helper\WorkflowHelper;

/**
 * Route controller class providing navigation and interaction functionality.
 */
class RouteController extends AbstractRouteController
{
    /**
     *
     * @Route("/admin/routes",
     *        methods = {"GET"}
     * )
     * @Theme("admin")
     */
    public function adminIndexAction(
        Request $request,
        PermissionHelper $permissionHelper
    ): Response {
        return $this->indexInternal(
            $request,
            $permissionHelper,
            true
        );
    }
    
    /**
     *
     * @Route("/routes",
     *        methods = {"GET"}
     * )
     */
    public function indexAction(
        Request $request,
        PermissionHelper $permissionHelper
    ): Response {
        return $this->indexInternal(
            $request,
            $permissionHelper,
            false
        );
    }
    
    /**
     *
     * @Route("/admin/routes/view/{sort}/{sortdir}/{page}/{num}.{_format}",
     *        requirements = {"sortdir" = "asc|desc|ASC|DESC", "page" = "\d+", "num" = "\d+", "_format" = "html"},
     *        defaults = {"sort" = "", "sortdir" = "asc", "page" = 1, "num" = 10, "_format" = "html"},
     *        methods = {"GET"}
     * )
     * @Theme("admin")
     */
    public function adminViewAction(
        Request $request,
        RouterInterface $router,
        PermissionHelper $permissionHelper,
        ControllerHelper $controllerHelper,
        ViewHelper $viewHelper,
        string $sort,
        string $sortdir,
        int $page,
        int $num
    ): Response {
        return $this->viewInternal(
            $request,
            $router,
            $permissionHelper,
            $controllerHelper,
            $viewHelper,
            $sort,
            $sortdir,
            $page,
            $num,
            true
        );
    }
    
    /**
     *
     * @Route("/routes/view/{sort}/{sortdir}/{page}/{num}.{_format}",
     *        requirements = {"sortdir" = "asc|desc|ASC|DESC", "page" = "\d+", "num" = "\d+", "_format" = "html"},
     *        defaults = {"sort" = "", "sortdir" = "asc", "page" = 1, "num" = 10, "_format" = "html"},
     *        methods = {"GET"}
     * )
     */
    public function viewAction(
        Request $request,
        RouterInterface $router,
        PermissionHelper $permissionHelper,
        ControllerHelper $controllerHelper,
        ViewHelper $viewHelper,
        string $sort,
        string $sortdir,
        int $page,
        int $num
    ): Response {
        return $this->viewInternal(
            $request,
            $router,
            $permissionHelper,
            $controllerHelper,
            $viewHelper,
            $sort,
            $sortdir,
            $page,
            $num,
            false
        );
    }
    
    /**
     *
     * @Route("/admin/route/{id}.{_format}",
     *        requirements = {"id" = "\d+", "_format" = "html"},
     *        defaults = {"_format" = "html"},
     *        methods = {"GET"}
     * )
     * @Theme("admin")
     */
    public function adminDisplayAction(
        Request $request,
        PermissionHelper $permissionHelper,
        ControllerHelper $controllerHelper,
        ViewHelper $viewHelper,
        EntityFactory $entityFactory,
        RouteEntity $route = null,
        int $id = 0
    ): Response {
        return $this->displayInternal(
            $request,
            $permissionHelper,
            $controllerHelper,
            $viewHelper,
            $entityFactory,
            $route,
            $id,
            true
        );
    }
    
    /**
     *
     * @Route("/route/{id}.{_format}",
     *        requirements = {"id" = "\d+", "_format" = "html"},
     *        defaults = {"_format" = "html"},
     *        methods = {"GET"}
     * )
     */
    public function displayAction(
        Request $request,
        PermissionHelper $permissionHelper,
        ControllerHelper $controllerHelper,
        ViewHelper $viewHelper,
        EntityFactory $entityFactory,
        RouteEntity $route = null,
        int $id = 0
    ): Response {
        return $this->displayInternal(
            $request,
            $permissionHelper,
            $controllerHelper,
            $viewHelper,
            $entityFactory,
            $route,
            $id,
            false
        );
    }
    
    /**
     *
     * @Route("/admin/route/edit/{id}.{_format}",
     *        requirements = {"id" = "\d+", "_format" = "html"},
     *        defaults = {"id" = "0", "_format" = "html"},
     *        methods = {"GET", "POST"}
     * )
     * @Theme("admin")
     */
    public function adminEditAction(
        Request $request,
        PermissionHelper $permissionHelper,
        ControllerHelper $controllerHelper,
        ViewHelper $viewHelper,
        EditHandler $formHandler
    ): Response {
        return $this->editInternal(
            $request,
            $permissionHelper,
            $controllerHelper,
            $viewHelper,
            $formHandler,
            true
        );
    }
    
    /**
     *
     * @Route("/route/edit/{id}.{_format}",
     *        requirements = {"id" = "\d+", "_format" = "html"},
     *        defaults = {"id" = "0", "_format" = "html"},
     *        methods = {"GET", "POST"}
     * )
     */
    public function editAction(
        Request $request,
        PermissionHelper $permissionHelper,
        ControllerHelper $controllerHelper,
        ViewHelper $viewHelper,
        EditHandler $formHandler
    ): Response {
        return $this->editInternal(
            $request,
            $permissionHelper,
            $controllerHelper,
            $viewHelper,
            $formHandler,
            false
        );
    }
    
    /**
     * Process status changes for multiple items.
     *
     * @Route("/admin/routes/handleSelectedEntries",
     *        methods = {"POST"}
     * )
     * @Theme("admin")
     */
    public function adminHandleSelectedEntriesAction(
        Request $request,
        LoggerInterface $logger,
        EntityFactory $entityFactory,
        WorkflowHelper $workflowHelper,
        CurrentUserApiInterface $currentUserApi
    ): RedirectResponse {
        return $this->handleSelectedEntriesActionInternal(
            $request,
            $logger,
            $entityFactory,
            $workflowHelper,
            $currentUserApi,
            true
        );
    }
    
    /**
     * Process status changes for multiple items.
     *
     * @Route("/routes/handleSelectedEntries",
     *        methods = {"POST"}
     * )
     */
    public function handleSelectedEntriesAction(
        Request $request,
        LoggerInterface $logger,
        EntityFactory $entityFactory,
        WorkflowHelper $workflowHelper,
        CurrentUserApiInterface $currentUserApi
    ): RedirectResponse {
        return $this->handleSelectedEntriesActionInternal(
            $request,
            $logger,
            $entityFactory,
            $workflowHelper,
            $currentUserApi,
            false
        );
    }
    
    // feel free to add your own controller methods here
}
