<?php

/**
 * Routes.
 *
 * @copyright Zikula contributors (Zikula)
 * @license http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
 * @author Zikula contributors <info@ziku.la>.
 * @see https://ziku.la
 * @version Generated by ModuleStudio 1.4.0 (https://modulestudio.de).
 */

declare(strict_types=1);

namespace Zikula\RoutesModule\Entity\Factory\Base;

use Zikula\RoutesModule\Entity\RouteEntity;
use Zikula\RoutesModule\Helper\ListEntriesHelper;
use Zikula\RoutesModule\Helper\PermissionHelper;

/**
 * Entity initialiser class used to dynamically apply default values to newly created entities.
 */
abstract class AbstractEntityInitialiser
{
    /**
     * @var PermissionHelper
     */
    protected $permissionHelper;

    /**
     * @var ListEntriesHelper
     */
    protected $listEntriesHelper;

    public function __construct(
        PermissionHelper $permissionHelper,
        ListEntriesHelper $listEntriesHelper
    ) {
        $this->permissionHelper = $permissionHelper;
        $this->listEntriesHelper = $listEntriesHelper;
    }

    /**
     * Initialises a given route instance.
     */
    public function initRoute(RouteEntity $entity): RouteEntity
    {
        $listEntries = $this->listEntriesHelper->getEntries('route', 'schemes');
        $items = [];
        foreach ($listEntries as $listEntry) {
            if (true === $listEntry['default']) {
                $items[] = $listEntry['value'];
            }
        }
        $entity->setSchemes(implode('###', $items));

        $listEntries = $this->listEntriesHelper->getEntries('route', 'methods');
        $items = [];
        foreach ($listEntries as $listEntry) {
            if (true === $listEntry['default']) {
                $items[] = $listEntry['value'];
            }
        }
        $entity->setMethods(implode('###', $items));

        return $entity;
    }
    
    public function getListEntriesHelper(): ?ListEntriesHelper
    {
        return $this->listEntriesHelper;
    }
    
    public function setListEntriesHelper(ListEntriesHelper $listEntriesHelper = null): void
    {
        if ($this->listEntriesHelper !== $listEntriesHelper) {
            $this->listEntriesHelper = $listEntriesHelper;
        }
    }
}
