<?php

/**
 * Routes.
 *
 * @copyright Zikula contributors (Zikula)
 * @license http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
 * @author Zikula contributors <info@ziku.la>.
 * @see https://ziku.la
 * @version Generated by ModuleStudio 1.4.0 (https://modulestudio.de).
 */

declare(strict_types=1);

namespace Zikula\RoutesModule\Event\Base;

use Zikula\RoutesModule\Entity\RouteEntity;

/**
 * Event base class for filtering route processing.
 */
abstract class AbstractRoutePostRemoveEvent
{
    /**
     * @var RouteEntity Reference to treated entity instance.
     */
    protected $route;

    public function __construct(RouteEntity $route)
    {
        $this->route = $route;
    }

    /**
     * @return RouteEntity
     */
    public function getRoute(): RouteEntity
    {
        return $this->route;
    }
}
