<?php

/**
 * Routes.
 *
 * @copyright Zikula contributors (Zikula)
 * @license http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
 * @author Zikula contributors <info@ziku.la>.
 * @see https://ziku.la
 * @version Generated by ModuleStudio 1.4.0 (https://modulestudio.de).
 */

declare(strict_types=1);

namespace Zikula\RoutesModule\Form\DataTransformer\Base;

use Symfony\Component\Form\DataTransformerInterface;

/**
 * Array field transformer base class.
 */
abstract class AbstractArrayFieldTransformer implements DataTransformerInterface
{
    /**
     * Transforms the object array to the normalised value.
     *
     * @param array|null $values The object array
     *
     * @return string Normalised value
     */
    public function transform($values)
    {
        if (null === $values) {
            return '';
        }

        if (!is_array($values)) {
            return $values;
        }

        if (!count($values)) {
            return '';
        }

        $value = $this->removeEmptyEntries($values);

        return implode("\n", $value);
    }

    /**
     * Transforms a textual value back to the array.
     *
     * @param string $value The textual value
     *
     * @return array Resulting array
     */
    public function reverseTransform($value)
    {
        if (!$value) {
            return [];
        }

        $items = explode("\n", $value);

        return $this->removeEmptyEntries($items);
    }

    /**
     * Iterates over the given array and removes all empty entries.
     */
    protected function removeEmptyEntries(array $array = []): array
    {
        $items = $array;

        foreach ($items as $k => $v) {
            if (!empty($v)) {
                continue;
            }
            unset($items[$k]);
        }

        return $items;
    }
}
