<?php

/**
 * Routes.
 *
 * @copyright Zikula contributors (Zikula)
 * @license http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
 * @author Zikula contributors <info@ziku.la>.
 * @see https://ziku.la
 * @version Generated by ModuleStudio 1.4.0 (https://modulestudio.de).
 */

declare(strict_types=1);

namespace Zikula\RoutesModule\Helper\Base;

use Symfony\Contracts\Translation\TranslatorInterface;
use Zikula\Bundle\CoreBundle\Doctrine\EntityAccess;
use Zikula\RoutesModule\Entity\RouteEntity;
use Zikula\RoutesModule\Helper\ListEntriesHelper;

/**
 * Entity display helper base class.
 */
abstract class AbstractEntityDisplayHelper
{
    /**
     * @var TranslatorInterface
     */
    protected $translator;
    
    /**
     * @var ListEntriesHelper Helper service for managing list entries
     */
    protected $listEntriesHelper;
    
    public function __construct(
        TranslatorInterface $translator,
        ListEntriesHelper $listEntriesHelper
    ) {
        $this->translator = $translator;
        $this->listEntriesHelper = $listEntriesHelper;
    }
    
    /**
     * Returns the formatted title for a given entity.
     */
    public function getFormattedTitle(EntityAccess $entity): string
    {
        if ($entity instanceof RouteEntity) {
            return $this->formatRoute($entity);
        }
    
        return '';
    }
    
    /**
     * Returns the formatted title for a given entity.
     */
    protected function formatRoute(RouteEntity $entity): string
    {
        return $this->translator->trans(
            '%path% (%sort%)',
            [
                '%path%' => $entity->getPath(),
                '%sort%' => $entity->getSort()
            ]
        );
    }
    
    /**
     * Returns name of the field used as title / name for entities of this repository.
     */
    public function getTitleFieldName(string $objectType = ''): string
    {
        if ('route' === $objectType) {
            return 'bundle';
        }
    
        return '';
    }
    
    /**
     * Returns name of the field used for describing entities of this repository.
     */
    public function getDescriptionFieldName(string $objectType = ''): string
    {
        if ('route' === $objectType) {
            return 'controller';
        }
    
        return '';
    }
    
    /**
     * Returns name of the date(time) field to be used for representing the start
     * of this object. Used for providing meta data to the tag module.
     */
    public function getStartDateFieldName(string $objectType = ''): string
    {
        if ('route' === $objectType) {
            return 'createdDate';
        }
    
        return '';
    }
}
