﻿// <auto-generated />
using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Infrastructure;
using Microsoft.EntityFrameworkCore.Migrations;
using Microsoft.EntityFrameworkCore.Storage.ValueConversion;
using Npgsql.EntityFrameworkCore.PostgreSQL.Metadata;
using Thor.Provider;

#nullable disable

namespace Thor.Provider.PostgreSQL.Thor
{
    [DbContext(typeof(PostgreSQLThorContext))]
    [Migration("20241103170657_Initial")]
    partial class Initial
    {
        /// <inheritdoc />
        protected override void BuildTargetModel(ModelBuilder modelBuilder)
        {
#pragma warning disable 612, 618
            modelBuilder
                .HasAnnotation("ProductVersion", "8.0.10")
                .HasAnnotation("Relational:MaxIdentifierLength", 63);

            NpgsqlModelBuilderExtensions.UseIdentityByDefaultColumns(modelBuilder);

            modelBuilder.Entity("Thor.Service.Domain.ChatChannel", b =>
                {
                    b.Property<string>("Id")
                        .HasColumnType("text");

                    b.Property<string>("Address")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<bool>("ControlAutomatically")
                        .HasColumnType("boolean");

                    b.Property<DateTime>("CreatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("Creator")
                        .HasColumnType("text");

                    b.Property<bool>("Disable")
                        .HasColumnType("boolean");

                    b.Property<string>("Extension")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("Key")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("Models")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("Modifier")
                        .HasColumnType("text");

                    b.Property<string>("Name")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<int>("Order")
                        .HasColumnType("integer");

                    b.Property<string>("Other")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<int>("Quota")
                        .HasColumnType("integer");

                    b.Property<long>("RemainQuota")
                        .HasColumnType("bigint");

                    b.Property<long?>("ResponseTime")
                        .HasColumnType("bigint");

                    b.Property<string>("Type")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<DateTime?>("UpdatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("Id");

                    b.HasIndex("Creator");

                    b.HasIndex("Name");

                    b.ToTable("Channels");
                });

            modelBuilder.Entity("Thor.Service.Domain.ModelManager", b =>
                {
                    b.Property<Guid>("Id")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("uuid");

                    b.Property<decimal?>("AudioOutputRate")
                        .HasColumnType("numeric");

                    b.Property<decimal?>("AudioPromptRate")
                        .HasColumnType("numeric");

                    b.Property<bool>("Available")
                        .HasColumnType("boolean");

                    b.Property<decimal?>("CompletionRate")
                        .HasColumnType("numeric");

                    b.Property<DateTime>("CreatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("Creator")
                        .HasColumnType("text");

                    b.Property<string>("Description")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<bool>("Enable")
                        .HasColumnType("boolean");

                    b.Property<string>("Icon")
                        .HasColumnType("text");

                    b.Property<bool>("IsVersion2")
                        .HasColumnType("boolean");

                    b.Property<string>("Model")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("Modifier")
                        .HasColumnType("text");

                    b.Property<decimal>("PromptRate")
                        .HasColumnType("numeric");

                    b.Property<string>("QuotaMax")
                        .HasColumnType("text");

                    b.Property<int>("QuotaType")
                        .HasColumnType("integer");

                    b.Property<string>("Tags")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<DateTime?>("UpdatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("Id");

                    b.HasIndex("Creator");

                    b.HasIndex("Model");

                    b.ToTable("ModelManagers");

                    b.HasData(
                        new
                        {
                            Id = new Guid("5e7b1222-1d8e-4c67-90bd-372197d04a2c"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7624),
                            Description = "GPT-3.5 Turbo 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-3.5-turbo",
                            PromptRate = 0.75m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("ca529992-c50b-4bb2-8798-1fa8ac0984b4"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7633),
                            Description = "GPT-3.5 Turbo 0125 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-3.5-turbo-0125",
                            PromptRate = 0.25m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("d8f649f7-e1bb-4cdf-a6a0-ca410f1d370d"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7634),
                            Description = "GPT-3.5 Turbo 0301 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-3.5-turbo-0301",
                            PromptRate = 0.75m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("9a44324a-997e-4358-aec4-4e789192acd3"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7634),
                            Description = "GPT-3.5 Turbo 0613 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-3.5-turbo-0613",
                            PromptRate = 0.75m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("d13fe35b-d975-443c-8a70-0176ce8fdd36"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7651),
                            Description = "GPT-3.5 Turbo 1106 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-3.5-turbo-1106",
                            PromptRate = 0.25m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("75cd2bdd-4771-4a06-a440-b8cb0bf9ac4c"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7652),
                            Description = "GPT-3.5 Turbo 16k 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-3.5-turbo-16k",
                            PromptRate = 0.75m,
                            QuotaMax = "16K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("b1e879f6-c0e5-4c36-b8be-fbabb86b14eb"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7652),
                            Description = "GPT-3.5 Turbo 16k 0613 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-3.5-turbo-16k-0613",
                            PromptRate = 0.75m,
                            QuotaMax = "16K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("7b34f0ac-65bc-42b9-bd10-0c151c59d5ee"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7653),
                            Description = "GPT-3.5 Turbo Instruct 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-3.5-turbo-instruct",
                            PromptRate = 0.001m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("28f3ab06-6c12-4691-8c69-b09733010306"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7654),
                            Description = "GPT-4 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4",
                            PromptRate = 15m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("413489f4-ec1d-42be-b6ff-4108dd43754c"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7654),
                            Description = "GPT-4 0125 预览文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4-0125-preview",
                            PromptRate = 5m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("ba85c2ee-f1c9-4fe4-a7dc-8cbca1b271f2"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7655),
                            Description = "GPT-4 0314 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4-0314",
                            PromptRate = 15m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("52d8d182-d91d-478e-b8cd-97650071d54f"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7656),
                            Description = "GPT-4 0613 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4-0613",
                            PromptRate = 15m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("2c88843e-833b-4e34-9879-4a622f204db5"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7658),
                            Description = "GPT-4 1106 预览文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4-1106-preview",
                            PromptRate = 5m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("c36364e6-9b2b-4476-bcd1-98d7ee2de279"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7659),
                            Description = "GPT-4 1106 视觉预览模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4-1106-vision-preview",
                            PromptRate = 10m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u89C6\\u89C9\",\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("36e1ae6c-2d64-4850-872d-fe0c2c0128c8"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7660),
                            Description = "GPT-4 32k 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4-32k",
                            PromptRate = 30m,
                            QuotaMax = "32K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("8fa47d18-a994-4bbc-ba76-a071c462f661"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7661),
                            Description = "GPT-4 32k 0314 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4-32k-0314",
                            PromptRate = 30m,
                            QuotaMax = "32K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("849fe8df-1344-4e1f-b276-484e8ee23466"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7661),
                            Description = "GPT-4 32k 0613 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4-32k-0613",
                            PromptRate = 30m,
                            QuotaMax = "32K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("76745063-1422-4107-b5d9-27acb8cdc173"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7662),
                            Description = "GPT-4 全部文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4-all",
                            PromptRate = 30m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\",\"\\u89C6\\u89C9\",\"\\u8054\\u7F51\"]"
                        },
                        new
                        {
                            Id = new Guid("10222f21-57b4-4f16-9f8f-8cd707cc63f4"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7663),
                            Description = "GPT-4 Turbo 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4-turbo",
                            PromptRate = 5m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("b61711ff-19ec-4ad0-b2c8-925a94d13e05"),
                            Available = true,
                            CompletionRate = 2m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7664),
                            Description = "Gemini 1.5 Pro 文本模型",
                            Enable = true,
                            Icon = "Google",
                            IsVersion2 = false,
                            Model = "gemini-1.5-pro",
                            PromptRate = 2m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("b252e18d-b400-4cc5-93e2-fb7a25202ec0"),
                            Available = true,
                            CompletionRate = 3m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7666),
                            Description = "Gemini Pro 文本模型",
                            Enable = true,
                            Icon = "Google",
                            IsVersion2 = false,
                            Model = "gemini-pro",
                            PromptRate = 2m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("056cd3ed-ba1c-4c2c-81f6-11f807dac4b0"),
                            Available = true,
                            CompletionRate = 3m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7666),
                            Description = "Gemini Pro 视觉模型",
                            Enable = true,
                            Icon = "Google",
                            IsVersion2 = false,
                            Model = "gemini-pro-vision",
                            PromptRate = 2m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\",\"\\u89C6\\u89C9\"]"
                        },
                        new
                        {
                            Id = new Guid("1aed309d-8653-415d-9ef3-f4bb59532ae5"),
                            Available = true,
                            CompletionRate = 3m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7667),
                            Description = "Gemini 1.5 Flash 文本模型",
                            Enable = true,
                            Icon = "Google",
                            IsVersion2 = false,
                            Model = "gemini-1.5-flash",
                            PromptRate = 0.2m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("40989633-c854-4abe-86ff-38c44e09dba7"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7668),
                            Description = "GPT-4 Turbo 2024-04-09 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4-turbo-2024-04-09",
                            PromptRate = 5m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("b8d0d3aa-df8f-4089-8ad4-8d753e1fd882"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7669),
                            Description = "GPT-4 Turbo 预览文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4-turbo-preview",
                            PromptRate = 5m,
                            QuotaMax = "8K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\",\"\\u89C6\\u89C9\"]"
                        },
                        new
                        {
                            Id = new Guid("27273083-1c87-449b-93f6-3130a3f7e1d9"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7669),
                            Description = "GPT-4 视觉预览模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4-vision-preview",
                            PromptRate = 10m,
                            QuotaMax = "8K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\",\"\\u89C6\\u89C9\"]"
                        },
                        new
                        {
                            Id = new Guid("86b0bcfc-4220-4942-a5c9-0396347c051a"),
                            Available = true,
                            CompletionRate = 3m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7670),
                            Description = "GPT-4o 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4o",
                            PromptRate = 3m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\",\"\\u89C6\\u89C9\",\"\\u97F3\\u9891\"]"
                        },
                        new
                        {
                            Id = new Guid("c73549ec-a493-4560-be90-6794bfaf6ccd"),
                            Available = true,
                            CompletionRate = 4m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7671),
                            Description = "ChatGPT 4o 最新文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "chatgpt-4o-latest",
                            PromptRate = 3m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\",\"\\u89C6\\u89C9\",\"\\u97F3\\u9891\"]"
                        },
                        new
                        {
                            Id = new Guid("54accf82-ce76-4b22-88ae-1bbf51ea8158"),
                            Available = true,
                            CompletionRate = 4m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7673),
                            Description = "GPT-4o Mini 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4o-mini",
                            PromptRate = 0.07m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\",\"\\u89C6\\u89C9\",\"\\u97F3\\u9891\"]"
                        },
                        new
                        {
                            Id = new Guid("6bb25f74-2b9c-463c-a0a4-2765f547f49c"),
                            Available = true,
                            CompletionRate = 4m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7673),
                            Description = "GPT-4o Mini 2024-07-18 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4o-mini-2024-07-18",
                            PromptRate = 0.07m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\",\"\\u89C6\\u89C9\",\"\\u97F3\\u9891\"]"
                        },
                        new
                        {
                            Id = new Guid("01ff3f29-c00c-45bc-b377-c573100728b3"),
                            Available = true,
                            CompletionRate = 4m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7674),
                            Description = "GPT-4o 2024-05-13 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4o-2024-05-13",
                            PromptRate = 3m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\",\"\\u89C6\\u89C9\",\"\\u97F3\\u9891\"]"
                        },
                        new
                        {
                            Id = new Guid("a87ab7db-ad64-406c-a8aa-f38c2dd7e06d"),
                            Available = true,
                            CompletionRate = 4m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7675),
                            Description = "GPT-4o 2024-08-06 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "gpt-4o-2024-08-06",
                            PromptRate = 1.25m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\",\"\\u89C6\\u89C9\",\"\\u97F3\\u9891\"]"
                        },
                        new
                        {
                            Id = new Guid("4f7c05b0-ee5e-48da-954d-9937dea54ad4"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7676),
                            Description = "Moonshot v1 128k 文本模型",
                            Enable = true,
                            Icon = "Moonshot",
                            IsVersion2 = false,
                            Model = "moonshot-v1-128k",
                            PromptRate = 5.06m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("5d8c5449-e6f7-4b16-b7ae-e56d525a8356"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7676),
                            Description = "Moonshot v1 32k 文本模型",
                            Enable = true,
                            Icon = "Moonshot",
                            IsVersion2 = false,
                            Model = "moonshot-v1-32k",
                            PromptRate = 2m,
                            QuotaMax = "32K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("45247d28-25e2-4d88-8558-f6db624f81d1"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7677),
                            Description = "Moonshot v1 8k 文本模型",
                            Enable = true,
                            Icon = "Moonshot",
                            IsVersion2 = false,
                            Model = "moonshot-v1-8k",
                            PromptRate = 1m,
                            QuotaMax = "8K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("138bc817-0215-413f-96d5-7a75192a3a7d"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7678),
                            Description = "Text Babbage 001 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "text-babbage-001",
                            PromptRate = 0.25m,
                            QuotaMax = "8K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("054ba477-0ecf-4112-bf95-c5b65ad9c92f"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7680),
                            Description = "Text Curie 001 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "text-curie-001",
                            PromptRate = 1m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("08397cab-7c87-4ab1-94f0-adab822ee3de"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7680),
                            Description = "Text Davinci 002 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "text-davinci-002",
                            PromptRate = 10m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("f8fd18cc-754c-4e2b-9a75-851f312c24b4"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7681),
                            Description = "Text Davinci 003 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "text-davinci-003",
                            PromptRate = 10m,
                            QuotaMax = "8K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("907bcf12-0996-442d-b81d-c53b364b8179"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7682),
                            Description = "Text Davinci Edit 001 文本模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "text-davinci-edit-001",
                            PromptRate = 10m,
                            QuotaMax = "8K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("9d3b34f9-74ea-4a2a-892e-19995f5ec2d3"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7682),
                            Description = "Text Embedding 3 Large 嵌入模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "text-embedding-3-large",
                            PromptRate = 0.13m,
                            QuotaMax = "8K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("7d4ac93b-200d-4f87-a85c-d6212c19baf1"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7683),
                            Description = "Text Embedding 3 Small 嵌入模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "text-embedding-3-small",
                            PromptRate = 0.1m,
                            QuotaMax = "8K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("c81b1a2e-d13d-4a58-87da-a5e8360cbc60"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7684),
                            Description = "Text Embedding Ada 002 嵌入模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "text-embedding-ada-002",
                            PromptRate = 0.1m,
                            QuotaMax = "8K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("15d71b93-d34c-43a9-9565-bb8d0da5ddf2"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7685),
                            Description = "TTS 1 语音合成模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "tts-1",
                            PromptRate = 7.5m,
                            QuotaType = 1,
                            Tags = "[\"\\u97F3\\u9891\"]"
                        },
                        new
                        {
                            Id = new Guid("fe9cbb87-250f-4157-878b-6b1687cdd345"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7687),
                            Description = "TTS 1 1106 语音合成模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "tts-1-1106",
                            PromptRate = 7.5m,
                            QuotaType = 1,
                            Tags = "[\"\\u97F3\\u9891\"]"
                        },
                        new
                        {
                            Id = new Guid("0296b929-ce40-4df0-a458-2964e0797a59"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7687),
                            Description = "TTS 1 HD 语音合成模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "tts-1-hd",
                            PromptRate = 15m,
                            QuotaType = 2,
                            Tags = "[\"\\u97F3\\u9891\"]"
                        },
                        new
                        {
                            Id = new Guid("07a1527a-9c98-4433-80d0-df44b75d84db"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7688),
                            Description = "TTS 1 HD 1106 语音合成模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "tts-1-hd-1106",
                            PromptRate = 15m,
                            QuotaType = 2,
                            Tags = "[\"\\u97F3\\u9891\"]"
                        },
                        new
                        {
                            Id = new Guid("5d5c417a-ff35-4e09-b420-69071a3d3310"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7689),
                            Description = "Whisper 1 语音识别模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "whisper-1",
                            PromptRate = 15m,
                            QuotaType = 2,
                            Tags = "[\"\\u97F3\\u9891\"]"
                        },
                        new
                        {
                            Id = new Guid("e615c373-cb1a-4cc7-9e1c-b9ce5aa3eb70"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7689),
                            Description = "Hunyuan Lite 文本模型",
                            Enable = true,
                            Icon = "Hunyuan",
                            IsVersion2 = false,
                            Model = "hunyuan-lite",
                            PromptRate = 0.75m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("ddd9ba02-73ad-4d46-8deb-bdadc736efc6"),
                            Available = true,
                            CompletionRate = 2m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7690),
                            Description = "通用文本模型",
                            Enable = true,
                            Icon = "Spark",
                            IsVersion2 = false,
                            Model = "general",
                            PromptRate = 2m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("4451bcc0-09d9-46db-b03e-233bd9cbf934"),
                            Available = true,
                            CompletionRate = 2m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7691),
                            Description = "通用文本模型 v3",
                            Enable = true,
                            Icon = "Spark",
                            IsVersion2 = false,
                            Model = "generalv3",
                            PromptRate = 2m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("9c0fbf7b-ff78-47ae-a3cf-be4902a6a9f1"),
                            Available = true,
                            CompletionRate = 2m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7691),
                            Description = "通用文本模型 v3.5",
                            Enable = true,
                            Icon = "Spark",
                            IsVersion2 = false,
                            Model = "generalv3.5",
                            PromptRate = 2m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("5a0d1043-ea45-499e-bdee-59641b03033b"),
                            Available = true,
                            CompletionRate = 3m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7693),
                            Description = "4.0 超级文本模型",
                            Enable = true,
                            Icon = "Spark",
                            IsVersion2 = false,
                            Model = "4.0Ultra",
                            PromptRate = 5m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("d5a7955b-c07f-4d5b-acb5-b2cfbacfac34"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7694),
                            Description = "ChatGLM Lite 文本模型",
                            Enable = true,
                            Icon = "ChatGLM",
                            IsVersion2 = false,
                            Model = "chatglm_lite",
                            PromptRate = 0.1429m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("7b05e674-304c-41c1-8899-18f4784a0cd1"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7695),
                            Description = "ChatGLM Pro 文本模型",
                            Enable = true,
                            Icon = "ChatGLM",
                            IsVersion2 = false,
                            Model = "chatglm_pro",
                            PromptRate = 0.7143m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("998ef7a5-2292-4c66-8e6f-77ee1a08c248"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7696),
                            Description = "ChatGLM 标准文本模型",
                            Enable = true,
                            Icon = "ChatGLM",
                            IsVersion2 = false,
                            Model = "chatglm_std",
                            PromptRate = 0.3572m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("a762c0d7-2a43-4305-8cbe-ed87822398ac"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7696),
                            Description = "ChatGLM Turbo 文本模型",
                            Enable = true,
                            Icon = "ChatGLM",
                            IsVersion2 = false,
                            Model = "chatglm_turbo",
                            PromptRate = 0.3572m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("9462a339-2ecd-4394-a4c7-aef816fd39f6"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7697),
                            Description = "Claude 2 文本模型",
                            Enable = true,
                            Icon = "Claude",
                            IsVersion2 = false,
                            Model = "claude-2",
                            PromptRate = 7.5m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("fafb1e1c-eb43-4142-8a1c-8ee8ccaab503"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7698),
                            Description = "Claude 2.0 文本模型",
                            Enable = true,
                            Icon = "Claude",
                            IsVersion2 = false,
                            Model = "claude-2.0",
                            PromptRate = 7.5m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("0e739669-2332-4eff-8fb4-c4eff028d0d2"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7698),
                            Description = "Claude 2.1 文本模型",
                            Enable = true,
                            Icon = "Claude",
                            IsVersion2 = false,
                            Model = "claude-2.1",
                            PromptRate = 7.5m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("ff88870b-a15e-455c-be79-65d47a358da3"),
                            Available = true,
                            CompletionRate = 5m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7700),
                            Description = "Claude 3 Haiku 文本模型",
                            Enable = true,
                            Icon = "Claude",
                            IsVersion2 = false,
                            Model = "claude-3-haiku",
                            PromptRate = 0.5m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("b7048614-36df-455d-8617-2d209e4c34ab"),
                            Available = true,
                            CompletionRate = 5m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7701),
                            Description = "Claude 3 Haiku 20240307 文本模型",
                            Enable = true,
                            Icon = "Claude",
                            IsVersion2 = false,
                            Model = "claude-3-haiku-20240307",
                            PromptRate = 0.5m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("726fac2a-d0df-4217-94bd-99944bddf0b0"),
                            Available = true,
                            CompletionRate = 5m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7702),
                            Description = "Claude 3.5 Sonnet 20240620 文本模型",
                            Enable = true,
                            Icon = "Claude",
                            IsVersion2 = false,
                            Model = "claude-3-5-sonnet-20240620",
                            PromptRate = 3m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("04d0bb5b-e3d1-4623-b248-f6e451f5687a"),
                            Available = true,
                            CompletionRate = 5m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7702),
                            Description = "Claude 3 Sonnet 20240229 文本模型",
                            Enable = true,
                            Icon = "Claude",
                            IsVersion2 = false,
                            Model = "claude-3-sonnet-20240229",
                            PromptRate = 3m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("8eb31887-8365-46c4-882e-9a22280650fd"),
                            Available = true,
                            CompletionRate = 5m,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7703),
                            Description = "Claude 3 Opus 20240229 文本模型",
                            Enable = true,
                            Icon = "Claude",
                            IsVersion2 = false,
                            Model = "claude-3-opus-20240229",
                            PromptRate = 30m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("ac0625c8-bb9a-46ea-9de5-d0e010a04cf8"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7704),
                            Description = "Claude Instant 1 文本模型",
                            Enable = true,
                            Icon = "Claude",
                            IsVersion2 = false,
                            Model = "claude-instant-1",
                            PromptRate = 0.815m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("55d9c543-d795-4d2f-af5f-a316acbf7a68"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7704),
                            Description = "Claude Instant 1.2 文本模型",
                            Enable = true,
                            Icon = "Claude",
                            IsVersion2 = false,
                            Model = "claude-instant-1.2",
                            PromptRate = 0.4m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("c985873d-6b29-403e-be38-2faef58aa10f"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7705),
                            Description = "DALL-E 2 图像生成模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "dall-e-2",
                            PromptRate = 8m,
                            QuotaType = 2,
                            Tags = "[\"\\u56FE\\u7247\"]"
                        },
                        new
                        {
                            Id = new Guid("9a5e224c-4cfe-4058-b09e-6252cc1bdf74"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7707),
                            Description = "DALL-E 3 图像生成模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "dall-e-3",
                            PromptRate = 20m,
                            QuotaType = 2,
                            Tags = "[\"\\u56FE\\u7247\"]"
                        },
                        new
                        {
                            Id = new Guid("52c559d9-ccfc-4a76-af0f-a03dc8e3a954"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7708),
                            Description = "Embedding 2 嵌入模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "embedding-2",
                            PromptRate = 0.0355m,
                            QuotaMax = "",
                            QuotaType = 1,
                            Tags = "[\"\\u5D4C\\u5165\\u6A21\\u578B\"]"
                        },
                        new
                        {
                            Id = new Guid("009d872e-7ded-48ed-acd7-6418f987fd4f"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7709),
                            Description = "Embedding BERT 512 v1 嵌入模型",
                            Enable = true,
                            Icon = "OpenAI",
                            IsVersion2 = false,
                            Model = "embedding-bert-512-v1",
                            PromptRate = 0.1m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u5D4C\\u5165\\u6A21\\u578B\"]"
                        },
                        new
                        {
                            Id = new Guid("f3f191e1-d1a9-4439-b9d0-b6ddbab52b95"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7709),
                            Description = "Embedding S1 v1 嵌入模型",
                            Enable = true,
                            IsVersion2 = false,
                            Model = "embedding_s1_v1",
                            PromptRate = 0.1m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u5D4C\\u5165\\u6A21\\u578B\"]"
                        },
                        new
                        {
                            Id = new Guid("a646afce-8641-4ae1-902b-cd59b73fed01"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7710),
                            Description = "GLM 3 Turbo 文本模型",
                            Enable = true,
                            Icon = "ChatGLM",
                            IsVersion2 = false,
                            Model = "glm-3-turbo",
                            PromptRate = 0.355m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("47892d02-9985-4691-b99b-7d88b9bba2ed"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7711),
                            Description = "GLM 4 文本模型",
                            Enable = true,
                            Icon = "ChatGLM",
                            IsVersion2 = false,
                            Model = "glm-4",
                            PromptRate = 15m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("24d33436-0441-49fd-b526-a3a16c64742d"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7711),
                            Description = "GLM 4 全部文本模型",
                            Enable = true,
                            Icon = "ChatGLM",
                            IsVersion2 = false,
                            Model = "glm-4-all",
                            PromptRate = 30m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        },
                        new
                        {
                            Id = new Guid("89aea156-24ee-49d5-bb31-a6b2fe1b3a9c"),
                            Available = true,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 354, DateTimeKind.Local).AddTicks(7712),
                            Description = "GLM 4v 文本模型",
                            Enable = true,
                            Icon = "ChatGLM",
                            IsVersion2 = false,
                            Model = "glm-4v",
                            PromptRate = 15m,
                            QuotaMax = "128K",
                            QuotaType = 1,
                            Tags = "[\"\\u6587\\u672C\"]"
                        });
                });

            modelBuilder.Entity("Thor.Service.Domain.Product", b =>
                {
                    b.Property<string>("Id")
                        .HasColumnType("text");

                    b.Property<DateTime>("CreatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("Creator")
                        .HasColumnType("text");

                    b.Property<string>("Description")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("Modifier")
                        .HasColumnType("text");

                    b.Property<string>("Name")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<decimal>("Price")
                        .HasColumnType("numeric");

                    b.Property<long>("RemainQuota")
                        .HasColumnType("bigint");

                    b.Property<int>("Stock")
                        .HasColumnType("integer");

                    b.Property<DateTime?>("UpdatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("Id");

                    b.ToTable("Products");
                });

            modelBuilder.Entity("Thor.Service.Domain.ProductPurchaseRecord", b =>
                {
                    b.Property<string>("Id")
                        .HasColumnType("text");

                    b.Property<DateTime>("CreatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("Creator")
                        .HasColumnType("text");

                    b.Property<string>("Description")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("Modifier")
                        .HasColumnType("text");

                    b.Property<string>("ProductId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<DateTime>("PurchaseTime")
                        .HasColumnType("timestamp with time zone");

                    b.Property<int>("Quantity")
                        .HasColumnType("integer");

                    b.Property<long>("RemainQuota")
                        .HasColumnType("bigint");

                    b.Property<int>("Status")
                        .HasColumnType("integer");

                    b.Property<DateTime?>("UpdatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("UserId")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("Id");

                    b.HasIndex("Creator");

                    b.HasIndex("UserId");

                    b.ToTable("ProductPurchaseRecords");
                });

            modelBuilder.Entity("Thor.Service.Domain.RateLimitModel", b =>
                {
                    b.Property<string>("Id")
                        .HasColumnType("text");

                    b.Property<string>("BlackList")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<DateTime>("CreatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("Creator")
                        .HasColumnType("text");

                    b.Property<string>("Description")
                        .HasColumnType("text");

                    b.Property<bool>("Enable")
                        .HasColumnType("boolean");

                    b.Property<int>("Limit")
                        .HasColumnType("integer");

                    b.Property<string>("Model")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("Modifier")
                        .HasColumnType("text");

                    b.Property<string>("Name")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("Strategy")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<DateTime?>("UpdatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<int>("Value")
                        .HasColumnType("integer");

                    b.Property<string>("WhiteList")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("Id");

                    b.HasIndex("Creator");

                    b.HasIndex("Model");

                    b.ToTable("RateLimitModels");
                });

            modelBuilder.Entity("Thor.Service.Domain.RedeemCode", b =>
                {
                    b.Property<string>("Id")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("text");

                    b.Property<string>("Code")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<DateTime>("CreatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("Creator")
                        .HasColumnType("text");

                    b.Property<bool>("Disabled")
                        .HasColumnType("boolean");

                    b.Property<string>("Modifier")
                        .HasColumnType("text");

                    b.Property<string>("Name")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<long>("Quota")
                        .HasColumnType("bigint");

                    b.Property<DateTime?>("RedeemedTime")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("RedeemedUserId")
                        .HasColumnType("text");

                    b.Property<string>("RedeemedUserName")
                        .HasColumnType("text");

                    b.Property<int>("State")
                        .HasColumnType("integer");

                    b.Property<DateTime?>("UpdatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.HasKey("Id");

                    b.HasIndex("Code");

                    b.ToTable("RedeemCodes");
                });

            modelBuilder.Entity("Thor.Service.Domain.Setting", b =>
                {
                    b.Property<string>("Key")
                        .HasColumnType("text");

                    b.Property<string>("Description")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<bool>("Private")
                        .HasColumnType("boolean");

                    b.Property<string>("Value")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("Key");

                    b.ToTable("Settings");

                    b.HasData(
                        new
                        {
                            Key = "Setting:GeneralSetting:RechargeAddress",
                            Description = "充值地址",
                            Private = false,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:ChatLink",
                            Description = "对话链接",
                            Private = false,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:VidolLink",
                            Description = "Vidol 链接",
                            Private = false,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:NewUserQuota",
                            Description = "新用户初始额度",
                            Private = true,
                            Value = "100000"
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:RequestQuota",
                            Description = "请求预扣额度",
                            Private = true,
                            Value = "2000"
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:InviteQuota",
                            Description = "邀请奖励额度",
                            Private = true,
                            Value = "100000"
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:EnableClearLog",
                            Description = "启用定时清理日志",
                            Private = true,
                            Value = "true"
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:IntervalDays",
                            Description = "间隔天数",
                            Private = true,
                            Value = "90"
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:EnableAutoCheckChannel",
                            Description = "启用自动检测渠道策略",
                            Private = true,
                            Value = "false"
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:CheckInterval",
                            Description = "检测间隔 (分钟)",
                            Private = true,
                            Value = "60"
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:AutoDisableChannel",
                            Description = "自动禁用异常渠道",
                            Private = true,
                            Value = "false"
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:AlipayNotifyUrl",
                            Description = "支付宝支付回调地址",
                            Private = false,
                            Value = "https://您的服务器地址/"
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:AlipayAppId",
                            Description = "支付宝应用APPID",
                            Private = true,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:AlipayPrivateKey",
                            Description = "支付宝应用私钥",
                            Private = true,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:AlipayPublicKey",
                            Description = "支付宝公钥",
                            Private = true,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:AlipayAppCertPath",
                            Description = "支付宝AppCertPath",
                            Private = true,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:AlipayRootCertPath",
                            Description = "支付宝AlipayRootCertPath",
                            Private = true,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:GeneralSetting:AlipayPublicCertPath",
                            Description = "支付宝公钥证书路径",
                            Private = true,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:SystemSetting:ServerAddress",
                            Description = "服务器地址",
                            Private = false,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:SystemSetting:EnableRegister",
                            Description = "启用账号注册",
                            Private = false,
                            Value = "true"
                        },
                        new
                        {
                            Key = "Setting:SystemSetting:EnableGithubLogin",
                            Description = "允许Github登录",
                            Private = false,
                            Value = "true"
                        },
                        new
                        {
                            Key = "Setting:SystemSetting:GithubClientId",
                            Description = "Github Client Id",
                            Private = false,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:SystemSetting:GithubClientSecret",
                            Description = "Github Client Secret",
                            Private = true,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:SystemSetting:EnableGiteeLogin",
                            Description = "允许Gitee登录",
                            Private = false,
                            Value = "true"
                        },
                        new
                        {
                            Key = "Setting:SystemSetting:GiteeClientId",
                            Description = "Gitee Client Id",
                            Private = false,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:SystemSetting:GiteeClientSecret",
                            Description = "Gitee Client Secret",
                            Private = true,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:SystemSetting:GiteeRedirectUri",
                            Description = "Gitee redirect_uri",
                            Private = false,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:SystemSetting:EmailAddress",
                            Description = "邮箱地址",
                            Private = true,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:SystemSetting:EmailPassword",
                            Description = "邮箱密码",
                            Private = true,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:SystemSetting:SmtpAddress",
                            Description = "SMTP地址",
                            Private = true,
                            Value = ""
                        },
                        new
                        {
                            Key = "Setting:SystemSetting:EnableEmailRegister",
                            Description = "启用邮箱验证注册",
                            Private = false,
                            Value = "false"
                        },
                        new
                        {
                            Key = "Setting:OtherSetting:WebTitle",
                            Description = "网站标题",
                            Private = false,
                            Value = "AIDtoNet API"
                        },
                        new
                        {
                            Key = "Setting:OtherSetting:WebLogo",
                            Description = "网站Logo地址",
                            Private = false,
                            Value = "/logo.png"
                        },
                        new
                        {
                            Key = "Setting:OtherSetting:IndexContent",
                            Description = "首页内容",
                            Private = false,
                            Value = "AI DotNet API 提供更强的兼容，将更多的AI平台接入到AI DotNet API中，让AI集成更加简单。"
                        });
                });

            modelBuilder.Entity("Thor.Service.Domain.Token", b =>
                {
                    b.Property<string>("Id")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("text");

                    b.Property<DateTime?>("AccessedTime")
                        .HasColumnType("timestamp with time zone");

                    b.Property<DateTime>("CreatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("Creator")
                        .HasColumnType("text");

                    b.Property<DateTime?>("DeletedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<bool>("Disabled")
                        .HasColumnType("boolean");

                    b.Property<DateTime?>("ExpiredTime")
                        .HasColumnType("timestamp with time zone");

                    b.Property<bool>("IsDelete")
                        .HasColumnType("boolean");

                    b.Property<string>("Key")
                        .IsRequired()
                        .HasMaxLength(42)
                        .HasColumnType("character varying(42)");

                    b.Property<string>("LimitModels")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("Modifier")
                        .HasColumnType("text");

                    b.Property<string>("Name")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<long>("RemainQuota")
                        .HasColumnType("bigint");

                    b.Property<bool>("UnlimitedExpired")
                        .HasColumnType("boolean");

                    b.Property<bool>("UnlimitedQuota")
                        .HasColumnType("boolean");

                    b.Property<DateTime?>("UpdatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<long>("UsedQuota")
                        .HasColumnType("bigint");

                    b.Property<string>("WhiteIpList")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("Id");

                    b.HasIndex("Creator");

                    b.HasIndex("Key");

                    b.ToTable("Tokens");

                    b.HasData(
                        new
                        {
                            Id = "324ed167-a7b8-4fe1-8dca-f608f6ff93ec",
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 352, DateTimeKind.Local).AddTicks(3391),
                            Creator = "a0581ea1-af3a-4d78-8501-b832f6017b98",
                            Disabled = false,
                            IsDelete = false,
                            Key = "sk-aAtCeKnf0XMvVCb8ATfSyafvMheD25cs6bwYdH",
                            LimitModels = "[]",
                            Name = "默认Token",
                            RemainQuota = 0L,
                            UnlimitedExpired = true,
                            UnlimitedQuota = true,
                            UsedQuota = 0L,
                            WhiteIpList = "[]"
                        });
                });

            modelBuilder.Entity("Thor.Service.Domain.User", b =>
                {
                    b.Property<string>("Id")
                        .HasColumnType("text");

                    b.Property<string>("Avatar")
                        .HasColumnType("text");

                    b.Property<long>("ConsumeToken")
                        .HasColumnType("bigint");

                    b.Property<DateTime>("CreatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("Creator")
                        .HasColumnType("text");

                    b.Property<DateTime?>("DeletedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("Email")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<bool>("IsDelete")
                        .HasColumnType("boolean");

                    b.Property<bool>("IsDisabled")
                        .HasColumnType("boolean");

                    b.Property<string>("Modifier")
                        .HasColumnType("text");

                    b.Property<string>("Password")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<string>("PasswordHas")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<long>("RequestCount")
                        .HasColumnType("bigint");

                    b.Property<long>("ResidualCredit")
                        .HasColumnType("bigint");

                    b.Property<string>("Role")
                        .IsRequired()
                        .HasColumnType("text");

                    b.Property<DateTime?>("UpdatedAt")
                        .HasColumnType("timestamp with time zone");

                    b.Property<string>("UserName")
                        .IsRequired()
                        .HasColumnType("text");

                    b.HasKey("Id");

                    b.ToTable("Users");

                    b.HasData(
                        new
                        {
                            Id = "a0581ea1-af3a-4d78-8501-b832f6017b98",
                            ConsumeToken = 0L,
                            CreatedAt = new DateTime(2024, 11, 4, 1, 6, 57, 352, DateTimeKind.Local).AddTicks(2940),
                            Email = "239573049@qq.com",
                            IsDelete = false,
                            IsDisabled = false,
                            Password = "659a41980932418aeb4b1245ba6a792a",
                            PasswordHas = "0519a14e45b343a2ae8b38fcf9c18a06",
                            RequestCount = 0L,
                            ResidualCredit = 1000000000L,
                            Role = "admin",
                            UserName = "admin"
                        });
                });
#pragma warning restore 612, 618
        }
    }
}
