## Vuex とは何か

Vuex は Vue.js アプリケーションで状態を一元的に管理するためのアプリケーションアーキテクチャです。[Flux](https://facebook.github.io/flux/) や [Redux](https://github.com/rackt/redux) にインスパイアされていますが、それよりも単純化された概念を持ち、 Vue.js のリアクティブシステムの長所を生かすために、特別に設計された実装になっています。

## なぜこれを必要とするのですか？

あなたのアプリケーションが十分に単純であるなら、おそらく Vuex は必要ないでしょう。早まって Vuex を適用しないようにしてください。しかし、中〜大規模な SPA を構築することになったら、Vue コンポーネントの外側の構造をより良くする方法を考える適切なタイミングです。そこで Vuex の出番です。

Vue.js を単体で使用するとき、私達はコンポーネントの"内部"に状態を格納しようとする傾向があります。つまり、各コンポーネントは、アプリケーションの状態の一部を所有しており、結果として状態が様々な場所に散らばっています。しかし、時には一部の状態を、複数のコンポーネントの間で共有したいこともあるでしょう。このようなケースで、カスタムイベントシステムを利用して、あるコンポーネントがいくつかの状態を他のコンポーネントに"送信"する例がよく見られます。このパターンは、大規模なコンポーネントツリーでは、内部のイベントフローが瞬く間に複雑になり、正しく動作しない場合に原因を調査するのが困難になるという問題があります。

大規模アプリケーションで状態の共有をより良く対処するために、**コンポーネント内部の状態**と**アプリケーションレベルの状態**を区別する必要があります。アプリケーションレベルの状態は特定のコンポーネントに属していませんが、私達のコンポーネントはリアクティブな DOM 更新のためにまだそれを監視することができます。ひとつの場所で一元的に状態を管理することによって、複数のコンポーネントに影響を与える状態すべてがそこに属している必要があり、もはやイベントをあちこちに渡す必要はありません。加えて、全ての状態の変更の記録と検査がおこなわれることで、状態が変化する過程の理解を容易にし、さらにタイムトラベルデバッグのような興味深い機能も実装できます。

Vuex は状態を管理するロジックの分割について、他にも様々な場所で一定の制約を強いてきますが、それでも実際のコード構造に対して十分な柔軟性を持っています。
