<?php
namespace Phly\Conduit;

use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;

/**
 * Middleware.
 *
 * Middleware accepts a request and a response, and optionally a
 * callback `$out` (called if the middleware wants to allow further
 * middleware to process the incoming request, or to delegate output to another
 * process).
 *
 * Middleware that does not need or desire further processing should not
 * call `$out`, and should usually instead `return $response->end();`.
 *
 * For the purposes of Conduit, `$out` is typically one of either an instance
 * of `Next` or an instance of `FinalHandler`, and, as such, should follow
 * those calling semantics.
 */
interface MiddlewareInterface
{
    /**
     * Process an incoming request and/or response.
     *
     * Accepts a server-side request and a response instance, and does
     * something with them.
     *
     * If the response is not complete and/or further processing would not
     * interfere with the work done in the middleware, or if the middleware
     * wants to delegate to another process, it can use the `$out` callable
     * if present.
     *
     * If the middleware does not return a value, execution of the current
     * request is considered complete, and the response instance provided will
     * be considered the response to return.
     *
     * Alternately, the middleware may return a response instance.
     *
     * Often, middleware will `return $out();`, with the assumption that a
     * later middleware will return a response.
     *
     * @param Request $request
     * @param Response $response
     * @param null|callable $out
     * @return null|Response
     */
    public function __invoke(Request $request, Response $response, callable $out = null);
}
