using NUnit.Framework;
namespace Eto.Test.UnitTests.Drawing
{
	[TestFixture]
	public class PenTests : TestBase
	{
		/// <summary>
		/// Issue 1066
		/// </summary>
		[Test]
		public void PenShouldReturnBrush()
		{
			var pen = new Pen(Colors.Blue);
			Assert.IsNotNull(pen.Brush, "#1.1");
			Assert.IsInstanceOf<SolidBrush>(pen.Brush, "#1.2");
			Assert.AreEqual(Colors.Blue, ((SolidBrush)pen.Brush).Color, "#1.3");

			var brush = new SolidBrush(Colors.Blue);
			pen = new Pen(brush);
			Assert.IsNotNull(pen.Brush, "#2.1");
			Assert.AreSame(brush, pen.Brush, "#2.2");
		}
	}
}
