# ![Pinry](https://raw.github.com/pinry/pinry/master/docs/src/imgs/logo-dark.png)

![Node.js Build](https://img.shields.io/github/workflow/status/pinry/pinry/Node.js%20CI?label=node.js%20build)
![Python Build](https://img.shields.io/github/workflow/status/pinry/pinry/Python%20package?label=python%20build)
![Docker Pulls](https://img.shields.io/docker/pulls/getpinry/pinry)

The open-source core of Pinry, a tiling image board system for people
who want to save, tag, and share images, videos and webpages in an easy
to skim through format.

For more information ( screenshots and document ) visit [getpinry.com](https://getpinry.com).


## Features
- Image fetch and online preview
- Tagging system for Pins
- Browser Extensions
- Multi-user support
- Works well with docker
- Both public and private boards (add @2020.02.11)
- Search by tags / Search boards with name (add @2020.02.14)
- Full API support via DRF (add @2022.02.19)
- CLI support (Add image or url to Pinry via [command-line tool](https://github.com/pinry/pinry-cli-py)) (add @2022.02.20)
- i18n support (if you want to help to translate, please contact us in issues) (add @2020.04.23)

## Install with Docker
Now we have pre-built docker image on multiple architectures like **ARMv7/ARMv8/AMD64**.

See our full documentation at [https://docs.getpinry.com/install-with-docker/](https://docs.getpinry.com/install-with-docker/)

## Requirements

See our full documentation at [https://docs.getpinry.com/development/](https://docs.getpinry.com/development/)


## Development

See our full documentation at [https://docs.getpinry.com/development/](https://docs.getpinry.com/development/)

## Contributors

The core contributors for Pinry have been/currently are:

* Isaac Bythewood <http://isaacbythewood.com/>
* Krzysztof Klimonda <https://github.com/kklimonda>
* Lapo Luchini <https://github.com/lapo-luchini>
* Ji Qu <https://winkidney.com/>

For a full list of contributors check out the [GitHub Contributors Graph](https://github.com/pinry/pinry/graphs/contributors)
