# Generated by Django 4.0.5 on 2022-10-24 18:53

import django.db.models.deletion
import djmoney.models.fields
import simple_history.models
from django.conf import settings
from django.db import migrations, models

import metering_billing.utils.utils


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0049_alter_historicalorganization_company_name_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="HistoricalPlan",
            fields=[
                (
                    "id",
                    models.BigIntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("plan_name", models.CharField(max_length=100)),
                (
                    "plan_duration",
                    models.CharField(
                        choices=[("month", "Month"), ("year", "Year")], max_length=40
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("active", "Active"),
                            ("inactive", "Inactive"),
                            ("experimental", "Experimental"),
                        ],
                        default="active",
                        max_length=40,
                    ),
                ),
                (
                    "plan_id",
                    models.CharField(
                        db_index=True,
                        default=metering_billing.utils.utils.plan_uuid,
                        max_length=100,
                    ),
                ),
                (
                    "created_on",
                    models.DateTimeField(default=metering_billing.utils.utils.now_utc),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical plan",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalPlanVersion",
            fields=[
                (
                    "id",
                    models.BigIntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                (
                    "description",
                    models.CharField(blank=True, max_length=200, null=True),
                ),
                ("version", models.PositiveSmallIntegerField()),
                (
                    "flat_fee_billing_type",
                    models.CharField(
                        choices=[
                            ("in_arrears", "In Arrears"),
                            ("in_advance", "In Advance"),
                        ],
                        max_length=40,
                    ),
                ),
                (
                    "usage_billing_type",
                    models.CharField(
                        choices=[
                            ("in_arrears", "In Arrears"),
                            ("pay_as_you_go_quarterly", "Pay as you go (Quarterly)"),
                            ("pay_as_you_go_monthly", "Pay as you go (Monthly)"),
                            ("pay_as_you_go_weekly", "Pay as you go (Weekly)"),
                        ],
                        max_length=40,
                    ),
                ),
                (
                    "proration_granularity",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("monthly", "Monthly"),
                            ("weekly", "Weekly"),
                            ("daily", "Daily"),
                            ("hourly", "Hourly"),
                            ("none", "None"),
                        ],
                        max_length=40,
                        null=True,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("active", "Active"),
                            ("retiring", "Retiring"),
                            ("grandfathered", "Grandfathered"),
                            ("archived", "Archived"),
                            ("inactive", "Inactive"),
                        ],
                        max_length=40,
                    ),
                ),
                (
                    "flat_rate_currency",
                    djmoney.models.fields.CurrencyField(
                        choices=[
                            ("XUA", "ADB Unit of Account"),
                            ("AFN", "Afghan Afghani"),
                            ("AFA", "Afghan Afghani (1927–2002)"),
                            ("ALL", "Albanian Lek"),
                            ("ALK", "Albanian Lek (1946–1965)"),
                            ("DZD", "Algerian Dinar"),
                            ("ADP", "Andorran Peseta"),
                            ("AOA", "Angolan Kwanza"),
                            ("AOK", "Angolan Kwanza (1977–1991)"),
                            ("AON", "Angolan New Kwanza (1990–2000)"),
                            ("AOR", "Angolan Readjusted Kwanza (1995–1999)"),
                            ("ARA", "Argentine Austral"),
                            ("ARS", "Argentine Peso"),
                            ("ARM", "Argentine Peso (1881–1970)"),
                            ("ARP", "Argentine Peso (1983–1985)"),
                            ("ARL", "Argentine Peso Ley (1970–1983)"),
                            ("AMD", "Armenian Dram"),
                            ("AWG", "Aruban Florin"),
                            ("AUD", "Australian Dollar"),
                            ("ATS", "Austrian Schilling"),
                            ("AZN", "Azerbaijani Manat"),
                            ("AZM", "Azerbaijani Manat (1993–2006)"),
                            ("BSD", "Bahamian Dollar"),
                            ("BHD", "Bahraini Dinar"),
                            ("BDT", "Bangladeshi Taka"),
                            ("BBD", "Barbadian Dollar"),
                            ("BYN", "Belarusian Ruble"),
                            ("BYB", "Belarusian Ruble (1994–1999)"),
                            ("BYR", "Belarusian Ruble (2000–2016)"),
                            ("BEF", "Belgian Franc"),
                            ("BEC", "Belgian Franc (convertible)"),
                            ("BEL", "Belgian Franc (financial)"),
                            ("BZD", "Belize Dollar"),
                            ("BMD", "Bermudan Dollar"),
                            ("BTN", "Bhutanese Ngultrum"),
                            ("BOB", "Bolivian Boliviano"),
                            ("BOL", "Bolivian Boliviano (1863–1963)"),
                            ("BOV", "Bolivian Mvdol"),
                            ("BOP", "Bolivian Peso"),
                            ("BAM", "Bosnia-Herzegovina Convertible Mark"),
                            ("BAD", "Bosnia-Herzegovina Dinar (1992–1994)"),
                            ("BAN", "Bosnia-Herzegovina New Dinar (1994–1997)"),
                            ("BWP", "Botswanan Pula"),
                            ("BRC", "Brazilian Cruzado (1986–1989)"),
                            ("BRZ", "Brazilian Cruzeiro (1942–1967)"),
                            ("BRE", "Brazilian Cruzeiro (1990–1993)"),
                            ("BRR", "Brazilian Cruzeiro (1993–1994)"),
                            ("BRN", "Brazilian New Cruzado (1989–1990)"),
                            ("BRB", "Brazilian New Cruzeiro (1967–1986)"),
                            ("BRL", "Brazilian Real"),
                            ("GBP", "British Pound"),
                            ("BND", "Brunei Dollar"),
                            ("BGL", "Bulgarian Hard Lev"),
                            ("BGN", "Bulgarian Lev"),
                            ("BGO", "Bulgarian Lev (1879–1952)"),
                            ("BGM", "Bulgarian Socialist Lev"),
                            ("BUK", "Burmese Kyat"),
                            ("BIF", "Burundian Franc"),
                            ("XPF", "CFP Franc"),
                            ("KHR", "Cambodian Riel"),
                            ("CAD", "Canadian Dollar"),
                            ("CVE", "Cape Verdean Escudo"),
                            ("KYD", "Cayman Islands Dollar"),
                            ("XAF", "Central African CFA Franc"),
                            ("CLE", "Chilean Escudo"),
                            ("CLP", "Chilean Peso"),
                            ("CLF", "Chilean Unit of Account (UF)"),
                            ("CNX", "Chinese People’s Bank Dollar"),
                            ("CNY", "Chinese Yuan"),
                            ("CNH", "Chinese Yuan (offshore)"),
                            ("COP", "Colombian Peso"),
                            ("COU", "Colombian Real Value Unit"),
                            ("KMF", "Comorian Franc"),
                            ("CDF", "Congolese Franc"),
                            ("CRC", "Costa Rican Colón"),
                            ("HRD", "Croatian Dinar"),
                            ("HRK", "Croatian Kuna"),
                            ("CUC", "Cuban Convertible Peso"),
                            ("CUP", "Cuban Peso"),
                            ("CYP", "Cypriot Pound"),
                            ("CZK", "Czech Koruna"),
                            ("CSK", "Czechoslovak Hard Koruna"),
                            ("DKK", "Danish Krone"),
                            ("DJF", "Djiboutian Franc"),
                            ("DOP", "Dominican Peso"),
                            ("NLG", "Dutch Guilder"),
                            ("XCD", "East Caribbean Dollar"),
                            ("DDM", "East German Mark"),
                            ("ECS", "Ecuadorian Sucre"),
                            ("ECV", "Ecuadorian Unit of Constant Value"),
                            ("EGP", "Egyptian Pound"),
                            ("GQE", "Equatorial Guinean Ekwele"),
                            ("ERN", "Eritrean Nakfa"),
                            ("EEK", "Estonian Kroon"),
                            ("ETB", "Ethiopian Birr"),
                            ("EUR", "Euro"),
                            ("XBA", "European Composite Unit"),
                            ("XEU", "European Currency Unit"),
                            ("XBB", "European Monetary Unit"),
                            ("XBC", "European Unit of Account (XBC)"),
                            ("XBD", "European Unit of Account (XBD)"),
                            ("FKP", "Falkland Islands Pound"),
                            ("FJD", "Fijian Dollar"),
                            ("FIM", "Finnish Markka"),
                            ("FRF", "French Franc"),
                            ("XFO", "French Gold Franc"),
                            ("XFU", "French UIC-Franc"),
                            ("GMD", "Gambian Dalasi"),
                            ("GEK", "Georgian Kupon Larit"),
                            ("GEL", "Georgian Lari"),
                            ("DEM", "German Mark"),
                            ("GHS", "Ghanaian Cedi"),
                            ("GHC", "Ghanaian Cedi (1979–2007)"),
                            ("GIP", "Gibraltar Pound"),
                            ("XAU", "Gold"),
                            ("GRD", "Greek Drachma"),
                            ("GTQ", "Guatemalan Quetzal"),
                            ("GWP", "Guinea-Bissau Peso"),
                            ("GNF", "Guinean Franc"),
                            ("GNS", "Guinean Syli"),
                            ("GYD", "Guyanaese Dollar"),
                            ("HTG", "Haitian Gourde"),
                            ("HNL", "Honduran Lempira"),
                            ("HKD", "Hong Kong Dollar"),
                            ("HUF", "Hungarian Forint"),
                            ("IMP", "IMP"),
                            ("ISK", "Icelandic Króna"),
                            ("ISJ", "Icelandic Króna (1918–1981)"),
                            ("INR", "Indian Rupee"),
                            ("IDR", "Indonesian Rupiah"),
                            ("IRR", "Iranian Rial"),
                            ("IQD", "Iraqi Dinar"),
                            ("IEP", "Irish Pound"),
                            ("ILS", "Israeli New Shekel"),
                            ("ILP", "Israeli Pound"),
                            ("ILR", "Israeli Shekel (1980–1985)"),
                            ("ITL", "Italian Lira"),
                            ("JMD", "Jamaican Dollar"),
                            ("JPY", "Japanese Yen"),
                            ("JOD", "Jordanian Dinar"),
                            ("KZT", "Kazakhstani Tenge"),
                            ("KES", "Kenyan Shilling"),
                            ("KWD", "Kuwaiti Dinar"),
                            ("KGS", "Kyrgystani Som"),
                            ("LAK", "Laotian Kip"),
                            ("LVL", "Latvian Lats"),
                            ("LVR", "Latvian Ruble"),
                            ("LBP", "Lebanese Pound"),
                            ("LSL", "Lesotho Loti"),
                            ("LRD", "Liberian Dollar"),
                            ("LYD", "Libyan Dinar"),
                            ("LTL", "Lithuanian Litas"),
                            ("LTT", "Lithuanian Talonas"),
                            ("LUL", "Luxembourg Financial Franc"),
                            ("LUC", "Luxembourgian Convertible Franc"),
                            ("LUF", "Luxembourgian Franc"),
                            ("MOP", "Macanese Pataca"),
                            ("MKD", "Macedonian Denar"),
                            ("MKN", "Macedonian Denar (1992–1993)"),
                            ("MGA", "Malagasy Ariary"),
                            ("MGF", "Malagasy Franc"),
                            ("MWK", "Malawian Kwacha"),
                            ("MYR", "Malaysian Ringgit"),
                            ("MVR", "Maldivian Rufiyaa"),
                            ("MVP", "Maldivian Rupee (1947–1981)"),
                            ("MLF", "Malian Franc"),
                            ("MTL", "Maltese Lira"),
                            ("MTP", "Maltese Pound"),
                            ("MRU", "Mauritanian Ouguiya"),
                            ("MRO", "Mauritanian Ouguiya (1973–2017)"),
                            ("MUR", "Mauritian Rupee"),
                            ("MXV", "Mexican Investment Unit"),
                            ("MXN", "Mexican Peso"),
                            ("MXP", "Mexican Silver Peso (1861–1992)"),
                            ("MDC", "Moldovan Cupon"),
                            ("MDL", "Moldovan Leu"),
                            ("MCF", "Monegasque Franc"),
                            ("MNT", "Mongolian Tugrik"),
                            ("MAD", "Moroccan Dirham"),
                            ("MAF", "Moroccan Franc"),
                            ("MZE", "Mozambican Escudo"),
                            ("MZN", "Mozambican Metical"),
                            ("MZM", "Mozambican Metical (1980–2006)"),
                            ("MMK", "Myanmar Kyat"),
                            ("NAD", "Namibian Dollar"),
                            ("NPR", "Nepalese Rupee"),
                            ("ANG", "Netherlands Antillean Guilder"),
                            ("TWD", "New Taiwan Dollar"),
                            ("NZD", "New Zealand Dollar"),
                            ("NIO", "Nicaraguan Córdoba"),
                            ("NIC", "Nicaraguan Córdoba (1988–1991)"),
                            ("NGN", "Nigerian Naira"),
                            ("KPW", "North Korean Won"),
                            ("NOK", "Norwegian Krone"),
                            ("OMR", "Omani Rial"),
                            ("PKR", "Pakistani Rupee"),
                            ("XPD", "Palladium"),
                            ("PAB", "Panamanian Balboa"),
                            ("PGK", "Papua New Guinean Kina"),
                            ("PYG", "Paraguayan Guarani"),
                            ("PEI", "Peruvian Inti"),
                            ("PEN", "Peruvian Sol"),
                            ("PES", "Peruvian Sol (1863–1965)"),
                            ("PHP", "Philippine Peso"),
                            ("XPT", "Platinum"),
                            ("PLN", "Polish Zloty"),
                            ("PLZ", "Polish Zloty (1950–1995)"),
                            ("PTE", "Portuguese Escudo"),
                            ("GWE", "Portuguese Guinea Escudo"),
                            ("QAR", "Qatari Rial"),
                            ("XRE", "RINET Funds"),
                            ("RHD", "Rhodesian Dollar"),
                            ("RON", "Romanian Leu"),
                            ("ROL", "Romanian Leu (1952–2006)"),
                            ("RUB", "Russian Ruble"),
                            ("RUR", "Russian Ruble (1991–1998)"),
                            ("RWF", "Rwandan Franc"),
                            ("SVC", "Salvadoran Colón"),
                            ("WST", "Samoan Tala"),
                            ("SAR", "Saudi Riyal"),
                            ("RSD", "Serbian Dinar"),
                            ("CSD", "Serbian Dinar (2002–2006)"),
                            ("SCR", "Seychellois Rupee"),
                            ("SLL", "Sierra Leonean Leone"),
                            ("XAG", "Silver"),
                            ("SGD", "Singapore Dollar"),
                            ("SKK", "Slovak Koruna"),
                            ("SIT", "Slovenian Tolar"),
                            ("SBD", "Solomon Islands Dollar"),
                            ("SOS", "Somali Shilling"),
                            ("ZAR", "South African Rand"),
                            ("ZAL", "South African Rand (financial)"),
                            ("KRH", "South Korean Hwan (1953–1962)"),
                            ("KRW", "South Korean Won"),
                            ("KRO", "South Korean Won (1945–1953)"),
                            ("SSP", "South Sudanese Pound"),
                            ("SUR", "Soviet Rouble"),
                            ("ESP", "Spanish Peseta"),
                            ("ESA", "Spanish Peseta (A account)"),
                            ("ESB", "Spanish Peseta (convertible account)"),
                            ("XDR", "Special Drawing Rights"),
                            ("LKR", "Sri Lankan Rupee"),
                            ("SHP", "St. Helena Pound"),
                            ("XSU", "Sucre"),
                            ("SDD", "Sudanese Dinar (1992–2007)"),
                            ("SDG", "Sudanese Pound"),
                            ("SDP", "Sudanese Pound (1957–1998)"),
                            ("SRD", "Surinamese Dollar"),
                            ("SRG", "Surinamese Guilder"),
                            ("SZL", "Swazi Lilangeni"),
                            ("SEK", "Swedish Krona"),
                            ("CHF", "Swiss Franc"),
                            ("SYP", "Syrian Pound"),
                            ("STN", "São Tomé & Príncipe Dobra"),
                            ("STD", "São Tomé & Príncipe Dobra (1977–2017)"),
                            ("TVD", "TVD"),
                            ("TJR", "Tajikistani Ruble"),
                            ("TJS", "Tajikistani Somoni"),
                            ("TZS", "Tanzanian Shilling"),
                            ("XTS", "Testing Currency Code"),
                            ("THB", "Thai Baht"),
                            (
                                "XXX",
                                "The codes assigned for transactions where no currency is involved",
                            ),
                            ("TPE", "Timorese Escudo"),
                            ("TOP", "Tongan Paʻanga"),
                            ("TTD", "Trinidad & Tobago Dollar"),
                            ("TND", "Tunisian Dinar"),
                            ("TRY", "Turkish Lira"),
                            ("TRL", "Turkish Lira (1922–2005)"),
                            ("TMT", "Turkmenistani Manat"),
                            ("TMM", "Turkmenistani Manat (1993–2009)"),
                            ("USD", "US Dollar"),
                            ("USN", "US Dollar (Next day)"),
                            ("USS", "US Dollar (Same day)"),
                            ("UGX", "Ugandan Shilling"),
                            ("UGS", "Ugandan Shilling (1966–1987)"),
                            ("UAH", "Ukrainian Hryvnia"),
                            ("UAK", "Ukrainian Karbovanets"),
                            ("AED", "United Arab Emirates Dirham"),
                            ("UYW", "Uruguayan Nominal Wage Index Unit"),
                            ("UYU", "Uruguayan Peso"),
                            ("UYP", "Uruguayan Peso (1975–1993)"),
                            ("UYI", "Uruguayan Peso (Indexed Units)"),
                            ("UZS", "Uzbekistani Som"),
                            ("VUV", "Vanuatu Vatu"),
                            ("VES", "Venezuelan Bolívar"),
                            ("VEB", "Venezuelan Bolívar (1871–2008)"),
                            ("VEF", "Venezuelan Bolívar (2008–2018)"),
                            ("VND", "Vietnamese Dong"),
                            ("VNN", "Vietnamese Dong (1978–1985)"),
                            ("CHE", "WIR Euro"),
                            ("CHW", "WIR Franc"),
                            ("XOF", "West African CFA Franc"),
                            ("YDD", "Yemeni Dinar"),
                            ("YER", "Yemeni Rial"),
                            ("YUN", "Yugoslavian Convertible Dinar (1990–1992)"),
                            ("YUD", "Yugoslavian Hard Dinar (1966–1990)"),
                            ("YUM", "Yugoslavian New Dinar (1994–2002)"),
                            ("YUR", "Yugoslavian Reformed Dinar (1992–1993)"),
                            ("ZWN", "ZWN"),
                            ("ZRN", "Zairean New Zaire (1993–1998)"),
                            ("ZRZ", "Zairean Zaire (1971–1993)"),
                            ("ZMW", "Zambian Kwacha"),
                            ("ZMK", "Zambian Kwacha (1968–2012)"),
                            ("ZWD", "Zimbabwean Dollar (1980–2008)"),
                            ("ZWR", "Zimbabwean Dollar (2008)"),
                            ("ZWL", "Zimbabwean Dollar (2009)"),
                        ],
                        default="USD",
                        editable=False,
                        max_length=3,
                    ),
                ),
                (
                    "flat_rate",
                    djmoney.models.fields.MoneyField(
                        decimal_places=10, default_currency="USD", max_digits=20
                    ),
                ),
                (
                    "created_on",
                    models.DateTimeField(default=metering_billing.utils.utils.now_utc),
                ),
                (
                    "version_id",
                    models.CharField(
                        default=metering_billing.utils.utils.plan_version_uuid,
                        max_length=250,
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="metering_billing.organization",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical plan version",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalProduct",
            fields=[
                (
                    "id",
                    models.BigIntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("description", models.TextField(blank=True, null=True)),
                (
                    "product_id",
                    models.CharField(
                        db_index=True,
                        default=metering_billing.utils.utils.product_uuid,
                        max_length=100,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[("active", "Active"), ("deprecated", "Deprecated")],
                        max_length=40,
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="metering_billing.organization",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical product",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="Plan",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("plan_name", models.CharField(max_length=100)),
                (
                    "plan_duration",
                    models.CharField(
                        choices=[("month", "Month"), ("year", "Year")], max_length=40
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("active", "Active"),
                            ("inactive", "Inactive"),
                            ("experimental", "Experimental"),
                        ],
                        default="active",
                        max_length=40,
                    ),
                ),
                (
                    "plan_id",
                    models.CharField(
                        default=metering_billing.utils.utils.plan_uuid,
                        max_length=100,
                        unique=True,
                    ),
                ),
                (
                    "created_on",
                    models.DateTimeField(default=metering_billing.utils.utils.now_utc),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="created_plans",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="PlanVersion",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "description",
                    models.CharField(blank=True, max_length=200, null=True),
                ),
                ("version", models.PositiveSmallIntegerField()),
                (
                    "flat_fee_billing_type",
                    models.CharField(
                        choices=[
                            ("in_arrears", "In Arrears"),
                            ("in_advance", "In Advance"),
                        ],
                        max_length=40,
                    ),
                ),
                (
                    "usage_billing_type",
                    models.CharField(
                        choices=[
                            ("in_arrears", "In Arrears"),
                            ("pay_as_you_go_quarterly", "Pay as you go (Quarterly)"),
                            ("pay_as_you_go_monthly", "Pay as you go (Monthly)"),
                            ("pay_as_you_go_weekly", "Pay as you go (Weekly)"),
                        ],
                        max_length=40,
                    ),
                ),
                (
                    "proration_granularity",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("monthly", "Monthly"),
                            ("weekly", "Weekly"),
                            ("daily", "Daily"),
                            ("hourly", "Hourly"),
                            ("none", "None"),
                        ],
                        max_length=40,
                        null=True,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("active", "Active"),
                            ("retiring", "Retiring"),
                            ("grandfathered", "Grandfathered"),
                            ("archived", "Archived"),
                            ("inactive", "Inactive"),
                        ],
                        max_length=40,
                    ),
                ),
                (
                    "flat_rate_currency",
                    djmoney.models.fields.CurrencyField(
                        choices=[
                            ("XUA", "ADB Unit of Account"),
                            ("AFN", "Afghan Afghani"),
                            ("AFA", "Afghan Afghani (1927–2002)"),
                            ("ALL", "Albanian Lek"),
                            ("ALK", "Albanian Lek (1946–1965)"),
                            ("DZD", "Algerian Dinar"),
                            ("ADP", "Andorran Peseta"),
                            ("AOA", "Angolan Kwanza"),
                            ("AOK", "Angolan Kwanza (1977–1991)"),
                            ("AON", "Angolan New Kwanza (1990–2000)"),
                            ("AOR", "Angolan Readjusted Kwanza (1995–1999)"),
                            ("ARA", "Argentine Austral"),
                            ("ARS", "Argentine Peso"),
                            ("ARM", "Argentine Peso (1881–1970)"),
                            ("ARP", "Argentine Peso (1983–1985)"),
                            ("ARL", "Argentine Peso Ley (1970–1983)"),
                            ("AMD", "Armenian Dram"),
                            ("AWG", "Aruban Florin"),
                            ("AUD", "Australian Dollar"),
                            ("ATS", "Austrian Schilling"),
                            ("AZN", "Azerbaijani Manat"),
                            ("AZM", "Azerbaijani Manat (1993–2006)"),
                            ("BSD", "Bahamian Dollar"),
                            ("BHD", "Bahraini Dinar"),
                            ("BDT", "Bangladeshi Taka"),
                            ("BBD", "Barbadian Dollar"),
                            ("BYN", "Belarusian Ruble"),
                            ("BYB", "Belarusian Ruble (1994–1999)"),
                            ("BYR", "Belarusian Ruble (2000–2016)"),
                            ("BEF", "Belgian Franc"),
                            ("BEC", "Belgian Franc (convertible)"),
                            ("BEL", "Belgian Franc (financial)"),
                            ("BZD", "Belize Dollar"),
                            ("BMD", "Bermudan Dollar"),
                            ("BTN", "Bhutanese Ngultrum"),
                            ("BOB", "Bolivian Boliviano"),
                            ("BOL", "Bolivian Boliviano (1863–1963)"),
                            ("BOV", "Bolivian Mvdol"),
                            ("BOP", "Bolivian Peso"),
                            ("BAM", "Bosnia-Herzegovina Convertible Mark"),
                            ("BAD", "Bosnia-Herzegovina Dinar (1992–1994)"),
                            ("BAN", "Bosnia-Herzegovina New Dinar (1994–1997)"),
                            ("BWP", "Botswanan Pula"),
                            ("BRC", "Brazilian Cruzado (1986–1989)"),
                            ("BRZ", "Brazilian Cruzeiro (1942–1967)"),
                            ("BRE", "Brazilian Cruzeiro (1990–1993)"),
                            ("BRR", "Brazilian Cruzeiro (1993–1994)"),
                            ("BRN", "Brazilian New Cruzado (1989–1990)"),
                            ("BRB", "Brazilian New Cruzeiro (1967–1986)"),
                            ("BRL", "Brazilian Real"),
                            ("GBP", "British Pound"),
                            ("BND", "Brunei Dollar"),
                            ("BGL", "Bulgarian Hard Lev"),
                            ("BGN", "Bulgarian Lev"),
                            ("BGO", "Bulgarian Lev (1879–1952)"),
                            ("BGM", "Bulgarian Socialist Lev"),
                            ("BUK", "Burmese Kyat"),
                            ("BIF", "Burundian Franc"),
                            ("XPF", "CFP Franc"),
                            ("KHR", "Cambodian Riel"),
                            ("CAD", "Canadian Dollar"),
                            ("CVE", "Cape Verdean Escudo"),
                            ("KYD", "Cayman Islands Dollar"),
                            ("XAF", "Central African CFA Franc"),
                            ("CLE", "Chilean Escudo"),
                            ("CLP", "Chilean Peso"),
                            ("CLF", "Chilean Unit of Account (UF)"),
                            ("CNX", "Chinese People’s Bank Dollar"),
                            ("CNY", "Chinese Yuan"),
                            ("CNH", "Chinese Yuan (offshore)"),
                            ("COP", "Colombian Peso"),
                            ("COU", "Colombian Real Value Unit"),
                            ("KMF", "Comorian Franc"),
                            ("CDF", "Congolese Franc"),
                            ("CRC", "Costa Rican Colón"),
                            ("HRD", "Croatian Dinar"),
                            ("HRK", "Croatian Kuna"),
                            ("CUC", "Cuban Convertible Peso"),
                            ("CUP", "Cuban Peso"),
                            ("CYP", "Cypriot Pound"),
                            ("CZK", "Czech Koruna"),
                            ("CSK", "Czechoslovak Hard Koruna"),
                            ("DKK", "Danish Krone"),
                            ("DJF", "Djiboutian Franc"),
                            ("DOP", "Dominican Peso"),
                            ("NLG", "Dutch Guilder"),
                            ("XCD", "East Caribbean Dollar"),
                            ("DDM", "East German Mark"),
                            ("ECS", "Ecuadorian Sucre"),
                            ("ECV", "Ecuadorian Unit of Constant Value"),
                            ("EGP", "Egyptian Pound"),
                            ("GQE", "Equatorial Guinean Ekwele"),
                            ("ERN", "Eritrean Nakfa"),
                            ("EEK", "Estonian Kroon"),
                            ("ETB", "Ethiopian Birr"),
                            ("EUR", "Euro"),
                            ("XBA", "European Composite Unit"),
                            ("XEU", "European Currency Unit"),
                            ("XBB", "European Monetary Unit"),
                            ("XBC", "European Unit of Account (XBC)"),
                            ("XBD", "European Unit of Account (XBD)"),
                            ("FKP", "Falkland Islands Pound"),
                            ("FJD", "Fijian Dollar"),
                            ("FIM", "Finnish Markka"),
                            ("FRF", "French Franc"),
                            ("XFO", "French Gold Franc"),
                            ("XFU", "French UIC-Franc"),
                            ("GMD", "Gambian Dalasi"),
                            ("GEK", "Georgian Kupon Larit"),
                            ("GEL", "Georgian Lari"),
                            ("DEM", "German Mark"),
                            ("GHS", "Ghanaian Cedi"),
                            ("GHC", "Ghanaian Cedi (1979–2007)"),
                            ("GIP", "Gibraltar Pound"),
                            ("XAU", "Gold"),
                            ("GRD", "Greek Drachma"),
                            ("GTQ", "Guatemalan Quetzal"),
                            ("GWP", "Guinea-Bissau Peso"),
                            ("GNF", "Guinean Franc"),
                            ("GNS", "Guinean Syli"),
                            ("GYD", "Guyanaese Dollar"),
                            ("HTG", "Haitian Gourde"),
                            ("HNL", "Honduran Lempira"),
                            ("HKD", "Hong Kong Dollar"),
                            ("HUF", "Hungarian Forint"),
                            ("IMP", "IMP"),
                            ("ISK", "Icelandic Króna"),
                            ("ISJ", "Icelandic Króna (1918–1981)"),
                            ("INR", "Indian Rupee"),
                            ("IDR", "Indonesian Rupiah"),
                            ("IRR", "Iranian Rial"),
                            ("IQD", "Iraqi Dinar"),
                            ("IEP", "Irish Pound"),
                            ("ILS", "Israeli New Shekel"),
                            ("ILP", "Israeli Pound"),
                            ("ILR", "Israeli Shekel (1980–1985)"),
                            ("ITL", "Italian Lira"),
                            ("JMD", "Jamaican Dollar"),
                            ("JPY", "Japanese Yen"),
                            ("JOD", "Jordanian Dinar"),
                            ("KZT", "Kazakhstani Tenge"),
                            ("KES", "Kenyan Shilling"),
                            ("KWD", "Kuwaiti Dinar"),
                            ("KGS", "Kyrgystani Som"),
                            ("LAK", "Laotian Kip"),
                            ("LVL", "Latvian Lats"),
                            ("LVR", "Latvian Ruble"),
                            ("LBP", "Lebanese Pound"),
                            ("LSL", "Lesotho Loti"),
                            ("LRD", "Liberian Dollar"),
                            ("LYD", "Libyan Dinar"),
                            ("LTL", "Lithuanian Litas"),
                            ("LTT", "Lithuanian Talonas"),
                            ("LUL", "Luxembourg Financial Franc"),
                            ("LUC", "Luxembourgian Convertible Franc"),
                            ("LUF", "Luxembourgian Franc"),
                            ("MOP", "Macanese Pataca"),
                            ("MKD", "Macedonian Denar"),
                            ("MKN", "Macedonian Denar (1992–1993)"),
                            ("MGA", "Malagasy Ariary"),
                            ("MGF", "Malagasy Franc"),
                            ("MWK", "Malawian Kwacha"),
                            ("MYR", "Malaysian Ringgit"),
                            ("MVR", "Maldivian Rufiyaa"),
                            ("MVP", "Maldivian Rupee (1947–1981)"),
                            ("MLF", "Malian Franc"),
                            ("MTL", "Maltese Lira"),
                            ("MTP", "Maltese Pound"),
                            ("MRU", "Mauritanian Ouguiya"),
                            ("MRO", "Mauritanian Ouguiya (1973–2017)"),
                            ("MUR", "Mauritian Rupee"),
                            ("MXV", "Mexican Investment Unit"),
                            ("MXN", "Mexican Peso"),
                            ("MXP", "Mexican Silver Peso (1861–1992)"),
                            ("MDC", "Moldovan Cupon"),
                            ("MDL", "Moldovan Leu"),
                            ("MCF", "Monegasque Franc"),
                            ("MNT", "Mongolian Tugrik"),
                            ("MAD", "Moroccan Dirham"),
                            ("MAF", "Moroccan Franc"),
                            ("MZE", "Mozambican Escudo"),
                            ("MZN", "Mozambican Metical"),
                            ("MZM", "Mozambican Metical (1980–2006)"),
                            ("MMK", "Myanmar Kyat"),
                            ("NAD", "Namibian Dollar"),
                            ("NPR", "Nepalese Rupee"),
                            ("ANG", "Netherlands Antillean Guilder"),
                            ("TWD", "New Taiwan Dollar"),
                            ("NZD", "New Zealand Dollar"),
                            ("NIO", "Nicaraguan Córdoba"),
                            ("NIC", "Nicaraguan Córdoba (1988–1991)"),
                            ("NGN", "Nigerian Naira"),
                            ("KPW", "North Korean Won"),
                            ("NOK", "Norwegian Krone"),
                            ("OMR", "Omani Rial"),
                            ("PKR", "Pakistani Rupee"),
                            ("XPD", "Palladium"),
                            ("PAB", "Panamanian Balboa"),
                            ("PGK", "Papua New Guinean Kina"),
                            ("PYG", "Paraguayan Guarani"),
                            ("PEI", "Peruvian Inti"),
                            ("PEN", "Peruvian Sol"),
                            ("PES", "Peruvian Sol (1863–1965)"),
                            ("PHP", "Philippine Peso"),
                            ("XPT", "Platinum"),
                            ("PLN", "Polish Zloty"),
                            ("PLZ", "Polish Zloty (1950–1995)"),
                            ("PTE", "Portuguese Escudo"),
                            ("GWE", "Portuguese Guinea Escudo"),
                            ("QAR", "Qatari Rial"),
                            ("XRE", "RINET Funds"),
                            ("RHD", "Rhodesian Dollar"),
                            ("RON", "Romanian Leu"),
                            ("ROL", "Romanian Leu (1952–2006)"),
                            ("RUB", "Russian Ruble"),
                            ("RUR", "Russian Ruble (1991–1998)"),
                            ("RWF", "Rwandan Franc"),
                            ("SVC", "Salvadoran Colón"),
                            ("WST", "Samoan Tala"),
                            ("SAR", "Saudi Riyal"),
                            ("RSD", "Serbian Dinar"),
                            ("CSD", "Serbian Dinar (2002–2006)"),
                            ("SCR", "Seychellois Rupee"),
                            ("SLL", "Sierra Leonean Leone"),
                            ("XAG", "Silver"),
                            ("SGD", "Singapore Dollar"),
                            ("SKK", "Slovak Koruna"),
                            ("SIT", "Slovenian Tolar"),
                            ("SBD", "Solomon Islands Dollar"),
                            ("SOS", "Somali Shilling"),
                            ("ZAR", "South African Rand"),
                            ("ZAL", "South African Rand (financial)"),
                            ("KRH", "South Korean Hwan (1953–1962)"),
                            ("KRW", "South Korean Won"),
                            ("KRO", "South Korean Won (1945–1953)"),
                            ("SSP", "South Sudanese Pound"),
                            ("SUR", "Soviet Rouble"),
                            ("ESP", "Spanish Peseta"),
                            ("ESA", "Spanish Peseta (A account)"),
                            ("ESB", "Spanish Peseta (convertible account)"),
                            ("XDR", "Special Drawing Rights"),
                            ("LKR", "Sri Lankan Rupee"),
                            ("SHP", "St. Helena Pound"),
                            ("XSU", "Sucre"),
                            ("SDD", "Sudanese Dinar (1992–2007)"),
                            ("SDG", "Sudanese Pound"),
                            ("SDP", "Sudanese Pound (1957–1998)"),
                            ("SRD", "Surinamese Dollar"),
                            ("SRG", "Surinamese Guilder"),
                            ("SZL", "Swazi Lilangeni"),
                            ("SEK", "Swedish Krona"),
                            ("CHF", "Swiss Franc"),
                            ("SYP", "Syrian Pound"),
                            ("STN", "São Tomé & Príncipe Dobra"),
                            ("STD", "São Tomé & Príncipe Dobra (1977–2017)"),
                            ("TVD", "TVD"),
                            ("TJR", "Tajikistani Ruble"),
                            ("TJS", "Tajikistani Somoni"),
                            ("TZS", "Tanzanian Shilling"),
                            ("XTS", "Testing Currency Code"),
                            ("THB", "Thai Baht"),
                            (
                                "XXX",
                                "The codes assigned for transactions where no currency is involved",
                            ),
                            ("TPE", "Timorese Escudo"),
                            ("TOP", "Tongan Paʻanga"),
                            ("TTD", "Trinidad & Tobago Dollar"),
                            ("TND", "Tunisian Dinar"),
                            ("TRY", "Turkish Lira"),
                            ("TRL", "Turkish Lira (1922–2005)"),
                            ("TMT", "Turkmenistani Manat"),
                            ("TMM", "Turkmenistani Manat (1993–2009)"),
                            ("USD", "US Dollar"),
                            ("USN", "US Dollar (Next day)"),
                            ("USS", "US Dollar (Same day)"),
                            ("UGX", "Ugandan Shilling"),
                            ("UGS", "Ugandan Shilling (1966–1987)"),
                            ("UAH", "Ukrainian Hryvnia"),
                            ("UAK", "Ukrainian Karbovanets"),
                            ("AED", "United Arab Emirates Dirham"),
                            ("UYW", "Uruguayan Nominal Wage Index Unit"),
                            ("UYU", "Uruguayan Peso"),
                            ("UYP", "Uruguayan Peso (1975–1993)"),
                            ("UYI", "Uruguayan Peso (Indexed Units)"),
                            ("UZS", "Uzbekistani Som"),
                            ("VUV", "Vanuatu Vatu"),
                            ("VES", "Venezuelan Bolívar"),
                            ("VEB", "Venezuelan Bolívar (1871–2008)"),
                            ("VEF", "Venezuelan Bolívar (2008–2018)"),
                            ("VND", "Vietnamese Dong"),
                            ("VNN", "Vietnamese Dong (1978–1985)"),
                            ("CHE", "WIR Euro"),
                            ("CHW", "WIR Franc"),
                            ("XOF", "West African CFA Franc"),
                            ("YDD", "Yemeni Dinar"),
                            ("YER", "Yemeni Rial"),
                            ("YUN", "Yugoslavian Convertible Dinar (1990–1992)"),
                            ("YUD", "Yugoslavian Hard Dinar (1966–1990)"),
                            ("YUM", "Yugoslavian New Dinar (1994–2002)"),
                            ("YUR", "Yugoslavian Reformed Dinar (1992–1993)"),
                            ("ZWN", "ZWN"),
                            ("ZRN", "Zairean New Zaire (1993–1998)"),
                            ("ZRZ", "Zairean Zaire (1971–1993)"),
                            ("ZMW", "Zambian Kwacha"),
                            ("ZMK", "Zambian Kwacha (1968–2012)"),
                            ("ZWD", "Zimbabwean Dollar (1980–2008)"),
                            ("ZWR", "Zimbabwean Dollar (2008)"),
                            ("ZWL", "Zimbabwean Dollar (2009)"),
                        ],
                        default="USD",
                        editable=False,
                        max_length=3,
                    ),
                ),
                (
                    "flat_rate",
                    djmoney.models.fields.MoneyField(
                        decimal_places=10, default_currency="USD", max_digits=20
                    ),
                ),
                (
                    "created_on",
                    models.DateTimeField(default=metering_billing.utils.utils.now_utc),
                ),
                (
                    "version_id",
                    models.CharField(
                        default=metering_billing.utils.utils.plan_version_uuid,
                        max_length=250,
                    ),
                ),
                (
                    "components",
                    models.ManyToManyField(
                        blank=True, to="metering_billing.plancomponent"
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="created_plan_versions",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "features",
                    models.ManyToManyField(blank=True, to="metering_billing.feature"),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="org_plan_versions",
                        to="metering_billing.organization",
                    ),
                ),
                (
                    "plan",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="versions",
                        to="metering_billing.plan",
                    ),
                ),
                (
                    "replace_with",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metering_billing.planversion",
                    ),
                ),
            ],
            options={
                "unique_together": {("organization", "version_id")},
            },
        ),
        migrations.CreateModel(
            name="Product",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("description", models.TextField(blank=True, null=True)),
                (
                    "product_id",
                    models.CharField(
                        default=metering_billing.utils.utils.product_uuid,
                        max_length=100,
                        unique=True,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[("active", "Active"), ("deprecated", "Deprecated")],
                        max_length=40,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="org_products",
                        to="metering_billing.organization",
                    ),
                ),
            ],
            options={
                "unique_together": {("organization", "product_id")},
            },
        ),
        migrations.AlterUniqueTogether(
            name="billingplan",
            unique_together=None,
        ),
        migrations.RemoveField(
            model_name="billingplan",
            name="components",
        ),
        migrations.RemoveField(
            model_name="billingplan",
            name="features",
        ),
        migrations.RemoveField(
            model_name="billingplan",
            name="organization",
        ),
        migrations.RemoveField(
            model_name="billingplan",
            name="replacement_billing_plan",
        ),
        migrations.RemoveField(
            model_name="historicalsubscription",
            name="auto_renew_billing_plan",
        ),
        migrations.RemoveField(
            model_name="subscription",
            name="auto_renew_billing_plan",
        ),
        migrations.AlterField(
            model_name="backtest",
            name="backtest_id",
            field=models.CharField(
                blank=True,
                default=metering_billing.utils.utils.backtest_uuid,
                max_length=100,
                unique=True,
            ),
        ),
        migrations.AlterField(
            model_name="billablemetric",
            name="billable_metric_name",
            field=models.CharField(
                blank=True,
                default=metering_billing.utils.utils.metric_uuid,
                max_length=200,
            ),
        ),
        migrations.AlterField(
            model_name="customer",
            name="customer_id",
            field=models.CharField(
                blank=True,
                default=metering_billing.utils.utils.customer_uuid,
                max_length=40,
            ),
        ),
        migrations.AlterField(
            model_name="historicalbacktest",
            name="backtest_id",
            field=models.CharField(
                blank=True,
                db_index=True,
                default=metering_billing.utils.utils.backtest_uuid,
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="historicalbillablemetric",
            name="billable_metric_name",
            field=models.CharField(
                blank=True,
                default=metering_billing.utils.utils.metric_uuid,
                max_length=200,
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="customer_id",
            field=models.CharField(
                blank=True,
                default=metering_billing.utils.utils.customer_uuid,
                max_length=40,
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubscription",
            name="status",
            field=models.CharField(
                choices=[
                    ("active", "Active"),
                    ("ended", "Ended"),
                    ("not_started", "Not Started"),
                ],
                default="not_started",
                max_length=20,
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubscription",
            name="subscription_id",
            field=models.CharField(
                blank=True,
                default=metering_billing.utils.utils.subscription_uuid,
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="subscription",
            name="status",
            field=models.CharField(
                choices=[
                    ("active", "Active"),
                    ("ended", "Ended"),
                    ("not_started", "Not Started"),
                ],
                default="not_started",
                max_length=20,
            ),
        ),
        migrations.AlterField(
            model_name="subscription",
            name="subscription_id",
            field=models.CharField(
                blank=True,
                default=metering_billing.utils.utils.subscription_uuid,
                max_length=100,
            ),
        ),
        migrations.DeleteModel(
            name="HistoricalBillingPlan",
        ),
        migrations.AddField(
            model_name="plan",
            name="display_version",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="metering_billing.planversion",
            ),
        ),
        migrations.AddField(
            model_name="plan",
            name="organization",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="org_plans",
                to="metering_billing.organization",
            ),
        ),
        migrations.AddField(
            model_name="plan",
            name="parent_product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="product_plans",
                to="metering_billing.product",
            ),
        ),
        migrations.AddField(
            model_name="historicalplanversion",
            name="plan",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.plan",
            ),
        ),
        migrations.AddField(
            model_name="historicalplanversion",
            name="replace_with",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.planversion",
            ),
        ),
        migrations.AddField(
            model_name="historicalplan",
            name="display_version",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.planversion",
            ),
        ),
        migrations.AddField(
            model_name="historicalplan",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalplan",
            name="organization",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.organization",
            ),
        ),
        migrations.AddField(
            model_name="historicalplan",
            name="parent_product",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.product",
            ),
        ),
        migrations.AlterField(
            model_name="backtestsubstitution",
            name="new_plan",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="metering_billing.planversion",
            ),
        ),
        migrations.AlterField(
            model_name="backtestsubstitution",
            name="original_plan",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="metering_billing.planversion",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbacktestsubstitution",
            name="new_plan",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.planversion",
            ),
        ),
        migrations.AlterField(
            model_name="historicalbacktestsubstitution",
            name="original_plan",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.planversion",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubscription",
            name="billing_plan",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                related_query_name="bp_subscription",
                to="metering_billing.planversion",
            ),
        ),
        migrations.AlterField(
            model_name="subscription",
            name="billing_plan",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="bp_subscriptions",
                related_query_name="bp_subscription",
                to="metering_billing.planversion",
            ),
        ),
        migrations.DeleteModel(
            name="BillingPlan",
        ),
    ]
