# Generated by Django 4.0.5 on 2022-12-14 04:56

import django.db.models.deletion
from django.db import migrations, models

import metering_billing.utils.utils


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0118_alter_pricingunit_unique_together_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="AccountsReceivableDebtor",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(default=metering_billing.utils.utils.now_utc),
                ),
                (
                    "currency",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="metering_billing.pricingunit",
                    ),
                ),
            ],
        ),
        migrations.RemoveField(
            model_name="subscription",
            name="status",
        ),
        migrations.AlterField(
            model_name="customer",
            name="customer_id",
            field=models.CharField(
                default=metering_billing.utils.utils.customer_uuid,
                help_text="The id provided when creating the customer, we suggest matching with your internal customer id in your backend",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="customer",
            name="customer_name",
            field=models.CharField(
                blank=True,
                help_text="The display name of the customer",
                max_length=100,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="customer",
            name="default_currency",
            field=models.ForeignKey(
                blank=True,
                help_text="The currency the customer will be invoiced in",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="metering_billing.pricingunit",
            ),
        ),
        migrations.AlterField(
            model_name="customer",
            name="email",
            field=models.EmailField(
                blank=True,
                help_text="The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider",
                max_length=100,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="customer",
            name="properties",
            field=models.JSONField(
                blank=True,
                default=dict,
                help_text="Extra metadata for the customer",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="event",
            name="event_name",
            field=models.CharField(
                help_text="String name of the event, corresponds to definition in metrics",
                max_length=200,
            ),
        ),
        migrations.AlterField(
            model_name="event",
            name="idempotency_id",
            field=models.CharField(
                default=metering_billing.utils.utils.event_uuid,
                help_text="A unique identifier for the specific event being passed in. Passing in a unique id allows Lotus to make sure no double counting occurs. We recommend using a UUID4. You can use the same idempotency_id again after 7 days",
                max_length=255,
            ),
        ),
        migrations.AlterField(
            model_name="event",
            name="properties",
            field=models.JSONField(
                blank=True,
                default=dict,
                help_text="Extra metadata on the event that can be filtered and queried on in the metrics. All key value pairs should have string keys and values can be either strings or numbers. Place subscription filters in this object to specify which subscription the event should be tracked under",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="event",
            name="time_created",
            field=models.DateTimeField(
                help_text="The time that the event occured, represented as a datetime in ISO 8601 in the UTC timezome."
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="customer_id",
            field=models.CharField(
                default=metering_billing.utils.utils.customer_uuid,
                help_text="The id provided when creating the customer, we suggest matching with your internal customer id in your backend",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="customer_name",
            field=models.CharField(
                blank=True,
                help_text="The display name of the customer",
                max_length=100,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="default_currency",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="The currency the customer will be invoiced in",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="metering_billing.pricingunit",
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="email",
            field=models.EmailField(
                blank=True,
                help_text="The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider",
                max_length=100,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="properties",
            field=models.JSONField(
                blank=True,
                default=dict,
                help_text="Extra metadata for the customer",
                null=True,
            ),
        ),
        migrations.CreateModel(
            name="AccountsReceivableTransaction",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(default=metering_billing.utils.utils.now_utc),
                ),
                (
                    "transaction_type",
                    models.PositiveSmallIntegerField(
                        verbose_name=[
                            (1, "Invoice"),
                            (2, "Receipt"),
                            (3, "Adjustment"),
                            (4, "Reversal"),
                        ]
                    ),
                ),
                ("due", models.DateTimeField(null=True)),
                ("amount", models.DecimalField(decimal_places=10, max_digits=20)),
                (
                    "debtor",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="transactions",
                        to="metering_billing.accountsreceivabledebtor",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="metering_billing.organization",
                    ),
                ),
                (
                    "related_txns",
                    models.ManyToManyField(
                        related_name="related_txns",
                        to="metering_billing.accountsreceivabletransaction",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="accountsreceivabledebtor",
            name="customer",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="debtors",
                to="metering_billing.customer",
            ),
        ),
        migrations.AddField(
            model_name="accountsreceivabledebtor",
            name="organization",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="metering_billing.organization",
            ),
        ),
    ]
