# Generated by Django 4.0.5 on 2022-12-04 01:00

import django.core.validators
import django.db.models.deletion
import simple_history.models
from django.conf import settings
from django.db import migrations, models

import metering_billing.utils.utils


class Migration(migrations.Migration):
    dependencies = [
        (
            "metering_billing",
            "0095_historicalsubscriptionrecord_subscriptionrecord_and_more",
        ),
    ]

    operations = [
        migrations.CreateModel(
            name="HistoricalSubscription",
            fields=[
                (
                    "id",
                    models.BigIntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                (
                    "day_anchor",
                    models.SmallIntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(31),
                        ],
                    ),
                ),
                (
                    "month_anchor",
                    models.SmallIntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(12),
                        ],
                    ),
                ),
                (
                    "billing_cadence",
                    models.CharField(
                        choices=[
                            ("monthly", "Monthly"),
                            ("quarterly", "Quarterly"),
                            ("yearly", "Yearly"),
                        ],
                        max_length=20,
                    ),
                ),
                ("start_date", models.DateTimeField()),
                ("end_date", models.DateTimeField()),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("active", "Active"),
                            ("ended", "Ended"),
                            ("not_started", "Not Started"),
                        ],
                        default="not_started",
                        max_length=20,
                    ),
                ),
                (
                    "subscription_id",
                    models.CharField(
                        blank=True,
                        default=metering_billing.utils.utils.subscription_uuid,
                        max_length=100,
                    ),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "customer",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="metering_billing.customer",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="metering_billing.organization",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical subscription",
                "verbose_name_plural": "historical subscriptions",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="Subscription",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "day_anchor",
                    models.SmallIntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(31),
                        ],
                    ),
                ),
                (
                    "month_anchor",
                    models.SmallIntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(12),
                        ],
                    ),
                ),
                (
                    "billing_cadence",
                    models.CharField(
                        choices=[
                            ("monthly", "Monthly"),
                            ("quarterly", "Quarterly"),
                            ("yearly", "Yearly"),
                        ],
                        max_length=20,
                    ),
                ),
                ("start_date", models.DateTimeField()),
                ("end_date", models.DateTimeField()),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("active", "Active"),
                            ("ended", "Ended"),
                            ("not_started", "Not Started"),
                        ],
                        default="not_started",
                        max_length=20,
                    ),
                ),
                (
                    "subscription_id",
                    models.CharField(
                        blank=True,
                        default=metering_billing.utils.utils.subscription_uuid,
                        max_length=100,
                    ),
                ),
                (
                    "customer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="subscriptions",
                        to="metering_billing.customer",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="subscriptions",
                        to="metering_billing.organization",
                    ),
                ),
            ],
        ),
        migrations.AlterModelOptions(
            name="historicalbacktest",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical backtest",
                "verbose_name_plural": "historical backtests",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalbacktestsubstitution",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical backtest substitution",
                "verbose_name_plural": "historical backtest substitutions",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalcustomer",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical customer",
                "verbose_name_plural": "historical customers",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalinvoice",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical invoice",
                "verbose_name_plural": "historical invoices",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalmetric",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical metric",
                "verbose_name_plural": "historical metrics",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalorganization",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical organization",
                "verbose_name_plural": "historical organizations",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalorganizationsetting",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical organization setting",
                "verbose_name_plural": "historical organization settings",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalplan",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical plan",
                "verbose_name_plural": "historical plans",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalplanversion",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical plan version",
                "verbose_name_plural": "historical plan versions",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalproduct",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical product",
                "verbose_name_plural": "historical products",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalsubscriptionrecord",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical subscription record",
                "verbose_name_plural": "historical subscription records",
            },
        ),
        migrations.AlterModelOptions(
            name="historicaluser",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical user",
                "verbose_name_plural": "historical users",
            },
        ),
        migrations.AlterField(
            model_name="historicalbacktest",
            name="history_date",
            field=models.DateTimeField(db_index=True),
        ),
        migrations.AlterField(
            model_name="historicalbacktestsubstitution",
            name="history_date",
            field=models.DateTimeField(db_index=True),
        ),
        migrations.AlterField(
            model_name="historicalcustomer",
            name="history_date",
            field=models.DateTimeField(db_index=True),
        ),
        migrations.AlterField(
            model_name="historicalinvoice",
            name="history_date",
            field=models.DateTimeField(db_index=True),
        ),
        migrations.AlterField(
            model_name="historicalmetric",
            name="history_date",
            field=models.DateTimeField(db_index=True),
        ),
        migrations.AlterField(
            model_name="historicalorganization",
            name="history_date",
            field=models.DateTimeField(db_index=True),
        ),
        migrations.AlterField(
            model_name="historicalorganizationsetting",
            name="history_date",
            field=models.DateTimeField(db_index=True),
        ),
        migrations.AlterField(
            model_name="historicalplan",
            name="history_date",
            field=models.DateTimeField(db_index=True),
        ),
        migrations.AlterField(
            model_name="historicalplanversion",
            name="history_date",
            field=models.DateTimeField(db_index=True),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="history_date",
            field=models.DateTimeField(db_index=True),
        ),
        migrations.AlterField(
            model_name="historicalsubscriptionrecord",
            name="history_date",
            field=models.DateTimeField(db_index=True),
        ),
        migrations.AlterField(
            model_name="historicaluser",
            name="history_date",
            field=models.DateTimeField(db_index=True),
        ),
        migrations.DeleteModel(
            name="SubscriptionManager",
        ),
    ]
