# Generated by Django 4.0.5 on 2022-12-13 05:29

from django.db import migrations


def backtest_substitutions_to_org(apps, schema_editor):
    BacktestSubstitution = apps.get_model("metering_billing", "BacktestSubstitution")
    for bts in BacktestSubstitution.objects.all():
        bts.organization = bts.backtest.organization
        bts.save()


def webhooktrigger_to_org(apps, schema_editor):
    WebhookTrigger = apps.get_model("metering_billing", "WebhookTrigger")
    for wt in WebhookTrigger.objects.all():
        wt.organization = wt.webhook_endpoint.organization
        wt.save()


def custom_pricing_unit_conversion_to_org(apps, schema_editor):
    CustomPricingUnitConversion = apps.get_model(
        "metering_billing", "CustomPricingUnitConversion"
    )
    for c in CustomPricingUnitConversion.objects.all():
        c.organization = c.plan_version.organization
        c.save()


def plan_component_to_org(apps, schema_editor):
    PlanComponent = apps.get_model("metering_billing", "PlanComponent")
    for pc in PlanComponent.objects.all():
        pc.organization = pc.billable_metric.organization
        pc.save()


def price_tier_to_org(apps, schema_editor):
    PriceTier = apps.get_model("metering_billing", "PriceTier")
    for pt in PriceTier.objects.all():
        pt.organization = pt.plan_component.billable_metric.organization
        pt.save()


def categorical_filter_to_org(apps, schema_editor):
    CategoricalFilter = apps.get_model("metering_billing", "CategoricalFilter")
    Metric = apps.get_model("metering_billing", "Metric")
    SubscriptionRecord = apps.get_model("metering_billing", "SubscriptionRecord")
    for m in Metric.objects.all():
        m2m = list(m.categorical_filters.all())
        m.categorical_filters.clear()
        for cf in m2m:
            cf, _ = CategoricalFilter.objects.get_or_create(
                organization=m.organization,
                property_name=cf.property_name,
                operator=cf.operator,
                comparison_value=cf.comparison_value,
            )
            m.categorical_filters.add(cf)
    for sr in SubscriptionRecord.objects.all():
        sr2m = list(sr.filters.all())
        sr.filters.clear()
        for cf in sr2m:
            cf, _ = CategoricalFilter.objects.get_or_create(
                organization=sr.organization,
                property_name=cf.property_name,
                operator=cf.operator,
                comparison_value=cf.comparison_value,
            )
            sr.filters.add(cf)
    CategoricalFilter.objects.filter(organization__isnull=True).delete()


def numeric_filter_to_org(apps, schema_editor):
    NumericFilter = apps.get_model("metering_billing", "NumericFilter")
    Metric = apps.get_model("metering_billing", "Metric")
    for m in Metric.objects.all():
        m2m = list(m.numeric_filters.all())
        m.numeric_filters.clear()
        for nf in m2m:
            nf, _ = NumericFilter.objects.get_or_create(
                organization=m.organization,
                property_name=nf.property_name,
                operator=nf.operator,
                comparison_value=nf.comparison_value,
            )
            m.numeric_filters.add(nf)
    NumericFilter.objects.filter(organization__isnull=True).delete()


def invoice_line_item_to_org(apps, schema_editor):
    InvoiceLineItem = apps.get_model("metering_billing", "InvoiceLineItem")
    for ili in InvoiceLineItem.objects.all():
        ili.organization = ili.invoice.organization
        ili.save()


def pricing_unit_to_org(apps, schema_editor):
    PricingUnit = apps.get_model("metering_billing", "PricingUnit")
    Organization = apps.get_model("metering_billing", "Organization")
    for pu in PricingUnit.objects.filter(organization__isnull=True):
        for org in Organization.objects.all():
            PricingUnit.objects.get_or_create(
                organization=org,
                name=pu.name,
                code=pu.code,
                symbol=pu.symbol,
            )
        pu.delete()


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0116_backtestsubstitution_organization_and_more"),
    ]

    operations = [
        migrations.RunPython(
            invoice_line_item_to_org, reverse_code=migrations.RunPython.noop
        ),
        migrations.RunPython(
            numeric_filter_to_org, reverse_code=migrations.RunPython.noop
        ),
        migrations.RunPython(
            categorical_filter_to_org, reverse_code=migrations.RunPython.noop
        ),
        migrations.RunPython(price_tier_to_org, reverse_code=migrations.RunPython.noop),
        migrations.RunPython(
            plan_component_to_org, reverse_code=migrations.RunPython.noop
        ),
        migrations.RunPython(
            webhooktrigger_to_org, reverse_code=migrations.RunPython.noop
        ),
        migrations.RunPython(
            backtest_substitutions_to_org, reverse_code=migrations.RunPython.noop
        ),
        migrations.RunPython(
            custom_pricing_unit_conversion_to_org,
            reverse_code=migrations.RunPython.noop,
        ),
        migrations.RunPython(
            pricing_unit_to_org, reverse_code=migrations.RunPython.noop
        ),
    ]
