# Generated by Django 4.0.5 on 2023-02-14 06:36

from django.db import migrations


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0181_event_unique"),
    ]

    operations = [
        migrations.RunSQL(
            sql="""
                CREATE OR REPLACE FUNCTION insert_event_with_idempotency_check() RETURNS trigger AS $$
                BEGIN
                    INSERT INTO metering_billing_idempotencecheck (idempotency_id, time_created, organization_id)
                        VALUES (NEW.idempotency_id, NEW.time_created, NEW.organization_id);
                    RETURN NEW;
                END;
                $$ LANGUAGE plpgsql;
                
                CREATE TRIGGER event_insert_trigger BEFORE INSERT ON metering_billing_usageevent
                    FOR EACH ROW EXECUTE PROCEDURE insert_event_with_idempotency_check();
            """,
            reverse_sql="""
                DROP TRIGGER event_insert_trigger ON metering_billing_usageevent;
                DROP FUNCTION insert_event_with_idempotency_check();
            """,
        )
    ]
