# Generated by Django 4.0.5 on 2023-02-18 22:27

import uuid

from django.conf import settings
from django.db import migrations, models


def fill_uuid(apps, schema_editor):
    IdempotenceCheck = apps.get_model("metering_billing", "IdempotenceCheck")
    for check in IdempotenceCheck.objects.all():
        check.uuidv5_idempotency_id = uuid.uuid5(
            settings.IDEMPOTENCY_ID_NAMESPACE, check.idempotency_id
        )
        check.save()


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0195_auto_20230218_2223"),
    ]

    operations = [
        migrations.RunPython(
            fill_uuid,
            reverse_code=migrations.RunPython.noop,
        ),
        migrations.RemoveConstraint(
            model_name="idempotencecheck",
            name="unique_idempotency_id_per_org_raw",
        ),
        migrations.RemoveField(
            model_name="idempotencecheck",
            name="idempotency_id",
        ),
        migrations.AlterField(
            model_name="idempotencecheck",
            name="uuidv5_idempotency_id",
            field=models.UUIDField(primary_key=True, serialize=False),
        ),
        migrations.AddConstraint(
            model_name="idempotencecheck",
            constraint=models.UniqueConstraint(
                fields=("organization", "uuidv5_idempotency_id"),
                name="unique_hashed_idempotency_id_per_org_raw",
            ),
        ),
    ]
