# Generated by Django 4.0.5 on 2023-03-10 23:56

from decimal import Decimal

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("metering_billing", "0204_alter_idempotencecheck_time_created"),
    ]

    operations = [
        migrations.RenameField(
            model_name="historicalinvoice",
            old_name="cost_due",
            new_name="amount",
        ),
        migrations.RenameField(
            model_name="invoice",
            old_name="cost_due",
            new_name="amount",
        ),
        migrations.RenameField(
            model_name="invoicelineitem",
            old_name="subtotal",
            new_name="base",
        ),
        migrations.AddField(
            model_name="invoicelineitem",
            name="amount",
            field=models.DecimalField(
                decimal_places=10,
                default=Decimal("0"),
                help_text="Amount of the line item. This is the price after any adjustments are applied.",
                max_digits=20,
            ),
        ),
        migrations.AlterField(
            model_name="webhooktrigger",
            name="trigger_name",
            field=models.CharField(
                choices=[
                    ("customer.created", "customer.created"),
                    ("invoice.created", "invoice.created"),
                    ("invoice.paid", "invoice.paid"),
                    ("invoice.past_due", "invoice.past_due"),
                    ("subscription.created", "subscription.created"),
                    ("usage_alert.triggered", "usage_alert.triggered"),
                    ("subscription.cancelled", "subscription.cancelled"),
                ],
                max_length=40,
            ),
        ),
        migrations.CreateModel(
            name="InvoiceLineItemAdjustment",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", models.DecimalField(decimal_places=10, max_digits=20)),
                ("account", models.PositiveBigIntegerField()),
                (
                    "adjustment_type",
                    models.PositiveSmallIntegerField(
                        choices=[(1, "sales_tax"), (2, "plan_adjustment")]
                    ),
                ),
                (
                    "invoice_line_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="adjustments",
                        to="metering_billing.invoicelineitem",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="invoice_line_item_adjustments",
                        to="metering_billing.organization",
                    ),
                ),
            ],
        ),
        migrations.AlterField(
            model_name="invoicelineitem",
            name="base",
            field=models.DecimalField(
                decimal_places=10,
                default=Decimal("0"),
                help_text="Base price of the line item. This is the price before any adjustments are applied.",
                max_digits=20,
            ),
        ),
    ]
