/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */


export interface paths {
  "/app/actions/": {
    /** @description API endpoint that allows events to be viewed. */
    get: operations["appActionsList"];
  };
  "/app/addonVersions/": {
    post: operations["appAddonVersionsCreate"];
  };
  "/app/addonVersions/{versionId}/": {
    patch: operations["appAddonVersionsPartialUpdate"];
  };
  "/app/addonVersions/{versionId}/delete/": {
    post: operations["appAddonVersionsDeleteCreate"];
  };
  "/app/addons/": {
    get: operations["appAddonsList"];
    post: operations["appAddonsCreate"];
  };
  "/app/addons/{addonId}/": {
    get: operations["appAddonsRetrieve"];
    patch: operations["appAddonsPartialUpdate"];
  };
  "/app/addons/{addonId}/delete/": {
    post: operations["appAddonsDeleteCreate"];
  };
  "/app/addons/{addonId}/features/add/": {
    post: operations["appAddonsFeaturesAddCreate"];
  };
  "/app/apiTokens/": {
    /** @description API endpoint that allows API Tokens to be viewed or edited. */
    get: operations["appApiTokensList"];
    /** @description API endpoint that allows API Tokens to be viewed or edited. */
    post: operations["appApiTokensCreate"];
  };
  "/app/apiTokens/{prefix}/": {
    /** @description API endpoint that allows API Tokens to be viewed or edited. */
    delete: operations["appApiTokensDestroy"];
  };
  "/app/apiTokens/{prefix}/roll/": {
    /** @description API endpoint that allows API Tokens to be viewed or edited. */
    post: operations["appApiTokensRollCreate"];
  };
  "/app/backtests/": {
    get: operations["appBacktestsList"];
    post: operations["appBacktestsCreate"];
  };
  "/app/backtests/{backtestId}/": {
    get: operations["appBacktestsRetrieve"];
  };
  "/app/credits/": {
    get: operations["appCreditsList"];
    post: operations["appCreditsCreate"];
  };
  "/app/credits/{creditId}/": {
    get: operations["appCreditsRetrieve"];
  };
  "/app/credits/{creditId}/update/": {
    post: operations["appCreditsUpdateCreate"];
  };
  "/app/credits/{creditId}/void/": {
    post: operations["appCreditsVoidCreate"];
  };
  "/app/crm/": {
    get: operations["appCrmList"];
  };
  "/app/crm/linkToken/": {
    post: operations["appCrmLinkTokenCreate"];
  };
  "/app/crm/setCustomerSource/": {
    post: operations["appCrmSetCustomerSourceCreate"];
  };
  "/app/crm/storeToken/": {
    post: operations["appCrmStoreTokenCreate"];
  };
  "/app/customers/": {
    get: operations["appCustomersList"];
    post: operations["appCustomersCreate"];
  };
  "/app/customers/{customerId}/": {
    get: operations["appCustomersRetrieve"];
    patch: operations["appCustomersPartialUpdate"];
  };
  "/app/customers/{customerId}/costAnalysis/": {
    get: operations["appCustomersCostAnalysisRetrieve"];
  };
  "/app/customers/{customerId}/delete/": {
    post: operations["appCustomersDeleteCreate"];
  };
  "/app/customers/{customerId}/draftInvoice/": {
    get: operations["appCustomersDraftInvoiceRetrieve"];
  };
  "/app/customers/summary/": {
    /** @description Get the current settings for the organization. */
    get: operations["appCustomersSummaryRetrieve"];
  };
  "/app/customers/totals/": {
    /** @description Get the current settings for the organization. */
    get: operations["appCustomersTotalsRetrieve"];
  };
  "/app/demoLogin/": {
    post: operations["appDemoLoginCreate"];
  };
  "/app/demoRegister/": {
    post: operations["appDemoRegisterCreate"];
  };
  "/app/events/": {
    /** @description API endpoint that allows events to be viewed. */
    get: operations["appEventsList"];
  };
  "/app/events/properties/": {
    /** @description API endpoint that allows events to be viewed. */
    get: operations["appEventsPropertiesRetrieve"];
  };
  "/app/externalPlanLinks/": {
    post: operations["appExternalPlanLinksCreate"];
  };
  "/app/externalPlanLinks/{externalPlanId}/": {
    delete: operations["appExternalPlanLinksDestroy"];
  };
  "/app/features/": {
    get: operations["appFeaturesList"];
    post: operations["appFeaturesCreate"];
  };
  "/app/importCustomers/": {
    post: operations["appImportCustomersCreate"];
  };
  "/app/importPaymentObjects/": {
    post: operations["appImportPaymentObjectsCreate"];
  };
  "/app/importSubscriptions/": {
    post: operations["appImportSubscriptionsCreate"];
  };
  "/app/invoices/": {
    get: operations["appInvoicesList"];
    post: operations["appInvoicesCreate"];
  };
  "/app/invoices/{invoiceId}/": {
    get: operations["appInvoicesRetrieve"];
    patch: operations["appInvoicesPartialUpdate"];
  };
  "/app/invoices/{invoiceId}/pdfUrl/": {
    get: operations["appInvoicesPdfUrlRetrieve"];
  };
  "/app/invoices/{invoiceId}/send/": {
    post: operations["appInvoicesSendCreate"];
  };
  "/app/login/": {
    post: operations["appLoginCreate"];
  };
  "/app/logout/": {
    post: operations["appLogoutCreate"];
  };
  "/app/metrics/": {
    get: operations["appMetricsList"];
    post: operations["appMetricsCreate"];
  };
  "/app/metrics/{metricId}/": {
    get: operations["appMetricsRetrieve"];
    patch: operations["appMetricsPartialUpdate"];
  };
  "/app/netsuiteCustomers/": {
    get: operations["appNetsuiteCustomersRetrieve"];
  };
  "/app/netsuiteInvoices/": {
    get: operations["appNetsuiteInvoicesRetrieve"];
  };
  "/app/organization/invite/": {
    post: operations["appOrganizationInviteCreate"];
  };
  "/app/organization/inviteLink/": {
    post: operations["appOrganizationInviteLinkCreate"];
  };
  "/app/organizationSettings/": {
    get: operations["appOrganizationSettingsList"];
  };
  "/app/organizationSettings/{settingId}/": {
    get: operations["appOrganizationSettingsRetrieve"];
    patch: operations["appOrganizationSettingsPartialUpdate"];
  };
  "/app/organizations/": {
    get: operations["appOrganizationsList"];
    post: operations["appOrganizationsCreate"];
  };
  "/app/organizations/{organizationId}/": {
    patch: operations["appOrganizationsPartialUpdate"];
  };
  "/app/organizations/{organizationId}/syncCrm/": {
    post: operations["appOrganizationsSyncCrmCreate"];
  };
  "/app/paymentProviders/": {
    get: operations["appPaymentProvidersList"];
    post: operations["appPaymentProvidersCreate"];
  };
  "/app/periodEvents/": {
    /** @description Returns the revenue for an organization in a given time period. */
    get: operations["appPeriodEventsRetrieve"];
  };
  "/app/periodMetricRevenue/": {
    /** @description Returns the revenue for an organization in a given time period. */
    get: operations["appPeriodMetricRevenueRetrieve"];
  };
  "/app/periodMetricUsage/": {
    /** @description Return current usage for a customer during a given billing period. */
    get: operations["appPeriodMetricUsageRetrieve"];
  };
  "/app/periodSubscriptions/": {
    get: operations["appPeriodSubscriptionsRetrieve"];
  };
  "/app/planVersions/": {
    get: operations["appPlanVersionsList"];
    post: operations["appPlanVersionsCreate"];
  };
  "/app/planVersions/{versionId}/": {
    get: operations["appPlanVersionsRetrieve"];
    patch: operations["appPlanVersionsPartialUpdate"];
  };
  "/app/planVersions/{versionId}/delete/": {
    post: operations["appPlanVersionsDeleteCreate"];
  };
  "/app/planVersions/{versionId}/features/add/": {
    post: operations["appPlanVersionsFeaturesAddCreate"];
  };
  "/app/planVersions/{versionId}/makePublic/": {
    post: operations["appPlanVersionsMakePublicCreate"];
  };
  "/app/planVersions/{versionId}/replacement/make/": {
    post: operations["appPlanVersionsReplacementMakeCreate"];
  };
  "/app/planVersions/{versionId}/replacement/set/": {
    post: operations["appPlanVersionsReplacementSetCreate"];
  };
  "/app/planVersions/{versionId}/subscriptions/": {
    get: operations["appPlanVersionsSubscriptionsList"];
  };
  "/app/planVersions/{versionId}/targetCustomers/add/": {
    post: operations["appPlanVersionsTargetCustomersAddCreate"];
  };
  "/app/planVersions/{versionId}/targetCustomers/remove/": {
    post: operations["appPlanVersionsTargetCustomersRemoveCreate"];
  };
  "/app/plans/": {
    /** @description ViewSet for viewing and editing Plans. */
    get: operations["appPlansList"];
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["appPlansCreate"];
  };
  "/app/plans/{planId}/": {
    /** @description ViewSet for viewing and editing Plans. */
    get: operations["appPlansRetrieve"];
    /** @description ViewSet for viewing and editing Plans. */
    patch: operations["appPlansPartialUpdate"];
  };
  "/app/plans/{planId}/delete/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["appPlansDeleteCreate"];
  };
  "/app/plans/{planId}/features/add/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["appPlansFeaturesAddCreate"];
  };
  "/app/plans/{planId}/tags/add/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["appPlansTagsAddCreate"];
  };
  "/app/plans/{planId}/tags/remove/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["appPlansTagsRemoveCreate"];
  };
  "/app/plans/{planId}/tags/set/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["appPlansTagsSetCreate"];
  };
  "/app/plans/{planId}/versions/{versionNumber}/activeDates/update/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["appPlansVersionsActiveDatesUpdateCreate"];
  };
  "/app/plans/{planId}/versions/{versionNumber}/features/add/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["appPlansVersionsFeaturesAddCreate"];
  };
  "/app/plans/{planId}/versions/{versionNumber}/replacement/set/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["appPlansVersionsReplacementSetCreate"];
  };
  "/app/plans/{planId}/versions/{versionNumber}/transition/set/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["appPlansVersionsTransitionSetCreate"];
  };
  "/app/plans/{planId}/versions/next/": {
    /** @description ViewSet for viewing and editing Plans. */
    get: operations["appPlansVersionsNextRetrieve"];
  };
  "/app/plansByCustomer/": {
    get: operations["appPlansByCustomerRetrieve"];
  };
  "/app/pricingUnits/": {
    get: operations["appPricingUnitsList"];
    post: operations["appPricingUnitsCreate"];
  };
  "/app/register/": {
    post: operations["appRegisterCreate"];
  };
  "/app/session/": {
    get: operations["appSessionRetrieve"];
  };
  "/app/stripe/cancelAtPeriodEndSubscriptions/": {
    post: operations["appStripeCancelAtPeriodEndSubscriptionsCreate"];
  };
  "/app/stripe/cancelSubscriptions/": {
    post: operations["appStripeCancelSubscriptionsCreate"];
  };
  "/app/subscriptions/": {
    get: operations["appSubscriptionsList"];
    post: operations["appSubscriptionsCreate"];
  };
  "/app/subscriptions/{subscriptionId}/": {
    get: operations["appSubscriptionsRetrieve"];
  };
  "/app/subscriptions/{subscriptionId}/addons/{addonId}/cancel/": {
    post: operations["appSubscriptionsAddonsCancelCreate"];
  };
  "/app/subscriptions/{subscriptionId}/addons/attach/": {
    post: operations["appSubscriptionsAddonsAttachCreate"];
  };
  "/app/subscriptions/{subscriptionId}/cancel/": {
    post: operations["appSubscriptionsCancelCreate2"];
  };
  "/app/subscriptions/{subscriptionId}/components/{metricId}/changePrepaidUnits/": {
    post: operations["appSubscriptionsComponentsChangePrepaidUnitsCreate"];
  };
  "/app/subscriptions/{subscriptionId}/switchPlan/": {
    post: operations["appSubscriptionsSwitchPlanCreate"];
  };
  "/app/subscriptions/{subscriptionId}/update/": {
    post: operations["appSubscriptionsUpdateCreate2"];
  };
  "/app/subscriptions/add/": {
    /** @deprecated */
    post: operations["appSubscriptionsAddCreate"];
  };
  "/app/subscriptions/cancel/": {
    /** @deprecated */
    post: operations["appSubscriptionsCancelCreate"];
  };
  "/app/subscriptions/update/": {
    post: operations["appSubscriptionsUpdateCreate"];
  };
  "/app/switchOrganization/": {
    /** @description Get the current settings for the organization. */
    post: operations["appSwitchOrganizationCreate"];
  };
  "/app/timezones/": {
    /** @description Pagination-enabled endpoint for retrieving an organization's event stream. */
    get: operations["appTimezonesRetrieve"];
  };
  "/app/transferSubscriptions/": {
    post: operations["appTransferSubscriptionsCreate"];
  };
  "/app/usageAlerts/": {
    /** @description ViewSet for viewing and editing UsageAlerts. */
    get: operations["appUsageAlertsList"];
    /** @description ViewSet for viewing and editing UsageAlerts. */
    post: operations["appUsageAlertsCreate"];
  };
  "/app/usageAlerts/{usageAlertId}/": {
    /** @description ViewSet for viewing and editing UsageAlerts. */
    get: operations["appUsageAlertsRetrieve"];
    /** @description ViewSet for viewing and editing UsageAlerts. */
    delete: operations["appUsageAlertsDestroy"];
  };
  "/app/user/password/reset/": {
    /** @description Verifies the token and resets the password. */
    post: operations["appUserPasswordResetCreate"];
  };
  "/app/user/password/reset/init/": {
    post: operations["appUserPasswordResetInitCreate"];
  };
  "/app/users/": {
    get: operations["appUsersList"];
    post: operations["appUsersCreate"];
  };
  "/app/webhooks/": {
    /** @description API endpoint that allows alerts to be viewed or edited. */
    get: operations["appWebhooksList"];
    /** @description API endpoint that allows alerts to be viewed or edited. */
    post: operations["appWebhooksCreate"];
  };
  "/app/webhooks/{webhookEndpointId}/": {
    /** @description API endpoint that allows alerts to be viewed or edited. */
    get: operations["appWebhooksRetrieve"];
    /** @description API endpoint that allows alerts to be viewed or edited. */
    delete: operations["appWebhooksDestroy"];
  };
  "/stripe/webhook/": {
    post: operations["stripeWebhookCreate"];
  };
}

export type webhooks = Record<string, never>;

export interface components {
  schemas: {
    APIToken: {
      /** @description A free-form name for the API key. Need not be unique. 50 characters max. */
      name?: string;
      prefix: string;
      /**
       * Expires 
       * Format: date-time 
       * @description Once API key expires, clients cannot use it anymore.
       */
      expiryDate?: string | null;
      /** Format: date-time */
      created: string;
    };
    APITokenCreateResponse: {
      apiKey: components["schemas"]["APIToken"];
      key: string;
    };
    APITokenRequest: {
      /** @description A free-form name for the API key. Need not be unique. 50 characters max. */
      name?: string;
      /**
       * Expires 
       * Format: date-time 
       * @description Once API key expires, clients cannot use it anymore.
       */
      expiryDate?: string | null;
    };
    APITokenRollResponse: {
      apiKey: components["schemas"]["APIToken"];
      key: string;
    };
    AccessMethodsSubscriptionRecord: {
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      startDate: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      endDate: string;
      subscriptionFilters: (components["schemas"]["SubscriptionFilter"])[];
      plan: components["schemas"]["LightweightPlanVersion"];
    };
    /** @description DRF serializer for :class:`~activity.models.Action`. */
    Action: {
      id: number;
      actor: string;
      verb: string;
      actionObject: string;
      target: string;
      public?: boolean;
      description?: string | null;
      /** Format: date-time */
      timestamp?: string;
    };
    AddFeatureRequest: {
      /**
       * Format: uuid 
       * @description The featureId of the feature you want to add to the plan.
       */
      featureId: string;
    };
    AddFeatureResponse: {
      success: boolean;
      message: string;
    };
    AddFeatureToAddOnRequest: {
      /** @description The versionIds of the AddOn versions you want to add the feature to. If you want to apply to all versions, use the allVersions parameter. */
      versionIds?: (string)[];
      /**
       * Format: uuid 
       * @description The featureId of the feature you want to add to the plan.
       */
      featureId: string;
    };
    AddFeatureToAddOnResponse: {
      success: boolean;
      message: string;
    };
    AddFeatureToPlanRequest: {
      /** @description The versionIds of the plan versions you want to add the feature to. If you want to apply to all versions, use the allVersions parameter. */
      versionIds?: (string)[];
      /**
       * @description Whether or not to apply this feature to all versions of the feature. If you want to apply to specific versions, use the versionIds parameter. 
       * @default false
       */
      allVersions?: boolean;
      /**
       * Format: uuid 
       * @description The featureId of the feature you want to add to the plan.
       */
      featureId: string;
    };
    AddFeatureToPlanResponse: {
      success: boolean;
      message: string;
    };
    AddFeatureToPlanVersionNumberResponse: {
      success: boolean;
      message: string;
    };
    AddOnCreateRequest: {
      /** @description The name of the add-on plan. */
      addonName: string;
      /** @description The description of the add-on plan. */
      addonDescription: string;
      /** @description The initial version of the add-on plan. */
      initialVersion: components["schemas"]["InitialAddOnVersionCreateRequest"];
    };
    AddOnDetail: {
      /** @description The name of the add-on plan. */
      addonName: string;
      /** @description The description of the add-on plan. */
      addonDescription: string;
      /** @description The ID of the add-on plan. */
      addonId: string;
      /** @description This addon's versions. */
      versions: (components["schemas"]["AddOnVersion"])[];
    };
    AddOnSubscriptionRecord: {
      addonSubscriptionId: string;
      customer: components["schemas"]["LightweightCustomer"];
      addon: components["schemas"]["LightweightAddOn"];
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      startDate: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      endDate: string;
      parent: components["schemas"]["LightweightSubscriptionRecord"];
      fullyBilled: boolean;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      autoRenew: boolean;
      metadata: {
        [key: string]: unknown | undefined;
      };
    };
    AddOnSubscriptionRecordCreateRequest: {
      /**
       * Format: uuid 
       * @description The add-on to be applied to the subscription.
       */
      addonId?: string;
      /**
       * @description The quantity of the add-on to be applied to the subscription. Flat fees of add-ons will be multiplied by this quantity. Usage-based components of add-ons will be unaffected by the quantity. 
       * @default 1
       */
      quantity?: number;
      /** @description A JSON object containing additional information about the add-on subscription. This will be returned in the response when you retrieve the add-on subscription. */
      metadata?: {
        [key: string]: unknown | undefined;
      };
    };
    AddOnUpdate: {
      addonName?: string;
      /** Format: date-time */
      activeFrom?: string;
      /** Format: date-time */
      activeTo?: string | null;
    };
    AddOnVersion: {
      recurringCharges: (components["schemas"]["RecurringCharge"])[];
      components: (components["schemas"]["PlanComponent"])[];
      features: (components["schemas"]["Feature"])[];
      /**
       * @description * `active` - Active
       * * `retiring` - Retiring
       * * `grandfathered` - Grandfathered
       * * `deleted` - Deleted
       * * `inactive` - Inactive
       * * `notStarted` - Not Started 
       * @enum {string}
       */
      status: "active" | "retiring" | "grandfathered" | "deleted" | "inactive" | "notStarted";
      /** @description Currency of the plan. Can only be null if the flat fee is 0 and all components are of type free. */
      currency: components["schemas"]["PricingUnit"];
      /** @description The number of active instances of this version of the add-on plan. */
      activeInstances: number;
      /**
       * @description * `invoiceOnAttach` - invoiceOnAttach
       * * `invoiceOnSubscriptionEnd` - invoiceOnSubscriptionEnd 
       * @enum {unknown}
       */
      invoiceWhen: "invoiceOnAttach" | "invoiceOnSubscriptionEnd";
      /**
       * @description * `oneTime` - oneTime
       * * `recurring` - recurring 
       * @enum {unknown}
       */
      billingFrequency: "oneTime" | "recurring";
      /** @enum {string} */
      addonType: "usageBased" | "flat";
    };
    AddOnVersionCreateRequest: {
      /** Format: uuid */
      addonId: string;
      recurringCharges?: (components["schemas"]["RecurringChargeCreateRequest"])[] | null;
      components?: (components["schemas"]["PlanComponentCreateRequest"])[] | null;
      features?: (string)[];
      currencyCode: string;
      /**
       * @description * `invoiceOnAttach` - invoiceOnAttach
       * * `invoiceOnSubscriptionEnd` - invoiceOnSubscriptionEnd 
       * @enum {unknown}
       */
      invoiceWhen: "invoiceOnAttach" | "invoiceOnSubscriptionEnd";
      /**
       * @description * `oneTime` - oneTime
       * * `recurring` - recurring 
       * @enum {unknown}
       */
      billingFrequency: "oneTime" | "recurring";
    };
    AddOnVersionDetail: {
      recurringCharges: (components["schemas"]["RecurringCharge"])[];
      components: (components["schemas"]["PlanComponent"])[];
      features: (components["schemas"]["Feature"])[];
      /**
       * @description * `active` - Active
       * * `retiring` - Retiring
       * * `grandfathered` - Grandfathered
       * * `deleted` - Deleted
       * * `inactive` - Inactive
       * * `notStarted` - Not Started 
       * @enum {string}
       */
      status: "active" | "retiring" | "grandfathered" | "deleted" | "inactive" | "notStarted";
      /** @description Currency of the plan. Can only be null if the flat fee is 0 and all components are of type free. */
      currency: components["schemas"]["PricingUnit"];
      /** @description The number of active instances of this version of the add-on plan. */
      activeInstances: number;
      /**
       * @description * `invoiceOnAttach` - invoiceOnAttach
       * * `invoiceOnSubscriptionEnd` - invoiceOnSubscriptionEnd 
       * @enum {unknown}
       */
      invoiceWhen: "invoiceOnAttach" | "invoiceOnSubscriptionEnd";
      /**
       * @description * `oneTime` - oneTime
       * * `recurring` - recurring 
       * @enum {unknown}
       */
      billingFrequency: "oneTime" | "recurring";
      /** @enum {string} */
      addonType: "usageBased" | "flat";
    };
    AddOnVersionUpdate: {
      addonVersionName?: string;
      /** Format: date-time */
      activeFrom?: string | null;
      /** Format: date-time */
      activeTo?: string | null;
    };
    AddPlanTags: {
      tags?: (components["schemas"]["Tag"])[];
      success: boolean;
      message: string;
    };
    AddPlanTagsRequest: {
      tags?: (components["schemas"]["TagRequest"])[];
    };
    AddTargetCustomerResponse: {
      success: boolean;
      message: string;
    };
    Address: {
      /** @description City, district, suburb, town, or village */
      city: string;
      /**
       * @description Two-letter country code (ISO 3166-1 alpha-2)
       * 
       * * `AW` - Aruba
       * * `AF` - Afghanistan
       * * `AO` - Angola
       * * `AI` - Anguilla
       * * `AX` - Åland Islands
       * * `AL` - Albania
       * * `AD` - Andorra
       * * `AE` - United Arab Emirates
       * * `AR` - Argentina
       * * `AM` - Armenia
       * * `AS` - American Samoa
       * * `AQ` - Antarctica
       * * `TF` - French Southern Territories
       * * `AG` - Antigua and Barbuda
       * * `AU` - Australia
       * * `AT` - Austria
       * * `AZ` - Azerbaijan
       * * `BI` - Burundi
       * * `BE` - Belgium
       * * `BJ` - Benin
       * * `BQ` - Bonaire, Sint Eustatius and Saba
       * * `BF` - Burkina Faso
       * * `BD` - Bangladesh
       * * `BG` - Bulgaria
       * * `BH` - Bahrain
       * * `BS` - Bahamas
       * * `BA` - Bosnia and Herzegovina
       * * `BL` - Saint Barthélemy
       * * `BY` - Belarus
       * * `BZ` - Belize
       * * `BM` - Bermuda
       * * `BO` - Bolivia, Plurinational State of
       * * `BR` - Brazil
       * * `BB` - Barbados
       * * `BN` - Brunei Darussalam
       * * `BT` - Bhutan
       * * `BV` - Bouvet Island
       * * `BW` - Botswana
       * * `CF` - Central African Republic
       * * `CA` - Canada
       * * `CC` - Cocos (Keeling) Islands
       * * `CH` - Switzerland
       * * `CL` - Chile
       * * `CN` - China
       * * `CI` - Côte d'Ivoire
       * * `CM` - Cameroon
       * * `CD` - Congo, The Democratic Republic of the
       * * `CG` - Congo
       * * `CK` - Cook Islands
       * * `CO` - Colombia
       * * `KM` - Comoros
       * * `CV` - Cabo Verde
       * * `CR` - Costa Rica
       * * `CU` - Cuba
       * * `CW` - Curaçao
       * * `CX` - Christmas Island
       * * `KY` - Cayman Islands
       * * `CY` - Cyprus
       * * `CZ` - Czechia
       * * `DE` - Germany
       * * `DJ` - Djibouti
       * * `DM` - Dominica
       * * `DK` - Denmark
       * * `DO` - Dominican Republic
       * * `DZ` - Algeria
       * * `EC` - Ecuador
       * * `EG` - Egypt
       * * `ER` - Eritrea
       * * `EH` - Western Sahara
       * * `ES` - Spain
       * * `EE` - Estonia
       * * `ET` - Ethiopia
       * * `FI` - Finland
       * * `FJ` - Fiji
       * * `FK` - Falkland Islands (Malvinas)
       * * `FR` - France
       * * `FO` - Faroe Islands
       * * `FM` - Micronesia, Federated States of
       * * `GA` - Gabon
       * * `GB` - United Kingdom
       * * `GE` - Georgia
       * * `GG` - Guernsey
       * * `GH` - Ghana
       * * `GI` - Gibraltar
       * * `GN` - Guinea
       * * `GP` - Guadeloupe
       * * `GM` - Gambia
       * * `GW` - Guinea-Bissau
       * * `GQ` - Equatorial Guinea
       * * `GR` - Greece
       * * `GD` - Grenada
       * * `GL` - Greenland
       * * `GT` - Guatemala
       * * `GF` - French Guiana
       * * `GU` - Guam
       * * `GY` - Guyana
       * * `HK` - Hong Kong
       * * `HM` - Heard Island and McDonald Islands
       * * `HN` - Honduras
       * * `HR` - Croatia
       * * `HT` - Haiti
       * * `HU` - Hungary
       * * `ID` - Indonesia
       * * `IM` - Isle of Man
       * * `IN` - India
       * * `IO` - British Indian Ocean Territory
       * * `IE` - Ireland
       * * `IR` - Iran, Islamic Republic of
       * * `IQ` - Iraq
       * * `IS` - Iceland
       * * `IL` - Israel
       * * `IT` - Italy
       * * `JM` - Jamaica
       * * `JE` - Jersey
       * * `JO` - Jordan
       * * `JP` - Japan
       * * `KZ` - Kazakhstan
       * * `KE` - Kenya
       * * `KG` - Kyrgyzstan
       * * `KH` - Cambodia
       * * `KI` - Kiribati
       * * `KN` - Saint Kitts and Nevis
       * * `KR` - Korea, Republic of
       * * `KW` - Kuwait
       * * `LA` - Lao People's Democratic Republic
       * * `LB` - Lebanon
       * * `LR` - Liberia
       * * `LY` - Libya
       * * `LC` - Saint Lucia
       * * `LI` - Liechtenstein
       * * `LK` - Sri Lanka
       * * `LS` - Lesotho
       * * `LT` - Lithuania
       * * `LU` - Luxembourg
       * * `LV` - Latvia
       * * `MO` - Macao
       * * `MF` - Saint Martin (French part)
       * * `MA` - Morocco
       * * `MC` - Monaco
       * * `MD` - Moldova, Republic of
       * * `MG` - Madagascar
       * * `MV` - Maldives
       * * `MX` - Mexico
       * * `MH` - Marshall Islands
       * * `MK` - North Macedonia
       * * `ML` - Mali
       * * `MT` - Malta
       * * `MM` - Myanmar
       * * `ME` - Montenegro
       * * `MN` - Mongolia
       * * `MP` - Northern Mariana Islands
       * * `MZ` - Mozambique
       * * `MR` - Mauritania
       * * `MS` - Montserrat
       * * `MQ` - Martinique
       * * `MU` - Mauritius
       * * `MW` - Malawi
       * * `MY` - Malaysia
       * * `YT` - Mayotte
       * * `NA` - Namibia
       * * `NC` - New Caledonia
       * * `NE` - Niger
       * * `NF` - Norfolk Island
       * * `NG` - Nigeria
       * * `NI` - Nicaragua
       * * `NU` - Niue
       * * `NL` - Netherlands
       * * `NO` - Norway
       * * `NP` - Nepal
       * * `NR` - Nauru
       * * `NZ` - New Zealand
       * * `OM` - Oman
       * * `PK` - Pakistan
       * * `PA` - Panama
       * * `PN` - Pitcairn
       * * `PE` - Peru
       * * `PH` - Philippines
       * * `PW` - Palau
       * * `PG` - Papua New Guinea
       * * `PL` - Poland
       * * `PR` - Puerto Rico
       * * `KP` - Korea, Democratic People's Republic of
       * * `PT` - Portugal
       * * `PY` - Paraguay
       * * `PS` - Palestine, State of
       * * `PF` - French Polynesia
       * * `QA` - Qatar
       * * `RE` - Réunion
       * * `RO` - Romania
       * * `RU` - Russian Federation
       * * `RW` - Rwanda
       * * `SA` - Saudi Arabia
       * * `SD` - Sudan
       * * `SN` - Senegal
       * * `SG` - Singapore
       * * `GS` - South Georgia and the South Sandwich Islands
       * * `SH` - Saint Helena, Ascension and Tristan da Cunha
       * * `SJ` - Svalbard and Jan Mayen
       * * `SB` - Solomon Islands
       * * `SL` - Sierra Leone
       * * `SV` - El Salvador
       * * `SM` - San Marino
       * * `SO` - Somalia
       * * `PM` - Saint Pierre and Miquelon
       * * `RS` - Serbia
       * * `SS` - South Sudan
       * * `ST` - Sao Tome and Principe
       * * `SR` - Suriname
       * * `SK` - Slovakia
       * * `SI` - Slovenia
       * * `SE` - Sweden
       * * `SZ` - Eswatini
       * * `SX` - Sint Maarten (Dutch part)
       * * `SC` - Seychelles
       * * `SY` - Syrian Arab Republic
       * * `TC` - Turks and Caicos Islands
       * * `TD` - Chad
       * * `TG` - Togo
       * * `TH` - Thailand
       * * `TJ` - Tajikistan
       * * `TK` - Tokelau
       * * `TM` - Turkmenistan
       * * `TL` - Timor-Leste
       * * `TO` - Tonga
       * * `TT` - Trinidad and Tobago
       * * `TN` - Tunisia
       * * `TR` - Turkey
       * * `TV` - Tuvalu
       * * `TW` - Taiwan, Province of China
       * * `TZ` - Tanzania, United Republic of
       * * `UG` - Uganda
       * * `UA` - Ukraine
       * * `UM` - United States Minor Outlying Islands
       * * `UY` - Uruguay
       * * `US` - United States
       * * `UZ` - Uzbekistan
       * * `VA` - Holy See (Vatican City State)
       * * `VC` - Saint Vincent and the Grenadines
       * * `VE` - Venezuela, Bolivarian Republic of
       * * `VG` - Virgin Islands, British
       * * `VI` - Virgin Islands, U.S.
       * * `VN` - Viet Nam
       * * `VU` - Vanuatu
       * * `WF` - Wallis and Futuna
       * * `WS` - Samoa
       * * `YE` - Yemen
       * * `ZA` - South Africa
       * * `ZM` - Zambia
       * * `ZW` - Zimbabwe 
       * @enum {string}
       */
      country: "AW" | "AF" | "AO" | "AI" | "AX" | "AL" | "AD" | "AE" | "AR" | "AM" | "AS" | "AQ" | "TF" | "AG" | "AU" | "AT" | "AZ" | "BI" | "BE" | "BJ" | "BQ" | "BF" | "BD" | "BG" | "BH" | "BS" | "BA" | "BL" | "BY" | "BZ" | "BM" | "BO" | "BR" | "BB" | "BN" | "BT" | "BV" | "BW" | "CF" | "CA" | "CC" | "CH" | "CL" | "CN" | "CI" | "CM" | "CD" | "CG" | "CK" | "CO" | "KM" | "CV" | "CR" | "CU" | "CW" | "CX" | "KY" | "CY" | "CZ" | "DE" | "DJ" | "DM" | "DK" | "DO" | "DZ" | "EC" | "EG" | "ER" | "EH" | "ES" | "EE" | "ET" | "FI" | "FJ" | "FK" | "FR" | "FO" | "FM" | "GA" | "GB" | "GE" | "GG" | "GH" | "GI" | "GN" | "GP" | "GM" | "GW" | "GQ" | "GR" | "GD" | "GL" | "GT" | "GF" | "GU" | "GY" | "HK" | "HM" | "HN" | "HR" | "HT" | "HU" | "ID" | "IM" | "IN" | "IO" | "IE" | "IR" | "IQ" | "IS" | "IL" | "IT" | "JM" | "JE" | "JO" | "JP" | "KZ" | "KE" | "KG" | "KH" | "KI" | "KN" | "KR" | "KW" | "LA" | "LB" | "LR" | "LY" | "LC" | "LI" | "LK" | "LS" | "LT" | "LU" | "LV" | "MO" | "MF" | "MA" | "MC" | "MD" | "MG" | "MV" | "MX" | "MH" | "MK" | "ML" | "MT" | "MM" | "ME" | "MN" | "MP" | "MZ" | "MR" | "MS" | "MQ" | "MU" | "MW" | "MY" | "YT" | "NA" | "NC" | "NE" | "NF" | "NG" | "NI" | "NU" | "NL" | "NO" | "NP" | "NR" | "NZ" | "OM" | "PK" | "PA" | "PN" | "PE" | "PH" | "PW" | "PG" | "PL" | "PR" | "KP" | "PT" | "PY" | "PS" | "PF" | "QA" | "RE" | "RO" | "RU" | "RW" | "SA" | "SD" | "SN" | "SG" | "GS" | "SH" | "SJ" | "SB" | "SL" | "SV" | "SM" | "SO" | "PM" | "RS" | "SS" | "ST" | "SR" | "SK" | "SI" | "SE" | "SZ" | "SX" | "SC" | "SY" | "TC" | "TD" | "TG" | "TH" | "TJ" | "TK" | "TM" | "TL" | "TO" | "TT" | "TN" | "TR" | "TV" | "TW" | "TZ" | "UG" | "UA" | "UM" | "UY" | "US" | "UZ" | "VA" | "VC" | "VE" | "VG" | "VI" | "VN" | "VU" | "WF" | "WS" | "YE" | "ZA" | "ZM" | "ZW";
      /** @description Address line 1 (e.g., street, PO Box, or company name) */
      line1: string;
      /** @description Address line 2 (e.g., apartment, suite, unit, or building) */
      line2?: string | null;
      /** @description ZIP or postal code */
      postalCode: string;
      /** @description State, county, province, or region */
      state?: string | null;
    };
    AddressRequest: {
      /** @description City, district, suburb, town, or village */
      city: string;
      /**
       * @description Two-letter country code (ISO 3166-1 alpha-2)
       * 
       * * `AW` - Aruba
       * * `AF` - Afghanistan
       * * `AO` - Angola
       * * `AI` - Anguilla
       * * `AX` - Åland Islands
       * * `AL` - Albania
       * * `AD` - Andorra
       * * `AE` - United Arab Emirates
       * * `AR` - Argentina
       * * `AM` - Armenia
       * * `AS` - American Samoa
       * * `AQ` - Antarctica
       * * `TF` - French Southern Territories
       * * `AG` - Antigua and Barbuda
       * * `AU` - Australia
       * * `AT` - Austria
       * * `AZ` - Azerbaijan
       * * `BI` - Burundi
       * * `BE` - Belgium
       * * `BJ` - Benin
       * * `BQ` - Bonaire, Sint Eustatius and Saba
       * * `BF` - Burkina Faso
       * * `BD` - Bangladesh
       * * `BG` - Bulgaria
       * * `BH` - Bahrain
       * * `BS` - Bahamas
       * * `BA` - Bosnia and Herzegovina
       * * `BL` - Saint Barthélemy
       * * `BY` - Belarus
       * * `BZ` - Belize
       * * `BM` - Bermuda
       * * `BO` - Bolivia, Plurinational State of
       * * `BR` - Brazil
       * * `BB` - Barbados
       * * `BN` - Brunei Darussalam
       * * `BT` - Bhutan
       * * `BV` - Bouvet Island
       * * `BW` - Botswana
       * * `CF` - Central African Republic
       * * `CA` - Canada
       * * `CC` - Cocos (Keeling) Islands
       * * `CH` - Switzerland
       * * `CL` - Chile
       * * `CN` - China
       * * `CI` - Côte d'Ivoire
       * * `CM` - Cameroon
       * * `CD` - Congo, The Democratic Republic of the
       * * `CG` - Congo
       * * `CK` - Cook Islands
       * * `CO` - Colombia
       * * `KM` - Comoros
       * * `CV` - Cabo Verde
       * * `CR` - Costa Rica
       * * `CU` - Cuba
       * * `CW` - Curaçao
       * * `CX` - Christmas Island
       * * `KY` - Cayman Islands
       * * `CY` - Cyprus
       * * `CZ` - Czechia
       * * `DE` - Germany
       * * `DJ` - Djibouti
       * * `DM` - Dominica
       * * `DK` - Denmark
       * * `DO` - Dominican Republic
       * * `DZ` - Algeria
       * * `EC` - Ecuador
       * * `EG` - Egypt
       * * `ER` - Eritrea
       * * `EH` - Western Sahara
       * * `ES` - Spain
       * * `EE` - Estonia
       * * `ET` - Ethiopia
       * * `FI` - Finland
       * * `FJ` - Fiji
       * * `FK` - Falkland Islands (Malvinas)
       * * `FR` - France
       * * `FO` - Faroe Islands
       * * `FM` - Micronesia, Federated States of
       * * `GA` - Gabon
       * * `GB` - United Kingdom
       * * `GE` - Georgia
       * * `GG` - Guernsey
       * * `GH` - Ghana
       * * `GI` - Gibraltar
       * * `GN` - Guinea
       * * `GP` - Guadeloupe
       * * `GM` - Gambia
       * * `GW` - Guinea-Bissau
       * * `GQ` - Equatorial Guinea
       * * `GR` - Greece
       * * `GD` - Grenada
       * * `GL` - Greenland
       * * `GT` - Guatemala
       * * `GF` - French Guiana
       * * `GU` - Guam
       * * `GY` - Guyana
       * * `HK` - Hong Kong
       * * `HM` - Heard Island and McDonald Islands
       * * `HN` - Honduras
       * * `HR` - Croatia
       * * `HT` - Haiti
       * * `HU` - Hungary
       * * `ID` - Indonesia
       * * `IM` - Isle of Man
       * * `IN` - India
       * * `IO` - British Indian Ocean Territory
       * * `IE` - Ireland
       * * `IR` - Iran, Islamic Republic of
       * * `IQ` - Iraq
       * * `IS` - Iceland
       * * `IL` - Israel
       * * `IT` - Italy
       * * `JM` - Jamaica
       * * `JE` - Jersey
       * * `JO` - Jordan
       * * `JP` - Japan
       * * `KZ` - Kazakhstan
       * * `KE` - Kenya
       * * `KG` - Kyrgyzstan
       * * `KH` - Cambodia
       * * `KI` - Kiribati
       * * `KN` - Saint Kitts and Nevis
       * * `KR` - Korea, Republic of
       * * `KW` - Kuwait
       * * `LA` - Lao People's Democratic Republic
       * * `LB` - Lebanon
       * * `LR` - Liberia
       * * `LY` - Libya
       * * `LC` - Saint Lucia
       * * `LI` - Liechtenstein
       * * `LK` - Sri Lanka
       * * `LS` - Lesotho
       * * `LT` - Lithuania
       * * `LU` - Luxembourg
       * * `LV` - Latvia
       * * `MO` - Macao
       * * `MF` - Saint Martin (French part)
       * * `MA` - Morocco
       * * `MC` - Monaco
       * * `MD` - Moldova, Republic of
       * * `MG` - Madagascar
       * * `MV` - Maldives
       * * `MX` - Mexico
       * * `MH` - Marshall Islands
       * * `MK` - North Macedonia
       * * `ML` - Mali
       * * `MT` - Malta
       * * `MM` - Myanmar
       * * `ME` - Montenegro
       * * `MN` - Mongolia
       * * `MP` - Northern Mariana Islands
       * * `MZ` - Mozambique
       * * `MR` - Mauritania
       * * `MS` - Montserrat
       * * `MQ` - Martinique
       * * `MU` - Mauritius
       * * `MW` - Malawi
       * * `MY` - Malaysia
       * * `YT` - Mayotte
       * * `NA` - Namibia
       * * `NC` - New Caledonia
       * * `NE` - Niger
       * * `NF` - Norfolk Island
       * * `NG` - Nigeria
       * * `NI` - Nicaragua
       * * `NU` - Niue
       * * `NL` - Netherlands
       * * `NO` - Norway
       * * `NP` - Nepal
       * * `NR` - Nauru
       * * `NZ` - New Zealand
       * * `OM` - Oman
       * * `PK` - Pakistan
       * * `PA` - Panama
       * * `PN` - Pitcairn
       * * `PE` - Peru
       * * `PH` - Philippines
       * * `PW` - Palau
       * * `PG` - Papua New Guinea
       * * `PL` - Poland
       * * `PR` - Puerto Rico
       * * `KP` - Korea, Democratic People's Republic of
       * * `PT` - Portugal
       * * `PY` - Paraguay
       * * `PS` - Palestine, State of
       * * `PF` - French Polynesia
       * * `QA` - Qatar
       * * `RE` - Réunion
       * * `RO` - Romania
       * * `RU` - Russian Federation
       * * `RW` - Rwanda
       * * `SA` - Saudi Arabia
       * * `SD` - Sudan
       * * `SN` - Senegal
       * * `SG` - Singapore
       * * `GS` - South Georgia and the South Sandwich Islands
       * * `SH` - Saint Helena, Ascension and Tristan da Cunha
       * * `SJ` - Svalbard and Jan Mayen
       * * `SB` - Solomon Islands
       * * `SL` - Sierra Leone
       * * `SV` - El Salvador
       * * `SM` - San Marino
       * * `SO` - Somalia
       * * `PM` - Saint Pierre and Miquelon
       * * `RS` - Serbia
       * * `SS` - South Sudan
       * * `ST` - Sao Tome and Principe
       * * `SR` - Suriname
       * * `SK` - Slovakia
       * * `SI` - Slovenia
       * * `SE` - Sweden
       * * `SZ` - Eswatini
       * * `SX` - Sint Maarten (Dutch part)
       * * `SC` - Seychelles
       * * `SY` - Syrian Arab Republic
       * * `TC` - Turks and Caicos Islands
       * * `TD` - Chad
       * * `TG` - Togo
       * * `TH` - Thailand
       * * `TJ` - Tajikistan
       * * `TK` - Tokelau
       * * `TM` - Turkmenistan
       * * `TL` - Timor-Leste
       * * `TO` - Tonga
       * * `TT` - Trinidad and Tobago
       * * `TN` - Tunisia
       * * `TR` - Turkey
       * * `TV` - Tuvalu
       * * `TW` - Taiwan, Province of China
       * * `TZ` - Tanzania, United Republic of
       * * `UG` - Uganda
       * * `UA` - Ukraine
       * * `UM` - United States Minor Outlying Islands
       * * `UY` - Uruguay
       * * `US` - United States
       * * `UZ` - Uzbekistan
       * * `VA` - Holy See (Vatican City State)
       * * `VC` - Saint Vincent and the Grenadines
       * * `VE` - Venezuela, Bolivarian Republic of
       * * `VG` - Virgin Islands, British
       * * `VI` - Virgin Islands, U.S.
       * * `VN` - Viet Nam
       * * `VU` - Vanuatu
       * * `WF` - Wallis and Futuna
       * * `WS` - Samoa
       * * `YE` - Yemen
       * * `ZA` - South Africa
       * * `ZM` - Zambia
       * * `ZW` - Zimbabwe 
       * @enum {string}
       */
      country: "AW" | "AF" | "AO" | "AI" | "AX" | "AL" | "AD" | "AE" | "AR" | "AM" | "AS" | "AQ" | "TF" | "AG" | "AU" | "AT" | "AZ" | "BI" | "BE" | "BJ" | "BQ" | "BF" | "BD" | "BG" | "BH" | "BS" | "BA" | "BL" | "BY" | "BZ" | "BM" | "BO" | "BR" | "BB" | "BN" | "BT" | "BV" | "BW" | "CF" | "CA" | "CC" | "CH" | "CL" | "CN" | "CI" | "CM" | "CD" | "CG" | "CK" | "CO" | "KM" | "CV" | "CR" | "CU" | "CW" | "CX" | "KY" | "CY" | "CZ" | "DE" | "DJ" | "DM" | "DK" | "DO" | "DZ" | "EC" | "EG" | "ER" | "EH" | "ES" | "EE" | "ET" | "FI" | "FJ" | "FK" | "FR" | "FO" | "FM" | "GA" | "GB" | "GE" | "GG" | "GH" | "GI" | "GN" | "GP" | "GM" | "GW" | "GQ" | "GR" | "GD" | "GL" | "GT" | "GF" | "GU" | "GY" | "HK" | "HM" | "HN" | "HR" | "HT" | "HU" | "ID" | "IM" | "IN" | "IO" | "IE" | "IR" | "IQ" | "IS" | "IL" | "IT" | "JM" | "JE" | "JO" | "JP" | "KZ" | "KE" | "KG" | "KH" | "KI" | "KN" | "KR" | "KW" | "LA" | "LB" | "LR" | "LY" | "LC" | "LI" | "LK" | "LS" | "LT" | "LU" | "LV" | "MO" | "MF" | "MA" | "MC" | "MD" | "MG" | "MV" | "MX" | "MH" | "MK" | "ML" | "MT" | "MM" | "ME" | "MN" | "MP" | "MZ" | "MR" | "MS" | "MQ" | "MU" | "MW" | "MY" | "YT" | "NA" | "NC" | "NE" | "NF" | "NG" | "NI" | "NU" | "NL" | "NO" | "NP" | "NR" | "NZ" | "OM" | "PK" | "PA" | "PN" | "PE" | "PH" | "PW" | "PG" | "PL" | "PR" | "KP" | "PT" | "PY" | "PS" | "PF" | "QA" | "RE" | "RO" | "RU" | "RW" | "SA" | "SD" | "SN" | "SG" | "GS" | "SH" | "SJ" | "SB" | "SL" | "SV" | "SM" | "SO" | "PM" | "RS" | "SS" | "ST" | "SR" | "SK" | "SI" | "SE" | "SZ" | "SX" | "SC" | "SY" | "TC" | "TD" | "TG" | "TH" | "TJ" | "TK" | "TM" | "TL" | "TO" | "TT" | "TN" | "TR" | "TV" | "TW" | "TZ" | "UG" | "UA" | "UM" | "UY" | "US" | "UZ" | "VA" | "VC" | "VE" | "VG" | "VI" | "VN" | "VU" | "WF" | "WS" | "YE" | "ZA" | "ZM" | "ZW";
      /** @description Address line 1 (e.g., street, PO Box, or company name) */
      line1: string;
      /** @description Address line 2 (e.g., apartment, suite, unit, or building) */
      line2?: string | null;
      /** @description ZIP or postal code */
      postalCode: string;
      /** @description State, county, province, or region */
      state?: string | null;
    };
    AllSubstitutionResults: {
      substitutionResults?: (components["schemas"]["SingleSubstitution"])[];
      /** Format: double */
      originalPlansRevenue?: number;
      /** Format: double */
      newPlansRevenue?: number;
      /** Format: double */
      pctRevenueChange?: number | null;
    };
    BacktestCreate: {
      /** Format: date */
      startDate: string;
      /** Format: date */
      endDate: string;
      kpis: ("totalRevenue")[];
      backtestName: string;
    };
    BacktestCreateRequest: {
      /** Format: date */
      startDate: string;
      /** Format: date */
      endDate: string;
      substitutions: (components["schemas"]["BacktestSubstitutionMultiRequest"])[];
      kpis: ("totalRevenue")[];
      backtestName: string;
    };
    BacktestDetail: {
      backtestId: string;
      /** Format: date */
      endDate: string;
      backtestName: string;
      kpis?: {
        [key: string]: unknown | undefined;
      };
      backtestSubstitutions: (components["schemas"]["BacktestSubstitution"])[];
      backtestResults: components["schemas"]["AllSubstitutionResults"];
      /**
       * @description * `running` - Running
       * * `completed` - Completed
       * * `failed` - Failed 
       * @enum {string}
       */
      status?: "running" | "completed" | "failed";
      /** Format: date-time */
      timeCreated?: string;
      /** Format: date */
      startDate: string;
    };
    BacktestSubstitution: {
      newPlan: components["schemas"]["PlanVersionDetail"];
      originalPlan: components["schemas"]["PlanVersionDetail"];
    };
    BacktestSubstitutionMulti: {
      /** Format: uuid */
      newPlan: string;
      originalPlans: (string)[];
    };
    BacktestSubstitutionMultiRequest: {
      /** Format: uuid */
      newPlan: string;
      originalPlans: (string)[];
    };
    BacktestSummary: {
      backtestName: string;
      /** Format: date */
      startDate: string;
      /** Format: date */
      endDate: string;
      /** Format: date-time */
      timeCreated?: string;
      kpis?: {
        [key: string]: unknown | undefined;
      };
      /**
       * @description * `running` - Running
       * * `completed` - Completed
       * * `failed` - Failed 
       * @enum {string}
       */
      status?: "running" | "completed" | "failed";
      backtestId: string;
    };
    BatchEventRequest: {
      batch: (components["schemas"]["EventRequest"])[];
    };
    CRMSyncRequestRequest: {
      crmProviderNames?: ("salesforce")[];
    };
    CategoricalFilter: {
      propertyName: string;
      /**
       * @description * `isin` - Is in
       * * `isnotin` - Is not in 
       * @enum {string}
       */
      operator: "isin" | "isnotin";
      comparisonValue: (string)[];
    };
    CategoricalFilterDetailRequest: {
      propertyName: string;
      /**
       * @description * `isin` - Is in
       * * `isnotin` - Is not in 
       * @enum {string}
       */
      operator: "isin" | "isnotin";
      comparisonValue: (string)[];
    };
    CategoricalFilterRequest: {
      propertyName: string;
      /**
       * @description * `isin` - Is in
       * * `isnotin` - Is not in 
       * @enum {string}
       */
      operator: "isin" | "isnotin";
      comparisonValue: (string)[];
    };
    ChangeActiveDateResponse: {
      success: boolean;
      message: string;
    };
    ChangeActiveDatesRequest: {
      /** @description The versionIds of the plan versions you want to add the feature to. If you want to apply to all versions, use the allVersions parameter. */
      versionIds?: (string)[];
      /**
       * @description Whether or not to apply this feature to all versions of the feature. If you want to apply to specific versions, use the versionIds parameter. 
       * @default false
       */
      allVersions?: boolean;
      /**
       * Format: date-time 
       * @description The date and time that the feature should be active from. If you want to make this inactive, you can pass null here.
       */
      activeFrom?: string | null;
      /**
       * Format: date-time 
       * @description The date and time that the feature should be active until. If you want to make this active indefinitely, you can pass null here.
       */
      activeTo?: string | null;
    };
    ChangePrepaidUnitsRequest: {
      /**
       * Format: double 
       * @description The new prepaid units for the customer.
       */
      units: number;
      /**
       * @description Whether or not to immediately invoice the customer for the change in prepaid units. 
       * @default true
       */
      invoiceNow?: boolean;
    };
    ChangeUserOrganizationRequestRequest: {
      /** @description The organization ID to transfer to */
      transferToOrganizationId: string;
    };
    ComponentCharge: {
      /**
       * Format: double 
       * @description The number of units to charge for. If left null, then it will be required at subscription create time.
       */
      units: number | null;
      /**
       * @description * `prorate` - prorate
       * * `full` - full 
       * @enum {unknown}
       */
      chargeBehavior: "prorate" | "full";
    };
    ComponentChargeCreateRequest: {
      /**
       * Format: double 
       * @description The number of units to charge for. If left null, then it will be required at subscription create time.
       */
      units: number | null;
      /**
       * @description * `prorate` - prorate
       * * `full` - full 
       * @enum {unknown}
       */
      chargeBehavior: "prorate" | "full";
    };
    ComponentUsage: {
      /** @description The name of the event you are checking access for. */
      eventName: string;
      /** @description The name of the metric. */
      metricName: string;
      /** @description The metricId of the metric. This metricId can be found in the Lotus frontend if you haven't seen it before. */
      metricId: string;
      /**
       * Format: double 
       * @description The current usage of the metric. Keep in mind the current usage of the metric can be different from the billable usage of the metric.
       */
      metricUsage: number;
      /**
       * Format: double 
       * @description If you specified a free tier of usage for this metric, this is the amount of usage that is free. Will be null if you did not specify a free tier for this metric.
       */
      metricFreeLimit: number | null;
      /**
       * Format: double 
       * @description The total limit of the metric. Will be null if you did not specify a limit for this metric.
       */
      metricTotalLimit: number | null;
    };
    ComponentsFixedChargeInitialValueRequest: {
      /**
       * Format: uuid 
       * @description The id of the metric that this initial value is for
       */
      metricId: string;
      /**
       * Format: double 
       * @description The number of units of the metric that this initial value is for
       */
      units: number;
    };
    ConfirmConnected: {
      organizationId: string;
    };
    ConfirmIdemsReceived: {
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
      idsNotFound: (string)[];
    };
    ConfirmIdemsReceivedFailure: {
      /**
       * @description * `failure` - failure 
       * @enum {string}
       */
      status: "failure";
      error: string;
    };
    ConfirmIdemsReceivedRequestRequest: {
      idempotencyIds: (string)[];
      /** @default 30 */
      numberDaysLookback?: number;
      customerId?: string;
    };
    CostAnalysis: {
      perDay: (components["schemas"]["SingleDayCostAnalysis"])[];
      /** Format: double */
      totalCost: number;
      /** Format: double */
      totalRevenue: number;
      /** Format: double */
      margin: number;
    };
    CreditDrawdown: {
      creditId: string;
      /** Format: double */
      amount: number;
      description?: string | null;
      /** Format: date-time */
      appliedAt: string;
    };
    Customer: {
      customerId: string;
      /** Format: email */
      email: string | null;
      /** @description The display name of the customer */
      customerName: string | null;
      invoices: readonly (components["schemas"]["LightweightInvoice"])[];
      /** Format: double */
      totalAmountDue: number;
      subscriptions: readonly (components["schemas"]["SubscriptionRecord"])[];
      /** @description A dictionary containing the customer's integrations. Keys are the integration type, and the value is a dictionary containing the integration's properties, which can vary by integration. */
      integrations: components["schemas"]["CustomerIntegrations"];
      defaultCurrency: components["schemas"]["PricingUnit"];
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      paymentProvider: "stripe" | "braintree" | "" | null;
      paymentProviderId: string | null;
      hasPaymentMethod: boolean;
      /** @deprecated */
      address?: components["schemas"]["Address"] | null;
      billingAddress: components["schemas"]["Address"] | null;
      shippingAddress: components["schemas"]["Address"] | null;
      /**
       * Format: double 
       * @description Tax rate as percentage. For example, 10.5 for 10.5%
       */
      taxRate: number | null;
      /**
       * @description * `Africa/Abidjan` - Africa/Abidjan
       * * `Africa/Accra` - Africa/Accra
       * * `Africa/Addis_Ababa` - Africa/Addis_Ababa
       * * `Africa/Algiers` - Africa/Algiers
       * * `Africa/Asmara` - Africa/Asmara
       * * `Africa/Bamako` - Africa/Bamako
       * * `Africa/Bangui` - Africa/Bangui
       * * `Africa/Banjul` - Africa/Banjul
       * * `Africa/Bissau` - Africa/Bissau
       * * `Africa/Blantyre` - Africa/Blantyre
       * * `Africa/Brazzaville` - Africa/Brazzaville
       * * `Africa/Bujumbura` - Africa/Bujumbura
       * * `Africa/Cairo` - Africa/Cairo
       * * `Africa/Casablanca` - Africa/Casablanca
       * * `Africa/Ceuta` - Africa/Ceuta
       * * `Africa/Conakry` - Africa/Conakry
       * * `Africa/Dakar` - Africa/Dakar
       * * `Africa/DarEs_Salaam` - Africa/DarEs_Salaam
       * * `Africa/Djibouti` - Africa/Djibouti
       * * `Africa/Douala` - Africa/Douala
       * * `Africa/El_Aaiun` - Africa/El_Aaiun
       * * `Africa/Freetown` - Africa/Freetown
       * * `Africa/Gaborone` - Africa/Gaborone
       * * `Africa/Harare` - Africa/Harare
       * * `Africa/Johannesburg` - Africa/Johannesburg
       * * `Africa/Juba` - Africa/Juba
       * * `Africa/Kampala` - Africa/Kampala
       * * `Africa/Khartoum` - Africa/Khartoum
       * * `Africa/Kigali` - Africa/Kigali
       * * `Africa/Kinshasa` - Africa/Kinshasa
       * * `Africa/Lagos` - Africa/Lagos
       * * `Africa/Libreville` - Africa/Libreville
       * * `Africa/Lome` - Africa/Lome
       * * `Africa/Luanda` - Africa/Luanda
       * * `Africa/Lubumbashi` - Africa/Lubumbashi
       * * `Africa/Lusaka` - Africa/Lusaka
       * * `Africa/Malabo` - Africa/Malabo
       * * `Africa/Maputo` - Africa/Maputo
       * * `Africa/Maseru` - Africa/Maseru
       * * `Africa/Mbabane` - Africa/Mbabane
       * * `Africa/Mogadishu` - Africa/Mogadishu
       * * `Africa/Monrovia` - Africa/Monrovia
       * * `Africa/Nairobi` - Africa/Nairobi
       * * `Africa/Ndjamena` - Africa/Ndjamena
       * * `Africa/Niamey` - Africa/Niamey
       * * `Africa/Nouakchott` - Africa/Nouakchott
       * * `Africa/Ouagadougou` - Africa/Ouagadougou
       * * `Africa/Porto-Novo` - Africa/Porto-Novo
       * * `Africa/Sao_Tome` - Africa/Sao_Tome
       * * `Africa/Tripoli` - Africa/Tripoli
       * * `Africa/Tunis` - Africa/Tunis
       * * `Africa/Windhoek` - Africa/Windhoek
       * * `America/Adak` - America/Adak
       * * `America/Anchorage` - America/Anchorage
       * * `America/Anguilla` - America/Anguilla
       * * `America/Antigua` - America/Antigua
       * * `America/Araguaina` - America/Araguaina
       * * `America/Argentina/Buenos_Aires` - America/Argentina/Buenos_Aires
       * * `America/Argentina/Catamarca` - America/Argentina/Catamarca
       * * `America/Argentina/Cordoba` - America/Argentina/Cordoba
       * * `America/Argentina/Jujuy` - America/Argentina/Jujuy
       * * `America/Argentina/La_Rioja` - America/Argentina/La_Rioja
       * * `America/Argentina/Mendoza` - America/Argentina/Mendoza
       * * `America/Argentina/Rio_Gallegos` - America/Argentina/Rio_Gallegos
       * * `America/Argentina/Salta` - America/Argentina/Salta
       * * `America/Argentina/San_Juan` - America/Argentina/San_Juan
       * * `America/Argentina/San_Luis` - America/Argentina/San_Luis
       * * `America/Argentina/Tucuman` - America/Argentina/Tucuman
       * * `America/Argentina/Ushuaia` - America/Argentina/Ushuaia
       * * `America/Aruba` - America/Aruba
       * * `America/Asuncion` - America/Asuncion
       * * `America/Atikokan` - America/Atikokan
       * * `America/Bahia` - America/Bahia
       * * `America/Bahia_Banderas` - America/Bahia_Banderas
       * * `America/Barbados` - America/Barbados
       * * `America/Belem` - America/Belem
       * * `America/Belize` - America/Belize
       * * `America/Blanc-Sablon` - America/Blanc-Sablon
       * * `America/Boa_Vista` - America/Boa_Vista
       * * `America/Bogota` - America/Bogota
       * * `America/Boise` - America/Boise
       * * `America/Cambridge_Bay` - America/Cambridge_Bay
       * * `America/Campo_Grande` - America/Campo_Grande
       * * `America/Cancun` - America/Cancun
       * * `America/Caracas` - America/Caracas
       * * `America/Cayenne` - America/Cayenne
       * * `America/Cayman` - America/Cayman
       * * `America/Chicago` - America/Chicago
       * * `America/Chihuahua` - America/Chihuahua
       * * `America/Ciudad_Juarez` - America/Ciudad_Juarez
       * * `America/Costa_Rica` - America/Costa_Rica
       * * `America/Creston` - America/Creston
       * * `America/Cuiaba` - America/Cuiaba
       * * `America/Curacao` - America/Curacao
       * * `America/Danmarkshavn` - America/Danmarkshavn
       * * `America/Dawson` - America/Dawson
       * * `America/Dawson_Creek` - America/Dawson_Creek
       * * `America/Denver` - America/Denver
       * * `America/Detroit` - America/Detroit
       * * `America/Dominica` - America/Dominica
       * * `America/Edmonton` - America/Edmonton
       * * `America/Eirunepe` - America/Eirunepe
       * * `America/El_Salvador` - America/El_Salvador
       * * `America/Fort_Nelson` - America/Fort_Nelson
       * * `America/Fortaleza` - America/Fortaleza
       * * `America/Glace_Bay` - America/Glace_Bay
       * * `America/Goose_Bay` - America/Goose_Bay
       * * `America/Grand_Turk` - America/Grand_Turk
       * * `America/Grenada` - America/Grenada
       * * `America/Guadeloupe` - America/Guadeloupe
       * * `America/Guatemala` - America/Guatemala
       * * `America/Guayaquil` - America/Guayaquil
       * * `America/Guyana` - America/Guyana
       * * `America/Halifax` - America/Halifax
       * * `America/Havana` - America/Havana
       * * `America/Hermosillo` - America/Hermosillo
       * * `America/Indiana/Indianapolis` - America/Indiana/Indianapolis
       * * `America/Indiana/Knox` - America/Indiana/Knox
       * * `America/Indiana/Marengo` - America/Indiana/Marengo
       * * `America/Indiana/Petersburg` - America/Indiana/Petersburg
       * * `America/Indiana/Tell_City` - America/Indiana/Tell_City
       * * `America/Indiana/Vevay` - America/Indiana/Vevay
       * * `America/Indiana/Vincennes` - America/Indiana/Vincennes
       * * `America/Indiana/Winamac` - America/Indiana/Winamac
       * * `America/Inuvik` - America/Inuvik
       * * `America/Iqaluit` - America/Iqaluit
       * * `America/Jamaica` - America/Jamaica
       * * `America/Juneau` - America/Juneau
       * * `America/Kentucky/Louisville` - America/Kentucky/Louisville
       * * `America/Kentucky/Monticello` - America/Kentucky/Monticello
       * * `America/Kralendijk` - America/Kralendijk
       * * `America/La_Paz` - America/La_Paz
       * * `America/Lima` - America/Lima
       * * `America/Los_Angeles` - America/Los_Angeles
       * * `America/Lower_Princes` - America/Lower_Princes
       * * `America/Maceio` - America/Maceio
       * * `America/Managua` - America/Managua
       * * `America/Manaus` - America/Manaus
       * * `America/Marigot` - America/Marigot
       * * `America/Martinique` - America/Martinique
       * * `America/Matamoros` - America/Matamoros
       * * `America/Mazatlan` - America/Mazatlan
       * * `America/Menominee` - America/Menominee
       * * `America/Merida` - America/Merida
       * * `America/Metlakatla` - America/Metlakatla
       * * `America/Mexico_City` - America/Mexico_City
       * * `America/Miquelon` - America/Miquelon
       * * `America/Moncton` - America/Moncton
       * * `America/Monterrey` - America/Monterrey
       * * `America/Montevideo` - America/Montevideo
       * * `America/Montserrat` - America/Montserrat
       * * `America/Nassau` - America/Nassau
       * * `America/New_York` - America/New_York
       * * `America/Nome` - America/Nome
       * * `America/Noronha` - America/Noronha
       * * `America/North_Dakota/Beulah` - America/North_Dakota/Beulah
       * * `America/North_Dakota/Center` - America/North_Dakota/Center
       * * `America/North_Dakota/New_Salem` - America/North_Dakota/New_Salem
       * * `America/Nuuk` - America/Nuuk
       * * `America/Ojinaga` - America/Ojinaga
       * * `America/Panama` - America/Panama
       * * `America/Paramaribo` - America/Paramaribo
       * * `America/Phoenix` - America/Phoenix
       * * `America/Port-au-Prince` - America/Port-au-Prince
       * * `America/PortOf_Spain` - America/PortOf_Spain
       * * `America/Porto_Velho` - America/Porto_Velho
       * * `America/Puerto_Rico` - America/Puerto_Rico
       * * `America/Punta_Arenas` - America/Punta_Arenas
       * * `America/Rankin_Inlet` - America/Rankin_Inlet
       * * `America/Recife` - America/Recife
       * * `America/Regina` - America/Regina
       * * `America/Resolute` - America/Resolute
       * * `America/Rio_Branco` - America/Rio_Branco
       * * `America/Santarem` - America/Santarem
       * * `America/Santiago` - America/Santiago
       * * `America/Santo_Domingo` - America/Santo_Domingo
       * * `America/Sao_Paulo` - America/Sao_Paulo
       * * `America/Scoresbysund` - America/Scoresbysund
       * * `America/Sitka` - America/Sitka
       * * `America/St_Barthelemy` - America/St_Barthelemy
       * * `America/St_Johns` - America/St_Johns
       * * `America/St_Kitts` - America/St_Kitts
       * * `America/St_Lucia` - America/St_Lucia
       * * `America/St_Thomas` - America/St_Thomas
       * * `America/St_Vincent` - America/St_Vincent
       * * `America/Swift_Current` - America/Swift_Current
       * * `America/Tegucigalpa` - America/Tegucigalpa
       * * `America/Thule` - America/Thule
       * * `America/Tijuana` - America/Tijuana
       * * `America/Toronto` - America/Toronto
       * * `America/Tortola` - America/Tortola
       * * `America/Vancouver` - America/Vancouver
       * * `America/Whitehorse` - America/Whitehorse
       * * `America/Winnipeg` - America/Winnipeg
       * * `America/Yakutat` - America/Yakutat
       * * `America/Yellowknife` - America/Yellowknife
       * * `Antarctica/Casey` - Antarctica/Casey
       * * `Antarctica/Davis` - Antarctica/Davis
       * * `Antarctica/DumontDUrville` - Antarctica/DumontDUrville
       * * `Antarctica/Macquarie` - Antarctica/Macquarie
       * * `Antarctica/Mawson` - Antarctica/Mawson
       * * `Antarctica/McMurdo` - Antarctica/McMurdo
       * * `Antarctica/Palmer` - Antarctica/Palmer
       * * `Antarctica/Rothera` - Antarctica/Rothera
       * * `Antarctica/Syowa` - Antarctica/Syowa
       * * `Antarctica/Troll` - Antarctica/Troll
       * * `Antarctica/Vostok` - Antarctica/Vostok
       * * `Arctic/Longyearbyen` - Arctic/Longyearbyen
       * * `Asia/Aden` - Asia/Aden
       * * `Asia/Almaty` - Asia/Almaty
       * * `Asia/Amman` - Asia/Amman
       * * `Asia/Anadyr` - Asia/Anadyr
       * * `Asia/Aqtau` - Asia/Aqtau
       * * `Asia/Aqtobe` - Asia/Aqtobe
       * * `Asia/Ashgabat` - Asia/Ashgabat
       * * `Asia/Atyrau` - Asia/Atyrau
       * * `Asia/Baghdad` - Asia/Baghdad
       * * `Asia/Bahrain` - Asia/Bahrain
       * * `Asia/Baku` - Asia/Baku
       * * `Asia/Bangkok` - Asia/Bangkok
       * * `Asia/Barnaul` - Asia/Barnaul
       * * `Asia/Beirut` - Asia/Beirut
       * * `Asia/Bishkek` - Asia/Bishkek
       * * `Asia/Brunei` - Asia/Brunei
       * * `Asia/Chita` - Asia/Chita
       * * `Asia/Choibalsan` - Asia/Choibalsan
       * * `Asia/Colombo` - Asia/Colombo
       * * `Asia/Damascus` - Asia/Damascus
       * * `Asia/Dhaka` - Asia/Dhaka
       * * `Asia/Dili` - Asia/Dili
       * * `Asia/Dubai` - Asia/Dubai
       * * `Asia/Dushanbe` - Asia/Dushanbe
       * * `Asia/Famagusta` - Asia/Famagusta
       * * `Asia/Gaza` - Asia/Gaza
       * * `Asia/Hebron` - Asia/Hebron
       * * `Asia/Ho_Chi_Minh` - Asia/Ho_Chi_Minh
       * * `Asia/Hong_Kong` - Asia/Hong_Kong
       * * `Asia/Hovd` - Asia/Hovd
       * * `Asia/Irkutsk` - Asia/Irkutsk
       * * `Asia/Jakarta` - Asia/Jakarta
       * * `Asia/Jayapura` - Asia/Jayapura
       * * `Asia/Jerusalem` - Asia/Jerusalem
       * * `Asia/Kabul` - Asia/Kabul
       * * `Asia/Kamchatka` - Asia/Kamchatka
       * * `Asia/Karachi` - Asia/Karachi
       * * `Asia/Kathmandu` - Asia/Kathmandu
       * * `Asia/Khandyga` - Asia/Khandyga
       * * `Asia/Kolkata` - Asia/Kolkata
       * * `Asia/Krasnoyarsk` - Asia/Krasnoyarsk
       * * `Asia/Kuala_Lumpur` - Asia/Kuala_Lumpur
       * * `Asia/Kuching` - Asia/Kuching
       * * `Asia/Kuwait` - Asia/Kuwait
       * * `Asia/Macau` - Asia/Macau
       * * `Asia/Magadan` - Asia/Magadan
       * * `Asia/Makassar` - Asia/Makassar
       * * `Asia/Manila` - Asia/Manila
       * * `Asia/Muscat` - Asia/Muscat
       * * `Asia/Nicosia` - Asia/Nicosia
       * * `Asia/Novokuznetsk` - Asia/Novokuznetsk
       * * `Asia/Novosibirsk` - Asia/Novosibirsk
       * * `Asia/Omsk` - Asia/Omsk
       * * `Asia/Oral` - Asia/Oral
       * * `Asia/Phnom_Penh` - Asia/Phnom_Penh
       * * `Asia/Pontianak` - Asia/Pontianak
       * * `Asia/Pyongyang` - Asia/Pyongyang
       * * `Asia/Qatar` - Asia/Qatar
       * * `Asia/Qostanay` - Asia/Qostanay
       * * `Asia/Qyzylorda` - Asia/Qyzylorda
       * * `Asia/Riyadh` - Asia/Riyadh
       * * `Asia/Sakhalin` - Asia/Sakhalin
       * * `Asia/Samarkand` - Asia/Samarkand
       * * `Asia/Seoul` - Asia/Seoul
       * * `Asia/Shanghai` - Asia/Shanghai
       * * `Asia/Singapore` - Asia/Singapore
       * * `Asia/Srednekolymsk` - Asia/Srednekolymsk
       * * `Asia/Taipei` - Asia/Taipei
       * * `Asia/Tashkent` - Asia/Tashkent
       * * `Asia/Tbilisi` - Asia/Tbilisi
       * * `Asia/Tehran` - Asia/Tehran
       * * `Asia/Thimphu` - Asia/Thimphu
       * * `Asia/Tokyo` - Asia/Tokyo
       * * `Asia/Tomsk` - Asia/Tomsk
       * * `Asia/Ulaanbaatar` - Asia/Ulaanbaatar
       * * `Asia/Urumqi` - Asia/Urumqi
       * * `Asia/Ust-Nera` - Asia/Ust-Nera
       * * `Asia/Vientiane` - Asia/Vientiane
       * * `Asia/Vladivostok` - Asia/Vladivostok
       * * `Asia/Yakutsk` - Asia/Yakutsk
       * * `Asia/Yangon` - Asia/Yangon
       * * `Asia/Yekaterinburg` - Asia/Yekaterinburg
       * * `Asia/Yerevan` - Asia/Yerevan
       * * `Atlantic/Azores` - Atlantic/Azores
       * * `Atlantic/Bermuda` - Atlantic/Bermuda
       * * `Atlantic/Canary` - Atlantic/Canary
       * * `Atlantic/Cape_Verde` - Atlantic/Cape_Verde
       * * `Atlantic/Faroe` - Atlantic/Faroe
       * * `Atlantic/Madeira` - Atlantic/Madeira
       * * `Atlantic/Reykjavik` - Atlantic/Reykjavik
       * * `Atlantic/South_Georgia` - Atlantic/South_Georgia
       * * `Atlantic/St_Helena` - Atlantic/St_Helena
       * * `Atlantic/Stanley` - Atlantic/Stanley
       * * `Australia/Adelaide` - Australia/Adelaide
       * * `Australia/Brisbane` - Australia/Brisbane
       * * `Australia/Broken_Hill` - Australia/Broken_Hill
       * * `Australia/Darwin` - Australia/Darwin
       * * `Australia/Eucla` - Australia/Eucla
       * * `Australia/Hobart` - Australia/Hobart
       * * `Australia/Lindeman` - Australia/Lindeman
       * * `Australia/Lord_Howe` - Australia/Lord_Howe
       * * `Australia/Melbourne` - Australia/Melbourne
       * * `Australia/Perth` - Australia/Perth
       * * `Australia/Sydney` - Australia/Sydney
       * * `Canada/Atlantic` - Canada/Atlantic
       * * `Canada/Central` - Canada/Central
       * * `Canada/Eastern` - Canada/Eastern
       * * `Canada/Mountain` - Canada/Mountain
       * * `Canada/Newfoundland` - Canada/Newfoundland
       * * `Canada/Pacific` - Canada/Pacific
       * * `Europe/Amsterdam` - Europe/Amsterdam
       * * `Europe/Andorra` - Europe/Andorra
       * * `Europe/Astrakhan` - Europe/Astrakhan
       * * `Europe/Athens` - Europe/Athens
       * * `Europe/Belgrade` - Europe/Belgrade
       * * `Europe/Berlin` - Europe/Berlin
       * * `Europe/Bratislava` - Europe/Bratislava
       * * `Europe/Brussels` - Europe/Brussels
       * * `Europe/Bucharest` - Europe/Bucharest
       * * `Europe/Budapest` - Europe/Budapest
       * * `Europe/Busingen` - Europe/Busingen
       * * `Europe/Chisinau` - Europe/Chisinau
       * * `Europe/Copenhagen` - Europe/Copenhagen
       * * `Europe/Dublin` - Europe/Dublin
       * * `Europe/Gibraltar` - Europe/Gibraltar
       * * `Europe/Guernsey` - Europe/Guernsey
       * * `Europe/Helsinki` - Europe/Helsinki
       * * `Europe/IsleOf_Man` - Europe/IsleOf_Man
       * * `Europe/Istanbul` - Europe/Istanbul
       * * `Europe/Jersey` - Europe/Jersey
       * * `Europe/Kaliningrad` - Europe/Kaliningrad
       * * `Europe/Kirov` - Europe/Kirov
       * * `Europe/Kyiv` - Europe/Kyiv
       * * `Europe/Lisbon` - Europe/Lisbon
       * * `Europe/Ljubljana` - Europe/Ljubljana
       * * `Europe/London` - Europe/London
       * * `Europe/Luxembourg` - Europe/Luxembourg
       * * `Europe/Madrid` - Europe/Madrid
       * * `Europe/Malta` - Europe/Malta
       * * `Europe/Mariehamn` - Europe/Mariehamn
       * * `Europe/Minsk` - Europe/Minsk
       * * `Europe/Monaco` - Europe/Monaco
       * * `Europe/Moscow` - Europe/Moscow
       * * `Europe/Oslo` - Europe/Oslo
       * * `Europe/Paris` - Europe/Paris
       * * `Europe/Podgorica` - Europe/Podgorica
       * * `Europe/Prague` - Europe/Prague
       * * `Europe/Riga` - Europe/Riga
       * * `Europe/Rome` - Europe/Rome
       * * `Europe/Samara` - Europe/Samara
       * * `Europe/San_Marino` - Europe/San_Marino
       * * `Europe/Sarajevo` - Europe/Sarajevo
       * * `Europe/Saratov` - Europe/Saratov
       * * `Europe/Simferopol` - Europe/Simferopol
       * * `Europe/Skopje` - Europe/Skopje
       * * `Europe/Sofia` - Europe/Sofia
       * * `Europe/Stockholm` - Europe/Stockholm
       * * `Europe/Tallinn` - Europe/Tallinn
       * * `Europe/Tirane` - Europe/Tirane
       * * `Europe/Ulyanovsk` - Europe/Ulyanovsk
       * * `Europe/Vaduz` - Europe/Vaduz
       * * `Europe/Vatican` - Europe/Vatican
       * * `Europe/Vienna` - Europe/Vienna
       * * `Europe/Vilnius` - Europe/Vilnius
       * * `Europe/Volgograd` - Europe/Volgograd
       * * `Europe/Warsaw` - Europe/Warsaw
       * * `Europe/Zagreb` - Europe/Zagreb
       * * `Europe/Zurich` - Europe/Zurich
       * * `GMT` - GMT
       * * `Indian/Antananarivo` - Indian/Antananarivo
       * * `Indian/Chagos` - Indian/Chagos
       * * `Indian/Christmas` - Indian/Christmas
       * * `Indian/Cocos` - Indian/Cocos
       * * `Indian/Comoro` - Indian/Comoro
       * * `Indian/Kerguelen` - Indian/Kerguelen
       * * `Indian/Mahe` - Indian/Mahe
       * * `Indian/Maldives` - Indian/Maldives
       * * `Indian/Mauritius` - Indian/Mauritius
       * * `Indian/Mayotte` - Indian/Mayotte
       * * `Indian/Reunion` - Indian/Reunion
       * * `Pacific/Apia` - Pacific/Apia
       * * `Pacific/Auckland` - Pacific/Auckland
       * * `Pacific/Bougainville` - Pacific/Bougainville
       * * `Pacific/Chatham` - Pacific/Chatham
       * * `Pacific/Chuuk` - Pacific/Chuuk
       * * `Pacific/Easter` - Pacific/Easter
       * * `Pacific/Efate` - Pacific/Efate
       * * `Pacific/Fakaofo` - Pacific/Fakaofo
       * * `Pacific/Fiji` - Pacific/Fiji
       * * `Pacific/Funafuti` - Pacific/Funafuti
       * * `Pacific/Galapagos` - Pacific/Galapagos
       * * `Pacific/Gambier` - Pacific/Gambier
       * * `Pacific/Guadalcanal` - Pacific/Guadalcanal
       * * `Pacific/Guam` - Pacific/Guam
       * * `Pacific/Honolulu` - Pacific/Honolulu
       * * `Pacific/Kanton` - Pacific/Kanton
       * * `Pacific/Kiritimati` - Pacific/Kiritimati
       * * `Pacific/Kosrae` - Pacific/Kosrae
       * * `Pacific/Kwajalein` - Pacific/Kwajalein
       * * `Pacific/Majuro` - Pacific/Majuro
       * * `Pacific/Marquesas` - Pacific/Marquesas
       * * `Pacific/Midway` - Pacific/Midway
       * * `Pacific/Nauru` - Pacific/Nauru
       * * `Pacific/Niue` - Pacific/Niue
       * * `Pacific/Norfolk` - Pacific/Norfolk
       * * `Pacific/Noumea` - Pacific/Noumea
       * * `Pacific/Pago_Pago` - Pacific/Pago_Pago
       * * `Pacific/Palau` - Pacific/Palau
       * * `Pacific/Pitcairn` - Pacific/Pitcairn
       * * `Pacific/Pohnpei` - Pacific/Pohnpei
       * * `Pacific/Port_Moresby` - Pacific/Port_Moresby
       * * `Pacific/Rarotonga` - Pacific/Rarotonga
       * * `Pacific/Saipan` - Pacific/Saipan
       * * `Pacific/Tahiti` - Pacific/Tahiti
       * * `Pacific/Tarawa` - Pacific/Tarawa
       * * `Pacific/Tongatapu` - Pacific/Tongatapu
       * * `Pacific/Wake` - Pacific/Wake
       * * `Pacific/Wallis` - Pacific/Wallis
       * * `US/Alaska` - US/Alaska
       * * `US/Arizona` - US/Arizona
       * * `US/Central` - US/Central
       * * `US/Eastern` - US/Eastern
       * * `US/Hawaii` - US/Hawaii
       * * `US/Mountain` - US/Mountain
       * * `US/Pacific` - US/Pacific
       * * `UTC` - UTC 
       * @enum {string}
       */
      timezone: "Africa/Abidjan" | "Africa/Accra" | "Africa/Addis_Ababa" | "Africa/Algiers" | "Africa/Asmara" | "Africa/Bamako" | "Africa/Bangui" | "Africa/Banjul" | "Africa/Bissau" | "Africa/Blantyre" | "Africa/Brazzaville" | "Africa/Bujumbura" | "Africa/Cairo" | "Africa/Casablanca" | "Africa/Ceuta" | "Africa/Conakry" | "Africa/Dakar" | "Africa/DarEs_Salaam" | "Africa/Djibouti" | "Africa/Douala" | "Africa/El_Aaiun" | "Africa/Freetown" | "Africa/Gaborone" | "Africa/Harare" | "Africa/Johannesburg" | "Africa/Juba" | "Africa/Kampala" | "Africa/Khartoum" | "Africa/Kigali" | "Africa/Kinshasa" | "Africa/Lagos" | "Africa/Libreville" | "Africa/Lome" | "Africa/Luanda" | "Africa/Lubumbashi" | "Africa/Lusaka" | "Africa/Malabo" | "Africa/Maputo" | "Africa/Maseru" | "Africa/Mbabane" | "Africa/Mogadishu" | "Africa/Monrovia" | "Africa/Nairobi" | "Africa/Ndjamena" | "Africa/Niamey" | "Africa/Nouakchott" | "Africa/Ouagadougou" | "Africa/Porto-Novo" | "Africa/Sao_Tome" | "Africa/Tripoli" | "Africa/Tunis" | "Africa/Windhoek" | "America/Adak" | "America/Anchorage" | "America/Anguilla" | "America/Antigua" | "America/Araguaina" | "America/Argentina/Buenos_Aires" | "America/Argentina/Catamarca" | "America/Argentina/Cordoba" | "America/Argentina/Jujuy" | "America/Argentina/La_Rioja" | "America/Argentina/Mendoza" | "America/Argentina/Rio_Gallegos" | "America/Argentina/Salta" | "America/Argentina/San_Juan" | "America/Argentina/San_Luis" | "America/Argentina/Tucuman" | "America/Argentina/Ushuaia" | "America/Aruba" | "America/Asuncion" | "America/Atikokan" | "America/Bahia" | "America/Bahia_Banderas" | "America/Barbados" | "America/Belem" | "America/Belize" | "America/Blanc-Sablon" | "America/Boa_Vista" | "America/Bogota" | "America/Boise" | "America/Cambridge_Bay" | "America/Campo_Grande" | "America/Cancun" | "America/Caracas" | "America/Cayenne" | "America/Cayman" | "America/Chicago" | "America/Chihuahua" | "America/Ciudad_Juarez" | "America/Costa_Rica" | "America/Creston" | "America/Cuiaba" | "America/Curacao" | "America/Danmarkshavn" | "America/Dawson" | "America/Dawson_Creek" | "America/Denver" | "America/Detroit" | "America/Dominica" | "America/Edmonton" | "America/Eirunepe" | "America/El_Salvador" | "America/Fort_Nelson" | "America/Fortaleza" | "America/Glace_Bay" | "America/Goose_Bay" | "America/Grand_Turk" | "America/Grenada" | "America/Guadeloupe" | "America/Guatemala" | "America/Guayaquil" | "America/Guyana" | "America/Halifax" | "America/Havana" | "America/Hermosillo" | "America/Indiana/Indianapolis" | "America/Indiana/Knox" | "America/Indiana/Marengo" | "America/Indiana/Petersburg" | "America/Indiana/Tell_City" | "America/Indiana/Vevay" | "America/Indiana/Vincennes" | "America/Indiana/Winamac" | "America/Inuvik" | "America/Iqaluit" | "America/Jamaica" | "America/Juneau" | "America/Kentucky/Louisville" | "America/Kentucky/Monticello" | "America/Kralendijk" | "America/La_Paz" | "America/Lima" | "America/Los_Angeles" | "America/Lower_Princes" | "America/Maceio" | "America/Managua" | "America/Manaus" | "America/Marigot" | "America/Martinique" | "America/Matamoros" | "America/Mazatlan" | "America/Menominee" | "America/Merida" | "America/Metlakatla" | "America/Mexico_City" | "America/Miquelon" | "America/Moncton" | "America/Monterrey" | "America/Montevideo" | "America/Montserrat" | "America/Nassau" | "America/New_York" | "America/Nome" | "America/Noronha" | "America/North_Dakota/Beulah" | "America/North_Dakota/Center" | "America/North_Dakota/New_Salem" | "America/Nuuk" | "America/Ojinaga" | "America/Panama" | "America/Paramaribo" | "America/Phoenix" | "America/Port-au-Prince" | "America/PortOf_Spain" | "America/Porto_Velho" | "America/Puerto_Rico" | "America/Punta_Arenas" | "America/Rankin_Inlet" | "America/Recife" | "America/Regina" | "America/Resolute" | "America/Rio_Branco" | "America/Santarem" | "America/Santiago" | "America/Santo_Domingo" | "America/Sao_Paulo" | "America/Scoresbysund" | "America/Sitka" | "America/St_Barthelemy" | "America/St_Johns" | "America/St_Kitts" | "America/St_Lucia" | "America/St_Thomas" | "America/St_Vincent" | "America/Swift_Current" | "America/Tegucigalpa" | "America/Thule" | "America/Tijuana" | "America/Toronto" | "America/Tortola" | "America/Vancouver" | "America/Whitehorse" | "America/Winnipeg" | "America/Yakutat" | "America/Yellowknife" | "Antarctica/Casey" | "Antarctica/Davis" | "Antarctica/DumontDUrville" | "Antarctica/Macquarie" | "Antarctica/Mawson" | "Antarctica/McMurdo" | "Antarctica/Palmer" | "Antarctica/Rothera" | "Antarctica/Syowa" | "Antarctica/Troll" | "Antarctica/Vostok" | "Arctic/Longyearbyen" | "Asia/Aden" | "Asia/Almaty" | "Asia/Amman" | "Asia/Anadyr" | "Asia/Aqtau" | "Asia/Aqtobe" | "Asia/Ashgabat" | "Asia/Atyrau" | "Asia/Baghdad" | "Asia/Bahrain" | "Asia/Baku" | "Asia/Bangkok" | "Asia/Barnaul" | "Asia/Beirut" | "Asia/Bishkek" | "Asia/Brunei" | "Asia/Chita" | "Asia/Choibalsan" | "Asia/Colombo" | "Asia/Damascus" | "Asia/Dhaka" | "Asia/Dili" | "Asia/Dubai" | "Asia/Dushanbe" | "Asia/Famagusta" | "Asia/Gaza" | "Asia/Hebron" | "Asia/Ho_Chi_Minh" | "Asia/Hong_Kong" | "Asia/Hovd" | "Asia/Irkutsk" | "Asia/Jakarta" | "Asia/Jayapura" | "Asia/Jerusalem" | "Asia/Kabul" | "Asia/Kamchatka" | "Asia/Karachi" | "Asia/Kathmandu" | "Asia/Khandyga" | "Asia/Kolkata" | "Asia/Krasnoyarsk" | "Asia/Kuala_Lumpur" | "Asia/Kuching" | "Asia/Kuwait" | "Asia/Macau" | "Asia/Magadan" | "Asia/Makassar" | "Asia/Manila" | "Asia/Muscat" | "Asia/Nicosia" | "Asia/Novokuznetsk" | "Asia/Novosibirsk" | "Asia/Omsk" | "Asia/Oral" | "Asia/Phnom_Penh" | "Asia/Pontianak" | "Asia/Pyongyang" | "Asia/Qatar" | "Asia/Qostanay" | "Asia/Qyzylorda" | "Asia/Riyadh" | "Asia/Sakhalin" | "Asia/Samarkand" | "Asia/Seoul" | "Asia/Shanghai" | "Asia/Singapore" | "Asia/Srednekolymsk" | "Asia/Taipei" | "Asia/Tashkent" | "Asia/Tbilisi" | "Asia/Tehran" | "Asia/Thimphu" | "Asia/Tokyo" | "Asia/Tomsk" | "Asia/Ulaanbaatar" | "Asia/Urumqi" | "Asia/Ust-Nera" | "Asia/Vientiane" | "Asia/Vladivostok" | "Asia/Yakutsk" | "Asia/Yangon" | "Asia/Yekaterinburg" | "Asia/Yerevan" | "Atlantic/Azores" | "Atlantic/Bermuda" | "Atlantic/Canary" | "Atlantic/Cape_Verde" | "Atlantic/Faroe" | "Atlantic/Madeira" | "Atlantic/Reykjavik" | "Atlantic/South_Georgia" | "Atlantic/St_Helena" | "Atlantic/Stanley" | "Australia/Adelaide" | "Australia/Brisbane" | "Australia/Broken_Hill" | "Australia/Darwin" | "Australia/Eucla" | "Australia/Hobart" | "Australia/Lindeman" | "Australia/Lord_Howe" | "Australia/Melbourne" | "Australia/Perth" | "Australia/Sydney" | "Canada/Atlantic" | "Canada/Central" | "Canada/Eastern" | "Canada/Mountain" | "Canada/Newfoundland" | "Canada/Pacific" | "Europe/Amsterdam" | "Europe/Andorra" | "Europe/Astrakhan" | "Europe/Athens" | "Europe/Belgrade" | "Europe/Berlin" | "Europe/Bratislava" | "Europe/Brussels" | "Europe/Bucharest" | "Europe/Budapest" | "Europe/Busingen" | "Europe/Chisinau" | "Europe/Copenhagen" | "Europe/Dublin" | "Europe/Gibraltar" | "Europe/Guernsey" | "Europe/Helsinki" | "Europe/IsleOf_Man" | "Europe/Istanbul" | "Europe/Jersey" | "Europe/Kaliningrad" | "Europe/Kirov" | "Europe/Kyiv" | "Europe/Lisbon" | "Europe/Ljubljana" | "Europe/London" | "Europe/Luxembourg" | "Europe/Madrid" | "Europe/Malta" | "Europe/Mariehamn" | "Europe/Minsk" | "Europe/Monaco" | "Europe/Moscow" | "Europe/Oslo" | "Europe/Paris" | "Europe/Podgorica" | "Europe/Prague" | "Europe/Riga" | "Europe/Rome" | "Europe/Samara" | "Europe/San_Marino" | "Europe/Sarajevo" | "Europe/Saratov" | "Europe/Simferopol" | "Europe/Skopje" | "Europe/Sofia" | "Europe/Stockholm" | "Europe/Tallinn" | "Europe/Tirane" | "Europe/Ulyanovsk" | "Europe/Vaduz" | "Europe/Vatican" | "Europe/Vienna" | "Europe/Vilnius" | "Europe/Volgograd" | "Europe/Warsaw" | "Europe/Zagreb" | "Europe/Zurich" | "GMT" | "Indian/Antananarivo" | "Indian/Chagos" | "Indian/Christmas" | "Indian/Cocos" | "Indian/Comoro" | "Indian/Kerguelen" | "Indian/Mahe" | "Indian/Maldives" | "Indian/Mauritius" | "Indian/Mayotte" | "Indian/Reunion" | "Pacific/Apia" | "Pacific/Auckland" | "Pacific/Bougainville" | "Pacific/Chatham" | "Pacific/Chuuk" | "Pacific/Easter" | "Pacific/Efate" | "Pacific/Fakaofo" | "Pacific/Fiji" | "Pacific/Funafuti" | "Pacific/Galapagos" | "Pacific/Gambier" | "Pacific/Guadalcanal" | "Pacific/Guam" | "Pacific/Honolulu" | "Pacific/Kanton" | "Pacific/Kiritimati" | "Pacific/Kosrae" | "Pacific/Kwajalein" | "Pacific/Majuro" | "Pacific/Marquesas" | "Pacific/Midway" | "Pacific/Nauru" | "Pacific/Niue" | "Pacific/Norfolk" | "Pacific/Noumea" | "Pacific/Pago_Pago" | "Pacific/Palau" | "Pacific/Pitcairn" | "Pacific/Pohnpei" | "Pacific/Port_Moresby" | "Pacific/Rarotonga" | "Pacific/Saipan" | "Pacific/Tahiti" | "Pacific/Tarawa" | "Pacific/Tongatapu" | "Pacific/Wake" | "Pacific/Wallis" | "US/Alaska" | "US/Arizona" | "US/Central" | "US/Eastern" | "US/Hawaii" | "US/Mountain" | "US/Pacific" | "UTC";
      /** @description A list of tax providers that are enabled for this customer. The list is ordered, meaning we will succesively try to calculate taxes using each provider until we find one that works. */
      taxProviders: readonly ("taxjar" | "lotus" | "netsuite")[];
    };
    CustomerBalanceAdjustment: {
      creditId: string;
      customer: components["schemas"]["LightweightCustomer"];
      /** Format: double */
      amount: number;
      /** Format: double */
      amountRemaining: number;
      currency: components["schemas"]["PricingUnit"];
      description: string | null;
      /** Format: date-time */
      effectiveAt: string;
      /** Format: date-time */
      expiresAt: string | null;
      /**
       * @description * `active` - Active
       * * `inactive` - Inactive 
       * @enum {string}
       */
      status: "active" | "inactive";
      /** Format: double */
      amountPaid: number;
      amountPaidCurrency: components["schemas"]["PricingUnit"] | null;
      drawdowns: readonly (components["schemas"]["CreditDrawdown"])[];
    };
    CustomerBalanceAdjustmentCreateRequest: {
      /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
      customerId: string | null;
      /** Format: double */
      amount: number;
      currencyCode: string;
      description?: string | null;
      /** Format: date-time */
      effectiveAt?: string;
      /** Format: date-time */
      expiresAt?: string | null;
      /** Format: double */
      amountPaid?: number;
      amountPaidCurrencyCode?: string;
    };
    CustomerBalanceAdjustmentUpdateRequest: {
      description?: string | null;
      /** Format: date-time */
      expiresAt?: string | null;
    };
    CustomerBraintreeIntegration: {
      braintreeId: string;
      hasPaymentMethod: boolean;
    };
    CustomerCreateRequest: {
      /** @description The display name of the customer */
      customerName?: string | null;
      /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
      customerId: string | null;
      /**
       * Format: email 
       * @description The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider
       */
      email: string;
      /**
       * @description The payment provider this customer is associated with. Currently, only Stripe is supported.
       * 
       * * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      paymentProvider?: "stripe" | "braintree";
      /** @description The customer's ID in the specified payment provider. Please note that paymentProvider and paymentProviderId are mutually necessary. */
      paymentProviderId?: string | null;
      /** @description Extra metadata for the customer */
      properties?: ({
        [key: string]: unknown | undefined;
      }) | null;
      /** @description The currency code this customer will be invoiced in. Codes are 3 letters, e.g. 'USD'. */
      defaultCurrencyCode?: string;
      /** @deprecated */
      address?: components["schemas"]["AddressRequest"] | null;
      billingAddress?: components["schemas"]["AddressRequest"] | null;
      shippingAddress?: components["schemas"]["AddressRequest"] | null;
      /**
       * Format: double 
       * @description Tax rate as percentage. For example, 10.5 for 10.5%
       */
      taxRate?: number | null;
    };
    CustomerCreatedRequest: {
      payload: components["schemas"]["CustomerRequest"];
    };
    CustomerDeleteResponse: {
      customerId: string;
      /** Format: date-time */
      deleted: string;
      /** Format: email */
      email: string | null;
      numSubscriptionsDeleted: number;
      numAddonsDeleted: number;
    };
    CustomerDetail: {
      defaultCurrency: components["schemas"]["PricingUnit"];
      /**
       * Format: double 
       * @description Tax rate as percentage. For example, 10.5 for 10.5%
       */
      taxRate: number | null;
      crmProviderId: string | null;
      customerId: string;
      /**
       * @description * `salesforce` - salesforce 
       * @enum {string}
       */
      crmProvider: "salesforce";
      /** @description A list of tax providers that are enabled for this customer. The list is ordered, meaning we will succesively try to calculate taxes using each provider until we find one that works. */
      taxProviders: readonly ("taxjar" | "lotus" | "netsuite")[];
      upcomingSubscriptions: readonly (components["schemas"]["SubscriptionRecord"])[];
      /** Format: uri */
      paymentProviderUrl: string | null;
      /** @deprecated */
      address: components["schemas"]["Address"] | null;
      invoices: readonly (components["schemas"]["LightweightInvoiceDetail"])[];
      /** @description A dictionary containing the customer's integrations. Keys are the integration type, and the value is a dictionary containing the integration's properties, which can vary by integration. */
      integrations: components["schemas"]["CustomerIntegrations"];
      hasPaymentMethod: boolean;
      stripeSubscriptions: readonly (components["schemas"]["StripeSubscriptionRecord"])[];
      subscriptions: readonly (components["schemas"]["SubscriptionRecord"])[];
      /** Format: double */
      totalAmountDue: number;
      shippingAddress: components["schemas"]["Address"] | null;
      billingAddress: components["schemas"]["Address"] | null;
      /** @description The display name of the customer */
      customerName: string | null;
      /**
       * @description * `Africa/Abidjan` - Africa/Abidjan
       * * `Africa/Accra` - Africa/Accra
       * * `Africa/Addis_Ababa` - Africa/Addis_Ababa
       * * `Africa/Algiers` - Africa/Algiers
       * * `Africa/Asmara` - Africa/Asmara
       * * `Africa/Bamako` - Africa/Bamako
       * * `Africa/Bangui` - Africa/Bangui
       * * `Africa/Banjul` - Africa/Banjul
       * * `Africa/Bissau` - Africa/Bissau
       * * `Africa/Blantyre` - Africa/Blantyre
       * * `Africa/Brazzaville` - Africa/Brazzaville
       * * `Africa/Bujumbura` - Africa/Bujumbura
       * * `Africa/Cairo` - Africa/Cairo
       * * `Africa/Casablanca` - Africa/Casablanca
       * * `Africa/Ceuta` - Africa/Ceuta
       * * `Africa/Conakry` - Africa/Conakry
       * * `Africa/Dakar` - Africa/Dakar
       * * `Africa/DarEs_Salaam` - Africa/DarEs_Salaam
       * * `Africa/Djibouti` - Africa/Djibouti
       * * `Africa/Douala` - Africa/Douala
       * * `Africa/El_Aaiun` - Africa/El_Aaiun
       * * `Africa/Freetown` - Africa/Freetown
       * * `Africa/Gaborone` - Africa/Gaborone
       * * `Africa/Harare` - Africa/Harare
       * * `Africa/Johannesburg` - Africa/Johannesburg
       * * `Africa/Juba` - Africa/Juba
       * * `Africa/Kampala` - Africa/Kampala
       * * `Africa/Khartoum` - Africa/Khartoum
       * * `Africa/Kigali` - Africa/Kigali
       * * `Africa/Kinshasa` - Africa/Kinshasa
       * * `Africa/Lagos` - Africa/Lagos
       * * `Africa/Libreville` - Africa/Libreville
       * * `Africa/Lome` - Africa/Lome
       * * `Africa/Luanda` - Africa/Luanda
       * * `Africa/Lubumbashi` - Africa/Lubumbashi
       * * `Africa/Lusaka` - Africa/Lusaka
       * * `Africa/Malabo` - Africa/Malabo
       * * `Africa/Maputo` - Africa/Maputo
       * * `Africa/Maseru` - Africa/Maseru
       * * `Africa/Mbabane` - Africa/Mbabane
       * * `Africa/Mogadishu` - Africa/Mogadishu
       * * `Africa/Monrovia` - Africa/Monrovia
       * * `Africa/Nairobi` - Africa/Nairobi
       * * `Africa/Ndjamena` - Africa/Ndjamena
       * * `Africa/Niamey` - Africa/Niamey
       * * `Africa/Nouakchott` - Africa/Nouakchott
       * * `Africa/Ouagadougou` - Africa/Ouagadougou
       * * `Africa/Porto-Novo` - Africa/Porto-Novo
       * * `Africa/Sao_Tome` - Africa/Sao_Tome
       * * `Africa/Tripoli` - Africa/Tripoli
       * * `Africa/Tunis` - Africa/Tunis
       * * `Africa/Windhoek` - Africa/Windhoek
       * * `America/Adak` - America/Adak
       * * `America/Anchorage` - America/Anchorage
       * * `America/Anguilla` - America/Anguilla
       * * `America/Antigua` - America/Antigua
       * * `America/Araguaina` - America/Araguaina
       * * `America/Argentina/Buenos_Aires` - America/Argentina/Buenos_Aires
       * * `America/Argentina/Catamarca` - America/Argentina/Catamarca
       * * `America/Argentina/Cordoba` - America/Argentina/Cordoba
       * * `America/Argentina/Jujuy` - America/Argentina/Jujuy
       * * `America/Argentina/La_Rioja` - America/Argentina/La_Rioja
       * * `America/Argentina/Mendoza` - America/Argentina/Mendoza
       * * `America/Argentina/Rio_Gallegos` - America/Argentina/Rio_Gallegos
       * * `America/Argentina/Salta` - America/Argentina/Salta
       * * `America/Argentina/San_Juan` - America/Argentina/San_Juan
       * * `America/Argentina/San_Luis` - America/Argentina/San_Luis
       * * `America/Argentina/Tucuman` - America/Argentina/Tucuman
       * * `America/Argentina/Ushuaia` - America/Argentina/Ushuaia
       * * `America/Aruba` - America/Aruba
       * * `America/Asuncion` - America/Asuncion
       * * `America/Atikokan` - America/Atikokan
       * * `America/Bahia` - America/Bahia
       * * `America/Bahia_Banderas` - America/Bahia_Banderas
       * * `America/Barbados` - America/Barbados
       * * `America/Belem` - America/Belem
       * * `America/Belize` - America/Belize
       * * `America/Blanc-Sablon` - America/Blanc-Sablon
       * * `America/Boa_Vista` - America/Boa_Vista
       * * `America/Bogota` - America/Bogota
       * * `America/Boise` - America/Boise
       * * `America/Cambridge_Bay` - America/Cambridge_Bay
       * * `America/Campo_Grande` - America/Campo_Grande
       * * `America/Cancun` - America/Cancun
       * * `America/Caracas` - America/Caracas
       * * `America/Cayenne` - America/Cayenne
       * * `America/Cayman` - America/Cayman
       * * `America/Chicago` - America/Chicago
       * * `America/Chihuahua` - America/Chihuahua
       * * `America/Ciudad_Juarez` - America/Ciudad_Juarez
       * * `America/Costa_Rica` - America/Costa_Rica
       * * `America/Creston` - America/Creston
       * * `America/Cuiaba` - America/Cuiaba
       * * `America/Curacao` - America/Curacao
       * * `America/Danmarkshavn` - America/Danmarkshavn
       * * `America/Dawson` - America/Dawson
       * * `America/Dawson_Creek` - America/Dawson_Creek
       * * `America/Denver` - America/Denver
       * * `America/Detroit` - America/Detroit
       * * `America/Dominica` - America/Dominica
       * * `America/Edmonton` - America/Edmonton
       * * `America/Eirunepe` - America/Eirunepe
       * * `America/El_Salvador` - America/El_Salvador
       * * `America/Fort_Nelson` - America/Fort_Nelson
       * * `America/Fortaleza` - America/Fortaleza
       * * `America/Glace_Bay` - America/Glace_Bay
       * * `America/Goose_Bay` - America/Goose_Bay
       * * `America/Grand_Turk` - America/Grand_Turk
       * * `America/Grenada` - America/Grenada
       * * `America/Guadeloupe` - America/Guadeloupe
       * * `America/Guatemala` - America/Guatemala
       * * `America/Guayaquil` - America/Guayaquil
       * * `America/Guyana` - America/Guyana
       * * `America/Halifax` - America/Halifax
       * * `America/Havana` - America/Havana
       * * `America/Hermosillo` - America/Hermosillo
       * * `America/Indiana/Indianapolis` - America/Indiana/Indianapolis
       * * `America/Indiana/Knox` - America/Indiana/Knox
       * * `America/Indiana/Marengo` - America/Indiana/Marengo
       * * `America/Indiana/Petersburg` - America/Indiana/Petersburg
       * * `America/Indiana/Tell_City` - America/Indiana/Tell_City
       * * `America/Indiana/Vevay` - America/Indiana/Vevay
       * * `America/Indiana/Vincennes` - America/Indiana/Vincennes
       * * `America/Indiana/Winamac` - America/Indiana/Winamac
       * * `America/Inuvik` - America/Inuvik
       * * `America/Iqaluit` - America/Iqaluit
       * * `America/Jamaica` - America/Jamaica
       * * `America/Juneau` - America/Juneau
       * * `America/Kentucky/Louisville` - America/Kentucky/Louisville
       * * `America/Kentucky/Monticello` - America/Kentucky/Monticello
       * * `America/Kralendijk` - America/Kralendijk
       * * `America/La_Paz` - America/La_Paz
       * * `America/Lima` - America/Lima
       * * `America/Los_Angeles` - America/Los_Angeles
       * * `America/Lower_Princes` - America/Lower_Princes
       * * `America/Maceio` - America/Maceio
       * * `America/Managua` - America/Managua
       * * `America/Manaus` - America/Manaus
       * * `America/Marigot` - America/Marigot
       * * `America/Martinique` - America/Martinique
       * * `America/Matamoros` - America/Matamoros
       * * `America/Mazatlan` - America/Mazatlan
       * * `America/Menominee` - America/Menominee
       * * `America/Merida` - America/Merida
       * * `America/Metlakatla` - America/Metlakatla
       * * `America/Mexico_City` - America/Mexico_City
       * * `America/Miquelon` - America/Miquelon
       * * `America/Moncton` - America/Moncton
       * * `America/Monterrey` - America/Monterrey
       * * `America/Montevideo` - America/Montevideo
       * * `America/Montserrat` - America/Montserrat
       * * `America/Nassau` - America/Nassau
       * * `America/New_York` - America/New_York
       * * `America/Nome` - America/Nome
       * * `America/Noronha` - America/Noronha
       * * `America/North_Dakota/Beulah` - America/North_Dakota/Beulah
       * * `America/North_Dakota/Center` - America/North_Dakota/Center
       * * `America/North_Dakota/New_Salem` - America/North_Dakota/New_Salem
       * * `America/Nuuk` - America/Nuuk
       * * `America/Ojinaga` - America/Ojinaga
       * * `America/Panama` - America/Panama
       * * `America/Paramaribo` - America/Paramaribo
       * * `America/Phoenix` - America/Phoenix
       * * `America/Port-au-Prince` - America/Port-au-Prince
       * * `America/PortOf_Spain` - America/PortOf_Spain
       * * `America/Porto_Velho` - America/Porto_Velho
       * * `America/Puerto_Rico` - America/Puerto_Rico
       * * `America/Punta_Arenas` - America/Punta_Arenas
       * * `America/Rankin_Inlet` - America/Rankin_Inlet
       * * `America/Recife` - America/Recife
       * * `America/Regina` - America/Regina
       * * `America/Resolute` - America/Resolute
       * * `America/Rio_Branco` - America/Rio_Branco
       * * `America/Santarem` - America/Santarem
       * * `America/Santiago` - America/Santiago
       * * `America/Santo_Domingo` - America/Santo_Domingo
       * * `America/Sao_Paulo` - America/Sao_Paulo
       * * `America/Scoresbysund` - America/Scoresbysund
       * * `America/Sitka` - America/Sitka
       * * `America/St_Barthelemy` - America/St_Barthelemy
       * * `America/St_Johns` - America/St_Johns
       * * `America/St_Kitts` - America/St_Kitts
       * * `America/St_Lucia` - America/St_Lucia
       * * `America/St_Thomas` - America/St_Thomas
       * * `America/St_Vincent` - America/St_Vincent
       * * `America/Swift_Current` - America/Swift_Current
       * * `America/Tegucigalpa` - America/Tegucigalpa
       * * `America/Thule` - America/Thule
       * * `America/Tijuana` - America/Tijuana
       * * `America/Toronto` - America/Toronto
       * * `America/Tortola` - America/Tortola
       * * `America/Vancouver` - America/Vancouver
       * * `America/Whitehorse` - America/Whitehorse
       * * `America/Winnipeg` - America/Winnipeg
       * * `America/Yakutat` - America/Yakutat
       * * `America/Yellowknife` - America/Yellowknife
       * * `Antarctica/Casey` - Antarctica/Casey
       * * `Antarctica/Davis` - Antarctica/Davis
       * * `Antarctica/DumontDUrville` - Antarctica/DumontDUrville
       * * `Antarctica/Macquarie` - Antarctica/Macquarie
       * * `Antarctica/Mawson` - Antarctica/Mawson
       * * `Antarctica/McMurdo` - Antarctica/McMurdo
       * * `Antarctica/Palmer` - Antarctica/Palmer
       * * `Antarctica/Rothera` - Antarctica/Rothera
       * * `Antarctica/Syowa` - Antarctica/Syowa
       * * `Antarctica/Troll` - Antarctica/Troll
       * * `Antarctica/Vostok` - Antarctica/Vostok
       * * `Arctic/Longyearbyen` - Arctic/Longyearbyen
       * * `Asia/Aden` - Asia/Aden
       * * `Asia/Almaty` - Asia/Almaty
       * * `Asia/Amman` - Asia/Amman
       * * `Asia/Anadyr` - Asia/Anadyr
       * * `Asia/Aqtau` - Asia/Aqtau
       * * `Asia/Aqtobe` - Asia/Aqtobe
       * * `Asia/Ashgabat` - Asia/Ashgabat
       * * `Asia/Atyrau` - Asia/Atyrau
       * * `Asia/Baghdad` - Asia/Baghdad
       * * `Asia/Bahrain` - Asia/Bahrain
       * * `Asia/Baku` - Asia/Baku
       * * `Asia/Bangkok` - Asia/Bangkok
       * * `Asia/Barnaul` - Asia/Barnaul
       * * `Asia/Beirut` - Asia/Beirut
       * * `Asia/Bishkek` - Asia/Bishkek
       * * `Asia/Brunei` - Asia/Brunei
       * * `Asia/Chita` - Asia/Chita
       * * `Asia/Choibalsan` - Asia/Choibalsan
       * * `Asia/Colombo` - Asia/Colombo
       * * `Asia/Damascus` - Asia/Damascus
       * * `Asia/Dhaka` - Asia/Dhaka
       * * `Asia/Dili` - Asia/Dili
       * * `Asia/Dubai` - Asia/Dubai
       * * `Asia/Dushanbe` - Asia/Dushanbe
       * * `Asia/Famagusta` - Asia/Famagusta
       * * `Asia/Gaza` - Asia/Gaza
       * * `Asia/Hebron` - Asia/Hebron
       * * `Asia/Ho_Chi_Minh` - Asia/Ho_Chi_Minh
       * * `Asia/Hong_Kong` - Asia/Hong_Kong
       * * `Asia/Hovd` - Asia/Hovd
       * * `Asia/Irkutsk` - Asia/Irkutsk
       * * `Asia/Jakarta` - Asia/Jakarta
       * * `Asia/Jayapura` - Asia/Jayapura
       * * `Asia/Jerusalem` - Asia/Jerusalem
       * * `Asia/Kabul` - Asia/Kabul
       * * `Asia/Kamchatka` - Asia/Kamchatka
       * * `Asia/Karachi` - Asia/Karachi
       * * `Asia/Kathmandu` - Asia/Kathmandu
       * * `Asia/Khandyga` - Asia/Khandyga
       * * `Asia/Kolkata` - Asia/Kolkata
       * * `Asia/Krasnoyarsk` - Asia/Krasnoyarsk
       * * `Asia/Kuala_Lumpur` - Asia/Kuala_Lumpur
       * * `Asia/Kuching` - Asia/Kuching
       * * `Asia/Kuwait` - Asia/Kuwait
       * * `Asia/Macau` - Asia/Macau
       * * `Asia/Magadan` - Asia/Magadan
       * * `Asia/Makassar` - Asia/Makassar
       * * `Asia/Manila` - Asia/Manila
       * * `Asia/Muscat` - Asia/Muscat
       * * `Asia/Nicosia` - Asia/Nicosia
       * * `Asia/Novokuznetsk` - Asia/Novokuznetsk
       * * `Asia/Novosibirsk` - Asia/Novosibirsk
       * * `Asia/Omsk` - Asia/Omsk
       * * `Asia/Oral` - Asia/Oral
       * * `Asia/Phnom_Penh` - Asia/Phnom_Penh
       * * `Asia/Pontianak` - Asia/Pontianak
       * * `Asia/Pyongyang` - Asia/Pyongyang
       * * `Asia/Qatar` - Asia/Qatar
       * * `Asia/Qostanay` - Asia/Qostanay
       * * `Asia/Qyzylorda` - Asia/Qyzylorda
       * * `Asia/Riyadh` - Asia/Riyadh
       * * `Asia/Sakhalin` - Asia/Sakhalin
       * * `Asia/Samarkand` - Asia/Samarkand
       * * `Asia/Seoul` - Asia/Seoul
       * * `Asia/Shanghai` - Asia/Shanghai
       * * `Asia/Singapore` - Asia/Singapore
       * * `Asia/Srednekolymsk` - Asia/Srednekolymsk
       * * `Asia/Taipei` - Asia/Taipei
       * * `Asia/Tashkent` - Asia/Tashkent
       * * `Asia/Tbilisi` - Asia/Tbilisi
       * * `Asia/Tehran` - Asia/Tehran
       * * `Asia/Thimphu` - Asia/Thimphu
       * * `Asia/Tokyo` - Asia/Tokyo
       * * `Asia/Tomsk` - Asia/Tomsk
       * * `Asia/Ulaanbaatar` - Asia/Ulaanbaatar
       * * `Asia/Urumqi` - Asia/Urumqi
       * * `Asia/Ust-Nera` - Asia/Ust-Nera
       * * `Asia/Vientiane` - Asia/Vientiane
       * * `Asia/Vladivostok` - Asia/Vladivostok
       * * `Asia/Yakutsk` - Asia/Yakutsk
       * * `Asia/Yangon` - Asia/Yangon
       * * `Asia/Yekaterinburg` - Asia/Yekaterinburg
       * * `Asia/Yerevan` - Asia/Yerevan
       * * `Atlantic/Azores` - Atlantic/Azores
       * * `Atlantic/Bermuda` - Atlantic/Bermuda
       * * `Atlantic/Canary` - Atlantic/Canary
       * * `Atlantic/Cape_Verde` - Atlantic/Cape_Verde
       * * `Atlantic/Faroe` - Atlantic/Faroe
       * * `Atlantic/Madeira` - Atlantic/Madeira
       * * `Atlantic/Reykjavik` - Atlantic/Reykjavik
       * * `Atlantic/South_Georgia` - Atlantic/South_Georgia
       * * `Atlantic/St_Helena` - Atlantic/St_Helena
       * * `Atlantic/Stanley` - Atlantic/Stanley
       * * `Australia/Adelaide` - Australia/Adelaide
       * * `Australia/Brisbane` - Australia/Brisbane
       * * `Australia/Broken_Hill` - Australia/Broken_Hill
       * * `Australia/Darwin` - Australia/Darwin
       * * `Australia/Eucla` - Australia/Eucla
       * * `Australia/Hobart` - Australia/Hobart
       * * `Australia/Lindeman` - Australia/Lindeman
       * * `Australia/Lord_Howe` - Australia/Lord_Howe
       * * `Australia/Melbourne` - Australia/Melbourne
       * * `Australia/Perth` - Australia/Perth
       * * `Australia/Sydney` - Australia/Sydney
       * * `Canada/Atlantic` - Canada/Atlantic
       * * `Canada/Central` - Canada/Central
       * * `Canada/Eastern` - Canada/Eastern
       * * `Canada/Mountain` - Canada/Mountain
       * * `Canada/Newfoundland` - Canada/Newfoundland
       * * `Canada/Pacific` - Canada/Pacific
       * * `Europe/Amsterdam` - Europe/Amsterdam
       * * `Europe/Andorra` - Europe/Andorra
       * * `Europe/Astrakhan` - Europe/Astrakhan
       * * `Europe/Athens` - Europe/Athens
       * * `Europe/Belgrade` - Europe/Belgrade
       * * `Europe/Berlin` - Europe/Berlin
       * * `Europe/Bratislava` - Europe/Bratislava
       * * `Europe/Brussels` - Europe/Brussels
       * * `Europe/Bucharest` - Europe/Bucharest
       * * `Europe/Budapest` - Europe/Budapest
       * * `Europe/Busingen` - Europe/Busingen
       * * `Europe/Chisinau` - Europe/Chisinau
       * * `Europe/Copenhagen` - Europe/Copenhagen
       * * `Europe/Dublin` - Europe/Dublin
       * * `Europe/Gibraltar` - Europe/Gibraltar
       * * `Europe/Guernsey` - Europe/Guernsey
       * * `Europe/Helsinki` - Europe/Helsinki
       * * `Europe/IsleOf_Man` - Europe/IsleOf_Man
       * * `Europe/Istanbul` - Europe/Istanbul
       * * `Europe/Jersey` - Europe/Jersey
       * * `Europe/Kaliningrad` - Europe/Kaliningrad
       * * `Europe/Kirov` - Europe/Kirov
       * * `Europe/Kyiv` - Europe/Kyiv
       * * `Europe/Lisbon` - Europe/Lisbon
       * * `Europe/Ljubljana` - Europe/Ljubljana
       * * `Europe/London` - Europe/London
       * * `Europe/Luxembourg` - Europe/Luxembourg
       * * `Europe/Madrid` - Europe/Madrid
       * * `Europe/Malta` - Europe/Malta
       * * `Europe/Mariehamn` - Europe/Mariehamn
       * * `Europe/Minsk` - Europe/Minsk
       * * `Europe/Monaco` - Europe/Monaco
       * * `Europe/Moscow` - Europe/Moscow
       * * `Europe/Oslo` - Europe/Oslo
       * * `Europe/Paris` - Europe/Paris
       * * `Europe/Podgorica` - Europe/Podgorica
       * * `Europe/Prague` - Europe/Prague
       * * `Europe/Riga` - Europe/Riga
       * * `Europe/Rome` - Europe/Rome
       * * `Europe/Samara` - Europe/Samara
       * * `Europe/San_Marino` - Europe/San_Marino
       * * `Europe/Sarajevo` - Europe/Sarajevo
       * * `Europe/Saratov` - Europe/Saratov
       * * `Europe/Simferopol` - Europe/Simferopol
       * * `Europe/Skopje` - Europe/Skopje
       * * `Europe/Sofia` - Europe/Sofia
       * * `Europe/Stockholm` - Europe/Stockholm
       * * `Europe/Tallinn` - Europe/Tallinn
       * * `Europe/Tirane` - Europe/Tirane
       * * `Europe/Ulyanovsk` - Europe/Ulyanovsk
       * * `Europe/Vaduz` - Europe/Vaduz
       * * `Europe/Vatican` - Europe/Vatican
       * * `Europe/Vienna` - Europe/Vienna
       * * `Europe/Vilnius` - Europe/Vilnius
       * * `Europe/Volgograd` - Europe/Volgograd
       * * `Europe/Warsaw` - Europe/Warsaw
       * * `Europe/Zagreb` - Europe/Zagreb
       * * `Europe/Zurich` - Europe/Zurich
       * * `GMT` - GMT
       * * `Indian/Antananarivo` - Indian/Antananarivo
       * * `Indian/Chagos` - Indian/Chagos
       * * `Indian/Christmas` - Indian/Christmas
       * * `Indian/Cocos` - Indian/Cocos
       * * `Indian/Comoro` - Indian/Comoro
       * * `Indian/Kerguelen` - Indian/Kerguelen
       * * `Indian/Mahe` - Indian/Mahe
       * * `Indian/Maldives` - Indian/Maldives
       * * `Indian/Mauritius` - Indian/Mauritius
       * * `Indian/Mayotte` - Indian/Mayotte
       * * `Indian/Reunion` - Indian/Reunion
       * * `Pacific/Apia` - Pacific/Apia
       * * `Pacific/Auckland` - Pacific/Auckland
       * * `Pacific/Bougainville` - Pacific/Bougainville
       * * `Pacific/Chatham` - Pacific/Chatham
       * * `Pacific/Chuuk` - Pacific/Chuuk
       * * `Pacific/Easter` - Pacific/Easter
       * * `Pacific/Efate` - Pacific/Efate
       * * `Pacific/Fakaofo` - Pacific/Fakaofo
       * * `Pacific/Fiji` - Pacific/Fiji
       * * `Pacific/Funafuti` - Pacific/Funafuti
       * * `Pacific/Galapagos` - Pacific/Galapagos
       * * `Pacific/Gambier` - Pacific/Gambier
       * * `Pacific/Guadalcanal` - Pacific/Guadalcanal
       * * `Pacific/Guam` - Pacific/Guam
       * * `Pacific/Honolulu` - Pacific/Honolulu
       * * `Pacific/Kanton` - Pacific/Kanton
       * * `Pacific/Kiritimati` - Pacific/Kiritimati
       * * `Pacific/Kosrae` - Pacific/Kosrae
       * * `Pacific/Kwajalein` - Pacific/Kwajalein
       * * `Pacific/Majuro` - Pacific/Majuro
       * * `Pacific/Marquesas` - Pacific/Marquesas
       * * `Pacific/Midway` - Pacific/Midway
       * * `Pacific/Nauru` - Pacific/Nauru
       * * `Pacific/Niue` - Pacific/Niue
       * * `Pacific/Norfolk` - Pacific/Norfolk
       * * `Pacific/Noumea` - Pacific/Noumea
       * * `Pacific/Pago_Pago` - Pacific/Pago_Pago
       * * `Pacific/Palau` - Pacific/Palau
       * * `Pacific/Pitcairn` - Pacific/Pitcairn
       * * `Pacific/Pohnpei` - Pacific/Pohnpei
       * * `Pacific/Port_Moresby` - Pacific/Port_Moresby
       * * `Pacific/Rarotonga` - Pacific/Rarotonga
       * * `Pacific/Saipan` - Pacific/Saipan
       * * `Pacific/Tahiti` - Pacific/Tahiti
       * * `Pacific/Tarawa` - Pacific/Tarawa
       * * `Pacific/Tongatapu` - Pacific/Tongatapu
       * * `Pacific/Wake` - Pacific/Wake
       * * `Pacific/Wallis` - Pacific/Wallis
       * * `US/Alaska` - US/Alaska
       * * `US/Arizona` - US/Arizona
       * * `US/Central` - US/Central
       * * `US/Eastern` - US/Eastern
       * * `US/Hawaii` - US/Hawaii
       * * `US/Mountain` - US/Mountain
       * * `US/Pacific` - US/Pacific
       * * `UTC` - UTC 
       * @enum {string}
       */
      timezone: "Africa/Abidjan" | "Africa/Accra" | "Africa/Addis_Ababa" | "Africa/Algiers" | "Africa/Asmara" | "Africa/Bamako" | "Africa/Bangui" | "Africa/Banjul" | "Africa/Bissau" | "Africa/Blantyre" | "Africa/Brazzaville" | "Africa/Bujumbura" | "Africa/Cairo" | "Africa/Casablanca" | "Africa/Ceuta" | "Africa/Conakry" | "Africa/Dakar" | "Africa/DarEs_Salaam" | "Africa/Djibouti" | "Africa/Douala" | "Africa/El_Aaiun" | "Africa/Freetown" | "Africa/Gaborone" | "Africa/Harare" | "Africa/Johannesburg" | "Africa/Juba" | "Africa/Kampala" | "Africa/Khartoum" | "Africa/Kigali" | "Africa/Kinshasa" | "Africa/Lagos" | "Africa/Libreville" | "Africa/Lome" | "Africa/Luanda" | "Africa/Lubumbashi" | "Africa/Lusaka" | "Africa/Malabo" | "Africa/Maputo" | "Africa/Maseru" | "Africa/Mbabane" | "Africa/Mogadishu" | "Africa/Monrovia" | "Africa/Nairobi" | "Africa/Ndjamena" | "Africa/Niamey" | "Africa/Nouakchott" | "Africa/Ouagadougou" | "Africa/Porto-Novo" | "Africa/Sao_Tome" | "Africa/Tripoli" | "Africa/Tunis" | "Africa/Windhoek" | "America/Adak" | "America/Anchorage" | "America/Anguilla" | "America/Antigua" | "America/Araguaina" | "America/Argentina/Buenos_Aires" | "America/Argentina/Catamarca" | "America/Argentina/Cordoba" | "America/Argentina/Jujuy" | "America/Argentina/La_Rioja" | "America/Argentina/Mendoza" | "America/Argentina/Rio_Gallegos" | "America/Argentina/Salta" | "America/Argentina/San_Juan" | "America/Argentina/San_Luis" | "America/Argentina/Tucuman" | "America/Argentina/Ushuaia" | "America/Aruba" | "America/Asuncion" | "America/Atikokan" | "America/Bahia" | "America/Bahia_Banderas" | "America/Barbados" | "America/Belem" | "America/Belize" | "America/Blanc-Sablon" | "America/Boa_Vista" | "America/Bogota" | "America/Boise" | "America/Cambridge_Bay" | "America/Campo_Grande" | "America/Cancun" | "America/Caracas" | "America/Cayenne" | "America/Cayman" | "America/Chicago" | "America/Chihuahua" | "America/Ciudad_Juarez" | "America/Costa_Rica" | "America/Creston" | "America/Cuiaba" | "America/Curacao" | "America/Danmarkshavn" | "America/Dawson" | "America/Dawson_Creek" | "America/Denver" | "America/Detroit" | "America/Dominica" | "America/Edmonton" | "America/Eirunepe" | "America/El_Salvador" | "America/Fort_Nelson" | "America/Fortaleza" | "America/Glace_Bay" | "America/Goose_Bay" | "America/Grand_Turk" | "America/Grenada" | "America/Guadeloupe" | "America/Guatemala" | "America/Guayaquil" | "America/Guyana" | "America/Halifax" | "America/Havana" | "America/Hermosillo" | "America/Indiana/Indianapolis" | "America/Indiana/Knox" | "America/Indiana/Marengo" | "America/Indiana/Petersburg" | "America/Indiana/Tell_City" | "America/Indiana/Vevay" | "America/Indiana/Vincennes" | "America/Indiana/Winamac" | "America/Inuvik" | "America/Iqaluit" | "America/Jamaica" | "America/Juneau" | "America/Kentucky/Louisville" | "America/Kentucky/Monticello" | "America/Kralendijk" | "America/La_Paz" | "America/Lima" | "America/Los_Angeles" | "America/Lower_Princes" | "America/Maceio" | "America/Managua" | "America/Manaus" | "America/Marigot" | "America/Martinique" | "America/Matamoros" | "America/Mazatlan" | "America/Menominee" | "America/Merida" | "America/Metlakatla" | "America/Mexico_City" | "America/Miquelon" | "America/Moncton" | "America/Monterrey" | "America/Montevideo" | "America/Montserrat" | "America/Nassau" | "America/New_York" | "America/Nome" | "America/Noronha" | "America/North_Dakota/Beulah" | "America/North_Dakota/Center" | "America/North_Dakota/New_Salem" | "America/Nuuk" | "America/Ojinaga" | "America/Panama" | "America/Paramaribo" | "America/Phoenix" | "America/Port-au-Prince" | "America/PortOf_Spain" | "America/Porto_Velho" | "America/Puerto_Rico" | "America/Punta_Arenas" | "America/Rankin_Inlet" | "America/Recife" | "America/Regina" | "America/Resolute" | "America/Rio_Branco" | "America/Santarem" | "America/Santiago" | "America/Santo_Domingo" | "America/Sao_Paulo" | "America/Scoresbysund" | "America/Sitka" | "America/St_Barthelemy" | "America/St_Johns" | "America/St_Kitts" | "America/St_Lucia" | "America/St_Thomas" | "America/St_Vincent" | "America/Swift_Current" | "America/Tegucigalpa" | "America/Thule" | "America/Tijuana" | "America/Toronto" | "America/Tortola" | "America/Vancouver" | "America/Whitehorse" | "America/Winnipeg" | "America/Yakutat" | "America/Yellowknife" | "Antarctica/Casey" | "Antarctica/Davis" | "Antarctica/DumontDUrville" | "Antarctica/Macquarie" | "Antarctica/Mawson" | "Antarctica/McMurdo" | "Antarctica/Palmer" | "Antarctica/Rothera" | "Antarctica/Syowa" | "Antarctica/Troll" | "Antarctica/Vostok" | "Arctic/Longyearbyen" | "Asia/Aden" | "Asia/Almaty" | "Asia/Amman" | "Asia/Anadyr" | "Asia/Aqtau" | "Asia/Aqtobe" | "Asia/Ashgabat" | "Asia/Atyrau" | "Asia/Baghdad" | "Asia/Bahrain" | "Asia/Baku" | "Asia/Bangkok" | "Asia/Barnaul" | "Asia/Beirut" | "Asia/Bishkek" | "Asia/Brunei" | "Asia/Chita" | "Asia/Choibalsan" | "Asia/Colombo" | "Asia/Damascus" | "Asia/Dhaka" | "Asia/Dili" | "Asia/Dubai" | "Asia/Dushanbe" | "Asia/Famagusta" | "Asia/Gaza" | "Asia/Hebron" | "Asia/Ho_Chi_Minh" | "Asia/Hong_Kong" | "Asia/Hovd" | "Asia/Irkutsk" | "Asia/Jakarta" | "Asia/Jayapura" | "Asia/Jerusalem" | "Asia/Kabul" | "Asia/Kamchatka" | "Asia/Karachi" | "Asia/Kathmandu" | "Asia/Khandyga" | "Asia/Kolkata" | "Asia/Krasnoyarsk" | "Asia/Kuala_Lumpur" | "Asia/Kuching" | "Asia/Kuwait" | "Asia/Macau" | "Asia/Magadan" | "Asia/Makassar" | "Asia/Manila" | "Asia/Muscat" | "Asia/Nicosia" | "Asia/Novokuznetsk" | "Asia/Novosibirsk" | "Asia/Omsk" | "Asia/Oral" | "Asia/Phnom_Penh" | "Asia/Pontianak" | "Asia/Pyongyang" | "Asia/Qatar" | "Asia/Qostanay" | "Asia/Qyzylorda" | "Asia/Riyadh" | "Asia/Sakhalin" | "Asia/Samarkand" | "Asia/Seoul" | "Asia/Shanghai" | "Asia/Singapore" | "Asia/Srednekolymsk" | "Asia/Taipei" | "Asia/Tashkent" | "Asia/Tbilisi" | "Asia/Tehran" | "Asia/Thimphu" | "Asia/Tokyo" | "Asia/Tomsk" | "Asia/Ulaanbaatar" | "Asia/Urumqi" | "Asia/Ust-Nera" | "Asia/Vientiane" | "Asia/Vladivostok" | "Asia/Yakutsk" | "Asia/Yangon" | "Asia/Yekaterinburg" | "Asia/Yerevan" | "Atlantic/Azores" | "Atlantic/Bermuda" | "Atlantic/Canary" | "Atlantic/Cape_Verde" | "Atlantic/Faroe" | "Atlantic/Madeira" | "Atlantic/Reykjavik" | "Atlantic/South_Georgia" | "Atlantic/St_Helena" | "Atlantic/Stanley" | "Australia/Adelaide" | "Australia/Brisbane" | "Australia/Broken_Hill" | "Australia/Darwin" | "Australia/Eucla" | "Australia/Hobart" | "Australia/Lindeman" | "Australia/Lord_Howe" | "Australia/Melbourne" | "Australia/Perth" | "Australia/Sydney" | "Canada/Atlantic" | "Canada/Central" | "Canada/Eastern" | "Canada/Mountain" | "Canada/Newfoundland" | "Canada/Pacific" | "Europe/Amsterdam" | "Europe/Andorra" | "Europe/Astrakhan" | "Europe/Athens" | "Europe/Belgrade" | "Europe/Berlin" | "Europe/Bratislava" | "Europe/Brussels" | "Europe/Bucharest" | "Europe/Budapest" | "Europe/Busingen" | "Europe/Chisinau" | "Europe/Copenhagen" | "Europe/Dublin" | "Europe/Gibraltar" | "Europe/Guernsey" | "Europe/Helsinki" | "Europe/IsleOf_Man" | "Europe/Istanbul" | "Europe/Jersey" | "Europe/Kaliningrad" | "Europe/Kirov" | "Europe/Kyiv" | "Europe/Lisbon" | "Europe/Ljubljana" | "Europe/London" | "Europe/Luxembourg" | "Europe/Madrid" | "Europe/Malta" | "Europe/Mariehamn" | "Europe/Minsk" | "Europe/Monaco" | "Europe/Moscow" | "Europe/Oslo" | "Europe/Paris" | "Europe/Podgorica" | "Europe/Prague" | "Europe/Riga" | "Europe/Rome" | "Europe/Samara" | "Europe/San_Marino" | "Europe/Sarajevo" | "Europe/Saratov" | "Europe/Simferopol" | "Europe/Skopje" | "Europe/Sofia" | "Europe/Stockholm" | "Europe/Tallinn" | "Europe/Tirane" | "Europe/Ulyanovsk" | "Europe/Vaduz" | "Europe/Vatican" | "Europe/Vienna" | "Europe/Vilnius" | "Europe/Volgograd" | "Europe/Warsaw" | "Europe/Zagreb" | "Europe/Zurich" | "GMT" | "Indian/Antananarivo" | "Indian/Chagos" | "Indian/Christmas" | "Indian/Cocos" | "Indian/Comoro" | "Indian/Kerguelen" | "Indian/Mahe" | "Indian/Maldives" | "Indian/Mauritius" | "Indian/Mayotte" | "Indian/Reunion" | "Pacific/Apia" | "Pacific/Auckland" | "Pacific/Bougainville" | "Pacific/Chatham" | "Pacific/Chuuk" | "Pacific/Easter" | "Pacific/Efate" | "Pacific/Fakaofo" | "Pacific/Fiji" | "Pacific/Funafuti" | "Pacific/Galapagos" | "Pacific/Gambier" | "Pacific/Guadalcanal" | "Pacific/Guam" | "Pacific/Honolulu" | "Pacific/Kanton" | "Pacific/Kiritimati" | "Pacific/Kosrae" | "Pacific/Kwajalein" | "Pacific/Majuro" | "Pacific/Marquesas" | "Pacific/Midway" | "Pacific/Nauru" | "Pacific/Niue" | "Pacific/Norfolk" | "Pacific/Noumea" | "Pacific/Pago_Pago" | "Pacific/Palau" | "Pacific/Pitcairn" | "Pacific/Pohnpei" | "Pacific/Port_Moresby" | "Pacific/Rarotonga" | "Pacific/Saipan" | "Pacific/Tahiti" | "Pacific/Tarawa" | "Pacific/Tongatapu" | "Pacific/Wake" | "Pacific/Wallis" | "US/Alaska" | "US/Arizona" | "US/Central" | "US/Eastern" | "US/Hawaii" | "US/Mountain" | "US/Pacific" | "UTC";
      /** Format: email */
      email: string | null;
      paymentProviderId: string | null;
      /** Format: uri */
      crmProviderUrl: string | null;
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      paymentProvider: "stripe" | "braintree" | "" | null;
    };
    CustomerIntegrations: {
      stripe?: components["schemas"]["CustomerStripeIntegration"] | null;
      braintree?: components["schemas"]["CustomerBraintreeIntegration"] | null;
    };
    CustomerRequest: {
      customerId: string;
      /** Format: email */
      email: string | null;
      defaultCurrency: components["schemas"]["PricingUnitRequest"];
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      paymentProvider: "stripe" | "braintree" | "" | null;
      /**
       * @description * `Africa/Abidjan` - Africa/Abidjan
       * * `Africa/Accra` - Africa/Accra
       * * `Africa/Addis_Ababa` - Africa/Addis_Ababa
       * * `Africa/Algiers` - Africa/Algiers
       * * `Africa/Asmara` - Africa/Asmara
       * * `Africa/Bamako` - Africa/Bamako
       * * `Africa/Bangui` - Africa/Bangui
       * * `Africa/Banjul` - Africa/Banjul
       * * `Africa/Bissau` - Africa/Bissau
       * * `Africa/Blantyre` - Africa/Blantyre
       * * `Africa/Brazzaville` - Africa/Brazzaville
       * * `Africa/Bujumbura` - Africa/Bujumbura
       * * `Africa/Cairo` - Africa/Cairo
       * * `Africa/Casablanca` - Africa/Casablanca
       * * `Africa/Ceuta` - Africa/Ceuta
       * * `Africa/Conakry` - Africa/Conakry
       * * `Africa/Dakar` - Africa/Dakar
       * * `Africa/DarEs_Salaam` - Africa/DarEs_Salaam
       * * `Africa/Djibouti` - Africa/Djibouti
       * * `Africa/Douala` - Africa/Douala
       * * `Africa/El_Aaiun` - Africa/El_Aaiun
       * * `Africa/Freetown` - Africa/Freetown
       * * `Africa/Gaborone` - Africa/Gaborone
       * * `Africa/Harare` - Africa/Harare
       * * `Africa/Johannesburg` - Africa/Johannesburg
       * * `Africa/Juba` - Africa/Juba
       * * `Africa/Kampala` - Africa/Kampala
       * * `Africa/Khartoum` - Africa/Khartoum
       * * `Africa/Kigali` - Africa/Kigali
       * * `Africa/Kinshasa` - Africa/Kinshasa
       * * `Africa/Lagos` - Africa/Lagos
       * * `Africa/Libreville` - Africa/Libreville
       * * `Africa/Lome` - Africa/Lome
       * * `Africa/Luanda` - Africa/Luanda
       * * `Africa/Lubumbashi` - Africa/Lubumbashi
       * * `Africa/Lusaka` - Africa/Lusaka
       * * `Africa/Malabo` - Africa/Malabo
       * * `Africa/Maputo` - Africa/Maputo
       * * `Africa/Maseru` - Africa/Maseru
       * * `Africa/Mbabane` - Africa/Mbabane
       * * `Africa/Mogadishu` - Africa/Mogadishu
       * * `Africa/Monrovia` - Africa/Monrovia
       * * `Africa/Nairobi` - Africa/Nairobi
       * * `Africa/Ndjamena` - Africa/Ndjamena
       * * `Africa/Niamey` - Africa/Niamey
       * * `Africa/Nouakchott` - Africa/Nouakchott
       * * `Africa/Ouagadougou` - Africa/Ouagadougou
       * * `Africa/Porto-Novo` - Africa/Porto-Novo
       * * `Africa/Sao_Tome` - Africa/Sao_Tome
       * * `Africa/Tripoli` - Africa/Tripoli
       * * `Africa/Tunis` - Africa/Tunis
       * * `Africa/Windhoek` - Africa/Windhoek
       * * `America/Adak` - America/Adak
       * * `America/Anchorage` - America/Anchorage
       * * `America/Anguilla` - America/Anguilla
       * * `America/Antigua` - America/Antigua
       * * `America/Araguaina` - America/Araguaina
       * * `America/Argentina/Buenos_Aires` - America/Argentina/Buenos_Aires
       * * `America/Argentina/Catamarca` - America/Argentina/Catamarca
       * * `America/Argentina/Cordoba` - America/Argentina/Cordoba
       * * `America/Argentina/Jujuy` - America/Argentina/Jujuy
       * * `America/Argentina/La_Rioja` - America/Argentina/La_Rioja
       * * `America/Argentina/Mendoza` - America/Argentina/Mendoza
       * * `America/Argentina/Rio_Gallegos` - America/Argentina/Rio_Gallegos
       * * `America/Argentina/Salta` - America/Argentina/Salta
       * * `America/Argentina/San_Juan` - America/Argentina/San_Juan
       * * `America/Argentina/San_Luis` - America/Argentina/San_Luis
       * * `America/Argentina/Tucuman` - America/Argentina/Tucuman
       * * `America/Argentina/Ushuaia` - America/Argentina/Ushuaia
       * * `America/Aruba` - America/Aruba
       * * `America/Asuncion` - America/Asuncion
       * * `America/Atikokan` - America/Atikokan
       * * `America/Bahia` - America/Bahia
       * * `America/Bahia_Banderas` - America/Bahia_Banderas
       * * `America/Barbados` - America/Barbados
       * * `America/Belem` - America/Belem
       * * `America/Belize` - America/Belize
       * * `America/Blanc-Sablon` - America/Blanc-Sablon
       * * `America/Boa_Vista` - America/Boa_Vista
       * * `America/Bogota` - America/Bogota
       * * `America/Boise` - America/Boise
       * * `America/Cambridge_Bay` - America/Cambridge_Bay
       * * `America/Campo_Grande` - America/Campo_Grande
       * * `America/Cancun` - America/Cancun
       * * `America/Caracas` - America/Caracas
       * * `America/Cayenne` - America/Cayenne
       * * `America/Cayman` - America/Cayman
       * * `America/Chicago` - America/Chicago
       * * `America/Chihuahua` - America/Chihuahua
       * * `America/Ciudad_Juarez` - America/Ciudad_Juarez
       * * `America/Costa_Rica` - America/Costa_Rica
       * * `America/Creston` - America/Creston
       * * `America/Cuiaba` - America/Cuiaba
       * * `America/Curacao` - America/Curacao
       * * `America/Danmarkshavn` - America/Danmarkshavn
       * * `America/Dawson` - America/Dawson
       * * `America/Dawson_Creek` - America/Dawson_Creek
       * * `America/Denver` - America/Denver
       * * `America/Detroit` - America/Detroit
       * * `America/Dominica` - America/Dominica
       * * `America/Edmonton` - America/Edmonton
       * * `America/Eirunepe` - America/Eirunepe
       * * `America/El_Salvador` - America/El_Salvador
       * * `America/Fort_Nelson` - America/Fort_Nelson
       * * `America/Fortaleza` - America/Fortaleza
       * * `America/Glace_Bay` - America/Glace_Bay
       * * `America/Goose_Bay` - America/Goose_Bay
       * * `America/Grand_Turk` - America/Grand_Turk
       * * `America/Grenada` - America/Grenada
       * * `America/Guadeloupe` - America/Guadeloupe
       * * `America/Guatemala` - America/Guatemala
       * * `America/Guayaquil` - America/Guayaquil
       * * `America/Guyana` - America/Guyana
       * * `America/Halifax` - America/Halifax
       * * `America/Havana` - America/Havana
       * * `America/Hermosillo` - America/Hermosillo
       * * `America/Indiana/Indianapolis` - America/Indiana/Indianapolis
       * * `America/Indiana/Knox` - America/Indiana/Knox
       * * `America/Indiana/Marengo` - America/Indiana/Marengo
       * * `America/Indiana/Petersburg` - America/Indiana/Petersburg
       * * `America/Indiana/Tell_City` - America/Indiana/Tell_City
       * * `America/Indiana/Vevay` - America/Indiana/Vevay
       * * `America/Indiana/Vincennes` - America/Indiana/Vincennes
       * * `America/Indiana/Winamac` - America/Indiana/Winamac
       * * `America/Inuvik` - America/Inuvik
       * * `America/Iqaluit` - America/Iqaluit
       * * `America/Jamaica` - America/Jamaica
       * * `America/Juneau` - America/Juneau
       * * `America/Kentucky/Louisville` - America/Kentucky/Louisville
       * * `America/Kentucky/Monticello` - America/Kentucky/Monticello
       * * `America/Kralendijk` - America/Kralendijk
       * * `America/La_Paz` - America/La_Paz
       * * `America/Lima` - America/Lima
       * * `America/Los_Angeles` - America/Los_Angeles
       * * `America/Lower_Princes` - America/Lower_Princes
       * * `America/Maceio` - America/Maceio
       * * `America/Managua` - America/Managua
       * * `America/Manaus` - America/Manaus
       * * `America/Marigot` - America/Marigot
       * * `America/Martinique` - America/Martinique
       * * `America/Matamoros` - America/Matamoros
       * * `America/Mazatlan` - America/Mazatlan
       * * `America/Menominee` - America/Menominee
       * * `America/Merida` - America/Merida
       * * `America/Metlakatla` - America/Metlakatla
       * * `America/Mexico_City` - America/Mexico_City
       * * `America/Miquelon` - America/Miquelon
       * * `America/Moncton` - America/Moncton
       * * `America/Monterrey` - America/Monterrey
       * * `America/Montevideo` - America/Montevideo
       * * `America/Montserrat` - America/Montserrat
       * * `America/Nassau` - America/Nassau
       * * `America/New_York` - America/New_York
       * * `America/Nome` - America/Nome
       * * `America/Noronha` - America/Noronha
       * * `America/North_Dakota/Beulah` - America/North_Dakota/Beulah
       * * `America/North_Dakota/Center` - America/North_Dakota/Center
       * * `America/North_Dakota/New_Salem` - America/North_Dakota/New_Salem
       * * `America/Nuuk` - America/Nuuk
       * * `America/Ojinaga` - America/Ojinaga
       * * `America/Panama` - America/Panama
       * * `America/Paramaribo` - America/Paramaribo
       * * `America/Phoenix` - America/Phoenix
       * * `America/Port-au-Prince` - America/Port-au-Prince
       * * `America/PortOf_Spain` - America/PortOf_Spain
       * * `America/Porto_Velho` - America/Porto_Velho
       * * `America/Puerto_Rico` - America/Puerto_Rico
       * * `America/Punta_Arenas` - America/Punta_Arenas
       * * `America/Rankin_Inlet` - America/Rankin_Inlet
       * * `America/Recife` - America/Recife
       * * `America/Regina` - America/Regina
       * * `America/Resolute` - America/Resolute
       * * `America/Rio_Branco` - America/Rio_Branco
       * * `America/Santarem` - America/Santarem
       * * `America/Santiago` - America/Santiago
       * * `America/Santo_Domingo` - America/Santo_Domingo
       * * `America/Sao_Paulo` - America/Sao_Paulo
       * * `America/Scoresbysund` - America/Scoresbysund
       * * `America/Sitka` - America/Sitka
       * * `America/St_Barthelemy` - America/St_Barthelemy
       * * `America/St_Johns` - America/St_Johns
       * * `America/St_Kitts` - America/St_Kitts
       * * `America/St_Lucia` - America/St_Lucia
       * * `America/St_Thomas` - America/St_Thomas
       * * `America/St_Vincent` - America/St_Vincent
       * * `America/Swift_Current` - America/Swift_Current
       * * `America/Tegucigalpa` - America/Tegucigalpa
       * * `America/Thule` - America/Thule
       * * `America/Tijuana` - America/Tijuana
       * * `America/Toronto` - America/Toronto
       * * `America/Tortola` - America/Tortola
       * * `America/Vancouver` - America/Vancouver
       * * `America/Whitehorse` - America/Whitehorse
       * * `America/Winnipeg` - America/Winnipeg
       * * `America/Yakutat` - America/Yakutat
       * * `America/Yellowknife` - America/Yellowknife
       * * `Antarctica/Casey` - Antarctica/Casey
       * * `Antarctica/Davis` - Antarctica/Davis
       * * `Antarctica/DumontDUrville` - Antarctica/DumontDUrville
       * * `Antarctica/Macquarie` - Antarctica/Macquarie
       * * `Antarctica/Mawson` - Antarctica/Mawson
       * * `Antarctica/McMurdo` - Antarctica/McMurdo
       * * `Antarctica/Palmer` - Antarctica/Palmer
       * * `Antarctica/Rothera` - Antarctica/Rothera
       * * `Antarctica/Syowa` - Antarctica/Syowa
       * * `Antarctica/Troll` - Antarctica/Troll
       * * `Antarctica/Vostok` - Antarctica/Vostok
       * * `Arctic/Longyearbyen` - Arctic/Longyearbyen
       * * `Asia/Aden` - Asia/Aden
       * * `Asia/Almaty` - Asia/Almaty
       * * `Asia/Amman` - Asia/Amman
       * * `Asia/Anadyr` - Asia/Anadyr
       * * `Asia/Aqtau` - Asia/Aqtau
       * * `Asia/Aqtobe` - Asia/Aqtobe
       * * `Asia/Ashgabat` - Asia/Ashgabat
       * * `Asia/Atyrau` - Asia/Atyrau
       * * `Asia/Baghdad` - Asia/Baghdad
       * * `Asia/Bahrain` - Asia/Bahrain
       * * `Asia/Baku` - Asia/Baku
       * * `Asia/Bangkok` - Asia/Bangkok
       * * `Asia/Barnaul` - Asia/Barnaul
       * * `Asia/Beirut` - Asia/Beirut
       * * `Asia/Bishkek` - Asia/Bishkek
       * * `Asia/Brunei` - Asia/Brunei
       * * `Asia/Chita` - Asia/Chita
       * * `Asia/Choibalsan` - Asia/Choibalsan
       * * `Asia/Colombo` - Asia/Colombo
       * * `Asia/Damascus` - Asia/Damascus
       * * `Asia/Dhaka` - Asia/Dhaka
       * * `Asia/Dili` - Asia/Dili
       * * `Asia/Dubai` - Asia/Dubai
       * * `Asia/Dushanbe` - Asia/Dushanbe
       * * `Asia/Famagusta` - Asia/Famagusta
       * * `Asia/Gaza` - Asia/Gaza
       * * `Asia/Hebron` - Asia/Hebron
       * * `Asia/Ho_Chi_Minh` - Asia/Ho_Chi_Minh
       * * `Asia/Hong_Kong` - Asia/Hong_Kong
       * * `Asia/Hovd` - Asia/Hovd
       * * `Asia/Irkutsk` - Asia/Irkutsk
       * * `Asia/Jakarta` - Asia/Jakarta
       * * `Asia/Jayapura` - Asia/Jayapura
       * * `Asia/Jerusalem` - Asia/Jerusalem
       * * `Asia/Kabul` - Asia/Kabul
       * * `Asia/Kamchatka` - Asia/Kamchatka
       * * `Asia/Karachi` - Asia/Karachi
       * * `Asia/Kathmandu` - Asia/Kathmandu
       * * `Asia/Khandyga` - Asia/Khandyga
       * * `Asia/Kolkata` - Asia/Kolkata
       * * `Asia/Krasnoyarsk` - Asia/Krasnoyarsk
       * * `Asia/Kuala_Lumpur` - Asia/Kuala_Lumpur
       * * `Asia/Kuching` - Asia/Kuching
       * * `Asia/Kuwait` - Asia/Kuwait
       * * `Asia/Macau` - Asia/Macau
       * * `Asia/Magadan` - Asia/Magadan
       * * `Asia/Makassar` - Asia/Makassar
       * * `Asia/Manila` - Asia/Manila
       * * `Asia/Muscat` - Asia/Muscat
       * * `Asia/Nicosia` - Asia/Nicosia
       * * `Asia/Novokuznetsk` - Asia/Novokuznetsk
       * * `Asia/Novosibirsk` - Asia/Novosibirsk
       * * `Asia/Omsk` - Asia/Omsk
       * * `Asia/Oral` - Asia/Oral
       * * `Asia/Phnom_Penh` - Asia/Phnom_Penh
       * * `Asia/Pontianak` - Asia/Pontianak
       * * `Asia/Pyongyang` - Asia/Pyongyang
       * * `Asia/Qatar` - Asia/Qatar
       * * `Asia/Qostanay` - Asia/Qostanay
       * * `Asia/Qyzylorda` - Asia/Qyzylorda
       * * `Asia/Riyadh` - Asia/Riyadh
       * * `Asia/Sakhalin` - Asia/Sakhalin
       * * `Asia/Samarkand` - Asia/Samarkand
       * * `Asia/Seoul` - Asia/Seoul
       * * `Asia/Shanghai` - Asia/Shanghai
       * * `Asia/Singapore` - Asia/Singapore
       * * `Asia/Srednekolymsk` - Asia/Srednekolymsk
       * * `Asia/Taipei` - Asia/Taipei
       * * `Asia/Tashkent` - Asia/Tashkent
       * * `Asia/Tbilisi` - Asia/Tbilisi
       * * `Asia/Tehran` - Asia/Tehran
       * * `Asia/Thimphu` - Asia/Thimphu
       * * `Asia/Tokyo` - Asia/Tokyo
       * * `Asia/Tomsk` - Asia/Tomsk
       * * `Asia/Ulaanbaatar` - Asia/Ulaanbaatar
       * * `Asia/Urumqi` - Asia/Urumqi
       * * `Asia/Ust-Nera` - Asia/Ust-Nera
       * * `Asia/Vientiane` - Asia/Vientiane
       * * `Asia/Vladivostok` - Asia/Vladivostok
       * * `Asia/Yakutsk` - Asia/Yakutsk
       * * `Asia/Yangon` - Asia/Yangon
       * * `Asia/Yekaterinburg` - Asia/Yekaterinburg
       * * `Asia/Yerevan` - Asia/Yerevan
       * * `Atlantic/Azores` - Atlantic/Azores
       * * `Atlantic/Bermuda` - Atlantic/Bermuda
       * * `Atlantic/Canary` - Atlantic/Canary
       * * `Atlantic/Cape_Verde` - Atlantic/Cape_Verde
       * * `Atlantic/Faroe` - Atlantic/Faroe
       * * `Atlantic/Madeira` - Atlantic/Madeira
       * * `Atlantic/Reykjavik` - Atlantic/Reykjavik
       * * `Atlantic/South_Georgia` - Atlantic/South_Georgia
       * * `Atlantic/St_Helena` - Atlantic/St_Helena
       * * `Atlantic/Stanley` - Atlantic/Stanley
       * * `Australia/Adelaide` - Australia/Adelaide
       * * `Australia/Brisbane` - Australia/Brisbane
       * * `Australia/Broken_Hill` - Australia/Broken_Hill
       * * `Australia/Darwin` - Australia/Darwin
       * * `Australia/Eucla` - Australia/Eucla
       * * `Australia/Hobart` - Australia/Hobart
       * * `Australia/Lindeman` - Australia/Lindeman
       * * `Australia/Lord_Howe` - Australia/Lord_Howe
       * * `Australia/Melbourne` - Australia/Melbourne
       * * `Australia/Perth` - Australia/Perth
       * * `Australia/Sydney` - Australia/Sydney
       * * `Canada/Atlantic` - Canada/Atlantic
       * * `Canada/Central` - Canada/Central
       * * `Canada/Eastern` - Canada/Eastern
       * * `Canada/Mountain` - Canada/Mountain
       * * `Canada/Newfoundland` - Canada/Newfoundland
       * * `Canada/Pacific` - Canada/Pacific
       * * `Europe/Amsterdam` - Europe/Amsterdam
       * * `Europe/Andorra` - Europe/Andorra
       * * `Europe/Astrakhan` - Europe/Astrakhan
       * * `Europe/Athens` - Europe/Athens
       * * `Europe/Belgrade` - Europe/Belgrade
       * * `Europe/Berlin` - Europe/Berlin
       * * `Europe/Bratislava` - Europe/Bratislava
       * * `Europe/Brussels` - Europe/Brussels
       * * `Europe/Bucharest` - Europe/Bucharest
       * * `Europe/Budapest` - Europe/Budapest
       * * `Europe/Busingen` - Europe/Busingen
       * * `Europe/Chisinau` - Europe/Chisinau
       * * `Europe/Copenhagen` - Europe/Copenhagen
       * * `Europe/Dublin` - Europe/Dublin
       * * `Europe/Gibraltar` - Europe/Gibraltar
       * * `Europe/Guernsey` - Europe/Guernsey
       * * `Europe/Helsinki` - Europe/Helsinki
       * * `Europe/IsleOf_Man` - Europe/IsleOf_Man
       * * `Europe/Istanbul` - Europe/Istanbul
       * * `Europe/Jersey` - Europe/Jersey
       * * `Europe/Kaliningrad` - Europe/Kaliningrad
       * * `Europe/Kirov` - Europe/Kirov
       * * `Europe/Kyiv` - Europe/Kyiv
       * * `Europe/Lisbon` - Europe/Lisbon
       * * `Europe/Ljubljana` - Europe/Ljubljana
       * * `Europe/London` - Europe/London
       * * `Europe/Luxembourg` - Europe/Luxembourg
       * * `Europe/Madrid` - Europe/Madrid
       * * `Europe/Malta` - Europe/Malta
       * * `Europe/Mariehamn` - Europe/Mariehamn
       * * `Europe/Minsk` - Europe/Minsk
       * * `Europe/Monaco` - Europe/Monaco
       * * `Europe/Moscow` - Europe/Moscow
       * * `Europe/Oslo` - Europe/Oslo
       * * `Europe/Paris` - Europe/Paris
       * * `Europe/Podgorica` - Europe/Podgorica
       * * `Europe/Prague` - Europe/Prague
       * * `Europe/Riga` - Europe/Riga
       * * `Europe/Rome` - Europe/Rome
       * * `Europe/Samara` - Europe/Samara
       * * `Europe/San_Marino` - Europe/San_Marino
       * * `Europe/Sarajevo` - Europe/Sarajevo
       * * `Europe/Saratov` - Europe/Saratov
       * * `Europe/Simferopol` - Europe/Simferopol
       * * `Europe/Skopje` - Europe/Skopje
       * * `Europe/Sofia` - Europe/Sofia
       * * `Europe/Stockholm` - Europe/Stockholm
       * * `Europe/Tallinn` - Europe/Tallinn
       * * `Europe/Tirane` - Europe/Tirane
       * * `Europe/Ulyanovsk` - Europe/Ulyanovsk
       * * `Europe/Vaduz` - Europe/Vaduz
       * * `Europe/Vatican` - Europe/Vatican
       * * `Europe/Vienna` - Europe/Vienna
       * * `Europe/Vilnius` - Europe/Vilnius
       * * `Europe/Volgograd` - Europe/Volgograd
       * * `Europe/Warsaw` - Europe/Warsaw
       * * `Europe/Zagreb` - Europe/Zagreb
       * * `Europe/Zurich` - Europe/Zurich
       * * `GMT` - GMT
       * * `Indian/Antananarivo` - Indian/Antananarivo
       * * `Indian/Chagos` - Indian/Chagos
       * * `Indian/Christmas` - Indian/Christmas
       * * `Indian/Cocos` - Indian/Cocos
       * * `Indian/Comoro` - Indian/Comoro
       * * `Indian/Kerguelen` - Indian/Kerguelen
       * * `Indian/Mahe` - Indian/Mahe
       * * `Indian/Maldives` - Indian/Maldives
       * * `Indian/Mauritius` - Indian/Mauritius
       * * `Indian/Mayotte` - Indian/Mayotte
       * * `Indian/Reunion` - Indian/Reunion
       * * `Pacific/Apia` - Pacific/Apia
       * * `Pacific/Auckland` - Pacific/Auckland
       * * `Pacific/Bougainville` - Pacific/Bougainville
       * * `Pacific/Chatham` - Pacific/Chatham
       * * `Pacific/Chuuk` - Pacific/Chuuk
       * * `Pacific/Easter` - Pacific/Easter
       * * `Pacific/Efate` - Pacific/Efate
       * * `Pacific/Fakaofo` - Pacific/Fakaofo
       * * `Pacific/Fiji` - Pacific/Fiji
       * * `Pacific/Funafuti` - Pacific/Funafuti
       * * `Pacific/Galapagos` - Pacific/Galapagos
       * * `Pacific/Gambier` - Pacific/Gambier
       * * `Pacific/Guadalcanal` - Pacific/Guadalcanal
       * * `Pacific/Guam` - Pacific/Guam
       * * `Pacific/Honolulu` - Pacific/Honolulu
       * * `Pacific/Kanton` - Pacific/Kanton
       * * `Pacific/Kiritimati` - Pacific/Kiritimati
       * * `Pacific/Kosrae` - Pacific/Kosrae
       * * `Pacific/Kwajalein` - Pacific/Kwajalein
       * * `Pacific/Majuro` - Pacific/Majuro
       * * `Pacific/Marquesas` - Pacific/Marquesas
       * * `Pacific/Midway` - Pacific/Midway
       * * `Pacific/Nauru` - Pacific/Nauru
       * * `Pacific/Niue` - Pacific/Niue
       * * `Pacific/Norfolk` - Pacific/Norfolk
       * * `Pacific/Noumea` - Pacific/Noumea
       * * `Pacific/Pago_Pago` - Pacific/Pago_Pago
       * * `Pacific/Palau` - Pacific/Palau
       * * `Pacific/Pitcairn` - Pacific/Pitcairn
       * * `Pacific/Pohnpei` - Pacific/Pohnpei
       * * `Pacific/Port_Moresby` - Pacific/Port_Moresby
       * * `Pacific/Rarotonga` - Pacific/Rarotonga
       * * `Pacific/Saipan` - Pacific/Saipan
       * * `Pacific/Tahiti` - Pacific/Tahiti
       * * `Pacific/Tarawa` - Pacific/Tarawa
       * * `Pacific/Tongatapu` - Pacific/Tongatapu
       * * `Pacific/Wake` - Pacific/Wake
       * * `Pacific/Wallis` - Pacific/Wallis
       * * `US/Alaska` - US/Alaska
       * * `US/Arizona` - US/Arizona
       * * `US/Central` - US/Central
       * * `US/Eastern` - US/Eastern
       * * `US/Hawaii` - US/Hawaii
       * * `US/Mountain` - US/Mountain
       * * `US/Pacific` - US/Pacific
       * * `UTC` - UTC 
       * @enum {string}
       */
      timezone: "Africa/Abidjan" | "Africa/Accra" | "Africa/Addis_Ababa" | "Africa/Algiers" | "Africa/Asmara" | "Africa/Bamako" | "Africa/Bangui" | "Africa/Banjul" | "Africa/Bissau" | "Africa/Blantyre" | "Africa/Brazzaville" | "Africa/Bujumbura" | "Africa/Cairo" | "Africa/Casablanca" | "Africa/Ceuta" | "Africa/Conakry" | "Africa/Dakar" | "Africa/DarEs_Salaam" | "Africa/Djibouti" | "Africa/Douala" | "Africa/El_Aaiun" | "Africa/Freetown" | "Africa/Gaborone" | "Africa/Harare" | "Africa/Johannesburg" | "Africa/Juba" | "Africa/Kampala" | "Africa/Khartoum" | "Africa/Kigali" | "Africa/Kinshasa" | "Africa/Lagos" | "Africa/Libreville" | "Africa/Lome" | "Africa/Luanda" | "Africa/Lubumbashi" | "Africa/Lusaka" | "Africa/Malabo" | "Africa/Maputo" | "Africa/Maseru" | "Africa/Mbabane" | "Africa/Mogadishu" | "Africa/Monrovia" | "Africa/Nairobi" | "Africa/Ndjamena" | "Africa/Niamey" | "Africa/Nouakchott" | "Africa/Ouagadougou" | "Africa/Porto-Novo" | "Africa/Sao_Tome" | "Africa/Tripoli" | "Africa/Tunis" | "Africa/Windhoek" | "America/Adak" | "America/Anchorage" | "America/Anguilla" | "America/Antigua" | "America/Araguaina" | "America/Argentina/Buenos_Aires" | "America/Argentina/Catamarca" | "America/Argentina/Cordoba" | "America/Argentina/Jujuy" | "America/Argentina/La_Rioja" | "America/Argentina/Mendoza" | "America/Argentina/Rio_Gallegos" | "America/Argentina/Salta" | "America/Argentina/San_Juan" | "America/Argentina/San_Luis" | "America/Argentina/Tucuman" | "America/Argentina/Ushuaia" | "America/Aruba" | "America/Asuncion" | "America/Atikokan" | "America/Bahia" | "America/Bahia_Banderas" | "America/Barbados" | "America/Belem" | "America/Belize" | "America/Blanc-Sablon" | "America/Boa_Vista" | "America/Bogota" | "America/Boise" | "America/Cambridge_Bay" | "America/Campo_Grande" | "America/Cancun" | "America/Caracas" | "America/Cayenne" | "America/Cayman" | "America/Chicago" | "America/Chihuahua" | "America/Ciudad_Juarez" | "America/Costa_Rica" | "America/Creston" | "America/Cuiaba" | "America/Curacao" | "America/Danmarkshavn" | "America/Dawson" | "America/Dawson_Creek" | "America/Denver" | "America/Detroit" | "America/Dominica" | "America/Edmonton" | "America/Eirunepe" | "America/El_Salvador" | "America/Fort_Nelson" | "America/Fortaleza" | "America/Glace_Bay" | "America/Goose_Bay" | "America/Grand_Turk" | "America/Grenada" | "America/Guadeloupe" | "America/Guatemala" | "America/Guayaquil" | "America/Guyana" | "America/Halifax" | "America/Havana" | "America/Hermosillo" | "America/Indiana/Indianapolis" | "America/Indiana/Knox" | "America/Indiana/Marengo" | "America/Indiana/Petersburg" | "America/Indiana/Tell_City" | "America/Indiana/Vevay" | "America/Indiana/Vincennes" | "America/Indiana/Winamac" | "America/Inuvik" | "America/Iqaluit" | "America/Jamaica" | "America/Juneau" | "America/Kentucky/Louisville" | "America/Kentucky/Monticello" | "America/Kralendijk" | "America/La_Paz" | "America/Lima" | "America/Los_Angeles" | "America/Lower_Princes" | "America/Maceio" | "America/Managua" | "America/Manaus" | "America/Marigot" | "America/Martinique" | "America/Matamoros" | "America/Mazatlan" | "America/Menominee" | "America/Merida" | "America/Metlakatla" | "America/Mexico_City" | "America/Miquelon" | "America/Moncton" | "America/Monterrey" | "America/Montevideo" | "America/Montserrat" | "America/Nassau" | "America/New_York" | "America/Nome" | "America/Noronha" | "America/North_Dakota/Beulah" | "America/North_Dakota/Center" | "America/North_Dakota/New_Salem" | "America/Nuuk" | "America/Ojinaga" | "America/Panama" | "America/Paramaribo" | "America/Phoenix" | "America/Port-au-Prince" | "America/PortOf_Spain" | "America/Porto_Velho" | "America/Puerto_Rico" | "America/Punta_Arenas" | "America/Rankin_Inlet" | "America/Recife" | "America/Regina" | "America/Resolute" | "America/Rio_Branco" | "America/Santarem" | "America/Santiago" | "America/Santo_Domingo" | "America/Sao_Paulo" | "America/Scoresbysund" | "America/Sitka" | "America/St_Barthelemy" | "America/St_Johns" | "America/St_Kitts" | "America/St_Lucia" | "America/St_Thomas" | "America/St_Vincent" | "America/Swift_Current" | "America/Tegucigalpa" | "America/Thule" | "America/Tijuana" | "America/Toronto" | "America/Tortola" | "America/Vancouver" | "America/Whitehorse" | "America/Winnipeg" | "America/Yakutat" | "America/Yellowknife" | "Antarctica/Casey" | "Antarctica/Davis" | "Antarctica/DumontDUrville" | "Antarctica/Macquarie" | "Antarctica/Mawson" | "Antarctica/McMurdo" | "Antarctica/Palmer" | "Antarctica/Rothera" | "Antarctica/Syowa" | "Antarctica/Troll" | "Antarctica/Vostok" | "Arctic/Longyearbyen" | "Asia/Aden" | "Asia/Almaty" | "Asia/Amman" | "Asia/Anadyr" | "Asia/Aqtau" | "Asia/Aqtobe" | "Asia/Ashgabat" | "Asia/Atyrau" | "Asia/Baghdad" | "Asia/Bahrain" | "Asia/Baku" | "Asia/Bangkok" | "Asia/Barnaul" | "Asia/Beirut" | "Asia/Bishkek" | "Asia/Brunei" | "Asia/Chita" | "Asia/Choibalsan" | "Asia/Colombo" | "Asia/Damascus" | "Asia/Dhaka" | "Asia/Dili" | "Asia/Dubai" | "Asia/Dushanbe" | "Asia/Famagusta" | "Asia/Gaza" | "Asia/Hebron" | "Asia/Ho_Chi_Minh" | "Asia/Hong_Kong" | "Asia/Hovd" | "Asia/Irkutsk" | "Asia/Jakarta" | "Asia/Jayapura" | "Asia/Jerusalem" | "Asia/Kabul" | "Asia/Kamchatka" | "Asia/Karachi" | "Asia/Kathmandu" | "Asia/Khandyga" | "Asia/Kolkata" | "Asia/Krasnoyarsk" | "Asia/Kuala_Lumpur" | "Asia/Kuching" | "Asia/Kuwait" | "Asia/Macau" | "Asia/Magadan" | "Asia/Makassar" | "Asia/Manila" | "Asia/Muscat" | "Asia/Nicosia" | "Asia/Novokuznetsk" | "Asia/Novosibirsk" | "Asia/Omsk" | "Asia/Oral" | "Asia/Phnom_Penh" | "Asia/Pontianak" | "Asia/Pyongyang" | "Asia/Qatar" | "Asia/Qostanay" | "Asia/Qyzylorda" | "Asia/Riyadh" | "Asia/Sakhalin" | "Asia/Samarkand" | "Asia/Seoul" | "Asia/Shanghai" | "Asia/Singapore" | "Asia/Srednekolymsk" | "Asia/Taipei" | "Asia/Tashkent" | "Asia/Tbilisi" | "Asia/Tehran" | "Asia/Thimphu" | "Asia/Tokyo" | "Asia/Tomsk" | "Asia/Ulaanbaatar" | "Asia/Urumqi" | "Asia/Ust-Nera" | "Asia/Vientiane" | "Asia/Vladivostok" | "Asia/Yakutsk" | "Asia/Yangon" | "Asia/Yekaterinburg" | "Asia/Yerevan" | "Atlantic/Azores" | "Atlantic/Bermuda" | "Atlantic/Canary" | "Atlantic/Cape_Verde" | "Atlantic/Faroe" | "Atlantic/Madeira" | "Atlantic/Reykjavik" | "Atlantic/South_Georgia" | "Atlantic/St_Helena" | "Atlantic/Stanley" | "Australia/Adelaide" | "Australia/Brisbane" | "Australia/Broken_Hill" | "Australia/Darwin" | "Australia/Eucla" | "Australia/Hobart" | "Australia/Lindeman" | "Australia/Lord_Howe" | "Australia/Melbourne" | "Australia/Perth" | "Australia/Sydney" | "Canada/Atlantic" | "Canada/Central" | "Canada/Eastern" | "Canada/Mountain" | "Canada/Newfoundland" | "Canada/Pacific" | "Europe/Amsterdam" | "Europe/Andorra" | "Europe/Astrakhan" | "Europe/Athens" | "Europe/Belgrade" | "Europe/Berlin" | "Europe/Bratislava" | "Europe/Brussels" | "Europe/Bucharest" | "Europe/Budapest" | "Europe/Busingen" | "Europe/Chisinau" | "Europe/Copenhagen" | "Europe/Dublin" | "Europe/Gibraltar" | "Europe/Guernsey" | "Europe/Helsinki" | "Europe/IsleOf_Man" | "Europe/Istanbul" | "Europe/Jersey" | "Europe/Kaliningrad" | "Europe/Kirov" | "Europe/Kyiv" | "Europe/Lisbon" | "Europe/Ljubljana" | "Europe/London" | "Europe/Luxembourg" | "Europe/Madrid" | "Europe/Malta" | "Europe/Mariehamn" | "Europe/Minsk" | "Europe/Monaco" | "Europe/Moscow" | "Europe/Oslo" | "Europe/Paris" | "Europe/Podgorica" | "Europe/Prague" | "Europe/Riga" | "Europe/Rome" | "Europe/Samara" | "Europe/San_Marino" | "Europe/Sarajevo" | "Europe/Saratov" | "Europe/Simferopol" | "Europe/Skopje" | "Europe/Sofia" | "Europe/Stockholm" | "Europe/Tallinn" | "Europe/Tirane" | "Europe/Ulyanovsk" | "Europe/Vaduz" | "Europe/Vatican" | "Europe/Vienna" | "Europe/Vilnius" | "Europe/Volgograd" | "Europe/Warsaw" | "Europe/Zagreb" | "Europe/Zurich" | "GMT" | "Indian/Antananarivo" | "Indian/Chagos" | "Indian/Christmas" | "Indian/Cocos" | "Indian/Comoro" | "Indian/Kerguelen" | "Indian/Mahe" | "Indian/Maldives" | "Indian/Mauritius" | "Indian/Mayotte" | "Indian/Reunion" | "Pacific/Apia" | "Pacific/Auckland" | "Pacific/Bougainville" | "Pacific/Chatham" | "Pacific/Chuuk" | "Pacific/Easter" | "Pacific/Efate" | "Pacific/Fakaofo" | "Pacific/Fiji" | "Pacific/Funafuti" | "Pacific/Galapagos" | "Pacific/Gambier" | "Pacific/Guadalcanal" | "Pacific/Guam" | "Pacific/Honolulu" | "Pacific/Kanton" | "Pacific/Kiritimati" | "Pacific/Kosrae" | "Pacific/Kwajalein" | "Pacific/Majuro" | "Pacific/Marquesas" | "Pacific/Midway" | "Pacific/Nauru" | "Pacific/Niue" | "Pacific/Norfolk" | "Pacific/Noumea" | "Pacific/Pago_Pago" | "Pacific/Palau" | "Pacific/Pitcairn" | "Pacific/Pohnpei" | "Pacific/Port_Moresby" | "Pacific/Rarotonga" | "Pacific/Saipan" | "Pacific/Tahiti" | "Pacific/Tarawa" | "Pacific/Tongatapu" | "Pacific/Wake" | "Pacific/Wallis" | "US/Alaska" | "US/Arizona" | "US/Central" | "US/Eastern" | "US/Hawaii" | "US/Mountain" | "US/Pacific" | "UTC";
    };
    CustomerStripeIntegration: {
      stripeId: string;
      hasPaymentMethod: boolean;
    };
    CustomerSummary: {
      /** @description The display name of the customer */
      customerName?: string | null;
      /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
      customerId?: string | null;
      subscriptions: readonly (components["schemas"]["SubscriptionCustomerSummary"])[];
    };
    CustomerUpdate: {
      defaultCurrencyCode: string;
      billingAddress?: components["schemas"]["Address"] | null;
      shippingAddress?: components["schemas"]["Address"] | null;
      /**
       * Format: double 
       * @description Tax rate as percentage. For example, 10.5 for 10.5%
       */
      taxRate?: number | null;
      /**
       * @description * `Africa/Abidjan` - Africa/Abidjan
       * * `Africa/Accra` - Africa/Accra
       * * `Africa/Addis_Ababa` - Africa/Addis_Ababa
       * * `Africa/Algiers` - Africa/Algiers
       * * `Africa/Asmara` - Africa/Asmara
       * * `Africa/Bamako` - Africa/Bamako
       * * `Africa/Bangui` - Africa/Bangui
       * * `Africa/Banjul` - Africa/Banjul
       * * `Africa/Bissau` - Africa/Bissau
       * * `Africa/Blantyre` - Africa/Blantyre
       * * `Africa/Brazzaville` - Africa/Brazzaville
       * * `Africa/Bujumbura` - Africa/Bujumbura
       * * `Africa/Cairo` - Africa/Cairo
       * * `Africa/Casablanca` - Africa/Casablanca
       * * `Africa/Ceuta` - Africa/Ceuta
       * * `Africa/Conakry` - Africa/Conakry
       * * `Africa/Dakar` - Africa/Dakar
       * * `Africa/DarEs_Salaam` - Africa/DarEs_Salaam
       * * `Africa/Djibouti` - Africa/Djibouti
       * * `Africa/Douala` - Africa/Douala
       * * `Africa/El_Aaiun` - Africa/El_Aaiun
       * * `Africa/Freetown` - Africa/Freetown
       * * `Africa/Gaborone` - Africa/Gaborone
       * * `Africa/Harare` - Africa/Harare
       * * `Africa/Johannesburg` - Africa/Johannesburg
       * * `Africa/Juba` - Africa/Juba
       * * `Africa/Kampala` - Africa/Kampala
       * * `Africa/Khartoum` - Africa/Khartoum
       * * `Africa/Kigali` - Africa/Kigali
       * * `Africa/Kinshasa` - Africa/Kinshasa
       * * `Africa/Lagos` - Africa/Lagos
       * * `Africa/Libreville` - Africa/Libreville
       * * `Africa/Lome` - Africa/Lome
       * * `Africa/Luanda` - Africa/Luanda
       * * `Africa/Lubumbashi` - Africa/Lubumbashi
       * * `Africa/Lusaka` - Africa/Lusaka
       * * `Africa/Malabo` - Africa/Malabo
       * * `Africa/Maputo` - Africa/Maputo
       * * `Africa/Maseru` - Africa/Maseru
       * * `Africa/Mbabane` - Africa/Mbabane
       * * `Africa/Mogadishu` - Africa/Mogadishu
       * * `Africa/Monrovia` - Africa/Monrovia
       * * `Africa/Nairobi` - Africa/Nairobi
       * * `Africa/Ndjamena` - Africa/Ndjamena
       * * `Africa/Niamey` - Africa/Niamey
       * * `Africa/Nouakchott` - Africa/Nouakchott
       * * `Africa/Ouagadougou` - Africa/Ouagadougou
       * * `Africa/Porto-Novo` - Africa/Porto-Novo
       * * `Africa/Sao_Tome` - Africa/Sao_Tome
       * * `Africa/Tripoli` - Africa/Tripoli
       * * `Africa/Tunis` - Africa/Tunis
       * * `Africa/Windhoek` - Africa/Windhoek
       * * `America/Adak` - America/Adak
       * * `America/Anchorage` - America/Anchorage
       * * `America/Anguilla` - America/Anguilla
       * * `America/Antigua` - America/Antigua
       * * `America/Araguaina` - America/Araguaina
       * * `America/Argentina/Buenos_Aires` - America/Argentina/Buenos_Aires
       * * `America/Argentina/Catamarca` - America/Argentina/Catamarca
       * * `America/Argentina/Cordoba` - America/Argentina/Cordoba
       * * `America/Argentina/Jujuy` - America/Argentina/Jujuy
       * * `America/Argentina/La_Rioja` - America/Argentina/La_Rioja
       * * `America/Argentina/Mendoza` - America/Argentina/Mendoza
       * * `America/Argentina/Rio_Gallegos` - America/Argentina/Rio_Gallegos
       * * `America/Argentina/Salta` - America/Argentina/Salta
       * * `America/Argentina/San_Juan` - America/Argentina/San_Juan
       * * `America/Argentina/San_Luis` - America/Argentina/San_Luis
       * * `America/Argentina/Tucuman` - America/Argentina/Tucuman
       * * `America/Argentina/Ushuaia` - America/Argentina/Ushuaia
       * * `America/Aruba` - America/Aruba
       * * `America/Asuncion` - America/Asuncion
       * * `America/Atikokan` - America/Atikokan
       * * `America/Bahia` - America/Bahia
       * * `America/Bahia_Banderas` - America/Bahia_Banderas
       * * `America/Barbados` - America/Barbados
       * * `America/Belem` - America/Belem
       * * `America/Belize` - America/Belize
       * * `America/Blanc-Sablon` - America/Blanc-Sablon
       * * `America/Boa_Vista` - America/Boa_Vista
       * * `America/Bogota` - America/Bogota
       * * `America/Boise` - America/Boise
       * * `America/Cambridge_Bay` - America/Cambridge_Bay
       * * `America/Campo_Grande` - America/Campo_Grande
       * * `America/Cancun` - America/Cancun
       * * `America/Caracas` - America/Caracas
       * * `America/Cayenne` - America/Cayenne
       * * `America/Cayman` - America/Cayman
       * * `America/Chicago` - America/Chicago
       * * `America/Chihuahua` - America/Chihuahua
       * * `America/Ciudad_Juarez` - America/Ciudad_Juarez
       * * `America/Costa_Rica` - America/Costa_Rica
       * * `America/Creston` - America/Creston
       * * `America/Cuiaba` - America/Cuiaba
       * * `America/Curacao` - America/Curacao
       * * `America/Danmarkshavn` - America/Danmarkshavn
       * * `America/Dawson` - America/Dawson
       * * `America/Dawson_Creek` - America/Dawson_Creek
       * * `America/Denver` - America/Denver
       * * `America/Detroit` - America/Detroit
       * * `America/Dominica` - America/Dominica
       * * `America/Edmonton` - America/Edmonton
       * * `America/Eirunepe` - America/Eirunepe
       * * `America/El_Salvador` - America/El_Salvador
       * * `America/Fort_Nelson` - America/Fort_Nelson
       * * `America/Fortaleza` - America/Fortaleza
       * * `America/Glace_Bay` - America/Glace_Bay
       * * `America/Goose_Bay` - America/Goose_Bay
       * * `America/Grand_Turk` - America/Grand_Turk
       * * `America/Grenada` - America/Grenada
       * * `America/Guadeloupe` - America/Guadeloupe
       * * `America/Guatemala` - America/Guatemala
       * * `America/Guayaquil` - America/Guayaquil
       * * `America/Guyana` - America/Guyana
       * * `America/Halifax` - America/Halifax
       * * `America/Havana` - America/Havana
       * * `America/Hermosillo` - America/Hermosillo
       * * `America/Indiana/Indianapolis` - America/Indiana/Indianapolis
       * * `America/Indiana/Knox` - America/Indiana/Knox
       * * `America/Indiana/Marengo` - America/Indiana/Marengo
       * * `America/Indiana/Petersburg` - America/Indiana/Petersburg
       * * `America/Indiana/Tell_City` - America/Indiana/Tell_City
       * * `America/Indiana/Vevay` - America/Indiana/Vevay
       * * `America/Indiana/Vincennes` - America/Indiana/Vincennes
       * * `America/Indiana/Winamac` - America/Indiana/Winamac
       * * `America/Inuvik` - America/Inuvik
       * * `America/Iqaluit` - America/Iqaluit
       * * `America/Jamaica` - America/Jamaica
       * * `America/Juneau` - America/Juneau
       * * `America/Kentucky/Louisville` - America/Kentucky/Louisville
       * * `America/Kentucky/Monticello` - America/Kentucky/Monticello
       * * `America/Kralendijk` - America/Kralendijk
       * * `America/La_Paz` - America/La_Paz
       * * `America/Lima` - America/Lima
       * * `America/Los_Angeles` - America/Los_Angeles
       * * `America/Lower_Princes` - America/Lower_Princes
       * * `America/Maceio` - America/Maceio
       * * `America/Managua` - America/Managua
       * * `America/Manaus` - America/Manaus
       * * `America/Marigot` - America/Marigot
       * * `America/Martinique` - America/Martinique
       * * `America/Matamoros` - America/Matamoros
       * * `America/Mazatlan` - America/Mazatlan
       * * `America/Menominee` - America/Menominee
       * * `America/Merida` - America/Merida
       * * `America/Metlakatla` - America/Metlakatla
       * * `America/Mexico_City` - America/Mexico_City
       * * `America/Miquelon` - America/Miquelon
       * * `America/Moncton` - America/Moncton
       * * `America/Monterrey` - America/Monterrey
       * * `America/Montevideo` - America/Montevideo
       * * `America/Montserrat` - America/Montserrat
       * * `America/Nassau` - America/Nassau
       * * `America/New_York` - America/New_York
       * * `America/Nome` - America/Nome
       * * `America/Noronha` - America/Noronha
       * * `America/North_Dakota/Beulah` - America/North_Dakota/Beulah
       * * `America/North_Dakota/Center` - America/North_Dakota/Center
       * * `America/North_Dakota/New_Salem` - America/North_Dakota/New_Salem
       * * `America/Nuuk` - America/Nuuk
       * * `America/Ojinaga` - America/Ojinaga
       * * `America/Panama` - America/Panama
       * * `America/Paramaribo` - America/Paramaribo
       * * `America/Phoenix` - America/Phoenix
       * * `America/Port-au-Prince` - America/Port-au-Prince
       * * `America/PortOf_Spain` - America/PortOf_Spain
       * * `America/Porto_Velho` - America/Porto_Velho
       * * `America/Puerto_Rico` - America/Puerto_Rico
       * * `America/Punta_Arenas` - America/Punta_Arenas
       * * `America/Rankin_Inlet` - America/Rankin_Inlet
       * * `America/Recife` - America/Recife
       * * `America/Regina` - America/Regina
       * * `America/Resolute` - America/Resolute
       * * `America/Rio_Branco` - America/Rio_Branco
       * * `America/Santarem` - America/Santarem
       * * `America/Santiago` - America/Santiago
       * * `America/Santo_Domingo` - America/Santo_Domingo
       * * `America/Sao_Paulo` - America/Sao_Paulo
       * * `America/Scoresbysund` - America/Scoresbysund
       * * `America/Sitka` - America/Sitka
       * * `America/St_Barthelemy` - America/St_Barthelemy
       * * `America/St_Johns` - America/St_Johns
       * * `America/St_Kitts` - America/St_Kitts
       * * `America/St_Lucia` - America/St_Lucia
       * * `America/St_Thomas` - America/St_Thomas
       * * `America/St_Vincent` - America/St_Vincent
       * * `America/Swift_Current` - America/Swift_Current
       * * `America/Tegucigalpa` - America/Tegucigalpa
       * * `America/Thule` - America/Thule
       * * `America/Tijuana` - America/Tijuana
       * * `America/Toronto` - America/Toronto
       * * `America/Tortola` - America/Tortola
       * * `America/Vancouver` - America/Vancouver
       * * `America/Whitehorse` - America/Whitehorse
       * * `America/Winnipeg` - America/Winnipeg
       * * `America/Yakutat` - America/Yakutat
       * * `America/Yellowknife` - America/Yellowknife
       * * `Antarctica/Casey` - Antarctica/Casey
       * * `Antarctica/Davis` - Antarctica/Davis
       * * `Antarctica/DumontDUrville` - Antarctica/DumontDUrville
       * * `Antarctica/Macquarie` - Antarctica/Macquarie
       * * `Antarctica/Mawson` - Antarctica/Mawson
       * * `Antarctica/McMurdo` - Antarctica/McMurdo
       * * `Antarctica/Palmer` - Antarctica/Palmer
       * * `Antarctica/Rothera` - Antarctica/Rothera
       * * `Antarctica/Syowa` - Antarctica/Syowa
       * * `Antarctica/Troll` - Antarctica/Troll
       * * `Antarctica/Vostok` - Antarctica/Vostok
       * * `Arctic/Longyearbyen` - Arctic/Longyearbyen
       * * `Asia/Aden` - Asia/Aden
       * * `Asia/Almaty` - Asia/Almaty
       * * `Asia/Amman` - Asia/Amman
       * * `Asia/Anadyr` - Asia/Anadyr
       * * `Asia/Aqtau` - Asia/Aqtau
       * * `Asia/Aqtobe` - Asia/Aqtobe
       * * `Asia/Ashgabat` - Asia/Ashgabat
       * * `Asia/Atyrau` - Asia/Atyrau
       * * `Asia/Baghdad` - Asia/Baghdad
       * * `Asia/Bahrain` - Asia/Bahrain
       * * `Asia/Baku` - Asia/Baku
       * * `Asia/Bangkok` - Asia/Bangkok
       * * `Asia/Barnaul` - Asia/Barnaul
       * * `Asia/Beirut` - Asia/Beirut
       * * `Asia/Bishkek` - Asia/Bishkek
       * * `Asia/Brunei` - Asia/Brunei
       * * `Asia/Chita` - Asia/Chita
       * * `Asia/Choibalsan` - Asia/Choibalsan
       * * `Asia/Colombo` - Asia/Colombo
       * * `Asia/Damascus` - Asia/Damascus
       * * `Asia/Dhaka` - Asia/Dhaka
       * * `Asia/Dili` - Asia/Dili
       * * `Asia/Dubai` - Asia/Dubai
       * * `Asia/Dushanbe` - Asia/Dushanbe
       * * `Asia/Famagusta` - Asia/Famagusta
       * * `Asia/Gaza` - Asia/Gaza
       * * `Asia/Hebron` - Asia/Hebron
       * * `Asia/Ho_Chi_Minh` - Asia/Ho_Chi_Minh
       * * `Asia/Hong_Kong` - Asia/Hong_Kong
       * * `Asia/Hovd` - Asia/Hovd
       * * `Asia/Irkutsk` - Asia/Irkutsk
       * * `Asia/Jakarta` - Asia/Jakarta
       * * `Asia/Jayapura` - Asia/Jayapura
       * * `Asia/Jerusalem` - Asia/Jerusalem
       * * `Asia/Kabul` - Asia/Kabul
       * * `Asia/Kamchatka` - Asia/Kamchatka
       * * `Asia/Karachi` - Asia/Karachi
       * * `Asia/Kathmandu` - Asia/Kathmandu
       * * `Asia/Khandyga` - Asia/Khandyga
       * * `Asia/Kolkata` - Asia/Kolkata
       * * `Asia/Krasnoyarsk` - Asia/Krasnoyarsk
       * * `Asia/Kuala_Lumpur` - Asia/Kuala_Lumpur
       * * `Asia/Kuching` - Asia/Kuching
       * * `Asia/Kuwait` - Asia/Kuwait
       * * `Asia/Macau` - Asia/Macau
       * * `Asia/Magadan` - Asia/Magadan
       * * `Asia/Makassar` - Asia/Makassar
       * * `Asia/Manila` - Asia/Manila
       * * `Asia/Muscat` - Asia/Muscat
       * * `Asia/Nicosia` - Asia/Nicosia
       * * `Asia/Novokuznetsk` - Asia/Novokuznetsk
       * * `Asia/Novosibirsk` - Asia/Novosibirsk
       * * `Asia/Omsk` - Asia/Omsk
       * * `Asia/Oral` - Asia/Oral
       * * `Asia/Phnom_Penh` - Asia/Phnom_Penh
       * * `Asia/Pontianak` - Asia/Pontianak
       * * `Asia/Pyongyang` - Asia/Pyongyang
       * * `Asia/Qatar` - Asia/Qatar
       * * `Asia/Qostanay` - Asia/Qostanay
       * * `Asia/Qyzylorda` - Asia/Qyzylorda
       * * `Asia/Riyadh` - Asia/Riyadh
       * * `Asia/Sakhalin` - Asia/Sakhalin
       * * `Asia/Samarkand` - Asia/Samarkand
       * * `Asia/Seoul` - Asia/Seoul
       * * `Asia/Shanghai` - Asia/Shanghai
       * * `Asia/Singapore` - Asia/Singapore
       * * `Asia/Srednekolymsk` - Asia/Srednekolymsk
       * * `Asia/Taipei` - Asia/Taipei
       * * `Asia/Tashkent` - Asia/Tashkent
       * * `Asia/Tbilisi` - Asia/Tbilisi
       * * `Asia/Tehran` - Asia/Tehran
       * * `Asia/Thimphu` - Asia/Thimphu
       * * `Asia/Tokyo` - Asia/Tokyo
       * * `Asia/Tomsk` - Asia/Tomsk
       * * `Asia/Ulaanbaatar` - Asia/Ulaanbaatar
       * * `Asia/Urumqi` - Asia/Urumqi
       * * `Asia/Ust-Nera` - Asia/Ust-Nera
       * * `Asia/Vientiane` - Asia/Vientiane
       * * `Asia/Vladivostok` - Asia/Vladivostok
       * * `Asia/Yakutsk` - Asia/Yakutsk
       * * `Asia/Yangon` - Asia/Yangon
       * * `Asia/Yekaterinburg` - Asia/Yekaterinburg
       * * `Asia/Yerevan` - Asia/Yerevan
       * * `Atlantic/Azores` - Atlantic/Azores
       * * `Atlantic/Bermuda` - Atlantic/Bermuda
       * * `Atlantic/Canary` - Atlantic/Canary
       * * `Atlantic/Cape_Verde` - Atlantic/Cape_Verde
       * * `Atlantic/Faroe` - Atlantic/Faroe
       * * `Atlantic/Madeira` - Atlantic/Madeira
       * * `Atlantic/Reykjavik` - Atlantic/Reykjavik
       * * `Atlantic/South_Georgia` - Atlantic/South_Georgia
       * * `Atlantic/St_Helena` - Atlantic/St_Helena
       * * `Atlantic/Stanley` - Atlantic/Stanley
       * * `Australia/Adelaide` - Australia/Adelaide
       * * `Australia/Brisbane` - Australia/Brisbane
       * * `Australia/Broken_Hill` - Australia/Broken_Hill
       * * `Australia/Darwin` - Australia/Darwin
       * * `Australia/Eucla` - Australia/Eucla
       * * `Australia/Hobart` - Australia/Hobart
       * * `Australia/Lindeman` - Australia/Lindeman
       * * `Australia/Lord_Howe` - Australia/Lord_Howe
       * * `Australia/Melbourne` - Australia/Melbourne
       * * `Australia/Perth` - Australia/Perth
       * * `Australia/Sydney` - Australia/Sydney
       * * `Canada/Atlantic` - Canada/Atlantic
       * * `Canada/Central` - Canada/Central
       * * `Canada/Eastern` - Canada/Eastern
       * * `Canada/Mountain` - Canada/Mountain
       * * `Canada/Newfoundland` - Canada/Newfoundland
       * * `Canada/Pacific` - Canada/Pacific
       * * `Europe/Amsterdam` - Europe/Amsterdam
       * * `Europe/Andorra` - Europe/Andorra
       * * `Europe/Astrakhan` - Europe/Astrakhan
       * * `Europe/Athens` - Europe/Athens
       * * `Europe/Belgrade` - Europe/Belgrade
       * * `Europe/Berlin` - Europe/Berlin
       * * `Europe/Bratislava` - Europe/Bratislava
       * * `Europe/Brussels` - Europe/Brussels
       * * `Europe/Bucharest` - Europe/Bucharest
       * * `Europe/Budapest` - Europe/Budapest
       * * `Europe/Busingen` - Europe/Busingen
       * * `Europe/Chisinau` - Europe/Chisinau
       * * `Europe/Copenhagen` - Europe/Copenhagen
       * * `Europe/Dublin` - Europe/Dublin
       * * `Europe/Gibraltar` - Europe/Gibraltar
       * * `Europe/Guernsey` - Europe/Guernsey
       * * `Europe/Helsinki` - Europe/Helsinki
       * * `Europe/IsleOf_Man` - Europe/IsleOf_Man
       * * `Europe/Istanbul` - Europe/Istanbul
       * * `Europe/Jersey` - Europe/Jersey
       * * `Europe/Kaliningrad` - Europe/Kaliningrad
       * * `Europe/Kirov` - Europe/Kirov
       * * `Europe/Kyiv` - Europe/Kyiv
       * * `Europe/Lisbon` - Europe/Lisbon
       * * `Europe/Ljubljana` - Europe/Ljubljana
       * * `Europe/London` - Europe/London
       * * `Europe/Luxembourg` - Europe/Luxembourg
       * * `Europe/Madrid` - Europe/Madrid
       * * `Europe/Malta` - Europe/Malta
       * * `Europe/Mariehamn` - Europe/Mariehamn
       * * `Europe/Minsk` - Europe/Minsk
       * * `Europe/Monaco` - Europe/Monaco
       * * `Europe/Moscow` - Europe/Moscow
       * * `Europe/Oslo` - Europe/Oslo
       * * `Europe/Paris` - Europe/Paris
       * * `Europe/Podgorica` - Europe/Podgorica
       * * `Europe/Prague` - Europe/Prague
       * * `Europe/Riga` - Europe/Riga
       * * `Europe/Rome` - Europe/Rome
       * * `Europe/Samara` - Europe/Samara
       * * `Europe/San_Marino` - Europe/San_Marino
       * * `Europe/Sarajevo` - Europe/Sarajevo
       * * `Europe/Saratov` - Europe/Saratov
       * * `Europe/Simferopol` - Europe/Simferopol
       * * `Europe/Skopje` - Europe/Skopje
       * * `Europe/Sofia` - Europe/Sofia
       * * `Europe/Stockholm` - Europe/Stockholm
       * * `Europe/Tallinn` - Europe/Tallinn
       * * `Europe/Tirane` - Europe/Tirane
       * * `Europe/Ulyanovsk` - Europe/Ulyanovsk
       * * `Europe/Vaduz` - Europe/Vaduz
       * * `Europe/Vatican` - Europe/Vatican
       * * `Europe/Vienna` - Europe/Vienna
       * * `Europe/Vilnius` - Europe/Vilnius
       * * `Europe/Volgograd` - Europe/Volgograd
       * * `Europe/Warsaw` - Europe/Warsaw
       * * `Europe/Zagreb` - Europe/Zagreb
       * * `Europe/Zurich` - Europe/Zurich
       * * `GMT` - GMT
       * * `Indian/Antananarivo` - Indian/Antananarivo
       * * `Indian/Chagos` - Indian/Chagos
       * * `Indian/Christmas` - Indian/Christmas
       * * `Indian/Cocos` - Indian/Cocos
       * * `Indian/Comoro` - Indian/Comoro
       * * `Indian/Kerguelen` - Indian/Kerguelen
       * * `Indian/Mahe` - Indian/Mahe
       * * `Indian/Maldives` - Indian/Maldives
       * * `Indian/Mauritius` - Indian/Mauritius
       * * `Indian/Mayotte` - Indian/Mayotte
       * * `Indian/Reunion` - Indian/Reunion
       * * `Pacific/Apia` - Pacific/Apia
       * * `Pacific/Auckland` - Pacific/Auckland
       * * `Pacific/Bougainville` - Pacific/Bougainville
       * * `Pacific/Chatham` - Pacific/Chatham
       * * `Pacific/Chuuk` - Pacific/Chuuk
       * * `Pacific/Easter` - Pacific/Easter
       * * `Pacific/Efate` - Pacific/Efate
       * * `Pacific/Fakaofo` - Pacific/Fakaofo
       * * `Pacific/Fiji` - Pacific/Fiji
       * * `Pacific/Funafuti` - Pacific/Funafuti
       * * `Pacific/Galapagos` - Pacific/Galapagos
       * * `Pacific/Gambier` - Pacific/Gambier
       * * `Pacific/Guadalcanal` - Pacific/Guadalcanal
       * * `Pacific/Guam` - Pacific/Guam
       * * `Pacific/Honolulu` - Pacific/Honolulu
       * * `Pacific/Kanton` - Pacific/Kanton
       * * `Pacific/Kiritimati` - Pacific/Kiritimati
       * * `Pacific/Kosrae` - Pacific/Kosrae
       * * `Pacific/Kwajalein` - Pacific/Kwajalein
       * * `Pacific/Majuro` - Pacific/Majuro
       * * `Pacific/Marquesas` - Pacific/Marquesas
       * * `Pacific/Midway` - Pacific/Midway
       * * `Pacific/Nauru` - Pacific/Nauru
       * * `Pacific/Niue` - Pacific/Niue
       * * `Pacific/Norfolk` - Pacific/Norfolk
       * * `Pacific/Noumea` - Pacific/Noumea
       * * `Pacific/Pago_Pago` - Pacific/Pago_Pago
       * * `Pacific/Palau` - Pacific/Palau
       * * `Pacific/Pitcairn` - Pacific/Pitcairn
       * * `Pacific/Pohnpei` - Pacific/Pohnpei
       * * `Pacific/Port_Moresby` - Pacific/Port_Moresby
       * * `Pacific/Rarotonga` - Pacific/Rarotonga
       * * `Pacific/Saipan` - Pacific/Saipan
       * * `Pacific/Tahiti` - Pacific/Tahiti
       * * `Pacific/Tarawa` - Pacific/Tarawa
       * * `Pacific/Tongatapu` - Pacific/Tongatapu
       * * `Pacific/Wake` - Pacific/Wake
       * * `Pacific/Wallis` - Pacific/Wallis
       * * `US/Alaska` - US/Alaska
       * * `US/Arizona` - US/Arizona
       * * `US/Central` - US/Central
       * * `US/Eastern` - US/Eastern
       * * `US/Hawaii` - US/Hawaii
       * * `US/Mountain` - US/Mountain
       * * `US/Pacific` - US/Pacific
       * * `UTC` - UTC 
       * @enum {string}
       */
      timezone: "Africa/Abidjan" | "Africa/Accra" | "Africa/Addis_Ababa" | "Africa/Algiers" | "Africa/Asmara" | "Africa/Bamako" | "Africa/Bangui" | "Africa/Banjul" | "Africa/Bissau" | "Africa/Blantyre" | "Africa/Brazzaville" | "Africa/Bujumbura" | "Africa/Cairo" | "Africa/Casablanca" | "Africa/Ceuta" | "Africa/Conakry" | "Africa/Dakar" | "Africa/DarEs_Salaam" | "Africa/Djibouti" | "Africa/Douala" | "Africa/El_Aaiun" | "Africa/Freetown" | "Africa/Gaborone" | "Africa/Harare" | "Africa/Johannesburg" | "Africa/Juba" | "Africa/Kampala" | "Africa/Khartoum" | "Africa/Kigali" | "Africa/Kinshasa" | "Africa/Lagos" | "Africa/Libreville" | "Africa/Lome" | "Africa/Luanda" | "Africa/Lubumbashi" | "Africa/Lusaka" | "Africa/Malabo" | "Africa/Maputo" | "Africa/Maseru" | "Africa/Mbabane" | "Africa/Mogadishu" | "Africa/Monrovia" | "Africa/Nairobi" | "Africa/Ndjamena" | "Africa/Niamey" | "Africa/Nouakchott" | "Africa/Ouagadougou" | "Africa/Porto-Novo" | "Africa/Sao_Tome" | "Africa/Tripoli" | "Africa/Tunis" | "Africa/Windhoek" | "America/Adak" | "America/Anchorage" | "America/Anguilla" | "America/Antigua" | "America/Araguaina" | "America/Argentina/Buenos_Aires" | "America/Argentina/Catamarca" | "America/Argentina/Cordoba" | "America/Argentina/Jujuy" | "America/Argentina/La_Rioja" | "America/Argentina/Mendoza" | "America/Argentina/Rio_Gallegos" | "America/Argentina/Salta" | "America/Argentina/San_Juan" | "America/Argentina/San_Luis" | "America/Argentina/Tucuman" | "America/Argentina/Ushuaia" | "America/Aruba" | "America/Asuncion" | "America/Atikokan" | "America/Bahia" | "America/Bahia_Banderas" | "America/Barbados" | "America/Belem" | "America/Belize" | "America/Blanc-Sablon" | "America/Boa_Vista" | "America/Bogota" | "America/Boise" | "America/Cambridge_Bay" | "America/Campo_Grande" | "America/Cancun" | "America/Caracas" | "America/Cayenne" | "America/Cayman" | "America/Chicago" | "America/Chihuahua" | "America/Ciudad_Juarez" | "America/Costa_Rica" | "America/Creston" | "America/Cuiaba" | "America/Curacao" | "America/Danmarkshavn" | "America/Dawson" | "America/Dawson_Creek" | "America/Denver" | "America/Detroit" | "America/Dominica" | "America/Edmonton" | "America/Eirunepe" | "America/El_Salvador" | "America/Fort_Nelson" | "America/Fortaleza" | "America/Glace_Bay" | "America/Goose_Bay" | "America/Grand_Turk" | "America/Grenada" | "America/Guadeloupe" | "America/Guatemala" | "America/Guayaquil" | "America/Guyana" | "America/Halifax" | "America/Havana" | "America/Hermosillo" | "America/Indiana/Indianapolis" | "America/Indiana/Knox" | "America/Indiana/Marengo" | "America/Indiana/Petersburg" | "America/Indiana/Tell_City" | "America/Indiana/Vevay" | "America/Indiana/Vincennes" | "America/Indiana/Winamac" | "America/Inuvik" | "America/Iqaluit" | "America/Jamaica" | "America/Juneau" | "America/Kentucky/Louisville" | "America/Kentucky/Monticello" | "America/Kralendijk" | "America/La_Paz" | "America/Lima" | "America/Los_Angeles" | "America/Lower_Princes" | "America/Maceio" | "America/Managua" | "America/Manaus" | "America/Marigot" | "America/Martinique" | "America/Matamoros" | "America/Mazatlan" | "America/Menominee" | "America/Merida" | "America/Metlakatla" | "America/Mexico_City" | "America/Miquelon" | "America/Moncton" | "America/Monterrey" | "America/Montevideo" | "America/Montserrat" | "America/Nassau" | "America/New_York" | "America/Nome" | "America/Noronha" | "America/North_Dakota/Beulah" | "America/North_Dakota/Center" | "America/North_Dakota/New_Salem" | "America/Nuuk" | "America/Ojinaga" | "America/Panama" | "America/Paramaribo" | "America/Phoenix" | "America/Port-au-Prince" | "America/PortOf_Spain" | "America/Porto_Velho" | "America/Puerto_Rico" | "America/Punta_Arenas" | "America/Rankin_Inlet" | "America/Recife" | "America/Regina" | "America/Resolute" | "America/Rio_Branco" | "America/Santarem" | "America/Santiago" | "America/Santo_Domingo" | "America/Sao_Paulo" | "America/Scoresbysund" | "America/Sitka" | "America/St_Barthelemy" | "America/St_Johns" | "America/St_Kitts" | "America/St_Lucia" | "America/St_Thomas" | "America/St_Vincent" | "America/Swift_Current" | "America/Tegucigalpa" | "America/Thule" | "America/Tijuana" | "America/Toronto" | "America/Tortola" | "America/Vancouver" | "America/Whitehorse" | "America/Winnipeg" | "America/Yakutat" | "America/Yellowknife" | "Antarctica/Casey" | "Antarctica/Davis" | "Antarctica/DumontDUrville" | "Antarctica/Macquarie" | "Antarctica/Mawson" | "Antarctica/McMurdo" | "Antarctica/Palmer" | "Antarctica/Rothera" | "Antarctica/Syowa" | "Antarctica/Troll" | "Antarctica/Vostok" | "Arctic/Longyearbyen" | "Asia/Aden" | "Asia/Almaty" | "Asia/Amman" | "Asia/Anadyr" | "Asia/Aqtau" | "Asia/Aqtobe" | "Asia/Ashgabat" | "Asia/Atyrau" | "Asia/Baghdad" | "Asia/Bahrain" | "Asia/Baku" | "Asia/Bangkok" | "Asia/Barnaul" | "Asia/Beirut" | "Asia/Bishkek" | "Asia/Brunei" | "Asia/Chita" | "Asia/Choibalsan" | "Asia/Colombo" | "Asia/Damascus" | "Asia/Dhaka" | "Asia/Dili" | "Asia/Dubai" | "Asia/Dushanbe" | "Asia/Famagusta" | "Asia/Gaza" | "Asia/Hebron" | "Asia/Ho_Chi_Minh" | "Asia/Hong_Kong" | "Asia/Hovd" | "Asia/Irkutsk" | "Asia/Jakarta" | "Asia/Jayapura" | "Asia/Jerusalem" | "Asia/Kabul" | "Asia/Kamchatka" | "Asia/Karachi" | "Asia/Kathmandu" | "Asia/Khandyga" | "Asia/Kolkata" | "Asia/Krasnoyarsk" | "Asia/Kuala_Lumpur" | "Asia/Kuching" | "Asia/Kuwait" | "Asia/Macau" | "Asia/Magadan" | "Asia/Makassar" | "Asia/Manila" | "Asia/Muscat" | "Asia/Nicosia" | "Asia/Novokuznetsk" | "Asia/Novosibirsk" | "Asia/Omsk" | "Asia/Oral" | "Asia/Phnom_Penh" | "Asia/Pontianak" | "Asia/Pyongyang" | "Asia/Qatar" | "Asia/Qostanay" | "Asia/Qyzylorda" | "Asia/Riyadh" | "Asia/Sakhalin" | "Asia/Samarkand" | "Asia/Seoul" | "Asia/Shanghai" | "Asia/Singapore" | "Asia/Srednekolymsk" | "Asia/Taipei" | "Asia/Tashkent" | "Asia/Tbilisi" | "Asia/Tehran" | "Asia/Thimphu" | "Asia/Tokyo" | "Asia/Tomsk" | "Asia/Ulaanbaatar" | "Asia/Urumqi" | "Asia/Ust-Nera" | "Asia/Vientiane" | "Asia/Vladivostok" | "Asia/Yakutsk" | "Asia/Yangon" | "Asia/Yekaterinburg" | "Asia/Yerevan" | "Atlantic/Azores" | "Atlantic/Bermuda" | "Atlantic/Canary" | "Atlantic/Cape_Verde" | "Atlantic/Faroe" | "Atlantic/Madeira" | "Atlantic/Reykjavik" | "Atlantic/South_Georgia" | "Atlantic/St_Helena" | "Atlantic/Stanley" | "Australia/Adelaide" | "Australia/Brisbane" | "Australia/Broken_Hill" | "Australia/Darwin" | "Australia/Eucla" | "Australia/Hobart" | "Australia/Lindeman" | "Australia/Lord_Howe" | "Australia/Melbourne" | "Australia/Perth" | "Australia/Sydney" | "Canada/Atlantic" | "Canada/Central" | "Canada/Eastern" | "Canada/Mountain" | "Canada/Newfoundland" | "Canada/Pacific" | "Europe/Amsterdam" | "Europe/Andorra" | "Europe/Astrakhan" | "Europe/Athens" | "Europe/Belgrade" | "Europe/Berlin" | "Europe/Bratislava" | "Europe/Brussels" | "Europe/Bucharest" | "Europe/Budapest" | "Europe/Busingen" | "Europe/Chisinau" | "Europe/Copenhagen" | "Europe/Dublin" | "Europe/Gibraltar" | "Europe/Guernsey" | "Europe/Helsinki" | "Europe/IsleOf_Man" | "Europe/Istanbul" | "Europe/Jersey" | "Europe/Kaliningrad" | "Europe/Kirov" | "Europe/Kyiv" | "Europe/Lisbon" | "Europe/Ljubljana" | "Europe/London" | "Europe/Luxembourg" | "Europe/Madrid" | "Europe/Malta" | "Europe/Mariehamn" | "Europe/Minsk" | "Europe/Monaco" | "Europe/Moscow" | "Europe/Oslo" | "Europe/Paris" | "Europe/Podgorica" | "Europe/Prague" | "Europe/Riga" | "Europe/Rome" | "Europe/Samara" | "Europe/San_Marino" | "Europe/Sarajevo" | "Europe/Saratov" | "Europe/Simferopol" | "Europe/Skopje" | "Europe/Sofia" | "Europe/Stockholm" | "Europe/Tallinn" | "Europe/Tirane" | "Europe/Ulyanovsk" | "Europe/Vaduz" | "Europe/Vatican" | "Europe/Vienna" | "Europe/Vilnius" | "Europe/Volgograd" | "Europe/Warsaw" | "Europe/Zagreb" | "Europe/Zurich" | "GMT" | "Indian/Antananarivo" | "Indian/Chagos" | "Indian/Christmas" | "Indian/Cocos" | "Indian/Comoro" | "Indian/Kerguelen" | "Indian/Mahe" | "Indian/Maldives" | "Indian/Mauritius" | "Indian/Mayotte" | "Indian/Reunion" | "Pacific/Apia" | "Pacific/Auckland" | "Pacific/Bougainville" | "Pacific/Chatham" | "Pacific/Chuuk" | "Pacific/Easter" | "Pacific/Efate" | "Pacific/Fakaofo" | "Pacific/Fiji" | "Pacific/Funafuti" | "Pacific/Galapagos" | "Pacific/Gambier" | "Pacific/Guadalcanal" | "Pacific/Guam" | "Pacific/Honolulu" | "Pacific/Kanton" | "Pacific/Kiritimati" | "Pacific/Kosrae" | "Pacific/Kwajalein" | "Pacific/Majuro" | "Pacific/Marquesas" | "Pacific/Midway" | "Pacific/Nauru" | "Pacific/Niue" | "Pacific/Norfolk" | "Pacific/Noumea" | "Pacific/Pago_Pago" | "Pacific/Palau" | "Pacific/Pitcairn" | "Pacific/Pohnpei" | "Pacific/Port_Moresby" | "Pacific/Rarotonga" | "Pacific/Saipan" | "Pacific/Tahiti" | "Pacific/Tarawa" | "Pacific/Tongatapu" | "Pacific/Wake" | "Pacific/Wallis" | "US/Alaska" | "US/Arizona" | "US/Central" | "US/Eastern" | "US/Hawaii" | "US/Mountain" | "US/Pacific" | "UTC";
      customerName?: string;
    };
    CustomerWithRevenue: {
      /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
      customerId?: string | null;
      /** Format: double */
      totalAmountDue: number;
    };
    DayMetricUsage: {
      /** Format: date */
      date: string;
      customerUsages: {
        [key: string]: number | undefined;
      };
    };
    DeleteAddOn: {
      success: boolean;
      message: string;
    };
    DeleteAddOnVersion: {
      success: boolean;
      message: string;
    };
    DeletePlan: {
      success: boolean;
      message: string;
    };
    DeletePlanVersion: {
      success: boolean;
      message: string;
    };
    DemoLoginFailure: {
      detail: string;
    };
    DemoLoginRequestRequest: {
      username: string;
      password: string;
    };
    DemoLoginSuccess: {
      detail: string;
      token: string;
      user: components["schemas"]["User"];
    };
    DemoRegistrationDetailRequest: {
      email: string;
      password: string;
      username: string;
    };
    DemoRegistrationFailure: {
      detail: string;
    };
    DemoRegistrationRequest: {
      register: components["schemas"]["DemoRegistrationDetailRequest"];
    };
    DemoRegistrationSuccess: {
      detail: string;
      token: string;
      user: components["schemas"]["User"];
    };
    EmailRequest: {
      /** Format: email */
      email: string;
    };
    EventDetail: {
      /** @description String name of the event, corresponds to definition in metrics */
      eventName: string;
      /** @description Extra metadata on the event that can be filtered and queried on in the metrics. All key value pairs should have string keys and values can be either strings or numbers. Place subscription filters in this object to specify which subscription the event should be tracked under */
      properties?: {
        [key: string]: unknown | undefined;
      };
      /**
       * Format: date-time 
       * @description The time that the event occured, represented as a datetime in RFC3339 in the UTC timezome.
       */
      timeCreated: string;
      /** @description A unique identifier for the specific event being passed in. Passing in a unique id allows Lotus to make sure no double counting occurs. We recommend using a UUID4. */
      idempotencyId: string;
      /** @description The id of the customer that this event is associated with, usually the customer id in your backend */
      customerId: string;
    };
    EventProperties: {
      eventNames: (string)[];
      eventNameToProps: {
        [key: string]: (string)[] | undefined;
      };
    };
    EventRequest: {
      /** @description String name of the event, corresponds to definition in metrics */
      eventName: string;
      /** @description Extra metadata on the event that can be filtered and queried on in the metrics. All key value pairs should have string keys and values can be either strings or numbers. Place subscription filters in this object to specify which subscription the event should be tracked under */
      properties?: {
        [key: string]: unknown | undefined;
      };
      /**
       * Format: date-time 
       * @description The time that the event occured, represented as a datetime in RFC3339 in the UTC timezome.
       */
      timeCreated: string;
      /** @description A unique identifier for the specific event being passed in. Passing in a unique id allows Lotus to make sure no double counting occurs. We recommend using a UUID4. */
      idempotencyId: string;
      /** @description The id of the customer that this event is associated with, usually the customer id in your backend */
      customerId: string;
    };
    ExternalPlanLink: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      source: "stripe" | "braintree";
      externalPlanId: string;
    };
    ExternalPlanLinkRequest: {
      /** Format: uuid */
      planId: string;
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      source: "stripe" | "braintree";
      externalPlanId: string;
    };
    Feature: {
      featureId: string;
      featureName: string;
      featureDescription: string | null;
    };
    FeatureAccessPerSubscription: {
      subscription: components["schemas"]["AccessMethodsSubscriptionRecord"];
      access: boolean;
    };
    FeatureAccessResponse: {
      customer: components["schemas"]["LightweightCustomer"];
      /** @description Whether or not the customer has access to this feature. The default behavior for this is whether any of the customer's plans have access to this feature. If you have specified subscription filters, then this will be whether any of the customer's plans that match the subscription filters have access to this feature. You can customize the behavior of this flag by setting a policy in your Organization settings in the frontend. */
      access: boolean;
      feature: components["schemas"]["Feature"];
      accessPerSubscription: (components["schemas"]["FeatureAccessPerSubscription"])[];
    };
    FeatureCreateRequest: {
      featureName: string;
      featureDescription?: string | null;
    };
    FeatureDetail: {
      featureId: string;
      featureName: string;
      featureDescription: string | null;
    };
    GetEventAccess: {
      /** @description The planId of the plan we are checking that has access to this feature. */
      planId: string;
      /** @description The subscription filters that are applied to this plan's relationship with the customer. If your billing model does not have the ability multiple plans or subscriptions per customer, this is likely not relevant for you. */
      subscriptionFilters: (components["schemas"]["SubscriptionFilter"])[];
      /** @description The usage of each component of the plan the customer is on. Only components that match the request will be included: If metricId is provided, this will be a list of length 1. If eventName is provided, this will be a list of length 1 or more depending on how many components of the customer's plan use this event. */
      usagePerComponent: (components["schemas"]["ComponentUsage"])[];
    };
    GetFeatureAccess: {
      /** @description Name of the feature to check access for. */
      featureName: string;
      /** @description The planId of the plan we are checking that has access to this feature. */
      planId: string;
      /** @description The subscription filters that are applied to this plan's relationship with the customer. If your billing model does not have the ability multiple plans or subscriptions per customer, this is likely not relevant for you. */
      subscriptionFilters: (components["schemas"]["SubscriptionFilter"])[];
      /** @description Whether or not the plan has access to this feature. If your customer can have multiple plans or subscriptions, then you must check the 'access' across all returned plans to determine if the customer can access this feature. */
      access: boolean;
    };
    ImportCustomerFailure: {
      /**
       * @description * `error` - error 
       * @enum {string}
       */
      status: "error";
      detail: string;
    };
    ImportCustomerSuccess: {
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
      detail: string;
    };
    ImportCustomersRequestRequest: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      source: "stripe" | "braintree";
    };
    ImportPaymentObjectFailure: {
      /**
       * @description * `error` - error 
       * @enum {string}
       */
      status: "error";
      detail: string;
    };
    ImportPaymentObjectSuccess: {
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
      detail: string;
    };
    ImportPaymentObjectsRequestRequest: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      source: "stripe" | "braintree";
    };
    ImportSubscriptionsFailure: {
      /**
       * @description * `error` - error 
       * @enum {string}
       */
      status: "error";
      detail: string;
    };
    ImportSubscriptionsRequestRequest: {
      /**
       * @description * `stripe` - Stripe 
       * @enum {string}
       */
      source: "stripe";
    };
    ImportSubscriptionsSuccess: {
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
      detail: string;
    };
    InitResetPasswordSuccess: {
      email: string;
    };
    InitialAddOnVersionCreateRequest: {
      recurringCharges?: (components["schemas"]["RecurringChargeCreateRequest"])[] | null;
      /**
       * @description * `invoiceOnAttach` - invoiceOnAttach
       * * `invoiceOnSubscriptionEnd` - invoiceOnSubscriptionEnd 
       * @enum {unknown}
       */
      invoiceWhen: "invoiceOnAttach" | "invoiceOnSubscriptionEnd";
      components?: (components["schemas"]["PlanComponentCreateRequest"])[] | null;
      features?: (string)[];
      currencyCode: string;
      /**
       * @description * `oneTime` - oneTime
       * * `recurring` - recurring 
       * @enum {unknown}
       */
      billingFrequency: "oneTime" | "recurring";
    };
    InitialExternalPlanLink: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      source: "stripe" | "braintree";
      externalPlanId: string;
    };
    InitialExternalPlanLinkRequest: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      source: "stripe" | "braintree";
      externalPlanId: string;
    };
    InitialPlanVersionCreateRequest: {
      targetCustomerIds?: (string | null)[];
      localizedName?: string | null;
      /** @default false */
      makeActive?: boolean;
      recurringCharges?: (components["schemas"]["RecurringChargeCreateRequest"])[];
      version: number;
      components?: (components["schemas"]["PlanComponentCreateRequest"])[];
      features?: (string)[];
      /**
       * @description * `replaceOnRenewal` - Replace on Renewal
       * * `grandfather` - Grandfather 
       * @default replaceOnRenewal 
       * @enum {string}
       */
      makeActiveType?: "replaceOnRenewal" | "grandfather";
      priceAdjustment?: components["schemas"]["PriceAdjustmentRequest"];
      currencyCode: string;
      dayAnchor?: number | null;
      monthAnchor?: number | null;
    };
    InviteLinkResponse: {
      /** Format: email */
      email: string;
      /** Format: uri */
      link: string;
    };
    InviteRequestRequest: {
      /** Format: email */
      email: string;
    };
    InviteResponse: {
      /** Format: email */
      email: string;
    };
    Invoice: {
      invoiceId: string;
      invoiceNumber: string;
      /**
       * Format: double 
       * @deprecated
       */
      costDue: number;
      /** Format: double */
      amount: number;
      currency: components["schemas"]["PricingUnit"];
      /** Format: date-time */
      issueDate: string;
      /**
       * @description * `draft` - draft
       * * `voided` - voided
       * * `paid` - paid
       * * `unpaid` - unpaid 
       * @enum {unknown}
       */
      paymentStatus: "draft" | "voided" | "paid" | "unpaid";
      externalPaymentObjId: string | null;
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      externalPaymentObjType: "stripe" | "braintree" | "" | null;
      externalPaymentObjStatus?: string | null;
      lineItems: (components["schemas"]["InvoiceLineItem"])[];
      customer: components["schemas"]["LightweightCustomerSerializerForInvoice"];
      /** Format: date-time */
      dueDate: string | null;
      /** Format: date */
      startDate: string;
      /** Format: date */
      endDate: string;
      seller: components["schemas"]["Seller"];
      /** Format: uri */
      invoicePdf: string | null;
    };
    InvoiceCreatedRequest: {
      payload: components["schemas"]["InvoiceRequest"];
    };
    InvoiceDetail: {
      invoiceNumber: string;
      crmProviderId: string | null;
      externalPaymentObjId: string | null;
      /**
       * @description * `salesforce` - salesforce 
       * @enum {string}
       */
      crmProvider: "salesforce";
      /** Format: uri */
      externalPaymentObjUrl: string | null;
      /** Format: uri */
      invoicePdf: string | null;
      /** Format: date-time */
      dueDate: string | null;
      /**
       * @description * `draft` - draft
       * * `voided` - voided
       * * `paid` - paid
       * * `unpaid` - unpaid 
       * @enum {unknown}
       */
      paymentStatus: "draft" | "voided" | "paid" | "unpaid";
      /** Format: date */
      endDate: string;
      invoiceId: string;
      /** Format: date */
      startDate: string;
      lineItems: (components["schemas"]["InvoiceLineItem"])[];
      customer: components["schemas"]["LightweightCustomerSerializerForInvoice"];
      currency: components["schemas"]["PricingUnit"];
      seller: components["schemas"]["Seller"];
      /**
       * Format: double 
       * @deprecated
       */
      costDue: number;
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      externalPaymentObjType: "stripe" | "braintree" | "" | null;
      /** Format: double */
      amount: number;
      /** Format: date-time */
      issueDate: string;
      /** Format: uri */
      crmProviderUrl: string | null;
      externalPaymentObjStatus?: string | null;
    };
    InvoiceDetailRequest: {
      invoiceId: string;
      lineItems: (components["schemas"]["InvoiceLineItemRequest"])[];
      currency: components["schemas"]["PricingUnitRequest"];
      seller: components["schemas"]["SellerRequest"];
      /**
       * Format: double 
       * @deprecated
       */
      costDue: number;
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      externalPaymentObjType: "stripe" | "braintree" | "" | null;
      externalPaymentObjStatus?: string | null;
    };
    InvoiceLineItem: {
      name: string;
      /** Format: date-time */
      startDate: string;
      /** Format: date-time */
      endDate: string;
      /** Format: double */
      quantity: number | null;
      /**
       * @description * `inArrears` - In Arrears
       * * `intermediate` - Intermediate
       * * `inAdvance` - In Advance
       * * `oneTime` - One Time 
       * @enum {string|null}
       */
      billingType: "inArrears" | "intermediate" | "inAdvance" | "oneTime" | "" | null;
      metadata: ({
        [key: string]: unknown | undefined;
      }) | null;
      plan: components["schemas"]["LightweightPlanVersion"] | null;
      subscriptionFilters: readonly (components["schemas"]["SubscriptionFilter"])[] | null;
      /**
       * Format: double 
       * @description Base price of the line item. This is the price before any adjustments are applied.
       */
      base: number;
      adjustments: readonly (components["schemas"]["InvoiceLineItemAdjustment"])[];
      /**
       * Format: double 
       * @description Amount of the line item. This is the price after any adjustments are applied.
       */
      amount: number;
      /**
       * Format: double 
       * @deprecated
       */
      subtotal: number;
    };
    InvoiceLineItemAdjustment: {
      /** Format: decimal */
      amount: string;
      account: string;
      /**
       * @description * `salesTax` - salesTax
       * * `planAdjustment` - planAdjustment 
       * @enum {unknown}
       */
      adjustmentType: "salesTax" | "planAdjustment";
    };
    InvoiceLineItemRequest: {
      name: string;
      /** Format: date-time */
      startDate: string;
      /** Format: date-time */
      endDate: string;
      /** Format: double */
      quantity: number | null;
      /**
       * @description * `inArrears` - In Arrears
       * * `intermediate` - Intermediate
       * * `inAdvance` - In Advance
       * * `oneTime` - One Time 
       * @enum {string|null}
       */
      billingType: "inArrears" | "intermediate" | "inAdvance" | "oneTime" | "" | null;
      metadata: ({
        [key: string]: unknown | undefined;
      }) | null;
      /**
       * Format: double 
       * @description Base price of the line item. This is the price before any adjustments are applied.
       */
      base: number;
      /**
       * Format: double 
       * @description Amount of the line item. This is the price after any adjustments are applied.
       */
      amount: number;
      /**
       * Format: double 
       * @deprecated
       */
      subtotal: number;
    };
    InvoicePaidRequest: {
      payload: components["schemas"]["InvoiceRequest"];
    };
    InvoicePastDueRequest: {
      payload: components["schemas"]["InvoiceRequest"];
    };
    InvoicePayment: {
      invoiceId: string;
      invoiceNumber: string;
      customer: components["schemas"]["LightweightCustomerSerializerForInvoice"];
      /** Format: double */
      amount: number;
      currency: components["schemas"]["PricingUnit"];
      /** Format: date-time */
      paymentDate: string;
      /**
       * @description * `stripe` - stripe
       * * `braintree` - braintree
       * * `lotusOutOfBand` - lotusOutOfBand 
       * @enum {string}
       */
      source: "stripe" | "braintree" | "lotusOutOfBand";
    };
    InvoiceRequest: {
      invoiceId: string;
      /**
       * Format: double 
       * @deprecated
       */
      costDue: number;
      currency: components["schemas"]["PricingUnitRequest"];
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      externalPaymentObjType: "stripe" | "braintree" | "" | null;
      externalPaymentObjStatus?: string | null;
      lineItems: (components["schemas"]["InvoiceLineItemRequest"])[];
      seller: components["schemas"]["SellerRequest"];
    };
    LightweightAddOn: {
      /** @description The name of the add-on plan. */
      addonName: string;
      /** @description The ID of the add-on plan. */
      addonId: string;
      /** @enum {string} */
      addonType: "flat" | "usageBased";
      /**
       * @description * `oneTime` - oneTime
       * * `recurring` - recurring 
       * @enum {unknown}
       */
      billingFrequency: "oneTime" | "recurring";
    };
    LightweightAddOnRequest: {
      /** @description The name of the add-on plan. */
      addonName: string;
      /** @description The ID of the add-on plan. */
      addonId: string;
    };
    LightweightAddOnSubscriptionRecord: {
      addonSubscriptionId: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      startDate: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      endDate: string;
      addon: components["schemas"]["LightweightAddOn"];
      fullyBilled: boolean;
    };
    LightweightAddOnSubscriptionRecordRequest: {
      addonSubscriptionId: string;
      addon: components["schemas"]["LightweightAddOnRequest"];
    };
    LightweightCustomer: {
      /** @description The display name of the customer */
      customerName: string | null;
      /**
       * Format: email 
       * @description The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider
       */
      email: string | null;
      /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
      customerId: string | null;
    };
    LightweightCustomerSerializerForInvoice: {
      /** @description The display name of the customer */
      customerName: string | null;
      /**
       * Format: email 
       * @description The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider
       */
      email: string | null;
      /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
      customerId: string | null;
      address?: components["schemas"]["Address"] | null;
    };
    LightweightInvoice: {
      invoiceNumber: string;
      externalPaymentObjId: string | null;
      /** Format: uri */
      invoicePdf: string | null;
      /** Format: date-time */
      dueDate: string | null;
      /**
       * @description * `draft` - draft
       * * `voided` - voided
       * * `paid` - paid
       * * `unpaid` - unpaid 
       * @enum {unknown}
       */
      paymentStatus: "draft" | "voided" | "paid" | "unpaid";
      /** Format: date */
      endDate: string;
      invoiceId: string;
      /** Format: date */
      startDate: string;
      currency: components["schemas"]["PricingUnit"];
      seller: components["schemas"]["Seller"];
      /**
       * Format: double 
       * @deprecated
       */
      costDue: number;
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      externalPaymentObjType: "stripe" | "braintree" | "" | null;
      /** Format: double */
      amount: number;
      /** Format: date-time */
      issueDate: string;
      externalPaymentObjStatus?: string | null;
    };
    LightweightInvoiceDetail: {
      invoiceNumber: string;
      crmProviderId: string | null;
      externalPaymentObjId: string | null;
      /**
       * @description * `salesforce` - salesforce 
       * @enum {string}
       */
      crmProvider: "salesforce";
      /** Format: uri */
      externalPaymentObjUrl: string | null;
      /** Format: uri */
      invoicePdf: string | null;
      /** Format: date-time */
      dueDate: string | null;
      /** Format: date */
      endDate: string;
      /**
       * @description * `draft` - draft
       * * `voided` - voided
       * * `paid` - paid
       * * `unpaid` - unpaid 
       * @enum {unknown}
       */
      paymentStatus: "draft" | "voided" | "paid" | "unpaid";
      invoiceId: string;
      /** Format: date */
      startDate: string;
      currency: components["schemas"]["PricingUnit"];
      seller: components["schemas"]["Seller"];
      /**
       * Format: double 
       * @deprecated
       */
      costDue: number;
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      externalPaymentObjType: "stripe" | "braintree" | "" | null;
      /** Format: double */
      amount: number;
      /** Format: date-time */
      issueDate: string;
      /** Format: uri */
      crmProviderUrl: string | null;
      externalPaymentObjStatus?: string | null;
    };
    LightweightMetric: {
      metricId: string;
      /** @description Name of the event that this metric is tracking. */
      eventName: string;
      metricName: string;
    };
    LightweightOrganization: {
      organizationId: string;
      organizationName: string;
      /**
       * @description * `Production` - Production
       * * `Development` - Development
       * * `Demo` - Demo
       * * `Internal Demo` - Internal Demo 
       * @enum {string}
       */
      organizationType: "Production" | "Development" | "Demo" | "Internal Demo";
      current: boolean;
    };
    LightweightPlan: {
      /** @description Name of the plan */
      planName: string;
      planId: string;
    };
    LightweightPlanVersion: {
      planName: string;
      planId: string;
      versionId: string;
      version: number | "customVersion";
    };
    LightweightPlanVersionRequest: {
      planId: string;
    };
    LightweightSubscriptionRecord: {
      /** @description Whether this subscription came from a renewal or from a first-time. Defaults to true on creation. */
      isNew: boolean;
      customer: components["schemas"]["LightweightCustomer"];
      billingPlan: components["schemas"]["LightweightPlanVersion"];
      metadata: {
        [key: string]: unknown | undefined;
      };
      fullyBilled: boolean;
      subscriptionFilters: readonly (components["schemas"]["SubscriptionFilter"])[];
      subscriptionId: string;
      planDetail: components["schemas"]["LightweightPlanVersion"];
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      endDate: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      autoRenew: boolean;
      addons: (components["schemas"]["LightweightAddOnSubscriptionRecord"])[];
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      startDate: string;
    };
    LightweightSubscriptionRecordRequest: {
      /** @description Whether this subscription came from a renewal or from a first-time. Defaults to true on creation. */
      isNew: boolean;
      billingPlan: components["schemas"]["LightweightPlanVersionRequest"];
      metadata: {
        [key: string]: unknown | undefined;
      };
      subscriptionId: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      endDate: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      autoRenew: boolean;
      addons: (components["schemas"]["LightweightAddOnSubscriptionRecordRequest"])[];
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      startDate: string;
    };
    LightweightUser: {
      /** @description Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only. */
      username: string;
      /** Format: email */
      email: string;
    };
    LinkTokenResponse: {
      /** @description The token used to link Vessel and the CRM */
      linkToken: string;
    };
    LoginFailure: {
      detail: string;
    };
    LoginRequestRequest: {
      username: string;
      password: string;
    };
    LoginSuccess: {
      detail: string;
      token: string;
      user: components["schemas"]["User"];
    };
    LogoutFailure: {
      detail: string;
    };
    LogoutSuccess: {
      detail: string;
    };
    MakePublicRequestRequest: {
      version: number;
    };
    MakePublicResponse: {
      success: boolean;
      message: string;
    };
    MakeReplaceWithRequest: {
      /** @description The plan versions that will get replaced by the current version. */
      versionsToReplace: (string)[];
    };
    MakeReplaceWithResponse: {
      success: boolean;
      message: string;
    };
    Metric: {
      metricId: string;
      /** @description Name of the event that this metric is tracking. */
      eventName: string;
      /** @description The name of the property of the event that should be used for this metric. Doesn't apply if the metric is of type 'counter' with an aggregation of count. */
      propertyName: string | null;
      aggregationType: string;
      /**
       * @description The granularity of the metric. Only applies to metrics of type 'gauge' or 'rate'.
       * 
       * * `seconds` - Second
       * * `minutes` - Minute
       * * `hours` - Hour
       * * `days` - Day
       * * `months` - Month
       * * `quarters` - Quarter
       * * `years` - Year
       * * `total` - Total 
       * @enum {string|null}
       */
      granularity: "seconds" | "minutes" | "hours" | "days" | "months" | "quarters" | "years" | "total" | "" | null;
      /**
       * @description Used only for metrics of type 'gauge'. Please refer to our documentation for an explanation of the different types.
       * 
       * * `delta` - Delta
       * * `total` - Total 
       * @enum {string|null}
       */
      eventType: "delta" | "total" | "" | null;
      /**
       * @description The type of metric that this is. Please refer to our documentation for an explanation of the different types.
       * 
       * * `counter` - Counter
       * * `rate` - Rate
       * * `custom` - Custom
       * * `gauge` - Gauge 
       * @enum {string}
       */
      metricType: "counter" | "rate" | "custom" | "gauge";
      metricName: string;
      numericFilters: (components["schemas"]["NumericFilter"])[];
      categoricalFilters: (components["schemas"]["CategoricalFilter"])[];
      /** @description Whether or not this metric is a cost metric (used to track costs to your business). */
      isCostMetric: boolean;
      /** @description A custom SQL query that can be used to define the metric. Please refer to our documentation for more information. */
      customSql: string | null;
      /**
       * @description The proration of the metric. Only applies to metrics of type 'gauge'.
       * 
       * * `seconds` - Second
       * * `minutes` - Minute
       * * `hours` - Hour
       * * `days` - Day
       * * `months` - Month
       * * `quarters` - Quarter
       * * `years` - Year
       * * `total` - Total 
       * @enum {string|null}
       */
      proration: "seconds" | "minutes" | "hours" | "days" | "months" | "quarters" | "years" | "total" | "" | null;
    };
    MetricAccessPerSubscription: {
      subscription: components["schemas"]["AccessMethodsSubscriptionRecord"];
      /**
       * Format: double 
       * @description The current usage of the metric. Keep in mind the current usage of the metric can be different from the billable usage of the metric. For examnple, for a gauge metric, the `metricUsage` is the current value of the gauge, while the billable usage is the accumulated tiem at each gauge level at the end of the subscription.
       */
      metricUsage: number;
      /**
       * Format: double 
       * @description If you specified a free tier of usage for this metric, this is the amount of usage that is free. Will be 0 if you didn't specify a free limit for this metric or this subscription doesn't have access to this metric, and null if the free tier is unlimited.
       */
      metricFreeLimit: number | null;
      /**
       * Format: double 
       * @description The total limit of the metric. Will be 0 if this subscription doesn't have access to this metric, and null if there is no limit to this metric.
       */
      metricTotalLimit: number | null;
    };
    MetricAccessResponse: {
      customer: components["schemas"]["LightweightCustomer"];
      /** @description Whether or not the customer has access to this metric. The default behavior for this is whether all of the customer's plans (that have access to the metric) are below the total limit of the metric. If you have specified subscription filters, then this will be whether all of the customer's plans that match the subscription filters are below the total limit of the metric. You can customize the behavior of this flag by setting a policy in your Organization settings in the frontend. */
      access: boolean;
      metric: components["schemas"]["LightweightMetric"];
      accessPerSubscription: (components["schemas"]["MetricAccessPerSubscription"])[];
    };
    MetricCreateRequest: {
      /** @description Name of the event that this metric is tracking. */
      eventName?: string;
      /** @description The name of the property of the event that should be used for this metric. Doesn't apply if the metric is of type 'counter' with an aggregation of count. */
      propertyName?: string | null;
      /**
       * @description The type of aggregation that should be used for this metric. Please refer to our documentation for an explanation of the different types.
       * 
       * * `count` - Count
       * * `sum` - Sum
       * * `max` - Max
       * * `unique` - Unique
       * * `latest` - Latest
       * * `average` - Average 
       * @enum {string|null}
       */
      usageAggregationType?: "count" | "sum" | "max" | "unique" | "latest" | "average" | "" | null;
      /**
       * @description * `count` - Count
       * * `sum` - Sum
       * * `max` - Max
       * * `unique` - Unique
       * * `latest` - Latest
       * * `average` - Average 
       * @enum {string|null}
       */
      billableAggregationType?: "count" | "sum" | "max" | "unique" | "latest" | "average" | "" | null;
      /**
       * @description The granularity of the metric. Only applies to metrics of type 'gauge' or 'rate'.
       * 
       * * `seconds` - Second
       * * `minutes` - Minute
       * * `hours` - Hour
       * * `days` - Day
       * * `months` - Month
       * * `quarters` - Quarter
       * * `years` - Year
       * * `total` - Total 
       * @enum {string|null}
       */
      granularity?: "seconds" | "minutes" | "hours" | "days" | "months" | "quarters" | "years" | "total" | "" | null;
      /**
       * @description Used only for metrics of type 'gauge'. Please refer to our documentation for an explanation of the different types.
       * 
       * * `delta` - Delta
       * * `total` - Total 
       * @enum {string|null}
       */
      eventType?: "delta" | "total" | "" | null;
      /**
       * @description The type of metric that this is. Please refer to our documentation for an explanation of the different types.
       * 
       * * `counter` - Counter
       * * `rate` - Rate
       * * `custom` - Custom
       * * `gauge` - Gauge 
       * @enum {string}
       */
      metricType: "counter" | "rate" | "custom" | "gauge";
      metricName: string;
      /**
       * @description The proration of the metric. Only applies to metrics of type 'gauge'.
       * 
       * * `seconds` - Second
       * * `minutes` - Minute
       * * `hours` - Hour
       * * `days` - Day
       * * `months` - Month
       * * `quarters` - Quarter
       * * `years` - Year
       * * `total` - Total 
       * @enum {string|null}
       */
      proration?: "seconds" | "minutes" | "hours" | "days" | "months" | "quarters" | "years" | "total" | "" | null;
      properties?: ({
        [key: string]: unknown | undefined;
      }) | null;
      /**
       * @description Whether or not this metric is a cost metric (used to track costs to your business). 
       * @default false
       */
      isCostMetric?: boolean;
      /** @description A custom SQL query that can be used to define the metric. Please refer to our documentation for more information. */
      customSql?: string | null;
      categoricalFilters?: (components["schemas"]["CategoricalFilterDetailRequest"])[];
      numericFilters?: (components["schemas"]["NumericFilterDetailRequest"])[];
    };
    MetricDetail: {
      /** @description Name of the event that this metric is tracking. */
      eventName: string;
      /** @description Whether or not this metric is a cost metric (used to track costs to your business). */
      isCostMetric: boolean;
      metricName: string;
      metricId: string;
      /**
       * @description The granularity of the metric. Only applies to metrics of type 'gauge' or 'rate'.
       * 
       * * `seconds` - Second
       * * `minutes` - Minute
       * * `hours` - Hour
       * * `days` - Day
       * * `months` - Month
       * * `quarters` - Quarter
       * * `years` - Year
       * * `total` - Total 
       * @enum {string|null}
       */
      granularity: "seconds" | "minutes" | "hours" | "days" | "months" | "quarters" | "years" | "total" | "" | null;
      /**
       * @description Used only for metrics of type 'gauge'. Please refer to our documentation for an explanation of the different types.
       * 
       * * `delta` - Delta
       * * `total` - Total 
       * @enum {string|null}
       */
      eventType: "delta" | "total" | "" | null;
      /** @description The name of the property of the event that should be used for this metric. Doesn't apply if the metric is of type 'counter' with an aggregation of count. */
      propertyName: string | null;
      numericFilters: (components["schemas"]["NumericFilter"])[];
      categoricalFilters: (components["schemas"]["CategoricalFilter"])[];
      /**
       * @description The proration of the metric. Only applies to metrics of type 'gauge'.
       * 
       * * `seconds` - Second
       * * `minutes` - Minute
       * * `hours` - Hour
       * * `days` - Day
       * * `months` - Month
       * * `quarters` - Quarter
       * * `years` - Year
       * * `total` - Total 
       * @enum {string|null}
       */
      proration: "seconds" | "minutes" | "hours" | "days" | "months" | "quarters" | "years" | "total" | "" | null;
      /** @description A custom SQL query that can be used to define the metric. Please refer to our documentation for more information. */
      customSql: string | null;
      /**
       * @description The type of metric that this is. Please refer to our documentation for an explanation of the different types.
       * 
       * * `counter` - Counter
       * * `rate` - Rate
       * * `custom` - Custom
       * * `gauge` - Gauge 
       * @enum {string}
       */
      metricType: "counter" | "rate" | "custom" | "gauge";
      /**
       * @description The type of aggregation that should be used for this metric. Please refer to our documentation for an explanation of the different types.
       * 
       * * `count` - Count
       * * `sum` - Sum
       * * `max` - Max
       * * `unique` - Unique
       * * `latest` - Latest
       * * `average` - Average 
       * @enum {string}
       */
      usageAggregationType?: "count" | "sum" | "max" | "unique" | "latest" | "average";
      /**
       * @description * `count` - Count
       * * `sum` - Sum
       * * `max` - Max
       * * `unique` - Unique
       * * `latest` - Latest
       * * `average` - Average 
       * @enum {string|null}
       */
      billableAggregationType?: "count" | "sum" | "max" | "unique" | "latest" | "average" | "" | "" | null;
    };
    MetricRequest: {
      metricId: string;
      aggregationType: string;
      metricName: string;
      numericFilters: (components["schemas"]["NumericFilterRequest"])[];
      categoricalFilters: (components["schemas"]["CategoricalFilterRequest"])[];
    };
    MetricRevenue: {
      metricName: string;
      /** Format: double */
      originalPlanRevenue: number;
      /** Format: double */
      newPlanRevenue: number;
    };
    MetricUpdate: {
      billableMetricName?: string | null;
      /**
       * @description * `active` - Active
       * * `archived` - Archived 
       * @enum {string}
       */
      status?: "active" | "archived";
    };
    NextPlanVersionNumberResponse: {
      version: number;
    };
    NumericFilter: {
      propertyName: string;
      /**
       * @description * `gte` - Greater than or equal to
       * * `gt` - Greater than
       * * `eq` - Equal to
       * * `lt` - Less than
       * * `lte` - Less than or equal to 
       * @enum {string}
       */
      operator: "gte" | "gt" | "eq" | "lt" | "lte";
      /** Format: double */
      comparisonValue: number;
    };
    NumericFilterDetailRequest: {
      propertyName: string;
      /**
       * @description * `gte` - Greater than or equal to
       * * `gt` - Greater than
       * * `eq` - Equal to
       * * `lt` - Less than
       * * `lte` - Less than or equal to 
       * @enum {string}
       */
      operator: "gte" | "gt" | "eq" | "lt" | "lte";
      /** Format: double */
      comparisonValue: number;
    };
    NumericFilterRequest: {
      propertyName: string;
      /**
       * @description * `gte` - Greater than or equal to
       * * `gt` - Greater than
       * * `eq` - Equal to
       * * `lt` - Less than
       * * `lte` - Less than or equal to 
       * @enum {string}
       */
      operator: "gte" | "gt" | "eq" | "lt" | "lte";
      /** Format: double */
      comparisonValue: number;
    };
    Organization: {
      organizationId: string;
      organizationName: string;
      users: readonly (components["schemas"]["OrganizationUser"])[];
      defaultCurrency: components["schemas"]["PricingUnitDetail"];
      availableCurrencies: readonly (components["schemas"]["PricingUnitDetail"])[];
      planTags: readonly (components["schemas"]["Tag"])[];
      /**
       * Format: double 
       * @description Tax rate as percentage. For example, 10.5 for 10.5%
       */
      taxRate?: number | null;
      paymentGracePeriod: number | null;
      linkedOrganizations: readonly (components["schemas"]["LightweightOrganization"])[];
      currentUser: components["schemas"]["LightweightUser"];
      address: components["schemas"]["Address"] | null;
      teamName: string;
      /** @description Allowed subscription filter keys */
      subscriptionFilterKeys?: (string)[];
      /**
       * @description * `Africa/Abidjan` - Africa/Abidjan
       * * `Africa/Accra` - Africa/Accra
       * * `Africa/Addis_Ababa` - Africa/Addis_Ababa
       * * `Africa/Algiers` - Africa/Algiers
       * * `Africa/Asmara` - Africa/Asmara
       * * `Africa/Bamako` - Africa/Bamako
       * * `Africa/Bangui` - Africa/Bangui
       * * `Africa/Banjul` - Africa/Banjul
       * * `Africa/Bissau` - Africa/Bissau
       * * `Africa/Blantyre` - Africa/Blantyre
       * * `Africa/Brazzaville` - Africa/Brazzaville
       * * `Africa/Bujumbura` - Africa/Bujumbura
       * * `Africa/Cairo` - Africa/Cairo
       * * `Africa/Casablanca` - Africa/Casablanca
       * * `Africa/Ceuta` - Africa/Ceuta
       * * `Africa/Conakry` - Africa/Conakry
       * * `Africa/Dakar` - Africa/Dakar
       * * `Africa/DarEs_Salaam` - Africa/DarEs_Salaam
       * * `Africa/Djibouti` - Africa/Djibouti
       * * `Africa/Douala` - Africa/Douala
       * * `Africa/El_Aaiun` - Africa/El_Aaiun
       * * `Africa/Freetown` - Africa/Freetown
       * * `Africa/Gaborone` - Africa/Gaborone
       * * `Africa/Harare` - Africa/Harare
       * * `Africa/Johannesburg` - Africa/Johannesburg
       * * `Africa/Juba` - Africa/Juba
       * * `Africa/Kampala` - Africa/Kampala
       * * `Africa/Khartoum` - Africa/Khartoum
       * * `Africa/Kigali` - Africa/Kigali
       * * `Africa/Kinshasa` - Africa/Kinshasa
       * * `Africa/Lagos` - Africa/Lagos
       * * `Africa/Libreville` - Africa/Libreville
       * * `Africa/Lome` - Africa/Lome
       * * `Africa/Luanda` - Africa/Luanda
       * * `Africa/Lubumbashi` - Africa/Lubumbashi
       * * `Africa/Lusaka` - Africa/Lusaka
       * * `Africa/Malabo` - Africa/Malabo
       * * `Africa/Maputo` - Africa/Maputo
       * * `Africa/Maseru` - Africa/Maseru
       * * `Africa/Mbabane` - Africa/Mbabane
       * * `Africa/Mogadishu` - Africa/Mogadishu
       * * `Africa/Monrovia` - Africa/Monrovia
       * * `Africa/Nairobi` - Africa/Nairobi
       * * `Africa/Ndjamena` - Africa/Ndjamena
       * * `Africa/Niamey` - Africa/Niamey
       * * `Africa/Nouakchott` - Africa/Nouakchott
       * * `Africa/Ouagadougou` - Africa/Ouagadougou
       * * `Africa/Porto-Novo` - Africa/Porto-Novo
       * * `Africa/Sao_Tome` - Africa/Sao_Tome
       * * `Africa/Tripoli` - Africa/Tripoli
       * * `Africa/Tunis` - Africa/Tunis
       * * `Africa/Windhoek` - Africa/Windhoek
       * * `America/Adak` - America/Adak
       * * `America/Anchorage` - America/Anchorage
       * * `America/Anguilla` - America/Anguilla
       * * `America/Antigua` - America/Antigua
       * * `America/Araguaina` - America/Araguaina
       * * `America/Argentina/Buenos_Aires` - America/Argentina/Buenos_Aires
       * * `America/Argentina/Catamarca` - America/Argentina/Catamarca
       * * `America/Argentina/Cordoba` - America/Argentina/Cordoba
       * * `America/Argentina/Jujuy` - America/Argentina/Jujuy
       * * `America/Argentina/La_Rioja` - America/Argentina/La_Rioja
       * * `America/Argentina/Mendoza` - America/Argentina/Mendoza
       * * `America/Argentina/Rio_Gallegos` - America/Argentina/Rio_Gallegos
       * * `America/Argentina/Salta` - America/Argentina/Salta
       * * `America/Argentina/San_Juan` - America/Argentina/San_Juan
       * * `America/Argentina/San_Luis` - America/Argentina/San_Luis
       * * `America/Argentina/Tucuman` - America/Argentina/Tucuman
       * * `America/Argentina/Ushuaia` - America/Argentina/Ushuaia
       * * `America/Aruba` - America/Aruba
       * * `America/Asuncion` - America/Asuncion
       * * `America/Atikokan` - America/Atikokan
       * * `America/Bahia` - America/Bahia
       * * `America/Bahia_Banderas` - America/Bahia_Banderas
       * * `America/Barbados` - America/Barbados
       * * `America/Belem` - America/Belem
       * * `America/Belize` - America/Belize
       * * `America/Blanc-Sablon` - America/Blanc-Sablon
       * * `America/Boa_Vista` - America/Boa_Vista
       * * `America/Bogota` - America/Bogota
       * * `America/Boise` - America/Boise
       * * `America/Cambridge_Bay` - America/Cambridge_Bay
       * * `America/Campo_Grande` - America/Campo_Grande
       * * `America/Cancun` - America/Cancun
       * * `America/Caracas` - America/Caracas
       * * `America/Cayenne` - America/Cayenne
       * * `America/Cayman` - America/Cayman
       * * `America/Chicago` - America/Chicago
       * * `America/Chihuahua` - America/Chihuahua
       * * `America/Ciudad_Juarez` - America/Ciudad_Juarez
       * * `America/Costa_Rica` - America/Costa_Rica
       * * `America/Creston` - America/Creston
       * * `America/Cuiaba` - America/Cuiaba
       * * `America/Curacao` - America/Curacao
       * * `America/Danmarkshavn` - America/Danmarkshavn
       * * `America/Dawson` - America/Dawson
       * * `America/Dawson_Creek` - America/Dawson_Creek
       * * `America/Denver` - America/Denver
       * * `America/Detroit` - America/Detroit
       * * `America/Dominica` - America/Dominica
       * * `America/Edmonton` - America/Edmonton
       * * `America/Eirunepe` - America/Eirunepe
       * * `America/El_Salvador` - America/El_Salvador
       * * `America/Fort_Nelson` - America/Fort_Nelson
       * * `America/Fortaleza` - America/Fortaleza
       * * `America/Glace_Bay` - America/Glace_Bay
       * * `America/Goose_Bay` - America/Goose_Bay
       * * `America/Grand_Turk` - America/Grand_Turk
       * * `America/Grenada` - America/Grenada
       * * `America/Guadeloupe` - America/Guadeloupe
       * * `America/Guatemala` - America/Guatemala
       * * `America/Guayaquil` - America/Guayaquil
       * * `America/Guyana` - America/Guyana
       * * `America/Halifax` - America/Halifax
       * * `America/Havana` - America/Havana
       * * `America/Hermosillo` - America/Hermosillo
       * * `America/Indiana/Indianapolis` - America/Indiana/Indianapolis
       * * `America/Indiana/Knox` - America/Indiana/Knox
       * * `America/Indiana/Marengo` - America/Indiana/Marengo
       * * `America/Indiana/Petersburg` - America/Indiana/Petersburg
       * * `America/Indiana/Tell_City` - America/Indiana/Tell_City
       * * `America/Indiana/Vevay` - America/Indiana/Vevay
       * * `America/Indiana/Vincennes` - America/Indiana/Vincennes
       * * `America/Indiana/Winamac` - America/Indiana/Winamac
       * * `America/Inuvik` - America/Inuvik
       * * `America/Iqaluit` - America/Iqaluit
       * * `America/Jamaica` - America/Jamaica
       * * `America/Juneau` - America/Juneau
       * * `America/Kentucky/Louisville` - America/Kentucky/Louisville
       * * `America/Kentucky/Monticello` - America/Kentucky/Monticello
       * * `America/Kralendijk` - America/Kralendijk
       * * `America/La_Paz` - America/La_Paz
       * * `America/Lima` - America/Lima
       * * `America/Los_Angeles` - America/Los_Angeles
       * * `America/Lower_Princes` - America/Lower_Princes
       * * `America/Maceio` - America/Maceio
       * * `America/Managua` - America/Managua
       * * `America/Manaus` - America/Manaus
       * * `America/Marigot` - America/Marigot
       * * `America/Martinique` - America/Martinique
       * * `America/Matamoros` - America/Matamoros
       * * `America/Mazatlan` - America/Mazatlan
       * * `America/Menominee` - America/Menominee
       * * `America/Merida` - America/Merida
       * * `America/Metlakatla` - America/Metlakatla
       * * `America/Mexico_City` - America/Mexico_City
       * * `America/Miquelon` - America/Miquelon
       * * `America/Moncton` - America/Moncton
       * * `America/Monterrey` - America/Monterrey
       * * `America/Montevideo` - America/Montevideo
       * * `America/Montserrat` - America/Montserrat
       * * `America/Nassau` - America/Nassau
       * * `America/New_York` - America/New_York
       * * `America/Nome` - America/Nome
       * * `America/Noronha` - America/Noronha
       * * `America/North_Dakota/Beulah` - America/North_Dakota/Beulah
       * * `America/North_Dakota/Center` - America/North_Dakota/Center
       * * `America/North_Dakota/New_Salem` - America/North_Dakota/New_Salem
       * * `America/Nuuk` - America/Nuuk
       * * `America/Ojinaga` - America/Ojinaga
       * * `America/Panama` - America/Panama
       * * `America/Paramaribo` - America/Paramaribo
       * * `America/Phoenix` - America/Phoenix
       * * `America/Port-au-Prince` - America/Port-au-Prince
       * * `America/PortOf_Spain` - America/PortOf_Spain
       * * `America/Porto_Velho` - America/Porto_Velho
       * * `America/Puerto_Rico` - America/Puerto_Rico
       * * `America/Punta_Arenas` - America/Punta_Arenas
       * * `America/Rankin_Inlet` - America/Rankin_Inlet
       * * `America/Recife` - America/Recife
       * * `America/Regina` - America/Regina
       * * `America/Resolute` - America/Resolute
       * * `America/Rio_Branco` - America/Rio_Branco
       * * `America/Santarem` - America/Santarem
       * * `America/Santiago` - America/Santiago
       * * `America/Santo_Domingo` - America/Santo_Domingo
       * * `America/Sao_Paulo` - America/Sao_Paulo
       * * `America/Scoresbysund` - America/Scoresbysund
       * * `America/Sitka` - America/Sitka
       * * `America/St_Barthelemy` - America/St_Barthelemy
       * * `America/St_Johns` - America/St_Johns
       * * `America/St_Kitts` - America/St_Kitts
       * * `America/St_Lucia` - America/St_Lucia
       * * `America/St_Thomas` - America/St_Thomas
       * * `America/St_Vincent` - America/St_Vincent
       * * `America/Swift_Current` - America/Swift_Current
       * * `America/Tegucigalpa` - America/Tegucigalpa
       * * `America/Thule` - America/Thule
       * * `America/Tijuana` - America/Tijuana
       * * `America/Toronto` - America/Toronto
       * * `America/Tortola` - America/Tortola
       * * `America/Vancouver` - America/Vancouver
       * * `America/Whitehorse` - America/Whitehorse
       * * `America/Winnipeg` - America/Winnipeg
       * * `America/Yakutat` - America/Yakutat
       * * `America/Yellowknife` - America/Yellowknife
       * * `Antarctica/Casey` - Antarctica/Casey
       * * `Antarctica/Davis` - Antarctica/Davis
       * * `Antarctica/DumontDUrville` - Antarctica/DumontDUrville
       * * `Antarctica/Macquarie` - Antarctica/Macquarie
       * * `Antarctica/Mawson` - Antarctica/Mawson
       * * `Antarctica/McMurdo` - Antarctica/McMurdo
       * * `Antarctica/Palmer` - Antarctica/Palmer
       * * `Antarctica/Rothera` - Antarctica/Rothera
       * * `Antarctica/Syowa` - Antarctica/Syowa
       * * `Antarctica/Troll` - Antarctica/Troll
       * * `Antarctica/Vostok` - Antarctica/Vostok
       * * `Arctic/Longyearbyen` - Arctic/Longyearbyen
       * * `Asia/Aden` - Asia/Aden
       * * `Asia/Almaty` - Asia/Almaty
       * * `Asia/Amman` - Asia/Amman
       * * `Asia/Anadyr` - Asia/Anadyr
       * * `Asia/Aqtau` - Asia/Aqtau
       * * `Asia/Aqtobe` - Asia/Aqtobe
       * * `Asia/Ashgabat` - Asia/Ashgabat
       * * `Asia/Atyrau` - Asia/Atyrau
       * * `Asia/Baghdad` - Asia/Baghdad
       * * `Asia/Bahrain` - Asia/Bahrain
       * * `Asia/Baku` - Asia/Baku
       * * `Asia/Bangkok` - Asia/Bangkok
       * * `Asia/Barnaul` - Asia/Barnaul
       * * `Asia/Beirut` - Asia/Beirut
       * * `Asia/Bishkek` - Asia/Bishkek
       * * `Asia/Brunei` - Asia/Brunei
       * * `Asia/Chita` - Asia/Chita
       * * `Asia/Choibalsan` - Asia/Choibalsan
       * * `Asia/Colombo` - Asia/Colombo
       * * `Asia/Damascus` - Asia/Damascus
       * * `Asia/Dhaka` - Asia/Dhaka
       * * `Asia/Dili` - Asia/Dili
       * * `Asia/Dubai` - Asia/Dubai
       * * `Asia/Dushanbe` - Asia/Dushanbe
       * * `Asia/Famagusta` - Asia/Famagusta
       * * `Asia/Gaza` - Asia/Gaza
       * * `Asia/Hebron` - Asia/Hebron
       * * `Asia/Ho_Chi_Minh` - Asia/Ho_Chi_Minh
       * * `Asia/Hong_Kong` - Asia/Hong_Kong
       * * `Asia/Hovd` - Asia/Hovd
       * * `Asia/Irkutsk` - Asia/Irkutsk
       * * `Asia/Jakarta` - Asia/Jakarta
       * * `Asia/Jayapura` - Asia/Jayapura
       * * `Asia/Jerusalem` - Asia/Jerusalem
       * * `Asia/Kabul` - Asia/Kabul
       * * `Asia/Kamchatka` - Asia/Kamchatka
       * * `Asia/Karachi` - Asia/Karachi
       * * `Asia/Kathmandu` - Asia/Kathmandu
       * * `Asia/Khandyga` - Asia/Khandyga
       * * `Asia/Kolkata` - Asia/Kolkata
       * * `Asia/Krasnoyarsk` - Asia/Krasnoyarsk
       * * `Asia/Kuala_Lumpur` - Asia/Kuala_Lumpur
       * * `Asia/Kuching` - Asia/Kuching
       * * `Asia/Kuwait` - Asia/Kuwait
       * * `Asia/Macau` - Asia/Macau
       * * `Asia/Magadan` - Asia/Magadan
       * * `Asia/Makassar` - Asia/Makassar
       * * `Asia/Manila` - Asia/Manila
       * * `Asia/Muscat` - Asia/Muscat
       * * `Asia/Nicosia` - Asia/Nicosia
       * * `Asia/Novokuznetsk` - Asia/Novokuznetsk
       * * `Asia/Novosibirsk` - Asia/Novosibirsk
       * * `Asia/Omsk` - Asia/Omsk
       * * `Asia/Oral` - Asia/Oral
       * * `Asia/Phnom_Penh` - Asia/Phnom_Penh
       * * `Asia/Pontianak` - Asia/Pontianak
       * * `Asia/Pyongyang` - Asia/Pyongyang
       * * `Asia/Qatar` - Asia/Qatar
       * * `Asia/Qostanay` - Asia/Qostanay
       * * `Asia/Qyzylorda` - Asia/Qyzylorda
       * * `Asia/Riyadh` - Asia/Riyadh
       * * `Asia/Sakhalin` - Asia/Sakhalin
       * * `Asia/Samarkand` - Asia/Samarkand
       * * `Asia/Seoul` - Asia/Seoul
       * * `Asia/Shanghai` - Asia/Shanghai
       * * `Asia/Singapore` - Asia/Singapore
       * * `Asia/Srednekolymsk` - Asia/Srednekolymsk
       * * `Asia/Taipei` - Asia/Taipei
       * * `Asia/Tashkent` - Asia/Tashkent
       * * `Asia/Tbilisi` - Asia/Tbilisi
       * * `Asia/Tehran` - Asia/Tehran
       * * `Asia/Thimphu` - Asia/Thimphu
       * * `Asia/Tokyo` - Asia/Tokyo
       * * `Asia/Tomsk` - Asia/Tomsk
       * * `Asia/Ulaanbaatar` - Asia/Ulaanbaatar
       * * `Asia/Urumqi` - Asia/Urumqi
       * * `Asia/Ust-Nera` - Asia/Ust-Nera
       * * `Asia/Vientiane` - Asia/Vientiane
       * * `Asia/Vladivostok` - Asia/Vladivostok
       * * `Asia/Yakutsk` - Asia/Yakutsk
       * * `Asia/Yangon` - Asia/Yangon
       * * `Asia/Yekaterinburg` - Asia/Yekaterinburg
       * * `Asia/Yerevan` - Asia/Yerevan
       * * `Atlantic/Azores` - Atlantic/Azores
       * * `Atlantic/Bermuda` - Atlantic/Bermuda
       * * `Atlantic/Canary` - Atlantic/Canary
       * * `Atlantic/Cape_Verde` - Atlantic/Cape_Verde
       * * `Atlantic/Faroe` - Atlantic/Faroe
       * * `Atlantic/Madeira` - Atlantic/Madeira
       * * `Atlantic/Reykjavik` - Atlantic/Reykjavik
       * * `Atlantic/South_Georgia` - Atlantic/South_Georgia
       * * `Atlantic/St_Helena` - Atlantic/St_Helena
       * * `Atlantic/Stanley` - Atlantic/Stanley
       * * `Australia/Adelaide` - Australia/Adelaide
       * * `Australia/Brisbane` - Australia/Brisbane
       * * `Australia/Broken_Hill` - Australia/Broken_Hill
       * * `Australia/Darwin` - Australia/Darwin
       * * `Australia/Eucla` - Australia/Eucla
       * * `Australia/Hobart` - Australia/Hobart
       * * `Australia/Lindeman` - Australia/Lindeman
       * * `Australia/Lord_Howe` - Australia/Lord_Howe
       * * `Australia/Melbourne` - Australia/Melbourne
       * * `Australia/Perth` - Australia/Perth
       * * `Australia/Sydney` - Australia/Sydney
       * * `Canada/Atlantic` - Canada/Atlantic
       * * `Canada/Central` - Canada/Central
       * * `Canada/Eastern` - Canada/Eastern
       * * `Canada/Mountain` - Canada/Mountain
       * * `Canada/Newfoundland` - Canada/Newfoundland
       * * `Canada/Pacific` - Canada/Pacific
       * * `Europe/Amsterdam` - Europe/Amsterdam
       * * `Europe/Andorra` - Europe/Andorra
       * * `Europe/Astrakhan` - Europe/Astrakhan
       * * `Europe/Athens` - Europe/Athens
       * * `Europe/Belgrade` - Europe/Belgrade
       * * `Europe/Berlin` - Europe/Berlin
       * * `Europe/Bratislava` - Europe/Bratislava
       * * `Europe/Brussels` - Europe/Brussels
       * * `Europe/Bucharest` - Europe/Bucharest
       * * `Europe/Budapest` - Europe/Budapest
       * * `Europe/Busingen` - Europe/Busingen
       * * `Europe/Chisinau` - Europe/Chisinau
       * * `Europe/Copenhagen` - Europe/Copenhagen
       * * `Europe/Dublin` - Europe/Dublin
       * * `Europe/Gibraltar` - Europe/Gibraltar
       * * `Europe/Guernsey` - Europe/Guernsey
       * * `Europe/Helsinki` - Europe/Helsinki
       * * `Europe/IsleOf_Man` - Europe/IsleOf_Man
       * * `Europe/Istanbul` - Europe/Istanbul
       * * `Europe/Jersey` - Europe/Jersey
       * * `Europe/Kaliningrad` - Europe/Kaliningrad
       * * `Europe/Kirov` - Europe/Kirov
       * * `Europe/Kyiv` - Europe/Kyiv
       * * `Europe/Lisbon` - Europe/Lisbon
       * * `Europe/Ljubljana` - Europe/Ljubljana
       * * `Europe/London` - Europe/London
       * * `Europe/Luxembourg` - Europe/Luxembourg
       * * `Europe/Madrid` - Europe/Madrid
       * * `Europe/Malta` - Europe/Malta
       * * `Europe/Mariehamn` - Europe/Mariehamn
       * * `Europe/Minsk` - Europe/Minsk
       * * `Europe/Monaco` - Europe/Monaco
       * * `Europe/Moscow` - Europe/Moscow
       * * `Europe/Oslo` - Europe/Oslo
       * * `Europe/Paris` - Europe/Paris
       * * `Europe/Podgorica` - Europe/Podgorica
       * * `Europe/Prague` - Europe/Prague
       * * `Europe/Riga` - Europe/Riga
       * * `Europe/Rome` - Europe/Rome
       * * `Europe/Samara` - Europe/Samara
       * * `Europe/San_Marino` - Europe/San_Marino
       * * `Europe/Sarajevo` - Europe/Sarajevo
       * * `Europe/Saratov` - Europe/Saratov
       * * `Europe/Simferopol` - Europe/Simferopol
       * * `Europe/Skopje` - Europe/Skopje
       * * `Europe/Sofia` - Europe/Sofia
       * * `Europe/Stockholm` - Europe/Stockholm
       * * `Europe/Tallinn` - Europe/Tallinn
       * * `Europe/Tirane` - Europe/Tirane
       * * `Europe/Ulyanovsk` - Europe/Ulyanovsk
       * * `Europe/Vaduz` - Europe/Vaduz
       * * `Europe/Vatican` - Europe/Vatican
       * * `Europe/Vienna` - Europe/Vienna
       * * `Europe/Vilnius` - Europe/Vilnius
       * * `Europe/Volgograd` - Europe/Volgograd
       * * `Europe/Warsaw` - Europe/Warsaw
       * * `Europe/Zagreb` - Europe/Zagreb
       * * `Europe/Zurich` - Europe/Zurich
       * * `GMT` - GMT
       * * `Indian/Antananarivo` - Indian/Antananarivo
       * * `Indian/Chagos` - Indian/Chagos
       * * `Indian/Christmas` - Indian/Christmas
       * * `Indian/Cocos` - Indian/Cocos
       * * `Indian/Comoro` - Indian/Comoro
       * * `Indian/Kerguelen` - Indian/Kerguelen
       * * `Indian/Mahe` - Indian/Mahe
       * * `Indian/Maldives` - Indian/Maldives
       * * `Indian/Mauritius` - Indian/Mauritius
       * * `Indian/Mayotte` - Indian/Mayotte
       * * `Indian/Reunion` - Indian/Reunion
       * * `Pacific/Apia` - Pacific/Apia
       * * `Pacific/Auckland` - Pacific/Auckland
       * * `Pacific/Bougainville` - Pacific/Bougainville
       * * `Pacific/Chatham` - Pacific/Chatham
       * * `Pacific/Chuuk` - Pacific/Chuuk
       * * `Pacific/Easter` - Pacific/Easter
       * * `Pacific/Efate` - Pacific/Efate
       * * `Pacific/Fakaofo` - Pacific/Fakaofo
       * * `Pacific/Fiji` - Pacific/Fiji
       * * `Pacific/Funafuti` - Pacific/Funafuti
       * * `Pacific/Galapagos` - Pacific/Galapagos
       * * `Pacific/Gambier` - Pacific/Gambier
       * * `Pacific/Guadalcanal` - Pacific/Guadalcanal
       * * `Pacific/Guam` - Pacific/Guam
       * * `Pacific/Honolulu` - Pacific/Honolulu
       * * `Pacific/Kanton` - Pacific/Kanton
       * * `Pacific/Kiritimati` - Pacific/Kiritimati
       * * `Pacific/Kosrae` - Pacific/Kosrae
       * * `Pacific/Kwajalein` - Pacific/Kwajalein
       * * `Pacific/Majuro` - Pacific/Majuro
       * * `Pacific/Marquesas` - Pacific/Marquesas
       * * `Pacific/Midway` - Pacific/Midway
       * * `Pacific/Nauru` - Pacific/Nauru
       * * `Pacific/Niue` - Pacific/Niue
       * * `Pacific/Norfolk` - Pacific/Norfolk
       * * `Pacific/Noumea` - Pacific/Noumea
       * * `Pacific/Pago_Pago` - Pacific/Pago_Pago
       * * `Pacific/Palau` - Pacific/Palau
       * * `Pacific/Pitcairn` - Pacific/Pitcairn
       * * `Pacific/Pohnpei` - Pacific/Pohnpei
       * * `Pacific/Port_Moresby` - Pacific/Port_Moresby
       * * `Pacific/Rarotonga` - Pacific/Rarotonga
       * * `Pacific/Saipan` - Pacific/Saipan
       * * `Pacific/Tahiti` - Pacific/Tahiti
       * * `Pacific/Tarawa` - Pacific/Tarawa
       * * `Pacific/Tongatapu` - Pacific/Tongatapu
       * * `Pacific/Wake` - Pacific/Wake
       * * `Pacific/Wallis` - Pacific/Wallis
       * * `US/Alaska` - US/Alaska
       * * `US/Arizona` - US/Arizona
       * * `US/Central` - US/Central
       * * `US/Eastern` - US/Eastern
       * * `US/Hawaii` - US/Hawaii
       * * `US/Mountain` - US/Mountain
       * * `US/Pacific` - US/Pacific
       * * `UTC` - UTC 
       * @enum {string}
       */
      timezone: "Africa/Abidjan" | "Africa/Accra" | "Africa/Addis_Ababa" | "Africa/Algiers" | "Africa/Asmara" | "Africa/Bamako" | "Africa/Bangui" | "Africa/Banjul" | "Africa/Bissau" | "Africa/Blantyre" | "Africa/Brazzaville" | "Africa/Bujumbura" | "Africa/Cairo" | "Africa/Casablanca" | "Africa/Ceuta" | "Africa/Conakry" | "Africa/Dakar" | "Africa/DarEs_Salaam" | "Africa/Djibouti" | "Africa/Douala" | "Africa/El_Aaiun" | "Africa/Freetown" | "Africa/Gaborone" | "Africa/Harare" | "Africa/Johannesburg" | "Africa/Juba" | "Africa/Kampala" | "Africa/Khartoum" | "Africa/Kigali" | "Africa/Kinshasa" | "Africa/Lagos" | "Africa/Libreville" | "Africa/Lome" | "Africa/Luanda" | "Africa/Lubumbashi" | "Africa/Lusaka" | "Africa/Malabo" | "Africa/Maputo" | "Africa/Maseru" | "Africa/Mbabane" | "Africa/Mogadishu" | "Africa/Monrovia" | "Africa/Nairobi" | "Africa/Ndjamena" | "Africa/Niamey" | "Africa/Nouakchott" | "Africa/Ouagadougou" | "Africa/Porto-Novo" | "Africa/Sao_Tome" | "Africa/Tripoli" | "Africa/Tunis" | "Africa/Windhoek" | "America/Adak" | "America/Anchorage" | "America/Anguilla" | "America/Antigua" | "America/Araguaina" | "America/Argentina/Buenos_Aires" | "America/Argentina/Catamarca" | "America/Argentina/Cordoba" | "America/Argentina/Jujuy" | "America/Argentina/La_Rioja" | "America/Argentina/Mendoza" | "America/Argentina/Rio_Gallegos" | "America/Argentina/Salta" | "America/Argentina/San_Juan" | "America/Argentina/San_Luis" | "America/Argentina/Tucuman" | "America/Argentina/Ushuaia" | "America/Aruba" | "America/Asuncion" | "America/Atikokan" | "America/Bahia" | "America/Bahia_Banderas" | "America/Barbados" | "America/Belem" | "America/Belize" | "America/Blanc-Sablon" | "America/Boa_Vista" | "America/Bogota" | "America/Boise" | "America/Cambridge_Bay" | "America/Campo_Grande" | "America/Cancun" | "America/Caracas" | "America/Cayenne" | "America/Cayman" | "America/Chicago" | "America/Chihuahua" | "America/Ciudad_Juarez" | "America/Costa_Rica" | "America/Creston" | "America/Cuiaba" | "America/Curacao" | "America/Danmarkshavn" | "America/Dawson" | "America/Dawson_Creek" | "America/Denver" | "America/Detroit" | "America/Dominica" | "America/Edmonton" | "America/Eirunepe" | "America/El_Salvador" | "America/Fort_Nelson" | "America/Fortaleza" | "America/Glace_Bay" | "America/Goose_Bay" | "America/Grand_Turk" | "America/Grenada" | "America/Guadeloupe" | "America/Guatemala" | "America/Guayaquil" | "America/Guyana" | "America/Halifax" | "America/Havana" | "America/Hermosillo" | "America/Indiana/Indianapolis" | "America/Indiana/Knox" | "America/Indiana/Marengo" | "America/Indiana/Petersburg" | "America/Indiana/Tell_City" | "America/Indiana/Vevay" | "America/Indiana/Vincennes" | "America/Indiana/Winamac" | "America/Inuvik" | "America/Iqaluit" | "America/Jamaica" | "America/Juneau" | "America/Kentucky/Louisville" | "America/Kentucky/Monticello" | "America/Kralendijk" | "America/La_Paz" | "America/Lima" | "America/Los_Angeles" | "America/Lower_Princes" | "America/Maceio" | "America/Managua" | "America/Manaus" | "America/Marigot" | "America/Martinique" | "America/Matamoros" | "America/Mazatlan" | "America/Menominee" | "America/Merida" | "America/Metlakatla" | "America/Mexico_City" | "America/Miquelon" | "America/Moncton" | "America/Monterrey" | "America/Montevideo" | "America/Montserrat" | "America/Nassau" | "America/New_York" | "America/Nome" | "America/Noronha" | "America/North_Dakota/Beulah" | "America/North_Dakota/Center" | "America/North_Dakota/New_Salem" | "America/Nuuk" | "America/Ojinaga" | "America/Panama" | "America/Paramaribo" | "America/Phoenix" | "America/Port-au-Prince" | "America/PortOf_Spain" | "America/Porto_Velho" | "America/Puerto_Rico" | "America/Punta_Arenas" | "America/Rankin_Inlet" | "America/Recife" | "America/Regina" | "America/Resolute" | "America/Rio_Branco" | "America/Santarem" | "America/Santiago" | "America/Santo_Domingo" | "America/Sao_Paulo" | "America/Scoresbysund" | "America/Sitka" | "America/St_Barthelemy" | "America/St_Johns" | "America/St_Kitts" | "America/St_Lucia" | "America/St_Thomas" | "America/St_Vincent" | "America/Swift_Current" | "America/Tegucigalpa" | "America/Thule" | "America/Tijuana" | "America/Toronto" | "America/Tortola" | "America/Vancouver" | "America/Whitehorse" | "America/Winnipeg" | "America/Yakutat" | "America/Yellowknife" | "Antarctica/Casey" | "Antarctica/Davis" | "Antarctica/DumontDUrville" | "Antarctica/Macquarie" | "Antarctica/Mawson" | "Antarctica/McMurdo" | "Antarctica/Palmer" | "Antarctica/Rothera" | "Antarctica/Syowa" | "Antarctica/Troll" | "Antarctica/Vostok" | "Arctic/Longyearbyen" | "Asia/Aden" | "Asia/Almaty" | "Asia/Amman" | "Asia/Anadyr" | "Asia/Aqtau" | "Asia/Aqtobe" | "Asia/Ashgabat" | "Asia/Atyrau" | "Asia/Baghdad" | "Asia/Bahrain" | "Asia/Baku" | "Asia/Bangkok" | "Asia/Barnaul" | "Asia/Beirut" | "Asia/Bishkek" | "Asia/Brunei" | "Asia/Chita" | "Asia/Choibalsan" | "Asia/Colombo" | "Asia/Damascus" | "Asia/Dhaka" | "Asia/Dili" | "Asia/Dubai" | "Asia/Dushanbe" | "Asia/Famagusta" | "Asia/Gaza" | "Asia/Hebron" | "Asia/Ho_Chi_Minh" | "Asia/Hong_Kong" | "Asia/Hovd" | "Asia/Irkutsk" | "Asia/Jakarta" | "Asia/Jayapura" | "Asia/Jerusalem" | "Asia/Kabul" | "Asia/Kamchatka" | "Asia/Karachi" | "Asia/Kathmandu" | "Asia/Khandyga" | "Asia/Kolkata" | "Asia/Krasnoyarsk" | "Asia/Kuala_Lumpur" | "Asia/Kuching" | "Asia/Kuwait" | "Asia/Macau" | "Asia/Magadan" | "Asia/Makassar" | "Asia/Manila" | "Asia/Muscat" | "Asia/Nicosia" | "Asia/Novokuznetsk" | "Asia/Novosibirsk" | "Asia/Omsk" | "Asia/Oral" | "Asia/Phnom_Penh" | "Asia/Pontianak" | "Asia/Pyongyang" | "Asia/Qatar" | "Asia/Qostanay" | "Asia/Qyzylorda" | "Asia/Riyadh" | "Asia/Sakhalin" | "Asia/Samarkand" | "Asia/Seoul" | "Asia/Shanghai" | "Asia/Singapore" | "Asia/Srednekolymsk" | "Asia/Taipei" | "Asia/Tashkent" | "Asia/Tbilisi" | "Asia/Tehran" | "Asia/Thimphu" | "Asia/Tokyo" | "Asia/Tomsk" | "Asia/Ulaanbaatar" | "Asia/Urumqi" | "Asia/Ust-Nera" | "Asia/Vientiane" | "Asia/Vladivostok" | "Asia/Yakutsk" | "Asia/Yangon" | "Asia/Yekaterinburg" | "Asia/Yerevan" | "Atlantic/Azores" | "Atlantic/Bermuda" | "Atlantic/Canary" | "Atlantic/Cape_Verde" | "Atlantic/Faroe" | "Atlantic/Madeira" | "Atlantic/Reykjavik" | "Atlantic/South_Georgia" | "Atlantic/St_Helena" | "Atlantic/Stanley" | "Australia/Adelaide" | "Australia/Brisbane" | "Australia/Broken_Hill" | "Australia/Darwin" | "Australia/Eucla" | "Australia/Hobart" | "Australia/Lindeman" | "Australia/Lord_Howe" | "Australia/Melbourne" | "Australia/Perth" | "Australia/Sydney" | "Canada/Atlantic" | "Canada/Central" | "Canada/Eastern" | "Canada/Mountain" | "Canada/Newfoundland" | "Canada/Pacific" | "Europe/Amsterdam" | "Europe/Andorra" | "Europe/Astrakhan" | "Europe/Athens" | "Europe/Belgrade" | "Europe/Berlin" | "Europe/Bratislava" | "Europe/Brussels" | "Europe/Bucharest" | "Europe/Budapest" | "Europe/Busingen" | "Europe/Chisinau" | "Europe/Copenhagen" | "Europe/Dublin" | "Europe/Gibraltar" | "Europe/Guernsey" | "Europe/Helsinki" | "Europe/IsleOf_Man" | "Europe/Istanbul" | "Europe/Jersey" | "Europe/Kaliningrad" | "Europe/Kirov" | "Europe/Kyiv" | "Europe/Lisbon" | "Europe/Ljubljana" | "Europe/London" | "Europe/Luxembourg" | "Europe/Madrid" | "Europe/Malta" | "Europe/Mariehamn" | "Europe/Minsk" | "Europe/Monaco" | "Europe/Moscow" | "Europe/Oslo" | "Europe/Paris" | "Europe/Podgorica" | "Europe/Prague" | "Europe/Riga" | "Europe/Rome" | "Europe/Samara" | "Europe/San_Marino" | "Europe/Sarajevo" | "Europe/Saratov" | "Europe/Simferopol" | "Europe/Skopje" | "Europe/Sofia" | "Europe/Stockholm" | "Europe/Tallinn" | "Europe/Tirane" | "Europe/Ulyanovsk" | "Europe/Vaduz" | "Europe/Vatican" | "Europe/Vienna" | "Europe/Vilnius" | "Europe/Volgograd" | "Europe/Warsaw" | "Europe/Zagreb" | "Europe/Zurich" | "GMT" | "Indian/Antananarivo" | "Indian/Chagos" | "Indian/Christmas" | "Indian/Cocos" | "Indian/Comoro" | "Indian/Kerguelen" | "Indian/Mahe" | "Indian/Maldives" | "Indian/Mauritius" | "Indian/Mayotte" | "Indian/Reunion" | "Pacific/Apia" | "Pacific/Auckland" | "Pacific/Bougainville" | "Pacific/Chatham" | "Pacific/Chuuk" | "Pacific/Easter" | "Pacific/Efate" | "Pacific/Fakaofo" | "Pacific/Fiji" | "Pacific/Funafuti" | "Pacific/Galapagos" | "Pacific/Gambier" | "Pacific/Guadalcanal" | "Pacific/Guam" | "Pacific/Honolulu" | "Pacific/Kanton" | "Pacific/Kiritimati" | "Pacific/Kosrae" | "Pacific/Kwajalein" | "Pacific/Majuro" | "Pacific/Marquesas" | "Pacific/Midway" | "Pacific/Nauru" | "Pacific/Niue" | "Pacific/Norfolk" | "Pacific/Noumea" | "Pacific/Pago_Pago" | "Pacific/Palau" | "Pacific/Pitcairn" | "Pacific/Pohnpei" | "Pacific/Port_Moresby" | "Pacific/Rarotonga" | "Pacific/Saipan" | "Pacific/Tahiti" | "Pacific/Tarawa" | "Pacific/Tongatapu" | "Pacific/Wake" | "Pacific/Wallis" | "US/Alaska" | "US/Arizona" | "US/Central" | "US/Eastern" | "US/Hawaii" | "US/Mountain" | "US/Pacific" | "UTC";
      stripeAccountId: string | null;
      braintreeMerchantId: string | null;
      taxProviders: readonly ("taxjar" | "lotus" | "netsuite")[];
      crmIntegrationAllowed: boolean;
    };
    OrganizationCreateRequest: {
      organizationName: string;
      defaultCurrencyCode?: string;
      /**
       * @description * `development` - development
       * * `production` - production 
       * @default development 
       * @enum {string}
       */
      organizationType?: "development" | "production";
    };
    OrganizationSetting: {
      settingId: string;
      /**
       * @description * `generateCustomerAfterCreatingInLotus` - Generate in Stripe after Lotus
       * * `genCustInBraintreeAfterLotus` - Generate in Braintree after Lotus
       * * `subscriptionFilterKeys` - Subscription Filter Keys
       * * `paymentGracePeriod` - Payment Grace Period
       * * `crmCustomerSource` - CRM Customer Source 
       * @enum {string}
       */
      settingName: "generateCustomerAfterCreatingInLotus" | "genCustInBraintreeAfterLotus" | "subscriptionFilterKeys" | "paymentGracePeriod" | "crmCustomerSource";
      settingValues: {
        [key: string]: unknown | undefined;
      };
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree
       * * `billing` - Billing
       * * `crm` - CRM 
       * @enum {string}
       */
      settingGroup?: "stripe" | "braintree" | "billing" | "crm";
    };
    OrganizationSettingUpdate: {
      settingValues?: {
        [key: string]: unknown | undefined;
      };
    };
    OrganizationUser: {
      /** @description Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only. */
      username: string;
      /** Format: email */
      email: string;
      role: string;
      /**
       * @description * `Active` - Active
       * * `Invited` - Invited 
       * @default Active 
       * @enum {string}
       */
      status?: "Active" | "Invited";
    };
    PaginatedActionList: {
      next?: string | null;
      previous?: string | null;
      results?: (components["schemas"]["Action"])[];
    };
    PaginatedEventDetailList: {
      next?: string | null;
      previous?: string | null;
      results?: (components["schemas"]["EventDetail"])[];
    };
    PatchedAddOnUpdateRequest: {
      addonName?: string;
      /** Format: date-time */
      activeFrom?: string;
      /** Format: date-time */
      activeTo?: string | null;
    };
    PatchedAddOnVersionUpdateRequest: {
      addonVersionName?: string;
      /** Format: date-time */
      activeFrom?: string | null;
      /** Format: date-time */
      activeTo?: string | null;
    };
    PatchedCustomerUpdateRequest: {
      defaultCurrencyCode?: string;
      billingAddress?: components["schemas"]["AddressRequest"] | null;
      shippingAddress?: components["schemas"]["AddressRequest"] | null;
      /**
       * Format: double 
       * @description Tax rate as percentage. For example, 10.5 for 10.5%
       */
      taxRate?: number | null;
      /**
       * @description * `Africa/Abidjan` - Africa/Abidjan
       * * `Africa/Accra` - Africa/Accra
       * * `Africa/Addis_Ababa` - Africa/Addis_Ababa
       * * `Africa/Algiers` - Africa/Algiers
       * * `Africa/Asmara` - Africa/Asmara
       * * `Africa/Bamako` - Africa/Bamako
       * * `Africa/Bangui` - Africa/Bangui
       * * `Africa/Banjul` - Africa/Banjul
       * * `Africa/Bissau` - Africa/Bissau
       * * `Africa/Blantyre` - Africa/Blantyre
       * * `Africa/Brazzaville` - Africa/Brazzaville
       * * `Africa/Bujumbura` - Africa/Bujumbura
       * * `Africa/Cairo` - Africa/Cairo
       * * `Africa/Casablanca` - Africa/Casablanca
       * * `Africa/Ceuta` - Africa/Ceuta
       * * `Africa/Conakry` - Africa/Conakry
       * * `Africa/Dakar` - Africa/Dakar
       * * `Africa/DarEs_Salaam` - Africa/DarEs_Salaam
       * * `Africa/Djibouti` - Africa/Djibouti
       * * `Africa/Douala` - Africa/Douala
       * * `Africa/El_Aaiun` - Africa/El_Aaiun
       * * `Africa/Freetown` - Africa/Freetown
       * * `Africa/Gaborone` - Africa/Gaborone
       * * `Africa/Harare` - Africa/Harare
       * * `Africa/Johannesburg` - Africa/Johannesburg
       * * `Africa/Juba` - Africa/Juba
       * * `Africa/Kampala` - Africa/Kampala
       * * `Africa/Khartoum` - Africa/Khartoum
       * * `Africa/Kigali` - Africa/Kigali
       * * `Africa/Kinshasa` - Africa/Kinshasa
       * * `Africa/Lagos` - Africa/Lagos
       * * `Africa/Libreville` - Africa/Libreville
       * * `Africa/Lome` - Africa/Lome
       * * `Africa/Luanda` - Africa/Luanda
       * * `Africa/Lubumbashi` - Africa/Lubumbashi
       * * `Africa/Lusaka` - Africa/Lusaka
       * * `Africa/Malabo` - Africa/Malabo
       * * `Africa/Maputo` - Africa/Maputo
       * * `Africa/Maseru` - Africa/Maseru
       * * `Africa/Mbabane` - Africa/Mbabane
       * * `Africa/Mogadishu` - Africa/Mogadishu
       * * `Africa/Monrovia` - Africa/Monrovia
       * * `Africa/Nairobi` - Africa/Nairobi
       * * `Africa/Ndjamena` - Africa/Ndjamena
       * * `Africa/Niamey` - Africa/Niamey
       * * `Africa/Nouakchott` - Africa/Nouakchott
       * * `Africa/Ouagadougou` - Africa/Ouagadougou
       * * `Africa/Porto-Novo` - Africa/Porto-Novo
       * * `Africa/Sao_Tome` - Africa/Sao_Tome
       * * `Africa/Tripoli` - Africa/Tripoli
       * * `Africa/Tunis` - Africa/Tunis
       * * `Africa/Windhoek` - Africa/Windhoek
       * * `America/Adak` - America/Adak
       * * `America/Anchorage` - America/Anchorage
       * * `America/Anguilla` - America/Anguilla
       * * `America/Antigua` - America/Antigua
       * * `America/Araguaina` - America/Araguaina
       * * `America/Argentina/Buenos_Aires` - America/Argentina/Buenos_Aires
       * * `America/Argentina/Catamarca` - America/Argentina/Catamarca
       * * `America/Argentina/Cordoba` - America/Argentina/Cordoba
       * * `America/Argentina/Jujuy` - America/Argentina/Jujuy
       * * `America/Argentina/La_Rioja` - America/Argentina/La_Rioja
       * * `America/Argentina/Mendoza` - America/Argentina/Mendoza
       * * `America/Argentina/Rio_Gallegos` - America/Argentina/Rio_Gallegos
       * * `America/Argentina/Salta` - America/Argentina/Salta
       * * `America/Argentina/San_Juan` - America/Argentina/San_Juan
       * * `America/Argentina/San_Luis` - America/Argentina/San_Luis
       * * `America/Argentina/Tucuman` - America/Argentina/Tucuman
       * * `America/Argentina/Ushuaia` - America/Argentina/Ushuaia
       * * `America/Aruba` - America/Aruba
       * * `America/Asuncion` - America/Asuncion
       * * `America/Atikokan` - America/Atikokan
       * * `America/Bahia` - America/Bahia
       * * `America/Bahia_Banderas` - America/Bahia_Banderas
       * * `America/Barbados` - America/Barbados
       * * `America/Belem` - America/Belem
       * * `America/Belize` - America/Belize
       * * `America/Blanc-Sablon` - America/Blanc-Sablon
       * * `America/Boa_Vista` - America/Boa_Vista
       * * `America/Bogota` - America/Bogota
       * * `America/Boise` - America/Boise
       * * `America/Cambridge_Bay` - America/Cambridge_Bay
       * * `America/Campo_Grande` - America/Campo_Grande
       * * `America/Cancun` - America/Cancun
       * * `America/Caracas` - America/Caracas
       * * `America/Cayenne` - America/Cayenne
       * * `America/Cayman` - America/Cayman
       * * `America/Chicago` - America/Chicago
       * * `America/Chihuahua` - America/Chihuahua
       * * `America/Ciudad_Juarez` - America/Ciudad_Juarez
       * * `America/Costa_Rica` - America/Costa_Rica
       * * `America/Creston` - America/Creston
       * * `America/Cuiaba` - America/Cuiaba
       * * `America/Curacao` - America/Curacao
       * * `America/Danmarkshavn` - America/Danmarkshavn
       * * `America/Dawson` - America/Dawson
       * * `America/Dawson_Creek` - America/Dawson_Creek
       * * `America/Denver` - America/Denver
       * * `America/Detroit` - America/Detroit
       * * `America/Dominica` - America/Dominica
       * * `America/Edmonton` - America/Edmonton
       * * `America/Eirunepe` - America/Eirunepe
       * * `America/El_Salvador` - America/El_Salvador
       * * `America/Fort_Nelson` - America/Fort_Nelson
       * * `America/Fortaleza` - America/Fortaleza
       * * `America/Glace_Bay` - America/Glace_Bay
       * * `America/Goose_Bay` - America/Goose_Bay
       * * `America/Grand_Turk` - America/Grand_Turk
       * * `America/Grenada` - America/Grenada
       * * `America/Guadeloupe` - America/Guadeloupe
       * * `America/Guatemala` - America/Guatemala
       * * `America/Guayaquil` - America/Guayaquil
       * * `America/Guyana` - America/Guyana
       * * `America/Halifax` - America/Halifax
       * * `America/Havana` - America/Havana
       * * `America/Hermosillo` - America/Hermosillo
       * * `America/Indiana/Indianapolis` - America/Indiana/Indianapolis
       * * `America/Indiana/Knox` - America/Indiana/Knox
       * * `America/Indiana/Marengo` - America/Indiana/Marengo
       * * `America/Indiana/Petersburg` - America/Indiana/Petersburg
       * * `America/Indiana/Tell_City` - America/Indiana/Tell_City
       * * `America/Indiana/Vevay` - America/Indiana/Vevay
       * * `America/Indiana/Vincennes` - America/Indiana/Vincennes
       * * `America/Indiana/Winamac` - America/Indiana/Winamac
       * * `America/Inuvik` - America/Inuvik
       * * `America/Iqaluit` - America/Iqaluit
       * * `America/Jamaica` - America/Jamaica
       * * `America/Juneau` - America/Juneau
       * * `America/Kentucky/Louisville` - America/Kentucky/Louisville
       * * `America/Kentucky/Monticello` - America/Kentucky/Monticello
       * * `America/Kralendijk` - America/Kralendijk
       * * `America/La_Paz` - America/La_Paz
       * * `America/Lima` - America/Lima
       * * `America/Los_Angeles` - America/Los_Angeles
       * * `America/Lower_Princes` - America/Lower_Princes
       * * `America/Maceio` - America/Maceio
       * * `America/Managua` - America/Managua
       * * `America/Manaus` - America/Manaus
       * * `America/Marigot` - America/Marigot
       * * `America/Martinique` - America/Martinique
       * * `America/Matamoros` - America/Matamoros
       * * `America/Mazatlan` - America/Mazatlan
       * * `America/Menominee` - America/Menominee
       * * `America/Merida` - America/Merida
       * * `America/Metlakatla` - America/Metlakatla
       * * `America/Mexico_City` - America/Mexico_City
       * * `America/Miquelon` - America/Miquelon
       * * `America/Moncton` - America/Moncton
       * * `America/Monterrey` - America/Monterrey
       * * `America/Montevideo` - America/Montevideo
       * * `America/Montserrat` - America/Montserrat
       * * `America/Nassau` - America/Nassau
       * * `America/New_York` - America/New_York
       * * `America/Nome` - America/Nome
       * * `America/Noronha` - America/Noronha
       * * `America/North_Dakota/Beulah` - America/North_Dakota/Beulah
       * * `America/North_Dakota/Center` - America/North_Dakota/Center
       * * `America/North_Dakota/New_Salem` - America/North_Dakota/New_Salem
       * * `America/Nuuk` - America/Nuuk
       * * `America/Ojinaga` - America/Ojinaga
       * * `America/Panama` - America/Panama
       * * `America/Paramaribo` - America/Paramaribo
       * * `America/Phoenix` - America/Phoenix
       * * `America/Port-au-Prince` - America/Port-au-Prince
       * * `America/PortOf_Spain` - America/PortOf_Spain
       * * `America/Porto_Velho` - America/Porto_Velho
       * * `America/Puerto_Rico` - America/Puerto_Rico
       * * `America/Punta_Arenas` - America/Punta_Arenas
       * * `America/Rankin_Inlet` - America/Rankin_Inlet
       * * `America/Recife` - America/Recife
       * * `America/Regina` - America/Regina
       * * `America/Resolute` - America/Resolute
       * * `America/Rio_Branco` - America/Rio_Branco
       * * `America/Santarem` - America/Santarem
       * * `America/Santiago` - America/Santiago
       * * `America/Santo_Domingo` - America/Santo_Domingo
       * * `America/Sao_Paulo` - America/Sao_Paulo
       * * `America/Scoresbysund` - America/Scoresbysund
       * * `America/Sitka` - America/Sitka
       * * `America/St_Barthelemy` - America/St_Barthelemy
       * * `America/St_Johns` - America/St_Johns
       * * `America/St_Kitts` - America/St_Kitts
       * * `America/St_Lucia` - America/St_Lucia
       * * `America/St_Thomas` - America/St_Thomas
       * * `America/St_Vincent` - America/St_Vincent
       * * `America/Swift_Current` - America/Swift_Current
       * * `America/Tegucigalpa` - America/Tegucigalpa
       * * `America/Thule` - America/Thule
       * * `America/Tijuana` - America/Tijuana
       * * `America/Toronto` - America/Toronto
       * * `America/Tortola` - America/Tortola
       * * `America/Vancouver` - America/Vancouver
       * * `America/Whitehorse` - America/Whitehorse
       * * `America/Winnipeg` - America/Winnipeg
       * * `America/Yakutat` - America/Yakutat
       * * `America/Yellowknife` - America/Yellowknife
       * * `Antarctica/Casey` - Antarctica/Casey
       * * `Antarctica/Davis` - Antarctica/Davis
       * * `Antarctica/DumontDUrville` - Antarctica/DumontDUrville
       * * `Antarctica/Macquarie` - Antarctica/Macquarie
       * * `Antarctica/Mawson` - Antarctica/Mawson
       * * `Antarctica/McMurdo` - Antarctica/McMurdo
       * * `Antarctica/Palmer` - Antarctica/Palmer
       * * `Antarctica/Rothera` - Antarctica/Rothera
       * * `Antarctica/Syowa` - Antarctica/Syowa
       * * `Antarctica/Troll` - Antarctica/Troll
       * * `Antarctica/Vostok` - Antarctica/Vostok
       * * `Arctic/Longyearbyen` - Arctic/Longyearbyen
       * * `Asia/Aden` - Asia/Aden
       * * `Asia/Almaty` - Asia/Almaty
       * * `Asia/Amman` - Asia/Amman
       * * `Asia/Anadyr` - Asia/Anadyr
       * * `Asia/Aqtau` - Asia/Aqtau
       * * `Asia/Aqtobe` - Asia/Aqtobe
       * * `Asia/Ashgabat` - Asia/Ashgabat
       * * `Asia/Atyrau` - Asia/Atyrau
       * * `Asia/Baghdad` - Asia/Baghdad
       * * `Asia/Bahrain` - Asia/Bahrain
       * * `Asia/Baku` - Asia/Baku
       * * `Asia/Bangkok` - Asia/Bangkok
       * * `Asia/Barnaul` - Asia/Barnaul
       * * `Asia/Beirut` - Asia/Beirut
       * * `Asia/Bishkek` - Asia/Bishkek
       * * `Asia/Brunei` - Asia/Brunei
       * * `Asia/Chita` - Asia/Chita
       * * `Asia/Choibalsan` - Asia/Choibalsan
       * * `Asia/Colombo` - Asia/Colombo
       * * `Asia/Damascus` - Asia/Damascus
       * * `Asia/Dhaka` - Asia/Dhaka
       * * `Asia/Dili` - Asia/Dili
       * * `Asia/Dubai` - Asia/Dubai
       * * `Asia/Dushanbe` - Asia/Dushanbe
       * * `Asia/Famagusta` - Asia/Famagusta
       * * `Asia/Gaza` - Asia/Gaza
       * * `Asia/Hebron` - Asia/Hebron
       * * `Asia/Ho_Chi_Minh` - Asia/Ho_Chi_Minh
       * * `Asia/Hong_Kong` - Asia/Hong_Kong
       * * `Asia/Hovd` - Asia/Hovd
       * * `Asia/Irkutsk` - Asia/Irkutsk
       * * `Asia/Jakarta` - Asia/Jakarta
       * * `Asia/Jayapura` - Asia/Jayapura
       * * `Asia/Jerusalem` - Asia/Jerusalem
       * * `Asia/Kabul` - Asia/Kabul
       * * `Asia/Kamchatka` - Asia/Kamchatka
       * * `Asia/Karachi` - Asia/Karachi
       * * `Asia/Kathmandu` - Asia/Kathmandu
       * * `Asia/Khandyga` - Asia/Khandyga
       * * `Asia/Kolkata` - Asia/Kolkata
       * * `Asia/Krasnoyarsk` - Asia/Krasnoyarsk
       * * `Asia/Kuala_Lumpur` - Asia/Kuala_Lumpur
       * * `Asia/Kuching` - Asia/Kuching
       * * `Asia/Kuwait` - Asia/Kuwait
       * * `Asia/Macau` - Asia/Macau
       * * `Asia/Magadan` - Asia/Magadan
       * * `Asia/Makassar` - Asia/Makassar
       * * `Asia/Manila` - Asia/Manila
       * * `Asia/Muscat` - Asia/Muscat
       * * `Asia/Nicosia` - Asia/Nicosia
       * * `Asia/Novokuznetsk` - Asia/Novokuznetsk
       * * `Asia/Novosibirsk` - Asia/Novosibirsk
       * * `Asia/Omsk` - Asia/Omsk
       * * `Asia/Oral` - Asia/Oral
       * * `Asia/Phnom_Penh` - Asia/Phnom_Penh
       * * `Asia/Pontianak` - Asia/Pontianak
       * * `Asia/Pyongyang` - Asia/Pyongyang
       * * `Asia/Qatar` - Asia/Qatar
       * * `Asia/Qostanay` - Asia/Qostanay
       * * `Asia/Qyzylorda` - Asia/Qyzylorda
       * * `Asia/Riyadh` - Asia/Riyadh
       * * `Asia/Sakhalin` - Asia/Sakhalin
       * * `Asia/Samarkand` - Asia/Samarkand
       * * `Asia/Seoul` - Asia/Seoul
       * * `Asia/Shanghai` - Asia/Shanghai
       * * `Asia/Singapore` - Asia/Singapore
       * * `Asia/Srednekolymsk` - Asia/Srednekolymsk
       * * `Asia/Taipei` - Asia/Taipei
       * * `Asia/Tashkent` - Asia/Tashkent
       * * `Asia/Tbilisi` - Asia/Tbilisi
       * * `Asia/Tehran` - Asia/Tehran
       * * `Asia/Thimphu` - Asia/Thimphu
       * * `Asia/Tokyo` - Asia/Tokyo
       * * `Asia/Tomsk` - Asia/Tomsk
       * * `Asia/Ulaanbaatar` - Asia/Ulaanbaatar
       * * `Asia/Urumqi` - Asia/Urumqi
       * * `Asia/Ust-Nera` - Asia/Ust-Nera
       * * `Asia/Vientiane` - Asia/Vientiane
       * * `Asia/Vladivostok` - Asia/Vladivostok
       * * `Asia/Yakutsk` - Asia/Yakutsk
       * * `Asia/Yangon` - Asia/Yangon
       * * `Asia/Yekaterinburg` - Asia/Yekaterinburg
       * * `Asia/Yerevan` - Asia/Yerevan
       * * `Atlantic/Azores` - Atlantic/Azores
       * * `Atlantic/Bermuda` - Atlantic/Bermuda
       * * `Atlantic/Canary` - Atlantic/Canary
       * * `Atlantic/Cape_Verde` - Atlantic/Cape_Verde
       * * `Atlantic/Faroe` - Atlantic/Faroe
       * * `Atlantic/Madeira` - Atlantic/Madeira
       * * `Atlantic/Reykjavik` - Atlantic/Reykjavik
       * * `Atlantic/South_Georgia` - Atlantic/South_Georgia
       * * `Atlantic/St_Helena` - Atlantic/St_Helena
       * * `Atlantic/Stanley` - Atlantic/Stanley
       * * `Australia/Adelaide` - Australia/Adelaide
       * * `Australia/Brisbane` - Australia/Brisbane
       * * `Australia/Broken_Hill` - Australia/Broken_Hill
       * * `Australia/Darwin` - Australia/Darwin
       * * `Australia/Eucla` - Australia/Eucla
       * * `Australia/Hobart` - Australia/Hobart
       * * `Australia/Lindeman` - Australia/Lindeman
       * * `Australia/Lord_Howe` - Australia/Lord_Howe
       * * `Australia/Melbourne` - Australia/Melbourne
       * * `Australia/Perth` - Australia/Perth
       * * `Australia/Sydney` - Australia/Sydney
       * * `Canada/Atlantic` - Canada/Atlantic
       * * `Canada/Central` - Canada/Central
       * * `Canada/Eastern` - Canada/Eastern
       * * `Canada/Mountain` - Canada/Mountain
       * * `Canada/Newfoundland` - Canada/Newfoundland
       * * `Canada/Pacific` - Canada/Pacific
       * * `Europe/Amsterdam` - Europe/Amsterdam
       * * `Europe/Andorra` - Europe/Andorra
       * * `Europe/Astrakhan` - Europe/Astrakhan
       * * `Europe/Athens` - Europe/Athens
       * * `Europe/Belgrade` - Europe/Belgrade
       * * `Europe/Berlin` - Europe/Berlin
       * * `Europe/Bratislava` - Europe/Bratislava
       * * `Europe/Brussels` - Europe/Brussels
       * * `Europe/Bucharest` - Europe/Bucharest
       * * `Europe/Budapest` - Europe/Budapest
       * * `Europe/Busingen` - Europe/Busingen
       * * `Europe/Chisinau` - Europe/Chisinau
       * * `Europe/Copenhagen` - Europe/Copenhagen
       * * `Europe/Dublin` - Europe/Dublin
       * * `Europe/Gibraltar` - Europe/Gibraltar
       * * `Europe/Guernsey` - Europe/Guernsey
       * * `Europe/Helsinki` - Europe/Helsinki
       * * `Europe/IsleOf_Man` - Europe/IsleOf_Man
       * * `Europe/Istanbul` - Europe/Istanbul
       * * `Europe/Jersey` - Europe/Jersey
       * * `Europe/Kaliningrad` - Europe/Kaliningrad
       * * `Europe/Kirov` - Europe/Kirov
       * * `Europe/Kyiv` - Europe/Kyiv
       * * `Europe/Lisbon` - Europe/Lisbon
       * * `Europe/Ljubljana` - Europe/Ljubljana
       * * `Europe/London` - Europe/London
       * * `Europe/Luxembourg` - Europe/Luxembourg
       * * `Europe/Madrid` - Europe/Madrid
       * * `Europe/Malta` - Europe/Malta
       * * `Europe/Mariehamn` - Europe/Mariehamn
       * * `Europe/Minsk` - Europe/Minsk
       * * `Europe/Monaco` - Europe/Monaco
       * * `Europe/Moscow` - Europe/Moscow
       * * `Europe/Oslo` - Europe/Oslo
       * * `Europe/Paris` - Europe/Paris
       * * `Europe/Podgorica` - Europe/Podgorica
       * * `Europe/Prague` - Europe/Prague
       * * `Europe/Riga` - Europe/Riga
       * * `Europe/Rome` - Europe/Rome
       * * `Europe/Samara` - Europe/Samara
       * * `Europe/San_Marino` - Europe/San_Marino
       * * `Europe/Sarajevo` - Europe/Sarajevo
       * * `Europe/Saratov` - Europe/Saratov
       * * `Europe/Simferopol` - Europe/Simferopol
       * * `Europe/Skopje` - Europe/Skopje
       * * `Europe/Sofia` - Europe/Sofia
       * * `Europe/Stockholm` - Europe/Stockholm
       * * `Europe/Tallinn` - Europe/Tallinn
       * * `Europe/Tirane` - Europe/Tirane
       * * `Europe/Ulyanovsk` - Europe/Ulyanovsk
       * * `Europe/Vaduz` - Europe/Vaduz
       * * `Europe/Vatican` - Europe/Vatican
       * * `Europe/Vienna` - Europe/Vienna
       * * `Europe/Vilnius` - Europe/Vilnius
       * * `Europe/Volgograd` - Europe/Volgograd
       * * `Europe/Warsaw` - Europe/Warsaw
       * * `Europe/Zagreb` - Europe/Zagreb
       * * `Europe/Zurich` - Europe/Zurich
       * * `GMT` - GMT
       * * `Indian/Antananarivo` - Indian/Antananarivo
       * * `Indian/Chagos` - Indian/Chagos
       * * `Indian/Christmas` - Indian/Christmas
       * * `Indian/Cocos` - Indian/Cocos
       * * `Indian/Comoro` - Indian/Comoro
       * * `Indian/Kerguelen` - Indian/Kerguelen
       * * `Indian/Mahe` - Indian/Mahe
       * * `Indian/Maldives` - Indian/Maldives
       * * `Indian/Mauritius` - Indian/Mauritius
       * * `Indian/Mayotte` - Indian/Mayotte
       * * `Indian/Reunion` - Indian/Reunion
       * * `Pacific/Apia` - Pacific/Apia
       * * `Pacific/Auckland` - Pacific/Auckland
       * * `Pacific/Bougainville` - Pacific/Bougainville
       * * `Pacific/Chatham` - Pacific/Chatham
       * * `Pacific/Chuuk` - Pacific/Chuuk
       * * `Pacific/Easter` - Pacific/Easter
       * * `Pacific/Efate` - Pacific/Efate
       * * `Pacific/Fakaofo` - Pacific/Fakaofo
       * * `Pacific/Fiji` - Pacific/Fiji
       * * `Pacific/Funafuti` - Pacific/Funafuti
       * * `Pacific/Galapagos` - Pacific/Galapagos
       * * `Pacific/Gambier` - Pacific/Gambier
       * * `Pacific/Guadalcanal` - Pacific/Guadalcanal
       * * `Pacific/Guam` - Pacific/Guam
       * * `Pacific/Honolulu` - Pacific/Honolulu
       * * `Pacific/Kanton` - Pacific/Kanton
       * * `Pacific/Kiritimati` - Pacific/Kiritimati
       * * `Pacific/Kosrae` - Pacific/Kosrae
       * * `Pacific/Kwajalein` - Pacific/Kwajalein
       * * `Pacific/Majuro` - Pacific/Majuro
       * * `Pacific/Marquesas` - Pacific/Marquesas
       * * `Pacific/Midway` - Pacific/Midway
       * * `Pacific/Nauru` - Pacific/Nauru
       * * `Pacific/Niue` - Pacific/Niue
       * * `Pacific/Norfolk` - Pacific/Norfolk
       * * `Pacific/Noumea` - Pacific/Noumea
       * * `Pacific/Pago_Pago` - Pacific/Pago_Pago
       * * `Pacific/Palau` - Pacific/Palau
       * * `Pacific/Pitcairn` - Pacific/Pitcairn
       * * `Pacific/Pohnpei` - Pacific/Pohnpei
       * * `Pacific/Port_Moresby` - Pacific/Port_Moresby
       * * `Pacific/Rarotonga` - Pacific/Rarotonga
       * * `Pacific/Saipan` - Pacific/Saipan
       * * `Pacific/Tahiti` - Pacific/Tahiti
       * * `Pacific/Tarawa` - Pacific/Tarawa
       * * `Pacific/Tongatapu` - Pacific/Tongatapu
       * * `Pacific/Wake` - Pacific/Wake
       * * `Pacific/Wallis` - Pacific/Wallis
       * * `US/Alaska` - US/Alaska
       * * `US/Arizona` - US/Arizona
       * * `US/Central` - US/Central
       * * `US/Eastern` - US/Eastern
       * * `US/Hawaii` - US/Hawaii
       * * `US/Mountain` - US/Mountain
       * * `US/Pacific` - US/Pacific
       * * `UTC` - UTC 
       * @enum {string}
       */
      timezone?: "Africa/Abidjan" | "Africa/Accra" | "Africa/Addis_Ababa" | "Africa/Algiers" | "Africa/Asmara" | "Africa/Bamako" | "Africa/Bangui" | "Africa/Banjul" | "Africa/Bissau" | "Africa/Blantyre" | "Africa/Brazzaville" | "Africa/Bujumbura" | "Africa/Cairo" | "Africa/Casablanca" | "Africa/Ceuta" | "Africa/Conakry" | "Africa/Dakar" | "Africa/DarEs_Salaam" | "Africa/Djibouti" | "Africa/Douala" | "Africa/El_Aaiun" | "Africa/Freetown" | "Africa/Gaborone" | "Africa/Harare" | "Africa/Johannesburg" | "Africa/Juba" | "Africa/Kampala" | "Africa/Khartoum" | "Africa/Kigali" | "Africa/Kinshasa" | "Africa/Lagos" | "Africa/Libreville" | "Africa/Lome" | "Africa/Luanda" | "Africa/Lubumbashi" | "Africa/Lusaka" | "Africa/Malabo" | "Africa/Maputo" | "Africa/Maseru" | "Africa/Mbabane" | "Africa/Mogadishu" | "Africa/Monrovia" | "Africa/Nairobi" | "Africa/Ndjamena" | "Africa/Niamey" | "Africa/Nouakchott" | "Africa/Ouagadougou" | "Africa/Porto-Novo" | "Africa/Sao_Tome" | "Africa/Tripoli" | "Africa/Tunis" | "Africa/Windhoek" | "America/Adak" | "America/Anchorage" | "America/Anguilla" | "America/Antigua" | "America/Araguaina" | "America/Argentina/Buenos_Aires" | "America/Argentina/Catamarca" | "America/Argentina/Cordoba" | "America/Argentina/Jujuy" | "America/Argentina/La_Rioja" | "America/Argentina/Mendoza" | "America/Argentina/Rio_Gallegos" | "America/Argentina/Salta" | "America/Argentina/San_Juan" | "America/Argentina/San_Luis" | "America/Argentina/Tucuman" | "America/Argentina/Ushuaia" | "America/Aruba" | "America/Asuncion" | "America/Atikokan" | "America/Bahia" | "America/Bahia_Banderas" | "America/Barbados" | "America/Belem" | "America/Belize" | "America/Blanc-Sablon" | "America/Boa_Vista" | "America/Bogota" | "America/Boise" | "America/Cambridge_Bay" | "America/Campo_Grande" | "America/Cancun" | "America/Caracas" | "America/Cayenne" | "America/Cayman" | "America/Chicago" | "America/Chihuahua" | "America/Ciudad_Juarez" | "America/Costa_Rica" | "America/Creston" | "America/Cuiaba" | "America/Curacao" | "America/Danmarkshavn" | "America/Dawson" | "America/Dawson_Creek" | "America/Denver" | "America/Detroit" | "America/Dominica" | "America/Edmonton" | "America/Eirunepe" | "America/El_Salvador" | "America/Fort_Nelson" | "America/Fortaleza" | "America/Glace_Bay" | "America/Goose_Bay" | "America/Grand_Turk" | "America/Grenada" | "America/Guadeloupe" | "America/Guatemala" | "America/Guayaquil" | "America/Guyana" | "America/Halifax" | "America/Havana" | "America/Hermosillo" | "America/Indiana/Indianapolis" | "America/Indiana/Knox" | "America/Indiana/Marengo" | "America/Indiana/Petersburg" | "America/Indiana/Tell_City" | "America/Indiana/Vevay" | "America/Indiana/Vincennes" | "America/Indiana/Winamac" | "America/Inuvik" | "America/Iqaluit" | "America/Jamaica" | "America/Juneau" | "America/Kentucky/Louisville" | "America/Kentucky/Monticello" | "America/Kralendijk" | "America/La_Paz" | "America/Lima" | "America/Los_Angeles" | "America/Lower_Princes" | "America/Maceio" | "America/Managua" | "America/Manaus" | "America/Marigot" | "America/Martinique" | "America/Matamoros" | "America/Mazatlan" | "America/Menominee" | "America/Merida" | "America/Metlakatla" | "America/Mexico_City" | "America/Miquelon" | "America/Moncton" | "America/Monterrey" | "America/Montevideo" | "America/Montserrat" | "America/Nassau" | "America/New_York" | "America/Nome" | "America/Noronha" | "America/North_Dakota/Beulah" | "America/North_Dakota/Center" | "America/North_Dakota/New_Salem" | "America/Nuuk" | "America/Ojinaga" | "America/Panama" | "America/Paramaribo" | "America/Phoenix" | "America/Port-au-Prince" | "America/PortOf_Spain" | "America/Porto_Velho" | "America/Puerto_Rico" | "America/Punta_Arenas" | "America/Rankin_Inlet" | "America/Recife" | "America/Regina" | "America/Resolute" | "America/Rio_Branco" | "America/Santarem" | "America/Santiago" | "America/Santo_Domingo" | "America/Sao_Paulo" | "America/Scoresbysund" | "America/Sitka" | "America/St_Barthelemy" | "America/St_Johns" | "America/St_Kitts" | "America/St_Lucia" | "America/St_Thomas" | "America/St_Vincent" | "America/Swift_Current" | "America/Tegucigalpa" | "America/Thule" | "America/Tijuana" | "America/Toronto" | "America/Tortola" | "America/Vancouver" | "America/Whitehorse" | "America/Winnipeg" | "America/Yakutat" | "America/Yellowknife" | "Antarctica/Casey" | "Antarctica/Davis" | "Antarctica/DumontDUrville" | "Antarctica/Macquarie" | "Antarctica/Mawson" | "Antarctica/McMurdo" | "Antarctica/Palmer" | "Antarctica/Rothera" | "Antarctica/Syowa" | "Antarctica/Troll" | "Antarctica/Vostok" | "Arctic/Longyearbyen" | "Asia/Aden" | "Asia/Almaty" | "Asia/Amman" | "Asia/Anadyr" | "Asia/Aqtau" | "Asia/Aqtobe" | "Asia/Ashgabat" | "Asia/Atyrau" | "Asia/Baghdad" | "Asia/Bahrain" | "Asia/Baku" | "Asia/Bangkok" | "Asia/Barnaul" | "Asia/Beirut" | "Asia/Bishkek" | "Asia/Brunei" | "Asia/Chita" | "Asia/Choibalsan" | "Asia/Colombo" | "Asia/Damascus" | "Asia/Dhaka" | "Asia/Dili" | "Asia/Dubai" | "Asia/Dushanbe" | "Asia/Famagusta" | "Asia/Gaza" | "Asia/Hebron" | "Asia/Ho_Chi_Minh" | "Asia/Hong_Kong" | "Asia/Hovd" | "Asia/Irkutsk" | "Asia/Jakarta" | "Asia/Jayapura" | "Asia/Jerusalem" | "Asia/Kabul" | "Asia/Kamchatka" | "Asia/Karachi" | "Asia/Kathmandu" | "Asia/Khandyga" | "Asia/Kolkata" | "Asia/Krasnoyarsk" | "Asia/Kuala_Lumpur" | "Asia/Kuching" | "Asia/Kuwait" | "Asia/Macau" | "Asia/Magadan" | "Asia/Makassar" | "Asia/Manila" | "Asia/Muscat" | "Asia/Nicosia" | "Asia/Novokuznetsk" | "Asia/Novosibirsk" | "Asia/Omsk" | "Asia/Oral" | "Asia/Phnom_Penh" | "Asia/Pontianak" | "Asia/Pyongyang" | "Asia/Qatar" | "Asia/Qostanay" | "Asia/Qyzylorda" | "Asia/Riyadh" | "Asia/Sakhalin" | "Asia/Samarkand" | "Asia/Seoul" | "Asia/Shanghai" | "Asia/Singapore" | "Asia/Srednekolymsk" | "Asia/Taipei" | "Asia/Tashkent" | "Asia/Tbilisi" | "Asia/Tehran" | "Asia/Thimphu" | "Asia/Tokyo" | "Asia/Tomsk" | "Asia/Ulaanbaatar" | "Asia/Urumqi" | "Asia/Ust-Nera" | "Asia/Vientiane" | "Asia/Vladivostok" | "Asia/Yakutsk" | "Asia/Yangon" | "Asia/Yekaterinburg" | "Asia/Yerevan" | "Atlantic/Azores" | "Atlantic/Bermuda" | "Atlantic/Canary" | "Atlantic/Cape_Verde" | "Atlantic/Faroe" | "Atlantic/Madeira" | "Atlantic/Reykjavik" | "Atlantic/South_Georgia" | "Atlantic/St_Helena" | "Atlantic/Stanley" | "Australia/Adelaide" | "Australia/Brisbane" | "Australia/Broken_Hill" | "Australia/Darwin" | "Australia/Eucla" | "Australia/Hobart" | "Australia/Lindeman" | "Australia/Lord_Howe" | "Australia/Melbourne" | "Australia/Perth" | "Australia/Sydney" | "Canada/Atlantic" | "Canada/Central" | "Canada/Eastern" | "Canada/Mountain" | "Canada/Newfoundland" | "Canada/Pacific" | "Europe/Amsterdam" | "Europe/Andorra" | "Europe/Astrakhan" | "Europe/Athens" | "Europe/Belgrade" | "Europe/Berlin" | "Europe/Bratislava" | "Europe/Brussels" | "Europe/Bucharest" | "Europe/Budapest" | "Europe/Busingen" | "Europe/Chisinau" | "Europe/Copenhagen" | "Europe/Dublin" | "Europe/Gibraltar" | "Europe/Guernsey" | "Europe/Helsinki" | "Europe/IsleOf_Man" | "Europe/Istanbul" | "Europe/Jersey" | "Europe/Kaliningrad" | "Europe/Kirov" | "Europe/Kyiv" | "Europe/Lisbon" | "Europe/Ljubljana" | "Europe/London" | "Europe/Luxembourg" | "Europe/Madrid" | "Europe/Malta" | "Europe/Mariehamn" | "Europe/Minsk" | "Europe/Monaco" | "Europe/Moscow" | "Europe/Oslo" | "Europe/Paris" | "Europe/Podgorica" | "Europe/Prague" | "Europe/Riga" | "Europe/Rome" | "Europe/Samara" | "Europe/San_Marino" | "Europe/Sarajevo" | "Europe/Saratov" | "Europe/Simferopol" | "Europe/Skopje" | "Europe/Sofia" | "Europe/Stockholm" | "Europe/Tallinn" | "Europe/Tirane" | "Europe/Ulyanovsk" | "Europe/Vaduz" | "Europe/Vatican" | "Europe/Vienna" | "Europe/Vilnius" | "Europe/Volgograd" | "Europe/Warsaw" | "Europe/Zagreb" | "Europe/Zurich" | "GMT" | "Indian/Antananarivo" | "Indian/Chagos" | "Indian/Christmas" | "Indian/Cocos" | "Indian/Comoro" | "Indian/Kerguelen" | "Indian/Mahe" | "Indian/Maldives" | "Indian/Mauritius" | "Indian/Mayotte" | "Indian/Reunion" | "Pacific/Apia" | "Pacific/Auckland" | "Pacific/Bougainville" | "Pacific/Chatham" | "Pacific/Chuuk" | "Pacific/Easter" | "Pacific/Efate" | "Pacific/Fakaofo" | "Pacific/Fiji" | "Pacific/Funafuti" | "Pacific/Galapagos" | "Pacific/Gambier" | "Pacific/Guadalcanal" | "Pacific/Guam" | "Pacific/Honolulu" | "Pacific/Kanton" | "Pacific/Kiritimati" | "Pacific/Kosrae" | "Pacific/Kwajalein" | "Pacific/Majuro" | "Pacific/Marquesas" | "Pacific/Midway" | "Pacific/Nauru" | "Pacific/Niue" | "Pacific/Norfolk" | "Pacific/Noumea" | "Pacific/Pago_Pago" | "Pacific/Palau" | "Pacific/Pitcairn" | "Pacific/Pohnpei" | "Pacific/Port_Moresby" | "Pacific/Rarotonga" | "Pacific/Saipan" | "Pacific/Tahiti" | "Pacific/Tarawa" | "Pacific/Tongatapu" | "Pacific/Wake" | "Pacific/Wallis" | "US/Alaska" | "US/Arizona" | "US/Central" | "US/Eastern" | "US/Hawaii" | "US/Mountain" | "US/Pacific" | "UTC";
      customerName?: string;
    };
    PatchedInvoiceUpdateRequest: {
      /**
       * @description * `paid` - paid
       * * `unpaid` - unpaid 
       * @enum {string}
       */
      paymentStatus?: "paid" | "unpaid";
    };
    PatchedMetricUpdateRequest: {
      billableMetricName?: string | null;
      /**
       * @description * `active` - Active
       * * `archived` - Archived 
       * @enum {string}
       */
      status?: "active" | "archived";
    };
    PatchedOrganizationSettingUpdateRequest: {
      settingValues?: {
        [key: string]: unknown | undefined;
      };
    };
    PatchedOrganizationUpdateRequest: {
      defaultCurrencyCode?: string;
      address?: components["schemas"]["AddressRequest"] | null;
      /**
       * Format: double 
       * @description Tax rate as percentage. For example, 10.5 for 10.5%
       */
      taxRate?: number | null;
      paymentGracePeriod?: number | null;
      planTags?: (components["schemas"]["TagRequest"])[];
      subscriptionFilterKeys?: (string)[];
      /**
       * @description * `Africa/Abidjan` - Africa/Abidjan
       * * `Africa/Accra` - Africa/Accra
       * * `Africa/Addis_Ababa` - Africa/Addis_Ababa
       * * `Africa/Algiers` - Africa/Algiers
       * * `Africa/Asmara` - Africa/Asmara
       * * `Africa/Bamako` - Africa/Bamako
       * * `Africa/Bangui` - Africa/Bangui
       * * `Africa/Banjul` - Africa/Banjul
       * * `Africa/Bissau` - Africa/Bissau
       * * `Africa/Blantyre` - Africa/Blantyre
       * * `Africa/Brazzaville` - Africa/Brazzaville
       * * `Africa/Bujumbura` - Africa/Bujumbura
       * * `Africa/Cairo` - Africa/Cairo
       * * `Africa/Casablanca` - Africa/Casablanca
       * * `Africa/Ceuta` - Africa/Ceuta
       * * `Africa/Conakry` - Africa/Conakry
       * * `Africa/Dakar` - Africa/Dakar
       * * `Africa/DarEs_Salaam` - Africa/DarEs_Salaam
       * * `Africa/Djibouti` - Africa/Djibouti
       * * `Africa/Douala` - Africa/Douala
       * * `Africa/El_Aaiun` - Africa/El_Aaiun
       * * `Africa/Freetown` - Africa/Freetown
       * * `Africa/Gaborone` - Africa/Gaborone
       * * `Africa/Harare` - Africa/Harare
       * * `Africa/Johannesburg` - Africa/Johannesburg
       * * `Africa/Juba` - Africa/Juba
       * * `Africa/Kampala` - Africa/Kampala
       * * `Africa/Khartoum` - Africa/Khartoum
       * * `Africa/Kigali` - Africa/Kigali
       * * `Africa/Kinshasa` - Africa/Kinshasa
       * * `Africa/Lagos` - Africa/Lagos
       * * `Africa/Libreville` - Africa/Libreville
       * * `Africa/Lome` - Africa/Lome
       * * `Africa/Luanda` - Africa/Luanda
       * * `Africa/Lubumbashi` - Africa/Lubumbashi
       * * `Africa/Lusaka` - Africa/Lusaka
       * * `Africa/Malabo` - Africa/Malabo
       * * `Africa/Maputo` - Africa/Maputo
       * * `Africa/Maseru` - Africa/Maseru
       * * `Africa/Mbabane` - Africa/Mbabane
       * * `Africa/Mogadishu` - Africa/Mogadishu
       * * `Africa/Monrovia` - Africa/Monrovia
       * * `Africa/Nairobi` - Africa/Nairobi
       * * `Africa/Ndjamena` - Africa/Ndjamena
       * * `Africa/Niamey` - Africa/Niamey
       * * `Africa/Nouakchott` - Africa/Nouakchott
       * * `Africa/Ouagadougou` - Africa/Ouagadougou
       * * `Africa/Porto-Novo` - Africa/Porto-Novo
       * * `Africa/Sao_Tome` - Africa/Sao_Tome
       * * `Africa/Tripoli` - Africa/Tripoli
       * * `Africa/Tunis` - Africa/Tunis
       * * `Africa/Windhoek` - Africa/Windhoek
       * * `America/Adak` - America/Adak
       * * `America/Anchorage` - America/Anchorage
       * * `America/Anguilla` - America/Anguilla
       * * `America/Antigua` - America/Antigua
       * * `America/Araguaina` - America/Araguaina
       * * `America/Argentina/Buenos_Aires` - America/Argentina/Buenos_Aires
       * * `America/Argentina/Catamarca` - America/Argentina/Catamarca
       * * `America/Argentina/Cordoba` - America/Argentina/Cordoba
       * * `America/Argentina/Jujuy` - America/Argentina/Jujuy
       * * `America/Argentina/La_Rioja` - America/Argentina/La_Rioja
       * * `America/Argentina/Mendoza` - America/Argentina/Mendoza
       * * `America/Argentina/Rio_Gallegos` - America/Argentina/Rio_Gallegos
       * * `America/Argentina/Salta` - America/Argentina/Salta
       * * `America/Argentina/San_Juan` - America/Argentina/San_Juan
       * * `America/Argentina/San_Luis` - America/Argentina/San_Luis
       * * `America/Argentina/Tucuman` - America/Argentina/Tucuman
       * * `America/Argentina/Ushuaia` - America/Argentina/Ushuaia
       * * `America/Aruba` - America/Aruba
       * * `America/Asuncion` - America/Asuncion
       * * `America/Atikokan` - America/Atikokan
       * * `America/Bahia` - America/Bahia
       * * `America/Bahia_Banderas` - America/Bahia_Banderas
       * * `America/Barbados` - America/Barbados
       * * `America/Belem` - America/Belem
       * * `America/Belize` - America/Belize
       * * `America/Blanc-Sablon` - America/Blanc-Sablon
       * * `America/Boa_Vista` - America/Boa_Vista
       * * `America/Bogota` - America/Bogota
       * * `America/Boise` - America/Boise
       * * `America/Cambridge_Bay` - America/Cambridge_Bay
       * * `America/Campo_Grande` - America/Campo_Grande
       * * `America/Cancun` - America/Cancun
       * * `America/Caracas` - America/Caracas
       * * `America/Cayenne` - America/Cayenne
       * * `America/Cayman` - America/Cayman
       * * `America/Chicago` - America/Chicago
       * * `America/Chihuahua` - America/Chihuahua
       * * `America/Ciudad_Juarez` - America/Ciudad_Juarez
       * * `America/Costa_Rica` - America/Costa_Rica
       * * `America/Creston` - America/Creston
       * * `America/Cuiaba` - America/Cuiaba
       * * `America/Curacao` - America/Curacao
       * * `America/Danmarkshavn` - America/Danmarkshavn
       * * `America/Dawson` - America/Dawson
       * * `America/Dawson_Creek` - America/Dawson_Creek
       * * `America/Denver` - America/Denver
       * * `America/Detroit` - America/Detroit
       * * `America/Dominica` - America/Dominica
       * * `America/Edmonton` - America/Edmonton
       * * `America/Eirunepe` - America/Eirunepe
       * * `America/El_Salvador` - America/El_Salvador
       * * `America/Fort_Nelson` - America/Fort_Nelson
       * * `America/Fortaleza` - America/Fortaleza
       * * `America/Glace_Bay` - America/Glace_Bay
       * * `America/Goose_Bay` - America/Goose_Bay
       * * `America/Grand_Turk` - America/Grand_Turk
       * * `America/Grenada` - America/Grenada
       * * `America/Guadeloupe` - America/Guadeloupe
       * * `America/Guatemala` - America/Guatemala
       * * `America/Guayaquil` - America/Guayaquil
       * * `America/Guyana` - America/Guyana
       * * `America/Halifax` - America/Halifax
       * * `America/Havana` - America/Havana
       * * `America/Hermosillo` - America/Hermosillo
       * * `America/Indiana/Indianapolis` - America/Indiana/Indianapolis
       * * `America/Indiana/Knox` - America/Indiana/Knox
       * * `America/Indiana/Marengo` - America/Indiana/Marengo
       * * `America/Indiana/Petersburg` - America/Indiana/Petersburg
       * * `America/Indiana/Tell_City` - America/Indiana/Tell_City
       * * `America/Indiana/Vevay` - America/Indiana/Vevay
       * * `America/Indiana/Vincennes` - America/Indiana/Vincennes
       * * `America/Indiana/Winamac` - America/Indiana/Winamac
       * * `America/Inuvik` - America/Inuvik
       * * `America/Iqaluit` - America/Iqaluit
       * * `America/Jamaica` - America/Jamaica
       * * `America/Juneau` - America/Juneau
       * * `America/Kentucky/Louisville` - America/Kentucky/Louisville
       * * `America/Kentucky/Monticello` - America/Kentucky/Monticello
       * * `America/Kralendijk` - America/Kralendijk
       * * `America/La_Paz` - America/La_Paz
       * * `America/Lima` - America/Lima
       * * `America/Los_Angeles` - America/Los_Angeles
       * * `America/Lower_Princes` - America/Lower_Princes
       * * `America/Maceio` - America/Maceio
       * * `America/Managua` - America/Managua
       * * `America/Manaus` - America/Manaus
       * * `America/Marigot` - America/Marigot
       * * `America/Martinique` - America/Martinique
       * * `America/Matamoros` - America/Matamoros
       * * `America/Mazatlan` - America/Mazatlan
       * * `America/Menominee` - America/Menominee
       * * `America/Merida` - America/Merida
       * * `America/Metlakatla` - America/Metlakatla
       * * `America/Mexico_City` - America/Mexico_City
       * * `America/Miquelon` - America/Miquelon
       * * `America/Moncton` - America/Moncton
       * * `America/Monterrey` - America/Monterrey
       * * `America/Montevideo` - America/Montevideo
       * * `America/Montserrat` - America/Montserrat
       * * `America/Nassau` - America/Nassau
       * * `America/New_York` - America/New_York
       * * `America/Nome` - America/Nome
       * * `America/Noronha` - America/Noronha
       * * `America/North_Dakota/Beulah` - America/North_Dakota/Beulah
       * * `America/North_Dakota/Center` - America/North_Dakota/Center
       * * `America/North_Dakota/New_Salem` - America/North_Dakota/New_Salem
       * * `America/Nuuk` - America/Nuuk
       * * `America/Ojinaga` - America/Ojinaga
       * * `America/Panama` - America/Panama
       * * `America/Paramaribo` - America/Paramaribo
       * * `America/Phoenix` - America/Phoenix
       * * `America/Port-au-Prince` - America/Port-au-Prince
       * * `America/PortOf_Spain` - America/PortOf_Spain
       * * `America/Porto_Velho` - America/Porto_Velho
       * * `America/Puerto_Rico` - America/Puerto_Rico
       * * `America/Punta_Arenas` - America/Punta_Arenas
       * * `America/Rankin_Inlet` - America/Rankin_Inlet
       * * `America/Recife` - America/Recife
       * * `America/Regina` - America/Regina
       * * `America/Resolute` - America/Resolute
       * * `America/Rio_Branco` - America/Rio_Branco
       * * `America/Santarem` - America/Santarem
       * * `America/Santiago` - America/Santiago
       * * `America/Santo_Domingo` - America/Santo_Domingo
       * * `America/Sao_Paulo` - America/Sao_Paulo
       * * `America/Scoresbysund` - America/Scoresbysund
       * * `America/Sitka` - America/Sitka
       * * `America/St_Barthelemy` - America/St_Barthelemy
       * * `America/St_Johns` - America/St_Johns
       * * `America/St_Kitts` - America/St_Kitts
       * * `America/St_Lucia` - America/St_Lucia
       * * `America/St_Thomas` - America/St_Thomas
       * * `America/St_Vincent` - America/St_Vincent
       * * `America/Swift_Current` - America/Swift_Current
       * * `America/Tegucigalpa` - America/Tegucigalpa
       * * `America/Thule` - America/Thule
       * * `America/Tijuana` - America/Tijuana
       * * `America/Toronto` - America/Toronto
       * * `America/Tortola` - America/Tortola
       * * `America/Vancouver` - America/Vancouver
       * * `America/Whitehorse` - America/Whitehorse
       * * `America/Winnipeg` - America/Winnipeg
       * * `America/Yakutat` - America/Yakutat
       * * `America/Yellowknife` - America/Yellowknife
       * * `Antarctica/Casey` - Antarctica/Casey
       * * `Antarctica/Davis` - Antarctica/Davis
       * * `Antarctica/DumontDUrville` - Antarctica/DumontDUrville
       * * `Antarctica/Macquarie` - Antarctica/Macquarie
       * * `Antarctica/Mawson` - Antarctica/Mawson
       * * `Antarctica/McMurdo` - Antarctica/McMurdo
       * * `Antarctica/Palmer` - Antarctica/Palmer
       * * `Antarctica/Rothera` - Antarctica/Rothera
       * * `Antarctica/Syowa` - Antarctica/Syowa
       * * `Antarctica/Troll` - Antarctica/Troll
       * * `Antarctica/Vostok` - Antarctica/Vostok
       * * `Arctic/Longyearbyen` - Arctic/Longyearbyen
       * * `Asia/Aden` - Asia/Aden
       * * `Asia/Almaty` - Asia/Almaty
       * * `Asia/Amman` - Asia/Amman
       * * `Asia/Anadyr` - Asia/Anadyr
       * * `Asia/Aqtau` - Asia/Aqtau
       * * `Asia/Aqtobe` - Asia/Aqtobe
       * * `Asia/Ashgabat` - Asia/Ashgabat
       * * `Asia/Atyrau` - Asia/Atyrau
       * * `Asia/Baghdad` - Asia/Baghdad
       * * `Asia/Bahrain` - Asia/Bahrain
       * * `Asia/Baku` - Asia/Baku
       * * `Asia/Bangkok` - Asia/Bangkok
       * * `Asia/Barnaul` - Asia/Barnaul
       * * `Asia/Beirut` - Asia/Beirut
       * * `Asia/Bishkek` - Asia/Bishkek
       * * `Asia/Brunei` - Asia/Brunei
       * * `Asia/Chita` - Asia/Chita
       * * `Asia/Choibalsan` - Asia/Choibalsan
       * * `Asia/Colombo` - Asia/Colombo
       * * `Asia/Damascus` - Asia/Damascus
       * * `Asia/Dhaka` - Asia/Dhaka
       * * `Asia/Dili` - Asia/Dili
       * * `Asia/Dubai` - Asia/Dubai
       * * `Asia/Dushanbe` - Asia/Dushanbe
       * * `Asia/Famagusta` - Asia/Famagusta
       * * `Asia/Gaza` - Asia/Gaza
       * * `Asia/Hebron` - Asia/Hebron
       * * `Asia/Ho_Chi_Minh` - Asia/Ho_Chi_Minh
       * * `Asia/Hong_Kong` - Asia/Hong_Kong
       * * `Asia/Hovd` - Asia/Hovd
       * * `Asia/Irkutsk` - Asia/Irkutsk
       * * `Asia/Jakarta` - Asia/Jakarta
       * * `Asia/Jayapura` - Asia/Jayapura
       * * `Asia/Jerusalem` - Asia/Jerusalem
       * * `Asia/Kabul` - Asia/Kabul
       * * `Asia/Kamchatka` - Asia/Kamchatka
       * * `Asia/Karachi` - Asia/Karachi
       * * `Asia/Kathmandu` - Asia/Kathmandu
       * * `Asia/Khandyga` - Asia/Khandyga
       * * `Asia/Kolkata` - Asia/Kolkata
       * * `Asia/Krasnoyarsk` - Asia/Krasnoyarsk
       * * `Asia/Kuala_Lumpur` - Asia/Kuala_Lumpur
       * * `Asia/Kuching` - Asia/Kuching
       * * `Asia/Kuwait` - Asia/Kuwait
       * * `Asia/Macau` - Asia/Macau
       * * `Asia/Magadan` - Asia/Magadan
       * * `Asia/Makassar` - Asia/Makassar
       * * `Asia/Manila` - Asia/Manila
       * * `Asia/Muscat` - Asia/Muscat
       * * `Asia/Nicosia` - Asia/Nicosia
       * * `Asia/Novokuznetsk` - Asia/Novokuznetsk
       * * `Asia/Novosibirsk` - Asia/Novosibirsk
       * * `Asia/Omsk` - Asia/Omsk
       * * `Asia/Oral` - Asia/Oral
       * * `Asia/Phnom_Penh` - Asia/Phnom_Penh
       * * `Asia/Pontianak` - Asia/Pontianak
       * * `Asia/Pyongyang` - Asia/Pyongyang
       * * `Asia/Qatar` - Asia/Qatar
       * * `Asia/Qostanay` - Asia/Qostanay
       * * `Asia/Qyzylorda` - Asia/Qyzylorda
       * * `Asia/Riyadh` - Asia/Riyadh
       * * `Asia/Sakhalin` - Asia/Sakhalin
       * * `Asia/Samarkand` - Asia/Samarkand
       * * `Asia/Seoul` - Asia/Seoul
       * * `Asia/Shanghai` - Asia/Shanghai
       * * `Asia/Singapore` - Asia/Singapore
       * * `Asia/Srednekolymsk` - Asia/Srednekolymsk
       * * `Asia/Taipei` - Asia/Taipei
       * * `Asia/Tashkent` - Asia/Tashkent
       * * `Asia/Tbilisi` - Asia/Tbilisi
       * * `Asia/Tehran` - Asia/Tehran
       * * `Asia/Thimphu` - Asia/Thimphu
       * * `Asia/Tokyo` - Asia/Tokyo
       * * `Asia/Tomsk` - Asia/Tomsk
       * * `Asia/Ulaanbaatar` - Asia/Ulaanbaatar
       * * `Asia/Urumqi` - Asia/Urumqi
       * * `Asia/Ust-Nera` - Asia/Ust-Nera
       * * `Asia/Vientiane` - Asia/Vientiane
       * * `Asia/Vladivostok` - Asia/Vladivostok
       * * `Asia/Yakutsk` - Asia/Yakutsk
       * * `Asia/Yangon` - Asia/Yangon
       * * `Asia/Yekaterinburg` - Asia/Yekaterinburg
       * * `Asia/Yerevan` - Asia/Yerevan
       * * `Atlantic/Azores` - Atlantic/Azores
       * * `Atlantic/Bermuda` - Atlantic/Bermuda
       * * `Atlantic/Canary` - Atlantic/Canary
       * * `Atlantic/Cape_Verde` - Atlantic/Cape_Verde
       * * `Atlantic/Faroe` - Atlantic/Faroe
       * * `Atlantic/Madeira` - Atlantic/Madeira
       * * `Atlantic/Reykjavik` - Atlantic/Reykjavik
       * * `Atlantic/South_Georgia` - Atlantic/South_Georgia
       * * `Atlantic/St_Helena` - Atlantic/St_Helena
       * * `Atlantic/Stanley` - Atlantic/Stanley
       * * `Australia/Adelaide` - Australia/Adelaide
       * * `Australia/Brisbane` - Australia/Brisbane
       * * `Australia/Broken_Hill` - Australia/Broken_Hill
       * * `Australia/Darwin` - Australia/Darwin
       * * `Australia/Eucla` - Australia/Eucla
       * * `Australia/Hobart` - Australia/Hobart
       * * `Australia/Lindeman` - Australia/Lindeman
       * * `Australia/Lord_Howe` - Australia/Lord_Howe
       * * `Australia/Melbourne` - Australia/Melbourne
       * * `Australia/Perth` - Australia/Perth
       * * `Australia/Sydney` - Australia/Sydney
       * * `Canada/Atlantic` - Canada/Atlantic
       * * `Canada/Central` - Canada/Central
       * * `Canada/Eastern` - Canada/Eastern
       * * `Canada/Mountain` - Canada/Mountain
       * * `Canada/Newfoundland` - Canada/Newfoundland
       * * `Canada/Pacific` - Canada/Pacific
       * * `Europe/Amsterdam` - Europe/Amsterdam
       * * `Europe/Andorra` - Europe/Andorra
       * * `Europe/Astrakhan` - Europe/Astrakhan
       * * `Europe/Athens` - Europe/Athens
       * * `Europe/Belgrade` - Europe/Belgrade
       * * `Europe/Berlin` - Europe/Berlin
       * * `Europe/Bratislava` - Europe/Bratislava
       * * `Europe/Brussels` - Europe/Brussels
       * * `Europe/Bucharest` - Europe/Bucharest
       * * `Europe/Budapest` - Europe/Budapest
       * * `Europe/Busingen` - Europe/Busingen
       * * `Europe/Chisinau` - Europe/Chisinau
       * * `Europe/Copenhagen` - Europe/Copenhagen
       * * `Europe/Dublin` - Europe/Dublin
       * * `Europe/Gibraltar` - Europe/Gibraltar
       * * `Europe/Guernsey` - Europe/Guernsey
       * * `Europe/Helsinki` - Europe/Helsinki
       * * `Europe/IsleOf_Man` - Europe/IsleOf_Man
       * * `Europe/Istanbul` - Europe/Istanbul
       * * `Europe/Jersey` - Europe/Jersey
       * * `Europe/Kaliningrad` - Europe/Kaliningrad
       * * `Europe/Kirov` - Europe/Kirov
       * * `Europe/Kyiv` - Europe/Kyiv
       * * `Europe/Lisbon` - Europe/Lisbon
       * * `Europe/Ljubljana` - Europe/Ljubljana
       * * `Europe/London` - Europe/London
       * * `Europe/Luxembourg` - Europe/Luxembourg
       * * `Europe/Madrid` - Europe/Madrid
       * * `Europe/Malta` - Europe/Malta
       * * `Europe/Mariehamn` - Europe/Mariehamn
       * * `Europe/Minsk` - Europe/Minsk
       * * `Europe/Monaco` - Europe/Monaco
       * * `Europe/Moscow` - Europe/Moscow
       * * `Europe/Oslo` - Europe/Oslo
       * * `Europe/Paris` - Europe/Paris
       * * `Europe/Podgorica` - Europe/Podgorica
       * * `Europe/Prague` - Europe/Prague
       * * `Europe/Riga` - Europe/Riga
       * * `Europe/Rome` - Europe/Rome
       * * `Europe/Samara` - Europe/Samara
       * * `Europe/San_Marino` - Europe/San_Marino
       * * `Europe/Sarajevo` - Europe/Sarajevo
       * * `Europe/Saratov` - Europe/Saratov
       * * `Europe/Simferopol` - Europe/Simferopol
       * * `Europe/Skopje` - Europe/Skopje
       * * `Europe/Sofia` - Europe/Sofia
       * * `Europe/Stockholm` - Europe/Stockholm
       * * `Europe/Tallinn` - Europe/Tallinn
       * * `Europe/Tirane` - Europe/Tirane
       * * `Europe/Ulyanovsk` - Europe/Ulyanovsk
       * * `Europe/Vaduz` - Europe/Vaduz
       * * `Europe/Vatican` - Europe/Vatican
       * * `Europe/Vienna` - Europe/Vienna
       * * `Europe/Vilnius` - Europe/Vilnius
       * * `Europe/Volgograd` - Europe/Volgograd
       * * `Europe/Warsaw` - Europe/Warsaw
       * * `Europe/Zagreb` - Europe/Zagreb
       * * `Europe/Zurich` - Europe/Zurich
       * * `GMT` - GMT
       * * `Indian/Antananarivo` - Indian/Antananarivo
       * * `Indian/Chagos` - Indian/Chagos
       * * `Indian/Christmas` - Indian/Christmas
       * * `Indian/Cocos` - Indian/Cocos
       * * `Indian/Comoro` - Indian/Comoro
       * * `Indian/Kerguelen` - Indian/Kerguelen
       * * `Indian/Mahe` - Indian/Mahe
       * * `Indian/Maldives` - Indian/Maldives
       * * `Indian/Mauritius` - Indian/Mauritius
       * * `Indian/Mayotte` - Indian/Mayotte
       * * `Indian/Reunion` - Indian/Reunion
       * * `Pacific/Apia` - Pacific/Apia
       * * `Pacific/Auckland` - Pacific/Auckland
       * * `Pacific/Bougainville` - Pacific/Bougainville
       * * `Pacific/Chatham` - Pacific/Chatham
       * * `Pacific/Chuuk` - Pacific/Chuuk
       * * `Pacific/Easter` - Pacific/Easter
       * * `Pacific/Efate` - Pacific/Efate
       * * `Pacific/Fakaofo` - Pacific/Fakaofo
       * * `Pacific/Fiji` - Pacific/Fiji
       * * `Pacific/Funafuti` - Pacific/Funafuti
       * * `Pacific/Galapagos` - Pacific/Galapagos
       * * `Pacific/Gambier` - Pacific/Gambier
       * * `Pacific/Guadalcanal` - Pacific/Guadalcanal
       * * `Pacific/Guam` - Pacific/Guam
       * * `Pacific/Honolulu` - Pacific/Honolulu
       * * `Pacific/Kanton` - Pacific/Kanton
       * * `Pacific/Kiritimati` - Pacific/Kiritimati
       * * `Pacific/Kosrae` - Pacific/Kosrae
       * * `Pacific/Kwajalein` - Pacific/Kwajalein
       * * `Pacific/Majuro` - Pacific/Majuro
       * * `Pacific/Marquesas` - Pacific/Marquesas
       * * `Pacific/Midway` - Pacific/Midway
       * * `Pacific/Nauru` - Pacific/Nauru
       * * `Pacific/Niue` - Pacific/Niue
       * * `Pacific/Norfolk` - Pacific/Norfolk
       * * `Pacific/Noumea` - Pacific/Noumea
       * * `Pacific/Pago_Pago` - Pacific/Pago_Pago
       * * `Pacific/Palau` - Pacific/Palau
       * * `Pacific/Pitcairn` - Pacific/Pitcairn
       * * `Pacific/Pohnpei` - Pacific/Pohnpei
       * * `Pacific/Port_Moresby` - Pacific/Port_Moresby
       * * `Pacific/Rarotonga` - Pacific/Rarotonga
       * * `Pacific/Saipan` - Pacific/Saipan
       * * `Pacific/Tahiti` - Pacific/Tahiti
       * * `Pacific/Tarawa` - Pacific/Tarawa
       * * `Pacific/Tongatapu` - Pacific/Tongatapu
       * * `Pacific/Wake` - Pacific/Wake
       * * `Pacific/Wallis` - Pacific/Wallis
       * * `US/Alaska` - US/Alaska
       * * `US/Arizona` - US/Arizona
       * * `US/Central` - US/Central
       * * `US/Eastern` - US/Eastern
       * * `US/Hawaii` - US/Hawaii
       * * `US/Mountain` - US/Mountain
       * * `US/Pacific` - US/Pacific
       * * `UTC` - UTC 
       * @enum {string}
       */
      timezone?: "Africa/Abidjan" | "Africa/Accra" | "Africa/Addis_Ababa" | "Africa/Algiers" | "Africa/Asmara" | "Africa/Bamako" | "Africa/Bangui" | "Africa/Banjul" | "Africa/Bissau" | "Africa/Blantyre" | "Africa/Brazzaville" | "Africa/Bujumbura" | "Africa/Cairo" | "Africa/Casablanca" | "Africa/Ceuta" | "Africa/Conakry" | "Africa/Dakar" | "Africa/DarEs_Salaam" | "Africa/Djibouti" | "Africa/Douala" | "Africa/El_Aaiun" | "Africa/Freetown" | "Africa/Gaborone" | "Africa/Harare" | "Africa/Johannesburg" | "Africa/Juba" | "Africa/Kampala" | "Africa/Khartoum" | "Africa/Kigali" | "Africa/Kinshasa" | "Africa/Lagos" | "Africa/Libreville" | "Africa/Lome" | "Africa/Luanda" | "Africa/Lubumbashi" | "Africa/Lusaka" | "Africa/Malabo" | "Africa/Maputo" | "Africa/Maseru" | "Africa/Mbabane" | "Africa/Mogadishu" | "Africa/Monrovia" | "Africa/Nairobi" | "Africa/Ndjamena" | "Africa/Niamey" | "Africa/Nouakchott" | "Africa/Ouagadougou" | "Africa/Porto-Novo" | "Africa/Sao_Tome" | "Africa/Tripoli" | "Africa/Tunis" | "Africa/Windhoek" | "America/Adak" | "America/Anchorage" | "America/Anguilla" | "America/Antigua" | "America/Araguaina" | "America/Argentina/Buenos_Aires" | "America/Argentina/Catamarca" | "America/Argentina/Cordoba" | "America/Argentina/Jujuy" | "America/Argentina/La_Rioja" | "America/Argentina/Mendoza" | "America/Argentina/Rio_Gallegos" | "America/Argentina/Salta" | "America/Argentina/San_Juan" | "America/Argentina/San_Luis" | "America/Argentina/Tucuman" | "America/Argentina/Ushuaia" | "America/Aruba" | "America/Asuncion" | "America/Atikokan" | "America/Bahia" | "America/Bahia_Banderas" | "America/Barbados" | "America/Belem" | "America/Belize" | "America/Blanc-Sablon" | "America/Boa_Vista" | "America/Bogota" | "America/Boise" | "America/Cambridge_Bay" | "America/Campo_Grande" | "America/Cancun" | "America/Caracas" | "America/Cayenne" | "America/Cayman" | "America/Chicago" | "America/Chihuahua" | "America/Ciudad_Juarez" | "America/Costa_Rica" | "America/Creston" | "America/Cuiaba" | "America/Curacao" | "America/Danmarkshavn" | "America/Dawson" | "America/Dawson_Creek" | "America/Denver" | "America/Detroit" | "America/Dominica" | "America/Edmonton" | "America/Eirunepe" | "America/El_Salvador" | "America/Fort_Nelson" | "America/Fortaleza" | "America/Glace_Bay" | "America/Goose_Bay" | "America/Grand_Turk" | "America/Grenada" | "America/Guadeloupe" | "America/Guatemala" | "America/Guayaquil" | "America/Guyana" | "America/Halifax" | "America/Havana" | "America/Hermosillo" | "America/Indiana/Indianapolis" | "America/Indiana/Knox" | "America/Indiana/Marengo" | "America/Indiana/Petersburg" | "America/Indiana/Tell_City" | "America/Indiana/Vevay" | "America/Indiana/Vincennes" | "America/Indiana/Winamac" | "America/Inuvik" | "America/Iqaluit" | "America/Jamaica" | "America/Juneau" | "America/Kentucky/Louisville" | "America/Kentucky/Monticello" | "America/Kralendijk" | "America/La_Paz" | "America/Lima" | "America/Los_Angeles" | "America/Lower_Princes" | "America/Maceio" | "America/Managua" | "America/Manaus" | "America/Marigot" | "America/Martinique" | "America/Matamoros" | "America/Mazatlan" | "America/Menominee" | "America/Merida" | "America/Metlakatla" | "America/Mexico_City" | "America/Miquelon" | "America/Moncton" | "America/Monterrey" | "America/Montevideo" | "America/Montserrat" | "America/Nassau" | "America/New_York" | "America/Nome" | "America/Noronha" | "America/North_Dakota/Beulah" | "America/North_Dakota/Center" | "America/North_Dakota/New_Salem" | "America/Nuuk" | "America/Ojinaga" | "America/Panama" | "America/Paramaribo" | "America/Phoenix" | "America/Port-au-Prince" | "America/PortOf_Spain" | "America/Porto_Velho" | "America/Puerto_Rico" | "America/Punta_Arenas" | "America/Rankin_Inlet" | "America/Recife" | "America/Regina" | "America/Resolute" | "America/Rio_Branco" | "America/Santarem" | "America/Santiago" | "America/Santo_Domingo" | "America/Sao_Paulo" | "America/Scoresbysund" | "America/Sitka" | "America/St_Barthelemy" | "America/St_Johns" | "America/St_Kitts" | "America/St_Lucia" | "America/St_Thomas" | "America/St_Vincent" | "America/Swift_Current" | "America/Tegucigalpa" | "America/Thule" | "America/Tijuana" | "America/Toronto" | "America/Tortola" | "America/Vancouver" | "America/Whitehorse" | "America/Winnipeg" | "America/Yakutat" | "America/Yellowknife" | "Antarctica/Casey" | "Antarctica/Davis" | "Antarctica/DumontDUrville" | "Antarctica/Macquarie" | "Antarctica/Mawson" | "Antarctica/McMurdo" | "Antarctica/Palmer" | "Antarctica/Rothera" | "Antarctica/Syowa" | "Antarctica/Troll" | "Antarctica/Vostok" | "Arctic/Longyearbyen" | "Asia/Aden" | "Asia/Almaty" | "Asia/Amman" | "Asia/Anadyr" | "Asia/Aqtau" | "Asia/Aqtobe" | "Asia/Ashgabat" | "Asia/Atyrau" | "Asia/Baghdad" | "Asia/Bahrain" | "Asia/Baku" | "Asia/Bangkok" | "Asia/Barnaul" | "Asia/Beirut" | "Asia/Bishkek" | "Asia/Brunei" | "Asia/Chita" | "Asia/Choibalsan" | "Asia/Colombo" | "Asia/Damascus" | "Asia/Dhaka" | "Asia/Dili" | "Asia/Dubai" | "Asia/Dushanbe" | "Asia/Famagusta" | "Asia/Gaza" | "Asia/Hebron" | "Asia/Ho_Chi_Minh" | "Asia/Hong_Kong" | "Asia/Hovd" | "Asia/Irkutsk" | "Asia/Jakarta" | "Asia/Jayapura" | "Asia/Jerusalem" | "Asia/Kabul" | "Asia/Kamchatka" | "Asia/Karachi" | "Asia/Kathmandu" | "Asia/Khandyga" | "Asia/Kolkata" | "Asia/Krasnoyarsk" | "Asia/Kuala_Lumpur" | "Asia/Kuching" | "Asia/Kuwait" | "Asia/Macau" | "Asia/Magadan" | "Asia/Makassar" | "Asia/Manila" | "Asia/Muscat" | "Asia/Nicosia" | "Asia/Novokuznetsk" | "Asia/Novosibirsk" | "Asia/Omsk" | "Asia/Oral" | "Asia/Phnom_Penh" | "Asia/Pontianak" | "Asia/Pyongyang" | "Asia/Qatar" | "Asia/Qostanay" | "Asia/Qyzylorda" | "Asia/Riyadh" | "Asia/Sakhalin" | "Asia/Samarkand" | "Asia/Seoul" | "Asia/Shanghai" | "Asia/Singapore" | "Asia/Srednekolymsk" | "Asia/Taipei" | "Asia/Tashkent" | "Asia/Tbilisi" | "Asia/Tehran" | "Asia/Thimphu" | "Asia/Tokyo" | "Asia/Tomsk" | "Asia/Ulaanbaatar" | "Asia/Urumqi" | "Asia/Ust-Nera" | "Asia/Vientiane" | "Asia/Vladivostok" | "Asia/Yakutsk" | "Asia/Yangon" | "Asia/Yekaterinburg" | "Asia/Yerevan" | "Atlantic/Azores" | "Atlantic/Bermuda" | "Atlantic/Canary" | "Atlantic/Cape_Verde" | "Atlantic/Faroe" | "Atlantic/Madeira" | "Atlantic/Reykjavik" | "Atlantic/South_Georgia" | "Atlantic/St_Helena" | "Atlantic/Stanley" | "Australia/Adelaide" | "Australia/Brisbane" | "Australia/Broken_Hill" | "Australia/Darwin" | "Australia/Eucla" | "Australia/Hobart" | "Australia/Lindeman" | "Australia/Lord_Howe" | "Australia/Melbourne" | "Australia/Perth" | "Australia/Sydney" | "Canada/Atlantic" | "Canada/Central" | "Canada/Eastern" | "Canada/Mountain" | "Canada/Newfoundland" | "Canada/Pacific" | "Europe/Amsterdam" | "Europe/Andorra" | "Europe/Astrakhan" | "Europe/Athens" | "Europe/Belgrade" | "Europe/Berlin" | "Europe/Bratislava" | "Europe/Brussels" | "Europe/Bucharest" | "Europe/Budapest" | "Europe/Busingen" | "Europe/Chisinau" | "Europe/Copenhagen" | "Europe/Dublin" | "Europe/Gibraltar" | "Europe/Guernsey" | "Europe/Helsinki" | "Europe/IsleOf_Man" | "Europe/Istanbul" | "Europe/Jersey" | "Europe/Kaliningrad" | "Europe/Kirov" | "Europe/Kyiv" | "Europe/Lisbon" | "Europe/Ljubljana" | "Europe/London" | "Europe/Luxembourg" | "Europe/Madrid" | "Europe/Malta" | "Europe/Mariehamn" | "Europe/Minsk" | "Europe/Monaco" | "Europe/Moscow" | "Europe/Oslo" | "Europe/Paris" | "Europe/Podgorica" | "Europe/Prague" | "Europe/Riga" | "Europe/Rome" | "Europe/Samara" | "Europe/San_Marino" | "Europe/Sarajevo" | "Europe/Saratov" | "Europe/Simferopol" | "Europe/Skopje" | "Europe/Sofia" | "Europe/Stockholm" | "Europe/Tallinn" | "Europe/Tirane" | "Europe/Ulyanovsk" | "Europe/Vaduz" | "Europe/Vatican" | "Europe/Vienna" | "Europe/Vilnius" | "Europe/Volgograd" | "Europe/Warsaw" | "Europe/Zagreb" | "Europe/Zurich" | "GMT" | "Indian/Antananarivo" | "Indian/Chagos" | "Indian/Christmas" | "Indian/Cocos" | "Indian/Comoro" | "Indian/Kerguelen" | "Indian/Mahe" | "Indian/Maldives" | "Indian/Mauritius" | "Indian/Mayotte" | "Indian/Reunion" | "Pacific/Apia" | "Pacific/Auckland" | "Pacific/Bougainville" | "Pacific/Chatham" | "Pacific/Chuuk" | "Pacific/Easter" | "Pacific/Efate" | "Pacific/Fakaofo" | "Pacific/Fiji" | "Pacific/Funafuti" | "Pacific/Galapagos" | "Pacific/Gambier" | "Pacific/Guadalcanal" | "Pacific/Guam" | "Pacific/Honolulu" | "Pacific/Kanton" | "Pacific/Kiritimati" | "Pacific/Kosrae" | "Pacific/Kwajalein" | "Pacific/Majuro" | "Pacific/Marquesas" | "Pacific/Midway" | "Pacific/Nauru" | "Pacific/Niue" | "Pacific/Norfolk" | "Pacific/Noumea" | "Pacific/Pago_Pago" | "Pacific/Palau" | "Pacific/Pitcairn" | "Pacific/Pohnpei" | "Pacific/Port_Moresby" | "Pacific/Rarotonga" | "Pacific/Saipan" | "Pacific/Tahiti" | "Pacific/Tarawa" | "Pacific/Tongatapu" | "Pacific/Wake" | "Pacific/Wallis" | "US/Alaska" | "US/Arizona" | "US/Central" | "US/Eastern" | "US/Hawaii" | "US/Mountain" | "US/Pacific" | "UTC";
      /**
       * @description To udpate a payment provider's ID, specify the payment provider you want to update in this field, and the paymentProviderId in the corresponding field.
       * 
       * * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      paymentProvider?: "stripe" | "braintree";
      paymentProviderId?: string;
      nangoConnected?: boolean;
      taxProviders?: (("taxjar" | "lotus" | "netsuite")[]) | null;
    };
    PatchedPlanUpdateRequest: {
      /** @description Name of the plan */
      planName?: string;
      /** @description Description of the plan */
      planDescription?: string | null;
      taxjarCode?: string | null;
      /** Format: date-time */
      activeFrom?: string;
      /** Format: date-time */
      activeTo?: string | null;
    };
    PatchedPlanVersionUpdateRequest: {
      localizedName?: string | null;
      /** Format: date-time */
      activeFrom?: string | null;
      /** Format: date-time */
      activeTo?: string | null;
    };
    PaymentProcesorPostDataRequest: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      paymentProcessor: "stripe" | "braintree";
      data: {
        [key: string]: unknown | undefined;
      };
    };
    PaymentProcesorPostRequestRequest: {
      ppInfo: components["schemas"]["PaymentProcesorPostDataRequest"];
    };
    PaymentProcesorPostResponse: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      paymentProcessor: "stripe" | "braintree";
      success: boolean;
      details: string;
    };
    PeriodMetricRevenueResponse: {
      /** Format: double */
      totalRevenuePeriod1: number;
      /** Format: double */
      totalRevenuePeriod2: number;
      /** Format: double */
      earnedRevenuePeriod1: number;
      /** Format: double */
      earnedRevenuePeriod2: number;
    };
    PeriodMetricUsageResponse: {
      metrics: {
        [key: string]: components["schemas"]["PeriodSingleMetricUsage"] | undefined;
      };
    };
    PeriodSingleMetricUsage: {
      data: (components["schemas"]["DayMetricUsage"])[];
    };
    PeriodSubscriptionsResponse: {
      period1_totalSubscriptions: number;
      period1_newSubscriptions: number;
      period2_totalSubscriptions: number;
      period2_newSubscriptions: number;
    };
    Plan: {
      planId: string;
      /** @description Name of the plan */
      planName: string;
      /**
       * @description Duration of the plan
       * 
       * * `monthly` - Monthly
       * * `quarterly` - Quarterly
       * * `yearly` - Yearly 
       * @enum {string|null}
       */
      planDuration: "monthly" | "quarterly" | "yearly" | "" | null;
      /** @description Description of the plan */
      planDescription: string | null;
      /** @description The external links that this plan has. */
      externalLinks: (components["schemas"]["InitialExternalPlanLink"])[];
      /** @description The number of versions that this plan has. */
      numVersions: number;
      /** @description This plan's currently active version. */
      activeVersion: number;
      /** @description The number of active subscriptions that this plan has across all versions. */
      activeSubscriptions: number;
      /** @description The tags that this plan has. */
      tags: readonly (string)[];
      /** @description This plan's versions. */
      versions: (components["schemas"]["PlanVersion"])[];
      /**
       * @deprecated 
       * @description [DEPRECATED] The parent plan that this plan has.
       */
      parentPlan: components["schemas"]["PlanNameAndID"] | null;
      /**
       * @deprecated 
       * @description [DEPRECATED] The target customer that this plan has.
       */
      targetCustomer: components["schemas"]["LightweightCustomer"] | null;
      /**
       * @deprecated 
       * @description [DEPRECATED] Display version has been deprecated. Use 'versions' instead. We will still return this field for now with some heuristics for figuring out what the desired version is, but it will be removed in the near future.
       */
      displayVersion: components["schemas"]["PlanVersion"];
      /**
       * @deprecated 
       * @description [DEPRECATED] The status of this plan.
       */
      status: string;
    };
    PlanComponent: {
      billableMetric: components["schemas"]["Metric"];
      tiers: (components["schemas"]["PriceTier"])[];
      pricingUnit: components["schemas"]["PricingUnit"];
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      invoicingIntervalUnit: "day" | "week" | "month" | "year" | "" | null;
      invoicingIntervalCount: number | null;
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      resetIntervalUnit: "day" | "week" | "month" | "year" | "" | null;
      resetIntervalCount: number | null;
      prepaidCharge: components["schemas"]["ComponentCharge"] | null;
    };
    PlanComponentCreateRequest: {
      /** Format: uuid */
      metricId: string;
      tiers?: (components["schemas"]["PriceTierCreateRequest"])[];
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      invoicingIntervalUnit?: "day" | "week" | "month" | "year" | "" | null;
      invoicingIntervalCount?: number | null;
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      resetIntervalUnit?: "day" | "week" | "month" | "year" | "" | null;
      resetIntervalCount?: number | null;
      prepaidCharge?: components["schemas"]["ComponentChargeCreateRequest"] | null;
    };
    PlanCreateRequest: {
      /** @description Name of the plan */
      planName: string;
      /** @description Description of the plan */
      planDescription?: string | null;
      /**
       * @description Duration of the plan
       * 
       * * `monthly` - Monthly
       * * `quarterly` - Quarterly
       * * `yearly` - Yearly 
       * @enum {string|null}
       */
      planDuration?: "monthly" | "quarterly" | "yearly" | "" | null;
      initialExternalLinks?: (components["schemas"]["InitialExternalPlanLinkRequest"])[];
      initialVersion: components["schemas"]["InitialPlanVersionCreateRequest"];
      tags?: (components["schemas"]["TagRequest"])[];
    };
    PlanDetail: {
      /** @description Name of the plan */
      planName: string;
      planId: string;
      /** @description The number of active subscriptions that this plan has across all versions. */
      activeSubscriptions: number;
      versions: readonly (components["schemas"]["PlanVersionDetail"])[];
      /** @description The external links that this plan has. */
      externalLinks: (components["schemas"]["InitialExternalPlanLink"])[];
      /**
       * @description Duration of the plan
       * 
       * * `monthly` - Monthly
       * * `quarterly` - Quarterly
       * * `yearly` - Yearly 
       * @enum {string|null}
       */
      planDuration: "monthly" | "quarterly" | "yearly" | "" | null;
      taxjarCode?: string | null;
      /** @description Description of the plan */
      planDescription: string | null;
      /** @description This plan's currently active version. */
      activeVersion: number;
      /** @description The tags that this plan has. */
      tags: readonly (components["schemas"]["Tag"])[];
      /** @description The number of versions that this plan has. */
      numVersions: number;
    };
    PlanNameAndID: {
      /** @description Name of the plan */
      planName: string;
      planId: string;
    };
    PlanRepresentation: {
      planName: string;
      planId: string;
      /** Format: double */
      planRevenue: number;
    };
    PlanUpdate: {
      /** @description Name of the plan */
      planName?: string;
      /** @description Description of the plan */
      planDescription?: string | null;
      taxjarCode?: string | null;
      /** Format: date-time */
      activeFrom?: string;
      /** Format: date-time */
      activeTo?: string | null;
    };
    PlanVersion: {
      recurringCharges: readonly (components["schemas"]["RecurringCharge"])[];
      components: (components["schemas"]["PlanComponent"])[];
      features: (components["schemas"]["Feature"])[];
      priceAdjustment: components["schemas"]["PriceAdjustment"] | null;
      version: number | "customVersion";
      /**
       * @description * `active` - Active
       * * `retiring` - Retiring
       * * `grandfathered` - Grandfathered
       * * `deleted` - Deleted
       * * `inactive` - Inactive
       * * `notStarted` - Not Started 
       * @enum {string}
       */
      status: "active" | "retiring" | "grandfathered" | "deleted" | "inactive" | "notStarted";
      planName: string;
      currency: components["schemas"]["PricingUnit"];
      /** Format: date-time */
      activeFrom: string | null;
      /** Format: date-time */
      activeTo: string | null;
      localizedName: string | null;
      targetCustomers: (components["schemas"]["LightweightCustomer"])[];
      /** Format: date-time */
      createdOn: string;
      /** @deprecated */
      usageBillingFrequency: string | null;
      /**
       * @deprecated 
       * @description * `inAdvance` - inAdvance
       * * `inArrears` - inArrears 
       * @enum {string}
       */
      flatFeeBillingType: "inAdvance" | "inArrears";
      /**
       * Format: double 
       * @deprecated
       */
      flatRate: number;
      /** @deprecated */
      description: string | null;
    };
    PlanVersionCreateRequest: {
      /** Format: uuid */
      planId: string;
      recurringCharges?: (components["schemas"]["RecurringChargeCreateRequest"])[];
      components?: (components["schemas"]["PlanComponentCreateRequest"])[];
      features?: (string)[];
      priceAdjustment?: components["schemas"]["PriceAdjustmentRequest"];
      dayAnchor?: number | null;
      monthAnchor?: number | null;
      currencyCode: string;
      version: number;
      targetCustomerIds?: (string | null)[];
      localizedName?: string | null;
      /** @default false */
      makeActive?: boolean;
      /**
       * @description * `replaceOnRenewal` - Replace on Renewal
       * * `grandfather` - Grandfather 
       * @default replaceOnRenewal 
       * @enum {string}
       */
      makeActiveType?: "replaceOnRenewal" | "grandfather";
    };
    PlanVersionDetail: {
      planId: string;
      localizedName: string | null;
      activeSubscriptions: number;
      version: number | "customVersion";
      recurringCharges: readonly (components["schemas"]["RecurringCharge"])[];
      components: (components["schemas"]["PlanComponent"])[];
      transitionTo: components["schemas"]["LightweightPlan"];
      replaceWith: components["schemas"]["LightweightPlanVersion"];
      targetCustomers: (components["schemas"]["LightweightCustomer"])[];
      versionId: string;
      /** Format: date-time */
      createdOn: string;
      planName: string;
      currency: components["schemas"]["PricingUnit"];
      /** Format: date-time */
      activeFrom: string | null;
      alerts: readonly (components["schemas"]["UsageAlert"])[];
      features: (components["schemas"]["Feature"])[];
      priceAdjustment: components["schemas"]["PriceAdjustment"] | null;
      /** Format: date-time */
      activeTo: string | null;
      /**
       * @description * `active` - Active
       * * `retiring` - Retiring
       * * `grandfathered` - Grandfathered
       * * `deleted` - Deleted
       * * `inactive` - Inactive
       * * `notStarted` - Not Started 
       * @enum {string}
       */
      status: "active" | "retiring" | "grandfathered" | "deleted" | "inactive" | "notStarted";
    };
    PlanVersionHistoricalSubscription: {
      customerId: string;
      customerName: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      startDate: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      endDate: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      autoRenew: boolean;
    };
    PlanVersionNumberSetReplaceWithResponse: {
      success: boolean;
      message: string;
    };
    PlanVersionNumberSetTransitionToResponse: {
      success: boolean;
      message: string;
    };
    PlanVersionUpdate: {
      localizedName?: string | null;
      /** Format: date-time */
      activeFrom?: string | null;
      /** Format: date-time */
      activeTo?: string | null;
    };
    PlansByNumCustomers: {
      results: (components["schemas"]["SinglePlanNumCustomers"])[];
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
    };
    PlansSetReplaceWithForVersionNumberRequest: {
      /** @description The version number of the plan that will replace the current version. */
      replacementVersionNumber: number;
    };
    PlansSetTransitionToForVersionNumberRequest: {
      /** @description The plan that the current version will transition to. */
      transitionToPlanId: number;
    };
    PriceAdjustment: {
      priceAdjustmentName: string;
      priceAdjustmentDescription: string | null;
      /**
       * @description * `percentage` - Percentage
       * * `fixed` - Fixed
       * * `priceOverride` - Price Override 
       * @enum {string}
       */
      priceAdjustmentType: "percentage" | "fixed" | "priceOverride";
      /** Format: double */
      priceAdjustmentAmount: number;
    };
    PriceAdjustmentRequest: {
      /** @default */
      priceAdjustmentName?: string;
      priceAdjustmentDescription?: string | null;
      /**
       * @description * `percentage` - Percentage
       * * `fixed` - Fixed
       * * `priceOverride` - Price Override 
       * @enum {string}
       */
      priceAdjustmentType: "percentage" | "fixed" | "priceOverride";
      /** Format: double */
      priceAdjustmentAmount: number;
    };
    PriceTier: {
      /**
       * @description * `flat` - flat
       * * `perUnit` - perUnit
       * * `free` - free 
       * @enum {unknown}
       */
      type: "flat" | "perUnit" | "free";
      /** Format: double */
      rangeStart: number;
      /** Format: double */
      rangeEnd: number | null;
      /** Format: double */
      costPerBatch: number | null;
      /** Format: double */
      metricUnitsPerBatch: number | null;
      /**
       * @description * `roundUp` - roundUp
       * * `roundDown` - roundDown
       * * `roundNearest` - roundNearest
       * * `noRounding` - noRounding 
       * @enum {unknown|null}
       */
      batchRoundingType: "roundUp" | "roundDown" | "roundNearest" | "noRounding" | "" | null;
    };
    PriceTierCreateRequest: {
      /**
       * @description * `flat` - Flat
       * * `perUnit` - Per Unit
       * * `free` - Free 
       * @enum {string}
       */
      type: "flat" | "perUnit" | "free";
      /** Format: double */
      rangeStart: number;
      /** Format: double */
      rangeEnd?: number | null;
      /** Format: double */
      costPerBatch?: number | null;
      /** Format: double */
      metricUnitsPerBatch?: number | null;
      /**
       * @description * `roundUp` - Round Up
       * * `roundDown` - Round Down
       * * `roundNearest` - Round Nearest
       * * `noRounding` - No Rounding 
       * @default noRounding 
       * @enum {string|null}
       */
      batchRoundingType?: "roundUp" | "roundDown" | "roundNearest" | "noRounding" | "" | null;
    };
    PricingUnit: {
      code: string;
      name: string;
      symbol: string;
    };
    PricingUnitDetail: {
      code: string;
      name: string;
      symbol: string;
    };
    PricingUnitDetailRequest: {
      code: string;
      name: string;
      symbol: string;
    };
    PricingUnitRequest: {
      code: string;
      name: string;
      symbol: string;
    };
    RecurringCharge: {
      name: string;
      /**
       * @description * `inAdvance` - inAdvance
       * * `inArrears` - inArrears 
       * @enum {string}
       */
      chargeTiming: "inAdvance" | "inArrears";
      /**
       * @description * `prorate` - prorate
       * * `full` - full 
       * @enum {string}
       */
      chargeBehavior: "prorate" | "full";
      /** Format: double */
      amount: number;
      pricingUnit: components["schemas"]["PricingUnit"];
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      invoicingIntervalUnit: "day" | "week" | "month" | "year" | "" | null;
      invoicingIntervalCount: number | null;
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      resetIntervalUnit: "day" | "week" | "month" | "year" | "" | null;
      resetIntervalCount: number | null;
    };
    RecurringChargeCreateRequest: {
      name: string;
      /**
       * @description * `inAdvance` - inAdvance
       * * `inArrears` - inArrears 
       * @enum {string}
       */
      chargeTiming: "inAdvance" | "inArrears";
      /**
       * @description * `prorate` - prorate
       * * `full` - full 
       * @default prorate 
       * @enum {string}
       */
      chargeBehavior?: "prorate" | "full";
      /** Format: double */
      amount: number;
      pricingUnitCode?: string;
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      invoicingIntervalUnit?: "day" | "week" | "month" | "year" | "" | null;
      invoicingIntervalCount?: number | null;
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      resetIntervalUnit?: "day" | "week" | "month" | "year" | "" | null;
      resetIntervalCount?: number | null;
    };
    RegistrationDetailRequest: {
      organizationName: string;
      industry: string;
      email: string;
      password: string;
      username: string;
    };
    RegistrationFailure: {
      detail: string;
    };
    RegistrationRequest: {
      register: components["schemas"]["RegistrationDetailRequest"];
    };
    RegistrationSuccess: {
      detail: string;
      token: string;
      user: components["schemas"]["User"];
    };
    RemovePlanTags: {
      tags?: (components["schemas"]["Tag"])[];
      success: boolean;
      message: string;
    };
    RemovePlanTagsRequest: {
      tags?: (components["schemas"]["TagRequest"])[];
    };
    RemoveTargetCustomerResponse: {
      success: boolean;
      message: string;
    };
    ResetPasswordRequestRequest: {
      userId: string;
      password: string;
      token: string;
    };
    ResetPasswordSuccess: {
      detail: string;
      token: string;
    };
    RevenueDate: {
      /** Format: date */
      date: string;
      /** Format: double */
      originalPlanRevenue: number;
      /** Format: double */
      newPlanRevenue: number;
    };
    Seller: {
      name: string;
      address?: components["schemas"]["Address"] | null;
      phone?: string | null;
      /** Format: email */
      email?: string | null;
    };
    SellerRequest: {
      name: string;
      phone?: string | null;
      /** Format: email */
      email?: string | null;
    };
    SessionSuccess: {
      isAuthenticated: boolean;
    };
    SetPlanTagsRequest: {
      tags?: (components["schemas"]["TagRequest"])[];
    };
    SetPlanTagsResponse: {
      tags?: (components["schemas"]["Tag"])[];
      success: boolean;
      message: string;
    };
    SetReplaceWithRequest: {
      /**
       * Format: uuid 
       * @description The plan version to replace the current version with.
       */
      replaceWith: string;
    };
    SetReplaceWithResponse: {
      success: boolean;
      message: string;
    };
    SingleCRMProvider: {
      /**
       * @description * `salesforce` - salesforce 
       * @enum {string}
       */
      crmProviderName: "salesforce";
      connected: boolean;
      selfHosted: boolean;
      working: boolean;
      connectionId: string | null;
      accountId: string | null;
      /** Format: uri */
      nativeOrgUrl: string | null;
    };
    SingleCustomerValue: {
      customerId: string;
      customerName: string;
      /** Format: double */
      value: number;
    };
    SingleDayCostAnalysis: {
      /** Format: date */
      date: string;
      costData: (components["schemas"]["SingleMetricCost"])[];
      /** Format: double */
      revenue: number;
    };
    SingleMetricCost: {
      metric: components["schemas"]["MetricDetail"];
      /** Format: double */
      cost: number;
    };
    SinglePaymentProcesor: {
      paymentProviderName: string;
      connected: boolean;
      /** Format: uri */
      redirectUrl: string;
      selfHosted: boolean;
      connectionId: string | null;
      working: boolean;
      accountId: string | null;
    };
    SinglePlanNumCustomers: {
      planName: string;
      numCustomers: number;
      /** Format: double */
      percentTotal: number;
    };
    SingleSubstitution: {
      substitutionName: string;
      originalPlan: components["schemas"]["PlanRepresentation"];
      newPlan: components["schemas"]["PlanRepresentation"];
      /** Format: double */
      pctRevenueChange: number | null;
      results: components["schemas"]["SingleSubstitutionResults"];
    };
    SingleSubstitutionResults: {
      cumulativeRevenue: (components["schemas"]["RevenueDate"])[];
      revenueByMetric: (components["schemas"]["MetricRevenue"])[];
      topCustomers: components["schemas"]["TopCustomers"];
    };
    StoreTokenRequestRequest: {
      /** @description The public token obtained from the Vessel API */
      publicToken: string;
    };
    StoreTokenResponse: {
      /** @description Whether the token was successfully stored */
      success: boolean;
    };
    StripeCancelSubscriptionsFailure: {
      /**
       * @description * `error` - error 
       * @enum {string}
       */
      status: "error";
      detail: string;
    };
    StripeCancelSubscriptionsSuccess: {
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
      detail: string;
    };
    StripeMultiSubscriptionsRequest: {
      /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
      customerId: string | null;
      stripeSubscriptionIds: (string)[];
    };
    StripeSubscriptionRecord: {
      /** @description Whether this subscription came from a renewal or from a first-time. Defaults to true on creation. */
      isNew?: boolean;
      customer: components["schemas"]["LightweightCustomer"];
      billingPlan: components["schemas"]["LightweightPlanVersion"];
      metadata?: {
        [key: string]: unknown | undefined;
      };
      stripeSubscriptionId: string | null;
      fullyBilled: boolean;
      subscriptionFilters: (components["schemas"]["SubscriptionFilter"])[];
      subscriptionId: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      endDate: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      autoRenew?: boolean;
      addons: (components["schemas"]["LightweightAddOnSubscriptionRecord"])[];
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      startDate: string;
    };
    StripeTurnOffAutoRenewalFailure: {
      /**
       * @description * `error` - error 
       * @enum {string}
       */
      status: "error";
      detail: string;
    };
    StripeTurnOffAutoRenewalSuccess: {
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
      detail: string;
    };
    SubscriptionCancelledRequest: {
      payload: components["schemas"]["SubscriptionRecordRequest"];
    };
    SubscriptionCreatedRequest: {
      payload: components["schemas"]["SubscriptionRecordRequest"];
    };
    SubscriptionCustomerSummary: {
      billingPlanName: string;
      planVersion: number;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      endDate: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      autoRenew?: boolean;
    };
    SubscriptionFilter: {
      value: string;
      /** @description The string name of the property to filter on. Example: 'productId' */
      propertyName: string;
    };
    SubscriptionFilterRequest: {
      value: string;
      /** @description The string name of the property to filter on. Example: 'productId' */
      propertyName: string;
    };
    SubscriptionRecord: {
      subscriptionId: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      startDate: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      endDate: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      autoRenew: boolean;
      /** @description Whether this subscription came from a renewal or from a first-time. Defaults to true on creation. */
      isNew: boolean;
      subscriptionFilters: (components["schemas"]["SubscriptionFilter"])[];
      customer: components["schemas"]["LightweightCustomer"];
      billingPlan: components["schemas"]["LightweightPlanVersion"];
      fullyBilled: boolean;
      addons: (components["schemas"]["LightweightAddOnSubscriptionRecord"])[];
      metadata: {
        [key: string]: unknown | undefined;
      };
    };
    SubscriptionRecordCancelRequest: {
      /**
       * @description When canceling a subscription, the behavior used to calculate the flat fee. If null or not provided, the charge's default behavior will be used according to the subscription's start and end dates. If chargeFull, the full flat fee will be charged, regardless of the duration of the subscription. If refund, the flat fee will not be charged. If chargeProrated, the prorated flat fee will be charged.
       * 
       * * `refund` - Refund
       * * `chargeProrated` - Prorate
       * * `chargeFull` - Charge Full 
       * @enum {string|null}
       */
      flatFeeBehavior?: "refund" | "chargeProrated" | "chargeFull" | "" | null;
      /**
       * @description If billFull, current usage will be billed on the invoice. If billNone, current unbilled usage will be dropped from the invoice. Defaults to billFull.
       * 
       * * `billFull` - Bill Full
       * * `billNone` - Bill None 
       * @default billFull 
       * @enum {string}
       */
      usageBehavior?: "billFull" | "billNone";
      /**
       * @description Whether to invoice now or invoice at the end of the billing period. Defaults to invoice now.
       * 
       * * `addToNextInvoice` - Add to Next Invoice
       * * `invoiceNow` - Invoice Now 
       * @default invoiceNow 
       * @enum {string}
       */
      invoicingBehavior?: "addToNextInvoice" | "invoiceNow";
    };
    SubscriptionRecordCreateRequest: {
      /**
       * Format: date-time 
       * @description The date the subscription starts. This should be a string in YYYY-MM-DD format of the date in UTC time.
       */
      startDate: string;
      /**
       * Format: date-time 
       * @description The date the subscription ends. This should be a string in YYYY-MM-DD format of the date in UTC time. If you don’t set it (recommended), we will use the information in the billing plan to automatically calculate this.
       */
      endDate?: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      autoRenew?: boolean;
      isNew?: boolean;
      /** @description Add filter key, value pairs that define which events will be applied to this plan subscription. */
      subscriptionFilters?: (components["schemas"]["SubscriptionFilterRequest"])[];
      /** @description The id provided when creating the customer */
      customerId: string | null;
      /**
       * Format: uuid 
       * @description The Lotus planId, found in the billing plan object. We will make a best-effort attempt to find the correct plan version (matching preferred currencies, prioritizing custom plans), but if more than one plan version or no plan version matches these criteria this will return an error.
       */
      planId?: string;
      /** @description The initial units for the plan components' prepaid fixed charges. This is only required if the plan has plan components where you did not specify the initial units. */
      componentFixedChargesInitialUnits?: (components["schemas"]["ComponentsFixedChargeInitialValueRequest"])[];
      /** @description A JSON object containing additional information about the subscription. */
      metadata?: {
        [key: string]: unknown | undefined;
      };
    };
    SubscriptionRecordCreateSerializerOldRequest: {
      /**
       * Format: date-time 
       * @description The date the subscription starts. This should be a string in YYYY-MM-DD format of the date in UTC time.
       */
      startDate: string;
      /**
       * Format: date-time 
       * @description The date the subscription ends. This should be a string in YYYY-MM-DD format of the date in UTC time. If you don’t set it (recommended), we will use the information in the billing plan to automatically calculate this.
       */
      endDate?: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      autoRenew?: boolean;
      isNew?: boolean;
      /** @description Add filter key, value pairs that define which events will be applied to this plan subscription. */
      subscriptionFilters?: (components["schemas"]["SubscriptionFilterRequest"])[];
      /** @description The id provided when creating the customer */
      customerId: string | null;
      /**
       * Format: uuid 
       * @description The Lotus planId, found in the billing plan object. This field has been deprecated in favor of versionId for the sake of being explicit. If used, a best effort will be made to find the correct plan version (matching preferred currencies, prioritizing custom plans), but if more than one plan versions matches this criteria this will return an error.
       */
      planId?: string;
    };
    SubscriptionRecordRequest: {
      subscriptionId: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      startDate: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      endDate: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      autoRenew: boolean;
      /** @description Whether this subscription came from a renewal or from a first-time. Defaults to true on creation. */
      isNew: boolean;
      subscriptionFilters: (components["schemas"]["SubscriptionFilterRequest"])[];
      billingPlan: components["schemas"]["LightweightPlanVersionRequest"];
      addons: (components["schemas"]["LightweightAddOnSubscriptionRecordRequest"])[];
      metadata: {
        [key: string]: unknown | undefined;
      };
    };
    SubscriptionRecordSwitchPlanRequest: {
      /**
       * Format: uuid 
       * @description The new plan to switch to.
       */
      switchPlanId?: string;
      /**
       * @description The invoicing behavior to use when replacing the plan. Invoice now will invoice the customer for the prorated difference of the old plan and the new plan, whereas addToNextInvoice will wait until the end of the subscription to do the calculation.
       * 
       * * `addToNextInvoice` - Add to Next Invoice
       * * `invoiceNow` - Invoice Now 
       * @default invoiceNow 
       * @enum {string}
       */
      invoicingBehavior?: "addToNextInvoice" | "invoiceNow";
      /**
       * @description The usage behavior to use when replacing the plan. Transfer to new subscription will transfer the usage from the old subscription to the new subscription, whereas keepSeparate will reset the usage to 0 for the new subscription, while keeping the old usage on the old subscription and charging for that appropriately at the end of the month.
       * 
       * * `transferToNewSubscription` - Transfer to New Subscription
       * * `keepSeparate` - Keep Separate 
       * @default transferToNewSubscription 
       * @enum {string}
       */
      usageBehavior?: "transferToNewSubscription" | "keepSeparate";
      /** @description The initial units for the plan components' prepaid fixed charges. In the context of swithciong plans, this is only required if the new plan has a component the old plan did not have, that has a prepaid charge, that deos not have a default. */
      componentFixedChargesInitialUnits?: (components["schemas"]["ComponentsFixedChargeInitialValueRequest"])[];
    };
    SubscriptionRecordUpdateRequest: {
      /** @description Turn off auto renew for the subscription */
      turnOffAutoRenew?: boolean;
      /**
       * Format: date-time 
       * @description Change the end date for the subscription.
       */
      endDate?: string;
      /** @description Update the metadata for the subscription. */
      metadata?: {
        [key: string]: unknown | undefined;
      };
    };
    SubscriptionRecordUpdateSerializerOldRequest: {
      /**
       * Format: uuid 
       * @description [DEPRECATED] Will currently perform a best-effort attempt to find the correct plan version to replace the current plan with. If more than one plan version matches the criteria, this will return an error. Use the changePlan method of a subscription instance instead.
       */
      replacePlanId?: string;
      /**
       * @description The invoicing behavior to use when replacing the plan. Invoice now will invoice the customer for the prorated difference of the old plan and the new plan, whereas addToNextInvoice will wait until the end of the subscription to do the calculation.
       * 
       * * `addToNextInvoice` - Add to Next Invoice
       * * `invoiceNow` - Invoice Now 
       * @default invoiceNow 
       * @enum {string}
       */
      invoicingBehavior?: "addToNextInvoice" | "invoiceNow";
      /**
       * @description The usage behavior to use when replacing the plan. Transfer to new subscription will transfer the usage from the old subscription to the new subscription, whereas keepSeparate will reset the usage to 0 for the new subscription, while keeping the old usage on the old subscription and charging for that appropriately at the end of the month.
       * 
       * * `transferToNewSubscription` - Transfer to New Subscription
       * * `keepSeparate` - Keep Separate 
       * @default transferToNewSubscription 
       * @enum {string}
       */
      usageBehavior?: "transferToNewSubscription" | "keepSeparate";
      /** @description Turn off auto renew for the subscription */
      turnOffAutoRenew?: boolean;
      /**
       * Format: date-time 
       * @description Change the end date for the subscription.
       */
      endDate?: string;
    };
    SubscriptionRenewedRequest: {
      payload: components["schemas"]["SubscriptionRecordRequest"];
    };
    SuccessResponse: {
      success: boolean;
    };
    Tag: {
      tagName: string;
      tagHex: string;
      tagColor: string;
    };
    TagRequest: {
      tagName: string;
      tagHex: string;
      tagColor: string;
    };
    TargetCustomersRequest: {
      customerIds: (string | null)[];
    };
    TimezonesResponse: {
      timezones: (string)[];
    };
    TopCustomers: {
      originalPlanRevenue: (components["schemas"]["SingleCustomerValue"])[];
      newPlanRevenue: (components["schemas"]["SingleCustomerValue"])[];
      biggestPctIncrease: (components["schemas"]["SingleCustomerValue"])[];
      biggestPctDecrease: (components["schemas"]["SingleCustomerValue"])[];
    };
    TrackEventFailure: {
      /**
       * @description * `none` - none 
       * @enum {string}
       */
      success: "none";
      failedEvents: {
        [key: string]: unknown | undefined;
      };
    };
    TrackEventSuccess: {
      /**
       * @description * `all` - all
       * * `some` - some 
       * @enum {string}
       */
      success: "all" | "some";
      failedEvents: {
        [key: string]: unknown | undefined;
      };
    };
    TransferSubscriptionsFailure: {
      /**
       * @description * `error` - error 
       * @enum {string}
       */
      status: "error";
      detail: string;
    };
    TransferSubscriptionsRequestRequest: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      source: "stripe" | "braintree";
      endNow: boolean;
    };
    TransferSubscriptionsSuccess: {
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
      detail: string;
    };
    URLResponse: {
      /** Format: uri */
      url: string;
      exists: boolean;
    };
    UpdateCRMSourceOfTruthRequest: {
      /**
       * @description * `salesforce` - salesforce 
       * @enum {string}
       */
      crmProviderName: "salesforce";
      lotusIsSource: boolean;
    };
    UsageAlert: {
      usageAlertId: string;
      metric: components["schemas"]["Metric"];
      planVersion: components["schemas"]["LightweightPlanVersion"];
      /** Format: double */
      threshold: number;
    };
    UsageAlertCreate: {
      /** Format: uuid */
      metricId: string;
      /** Format: uuid */
      planVersionId: string;
      /** Format: double */
      threshold: number;
    };
    UsageAlertCreateRequest: {
      /** Format: uuid */
      metricId: string;
      /** Format: uuid */
      planVersionId: string;
      /** Format: double */
      threshold: number;
    };
    UsageAlertPayloadRequest: {
      subscription: components["schemas"]["LightweightSubscriptionRecordRequest"];
      usageAlert: components["schemas"]["UsageAlertRequest"];
      /** Format: double */
      usage: number;
      /** Format: date-time */
      timeTriggered: string;
    };
    UsageAlertRequest: {
      metric: components["schemas"]["MetricRequest"];
      planVersion: components["schemas"]["LightweightPlanVersionRequest"];
      /** Format: double */
      threshold: number;
    };
    UsageAlertTriggeredRequest: {
      payload: components["schemas"]["UsageAlertPayloadRequest"];
    };
    User: {
      /** @description Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only. */
      username: string;
      /** Format: email */
      email: string;
      organizationName: string;
      organizationId: string;
    };
    UserRequest: {
      /** @description Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only. */
      username: string;
      /** Format: email */
      email: string;
      organizationName: string;
      organizationId: string;
    };
    WebhookEndpoint: {
      webhookEndpointId: string;
      name?: string | null;
      webhookUrl: string;
      webhookSecret: string;
      triggers: readonly (components["schemas"]["WebhookTrigger"])[];
    };
    WebhookEndpointRequest: {
      name?: string | null;
      webhookUrl: string;
      triggersIn: ("customer.created" | "invoice.created" | "invoice.paid" | "invoice.pastDue" | "subscription.created" | "usageAlert.triggered" | "subscription.cancelled" | "subscription.renewed")[];
    };
    WebhookTrigger: {
      /**
       * @description * `customer.created` - customer.created
       * * `invoice.created` - invoice.created
       * * `invoice.paid` - invoice.paid
       * * `invoice.pastDue` - invoice.pastDue
       * * `subscription.created` - subscription.created
       * * `usageAlert.triggered` - usageAlert.triggered
       * * `subscription.cancelled` - subscription.cancelled
       * * `subscription.renewed` - subscription.renewed 
       * @enum {string}
       */
      triggerName: "customer.created" | "invoice.created" | "invoice.paid" | "invoice.pastDue" | "subscription.created" | "usageAlert.triggered" | "subscription.cancelled" | "subscription.renewed";
    };
    WebhookTriggerRequest: {
      /**
       * @description * `customer.created` - customer.created
       * * `invoice.created` - invoice.created
       * * `invoice.paid` - invoice.paid
       * * `invoice.pastDue` - invoice.pastDue
       * * `subscription.created` - subscription.created
       * * `usageAlert.triggered` - usageAlert.triggered
       * * `subscription.cancelled` - subscription.cancelled
       * * `subscription.renewed` - subscription.renewed 
       * @enum {string}
       */
      triggerName: "customer.created" | "invoice.created" | "invoice.paid" | "invoice.pastDue" | "subscription.created" | "usageAlert.triggered" | "subscription.cancelled" | "subscription.renewed";
    };
  };
  responses: never;
  parameters: never;
  requestBodies: never;
  headers: never;
  pathItems: never;
}

export type external = Record<string, never>;

export interface operations {

  /** @description API endpoint that allows events to be viewed. */
  appActionsList: {
    parameters: {
      query: {
        /** @description The pagination cursor value. */
        c?: string;
        /** @description Number of results to return per page. */
        pageSize?: number;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PaginatedActionList"];
        };
      };
    };
  };
  appAddonVersionsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["AddOnVersionCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddOnVersionCreateRequest"];
        "multipart/form-data": components["schemas"]["AddOnVersionCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["AddOnVersionDetail"];
        };
      };
    };
  };
  appAddonVersionsPartialUpdate: {
    parameters: {
      path: {
        versionId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedAddOnVersionUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedAddOnVersionUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedAddOnVersionUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddOnVersionUpdate"];
        };
      };
    };
  };
  appAddonVersionsDeleteCreate: {
    parameters: {
      path: {
        versionId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["DeleteAddOnVersion"];
        };
      };
    };
  };
  appAddonsList: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["AddOnDetail"])[];
        };
      };
    };
  };
  appAddonsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["AddOnCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddOnCreateRequest"];
        "multipart/form-data": components["schemas"]["AddOnCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["AddOnDetail"];
        };
      };
    };
  };
  appAddonsRetrieve: {
    parameters: {
      path: {
        addonId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddOnDetail"];
        };
      };
    };
  };
  appAddonsPartialUpdate: {
    parameters: {
      path: {
        addonId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedAddOnUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedAddOnUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedAddOnUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddOnUpdate"];
        };
      };
    };
  };
  appAddonsDeleteCreate: {
    parameters: {
      path: {
        addonId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["DeleteAddOn"];
        };
      };
    };
  };
  appAddonsFeaturesAddCreate: {
    parameters: {
      path: {
        addonId: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["AddFeatureToAddOnRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddFeatureToAddOnRequest"];
        "multipart/form-data": components["schemas"]["AddFeatureToAddOnRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddFeatureToAddOnResponse"];
        };
      };
    };
  };
  /** @description API endpoint that allows API Tokens to be viewed or edited. */
  appApiTokensList: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["APIToken"])[];
        };
      };
    };
  };
  /** @description API endpoint that allows API Tokens to be viewed or edited. */
  appApiTokensCreate: {
    requestBody?: {
      content: {
        "application/json": components["schemas"]["APITokenRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["APITokenRequest"];
        "multipart/form-data": components["schemas"]["APITokenRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["APITokenCreateResponse"];
        };
      };
    };
  };
  /** @description API endpoint that allows API Tokens to be viewed or edited. */
  appApiTokensDestroy: {
    parameters: {
      path: {
        prefix: string;
      };
    };
    responses: {
      /** @description No response body */
      204: never;
    };
  };
  /** @description API endpoint that allows API Tokens to be viewed or edited. */
  appApiTokensRollCreate: {
    parameters: {
      path: {
        prefix: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["APITokenRollResponse"];
        };
      };
    };
  };
  appBacktestsList: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["BacktestSummary"])[];
        };
      };
    };
  };
  appBacktestsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["BacktestCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["BacktestCreateRequest"];
        "multipart/form-data": components["schemas"]["BacktestCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["BacktestCreate"];
        };
      };
    };
  };
  appBacktestsRetrieve: {
    parameters: {
      path: {
        backtestId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["BacktestDetail"];
        };
      };
    };
  };
  appCreditsList: {
    parameters: {
      query: {
        /** @description Filter to adjustments in a specific currency */
        currencyCode?: string;
        /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
        customerId: string | null;
        /** @description Filter to adjustments that are effective after this date */
        effectiveAfter?: string;
        /** @description Filter to adjustments that are effective before this date */
        effectiveBefore?: string;
        /** @description Filter to adjustments that expire after this date */
        expiresAfter?: string;
        /** @description Filter to adjustments that expire before this date */
        expiresBefore?: string;
        /** @description Filter to adjustments that were issued after this date */
        issuedAfter?: string;
        /** @description Filter to adjustments that were issued before this date */
        issuedBefore?: string;
        /** @description Filter to a specific set of adjustment statuses. Defaults to both active and inactive. */
        status?: ("active" | "inactive")[];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["CustomerBalanceAdjustment"])[];
        };
      };
    };
  };
  appCreditsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["CustomerBalanceAdjustmentCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["CustomerBalanceAdjustmentCreateRequest"];
        "multipart/form-data": components["schemas"]["CustomerBalanceAdjustmentCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["CustomerBalanceAdjustment"];
        };
      };
    };
  };
  appCreditsRetrieve: {
    parameters: {
      path: {
        /** @description The ID of the credit to retrieve or update. */
        creditId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerBalanceAdjustment"];
        };
      };
    };
  };
  appCreditsUpdateCreate: {
    parameters: {
      path: {
        /** @description The ID of the credit to retrieve or update. */
        creditId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["CustomerBalanceAdjustmentUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["CustomerBalanceAdjustmentUpdateRequest"];
        "multipart/form-data": components["schemas"]["CustomerBalanceAdjustmentUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerBalanceAdjustment"];
        };
      };
    };
  };
  appCreditsVoidCreate: {
    parameters: {
      path: {
        /** @description The ID of the credit to retrieve or update. */
        creditId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerBalanceAdjustment"];
        };
      };
    };
  };
  appCrmList: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["SingleCRMProvider"])[];
        };
      };
    };
  };
  appCrmLinkTokenCreate: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["LinkTokenResponse"];
        };
      };
    };
  };
  appCrmSetCustomerSourceCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateCRMSourceOfTruthRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["UpdateCRMSourceOfTruthRequest"];
        "multipart/form-data": components["schemas"]["UpdateCRMSourceOfTruthRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SuccessResponse"];
        };
      };
    };
  };
  appCrmStoreTokenCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["StoreTokenRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["StoreTokenRequestRequest"];
        "multipart/form-data": components["schemas"]["StoreTokenRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["StoreTokenResponse"];
        };
      };
    };
  };
  appCustomersList: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["CustomerDetail"])[];
        };
      };
    };
  };
  appCustomersCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["CustomerCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["CustomerCreateRequest"];
        "multipart/form-data": components["schemas"]["CustomerCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["Customer"];
        };
      };
    };
  };
  appCustomersRetrieve: {
    parameters: {
      path: {
        customerId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerDetail"];
        };
      };
    };
  };
  appCustomersPartialUpdate: {
    parameters: {
      path: {
        customerId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedCustomerUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedCustomerUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedCustomerUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerUpdate"];
        };
      };
    };
  };
  appCustomersCostAnalysisRetrieve: {
    parameters: {
      query: {
        endDate: string;
        startDate: string;
      };
      path: {
        customerId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CostAnalysis"];
        };
      };
    };
  };
  appCustomersDeleteCreate: {
    parameters: {
      path: {
        customerId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerDeleteResponse"];
        };
      };
    };
  };
  appCustomersDraftInvoiceRetrieve: {
    parameters: {
      query: {
        includeNextPeriod?: boolean;
      };
      path: {
        customerId: string;
      };
    };
    responses: {
      /** @description No response body */
      200: never;
    };
  };
  /** @description Get the current settings for the organization. */
  appCustomersSummaryRetrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerSummary"];
        };
      };
    };
  };
  /** @description Get the current settings for the organization. */
  appCustomersTotalsRetrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerWithRevenue"];
        };
      };
    };
  };
  appDemoLoginCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["DemoLoginRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["DemoLoginRequestRequest"];
        "multipart/form-data": components["schemas"]["DemoLoginRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["DemoLoginSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["DemoLoginFailure"];
        };
      };
    };
  };
  appDemoRegisterCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["DemoRegistrationRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["DemoRegistrationRequest"];
        "multipart/form-data": components["schemas"]["DemoRegistrationRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["DemoRegistrationSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["DemoRegistrationFailure"];
        };
      };
    };
  };
  /** @description API endpoint that allows events to be viewed. */
  appEventsList: {
    parameters: {
      query: {
        /** @description The pagination cursor value. */
        c?: string;
        /** @description Number of results to return per page. */
        pageSize?: number;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PaginatedEventDetailList"];
        };
      };
    };
  };
  /** @description API endpoint that allows events to be viewed. */
  appEventsPropertiesRetrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["EventProperties"];
        };
      };
    };
  };
  appExternalPlanLinksCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["ExternalPlanLinkRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ExternalPlanLinkRequest"];
        "multipart/form-data": components["schemas"]["ExternalPlanLinkRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["ExternalPlanLink"];
        };
      };
    };
  };
  appExternalPlanLinksDestroy: {
    parameters: {
      query: {
        /**
         * @description * `stripe` - Stripe
         * * `braintree` - Braintree
         */
        source: "stripe" | "braintree";
      };
      path: {
        externalPlanId: string;
      };
    };
    responses: {
      /** @description No response body */
      204: never;
    };
  };
  appFeaturesList: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["FeatureDetail"])[];
        };
      };
    };
  };
  appFeaturesCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["FeatureCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["FeatureCreateRequest"];
        "multipart/form-data": components["schemas"]["FeatureCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["FeatureDetail"];
        };
      };
    };
  };
  appImportCustomersCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["ImportCustomersRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ImportCustomersRequestRequest"];
        "multipart/form-data": components["schemas"]["ImportCustomersRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["ImportCustomerSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["ImportCustomerFailure"];
        };
      };
    };
  };
  appImportPaymentObjectsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["ImportPaymentObjectsRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ImportPaymentObjectsRequestRequest"];
        "multipart/form-data": components["schemas"]["ImportPaymentObjectsRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["ImportPaymentObjectSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["ImportPaymentObjectFailure"];
        };
      };
    };
  };
  appImportSubscriptionsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["ImportSubscriptionsRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ImportSubscriptionsRequestRequest"];
        "multipart/form-data": components["schemas"]["ImportSubscriptionsRequestRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["ImportSubscriptionsSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["ImportSubscriptionsFailure"];
        };
      };
    };
  };
  appInvoicesList: {
    parameters: {
      query: {
        /** @description A filter for invoices for a specific customer */
        customerId?: string | null;
        /** @description A filter for invoices with a specific payment status */
        paymentStatus?: ("unpaid" | "paid")[];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["InvoiceDetail"])[];
        };
      };
    };
  };
  appInvoicesCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["InvoiceDetailRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["InvoiceDetailRequest"];
        "multipart/form-data": components["schemas"]["InvoiceDetailRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["InvoiceDetail"];
        };
      };
    };
  };
  appInvoicesRetrieve: {
    parameters: {
      path: {
        invoiceId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["InvoiceDetail"];
        };
      };
    };
  };
  appInvoicesPartialUpdate: {
    parameters: {
      path: {
        invoiceId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedInvoiceUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedInvoiceUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedInvoiceUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["InvoicePayment"];
        };
      };
    };
  };
  appInvoicesPdfUrlRetrieve: {
    parameters: {
      path: {
        /** @description Either an invoice ID (in the format `invoice_<uuid>`) or an invoice number (in the format `YYMMDD-000001`) */
        invoiceId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["InvoiceDetail"];
        };
      };
    };
  };
  appInvoicesSendCreate: {
    parameters: {
      path: {
        invoiceId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["InvoiceDetail"];
        };
      };
    };
  };
  appLoginCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["LoginRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["LoginRequestRequest"];
        "multipart/form-data": components["schemas"]["LoginRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["LoginSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["LoginFailure"];
        };
      };
    };
  };
  appLogoutCreate: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["LogoutSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["LogoutFailure"];
        };
      };
    };
  };
  appMetricsList: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["MetricDetail"])[];
        };
      };
    };
  };
  appMetricsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["MetricCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["MetricCreateRequest"];
        "multipart/form-data": components["schemas"]["MetricCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["MetricDetail"];
        };
      };
    };
  };
  appMetricsRetrieve: {
    parameters: {
      path: {
        metricId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["MetricDetail"];
        };
      };
    };
  };
  appMetricsPartialUpdate: {
    parameters: {
      path: {
        metricId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedMetricUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedMetricUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedMetricUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["MetricUpdate"];
        };
      };
    };
  };
  appNetsuiteCustomersRetrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["URLResponse"];
        };
      };
    };
  };
  appNetsuiteInvoicesRetrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["URLResponse"];
        };
      };
    };
  };
  appOrganizationInviteCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["InviteRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["InviteRequestRequest"];
        "multipart/form-data": components["schemas"]["InviteRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["InviteResponse"];
        };
      };
    };
  };
  appOrganizationInviteLinkCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["InviteRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["InviteRequestRequest"];
        "multipart/form-data": components["schemas"]["InviteRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["InviteLinkResponse"];
        };
      };
    };
  };
  appOrganizationSettingsList: {
    parameters: {
      query: {
        /**
         * @description Filters organizationSettings to a single settingGroup. Defaults to returning all settings.
         * 
         * * `stripe` - Stripe
         * * `braintree` - Braintree
         * * `billing` - Billing
         * * `crm` - CRM
         */
        settingGroup?: "stripe" | "braintree" | "billing" | "crm";
        /** @description Filters organizationSettings by settingName. Defaults to returning all settings. */
        settingName?: ("generateCustomerAfterCreatingInLotus" | "genCustInBraintreeAfterLotus" | "subscriptionFilterKeys" | "paymentGracePeriod" | "crmCustomerSource")[];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["OrganizationSetting"])[];
        };
      };
    };
  };
  appOrganizationSettingsRetrieve: {
    parameters: {
      path: {
        settingId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["OrganizationSetting"];
        };
      };
    };
  };
  appOrganizationSettingsPartialUpdate: {
    parameters: {
      path: {
        settingId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedOrganizationSettingUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedOrganizationSettingUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedOrganizationSettingUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["OrganizationSettingUpdate"];
        };
      };
    };
  };
  appOrganizationsList: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["Organization"])[];
        };
      };
    };
  };
  appOrganizationsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["OrganizationCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["OrganizationCreateRequest"];
        "multipart/form-data": components["schemas"]["OrganizationCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["Organization"];
        };
      };
    };
  };
  appOrganizationsPartialUpdate: {
    parameters: {
      path: {
        organizationId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedOrganizationUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedOrganizationUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedOrganizationUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["Organization"];
        };
      };
    };
  };
  appOrganizationsSyncCrmCreate: {
    parameters: {
      path: {
        organizationId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["CRMSyncRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["CRMSyncRequestRequest"];
        "multipart/form-data": components["schemas"]["CRMSyncRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["DeleteAddOn"];
        };
      };
    };
  };
  appPaymentProvidersList: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["SinglePaymentProcesor"])[];
        };
      };
    };
  };
  appPaymentProvidersCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["PaymentProcesorPostRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PaymentProcesorPostRequestRequest"];
        "multipart/form-data": components["schemas"]["PaymentProcesorPostRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PaymentProcesorPostResponse"];
        };
      };
    };
  };
  /** @description Returns the revenue for an organization in a given time period. */
  appPeriodEventsRetrieve: {
    parameters: {
      query: {
        period1_endDate: string;
        period1_startDate: string;
        period2_endDate: string;
        period2_startDate: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PeriodMetricRevenueResponse"];
        };
      };
    };
  };
  /** @description Returns the revenue for an organization in a given time period. */
  appPeriodMetricRevenueRetrieve: {
    parameters: {
      query: {
        period1_endDate: string;
        period1_startDate: string;
        period2_endDate: string;
        period2_startDate: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PeriodMetricRevenueResponse"];
        };
      };
    };
  };
  /** @description Return current usage for a customer during a given billing period. */
  appPeriodMetricUsageRetrieve: {
    parameters: {
      query: {
        endDate: string;
        startDate: string;
        topN_customers?: number;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PeriodMetricUsageResponse"];
        };
      };
    };
  };
  appPeriodSubscriptionsRetrieve: {
    parameters: {
      query: {
        period1_endDate: string;
        period1_startDate: string;
        period2_endDate: string;
        period2_startDate: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PeriodSubscriptionsResponse"];
        };
      };
    };
  };
  appPlanVersionsList: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["PlanVersionDetail"])[];
        };
      };
    };
  };
  appPlanVersionsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["PlanVersionCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PlanVersionCreateRequest"];
        "multipart/form-data": components["schemas"]["PlanVersionCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["PlanVersionDetail"];
        };
      };
    };
  };
  appPlanVersionsRetrieve: {
    parameters: {
      path: {
        versionId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PlanVersionDetail"];
        };
      };
    };
  };
  appPlanVersionsPartialUpdate: {
    parameters: {
      path: {
        versionId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedPlanVersionUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedPlanVersionUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedPlanVersionUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PlanVersionUpdate"];
        };
      };
    };
  };
  appPlanVersionsDeleteCreate: {
    parameters: {
      path: {
        versionId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["DeletePlanVersion"];
        };
      };
    };
  };
  appPlanVersionsFeaturesAddCreate: {
    parameters: {
      path: {
        versionId: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["AddFeatureRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddFeatureRequest"];
        "multipart/form-data": components["schemas"]["AddFeatureRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddFeatureResponse"];
        };
      };
    };
  };
  appPlanVersionsMakePublicCreate: {
    parameters: {
      path: {
        versionId: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["MakePublicRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["MakePublicRequestRequest"];
        "multipart/form-data": components["schemas"]["MakePublicRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["MakePublicResponse"];
        };
      };
    };
  };
  appPlanVersionsReplacementMakeCreate: {
    parameters: {
      path: {
        versionId: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["MakeReplaceWithRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["MakeReplaceWithRequest"];
        "multipart/form-data": components["schemas"]["MakeReplaceWithRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["MakeReplaceWithResponse"];
        };
      };
    };
  };
  appPlanVersionsReplacementSetCreate: {
    parameters: {
      path: {
        versionId: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["SetReplaceWithRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SetReplaceWithRequest"];
        "multipart/form-data": components["schemas"]["SetReplaceWithRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SetReplaceWithResponse"];
        };
      };
    };
  };
  appPlanVersionsSubscriptionsList: {
    parameters: {
      path: {
        versionId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["PlanVersionHistoricalSubscription"])[];
        };
      };
    };
  };
  appPlanVersionsTargetCustomersAddCreate: {
    parameters: {
      path: {
        versionId: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["TargetCustomersRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["TargetCustomersRequest"];
        "multipart/form-data": components["schemas"]["TargetCustomersRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddTargetCustomerResponse"];
        };
      };
    };
  };
  appPlanVersionsTargetCustomersRemoveCreate: {
    parameters: {
      path: {
        versionId: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["TargetCustomersRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["TargetCustomersRequest"];
        "multipart/form-data": components["schemas"]["TargetCustomersRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["RemoveTargetCustomerResponse"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  appPlansList: {
    parameters: {
      query: {
        /**
         * @description Filter to plans that have this duration.
         * 
         * * `monthly` - Monthly
         * * `quarterly` - Quarterly
         * * `yearly` - Yearly
         */
        duration?: "monthly" | "quarterly" | "yearly";
        /** @description Filter to plans that do not have any of the tags in this list. */
        excludeTags?: (string)[];
        /** @description Filter to plans that have any of the tags in this list. */
        includeTags?: (string)[];
        /** @description Filter to plans that have all of the tags in this list. */
        includeTagsAll?: (string)[];
        /** @description Filter to versions that have the currency specified by this currency code. */
        versionCurrencyCode?: string;
        /**
         * @description Filter to versions that have this custom type. If you choose customOnly, you will only see versions that have target customers. If you choose publicOnly, you will only see versions that do not have target customers.
         * 
         * * `customOnly` - Custom Only
         * * `publicOnly` - Public Only
         * * `all` - All
         */
        versionCustomType?: "customOnly" | "publicOnly" | "all";
        /** @description Filter to versions that have this status. Ended means it has an activeTo date in the past. Not started means it has an activeFrom date in the future or null. */
        versionStatus?: ("active" | "ended" | "notStarted")[];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["PlanDetail"])[];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  appPlansCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["PlanCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PlanCreateRequest"];
        "multipart/form-data": components["schemas"]["PlanCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["PlanDetail"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  appPlansRetrieve: {
    parameters: {
      query: {
        /** @description Filter to versions that have the currency specified by this currency code. */
        versionCurrencyCode?: string;
        /**
         * @description Filter to versions that have this custom type. If you choose customOnly, you will only see versions that have target customers. If you choose publicOnly, you will only see versions that do not have target customers.
         * 
         * * `customOnly` - Custom Only
         * * `publicOnly` - Public Only
         * * `all` - All
         */
        versionCustomType?: "customOnly" | "publicOnly" | "all";
        /** @description Filter to versions that have this status. Ended means it has an activeTo date in the past. Not started means it has an activeFrom date in the future or null. */
        versionStatus?: ("active" | "ended" | "notStarted")[];
      };
      path: {
        planId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PlanDetail"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  appPlansPartialUpdate: {
    parameters: {
      path: {
        planId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedPlanUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedPlanUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedPlanUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PlanUpdate"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  appPlansDeleteCreate: {
    parameters: {
      path: {
        planId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["DeletePlan"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  appPlansFeaturesAddCreate: {
    parameters: {
      path: {
        planId: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["AddFeatureToPlanRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddFeatureToPlanRequest"];
        "multipart/form-data": components["schemas"]["AddFeatureToPlanRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddFeatureToPlanResponse"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  appPlansTagsAddCreate: {
    parameters: {
      path: {
        planId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["AddPlanTagsRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddPlanTagsRequest"];
        "multipart/form-data": components["schemas"]["AddPlanTagsRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddPlanTags"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  appPlansTagsRemoveCreate: {
    parameters: {
      path: {
        planId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["RemovePlanTagsRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["RemovePlanTagsRequest"];
        "multipart/form-data": components["schemas"]["RemovePlanTagsRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["RemovePlanTags"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  appPlansTagsSetCreate: {
    parameters: {
      path: {
        planId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["SetPlanTagsRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SetPlanTagsRequest"];
        "multipart/form-data": components["schemas"]["SetPlanTagsRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SetPlanTagsResponse"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  appPlansVersionsActiveDatesUpdateCreate: {
    parameters: {
      path: {
        /** @description The ID of the plan whose versions we're changing the active dates. */
        planId: string;
        /** @description The version number to update. */
        versionNumber: number;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["ChangeActiveDatesRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ChangeActiveDatesRequest"];
        "multipart/form-data": components["schemas"]["ChangeActiveDatesRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["ChangeActiveDateResponse"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  appPlansVersionsFeaturesAddCreate: {
    parameters: {
      path: {
        /** @description The ID of the plan whose versions we're adding a feature to. */
        planId: string;
        /** @description The version number to update. */
        versionNumber: number;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["AddFeatureToPlanRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddFeatureToPlanRequest"];
        "multipart/form-data": components["schemas"]["AddFeatureToPlanRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddFeatureToPlanVersionNumberResponse"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  appPlansVersionsReplacementSetCreate: {
    parameters: {
      path: {
        planId: string;
        versionNumber: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["PlansSetReplaceWithForVersionNumberRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PlansSetReplaceWithForVersionNumberRequest"];
        "multipart/form-data": components["schemas"]["PlansSetReplaceWithForVersionNumberRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PlanVersionNumberSetReplaceWithResponse"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  appPlansVersionsTransitionSetCreate: {
    parameters: {
      path: {
        planId: string;
        versionNumber: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["PlansSetTransitionToForVersionNumberRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PlansSetTransitionToForVersionNumberRequest"];
        "multipart/form-data": components["schemas"]["PlansSetTransitionToForVersionNumberRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PlanVersionNumberSetTransitionToResponse"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  appPlansVersionsNextRetrieve: {
    parameters: {
      path: {
        planId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["NextPlanVersionNumberResponse"];
        };
      };
    };
  };
  appPlansByCustomerRetrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PlansByNumCustomers"];
        };
      };
    };
  };
  appPricingUnitsList: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["PricingUnitDetail"])[];
        };
      };
    };
  };
  appPricingUnitsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["PricingUnitDetailRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PricingUnitDetailRequest"];
        "multipart/form-data": components["schemas"]["PricingUnitDetailRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["PricingUnitDetail"];
        };
      };
    };
  };
  appRegisterCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["RegistrationRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["RegistrationRequest"];
        "multipart/form-data": components["schemas"]["RegistrationRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["RegistrationSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["RegistrationFailure"];
        };
      };
    };
  };
  appSessionRetrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SessionSuccess"];
        };
      };
    };
  };
  appStripeCancelAtPeriodEndSubscriptionsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["StripeMultiSubscriptionsRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["StripeMultiSubscriptionsRequest"];
        "multipart/form-data": components["schemas"]["StripeMultiSubscriptionsRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["StripeTurnOffAutoRenewalSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["StripeTurnOffAutoRenewalFailure"];
        };
      };
    };
  };
  appStripeCancelSubscriptionsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["StripeMultiSubscriptionsRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["StripeMultiSubscriptionsRequest"];
        "multipart/form-data": components["schemas"]["StripeMultiSubscriptionsRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["StripeCancelSubscriptionsSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["StripeCancelSubscriptionsFailure"];
        };
      };
    };
  };
  appSubscriptionsList: {
    parameters: {
      query: {
        /** @description Filter to a specific customer. */
        customerId: string | null;
        /** @description Filter to a specific plan. */
        planId?: string;
        /** @description If specified, will only return subscriptions with a start date before this date. */
        rangeEnd?: string;
        /** @description If specified, will only return subscriptions with an end date after this date. */
        rangeStart?: string;
        /** @description Filter to a specific set of subscription statuses. Defaults to active. */
        status?: ("active" | "ended" | "notStarted")[];
        /** @description Filter to a specific set of subscription filters. If your billing model only allows for one subscription per customer, you very likely do not need this field. Must be formatted as a JSON-encoded + stringified list of dictionaries, where each dictionary has a key of 'propertyName' and a key of 'value'. */
        subscriptionFilters?: (components["schemas"]["SubscriptionFilterRequest"])[];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["SubscriptionRecord"])[];
        };
      };
    };
  };
  appSubscriptionsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordCreateRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["SubscriptionRecord"];
        };
      };
    };
  };
  appSubscriptionsRetrieve: {
    parameters: {
      path: {
        subscriptionId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SubscriptionRecord"];
        };
      };
    };
  };
  appSubscriptionsAddonsCancelCreate: {
    parameters: {
      path: {
        /** @description The ID of the addon within the subscription update. */
        addonId: string;
        /** @description The ID of the subscription to update. */
        subscriptionId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordCancelRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordCancelRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordCancelRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["AddOnSubscriptionRecord"])[];
        };
      };
    };
  };
  appSubscriptionsAddonsAttachCreate: {
    parameters: {
      path: {
        /** @description The ID of the subscription to add an addon to. */
        subscriptionId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["AddOnSubscriptionRecordCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddOnSubscriptionRecordCreateRequest"];
        "multipart/form-data": components["schemas"]["AddOnSubscriptionRecordCreateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddOnSubscriptionRecord"];
        };
      };
    };
  };
  appSubscriptionsCancelCreate2: {
    parameters: {
      path: {
        /** @description The ID of the subscription to cancel. */
        subscriptionId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordCancelRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordCancelRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordCancelRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SubscriptionRecord"];
        };
      };
    };
  };
  appSubscriptionsComponentsChangePrepaidUnitsCreate: {
    parameters: {
      path: {
        /** @description The ID of the metric to alter the prepaid usage for. */
        metricId: string;
        /** @description The ID of the subscription which will have its plans switched. */
        subscriptionId: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ChangePrepaidUnitsRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ChangePrepaidUnitsRequest"];
        "multipart/form-data": components["schemas"]["ChangePrepaidUnitsRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SubscriptionRecord"];
        };
      };
    };
  };
  appSubscriptionsSwitchPlanCreate: {
    parameters: {
      path: {
        /** @description The ID of the subscription which will have its plans switched. */
        subscriptionId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordSwitchPlanRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordSwitchPlanRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordSwitchPlanRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SubscriptionRecord"];
        };
      };
    };
  };
  appSubscriptionsUpdateCreate2: {
    parameters: {
      path: {
        /** @description The ID of the subscription to update. */
        subscriptionId: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordUpdateRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SubscriptionRecord"];
        };
      };
    };
  };
  /** @deprecated */
  appSubscriptionsAddCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordCreateSerializerOldRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordCreateSerializerOldRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordCreateSerializerOldRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SubscriptionRecord"];
        };
      };
    };
  };
  /** @deprecated */
  appSubscriptionsCancelCreate: {
    parameters: {
      query: {
        /** @description Filter to a specific customer. */
        customerId: string | null;
        /** @description Filter to a specific plan. If not specified, all plans will be included in the cancellation request. */
        planId?: string;
        /** @description Filter to a specific set of subscription filters. If your billing model only allows for one subscription per customer, you very likely do not need this field. Must be formatted as a JSON-encoded + stringified list of dictionaries, where each dictionary has a key of 'propertyName' and a key of 'value'. */
        subscriptionFilters?: (components["schemas"]["SubscriptionFilterRequest"])[];
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordCancelRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordCancelRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordCancelRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["SubscriptionRecord"])[];
        };
      };
    };
  };
  appSubscriptionsUpdateCreate: {
    parameters: {
      query: {
        /** @description Filter to a specific customer. */
        customerId: string | null;
        /** @description Filter to a specific plan. */
        planId: string;
        /** @description Filter to a specific set of subscription filters. If your billing model only allows for one subscription per customer, you very likely do not need this field. Must be formatted as a JSON-encoded + stringified list of dictionaries, where each dictionary has a key of 'propertyName' and a key of 'value'. */
        subscriptionFilters?: (components["schemas"]["SubscriptionFilterRequest"])[];
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordUpdateSerializerOldRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordUpdateSerializerOldRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordUpdateSerializerOldRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["SubscriptionRecord"])[];
        };
      };
    };
  };
  /** @description Get the current settings for the organization. */
  appSwitchOrganizationCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["ChangeUserOrganizationRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ChangeUserOrganizationRequestRequest"];
        "multipart/form-data": components["schemas"]["ChangeUserOrganizationRequestRequest"];
      };
    };
    responses: {
      /** @description No response body */
      200: never;
    };
  };
  /** @description Pagination-enabled endpoint for retrieving an organization's event stream. */
  appTimezonesRetrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["TimezonesResponse"];
        };
      };
    };
  };
  appTransferSubscriptionsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["TransferSubscriptionsRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["TransferSubscriptionsRequestRequest"];
        "multipart/form-data": components["schemas"]["TransferSubscriptionsRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["TransferSubscriptionsSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["TransferSubscriptionsFailure"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing UsageAlerts. */
  appUsageAlertsList: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["UsageAlert"])[];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing UsageAlerts. */
  appUsageAlertsCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["UsageAlertCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["UsageAlertCreateRequest"];
        "multipart/form-data": components["schemas"]["UsageAlertCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["UsageAlertCreate"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing UsageAlerts. */
  appUsageAlertsRetrieve: {
    parameters: {
      path: {
        usageAlertId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["UsageAlert"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing UsageAlerts. */
  appUsageAlertsDestroy: {
    parameters: {
      path: {
        usageAlertId: string;
      };
    };
    responses: {
      /** @description No response body */
      204: never;
    };
  };
  /** @description Verifies the token and resets the password. */
  appUserPasswordResetCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["ResetPasswordRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ResetPasswordRequestRequest"];
        "multipart/form-data": components["schemas"]["ResetPasswordRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["ResetPasswordSuccess"];
        };
      };
    };
  };
  appUserPasswordResetInitCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["EmailRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["EmailRequest"];
        "multipart/form-data": components["schemas"]["EmailRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["InitResetPasswordSuccess"];
        };
      };
    };
  };
  appUsersList: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["User"])[];
        };
      };
    };
  };
  appUsersCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["UserRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["UserRequest"];
        "multipart/form-data": components["schemas"]["UserRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["User"];
        };
      };
    };
  };
  /** @description API endpoint that allows alerts to be viewed or edited. */
  appWebhooksList: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["WebhookEndpoint"])[];
        };
      };
    };
  };
  /** @description API endpoint that allows alerts to be viewed or edited. */
  appWebhooksCreate: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["WebhookEndpointRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["WebhookEndpointRequest"];
        "multipart/form-data": components["schemas"]["WebhookEndpointRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["WebhookEndpoint"];
        };
      };
    };
  };
  /** @description API endpoint that allows alerts to be viewed or edited. */
  appWebhooksRetrieve: {
    parameters: {
      path: {
        webhookEndpointId: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["WebhookEndpoint"];
        };
      };
    };
  };
  /** @description API endpoint that allows alerts to be viewed or edited. */
  appWebhooksDestroy: {
    parameters: {
      path: {
        webhookEndpointId: string;
      };
    };
    responses: {
      /** @description No response body */
      204: never;
    };
  };
  stripeWebhookCreate: {
    responses: {
      /** @description No response body */
      200: never;
    };
  };
}
