/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */


export interface paths {
  "/app/actions/": {
    /** @description API endpoint that allows events to be viewed. */
    get: operations["app_actions_list"];
  };
  "/app/addon_versions/": {
    post: operations["app_addon_versions_create"];
  };
  "/app/addon_versions/{version_id}/": {
    patch: operations["app_addon_versions_partial_update"];
  };
  "/app/addon_versions/{version_id}/delete/": {
    post: operations["app_addon_versions_delete_create"];
  };
  "/app/addons/": {
    get: operations["app_addons_list"];
    post: operations["app_addons_create"];
  };
  "/app/addons/{addon_id}/": {
    get: operations["app_addons_retrieve"];
    patch: operations["app_addons_partial_update"];
  };
  "/app/addons/{addon_id}/delete/": {
    post: operations["app_addons_delete_create"];
  };
  "/app/addons/{addon_id}/features/add/": {
    post: operations["app_addons_features_add_create"];
  };
  "/app/api_tokens/": {
    /** @description API endpoint that allows API Tokens to be viewed or edited. */
    get: operations["app_api_tokens_list"];
    /** @description API endpoint that allows API Tokens to be viewed or edited. */
    post: operations["app_api_tokens_create"];
  };
  "/app/api_tokens/{prefix}/": {
    /** @description API endpoint that allows API Tokens to be viewed or edited. */
    delete: operations["app_api_tokens_destroy"];
  };
  "/app/api_tokens/{prefix}/roll/": {
    /** @description API endpoint that allows API Tokens to be viewed or edited. */
    post: operations["app_api_tokens_roll_create"];
  };
  "/app/backtests/": {
    get: operations["app_backtests_list"];
    post: operations["app_backtests_create"];
  };
  "/app/backtests/{backtest_id}/": {
    get: operations["app_backtests_retrieve"];
  };
  "/app/credits/": {
    get: operations["app_credits_list"];
    post: operations["app_credits_create"];
  };
  "/app/credits/{credit_id}/": {
    get: operations["app_credits_retrieve"];
  };
  "/app/credits/{credit_id}/update/": {
    post: operations["app_credits_update_create"];
  };
  "/app/credits/{credit_id}/void/": {
    post: operations["app_credits_void_create"];
  };
  "/app/crm/": {
    get: operations["app_crm_list"];
  };
  "/app/crm/link_token/": {
    post: operations["app_crm_link_token_create"];
  };
  "/app/crm/set_customer_source/": {
    post: operations["app_crm_set_customer_source_create"];
  };
  "/app/crm/store_token/": {
    post: operations["app_crm_store_token_create"];
  };
  "/app/customers/": {
    get: operations["app_customers_list"];
    post: operations["app_customers_create"];
  };
  "/app/customers/{customer_id}/": {
    get: operations["app_customers_retrieve"];
    patch: operations["app_customers_partial_update"];
  };
  "/app/customers/{customer_id}/cost_analysis/": {
    get: operations["app_customers_cost_analysis_retrieve"];
  };
  "/app/customers/{customer_id}/delete/": {
    post: operations["app_customers_delete_create"];
  };
  "/app/customers/{customer_id}/draft_invoice/": {
    get: operations["app_customers_draft_invoice_retrieve"];
  };
  "/app/customers/summary/": {
    /** @description Get the current settings for the organization. */
    get: operations["app_customers_summary_retrieve"];
  };
  "/app/customers/totals/": {
    /** @description Get the current settings for the organization. */
    get: operations["app_customers_totals_retrieve"];
  };
  "/app/demo_login/": {
    post: operations["app_demo_login_create"];
  };
  "/app/demo_register/": {
    post: operations["app_demo_register_create"];
  };
  "/app/events/": {
    /** @description API endpoint that allows events to be viewed. */
    get: operations["app_events_list"];
  };
  "/app/events/properties/": {
    /** @description API endpoint that allows events to be viewed. */
    get: operations["app_events_properties_retrieve"];
  };
  "/app/external_plan_links/": {
    post: operations["app_external_plan_links_create"];
  };
  "/app/external_plan_links/{external_plan_id}/": {
    delete: operations["app_external_plan_links_destroy"];
  };
  "/app/features/": {
    get: operations["app_features_list"];
    post: operations["app_features_create"];
  };
  "/app/import_customers/": {
    post: operations["app_import_customers_create"];
  };
  "/app/import_payment_objects/": {
    post: operations["app_import_payment_objects_create"];
  };
  "/app/import_subscriptions/": {
    post: operations["app_import_subscriptions_create"];
  };
  "/app/invoices/": {
    get: operations["app_invoices_list"];
    post: operations["app_invoices_create"];
  };
  "/app/invoices/{invoice_id}/": {
    get: operations["app_invoices_retrieve"];
    patch: operations["app_invoices_partial_update"];
  };
  "/app/invoices/{invoice_id}/pdf_url/": {
    get: operations["app_invoices_pdf_url_retrieve"];
  };
  "/app/invoices/{invoice_id}/send/": {
    post: operations["app_invoices_send_create"];
  };
  "/app/login/": {
    post: operations["app_login_create"];
  };
  "/app/logout/": {
    post: operations["app_logout_create"];
  };
  "/app/metrics/": {
    get: operations["app_metrics_list"];
    post: operations["app_metrics_create"];
  };
  "/app/metrics/{metric_id}/": {
    get: operations["app_metrics_retrieve"];
    patch: operations["app_metrics_partial_update"];
  };
  "/app/netsuite_customers/": {
    get: operations["app_netsuite_customers_retrieve"];
  };
  "/app/netsuite_invoices/": {
    get: operations["app_netsuite_invoices_retrieve"];
  };
  "/app/organization/invite/": {
    post: operations["app_organization_invite_create"];
  };
  "/app/organization/invite_link/": {
    post: operations["app_organization_invite_link_create"];
  };
  "/app/organization_settings/": {
    get: operations["app_organization_settings_list"];
  };
  "/app/organization_settings/{setting_id}/": {
    get: operations["app_organization_settings_retrieve"];
    patch: operations["app_organization_settings_partial_update"];
  };
  "/app/organizations/": {
    get: operations["app_organizations_list"];
    post: operations["app_organizations_create"];
  };
  "/app/organizations/{organization_id}/": {
    patch: operations["app_organizations_partial_update"];
  };
  "/app/organizations/{organization_id}/sync_crm/": {
    post: operations["app_organizations_sync_crm_create"];
  };
  "/app/payment_providers/": {
    get: operations["app_payment_providers_list"];
    post: operations["app_payment_providers_create"];
  };
  "/app/period_events/": {
    /** @description Returns the revenue for an organization in a given time period. */
    get: operations["app_period_events_retrieve"];
  };
  "/app/period_metric_revenue/": {
    /** @description Returns the revenue for an organization in a given time period. */
    get: operations["app_period_metric_revenue_retrieve"];
  };
  "/app/period_metric_usage/": {
    /** @description Return current usage for a customer during a given billing period. */
    get: operations["app_period_metric_usage_retrieve"];
  };
  "/app/period_subscriptions/": {
    get: operations["app_period_subscriptions_retrieve"];
  };
  "/app/plan_versions/": {
    get: operations["app_plan_versions_list"];
    post: operations["app_plan_versions_create"];
  };
  "/app/plan_versions/{version_id}/": {
    get: operations["app_plan_versions_retrieve"];
    patch: operations["app_plan_versions_partial_update"];
  };
  "/app/plan_versions/{version_id}/delete/": {
    post: operations["app_plan_versions_delete_create"];
  };
  "/app/plan_versions/{version_id}/features/add/": {
    post: operations["app_plan_versions_features_add_create"];
  };
  "/app/plan_versions/{version_id}/make_public/": {
    post: operations["app_plan_versions_make_public_create"];
  };
  "/app/plan_versions/{version_id}/replacement/make/": {
    post: operations["app_plan_versions_replacement_make_create"];
  };
  "/app/plan_versions/{version_id}/replacement/set/": {
    post: operations["app_plan_versions_replacement_set_create"];
  };
  "/app/plan_versions/{version_id}/subscriptions/": {
    get: operations["app_plan_versions_subscriptions_list"];
  };
  "/app/plan_versions/{version_id}/target_customers/add/": {
    post: operations["app_plan_versions_target_customers_add_create"];
  };
  "/app/plan_versions/{version_id}/target_customers/remove/": {
    post: operations["app_plan_versions_target_customers_remove_create"];
  };
  "/app/plans/": {
    /** @description ViewSet for viewing and editing Plans. */
    get: operations["app_plans_list"];
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["app_plans_create"];
  };
  "/app/plans/{plan_id}/": {
    /** @description ViewSet for viewing and editing Plans. */
    get: operations["app_plans_retrieve"];
    /** @description ViewSet for viewing and editing Plans. */
    patch: operations["app_plans_partial_update"];
  };
  "/app/plans/{plan_id}/delete/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["app_plans_delete_create"];
  };
  "/app/plans/{plan_id}/features/add/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["app_plans_features_add_create"];
  };
  "/app/plans/{plan_id}/tags/add/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["app_plans_tags_add_create"];
  };
  "/app/plans/{plan_id}/tags/remove/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["app_plans_tags_remove_create"];
  };
  "/app/plans/{plan_id}/tags/set/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["app_plans_tags_set_create"];
  };
  "/app/plans/{plan_id}/versions/{version_number}/active_dates/update/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["app_plans_versions_active_dates_update_create"];
  };
  "/app/plans/{plan_id}/versions/{version_number}/features/add/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["app_plans_versions_features_add_create"];
  };
  "/app/plans/{plan_id}/versions/{version_number}/replacement/set/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["app_plans_versions_replacement_set_create"];
  };
  "/app/plans/{plan_id}/versions/{version_number}/transition/set/": {
    /** @description ViewSet for viewing and editing Plans. */
    post: operations["app_plans_versions_transition_set_create"];
  };
  "/app/plans/{plan_id}/versions/next/": {
    /** @description ViewSet for viewing and editing Plans. */
    get: operations["app_plans_versions_next_retrieve"];
  };
  "/app/plans_by_customer/": {
    get: operations["app_plans_by_customer_retrieve"];
  };
  "/app/pricing_units/": {
    get: operations["app_pricing_units_list"];
    post: operations["app_pricing_units_create"];
  };
  "/app/register/": {
    post: operations["app_register_create"];
  };
  "/app/session/": {
    get: operations["app_session_retrieve"];
  };
  "/app/stripe/cancel_at_period_end_subscriptions/": {
    post: operations["app_stripe_cancel_at_period_end_subscriptions_create"];
  };
  "/app/stripe/cancel_subscriptions/": {
    post: operations["app_stripe_cancel_subscriptions_create"];
  };
  "/app/subscriptions/": {
    get: operations["app_subscriptions_list"];
    post: operations["app_subscriptions_create"];
  };
  "/app/subscriptions/{subscription_id}/": {
    get: operations["app_subscriptions_retrieve"];
  };
  "/app/subscriptions/{subscription_id}/addons/{addon_id}/cancel/": {
    post: operations["app_subscriptions_addons_cancel_create"];
  };
  "/app/subscriptions/{subscription_id}/addons/attach/": {
    post: operations["app_subscriptions_addons_attach_create"];
  };
  "/app/subscriptions/{subscription_id}/cancel/": {
    post: operations["app_subscriptions_cancel_create_2"];
  };
  "/app/subscriptions/{subscription_id}/components/{metric_id}/change_prepaid_units/": {
    post: operations["app_subscriptions_components_change_prepaid_units_create"];
  };
  "/app/subscriptions/{subscription_id}/switch_plan/": {
    post: operations["app_subscriptions_switch_plan_create"];
  };
  "/app/subscriptions/{subscription_id}/update/": {
    post: operations["app_subscriptions_update_create_2"];
  };
  "/app/subscriptions/add/": {
    /** @deprecated */
    post: operations["app_subscriptions_add_create"];
  };
  "/app/subscriptions/cancel/": {
    /** @deprecated */
    post: operations["app_subscriptions_cancel_create"];
  };
  "/app/subscriptions/update/": {
    post: operations["app_subscriptions_update_create"];
  };
  "/app/switch_organization/": {
    /** @description Get the current settings for the organization. */
    post: operations["app_switch_organization_create"];
  };
  "/app/timezones/": {
    /** @description Pagination-enabled endpoint for retrieving an organization's event stream. */
    get: operations["app_timezones_retrieve"];
  };
  "/app/transfer_subscriptions/": {
    post: operations["app_transfer_subscriptions_create"];
  };
  "/app/usage_alerts/": {
    /** @description ViewSet for viewing and editing UsageAlerts. */
    get: operations["app_usage_alerts_list"];
    /** @description ViewSet for viewing and editing UsageAlerts. */
    post: operations["app_usage_alerts_create"];
  };
  "/app/usage_alerts/{usage_alert_id}/": {
    /** @description ViewSet for viewing and editing UsageAlerts. */
    get: operations["app_usage_alerts_retrieve"];
    /** @description ViewSet for viewing and editing UsageAlerts. */
    delete: operations["app_usage_alerts_destroy"];
  };
  "/app/user/password/reset/": {
    /** @description Verifies the token and resets the password. */
    post: operations["app_user_password_reset_create"];
  };
  "/app/user/password/reset/init/": {
    post: operations["app_user_password_reset_init_create"];
  };
  "/app/users/": {
    get: operations["app_users_list"];
    post: operations["app_users_create"];
  };
  "/app/webhooks/": {
    /** @description API endpoint that allows alerts to be viewed or edited. */
    get: operations["app_webhooks_list"];
    /** @description API endpoint that allows alerts to be viewed or edited. */
    post: operations["app_webhooks_create"];
  };
  "/app/webhooks/{webhook_endpoint_id}/": {
    /** @description API endpoint that allows alerts to be viewed or edited. */
    get: operations["app_webhooks_retrieve"];
    /** @description API endpoint that allows alerts to be viewed or edited. */
    delete: operations["app_webhooks_destroy"];
  };
  "/stripe/webhook/": {
    post: operations["stripe_webhook_create"];
  };
}

export type webhooks = Record<string, never>;

export interface components {
  schemas: {
    APIToken: {
      /** @description A free-form name for the API key. Need not be unique. 50 characters max. */
      name?: string;
      prefix: string;
      /**
       * Expires 
       * Format: date-time 
       * @description Once API key expires, clients cannot use it anymore.
       */
      expiry_date?: string | null;
      /** Format: date-time */
      created: string;
    };
    APITokenCreateResponse: {
      api_key: components["schemas"]["APIToken"];
      key: string;
    };
    APITokenRequest: {
      /** @description A free-form name for the API key. Need not be unique. 50 characters max. */
      name?: string;
      /**
       * Expires 
       * Format: date-time 
       * @description Once API key expires, clients cannot use it anymore.
       */
      expiry_date?: string | null;
    };
    APITokenRollResponse: {
      api_key: components["schemas"]["APIToken"];
      key: string;
    };
    AccessMethodsSubscriptionRecord: {
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      start_date: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      end_date: string;
      subscription_filters: (components["schemas"]["SubscriptionFilter"])[];
      plan: components["schemas"]["LightweightPlanVersion"];
    };
    /** @description DRF serializer for :class:`~activity.models.Action`. */
    Action: {
      id: number;
      actor: string;
      verb: string;
      action_object: string;
      target: string;
      public?: boolean;
      description?: string | null;
      /** Format: date-time */
      timestamp?: string;
    };
    AddFeatureRequest: {
      /**
       * Format: uuid 
       * @description The feature_id of the feature you want to add to the plan.
       */
      feature_id: string;
    };
    AddFeatureResponse: {
      success: boolean;
      message: string;
    };
    AddFeatureToAddOnRequest: {
      /** @description The version_ids of the AddOn versions you want to add the feature to. If you want to apply to all versions, use the all_versions parameter. */
      version_ids?: (string)[];
      /**
       * Format: uuid 
       * @description The feature_id of the feature you want to add to the plan.
       */
      feature_id: string;
    };
    AddFeatureToAddOnResponse: {
      success: boolean;
      message: string;
    };
    AddFeatureToPlanRequest: {
      /** @description The version_ids of the plan versions you want to add the feature to. If you want to apply to all versions, use the all_versions parameter. */
      version_ids?: (string)[];
      /**
       * @description Whether or not to apply this feature to all versions of the feature. If you want to apply to specific versions, use the version_ids parameter. 
       * @default false
       */
      all_versions?: boolean;
      /**
       * Format: uuid 
       * @description The feature_id of the feature you want to add to the plan.
       */
      feature_id: string;
    };
    AddFeatureToPlanResponse: {
      success: boolean;
      message: string;
    };
    AddFeatureToPlanVersionNumberResponse: {
      success: boolean;
      message: string;
    };
    AddOnCreateRequest: {
      /** @description The name of the add-on plan. */
      addon_name: string;
      /** @description The description of the add-on plan. */
      addon_description: string;
      /** @description The initial version of the add-on plan. */
      initial_version: components["schemas"]["InitialAddOnVersionCreateRequest"];
    };
    AddOnDetail: {
      /** @description The name of the add-on plan. */
      addon_name: string;
      /** @description The description of the add-on plan. */
      addon_description: string;
      /** @description The ID of the add-on plan. */
      addon_id: string;
      /** @description This addon's versions. */
      versions: (components["schemas"]["AddOnVersion"])[];
    };
    AddOnSubscriptionRecord: {
      addon_subscription_id: string;
      customer: components["schemas"]["LightweightCustomer"];
      addon: components["schemas"]["LightweightAddOn"];
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      start_date: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      end_date: string;
      parent: components["schemas"]["LightweightSubscriptionRecord"];
      fully_billed: boolean;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      auto_renew: boolean;
      metadata: {
        [key: string]: unknown | undefined;
      };
    };
    AddOnSubscriptionRecordCreateRequest: {
      /**
       * Format: uuid 
       * @description The add-on to be applied to the subscription.
       */
      addon_id?: string;
      /**
       * @description The quantity of the add-on to be applied to the subscription. Flat fees of add-ons will be multiplied by this quantity. Usage-based components of add-ons will be unaffected by the quantity. 
       * @default 1
       */
      quantity?: number;
      /** @description A JSON object containing additional information about the add-on subscription. This will be returned in the response when you retrieve the add-on subscription. */
      metadata?: {
        [key: string]: unknown | undefined;
      };
    };
    AddOnUpdate: {
      addon_name?: string;
      /** Format: date-time */
      active_from?: string;
      /** Format: date-time */
      active_to?: string | null;
    };
    AddOnVersion: {
      recurring_charges: (components["schemas"]["RecurringCharge"])[];
      components: (components["schemas"]["PlanComponent"])[];
      features: (components["schemas"]["Feature"])[];
      /**
       * @description * `active` - Active
       * * `retiring` - Retiring
       * * `grandfathered` - Grandfathered
       * * `deleted` - Deleted
       * * `inactive` - Inactive
       * * `not_started` - Not Started 
       * @enum {string}
       */
      status: "active" | "retiring" | "grandfathered" | "deleted" | "inactive" | "not_started";
      /** @description Currency of the plan. Can only be null if the flat fee is 0 and all components are of type free. */
      currency: components["schemas"]["PricingUnit"];
      /** @description The number of active instances of this version of the add-on plan. */
      active_instances: number;
      /**
       * @description * `invoice_on_attach` - invoice_on_attach
       * * `invoice_on_subscription_end` - invoice_on_subscription_end 
       * @enum {unknown}
       */
      invoice_when: "invoice_on_attach" | "invoice_on_subscription_end";
      /**
       * @description * `one_time` - one_time
       * * `recurring` - recurring 
       * @enum {unknown}
       */
      billing_frequency: "one_time" | "recurring";
      /** @enum {string} */
      addon_type: "usage_based" | "flat";
    };
    AddOnVersionCreateRequest: {
      /** Format: uuid */
      addon_id: string;
      recurring_charges?: (components["schemas"]["RecurringChargeCreateRequest"])[] | null;
      components?: (components["schemas"]["PlanComponentCreateRequest"])[] | null;
      features?: (string)[];
      currency_code: string;
      /**
       * @description * `invoice_on_attach` - invoice_on_attach
       * * `invoice_on_subscription_end` - invoice_on_subscription_end 
       * @enum {unknown}
       */
      invoice_when: "invoice_on_attach" | "invoice_on_subscription_end";
      /**
       * @description * `one_time` - one_time
       * * `recurring` - recurring 
       * @enum {unknown}
       */
      billing_frequency: "one_time" | "recurring";
    };
    AddOnVersionDetail: {
      recurring_charges: (components["schemas"]["RecurringCharge"])[];
      components: (components["schemas"]["PlanComponent"])[];
      features: (components["schemas"]["Feature"])[];
      /**
       * @description * `active` - Active
       * * `retiring` - Retiring
       * * `grandfathered` - Grandfathered
       * * `deleted` - Deleted
       * * `inactive` - Inactive
       * * `not_started` - Not Started 
       * @enum {string}
       */
      status: "active" | "retiring" | "grandfathered" | "deleted" | "inactive" | "not_started";
      /** @description Currency of the plan. Can only be null if the flat fee is 0 and all components are of type free. */
      currency: components["schemas"]["PricingUnit"];
      /** @description The number of active instances of this version of the add-on plan. */
      active_instances: number;
      /**
       * @description * `invoice_on_attach` - invoice_on_attach
       * * `invoice_on_subscription_end` - invoice_on_subscription_end 
       * @enum {unknown}
       */
      invoice_when: "invoice_on_attach" | "invoice_on_subscription_end";
      /**
       * @description * `one_time` - one_time
       * * `recurring` - recurring 
       * @enum {unknown}
       */
      billing_frequency: "one_time" | "recurring";
      /** @enum {string} */
      addon_type: "usage_based" | "flat";
    };
    AddOnVersionUpdate: {
      addon_version_name?: string;
      /** Format: date-time */
      active_from?: string | null;
      /** Format: date-time */
      active_to?: string | null;
    };
    AddPlanTags: {
      tags?: (components["schemas"]["Tag"])[];
      success: boolean;
      message: string;
    };
    AddPlanTagsRequest: {
      tags?: (components["schemas"]["TagRequest"])[];
    };
    AddTargetCustomerResponse: {
      success: boolean;
      message: string;
    };
    Address: {
      /** @description City, district, suburb, town, or village */
      city: string;
      /**
       * @description Two-letter country code (ISO 3166-1 alpha-2)
       * 
       * * `AW` - Aruba
       * * `AF` - Afghanistan
       * * `AO` - Angola
       * * `AI` - Anguilla
       * * `AX` - Åland Islands
       * * `AL` - Albania
       * * `AD` - Andorra
       * * `AE` - United Arab Emirates
       * * `AR` - Argentina
       * * `AM` - Armenia
       * * `AS` - American Samoa
       * * `AQ` - Antarctica
       * * `TF` - French Southern Territories
       * * `AG` - Antigua and Barbuda
       * * `AU` - Australia
       * * `AT` - Austria
       * * `AZ` - Azerbaijan
       * * `BI` - Burundi
       * * `BE` - Belgium
       * * `BJ` - Benin
       * * `BQ` - Bonaire, Sint Eustatius and Saba
       * * `BF` - Burkina Faso
       * * `BD` - Bangladesh
       * * `BG` - Bulgaria
       * * `BH` - Bahrain
       * * `BS` - Bahamas
       * * `BA` - Bosnia and Herzegovina
       * * `BL` - Saint Barthélemy
       * * `BY` - Belarus
       * * `BZ` - Belize
       * * `BM` - Bermuda
       * * `BO` - Bolivia, Plurinational State of
       * * `BR` - Brazil
       * * `BB` - Barbados
       * * `BN` - Brunei Darussalam
       * * `BT` - Bhutan
       * * `BV` - Bouvet Island
       * * `BW` - Botswana
       * * `CF` - Central African Republic
       * * `CA` - Canada
       * * `CC` - Cocos (Keeling) Islands
       * * `CH` - Switzerland
       * * `CL` - Chile
       * * `CN` - China
       * * `CI` - Côte d'Ivoire
       * * `CM` - Cameroon
       * * `CD` - Congo, The Democratic Republic of the
       * * `CG` - Congo
       * * `CK` - Cook Islands
       * * `CO` - Colombia
       * * `KM` - Comoros
       * * `CV` - Cabo Verde
       * * `CR` - Costa Rica
       * * `CU` - Cuba
       * * `CW` - Curaçao
       * * `CX` - Christmas Island
       * * `KY` - Cayman Islands
       * * `CY` - Cyprus
       * * `CZ` - Czechia
       * * `DE` - Germany
       * * `DJ` - Djibouti
       * * `DM` - Dominica
       * * `DK` - Denmark
       * * `DO` - Dominican Republic
       * * `DZ` - Algeria
       * * `EC` - Ecuador
       * * `EG` - Egypt
       * * `ER` - Eritrea
       * * `EH` - Western Sahara
       * * `ES` - Spain
       * * `EE` - Estonia
       * * `ET` - Ethiopia
       * * `FI` - Finland
       * * `FJ` - Fiji
       * * `FK` - Falkland Islands (Malvinas)
       * * `FR` - France
       * * `FO` - Faroe Islands
       * * `FM` - Micronesia, Federated States of
       * * `GA` - Gabon
       * * `GB` - United Kingdom
       * * `GE` - Georgia
       * * `GG` - Guernsey
       * * `GH` - Ghana
       * * `GI` - Gibraltar
       * * `GN` - Guinea
       * * `GP` - Guadeloupe
       * * `GM` - Gambia
       * * `GW` - Guinea-Bissau
       * * `GQ` - Equatorial Guinea
       * * `GR` - Greece
       * * `GD` - Grenada
       * * `GL` - Greenland
       * * `GT` - Guatemala
       * * `GF` - French Guiana
       * * `GU` - Guam
       * * `GY` - Guyana
       * * `HK` - Hong Kong
       * * `HM` - Heard Island and McDonald Islands
       * * `HN` - Honduras
       * * `HR` - Croatia
       * * `HT` - Haiti
       * * `HU` - Hungary
       * * `ID` - Indonesia
       * * `IM` - Isle of Man
       * * `IN` - India
       * * `IO` - British Indian Ocean Territory
       * * `IE` - Ireland
       * * `IR` - Iran, Islamic Republic of
       * * `IQ` - Iraq
       * * `IS` - Iceland
       * * `IL` - Israel
       * * `IT` - Italy
       * * `JM` - Jamaica
       * * `JE` - Jersey
       * * `JO` - Jordan
       * * `JP` - Japan
       * * `KZ` - Kazakhstan
       * * `KE` - Kenya
       * * `KG` - Kyrgyzstan
       * * `KH` - Cambodia
       * * `KI` - Kiribati
       * * `KN` - Saint Kitts and Nevis
       * * `KR` - Korea, Republic of
       * * `KW` - Kuwait
       * * `LA` - Lao People's Democratic Republic
       * * `LB` - Lebanon
       * * `LR` - Liberia
       * * `LY` - Libya
       * * `LC` - Saint Lucia
       * * `LI` - Liechtenstein
       * * `LK` - Sri Lanka
       * * `LS` - Lesotho
       * * `LT` - Lithuania
       * * `LU` - Luxembourg
       * * `LV` - Latvia
       * * `MO` - Macao
       * * `MF` - Saint Martin (French part)
       * * `MA` - Morocco
       * * `MC` - Monaco
       * * `MD` - Moldova, Republic of
       * * `MG` - Madagascar
       * * `MV` - Maldives
       * * `MX` - Mexico
       * * `MH` - Marshall Islands
       * * `MK` - North Macedonia
       * * `ML` - Mali
       * * `MT` - Malta
       * * `MM` - Myanmar
       * * `ME` - Montenegro
       * * `MN` - Mongolia
       * * `MP` - Northern Mariana Islands
       * * `MZ` - Mozambique
       * * `MR` - Mauritania
       * * `MS` - Montserrat
       * * `MQ` - Martinique
       * * `MU` - Mauritius
       * * `MW` - Malawi
       * * `MY` - Malaysia
       * * `YT` - Mayotte
       * * `NA` - Namibia
       * * `NC` - New Caledonia
       * * `NE` - Niger
       * * `NF` - Norfolk Island
       * * `NG` - Nigeria
       * * `NI` - Nicaragua
       * * `NU` - Niue
       * * `NL` - Netherlands
       * * `NO` - Norway
       * * `NP` - Nepal
       * * `NR` - Nauru
       * * `NZ` - New Zealand
       * * `OM` - Oman
       * * `PK` - Pakistan
       * * `PA` - Panama
       * * `PN` - Pitcairn
       * * `PE` - Peru
       * * `PH` - Philippines
       * * `PW` - Palau
       * * `PG` - Papua New Guinea
       * * `PL` - Poland
       * * `PR` - Puerto Rico
       * * `KP` - Korea, Democratic People's Republic of
       * * `PT` - Portugal
       * * `PY` - Paraguay
       * * `PS` - Palestine, State of
       * * `PF` - French Polynesia
       * * `QA` - Qatar
       * * `RE` - Réunion
       * * `RO` - Romania
       * * `RU` - Russian Federation
       * * `RW` - Rwanda
       * * `SA` - Saudi Arabia
       * * `SD` - Sudan
       * * `SN` - Senegal
       * * `SG` - Singapore
       * * `GS` - South Georgia and the South Sandwich Islands
       * * `SH` - Saint Helena, Ascension and Tristan da Cunha
       * * `SJ` - Svalbard and Jan Mayen
       * * `SB` - Solomon Islands
       * * `SL` - Sierra Leone
       * * `SV` - El Salvador
       * * `SM` - San Marino
       * * `SO` - Somalia
       * * `PM` - Saint Pierre and Miquelon
       * * `RS` - Serbia
       * * `SS` - South Sudan
       * * `ST` - Sao Tome and Principe
       * * `SR` - Suriname
       * * `SK` - Slovakia
       * * `SI` - Slovenia
       * * `SE` - Sweden
       * * `SZ` - Eswatini
       * * `SX` - Sint Maarten (Dutch part)
       * * `SC` - Seychelles
       * * `SY` - Syrian Arab Republic
       * * `TC` - Turks and Caicos Islands
       * * `TD` - Chad
       * * `TG` - Togo
       * * `TH` - Thailand
       * * `TJ` - Tajikistan
       * * `TK` - Tokelau
       * * `TM` - Turkmenistan
       * * `TL` - Timor-Leste
       * * `TO` - Tonga
       * * `TT` - Trinidad and Tobago
       * * `TN` - Tunisia
       * * `TR` - Turkey
       * * `TV` - Tuvalu
       * * `TW` - Taiwan, Province of China
       * * `TZ` - Tanzania, United Republic of
       * * `UG` - Uganda
       * * `UA` - Ukraine
       * * `UM` - United States Minor Outlying Islands
       * * `UY` - Uruguay
       * * `US` - United States
       * * `UZ` - Uzbekistan
       * * `VA` - Holy See (Vatican City State)
       * * `VC` - Saint Vincent and the Grenadines
       * * `VE` - Venezuela, Bolivarian Republic of
       * * `VG` - Virgin Islands, British
       * * `VI` - Virgin Islands, U.S.
       * * `VN` - Viet Nam
       * * `VU` - Vanuatu
       * * `WF` - Wallis and Futuna
       * * `WS` - Samoa
       * * `YE` - Yemen
       * * `ZA` - South Africa
       * * `ZM` - Zambia
       * * `ZW` - Zimbabwe 
       * @enum {string}
       */
      country: "AW" | "AF" | "AO" | "AI" | "AX" | "AL" | "AD" | "AE" | "AR" | "AM" | "AS" | "AQ" | "TF" | "AG" | "AU" | "AT" | "AZ" | "BI" | "BE" | "BJ" | "BQ" | "BF" | "BD" | "BG" | "BH" | "BS" | "BA" | "BL" | "BY" | "BZ" | "BM" | "BO" | "BR" | "BB" | "BN" | "BT" | "BV" | "BW" | "CF" | "CA" | "CC" | "CH" | "CL" | "CN" | "CI" | "CM" | "CD" | "CG" | "CK" | "CO" | "KM" | "CV" | "CR" | "CU" | "CW" | "CX" | "KY" | "CY" | "CZ" | "DE" | "DJ" | "DM" | "DK" | "DO" | "DZ" | "EC" | "EG" | "ER" | "EH" | "ES" | "EE" | "ET" | "FI" | "FJ" | "FK" | "FR" | "FO" | "FM" | "GA" | "GB" | "GE" | "GG" | "GH" | "GI" | "GN" | "GP" | "GM" | "GW" | "GQ" | "GR" | "GD" | "GL" | "GT" | "GF" | "GU" | "GY" | "HK" | "HM" | "HN" | "HR" | "HT" | "HU" | "ID" | "IM" | "IN" | "IO" | "IE" | "IR" | "IQ" | "IS" | "IL" | "IT" | "JM" | "JE" | "JO" | "JP" | "KZ" | "KE" | "KG" | "KH" | "KI" | "KN" | "KR" | "KW" | "LA" | "LB" | "LR" | "LY" | "LC" | "LI" | "LK" | "LS" | "LT" | "LU" | "LV" | "MO" | "MF" | "MA" | "MC" | "MD" | "MG" | "MV" | "MX" | "MH" | "MK" | "ML" | "MT" | "MM" | "ME" | "MN" | "MP" | "MZ" | "MR" | "MS" | "MQ" | "MU" | "MW" | "MY" | "YT" | "NA" | "NC" | "NE" | "NF" | "NG" | "NI" | "NU" | "NL" | "NO" | "NP" | "NR" | "NZ" | "OM" | "PK" | "PA" | "PN" | "PE" | "PH" | "PW" | "PG" | "PL" | "PR" | "KP" | "PT" | "PY" | "PS" | "PF" | "QA" | "RE" | "RO" | "RU" | "RW" | "SA" | "SD" | "SN" | "SG" | "GS" | "SH" | "SJ" | "SB" | "SL" | "SV" | "SM" | "SO" | "PM" | "RS" | "SS" | "ST" | "SR" | "SK" | "SI" | "SE" | "SZ" | "SX" | "SC" | "SY" | "TC" | "TD" | "TG" | "TH" | "TJ" | "TK" | "TM" | "TL" | "TO" | "TT" | "TN" | "TR" | "TV" | "TW" | "TZ" | "UG" | "UA" | "UM" | "UY" | "US" | "UZ" | "VA" | "VC" | "VE" | "VG" | "VI" | "VN" | "VU" | "WF" | "WS" | "YE" | "ZA" | "ZM" | "ZW";
      /** @description Address line 1 (e.g., street, PO Box, or company name) */
      line1: string;
      /** @description Address line 2 (e.g., apartment, suite, unit, or building) */
      line2?: string | null;
      /** @description ZIP or postal code */
      postal_code: string;
      /** @description State, county, province, or region */
      state?: string | null;
    };
    AddressRequest: {
      /** @description City, district, suburb, town, or village */
      city: string;
      /**
       * @description Two-letter country code (ISO 3166-1 alpha-2)
       * 
       * * `AW` - Aruba
       * * `AF` - Afghanistan
       * * `AO` - Angola
       * * `AI` - Anguilla
       * * `AX` - Åland Islands
       * * `AL` - Albania
       * * `AD` - Andorra
       * * `AE` - United Arab Emirates
       * * `AR` - Argentina
       * * `AM` - Armenia
       * * `AS` - American Samoa
       * * `AQ` - Antarctica
       * * `TF` - French Southern Territories
       * * `AG` - Antigua and Barbuda
       * * `AU` - Australia
       * * `AT` - Austria
       * * `AZ` - Azerbaijan
       * * `BI` - Burundi
       * * `BE` - Belgium
       * * `BJ` - Benin
       * * `BQ` - Bonaire, Sint Eustatius and Saba
       * * `BF` - Burkina Faso
       * * `BD` - Bangladesh
       * * `BG` - Bulgaria
       * * `BH` - Bahrain
       * * `BS` - Bahamas
       * * `BA` - Bosnia and Herzegovina
       * * `BL` - Saint Barthélemy
       * * `BY` - Belarus
       * * `BZ` - Belize
       * * `BM` - Bermuda
       * * `BO` - Bolivia, Plurinational State of
       * * `BR` - Brazil
       * * `BB` - Barbados
       * * `BN` - Brunei Darussalam
       * * `BT` - Bhutan
       * * `BV` - Bouvet Island
       * * `BW` - Botswana
       * * `CF` - Central African Republic
       * * `CA` - Canada
       * * `CC` - Cocos (Keeling) Islands
       * * `CH` - Switzerland
       * * `CL` - Chile
       * * `CN` - China
       * * `CI` - Côte d'Ivoire
       * * `CM` - Cameroon
       * * `CD` - Congo, The Democratic Republic of the
       * * `CG` - Congo
       * * `CK` - Cook Islands
       * * `CO` - Colombia
       * * `KM` - Comoros
       * * `CV` - Cabo Verde
       * * `CR` - Costa Rica
       * * `CU` - Cuba
       * * `CW` - Curaçao
       * * `CX` - Christmas Island
       * * `KY` - Cayman Islands
       * * `CY` - Cyprus
       * * `CZ` - Czechia
       * * `DE` - Germany
       * * `DJ` - Djibouti
       * * `DM` - Dominica
       * * `DK` - Denmark
       * * `DO` - Dominican Republic
       * * `DZ` - Algeria
       * * `EC` - Ecuador
       * * `EG` - Egypt
       * * `ER` - Eritrea
       * * `EH` - Western Sahara
       * * `ES` - Spain
       * * `EE` - Estonia
       * * `ET` - Ethiopia
       * * `FI` - Finland
       * * `FJ` - Fiji
       * * `FK` - Falkland Islands (Malvinas)
       * * `FR` - France
       * * `FO` - Faroe Islands
       * * `FM` - Micronesia, Federated States of
       * * `GA` - Gabon
       * * `GB` - United Kingdom
       * * `GE` - Georgia
       * * `GG` - Guernsey
       * * `GH` - Ghana
       * * `GI` - Gibraltar
       * * `GN` - Guinea
       * * `GP` - Guadeloupe
       * * `GM` - Gambia
       * * `GW` - Guinea-Bissau
       * * `GQ` - Equatorial Guinea
       * * `GR` - Greece
       * * `GD` - Grenada
       * * `GL` - Greenland
       * * `GT` - Guatemala
       * * `GF` - French Guiana
       * * `GU` - Guam
       * * `GY` - Guyana
       * * `HK` - Hong Kong
       * * `HM` - Heard Island and McDonald Islands
       * * `HN` - Honduras
       * * `HR` - Croatia
       * * `HT` - Haiti
       * * `HU` - Hungary
       * * `ID` - Indonesia
       * * `IM` - Isle of Man
       * * `IN` - India
       * * `IO` - British Indian Ocean Territory
       * * `IE` - Ireland
       * * `IR` - Iran, Islamic Republic of
       * * `IQ` - Iraq
       * * `IS` - Iceland
       * * `IL` - Israel
       * * `IT` - Italy
       * * `JM` - Jamaica
       * * `JE` - Jersey
       * * `JO` - Jordan
       * * `JP` - Japan
       * * `KZ` - Kazakhstan
       * * `KE` - Kenya
       * * `KG` - Kyrgyzstan
       * * `KH` - Cambodia
       * * `KI` - Kiribati
       * * `KN` - Saint Kitts and Nevis
       * * `KR` - Korea, Republic of
       * * `KW` - Kuwait
       * * `LA` - Lao People's Democratic Republic
       * * `LB` - Lebanon
       * * `LR` - Liberia
       * * `LY` - Libya
       * * `LC` - Saint Lucia
       * * `LI` - Liechtenstein
       * * `LK` - Sri Lanka
       * * `LS` - Lesotho
       * * `LT` - Lithuania
       * * `LU` - Luxembourg
       * * `LV` - Latvia
       * * `MO` - Macao
       * * `MF` - Saint Martin (French part)
       * * `MA` - Morocco
       * * `MC` - Monaco
       * * `MD` - Moldova, Republic of
       * * `MG` - Madagascar
       * * `MV` - Maldives
       * * `MX` - Mexico
       * * `MH` - Marshall Islands
       * * `MK` - North Macedonia
       * * `ML` - Mali
       * * `MT` - Malta
       * * `MM` - Myanmar
       * * `ME` - Montenegro
       * * `MN` - Mongolia
       * * `MP` - Northern Mariana Islands
       * * `MZ` - Mozambique
       * * `MR` - Mauritania
       * * `MS` - Montserrat
       * * `MQ` - Martinique
       * * `MU` - Mauritius
       * * `MW` - Malawi
       * * `MY` - Malaysia
       * * `YT` - Mayotte
       * * `NA` - Namibia
       * * `NC` - New Caledonia
       * * `NE` - Niger
       * * `NF` - Norfolk Island
       * * `NG` - Nigeria
       * * `NI` - Nicaragua
       * * `NU` - Niue
       * * `NL` - Netherlands
       * * `NO` - Norway
       * * `NP` - Nepal
       * * `NR` - Nauru
       * * `NZ` - New Zealand
       * * `OM` - Oman
       * * `PK` - Pakistan
       * * `PA` - Panama
       * * `PN` - Pitcairn
       * * `PE` - Peru
       * * `PH` - Philippines
       * * `PW` - Palau
       * * `PG` - Papua New Guinea
       * * `PL` - Poland
       * * `PR` - Puerto Rico
       * * `KP` - Korea, Democratic People's Republic of
       * * `PT` - Portugal
       * * `PY` - Paraguay
       * * `PS` - Palestine, State of
       * * `PF` - French Polynesia
       * * `QA` - Qatar
       * * `RE` - Réunion
       * * `RO` - Romania
       * * `RU` - Russian Federation
       * * `RW` - Rwanda
       * * `SA` - Saudi Arabia
       * * `SD` - Sudan
       * * `SN` - Senegal
       * * `SG` - Singapore
       * * `GS` - South Georgia and the South Sandwich Islands
       * * `SH` - Saint Helena, Ascension and Tristan da Cunha
       * * `SJ` - Svalbard and Jan Mayen
       * * `SB` - Solomon Islands
       * * `SL` - Sierra Leone
       * * `SV` - El Salvador
       * * `SM` - San Marino
       * * `SO` - Somalia
       * * `PM` - Saint Pierre and Miquelon
       * * `RS` - Serbia
       * * `SS` - South Sudan
       * * `ST` - Sao Tome and Principe
       * * `SR` - Suriname
       * * `SK` - Slovakia
       * * `SI` - Slovenia
       * * `SE` - Sweden
       * * `SZ` - Eswatini
       * * `SX` - Sint Maarten (Dutch part)
       * * `SC` - Seychelles
       * * `SY` - Syrian Arab Republic
       * * `TC` - Turks and Caicos Islands
       * * `TD` - Chad
       * * `TG` - Togo
       * * `TH` - Thailand
       * * `TJ` - Tajikistan
       * * `TK` - Tokelau
       * * `TM` - Turkmenistan
       * * `TL` - Timor-Leste
       * * `TO` - Tonga
       * * `TT` - Trinidad and Tobago
       * * `TN` - Tunisia
       * * `TR` - Turkey
       * * `TV` - Tuvalu
       * * `TW` - Taiwan, Province of China
       * * `TZ` - Tanzania, United Republic of
       * * `UG` - Uganda
       * * `UA` - Ukraine
       * * `UM` - United States Minor Outlying Islands
       * * `UY` - Uruguay
       * * `US` - United States
       * * `UZ` - Uzbekistan
       * * `VA` - Holy See (Vatican City State)
       * * `VC` - Saint Vincent and the Grenadines
       * * `VE` - Venezuela, Bolivarian Republic of
       * * `VG` - Virgin Islands, British
       * * `VI` - Virgin Islands, U.S.
       * * `VN` - Viet Nam
       * * `VU` - Vanuatu
       * * `WF` - Wallis and Futuna
       * * `WS` - Samoa
       * * `YE` - Yemen
       * * `ZA` - South Africa
       * * `ZM` - Zambia
       * * `ZW` - Zimbabwe 
       * @enum {string}
       */
      country: "AW" | "AF" | "AO" | "AI" | "AX" | "AL" | "AD" | "AE" | "AR" | "AM" | "AS" | "AQ" | "TF" | "AG" | "AU" | "AT" | "AZ" | "BI" | "BE" | "BJ" | "BQ" | "BF" | "BD" | "BG" | "BH" | "BS" | "BA" | "BL" | "BY" | "BZ" | "BM" | "BO" | "BR" | "BB" | "BN" | "BT" | "BV" | "BW" | "CF" | "CA" | "CC" | "CH" | "CL" | "CN" | "CI" | "CM" | "CD" | "CG" | "CK" | "CO" | "KM" | "CV" | "CR" | "CU" | "CW" | "CX" | "KY" | "CY" | "CZ" | "DE" | "DJ" | "DM" | "DK" | "DO" | "DZ" | "EC" | "EG" | "ER" | "EH" | "ES" | "EE" | "ET" | "FI" | "FJ" | "FK" | "FR" | "FO" | "FM" | "GA" | "GB" | "GE" | "GG" | "GH" | "GI" | "GN" | "GP" | "GM" | "GW" | "GQ" | "GR" | "GD" | "GL" | "GT" | "GF" | "GU" | "GY" | "HK" | "HM" | "HN" | "HR" | "HT" | "HU" | "ID" | "IM" | "IN" | "IO" | "IE" | "IR" | "IQ" | "IS" | "IL" | "IT" | "JM" | "JE" | "JO" | "JP" | "KZ" | "KE" | "KG" | "KH" | "KI" | "KN" | "KR" | "KW" | "LA" | "LB" | "LR" | "LY" | "LC" | "LI" | "LK" | "LS" | "LT" | "LU" | "LV" | "MO" | "MF" | "MA" | "MC" | "MD" | "MG" | "MV" | "MX" | "MH" | "MK" | "ML" | "MT" | "MM" | "ME" | "MN" | "MP" | "MZ" | "MR" | "MS" | "MQ" | "MU" | "MW" | "MY" | "YT" | "NA" | "NC" | "NE" | "NF" | "NG" | "NI" | "NU" | "NL" | "NO" | "NP" | "NR" | "NZ" | "OM" | "PK" | "PA" | "PN" | "PE" | "PH" | "PW" | "PG" | "PL" | "PR" | "KP" | "PT" | "PY" | "PS" | "PF" | "QA" | "RE" | "RO" | "RU" | "RW" | "SA" | "SD" | "SN" | "SG" | "GS" | "SH" | "SJ" | "SB" | "SL" | "SV" | "SM" | "SO" | "PM" | "RS" | "SS" | "ST" | "SR" | "SK" | "SI" | "SE" | "SZ" | "SX" | "SC" | "SY" | "TC" | "TD" | "TG" | "TH" | "TJ" | "TK" | "TM" | "TL" | "TO" | "TT" | "TN" | "TR" | "TV" | "TW" | "TZ" | "UG" | "UA" | "UM" | "UY" | "US" | "UZ" | "VA" | "VC" | "VE" | "VG" | "VI" | "VN" | "VU" | "WF" | "WS" | "YE" | "ZA" | "ZM" | "ZW";
      /** @description Address line 1 (e.g., street, PO Box, or company name) */
      line1: string;
      /** @description Address line 2 (e.g., apartment, suite, unit, or building) */
      line2?: string | null;
      /** @description ZIP or postal code */
      postal_code: string;
      /** @description State, county, province, or region */
      state?: string | null;
    };
    AllSubstitutionResults: {
      substitution_results?: (components["schemas"]["SingleSubstitution"])[];
      /** Format: double */
      original_plans_revenue?: number;
      /** Format: double */
      new_plans_revenue?: number;
      /** Format: double */
      pct_revenue_change?: number | null;
    };
    BacktestCreate: {
      /** Format: date */
      start_date: string;
      /** Format: date */
      end_date: string;
      kpis: ("total_revenue")[];
      backtest_name: string;
    };
    BacktestCreateRequest: {
      /** Format: date */
      start_date: string;
      /** Format: date */
      end_date: string;
      substitutions: (components["schemas"]["BacktestSubstitutionMultiRequest"])[];
      kpis: ("total_revenue")[];
      backtest_name: string;
    };
    BacktestDetail: {
      backtest_id: string;
      /** Format: date */
      end_date: string;
      backtest_name: string;
      kpis?: {
        [key: string]: unknown | undefined;
      };
      backtest_substitutions: (components["schemas"]["BacktestSubstitution"])[];
      backtest_results: components["schemas"]["AllSubstitutionResults"];
      /**
       * @description * `running` - Running
       * * `completed` - Completed
       * * `failed` - Failed 
       * @enum {string}
       */
      status?: "running" | "completed" | "failed";
      /** Format: date-time */
      time_created?: string;
      /** Format: date */
      start_date: string;
    };
    BacktestSubstitution: {
      new_plan: components["schemas"]["PlanVersionDetail"];
      original_plan: components["schemas"]["PlanVersionDetail"];
    };
    BacktestSubstitutionMulti: {
      /** Format: uuid */
      new_plan: string;
      original_plans: (string)[];
    };
    BacktestSubstitutionMultiRequest: {
      /** Format: uuid */
      new_plan: string;
      original_plans: (string)[];
    };
    BacktestSummary: {
      backtest_name: string;
      /** Format: date */
      start_date: string;
      /** Format: date */
      end_date: string;
      /** Format: date-time */
      time_created?: string;
      kpis?: {
        [key: string]: unknown | undefined;
      };
      /**
       * @description * `running` - Running
       * * `completed` - Completed
       * * `failed` - Failed 
       * @enum {string}
       */
      status?: "running" | "completed" | "failed";
      backtest_id: string;
    };
    BatchEventRequest: {
      batch: (components["schemas"]["EventRequest"])[];
    };
    CRMSyncRequestRequest: {
      crm_provider_names?: ("salesforce")[];
    };
    CategoricalFilter: {
      property_name: string;
      /**
       * @description * `isin` - Is in
       * * `isnotin` - Is not in 
       * @enum {string}
       */
      operator: "isin" | "isnotin";
      comparison_value: (string)[];
    };
    CategoricalFilterDetailRequest: {
      property_name: string;
      /**
       * @description * `isin` - Is in
       * * `isnotin` - Is not in 
       * @enum {string}
       */
      operator: "isin" | "isnotin";
      comparison_value: (string)[];
    };
    CategoricalFilterRequest: {
      property_name: string;
      /**
       * @description * `isin` - Is in
       * * `isnotin` - Is not in 
       * @enum {string}
       */
      operator: "isin" | "isnotin";
      comparison_value: (string)[];
    };
    ChangeActiveDateResponse: {
      success: boolean;
      message: string;
    };
    ChangeActiveDatesRequest: {
      /** @description The version_ids of the plan versions you want to add the feature to. If you want to apply to all versions, use the all_versions parameter. */
      version_ids?: (string)[];
      /**
       * @description Whether or not to apply this feature to all versions of the feature. If you want to apply to specific versions, use the version_ids parameter. 
       * @default false
       */
      all_versions?: boolean;
      /**
       * Format: date-time 
       * @description The date and time that the feature should be active from. If you want to make this inactive, you can pass null here.
       */
      active_from?: string | null;
      /**
       * Format: date-time 
       * @description The date and time that the feature should be active until. If you want to make this active indefinitely, you can pass null here.
       */
      active_to?: string | null;
    };
    ChangePrepaidUnitsRequest: {
      /**
       * Format: double 
       * @description The new prepaid units for the customer.
       */
      units: number;
      /**
       * @description Whether or not to immediately invoice the customer for the change in prepaid units. 
       * @default true
       */
      invoice_now?: boolean;
    };
    ChangeUserOrganizationRequestRequest: {
      /** @description The organization ID to transfer to */
      transfer_to_organization_id: string;
    };
    ComponentCharge: {
      /**
       * Format: double 
       * @description The number of units to charge for. If left null, then it will be required at subscription create time.
       */
      units: number | null;
      /**
       * @description * `prorate` - prorate
       * * `full` - full 
       * @enum {unknown}
       */
      charge_behavior: "prorate" | "full";
    };
    ComponentChargeCreateRequest: {
      /**
       * Format: double 
       * @description The number of units to charge for. If left null, then it will be required at subscription create time.
       */
      units: number | null;
      /**
       * @description * `prorate` - prorate
       * * `full` - full 
       * @enum {unknown}
       */
      charge_behavior: "prorate" | "full";
    };
    ComponentUsage: {
      /** @description The name of the event you are checking access for. */
      event_name: string;
      /** @description The name of the metric. */
      metric_name: string;
      /** @description The metric_id of the metric. This metric_id can be found in the Lotus frontend if you haven't seen it before. */
      metric_id: string;
      /**
       * Format: double 
       * @description The current usage of the metric. Keep in mind the current usage of the metric can be different from the billable usage of the metric.
       */
      metric_usage: number;
      /**
       * Format: double 
       * @description If you specified a free tier of usage for this metric, this is the amount of usage that is free. Will be null if you did not specify a free tier for this metric.
       */
      metric_free_limit: number | null;
      /**
       * Format: double 
       * @description The total limit of the metric. Will be null if you did not specify a limit for this metric.
       */
      metric_total_limit: number | null;
    };
    ComponentsFixedChargeInitialValueRequest: {
      /**
       * Format: uuid 
       * @description The id of the metric that this initial value is for
       */
      metric_id: string;
      /**
       * Format: double 
       * @description The number of units of the metric that this initial value is for
       */
      units: number;
    };
    ConfirmConnected: {
      organization_id: string;
    };
    ConfirmIdemsReceived: {
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
      ids_not_found: (string)[];
    };
    ConfirmIdemsReceivedFailure: {
      /**
       * @description * `failure` - failure 
       * @enum {string}
       */
      status: "failure";
      error: string;
    };
    ConfirmIdemsReceivedRequestRequest: {
      idempotency_ids: (string)[];
      /** @default 30 */
      number_days_lookback?: number;
      customer_id?: string;
    };
    CostAnalysis: {
      per_day: (components["schemas"]["SingleDayCostAnalysis"])[];
      /** Format: double */
      total_cost: number;
      /** Format: double */
      total_revenue: number;
      /** Format: double */
      margin: number;
    };
    CreditDrawdown: {
      credit_id: string;
      /** Format: double */
      amount: number;
      description?: string | null;
      /** Format: date-time */
      applied_at: string;
    };
    Customer: {
      customer_id: string;
      /** Format: email */
      email: string | null;
      /** @description The display name of the customer */
      customer_name: string | null;
      invoices: readonly (components["schemas"]["LightweightInvoice"])[];
      /** Format: double */
      total_amount_due: number;
      subscriptions: readonly (components["schemas"]["SubscriptionRecord"])[];
      /** @description A dictionary containing the customer's integrations. Keys are the integration type, and the value is a dictionary containing the integration's properties, which can vary by integration. */
      integrations: components["schemas"]["CustomerIntegrations"];
      default_currency: components["schemas"]["PricingUnit"];
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      payment_provider: "stripe" | "braintree" | "" | null;
      payment_provider_id: string | null;
      has_payment_method: boolean;
      /** @deprecated */
      address?: components["schemas"]["Address"] | null;
      billing_address: components["schemas"]["Address"] | null;
      shipping_address: components["schemas"]["Address"] | null;
      /**
       * Format: double 
       * @description Tax rate as percentage. For example, 10.5 for 10.5%
       */
      tax_rate: number | null;
      /**
       * @description * `Africa/Abidjan` - Africa/Abidjan
       * * `Africa/Accra` - Africa/Accra
       * * `Africa/Addis_Ababa` - Africa/Addis_Ababa
       * * `Africa/Algiers` - Africa/Algiers
       * * `Africa/Asmara` - Africa/Asmara
       * * `Africa/Bamako` - Africa/Bamako
       * * `Africa/Bangui` - Africa/Bangui
       * * `Africa/Banjul` - Africa/Banjul
       * * `Africa/Bissau` - Africa/Bissau
       * * `Africa/Blantyre` - Africa/Blantyre
       * * `Africa/Brazzaville` - Africa/Brazzaville
       * * `Africa/Bujumbura` - Africa/Bujumbura
       * * `Africa/Cairo` - Africa/Cairo
       * * `Africa/Casablanca` - Africa/Casablanca
       * * `Africa/Ceuta` - Africa/Ceuta
       * * `Africa/Conakry` - Africa/Conakry
       * * `Africa/Dakar` - Africa/Dakar
       * * `Africa/Dar_es_Salaam` - Africa/Dar_es_Salaam
       * * `Africa/Djibouti` - Africa/Djibouti
       * * `Africa/Douala` - Africa/Douala
       * * `Africa/El_Aaiun` - Africa/El_Aaiun
       * * `Africa/Freetown` - Africa/Freetown
       * * `Africa/Gaborone` - Africa/Gaborone
       * * `Africa/Harare` - Africa/Harare
       * * `Africa/Johannesburg` - Africa/Johannesburg
       * * `Africa/Juba` - Africa/Juba
       * * `Africa/Kampala` - Africa/Kampala
       * * `Africa/Khartoum` - Africa/Khartoum
       * * `Africa/Kigali` - Africa/Kigali
       * * `Africa/Kinshasa` - Africa/Kinshasa
       * * `Africa/Lagos` - Africa/Lagos
       * * `Africa/Libreville` - Africa/Libreville
       * * `Africa/Lome` - Africa/Lome
       * * `Africa/Luanda` - Africa/Luanda
       * * `Africa/Lubumbashi` - Africa/Lubumbashi
       * * `Africa/Lusaka` - Africa/Lusaka
       * * `Africa/Malabo` - Africa/Malabo
       * * `Africa/Maputo` - Africa/Maputo
       * * `Africa/Maseru` - Africa/Maseru
       * * `Africa/Mbabane` - Africa/Mbabane
       * * `Africa/Mogadishu` - Africa/Mogadishu
       * * `Africa/Monrovia` - Africa/Monrovia
       * * `Africa/Nairobi` - Africa/Nairobi
       * * `Africa/Ndjamena` - Africa/Ndjamena
       * * `Africa/Niamey` - Africa/Niamey
       * * `Africa/Nouakchott` - Africa/Nouakchott
       * * `Africa/Ouagadougou` - Africa/Ouagadougou
       * * `Africa/Porto-Novo` - Africa/Porto-Novo
       * * `Africa/Sao_Tome` - Africa/Sao_Tome
       * * `Africa/Tripoli` - Africa/Tripoli
       * * `Africa/Tunis` - Africa/Tunis
       * * `Africa/Windhoek` - Africa/Windhoek
       * * `America/Adak` - America/Adak
       * * `America/Anchorage` - America/Anchorage
       * * `America/Anguilla` - America/Anguilla
       * * `America/Antigua` - America/Antigua
       * * `America/Araguaina` - America/Araguaina
       * * `America/Argentina/Buenos_Aires` - America/Argentina/Buenos_Aires
       * * `America/Argentina/Catamarca` - America/Argentina/Catamarca
       * * `America/Argentina/Cordoba` - America/Argentina/Cordoba
       * * `America/Argentina/Jujuy` - America/Argentina/Jujuy
       * * `America/Argentina/La_Rioja` - America/Argentina/La_Rioja
       * * `America/Argentina/Mendoza` - America/Argentina/Mendoza
       * * `America/Argentina/Rio_Gallegos` - America/Argentina/Rio_Gallegos
       * * `America/Argentina/Salta` - America/Argentina/Salta
       * * `America/Argentina/San_Juan` - America/Argentina/San_Juan
       * * `America/Argentina/San_Luis` - America/Argentina/San_Luis
       * * `America/Argentina/Tucuman` - America/Argentina/Tucuman
       * * `America/Argentina/Ushuaia` - America/Argentina/Ushuaia
       * * `America/Aruba` - America/Aruba
       * * `America/Asuncion` - America/Asuncion
       * * `America/Atikokan` - America/Atikokan
       * * `America/Bahia` - America/Bahia
       * * `America/Bahia_Banderas` - America/Bahia_Banderas
       * * `America/Barbados` - America/Barbados
       * * `America/Belem` - America/Belem
       * * `America/Belize` - America/Belize
       * * `America/Blanc-Sablon` - America/Blanc-Sablon
       * * `America/Boa_Vista` - America/Boa_Vista
       * * `America/Bogota` - America/Bogota
       * * `America/Boise` - America/Boise
       * * `America/Cambridge_Bay` - America/Cambridge_Bay
       * * `America/Campo_Grande` - America/Campo_Grande
       * * `America/Cancun` - America/Cancun
       * * `America/Caracas` - America/Caracas
       * * `America/Cayenne` - America/Cayenne
       * * `America/Cayman` - America/Cayman
       * * `America/Chicago` - America/Chicago
       * * `America/Chihuahua` - America/Chihuahua
       * * `America/Ciudad_Juarez` - America/Ciudad_Juarez
       * * `America/Costa_Rica` - America/Costa_Rica
       * * `America/Creston` - America/Creston
       * * `America/Cuiaba` - America/Cuiaba
       * * `America/Curacao` - America/Curacao
       * * `America/Danmarkshavn` - America/Danmarkshavn
       * * `America/Dawson` - America/Dawson
       * * `America/Dawson_Creek` - America/Dawson_Creek
       * * `America/Denver` - America/Denver
       * * `America/Detroit` - America/Detroit
       * * `America/Dominica` - America/Dominica
       * * `America/Edmonton` - America/Edmonton
       * * `America/Eirunepe` - America/Eirunepe
       * * `America/El_Salvador` - America/El_Salvador
       * * `America/Fort_Nelson` - America/Fort_Nelson
       * * `America/Fortaleza` - America/Fortaleza
       * * `America/Glace_Bay` - America/Glace_Bay
       * * `America/Goose_Bay` - America/Goose_Bay
       * * `America/Grand_Turk` - America/Grand_Turk
       * * `America/Grenada` - America/Grenada
       * * `America/Guadeloupe` - America/Guadeloupe
       * * `America/Guatemala` - America/Guatemala
       * * `America/Guayaquil` - America/Guayaquil
       * * `America/Guyana` - America/Guyana
       * * `America/Halifax` - America/Halifax
       * * `America/Havana` - America/Havana
       * * `America/Hermosillo` - America/Hermosillo
       * * `America/Indiana/Indianapolis` - America/Indiana/Indianapolis
       * * `America/Indiana/Knox` - America/Indiana/Knox
       * * `America/Indiana/Marengo` - America/Indiana/Marengo
       * * `America/Indiana/Petersburg` - America/Indiana/Petersburg
       * * `America/Indiana/Tell_City` - America/Indiana/Tell_City
       * * `America/Indiana/Vevay` - America/Indiana/Vevay
       * * `America/Indiana/Vincennes` - America/Indiana/Vincennes
       * * `America/Indiana/Winamac` - America/Indiana/Winamac
       * * `America/Inuvik` - America/Inuvik
       * * `America/Iqaluit` - America/Iqaluit
       * * `America/Jamaica` - America/Jamaica
       * * `America/Juneau` - America/Juneau
       * * `America/Kentucky/Louisville` - America/Kentucky/Louisville
       * * `America/Kentucky/Monticello` - America/Kentucky/Monticello
       * * `America/Kralendijk` - America/Kralendijk
       * * `America/La_Paz` - America/La_Paz
       * * `America/Lima` - America/Lima
       * * `America/Los_Angeles` - America/Los_Angeles
       * * `America/Lower_Princes` - America/Lower_Princes
       * * `America/Maceio` - America/Maceio
       * * `America/Managua` - America/Managua
       * * `America/Manaus` - America/Manaus
       * * `America/Marigot` - America/Marigot
       * * `America/Martinique` - America/Martinique
       * * `America/Matamoros` - America/Matamoros
       * * `America/Mazatlan` - America/Mazatlan
       * * `America/Menominee` - America/Menominee
       * * `America/Merida` - America/Merida
       * * `America/Metlakatla` - America/Metlakatla
       * * `America/Mexico_City` - America/Mexico_City
       * * `America/Miquelon` - America/Miquelon
       * * `America/Moncton` - America/Moncton
       * * `America/Monterrey` - America/Monterrey
       * * `America/Montevideo` - America/Montevideo
       * * `America/Montserrat` - America/Montserrat
       * * `America/Nassau` - America/Nassau
       * * `America/New_York` - America/New_York
       * * `America/Nome` - America/Nome
       * * `America/Noronha` - America/Noronha
       * * `America/North_Dakota/Beulah` - America/North_Dakota/Beulah
       * * `America/North_Dakota/Center` - America/North_Dakota/Center
       * * `America/North_Dakota/New_Salem` - America/North_Dakota/New_Salem
       * * `America/Nuuk` - America/Nuuk
       * * `America/Ojinaga` - America/Ojinaga
       * * `America/Panama` - America/Panama
       * * `America/Paramaribo` - America/Paramaribo
       * * `America/Phoenix` - America/Phoenix
       * * `America/Port-au-Prince` - America/Port-au-Prince
       * * `America/Port_of_Spain` - America/Port_of_Spain
       * * `America/Porto_Velho` - America/Porto_Velho
       * * `America/Puerto_Rico` - America/Puerto_Rico
       * * `America/Punta_Arenas` - America/Punta_Arenas
       * * `America/Rankin_Inlet` - America/Rankin_Inlet
       * * `America/Recife` - America/Recife
       * * `America/Regina` - America/Regina
       * * `America/Resolute` - America/Resolute
       * * `America/Rio_Branco` - America/Rio_Branco
       * * `America/Santarem` - America/Santarem
       * * `America/Santiago` - America/Santiago
       * * `America/Santo_Domingo` - America/Santo_Domingo
       * * `America/Sao_Paulo` - America/Sao_Paulo
       * * `America/Scoresbysund` - America/Scoresbysund
       * * `America/Sitka` - America/Sitka
       * * `America/St_Barthelemy` - America/St_Barthelemy
       * * `America/St_Johns` - America/St_Johns
       * * `America/St_Kitts` - America/St_Kitts
       * * `America/St_Lucia` - America/St_Lucia
       * * `America/St_Thomas` - America/St_Thomas
       * * `America/St_Vincent` - America/St_Vincent
       * * `America/Swift_Current` - America/Swift_Current
       * * `America/Tegucigalpa` - America/Tegucigalpa
       * * `America/Thule` - America/Thule
       * * `America/Tijuana` - America/Tijuana
       * * `America/Toronto` - America/Toronto
       * * `America/Tortola` - America/Tortola
       * * `America/Vancouver` - America/Vancouver
       * * `America/Whitehorse` - America/Whitehorse
       * * `America/Winnipeg` - America/Winnipeg
       * * `America/Yakutat` - America/Yakutat
       * * `America/Yellowknife` - America/Yellowknife
       * * `Antarctica/Casey` - Antarctica/Casey
       * * `Antarctica/Davis` - Antarctica/Davis
       * * `Antarctica/DumontDUrville` - Antarctica/DumontDUrville
       * * `Antarctica/Macquarie` - Antarctica/Macquarie
       * * `Antarctica/Mawson` - Antarctica/Mawson
       * * `Antarctica/McMurdo` - Antarctica/McMurdo
       * * `Antarctica/Palmer` - Antarctica/Palmer
       * * `Antarctica/Rothera` - Antarctica/Rothera
       * * `Antarctica/Syowa` - Antarctica/Syowa
       * * `Antarctica/Troll` - Antarctica/Troll
       * * `Antarctica/Vostok` - Antarctica/Vostok
       * * `Arctic/Longyearbyen` - Arctic/Longyearbyen
       * * `Asia/Aden` - Asia/Aden
       * * `Asia/Almaty` - Asia/Almaty
       * * `Asia/Amman` - Asia/Amman
       * * `Asia/Anadyr` - Asia/Anadyr
       * * `Asia/Aqtau` - Asia/Aqtau
       * * `Asia/Aqtobe` - Asia/Aqtobe
       * * `Asia/Ashgabat` - Asia/Ashgabat
       * * `Asia/Atyrau` - Asia/Atyrau
       * * `Asia/Baghdad` - Asia/Baghdad
       * * `Asia/Bahrain` - Asia/Bahrain
       * * `Asia/Baku` - Asia/Baku
       * * `Asia/Bangkok` - Asia/Bangkok
       * * `Asia/Barnaul` - Asia/Barnaul
       * * `Asia/Beirut` - Asia/Beirut
       * * `Asia/Bishkek` - Asia/Bishkek
       * * `Asia/Brunei` - Asia/Brunei
       * * `Asia/Chita` - Asia/Chita
       * * `Asia/Choibalsan` - Asia/Choibalsan
       * * `Asia/Colombo` - Asia/Colombo
       * * `Asia/Damascus` - Asia/Damascus
       * * `Asia/Dhaka` - Asia/Dhaka
       * * `Asia/Dili` - Asia/Dili
       * * `Asia/Dubai` - Asia/Dubai
       * * `Asia/Dushanbe` - Asia/Dushanbe
       * * `Asia/Famagusta` - Asia/Famagusta
       * * `Asia/Gaza` - Asia/Gaza
       * * `Asia/Hebron` - Asia/Hebron
       * * `Asia/Ho_Chi_Minh` - Asia/Ho_Chi_Minh
       * * `Asia/Hong_Kong` - Asia/Hong_Kong
       * * `Asia/Hovd` - Asia/Hovd
       * * `Asia/Irkutsk` - Asia/Irkutsk
       * * `Asia/Jakarta` - Asia/Jakarta
       * * `Asia/Jayapura` - Asia/Jayapura
       * * `Asia/Jerusalem` - Asia/Jerusalem
       * * `Asia/Kabul` - Asia/Kabul
       * * `Asia/Kamchatka` - Asia/Kamchatka
       * * `Asia/Karachi` - Asia/Karachi
       * * `Asia/Kathmandu` - Asia/Kathmandu
       * * `Asia/Khandyga` - Asia/Khandyga
       * * `Asia/Kolkata` - Asia/Kolkata
       * * `Asia/Krasnoyarsk` - Asia/Krasnoyarsk
       * * `Asia/Kuala_Lumpur` - Asia/Kuala_Lumpur
       * * `Asia/Kuching` - Asia/Kuching
       * * `Asia/Kuwait` - Asia/Kuwait
       * * `Asia/Macau` - Asia/Macau
       * * `Asia/Magadan` - Asia/Magadan
       * * `Asia/Makassar` - Asia/Makassar
       * * `Asia/Manila` - Asia/Manila
       * * `Asia/Muscat` - Asia/Muscat
       * * `Asia/Nicosia` - Asia/Nicosia
       * * `Asia/Novokuznetsk` - Asia/Novokuznetsk
       * * `Asia/Novosibirsk` - Asia/Novosibirsk
       * * `Asia/Omsk` - Asia/Omsk
       * * `Asia/Oral` - Asia/Oral
       * * `Asia/Phnom_Penh` - Asia/Phnom_Penh
       * * `Asia/Pontianak` - Asia/Pontianak
       * * `Asia/Pyongyang` - Asia/Pyongyang
       * * `Asia/Qatar` - Asia/Qatar
       * * `Asia/Qostanay` - Asia/Qostanay
       * * `Asia/Qyzylorda` - Asia/Qyzylorda
       * * `Asia/Riyadh` - Asia/Riyadh
       * * `Asia/Sakhalin` - Asia/Sakhalin
       * * `Asia/Samarkand` - Asia/Samarkand
       * * `Asia/Seoul` - Asia/Seoul
       * * `Asia/Shanghai` - Asia/Shanghai
       * * `Asia/Singapore` - Asia/Singapore
       * * `Asia/Srednekolymsk` - Asia/Srednekolymsk
       * * `Asia/Taipei` - Asia/Taipei
       * * `Asia/Tashkent` - Asia/Tashkent
       * * `Asia/Tbilisi` - Asia/Tbilisi
       * * `Asia/Tehran` - Asia/Tehran
       * * `Asia/Thimphu` - Asia/Thimphu
       * * `Asia/Tokyo` - Asia/Tokyo
       * * `Asia/Tomsk` - Asia/Tomsk
       * * `Asia/Ulaanbaatar` - Asia/Ulaanbaatar
       * * `Asia/Urumqi` - Asia/Urumqi
       * * `Asia/Ust-Nera` - Asia/Ust-Nera
       * * `Asia/Vientiane` - Asia/Vientiane
       * * `Asia/Vladivostok` - Asia/Vladivostok
       * * `Asia/Yakutsk` - Asia/Yakutsk
       * * `Asia/Yangon` - Asia/Yangon
       * * `Asia/Yekaterinburg` - Asia/Yekaterinburg
       * * `Asia/Yerevan` - Asia/Yerevan
       * * `Atlantic/Azores` - Atlantic/Azores
       * * `Atlantic/Bermuda` - Atlantic/Bermuda
       * * `Atlantic/Canary` - Atlantic/Canary
       * * `Atlantic/Cape_Verde` - Atlantic/Cape_Verde
       * * `Atlantic/Faroe` - Atlantic/Faroe
       * * `Atlantic/Madeira` - Atlantic/Madeira
       * * `Atlantic/Reykjavik` - Atlantic/Reykjavik
       * * `Atlantic/South_Georgia` - Atlantic/South_Georgia
       * * `Atlantic/St_Helena` - Atlantic/St_Helena
       * * `Atlantic/Stanley` - Atlantic/Stanley
       * * `Australia/Adelaide` - Australia/Adelaide
       * * `Australia/Brisbane` - Australia/Brisbane
       * * `Australia/Broken_Hill` - Australia/Broken_Hill
       * * `Australia/Darwin` - Australia/Darwin
       * * `Australia/Eucla` - Australia/Eucla
       * * `Australia/Hobart` - Australia/Hobart
       * * `Australia/Lindeman` - Australia/Lindeman
       * * `Australia/Lord_Howe` - Australia/Lord_Howe
       * * `Australia/Melbourne` - Australia/Melbourne
       * * `Australia/Perth` - Australia/Perth
       * * `Australia/Sydney` - Australia/Sydney
       * * `Canada/Atlantic` - Canada/Atlantic
       * * `Canada/Central` - Canada/Central
       * * `Canada/Eastern` - Canada/Eastern
       * * `Canada/Mountain` - Canada/Mountain
       * * `Canada/Newfoundland` - Canada/Newfoundland
       * * `Canada/Pacific` - Canada/Pacific
       * * `Europe/Amsterdam` - Europe/Amsterdam
       * * `Europe/Andorra` - Europe/Andorra
       * * `Europe/Astrakhan` - Europe/Astrakhan
       * * `Europe/Athens` - Europe/Athens
       * * `Europe/Belgrade` - Europe/Belgrade
       * * `Europe/Berlin` - Europe/Berlin
       * * `Europe/Bratislava` - Europe/Bratislava
       * * `Europe/Brussels` - Europe/Brussels
       * * `Europe/Bucharest` - Europe/Bucharest
       * * `Europe/Budapest` - Europe/Budapest
       * * `Europe/Busingen` - Europe/Busingen
       * * `Europe/Chisinau` - Europe/Chisinau
       * * `Europe/Copenhagen` - Europe/Copenhagen
       * * `Europe/Dublin` - Europe/Dublin
       * * `Europe/Gibraltar` - Europe/Gibraltar
       * * `Europe/Guernsey` - Europe/Guernsey
       * * `Europe/Helsinki` - Europe/Helsinki
       * * `Europe/Isle_of_Man` - Europe/Isle_of_Man
       * * `Europe/Istanbul` - Europe/Istanbul
       * * `Europe/Jersey` - Europe/Jersey
       * * `Europe/Kaliningrad` - Europe/Kaliningrad
       * * `Europe/Kirov` - Europe/Kirov
       * * `Europe/Kyiv` - Europe/Kyiv
       * * `Europe/Lisbon` - Europe/Lisbon
       * * `Europe/Ljubljana` - Europe/Ljubljana
       * * `Europe/London` - Europe/London
       * * `Europe/Luxembourg` - Europe/Luxembourg
       * * `Europe/Madrid` - Europe/Madrid
       * * `Europe/Malta` - Europe/Malta
       * * `Europe/Mariehamn` - Europe/Mariehamn
       * * `Europe/Minsk` - Europe/Minsk
       * * `Europe/Monaco` - Europe/Monaco
       * * `Europe/Moscow` - Europe/Moscow
       * * `Europe/Oslo` - Europe/Oslo
       * * `Europe/Paris` - Europe/Paris
       * * `Europe/Podgorica` - Europe/Podgorica
       * * `Europe/Prague` - Europe/Prague
       * * `Europe/Riga` - Europe/Riga
       * * `Europe/Rome` - Europe/Rome
       * * `Europe/Samara` - Europe/Samara
       * * `Europe/San_Marino` - Europe/San_Marino
       * * `Europe/Sarajevo` - Europe/Sarajevo
       * * `Europe/Saratov` - Europe/Saratov
       * * `Europe/Simferopol` - Europe/Simferopol
       * * `Europe/Skopje` - Europe/Skopje
       * * `Europe/Sofia` - Europe/Sofia
       * * `Europe/Stockholm` - Europe/Stockholm
       * * `Europe/Tallinn` - Europe/Tallinn
       * * `Europe/Tirane` - Europe/Tirane
       * * `Europe/Ulyanovsk` - Europe/Ulyanovsk
       * * `Europe/Vaduz` - Europe/Vaduz
       * * `Europe/Vatican` - Europe/Vatican
       * * `Europe/Vienna` - Europe/Vienna
       * * `Europe/Vilnius` - Europe/Vilnius
       * * `Europe/Volgograd` - Europe/Volgograd
       * * `Europe/Warsaw` - Europe/Warsaw
       * * `Europe/Zagreb` - Europe/Zagreb
       * * `Europe/Zurich` - Europe/Zurich
       * * `GMT` - GMT
       * * `Indian/Antananarivo` - Indian/Antananarivo
       * * `Indian/Chagos` - Indian/Chagos
       * * `Indian/Christmas` - Indian/Christmas
       * * `Indian/Cocos` - Indian/Cocos
       * * `Indian/Comoro` - Indian/Comoro
       * * `Indian/Kerguelen` - Indian/Kerguelen
       * * `Indian/Mahe` - Indian/Mahe
       * * `Indian/Maldives` - Indian/Maldives
       * * `Indian/Mauritius` - Indian/Mauritius
       * * `Indian/Mayotte` - Indian/Mayotte
       * * `Indian/Reunion` - Indian/Reunion
       * * `Pacific/Apia` - Pacific/Apia
       * * `Pacific/Auckland` - Pacific/Auckland
       * * `Pacific/Bougainville` - Pacific/Bougainville
       * * `Pacific/Chatham` - Pacific/Chatham
       * * `Pacific/Chuuk` - Pacific/Chuuk
       * * `Pacific/Easter` - Pacific/Easter
       * * `Pacific/Efate` - Pacific/Efate
       * * `Pacific/Fakaofo` - Pacific/Fakaofo
       * * `Pacific/Fiji` - Pacific/Fiji
       * * `Pacific/Funafuti` - Pacific/Funafuti
       * * `Pacific/Galapagos` - Pacific/Galapagos
       * * `Pacific/Gambier` - Pacific/Gambier
       * * `Pacific/Guadalcanal` - Pacific/Guadalcanal
       * * `Pacific/Guam` - Pacific/Guam
       * * `Pacific/Honolulu` - Pacific/Honolulu
       * * `Pacific/Kanton` - Pacific/Kanton
       * * `Pacific/Kiritimati` - Pacific/Kiritimati
       * * `Pacific/Kosrae` - Pacific/Kosrae
       * * `Pacific/Kwajalein` - Pacific/Kwajalein
       * * `Pacific/Majuro` - Pacific/Majuro
       * * `Pacific/Marquesas` - Pacific/Marquesas
       * * `Pacific/Midway` - Pacific/Midway
       * * `Pacific/Nauru` - Pacific/Nauru
       * * `Pacific/Niue` - Pacific/Niue
       * * `Pacific/Norfolk` - Pacific/Norfolk
       * * `Pacific/Noumea` - Pacific/Noumea
       * * `Pacific/Pago_Pago` - Pacific/Pago_Pago
       * * `Pacific/Palau` - Pacific/Palau
       * * `Pacific/Pitcairn` - Pacific/Pitcairn
       * * `Pacific/Pohnpei` - Pacific/Pohnpei
       * * `Pacific/Port_Moresby` - Pacific/Port_Moresby
       * * `Pacific/Rarotonga` - Pacific/Rarotonga
       * * `Pacific/Saipan` - Pacific/Saipan
       * * `Pacific/Tahiti` - Pacific/Tahiti
       * * `Pacific/Tarawa` - Pacific/Tarawa
       * * `Pacific/Tongatapu` - Pacific/Tongatapu
       * * `Pacific/Wake` - Pacific/Wake
       * * `Pacific/Wallis` - Pacific/Wallis
       * * `US/Alaska` - US/Alaska
       * * `US/Arizona` - US/Arizona
       * * `US/Central` - US/Central
       * * `US/Eastern` - US/Eastern
       * * `US/Hawaii` - US/Hawaii
       * * `US/Mountain` - US/Mountain
       * * `US/Pacific` - US/Pacific
       * * `UTC` - UTC 
       * @enum {string}
       */
      timezone: "Africa/Abidjan" | "Africa/Accra" | "Africa/Addis_Ababa" | "Africa/Algiers" | "Africa/Asmara" | "Africa/Bamako" | "Africa/Bangui" | "Africa/Banjul" | "Africa/Bissau" | "Africa/Blantyre" | "Africa/Brazzaville" | "Africa/Bujumbura" | "Africa/Cairo" | "Africa/Casablanca" | "Africa/Ceuta" | "Africa/Conakry" | "Africa/Dakar" | "Africa/Dar_es_Salaam" | "Africa/Djibouti" | "Africa/Douala" | "Africa/El_Aaiun" | "Africa/Freetown" | "Africa/Gaborone" | "Africa/Harare" | "Africa/Johannesburg" | "Africa/Juba" | "Africa/Kampala" | "Africa/Khartoum" | "Africa/Kigali" | "Africa/Kinshasa" | "Africa/Lagos" | "Africa/Libreville" | "Africa/Lome" | "Africa/Luanda" | "Africa/Lubumbashi" | "Africa/Lusaka" | "Africa/Malabo" | "Africa/Maputo" | "Africa/Maseru" | "Africa/Mbabane" | "Africa/Mogadishu" | "Africa/Monrovia" | "Africa/Nairobi" | "Africa/Ndjamena" | "Africa/Niamey" | "Africa/Nouakchott" | "Africa/Ouagadougou" | "Africa/Porto-Novo" | "Africa/Sao_Tome" | "Africa/Tripoli" | "Africa/Tunis" | "Africa/Windhoek" | "America/Adak" | "America/Anchorage" | "America/Anguilla" | "America/Antigua" | "America/Araguaina" | "America/Argentina/Buenos_Aires" | "America/Argentina/Catamarca" | "America/Argentina/Cordoba" | "America/Argentina/Jujuy" | "America/Argentina/La_Rioja" | "America/Argentina/Mendoza" | "America/Argentina/Rio_Gallegos" | "America/Argentina/Salta" | "America/Argentina/San_Juan" | "America/Argentina/San_Luis" | "America/Argentina/Tucuman" | "America/Argentina/Ushuaia" | "America/Aruba" | "America/Asuncion" | "America/Atikokan" | "America/Bahia" | "America/Bahia_Banderas" | "America/Barbados" | "America/Belem" | "America/Belize" | "America/Blanc-Sablon" | "America/Boa_Vista" | "America/Bogota" | "America/Boise" | "America/Cambridge_Bay" | "America/Campo_Grande" | "America/Cancun" | "America/Caracas" | "America/Cayenne" | "America/Cayman" | "America/Chicago" | "America/Chihuahua" | "America/Ciudad_Juarez" | "America/Costa_Rica" | "America/Creston" | "America/Cuiaba" | "America/Curacao" | "America/Danmarkshavn" | "America/Dawson" | "America/Dawson_Creek" | "America/Denver" | "America/Detroit" | "America/Dominica" | "America/Edmonton" | "America/Eirunepe" | "America/El_Salvador" | "America/Fort_Nelson" | "America/Fortaleza" | "America/Glace_Bay" | "America/Goose_Bay" | "America/Grand_Turk" | "America/Grenada" | "America/Guadeloupe" | "America/Guatemala" | "America/Guayaquil" | "America/Guyana" | "America/Halifax" | "America/Havana" | "America/Hermosillo" | "America/Indiana/Indianapolis" | "America/Indiana/Knox" | "America/Indiana/Marengo" | "America/Indiana/Petersburg" | "America/Indiana/Tell_City" | "America/Indiana/Vevay" | "America/Indiana/Vincennes" | "America/Indiana/Winamac" | "America/Inuvik" | "America/Iqaluit" | "America/Jamaica" | "America/Juneau" | "America/Kentucky/Louisville" | "America/Kentucky/Monticello" | "America/Kralendijk" | "America/La_Paz" | "America/Lima" | "America/Los_Angeles" | "America/Lower_Princes" | "America/Maceio" | "America/Managua" | "America/Manaus" | "America/Marigot" | "America/Martinique" | "America/Matamoros" | "America/Mazatlan" | "America/Menominee" | "America/Merida" | "America/Metlakatla" | "America/Mexico_City" | "America/Miquelon" | "America/Moncton" | "America/Monterrey" | "America/Montevideo" | "America/Montserrat" | "America/Nassau" | "America/New_York" | "America/Nome" | "America/Noronha" | "America/North_Dakota/Beulah" | "America/North_Dakota/Center" | "America/North_Dakota/New_Salem" | "America/Nuuk" | "America/Ojinaga" | "America/Panama" | "America/Paramaribo" | "America/Phoenix" | "America/Port-au-Prince" | "America/Port_of_Spain" | "America/Porto_Velho" | "America/Puerto_Rico" | "America/Punta_Arenas" | "America/Rankin_Inlet" | "America/Recife" | "America/Regina" | "America/Resolute" | "America/Rio_Branco" | "America/Santarem" | "America/Santiago" | "America/Santo_Domingo" | "America/Sao_Paulo" | "America/Scoresbysund" | "America/Sitka" | "America/St_Barthelemy" | "America/St_Johns" | "America/St_Kitts" | "America/St_Lucia" | "America/St_Thomas" | "America/St_Vincent" | "America/Swift_Current" | "America/Tegucigalpa" | "America/Thule" | "America/Tijuana" | "America/Toronto" | "America/Tortola" | "America/Vancouver" | "America/Whitehorse" | "America/Winnipeg" | "America/Yakutat" | "America/Yellowknife" | "Antarctica/Casey" | "Antarctica/Davis" | "Antarctica/DumontDUrville" | "Antarctica/Macquarie" | "Antarctica/Mawson" | "Antarctica/McMurdo" | "Antarctica/Palmer" | "Antarctica/Rothera" | "Antarctica/Syowa" | "Antarctica/Troll" | "Antarctica/Vostok" | "Arctic/Longyearbyen" | "Asia/Aden" | "Asia/Almaty" | "Asia/Amman" | "Asia/Anadyr" | "Asia/Aqtau" | "Asia/Aqtobe" | "Asia/Ashgabat" | "Asia/Atyrau" | "Asia/Baghdad" | "Asia/Bahrain" | "Asia/Baku" | "Asia/Bangkok" | "Asia/Barnaul" | "Asia/Beirut" | "Asia/Bishkek" | "Asia/Brunei" | "Asia/Chita" | "Asia/Choibalsan" | "Asia/Colombo" | "Asia/Damascus" | "Asia/Dhaka" | "Asia/Dili" | "Asia/Dubai" | "Asia/Dushanbe" | "Asia/Famagusta" | "Asia/Gaza" | "Asia/Hebron" | "Asia/Ho_Chi_Minh" | "Asia/Hong_Kong" | "Asia/Hovd" | "Asia/Irkutsk" | "Asia/Jakarta" | "Asia/Jayapura" | "Asia/Jerusalem" | "Asia/Kabul" | "Asia/Kamchatka" | "Asia/Karachi" | "Asia/Kathmandu" | "Asia/Khandyga" | "Asia/Kolkata" | "Asia/Krasnoyarsk" | "Asia/Kuala_Lumpur" | "Asia/Kuching" | "Asia/Kuwait" | "Asia/Macau" | "Asia/Magadan" | "Asia/Makassar" | "Asia/Manila" | "Asia/Muscat" | "Asia/Nicosia" | "Asia/Novokuznetsk" | "Asia/Novosibirsk" | "Asia/Omsk" | "Asia/Oral" | "Asia/Phnom_Penh" | "Asia/Pontianak" | "Asia/Pyongyang" | "Asia/Qatar" | "Asia/Qostanay" | "Asia/Qyzylorda" | "Asia/Riyadh" | "Asia/Sakhalin" | "Asia/Samarkand" | "Asia/Seoul" | "Asia/Shanghai" | "Asia/Singapore" | "Asia/Srednekolymsk" | "Asia/Taipei" | "Asia/Tashkent" | "Asia/Tbilisi" | "Asia/Tehran" | "Asia/Thimphu" | "Asia/Tokyo" | "Asia/Tomsk" | "Asia/Ulaanbaatar" | "Asia/Urumqi" | "Asia/Ust-Nera" | "Asia/Vientiane" | "Asia/Vladivostok" | "Asia/Yakutsk" | "Asia/Yangon" | "Asia/Yekaterinburg" | "Asia/Yerevan" | "Atlantic/Azores" | "Atlantic/Bermuda" | "Atlantic/Canary" | "Atlantic/Cape_Verde" | "Atlantic/Faroe" | "Atlantic/Madeira" | "Atlantic/Reykjavik" | "Atlantic/South_Georgia" | "Atlantic/St_Helena" | "Atlantic/Stanley" | "Australia/Adelaide" | "Australia/Brisbane" | "Australia/Broken_Hill" | "Australia/Darwin" | "Australia/Eucla" | "Australia/Hobart" | "Australia/Lindeman" | "Australia/Lord_Howe" | "Australia/Melbourne" | "Australia/Perth" | "Australia/Sydney" | "Canada/Atlantic" | "Canada/Central" | "Canada/Eastern" | "Canada/Mountain" | "Canada/Newfoundland" | "Canada/Pacific" | "Europe/Amsterdam" | "Europe/Andorra" | "Europe/Astrakhan" | "Europe/Athens" | "Europe/Belgrade" | "Europe/Berlin" | "Europe/Bratislava" | "Europe/Brussels" | "Europe/Bucharest" | "Europe/Budapest" | "Europe/Busingen" | "Europe/Chisinau" | "Europe/Copenhagen" | "Europe/Dublin" | "Europe/Gibraltar" | "Europe/Guernsey" | "Europe/Helsinki" | "Europe/Isle_of_Man" | "Europe/Istanbul" | "Europe/Jersey" | "Europe/Kaliningrad" | "Europe/Kirov" | "Europe/Kyiv" | "Europe/Lisbon" | "Europe/Ljubljana" | "Europe/London" | "Europe/Luxembourg" | "Europe/Madrid" | "Europe/Malta" | "Europe/Mariehamn" | "Europe/Minsk" | "Europe/Monaco" | "Europe/Moscow" | "Europe/Oslo" | "Europe/Paris" | "Europe/Podgorica" | "Europe/Prague" | "Europe/Riga" | "Europe/Rome" | "Europe/Samara" | "Europe/San_Marino" | "Europe/Sarajevo" | "Europe/Saratov" | "Europe/Simferopol" | "Europe/Skopje" | "Europe/Sofia" | "Europe/Stockholm" | "Europe/Tallinn" | "Europe/Tirane" | "Europe/Ulyanovsk" | "Europe/Vaduz" | "Europe/Vatican" | "Europe/Vienna" | "Europe/Vilnius" | "Europe/Volgograd" | "Europe/Warsaw" | "Europe/Zagreb" | "Europe/Zurich" | "GMT" | "Indian/Antananarivo" | "Indian/Chagos" | "Indian/Christmas" | "Indian/Cocos" | "Indian/Comoro" | "Indian/Kerguelen" | "Indian/Mahe" | "Indian/Maldives" | "Indian/Mauritius" | "Indian/Mayotte" | "Indian/Reunion" | "Pacific/Apia" | "Pacific/Auckland" | "Pacific/Bougainville" | "Pacific/Chatham" | "Pacific/Chuuk" | "Pacific/Easter" | "Pacific/Efate" | "Pacific/Fakaofo" | "Pacific/Fiji" | "Pacific/Funafuti" | "Pacific/Galapagos" | "Pacific/Gambier" | "Pacific/Guadalcanal" | "Pacific/Guam" | "Pacific/Honolulu" | "Pacific/Kanton" | "Pacific/Kiritimati" | "Pacific/Kosrae" | "Pacific/Kwajalein" | "Pacific/Majuro" | "Pacific/Marquesas" | "Pacific/Midway" | "Pacific/Nauru" | "Pacific/Niue" | "Pacific/Norfolk" | "Pacific/Noumea" | "Pacific/Pago_Pago" | "Pacific/Palau" | "Pacific/Pitcairn" | "Pacific/Pohnpei" | "Pacific/Port_Moresby" | "Pacific/Rarotonga" | "Pacific/Saipan" | "Pacific/Tahiti" | "Pacific/Tarawa" | "Pacific/Tongatapu" | "Pacific/Wake" | "Pacific/Wallis" | "US/Alaska" | "US/Arizona" | "US/Central" | "US/Eastern" | "US/Hawaii" | "US/Mountain" | "US/Pacific" | "UTC";
      /** @description A list of tax providers that are enabled for this customer. The list is ordered, meaning we will succesively try to calculate taxes using each provider until we find one that works. */
      tax_providers: readonly ("taxjar" | "lotus" | "netsuite")[];
    };
    CustomerBalanceAdjustment: {
      credit_id: string;
      customer: components["schemas"]["LightweightCustomer"];
      /** Format: double */
      amount: number;
      /** Format: double */
      amount_remaining: number;
      currency: components["schemas"]["PricingUnit"];
      description: string | null;
      /** Format: date-time */
      effective_at: string;
      /** Format: date-time */
      expires_at: string | null;
      /**
       * @description * `active` - Active
       * * `inactive` - Inactive 
       * @enum {string}
       */
      status: "active" | "inactive";
      /** Format: double */
      amount_paid: number;
      amount_paid_currency: components["schemas"]["PricingUnit"] | null;
      drawdowns: readonly (components["schemas"]["CreditDrawdown"])[];
    };
    CustomerBalanceAdjustmentCreateRequest: {
      /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
      customer_id: string | null;
      /** Format: double */
      amount: number;
      currency_code: string;
      description?: string | null;
      /** Format: date-time */
      effective_at?: string;
      /** Format: date-time */
      expires_at?: string | null;
      /** Format: double */
      amount_paid?: number;
      amount_paid_currency_code?: string;
    };
    CustomerBalanceAdjustmentUpdateRequest: {
      description?: string | null;
      /** Format: date-time */
      expires_at?: string | null;
    };
    CustomerBraintreeIntegration: {
      braintree_id: string;
      has_payment_method: boolean;
    };
    CustomerCreateRequest: {
      /** @description The display name of the customer */
      customer_name?: string | null;
      /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
      customer_id: string | null;
      /**
       * Format: email 
       * @description The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider
       */
      email: string;
      /**
       * @description The payment provider this customer is associated with. Currently, only Stripe is supported.
       * 
       * * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      payment_provider?: "stripe" | "braintree";
      /** @description The customer's ID in the specified payment provider. Please note that payment_provider and payment_provider_id are mutually necessary. */
      payment_provider_id?: string | null;
      /** @description Extra metadata for the customer */
      properties?: ({
        [key: string]: unknown | undefined;
      }) | null;
      /** @description The currency code this customer will be invoiced in. Codes are 3 letters, e.g. 'USD'. */
      default_currency_code?: string;
      /** @deprecated */
      address?: components["schemas"]["AddressRequest"] | null;
      billing_address?: components["schemas"]["AddressRequest"] | null;
      shipping_address?: components["schemas"]["AddressRequest"] | null;
      /**
       * Format: double 
       * @description Tax rate as percentage. For example, 10.5 for 10.5%
       */
      tax_rate?: number | null;
    };
    CustomerCreatedRequest: {
      payload: components["schemas"]["CustomerRequest"];
    };
    CustomerDeleteResponse: {
      customer_id: string;
      /** Format: date-time */
      deleted: string;
      /** Format: email */
      email: string | null;
      num_subscriptions_deleted: number;
      num_addons_deleted: number;
    };
    CustomerDetail: {
      default_currency: components["schemas"]["PricingUnit"];
      /**
       * Format: double 
       * @description Tax rate as percentage. For example, 10.5 for 10.5%
       */
      tax_rate: number | null;
      crm_provider_id: string | null;
      customer_id: string;
      /**
       * @description * `salesforce` - salesforce 
       * @enum {string}
       */
      crm_provider: "salesforce";
      /** @description A list of tax providers that are enabled for this customer. The list is ordered, meaning we will succesively try to calculate taxes using each provider until we find one that works. */
      tax_providers: readonly ("taxjar" | "lotus" | "netsuite")[];
      upcoming_subscriptions: readonly (components["schemas"]["SubscriptionRecord"])[];
      /** Format: uri */
      payment_provider_url: string | null;
      /** @deprecated */
      address: components["schemas"]["Address"] | null;
      invoices: readonly (components["schemas"]["LightweightInvoiceDetail"])[];
      /** @description A dictionary containing the customer's integrations. Keys are the integration type, and the value is a dictionary containing the integration's properties, which can vary by integration. */
      integrations: components["schemas"]["CustomerIntegrations"];
      has_payment_method: boolean;
      stripe_subscriptions: readonly (components["schemas"]["StripeSubscriptionRecord"])[];
      subscriptions: readonly (components["schemas"]["SubscriptionRecord"])[];
      /** Format: double */
      total_amount_due: number;
      shipping_address: components["schemas"]["Address"] | null;
      billing_address: components["schemas"]["Address"] | null;
      /** @description The display name of the customer */
      customer_name: string | null;
      /**
       * @description * `Africa/Abidjan` - Africa/Abidjan
       * * `Africa/Accra` - Africa/Accra
       * * `Africa/Addis_Ababa` - Africa/Addis_Ababa
       * * `Africa/Algiers` - Africa/Algiers
       * * `Africa/Asmara` - Africa/Asmara
       * * `Africa/Bamako` - Africa/Bamako
       * * `Africa/Bangui` - Africa/Bangui
       * * `Africa/Banjul` - Africa/Banjul
       * * `Africa/Bissau` - Africa/Bissau
       * * `Africa/Blantyre` - Africa/Blantyre
       * * `Africa/Brazzaville` - Africa/Brazzaville
       * * `Africa/Bujumbura` - Africa/Bujumbura
       * * `Africa/Cairo` - Africa/Cairo
       * * `Africa/Casablanca` - Africa/Casablanca
       * * `Africa/Ceuta` - Africa/Ceuta
       * * `Africa/Conakry` - Africa/Conakry
       * * `Africa/Dakar` - Africa/Dakar
       * * `Africa/Dar_es_Salaam` - Africa/Dar_es_Salaam
       * * `Africa/Djibouti` - Africa/Djibouti
       * * `Africa/Douala` - Africa/Douala
       * * `Africa/El_Aaiun` - Africa/El_Aaiun
       * * `Africa/Freetown` - Africa/Freetown
       * * `Africa/Gaborone` - Africa/Gaborone
       * * `Africa/Harare` - Africa/Harare
       * * `Africa/Johannesburg` - Africa/Johannesburg
       * * `Africa/Juba` - Africa/Juba
       * * `Africa/Kampala` - Africa/Kampala
       * * `Africa/Khartoum` - Africa/Khartoum
       * * `Africa/Kigali` - Africa/Kigali
       * * `Africa/Kinshasa` - Africa/Kinshasa
       * * `Africa/Lagos` - Africa/Lagos
       * * `Africa/Libreville` - Africa/Libreville
       * * `Africa/Lome` - Africa/Lome
       * * `Africa/Luanda` - Africa/Luanda
       * * `Africa/Lubumbashi` - Africa/Lubumbashi
       * * `Africa/Lusaka` - Africa/Lusaka
       * * `Africa/Malabo` - Africa/Malabo
       * * `Africa/Maputo` - Africa/Maputo
       * * `Africa/Maseru` - Africa/Maseru
       * * `Africa/Mbabane` - Africa/Mbabane
       * * `Africa/Mogadishu` - Africa/Mogadishu
       * * `Africa/Monrovia` - Africa/Monrovia
       * * `Africa/Nairobi` - Africa/Nairobi
       * * `Africa/Ndjamena` - Africa/Ndjamena
       * * `Africa/Niamey` - Africa/Niamey
       * * `Africa/Nouakchott` - Africa/Nouakchott
       * * `Africa/Ouagadougou` - Africa/Ouagadougou
       * * `Africa/Porto-Novo` - Africa/Porto-Novo
       * * `Africa/Sao_Tome` - Africa/Sao_Tome
       * * `Africa/Tripoli` - Africa/Tripoli
       * * `Africa/Tunis` - Africa/Tunis
       * * `Africa/Windhoek` - Africa/Windhoek
       * * `America/Adak` - America/Adak
       * * `America/Anchorage` - America/Anchorage
       * * `America/Anguilla` - America/Anguilla
       * * `America/Antigua` - America/Antigua
       * * `America/Araguaina` - America/Araguaina
       * * `America/Argentina/Buenos_Aires` - America/Argentina/Buenos_Aires
       * * `America/Argentina/Catamarca` - America/Argentina/Catamarca
       * * `America/Argentina/Cordoba` - America/Argentina/Cordoba
       * * `America/Argentina/Jujuy` - America/Argentina/Jujuy
       * * `America/Argentina/La_Rioja` - America/Argentina/La_Rioja
       * * `America/Argentina/Mendoza` - America/Argentina/Mendoza
       * * `America/Argentina/Rio_Gallegos` - America/Argentina/Rio_Gallegos
       * * `America/Argentina/Salta` - America/Argentina/Salta
       * * `America/Argentina/San_Juan` - America/Argentina/San_Juan
       * * `America/Argentina/San_Luis` - America/Argentina/San_Luis
       * * `America/Argentina/Tucuman` - America/Argentina/Tucuman
       * * `America/Argentina/Ushuaia` - America/Argentina/Ushuaia
       * * `America/Aruba` - America/Aruba
       * * `America/Asuncion` - America/Asuncion
       * * `America/Atikokan` - America/Atikokan
       * * `America/Bahia` - America/Bahia
       * * `America/Bahia_Banderas` - America/Bahia_Banderas
       * * `America/Barbados` - America/Barbados
       * * `America/Belem` - America/Belem
       * * `America/Belize` - America/Belize
       * * `America/Blanc-Sablon` - America/Blanc-Sablon
       * * `America/Boa_Vista` - America/Boa_Vista
       * * `America/Bogota` - America/Bogota
       * * `America/Boise` - America/Boise
       * * `America/Cambridge_Bay` - America/Cambridge_Bay
       * * `America/Campo_Grande` - America/Campo_Grande
       * * `America/Cancun` - America/Cancun
       * * `America/Caracas` - America/Caracas
       * * `America/Cayenne` - America/Cayenne
       * * `America/Cayman` - America/Cayman
       * * `America/Chicago` - America/Chicago
       * * `America/Chihuahua` - America/Chihuahua
       * * `America/Ciudad_Juarez` - America/Ciudad_Juarez
       * * `America/Costa_Rica` - America/Costa_Rica
       * * `America/Creston` - America/Creston
       * * `America/Cuiaba` - America/Cuiaba
       * * `America/Curacao` - America/Curacao
       * * `America/Danmarkshavn` - America/Danmarkshavn
       * * `America/Dawson` - America/Dawson
       * * `America/Dawson_Creek` - America/Dawson_Creek
       * * `America/Denver` - America/Denver
       * * `America/Detroit` - America/Detroit
       * * `America/Dominica` - America/Dominica
       * * `America/Edmonton` - America/Edmonton
       * * `America/Eirunepe` - America/Eirunepe
       * * `America/El_Salvador` - America/El_Salvador
       * * `America/Fort_Nelson` - America/Fort_Nelson
       * * `America/Fortaleza` - America/Fortaleza
       * * `America/Glace_Bay` - America/Glace_Bay
       * * `America/Goose_Bay` - America/Goose_Bay
       * * `America/Grand_Turk` - America/Grand_Turk
       * * `America/Grenada` - America/Grenada
       * * `America/Guadeloupe` - America/Guadeloupe
       * * `America/Guatemala` - America/Guatemala
       * * `America/Guayaquil` - America/Guayaquil
       * * `America/Guyana` - America/Guyana
       * * `America/Halifax` - America/Halifax
       * * `America/Havana` - America/Havana
       * * `America/Hermosillo` - America/Hermosillo
       * * `America/Indiana/Indianapolis` - America/Indiana/Indianapolis
       * * `America/Indiana/Knox` - America/Indiana/Knox
       * * `America/Indiana/Marengo` - America/Indiana/Marengo
       * * `America/Indiana/Petersburg` - America/Indiana/Petersburg
       * * `America/Indiana/Tell_City` - America/Indiana/Tell_City
       * * `America/Indiana/Vevay` - America/Indiana/Vevay
       * * `America/Indiana/Vincennes` - America/Indiana/Vincennes
       * * `America/Indiana/Winamac` - America/Indiana/Winamac
       * * `America/Inuvik` - America/Inuvik
       * * `America/Iqaluit` - America/Iqaluit
       * * `America/Jamaica` - America/Jamaica
       * * `America/Juneau` - America/Juneau
       * * `America/Kentucky/Louisville` - America/Kentucky/Louisville
       * * `America/Kentucky/Monticello` - America/Kentucky/Monticello
       * * `America/Kralendijk` - America/Kralendijk
       * * `America/La_Paz` - America/La_Paz
       * * `America/Lima` - America/Lima
       * * `America/Los_Angeles` - America/Los_Angeles
       * * `America/Lower_Princes` - America/Lower_Princes
       * * `America/Maceio` - America/Maceio
       * * `America/Managua` - America/Managua
       * * `America/Manaus` - America/Manaus
       * * `America/Marigot` - America/Marigot
       * * `America/Martinique` - America/Martinique
       * * `America/Matamoros` - America/Matamoros
       * * `America/Mazatlan` - America/Mazatlan
       * * `America/Menominee` - America/Menominee
       * * `America/Merida` - America/Merida
       * * `America/Metlakatla` - America/Metlakatla
       * * `America/Mexico_City` - America/Mexico_City
       * * `America/Miquelon` - America/Miquelon
       * * `America/Moncton` - America/Moncton
       * * `America/Monterrey` - America/Monterrey
       * * `America/Montevideo` - America/Montevideo
       * * `America/Montserrat` - America/Montserrat
       * * `America/Nassau` - America/Nassau
       * * `America/New_York` - America/New_York
       * * `America/Nome` - America/Nome
       * * `America/Noronha` - America/Noronha
       * * `America/North_Dakota/Beulah` - America/North_Dakota/Beulah
       * * `America/North_Dakota/Center` - America/North_Dakota/Center
       * * `America/North_Dakota/New_Salem` - America/North_Dakota/New_Salem
       * * `America/Nuuk` - America/Nuuk
       * * `America/Ojinaga` - America/Ojinaga
       * * `America/Panama` - America/Panama
       * * `America/Paramaribo` - America/Paramaribo
       * * `America/Phoenix` - America/Phoenix
       * * `America/Port-au-Prince` - America/Port-au-Prince
       * * `America/Port_of_Spain` - America/Port_of_Spain
       * * `America/Porto_Velho` - America/Porto_Velho
       * * `America/Puerto_Rico` - America/Puerto_Rico
       * * `America/Punta_Arenas` - America/Punta_Arenas
       * * `America/Rankin_Inlet` - America/Rankin_Inlet
       * * `America/Recife` - America/Recife
       * * `America/Regina` - America/Regina
       * * `America/Resolute` - America/Resolute
       * * `America/Rio_Branco` - America/Rio_Branco
       * * `America/Santarem` - America/Santarem
       * * `America/Santiago` - America/Santiago
       * * `America/Santo_Domingo` - America/Santo_Domingo
       * * `America/Sao_Paulo` - America/Sao_Paulo
       * * `America/Scoresbysund` - America/Scoresbysund
       * * `America/Sitka` - America/Sitka
       * * `America/St_Barthelemy` - America/St_Barthelemy
       * * `America/St_Johns` - America/St_Johns
       * * `America/St_Kitts` - America/St_Kitts
       * * `America/St_Lucia` - America/St_Lucia
       * * `America/St_Thomas` - America/St_Thomas
       * * `America/St_Vincent` - America/St_Vincent
       * * `America/Swift_Current` - America/Swift_Current
       * * `America/Tegucigalpa` - America/Tegucigalpa
       * * `America/Thule` - America/Thule
       * * `America/Tijuana` - America/Tijuana
       * * `America/Toronto` - America/Toronto
       * * `America/Tortola` - America/Tortola
       * * `America/Vancouver` - America/Vancouver
       * * `America/Whitehorse` - America/Whitehorse
       * * `America/Winnipeg` - America/Winnipeg
       * * `America/Yakutat` - America/Yakutat
       * * `America/Yellowknife` - America/Yellowknife
       * * `Antarctica/Casey` - Antarctica/Casey
       * * `Antarctica/Davis` - Antarctica/Davis
       * * `Antarctica/DumontDUrville` - Antarctica/DumontDUrville
       * * `Antarctica/Macquarie` - Antarctica/Macquarie
       * * `Antarctica/Mawson` - Antarctica/Mawson
       * * `Antarctica/McMurdo` - Antarctica/McMurdo
       * * `Antarctica/Palmer` - Antarctica/Palmer
       * * `Antarctica/Rothera` - Antarctica/Rothera
       * * `Antarctica/Syowa` - Antarctica/Syowa
       * * `Antarctica/Troll` - Antarctica/Troll
       * * `Antarctica/Vostok` - Antarctica/Vostok
       * * `Arctic/Longyearbyen` - Arctic/Longyearbyen
       * * `Asia/Aden` - Asia/Aden
       * * `Asia/Almaty` - Asia/Almaty
       * * `Asia/Amman` - Asia/Amman
       * * `Asia/Anadyr` - Asia/Anadyr
       * * `Asia/Aqtau` - Asia/Aqtau
       * * `Asia/Aqtobe` - Asia/Aqtobe
       * * `Asia/Ashgabat` - Asia/Ashgabat
       * * `Asia/Atyrau` - Asia/Atyrau
       * * `Asia/Baghdad` - Asia/Baghdad
       * * `Asia/Bahrain` - Asia/Bahrain
       * * `Asia/Baku` - Asia/Baku
       * * `Asia/Bangkok` - Asia/Bangkok
       * * `Asia/Barnaul` - Asia/Barnaul
       * * `Asia/Beirut` - Asia/Beirut
       * * `Asia/Bishkek` - Asia/Bishkek
       * * `Asia/Brunei` - Asia/Brunei
       * * `Asia/Chita` - Asia/Chita
       * * `Asia/Choibalsan` - Asia/Choibalsan
       * * `Asia/Colombo` - Asia/Colombo
       * * `Asia/Damascus` - Asia/Damascus
       * * `Asia/Dhaka` - Asia/Dhaka
       * * `Asia/Dili` - Asia/Dili
       * * `Asia/Dubai` - Asia/Dubai
       * * `Asia/Dushanbe` - Asia/Dushanbe
       * * `Asia/Famagusta` - Asia/Famagusta
       * * `Asia/Gaza` - Asia/Gaza
       * * `Asia/Hebron` - Asia/Hebron
       * * `Asia/Ho_Chi_Minh` - Asia/Ho_Chi_Minh
       * * `Asia/Hong_Kong` - Asia/Hong_Kong
       * * `Asia/Hovd` - Asia/Hovd
       * * `Asia/Irkutsk` - Asia/Irkutsk
       * * `Asia/Jakarta` - Asia/Jakarta
       * * `Asia/Jayapura` - Asia/Jayapura
       * * `Asia/Jerusalem` - Asia/Jerusalem
       * * `Asia/Kabul` - Asia/Kabul
       * * `Asia/Kamchatka` - Asia/Kamchatka
       * * `Asia/Karachi` - Asia/Karachi
       * * `Asia/Kathmandu` - Asia/Kathmandu
       * * `Asia/Khandyga` - Asia/Khandyga
       * * `Asia/Kolkata` - Asia/Kolkata
       * * `Asia/Krasnoyarsk` - Asia/Krasnoyarsk
       * * `Asia/Kuala_Lumpur` - Asia/Kuala_Lumpur
       * * `Asia/Kuching` - Asia/Kuching
       * * `Asia/Kuwait` - Asia/Kuwait
       * * `Asia/Macau` - Asia/Macau
       * * `Asia/Magadan` - Asia/Magadan
       * * `Asia/Makassar` - Asia/Makassar
       * * `Asia/Manila` - Asia/Manila
       * * `Asia/Muscat` - Asia/Muscat
       * * `Asia/Nicosia` - Asia/Nicosia
       * * `Asia/Novokuznetsk` - Asia/Novokuznetsk
       * * `Asia/Novosibirsk` - Asia/Novosibirsk
       * * `Asia/Omsk` - Asia/Omsk
       * * `Asia/Oral` - Asia/Oral
       * * `Asia/Phnom_Penh` - Asia/Phnom_Penh
       * * `Asia/Pontianak` - Asia/Pontianak
       * * `Asia/Pyongyang` - Asia/Pyongyang
       * * `Asia/Qatar` - Asia/Qatar
       * * `Asia/Qostanay` - Asia/Qostanay
       * * `Asia/Qyzylorda` - Asia/Qyzylorda
       * * `Asia/Riyadh` - Asia/Riyadh
       * * `Asia/Sakhalin` - Asia/Sakhalin
       * * `Asia/Samarkand` - Asia/Samarkand
       * * `Asia/Seoul` - Asia/Seoul
       * * `Asia/Shanghai` - Asia/Shanghai
       * * `Asia/Singapore` - Asia/Singapore
       * * `Asia/Srednekolymsk` - Asia/Srednekolymsk
       * * `Asia/Taipei` - Asia/Taipei
       * * `Asia/Tashkent` - Asia/Tashkent
       * * `Asia/Tbilisi` - Asia/Tbilisi
       * * `Asia/Tehran` - Asia/Tehran
       * * `Asia/Thimphu` - Asia/Thimphu
       * * `Asia/Tokyo` - Asia/Tokyo
       * * `Asia/Tomsk` - Asia/Tomsk
       * * `Asia/Ulaanbaatar` - Asia/Ulaanbaatar
       * * `Asia/Urumqi` - Asia/Urumqi
       * * `Asia/Ust-Nera` - Asia/Ust-Nera
       * * `Asia/Vientiane` - Asia/Vientiane
       * * `Asia/Vladivostok` - Asia/Vladivostok
       * * `Asia/Yakutsk` - Asia/Yakutsk
       * * `Asia/Yangon` - Asia/Yangon
       * * `Asia/Yekaterinburg` - Asia/Yekaterinburg
       * * `Asia/Yerevan` - Asia/Yerevan
       * * `Atlantic/Azores` - Atlantic/Azores
       * * `Atlantic/Bermuda` - Atlantic/Bermuda
       * * `Atlantic/Canary` - Atlantic/Canary
       * * `Atlantic/Cape_Verde` - Atlantic/Cape_Verde
       * * `Atlantic/Faroe` - Atlantic/Faroe
       * * `Atlantic/Madeira` - Atlantic/Madeira
       * * `Atlantic/Reykjavik` - Atlantic/Reykjavik
       * * `Atlantic/South_Georgia` - Atlantic/South_Georgia
       * * `Atlantic/St_Helena` - Atlantic/St_Helena
       * * `Atlantic/Stanley` - Atlantic/Stanley
       * * `Australia/Adelaide` - Australia/Adelaide
       * * `Australia/Brisbane` - Australia/Brisbane
       * * `Australia/Broken_Hill` - Australia/Broken_Hill
       * * `Australia/Darwin` - Australia/Darwin
       * * `Australia/Eucla` - Australia/Eucla
       * * `Australia/Hobart` - Australia/Hobart
       * * `Australia/Lindeman` - Australia/Lindeman
       * * `Australia/Lord_Howe` - Australia/Lord_Howe
       * * `Australia/Melbourne` - Australia/Melbourne
       * * `Australia/Perth` - Australia/Perth
       * * `Australia/Sydney` - Australia/Sydney
       * * `Canada/Atlantic` - Canada/Atlantic
       * * `Canada/Central` - Canada/Central
       * * `Canada/Eastern` - Canada/Eastern
       * * `Canada/Mountain` - Canada/Mountain
       * * `Canada/Newfoundland` - Canada/Newfoundland
       * * `Canada/Pacific` - Canada/Pacific
       * * `Europe/Amsterdam` - Europe/Amsterdam
       * * `Europe/Andorra` - Europe/Andorra
       * * `Europe/Astrakhan` - Europe/Astrakhan
       * * `Europe/Athens` - Europe/Athens
       * * `Europe/Belgrade` - Europe/Belgrade
       * * `Europe/Berlin` - Europe/Berlin
       * * `Europe/Bratislava` - Europe/Bratislava
       * * `Europe/Brussels` - Europe/Brussels
       * * `Europe/Bucharest` - Europe/Bucharest
       * * `Europe/Budapest` - Europe/Budapest
       * * `Europe/Busingen` - Europe/Busingen
       * * `Europe/Chisinau` - Europe/Chisinau
       * * `Europe/Copenhagen` - Europe/Copenhagen
       * * `Europe/Dublin` - Europe/Dublin
       * * `Europe/Gibraltar` - Europe/Gibraltar
       * * `Europe/Guernsey` - Europe/Guernsey
       * * `Europe/Helsinki` - Europe/Helsinki
       * * `Europe/Isle_of_Man` - Europe/Isle_of_Man
       * * `Europe/Istanbul` - Europe/Istanbul
       * * `Europe/Jersey` - Europe/Jersey
       * * `Europe/Kaliningrad` - Europe/Kaliningrad
       * * `Europe/Kirov` - Europe/Kirov
       * * `Europe/Kyiv` - Europe/Kyiv
       * * `Europe/Lisbon` - Europe/Lisbon
       * * `Europe/Ljubljana` - Europe/Ljubljana
       * * `Europe/London` - Europe/London
       * * `Europe/Luxembourg` - Europe/Luxembourg
       * * `Europe/Madrid` - Europe/Madrid
       * * `Europe/Malta` - Europe/Malta
       * * `Europe/Mariehamn` - Europe/Mariehamn
       * * `Europe/Minsk` - Europe/Minsk
       * * `Europe/Monaco` - Europe/Monaco
       * * `Europe/Moscow` - Europe/Moscow
       * * `Europe/Oslo` - Europe/Oslo
       * * `Europe/Paris` - Europe/Paris
       * * `Europe/Podgorica` - Europe/Podgorica
       * * `Europe/Prague` - Europe/Prague
       * * `Europe/Riga` - Europe/Riga
       * * `Europe/Rome` - Europe/Rome
       * * `Europe/Samara` - Europe/Samara
       * * `Europe/San_Marino` - Europe/San_Marino
       * * `Europe/Sarajevo` - Europe/Sarajevo
       * * `Europe/Saratov` - Europe/Saratov
       * * `Europe/Simferopol` - Europe/Simferopol
       * * `Europe/Skopje` - Europe/Skopje
       * * `Europe/Sofia` - Europe/Sofia
       * * `Europe/Stockholm` - Europe/Stockholm
       * * `Europe/Tallinn` - Europe/Tallinn
       * * `Europe/Tirane` - Europe/Tirane
       * * `Europe/Ulyanovsk` - Europe/Ulyanovsk
       * * `Europe/Vaduz` - Europe/Vaduz
       * * `Europe/Vatican` - Europe/Vatican
       * * `Europe/Vienna` - Europe/Vienna
       * * `Europe/Vilnius` - Europe/Vilnius
       * * `Europe/Volgograd` - Europe/Volgograd
       * * `Europe/Warsaw` - Europe/Warsaw
       * * `Europe/Zagreb` - Europe/Zagreb
       * * `Europe/Zurich` - Europe/Zurich
       * * `GMT` - GMT
       * * `Indian/Antananarivo` - Indian/Antananarivo
       * * `Indian/Chagos` - Indian/Chagos
       * * `Indian/Christmas` - Indian/Christmas
       * * `Indian/Cocos` - Indian/Cocos
       * * `Indian/Comoro` - Indian/Comoro
       * * `Indian/Kerguelen` - Indian/Kerguelen
       * * `Indian/Mahe` - Indian/Mahe
       * * `Indian/Maldives` - Indian/Maldives
       * * `Indian/Mauritius` - Indian/Mauritius
       * * `Indian/Mayotte` - Indian/Mayotte
       * * `Indian/Reunion` - Indian/Reunion
       * * `Pacific/Apia` - Pacific/Apia
       * * `Pacific/Auckland` - Pacific/Auckland
       * * `Pacific/Bougainville` - Pacific/Bougainville
       * * `Pacific/Chatham` - Pacific/Chatham
       * * `Pacific/Chuuk` - Pacific/Chuuk
       * * `Pacific/Easter` - Pacific/Easter
       * * `Pacific/Efate` - Pacific/Efate
       * * `Pacific/Fakaofo` - Pacific/Fakaofo
       * * `Pacific/Fiji` - Pacific/Fiji
       * * `Pacific/Funafuti` - Pacific/Funafuti
       * * `Pacific/Galapagos` - Pacific/Galapagos
       * * `Pacific/Gambier` - Pacific/Gambier
       * * `Pacific/Guadalcanal` - Pacific/Guadalcanal
       * * `Pacific/Guam` - Pacific/Guam
       * * `Pacific/Honolulu` - Pacific/Honolulu
       * * `Pacific/Kanton` - Pacific/Kanton
       * * `Pacific/Kiritimati` - Pacific/Kiritimati
       * * `Pacific/Kosrae` - Pacific/Kosrae
       * * `Pacific/Kwajalein` - Pacific/Kwajalein
       * * `Pacific/Majuro` - Pacific/Majuro
       * * `Pacific/Marquesas` - Pacific/Marquesas
       * * `Pacific/Midway` - Pacific/Midway
       * * `Pacific/Nauru` - Pacific/Nauru
       * * `Pacific/Niue` - Pacific/Niue
       * * `Pacific/Norfolk` - Pacific/Norfolk
       * * `Pacific/Noumea` - Pacific/Noumea
       * * `Pacific/Pago_Pago` - Pacific/Pago_Pago
       * * `Pacific/Palau` - Pacific/Palau
       * * `Pacific/Pitcairn` - Pacific/Pitcairn
       * * `Pacific/Pohnpei` - Pacific/Pohnpei
       * * `Pacific/Port_Moresby` - Pacific/Port_Moresby
       * * `Pacific/Rarotonga` - Pacific/Rarotonga
       * * `Pacific/Saipan` - Pacific/Saipan
       * * `Pacific/Tahiti` - Pacific/Tahiti
       * * `Pacific/Tarawa` - Pacific/Tarawa
       * * `Pacific/Tongatapu` - Pacific/Tongatapu
       * * `Pacific/Wake` - Pacific/Wake
       * * `Pacific/Wallis` - Pacific/Wallis
       * * `US/Alaska` - US/Alaska
       * * `US/Arizona` - US/Arizona
       * * `US/Central` - US/Central
       * * `US/Eastern` - US/Eastern
       * * `US/Hawaii` - US/Hawaii
       * * `US/Mountain` - US/Mountain
       * * `US/Pacific` - US/Pacific
       * * `UTC` - UTC 
       * @enum {string}
       */
      timezone: "Africa/Abidjan" | "Africa/Accra" | "Africa/Addis_Ababa" | "Africa/Algiers" | "Africa/Asmara" | "Africa/Bamako" | "Africa/Bangui" | "Africa/Banjul" | "Africa/Bissau" | "Africa/Blantyre" | "Africa/Brazzaville" | "Africa/Bujumbura" | "Africa/Cairo" | "Africa/Casablanca" | "Africa/Ceuta" | "Africa/Conakry" | "Africa/Dakar" | "Africa/Dar_es_Salaam" | "Africa/Djibouti" | "Africa/Douala" | "Africa/El_Aaiun" | "Africa/Freetown" | "Africa/Gaborone" | "Africa/Harare" | "Africa/Johannesburg" | "Africa/Juba" | "Africa/Kampala" | "Africa/Khartoum" | "Africa/Kigali" | "Africa/Kinshasa" | "Africa/Lagos" | "Africa/Libreville" | "Africa/Lome" | "Africa/Luanda" | "Africa/Lubumbashi" | "Africa/Lusaka" | "Africa/Malabo" | "Africa/Maputo" | "Africa/Maseru" | "Africa/Mbabane" | "Africa/Mogadishu" | "Africa/Monrovia" | "Africa/Nairobi" | "Africa/Ndjamena" | "Africa/Niamey" | "Africa/Nouakchott" | "Africa/Ouagadougou" | "Africa/Porto-Novo" | "Africa/Sao_Tome" | "Africa/Tripoli" | "Africa/Tunis" | "Africa/Windhoek" | "America/Adak" | "America/Anchorage" | "America/Anguilla" | "America/Antigua" | "America/Araguaina" | "America/Argentina/Buenos_Aires" | "America/Argentina/Catamarca" | "America/Argentina/Cordoba" | "America/Argentina/Jujuy" | "America/Argentina/La_Rioja" | "America/Argentina/Mendoza" | "America/Argentina/Rio_Gallegos" | "America/Argentina/Salta" | "America/Argentina/San_Juan" | "America/Argentina/San_Luis" | "America/Argentina/Tucuman" | "America/Argentina/Ushuaia" | "America/Aruba" | "America/Asuncion" | "America/Atikokan" | "America/Bahia" | "America/Bahia_Banderas" | "America/Barbados" | "America/Belem" | "America/Belize" | "America/Blanc-Sablon" | "America/Boa_Vista" | "America/Bogota" | "America/Boise" | "America/Cambridge_Bay" | "America/Campo_Grande" | "America/Cancun" | "America/Caracas" | "America/Cayenne" | "America/Cayman" | "America/Chicago" | "America/Chihuahua" | "America/Ciudad_Juarez" | "America/Costa_Rica" | "America/Creston" | "America/Cuiaba" | "America/Curacao" | "America/Danmarkshavn" | "America/Dawson" | "America/Dawson_Creek" | "America/Denver" | "America/Detroit" | "America/Dominica" | "America/Edmonton" | "America/Eirunepe" | "America/El_Salvador" | "America/Fort_Nelson" | "America/Fortaleza" | "America/Glace_Bay" | "America/Goose_Bay" | "America/Grand_Turk" | "America/Grenada" | "America/Guadeloupe" | "America/Guatemala" | "America/Guayaquil" | "America/Guyana" | "America/Halifax" | "America/Havana" | "America/Hermosillo" | "America/Indiana/Indianapolis" | "America/Indiana/Knox" | "America/Indiana/Marengo" | "America/Indiana/Petersburg" | "America/Indiana/Tell_City" | "America/Indiana/Vevay" | "America/Indiana/Vincennes" | "America/Indiana/Winamac" | "America/Inuvik" | "America/Iqaluit" | "America/Jamaica" | "America/Juneau" | "America/Kentucky/Louisville" | "America/Kentucky/Monticello" | "America/Kralendijk" | "America/La_Paz" | "America/Lima" | "America/Los_Angeles" | "America/Lower_Princes" | "America/Maceio" | "America/Managua" | "America/Manaus" | "America/Marigot" | "America/Martinique" | "America/Matamoros" | "America/Mazatlan" | "America/Menominee" | "America/Merida" | "America/Metlakatla" | "America/Mexico_City" | "America/Miquelon" | "America/Moncton" | "America/Monterrey" | "America/Montevideo" | "America/Montserrat" | "America/Nassau" | "America/New_York" | "America/Nome" | "America/Noronha" | "America/North_Dakota/Beulah" | "America/North_Dakota/Center" | "America/North_Dakota/New_Salem" | "America/Nuuk" | "America/Ojinaga" | "America/Panama" | "America/Paramaribo" | "America/Phoenix" | "America/Port-au-Prince" | "America/Port_of_Spain" | "America/Porto_Velho" | "America/Puerto_Rico" | "America/Punta_Arenas" | "America/Rankin_Inlet" | "America/Recife" | "America/Regina" | "America/Resolute" | "America/Rio_Branco" | "America/Santarem" | "America/Santiago" | "America/Santo_Domingo" | "America/Sao_Paulo" | "America/Scoresbysund" | "America/Sitka" | "America/St_Barthelemy" | "America/St_Johns" | "America/St_Kitts" | "America/St_Lucia" | "America/St_Thomas" | "America/St_Vincent" | "America/Swift_Current" | "America/Tegucigalpa" | "America/Thule" | "America/Tijuana" | "America/Toronto" | "America/Tortola" | "America/Vancouver" | "America/Whitehorse" | "America/Winnipeg" | "America/Yakutat" | "America/Yellowknife" | "Antarctica/Casey" | "Antarctica/Davis" | "Antarctica/DumontDUrville" | "Antarctica/Macquarie" | "Antarctica/Mawson" | "Antarctica/McMurdo" | "Antarctica/Palmer" | "Antarctica/Rothera" | "Antarctica/Syowa" | "Antarctica/Troll" | "Antarctica/Vostok" | "Arctic/Longyearbyen" | "Asia/Aden" | "Asia/Almaty" | "Asia/Amman" | "Asia/Anadyr" | "Asia/Aqtau" | "Asia/Aqtobe" | "Asia/Ashgabat" | "Asia/Atyrau" | "Asia/Baghdad" | "Asia/Bahrain" | "Asia/Baku" | "Asia/Bangkok" | "Asia/Barnaul" | "Asia/Beirut" | "Asia/Bishkek" | "Asia/Brunei" | "Asia/Chita" | "Asia/Choibalsan" | "Asia/Colombo" | "Asia/Damascus" | "Asia/Dhaka" | "Asia/Dili" | "Asia/Dubai" | "Asia/Dushanbe" | "Asia/Famagusta" | "Asia/Gaza" | "Asia/Hebron" | "Asia/Ho_Chi_Minh" | "Asia/Hong_Kong" | "Asia/Hovd" | "Asia/Irkutsk" | "Asia/Jakarta" | "Asia/Jayapura" | "Asia/Jerusalem" | "Asia/Kabul" | "Asia/Kamchatka" | "Asia/Karachi" | "Asia/Kathmandu" | "Asia/Khandyga" | "Asia/Kolkata" | "Asia/Krasnoyarsk" | "Asia/Kuala_Lumpur" | "Asia/Kuching" | "Asia/Kuwait" | "Asia/Macau" | "Asia/Magadan" | "Asia/Makassar" | "Asia/Manila" | "Asia/Muscat" | "Asia/Nicosia" | "Asia/Novokuznetsk" | "Asia/Novosibirsk" | "Asia/Omsk" | "Asia/Oral" | "Asia/Phnom_Penh" | "Asia/Pontianak" | "Asia/Pyongyang" | "Asia/Qatar" | "Asia/Qostanay" | "Asia/Qyzylorda" | "Asia/Riyadh" | "Asia/Sakhalin" | "Asia/Samarkand" | "Asia/Seoul" | "Asia/Shanghai" | "Asia/Singapore" | "Asia/Srednekolymsk" | "Asia/Taipei" | "Asia/Tashkent" | "Asia/Tbilisi" | "Asia/Tehran" | "Asia/Thimphu" | "Asia/Tokyo" | "Asia/Tomsk" | "Asia/Ulaanbaatar" | "Asia/Urumqi" | "Asia/Ust-Nera" | "Asia/Vientiane" | "Asia/Vladivostok" | "Asia/Yakutsk" | "Asia/Yangon" | "Asia/Yekaterinburg" | "Asia/Yerevan" | "Atlantic/Azores" | "Atlantic/Bermuda" | "Atlantic/Canary" | "Atlantic/Cape_Verde" | "Atlantic/Faroe" | "Atlantic/Madeira" | "Atlantic/Reykjavik" | "Atlantic/South_Georgia" | "Atlantic/St_Helena" | "Atlantic/Stanley" | "Australia/Adelaide" | "Australia/Brisbane" | "Australia/Broken_Hill" | "Australia/Darwin" | "Australia/Eucla" | "Australia/Hobart" | "Australia/Lindeman" | "Australia/Lord_Howe" | "Australia/Melbourne" | "Australia/Perth" | "Australia/Sydney" | "Canada/Atlantic" | "Canada/Central" | "Canada/Eastern" | "Canada/Mountain" | "Canada/Newfoundland" | "Canada/Pacific" | "Europe/Amsterdam" | "Europe/Andorra" | "Europe/Astrakhan" | "Europe/Athens" | "Europe/Belgrade" | "Europe/Berlin" | "Europe/Bratislava" | "Europe/Brussels" | "Europe/Bucharest" | "Europe/Budapest" | "Europe/Busingen" | "Europe/Chisinau" | "Europe/Copenhagen" | "Europe/Dublin" | "Europe/Gibraltar" | "Europe/Guernsey" | "Europe/Helsinki" | "Europe/Isle_of_Man" | "Europe/Istanbul" | "Europe/Jersey" | "Europe/Kaliningrad" | "Europe/Kirov" | "Europe/Kyiv" | "Europe/Lisbon" | "Europe/Ljubljana" | "Europe/London" | "Europe/Luxembourg" | "Europe/Madrid" | "Europe/Malta" | "Europe/Mariehamn" | "Europe/Minsk" | "Europe/Monaco" | "Europe/Moscow" | "Europe/Oslo" | "Europe/Paris" | "Europe/Podgorica" | "Europe/Prague" | "Europe/Riga" | "Europe/Rome" | "Europe/Samara" | "Europe/San_Marino" | "Europe/Sarajevo" | "Europe/Saratov" | "Europe/Simferopol" | "Europe/Skopje" | "Europe/Sofia" | "Europe/Stockholm" | "Europe/Tallinn" | "Europe/Tirane" | "Europe/Ulyanovsk" | "Europe/Vaduz" | "Europe/Vatican" | "Europe/Vienna" | "Europe/Vilnius" | "Europe/Volgograd" | "Europe/Warsaw" | "Europe/Zagreb" | "Europe/Zurich" | "GMT" | "Indian/Antananarivo" | "Indian/Chagos" | "Indian/Christmas" | "Indian/Cocos" | "Indian/Comoro" | "Indian/Kerguelen" | "Indian/Mahe" | "Indian/Maldives" | "Indian/Mauritius" | "Indian/Mayotte" | "Indian/Reunion" | "Pacific/Apia" | "Pacific/Auckland" | "Pacific/Bougainville" | "Pacific/Chatham" | "Pacific/Chuuk" | "Pacific/Easter" | "Pacific/Efate" | "Pacific/Fakaofo" | "Pacific/Fiji" | "Pacific/Funafuti" | "Pacific/Galapagos" | "Pacific/Gambier" | "Pacific/Guadalcanal" | "Pacific/Guam" | "Pacific/Honolulu" | "Pacific/Kanton" | "Pacific/Kiritimati" | "Pacific/Kosrae" | "Pacific/Kwajalein" | "Pacific/Majuro" | "Pacific/Marquesas" | "Pacific/Midway" | "Pacific/Nauru" | "Pacific/Niue" | "Pacific/Norfolk" | "Pacific/Noumea" | "Pacific/Pago_Pago" | "Pacific/Palau" | "Pacific/Pitcairn" | "Pacific/Pohnpei" | "Pacific/Port_Moresby" | "Pacific/Rarotonga" | "Pacific/Saipan" | "Pacific/Tahiti" | "Pacific/Tarawa" | "Pacific/Tongatapu" | "Pacific/Wake" | "Pacific/Wallis" | "US/Alaska" | "US/Arizona" | "US/Central" | "US/Eastern" | "US/Hawaii" | "US/Mountain" | "US/Pacific" | "UTC";
      /** Format: email */
      email: string | null;
      payment_provider_id: string | null;
      /** Format: uri */
      crm_provider_url: string | null;
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      payment_provider: "stripe" | "braintree" | "" | null;
    };
    CustomerIntegrations: {
      stripe?: components["schemas"]["CustomerStripeIntegration"] | null;
      braintree?: components["schemas"]["CustomerBraintreeIntegration"] | null;
    };
    CustomerRequest: {
      customer_id: string;
      /** Format: email */
      email: string | null;
      default_currency: components["schemas"]["PricingUnitRequest"];
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      payment_provider: "stripe" | "braintree" | "" | null;
      /**
       * @description * `Africa/Abidjan` - Africa/Abidjan
       * * `Africa/Accra` - Africa/Accra
       * * `Africa/Addis_Ababa` - Africa/Addis_Ababa
       * * `Africa/Algiers` - Africa/Algiers
       * * `Africa/Asmara` - Africa/Asmara
       * * `Africa/Bamako` - Africa/Bamako
       * * `Africa/Bangui` - Africa/Bangui
       * * `Africa/Banjul` - Africa/Banjul
       * * `Africa/Bissau` - Africa/Bissau
       * * `Africa/Blantyre` - Africa/Blantyre
       * * `Africa/Brazzaville` - Africa/Brazzaville
       * * `Africa/Bujumbura` - Africa/Bujumbura
       * * `Africa/Cairo` - Africa/Cairo
       * * `Africa/Casablanca` - Africa/Casablanca
       * * `Africa/Ceuta` - Africa/Ceuta
       * * `Africa/Conakry` - Africa/Conakry
       * * `Africa/Dakar` - Africa/Dakar
       * * `Africa/Dar_es_Salaam` - Africa/Dar_es_Salaam
       * * `Africa/Djibouti` - Africa/Djibouti
       * * `Africa/Douala` - Africa/Douala
       * * `Africa/El_Aaiun` - Africa/El_Aaiun
       * * `Africa/Freetown` - Africa/Freetown
       * * `Africa/Gaborone` - Africa/Gaborone
       * * `Africa/Harare` - Africa/Harare
       * * `Africa/Johannesburg` - Africa/Johannesburg
       * * `Africa/Juba` - Africa/Juba
       * * `Africa/Kampala` - Africa/Kampala
       * * `Africa/Khartoum` - Africa/Khartoum
       * * `Africa/Kigali` - Africa/Kigali
       * * `Africa/Kinshasa` - Africa/Kinshasa
       * * `Africa/Lagos` - Africa/Lagos
       * * `Africa/Libreville` - Africa/Libreville
       * * `Africa/Lome` - Africa/Lome
       * * `Africa/Luanda` - Africa/Luanda
       * * `Africa/Lubumbashi` - Africa/Lubumbashi
       * * `Africa/Lusaka` - Africa/Lusaka
       * * `Africa/Malabo` - Africa/Malabo
       * * `Africa/Maputo` - Africa/Maputo
       * * `Africa/Maseru` - Africa/Maseru
       * * `Africa/Mbabane` - Africa/Mbabane
       * * `Africa/Mogadishu` - Africa/Mogadishu
       * * `Africa/Monrovia` - Africa/Monrovia
       * * `Africa/Nairobi` - Africa/Nairobi
       * * `Africa/Ndjamena` - Africa/Ndjamena
       * * `Africa/Niamey` - Africa/Niamey
       * * `Africa/Nouakchott` - Africa/Nouakchott
       * * `Africa/Ouagadougou` - Africa/Ouagadougou
       * * `Africa/Porto-Novo` - Africa/Porto-Novo
       * * `Africa/Sao_Tome` - Africa/Sao_Tome
       * * `Africa/Tripoli` - Africa/Tripoli
       * * `Africa/Tunis` - Africa/Tunis
       * * `Africa/Windhoek` - Africa/Windhoek
       * * `America/Adak` - America/Adak
       * * `America/Anchorage` - America/Anchorage
       * * `America/Anguilla` - America/Anguilla
       * * `America/Antigua` - America/Antigua
       * * `America/Araguaina` - America/Araguaina
       * * `America/Argentina/Buenos_Aires` - America/Argentina/Buenos_Aires
       * * `America/Argentina/Catamarca` - America/Argentina/Catamarca
       * * `America/Argentina/Cordoba` - America/Argentina/Cordoba
       * * `America/Argentina/Jujuy` - America/Argentina/Jujuy
       * * `America/Argentina/La_Rioja` - America/Argentina/La_Rioja
       * * `America/Argentina/Mendoza` - America/Argentina/Mendoza
       * * `America/Argentina/Rio_Gallegos` - America/Argentina/Rio_Gallegos
       * * `America/Argentina/Salta` - America/Argentina/Salta
       * * `America/Argentina/San_Juan` - America/Argentina/San_Juan
       * * `America/Argentina/San_Luis` - America/Argentina/San_Luis
       * * `America/Argentina/Tucuman` - America/Argentina/Tucuman
       * * `America/Argentina/Ushuaia` - America/Argentina/Ushuaia
       * * `America/Aruba` - America/Aruba
       * * `America/Asuncion` - America/Asuncion
       * * `America/Atikokan` - America/Atikokan
       * * `America/Bahia` - America/Bahia
       * * `America/Bahia_Banderas` - America/Bahia_Banderas
       * * `America/Barbados` - America/Barbados
       * * `America/Belem` - America/Belem
       * * `America/Belize` - America/Belize
       * * `America/Blanc-Sablon` - America/Blanc-Sablon
       * * `America/Boa_Vista` - America/Boa_Vista
       * * `America/Bogota` - America/Bogota
       * * `America/Boise` - America/Boise
       * * `America/Cambridge_Bay` - America/Cambridge_Bay
       * * `America/Campo_Grande` - America/Campo_Grande
       * * `America/Cancun` - America/Cancun
       * * `America/Caracas` - America/Caracas
       * * `America/Cayenne` - America/Cayenne
       * * `America/Cayman` - America/Cayman
       * * `America/Chicago` - America/Chicago
       * * `America/Chihuahua` - America/Chihuahua
       * * `America/Ciudad_Juarez` - America/Ciudad_Juarez
       * * `America/Costa_Rica` - America/Costa_Rica
       * * `America/Creston` - America/Creston
       * * `America/Cuiaba` - America/Cuiaba
       * * `America/Curacao` - America/Curacao
       * * `America/Danmarkshavn` - America/Danmarkshavn
       * * `America/Dawson` - America/Dawson
       * * `America/Dawson_Creek` - America/Dawson_Creek
       * * `America/Denver` - America/Denver
       * * `America/Detroit` - America/Detroit
       * * `America/Dominica` - America/Dominica
       * * `America/Edmonton` - America/Edmonton
       * * `America/Eirunepe` - America/Eirunepe
       * * `America/El_Salvador` - America/El_Salvador
       * * `America/Fort_Nelson` - America/Fort_Nelson
       * * `America/Fortaleza` - America/Fortaleza
       * * `America/Glace_Bay` - America/Glace_Bay
       * * `America/Goose_Bay` - America/Goose_Bay
       * * `America/Grand_Turk` - America/Grand_Turk
       * * `America/Grenada` - America/Grenada
       * * `America/Guadeloupe` - America/Guadeloupe
       * * `America/Guatemala` - America/Guatemala
       * * `America/Guayaquil` - America/Guayaquil
       * * `America/Guyana` - America/Guyana
       * * `America/Halifax` - America/Halifax
       * * `America/Havana` - America/Havana
       * * `America/Hermosillo` - America/Hermosillo
       * * `America/Indiana/Indianapolis` - America/Indiana/Indianapolis
       * * `America/Indiana/Knox` - America/Indiana/Knox
       * * `America/Indiana/Marengo` - America/Indiana/Marengo
       * * `America/Indiana/Petersburg` - America/Indiana/Petersburg
       * * `America/Indiana/Tell_City` - America/Indiana/Tell_City
       * * `America/Indiana/Vevay` - America/Indiana/Vevay
       * * `America/Indiana/Vincennes` - America/Indiana/Vincennes
       * * `America/Indiana/Winamac` - America/Indiana/Winamac
       * * `America/Inuvik` - America/Inuvik
       * * `America/Iqaluit` - America/Iqaluit
       * * `America/Jamaica` - America/Jamaica
       * * `America/Juneau` - America/Juneau
       * * `America/Kentucky/Louisville` - America/Kentucky/Louisville
       * * `America/Kentucky/Monticello` - America/Kentucky/Monticello
       * * `America/Kralendijk` - America/Kralendijk
       * * `America/La_Paz` - America/La_Paz
       * * `America/Lima` - America/Lima
       * * `America/Los_Angeles` - America/Los_Angeles
       * * `America/Lower_Princes` - America/Lower_Princes
       * * `America/Maceio` - America/Maceio
       * * `America/Managua` - America/Managua
       * * `America/Manaus` - America/Manaus
       * * `America/Marigot` - America/Marigot
       * * `America/Martinique` - America/Martinique
       * * `America/Matamoros` - America/Matamoros
       * * `America/Mazatlan` - America/Mazatlan
       * * `America/Menominee` - America/Menominee
       * * `America/Merida` - America/Merida
       * * `America/Metlakatla` - America/Metlakatla
       * * `America/Mexico_City` - America/Mexico_City
       * * `America/Miquelon` - America/Miquelon
       * * `America/Moncton` - America/Moncton
       * * `America/Monterrey` - America/Monterrey
       * * `America/Montevideo` - America/Montevideo
       * * `America/Montserrat` - America/Montserrat
       * * `America/Nassau` - America/Nassau
       * * `America/New_York` - America/New_York
       * * `America/Nome` - America/Nome
       * * `America/Noronha` - America/Noronha
       * * `America/North_Dakota/Beulah` - America/North_Dakota/Beulah
       * * `America/North_Dakota/Center` - America/North_Dakota/Center
       * * `America/North_Dakota/New_Salem` - America/North_Dakota/New_Salem
       * * `America/Nuuk` - America/Nuuk
       * * `America/Ojinaga` - America/Ojinaga
       * * `America/Panama` - America/Panama
       * * `America/Paramaribo` - America/Paramaribo
       * * `America/Phoenix` - America/Phoenix
       * * `America/Port-au-Prince` - America/Port-au-Prince
       * * `America/Port_of_Spain` - America/Port_of_Spain
       * * `America/Porto_Velho` - America/Porto_Velho
       * * `America/Puerto_Rico` - America/Puerto_Rico
       * * `America/Punta_Arenas` - America/Punta_Arenas
       * * `America/Rankin_Inlet` - America/Rankin_Inlet
       * * `America/Recife` - America/Recife
       * * `America/Regina` - America/Regina
       * * `America/Resolute` - America/Resolute
       * * `America/Rio_Branco` - America/Rio_Branco
       * * `America/Santarem` - America/Santarem
       * * `America/Santiago` - America/Santiago
       * * `America/Santo_Domingo` - America/Santo_Domingo
       * * `America/Sao_Paulo` - America/Sao_Paulo
       * * `America/Scoresbysund` - America/Scoresbysund
       * * `America/Sitka` - America/Sitka
       * * `America/St_Barthelemy` - America/St_Barthelemy
       * * `America/St_Johns` - America/St_Johns
       * * `America/St_Kitts` - America/St_Kitts
       * * `America/St_Lucia` - America/St_Lucia
       * * `America/St_Thomas` - America/St_Thomas
       * * `America/St_Vincent` - America/St_Vincent
       * * `America/Swift_Current` - America/Swift_Current
       * * `America/Tegucigalpa` - America/Tegucigalpa
       * * `America/Thule` - America/Thule
       * * `America/Tijuana` - America/Tijuana
       * * `America/Toronto` - America/Toronto
       * * `America/Tortola` - America/Tortola
       * * `America/Vancouver` - America/Vancouver
       * * `America/Whitehorse` - America/Whitehorse
       * * `America/Winnipeg` - America/Winnipeg
       * * `America/Yakutat` - America/Yakutat
       * * `America/Yellowknife` - America/Yellowknife
       * * `Antarctica/Casey` - Antarctica/Casey
       * * `Antarctica/Davis` - Antarctica/Davis
       * * `Antarctica/DumontDUrville` - Antarctica/DumontDUrville
       * * `Antarctica/Macquarie` - Antarctica/Macquarie
       * * `Antarctica/Mawson` - Antarctica/Mawson
       * * `Antarctica/McMurdo` - Antarctica/McMurdo
       * * `Antarctica/Palmer` - Antarctica/Palmer
       * * `Antarctica/Rothera` - Antarctica/Rothera
       * * `Antarctica/Syowa` - Antarctica/Syowa
       * * `Antarctica/Troll` - Antarctica/Troll
       * * `Antarctica/Vostok` - Antarctica/Vostok
       * * `Arctic/Longyearbyen` - Arctic/Longyearbyen
       * * `Asia/Aden` - Asia/Aden
       * * `Asia/Almaty` - Asia/Almaty
       * * `Asia/Amman` - Asia/Amman
       * * `Asia/Anadyr` - Asia/Anadyr
       * * `Asia/Aqtau` - Asia/Aqtau
       * * `Asia/Aqtobe` - Asia/Aqtobe
       * * `Asia/Ashgabat` - Asia/Ashgabat
       * * `Asia/Atyrau` - Asia/Atyrau
       * * `Asia/Baghdad` - Asia/Baghdad
       * * `Asia/Bahrain` - Asia/Bahrain
       * * `Asia/Baku` - Asia/Baku
       * * `Asia/Bangkok` - Asia/Bangkok
       * * `Asia/Barnaul` - Asia/Barnaul
       * * `Asia/Beirut` - Asia/Beirut
       * * `Asia/Bishkek` - Asia/Bishkek
       * * `Asia/Brunei` - Asia/Brunei
       * * `Asia/Chita` - Asia/Chita
       * * `Asia/Choibalsan` - Asia/Choibalsan
       * * `Asia/Colombo` - Asia/Colombo
       * * `Asia/Damascus` - Asia/Damascus
       * * `Asia/Dhaka` - Asia/Dhaka
       * * `Asia/Dili` - Asia/Dili
       * * `Asia/Dubai` - Asia/Dubai
       * * `Asia/Dushanbe` - Asia/Dushanbe
       * * `Asia/Famagusta` - Asia/Famagusta
       * * `Asia/Gaza` - Asia/Gaza
       * * `Asia/Hebron` - Asia/Hebron
       * * `Asia/Ho_Chi_Minh` - Asia/Ho_Chi_Minh
       * * `Asia/Hong_Kong` - Asia/Hong_Kong
       * * `Asia/Hovd` - Asia/Hovd
       * * `Asia/Irkutsk` - Asia/Irkutsk
       * * `Asia/Jakarta` - Asia/Jakarta
       * * `Asia/Jayapura` - Asia/Jayapura
       * * `Asia/Jerusalem` - Asia/Jerusalem
       * * `Asia/Kabul` - Asia/Kabul
       * * `Asia/Kamchatka` - Asia/Kamchatka
       * * `Asia/Karachi` - Asia/Karachi
       * * `Asia/Kathmandu` - Asia/Kathmandu
       * * `Asia/Khandyga` - Asia/Khandyga
       * * `Asia/Kolkata` - Asia/Kolkata
       * * `Asia/Krasnoyarsk` - Asia/Krasnoyarsk
       * * `Asia/Kuala_Lumpur` - Asia/Kuala_Lumpur
       * * `Asia/Kuching` - Asia/Kuching
       * * `Asia/Kuwait` - Asia/Kuwait
       * * `Asia/Macau` - Asia/Macau
       * * `Asia/Magadan` - Asia/Magadan
       * * `Asia/Makassar` - Asia/Makassar
       * * `Asia/Manila` - Asia/Manila
       * * `Asia/Muscat` - Asia/Muscat
       * * `Asia/Nicosia` - Asia/Nicosia
       * * `Asia/Novokuznetsk` - Asia/Novokuznetsk
       * * `Asia/Novosibirsk` - Asia/Novosibirsk
       * * `Asia/Omsk` - Asia/Omsk
       * * `Asia/Oral` - Asia/Oral
       * * `Asia/Phnom_Penh` - Asia/Phnom_Penh
       * * `Asia/Pontianak` - Asia/Pontianak
       * * `Asia/Pyongyang` - Asia/Pyongyang
       * * `Asia/Qatar` - Asia/Qatar
       * * `Asia/Qostanay` - Asia/Qostanay
       * * `Asia/Qyzylorda` - Asia/Qyzylorda
       * * `Asia/Riyadh` - Asia/Riyadh
       * * `Asia/Sakhalin` - Asia/Sakhalin
       * * `Asia/Samarkand` - Asia/Samarkand
       * * `Asia/Seoul` - Asia/Seoul
       * * `Asia/Shanghai` - Asia/Shanghai
       * * `Asia/Singapore` - Asia/Singapore
       * * `Asia/Srednekolymsk` - Asia/Srednekolymsk
       * * `Asia/Taipei` - Asia/Taipei
       * * `Asia/Tashkent` - Asia/Tashkent
       * * `Asia/Tbilisi` - Asia/Tbilisi
       * * `Asia/Tehran` - Asia/Tehran
       * * `Asia/Thimphu` - Asia/Thimphu
       * * `Asia/Tokyo` - Asia/Tokyo
       * * `Asia/Tomsk` - Asia/Tomsk
       * * `Asia/Ulaanbaatar` - Asia/Ulaanbaatar
       * * `Asia/Urumqi` - Asia/Urumqi
       * * `Asia/Ust-Nera` - Asia/Ust-Nera
       * * `Asia/Vientiane` - Asia/Vientiane
       * * `Asia/Vladivostok` - Asia/Vladivostok
       * * `Asia/Yakutsk` - Asia/Yakutsk
       * * `Asia/Yangon` - Asia/Yangon
       * * `Asia/Yekaterinburg` - Asia/Yekaterinburg
       * * `Asia/Yerevan` - Asia/Yerevan
       * * `Atlantic/Azores` - Atlantic/Azores
       * * `Atlantic/Bermuda` - Atlantic/Bermuda
       * * `Atlantic/Canary` - Atlantic/Canary
       * * `Atlantic/Cape_Verde` - Atlantic/Cape_Verde
       * * `Atlantic/Faroe` - Atlantic/Faroe
       * * `Atlantic/Madeira` - Atlantic/Madeira
       * * `Atlantic/Reykjavik` - Atlantic/Reykjavik
       * * `Atlantic/South_Georgia` - Atlantic/South_Georgia
       * * `Atlantic/St_Helena` - Atlantic/St_Helena
       * * `Atlantic/Stanley` - Atlantic/Stanley
       * * `Australia/Adelaide` - Australia/Adelaide
       * * `Australia/Brisbane` - Australia/Brisbane
       * * `Australia/Broken_Hill` - Australia/Broken_Hill
       * * `Australia/Darwin` - Australia/Darwin
       * * `Australia/Eucla` - Australia/Eucla
       * * `Australia/Hobart` - Australia/Hobart
       * * `Australia/Lindeman` - Australia/Lindeman
       * * `Australia/Lord_Howe` - Australia/Lord_Howe
       * * `Australia/Melbourne` - Australia/Melbourne
       * * `Australia/Perth` - Australia/Perth
       * * `Australia/Sydney` - Australia/Sydney
       * * `Canada/Atlantic` - Canada/Atlantic
       * * `Canada/Central` - Canada/Central
       * * `Canada/Eastern` - Canada/Eastern
       * * `Canada/Mountain` - Canada/Mountain
       * * `Canada/Newfoundland` - Canada/Newfoundland
       * * `Canada/Pacific` - Canada/Pacific
       * * `Europe/Amsterdam` - Europe/Amsterdam
       * * `Europe/Andorra` - Europe/Andorra
       * * `Europe/Astrakhan` - Europe/Astrakhan
       * * `Europe/Athens` - Europe/Athens
       * * `Europe/Belgrade` - Europe/Belgrade
       * * `Europe/Berlin` - Europe/Berlin
       * * `Europe/Bratislava` - Europe/Bratislava
       * * `Europe/Brussels` - Europe/Brussels
       * * `Europe/Bucharest` - Europe/Bucharest
       * * `Europe/Budapest` - Europe/Budapest
       * * `Europe/Busingen` - Europe/Busingen
       * * `Europe/Chisinau` - Europe/Chisinau
       * * `Europe/Copenhagen` - Europe/Copenhagen
       * * `Europe/Dublin` - Europe/Dublin
       * * `Europe/Gibraltar` - Europe/Gibraltar
       * * `Europe/Guernsey` - Europe/Guernsey
       * * `Europe/Helsinki` - Europe/Helsinki
       * * `Europe/Isle_of_Man` - Europe/Isle_of_Man
       * * `Europe/Istanbul` - Europe/Istanbul
       * * `Europe/Jersey` - Europe/Jersey
       * * `Europe/Kaliningrad` - Europe/Kaliningrad
       * * `Europe/Kirov` - Europe/Kirov
       * * `Europe/Kyiv` - Europe/Kyiv
       * * `Europe/Lisbon` - Europe/Lisbon
       * * `Europe/Ljubljana` - Europe/Ljubljana
       * * `Europe/London` - Europe/London
       * * `Europe/Luxembourg` - Europe/Luxembourg
       * * `Europe/Madrid` - Europe/Madrid
       * * `Europe/Malta` - Europe/Malta
       * * `Europe/Mariehamn` - Europe/Mariehamn
       * * `Europe/Minsk` - Europe/Minsk
       * * `Europe/Monaco` - Europe/Monaco
       * * `Europe/Moscow` - Europe/Moscow
       * * `Europe/Oslo` - Europe/Oslo
       * * `Europe/Paris` - Europe/Paris
       * * `Europe/Podgorica` - Europe/Podgorica
       * * `Europe/Prague` - Europe/Prague
       * * `Europe/Riga` - Europe/Riga
       * * `Europe/Rome` - Europe/Rome
       * * `Europe/Samara` - Europe/Samara
       * * `Europe/San_Marino` - Europe/San_Marino
       * * `Europe/Sarajevo` - Europe/Sarajevo
       * * `Europe/Saratov` - Europe/Saratov
       * * `Europe/Simferopol` - Europe/Simferopol
       * * `Europe/Skopje` - Europe/Skopje
       * * `Europe/Sofia` - Europe/Sofia
       * * `Europe/Stockholm` - Europe/Stockholm
       * * `Europe/Tallinn` - Europe/Tallinn
       * * `Europe/Tirane` - Europe/Tirane
       * * `Europe/Ulyanovsk` - Europe/Ulyanovsk
       * * `Europe/Vaduz` - Europe/Vaduz
       * * `Europe/Vatican` - Europe/Vatican
       * * `Europe/Vienna` - Europe/Vienna
       * * `Europe/Vilnius` - Europe/Vilnius
       * * `Europe/Volgograd` - Europe/Volgograd
       * * `Europe/Warsaw` - Europe/Warsaw
       * * `Europe/Zagreb` - Europe/Zagreb
       * * `Europe/Zurich` - Europe/Zurich
       * * `GMT` - GMT
       * * `Indian/Antananarivo` - Indian/Antananarivo
       * * `Indian/Chagos` - Indian/Chagos
       * * `Indian/Christmas` - Indian/Christmas
       * * `Indian/Cocos` - Indian/Cocos
       * * `Indian/Comoro` - Indian/Comoro
       * * `Indian/Kerguelen` - Indian/Kerguelen
       * * `Indian/Mahe` - Indian/Mahe
       * * `Indian/Maldives` - Indian/Maldives
       * * `Indian/Mauritius` - Indian/Mauritius
       * * `Indian/Mayotte` - Indian/Mayotte
       * * `Indian/Reunion` - Indian/Reunion
       * * `Pacific/Apia` - Pacific/Apia
       * * `Pacific/Auckland` - Pacific/Auckland
       * * `Pacific/Bougainville` - Pacific/Bougainville
       * * `Pacific/Chatham` - Pacific/Chatham
       * * `Pacific/Chuuk` - Pacific/Chuuk
       * * `Pacific/Easter` - Pacific/Easter
       * * `Pacific/Efate` - Pacific/Efate
       * * `Pacific/Fakaofo` - Pacific/Fakaofo
       * * `Pacific/Fiji` - Pacific/Fiji
       * * `Pacific/Funafuti` - Pacific/Funafuti
       * * `Pacific/Galapagos` - Pacific/Galapagos
       * * `Pacific/Gambier` - Pacific/Gambier
       * * `Pacific/Guadalcanal` - Pacific/Guadalcanal
       * * `Pacific/Guam` - Pacific/Guam
       * * `Pacific/Honolulu` - Pacific/Honolulu
       * * `Pacific/Kanton` - Pacific/Kanton
       * * `Pacific/Kiritimati` - Pacific/Kiritimati
       * * `Pacific/Kosrae` - Pacific/Kosrae
       * * `Pacific/Kwajalein` - Pacific/Kwajalein
       * * `Pacific/Majuro` - Pacific/Majuro
       * * `Pacific/Marquesas` - Pacific/Marquesas
       * * `Pacific/Midway` - Pacific/Midway
       * * `Pacific/Nauru` - Pacific/Nauru
       * * `Pacific/Niue` - Pacific/Niue
       * * `Pacific/Norfolk` - Pacific/Norfolk
       * * `Pacific/Noumea` - Pacific/Noumea
       * * `Pacific/Pago_Pago` - Pacific/Pago_Pago
       * * `Pacific/Palau` - Pacific/Palau
       * * `Pacific/Pitcairn` - Pacific/Pitcairn
       * * `Pacific/Pohnpei` - Pacific/Pohnpei
       * * `Pacific/Port_Moresby` - Pacific/Port_Moresby
       * * `Pacific/Rarotonga` - Pacific/Rarotonga
       * * `Pacific/Saipan` - Pacific/Saipan
       * * `Pacific/Tahiti` - Pacific/Tahiti
       * * `Pacific/Tarawa` - Pacific/Tarawa
       * * `Pacific/Tongatapu` - Pacific/Tongatapu
       * * `Pacific/Wake` - Pacific/Wake
       * * `Pacific/Wallis` - Pacific/Wallis
       * * `US/Alaska` - US/Alaska
       * * `US/Arizona` - US/Arizona
       * * `US/Central` - US/Central
       * * `US/Eastern` - US/Eastern
       * * `US/Hawaii` - US/Hawaii
       * * `US/Mountain` - US/Mountain
       * * `US/Pacific` - US/Pacific
       * * `UTC` - UTC 
       * @enum {string}
       */
      timezone: "Africa/Abidjan" | "Africa/Accra" | "Africa/Addis_Ababa" | "Africa/Algiers" | "Africa/Asmara" | "Africa/Bamako" | "Africa/Bangui" | "Africa/Banjul" | "Africa/Bissau" | "Africa/Blantyre" | "Africa/Brazzaville" | "Africa/Bujumbura" | "Africa/Cairo" | "Africa/Casablanca" | "Africa/Ceuta" | "Africa/Conakry" | "Africa/Dakar" | "Africa/Dar_es_Salaam" | "Africa/Djibouti" | "Africa/Douala" | "Africa/El_Aaiun" | "Africa/Freetown" | "Africa/Gaborone" | "Africa/Harare" | "Africa/Johannesburg" | "Africa/Juba" | "Africa/Kampala" | "Africa/Khartoum" | "Africa/Kigali" | "Africa/Kinshasa" | "Africa/Lagos" | "Africa/Libreville" | "Africa/Lome" | "Africa/Luanda" | "Africa/Lubumbashi" | "Africa/Lusaka" | "Africa/Malabo" | "Africa/Maputo" | "Africa/Maseru" | "Africa/Mbabane" | "Africa/Mogadishu" | "Africa/Monrovia" | "Africa/Nairobi" | "Africa/Ndjamena" | "Africa/Niamey" | "Africa/Nouakchott" | "Africa/Ouagadougou" | "Africa/Porto-Novo" | "Africa/Sao_Tome" | "Africa/Tripoli" | "Africa/Tunis" | "Africa/Windhoek" | "America/Adak" | "America/Anchorage" | "America/Anguilla" | "America/Antigua" | "America/Araguaina" | "America/Argentina/Buenos_Aires" | "America/Argentina/Catamarca" | "America/Argentina/Cordoba" | "America/Argentina/Jujuy" | "America/Argentina/La_Rioja" | "America/Argentina/Mendoza" | "America/Argentina/Rio_Gallegos" | "America/Argentina/Salta" | "America/Argentina/San_Juan" | "America/Argentina/San_Luis" | "America/Argentina/Tucuman" | "America/Argentina/Ushuaia" | "America/Aruba" | "America/Asuncion" | "America/Atikokan" | "America/Bahia" | "America/Bahia_Banderas" | "America/Barbados" | "America/Belem" | "America/Belize" | "America/Blanc-Sablon" | "America/Boa_Vista" | "America/Bogota" | "America/Boise" | "America/Cambridge_Bay" | "America/Campo_Grande" | "America/Cancun" | "America/Caracas" | "America/Cayenne" | "America/Cayman" | "America/Chicago" | "America/Chihuahua" | "America/Ciudad_Juarez" | "America/Costa_Rica" | "America/Creston" | "America/Cuiaba" | "America/Curacao" | "America/Danmarkshavn" | "America/Dawson" | "America/Dawson_Creek" | "America/Denver" | "America/Detroit" | "America/Dominica" | "America/Edmonton" | "America/Eirunepe" | "America/El_Salvador" | "America/Fort_Nelson" | "America/Fortaleza" | "America/Glace_Bay" | "America/Goose_Bay" | "America/Grand_Turk" | "America/Grenada" | "America/Guadeloupe" | "America/Guatemala" | "America/Guayaquil" | "America/Guyana" | "America/Halifax" | "America/Havana" | "America/Hermosillo" | "America/Indiana/Indianapolis" | "America/Indiana/Knox" | "America/Indiana/Marengo" | "America/Indiana/Petersburg" | "America/Indiana/Tell_City" | "America/Indiana/Vevay" | "America/Indiana/Vincennes" | "America/Indiana/Winamac" | "America/Inuvik" | "America/Iqaluit" | "America/Jamaica" | "America/Juneau" | "America/Kentucky/Louisville" | "America/Kentucky/Monticello" | "America/Kralendijk" | "America/La_Paz" | "America/Lima" | "America/Los_Angeles" | "America/Lower_Princes" | "America/Maceio" | "America/Managua" | "America/Manaus" | "America/Marigot" | "America/Martinique" | "America/Matamoros" | "America/Mazatlan" | "America/Menominee" | "America/Merida" | "America/Metlakatla" | "America/Mexico_City" | "America/Miquelon" | "America/Moncton" | "America/Monterrey" | "America/Montevideo" | "America/Montserrat" | "America/Nassau" | "America/New_York" | "America/Nome" | "America/Noronha" | "America/North_Dakota/Beulah" | "America/North_Dakota/Center" | "America/North_Dakota/New_Salem" | "America/Nuuk" | "America/Ojinaga" | "America/Panama" | "America/Paramaribo" | "America/Phoenix" | "America/Port-au-Prince" | "America/Port_of_Spain" | "America/Porto_Velho" | "America/Puerto_Rico" | "America/Punta_Arenas" | "America/Rankin_Inlet" | "America/Recife" | "America/Regina" | "America/Resolute" | "America/Rio_Branco" | "America/Santarem" | "America/Santiago" | "America/Santo_Domingo" | "America/Sao_Paulo" | "America/Scoresbysund" | "America/Sitka" | "America/St_Barthelemy" | "America/St_Johns" | "America/St_Kitts" | "America/St_Lucia" | "America/St_Thomas" | "America/St_Vincent" | "America/Swift_Current" | "America/Tegucigalpa" | "America/Thule" | "America/Tijuana" | "America/Toronto" | "America/Tortola" | "America/Vancouver" | "America/Whitehorse" | "America/Winnipeg" | "America/Yakutat" | "America/Yellowknife" | "Antarctica/Casey" | "Antarctica/Davis" | "Antarctica/DumontDUrville" | "Antarctica/Macquarie" | "Antarctica/Mawson" | "Antarctica/McMurdo" | "Antarctica/Palmer" | "Antarctica/Rothera" | "Antarctica/Syowa" | "Antarctica/Troll" | "Antarctica/Vostok" | "Arctic/Longyearbyen" | "Asia/Aden" | "Asia/Almaty" | "Asia/Amman" | "Asia/Anadyr" | "Asia/Aqtau" | "Asia/Aqtobe" | "Asia/Ashgabat" | "Asia/Atyrau" | "Asia/Baghdad" | "Asia/Bahrain" | "Asia/Baku" | "Asia/Bangkok" | "Asia/Barnaul" | "Asia/Beirut" | "Asia/Bishkek" | "Asia/Brunei" | "Asia/Chita" | "Asia/Choibalsan" | "Asia/Colombo" | "Asia/Damascus" | "Asia/Dhaka" | "Asia/Dili" | "Asia/Dubai" | "Asia/Dushanbe" | "Asia/Famagusta" | "Asia/Gaza" | "Asia/Hebron" | "Asia/Ho_Chi_Minh" | "Asia/Hong_Kong" | "Asia/Hovd" | "Asia/Irkutsk" | "Asia/Jakarta" | "Asia/Jayapura" | "Asia/Jerusalem" | "Asia/Kabul" | "Asia/Kamchatka" | "Asia/Karachi" | "Asia/Kathmandu" | "Asia/Khandyga" | "Asia/Kolkata" | "Asia/Krasnoyarsk" | "Asia/Kuala_Lumpur" | "Asia/Kuching" | "Asia/Kuwait" | "Asia/Macau" | "Asia/Magadan" | "Asia/Makassar" | "Asia/Manila" | "Asia/Muscat" | "Asia/Nicosia" | "Asia/Novokuznetsk" | "Asia/Novosibirsk" | "Asia/Omsk" | "Asia/Oral" | "Asia/Phnom_Penh" | "Asia/Pontianak" | "Asia/Pyongyang" | "Asia/Qatar" | "Asia/Qostanay" | "Asia/Qyzylorda" | "Asia/Riyadh" | "Asia/Sakhalin" | "Asia/Samarkand" | "Asia/Seoul" | "Asia/Shanghai" | "Asia/Singapore" | "Asia/Srednekolymsk" | "Asia/Taipei" | "Asia/Tashkent" | "Asia/Tbilisi" | "Asia/Tehran" | "Asia/Thimphu" | "Asia/Tokyo" | "Asia/Tomsk" | "Asia/Ulaanbaatar" | "Asia/Urumqi" | "Asia/Ust-Nera" | "Asia/Vientiane" | "Asia/Vladivostok" | "Asia/Yakutsk" | "Asia/Yangon" | "Asia/Yekaterinburg" | "Asia/Yerevan" | "Atlantic/Azores" | "Atlantic/Bermuda" | "Atlantic/Canary" | "Atlantic/Cape_Verde" | "Atlantic/Faroe" | "Atlantic/Madeira" | "Atlantic/Reykjavik" | "Atlantic/South_Georgia" | "Atlantic/St_Helena" | "Atlantic/Stanley" | "Australia/Adelaide" | "Australia/Brisbane" | "Australia/Broken_Hill" | "Australia/Darwin" | "Australia/Eucla" | "Australia/Hobart" | "Australia/Lindeman" | "Australia/Lord_Howe" | "Australia/Melbourne" | "Australia/Perth" | "Australia/Sydney" | "Canada/Atlantic" | "Canada/Central" | "Canada/Eastern" | "Canada/Mountain" | "Canada/Newfoundland" | "Canada/Pacific" | "Europe/Amsterdam" | "Europe/Andorra" | "Europe/Astrakhan" | "Europe/Athens" | "Europe/Belgrade" | "Europe/Berlin" | "Europe/Bratislava" | "Europe/Brussels" | "Europe/Bucharest" | "Europe/Budapest" | "Europe/Busingen" | "Europe/Chisinau" | "Europe/Copenhagen" | "Europe/Dublin" | "Europe/Gibraltar" | "Europe/Guernsey" | "Europe/Helsinki" | "Europe/Isle_of_Man" | "Europe/Istanbul" | "Europe/Jersey" | "Europe/Kaliningrad" | "Europe/Kirov" | "Europe/Kyiv" | "Europe/Lisbon" | "Europe/Ljubljana" | "Europe/London" | "Europe/Luxembourg" | "Europe/Madrid" | "Europe/Malta" | "Europe/Mariehamn" | "Europe/Minsk" | "Europe/Monaco" | "Europe/Moscow" | "Europe/Oslo" | "Europe/Paris" | "Europe/Podgorica" | "Europe/Prague" | "Europe/Riga" | "Europe/Rome" | "Europe/Samara" | "Europe/San_Marino" | "Europe/Sarajevo" | "Europe/Saratov" | "Europe/Simferopol" | "Europe/Skopje" | "Europe/Sofia" | "Europe/Stockholm" | "Europe/Tallinn" | "Europe/Tirane" | "Europe/Ulyanovsk" | "Europe/Vaduz" | "Europe/Vatican" | "Europe/Vienna" | "Europe/Vilnius" | "Europe/Volgograd" | "Europe/Warsaw" | "Europe/Zagreb" | "Europe/Zurich" | "GMT" | "Indian/Antananarivo" | "Indian/Chagos" | "Indian/Christmas" | "Indian/Cocos" | "Indian/Comoro" | "Indian/Kerguelen" | "Indian/Mahe" | "Indian/Maldives" | "Indian/Mauritius" | "Indian/Mayotte" | "Indian/Reunion" | "Pacific/Apia" | "Pacific/Auckland" | "Pacific/Bougainville" | "Pacific/Chatham" | "Pacific/Chuuk" | "Pacific/Easter" | "Pacific/Efate" | "Pacific/Fakaofo" | "Pacific/Fiji" | "Pacific/Funafuti" | "Pacific/Galapagos" | "Pacific/Gambier" | "Pacific/Guadalcanal" | "Pacific/Guam" | "Pacific/Honolulu" | "Pacific/Kanton" | "Pacific/Kiritimati" | "Pacific/Kosrae" | "Pacific/Kwajalein" | "Pacific/Majuro" | "Pacific/Marquesas" | "Pacific/Midway" | "Pacific/Nauru" | "Pacific/Niue" | "Pacific/Norfolk" | "Pacific/Noumea" | "Pacific/Pago_Pago" | "Pacific/Palau" | "Pacific/Pitcairn" | "Pacific/Pohnpei" | "Pacific/Port_Moresby" | "Pacific/Rarotonga" | "Pacific/Saipan" | "Pacific/Tahiti" | "Pacific/Tarawa" | "Pacific/Tongatapu" | "Pacific/Wake" | "Pacific/Wallis" | "US/Alaska" | "US/Arizona" | "US/Central" | "US/Eastern" | "US/Hawaii" | "US/Mountain" | "US/Pacific" | "UTC";
    };
    CustomerStripeIntegration: {
      stripe_id: string;
      has_payment_method: boolean;
    };
    CustomerSummary: {
      /** @description The display name of the customer */
      customer_name?: string | null;
      /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
      customer_id?: string | null;
      subscriptions: readonly (components["schemas"]["SubscriptionCustomerSummary"])[];
    };
    CustomerUpdate: {
      default_currency_code: string;
      billing_address?: components["schemas"]["Address"] | null;
      shipping_address?: components["schemas"]["Address"] | null;
      /**
       * Format: double 
       * @description Tax rate as percentage. For example, 10.5 for 10.5%
       */
      tax_rate?: number | null;
      /**
       * @description * `Africa/Abidjan` - Africa/Abidjan
       * * `Africa/Accra` - Africa/Accra
       * * `Africa/Addis_Ababa` - Africa/Addis_Ababa
       * * `Africa/Algiers` - Africa/Algiers
       * * `Africa/Asmara` - Africa/Asmara
       * * `Africa/Bamako` - Africa/Bamako
       * * `Africa/Bangui` - Africa/Bangui
       * * `Africa/Banjul` - Africa/Banjul
       * * `Africa/Bissau` - Africa/Bissau
       * * `Africa/Blantyre` - Africa/Blantyre
       * * `Africa/Brazzaville` - Africa/Brazzaville
       * * `Africa/Bujumbura` - Africa/Bujumbura
       * * `Africa/Cairo` - Africa/Cairo
       * * `Africa/Casablanca` - Africa/Casablanca
       * * `Africa/Ceuta` - Africa/Ceuta
       * * `Africa/Conakry` - Africa/Conakry
       * * `Africa/Dakar` - Africa/Dakar
       * * `Africa/Dar_es_Salaam` - Africa/Dar_es_Salaam
       * * `Africa/Djibouti` - Africa/Djibouti
       * * `Africa/Douala` - Africa/Douala
       * * `Africa/El_Aaiun` - Africa/El_Aaiun
       * * `Africa/Freetown` - Africa/Freetown
       * * `Africa/Gaborone` - Africa/Gaborone
       * * `Africa/Harare` - Africa/Harare
       * * `Africa/Johannesburg` - Africa/Johannesburg
       * * `Africa/Juba` - Africa/Juba
       * * `Africa/Kampala` - Africa/Kampala
       * * `Africa/Khartoum` - Africa/Khartoum
       * * `Africa/Kigali` - Africa/Kigali
       * * `Africa/Kinshasa` - Africa/Kinshasa
       * * `Africa/Lagos` - Africa/Lagos
       * * `Africa/Libreville` - Africa/Libreville
       * * `Africa/Lome` - Africa/Lome
       * * `Africa/Luanda` - Africa/Luanda
       * * `Africa/Lubumbashi` - Africa/Lubumbashi
       * * `Africa/Lusaka` - Africa/Lusaka
       * * `Africa/Malabo` - Africa/Malabo
       * * `Africa/Maputo` - Africa/Maputo
       * * `Africa/Maseru` - Africa/Maseru
       * * `Africa/Mbabane` - Africa/Mbabane
       * * `Africa/Mogadishu` - Africa/Mogadishu
       * * `Africa/Monrovia` - Africa/Monrovia
       * * `Africa/Nairobi` - Africa/Nairobi
       * * `Africa/Ndjamena` - Africa/Ndjamena
       * * `Africa/Niamey` - Africa/Niamey
       * * `Africa/Nouakchott` - Africa/Nouakchott
       * * `Africa/Ouagadougou` - Africa/Ouagadougou
       * * `Africa/Porto-Novo` - Africa/Porto-Novo
       * * `Africa/Sao_Tome` - Africa/Sao_Tome
       * * `Africa/Tripoli` - Africa/Tripoli
       * * `Africa/Tunis` - Africa/Tunis
       * * `Africa/Windhoek` - Africa/Windhoek
       * * `America/Adak` - America/Adak
       * * `America/Anchorage` - America/Anchorage
       * * `America/Anguilla` - America/Anguilla
       * * `America/Antigua` - America/Antigua
       * * `America/Araguaina` - America/Araguaina
       * * `America/Argentina/Buenos_Aires` - America/Argentina/Buenos_Aires
       * * `America/Argentina/Catamarca` - America/Argentina/Catamarca
       * * `America/Argentina/Cordoba` - America/Argentina/Cordoba
       * * `America/Argentina/Jujuy` - America/Argentina/Jujuy
       * * `America/Argentina/La_Rioja` - America/Argentina/La_Rioja
       * * `America/Argentina/Mendoza` - America/Argentina/Mendoza
       * * `America/Argentina/Rio_Gallegos` - America/Argentina/Rio_Gallegos
       * * `America/Argentina/Salta` - America/Argentina/Salta
       * * `America/Argentina/San_Juan` - America/Argentina/San_Juan
       * * `America/Argentina/San_Luis` - America/Argentina/San_Luis
       * * `America/Argentina/Tucuman` - America/Argentina/Tucuman
       * * `America/Argentina/Ushuaia` - America/Argentina/Ushuaia
       * * `America/Aruba` - America/Aruba
       * * `America/Asuncion` - America/Asuncion
       * * `America/Atikokan` - America/Atikokan
       * * `America/Bahia` - America/Bahia
       * * `America/Bahia_Banderas` - America/Bahia_Banderas
       * * `America/Barbados` - America/Barbados
       * * `America/Belem` - America/Belem
       * * `America/Belize` - America/Belize
       * * `America/Blanc-Sablon` - America/Blanc-Sablon
       * * `America/Boa_Vista` - America/Boa_Vista
       * * `America/Bogota` - America/Bogota
       * * `America/Boise` - America/Boise
       * * `America/Cambridge_Bay` - America/Cambridge_Bay
       * * `America/Campo_Grande` - America/Campo_Grande
       * * `America/Cancun` - America/Cancun
       * * `America/Caracas` - America/Caracas
       * * `America/Cayenne` - America/Cayenne
       * * `America/Cayman` - America/Cayman
       * * `America/Chicago` - America/Chicago
       * * `America/Chihuahua` - America/Chihuahua
       * * `America/Ciudad_Juarez` - America/Ciudad_Juarez
       * * `America/Costa_Rica` - America/Costa_Rica
       * * `America/Creston` - America/Creston
       * * `America/Cuiaba` - America/Cuiaba
       * * `America/Curacao` - America/Curacao
       * * `America/Danmarkshavn` - America/Danmarkshavn
       * * `America/Dawson` - America/Dawson
       * * `America/Dawson_Creek` - America/Dawson_Creek
       * * `America/Denver` - America/Denver
       * * `America/Detroit` - America/Detroit
       * * `America/Dominica` - America/Dominica
       * * `America/Edmonton` - America/Edmonton
       * * `America/Eirunepe` - America/Eirunepe
       * * `America/El_Salvador` - America/El_Salvador
       * * `America/Fort_Nelson` - America/Fort_Nelson
       * * `America/Fortaleza` - America/Fortaleza
       * * `America/Glace_Bay` - America/Glace_Bay
       * * `America/Goose_Bay` - America/Goose_Bay
       * * `America/Grand_Turk` - America/Grand_Turk
       * * `America/Grenada` - America/Grenada
       * * `America/Guadeloupe` - America/Guadeloupe
       * * `America/Guatemala` - America/Guatemala
       * * `America/Guayaquil` - America/Guayaquil
       * * `America/Guyana` - America/Guyana
       * * `America/Halifax` - America/Halifax
       * * `America/Havana` - America/Havana
       * * `America/Hermosillo` - America/Hermosillo
       * * `America/Indiana/Indianapolis` - America/Indiana/Indianapolis
       * * `America/Indiana/Knox` - America/Indiana/Knox
       * * `America/Indiana/Marengo` - America/Indiana/Marengo
       * * `America/Indiana/Petersburg` - America/Indiana/Petersburg
       * * `America/Indiana/Tell_City` - America/Indiana/Tell_City
       * * `America/Indiana/Vevay` - America/Indiana/Vevay
       * * `America/Indiana/Vincennes` - America/Indiana/Vincennes
       * * `America/Indiana/Winamac` - America/Indiana/Winamac
       * * `America/Inuvik` - America/Inuvik
       * * `America/Iqaluit` - America/Iqaluit
       * * `America/Jamaica` - America/Jamaica
       * * `America/Juneau` - America/Juneau
       * * `America/Kentucky/Louisville` - America/Kentucky/Louisville
       * * `America/Kentucky/Monticello` - America/Kentucky/Monticello
       * * `America/Kralendijk` - America/Kralendijk
       * * `America/La_Paz` - America/La_Paz
       * * `America/Lima` - America/Lima
       * * `America/Los_Angeles` - America/Los_Angeles
       * * `America/Lower_Princes` - America/Lower_Princes
       * * `America/Maceio` - America/Maceio
       * * `America/Managua` - America/Managua
       * * `America/Manaus` - America/Manaus
       * * `America/Marigot` - America/Marigot
       * * `America/Martinique` - America/Martinique
       * * `America/Matamoros` - America/Matamoros
       * * `America/Mazatlan` - America/Mazatlan
       * * `America/Menominee` - America/Menominee
       * * `America/Merida` - America/Merida
       * * `America/Metlakatla` - America/Metlakatla
       * * `America/Mexico_City` - America/Mexico_City
       * * `America/Miquelon` - America/Miquelon
       * * `America/Moncton` - America/Moncton
       * * `America/Monterrey` - America/Monterrey
       * * `America/Montevideo` - America/Montevideo
       * * `America/Montserrat` - America/Montserrat
       * * `America/Nassau` - America/Nassau
       * * `America/New_York` - America/New_York
       * * `America/Nome` - America/Nome
       * * `America/Noronha` - America/Noronha
       * * `America/North_Dakota/Beulah` - America/North_Dakota/Beulah
       * * `America/North_Dakota/Center` - America/North_Dakota/Center
       * * `America/North_Dakota/New_Salem` - America/North_Dakota/New_Salem
       * * `America/Nuuk` - America/Nuuk
       * * `America/Ojinaga` - America/Ojinaga
       * * `America/Panama` - America/Panama
       * * `America/Paramaribo` - America/Paramaribo
       * * `America/Phoenix` - America/Phoenix
       * * `America/Port-au-Prince` - America/Port-au-Prince
       * * `America/Port_of_Spain` - America/Port_of_Spain
       * * `America/Porto_Velho` - America/Porto_Velho
       * * `America/Puerto_Rico` - America/Puerto_Rico
       * * `America/Punta_Arenas` - America/Punta_Arenas
       * * `America/Rankin_Inlet` - America/Rankin_Inlet
       * * `America/Recife` - America/Recife
       * * `America/Regina` - America/Regina
       * * `America/Resolute` - America/Resolute
       * * `America/Rio_Branco` - America/Rio_Branco
       * * `America/Santarem` - America/Santarem
       * * `America/Santiago` - America/Santiago
       * * `America/Santo_Domingo` - America/Santo_Domingo
       * * `America/Sao_Paulo` - America/Sao_Paulo
       * * `America/Scoresbysund` - America/Scoresbysund
       * * `America/Sitka` - America/Sitka
       * * `America/St_Barthelemy` - America/St_Barthelemy
       * * `America/St_Johns` - America/St_Johns
       * * `America/St_Kitts` - America/St_Kitts
       * * `America/St_Lucia` - America/St_Lucia
       * * `America/St_Thomas` - America/St_Thomas
       * * `America/St_Vincent` - America/St_Vincent
       * * `America/Swift_Current` - America/Swift_Current
       * * `America/Tegucigalpa` - America/Tegucigalpa
       * * `America/Thule` - America/Thule
       * * `America/Tijuana` - America/Tijuana
       * * `America/Toronto` - America/Toronto
       * * `America/Tortola` - America/Tortola
       * * `America/Vancouver` - America/Vancouver
       * * `America/Whitehorse` - America/Whitehorse
       * * `America/Winnipeg` - America/Winnipeg
       * * `America/Yakutat` - America/Yakutat
       * * `America/Yellowknife` - America/Yellowknife
       * * `Antarctica/Casey` - Antarctica/Casey
       * * `Antarctica/Davis` - Antarctica/Davis
       * * `Antarctica/DumontDUrville` - Antarctica/DumontDUrville
       * * `Antarctica/Macquarie` - Antarctica/Macquarie
       * * `Antarctica/Mawson` - Antarctica/Mawson
       * * `Antarctica/McMurdo` - Antarctica/McMurdo
       * * `Antarctica/Palmer` - Antarctica/Palmer
       * * `Antarctica/Rothera` - Antarctica/Rothera
       * * `Antarctica/Syowa` - Antarctica/Syowa
       * * `Antarctica/Troll` - Antarctica/Troll
       * * `Antarctica/Vostok` - Antarctica/Vostok
       * * `Arctic/Longyearbyen` - Arctic/Longyearbyen
       * * `Asia/Aden` - Asia/Aden
       * * `Asia/Almaty` - Asia/Almaty
       * * `Asia/Amman` - Asia/Amman
       * * `Asia/Anadyr` - Asia/Anadyr
       * * `Asia/Aqtau` - Asia/Aqtau
       * * `Asia/Aqtobe` - Asia/Aqtobe
       * * `Asia/Ashgabat` - Asia/Ashgabat
       * * `Asia/Atyrau` - Asia/Atyrau
       * * `Asia/Baghdad` - Asia/Baghdad
       * * `Asia/Bahrain` - Asia/Bahrain
       * * `Asia/Baku` - Asia/Baku
       * * `Asia/Bangkok` - Asia/Bangkok
       * * `Asia/Barnaul` - Asia/Barnaul
       * * `Asia/Beirut` - Asia/Beirut
       * * `Asia/Bishkek` - Asia/Bishkek
       * * `Asia/Brunei` - Asia/Brunei
       * * `Asia/Chita` - Asia/Chita
       * * `Asia/Choibalsan` - Asia/Choibalsan
       * * `Asia/Colombo` - Asia/Colombo
       * * `Asia/Damascus` - Asia/Damascus
       * * `Asia/Dhaka` - Asia/Dhaka
       * * `Asia/Dili` - Asia/Dili
       * * `Asia/Dubai` - Asia/Dubai
       * * `Asia/Dushanbe` - Asia/Dushanbe
       * * `Asia/Famagusta` - Asia/Famagusta
       * * `Asia/Gaza` - Asia/Gaza
       * * `Asia/Hebron` - Asia/Hebron
       * * `Asia/Ho_Chi_Minh` - Asia/Ho_Chi_Minh
       * * `Asia/Hong_Kong` - Asia/Hong_Kong
       * * `Asia/Hovd` - Asia/Hovd
       * * `Asia/Irkutsk` - Asia/Irkutsk
       * * `Asia/Jakarta` - Asia/Jakarta
       * * `Asia/Jayapura` - Asia/Jayapura
       * * `Asia/Jerusalem` - Asia/Jerusalem
       * * `Asia/Kabul` - Asia/Kabul
       * * `Asia/Kamchatka` - Asia/Kamchatka
       * * `Asia/Karachi` - Asia/Karachi
       * * `Asia/Kathmandu` - Asia/Kathmandu
       * * `Asia/Khandyga` - Asia/Khandyga
       * * `Asia/Kolkata` - Asia/Kolkata
       * * `Asia/Krasnoyarsk` - Asia/Krasnoyarsk
       * * `Asia/Kuala_Lumpur` - Asia/Kuala_Lumpur
       * * `Asia/Kuching` - Asia/Kuching
       * * `Asia/Kuwait` - Asia/Kuwait
       * * `Asia/Macau` - Asia/Macau
       * * `Asia/Magadan` - Asia/Magadan
       * * `Asia/Makassar` - Asia/Makassar
       * * `Asia/Manila` - Asia/Manila
       * * `Asia/Muscat` - Asia/Muscat
       * * `Asia/Nicosia` - Asia/Nicosia
       * * `Asia/Novokuznetsk` - Asia/Novokuznetsk
       * * `Asia/Novosibirsk` - Asia/Novosibirsk
       * * `Asia/Omsk` - Asia/Omsk
       * * `Asia/Oral` - Asia/Oral
       * * `Asia/Phnom_Penh` - Asia/Phnom_Penh
       * * `Asia/Pontianak` - Asia/Pontianak
       * * `Asia/Pyongyang` - Asia/Pyongyang
       * * `Asia/Qatar` - Asia/Qatar
       * * `Asia/Qostanay` - Asia/Qostanay
       * * `Asia/Qyzylorda` - Asia/Qyzylorda
       * * `Asia/Riyadh` - Asia/Riyadh
       * * `Asia/Sakhalin` - Asia/Sakhalin
       * * `Asia/Samarkand` - Asia/Samarkand
       * * `Asia/Seoul` - Asia/Seoul
       * * `Asia/Shanghai` - Asia/Shanghai
       * * `Asia/Singapore` - Asia/Singapore
       * * `Asia/Srednekolymsk` - Asia/Srednekolymsk
       * * `Asia/Taipei` - Asia/Taipei
       * * `Asia/Tashkent` - Asia/Tashkent
       * * `Asia/Tbilisi` - Asia/Tbilisi
       * * `Asia/Tehran` - Asia/Tehran
       * * `Asia/Thimphu` - Asia/Thimphu
       * * `Asia/Tokyo` - Asia/Tokyo
       * * `Asia/Tomsk` - Asia/Tomsk
       * * `Asia/Ulaanbaatar` - Asia/Ulaanbaatar
       * * `Asia/Urumqi` - Asia/Urumqi
       * * `Asia/Ust-Nera` - Asia/Ust-Nera
       * * `Asia/Vientiane` - Asia/Vientiane
       * * `Asia/Vladivostok` - Asia/Vladivostok
       * * `Asia/Yakutsk` - Asia/Yakutsk
       * * `Asia/Yangon` - Asia/Yangon
       * * `Asia/Yekaterinburg` - Asia/Yekaterinburg
       * * `Asia/Yerevan` - Asia/Yerevan
       * * `Atlantic/Azores` - Atlantic/Azores
       * * `Atlantic/Bermuda` - Atlantic/Bermuda
       * * `Atlantic/Canary` - Atlantic/Canary
       * * `Atlantic/Cape_Verde` - Atlantic/Cape_Verde
       * * `Atlantic/Faroe` - Atlantic/Faroe
       * * `Atlantic/Madeira` - Atlantic/Madeira
       * * `Atlantic/Reykjavik` - Atlantic/Reykjavik
       * * `Atlantic/South_Georgia` - Atlantic/South_Georgia
       * * `Atlantic/St_Helena` - Atlantic/St_Helena
       * * `Atlantic/Stanley` - Atlantic/Stanley
       * * `Australia/Adelaide` - Australia/Adelaide
       * * `Australia/Brisbane` - Australia/Brisbane
       * * `Australia/Broken_Hill` - Australia/Broken_Hill
       * * `Australia/Darwin` - Australia/Darwin
       * * `Australia/Eucla` - Australia/Eucla
       * * `Australia/Hobart` - Australia/Hobart
       * * `Australia/Lindeman` - Australia/Lindeman
       * * `Australia/Lord_Howe` - Australia/Lord_Howe
       * * `Australia/Melbourne` - Australia/Melbourne
       * * `Australia/Perth` - Australia/Perth
       * * `Australia/Sydney` - Australia/Sydney
       * * `Canada/Atlantic` - Canada/Atlantic
       * * `Canada/Central` - Canada/Central
       * * `Canada/Eastern` - Canada/Eastern
       * * `Canada/Mountain` - Canada/Mountain
       * * `Canada/Newfoundland` - Canada/Newfoundland
       * * `Canada/Pacific` - Canada/Pacific
       * * `Europe/Amsterdam` - Europe/Amsterdam
       * * `Europe/Andorra` - Europe/Andorra
       * * `Europe/Astrakhan` - Europe/Astrakhan
       * * `Europe/Athens` - Europe/Athens
       * * `Europe/Belgrade` - Europe/Belgrade
       * * `Europe/Berlin` - Europe/Berlin
       * * `Europe/Bratislava` - Europe/Bratislava
       * * `Europe/Brussels` - Europe/Brussels
       * * `Europe/Bucharest` - Europe/Bucharest
       * * `Europe/Budapest` - Europe/Budapest
       * * `Europe/Busingen` - Europe/Busingen
       * * `Europe/Chisinau` - Europe/Chisinau
       * * `Europe/Copenhagen` - Europe/Copenhagen
       * * `Europe/Dublin` - Europe/Dublin
       * * `Europe/Gibraltar` - Europe/Gibraltar
       * * `Europe/Guernsey` - Europe/Guernsey
       * * `Europe/Helsinki` - Europe/Helsinki
       * * `Europe/Isle_of_Man` - Europe/Isle_of_Man
       * * `Europe/Istanbul` - Europe/Istanbul
       * * `Europe/Jersey` - Europe/Jersey
       * * `Europe/Kaliningrad` - Europe/Kaliningrad
       * * `Europe/Kirov` - Europe/Kirov
       * * `Europe/Kyiv` - Europe/Kyiv
       * * `Europe/Lisbon` - Europe/Lisbon
       * * `Europe/Ljubljana` - Europe/Ljubljana
       * * `Europe/London` - Europe/London
       * * `Europe/Luxembourg` - Europe/Luxembourg
       * * `Europe/Madrid` - Europe/Madrid
       * * `Europe/Malta` - Europe/Malta
       * * `Europe/Mariehamn` - Europe/Mariehamn
       * * `Europe/Minsk` - Europe/Minsk
       * * `Europe/Monaco` - Europe/Monaco
       * * `Europe/Moscow` - Europe/Moscow
       * * `Europe/Oslo` - Europe/Oslo
       * * `Europe/Paris` - Europe/Paris
       * * `Europe/Podgorica` - Europe/Podgorica
       * * `Europe/Prague` - Europe/Prague
       * * `Europe/Riga` - Europe/Riga
       * * `Europe/Rome` - Europe/Rome
       * * `Europe/Samara` - Europe/Samara
       * * `Europe/San_Marino` - Europe/San_Marino
       * * `Europe/Sarajevo` - Europe/Sarajevo
       * * `Europe/Saratov` - Europe/Saratov
       * * `Europe/Simferopol` - Europe/Simferopol
       * * `Europe/Skopje` - Europe/Skopje
       * * `Europe/Sofia` - Europe/Sofia
       * * `Europe/Stockholm` - Europe/Stockholm
       * * `Europe/Tallinn` - Europe/Tallinn
       * * `Europe/Tirane` - Europe/Tirane
       * * `Europe/Ulyanovsk` - Europe/Ulyanovsk
       * * `Europe/Vaduz` - Europe/Vaduz
       * * `Europe/Vatican` - Europe/Vatican
       * * `Europe/Vienna` - Europe/Vienna
       * * `Europe/Vilnius` - Europe/Vilnius
       * * `Europe/Volgograd` - Europe/Volgograd
       * * `Europe/Warsaw` - Europe/Warsaw
       * * `Europe/Zagreb` - Europe/Zagreb
       * * `Europe/Zurich` - Europe/Zurich
       * * `GMT` - GMT
       * * `Indian/Antananarivo` - Indian/Antananarivo
       * * `Indian/Chagos` - Indian/Chagos
       * * `Indian/Christmas` - Indian/Christmas
       * * `Indian/Cocos` - Indian/Cocos
       * * `Indian/Comoro` - Indian/Comoro
       * * `Indian/Kerguelen` - Indian/Kerguelen
       * * `Indian/Mahe` - Indian/Mahe
       * * `Indian/Maldives` - Indian/Maldives
       * * `Indian/Mauritius` - Indian/Mauritius
       * * `Indian/Mayotte` - Indian/Mayotte
       * * `Indian/Reunion` - Indian/Reunion
       * * `Pacific/Apia` - Pacific/Apia
       * * `Pacific/Auckland` - Pacific/Auckland
       * * `Pacific/Bougainville` - Pacific/Bougainville
       * * `Pacific/Chatham` - Pacific/Chatham
       * * `Pacific/Chuuk` - Pacific/Chuuk
       * * `Pacific/Easter` - Pacific/Easter
       * * `Pacific/Efate` - Pacific/Efate
       * * `Pacific/Fakaofo` - Pacific/Fakaofo
       * * `Pacific/Fiji` - Pacific/Fiji
       * * `Pacific/Funafuti` - Pacific/Funafuti
       * * `Pacific/Galapagos` - Pacific/Galapagos
       * * `Pacific/Gambier` - Pacific/Gambier
       * * `Pacific/Guadalcanal` - Pacific/Guadalcanal
       * * `Pacific/Guam` - Pacific/Guam
       * * `Pacific/Honolulu` - Pacific/Honolulu
       * * `Pacific/Kanton` - Pacific/Kanton
       * * `Pacific/Kiritimati` - Pacific/Kiritimati
       * * `Pacific/Kosrae` - Pacific/Kosrae
       * * `Pacific/Kwajalein` - Pacific/Kwajalein
       * * `Pacific/Majuro` - Pacific/Majuro
       * * `Pacific/Marquesas` - Pacific/Marquesas
       * * `Pacific/Midway` - Pacific/Midway
       * * `Pacific/Nauru` - Pacific/Nauru
       * * `Pacific/Niue` - Pacific/Niue
       * * `Pacific/Norfolk` - Pacific/Norfolk
       * * `Pacific/Noumea` - Pacific/Noumea
       * * `Pacific/Pago_Pago` - Pacific/Pago_Pago
       * * `Pacific/Palau` - Pacific/Palau
       * * `Pacific/Pitcairn` - Pacific/Pitcairn
       * * `Pacific/Pohnpei` - Pacific/Pohnpei
       * * `Pacific/Port_Moresby` - Pacific/Port_Moresby
       * * `Pacific/Rarotonga` - Pacific/Rarotonga
       * * `Pacific/Saipan` - Pacific/Saipan
       * * `Pacific/Tahiti` - Pacific/Tahiti
       * * `Pacific/Tarawa` - Pacific/Tarawa
       * * `Pacific/Tongatapu` - Pacific/Tongatapu
       * * `Pacific/Wake` - Pacific/Wake
       * * `Pacific/Wallis` - Pacific/Wallis
       * * `US/Alaska` - US/Alaska
       * * `US/Arizona` - US/Arizona
       * * `US/Central` - US/Central
       * * `US/Eastern` - US/Eastern
       * * `US/Hawaii` - US/Hawaii
       * * `US/Mountain` - US/Mountain
       * * `US/Pacific` - US/Pacific
       * * `UTC` - UTC 
       * @enum {string}
       */
      timezone: "Africa/Abidjan" | "Africa/Accra" | "Africa/Addis_Ababa" | "Africa/Algiers" | "Africa/Asmara" | "Africa/Bamako" | "Africa/Bangui" | "Africa/Banjul" | "Africa/Bissau" | "Africa/Blantyre" | "Africa/Brazzaville" | "Africa/Bujumbura" | "Africa/Cairo" | "Africa/Casablanca" | "Africa/Ceuta" | "Africa/Conakry" | "Africa/Dakar" | "Africa/Dar_es_Salaam" | "Africa/Djibouti" | "Africa/Douala" | "Africa/El_Aaiun" | "Africa/Freetown" | "Africa/Gaborone" | "Africa/Harare" | "Africa/Johannesburg" | "Africa/Juba" | "Africa/Kampala" | "Africa/Khartoum" | "Africa/Kigali" | "Africa/Kinshasa" | "Africa/Lagos" | "Africa/Libreville" | "Africa/Lome" | "Africa/Luanda" | "Africa/Lubumbashi" | "Africa/Lusaka" | "Africa/Malabo" | "Africa/Maputo" | "Africa/Maseru" | "Africa/Mbabane" | "Africa/Mogadishu" | "Africa/Monrovia" | "Africa/Nairobi" | "Africa/Ndjamena" | "Africa/Niamey" | "Africa/Nouakchott" | "Africa/Ouagadougou" | "Africa/Porto-Novo" | "Africa/Sao_Tome" | "Africa/Tripoli" | "Africa/Tunis" | "Africa/Windhoek" | "America/Adak" | "America/Anchorage" | "America/Anguilla" | "America/Antigua" | "America/Araguaina" | "America/Argentina/Buenos_Aires" | "America/Argentina/Catamarca" | "America/Argentina/Cordoba" | "America/Argentina/Jujuy" | "America/Argentina/La_Rioja" | "America/Argentina/Mendoza" | "America/Argentina/Rio_Gallegos" | "America/Argentina/Salta" | "America/Argentina/San_Juan" | "America/Argentina/San_Luis" | "America/Argentina/Tucuman" | "America/Argentina/Ushuaia" | "America/Aruba" | "America/Asuncion" | "America/Atikokan" | "America/Bahia" | "America/Bahia_Banderas" | "America/Barbados" | "America/Belem" | "America/Belize" | "America/Blanc-Sablon" | "America/Boa_Vista" | "America/Bogota" | "America/Boise" | "America/Cambridge_Bay" | "America/Campo_Grande" | "America/Cancun" | "America/Caracas" | "America/Cayenne" | "America/Cayman" | "America/Chicago" | "America/Chihuahua" | "America/Ciudad_Juarez" | "America/Costa_Rica" | "America/Creston" | "America/Cuiaba" | "America/Curacao" | "America/Danmarkshavn" | "America/Dawson" | "America/Dawson_Creek" | "America/Denver" | "America/Detroit" | "America/Dominica" | "America/Edmonton" | "America/Eirunepe" | "America/El_Salvador" | "America/Fort_Nelson" | "America/Fortaleza" | "America/Glace_Bay" | "America/Goose_Bay" | "America/Grand_Turk" | "America/Grenada" | "America/Guadeloupe" | "America/Guatemala" | "America/Guayaquil" | "America/Guyana" | "America/Halifax" | "America/Havana" | "America/Hermosillo" | "America/Indiana/Indianapolis" | "America/Indiana/Knox" | "America/Indiana/Marengo" | "America/Indiana/Petersburg" | "America/Indiana/Tell_City" | "America/Indiana/Vevay" | "America/Indiana/Vincennes" | "America/Indiana/Winamac" | "America/Inuvik" | "America/Iqaluit" | "America/Jamaica" | "America/Juneau" | "America/Kentucky/Louisville" | "America/Kentucky/Monticello" | "America/Kralendijk" | "America/La_Paz" | "America/Lima" | "America/Los_Angeles" | "America/Lower_Princes" | "America/Maceio" | "America/Managua" | "America/Manaus" | "America/Marigot" | "America/Martinique" | "America/Matamoros" | "America/Mazatlan" | "America/Menominee" | "America/Merida" | "America/Metlakatla" | "America/Mexico_City" | "America/Miquelon" | "America/Moncton" | "America/Monterrey" | "America/Montevideo" | "America/Montserrat" | "America/Nassau" | "America/New_York" | "America/Nome" | "America/Noronha" | "America/North_Dakota/Beulah" | "America/North_Dakota/Center" | "America/North_Dakota/New_Salem" | "America/Nuuk" | "America/Ojinaga" | "America/Panama" | "America/Paramaribo" | "America/Phoenix" | "America/Port-au-Prince" | "America/Port_of_Spain" | "America/Porto_Velho" | "America/Puerto_Rico" | "America/Punta_Arenas" | "America/Rankin_Inlet" | "America/Recife" | "America/Regina" | "America/Resolute" | "America/Rio_Branco" | "America/Santarem" | "America/Santiago" | "America/Santo_Domingo" | "America/Sao_Paulo" | "America/Scoresbysund" | "America/Sitka" | "America/St_Barthelemy" | "America/St_Johns" | "America/St_Kitts" | "America/St_Lucia" | "America/St_Thomas" | "America/St_Vincent" | "America/Swift_Current" | "America/Tegucigalpa" | "America/Thule" | "America/Tijuana" | "America/Toronto" | "America/Tortola" | "America/Vancouver" | "America/Whitehorse" | "America/Winnipeg" | "America/Yakutat" | "America/Yellowknife" | "Antarctica/Casey" | "Antarctica/Davis" | "Antarctica/DumontDUrville" | "Antarctica/Macquarie" | "Antarctica/Mawson" | "Antarctica/McMurdo" | "Antarctica/Palmer" | "Antarctica/Rothera" | "Antarctica/Syowa" | "Antarctica/Troll" | "Antarctica/Vostok" | "Arctic/Longyearbyen" | "Asia/Aden" | "Asia/Almaty" | "Asia/Amman" | "Asia/Anadyr" | "Asia/Aqtau" | "Asia/Aqtobe" | "Asia/Ashgabat" | "Asia/Atyrau" | "Asia/Baghdad" | "Asia/Bahrain" | "Asia/Baku" | "Asia/Bangkok" | "Asia/Barnaul" | "Asia/Beirut" | "Asia/Bishkek" | "Asia/Brunei" | "Asia/Chita" | "Asia/Choibalsan" | "Asia/Colombo" | "Asia/Damascus" | "Asia/Dhaka" | "Asia/Dili" | "Asia/Dubai" | "Asia/Dushanbe" | "Asia/Famagusta" | "Asia/Gaza" | "Asia/Hebron" | "Asia/Ho_Chi_Minh" | "Asia/Hong_Kong" | "Asia/Hovd" | "Asia/Irkutsk" | "Asia/Jakarta" | "Asia/Jayapura" | "Asia/Jerusalem" | "Asia/Kabul" | "Asia/Kamchatka" | "Asia/Karachi" | "Asia/Kathmandu" | "Asia/Khandyga" | "Asia/Kolkata" | "Asia/Krasnoyarsk" | "Asia/Kuala_Lumpur" | "Asia/Kuching" | "Asia/Kuwait" | "Asia/Macau" | "Asia/Magadan" | "Asia/Makassar" | "Asia/Manila" | "Asia/Muscat" | "Asia/Nicosia" | "Asia/Novokuznetsk" | "Asia/Novosibirsk" | "Asia/Omsk" | "Asia/Oral" | "Asia/Phnom_Penh" | "Asia/Pontianak" | "Asia/Pyongyang" | "Asia/Qatar" | "Asia/Qostanay" | "Asia/Qyzylorda" | "Asia/Riyadh" | "Asia/Sakhalin" | "Asia/Samarkand" | "Asia/Seoul" | "Asia/Shanghai" | "Asia/Singapore" | "Asia/Srednekolymsk" | "Asia/Taipei" | "Asia/Tashkent" | "Asia/Tbilisi" | "Asia/Tehran" | "Asia/Thimphu" | "Asia/Tokyo" | "Asia/Tomsk" | "Asia/Ulaanbaatar" | "Asia/Urumqi" | "Asia/Ust-Nera" | "Asia/Vientiane" | "Asia/Vladivostok" | "Asia/Yakutsk" | "Asia/Yangon" | "Asia/Yekaterinburg" | "Asia/Yerevan" | "Atlantic/Azores" | "Atlantic/Bermuda" | "Atlantic/Canary" | "Atlantic/Cape_Verde" | "Atlantic/Faroe" | "Atlantic/Madeira" | "Atlantic/Reykjavik" | "Atlantic/South_Georgia" | "Atlantic/St_Helena" | "Atlantic/Stanley" | "Australia/Adelaide" | "Australia/Brisbane" | "Australia/Broken_Hill" | "Australia/Darwin" | "Australia/Eucla" | "Australia/Hobart" | "Australia/Lindeman" | "Australia/Lord_Howe" | "Australia/Melbourne" | "Australia/Perth" | "Australia/Sydney" | "Canada/Atlantic" | "Canada/Central" | "Canada/Eastern" | "Canada/Mountain" | "Canada/Newfoundland" | "Canada/Pacific" | "Europe/Amsterdam" | "Europe/Andorra" | "Europe/Astrakhan" | "Europe/Athens" | "Europe/Belgrade" | "Europe/Berlin" | "Europe/Bratislava" | "Europe/Brussels" | "Europe/Bucharest" | "Europe/Budapest" | "Europe/Busingen" | "Europe/Chisinau" | "Europe/Copenhagen" | "Europe/Dublin" | "Europe/Gibraltar" | "Europe/Guernsey" | "Europe/Helsinki" | "Europe/Isle_of_Man" | "Europe/Istanbul" | "Europe/Jersey" | "Europe/Kaliningrad" | "Europe/Kirov" | "Europe/Kyiv" | "Europe/Lisbon" | "Europe/Ljubljana" | "Europe/London" | "Europe/Luxembourg" | "Europe/Madrid" | "Europe/Malta" | "Europe/Mariehamn" | "Europe/Minsk" | "Europe/Monaco" | "Europe/Moscow" | "Europe/Oslo" | "Europe/Paris" | "Europe/Podgorica" | "Europe/Prague" | "Europe/Riga" | "Europe/Rome" | "Europe/Samara" | "Europe/San_Marino" | "Europe/Sarajevo" | "Europe/Saratov" | "Europe/Simferopol" | "Europe/Skopje" | "Europe/Sofia" | "Europe/Stockholm" | "Europe/Tallinn" | "Europe/Tirane" | "Europe/Ulyanovsk" | "Europe/Vaduz" | "Europe/Vatican" | "Europe/Vienna" | "Europe/Vilnius" | "Europe/Volgograd" | "Europe/Warsaw" | "Europe/Zagreb" | "Europe/Zurich" | "GMT" | "Indian/Antananarivo" | "Indian/Chagos" | "Indian/Christmas" | "Indian/Cocos" | "Indian/Comoro" | "Indian/Kerguelen" | "Indian/Mahe" | "Indian/Maldives" | "Indian/Mauritius" | "Indian/Mayotte" | "Indian/Reunion" | "Pacific/Apia" | "Pacific/Auckland" | "Pacific/Bougainville" | "Pacific/Chatham" | "Pacific/Chuuk" | "Pacific/Easter" | "Pacific/Efate" | "Pacific/Fakaofo" | "Pacific/Fiji" | "Pacific/Funafuti" | "Pacific/Galapagos" | "Pacific/Gambier" | "Pacific/Guadalcanal" | "Pacific/Guam" | "Pacific/Honolulu" | "Pacific/Kanton" | "Pacific/Kiritimati" | "Pacific/Kosrae" | "Pacific/Kwajalein" | "Pacific/Majuro" | "Pacific/Marquesas" | "Pacific/Midway" | "Pacific/Nauru" | "Pacific/Niue" | "Pacific/Norfolk" | "Pacific/Noumea" | "Pacific/Pago_Pago" | "Pacific/Palau" | "Pacific/Pitcairn" | "Pacific/Pohnpei" | "Pacific/Port_Moresby" | "Pacific/Rarotonga" | "Pacific/Saipan" | "Pacific/Tahiti" | "Pacific/Tarawa" | "Pacific/Tongatapu" | "Pacific/Wake" | "Pacific/Wallis" | "US/Alaska" | "US/Arizona" | "US/Central" | "US/Eastern" | "US/Hawaii" | "US/Mountain" | "US/Pacific" | "UTC";
      customer_name?: string;
    };
    CustomerWithRevenue: {
      /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
      customer_id?: string | null;
      /** Format: double */
      total_amount_due: number;
    };
    DayMetricUsage: {
      /** Format: date */
      date: string;
      customer_usages: {
        [key: string]: number | undefined;
      };
    };
    DeleteAddOn: {
      success: boolean;
      message: string;
    };
    DeleteAddOnVersion: {
      success: boolean;
      message: string;
    };
    DeletePlan: {
      success: boolean;
      message: string;
    };
    DeletePlanVersion: {
      success: boolean;
      message: string;
    };
    DemoLoginFailure: {
      detail: string;
    };
    DemoLoginRequestRequest: {
      username: string;
      password: string;
    };
    DemoLoginSuccess: {
      detail: string;
      token: string;
      user: components["schemas"]["User"];
    };
    DemoRegistrationDetailRequest: {
      email: string;
      password: string;
      username: string;
    };
    DemoRegistrationFailure: {
      detail: string;
    };
    DemoRegistrationRequest: {
      register: components["schemas"]["DemoRegistrationDetailRequest"];
    };
    DemoRegistrationSuccess: {
      detail: string;
      token: string;
      user: components["schemas"]["User"];
    };
    EmailRequest: {
      /** Format: email */
      email: string;
    };
    EventDetail: {
      /** @description String name of the event, corresponds to definition in metrics */
      event_name: string;
      /** @description Extra metadata on the event that can be filtered and queried on in the metrics. All key value pairs should have string keys and values can be either strings or numbers. Place subscription filters in this object to specify which subscription the event should be tracked under */
      properties?: {
        [key: string]: unknown | undefined;
      };
      /**
       * Format: date-time 
       * @description The time that the event occured, represented as a datetime in RFC3339 in the UTC timezome.
       */
      time_created: string;
      /** @description A unique identifier for the specific event being passed in. Passing in a unique id allows Lotus to make sure no double counting occurs. We recommend using a UUID4. */
      idempotency_id: string;
      /** @description The id of the customer that this event is associated with, usually the customer id in your backend */
      customer_id: string;
    };
    EventProperties: {
      event_names: (string)[];
      event_name_to_props: {
        [key: string]: (string)[] | undefined;
      };
    };
    EventRequest: {
      /** @description String name of the event, corresponds to definition in metrics */
      event_name: string;
      /** @description Extra metadata on the event that can be filtered and queried on in the metrics. All key value pairs should have string keys and values can be either strings or numbers. Place subscription filters in this object to specify which subscription the event should be tracked under */
      properties?: {
        [key: string]: unknown | undefined;
      };
      /**
       * Format: date-time 
       * @description The time that the event occured, represented as a datetime in RFC3339 in the UTC timezome.
       */
      time_created: string;
      /** @description A unique identifier for the specific event being passed in. Passing in a unique id allows Lotus to make sure no double counting occurs. We recommend using a UUID4. */
      idempotency_id: string;
      /** @description The id of the customer that this event is associated with, usually the customer id in your backend */
      customer_id: string;
    };
    ExternalPlanLink: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      source: "stripe" | "braintree";
      external_plan_id: string;
    };
    ExternalPlanLinkRequest: {
      /** Format: uuid */
      plan_id: string;
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      source: "stripe" | "braintree";
      external_plan_id: string;
    };
    Feature: {
      feature_id: string;
      feature_name: string;
      feature_description: string | null;
    };
    FeatureAccessPerSubscription: {
      subscription: components["schemas"]["AccessMethodsSubscriptionRecord"];
      access: boolean;
    };
    FeatureAccessResponse: {
      customer: components["schemas"]["LightweightCustomer"];
      /** @description Whether or not the customer has access to this feature. The default behavior for this is whether any of the customer's plans have access to this feature. If you have specified subscription filters, then this will be whether any of the customer's plans that match the subscription filters have access to this feature. You can customize the behavior of this flag by setting a policy in your Organization settings in the frontend. */
      access: boolean;
      feature: components["schemas"]["Feature"];
      access_per_subscription: (components["schemas"]["FeatureAccessPerSubscription"])[];
    };
    FeatureCreateRequest: {
      feature_name: string;
      feature_description?: string | null;
    };
    FeatureDetail: {
      feature_id: string;
      feature_name: string;
      feature_description: string | null;
    };
    GetEventAccess: {
      /** @description The plan_id of the plan we are checking that has access to this feature. */
      plan_id: string;
      /** @description The subscription filters that are applied to this plan's relationship with the customer. If your billing model does not have the ability multiple plans or subscriptions per customer, this is likely not relevant for you. */
      subscription_filters: (components["schemas"]["SubscriptionFilter"])[];
      /** @description The usage of each component of the plan the customer is on. Only components that match the request will be included: If metric_id is provided, this will be a list of length 1. If event_name is provided, this will be a list of length 1 or more depending on how many components of the customer's plan use this event. */
      usage_per_component: (components["schemas"]["ComponentUsage"])[];
    };
    GetFeatureAccess: {
      /** @description Name of the feature to check access for. */
      feature_name: string;
      /** @description The plan_id of the plan we are checking that has access to this feature. */
      plan_id: string;
      /** @description The subscription filters that are applied to this plan's relationship with the customer. If your billing model does not have the ability multiple plans or subscriptions per customer, this is likely not relevant for you. */
      subscription_filters: (components["schemas"]["SubscriptionFilter"])[];
      /** @description Whether or not the plan has access to this feature. If your customer can have multiple plans or subscriptions, then you must check the 'access' across all returned plans to determine if the customer can access this feature. */
      access: boolean;
    };
    ImportCustomerFailure: {
      /**
       * @description * `error` - error 
       * @enum {string}
       */
      status: "error";
      detail: string;
    };
    ImportCustomerSuccess: {
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
      detail: string;
    };
    ImportCustomersRequestRequest: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      source: "stripe" | "braintree";
    };
    ImportPaymentObjectFailure: {
      /**
       * @description * `error` - error 
       * @enum {string}
       */
      status: "error";
      detail: string;
    };
    ImportPaymentObjectSuccess: {
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
      detail: string;
    };
    ImportPaymentObjectsRequestRequest: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      source: "stripe" | "braintree";
    };
    ImportSubscriptionsFailure: {
      /**
       * @description * `error` - error 
       * @enum {string}
       */
      status: "error";
      detail: string;
    };
    ImportSubscriptionsRequestRequest: {
      /**
       * @description * `stripe` - Stripe 
       * @enum {string}
       */
      source: "stripe";
    };
    ImportSubscriptionsSuccess: {
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
      detail: string;
    };
    InitResetPasswordSuccess: {
      email: string;
    };
    InitialAddOnVersionCreateRequest: {
      recurring_charges?: (components["schemas"]["RecurringChargeCreateRequest"])[] | null;
      /**
       * @description * `invoice_on_attach` - invoice_on_attach
       * * `invoice_on_subscription_end` - invoice_on_subscription_end 
       * @enum {unknown}
       */
      invoice_when: "invoice_on_attach" | "invoice_on_subscription_end";
      components?: (components["schemas"]["PlanComponentCreateRequest"])[] | null;
      features?: (string)[];
      currency_code: string;
      /**
       * @description * `one_time` - one_time
       * * `recurring` - recurring 
       * @enum {unknown}
       */
      billing_frequency: "one_time" | "recurring";
    };
    InitialExternalPlanLink: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      source: "stripe" | "braintree";
      external_plan_id: string;
    };
    InitialExternalPlanLinkRequest: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      source: "stripe" | "braintree";
      external_plan_id: string;
    };
    InitialPlanVersionCreateRequest: {
      target_customer_ids?: (string | null)[];
      localized_name?: string | null;
      /** @default false */
      make_active?: boolean;
      recurring_charges?: (components["schemas"]["RecurringChargeCreateRequest"])[];
      version: number;
      components?: (components["schemas"]["PlanComponentCreateRequest"])[];
      features?: (string)[];
      /**
       * @description * `replace_on_renewal` - Replace on Renewal
       * * `grandfather` - Grandfather 
       * @default replace_on_renewal 
       * @enum {string}
       */
      make_active_type?: "replace_on_renewal" | "grandfather";
      price_adjustment?: components["schemas"]["PriceAdjustmentRequest"];
      currency_code: string;
      day_anchor?: number | null;
      month_anchor?: number | null;
    };
    InviteLinkResponse: {
      /** Format: email */
      email: string;
      /** Format: uri */
      link: string;
    };
    InviteRequestRequest: {
      /** Format: email */
      email: string;
    };
    InviteResponse: {
      /** Format: email */
      email: string;
    };
    Invoice: {
      invoice_id: string;
      invoice_number: string;
      /**
       * Format: double 
       * @deprecated
       */
      cost_due: number;
      /** Format: double */
      amount: number;
      currency: components["schemas"]["PricingUnit"];
      /** Format: date-time */
      issue_date: string;
      /**
       * @description * `draft` - draft
       * * `voided` - voided
       * * `paid` - paid
       * * `unpaid` - unpaid 
       * @enum {unknown}
       */
      payment_status: "draft" | "voided" | "paid" | "unpaid";
      external_payment_obj_id: string | null;
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      external_payment_obj_type: "stripe" | "braintree" | "" | null;
      external_payment_obj_status?: string | null;
      line_items: (components["schemas"]["InvoiceLineItem"])[];
      customer: components["schemas"]["LightweightCustomerSerializerForInvoice"];
      /** Format: date-time */
      due_date: string | null;
      /** Format: date */
      start_date: string;
      /** Format: date */
      end_date: string;
      seller: components["schemas"]["Seller"];
      /** Format: uri */
      invoice_pdf: string | null;
    };
    InvoiceCreatedRequest: {
      payload: components["schemas"]["InvoiceRequest"];
    };
    InvoiceDetail: {
      invoice_number: string;
      crm_provider_id: string | null;
      external_payment_obj_id: string | null;
      /**
       * @description * `salesforce` - salesforce 
       * @enum {string}
       */
      crm_provider: "salesforce";
      /** Format: uri */
      external_payment_obj_url: string | null;
      /** Format: uri */
      invoice_pdf: string | null;
      /** Format: date-time */
      due_date: string | null;
      /**
       * @description * `draft` - draft
       * * `voided` - voided
       * * `paid` - paid
       * * `unpaid` - unpaid 
       * @enum {unknown}
       */
      payment_status: "draft" | "voided" | "paid" | "unpaid";
      /** Format: date */
      end_date: string;
      invoice_id: string;
      /** Format: date */
      start_date: string;
      line_items: (components["schemas"]["InvoiceLineItem"])[];
      customer: components["schemas"]["LightweightCustomerSerializerForInvoice"];
      currency: components["schemas"]["PricingUnit"];
      seller: components["schemas"]["Seller"];
      /**
       * Format: double 
       * @deprecated
       */
      cost_due: number;
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      external_payment_obj_type: "stripe" | "braintree" | "" | null;
      /** Format: double */
      amount: number;
      /** Format: date-time */
      issue_date: string;
      /** Format: uri */
      crm_provider_url: string | null;
      external_payment_obj_status?: string | null;
    };
    InvoiceDetailRequest: {
      invoice_id: string;
      line_items: (components["schemas"]["InvoiceLineItemRequest"])[];
      currency: components["schemas"]["PricingUnitRequest"];
      seller: components["schemas"]["SellerRequest"];
      /**
       * Format: double 
       * @deprecated
       */
      cost_due: number;
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      external_payment_obj_type: "stripe" | "braintree" | "" | null;
      external_payment_obj_status?: string | null;
    };
    InvoiceLineItem: {
      name: string;
      /** Format: date-time */
      start_date: string;
      /** Format: date-time */
      end_date: string;
      /** Format: double */
      quantity: number | null;
      /**
       * @description * `in_arrears` - In Arrears
       * * `intermediate` - Intermediate
       * * `in_advance` - In Advance
       * * `one_time` - One Time 
       * @enum {string|null}
       */
      billing_type: "in_arrears" | "intermediate" | "in_advance" | "one_time" | "" | null;
      metadata: ({
        [key: string]: unknown | undefined;
      }) | null;
      plan: components["schemas"]["LightweightPlanVersion"] | null;
      subscription_filters: readonly (components["schemas"]["SubscriptionFilter"])[] | null;
      /**
       * Format: double 
       * @description Base price of the line item. This is the price before any adjustments are applied.
       */
      base: number;
      adjustments: readonly (components["schemas"]["InvoiceLineItemAdjustment"])[];
      /**
       * Format: double 
       * @description Amount of the line item. This is the price after any adjustments are applied.
       */
      amount: number;
      /**
       * Format: double 
       * @deprecated
       */
      subtotal: number;
    };
    InvoiceLineItemAdjustment: {
      /** Format: decimal */
      amount: string;
      account: string;
      /**
       * @description * `sales_tax` - sales_tax
       * * `plan_adjustment` - plan_adjustment 
       * @enum {unknown}
       */
      adjustment_type: "sales_tax" | "plan_adjustment";
    };
    InvoiceLineItemRequest: {
      name: string;
      /** Format: date-time */
      start_date: string;
      /** Format: date-time */
      end_date: string;
      /** Format: double */
      quantity: number | null;
      /**
       * @description * `in_arrears` - In Arrears
       * * `intermediate` - Intermediate
       * * `in_advance` - In Advance
       * * `one_time` - One Time 
       * @enum {string|null}
       */
      billing_type: "in_arrears" | "intermediate" | "in_advance" | "one_time" | "" | null;
      metadata: ({
        [key: string]: unknown | undefined;
      }) | null;
      /**
       * Format: double 
       * @description Base price of the line item. This is the price before any adjustments are applied.
       */
      base: number;
      /**
       * Format: double 
       * @description Amount of the line item. This is the price after any adjustments are applied.
       */
      amount: number;
      /**
       * Format: double 
       * @deprecated
       */
      subtotal: number;
    };
    InvoicePaidRequest: {
      payload: components["schemas"]["InvoiceRequest"];
    };
    InvoicePastDueRequest: {
      payload: components["schemas"]["InvoiceRequest"];
    };
    InvoicePayment: {
      invoice_id: string;
      invoice_number: string;
      customer: components["schemas"]["LightweightCustomerSerializerForInvoice"];
      /** Format: double */
      amount: number;
      currency: components["schemas"]["PricingUnit"];
      /** Format: date-time */
      payment_date: string;
      /**
       * @description * `stripe` - stripe
       * * `braintree` - braintree
       * * `lotus_out_of_band` - lotus_out_of_band 
       * @enum {string}
       */
      source: "stripe" | "braintree" | "lotus_out_of_band";
    };
    InvoiceRequest: {
      invoice_id: string;
      /**
       * Format: double 
       * @deprecated
       */
      cost_due: number;
      currency: components["schemas"]["PricingUnitRequest"];
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      external_payment_obj_type: "stripe" | "braintree" | "" | null;
      external_payment_obj_status?: string | null;
      line_items: (components["schemas"]["InvoiceLineItemRequest"])[];
      seller: components["schemas"]["SellerRequest"];
    };
    LightweightAddOn: {
      /** @description The name of the add-on plan. */
      addon_name: string;
      /** @description The ID of the add-on plan. */
      addon_id: string;
      /** @enum {string} */
      addon_type: "flat" | "usage_based";
      /**
       * @description * `one_time` - one_time
       * * `recurring` - recurring 
       * @enum {unknown}
       */
      billing_frequency: "one_time" | "recurring";
    };
    LightweightAddOnRequest: {
      /** @description The name of the add-on plan. */
      addon_name: string;
      /** @description The ID of the add-on plan. */
      addon_id: string;
    };
    LightweightAddOnSubscriptionRecord: {
      addon_subscription_id: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      start_date: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      end_date: string;
      addon: components["schemas"]["LightweightAddOn"];
      fully_billed: boolean;
    };
    LightweightAddOnSubscriptionRecordRequest: {
      addon_subscription_id: string;
      addon: components["schemas"]["LightweightAddOnRequest"];
    };
    LightweightCustomer: {
      /** @description The display name of the customer */
      customer_name: string | null;
      /**
       * Format: email 
       * @description The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider
       */
      email: string | null;
      /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
      customer_id: string | null;
    };
    LightweightCustomerSerializerForInvoice: {
      /** @description The display name of the customer */
      customer_name: string | null;
      /**
       * Format: email 
       * @description The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider
       */
      email: string | null;
      /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
      customer_id: string | null;
      address?: components["schemas"]["Address"] | null;
    };
    LightweightInvoice: {
      invoice_number: string;
      external_payment_obj_id: string | null;
      /** Format: uri */
      invoice_pdf: string | null;
      /** Format: date-time */
      due_date: string | null;
      /**
       * @description * `draft` - draft
       * * `voided` - voided
       * * `paid` - paid
       * * `unpaid` - unpaid 
       * @enum {unknown}
       */
      payment_status: "draft" | "voided" | "paid" | "unpaid";
      /** Format: date */
      end_date: string;
      invoice_id: string;
      /** Format: date */
      start_date: string;
      currency: components["schemas"]["PricingUnit"];
      seller: components["schemas"]["Seller"];
      /**
       * Format: double 
       * @deprecated
       */
      cost_due: number;
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      external_payment_obj_type: "stripe" | "braintree" | "" | null;
      /** Format: double */
      amount: number;
      /** Format: date-time */
      issue_date: string;
      external_payment_obj_status?: string | null;
    };
    LightweightInvoiceDetail: {
      invoice_number: string;
      crm_provider_id: string | null;
      external_payment_obj_id: string | null;
      /**
       * @description * `salesforce` - salesforce 
       * @enum {string}
       */
      crm_provider: "salesforce";
      /** Format: uri */
      external_payment_obj_url: string | null;
      /** Format: uri */
      invoice_pdf: string | null;
      /** Format: date-time */
      due_date: string | null;
      /** Format: date */
      end_date: string;
      /**
       * @description * `draft` - draft
       * * `voided` - voided
       * * `paid` - paid
       * * `unpaid` - unpaid 
       * @enum {unknown}
       */
      payment_status: "draft" | "voided" | "paid" | "unpaid";
      invoice_id: string;
      /** Format: date */
      start_date: string;
      currency: components["schemas"]["PricingUnit"];
      seller: components["schemas"]["Seller"];
      /**
       * Format: double 
       * @deprecated
       */
      cost_due: number;
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string|null}
       */
      external_payment_obj_type: "stripe" | "braintree" | "" | null;
      /** Format: double */
      amount: number;
      /** Format: date-time */
      issue_date: string;
      /** Format: uri */
      crm_provider_url: string | null;
      external_payment_obj_status?: string | null;
    };
    LightweightMetric: {
      metric_id: string;
      /** @description Name of the event that this metric is tracking. */
      event_name: string;
      metric_name: string;
    };
    LightweightOrganization: {
      organization_id: string;
      organization_name: string;
      /**
       * @description * `Production` - Production
       * * `Development` - Development
       * * `Demo` - Demo
       * * `Internal Demo` - Internal Demo 
       * @enum {string}
       */
      organization_type: "Production" | "Development" | "Demo" | "Internal Demo";
      current: boolean;
    };
    LightweightPlan: {
      /** @description Name of the plan */
      plan_name: string;
      plan_id: string;
    };
    LightweightPlanVersion: {
      plan_name: string;
      plan_id: string;
      version_id: string;
      version: number | "custom_version";
    };
    LightweightPlanVersionRequest: {
      plan_id: string;
    };
    LightweightSubscriptionRecord: {
      /** @description Whether this subscription came from a renewal or from a first-time. Defaults to true on creation. */
      is_new: boolean;
      customer: components["schemas"]["LightweightCustomer"];
      billing_plan: components["schemas"]["LightweightPlanVersion"];
      metadata: {
        [key: string]: unknown | undefined;
      };
      fully_billed: boolean;
      subscription_filters: readonly (components["schemas"]["SubscriptionFilter"])[];
      subscription_id: string;
      plan_detail: components["schemas"]["LightweightPlanVersion"];
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      end_date: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      auto_renew: boolean;
      addons: (components["schemas"]["LightweightAddOnSubscriptionRecord"])[];
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      start_date: string;
    };
    LightweightSubscriptionRecordRequest: {
      /** @description Whether this subscription came from a renewal or from a first-time. Defaults to true on creation. */
      is_new: boolean;
      billing_plan: components["schemas"]["LightweightPlanVersionRequest"];
      metadata: {
        [key: string]: unknown | undefined;
      };
      subscription_id: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      end_date: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      auto_renew: boolean;
      addons: (components["schemas"]["LightweightAddOnSubscriptionRecordRequest"])[];
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      start_date: string;
    };
    LightweightUser: {
      /** @description Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only. */
      username: string;
      /** Format: email */
      email: string;
    };
    LinkTokenResponse: {
      /** @description The token used to link Vessel and the CRM */
      link_token: string;
    };
    LoginFailure: {
      detail: string;
    };
    LoginRequestRequest: {
      username: string;
      password: string;
    };
    LoginSuccess: {
      detail: string;
      token: string;
      user: components["schemas"]["User"];
    };
    LogoutFailure: {
      detail: string;
    };
    LogoutSuccess: {
      detail: string;
    };
    MakePublicRequestRequest: {
      version: number;
    };
    MakePublicResponse: {
      success: boolean;
      message: string;
    };
    MakeReplaceWithRequest: {
      /** @description The plan versions that will get replaced by the current version. */
      versions_to_replace: (string)[];
    };
    MakeReplaceWithResponse: {
      success: boolean;
      message: string;
    };
    Metric: {
      metric_id: string;
      /** @description Name of the event that this metric is tracking. */
      event_name: string;
      /** @description The name of the property of the event that should be used for this metric. Doesn't apply if the metric is of type 'counter' with an aggregation of count. */
      property_name: string | null;
      aggregation_type: string;
      /**
       * @description The granularity of the metric. Only applies to metrics of type 'gauge' or 'rate'.
       * 
       * * `seconds` - Second
       * * `minutes` - Minute
       * * `hours` - Hour
       * * `days` - Day
       * * `months` - Month
       * * `quarters` - Quarter
       * * `years` - Year
       * * `total` - Total 
       * @enum {string|null}
       */
      granularity: "seconds" | "minutes" | "hours" | "days" | "months" | "quarters" | "years" | "total" | "" | null;
      /**
       * @description Used only for metrics of type 'gauge'. Please refer to our documentation for an explanation of the different types.
       * 
       * * `delta` - Delta
       * * `total` - Total 
       * @enum {string|null}
       */
      event_type: "delta" | "total" | "" | null;
      /**
       * @description The type of metric that this is. Please refer to our documentation for an explanation of the different types.
       * 
       * * `counter` - Counter
       * * `rate` - Rate
       * * `custom` - Custom
       * * `gauge` - Gauge 
       * @enum {string}
       */
      metric_type: "counter" | "rate" | "custom" | "gauge";
      metric_name: string;
      numeric_filters: (components["schemas"]["NumericFilter"])[];
      categorical_filters: (components["schemas"]["CategoricalFilter"])[];
      /** @description Whether or not this metric is a cost metric (used to track costs to your business). */
      is_cost_metric: boolean;
      /** @description A custom SQL query that can be used to define the metric. Please refer to our documentation for more information. */
      custom_sql: string | null;
      /**
       * @description The proration of the metric. Only applies to metrics of type 'gauge'.
       * 
       * * `seconds` - Second
       * * `minutes` - Minute
       * * `hours` - Hour
       * * `days` - Day
       * * `months` - Month
       * * `quarters` - Quarter
       * * `years` - Year
       * * `total` - Total 
       * @enum {string|null}
       */
      proration: "seconds" | "minutes" | "hours" | "days" | "months" | "quarters" | "years" | "total" | "" | null;
    };
    MetricAccessPerSubscription: {
      subscription: components["schemas"]["AccessMethodsSubscriptionRecord"];
      /**
       * Format: double 
       * @description The current usage of the metric. Keep in mind the current usage of the metric can be different from the billable usage of the metric. For examnple, for a gauge metric, the `metric_usage` is the current value of the gauge, while the billable usage is the accumulated tiem at each gauge level at the end of the subscription.
       */
      metric_usage: number;
      /**
       * Format: double 
       * @description If you specified a free tier of usage for this metric, this is the amount of usage that is free. Will be 0 if you didn't specify a free limit for this metric or this subscription doesn't have access to this metric, and null if the free tier is unlimited.
       */
      metric_free_limit: number | null;
      /**
       * Format: double 
       * @description The total limit of the metric. Will be 0 if this subscription doesn't have access to this metric, and null if there is no limit to this metric.
       */
      metric_total_limit: number | null;
    };
    MetricAccessResponse: {
      customer: components["schemas"]["LightweightCustomer"];
      /** @description Whether or not the customer has access to this metric. The default behavior for this is whether all of the customer's plans (that have access to the metric) are below the total limit of the metric. If you have specified subscription filters, then this will be whether all of the customer's plans that match the subscription filters are below the total limit of the metric. You can customize the behavior of this flag by setting a policy in your Organization settings in the frontend. */
      access: boolean;
      metric: components["schemas"]["LightweightMetric"];
      access_per_subscription: (components["schemas"]["MetricAccessPerSubscription"])[];
    };
    MetricCreateRequest: {
      /** @description Name of the event that this metric is tracking. */
      event_name?: string;
      /** @description The name of the property of the event that should be used for this metric. Doesn't apply if the metric is of type 'counter' with an aggregation of count. */
      property_name?: string | null;
      /**
       * @description The type of aggregation that should be used for this metric. Please refer to our documentation for an explanation of the different types.
       * 
       * * `count` - Count
       * * `sum` - Sum
       * * `max` - Max
       * * `unique` - Unique
       * * `latest` - Latest
       * * `average` - Average 
       * @enum {string|null}
       */
      usage_aggregation_type?: "count" | "sum" | "max" | "unique" | "latest" | "average" | "" | null;
      /**
       * @description * `count` - Count
       * * `sum` - Sum
       * * `max` - Max
       * * `unique` - Unique
       * * `latest` - Latest
       * * `average` - Average 
       * @enum {string|null}
       */
      billable_aggregation_type?: "count" | "sum" | "max" | "unique" | "latest" | "average" | "" | null;
      /**
       * @description The granularity of the metric. Only applies to metrics of type 'gauge' or 'rate'.
       * 
       * * `seconds` - Second
       * * `minutes` - Minute
       * * `hours` - Hour
       * * `days` - Day
       * * `months` - Month
       * * `quarters` - Quarter
       * * `years` - Year
       * * `total` - Total 
       * @enum {string|null}
       */
      granularity?: "seconds" | "minutes" | "hours" | "days" | "months" | "quarters" | "years" | "total" | "" | null;
      /**
       * @description Used only for metrics of type 'gauge'. Please refer to our documentation for an explanation of the different types.
       * 
       * * `delta` - Delta
       * * `total` - Total 
       * @enum {string|null}
       */
      event_type?: "delta" | "total" | "" | null;
      /**
       * @description The type of metric that this is. Please refer to our documentation for an explanation of the different types.
       * 
       * * `counter` - Counter
       * * `rate` - Rate
       * * `custom` - Custom
       * * `gauge` - Gauge 
       * @enum {string}
       */
      metric_type: "counter" | "rate" | "custom" | "gauge";
      metric_name: string;
      /**
       * @description The proration of the metric. Only applies to metrics of type 'gauge'.
       * 
       * * `seconds` - Second
       * * `minutes` - Minute
       * * `hours` - Hour
       * * `days` - Day
       * * `months` - Month
       * * `quarters` - Quarter
       * * `years` - Year
       * * `total` - Total 
       * @enum {string|null}
       */
      proration?: "seconds" | "minutes" | "hours" | "days" | "months" | "quarters" | "years" | "total" | "" | null;
      properties?: ({
        [key: string]: unknown | undefined;
      }) | null;
      /**
       * @description Whether or not this metric is a cost metric (used to track costs to your business). 
       * @default false
       */
      is_cost_metric?: boolean;
      /** @description A custom SQL query that can be used to define the metric. Please refer to our documentation for more information. */
      custom_sql?: string | null;
      categorical_filters?: (components["schemas"]["CategoricalFilterDetailRequest"])[];
      numeric_filters?: (components["schemas"]["NumericFilterDetailRequest"])[];
    };
    MetricDetail: {
      /** @description Name of the event that this metric is tracking. */
      event_name: string;
      /** @description Whether or not this metric is a cost metric (used to track costs to your business). */
      is_cost_metric: boolean;
      metric_name: string;
      metric_id: string;
      /**
       * @description The granularity of the metric. Only applies to metrics of type 'gauge' or 'rate'.
       * 
       * * `seconds` - Second
       * * `minutes` - Minute
       * * `hours` - Hour
       * * `days` - Day
       * * `months` - Month
       * * `quarters` - Quarter
       * * `years` - Year
       * * `total` - Total 
       * @enum {string|null}
       */
      granularity: "seconds" | "minutes" | "hours" | "days" | "months" | "quarters" | "years" | "total" | "" | null;
      /**
       * @description Used only for metrics of type 'gauge'. Please refer to our documentation for an explanation of the different types.
       * 
       * * `delta` - Delta
       * * `total` - Total 
       * @enum {string|null}
       */
      event_type: "delta" | "total" | "" | null;
      /** @description The name of the property of the event that should be used for this metric. Doesn't apply if the metric is of type 'counter' with an aggregation of count. */
      property_name: string | null;
      numeric_filters: (components["schemas"]["NumericFilter"])[];
      categorical_filters: (components["schemas"]["CategoricalFilter"])[];
      /**
       * @description The proration of the metric. Only applies to metrics of type 'gauge'.
       * 
       * * `seconds` - Second
       * * `minutes` - Minute
       * * `hours` - Hour
       * * `days` - Day
       * * `months` - Month
       * * `quarters` - Quarter
       * * `years` - Year
       * * `total` - Total 
       * @enum {string|null}
       */
      proration: "seconds" | "minutes" | "hours" | "days" | "months" | "quarters" | "years" | "total" | "" | null;
      /** @description A custom SQL query that can be used to define the metric. Please refer to our documentation for more information. */
      custom_sql: string | null;
      /**
       * @description The type of metric that this is. Please refer to our documentation for an explanation of the different types.
       * 
       * * `counter` - Counter
       * * `rate` - Rate
       * * `custom` - Custom
       * * `gauge` - Gauge 
       * @enum {string}
       */
      metric_type: "counter" | "rate" | "custom" | "gauge";
      /**
       * @description The type of aggregation that should be used for this metric. Please refer to our documentation for an explanation of the different types.
       * 
       * * `count` - Count
       * * `sum` - Sum
       * * `max` - Max
       * * `unique` - Unique
       * * `latest` - Latest
       * * `average` - Average 
       * @enum {string}
       */
      usage_aggregation_type?: "count" | "sum" | "max" | "unique" | "latest" | "average";
      /**
       * @description * `count` - Count
       * * `sum` - Sum
       * * `max` - Max
       * * `unique` - Unique
       * * `latest` - Latest
       * * `average` - Average 
       * @enum {string|null}
       */
      billable_aggregation_type?: "count" | "sum" | "max" | "unique" | "latest" | "average" | "" | "" | null;
    };
    MetricRequest: {
      metric_id: string;
      aggregation_type: string;
      metric_name: string;
      numeric_filters: (components["schemas"]["NumericFilterRequest"])[];
      categorical_filters: (components["schemas"]["CategoricalFilterRequest"])[];
    };
    MetricRevenue: {
      metric_name: string;
      /** Format: double */
      original_plan_revenue: number;
      /** Format: double */
      new_plan_revenue: number;
    };
    MetricUpdate: {
      billable_metric_name?: string | null;
      /**
       * @description * `active` - Active
       * * `archived` - Archived 
       * @enum {string}
       */
      status?: "active" | "archived";
    };
    NextPlanVersionNumberResponse: {
      version: number;
    };
    NumericFilter: {
      property_name: string;
      /**
       * @description * `gte` - Greater than or equal to
       * * `gt` - Greater than
       * * `eq` - Equal to
       * * `lt` - Less than
       * * `lte` - Less than or equal to 
       * @enum {string}
       */
      operator: "gte" | "gt" | "eq" | "lt" | "lte";
      /** Format: double */
      comparison_value: number;
    };
    NumericFilterDetailRequest: {
      property_name: string;
      /**
       * @description * `gte` - Greater than or equal to
       * * `gt` - Greater than
       * * `eq` - Equal to
       * * `lt` - Less than
       * * `lte` - Less than or equal to 
       * @enum {string}
       */
      operator: "gte" | "gt" | "eq" | "lt" | "lte";
      /** Format: double */
      comparison_value: number;
    };
    NumericFilterRequest: {
      property_name: string;
      /**
       * @description * `gte` - Greater than or equal to
       * * `gt` - Greater than
       * * `eq` - Equal to
       * * `lt` - Less than
       * * `lte` - Less than or equal to 
       * @enum {string}
       */
      operator: "gte" | "gt" | "eq" | "lt" | "lte";
      /** Format: double */
      comparison_value: number;
    };
    Organization: {
      organization_id: string;
      organization_name: string;
      users: readonly (components["schemas"]["OrganizationUser"])[];
      default_currency: components["schemas"]["PricingUnitDetail"];
      available_currencies: readonly (components["schemas"]["PricingUnitDetail"])[];
      plan_tags: readonly (components["schemas"]["Tag"])[];
      /**
       * Format: double 
       * @description Tax rate as percentage. For example, 10.5 for 10.5%
       */
      tax_rate?: number | null;
      payment_grace_period: number | null;
      linked_organizations: readonly (components["schemas"]["LightweightOrganization"])[];
      current_user: components["schemas"]["LightweightUser"];
      address: components["schemas"]["Address"] | null;
      team_name: string;
      /** @description Allowed subscription filter keys */
      subscription_filter_keys?: (string)[];
      /**
       * @description * `Africa/Abidjan` - Africa/Abidjan
       * * `Africa/Accra` - Africa/Accra
       * * `Africa/Addis_Ababa` - Africa/Addis_Ababa
       * * `Africa/Algiers` - Africa/Algiers
       * * `Africa/Asmara` - Africa/Asmara
       * * `Africa/Bamako` - Africa/Bamako
       * * `Africa/Bangui` - Africa/Bangui
       * * `Africa/Banjul` - Africa/Banjul
       * * `Africa/Bissau` - Africa/Bissau
       * * `Africa/Blantyre` - Africa/Blantyre
       * * `Africa/Brazzaville` - Africa/Brazzaville
       * * `Africa/Bujumbura` - Africa/Bujumbura
       * * `Africa/Cairo` - Africa/Cairo
       * * `Africa/Casablanca` - Africa/Casablanca
       * * `Africa/Ceuta` - Africa/Ceuta
       * * `Africa/Conakry` - Africa/Conakry
       * * `Africa/Dakar` - Africa/Dakar
       * * `Africa/Dar_es_Salaam` - Africa/Dar_es_Salaam
       * * `Africa/Djibouti` - Africa/Djibouti
       * * `Africa/Douala` - Africa/Douala
       * * `Africa/El_Aaiun` - Africa/El_Aaiun
       * * `Africa/Freetown` - Africa/Freetown
       * * `Africa/Gaborone` - Africa/Gaborone
       * * `Africa/Harare` - Africa/Harare
       * * `Africa/Johannesburg` - Africa/Johannesburg
       * * `Africa/Juba` - Africa/Juba
       * * `Africa/Kampala` - Africa/Kampala
       * * `Africa/Khartoum` - Africa/Khartoum
       * * `Africa/Kigali` - Africa/Kigali
       * * `Africa/Kinshasa` - Africa/Kinshasa
       * * `Africa/Lagos` - Africa/Lagos
       * * `Africa/Libreville` - Africa/Libreville
       * * `Africa/Lome` - Africa/Lome
       * * `Africa/Luanda` - Africa/Luanda
       * * `Africa/Lubumbashi` - Africa/Lubumbashi
       * * `Africa/Lusaka` - Africa/Lusaka
       * * `Africa/Malabo` - Africa/Malabo
       * * `Africa/Maputo` - Africa/Maputo
       * * `Africa/Maseru` - Africa/Maseru
       * * `Africa/Mbabane` - Africa/Mbabane
       * * `Africa/Mogadishu` - Africa/Mogadishu
       * * `Africa/Monrovia` - Africa/Monrovia
       * * `Africa/Nairobi` - Africa/Nairobi
       * * `Africa/Ndjamena` - Africa/Ndjamena
       * * `Africa/Niamey` - Africa/Niamey
       * * `Africa/Nouakchott` - Africa/Nouakchott
       * * `Africa/Ouagadougou` - Africa/Ouagadougou
       * * `Africa/Porto-Novo` - Africa/Porto-Novo
       * * `Africa/Sao_Tome` - Africa/Sao_Tome
       * * `Africa/Tripoli` - Africa/Tripoli
       * * `Africa/Tunis` - Africa/Tunis
       * * `Africa/Windhoek` - Africa/Windhoek
       * * `America/Adak` - America/Adak
       * * `America/Anchorage` - America/Anchorage
       * * `America/Anguilla` - America/Anguilla
       * * `America/Antigua` - America/Antigua
       * * `America/Araguaina` - America/Araguaina
       * * `America/Argentina/Buenos_Aires` - America/Argentina/Buenos_Aires
       * * `America/Argentina/Catamarca` - America/Argentina/Catamarca
       * * `America/Argentina/Cordoba` - America/Argentina/Cordoba
       * * `America/Argentina/Jujuy` - America/Argentina/Jujuy
       * * `America/Argentina/La_Rioja` - America/Argentina/La_Rioja
       * * `America/Argentina/Mendoza` - America/Argentina/Mendoza
       * * `America/Argentina/Rio_Gallegos` - America/Argentina/Rio_Gallegos
       * * `America/Argentina/Salta` - America/Argentina/Salta
       * * `America/Argentina/San_Juan` - America/Argentina/San_Juan
       * * `America/Argentina/San_Luis` - America/Argentina/San_Luis
       * * `America/Argentina/Tucuman` - America/Argentina/Tucuman
       * * `America/Argentina/Ushuaia` - America/Argentina/Ushuaia
       * * `America/Aruba` - America/Aruba
       * * `America/Asuncion` - America/Asuncion
       * * `America/Atikokan` - America/Atikokan
       * * `America/Bahia` - America/Bahia
       * * `America/Bahia_Banderas` - America/Bahia_Banderas
       * * `America/Barbados` - America/Barbados
       * * `America/Belem` - America/Belem
       * * `America/Belize` - America/Belize
       * * `America/Blanc-Sablon` - America/Blanc-Sablon
       * * `America/Boa_Vista` - America/Boa_Vista
       * * `America/Bogota` - America/Bogota
       * * `America/Boise` - America/Boise
       * * `America/Cambridge_Bay` - America/Cambridge_Bay
       * * `America/Campo_Grande` - America/Campo_Grande
       * * `America/Cancun` - America/Cancun
       * * `America/Caracas` - America/Caracas
       * * `America/Cayenne` - America/Cayenne
       * * `America/Cayman` - America/Cayman
       * * `America/Chicago` - America/Chicago
       * * `America/Chihuahua` - America/Chihuahua
       * * `America/Ciudad_Juarez` - America/Ciudad_Juarez
       * * `America/Costa_Rica` - America/Costa_Rica
       * * `America/Creston` - America/Creston
       * * `America/Cuiaba` - America/Cuiaba
       * * `America/Curacao` - America/Curacao
       * * `America/Danmarkshavn` - America/Danmarkshavn
       * * `America/Dawson` - America/Dawson
       * * `America/Dawson_Creek` - America/Dawson_Creek
       * * `America/Denver` - America/Denver
       * * `America/Detroit` - America/Detroit
       * * `America/Dominica` - America/Dominica
       * * `America/Edmonton` - America/Edmonton
       * * `America/Eirunepe` - America/Eirunepe
       * * `America/El_Salvador` - America/El_Salvador
       * * `America/Fort_Nelson` - America/Fort_Nelson
       * * `America/Fortaleza` - America/Fortaleza
       * * `America/Glace_Bay` - America/Glace_Bay
       * * `America/Goose_Bay` - America/Goose_Bay
       * * `America/Grand_Turk` - America/Grand_Turk
       * * `America/Grenada` - America/Grenada
       * * `America/Guadeloupe` - America/Guadeloupe
       * * `America/Guatemala` - America/Guatemala
       * * `America/Guayaquil` - America/Guayaquil
       * * `America/Guyana` - America/Guyana
       * * `America/Halifax` - America/Halifax
       * * `America/Havana` - America/Havana
       * * `America/Hermosillo` - America/Hermosillo
       * * `America/Indiana/Indianapolis` - America/Indiana/Indianapolis
       * * `America/Indiana/Knox` - America/Indiana/Knox
       * * `America/Indiana/Marengo` - America/Indiana/Marengo
       * * `America/Indiana/Petersburg` - America/Indiana/Petersburg
       * * `America/Indiana/Tell_City` - America/Indiana/Tell_City
       * * `America/Indiana/Vevay` - America/Indiana/Vevay
       * * `America/Indiana/Vincennes` - America/Indiana/Vincennes
       * * `America/Indiana/Winamac` - America/Indiana/Winamac
       * * `America/Inuvik` - America/Inuvik
       * * `America/Iqaluit` - America/Iqaluit
       * * `America/Jamaica` - America/Jamaica
       * * `America/Juneau` - America/Juneau
       * * `America/Kentucky/Louisville` - America/Kentucky/Louisville
       * * `America/Kentucky/Monticello` - America/Kentucky/Monticello
       * * `America/Kralendijk` - America/Kralendijk
       * * `America/La_Paz` - America/La_Paz
       * * `America/Lima` - America/Lima
       * * `America/Los_Angeles` - America/Los_Angeles
       * * `America/Lower_Princes` - America/Lower_Princes
       * * `America/Maceio` - America/Maceio
       * * `America/Managua` - America/Managua
       * * `America/Manaus` - America/Manaus
       * * `America/Marigot` - America/Marigot
       * * `America/Martinique` - America/Martinique
       * * `America/Matamoros` - America/Matamoros
       * * `America/Mazatlan` - America/Mazatlan
       * * `America/Menominee` - America/Menominee
       * * `America/Merida` - America/Merida
       * * `America/Metlakatla` - America/Metlakatla
       * * `America/Mexico_City` - America/Mexico_City
       * * `America/Miquelon` - America/Miquelon
       * * `America/Moncton` - America/Moncton
       * * `America/Monterrey` - America/Monterrey
       * * `America/Montevideo` - America/Montevideo
       * * `America/Montserrat` - America/Montserrat
       * * `America/Nassau` - America/Nassau
       * * `America/New_York` - America/New_York
       * * `America/Nome` - America/Nome
       * * `America/Noronha` - America/Noronha
       * * `America/North_Dakota/Beulah` - America/North_Dakota/Beulah
       * * `America/North_Dakota/Center` - America/North_Dakota/Center
       * * `America/North_Dakota/New_Salem` - America/North_Dakota/New_Salem
       * * `America/Nuuk` - America/Nuuk
       * * `America/Ojinaga` - America/Ojinaga
       * * `America/Panama` - America/Panama
       * * `America/Paramaribo` - America/Paramaribo
       * * `America/Phoenix` - America/Phoenix
       * * `America/Port-au-Prince` - America/Port-au-Prince
       * * `America/Port_of_Spain` - America/Port_of_Spain
       * * `America/Porto_Velho` - America/Porto_Velho
       * * `America/Puerto_Rico` - America/Puerto_Rico
       * * `America/Punta_Arenas` - America/Punta_Arenas
       * * `America/Rankin_Inlet` - America/Rankin_Inlet
       * * `America/Recife` - America/Recife
       * * `America/Regina` - America/Regina
       * * `America/Resolute` - America/Resolute
       * * `America/Rio_Branco` - America/Rio_Branco
       * * `America/Santarem` - America/Santarem
       * * `America/Santiago` - America/Santiago
       * * `America/Santo_Domingo` - America/Santo_Domingo
       * * `America/Sao_Paulo` - America/Sao_Paulo
       * * `America/Scoresbysund` - America/Scoresbysund
       * * `America/Sitka` - America/Sitka
       * * `America/St_Barthelemy` - America/St_Barthelemy
       * * `America/St_Johns` - America/St_Johns
       * * `America/St_Kitts` - America/St_Kitts
       * * `America/St_Lucia` - America/St_Lucia
       * * `America/St_Thomas` - America/St_Thomas
       * * `America/St_Vincent` - America/St_Vincent
       * * `America/Swift_Current` - America/Swift_Current
       * * `America/Tegucigalpa` - America/Tegucigalpa
       * * `America/Thule` - America/Thule
       * * `America/Tijuana` - America/Tijuana
       * * `America/Toronto` - America/Toronto
       * * `America/Tortola` - America/Tortola
       * * `America/Vancouver` - America/Vancouver
       * * `America/Whitehorse` - America/Whitehorse
       * * `America/Winnipeg` - America/Winnipeg
       * * `America/Yakutat` - America/Yakutat
       * * `America/Yellowknife` - America/Yellowknife
       * * `Antarctica/Casey` - Antarctica/Casey
       * * `Antarctica/Davis` - Antarctica/Davis
       * * `Antarctica/DumontDUrville` - Antarctica/DumontDUrville
       * * `Antarctica/Macquarie` - Antarctica/Macquarie
       * * `Antarctica/Mawson` - Antarctica/Mawson
       * * `Antarctica/McMurdo` - Antarctica/McMurdo
       * * `Antarctica/Palmer` - Antarctica/Palmer
       * * `Antarctica/Rothera` - Antarctica/Rothera
       * * `Antarctica/Syowa` - Antarctica/Syowa
       * * `Antarctica/Troll` - Antarctica/Troll
       * * `Antarctica/Vostok` - Antarctica/Vostok
       * * `Arctic/Longyearbyen` - Arctic/Longyearbyen
       * * `Asia/Aden` - Asia/Aden
       * * `Asia/Almaty` - Asia/Almaty
       * * `Asia/Amman` - Asia/Amman
       * * `Asia/Anadyr` - Asia/Anadyr
       * * `Asia/Aqtau` - Asia/Aqtau
       * * `Asia/Aqtobe` - Asia/Aqtobe
       * * `Asia/Ashgabat` - Asia/Ashgabat
       * * `Asia/Atyrau` - Asia/Atyrau
       * * `Asia/Baghdad` - Asia/Baghdad
       * * `Asia/Bahrain` - Asia/Bahrain
       * * `Asia/Baku` - Asia/Baku
       * * `Asia/Bangkok` - Asia/Bangkok
       * * `Asia/Barnaul` - Asia/Barnaul
       * * `Asia/Beirut` - Asia/Beirut
       * * `Asia/Bishkek` - Asia/Bishkek
       * * `Asia/Brunei` - Asia/Brunei
       * * `Asia/Chita` - Asia/Chita
       * * `Asia/Choibalsan` - Asia/Choibalsan
       * * `Asia/Colombo` - Asia/Colombo
       * * `Asia/Damascus` - Asia/Damascus
       * * `Asia/Dhaka` - Asia/Dhaka
       * * `Asia/Dili` - Asia/Dili
       * * `Asia/Dubai` - Asia/Dubai
       * * `Asia/Dushanbe` - Asia/Dushanbe
       * * `Asia/Famagusta` - Asia/Famagusta
       * * `Asia/Gaza` - Asia/Gaza
       * * `Asia/Hebron` - Asia/Hebron
       * * `Asia/Ho_Chi_Minh` - Asia/Ho_Chi_Minh
       * * `Asia/Hong_Kong` - Asia/Hong_Kong
       * * `Asia/Hovd` - Asia/Hovd
       * * `Asia/Irkutsk` - Asia/Irkutsk
       * * `Asia/Jakarta` - Asia/Jakarta
       * * `Asia/Jayapura` - Asia/Jayapura
       * * `Asia/Jerusalem` - Asia/Jerusalem
       * * `Asia/Kabul` - Asia/Kabul
       * * `Asia/Kamchatka` - Asia/Kamchatka
       * * `Asia/Karachi` - Asia/Karachi
       * * `Asia/Kathmandu` - Asia/Kathmandu
       * * `Asia/Khandyga` - Asia/Khandyga
       * * `Asia/Kolkata` - Asia/Kolkata
       * * `Asia/Krasnoyarsk` - Asia/Krasnoyarsk
       * * `Asia/Kuala_Lumpur` - Asia/Kuala_Lumpur
       * * `Asia/Kuching` - Asia/Kuching
       * * `Asia/Kuwait` - Asia/Kuwait
       * * `Asia/Macau` - Asia/Macau
       * * `Asia/Magadan` - Asia/Magadan
       * * `Asia/Makassar` - Asia/Makassar
       * * `Asia/Manila` - Asia/Manila
       * * `Asia/Muscat` - Asia/Muscat
       * * `Asia/Nicosia` - Asia/Nicosia
       * * `Asia/Novokuznetsk` - Asia/Novokuznetsk
       * * `Asia/Novosibirsk` - Asia/Novosibirsk
       * * `Asia/Omsk` - Asia/Omsk
       * * `Asia/Oral` - Asia/Oral
       * * `Asia/Phnom_Penh` - Asia/Phnom_Penh
       * * `Asia/Pontianak` - Asia/Pontianak
       * * `Asia/Pyongyang` - Asia/Pyongyang
       * * `Asia/Qatar` - Asia/Qatar
       * * `Asia/Qostanay` - Asia/Qostanay
       * * `Asia/Qyzylorda` - Asia/Qyzylorda
       * * `Asia/Riyadh` - Asia/Riyadh
       * * `Asia/Sakhalin` - Asia/Sakhalin
       * * `Asia/Samarkand` - Asia/Samarkand
       * * `Asia/Seoul` - Asia/Seoul
       * * `Asia/Shanghai` - Asia/Shanghai
       * * `Asia/Singapore` - Asia/Singapore
       * * `Asia/Srednekolymsk` - Asia/Srednekolymsk
       * * `Asia/Taipei` - Asia/Taipei
       * * `Asia/Tashkent` - Asia/Tashkent
       * * `Asia/Tbilisi` - Asia/Tbilisi
       * * `Asia/Tehran` - Asia/Tehran
       * * `Asia/Thimphu` - Asia/Thimphu
       * * `Asia/Tokyo` - Asia/Tokyo
       * * `Asia/Tomsk` - Asia/Tomsk
       * * `Asia/Ulaanbaatar` - Asia/Ulaanbaatar
       * * `Asia/Urumqi` - Asia/Urumqi
       * * `Asia/Ust-Nera` - Asia/Ust-Nera
       * * `Asia/Vientiane` - Asia/Vientiane
       * * `Asia/Vladivostok` - Asia/Vladivostok
       * * `Asia/Yakutsk` - Asia/Yakutsk
       * * `Asia/Yangon` - Asia/Yangon
       * * `Asia/Yekaterinburg` - Asia/Yekaterinburg
       * * `Asia/Yerevan` - Asia/Yerevan
       * * `Atlantic/Azores` - Atlantic/Azores
       * * `Atlantic/Bermuda` - Atlantic/Bermuda
       * * `Atlantic/Canary` - Atlantic/Canary
       * * `Atlantic/Cape_Verde` - Atlantic/Cape_Verde
       * * `Atlantic/Faroe` - Atlantic/Faroe
       * * `Atlantic/Madeira` - Atlantic/Madeira
       * * `Atlantic/Reykjavik` - Atlantic/Reykjavik
       * * `Atlantic/South_Georgia` - Atlantic/South_Georgia
       * * `Atlantic/St_Helena` - Atlantic/St_Helena
       * * `Atlantic/Stanley` - Atlantic/Stanley
       * * `Australia/Adelaide` - Australia/Adelaide
       * * `Australia/Brisbane` - Australia/Brisbane
       * * `Australia/Broken_Hill` - Australia/Broken_Hill
       * * `Australia/Darwin` - Australia/Darwin
       * * `Australia/Eucla` - Australia/Eucla
       * * `Australia/Hobart` - Australia/Hobart
       * * `Australia/Lindeman` - Australia/Lindeman
       * * `Australia/Lord_Howe` - Australia/Lord_Howe
       * * `Australia/Melbourne` - Australia/Melbourne
       * * `Australia/Perth` - Australia/Perth
       * * `Australia/Sydney` - Australia/Sydney
       * * `Canada/Atlantic` - Canada/Atlantic
       * * `Canada/Central` - Canada/Central
       * * `Canada/Eastern` - Canada/Eastern
       * * `Canada/Mountain` - Canada/Mountain
       * * `Canada/Newfoundland` - Canada/Newfoundland
       * * `Canada/Pacific` - Canada/Pacific
       * * `Europe/Amsterdam` - Europe/Amsterdam
       * * `Europe/Andorra` - Europe/Andorra
       * * `Europe/Astrakhan` - Europe/Astrakhan
       * * `Europe/Athens` - Europe/Athens
       * * `Europe/Belgrade` - Europe/Belgrade
       * * `Europe/Berlin` - Europe/Berlin
       * * `Europe/Bratislava` - Europe/Bratislava
       * * `Europe/Brussels` - Europe/Brussels
       * * `Europe/Bucharest` - Europe/Bucharest
       * * `Europe/Budapest` - Europe/Budapest
       * * `Europe/Busingen` - Europe/Busingen
       * * `Europe/Chisinau` - Europe/Chisinau
       * * `Europe/Copenhagen` - Europe/Copenhagen
       * * `Europe/Dublin` - Europe/Dublin
       * * `Europe/Gibraltar` - Europe/Gibraltar
       * * `Europe/Guernsey` - Europe/Guernsey
       * * `Europe/Helsinki` - Europe/Helsinki
       * * `Europe/Isle_of_Man` - Europe/Isle_of_Man
       * * `Europe/Istanbul` - Europe/Istanbul
       * * `Europe/Jersey` - Europe/Jersey
       * * `Europe/Kaliningrad` - Europe/Kaliningrad
       * * `Europe/Kirov` - Europe/Kirov
       * * `Europe/Kyiv` - Europe/Kyiv
       * * `Europe/Lisbon` - Europe/Lisbon
       * * `Europe/Ljubljana` - Europe/Ljubljana
       * * `Europe/London` - Europe/London
       * * `Europe/Luxembourg` - Europe/Luxembourg
       * * `Europe/Madrid` - Europe/Madrid
       * * `Europe/Malta` - Europe/Malta
       * * `Europe/Mariehamn` - Europe/Mariehamn
       * * `Europe/Minsk` - Europe/Minsk
       * * `Europe/Monaco` - Europe/Monaco
       * * `Europe/Moscow` - Europe/Moscow
       * * `Europe/Oslo` - Europe/Oslo
       * * `Europe/Paris` - Europe/Paris
       * * `Europe/Podgorica` - Europe/Podgorica
       * * `Europe/Prague` - Europe/Prague
       * * `Europe/Riga` - Europe/Riga
       * * `Europe/Rome` - Europe/Rome
       * * `Europe/Samara` - Europe/Samara
       * * `Europe/San_Marino` - Europe/San_Marino
       * * `Europe/Sarajevo` - Europe/Sarajevo
       * * `Europe/Saratov` - Europe/Saratov
       * * `Europe/Simferopol` - Europe/Simferopol
       * * `Europe/Skopje` - Europe/Skopje
       * * `Europe/Sofia` - Europe/Sofia
       * * `Europe/Stockholm` - Europe/Stockholm
       * * `Europe/Tallinn` - Europe/Tallinn
       * * `Europe/Tirane` - Europe/Tirane
       * * `Europe/Ulyanovsk` - Europe/Ulyanovsk
       * * `Europe/Vaduz` - Europe/Vaduz
       * * `Europe/Vatican` - Europe/Vatican
       * * `Europe/Vienna` - Europe/Vienna
       * * `Europe/Vilnius` - Europe/Vilnius
       * * `Europe/Volgograd` - Europe/Volgograd
       * * `Europe/Warsaw` - Europe/Warsaw
       * * `Europe/Zagreb` - Europe/Zagreb
       * * `Europe/Zurich` - Europe/Zurich
       * * `GMT` - GMT
       * * `Indian/Antananarivo` - Indian/Antananarivo
       * * `Indian/Chagos` - Indian/Chagos
       * * `Indian/Christmas` - Indian/Christmas
       * * `Indian/Cocos` - Indian/Cocos
       * * `Indian/Comoro` - Indian/Comoro
       * * `Indian/Kerguelen` - Indian/Kerguelen
       * * `Indian/Mahe` - Indian/Mahe
       * * `Indian/Maldives` - Indian/Maldives
       * * `Indian/Mauritius` - Indian/Mauritius
       * * `Indian/Mayotte` - Indian/Mayotte
       * * `Indian/Reunion` - Indian/Reunion
       * * `Pacific/Apia` - Pacific/Apia
       * * `Pacific/Auckland` - Pacific/Auckland
       * * `Pacific/Bougainville` - Pacific/Bougainville
       * * `Pacific/Chatham` - Pacific/Chatham
       * * `Pacific/Chuuk` - Pacific/Chuuk
       * * `Pacific/Easter` - Pacific/Easter
       * * `Pacific/Efate` - Pacific/Efate
       * * `Pacific/Fakaofo` - Pacific/Fakaofo
       * * `Pacific/Fiji` - Pacific/Fiji
       * * `Pacific/Funafuti` - Pacific/Funafuti
       * * `Pacific/Galapagos` - Pacific/Galapagos
       * * `Pacific/Gambier` - Pacific/Gambier
       * * `Pacific/Guadalcanal` - Pacific/Guadalcanal
       * * `Pacific/Guam` - Pacific/Guam
       * * `Pacific/Honolulu` - Pacific/Honolulu
       * * `Pacific/Kanton` - Pacific/Kanton
       * * `Pacific/Kiritimati` - Pacific/Kiritimati
       * * `Pacific/Kosrae` - Pacific/Kosrae
       * * `Pacific/Kwajalein` - Pacific/Kwajalein
       * * `Pacific/Majuro` - Pacific/Majuro
       * * `Pacific/Marquesas` - Pacific/Marquesas
       * * `Pacific/Midway` - Pacific/Midway
       * * `Pacific/Nauru` - Pacific/Nauru
       * * `Pacific/Niue` - Pacific/Niue
       * * `Pacific/Norfolk` - Pacific/Norfolk
       * * `Pacific/Noumea` - Pacific/Noumea
       * * `Pacific/Pago_Pago` - Pacific/Pago_Pago
       * * `Pacific/Palau` - Pacific/Palau
       * * `Pacific/Pitcairn` - Pacific/Pitcairn
       * * `Pacific/Pohnpei` - Pacific/Pohnpei
       * * `Pacific/Port_Moresby` - Pacific/Port_Moresby
       * * `Pacific/Rarotonga` - Pacific/Rarotonga
       * * `Pacific/Saipan` - Pacific/Saipan
       * * `Pacific/Tahiti` - Pacific/Tahiti
       * * `Pacific/Tarawa` - Pacific/Tarawa
       * * `Pacific/Tongatapu` - Pacific/Tongatapu
       * * `Pacific/Wake` - Pacific/Wake
       * * `Pacific/Wallis` - Pacific/Wallis
       * * `US/Alaska` - US/Alaska
       * * `US/Arizona` - US/Arizona
       * * `US/Central` - US/Central
       * * `US/Eastern` - US/Eastern
       * * `US/Hawaii` - US/Hawaii
       * * `US/Mountain` - US/Mountain
       * * `US/Pacific` - US/Pacific
       * * `UTC` - UTC 
       * @enum {string}
       */
      timezone: "Africa/Abidjan" | "Africa/Accra" | "Africa/Addis_Ababa" | "Africa/Algiers" | "Africa/Asmara" | "Africa/Bamako" | "Africa/Bangui" | "Africa/Banjul" | "Africa/Bissau" | "Africa/Blantyre" | "Africa/Brazzaville" | "Africa/Bujumbura" | "Africa/Cairo" | "Africa/Casablanca" | "Africa/Ceuta" | "Africa/Conakry" | "Africa/Dakar" | "Africa/Dar_es_Salaam" | "Africa/Djibouti" | "Africa/Douala" | "Africa/El_Aaiun" | "Africa/Freetown" | "Africa/Gaborone" | "Africa/Harare" | "Africa/Johannesburg" | "Africa/Juba" | "Africa/Kampala" | "Africa/Khartoum" | "Africa/Kigali" | "Africa/Kinshasa" | "Africa/Lagos" | "Africa/Libreville" | "Africa/Lome" | "Africa/Luanda" | "Africa/Lubumbashi" | "Africa/Lusaka" | "Africa/Malabo" | "Africa/Maputo" | "Africa/Maseru" | "Africa/Mbabane" | "Africa/Mogadishu" | "Africa/Monrovia" | "Africa/Nairobi" | "Africa/Ndjamena" | "Africa/Niamey" | "Africa/Nouakchott" | "Africa/Ouagadougou" | "Africa/Porto-Novo" | "Africa/Sao_Tome" | "Africa/Tripoli" | "Africa/Tunis" | "Africa/Windhoek" | "America/Adak" | "America/Anchorage" | "America/Anguilla" | "America/Antigua" | "America/Araguaina" | "America/Argentina/Buenos_Aires" | "America/Argentina/Catamarca" | "America/Argentina/Cordoba" | "America/Argentina/Jujuy" | "America/Argentina/La_Rioja" | "America/Argentina/Mendoza" | "America/Argentina/Rio_Gallegos" | "America/Argentina/Salta" | "America/Argentina/San_Juan" | "America/Argentina/San_Luis" | "America/Argentina/Tucuman" | "America/Argentina/Ushuaia" | "America/Aruba" | "America/Asuncion" | "America/Atikokan" | "America/Bahia" | "America/Bahia_Banderas" | "America/Barbados" | "America/Belem" | "America/Belize" | "America/Blanc-Sablon" | "America/Boa_Vista" | "America/Bogota" | "America/Boise" | "America/Cambridge_Bay" | "America/Campo_Grande" | "America/Cancun" | "America/Caracas" | "America/Cayenne" | "America/Cayman" | "America/Chicago" | "America/Chihuahua" | "America/Ciudad_Juarez" | "America/Costa_Rica" | "America/Creston" | "America/Cuiaba" | "America/Curacao" | "America/Danmarkshavn" | "America/Dawson" | "America/Dawson_Creek" | "America/Denver" | "America/Detroit" | "America/Dominica" | "America/Edmonton" | "America/Eirunepe" | "America/El_Salvador" | "America/Fort_Nelson" | "America/Fortaleza" | "America/Glace_Bay" | "America/Goose_Bay" | "America/Grand_Turk" | "America/Grenada" | "America/Guadeloupe" | "America/Guatemala" | "America/Guayaquil" | "America/Guyana" | "America/Halifax" | "America/Havana" | "America/Hermosillo" | "America/Indiana/Indianapolis" | "America/Indiana/Knox" | "America/Indiana/Marengo" | "America/Indiana/Petersburg" | "America/Indiana/Tell_City" | "America/Indiana/Vevay" | "America/Indiana/Vincennes" | "America/Indiana/Winamac" | "America/Inuvik" | "America/Iqaluit" | "America/Jamaica" | "America/Juneau" | "America/Kentucky/Louisville" | "America/Kentucky/Monticello" | "America/Kralendijk" | "America/La_Paz" | "America/Lima" | "America/Los_Angeles" | "America/Lower_Princes" | "America/Maceio" | "America/Managua" | "America/Manaus" | "America/Marigot" | "America/Martinique" | "America/Matamoros" | "America/Mazatlan" | "America/Menominee" | "America/Merida" | "America/Metlakatla" | "America/Mexico_City" | "America/Miquelon" | "America/Moncton" | "America/Monterrey" | "America/Montevideo" | "America/Montserrat" | "America/Nassau" | "America/New_York" | "America/Nome" | "America/Noronha" | "America/North_Dakota/Beulah" | "America/North_Dakota/Center" | "America/North_Dakota/New_Salem" | "America/Nuuk" | "America/Ojinaga" | "America/Panama" | "America/Paramaribo" | "America/Phoenix" | "America/Port-au-Prince" | "America/Port_of_Spain" | "America/Porto_Velho" | "America/Puerto_Rico" | "America/Punta_Arenas" | "America/Rankin_Inlet" | "America/Recife" | "America/Regina" | "America/Resolute" | "America/Rio_Branco" | "America/Santarem" | "America/Santiago" | "America/Santo_Domingo" | "America/Sao_Paulo" | "America/Scoresbysund" | "America/Sitka" | "America/St_Barthelemy" | "America/St_Johns" | "America/St_Kitts" | "America/St_Lucia" | "America/St_Thomas" | "America/St_Vincent" | "America/Swift_Current" | "America/Tegucigalpa" | "America/Thule" | "America/Tijuana" | "America/Toronto" | "America/Tortola" | "America/Vancouver" | "America/Whitehorse" | "America/Winnipeg" | "America/Yakutat" | "America/Yellowknife" | "Antarctica/Casey" | "Antarctica/Davis" | "Antarctica/DumontDUrville" | "Antarctica/Macquarie" | "Antarctica/Mawson" | "Antarctica/McMurdo" | "Antarctica/Palmer" | "Antarctica/Rothera" | "Antarctica/Syowa" | "Antarctica/Troll" | "Antarctica/Vostok" | "Arctic/Longyearbyen" | "Asia/Aden" | "Asia/Almaty" | "Asia/Amman" | "Asia/Anadyr" | "Asia/Aqtau" | "Asia/Aqtobe" | "Asia/Ashgabat" | "Asia/Atyrau" | "Asia/Baghdad" | "Asia/Bahrain" | "Asia/Baku" | "Asia/Bangkok" | "Asia/Barnaul" | "Asia/Beirut" | "Asia/Bishkek" | "Asia/Brunei" | "Asia/Chita" | "Asia/Choibalsan" | "Asia/Colombo" | "Asia/Damascus" | "Asia/Dhaka" | "Asia/Dili" | "Asia/Dubai" | "Asia/Dushanbe" | "Asia/Famagusta" | "Asia/Gaza" | "Asia/Hebron" | "Asia/Ho_Chi_Minh" | "Asia/Hong_Kong" | "Asia/Hovd" | "Asia/Irkutsk" | "Asia/Jakarta" | "Asia/Jayapura" | "Asia/Jerusalem" | "Asia/Kabul" | "Asia/Kamchatka" | "Asia/Karachi" | "Asia/Kathmandu" | "Asia/Khandyga" | "Asia/Kolkata" | "Asia/Krasnoyarsk" | "Asia/Kuala_Lumpur" | "Asia/Kuching" | "Asia/Kuwait" | "Asia/Macau" | "Asia/Magadan" | "Asia/Makassar" | "Asia/Manila" | "Asia/Muscat" | "Asia/Nicosia" | "Asia/Novokuznetsk" | "Asia/Novosibirsk" | "Asia/Omsk" | "Asia/Oral" | "Asia/Phnom_Penh" | "Asia/Pontianak" | "Asia/Pyongyang" | "Asia/Qatar" | "Asia/Qostanay" | "Asia/Qyzylorda" | "Asia/Riyadh" | "Asia/Sakhalin" | "Asia/Samarkand" | "Asia/Seoul" | "Asia/Shanghai" | "Asia/Singapore" | "Asia/Srednekolymsk" | "Asia/Taipei" | "Asia/Tashkent" | "Asia/Tbilisi" | "Asia/Tehran" | "Asia/Thimphu" | "Asia/Tokyo" | "Asia/Tomsk" | "Asia/Ulaanbaatar" | "Asia/Urumqi" | "Asia/Ust-Nera" | "Asia/Vientiane" | "Asia/Vladivostok" | "Asia/Yakutsk" | "Asia/Yangon" | "Asia/Yekaterinburg" | "Asia/Yerevan" | "Atlantic/Azores" | "Atlantic/Bermuda" | "Atlantic/Canary" | "Atlantic/Cape_Verde" | "Atlantic/Faroe" | "Atlantic/Madeira" | "Atlantic/Reykjavik" | "Atlantic/South_Georgia" | "Atlantic/St_Helena" | "Atlantic/Stanley" | "Australia/Adelaide" | "Australia/Brisbane" | "Australia/Broken_Hill" | "Australia/Darwin" | "Australia/Eucla" | "Australia/Hobart" | "Australia/Lindeman" | "Australia/Lord_Howe" | "Australia/Melbourne" | "Australia/Perth" | "Australia/Sydney" | "Canada/Atlantic" | "Canada/Central" | "Canada/Eastern" | "Canada/Mountain" | "Canada/Newfoundland" | "Canada/Pacific" | "Europe/Amsterdam" | "Europe/Andorra" | "Europe/Astrakhan" | "Europe/Athens" | "Europe/Belgrade" | "Europe/Berlin" | "Europe/Bratislava" | "Europe/Brussels" | "Europe/Bucharest" | "Europe/Budapest" | "Europe/Busingen" | "Europe/Chisinau" | "Europe/Copenhagen" | "Europe/Dublin" | "Europe/Gibraltar" | "Europe/Guernsey" | "Europe/Helsinki" | "Europe/Isle_of_Man" | "Europe/Istanbul" | "Europe/Jersey" | "Europe/Kaliningrad" | "Europe/Kirov" | "Europe/Kyiv" | "Europe/Lisbon" | "Europe/Ljubljana" | "Europe/London" | "Europe/Luxembourg" | "Europe/Madrid" | "Europe/Malta" | "Europe/Mariehamn" | "Europe/Minsk" | "Europe/Monaco" | "Europe/Moscow" | "Europe/Oslo" | "Europe/Paris" | "Europe/Podgorica" | "Europe/Prague" | "Europe/Riga" | "Europe/Rome" | "Europe/Samara" | "Europe/San_Marino" | "Europe/Sarajevo" | "Europe/Saratov" | "Europe/Simferopol" | "Europe/Skopje" | "Europe/Sofia" | "Europe/Stockholm" | "Europe/Tallinn" | "Europe/Tirane" | "Europe/Ulyanovsk" | "Europe/Vaduz" | "Europe/Vatican" | "Europe/Vienna" | "Europe/Vilnius" | "Europe/Volgograd" | "Europe/Warsaw" | "Europe/Zagreb" | "Europe/Zurich" | "GMT" | "Indian/Antananarivo" | "Indian/Chagos" | "Indian/Christmas" | "Indian/Cocos" | "Indian/Comoro" | "Indian/Kerguelen" | "Indian/Mahe" | "Indian/Maldives" | "Indian/Mauritius" | "Indian/Mayotte" | "Indian/Reunion" | "Pacific/Apia" | "Pacific/Auckland" | "Pacific/Bougainville" | "Pacific/Chatham" | "Pacific/Chuuk" | "Pacific/Easter" | "Pacific/Efate" | "Pacific/Fakaofo" | "Pacific/Fiji" | "Pacific/Funafuti" | "Pacific/Galapagos" | "Pacific/Gambier" | "Pacific/Guadalcanal" | "Pacific/Guam" | "Pacific/Honolulu" | "Pacific/Kanton" | "Pacific/Kiritimati" | "Pacific/Kosrae" | "Pacific/Kwajalein" | "Pacific/Majuro" | "Pacific/Marquesas" | "Pacific/Midway" | "Pacific/Nauru" | "Pacific/Niue" | "Pacific/Norfolk" | "Pacific/Noumea" | "Pacific/Pago_Pago" | "Pacific/Palau" | "Pacific/Pitcairn" | "Pacific/Pohnpei" | "Pacific/Port_Moresby" | "Pacific/Rarotonga" | "Pacific/Saipan" | "Pacific/Tahiti" | "Pacific/Tarawa" | "Pacific/Tongatapu" | "Pacific/Wake" | "Pacific/Wallis" | "US/Alaska" | "US/Arizona" | "US/Central" | "US/Eastern" | "US/Hawaii" | "US/Mountain" | "US/Pacific" | "UTC";
      stripe_account_id: string | null;
      braintree_merchant_id: string | null;
      tax_providers: readonly ("taxjar" | "lotus" | "netsuite")[];
      crm_integration_allowed: boolean;
    };
    OrganizationCreateRequest: {
      organization_name: string;
      default_currency_code?: string;
      /**
       * @description * `development` - development
       * * `production` - production 
       * @default development 
       * @enum {string}
       */
      organization_type?: "development" | "production";
    };
    OrganizationSetting: {
      setting_id: string;
      /**
       * @description * `generate_customer_after_creating_in_lotus` - Generate in Stripe after Lotus
       * * `gen_cust_in_braintree_after_lotus` - Generate in Braintree after Lotus
       * * `subscription_filter_keys` - Subscription Filter Keys
       * * `payment_grace_period` - Payment Grace Period
       * * `crm_customer_source` - CRM Customer Source 
       * @enum {string}
       */
      setting_name: "generate_customer_after_creating_in_lotus" | "gen_cust_in_braintree_after_lotus" | "subscription_filter_keys" | "payment_grace_period" | "crm_customer_source";
      setting_values: {
        [key: string]: unknown | undefined;
      };
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree
       * * `billing` - Billing
       * * `crm` - CRM 
       * @enum {string}
       */
      setting_group?: "stripe" | "braintree" | "billing" | "crm";
    };
    OrganizationSettingUpdate: {
      setting_values?: {
        [key: string]: unknown | undefined;
      };
    };
    OrganizationUser: {
      /** @description Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only. */
      username: string;
      /** Format: email */
      email: string;
      role: string;
      /**
       * @description * `Active` - Active
       * * `Invited` - Invited 
       * @default Active 
       * @enum {string}
       */
      status?: "Active" | "Invited";
    };
    PaginatedActionList: {
      next?: string | null;
      previous?: string | null;
      results?: (components["schemas"]["Action"])[];
    };
    PaginatedEventDetailList: {
      next?: string | null;
      previous?: string | null;
      results?: (components["schemas"]["EventDetail"])[];
    };
    PatchedAddOnUpdateRequest: {
      addon_name?: string;
      /** Format: date-time */
      active_from?: string;
      /** Format: date-time */
      active_to?: string | null;
    };
    PatchedAddOnVersionUpdateRequest: {
      addon_version_name?: string;
      /** Format: date-time */
      active_from?: string | null;
      /** Format: date-time */
      active_to?: string | null;
    };
    PatchedCustomerUpdateRequest: {
      default_currency_code?: string;
      billing_address?: components["schemas"]["AddressRequest"] | null;
      shipping_address?: components["schemas"]["AddressRequest"] | null;
      /**
       * Format: double 
       * @description Tax rate as percentage. For example, 10.5 for 10.5%
       */
      tax_rate?: number | null;
      /**
       * @description * `Africa/Abidjan` - Africa/Abidjan
       * * `Africa/Accra` - Africa/Accra
       * * `Africa/Addis_Ababa` - Africa/Addis_Ababa
       * * `Africa/Algiers` - Africa/Algiers
       * * `Africa/Asmara` - Africa/Asmara
       * * `Africa/Bamako` - Africa/Bamako
       * * `Africa/Bangui` - Africa/Bangui
       * * `Africa/Banjul` - Africa/Banjul
       * * `Africa/Bissau` - Africa/Bissau
       * * `Africa/Blantyre` - Africa/Blantyre
       * * `Africa/Brazzaville` - Africa/Brazzaville
       * * `Africa/Bujumbura` - Africa/Bujumbura
       * * `Africa/Cairo` - Africa/Cairo
       * * `Africa/Casablanca` - Africa/Casablanca
       * * `Africa/Ceuta` - Africa/Ceuta
       * * `Africa/Conakry` - Africa/Conakry
       * * `Africa/Dakar` - Africa/Dakar
       * * `Africa/Dar_es_Salaam` - Africa/Dar_es_Salaam
       * * `Africa/Djibouti` - Africa/Djibouti
       * * `Africa/Douala` - Africa/Douala
       * * `Africa/El_Aaiun` - Africa/El_Aaiun
       * * `Africa/Freetown` - Africa/Freetown
       * * `Africa/Gaborone` - Africa/Gaborone
       * * `Africa/Harare` - Africa/Harare
       * * `Africa/Johannesburg` - Africa/Johannesburg
       * * `Africa/Juba` - Africa/Juba
       * * `Africa/Kampala` - Africa/Kampala
       * * `Africa/Khartoum` - Africa/Khartoum
       * * `Africa/Kigali` - Africa/Kigali
       * * `Africa/Kinshasa` - Africa/Kinshasa
       * * `Africa/Lagos` - Africa/Lagos
       * * `Africa/Libreville` - Africa/Libreville
       * * `Africa/Lome` - Africa/Lome
       * * `Africa/Luanda` - Africa/Luanda
       * * `Africa/Lubumbashi` - Africa/Lubumbashi
       * * `Africa/Lusaka` - Africa/Lusaka
       * * `Africa/Malabo` - Africa/Malabo
       * * `Africa/Maputo` - Africa/Maputo
       * * `Africa/Maseru` - Africa/Maseru
       * * `Africa/Mbabane` - Africa/Mbabane
       * * `Africa/Mogadishu` - Africa/Mogadishu
       * * `Africa/Monrovia` - Africa/Monrovia
       * * `Africa/Nairobi` - Africa/Nairobi
       * * `Africa/Ndjamena` - Africa/Ndjamena
       * * `Africa/Niamey` - Africa/Niamey
       * * `Africa/Nouakchott` - Africa/Nouakchott
       * * `Africa/Ouagadougou` - Africa/Ouagadougou
       * * `Africa/Porto-Novo` - Africa/Porto-Novo
       * * `Africa/Sao_Tome` - Africa/Sao_Tome
       * * `Africa/Tripoli` - Africa/Tripoli
       * * `Africa/Tunis` - Africa/Tunis
       * * `Africa/Windhoek` - Africa/Windhoek
       * * `America/Adak` - America/Adak
       * * `America/Anchorage` - America/Anchorage
       * * `America/Anguilla` - America/Anguilla
       * * `America/Antigua` - America/Antigua
       * * `America/Araguaina` - America/Araguaina
       * * `America/Argentina/Buenos_Aires` - America/Argentina/Buenos_Aires
       * * `America/Argentina/Catamarca` - America/Argentina/Catamarca
       * * `America/Argentina/Cordoba` - America/Argentina/Cordoba
       * * `America/Argentina/Jujuy` - America/Argentina/Jujuy
       * * `America/Argentina/La_Rioja` - America/Argentina/La_Rioja
       * * `America/Argentina/Mendoza` - America/Argentina/Mendoza
       * * `America/Argentina/Rio_Gallegos` - America/Argentina/Rio_Gallegos
       * * `America/Argentina/Salta` - America/Argentina/Salta
       * * `America/Argentina/San_Juan` - America/Argentina/San_Juan
       * * `America/Argentina/San_Luis` - America/Argentina/San_Luis
       * * `America/Argentina/Tucuman` - America/Argentina/Tucuman
       * * `America/Argentina/Ushuaia` - America/Argentina/Ushuaia
       * * `America/Aruba` - America/Aruba
       * * `America/Asuncion` - America/Asuncion
       * * `America/Atikokan` - America/Atikokan
       * * `America/Bahia` - America/Bahia
       * * `America/Bahia_Banderas` - America/Bahia_Banderas
       * * `America/Barbados` - America/Barbados
       * * `America/Belem` - America/Belem
       * * `America/Belize` - America/Belize
       * * `America/Blanc-Sablon` - America/Blanc-Sablon
       * * `America/Boa_Vista` - America/Boa_Vista
       * * `America/Bogota` - America/Bogota
       * * `America/Boise` - America/Boise
       * * `America/Cambridge_Bay` - America/Cambridge_Bay
       * * `America/Campo_Grande` - America/Campo_Grande
       * * `America/Cancun` - America/Cancun
       * * `America/Caracas` - America/Caracas
       * * `America/Cayenne` - America/Cayenne
       * * `America/Cayman` - America/Cayman
       * * `America/Chicago` - America/Chicago
       * * `America/Chihuahua` - America/Chihuahua
       * * `America/Ciudad_Juarez` - America/Ciudad_Juarez
       * * `America/Costa_Rica` - America/Costa_Rica
       * * `America/Creston` - America/Creston
       * * `America/Cuiaba` - America/Cuiaba
       * * `America/Curacao` - America/Curacao
       * * `America/Danmarkshavn` - America/Danmarkshavn
       * * `America/Dawson` - America/Dawson
       * * `America/Dawson_Creek` - America/Dawson_Creek
       * * `America/Denver` - America/Denver
       * * `America/Detroit` - America/Detroit
       * * `America/Dominica` - America/Dominica
       * * `America/Edmonton` - America/Edmonton
       * * `America/Eirunepe` - America/Eirunepe
       * * `America/El_Salvador` - America/El_Salvador
       * * `America/Fort_Nelson` - America/Fort_Nelson
       * * `America/Fortaleza` - America/Fortaleza
       * * `America/Glace_Bay` - America/Glace_Bay
       * * `America/Goose_Bay` - America/Goose_Bay
       * * `America/Grand_Turk` - America/Grand_Turk
       * * `America/Grenada` - America/Grenada
       * * `America/Guadeloupe` - America/Guadeloupe
       * * `America/Guatemala` - America/Guatemala
       * * `America/Guayaquil` - America/Guayaquil
       * * `America/Guyana` - America/Guyana
       * * `America/Halifax` - America/Halifax
       * * `America/Havana` - America/Havana
       * * `America/Hermosillo` - America/Hermosillo
       * * `America/Indiana/Indianapolis` - America/Indiana/Indianapolis
       * * `America/Indiana/Knox` - America/Indiana/Knox
       * * `America/Indiana/Marengo` - America/Indiana/Marengo
       * * `America/Indiana/Petersburg` - America/Indiana/Petersburg
       * * `America/Indiana/Tell_City` - America/Indiana/Tell_City
       * * `America/Indiana/Vevay` - America/Indiana/Vevay
       * * `America/Indiana/Vincennes` - America/Indiana/Vincennes
       * * `America/Indiana/Winamac` - America/Indiana/Winamac
       * * `America/Inuvik` - America/Inuvik
       * * `America/Iqaluit` - America/Iqaluit
       * * `America/Jamaica` - America/Jamaica
       * * `America/Juneau` - America/Juneau
       * * `America/Kentucky/Louisville` - America/Kentucky/Louisville
       * * `America/Kentucky/Monticello` - America/Kentucky/Monticello
       * * `America/Kralendijk` - America/Kralendijk
       * * `America/La_Paz` - America/La_Paz
       * * `America/Lima` - America/Lima
       * * `America/Los_Angeles` - America/Los_Angeles
       * * `America/Lower_Princes` - America/Lower_Princes
       * * `America/Maceio` - America/Maceio
       * * `America/Managua` - America/Managua
       * * `America/Manaus` - America/Manaus
       * * `America/Marigot` - America/Marigot
       * * `America/Martinique` - America/Martinique
       * * `America/Matamoros` - America/Matamoros
       * * `America/Mazatlan` - America/Mazatlan
       * * `America/Menominee` - America/Menominee
       * * `America/Merida` - America/Merida
       * * `America/Metlakatla` - America/Metlakatla
       * * `America/Mexico_City` - America/Mexico_City
       * * `America/Miquelon` - America/Miquelon
       * * `America/Moncton` - America/Moncton
       * * `America/Monterrey` - America/Monterrey
       * * `America/Montevideo` - America/Montevideo
       * * `America/Montserrat` - America/Montserrat
       * * `America/Nassau` - America/Nassau
       * * `America/New_York` - America/New_York
       * * `America/Nome` - America/Nome
       * * `America/Noronha` - America/Noronha
       * * `America/North_Dakota/Beulah` - America/North_Dakota/Beulah
       * * `America/North_Dakota/Center` - America/North_Dakota/Center
       * * `America/North_Dakota/New_Salem` - America/North_Dakota/New_Salem
       * * `America/Nuuk` - America/Nuuk
       * * `America/Ojinaga` - America/Ojinaga
       * * `America/Panama` - America/Panama
       * * `America/Paramaribo` - America/Paramaribo
       * * `America/Phoenix` - America/Phoenix
       * * `America/Port-au-Prince` - America/Port-au-Prince
       * * `America/Port_of_Spain` - America/Port_of_Spain
       * * `America/Porto_Velho` - America/Porto_Velho
       * * `America/Puerto_Rico` - America/Puerto_Rico
       * * `America/Punta_Arenas` - America/Punta_Arenas
       * * `America/Rankin_Inlet` - America/Rankin_Inlet
       * * `America/Recife` - America/Recife
       * * `America/Regina` - America/Regina
       * * `America/Resolute` - America/Resolute
       * * `America/Rio_Branco` - America/Rio_Branco
       * * `America/Santarem` - America/Santarem
       * * `America/Santiago` - America/Santiago
       * * `America/Santo_Domingo` - America/Santo_Domingo
       * * `America/Sao_Paulo` - America/Sao_Paulo
       * * `America/Scoresbysund` - America/Scoresbysund
       * * `America/Sitka` - America/Sitka
       * * `America/St_Barthelemy` - America/St_Barthelemy
       * * `America/St_Johns` - America/St_Johns
       * * `America/St_Kitts` - America/St_Kitts
       * * `America/St_Lucia` - America/St_Lucia
       * * `America/St_Thomas` - America/St_Thomas
       * * `America/St_Vincent` - America/St_Vincent
       * * `America/Swift_Current` - America/Swift_Current
       * * `America/Tegucigalpa` - America/Tegucigalpa
       * * `America/Thule` - America/Thule
       * * `America/Tijuana` - America/Tijuana
       * * `America/Toronto` - America/Toronto
       * * `America/Tortola` - America/Tortola
       * * `America/Vancouver` - America/Vancouver
       * * `America/Whitehorse` - America/Whitehorse
       * * `America/Winnipeg` - America/Winnipeg
       * * `America/Yakutat` - America/Yakutat
       * * `America/Yellowknife` - America/Yellowknife
       * * `Antarctica/Casey` - Antarctica/Casey
       * * `Antarctica/Davis` - Antarctica/Davis
       * * `Antarctica/DumontDUrville` - Antarctica/DumontDUrville
       * * `Antarctica/Macquarie` - Antarctica/Macquarie
       * * `Antarctica/Mawson` - Antarctica/Mawson
       * * `Antarctica/McMurdo` - Antarctica/McMurdo
       * * `Antarctica/Palmer` - Antarctica/Palmer
       * * `Antarctica/Rothera` - Antarctica/Rothera
       * * `Antarctica/Syowa` - Antarctica/Syowa
       * * `Antarctica/Troll` - Antarctica/Troll
       * * `Antarctica/Vostok` - Antarctica/Vostok
       * * `Arctic/Longyearbyen` - Arctic/Longyearbyen
       * * `Asia/Aden` - Asia/Aden
       * * `Asia/Almaty` - Asia/Almaty
       * * `Asia/Amman` - Asia/Amman
       * * `Asia/Anadyr` - Asia/Anadyr
       * * `Asia/Aqtau` - Asia/Aqtau
       * * `Asia/Aqtobe` - Asia/Aqtobe
       * * `Asia/Ashgabat` - Asia/Ashgabat
       * * `Asia/Atyrau` - Asia/Atyrau
       * * `Asia/Baghdad` - Asia/Baghdad
       * * `Asia/Bahrain` - Asia/Bahrain
       * * `Asia/Baku` - Asia/Baku
       * * `Asia/Bangkok` - Asia/Bangkok
       * * `Asia/Barnaul` - Asia/Barnaul
       * * `Asia/Beirut` - Asia/Beirut
       * * `Asia/Bishkek` - Asia/Bishkek
       * * `Asia/Brunei` - Asia/Brunei
       * * `Asia/Chita` - Asia/Chita
       * * `Asia/Choibalsan` - Asia/Choibalsan
       * * `Asia/Colombo` - Asia/Colombo
       * * `Asia/Damascus` - Asia/Damascus
       * * `Asia/Dhaka` - Asia/Dhaka
       * * `Asia/Dili` - Asia/Dili
       * * `Asia/Dubai` - Asia/Dubai
       * * `Asia/Dushanbe` - Asia/Dushanbe
       * * `Asia/Famagusta` - Asia/Famagusta
       * * `Asia/Gaza` - Asia/Gaza
       * * `Asia/Hebron` - Asia/Hebron
       * * `Asia/Ho_Chi_Minh` - Asia/Ho_Chi_Minh
       * * `Asia/Hong_Kong` - Asia/Hong_Kong
       * * `Asia/Hovd` - Asia/Hovd
       * * `Asia/Irkutsk` - Asia/Irkutsk
       * * `Asia/Jakarta` - Asia/Jakarta
       * * `Asia/Jayapura` - Asia/Jayapura
       * * `Asia/Jerusalem` - Asia/Jerusalem
       * * `Asia/Kabul` - Asia/Kabul
       * * `Asia/Kamchatka` - Asia/Kamchatka
       * * `Asia/Karachi` - Asia/Karachi
       * * `Asia/Kathmandu` - Asia/Kathmandu
       * * `Asia/Khandyga` - Asia/Khandyga
       * * `Asia/Kolkata` - Asia/Kolkata
       * * `Asia/Krasnoyarsk` - Asia/Krasnoyarsk
       * * `Asia/Kuala_Lumpur` - Asia/Kuala_Lumpur
       * * `Asia/Kuching` - Asia/Kuching
       * * `Asia/Kuwait` - Asia/Kuwait
       * * `Asia/Macau` - Asia/Macau
       * * `Asia/Magadan` - Asia/Magadan
       * * `Asia/Makassar` - Asia/Makassar
       * * `Asia/Manila` - Asia/Manila
       * * `Asia/Muscat` - Asia/Muscat
       * * `Asia/Nicosia` - Asia/Nicosia
       * * `Asia/Novokuznetsk` - Asia/Novokuznetsk
       * * `Asia/Novosibirsk` - Asia/Novosibirsk
       * * `Asia/Omsk` - Asia/Omsk
       * * `Asia/Oral` - Asia/Oral
       * * `Asia/Phnom_Penh` - Asia/Phnom_Penh
       * * `Asia/Pontianak` - Asia/Pontianak
       * * `Asia/Pyongyang` - Asia/Pyongyang
       * * `Asia/Qatar` - Asia/Qatar
       * * `Asia/Qostanay` - Asia/Qostanay
       * * `Asia/Qyzylorda` - Asia/Qyzylorda
       * * `Asia/Riyadh` - Asia/Riyadh
       * * `Asia/Sakhalin` - Asia/Sakhalin
       * * `Asia/Samarkand` - Asia/Samarkand
       * * `Asia/Seoul` - Asia/Seoul
       * * `Asia/Shanghai` - Asia/Shanghai
       * * `Asia/Singapore` - Asia/Singapore
       * * `Asia/Srednekolymsk` - Asia/Srednekolymsk
       * * `Asia/Taipei` - Asia/Taipei
       * * `Asia/Tashkent` - Asia/Tashkent
       * * `Asia/Tbilisi` - Asia/Tbilisi
       * * `Asia/Tehran` - Asia/Tehran
       * * `Asia/Thimphu` - Asia/Thimphu
       * * `Asia/Tokyo` - Asia/Tokyo
       * * `Asia/Tomsk` - Asia/Tomsk
       * * `Asia/Ulaanbaatar` - Asia/Ulaanbaatar
       * * `Asia/Urumqi` - Asia/Urumqi
       * * `Asia/Ust-Nera` - Asia/Ust-Nera
       * * `Asia/Vientiane` - Asia/Vientiane
       * * `Asia/Vladivostok` - Asia/Vladivostok
       * * `Asia/Yakutsk` - Asia/Yakutsk
       * * `Asia/Yangon` - Asia/Yangon
       * * `Asia/Yekaterinburg` - Asia/Yekaterinburg
       * * `Asia/Yerevan` - Asia/Yerevan
       * * `Atlantic/Azores` - Atlantic/Azores
       * * `Atlantic/Bermuda` - Atlantic/Bermuda
       * * `Atlantic/Canary` - Atlantic/Canary
       * * `Atlantic/Cape_Verde` - Atlantic/Cape_Verde
       * * `Atlantic/Faroe` - Atlantic/Faroe
       * * `Atlantic/Madeira` - Atlantic/Madeira
       * * `Atlantic/Reykjavik` - Atlantic/Reykjavik
       * * `Atlantic/South_Georgia` - Atlantic/South_Georgia
       * * `Atlantic/St_Helena` - Atlantic/St_Helena
       * * `Atlantic/Stanley` - Atlantic/Stanley
       * * `Australia/Adelaide` - Australia/Adelaide
       * * `Australia/Brisbane` - Australia/Brisbane
       * * `Australia/Broken_Hill` - Australia/Broken_Hill
       * * `Australia/Darwin` - Australia/Darwin
       * * `Australia/Eucla` - Australia/Eucla
       * * `Australia/Hobart` - Australia/Hobart
       * * `Australia/Lindeman` - Australia/Lindeman
       * * `Australia/Lord_Howe` - Australia/Lord_Howe
       * * `Australia/Melbourne` - Australia/Melbourne
       * * `Australia/Perth` - Australia/Perth
       * * `Australia/Sydney` - Australia/Sydney
       * * `Canada/Atlantic` - Canada/Atlantic
       * * `Canada/Central` - Canada/Central
       * * `Canada/Eastern` - Canada/Eastern
       * * `Canada/Mountain` - Canada/Mountain
       * * `Canada/Newfoundland` - Canada/Newfoundland
       * * `Canada/Pacific` - Canada/Pacific
       * * `Europe/Amsterdam` - Europe/Amsterdam
       * * `Europe/Andorra` - Europe/Andorra
       * * `Europe/Astrakhan` - Europe/Astrakhan
       * * `Europe/Athens` - Europe/Athens
       * * `Europe/Belgrade` - Europe/Belgrade
       * * `Europe/Berlin` - Europe/Berlin
       * * `Europe/Bratislava` - Europe/Bratislava
       * * `Europe/Brussels` - Europe/Brussels
       * * `Europe/Bucharest` - Europe/Bucharest
       * * `Europe/Budapest` - Europe/Budapest
       * * `Europe/Busingen` - Europe/Busingen
       * * `Europe/Chisinau` - Europe/Chisinau
       * * `Europe/Copenhagen` - Europe/Copenhagen
       * * `Europe/Dublin` - Europe/Dublin
       * * `Europe/Gibraltar` - Europe/Gibraltar
       * * `Europe/Guernsey` - Europe/Guernsey
       * * `Europe/Helsinki` - Europe/Helsinki
       * * `Europe/Isle_of_Man` - Europe/Isle_of_Man
       * * `Europe/Istanbul` - Europe/Istanbul
       * * `Europe/Jersey` - Europe/Jersey
       * * `Europe/Kaliningrad` - Europe/Kaliningrad
       * * `Europe/Kirov` - Europe/Kirov
       * * `Europe/Kyiv` - Europe/Kyiv
       * * `Europe/Lisbon` - Europe/Lisbon
       * * `Europe/Ljubljana` - Europe/Ljubljana
       * * `Europe/London` - Europe/London
       * * `Europe/Luxembourg` - Europe/Luxembourg
       * * `Europe/Madrid` - Europe/Madrid
       * * `Europe/Malta` - Europe/Malta
       * * `Europe/Mariehamn` - Europe/Mariehamn
       * * `Europe/Minsk` - Europe/Minsk
       * * `Europe/Monaco` - Europe/Monaco
       * * `Europe/Moscow` - Europe/Moscow
       * * `Europe/Oslo` - Europe/Oslo
       * * `Europe/Paris` - Europe/Paris
       * * `Europe/Podgorica` - Europe/Podgorica
       * * `Europe/Prague` - Europe/Prague
       * * `Europe/Riga` - Europe/Riga
       * * `Europe/Rome` - Europe/Rome
       * * `Europe/Samara` - Europe/Samara
       * * `Europe/San_Marino` - Europe/San_Marino
       * * `Europe/Sarajevo` - Europe/Sarajevo
       * * `Europe/Saratov` - Europe/Saratov
       * * `Europe/Simferopol` - Europe/Simferopol
       * * `Europe/Skopje` - Europe/Skopje
       * * `Europe/Sofia` - Europe/Sofia
       * * `Europe/Stockholm` - Europe/Stockholm
       * * `Europe/Tallinn` - Europe/Tallinn
       * * `Europe/Tirane` - Europe/Tirane
       * * `Europe/Ulyanovsk` - Europe/Ulyanovsk
       * * `Europe/Vaduz` - Europe/Vaduz
       * * `Europe/Vatican` - Europe/Vatican
       * * `Europe/Vienna` - Europe/Vienna
       * * `Europe/Vilnius` - Europe/Vilnius
       * * `Europe/Volgograd` - Europe/Volgograd
       * * `Europe/Warsaw` - Europe/Warsaw
       * * `Europe/Zagreb` - Europe/Zagreb
       * * `Europe/Zurich` - Europe/Zurich
       * * `GMT` - GMT
       * * `Indian/Antananarivo` - Indian/Antananarivo
       * * `Indian/Chagos` - Indian/Chagos
       * * `Indian/Christmas` - Indian/Christmas
       * * `Indian/Cocos` - Indian/Cocos
       * * `Indian/Comoro` - Indian/Comoro
       * * `Indian/Kerguelen` - Indian/Kerguelen
       * * `Indian/Mahe` - Indian/Mahe
       * * `Indian/Maldives` - Indian/Maldives
       * * `Indian/Mauritius` - Indian/Mauritius
       * * `Indian/Mayotte` - Indian/Mayotte
       * * `Indian/Reunion` - Indian/Reunion
       * * `Pacific/Apia` - Pacific/Apia
       * * `Pacific/Auckland` - Pacific/Auckland
       * * `Pacific/Bougainville` - Pacific/Bougainville
       * * `Pacific/Chatham` - Pacific/Chatham
       * * `Pacific/Chuuk` - Pacific/Chuuk
       * * `Pacific/Easter` - Pacific/Easter
       * * `Pacific/Efate` - Pacific/Efate
       * * `Pacific/Fakaofo` - Pacific/Fakaofo
       * * `Pacific/Fiji` - Pacific/Fiji
       * * `Pacific/Funafuti` - Pacific/Funafuti
       * * `Pacific/Galapagos` - Pacific/Galapagos
       * * `Pacific/Gambier` - Pacific/Gambier
       * * `Pacific/Guadalcanal` - Pacific/Guadalcanal
       * * `Pacific/Guam` - Pacific/Guam
       * * `Pacific/Honolulu` - Pacific/Honolulu
       * * `Pacific/Kanton` - Pacific/Kanton
       * * `Pacific/Kiritimati` - Pacific/Kiritimati
       * * `Pacific/Kosrae` - Pacific/Kosrae
       * * `Pacific/Kwajalein` - Pacific/Kwajalein
       * * `Pacific/Majuro` - Pacific/Majuro
       * * `Pacific/Marquesas` - Pacific/Marquesas
       * * `Pacific/Midway` - Pacific/Midway
       * * `Pacific/Nauru` - Pacific/Nauru
       * * `Pacific/Niue` - Pacific/Niue
       * * `Pacific/Norfolk` - Pacific/Norfolk
       * * `Pacific/Noumea` - Pacific/Noumea
       * * `Pacific/Pago_Pago` - Pacific/Pago_Pago
       * * `Pacific/Palau` - Pacific/Palau
       * * `Pacific/Pitcairn` - Pacific/Pitcairn
       * * `Pacific/Pohnpei` - Pacific/Pohnpei
       * * `Pacific/Port_Moresby` - Pacific/Port_Moresby
       * * `Pacific/Rarotonga` - Pacific/Rarotonga
       * * `Pacific/Saipan` - Pacific/Saipan
       * * `Pacific/Tahiti` - Pacific/Tahiti
       * * `Pacific/Tarawa` - Pacific/Tarawa
       * * `Pacific/Tongatapu` - Pacific/Tongatapu
       * * `Pacific/Wake` - Pacific/Wake
       * * `Pacific/Wallis` - Pacific/Wallis
       * * `US/Alaska` - US/Alaska
       * * `US/Arizona` - US/Arizona
       * * `US/Central` - US/Central
       * * `US/Eastern` - US/Eastern
       * * `US/Hawaii` - US/Hawaii
       * * `US/Mountain` - US/Mountain
       * * `US/Pacific` - US/Pacific
       * * `UTC` - UTC 
       * @enum {string}
       */
      timezone?: "Africa/Abidjan" | "Africa/Accra" | "Africa/Addis_Ababa" | "Africa/Algiers" | "Africa/Asmara" | "Africa/Bamako" | "Africa/Bangui" | "Africa/Banjul" | "Africa/Bissau" | "Africa/Blantyre" | "Africa/Brazzaville" | "Africa/Bujumbura" | "Africa/Cairo" | "Africa/Casablanca" | "Africa/Ceuta" | "Africa/Conakry" | "Africa/Dakar" | "Africa/Dar_es_Salaam" | "Africa/Djibouti" | "Africa/Douala" | "Africa/El_Aaiun" | "Africa/Freetown" | "Africa/Gaborone" | "Africa/Harare" | "Africa/Johannesburg" | "Africa/Juba" | "Africa/Kampala" | "Africa/Khartoum" | "Africa/Kigali" | "Africa/Kinshasa" | "Africa/Lagos" | "Africa/Libreville" | "Africa/Lome" | "Africa/Luanda" | "Africa/Lubumbashi" | "Africa/Lusaka" | "Africa/Malabo" | "Africa/Maputo" | "Africa/Maseru" | "Africa/Mbabane" | "Africa/Mogadishu" | "Africa/Monrovia" | "Africa/Nairobi" | "Africa/Ndjamena" | "Africa/Niamey" | "Africa/Nouakchott" | "Africa/Ouagadougou" | "Africa/Porto-Novo" | "Africa/Sao_Tome" | "Africa/Tripoli" | "Africa/Tunis" | "Africa/Windhoek" | "America/Adak" | "America/Anchorage" | "America/Anguilla" | "America/Antigua" | "America/Araguaina" | "America/Argentina/Buenos_Aires" | "America/Argentina/Catamarca" | "America/Argentina/Cordoba" | "America/Argentina/Jujuy" | "America/Argentina/La_Rioja" | "America/Argentina/Mendoza" | "America/Argentina/Rio_Gallegos" | "America/Argentina/Salta" | "America/Argentina/San_Juan" | "America/Argentina/San_Luis" | "America/Argentina/Tucuman" | "America/Argentina/Ushuaia" | "America/Aruba" | "America/Asuncion" | "America/Atikokan" | "America/Bahia" | "America/Bahia_Banderas" | "America/Barbados" | "America/Belem" | "America/Belize" | "America/Blanc-Sablon" | "America/Boa_Vista" | "America/Bogota" | "America/Boise" | "America/Cambridge_Bay" | "America/Campo_Grande" | "America/Cancun" | "America/Caracas" | "America/Cayenne" | "America/Cayman" | "America/Chicago" | "America/Chihuahua" | "America/Ciudad_Juarez" | "America/Costa_Rica" | "America/Creston" | "America/Cuiaba" | "America/Curacao" | "America/Danmarkshavn" | "America/Dawson" | "America/Dawson_Creek" | "America/Denver" | "America/Detroit" | "America/Dominica" | "America/Edmonton" | "America/Eirunepe" | "America/El_Salvador" | "America/Fort_Nelson" | "America/Fortaleza" | "America/Glace_Bay" | "America/Goose_Bay" | "America/Grand_Turk" | "America/Grenada" | "America/Guadeloupe" | "America/Guatemala" | "America/Guayaquil" | "America/Guyana" | "America/Halifax" | "America/Havana" | "America/Hermosillo" | "America/Indiana/Indianapolis" | "America/Indiana/Knox" | "America/Indiana/Marengo" | "America/Indiana/Petersburg" | "America/Indiana/Tell_City" | "America/Indiana/Vevay" | "America/Indiana/Vincennes" | "America/Indiana/Winamac" | "America/Inuvik" | "America/Iqaluit" | "America/Jamaica" | "America/Juneau" | "America/Kentucky/Louisville" | "America/Kentucky/Monticello" | "America/Kralendijk" | "America/La_Paz" | "America/Lima" | "America/Los_Angeles" | "America/Lower_Princes" | "America/Maceio" | "America/Managua" | "America/Manaus" | "America/Marigot" | "America/Martinique" | "America/Matamoros" | "America/Mazatlan" | "America/Menominee" | "America/Merida" | "America/Metlakatla" | "America/Mexico_City" | "America/Miquelon" | "America/Moncton" | "America/Monterrey" | "America/Montevideo" | "America/Montserrat" | "America/Nassau" | "America/New_York" | "America/Nome" | "America/Noronha" | "America/North_Dakota/Beulah" | "America/North_Dakota/Center" | "America/North_Dakota/New_Salem" | "America/Nuuk" | "America/Ojinaga" | "America/Panama" | "America/Paramaribo" | "America/Phoenix" | "America/Port-au-Prince" | "America/Port_of_Spain" | "America/Porto_Velho" | "America/Puerto_Rico" | "America/Punta_Arenas" | "America/Rankin_Inlet" | "America/Recife" | "America/Regina" | "America/Resolute" | "America/Rio_Branco" | "America/Santarem" | "America/Santiago" | "America/Santo_Domingo" | "America/Sao_Paulo" | "America/Scoresbysund" | "America/Sitka" | "America/St_Barthelemy" | "America/St_Johns" | "America/St_Kitts" | "America/St_Lucia" | "America/St_Thomas" | "America/St_Vincent" | "America/Swift_Current" | "America/Tegucigalpa" | "America/Thule" | "America/Tijuana" | "America/Toronto" | "America/Tortola" | "America/Vancouver" | "America/Whitehorse" | "America/Winnipeg" | "America/Yakutat" | "America/Yellowknife" | "Antarctica/Casey" | "Antarctica/Davis" | "Antarctica/DumontDUrville" | "Antarctica/Macquarie" | "Antarctica/Mawson" | "Antarctica/McMurdo" | "Antarctica/Palmer" | "Antarctica/Rothera" | "Antarctica/Syowa" | "Antarctica/Troll" | "Antarctica/Vostok" | "Arctic/Longyearbyen" | "Asia/Aden" | "Asia/Almaty" | "Asia/Amman" | "Asia/Anadyr" | "Asia/Aqtau" | "Asia/Aqtobe" | "Asia/Ashgabat" | "Asia/Atyrau" | "Asia/Baghdad" | "Asia/Bahrain" | "Asia/Baku" | "Asia/Bangkok" | "Asia/Barnaul" | "Asia/Beirut" | "Asia/Bishkek" | "Asia/Brunei" | "Asia/Chita" | "Asia/Choibalsan" | "Asia/Colombo" | "Asia/Damascus" | "Asia/Dhaka" | "Asia/Dili" | "Asia/Dubai" | "Asia/Dushanbe" | "Asia/Famagusta" | "Asia/Gaza" | "Asia/Hebron" | "Asia/Ho_Chi_Minh" | "Asia/Hong_Kong" | "Asia/Hovd" | "Asia/Irkutsk" | "Asia/Jakarta" | "Asia/Jayapura" | "Asia/Jerusalem" | "Asia/Kabul" | "Asia/Kamchatka" | "Asia/Karachi" | "Asia/Kathmandu" | "Asia/Khandyga" | "Asia/Kolkata" | "Asia/Krasnoyarsk" | "Asia/Kuala_Lumpur" | "Asia/Kuching" | "Asia/Kuwait" | "Asia/Macau" | "Asia/Magadan" | "Asia/Makassar" | "Asia/Manila" | "Asia/Muscat" | "Asia/Nicosia" | "Asia/Novokuznetsk" | "Asia/Novosibirsk" | "Asia/Omsk" | "Asia/Oral" | "Asia/Phnom_Penh" | "Asia/Pontianak" | "Asia/Pyongyang" | "Asia/Qatar" | "Asia/Qostanay" | "Asia/Qyzylorda" | "Asia/Riyadh" | "Asia/Sakhalin" | "Asia/Samarkand" | "Asia/Seoul" | "Asia/Shanghai" | "Asia/Singapore" | "Asia/Srednekolymsk" | "Asia/Taipei" | "Asia/Tashkent" | "Asia/Tbilisi" | "Asia/Tehran" | "Asia/Thimphu" | "Asia/Tokyo" | "Asia/Tomsk" | "Asia/Ulaanbaatar" | "Asia/Urumqi" | "Asia/Ust-Nera" | "Asia/Vientiane" | "Asia/Vladivostok" | "Asia/Yakutsk" | "Asia/Yangon" | "Asia/Yekaterinburg" | "Asia/Yerevan" | "Atlantic/Azores" | "Atlantic/Bermuda" | "Atlantic/Canary" | "Atlantic/Cape_Verde" | "Atlantic/Faroe" | "Atlantic/Madeira" | "Atlantic/Reykjavik" | "Atlantic/South_Georgia" | "Atlantic/St_Helena" | "Atlantic/Stanley" | "Australia/Adelaide" | "Australia/Brisbane" | "Australia/Broken_Hill" | "Australia/Darwin" | "Australia/Eucla" | "Australia/Hobart" | "Australia/Lindeman" | "Australia/Lord_Howe" | "Australia/Melbourne" | "Australia/Perth" | "Australia/Sydney" | "Canada/Atlantic" | "Canada/Central" | "Canada/Eastern" | "Canada/Mountain" | "Canada/Newfoundland" | "Canada/Pacific" | "Europe/Amsterdam" | "Europe/Andorra" | "Europe/Astrakhan" | "Europe/Athens" | "Europe/Belgrade" | "Europe/Berlin" | "Europe/Bratislava" | "Europe/Brussels" | "Europe/Bucharest" | "Europe/Budapest" | "Europe/Busingen" | "Europe/Chisinau" | "Europe/Copenhagen" | "Europe/Dublin" | "Europe/Gibraltar" | "Europe/Guernsey" | "Europe/Helsinki" | "Europe/Isle_of_Man" | "Europe/Istanbul" | "Europe/Jersey" | "Europe/Kaliningrad" | "Europe/Kirov" | "Europe/Kyiv" | "Europe/Lisbon" | "Europe/Ljubljana" | "Europe/London" | "Europe/Luxembourg" | "Europe/Madrid" | "Europe/Malta" | "Europe/Mariehamn" | "Europe/Minsk" | "Europe/Monaco" | "Europe/Moscow" | "Europe/Oslo" | "Europe/Paris" | "Europe/Podgorica" | "Europe/Prague" | "Europe/Riga" | "Europe/Rome" | "Europe/Samara" | "Europe/San_Marino" | "Europe/Sarajevo" | "Europe/Saratov" | "Europe/Simferopol" | "Europe/Skopje" | "Europe/Sofia" | "Europe/Stockholm" | "Europe/Tallinn" | "Europe/Tirane" | "Europe/Ulyanovsk" | "Europe/Vaduz" | "Europe/Vatican" | "Europe/Vienna" | "Europe/Vilnius" | "Europe/Volgograd" | "Europe/Warsaw" | "Europe/Zagreb" | "Europe/Zurich" | "GMT" | "Indian/Antananarivo" | "Indian/Chagos" | "Indian/Christmas" | "Indian/Cocos" | "Indian/Comoro" | "Indian/Kerguelen" | "Indian/Mahe" | "Indian/Maldives" | "Indian/Mauritius" | "Indian/Mayotte" | "Indian/Reunion" | "Pacific/Apia" | "Pacific/Auckland" | "Pacific/Bougainville" | "Pacific/Chatham" | "Pacific/Chuuk" | "Pacific/Easter" | "Pacific/Efate" | "Pacific/Fakaofo" | "Pacific/Fiji" | "Pacific/Funafuti" | "Pacific/Galapagos" | "Pacific/Gambier" | "Pacific/Guadalcanal" | "Pacific/Guam" | "Pacific/Honolulu" | "Pacific/Kanton" | "Pacific/Kiritimati" | "Pacific/Kosrae" | "Pacific/Kwajalein" | "Pacific/Majuro" | "Pacific/Marquesas" | "Pacific/Midway" | "Pacific/Nauru" | "Pacific/Niue" | "Pacific/Norfolk" | "Pacific/Noumea" | "Pacific/Pago_Pago" | "Pacific/Palau" | "Pacific/Pitcairn" | "Pacific/Pohnpei" | "Pacific/Port_Moresby" | "Pacific/Rarotonga" | "Pacific/Saipan" | "Pacific/Tahiti" | "Pacific/Tarawa" | "Pacific/Tongatapu" | "Pacific/Wake" | "Pacific/Wallis" | "US/Alaska" | "US/Arizona" | "US/Central" | "US/Eastern" | "US/Hawaii" | "US/Mountain" | "US/Pacific" | "UTC";
      customer_name?: string;
    };
    PatchedInvoiceUpdateRequest: {
      /**
       * @description * `paid` - paid
       * * `unpaid` - unpaid 
       * @enum {string}
       */
      payment_status?: "paid" | "unpaid";
    };
    PatchedMetricUpdateRequest: {
      billable_metric_name?: string | null;
      /**
       * @description * `active` - Active
       * * `archived` - Archived 
       * @enum {string}
       */
      status?: "active" | "archived";
    };
    PatchedOrganizationSettingUpdateRequest: {
      setting_values?: {
        [key: string]: unknown | undefined;
      };
    };
    PatchedOrganizationUpdateRequest: {
      default_currency_code?: string;
      address?: components["schemas"]["AddressRequest"] | null;
      /**
       * Format: double 
       * @description Tax rate as percentage. For example, 10.5 for 10.5%
       */
      tax_rate?: number | null;
      payment_grace_period?: number | null;
      plan_tags?: (components["schemas"]["TagRequest"])[];
      subscription_filter_keys?: (string)[];
      /**
       * @description * `Africa/Abidjan` - Africa/Abidjan
       * * `Africa/Accra` - Africa/Accra
       * * `Africa/Addis_Ababa` - Africa/Addis_Ababa
       * * `Africa/Algiers` - Africa/Algiers
       * * `Africa/Asmara` - Africa/Asmara
       * * `Africa/Bamako` - Africa/Bamako
       * * `Africa/Bangui` - Africa/Bangui
       * * `Africa/Banjul` - Africa/Banjul
       * * `Africa/Bissau` - Africa/Bissau
       * * `Africa/Blantyre` - Africa/Blantyre
       * * `Africa/Brazzaville` - Africa/Brazzaville
       * * `Africa/Bujumbura` - Africa/Bujumbura
       * * `Africa/Cairo` - Africa/Cairo
       * * `Africa/Casablanca` - Africa/Casablanca
       * * `Africa/Ceuta` - Africa/Ceuta
       * * `Africa/Conakry` - Africa/Conakry
       * * `Africa/Dakar` - Africa/Dakar
       * * `Africa/Dar_es_Salaam` - Africa/Dar_es_Salaam
       * * `Africa/Djibouti` - Africa/Djibouti
       * * `Africa/Douala` - Africa/Douala
       * * `Africa/El_Aaiun` - Africa/El_Aaiun
       * * `Africa/Freetown` - Africa/Freetown
       * * `Africa/Gaborone` - Africa/Gaborone
       * * `Africa/Harare` - Africa/Harare
       * * `Africa/Johannesburg` - Africa/Johannesburg
       * * `Africa/Juba` - Africa/Juba
       * * `Africa/Kampala` - Africa/Kampala
       * * `Africa/Khartoum` - Africa/Khartoum
       * * `Africa/Kigali` - Africa/Kigali
       * * `Africa/Kinshasa` - Africa/Kinshasa
       * * `Africa/Lagos` - Africa/Lagos
       * * `Africa/Libreville` - Africa/Libreville
       * * `Africa/Lome` - Africa/Lome
       * * `Africa/Luanda` - Africa/Luanda
       * * `Africa/Lubumbashi` - Africa/Lubumbashi
       * * `Africa/Lusaka` - Africa/Lusaka
       * * `Africa/Malabo` - Africa/Malabo
       * * `Africa/Maputo` - Africa/Maputo
       * * `Africa/Maseru` - Africa/Maseru
       * * `Africa/Mbabane` - Africa/Mbabane
       * * `Africa/Mogadishu` - Africa/Mogadishu
       * * `Africa/Monrovia` - Africa/Monrovia
       * * `Africa/Nairobi` - Africa/Nairobi
       * * `Africa/Ndjamena` - Africa/Ndjamena
       * * `Africa/Niamey` - Africa/Niamey
       * * `Africa/Nouakchott` - Africa/Nouakchott
       * * `Africa/Ouagadougou` - Africa/Ouagadougou
       * * `Africa/Porto-Novo` - Africa/Porto-Novo
       * * `Africa/Sao_Tome` - Africa/Sao_Tome
       * * `Africa/Tripoli` - Africa/Tripoli
       * * `Africa/Tunis` - Africa/Tunis
       * * `Africa/Windhoek` - Africa/Windhoek
       * * `America/Adak` - America/Adak
       * * `America/Anchorage` - America/Anchorage
       * * `America/Anguilla` - America/Anguilla
       * * `America/Antigua` - America/Antigua
       * * `America/Araguaina` - America/Araguaina
       * * `America/Argentina/Buenos_Aires` - America/Argentina/Buenos_Aires
       * * `America/Argentina/Catamarca` - America/Argentina/Catamarca
       * * `America/Argentina/Cordoba` - America/Argentina/Cordoba
       * * `America/Argentina/Jujuy` - America/Argentina/Jujuy
       * * `America/Argentina/La_Rioja` - America/Argentina/La_Rioja
       * * `America/Argentina/Mendoza` - America/Argentina/Mendoza
       * * `America/Argentina/Rio_Gallegos` - America/Argentina/Rio_Gallegos
       * * `America/Argentina/Salta` - America/Argentina/Salta
       * * `America/Argentina/San_Juan` - America/Argentina/San_Juan
       * * `America/Argentina/San_Luis` - America/Argentina/San_Luis
       * * `America/Argentina/Tucuman` - America/Argentina/Tucuman
       * * `America/Argentina/Ushuaia` - America/Argentina/Ushuaia
       * * `America/Aruba` - America/Aruba
       * * `America/Asuncion` - America/Asuncion
       * * `America/Atikokan` - America/Atikokan
       * * `America/Bahia` - America/Bahia
       * * `America/Bahia_Banderas` - America/Bahia_Banderas
       * * `America/Barbados` - America/Barbados
       * * `America/Belem` - America/Belem
       * * `America/Belize` - America/Belize
       * * `America/Blanc-Sablon` - America/Blanc-Sablon
       * * `America/Boa_Vista` - America/Boa_Vista
       * * `America/Bogota` - America/Bogota
       * * `America/Boise` - America/Boise
       * * `America/Cambridge_Bay` - America/Cambridge_Bay
       * * `America/Campo_Grande` - America/Campo_Grande
       * * `America/Cancun` - America/Cancun
       * * `America/Caracas` - America/Caracas
       * * `America/Cayenne` - America/Cayenne
       * * `America/Cayman` - America/Cayman
       * * `America/Chicago` - America/Chicago
       * * `America/Chihuahua` - America/Chihuahua
       * * `America/Ciudad_Juarez` - America/Ciudad_Juarez
       * * `America/Costa_Rica` - America/Costa_Rica
       * * `America/Creston` - America/Creston
       * * `America/Cuiaba` - America/Cuiaba
       * * `America/Curacao` - America/Curacao
       * * `America/Danmarkshavn` - America/Danmarkshavn
       * * `America/Dawson` - America/Dawson
       * * `America/Dawson_Creek` - America/Dawson_Creek
       * * `America/Denver` - America/Denver
       * * `America/Detroit` - America/Detroit
       * * `America/Dominica` - America/Dominica
       * * `America/Edmonton` - America/Edmonton
       * * `America/Eirunepe` - America/Eirunepe
       * * `America/El_Salvador` - America/El_Salvador
       * * `America/Fort_Nelson` - America/Fort_Nelson
       * * `America/Fortaleza` - America/Fortaleza
       * * `America/Glace_Bay` - America/Glace_Bay
       * * `America/Goose_Bay` - America/Goose_Bay
       * * `America/Grand_Turk` - America/Grand_Turk
       * * `America/Grenada` - America/Grenada
       * * `America/Guadeloupe` - America/Guadeloupe
       * * `America/Guatemala` - America/Guatemala
       * * `America/Guayaquil` - America/Guayaquil
       * * `America/Guyana` - America/Guyana
       * * `America/Halifax` - America/Halifax
       * * `America/Havana` - America/Havana
       * * `America/Hermosillo` - America/Hermosillo
       * * `America/Indiana/Indianapolis` - America/Indiana/Indianapolis
       * * `America/Indiana/Knox` - America/Indiana/Knox
       * * `America/Indiana/Marengo` - America/Indiana/Marengo
       * * `America/Indiana/Petersburg` - America/Indiana/Petersburg
       * * `America/Indiana/Tell_City` - America/Indiana/Tell_City
       * * `America/Indiana/Vevay` - America/Indiana/Vevay
       * * `America/Indiana/Vincennes` - America/Indiana/Vincennes
       * * `America/Indiana/Winamac` - America/Indiana/Winamac
       * * `America/Inuvik` - America/Inuvik
       * * `America/Iqaluit` - America/Iqaluit
       * * `America/Jamaica` - America/Jamaica
       * * `America/Juneau` - America/Juneau
       * * `America/Kentucky/Louisville` - America/Kentucky/Louisville
       * * `America/Kentucky/Monticello` - America/Kentucky/Monticello
       * * `America/Kralendijk` - America/Kralendijk
       * * `America/La_Paz` - America/La_Paz
       * * `America/Lima` - America/Lima
       * * `America/Los_Angeles` - America/Los_Angeles
       * * `America/Lower_Princes` - America/Lower_Princes
       * * `America/Maceio` - America/Maceio
       * * `America/Managua` - America/Managua
       * * `America/Manaus` - America/Manaus
       * * `America/Marigot` - America/Marigot
       * * `America/Martinique` - America/Martinique
       * * `America/Matamoros` - America/Matamoros
       * * `America/Mazatlan` - America/Mazatlan
       * * `America/Menominee` - America/Menominee
       * * `America/Merida` - America/Merida
       * * `America/Metlakatla` - America/Metlakatla
       * * `America/Mexico_City` - America/Mexico_City
       * * `America/Miquelon` - America/Miquelon
       * * `America/Moncton` - America/Moncton
       * * `America/Monterrey` - America/Monterrey
       * * `America/Montevideo` - America/Montevideo
       * * `America/Montserrat` - America/Montserrat
       * * `America/Nassau` - America/Nassau
       * * `America/New_York` - America/New_York
       * * `America/Nome` - America/Nome
       * * `America/Noronha` - America/Noronha
       * * `America/North_Dakota/Beulah` - America/North_Dakota/Beulah
       * * `America/North_Dakota/Center` - America/North_Dakota/Center
       * * `America/North_Dakota/New_Salem` - America/North_Dakota/New_Salem
       * * `America/Nuuk` - America/Nuuk
       * * `America/Ojinaga` - America/Ojinaga
       * * `America/Panama` - America/Panama
       * * `America/Paramaribo` - America/Paramaribo
       * * `America/Phoenix` - America/Phoenix
       * * `America/Port-au-Prince` - America/Port-au-Prince
       * * `America/Port_of_Spain` - America/Port_of_Spain
       * * `America/Porto_Velho` - America/Porto_Velho
       * * `America/Puerto_Rico` - America/Puerto_Rico
       * * `America/Punta_Arenas` - America/Punta_Arenas
       * * `America/Rankin_Inlet` - America/Rankin_Inlet
       * * `America/Recife` - America/Recife
       * * `America/Regina` - America/Regina
       * * `America/Resolute` - America/Resolute
       * * `America/Rio_Branco` - America/Rio_Branco
       * * `America/Santarem` - America/Santarem
       * * `America/Santiago` - America/Santiago
       * * `America/Santo_Domingo` - America/Santo_Domingo
       * * `America/Sao_Paulo` - America/Sao_Paulo
       * * `America/Scoresbysund` - America/Scoresbysund
       * * `America/Sitka` - America/Sitka
       * * `America/St_Barthelemy` - America/St_Barthelemy
       * * `America/St_Johns` - America/St_Johns
       * * `America/St_Kitts` - America/St_Kitts
       * * `America/St_Lucia` - America/St_Lucia
       * * `America/St_Thomas` - America/St_Thomas
       * * `America/St_Vincent` - America/St_Vincent
       * * `America/Swift_Current` - America/Swift_Current
       * * `America/Tegucigalpa` - America/Tegucigalpa
       * * `America/Thule` - America/Thule
       * * `America/Tijuana` - America/Tijuana
       * * `America/Toronto` - America/Toronto
       * * `America/Tortola` - America/Tortola
       * * `America/Vancouver` - America/Vancouver
       * * `America/Whitehorse` - America/Whitehorse
       * * `America/Winnipeg` - America/Winnipeg
       * * `America/Yakutat` - America/Yakutat
       * * `America/Yellowknife` - America/Yellowknife
       * * `Antarctica/Casey` - Antarctica/Casey
       * * `Antarctica/Davis` - Antarctica/Davis
       * * `Antarctica/DumontDUrville` - Antarctica/DumontDUrville
       * * `Antarctica/Macquarie` - Antarctica/Macquarie
       * * `Antarctica/Mawson` - Antarctica/Mawson
       * * `Antarctica/McMurdo` - Antarctica/McMurdo
       * * `Antarctica/Palmer` - Antarctica/Palmer
       * * `Antarctica/Rothera` - Antarctica/Rothera
       * * `Antarctica/Syowa` - Antarctica/Syowa
       * * `Antarctica/Troll` - Antarctica/Troll
       * * `Antarctica/Vostok` - Antarctica/Vostok
       * * `Arctic/Longyearbyen` - Arctic/Longyearbyen
       * * `Asia/Aden` - Asia/Aden
       * * `Asia/Almaty` - Asia/Almaty
       * * `Asia/Amman` - Asia/Amman
       * * `Asia/Anadyr` - Asia/Anadyr
       * * `Asia/Aqtau` - Asia/Aqtau
       * * `Asia/Aqtobe` - Asia/Aqtobe
       * * `Asia/Ashgabat` - Asia/Ashgabat
       * * `Asia/Atyrau` - Asia/Atyrau
       * * `Asia/Baghdad` - Asia/Baghdad
       * * `Asia/Bahrain` - Asia/Bahrain
       * * `Asia/Baku` - Asia/Baku
       * * `Asia/Bangkok` - Asia/Bangkok
       * * `Asia/Barnaul` - Asia/Barnaul
       * * `Asia/Beirut` - Asia/Beirut
       * * `Asia/Bishkek` - Asia/Bishkek
       * * `Asia/Brunei` - Asia/Brunei
       * * `Asia/Chita` - Asia/Chita
       * * `Asia/Choibalsan` - Asia/Choibalsan
       * * `Asia/Colombo` - Asia/Colombo
       * * `Asia/Damascus` - Asia/Damascus
       * * `Asia/Dhaka` - Asia/Dhaka
       * * `Asia/Dili` - Asia/Dili
       * * `Asia/Dubai` - Asia/Dubai
       * * `Asia/Dushanbe` - Asia/Dushanbe
       * * `Asia/Famagusta` - Asia/Famagusta
       * * `Asia/Gaza` - Asia/Gaza
       * * `Asia/Hebron` - Asia/Hebron
       * * `Asia/Ho_Chi_Minh` - Asia/Ho_Chi_Minh
       * * `Asia/Hong_Kong` - Asia/Hong_Kong
       * * `Asia/Hovd` - Asia/Hovd
       * * `Asia/Irkutsk` - Asia/Irkutsk
       * * `Asia/Jakarta` - Asia/Jakarta
       * * `Asia/Jayapura` - Asia/Jayapura
       * * `Asia/Jerusalem` - Asia/Jerusalem
       * * `Asia/Kabul` - Asia/Kabul
       * * `Asia/Kamchatka` - Asia/Kamchatka
       * * `Asia/Karachi` - Asia/Karachi
       * * `Asia/Kathmandu` - Asia/Kathmandu
       * * `Asia/Khandyga` - Asia/Khandyga
       * * `Asia/Kolkata` - Asia/Kolkata
       * * `Asia/Krasnoyarsk` - Asia/Krasnoyarsk
       * * `Asia/Kuala_Lumpur` - Asia/Kuala_Lumpur
       * * `Asia/Kuching` - Asia/Kuching
       * * `Asia/Kuwait` - Asia/Kuwait
       * * `Asia/Macau` - Asia/Macau
       * * `Asia/Magadan` - Asia/Magadan
       * * `Asia/Makassar` - Asia/Makassar
       * * `Asia/Manila` - Asia/Manila
       * * `Asia/Muscat` - Asia/Muscat
       * * `Asia/Nicosia` - Asia/Nicosia
       * * `Asia/Novokuznetsk` - Asia/Novokuznetsk
       * * `Asia/Novosibirsk` - Asia/Novosibirsk
       * * `Asia/Omsk` - Asia/Omsk
       * * `Asia/Oral` - Asia/Oral
       * * `Asia/Phnom_Penh` - Asia/Phnom_Penh
       * * `Asia/Pontianak` - Asia/Pontianak
       * * `Asia/Pyongyang` - Asia/Pyongyang
       * * `Asia/Qatar` - Asia/Qatar
       * * `Asia/Qostanay` - Asia/Qostanay
       * * `Asia/Qyzylorda` - Asia/Qyzylorda
       * * `Asia/Riyadh` - Asia/Riyadh
       * * `Asia/Sakhalin` - Asia/Sakhalin
       * * `Asia/Samarkand` - Asia/Samarkand
       * * `Asia/Seoul` - Asia/Seoul
       * * `Asia/Shanghai` - Asia/Shanghai
       * * `Asia/Singapore` - Asia/Singapore
       * * `Asia/Srednekolymsk` - Asia/Srednekolymsk
       * * `Asia/Taipei` - Asia/Taipei
       * * `Asia/Tashkent` - Asia/Tashkent
       * * `Asia/Tbilisi` - Asia/Tbilisi
       * * `Asia/Tehran` - Asia/Tehran
       * * `Asia/Thimphu` - Asia/Thimphu
       * * `Asia/Tokyo` - Asia/Tokyo
       * * `Asia/Tomsk` - Asia/Tomsk
       * * `Asia/Ulaanbaatar` - Asia/Ulaanbaatar
       * * `Asia/Urumqi` - Asia/Urumqi
       * * `Asia/Ust-Nera` - Asia/Ust-Nera
       * * `Asia/Vientiane` - Asia/Vientiane
       * * `Asia/Vladivostok` - Asia/Vladivostok
       * * `Asia/Yakutsk` - Asia/Yakutsk
       * * `Asia/Yangon` - Asia/Yangon
       * * `Asia/Yekaterinburg` - Asia/Yekaterinburg
       * * `Asia/Yerevan` - Asia/Yerevan
       * * `Atlantic/Azores` - Atlantic/Azores
       * * `Atlantic/Bermuda` - Atlantic/Bermuda
       * * `Atlantic/Canary` - Atlantic/Canary
       * * `Atlantic/Cape_Verde` - Atlantic/Cape_Verde
       * * `Atlantic/Faroe` - Atlantic/Faroe
       * * `Atlantic/Madeira` - Atlantic/Madeira
       * * `Atlantic/Reykjavik` - Atlantic/Reykjavik
       * * `Atlantic/South_Georgia` - Atlantic/South_Georgia
       * * `Atlantic/St_Helena` - Atlantic/St_Helena
       * * `Atlantic/Stanley` - Atlantic/Stanley
       * * `Australia/Adelaide` - Australia/Adelaide
       * * `Australia/Brisbane` - Australia/Brisbane
       * * `Australia/Broken_Hill` - Australia/Broken_Hill
       * * `Australia/Darwin` - Australia/Darwin
       * * `Australia/Eucla` - Australia/Eucla
       * * `Australia/Hobart` - Australia/Hobart
       * * `Australia/Lindeman` - Australia/Lindeman
       * * `Australia/Lord_Howe` - Australia/Lord_Howe
       * * `Australia/Melbourne` - Australia/Melbourne
       * * `Australia/Perth` - Australia/Perth
       * * `Australia/Sydney` - Australia/Sydney
       * * `Canada/Atlantic` - Canada/Atlantic
       * * `Canada/Central` - Canada/Central
       * * `Canada/Eastern` - Canada/Eastern
       * * `Canada/Mountain` - Canada/Mountain
       * * `Canada/Newfoundland` - Canada/Newfoundland
       * * `Canada/Pacific` - Canada/Pacific
       * * `Europe/Amsterdam` - Europe/Amsterdam
       * * `Europe/Andorra` - Europe/Andorra
       * * `Europe/Astrakhan` - Europe/Astrakhan
       * * `Europe/Athens` - Europe/Athens
       * * `Europe/Belgrade` - Europe/Belgrade
       * * `Europe/Berlin` - Europe/Berlin
       * * `Europe/Bratislava` - Europe/Bratislava
       * * `Europe/Brussels` - Europe/Brussels
       * * `Europe/Bucharest` - Europe/Bucharest
       * * `Europe/Budapest` - Europe/Budapest
       * * `Europe/Busingen` - Europe/Busingen
       * * `Europe/Chisinau` - Europe/Chisinau
       * * `Europe/Copenhagen` - Europe/Copenhagen
       * * `Europe/Dublin` - Europe/Dublin
       * * `Europe/Gibraltar` - Europe/Gibraltar
       * * `Europe/Guernsey` - Europe/Guernsey
       * * `Europe/Helsinki` - Europe/Helsinki
       * * `Europe/Isle_of_Man` - Europe/Isle_of_Man
       * * `Europe/Istanbul` - Europe/Istanbul
       * * `Europe/Jersey` - Europe/Jersey
       * * `Europe/Kaliningrad` - Europe/Kaliningrad
       * * `Europe/Kirov` - Europe/Kirov
       * * `Europe/Kyiv` - Europe/Kyiv
       * * `Europe/Lisbon` - Europe/Lisbon
       * * `Europe/Ljubljana` - Europe/Ljubljana
       * * `Europe/London` - Europe/London
       * * `Europe/Luxembourg` - Europe/Luxembourg
       * * `Europe/Madrid` - Europe/Madrid
       * * `Europe/Malta` - Europe/Malta
       * * `Europe/Mariehamn` - Europe/Mariehamn
       * * `Europe/Minsk` - Europe/Minsk
       * * `Europe/Monaco` - Europe/Monaco
       * * `Europe/Moscow` - Europe/Moscow
       * * `Europe/Oslo` - Europe/Oslo
       * * `Europe/Paris` - Europe/Paris
       * * `Europe/Podgorica` - Europe/Podgorica
       * * `Europe/Prague` - Europe/Prague
       * * `Europe/Riga` - Europe/Riga
       * * `Europe/Rome` - Europe/Rome
       * * `Europe/Samara` - Europe/Samara
       * * `Europe/San_Marino` - Europe/San_Marino
       * * `Europe/Sarajevo` - Europe/Sarajevo
       * * `Europe/Saratov` - Europe/Saratov
       * * `Europe/Simferopol` - Europe/Simferopol
       * * `Europe/Skopje` - Europe/Skopje
       * * `Europe/Sofia` - Europe/Sofia
       * * `Europe/Stockholm` - Europe/Stockholm
       * * `Europe/Tallinn` - Europe/Tallinn
       * * `Europe/Tirane` - Europe/Tirane
       * * `Europe/Ulyanovsk` - Europe/Ulyanovsk
       * * `Europe/Vaduz` - Europe/Vaduz
       * * `Europe/Vatican` - Europe/Vatican
       * * `Europe/Vienna` - Europe/Vienna
       * * `Europe/Vilnius` - Europe/Vilnius
       * * `Europe/Volgograd` - Europe/Volgograd
       * * `Europe/Warsaw` - Europe/Warsaw
       * * `Europe/Zagreb` - Europe/Zagreb
       * * `Europe/Zurich` - Europe/Zurich
       * * `GMT` - GMT
       * * `Indian/Antananarivo` - Indian/Antananarivo
       * * `Indian/Chagos` - Indian/Chagos
       * * `Indian/Christmas` - Indian/Christmas
       * * `Indian/Cocos` - Indian/Cocos
       * * `Indian/Comoro` - Indian/Comoro
       * * `Indian/Kerguelen` - Indian/Kerguelen
       * * `Indian/Mahe` - Indian/Mahe
       * * `Indian/Maldives` - Indian/Maldives
       * * `Indian/Mauritius` - Indian/Mauritius
       * * `Indian/Mayotte` - Indian/Mayotte
       * * `Indian/Reunion` - Indian/Reunion
       * * `Pacific/Apia` - Pacific/Apia
       * * `Pacific/Auckland` - Pacific/Auckland
       * * `Pacific/Bougainville` - Pacific/Bougainville
       * * `Pacific/Chatham` - Pacific/Chatham
       * * `Pacific/Chuuk` - Pacific/Chuuk
       * * `Pacific/Easter` - Pacific/Easter
       * * `Pacific/Efate` - Pacific/Efate
       * * `Pacific/Fakaofo` - Pacific/Fakaofo
       * * `Pacific/Fiji` - Pacific/Fiji
       * * `Pacific/Funafuti` - Pacific/Funafuti
       * * `Pacific/Galapagos` - Pacific/Galapagos
       * * `Pacific/Gambier` - Pacific/Gambier
       * * `Pacific/Guadalcanal` - Pacific/Guadalcanal
       * * `Pacific/Guam` - Pacific/Guam
       * * `Pacific/Honolulu` - Pacific/Honolulu
       * * `Pacific/Kanton` - Pacific/Kanton
       * * `Pacific/Kiritimati` - Pacific/Kiritimati
       * * `Pacific/Kosrae` - Pacific/Kosrae
       * * `Pacific/Kwajalein` - Pacific/Kwajalein
       * * `Pacific/Majuro` - Pacific/Majuro
       * * `Pacific/Marquesas` - Pacific/Marquesas
       * * `Pacific/Midway` - Pacific/Midway
       * * `Pacific/Nauru` - Pacific/Nauru
       * * `Pacific/Niue` - Pacific/Niue
       * * `Pacific/Norfolk` - Pacific/Norfolk
       * * `Pacific/Noumea` - Pacific/Noumea
       * * `Pacific/Pago_Pago` - Pacific/Pago_Pago
       * * `Pacific/Palau` - Pacific/Palau
       * * `Pacific/Pitcairn` - Pacific/Pitcairn
       * * `Pacific/Pohnpei` - Pacific/Pohnpei
       * * `Pacific/Port_Moresby` - Pacific/Port_Moresby
       * * `Pacific/Rarotonga` - Pacific/Rarotonga
       * * `Pacific/Saipan` - Pacific/Saipan
       * * `Pacific/Tahiti` - Pacific/Tahiti
       * * `Pacific/Tarawa` - Pacific/Tarawa
       * * `Pacific/Tongatapu` - Pacific/Tongatapu
       * * `Pacific/Wake` - Pacific/Wake
       * * `Pacific/Wallis` - Pacific/Wallis
       * * `US/Alaska` - US/Alaska
       * * `US/Arizona` - US/Arizona
       * * `US/Central` - US/Central
       * * `US/Eastern` - US/Eastern
       * * `US/Hawaii` - US/Hawaii
       * * `US/Mountain` - US/Mountain
       * * `US/Pacific` - US/Pacific
       * * `UTC` - UTC 
       * @enum {string}
       */
      timezone?: "Africa/Abidjan" | "Africa/Accra" | "Africa/Addis_Ababa" | "Africa/Algiers" | "Africa/Asmara" | "Africa/Bamako" | "Africa/Bangui" | "Africa/Banjul" | "Africa/Bissau" | "Africa/Blantyre" | "Africa/Brazzaville" | "Africa/Bujumbura" | "Africa/Cairo" | "Africa/Casablanca" | "Africa/Ceuta" | "Africa/Conakry" | "Africa/Dakar" | "Africa/Dar_es_Salaam" | "Africa/Djibouti" | "Africa/Douala" | "Africa/El_Aaiun" | "Africa/Freetown" | "Africa/Gaborone" | "Africa/Harare" | "Africa/Johannesburg" | "Africa/Juba" | "Africa/Kampala" | "Africa/Khartoum" | "Africa/Kigali" | "Africa/Kinshasa" | "Africa/Lagos" | "Africa/Libreville" | "Africa/Lome" | "Africa/Luanda" | "Africa/Lubumbashi" | "Africa/Lusaka" | "Africa/Malabo" | "Africa/Maputo" | "Africa/Maseru" | "Africa/Mbabane" | "Africa/Mogadishu" | "Africa/Monrovia" | "Africa/Nairobi" | "Africa/Ndjamena" | "Africa/Niamey" | "Africa/Nouakchott" | "Africa/Ouagadougou" | "Africa/Porto-Novo" | "Africa/Sao_Tome" | "Africa/Tripoli" | "Africa/Tunis" | "Africa/Windhoek" | "America/Adak" | "America/Anchorage" | "America/Anguilla" | "America/Antigua" | "America/Araguaina" | "America/Argentina/Buenos_Aires" | "America/Argentina/Catamarca" | "America/Argentina/Cordoba" | "America/Argentina/Jujuy" | "America/Argentina/La_Rioja" | "America/Argentina/Mendoza" | "America/Argentina/Rio_Gallegos" | "America/Argentina/Salta" | "America/Argentina/San_Juan" | "America/Argentina/San_Luis" | "America/Argentina/Tucuman" | "America/Argentina/Ushuaia" | "America/Aruba" | "America/Asuncion" | "America/Atikokan" | "America/Bahia" | "America/Bahia_Banderas" | "America/Barbados" | "America/Belem" | "America/Belize" | "America/Blanc-Sablon" | "America/Boa_Vista" | "America/Bogota" | "America/Boise" | "America/Cambridge_Bay" | "America/Campo_Grande" | "America/Cancun" | "America/Caracas" | "America/Cayenne" | "America/Cayman" | "America/Chicago" | "America/Chihuahua" | "America/Ciudad_Juarez" | "America/Costa_Rica" | "America/Creston" | "America/Cuiaba" | "America/Curacao" | "America/Danmarkshavn" | "America/Dawson" | "America/Dawson_Creek" | "America/Denver" | "America/Detroit" | "America/Dominica" | "America/Edmonton" | "America/Eirunepe" | "America/El_Salvador" | "America/Fort_Nelson" | "America/Fortaleza" | "America/Glace_Bay" | "America/Goose_Bay" | "America/Grand_Turk" | "America/Grenada" | "America/Guadeloupe" | "America/Guatemala" | "America/Guayaquil" | "America/Guyana" | "America/Halifax" | "America/Havana" | "America/Hermosillo" | "America/Indiana/Indianapolis" | "America/Indiana/Knox" | "America/Indiana/Marengo" | "America/Indiana/Petersburg" | "America/Indiana/Tell_City" | "America/Indiana/Vevay" | "America/Indiana/Vincennes" | "America/Indiana/Winamac" | "America/Inuvik" | "America/Iqaluit" | "America/Jamaica" | "America/Juneau" | "America/Kentucky/Louisville" | "America/Kentucky/Monticello" | "America/Kralendijk" | "America/La_Paz" | "America/Lima" | "America/Los_Angeles" | "America/Lower_Princes" | "America/Maceio" | "America/Managua" | "America/Manaus" | "America/Marigot" | "America/Martinique" | "America/Matamoros" | "America/Mazatlan" | "America/Menominee" | "America/Merida" | "America/Metlakatla" | "America/Mexico_City" | "America/Miquelon" | "America/Moncton" | "America/Monterrey" | "America/Montevideo" | "America/Montserrat" | "America/Nassau" | "America/New_York" | "America/Nome" | "America/Noronha" | "America/North_Dakota/Beulah" | "America/North_Dakota/Center" | "America/North_Dakota/New_Salem" | "America/Nuuk" | "America/Ojinaga" | "America/Panama" | "America/Paramaribo" | "America/Phoenix" | "America/Port-au-Prince" | "America/Port_of_Spain" | "America/Porto_Velho" | "America/Puerto_Rico" | "America/Punta_Arenas" | "America/Rankin_Inlet" | "America/Recife" | "America/Regina" | "America/Resolute" | "America/Rio_Branco" | "America/Santarem" | "America/Santiago" | "America/Santo_Domingo" | "America/Sao_Paulo" | "America/Scoresbysund" | "America/Sitka" | "America/St_Barthelemy" | "America/St_Johns" | "America/St_Kitts" | "America/St_Lucia" | "America/St_Thomas" | "America/St_Vincent" | "America/Swift_Current" | "America/Tegucigalpa" | "America/Thule" | "America/Tijuana" | "America/Toronto" | "America/Tortola" | "America/Vancouver" | "America/Whitehorse" | "America/Winnipeg" | "America/Yakutat" | "America/Yellowknife" | "Antarctica/Casey" | "Antarctica/Davis" | "Antarctica/DumontDUrville" | "Antarctica/Macquarie" | "Antarctica/Mawson" | "Antarctica/McMurdo" | "Antarctica/Palmer" | "Antarctica/Rothera" | "Antarctica/Syowa" | "Antarctica/Troll" | "Antarctica/Vostok" | "Arctic/Longyearbyen" | "Asia/Aden" | "Asia/Almaty" | "Asia/Amman" | "Asia/Anadyr" | "Asia/Aqtau" | "Asia/Aqtobe" | "Asia/Ashgabat" | "Asia/Atyrau" | "Asia/Baghdad" | "Asia/Bahrain" | "Asia/Baku" | "Asia/Bangkok" | "Asia/Barnaul" | "Asia/Beirut" | "Asia/Bishkek" | "Asia/Brunei" | "Asia/Chita" | "Asia/Choibalsan" | "Asia/Colombo" | "Asia/Damascus" | "Asia/Dhaka" | "Asia/Dili" | "Asia/Dubai" | "Asia/Dushanbe" | "Asia/Famagusta" | "Asia/Gaza" | "Asia/Hebron" | "Asia/Ho_Chi_Minh" | "Asia/Hong_Kong" | "Asia/Hovd" | "Asia/Irkutsk" | "Asia/Jakarta" | "Asia/Jayapura" | "Asia/Jerusalem" | "Asia/Kabul" | "Asia/Kamchatka" | "Asia/Karachi" | "Asia/Kathmandu" | "Asia/Khandyga" | "Asia/Kolkata" | "Asia/Krasnoyarsk" | "Asia/Kuala_Lumpur" | "Asia/Kuching" | "Asia/Kuwait" | "Asia/Macau" | "Asia/Magadan" | "Asia/Makassar" | "Asia/Manila" | "Asia/Muscat" | "Asia/Nicosia" | "Asia/Novokuznetsk" | "Asia/Novosibirsk" | "Asia/Omsk" | "Asia/Oral" | "Asia/Phnom_Penh" | "Asia/Pontianak" | "Asia/Pyongyang" | "Asia/Qatar" | "Asia/Qostanay" | "Asia/Qyzylorda" | "Asia/Riyadh" | "Asia/Sakhalin" | "Asia/Samarkand" | "Asia/Seoul" | "Asia/Shanghai" | "Asia/Singapore" | "Asia/Srednekolymsk" | "Asia/Taipei" | "Asia/Tashkent" | "Asia/Tbilisi" | "Asia/Tehran" | "Asia/Thimphu" | "Asia/Tokyo" | "Asia/Tomsk" | "Asia/Ulaanbaatar" | "Asia/Urumqi" | "Asia/Ust-Nera" | "Asia/Vientiane" | "Asia/Vladivostok" | "Asia/Yakutsk" | "Asia/Yangon" | "Asia/Yekaterinburg" | "Asia/Yerevan" | "Atlantic/Azores" | "Atlantic/Bermuda" | "Atlantic/Canary" | "Atlantic/Cape_Verde" | "Atlantic/Faroe" | "Atlantic/Madeira" | "Atlantic/Reykjavik" | "Atlantic/South_Georgia" | "Atlantic/St_Helena" | "Atlantic/Stanley" | "Australia/Adelaide" | "Australia/Brisbane" | "Australia/Broken_Hill" | "Australia/Darwin" | "Australia/Eucla" | "Australia/Hobart" | "Australia/Lindeman" | "Australia/Lord_Howe" | "Australia/Melbourne" | "Australia/Perth" | "Australia/Sydney" | "Canada/Atlantic" | "Canada/Central" | "Canada/Eastern" | "Canada/Mountain" | "Canada/Newfoundland" | "Canada/Pacific" | "Europe/Amsterdam" | "Europe/Andorra" | "Europe/Astrakhan" | "Europe/Athens" | "Europe/Belgrade" | "Europe/Berlin" | "Europe/Bratislava" | "Europe/Brussels" | "Europe/Bucharest" | "Europe/Budapest" | "Europe/Busingen" | "Europe/Chisinau" | "Europe/Copenhagen" | "Europe/Dublin" | "Europe/Gibraltar" | "Europe/Guernsey" | "Europe/Helsinki" | "Europe/Isle_of_Man" | "Europe/Istanbul" | "Europe/Jersey" | "Europe/Kaliningrad" | "Europe/Kirov" | "Europe/Kyiv" | "Europe/Lisbon" | "Europe/Ljubljana" | "Europe/London" | "Europe/Luxembourg" | "Europe/Madrid" | "Europe/Malta" | "Europe/Mariehamn" | "Europe/Minsk" | "Europe/Monaco" | "Europe/Moscow" | "Europe/Oslo" | "Europe/Paris" | "Europe/Podgorica" | "Europe/Prague" | "Europe/Riga" | "Europe/Rome" | "Europe/Samara" | "Europe/San_Marino" | "Europe/Sarajevo" | "Europe/Saratov" | "Europe/Simferopol" | "Europe/Skopje" | "Europe/Sofia" | "Europe/Stockholm" | "Europe/Tallinn" | "Europe/Tirane" | "Europe/Ulyanovsk" | "Europe/Vaduz" | "Europe/Vatican" | "Europe/Vienna" | "Europe/Vilnius" | "Europe/Volgograd" | "Europe/Warsaw" | "Europe/Zagreb" | "Europe/Zurich" | "GMT" | "Indian/Antananarivo" | "Indian/Chagos" | "Indian/Christmas" | "Indian/Cocos" | "Indian/Comoro" | "Indian/Kerguelen" | "Indian/Mahe" | "Indian/Maldives" | "Indian/Mauritius" | "Indian/Mayotte" | "Indian/Reunion" | "Pacific/Apia" | "Pacific/Auckland" | "Pacific/Bougainville" | "Pacific/Chatham" | "Pacific/Chuuk" | "Pacific/Easter" | "Pacific/Efate" | "Pacific/Fakaofo" | "Pacific/Fiji" | "Pacific/Funafuti" | "Pacific/Galapagos" | "Pacific/Gambier" | "Pacific/Guadalcanal" | "Pacific/Guam" | "Pacific/Honolulu" | "Pacific/Kanton" | "Pacific/Kiritimati" | "Pacific/Kosrae" | "Pacific/Kwajalein" | "Pacific/Majuro" | "Pacific/Marquesas" | "Pacific/Midway" | "Pacific/Nauru" | "Pacific/Niue" | "Pacific/Norfolk" | "Pacific/Noumea" | "Pacific/Pago_Pago" | "Pacific/Palau" | "Pacific/Pitcairn" | "Pacific/Pohnpei" | "Pacific/Port_Moresby" | "Pacific/Rarotonga" | "Pacific/Saipan" | "Pacific/Tahiti" | "Pacific/Tarawa" | "Pacific/Tongatapu" | "Pacific/Wake" | "Pacific/Wallis" | "US/Alaska" | "US/Arizona" | "US/Central" | "US/Eastern" | "US/Hawaii" | "US/Mountain" | "US/Pacific" | "UTC";
      /**
       * @description To udpate a payment provider's ID, specify the payment provider you want to update in this field, and the payment_provider_id in the corresponding field.
       * 
       * * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      payment_provider?: "stripe" | "braintree";
      payment_provider_id?: string;
      nango_connected?: boolean;
      tax_providers?: (("taxjar" | "lotus" | "netsuite")[]) | null;
    };
    PatchedPlanUpdateRequest: {
      /** @description Name of the plan */
      plan_name?: string;
      /** @description Description of the plan */
      plan_description?: string | null;
      taxjar_code?: string | null;
      /** Format: date-time */
      active_from?: string;
      /** Format: date-time */
      active_to?: string | null;
    };
    PatchedPlanVersionUpdateRequest: {
      localized_name?: string | null;
      /** Format: date-time */
      active_from?: string | null;
      /** Format: date-time */
      active_to?: string | null;
    };
    PaymentProcesorPostDataRequest: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      payment_processor: "stripe" | "braintree";
      data: {
        [key: string]: unknown | undefined;
      };
    };
    PaymentProcesorPostRequestRequest: {
      pp_info: components["schemas"]["PaymentProcesorPostDataRequest"];
    };
    PaymentProcesorPostResponse: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      payment_processor: "stripe" | "braintree";
      success: boolean;
      details: string;
    };
    PeriodMetricRevenueResponse: {
      /** Format: double */
      total_revenue_period_1: number;
      /** Format: double */
      total_revenue_period_2: number;
      /** Format: double */
      earned_revenue_period_1: number;
      /** Format: double */
      earned_revenue_period_2: number;
    };
    PeriodMetricUsageResponse: {
      metrics: {
        [key: string]: components["schemas"]["PeriodSingleMetricUsage"] | undefined;
      };
    };
    PeriodSingleMetricUsage: {
      data: (components["schemas"]["DayMetricUsage"])[];
    };
    PeriodSubscriptionsResponse: {
      period_1_total_subscriptions: number;
      period_1_new_subscriptions: number;
      period_2_total_subscriptions: number;
      period_2_new_subscriptions: number;
    };
    Plan: {
      plan_id: string;
      /** @description Name of the plan */
      plan_name: string;
      /**
       * @description Duration of the plan
       * 
       * * `monthly` - Monthly
       * * `quarterly` - Quarterly
       * * `yearly` - Yearly 
       * @enum {string|null}
       */
      plan_duration: "monthly" | "quarterly" | "yearly" | "" | null;
      /** @description Description of the plan */
      plan_description: string | null;
      /** @description The external links that this plan has. */
      external_links: (components["schemas"]["InitialExternalPlanLink"])[];
      /** @description The number of versions that this plan has. */
      num_versions: number;
      /** @description This plan's currently active version. */
      active_version: number;
      /** @description The number of active subscriptions that this plan has across all versions. */
      active_subscriptions: number;
      /** @description The tags that this plan has. */
      tags: readonly (string)[];
      /** @description This plan's versions. */
      versions: (components["schemas"]["PlanVersion"])[];
      /**
       * @deprecated 
       * @description [DEPRECATED] The parent plan that this plan has.
       */
      parent_plan: components["schemas"]["PlanNameAndID"] | null;
      /**
       * @deprecated 
       * @description [DEPRECATED] The target customer that this plan has.
       */
      target_customer: components["schemas"]["LightweightCustomer"] | null;
      /**
       * @deprecated 
       * @description [DEPRECATED] Display version has been deprecated. Use 'versions' instead. We will still return this field for now with some heuristics for figuring out what the desired version is, but it will be removed in the near future.
       */
      display_version: components["schemas"]["PlanVersion"];
      /**
       * @deprecated 
       * @description [DEPRECATED] The status of this plan.
       */
      status: string;
    };
    PlanComponent: {
      billable_metric: components["schemas"]["Metric"];
      tiers: (components["schemas"]["PriceTier"])[];
      pricing_unit: components["schemas"]["PricingUnit"];
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      invoicing_interval_unit: "day" | "week" | "month" | "year" | "" | null;
      invoicing_interval_count: number | null;
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      reset_interval_unit: "day" | "week" | "month" | "year" | "" | null;
      reset_interval_count: number | null;
      prepaid_charge: components["schemas"]["ComponentCharge"] | null;
    };
    PlanComponentCreateRequest: {
      /** Format: uuid */
      metric_id: string;
      tiers?: (components["schemas"]["PriceTierCreateRequest"])[];
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      invoicing_interval_unit?: "day" | "week" | "month" | "year" | "" | null;
      invoicing_interval_count?: number | null;
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      reset_interval_unit?: "day" | "week" | "month" | "year" | "" | null;
      reset_interval_count?: number | null;
      prepaid_charge?: components["schemas"]["ComponentChargeCreateRequest"] | null;
    };
    PlanCreateRequest: {
      /** @description Name of the plan */
      plan_name: string;
      /** @description Description of the plan */
      plan_description?: string | null;
      /**
       * @description Duration of the plan
       * 
       * * `monthly` - Monthly
       * * `quarterly` - Quarterly
       * * `yearly` - Yearly 
       * @enum {string|null}
       */
      plan_duration?: "monthly" | "quarterly" | "yearly" | "" | null;
      initial_external_links?: (components["schemas"]["InitialExternalPlanLinkRequest"])[];
      initial_version: components["schemas"]["InitialPlanVersionCreateRequest"];
      tags?: (components["schemas"]["TagRequest"])[];
    };
    PlanDetail: {
      /** @description Name of the plan */
      plan_name: string;
      plan_id: string;
      /** @description The number of active subscriptions that this plan has across all versions. */
      active_subscriptions: number;
      versions: readonly (components["schemas"]["PlanVersionDetail"])[];
      /** @description The external links that this plan has. */
      external_links: (components["schemas"]["InitialExternalPlanLink"])[];
      /**
       * @description Duration of the plan
       * 
       * * `monthly` - Monthly
       * * `quarterly` - Quarterly
       * * `yearly` - Yearly 
       * @enum {string|null}
       */
      plan_duration: "monthly" | "quarterly" | "yearly" | "" | null;
      taxjar_code?: string | null;
      /** @description Description of the plan */
      plan_description: string | null;
      /** @description This plan's currently active version. */
      active_version: number;
      /** @description The tags that this plan has. */
      tags: readonly (components["schemas"]["Tag"])[];
      /** @description The number of versions that this plan has. */
      num_versions: number;
    };
    PlanNameAndID: {
      /** @description Name of the plan */
      plan_name: string;
      plan_id: string;
    };
    PlanRepresentation: {
      plan_name: string;
      plan_id: string;
      /** Format: double */
      plan_revenue: number;
    };
    PlanUpdate: {
      /** @description Name of the plan */
      plan_name?: string;
      /** @description Description of the plan */
      plan_description?: string | null;
      taxjar_code?: string | null;
      /** Format: date-time */
      active_from?: string;
      /** Format: date-time */
      active_to?: string | null;
    };
    PlanVersion: {
      recurring_charges: readonly (components["schemas"]["RecurringCharge"])[];
      components: (components["schemas"]["PlanComponent"])[];
      features: (components["schemas"]["Feature"])[];
      price_adjustment: components["schemas"]["PriceAdjustment"] | null;
      version: number | "custom_version";
      /**
       * @description * `active` - Active
       * * `retiring` - Retiring
       * * `grandfathered` - Grandfathered
       * * `deleted` - Deleted
       * * `inactive` - Inactive
       * * `not_started` - Not Started 
       * @enum {string}
       */
      status: "active" | "retiring" | "grandfathered" | "deleted" | "inactive" | "not_started";
      plan_name: string;
      currency: components["schemas"]["PricingUnit"];
      /** Format: date-time */
      active_from: string | null;
      /** Format: date-time */
      active_to: string | null;
      localized_name: string | null;
      target_customers: (components["schemas"]["LightweightCustomer"])[];
      /** Format: date-time */
      created_on: string;
      /** @deprecated */
      usage_billing_frequency: string | null;
      /**
       * @deprecated 
       * @description * `in_advance` - in_advance
       * * `in_arrears` - in_arrears 
       * @enum {string}
       */
      flat_fee_billing_type: "in_advance" | "in_arrears";
      /**
       * Format: double 
       * @deprecated
       */
      flat_rate: number;
      /** @deprecated */
      description: string | null;
    };
    PlanVersionCreateRequest: {
      /** Format: uuid */
      plan_id: string;
      recurring_charges?: (components["schemas"]["RecurringChargeCreateRequest"])[];
      components?: (components["schemas"]["PlanComponentCreateRequest"])[];
      features?: (string)[];
      price_adjustment?: components["schemas"]["PriceAdjustmentRequest"];
      day_anchor?: number | null;
      month_anchor?: number | null;
      currency_code: string;
      version: number;
      target_customer_ids?: (string | null)[];
      localized_name?: string | null;
      /** @default false */
      make_active?: boolean;
      /**
       * @description * `replace_on_renewal` - Replace on Renewal
       * * `grandfather` - Grandfather 
       * @default replace_on_renewal 
       * @enum {string}
       */
      make_active_type?: "replace_on_renewal" | "grandfather";
    };
    PlanVersionDetail: {
      plan_id: string;
      localized_name: string | null;
      active_subscriptions: number;
      version: number | "custom_version";
      recurring_charges: readonly (components["schemas"]["RecurringCharge"])[];
      components: (components["schemas"]["PlanComponent"])[];
      transition_to: components["schemas"]["LightweightPlan"];
      replace_with: components["schemas"]["LightweightPlanVersion"];
      target_customers: (components["schemas"]["LightweightCustomer"])[];
      version_id: string;
      /** Format: date-time */
      created_on: string;
      plan_name: string;
      currency: components["schemas"]["PricingUnit"];
      /** Format: date-time */
      active_from: string | null;
      alerts: readonly (components["schemas"]["UsageAlert"])[];
      features: (components["schemas"]["Feature"])[];
      price_adjustment: components["schemas"]["PriceAdjustment"] | null;
      /** Format: date-time */
      active_to: string | null;
      /**
       * @description * `active` - Active
       * * `retiring` - Retiring
       * * `grandfathered` - Grandfathered
       * * `deleted` - Deleted
       * * `inactive` - Inactive
       * * `not_started` - Not Started 
       * @enum {string}
       */
      status: "active" | "retiring" | "grandfathered" | "deleted" | "inactive" | "not_started";
    };
    PlanVersionHistoricalSubscription: {
      customer_id: string;
      customer_name: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      start_date: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      end_date: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      auto_renew: boolean;
    };
    PlanVersionNumberSetReplaceWithResponse: {
      success: boolean;
      message: string;
    };
    PlanVersionNumberSetTransitionToResponse: {
      success: boolean;
      message: string;
    };
    PlanVersionUpdate: {
      localized_name?: string | null;
      /** Format: date-time */
      active_from?: string | null;
      /** Format: date-time */
      active_to?: string | null;
    };
    PlansByNumCustomers: {
      results: (components["schemas"]["SinglePlanNumCustomers"])[];
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
    };
    PlansSetReplaceWithForVersionNumberRequest: {
      /** @description The version number of the plan that will replace the current version. */
      replacement_version_number: number;
    };
    PlansSetTransitionToForVersionNumberRequest: {
      /** @description The plan that the current version will transition to. */
      transition_to_plan_id: number;
    };
    PriceAdjustment: {
      price_adjustment_name: string;
      price_adjustment_description: string | null;
      /**
       * @description * `percentage` - Percentage
       * * `fixed` - Fixed
       * * `price_override` - Price Override 
       * @enum {string}
       */
      price_adjustment_type: "percentage" | "fixed" | "price_override";
      /** Format: double */
      price_adjustment_amount: number;
    };
    PriceAdjustmentRequest: {
      /** @default */
      price_adjustment_name?: string;
      price_adjustment_description?: string | null;
      /**
       * @description * `percentage` - Percentage
       * * `fixed` - Fixed
       * * `price_override` - Price Override 
       * @enum {string}
       */
      price_adjustment_type: "percentage" | "fixed" | "price_override";
      /** Format: double */
      price_adjustment_amount: number;
    };
    PriceTier: {
      /**
       * @description * `flat` - flat
       * * `per_unit` - per_unit
       * * `free` - free 
       * @enum {unknown}
       */
      type: "flat" | "per_unit" | "free";
      /** Format: double */
      range_start: number;
      /** Format: double */
      range_end: number | null;
      /** Format: double */
      cost_per_batch: number | null;
      /** Format: double */
      metric_units_per_batch: number | null;
      /**
       * @description * `round_up` - round_up
       * * `round_down` - round_down
       * * `round_nearest` - round_nearest
       * * `no_rounding` - no_rounding 
       * @enum {unknown|null}
       */
      batch_rounding_type: "round_up" | "round_down" | "round_nearest" | "no_rounding" | "" | null;
    };
    PriceTierCreateRequest: {
      /**
       * @description * `flat` - Flat
       * * `per_unit` - Per Unit
       * * `free` - Free 
       * @enum {string}
       */
      type: "flat" | "per_unit" | "free";
      /** Format: double */
      range_start: number;
      /** Format: double */
      range_end?: number | null;
      /** Format: double */
      cost_per_batch?: number | null;
      /** Format: double */
      metric_units_per_batch?: number | null;
      /**
       * @description * `round_up` - Round Up
       * * `round_down` - Round Down
       * * `round_nearest` - Round Nearest
       * * `no_rounding` - No Rounding 
       * @default no_rounding 
       * @enum {string|null}
       */
      batch_rounding_type?: "round_up" | "round_down" | "round_nearest" | "no_rounding" | "" | null;
    };
    PricingUnit: {
      code: string;
      name: string;
      symbol: string;
    };
    PricingUnitDetail: {
      code: string;
      name: string;
      symbol: string;
    };
    PricingUnitDetailRequest: {
      code: string;
      name: string;
      symbol: string;
    };
    PricingUnitRequest: {
      code: string;
      name: string;
      symbol: string;
    };
    RecurringCharge: {
      name: string;
      /**
       * @description * `in_advance` - in_advance
       * * `in_arrears` - in_arrears 
       * @enum {string}
       */
      charge_timing: "in_advance" | "in_arrears";
      /**
       * @description * `prorate` - prorate
       * * `full` - full 
       * @enum {string}
       */
      charge_behavior: "prorate" | "full";
      /** Format: double */
      amount: number;
      pricing_unit: components["schemas"]["PricingUnit"];
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      invoicing_interval_unit: "day" | "week" | "month" | "year" | "" | null;
      invoicing_interval_count: number | null;
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      reset_interval_unit: "day" | "week" | "month" | "year" | "" | null;
      reset_interval_count: number | null;
    };
    RecurringChargeCreateRequest: {
      name: string;
      /**
       * @description * `in_advance` - in_advance
       * * `in_arrears` - in_arrears 
       * @enum {string}
       */
      charge_timing: "in_advance" | "in_arrears";
      /**
       * @description * `prorate` - prorate
       * * `full` - full 
       * @default prorate 
       * @enum {string}
       */
      charge_behavior?: "prorate" | "full";
      /** Format: double */
      amount: number;
      pricing_unit_code?: string;
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      invoicing_interval_unit?: "day" | "week" | "month" | "year" | "" | null;
      invoicing_interval_count?: number | null;
      /**
       * @description * `day` - day
       * * `week` - week
       * * `month` - month
       * * `year` - year 
       * @enum {string|null}
       */
      reset_interval_unit?: "day" | "week" | "month" | "year" | "" | null;
      reset_interval_count?: number | null;
    };
    RegistrationDetailRequest: {
      organization_name: string;
      industry: string;
      email: string;
      password: string;
      username: string;
    };
    RegistrationFailure: {
      detail: string;
    };
    RegistrationRequest: {
      register: components["schemas"]["RegistrationDetailRequest"];
    };
    RegistrationSuccess: {
      detail: string;
      token: string;
      user: components["schemas"]["User"];
    };
    RemovePlanTags: {
      tags?: (components["schemas"]["Tag"])[];
      success: boolean;
      message: string;
    };
    RemovePlanTagsRequest: {
      tags?: (components["schemas"]["TagRequest"])[];
    };
    RemoveTargetCustomerResponse: {
      success: boolean;
      message: string;
    };
    ResetPasswordRequestRequest: {
      userId: string;
      password: string;
      token: string;
    };
    ResetPasswordSuccess: {
      detail: string;
      token: string;
    };
    RevenueDate: {
      /** Format: date */
      date: string;
      /** Format: double */
      original_plan_revenue: number;
      /** Format: double */
      new_plan_revenue: number;
    };
    Seller: {
      name: string;
      address?: components["schemas"]["Address"] | null;
      phone?: string | null;
      /** Format: email */
      email?: string | null;
    };
    SellerRequest: {
      name: string;
      phone?: string | null;
      /** Format: email */
      email?: string | null;
    };
    SessionSuccess: {
      isAuthenticated: boolean;
    };
    SetPlanTagsRequest: {
      tags?: (components["schemas"]["TagRequest"])[];
    };
    SetPlanTagsResponse: {
      tags?: (components["schemas"]["Tag"])[];
      success: boolean;
      message: string;
    };
    SetReplaceWithRequest: {
      /**
       * Format: uuid 
       * @description The plan version to replace the current version with.
       */
      replace_with: string;
    };
    SetReplaceWithResponse: {
      success: boolean;
      message: string;
    };
    SingleCRMProvider: {
      /**
       * @description * `salesforce` - salesforce 
       * @enum {string}
       */
      crm_provider_name: "salesforce";
      connected: boolean;
      self_hosted: boolean;
      working: boolean;
      connection_id: string | null;
      account_id: string | null;
      /** Format: uri */
      native_org_url: string | null;
    };
    SingleCustomerValue: {
      customer_id: string;
      customer_name: string;
      /** Format: double */
      value: number;
    };
    SingleDayCostAnalysis: {
      /** Format: date */
      date: string;
      cost_data: (components["schemas"]["SingleMetricCost"])[];
      /** Format: double */
      revenue: number;
    };
    SingleMetricCost: {
      metric: components["schemas"]["MetricDetail"];
      /** Format: double */
      cost: number;
    };
    SinglePaymentProcesor: {
      payment_provider_name: string;
      connected: boolean;
      /** Format: uri */
      redirect_url: string;
      self_hosted: boolean;
      connection_id: string | null;
      working: boolean;
      account_id: string | null;
    };
    SinglePlanNumCustomers: {
      plan_name: string;
      num_customers: number;
      /** Format: double */
      percent_total: number;
    };
    SingleSubstitution: {
      substitution_name: string;
      original_plan: components["schemas"]["PlanRepresentation"];
      new_plan: components["schemas"]["PlanRepresentation"];
      /** Format: double */
      pct_revenue_change: number | null;
      results: components["schemas"]["SingleSubstitutionResults"];
    };
    SingleSubstitutionResults: {
      cumulative_revenue: (components["schemas"]["RevenueDate"])[];
      revenue_by_metric: (components["schemas"]["MetricRevenue"])[];
      top_customers: components["schemas"]["TopCustomers"];
    };
    StoreTokenRequestRequest: {
      /** @description The public token obtained from the Vessel API */
      publicToken: string;
    };
    StoreTokenResponse: {
      /** @description Whether the token was successfully stored */
      success: boolean;
    };
    StripeCancelSubscriptionsFailure: {
      /**
       * @description * `error` - error 
       * @enum {string}
       */
      status: "error";
      detail: string;
    };
    StripeCancelSubscriptionsSuccess: {
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
      detail: string;
    };
    StripeMultiSubscriptionsRequest: {
      /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
      customer_id: string | null;
      stripe_subscription_ids: (string)[];
    };
    StripeSubscriptionRecord: {
      /** @description Whether this subscription came from a renewal or from a first-time. Defaults to true on creation. */
      is_new?: boolean;
      customer: components["schemas"]["LightweightCustomer"];
      billing_plan: components["schemas"]["LightweightPlanVersion"];
      metadata?: {
        [key: string]: unknown | undefined;
      };
      stripe_subscription_id: string | null;
      fully_billed: boolean;
      subscription_filters: (components["schemas"]["SubscriptionFilter"])[];
      subscription_id: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      end_date: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      auto_renew?: boolean;
      addons: (components["schemas"]["LightweightAddOnSubscriptionRecord"])[];
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      start_date: string;
    };
    StripeTurnOffAutoRenewalFailure: {
      /**
       * @description * `error` - error 
       * @enum {string}
       */
      status: "error";
      detail: string;
    };
    StripeTurnOffAutoRenewalSuccess: {
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
      detail: string;
    };
    SubscriptionCancelledRequest: {
      payload: components["schemas"]["SubscriptionRecordRequest"];
    };
    SubscriptionCreatedRequest: {
      payload: components["schemas"]["SubscriptionRecordRequest"];
    };
    SubscriptionCustomerSummary: {
      billing_plan_name: string;
      plan_version: number;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      end_date: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      auto_renew?: boolean;
    };
    SubscriptionFilter: {
      value: string;
      /** @description The string name of the property to filter on. Example: 'product_id' */
      property_name: string;
    };
    SubscriptionFilterRequest: {
      value: string;
      /** @description The string name of the property to filter on. Example: 'product_id' */
      property_name: string;
    };
    SubscriptionRecord: {
      subscription_id: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      start_date: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      end_date: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      auto_renew: boolean;
      /** @description Whether this subscription came from a renewal or from a first-time. Defaults to true on creation. */
      is_new: boolean;
      subscription_filters: (components["schemas"]["SubscriptionFilter"])[];
      customer: components["schemas"]["LightweightCustomer"];
      billing_plan: components["schemas"]["LightweightPlanVersion"];
      fully_billed: boolean;
      addons: (components["schemas"]["LightweightAddOnSubscriptionRecord"])[];
      metadata: {
        [key: string]: unknown | undefined;
      };
    };
    SubscriptionRecordCancelRequest: {
      /**
       * @description When canceling a subscription, the behavior used to calculate the flat fee. If null or not provided, the charge's default behavior will be used according to the subscription's start and end dates. If charge_full, the full flat fee will be charged, regardless of the duration of the subscription. If refund, the flat fee will not be charged. If charge_prorated, the prorated flat fee will be charged.
       * 
       * * `refund` - Refund
       * * `charge_prorated` - Prorate
       * * `charge_full` - Charge Full 
       * @enum {string|null}
       */
      flat_fee_behavior?: "refund" | "charge_prorated" | "charge_full" | "" | null;
      /**
       * @description If bill_full, current usage will be billed on the invoice. If bill_none, current unbilled usage will be dropped from the invoice. Defaults to bill_full.
       * 
       * * `bill_full` - Bill Full
       * * `bill_none` - Bill None 
       * @default bill_full 
       * @enum {string}
       */
      usage_behavior?: "bill_full" | "bill_none";
      /**
       * @description Whether to invoice now or invoice at the end of the billing period. Defaults to invoice now.
       * 
       * * `add_to_next_invoice` - Add to Next Invoice
       * * `invoice_now` - Invoice Now 
       * @default invoice_now 
       * @enum {string}
       */
      invoicing_behavior?: "add_to_next_invoice" | "invoice_now";
    };
    SubscriptionRecordCreateRequest: {
      /**
       * Format: date-time 
       * @description The date the subscription starts. This should be a string in YYYY-MM-DD format of the date in UTC time.
       */
      start_date: string;
      /**
       * Format: date-time 
       * @description The date the subscription ends. This should be a string in YYYY-MM-DD format of the date in UTC time. If you don’t set it (recommended), we will use the information in the billing plan to automatically calculate this.
       */
      end_date?: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      auto_renew?: boolean;
      is_new?: boolean;
      /** @description Add filter key, value pairs that define which events will be applied to this plan subscription. */
      subscription_filters?: (components["schemas"]["SubscriptionFilterRequest"])[];
      /** @description The id provided when creating the customer */
      customer_id: string | null;
      /**
       * Format: uuid 
       * @description The Lotus plan_id, found in the billing plan object. We will make a best-effort attempt to find the correct plan version (matching preferred currencies, prioritizing custom plans), but if more than one plan version or no plan version matches these criteria this will return an error.
       */
      plan_id?: string;
      /** @description The initial units for the plan components' prepaid fixed charges. This is only required if the plan has plan components where you did not specify the initial units. */
      component_fixed_charges_initial_units?: (components["schemas"]["ComponentsFixedChargeInitialValueRequest"])[];
      /** @description A JSON object containing additional information about the subscription. */
      metadata?: {
        [key: string]: unknown | undefined;
      };
    };
    SubscriptionRecordCreateSerializerOldRequest: {
      /**
       * Format: date-time 
       * @description The date the subscription starts. This should be a string in YYYY-MM-DD format of the date in UTC time.
       */
      start_date: string;
      /**
       * Format: date-time 
       * @description The date the subscription ends. This should be a string in YYYY-MM-DD format of the date in UTC time. If you don’t set it (recommended), we will use the information in the billing plan to automatically calculate this.
       */
      end_date?: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      auto_renew?: boolean;
      is_new?: boolean;
      /** @description Add filter key, value pairs that define which events will be applied to this plan subscription. */
      subscription_filters?: (components["schemas"]["SubscriptionFilterRequest"])[];
      /** @description The id provided when creating the customer */
      customer_id: string | null;
      /**
       * Format: uuid 
       * @description The Lotus plan_id, found in the billing plan object. This field has been deprecated in favor of version_id for the sake of being explicit. If used, a best effort will be made to find the correct plan version (matching preferred currencies, prioritizing custom plans), but if more than one plan versions matches this criteria this will return an error.
       */
      plan_id?: string;
    };
    SubscriptionRecordRequest: {
      subscription_id: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      start_date: string;
      /**
       * Format: date-time 
       * @description The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.
       */
      end_date: string;
      /** @description Whether the subscription automatically renews. Defaults to true. */
      auto_renew: boolean;
      /** @description Whether this subscription came from a renewal or from a first-time. Defaults to true on creation. */
      is_new: boolean;
      subscription_filters: (components["schemas"]["SubscriptionFilterRequest"])[];
      billing_plan: components["schemas"]["LightweightPlanVersionRequest"];
      addons: (components["schemas"]["LightweightAddOnSubscriptionRecordRequest"])[];
      metadata: {
        [key: string]: unknown | undefined;
      };
    };
    SubscriptionRecordSwitchPlanRequest: {
      /**
       * Format: uuid 
       * @description The new plan to switch to.
       */
      switch_plan_id?: string;
      /**
       * @description The invoicing behavior to use when replacing the plan. Invoice now will invoice the customer for the prorated difference of the old plan and the new plan, whereas add_to_next_invoice will wait until the end of the subscription to do the calculation.
       * 
       * * `add_to_next_invoice` - Add to Next Invoice
       * * `invoice_now` - Invoice Now 
       * @default invoice_now 
       * @enum {string}
       */
      invoicing_behavior?: "add_to_next_invoice" | "invoice_now";
      /**
       * @description The usage behavior to use when replacing the plan. Transfer to new subscription will transfer the usage from the old subscription to the new subscription, whereas keep_separate will reset the usage to 0 for the new subscription, while keeping the old usage on the old subscription and charging for that appropriately at the end of the month.
       * 
       * * `transfer_to_new_subscription` - Transfer to New Subscription
       * * `keep_separate` - Keep Separate 
       * @default transfer_to_new_subscription 
       * @enum {string}
       */
      usage_behavior?: "transfer_to_new_subscription" | "keep_separate";
      /** @description The initial units for the plan components' prepaid fixed charges. In the context of swithciong plans, this is only required if the new plan has a component the old plan did not have, that has a prepaid charge, that deos not have a default. */
      component_fixed_charges_initial_units?: (components["schemas"]["ComponentsFixedChargeInitialValueRequest"])[];
    };
    SubscriptionRecordUpdateRequest: {
      /** @description Turn off auto renew for the subscription */
      turn_off_auto_renew?: boolean;
      /**
       * Format: date-time 
       * @description Change the end date for the subscription.
       */
      end_date?: string;
      /** @description Update the metadata for the subscription. */
      metadata?: {
        [key: string]: unknown | undefined;
      };
    };
    SubscriptionRecordUpdateSerializerOldRequest: {
      /**
       * Format: uuid 
       * @description [DEPRECATED] Will currently perform a best-effort attempt to find the correct plan version to replace the current plan with. If more than one plan version matches the criteria, this will return an error. Use the change_plan method of a subscription instance instead.
       */
      replace_plan_id?: string;
      /**
       * @description The invoicing behavior to use when replacing the plan. Invoice now will invoice the customer for the prorated difference of the old plan and the new plan, whereas add_to_next_invoice will wait until the end of the subscription to do the calculation.
       * 
       * * `add_to_next_invoice` - Add to Next Invoice
       * * `invoice_now` - Invoice Now 
       * @default invoice_now 
       * @enum {string}
       */
      invoicing_behavior?: "add_to_next_invoice" | "invoice_now";
      /**
       * @description The usage behavior to use when replacing the plan. Transfer to new subscription will transfer the usage from the old subscription to the new subscription, whereas keep_separate will reset the usage to 0 for the new subscription, while keeping the old usage on the old subscription and charging for that appropriately at the end of the month.
       * 
       * * `transfer_to_new_subscription` - Transfer to New Subscription
       * * `keep_separate` - Keep Separate 
       * @default transfer_to_new_subscription 
       * @enum {string}
       */
      usage_behavior?: "transfer_to_new_subscription" | "keep_separate";
      /** @description Turn off auto renew for the subscription */
      turn_off_auto_renew?: boolean;
      /**
       * Format: date-time 
       * @description Change the end date for the subscription.
       */
      end_date?: string;
    };
    SubscriptionRenewedRequest: {
      payload: components["schemas"]["SubscriptionRecordRequest"];
    };
    SuccessResponse: {
      success: boolean;
    };
    Tag: {
      tag_name: string;
      tag_hex: string;
      tag_color: string;
    };
    TagRequest: {
      tag_name: string;
      tag_hex: string;
      tag_color: string;
    };
    TargetCustomersRequest: {
      customer_ids: (string | null)[];
    };
    TimezonesResponse: {
      timezones: (string)[];
    };
    TopCustomers: {
      original_plan_revenue: (components["schemas"]["SingleCustomerValue"])[];
      new_plan_revenue: (components["schemas"]["SingleCustomerValue"])[];
      biggest_pct_increase: (components["schemas"]["SingleCustomerValue"])[];
      biggest_pct_decrease: (components["schemas"]["SingleCustomerValue"])[];
    };
    TrackEventFailure: {
      /**
       * @description * `none` - none 
       * @enum {string}
       */
      success: "none";
      failed_events: {
        [key: string]: unknown | undefined;
      };
    };
    TrackEventSuccess: {
      /**
       * @description * `all` - all
       * * `some` - some 
       * @enum {string}
       */
      success: "all" | "some";
      failed_events: {
        [key: string]: unknown | undefined;
      };
    };
    TransferSubscriptionsFailure: {
      /**
       * @description * `error` - error 
       * @enum {string}
       */
      status: "error";
      detail: string;
    };
    TransferSubscriptionsRequestRequest: {
      /**
       * @description * `stripe` - Stripe
       * * `braintree` - Braintree 
       * @enum {string}
       */
      source: "stripe" | "braintree";
      end_now: boolean;
    };
    TransferSubscriptionsSuccess: {
      /**
       * @description * `success` - success 
       * @enum {string}
       */
      status: "success";
      detail: string;
    };
    URLResponse: {
      /** Format: uri */
      url: string;
      exists: boolean;
    };
    UpdateCRMSourceOfTruthRequest: {
      /**
       * @description * `salesforce` - salesforce 
       * @enum {string}
       */
      crm_provider_name: "salesforce";
      lotus_is_source: boolean;
    };
    UsageAlert: {
      usage_alert_id: string;
      metric: components["schemas"]["Metric"];
      plan_version: components["schemas"]["LightweightPlanVersion"];
      /** Format: double */
      threshold: number;
    };
    UsageAlertCreate: {
      /** Format: uuid */
      metric_id: string;
      /** Format: uuid */
      plan_version_id: string;
      /** Format: double */
      threshold: number;
    };
    UsageAlertCreateRequest: {
      /** Format: uuid */
      metric_id: string;
      /** Format: uuid */
      plan_version_id: string;
      /** Format: double */
      threshold: number;
    };
    UsageAlertPayloadRequest: {
      subscription: components["schemas"]["LightweightSubscriptionRecordRequest"];
      usage_alert: components["schemas"]["UsageAlertRequest"];
      /** Format: double */
      usage: number;
      /** Format: date-time */
      time_triggered: string;
    };
    UsageAlertRequest: {
      metric: components["schemas"]["MetricRequest"];
      plan_version: components["schemas"]["LightweightPlanVersionRequest"];
      /** Format: double */
      threshold: number;
    };
    UsageAlertTriggeredRequest: {
      payload: components["schemas"]["UsageAlertPayloadRequest"];
    };
    User: {
      /** @description Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only. */
      username: string;
      /** Format: email */
      email: string;
      organization_name: string;
      organization_id: string;
    };
    UserRequest: {
      /** @description Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only. */
      username: string;
      /** Format: email */
      email: string;
      organization_name: string;
      organization_id: string;
    };
    WebhookEndpoint: {
      webhook_endpoint_id: string;
      name?: string | null;
      webhook_url: string;
      webhook_secret: string;
      triggers: readonly (components["schemas"]["WebhookTrigger"])[];
    };
    WebhookEndpointRequest: {
      name?: string | null;
      webhook_url: string;
      triggers_in: ("customer.created" | "invoice.created" | "invoice.paid" | "invoice.past_due" | "subscription.created" | "usage_alert.triggered" | "subscription.cancelled" | "subscription.renewed")[];
    };
    WebhookTrigger: {
      /**
       * @description * `customer.created` - customer.created
       * * `invoice.created` - invoice.created
       * * `invoice.paid` - invoice.paid
       * * `invoice.past_due` - invoice.past_due
       * * `subscription.created` - subscription.created
       * * `usage_alert.triggered` - usage_alert.triggered
       * * `subscription.cancelled` - subscription.cancelled
       * * `subscription.renewed` - subscription.renewed 
       * @enum {string}
       */
      trigger_name: "customer.created" | "invoice.created" | "invoice.paid" | "invoice.past_due" | "subscription.created" | "usage_alert.triggered" | "subscription.cancelled" | "subscription.renewed";
    };
    WebhookTriggerRequest: {
      /**
       * @description * `customer.created` - customer.created
       * * `invoice.created` - invoice.created
       * * `invoice.paid` - invoice.paid
       * * `invoice.past_due` - invoice.past_due
       * * `subscription.created` - subscription.created
       * * `usage_alert.triggered` - usage_alert.triggered
       * * `subscription.cancelled` - subscription.cancelled
       * * `subscription.renewed` - subscription.renewed 
       * @enum {string}
       */
      trigger_name: "customer.created" | "invoice.created" | "invoice.paid" | "invoice.past_due" | "subscription.created" | "usage_alert.triggered" | "subscription.cancelled" | "subscription.renewed";
    };
  };
  responses: never;
  parameters: never;
  requestBodies: never;
  headers: never;
  pathItems: never;
}

export type external = Record<string, never>;

export interface operations {

  /** @description API endpoint that allows events to be viewed. */
  app_actions_list: {
    parameters: {
      query: {
        /** @description The pagination cursor value. */
        c?: string;
        /** @description Number of results to return per page. */
        page_size?: number;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PaginatedActionList"];
        };
      };
    };
  };
  app_addon_versions_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["AddOnVersionCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddOnVersionCreateRequest"];
        "multipart/form-data": components["schemas"]["AddOnVersionCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["AddOnVersionDetail"];
        };
      };
    };
  };
  app_addon_versions_partial_update: {
    parameters: {
      path: {
        version_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedAddOnVersionUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedAddOnVersionUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedAddOnVersionUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddOnVersionUpdate"];
        };
      };
    };
  };
  app_addon_versions_delete_create: {
    parameters: {
      path: {
        version_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["DeleteAddOnVersion"];
        };
      };
    };
  };
  app_addons_list: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["AddOnDetail"])[];
        };
      };
    };
  };
  app_addons_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["AddOnCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddOnCreateRequest"];
        "multipart/form-data": components["schemas"]["AddOnCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["AddOnDetail"];
        };
      };
    };
  };
  app_addons_retrieve: {
    parameters: {
      path: {
        addon_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddOnDetail"];
        };
      };
    };
  };
  app_addons_partial_update: {
    parameters: {
      path: {
        addon_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedAddOnUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedAddOnUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedAddOnUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddOnUpdate"];
        };
      };
    };
  };
  app_addons_delete_create: {
    parameters: {
      path: {
        addon_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["DeleteAddOn"];
        };
      };
    };
  };
  app_addons_features_add_create: {
    parameters: {
      path: {
        addon_id: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["AddFeatureToAddOnRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddFeatureToAddOnRequest"];
        "multipart/form-data": components["schemas"]["AddFeatureToAddOnRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddFeatureToAddOnResponse"];
        };
      };
    };
  };
  /** @description API endpoint that allows API Tokens to be viewed or edited. */
  app_api_tokens_list: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["APIToken"])[];
        };
      };
    };
  };
  /** @description API endpoint that allows API Tokens to be viewed or edited. */
  app_api_tokens_create: {
    requestBody?: {
      content: {
        "application/json": components["schemas"]["APITokenRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["APITokenRequest"];
        "multipart/form-data": components["schemas"]["APITokenRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["APITokenCreateResponse"];
        };
      };
    };
  };
  /** @description API endpoint that allows API Tokens to be viewed or edited. */
  app_api_tokens_destroy: {
    parameters: {
      path: {
        prefix: string;
      };
    };
    responses: {
      /** @description No response body */
      204: never;
    };
  };
  /** @description API endpoint that allows API Tokens to be viewed or edited. */
  app_api_tokens_roll_create: {
    parameters: {
      path: {
        prefix: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["APITokenRollResponse"];
        };
      };
    };
  };
  app_backtests_list: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["BacktestSummary"])[];
        };
      };
    };
  };
  app_backtests_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["BacktestCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["BacktestCreateRequest"];
        "multipart/form-data": components["schemas"]["BacktestCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["BacktestCreate"];
        };
      };
    };
  };
  app_backtests_retrieve: {
    parameters: {
      path: {
        backtest_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["BacktestDetail"];
        };
      };
    };
  };
  app_credits_list: {
    parameters: {
      query: {
        /** @description Filter to adjustments in a specific currency */
        currency_code?: string;
        /** @description The id provided when creating the customer, we suggest matching with your internal customer id in your backend */
        customer_id: string | null;
        /** @description Filter to adjustments that are effective after this date */
        effective_after?: string;
        /** @description Filter to adjustments that are effective before this date */
        effective_before?: string;
        /** @description Filter to adjustments that expire after this date */
        expires_after?: string;
        /** @description Filter to adjustments that expire before this date */
        expires_before?: string;
        /** @description Filter to adjustments that were issued after this date */
        issued_after?: string;
        /** @description Filter to adjustments that were issued before this date */
        issued_before?: string;
        /** @description Filter to a specific set of adjustment statuses. Defaults to both active and inactive. */
        status?: ("active" | "inactive")[];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["CustomerBalanceAdjustment"])[];
        };
      };
    };
  };
  app_credits_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["CustomerBalanceAdjustmentCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["CustomerBalanceAdjustmentCreateRequest"];
        "multipart/form-data": components["schemas"]["CustomerBalanceAdjustmentCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["CustomerBalanceAdjustment"];
        };
      };
    };
  };
  app_credits_retrieve: {
    parameters: {
      path: {
        /** @description The ID of the credit to retrieve or update. */
        credit_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerBalanceAdjustment"];
        };
      };
    };
  };
  app_credits_update_create: {
    parameters: {
      path: {
        /** @description The ID of the credit to retrieve or update. */
        credit_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["CustomerBalanceAdjustmentUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["CustomerBalanceAdjustmentUpdateRequest"];
        "multipart/form-data": components["schemas"]["CustomerBalanceAdjustmentUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerBalanceAdjustment"];
        };
      };
    };
  };
  app_credits_void_create: {
    parameters: {
      path: {
        /** @description The ID of the credit to retrieve or update. */
        credit_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerBalanceAdjustment"];
        };
      };
    };
  };
  app_crm_list: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["SingleCRMProvider"])[];
        };
      };
    };
  };
  app_crm_link_token_create: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["LinkTokenResponse"];
        };
      };
    };
  };
  app_crm_set_customer_source_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateCRMSourceOfTruthRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["UpdateCRMSourceOfTruthRequest"];
        "multipart/form-data": components["schemas"]["UpdateCRMSourceOfTruthRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SuccessResponse"];
        };
      };
    };
  };
  app_crm_store_token_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["StoreTokenRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["StoreTokenRequestRequest"];
        "multipart/form-data": components["schemas"]["StoreTokenRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["StoreTokenResponse"];
        };
      };
    };
  };
  app_customers_list: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["CustomerDetail"])[];
        };
      };
    };
  };
  app_customers_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["CustomerCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["CustomerCreateRequest"];
        "multipart/form-data": components["schemas"]["CustomerCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["Customer"];
        };
      };
    };
  };
  app_customers_retrieve: {
    parameters: {
      path: {
        customer_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerDetail"];
        };
      };
    };
  };
  app_customers_partial_update: {
    parameters: {
      path: {
        customer_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedCustomerUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedCustomerUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedCustomerUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerUpdate"];
        };
      };
    };
  };
  app_customers_cost_analysis_retrieve: {
    parameters: {
      query: {
        end_date: string;
        start_date: string;
      };
      path: {
        customer_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CostAnalysis"];
        };
      };
    };
  };
  app_customers_delete_create: {
    parameters: {
      path: {
        customer_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerDeleteResponse"];
        };
      };
    };
  };
  app_customers_draft_invoice_retrieve: {
    parameters: {
      query: {
        include_next_period?: boolean;
      };
      path: {
        customer_id: string;
      };
    };
    responses: {
      /** @description No response body */
      200: never;
    };
  };
  /** @description Get the current settings for the organization. */
  app_customers_summary_retrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerSummary"];
        };
      };
    };
  };
  /** @description Get the current settings for the organization. */
  app_customers_totals_retrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["CustomerWithRevenue"];
        };
      };
    };
  };
  app_demo_login_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["DemoLoginRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["DemoLoginRequestRequest"];
        "multipart/form-data": components["schemas"]["DemoLoginRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["DemoLoginSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["DemoLoginFailure"];
        };
      };
    };
  };
  app_demo_register_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["DemoRegistrationRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["DemoRegistrationRequest"];
        "multipart/form-data": components["schemas"]["DemoRegistrationRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["DemoRegistrationSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["DemoRegistrationFailure"];
        };
      };
    };
  };
  /** @description API endpoint that allows events to be viewed. */
  app_events_list: {
    parameters: {
      query: {
        /** @description The pagination cursor value. */
        c?: string;
        /** @description Number of results to return per page. */
        page_size?: number;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PaginatedEventDetailList"];
        };
      };
    };
  };
  /** @description API endpoint that allows events to be viewed. */
  app_events_properties_retrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["EventProperties"];
        };
      };
    };
  };
  app_external_plan_links_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["ExternalPlanLinkRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ExternalPlanLinkRequest"];
        "multipart/form-data": components["schemas"]["ExternalPlanLinkRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["ExternalPlanLink"];
        };
      };
    };
  };
  app_external_plan_links_destroy: {
    parameters: {
      query: {
        /**
         * @description * `stripe` - Stripe
         * * `braintree` - Braintree
         */
        source: "stripe" | "braintree";
      };
      path: {
        external_plan_id: string;
      };
    };
    responses: {
      /** @description No response body */
      204: never;
    };
  };
  app_features_list: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["FeatureDetail"])[];
        };
      };
    };
  };
  app_features_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["FeatureCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["FeatureCreateRequest"];
        "multipart/form-data": components["schemas"]["FeatureCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["FeatureDetail"];
        };
      };
    };
  };
  app_import_customers_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["ImportCustomersRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ImportCustomersRequestRequest"];
        "multipart/form-data": components["schemas"]["ImportCustomersRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["ImportCustomerSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["ImportCustomerFailure"];
        };
      };
    };
  };
  app_import_payment_objects_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["ImportPaymentObjectsRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ImportPaymentObjectsRequestRequest"];
        "multipart/form-data": components["schemas"]["ImportPaymentObjectsRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["ImportPaymentObjectSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["ImportPaymentObjectFailure"];
        };
      };
    };
  };
  app_import_subscriptions_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["ImportSubscriptionsRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ImportSubscriptionsRequestRequest"];
        "multipart/form-data": components["schemas"]["ImportSubscriptionsRequestRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["ImportSubscriptionsSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["ImportSubscriptionsFailure"];
        };
      };
    };
  };
  app_invoices_list: {
    parameters: {
      query: {
        /** @description A filter for invoices for a specific customer */
        customer_id?: string | null;
        /** @description A filter for invoices with a specific payment status */
        payment_status?: ("unpaid" | "paid")[];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["InvoiceDetail"])[];
        };
      };
    };
  };
  app_invoices_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["InvoiceDetailRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["InvoiceDetailRequest"];
        "multipart/form-data": components["schemas"]["InvoiceDetailRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["InvoiceDetail"];
        };
      };
    };
  };
  app_invoices_retrieve: {
    parameters: {
      path: {
        invoice_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["InvoiceDetail"];
        };
      };
    };
  };
  app_invoices_partial_update: {
    parameters: {
      path: {
        invoice_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedInvoiceUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedInvoiceUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedInvoiceUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["InvoicePayment"];
        };
      };
    };
  };
  app_invoices_pdf_url_retrieve: {
    parameters: {
      path: {
        /** @description Either an invoice ID (in the format `invoice_<uuid>`) or an invoice number (in the format `YYMMDD-000001`) */
        invoice_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["InvoiceDetail"];
        };
      };
    };
  };
  app_invoices_send_create: {
    parameters: {
      path: {
        invoice_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["InvoiceDetail"];
        };
      };
    };
  };
  app_login_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["LoginRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["LoginRequestRequest"];
        "multipart/form-data": components["schemas"]["LoginRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["LoginSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["LoginFailure"];
        };
      };
    };
  };
  app_logout_create: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["LogoutSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["LogoutFailure"];
        };
      };
    };
  };
  app_metrics_list: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["MetricDetail"])[];
        };
      };
    };
  };
  app_metrics_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["MetricCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["MetricCreateRequest"];
        "multipart/form-data": components["schemas"]["MetricCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["MetricDetail"];
        };
      };
    };
  };
  app_metrics_retrieve: {
    parameters: {
      path: {
        metric_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["MetricDetail"];
        };
      };
    };
  };
  app_metrics_partial_update: {
    parameters: {
      path: {
        metric_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedMetricUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedMetricUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedMetricUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["MetricUpdate"];
        };
      };
    };
  };
  app_netsuite_customers_retrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["URLResponse"];
        };
      };
    };
  };
  app_netsuite_invoices_retrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["URLResponse"];
        };
      };
    };
  };
  app_organization_invite_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["InviteRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["InviteRequestRequest"];
        "multipart/form-data": components["schemas"]["InviteRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["InviteResponse"];
        };
      };
    };
  };
  app_organization_invite_link_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["InviteRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["InviteRequestRequest"];
        "multipart/form-data": components["schemas"]["InviteRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["InviteLinkResponse"];
        };
      };
    };
  };
  app_organization_settings_list: {
    parameters: {
      query: {
        /**
         * @description Filters organization_settings to a single setting_group. Defaults to returning all settings.
         * 
         * * `stripe` - Stripe
         * * `braintree` - Braintree
         * * `billing` - Billing
         * * `crm` - CRM
         */
        setting_group?: "stripe" | "braintree" | "billing" | "crm";
        /** @description Filters organization_settings by setting_name. Defaults to returning all settings. */
        setting_name?: ("generate_customer_after_creating_in_lotus" | "gen_cust_in_braintree_after_lotus" | "subscription_filter_keys" | "payment_grace_period" | "crm_customer_source")[];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["OrganizationSetting"])[];
        };
      };
    };
  };
  app_organization_settings_retrieve: {
    parameters: {
      path: {
        setting_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["OrganizationSetting"];
        };
      };
    };
  };
  app_organization_settings_partial_update: {
    parameters: {
      path: {
        setting_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedOrganizationSettingUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedOrganizationSettingUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedOrganizationSettingUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["OrganizationSettingUpdate"];
        };
      };
    };
  };
  app_organizations_list: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["Organization"])[];
        };
      };
    };
  };
  app_organizations_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["OrganizationCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["OrganizationCreateRequest"];
        "multipart/form-data": components["schemas"]["OrganizationCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["Organization"];
        };
      };
    };
  };
  app_organizations_partial_update: {
    parameters: {
      path: {
        organization_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedOrganizationUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedOrganizationUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedOrganizationUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["Organization"];
        };
      };
    };
  };
  app_organizations_sync_crm_create: {
    parameters: {
      path: {
        organization_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["CRMSyncRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["CRMSyncRequestRequest"];
        "multipart/form-data": components["schemas"]["CRMSyncRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["DeleteAddOn"];
        };
      };
    };
  };
  app_payment_providers_list: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["SinglePaymentProcesor"])[];
        };
      };
    };
  };
  app_payment_providers_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["PaymentProcesorPostRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PaymentProcesorPostRequestRequest"];
        "multipart/form-data": components["schemas"]["PaymentProcesorPostRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PaymentProcesorPostResponse"];
        };
      };
    };
  };
  /** @description Returns the revenue for an organization in a given time period. */
  app_period_events_retrieve: {
    parameters: {
      query: {
        period_1_end_date: string;
        period_1_start_date: string;
        period_2_end_date: string;
        period_2_start_date: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PeriodMetricRevenueResponse"];
        };
      };
    };
  };
  /** @description Returns the revenue for an organization in a given time period. */
  app_period_metric_revenue_retrieve: {
    parameters: {
      query: {
        period_1_end_date: string;
        period_1_start_date: string;
        period_2_end_date: string;
        period_2_start_date: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PeriodMetricRevenueResponse"];
        };
      };
    };
  };
  /** @description Return current usage for a customer during a given billing period. */
  app_period_metric_usage_retrieve: {
    parameters: {
      query: {
        end_date: string;
        start_date: string;
        top_n_customers?: number;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PeriodMetricUsageResponse"];
        };
      };
    };
  };
  app_period_subscriptions_retrieve: {
    parameters: {
      query: {
        period_1_end_date: string;
        period_1_start_date: string;
        period_2_end_date: string;
        period_2_start_date: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PeriodSubscriptionsResponse"];
        };
      };
    };
  };
  app_plan_versions_list: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["PlanVersionDetail"])[];
        };
      };
    };
  };
  app_plan_versions_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["PlanVersionCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PlanVersionCreateRequest"];
        "multipart/form-data": components["schemas"]["PlanVersionCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["PlanVersionDetail"];
        };
      };
    };
  };
  app_plan_versions_retrieve: {
    parameters: {
      path: {
        version_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PlanVersionDetail"];
        };
      };
    };
  };
  app_plan_versions_partial_update: {
    parameters: {
      path: {
        version_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedPlanVersionUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedPlanVersionUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedPlanVersionUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PlanVersionUpdate"];
        };
      };
    };
  };
  app_plan_versions_delete_create: {
    parameters: {
      path: {
        version_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["DeletePlanVersion"];
        };
      };
    };
  };
  app_plan_versions_features_add_create: {
    parameters: {
      path: {
        version_id: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["AddFeatureRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddFeatureRequest"];
        "multipart/form-data": components["schemas"]["AddFeatureRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddFeatureResponse"];
        };
      };
    };
  };
  app_plan_versions_make_public_create: {
    parameters: {
      path: {
        version_id: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["MakePublicRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["MakePublicRequestRequest"];
        "multipart/form-data": components["schemas"]["MakePublicRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["MakePublicResponse"];
        };
      };
    };
  };
  app_plan_versions_replacement_make_create: {
    parameters: {
      path: {
        version_id: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["MakeReplaceWithRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["MakeReplaceWithRequest"];
        "multipart/form-data": components["schemas"]["MakeReplaceWithRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["MakeReplaceWithResponse"];
        };
      };
    };
  };
  app_plan_versions_replacement_set_create: {
    parameters: {
      path: {
        version_id: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["SetReplaceWithRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SetReplaceWithRequest"];
        "multipart/form-data": components["schemas"]["SetReplaceWithRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SetReplaceWithResponse"];
        };
      };
    };
  };
  app_plan_versions_subscriptions_list: {
    parameters: {
      path: {
        version_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["PlanVersionHistoricalSubscription"])[];
        };
      };
    };
  };
  app_plan_versions_target_customers_add_create: {
    parameters: {
      path: {
        version_id: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["TargetCustomersRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["TargetCustomersRequest"];
        "multipart/form-data": components["schemas"]["TargetCustomersRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddTargetCustomerResponse"];
        };
      };
    };
  };
  app_plan_versions_target_customers_remove_create: {
    parameters: {
      path: {
        version_id: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["TargetCustomersRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["TargetCustomersRequest"];
        "multipart/form-data": components["schemas"]["TargetCustomersRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["RemoveTargetCustomerResponse"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  app_plans_list: {
    parameters: {
      query: {
        /**
         * @description Filter to plans that have this duration.
         * 
         * * `monthly` - Monthly
         * * `quarterly` - Quarterly
         * * `yearly` - Yearly
         */
        duration?: "monthly" | "quarterly" | "yearly";
        /** @description Filter to plans that do not have any of the tags in this list. */
        exclude_tags?: (string)[];
        /** @description Filter to plans that have any of the tags in this list. */
        include_tags?: (string)[];
        /** @description Filter to plans that have all of the tags in this list. */
        include_tags_all?: (string)[];
        /** @description Filter to versions that have the currency specified by this currency code. */
        version_currency_code?: string;
        /**
         * @description Filter to versions that have this custom type. If you choose custom_only, you will only see versions that have target customers. If you choose public_only, you will only see versions that do not have target customers.
         * 
         * * `custom_only` - Custom Only
         * * `public_only` - Public Only
         * * `all` - All
         */
        version_custom_type?: "custom_only" | "public_only" | "all";
        /** @description Filter to versions that have this status. Ended means it has an active_to date in the past. Not started means it has an active_from date in the future or null. */
        version_status?: ("active" | "ended" | "not_started")[];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["PlanDetail"])[];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  app_plans_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["PlanCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PlanCreateRequest"];
        "multipart/form-data": components["schemas"]["PlanCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["PlanDetail"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  app_plans_retrieve: {
    parameters: {
      query: {
        /** @description Filter to versions that have the currency specified by this currency code. */
        version_currency_code?: string;
        /**
         * @description Filter to versions that have this custom type. If you choose custom_only, you will only see versions that have target customers. If you choose public_only, you will only see versions that do not have target customers.
         * 
         * * `custom_only` - Custom Only
         * * `public_only` - Public Only
         * * `all` - All
         */
        version_custom_type?: "custom_only" | "public_only" | "all";
        /** @description Filter to versions that have this status. Ended means it has an active_to date in the past. Not started means it has an active_from date in the future or null. */
        version_status?: ("active" | "ended" | "not_started")[];
      };
      path: {
        plan_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PlanDetail"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  app_plans_partial_update: {
    parameters: {
      path: {
        plan_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["PatchedPlanUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PatchedPlanUpdateRequest"];
        "multipart/form-data": components["schemas"]["PatchedPlanUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PlanUpdate"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  app_plans_delete_create: {
    parameters: {
      path: {
        plan_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["DeletePlan"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  app_plans_features_add_create: {
    parameters: {
      path: {
        plan_id: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["AddFeatureToPlanRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddFeatureToPlanRequest"];
        "multipart/form-data": components["schemas"]["AddFeatureToPlanRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddFeatureToPlanResponse"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  app_plans_tags_add_create: {
    parameters: {
      path: {
        plan_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["AddPlanTagsRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddPlanTagsRequest"];
        "multipart/form-data": components["schemas"]["AddPlanTagsRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddPlanTags"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  app_plans_tags_remove_create: {
    parameters: {
      path: {
        plan_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["RemovePlanTagsRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["RemovePlanTagsRequest"];
        "multipart/form-data": components["schemas"]["RemovePlanTagsRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["RemovePlanTags"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  app_plans_tags_set_create: {
    parameters: {
      path: {
        plan_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["SetPlanTagsRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SetPlanTagsRequest"];
        "multipart/form-data": components["schemas"]["SetPlanTagsRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SetPlanTagsResponse"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  app_plans_versions_active_dates_update_create: {
    parameters: {
      path: {
        /** @description The ID of the plan whose versions we're changing the active dates. */
        plan_id: string;
        /** @description The version number to update. */
        version_number: number;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["ChangeActiveDatesRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ChangeActiveDatesRequest"];
        "multipart/form-data": components["schemas"]["ChangeActiveDatesRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["ChangeActiveDateResponse"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  app_plans_versions_features_add_create: {
    parameters: {
      path: {
        /** @description The ID of the plan whose versions we're adding a feature to. */
        plan_id: string;
        /** @description The version number to update. */
        version_number: number;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["AddFeatureToPlanRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddFeatureToPlanRequest"];
        "multipart/form-data": components["schemas"]["AddFeatureToPlanRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddFeatureToPlanVersionNumberResponse"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  app_plans_versions_replacement_set_create: {
    parameters: {
      path: {
        plan_id: string;
        version_number: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["PlansSetReplaceWithForVersionNumberRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PlansSetReplaceWithForVersionNumberRequest"];
        "multipart/form-data": components["schemas"]["PlansSetReplaceWithForVersionNumberRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PlanVersionNumberSetReplaceWithResponse"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  app_plans_versions_transition_set_create: {
    parameters: {
      path: {
        plan_id: string;
        version_number: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["PlansSetTransitionToForVersionNumberRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PlansSetTransitionToForVersionNumberRequest"];
        "multipart/form-data": components["schemas"]["PlansSetTransitionToForVersionNumberRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PlanVersionNumberSetTransitionToResponse"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing Plans. */
  app_plans_versions_next_retrieve: {
    parameters: {
      path: {
        plan_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["NextPlanVersionNumberResponse"];
        };
      };
    };
  };
  app_plans_by_customer_retrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["PlansByNumCustomers"];
        };
      };
    };
  };
  app_pricing_units_list: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["PricingUnitDetail"])[];
        };
      };
    };
  };
  app_pricing_units_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["PricingUnitDetailRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["PricingUnitDetailRequest"];
        "multipart/form-data": components["schemas"]["PricingUnitDetailRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["PricingUnitDetail"];
        };
      };
    };
  };
  app_register_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["RegistrationRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["RegistrationRequest"];
        "multipart/form-data": components["schemas"]["RegistrationRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["RegistrationSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["RegistrationFailure"];
        };
      };
    };
  };
  app_session_retrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SessionSuccess"];
        };
      };
    };
  };
  app_stripe_cancel_at_period_end_subscriptions_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["StripeMultiSubscriptionsRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["StripeMultiSubscriptionsRequest"];
        "multipart/form-data": components["schemas"]["StripeMultiSubscriptionsRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["StripeTurnOffAutoRenewalSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["StripeTurnOffAutoRenewalFailure"];
        };
      };
    };
  };
  app_stripe_cancel_subscriptions_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["StripeMultiSubscriptionsRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["StripeMultiSubscriptionsRequest"];
        "multipart/form-data": components["schemas"]["StripeMultiSubscriptionsRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["StripeCancelSubscriptionsSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["StripeCancelSubscriptionsFailure"];
        };
      };
    };
  };
  app_subscriptions_list: {
    parameters: {
      query: {
        /** @description Filter to a specific customer. */
        customer_id: string | null;
        /** @description Filter to a specific plan. */
        plan_id?: string;
        /** @description If specified, will only return subscriptions with a start date before this date. */
        range_end?: string;
        /** @description If specified, will only return subscriptions with an end date after this date. */
        range_start?: string;
        /** @description Filter to a specific set of subscription statuses. Defaults to active. */
        status?: ("active" | "ended" | "not_started")[];
        /** @description Filter to a specific set of subscription filters. If your billing model only allows for one subscription per customer, you very likely do not need this field. Must be formatted as a JSON-encoded + stringified list of dictionaries, where each dictionary has a key of 'property_name' and a key of 'value'. */
        subscription_filters?: (components["schemas"]["SubscriptionFilterRequest"])[];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["SubscriptionRecord"])[];
        };
      };
    };
  };
  app_subscriptions_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordCreateRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["SubscriptionRecord"];
        };
      };
    };
  };
  app_subscriptions_retrieve: {
    parameters: {
      path: {
        subscription_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SubscriptionRecord"];
        };
      };
    };
  };
  app_subscriptions_addons_cancel_create: {
    parameters: {
      path: {
        /** @description The ID of the addon within the subscription update. */
        addon_id: string;
        /** @description The ID of the subscription to update. */
        subscription_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordCancelRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordCancelRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordCancelRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["AddOnSubscriptionRecord"])[];
        };
      };
    };
  };
  app_subscriptions_addons_attach_create: {
    parameters: {
      path: {
        /** @description The ID of the subscription to add an addon to. */
        subscription_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["AddOnSubscriptionRecordCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["AddOnSubscriptionRecordCreateRequest"];
        "multipart/form-data": components["schemas"]["AddOnSubscriptionRecordCreateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["AddOnSubscriptionRecord"];
        };
      };
    };
  };
  app_subscriptions_cancel_create_2: {
    parameters: {
      path: {
        /** @description The ID of the subscription to cancel. */
        subscription_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordCancelRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordCancelRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordCancelRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SubscriptionRecord"];
        };
      };
    };
  };
  app_subscriptions_components_change_prepaid_units_create: {
    parameters: {
      path: {
        /** @description The ID of the metric to alter the prepaid usage for. */
        metric_id: string;
        /** @description The ID of the subscription which will have its plans switched. */
        subscription_id: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ChangePrepaidUnitsRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ChangePrepaidUnitsRequest"];
        "multipart/form-data": components["schemas"]["ChangePrepaidUnitsRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SubscriptionRecord"];
        };
      };
    };
  };
  app_subscriptions_switch_plan_create: {
    parameters: {
      path: {
        /** @description The ID of the subscription which will have its plans switched. */
        subscription_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordSwitchPlanRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordSwitchPlanRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordSwitchPlanRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SubscriptionRecord"];
        };
      };
    };
  };
  app_subscriptions_update_create_2: {
    parameters: {
      path: {
        /** @description The ID of the subscription to update. */
        subscription_id: string;
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordUpdateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordUpdateRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordUpdateRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SubscriptionRecord"];
        };
      };
    };
  };
  /** @deprecated */
  app_subscriptions_add_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordCreateSerializerOldRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordCreateSerializerOldRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordCreateSerializerOldRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["SubscriptionRecord"];
        };
      };
    };
  };
  /** @deprecated */
  app_subscriptions_cancel_create: {
    parameters: {
      query: {
        /** @description Filter to a specific customer. */
        customer_id: string | null;
        /** @description Filter to a specific plan. If not specified, all plans will be included in the cancellation request. */
        plan_id?: string;
        /** @description Filter to a specific set of subscription filters. If your billing model only allows for one subscription per customer, you very likely do not need this field. Must be formatted as a JSON-encoded + stringified list of dictionaries, where each dictionary has a key of 'property_name' and a key of 'value'. */
        subscription_filters?: (components["schemas"]["SubscriptionFilterRequest"])[];
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordCancelRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordCancelRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordCancelRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["SubscriptionRecord"])[];
        };
      };
    };
  };
  app_subscriptions_update_create: {
    parameters: {
      query: {
        /** @description Filter to a specific customer. */
        customer_id: string | null;
        /** @description Filter to a specific plan. */
        plan_id: string;
        /** @description Filter to a specific set of subscription filters. If your billing model only allows for one subscription per customer, you very likely do not need this field. Must be formatted as a JSON-encoded + stringified list of dictionaries, where each dictionary has a key of 'property_name' and a key of 'value'. */
        subscription_filters?: (components["schemas"]["SubscriptionFilterRequest"])[];
      };
    };
    requestBody?: {
      content: {
        "application/json": components["schemas"]["SubscriptionRecordUpdateSerializerOldRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["SubscriptionRecordUpdateSerializerOldRequest"];
        "multipart/form-data": components["schemas"]["SubscriptionRecordUpdateSerializerOldRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["SubscriptionRecord"])[];
        };
      };
    };
  };
  /** @description Get the current settings for the organization. */
  app_switch_organization_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["ChangeUserOrganizationRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ChangeUserOrganizationRequestRequest"];
        "multipart/form-data": components["schemas"]["ChangeUserOrganizationRequestRequest"];
      };
    };
    responses: {
      /** @description No response body */
      200: never;
    };
  };
  /** @description Pagination-enabled endpoint for retrieving an organization's event stream. */
  app_timezones_retrieve: {
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["TimezonesResponse"];
        };
      };
    };
  };
  app_transfer_subscriptions_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["TransferSubscriptionsRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["TransferSubscriptionsRequestRequest"];
        "multipart/form-data": components["schemas"]["TransferSubscriptionsRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["TransferSubscriptionsSuccess"];
        };
      };
      400: {
        content: {
          "application/json": components["schemas"]["TransferSubscriptionsFailure"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing UsageAlerts. */
  app_usage_alerts_list: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["UsageAlert"])[];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing UsageAlerts. */
  app_usage_alerts_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["UsageAlertCreateRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["UsageAlertCreateRequest"];
        "multipart/form-data": components["schemas"]["UsageAlertCreateRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["UsageAlertCreate"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing UsageAlerts. */
  app_usage_alerts_retrieve: {
    parameters: {
      path: {
        usage_alert_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["UsageAlert"];
        };
      };
    };
  };
  /** @description ViewSet for viewing and editing UsageAlerts. */
  app_usage_alerts_destroy: {
    parameters: {
      path: {
        usage_alert_id: string;
      };
    };
    responses: {
      /** @description No response body */
      204: never;
    };
  };
  /** @description Verifies the token and resets the password. */
  app_user_password_reset_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["ResetPasswordRequestRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["ResetPasswordRequestRequest"];
        "multipart/form-data": components["schemas"]["ResetPasswordRequestRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["ResetPasswordSuccess"];
        };
      };
    };
  };
  app_user_password_reset_init_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["EmailRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["EmailRequest"];
        "multipart/form-data": components["schemas"]["EmailRequest"];
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["InitResetPasswordSuccess"];
        };
      };
    };
  };
  app_users_list: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["User"])[];
        };
      };
    };
  };
  app_users_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["UserRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["UserRequest"];
        "multipart/form-data": components["schemas"]["UserRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["User"];
        };
      };
    };
  };
  /** @description API endpoint that allows alerts to be viewed or edited. */
  app_webhooks_list: {
    responses: {
      200: {
        content: {
          "application/json": (components["schemas"]["WebhookEndpoint"])[];
        };
      };
    };
  };
  /** @description API endpoint that allows alerts to be viewed or edited. */
  app_webhooks_create: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["WebhookEndpointRequest"];
        "application/x-www-form-urlencoded": components["schemas"]["WebhookEndpointRequest"];
        "multipart/form-data": components["schemas"]["WebhookEndpointRequest"];
      };
    };
    responses: {
      201: {
        content: {
          "application/json": components["schemas"]["WebhookEndpoint"];
        };
      };
    };
  };
  /** @description API endpoint that allows alerts to be viewed or edited. */
  app_webhooks_retrieve: {
    parameters: {
      path: {
        webhook_endpoint_id: string;
      };
    };
    responses: {
      200: {
        content: {
          "application/json": components["schemas"]["WebhookEndpoint"];
        };
      };
    };
  };
  /** @description API endpoint that allows alerts to be viewed or edited. */
  app_webhooks_destroy: {
    parameters: {
      path: {
        webhook_endpoint_id: string;
      };
    };
    responses: {
      /** @description No response body */
      204: never;
    };
  };
  stripe_webhook_create: {
    responses: {
      /** @description No response body */
      200: never;
    };
  };
}
