# System.Reflection.Metadata

``` diff
+namespace System.Reflection.Metadata {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct AssemblyDefinition {
+        public StringHandle Culture { get; }
+        public AssemblyFlags Flags { get; }
+        public AssemblyHashAlgorithm HashAlgorithm { get; }
+        public StringHandle Name { get; }
+        public BlobHandle PublicKey { get; }
+        public Version Version { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public DeclarativeSecurityAttributeHandleCollection GetDeclarativeSecurityAttributes();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct AssemblyDefinitionHandle : IEquatable<AssemblyDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(AssemblyDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(AssemblyDefinitionHandle left, AssemblyDefinitionHandle right);
+        public static explicit operator AssemblyDefinitionHandle (EntityHandle handle);
+        public static explicit operator AssemblyDefinitionHandle (Handle handle);
+        public static implicit operator Handle (AssemblyDefinitionHandle handle);
+        public static implicit operator EntityHandle (AssemblyDefinitionHandle handle);
+        public static bool operator !=(AssemblyDefinitionHandle left, AssemblyDefinitionHandle right);
+    }
+    public static class AssemblyExtensions {
+        public unsafe static bool TryGetRawMetadata(this Assembly assembly, out byte* blob, out int length);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct AssemblyFile {
+        public bool ContainsMetadata { get; }
+        public BlobHandle HashValue { get; }
+        public StringHandle Name { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct AssemblyFileHandle : IEquatable<AssemblyFileHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(AssemblyFileHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(AssemblyFileHandle left, AssemblyFileHandle right);
+        public static explicit operator AssemblyFileHandle (EntityHandle handle);
+        public static explicit operator AssemblyFileHandle (Handle handle);
+        public static implicit operator Handle (AssemblyFileHandle handle);
+        public static implicit operator EntityHandle (AssemblyFileHandle handle);
+        public static bool operator !=(AssemblyFileHandle left, AssemblyFileHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct AssemblyFileHandleCollection : IEnumerable, IEnumerable<AssemblyFileHandle>, IReadOnlyCollection<AssemblyFileHandle> {
+        public int Count { get; }
+        public AssemblyFileHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<AssemblyFileHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.AssemblyFileHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<AssemblyFileHandle> {
+            public AssemblyFileHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct AssemblyReference {
+        public StringHandle Culture { get; }
+        public AssemblyFlags Flags { get; }
+        public BlobHandle HashValue { get; }
+        public StringHandle Name { get; }
+        public BlobHandle PublicKeyOrToken { get; }
+        public Version Version { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct AssemblyReferenceHandle : IEquatable<AssemblyReferenceHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(AssemblyReferenceHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(AssemblyReferenceHandle left, AssemblyReferenceHandle right);
+        public static explicit operator AssemblyReferenceHandle (EntityHandle handle);
+        public static explicit operator AssemblyReferenceHandle (Handle handle);
+        public static implicit operator Handle (AssemblyReferenceHandle handle);
+        public static implicit operator EntityHandle (AssemblyReferenceHandle handle);
+        public static bool operator !=(AssemblyReferenceHandle left, AssemblyReferenceHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct AssemblyReferenceHandleCollection : IEnumerable, IEnumerable<AssemblyReferenceHandle>, IReadOnlyCollection<AssemblyReferenceHandle> {
+        public int Count { get; }
+        public AssemblyReferenceHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<AssemblyReferenceHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.AssemblyReferenceHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<AssemblyReferenceHandle> {
+            public AssemblyReferenceHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct BlobHandle : IEquatable<BlobHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(BlobHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(BlobHandle left, BlobHandle right);
+        public static explicit operator BlobHandle (Handle handle);
+        public static implicit operator Handle (BlobHandle handle);
+        public static bool operator !=(BlobHandle left, BlobHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct BlobReader {
+        public unsafe BlobReader(byte* buffer, int length);
+        public int Length { get; }
+        public int Offset { get; }
+        public int RemainingBytes { get; }
+        public BlobHandle ReadBlobHandle();
+        public bool ReadBoolean();
+        public byte ReadByte();
+        public byte[] ReadBytes(int byteCount);
+        public char ReadChar();
+        public int ReadCompressedInteger();
+        public int ReadCompressedSignedInteger();
+        public object ReadConstant(ConstantTypeCode typeCode);
+        public DateTime ReadDateTime();
+        public Decimal ReadDecimal();
+        public double ReadDouble();
+        public Guid ReadGuid();
+        public short ReadInt16();
+        public int ReadInt32();
+        public long ReadInt64();
+        public sbyte ReadSByte();
+        public SerializationTypeCode ReadSerializationTypeCode();
+        public string ReadSerializedString();
+        public SignatureHeader ReadSignatureHeader();
+        public SignatureTypeCode ReadSignatureTypeCode();
+        public float ReadSingle();
+        public EntityHandle ReadTypeHandle();
+        public ushort ReadUInt16();
+        public uint ReadUInt32();
+        public ulong ReadUInt64();
+        public string ReadUTF16(int byteCount);
+        public string ReadUTF8(int byteCount);
+        public void Reset();
+        public bool TryReadCompressedInteger(out int value);
+        public bool TryReadCompressedSignedInteger(out int value);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Constant {
+        public EntityHandle Parent { get; }
+        public ConstantTypeCode TypeCode { get; }
+        public BlobHandle Value { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ConstantHandle : IEquatable<ConstantHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ConstantHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(ConstantHandle left, ConstantHandle right);
+        public static explicit operator ConstantHandle (EntityHandle handle);
+        public static explicit operator ConstantHandle (Handle handle);
+        public static implicit operator Handle (ConstantHandle handle);
+        public static implicit operator EntityHandle (ConstantHandle handle);
+        public static bool operator !=(ConstantHandle left, ConstantHandle right);
+    }
+    public enum ConstantTypeCode : byte {
+        Boolean = (byte)2,
+        Byte = (byte)5,
+        Char = (byte)3,
+        Double = (byte)13,
+        Int16 = (byte)6,
+        Int32 = (byte)8,
+        Int64 = (byte)10,
+        Invalid = (byte)0,
+        NullReference = (byte)18,
+        SByte = (byte)4,
+        Single = (byte)12,
+        String = (byte)14,
+        UInt16 = (byte)7,
+        UInt32 = (byte)9,
+        UInt64 = (byte)11,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CustomAttribute {
+        public EntityHandle Constructor { get; }
+        public EntityHandle Parent { get; }
+        public BlobHandle Value { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CustomAttributeHandle : IEquatable<CustomAttributeHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(CustomAttributeHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(CustomAttributeHandle left, CustomAttributeHandle right);
+        public static explicit operator CustomAttributeHandle (EntityHandle handle);
+        public static explicit operator CustomAttributeHandle (Handle handle);
+        public static implicit operator Handle (CustomAttributeHandle handle);
+        public static implicit operator EntityHandle (CustomAttributeHandle handle);
+        public static bool operator !=(CustomAttributeHandle left, CustomAttributeHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CustomAttributeHandleCollection : IEnumerable, IEnumerable<CustomAttributeHandle>, IReadOnlyCollection<CustomAttributeHandle> {
+        public int Count { get; }
+        public CustomAttributeHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<CustomAttributeHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.CustomAttributeHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<CustomAttributeHandle> {
+            public CustomAttributeHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public enum CustomAttributeNamedArgumentKind : byte {
+        Field = (byte)83,
+        Property = (byte)84,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CustomDebugInformation {
+        public GuidHandle Kind { get; }
+        public EntityHandle Parent { get; }
+        public BlobHandle Value { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CustomDebugInformationHandle : IEquatable<CustomDebugInformationHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(CustomDebugInformationHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(CustomDebugInformationHandle left, CustomDebugInformationHandle right);
+        public static explicit operator CustomDebugInformationHandle (EntityHandle handle);
+        public static explicit operator CustomDebugInformationHandle (Handle handle);
+        public static implicit operator Handle (CustomDebugInformationHandle handle);
+        public static implicit operator EntityHandle (CustomDebugInformationHandle handle);
+        public static bool operator !=(CustomDebugInformationHandle left, CustomDebugInformationHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CustomDebugInformationHandleCollection : IEnumerable, IEnumerable<CustomDebugInformationHandle>, IReadOnlyCollection<CustomDebugInformationHandle> {
+        public int Count { get; }
+        public CustomDebugInformationHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<CustomDebugInformationHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.CustomDebugInformationHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<CustomDebugInformationHandle> {
+            public CustomDebugInformationHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public sealed class DebugMetadataHeader {
+        public MethodDefinitionHandle EntryPoint { get; }
+        public ImmutableArray<byte> Id { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct DeclarativeSecurityAttribute {
+        public DeclarativeSecurityAction Action { get; }
+        public EntityHandle Parent { get; }
+        public BlobHandle PermissionSet { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct DeclarativeSecurityAttributeHandle : IEquatable<DeclarativeSecurityAttributeHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(DeclarativeSecurityAttributeHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(DeclarativeSecurityAttributeHandle left, DeclarativeSecurityAttributeHandle right);
+        public static explicit operator DeclarativeSecurityAttributeHandle (EntityHandle handle);
+        public static explicit operator DeclarativeSecurityAttributeHandle (Handle handle);
+        public static implicit operator Handle (DeclarativeSecurityAttributeHandle handle);
+        public static implicit operator EntityHandle (DeclarativeSecurityAttributeHandle handle);
+        public static bool operator !=(DeclarativeSecurityAttributeHandle left, DeclarativeSecurityAttributeHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct DeclarativeSecurityAttributeHandleCollection : IEnumerable, IEnumerable<DeclarativeSecurityAttributeHandle>, IReadOnlyCollection<DeclarativeSecurityAttributeHandle> {
+        public int Count { get; }
+        public DeclarativeSecurityAttributeHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<DeclarativeSecurityAttributeHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.DeclarativeSecurityAttributeHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<DeclarativeSecurityAttributeHandle> {
+            public DeclarativeSecurityAttributeHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Document {
+        public BlobHandle Hash { get; }
+        public GuidHandle HashAlgorithm { get; }
+        public GuidHandle Language { get; }
+        public DocumentNameBlobHandle Name { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct DocumentHandle : IEquatable<DocumentHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(DocumentHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(DocumentHandle left, DocumentHandle right);
+        public static explicit operator DocumentHandle (EntityHandle handle);
+        public static explicit operator DocumentHandle (Handle handle);
+        public static implicit operator Handle (DocumentHandle handle);
+        public static implicit operator EntityHandle (DocumentHandle handle);
+        public static bool operator !=(DocumentHandle left, DocumentHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct DocumentHandleCollection : IEnumerable, IEnumerable<DocumentHandle>, IReadOnlyCollection<DocumentHandle> {
+        public int Count { get; }
+        public DocumentHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<DocumentHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.DocumentHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<DocumentHandle> {
+            public DocumentHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct DocumentNameBlobHandle : IEquatable<DocumentNameBlobHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(DocumentNameBlobHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(DocumentNameBlobHandle left, DocumentNameBlobHandle right);
+        public static explicit operator DocumentNameBlobHandle (BlobHandle handle);
+        public static implicit operator BlobHandle (DocumentNameBlobHandle handle);
+        public static bool operator !=(DocumentNameBlobHandle left, DocumentNameBlobHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct EntityHandle : IEquatable<EntityHandle> {
+        public static readonly AssemblyDefinitionHandle AssemblyDefinition;
+        public static readonly ModuleDefinitionHandle ModuleDefinition;
+        public bool IsNil { get; }
+        public HandleKind Kind { get; }
+        public override bool Equals(object obj);
+        public bool Equals(EntityHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(EntityHandle left, EntityHandle right);
+        public static explicit operator EntityHandle (Handle handle);
+        public static implicit operator Handle (EntityHandle handle);
+        public static bool operator !=(EntityHandle left, EntityHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct EventAccessors {
+        public MethodDefinitionHandle Adder { get; }
+        public MethodDefinitionHandle Raiser { get; }
+        public MethodDefinitionHandle Remover { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct EventDefinition {
+        public EventAttributes Attributes { get; }
+        public StringHandle Name { get; }
+        public EntityHandle Type { get; }
+        public EventAccessors GetAccessors();
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct EventDefinitionHandle : IEquatable<EventDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(EventDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(EventDefinitionHandle left, EventDefinitionHandle right);
+        public static explicit operator EventDefinitionHandle (EntityHandle handle);
+        public static explicit operator EventDefinitionHandle (Handle handle);
+        public static implicit operator Handle (EventDefinitionHandle handle);
+        public static implicit operator EntityHandle (EventDefinitionHandle handle);
+        public static bool operator !=(EventDefinitionHandle left, EventDefinitionHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct EventDefinitionHandleCollection : IEnumerable, IEnumerable<EventDefinitionHandle>, IReadOnlyCollection<EventDefinitionHandle> {
+        public int Count { get; }
+        public EventDefinitionHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<EventDefinitionHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.EventDefinitionHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<EventDefinitionHandle> {
+            public EventDefinitionHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ExceptionRegion {
+        public EntityHandle CatchType { get; }
+        public int FilterOffset { get; }
+        public int HandlerLength { get; }
+        public int HandlerOffset { get; }
+        public ExceptionRegionKind Kind { get; }
+        public int TryLength { get; }
+        public int TryOffset { get; }
+    }
+    public enum ExceptionRegionKind : ushort {
+        Catch = (ushort)0,
+        Fault = (ushort)4,
+        Filter = (ushort)1,
+        Finally = (ushort)2,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ExportedType {
+        public TypeAttributes Attributes { get; }
+        public EntityHandle Implementation { get; }
+        public bool IsForwarder { get; }
+        public StringHandle Name { get; }
+        public StringHandle Namespace { get; }
+        public NamespaceDefinitionHandle NamespaceDefinition { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ExportedTypeHandle : IEquatable<ExportedTypeHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ExportedTypeHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(ExportedTypeHandle left, ExportedTypeHandle right);
+        public static explicit operator ExportedTypeHandle (EntityHandle handle);
+        public static explicit operator ExportedTypeHandle (Handle handle);
+        public static implicit operator Handle (ExportedTypeHandle handle);
+        public static implicit operator EntityHandle (ExportedTypeHandle handle);
+        public static bool operator !=(ExportedTypeHandle left, ExportedTypeHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ExportedTypeHandleCollection : IEnumerable, IEnumerable<ExportedTypeHandle>, IReadOnlyCollection<ExportedTypeHandle> {
+        public int Count { get; }
+        public ExportedTypeHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<ExportedTypeHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.ExportedTypeHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<ExportedTypeHandle> {
+            public ExportedTypeHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct FieldDefinition {
+        public FieldAttributes Attributes { get; }
+        public StringHandle Name { get; }
+        public BlobHandle Signature { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public TypeDefinitionHandle GetDeclaringType();
+        public ConstantHandle GetDefaultValue();
+        public BlobHandle GetMarshallingDescriptor();
+        public int GetOffset();
+        public int GetRelativeVirtualAddress();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct FieldDefinitionHandle : IEquatable<FieldDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(FieldDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(FieldDefinitionHandle left, FieldDefinitionHandle right);
+        public static explicit operator FieldDefinitionHandle (EntityHandle handle);
+        public static explicit operator FieldDefinitionHandle (Handle handle);
+        public static implicit operator Handle (FieldDefinitionHandle handle);
+        public static implicit operator EntityHandle (FieldDefinitionHandle handle);
+        public static bool operator !=(FieldDefinitionHandle left, FieldDefinitionHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct FieldDefinitionHandleCollection : IEnumerable, IEnumerable<FieldDefinitionHandle>, IReadOnlyCollection<FieldDefinitionHandle> {
+        public int Count { get; }
+        public FieldDefinitionHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<FieldDefinitionHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.FieldDefinitionHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<FieldDefinitionHandle> {
+            public FieldDefinitionHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct GenericParameter {
+        public GenericParameterAttributes Attributes { get; }
+        public int Index { get; }
+        public StringHandle Name { get; }
+        public EntityHandle Parent { get; }
+        public GenericParameterConstraintHandleCollection GetConstraints();
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct GenericParameterConstraint {
+        public GenericParameterHandle Parameter { get; }
+        public EntityHandle Type { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct GenericParameterConstraintHandle : IEquatable<GenericParameterConstraintHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(GenericParameterConstraintHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(GenericParameterConstraintHandle left, GenericParameterConstraintHandle right);
+        public static explicit operator GenericParameterConstraintHandle (EntityHandle handle);
+        public static explicit operator GenericParameterConstraintHandle (Handle handle);
+        public static implicit operator Handle (GenericParameterConstraintHandle handle);
+        public static implicit operator EntityHandle (GenericParameterConstraintHandle handle);
+        public static bool operator !=(GenericParameterConstraintHandle left, GenericParameterConstraintHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct GenericParameterConstraintHandleCollection : IEnumerable, IEnumerable<GenericParameterConstraintHandle>, IReadOnlyCollection<GenericParameterConstraintHandle>, IReadOnlyList<GenericParameterConstraintHandle> {
+        public int Count { get; }
+        public GenericParameterConstraintHandle this[int index] { get; }
+        public GenericParameterConstraintHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<GenericParameterConstraintHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.GenericParameterConstraintHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<GenericParameterConstraintHandle> {
+            public GenericParameterConstraintHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct GenericParameterHandle : IEquatable<GenericParameterHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(GenericParameterHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(GenericParameterHandle left, GenericParameterHandle right);
+        public static explicit operator GenericParameterHandle (EntityHandle handle);
+        public static explicit operator GenericParameterHandle (Handle handle);
+        public static implicit operator Handle (GenericParameterHandle handle);
+        public static implicit operator EntityHandle (GenericParameterHandle handle);
+        public static bool operator !=(GenericParameterHandle left, GenericParameterHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct GenericParameterHandleCollection : IEnumerable, IEnumerable<GenericParameterHandle>, IReadOnlyCollection<GenericParameterHandle>, IReadOnlyList<GenericParameterHandle> {
+        public int Count { get; }
+        public GenericParameterHandle this[int index] { get; }
+        public GenericParameterHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<GenericParameterHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.GenericParameterHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<GenericParameterHandle> {
+            public GenericParameterHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct GuidHandle : IEquatable<GuidHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(GuidHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(GuidHandle left, GuidHandle right);
+        public static explicit operator GuidHandle (Handle handle);
+        public static implicit operator Handle (GuidHandle handle);
+        public static bool operator !=(GuidHandle left, GuidHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Handle : IEquatable<Handle> {
+        public static readonly AssemblyDefinitionHandle AssemblyDefinition;
+        public static readonly ModuleDefinitionHandle ModuleDefinition;
+        public bool IsNil { get; }
+        public HandleKind Kind { get; }
+        public override bool Equals(object obj);
+        public bool Equals(Handle other);
+        public override int GetHashCode();
+        public static bool operator ==(Handle left, Handle right);
+        public static bool operator !=(Handle left, Handle right);
+    }
+    public sealed class HandleComparer : IComparer<EntityHandle>, IComparer<Handle>, IEqualityComparer<EntityHandle>, IEqualityComparer<Handle> {
+        public static HandleComparer Default { get; }
+        public int Compare(EntityHandle x, EntityHandle y);
+        public int Compare(Handle x, Handle y);
+        public bool Equals(EntityHandle x, EntityHandle y);
+        public bool Equals(Handle x, Handle y);
+        public int GetHashCode(EntityHandle obj);
+        public int GetHashCode(Handle obj);
+    }
+    public enum HandleKind : byte {
+        AssemblyDefinition = (byte)32,
+        AssemblyFile = (byte)38,
+        AssemblyReference = (byte)35,
+        Blob = (byte)113,
+        Constant = (byte)11,
+        CustomAttribute = (byte)12,
+        CustomDebugInformation = (byte)55,
+        DeclarativeSecurityAttribute = (byte)14,
+        Document = (byte)48,
+        EventDefinition = (byte)20,
+        ExportedType = (byte)39,
+        FieldDefinition = (byte)4,
+        GenericParameter = (byte)42,
+        GenericParameterConstraint = (byte)44,
+        Guid = (byte)114,
+        ImportScope = (byte)53,
+        InterfaceImplementation = (byte)9,
+        LocalConstant = (byte)52,
+        LocalScope = (byte)50,
+        LocalVariable = (byte)51,
+        ManifestResource = (byte)40,
+        MemberReference = (byte)10,
+        MethodDebugInformation = (byte)49,
+        MethodDefinition = (byte)6,
+        MethodImplementation = (byte)25,
+        MethodSpecification = (byte)43,
+        ModuleDefinition = (byte)0,
+        ModuleReference = (byte)26,
+        NamespaceDefinition = (byte)124,
+        Parameter = (byte)8,
+        PropertyDefinition = (byte)23,
+        StandaloneSignature = (byte)17,
+        String = (byte)120,
+        TypeDefinition = (byte)2,
+        TypeReference = (byte)1,
+        TypeSpecification = (byte)27,
+        UserString = (byte)112,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ImportDefinition {
+        public BlobHandle Alias { get; }
+        public ImportDefinitionKind Kind { get; }
+        public AssemblyReferenceHandle TargetAssembly { get; }
+        public BlobHandle TargetNamespace { get; }
+        public EntityHandle TargetType { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ImportDefinitionCollection : IEnumerable, IEnumerable<ImportDefinition> {
+        public ImportDefinitionCollection.Enumerator GetEnumerator();
+        IEnumerator<ImportDefinition> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.ImportDefinition>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<ImportDefinition> {
+            public ImportDefinition Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            public void Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public enum ImportDefinitionKind {
+        AliasAssemblyNamespace = 8,
+        AliasAssemblyReference = 6,
+        AliasNamespace = 7,
+        AliasType = 9,
+        ImportAssemblyNamespace = 2,
+        ImportAssemblyReferenceAlias = 5,
+        ImportNamespace = 1,
+        ImportType = 3,
+        ImportXmlNamespace = 4,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ImportScope {
+        public BlobHandle ImportsBlob { get; }
+        public ImportScopeHandle Parent { get; }
+        public ImportDefinitionCollection GetImports();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ImportScopeCollection : IEnumerable, IEnumerable<ImportScopeHandle>, IReadOnlyCollection<ImportScopeHandle> {
+        public int Count { get; }
+        public ImportScopeCollection.Enumerator GetEnumerator();
+        IEnumerator<ImportScopeHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.ImportScopeHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<ImportScopeHandle> {
+            public ImportScopeHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ImportScopeHandle : IEquatable<ImportScopeHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ImportScopeHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(ImportScopeHandle left, ImportScopeHandle right);
+        public static explicit operator ImportScopeHandle (EntityHandle handle);
+        public static explicit operator ImportScopeHandle (Handle handle);
+        public static implicit operator Handle (ImportScopeHandle handle);
+        public static implicit operator EntityHandle (ImportScopeHandle handle);
+        public static bool operator !=(ImportScopeHandle left, ImportScopeHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct InterfaceImplementation {
+        public EntityHandle Interface { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct InterfaceImplementationHandle : IEquatable<InterfaceImplementationHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(InterfaceImplementationHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(InterfaceImplementationHandle left, InterfaceImplementationHandle right);
+        public static explicit operator InterfaceImplementationHandle (EntityHandle handle);
+        public static explicit operator InterfaceImplementationHandle (Handle handle);
+        public static implicit operator Handle (InterfaceImplementationHandle handle);
+        public static implicit operator EntityHandle (InterfaceImplementationHandle handle);
+        public static bool operator !=(InterfaceImplementationHandle left, InterfaceImplementationHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct InterfaceImplementationHandleCollection : IEnumerable, IEnumerable<InterfaceImplementationHandle>, IReadOnlyCollection<InterfaceImplementationHandle> {
+        public int Count { get; }
+        public InterfaceImplementationHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<InterfaceImplementationHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.InterfaceImplementationHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<InterfaceImplementationHandle> {
+            public InterfaceImplementationHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct LocalConstant {
+        public StringHandle Name { get; }
+        public BlobHandle Signature { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct LocalConstantHandle : IEquatable<LocalConstantHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(LocalConstantHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(LocalConstantHandle left, LocalConstantHandle right);
+        public static explicit operator LocalConstantHandle (EntityHandle handle);
+        public static explicit operator LocalConstantHandle (Handle handle);
+        public static implicit operator Handle (LocalConstantHandle handle);
+        public static implicit operator EntityHandle (LocalConstantHandle handle);
+        public static bool operator !=(LocalConstantHandle left, LocalConstantHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct LocalConstantHandleCollection : IEnumerable, IEnumerable<LocalConstantHandle>, IReadOnlyCollection<LocalConstantHandle> {
+        public int Count { get; }
+        public LocalConstantHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<LocalConstantHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.LocalConstantHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<LocalConstantHandle> {
+            public LocalConstantHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct LocalScope {
+        public int EndOffset { get; }
+        public ImportScopeHandle ImportScope { get; }
+        public int Length { get; }
+        public MethodDefinitionHandle Method { get; }
+        public int StartOffset { get; }
+        public LocalScopeHandleCollection.ChildrenEnumerator GetChildren();
+        public LocalConstantHandleCollection GetLocalConstants();
+        public LocalVariableHandleCollection GetLocalVariables();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct LocalScopeHandle : IEquatable<LocalScopeHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(LocalScopeHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(LocalScopeHandle left, LocalScopeHandle right);
+        public static explicit operator LocalScopeHandle (EntityHandle handle);
+        public static explicit operator LocalScopeHandle (Handle handle);
+        public static implicit operator Handle (LocalScopeHandle handle);
+        public static implicit operator EntityHandle (LocalScopeHandle handle);
+        public static bool operator !=(LocalScopeHandle left, LocalScopeHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct LocalScopeHandleCollection : IEnumerable, IEnumerable<LocalScopeHandle>, IReadOnlyCollection<LocalScopeHandle> {
+        public int Count { get; }
+        public LocalScopeHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<LocalScopeHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.LocalScopeHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct ChildrenEnumerator : IDisposable, IEnumerator, IEnumerator<LocalScopeHandle> {
+            public LocalScopeHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<LocalScopeHandle> {
+            public LocalScopeHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct LocalVariable {
+        public LocalVariableAttributes Attributes { get; }
+        public int Index { get; }
+        public StringHandle Name { get; }
+    }
+    public enum LocalVariableAttributes {
+        DebuggerHidden = 1,
+        None = 0,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct LocalVariableHandle : IEquatable<LocalVariableHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(LocalVariableHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(LocalVariableHandle left, LocalVariableHandle right);
+        public static explicit operator LocalVariableHandle (EntityHandle handle);
+        public static explicit operator LocalVariableHandle (Handle handle);
+        public static implicit operator Handle (LocalVariableHandle handle);
+        public static implicit operator EntityHandle (LocalVariableHandle handle);
+        public static bool operator !=(LocalVariableHandle left, LocalVariableHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct LocalVariableHandleCollection : IEnumerable, IEnumerable<LocalVariableHandle>, IReadOnlyCollection<LocalVariableHandle> {
+        public int Count { get; }
+        public LocalVariableHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<LocalVariableHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.LocalVariableHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<LocalVariableHandle> {
+            public LocalVariableHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ManifestResource {
+        public ManifestResourceAttributes Attributes { get; }
+        public EntityHandle Implementation { get; }
+        public StringHandle Name { get; }
+        public long Offset { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ManifestResourceHandle : IEquatable<ManifestResourceHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ManifestResourceHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(ManifestResourceHandle left, ManifestResourceHandle right);
+        public static explicit operator ManifestResourceHandle (EntityHandle handle);
+        public static explicit operator ManifestResourceHandle (Handle handle);
+        public static implicit operator Handle (ManifestResourceHandle handle);
+        public static implicit operator EntityHandle (ManifestResourceHandle handle);
+        public static bool operator !=(ManifestResourceHandle left, ManifestResourceHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ManifestResourceHandleCollection : IEnumerable, IEnumerable<ManifestResourceHandle>, IReadOnlyCollection<ManifestResourceHandle> {
+        public int Count { get; }
+        public ManifestResourceHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<ManifestResourceHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.ManifestResourceHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<ManifestResourceHandle> {
+            public ManifestResourceHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MemberReference {
+        public StringHandle Name { get; }
+        public EntityHandle Parent { get; }
+        public BlobHandle Signature { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public MemberReferenceKind GetKind();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MemberReferenceHandle : IEquatable<MemberReferenceHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(MemberReferenceHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(MemberReferenceHandle left, MemberReferenceHandle right);
+        public static explicit operator MemberReferenceHandle (EntityHandle handle);
+        public static explicit operator MemberReferenceHandle (Handle handle);
+        public static implicit operator Handle (MemberReferenceHandle handle);
+        public static implicit operator EntityHandle (MemberReferenceHandle handle);
+        public static bool operator !=(MemberReferenceHandle left, MemberReferenceHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MemberReferenceHandleCollection : IEnumerable, IEnumerable<MemberReferenceHandle>, IReadOnlyCollection<MemberReferenceHandle> {
+        public int Count { get; }
+        public MemberReferenceHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<MemberReferenceHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.MemberReferenceHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<MemberReferenceHandle> {
+            public MemberReferenceHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public enum MemberReferenceKind {
+        Field = 1,
+        Method = 0,
+    }
+    public enum MetadataKind {
+        Ecma335 = 0,
+        ManagedWindowsMetadata = 2,
+        WindowsMetadata = 1,
+    }
+    public sealed class MetadataReader {
+        public unsafe MetadataReader(byte* metadata, int length);
+        public unsafe MetadataReader(byte* metadata, int length, MetadataReaderOptions options);
+        public unsafe MetadataReader(byte* metadata, int length, MetadataReaderOptions options, MetadataStringDecoder utf8Decoder);
+        public AssemblyFileHandleCollection AssemblyFiles { get; }
+        public AssemblyReferenceHandleCollection AssemblyReferences { get; }
+        public CustomAttributeHandleCollection CustomAttributes { get; }
+        public CustomDebugInformationHandleCollection CustomDebugInformation { get; }
+        public DebugMetadataHeader DebugMetadataHeader { get; }
+        public DeclarativeSecurityAttributeHandleCollection DeclarativeSecurityAttributes { get; }
+        public DocumentHandleCollection Documents { get; }
+        public EventDefinitionHandleCollection EventDefinitions { get; }
+        public ExportedTypeHandleCollection ExportedTypes { get; }
+        public FieldDefinitionHandleCollection FieldDefinitions { get; }
+        public ImportScopeCollection ImportScopes { get; }
+        public bool IsAssembly { get; }
+        public LocalConstantHandleCollection LocalConstants { get; }
+        public LocalScopeHandleCollection LocalScopes { get; }
+        public LocalVariableHandleCollection LocalVariables { get; }
+        public ManifestResourceHandleCollection ManifestResources { get; }
+        public MemberReferenceHandleCollection MemberReferences { get; }
+        public MetadataKind MetadataKind { get; }
+        public string MetadataVersion { get; }
+        public MethodDebugInformationHandleCollection MethodDebugInformation { get; }
+        public MethodDefinitionHandleCollection MethodDefinitions { get; }
+        public MetadataReaderOptions Options { get; }
+        public PropertyDefinitionHandleCollection PropertyDefinitions { get; }
+        public MetadataStringComparer StringComparer { get; }
+        public TypeDefinitionHandleCollection TypeDefinitions { get; }
+        public TypeReferenceHandleCollection TypeReferences { get; }
+        public AssemblyDefinition GetAssemblyDefinition();
+        public AssemblyFile GetAssemblyFile(AssemblyFileHandle handle);
+        public AssemblyReference GetAssemblyReference(AssemblyReferenceHandle handle);
+        public byte[] GetBlobBytes(BlobHandle handle);
+        public ImmutableArray<byte> GetBlobContent(BlobHandle handle);
+        public BlobReader GetBlobReader(BlobHandle handle);
+        public Constant GetConstant(ConstantHandle handle);
+        public CustomAttribute GetCustomAttribute(CustomAttributeHandle handle);
+        public CustomAttributeHandleCollection GetCustomAttributes(EntityHandle handle);
+        public CustomDebugInformation GetCustomDebugInformation(CustomDebugInformationHandle handle);
+        public CustomDebugInformationHandleCollection GetCustomDebugInformation(EntityHandle handle);
+        public DeclarativeSecurityAttribute GetDeclarativeSecurityAttribute(DeclarativeSecurityAttributeHandle handle);
+        public Document GetDocument(DocumentHandle handle);
+        public EventDefinition GetEventDefinition(EventDefinitionHandle handle);
+        public ExportedType GetExportedType(ExportedTypeHandle handle);
+        public FieldDefinition GetFieldDefinition(FieldDefinitionHandle handle);
+        public GenericParameter GetGenericParameter(GenericParameterHandle handle);
+        public GenericParameterConstraint GetGenericParameterConstraint(GenericParameterConstraintHandle handle);
+        public Guid GetGuid(GuidHandle handle);
+        public ImportScope GetImportScope(ImportScopeHandle handle);
+        public InterfaceImplementation GetInterfaceImplementation(InterfaceImplementationHandle handle);
+        public LocalConstant GetLocalConstant(LocalConstantHandle handle);
+        public LocalScope GetLocalScope(LocalScopeHandle handle);
+        public LocalScopeHandleCollection GetLocalScopes(MethodDebugInformationHandle handle);
+        public LocalScopeHandleCollection GetLocalScopes(MethodDefinitionHandle handle);
+        public LocalVariable GetLocalVariable(LocalVariableHandle handle);
+        public ManifestResource GetManifestResource(ManifestResourceHandle handle);
+        public MemberReference GetMemberReference(MemberReferenceHandle handle);
+        public MethodDebugInformation GetMethodDebugInformation(MethodDebugInformationHandle handle);
+        public MethodDebugInformation GetMethodDebugInformation(MethodDefinitionHandle handle);
+        public MethodDefinition GetMethodDefinition(MethodDefinitionHandle handle);
+        public MethodImplementation GetMethodImplementation(MethodImplementationHandle handle);
+        public MethodSpecification GetMethodSpecification(MethodSpecificationHandle handle);
+        public ModuleDefinition GetModuleDefinition();
+        public ModuleReference GetModuleReference(ModuleReferenceHandle handle);
+        public NamespaceDefinition GetNamespaceDefinition(NamespaceDefinitionHandle handle);
+        public NamespaceDefinition GetNamespaceDefinitionRoot();
+        public Parameter GetParameter(ParameterHandle handle);
+        public PropertyDefinition GetPropertyDefinition(PropertyDefinitionHandle handle);
+        public StandaloneSignature GetStandaloneSignature(StandaloneSignatureHandle handle);
+        public string GetString(DocumentNameBlobHandle handle);
+        public string GetString(NamespaceDefinitionHandle handle);
+        public string GetString(StringHandle handle);
+        public TypeDefinition GetTypeDefinition(TypeDefinitionHandle handle);
+        public TypeReference GetTypeReference(TypeReferenceHandle handle);
+        public TypeSpecification GetTypeSpecification(TypeSpecificationHandle handle);
+        public string GetUserString(UserStringHandle handle);
+    }
+    public enum MetadataReaderOptions {
+        ApplyWindowsRuntimeProjections = 1,
+        Default = 1,
+        None = 0,
+    }
+    public sealed class MetadataReaderProvider : IDisposable {
+        public void Dispose();
+        public unsafe static MetadataReaderProvider FromMetadataImage(byte* start, int size);
+        public static MetadataReaderProvider FromMetadataImage(ImmutableArray<byte> image);
+        public static MetadataReaderProvider FromMetadataStream(Stream stream, MetadataStreamOptions options=(MetadataStreamOptions)(0), int size=0);
+        public unsafe static MetadataReaderProvider FromPortablePdbImage(byte* start, int size);
+        public static MetadataReaderProvider FromPortablePdbImage(ImmutableArray<byte> image);
+        public static MetadataReaderProvider FromPortablePdbStream(Stream stream, MetadataStreamOptions options=(MetadataStreamOptions)(0), int size=0);
+        public MetadataReader GetMetadataReader(MetadataReaderOptions options=(MetadataReaderOptions)(1), MetadataStringDecoder utf8Decoder=null);
+    }
+    public enum MetadataStreamOptions {
+        Default = 0,
+        LeaveOpen = 1,
+        PrefetchMetadata = 2,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MetadataStringComparer {
+        public bool Equals(DocumentNameBlobHandle handle, string value);
+        public bool Equals(DocumentNameBlobHandle handle, string value, bool ignoreCase);
+        public bool Equals(NamespaceDefinitionHandle handle, string value);
+        public bool Equals(NamespaceDefinitionHandle handle, string value, bool ignoreCase);
+        public bool Equals(StringHandle handle, string value);
+        public bool Equals(StringHandle handle, string value, bool ignoreCase);
+        public bool StartsWith(StringHandle handle, string value);
+        public bool StartsWith(StringHandle handle, string value, bool ignoreCase);
+    }
+    public class MetadataStringDecoder {
+        public MetadataStringDecoder(Encoding encoding);
+        public static MetadataStringDecoder DefaultUTF8 { get; }
+        public Encoding Encoding { get; }
+        public unsafe virtual string GetString(byte* bytes, int byteCount);
+    }
+    public sealed class MethodBodyBlock {
+        public ImmutableArray<ExceptionRegion> ExceptionRegions { get; }
+        public StandaloneSignatureHandle LocalSignature { get; }
+        public bool LocalVariablesInitialized { get; }
+        public int MaxStack { get; }
+        public int Size { get; }
+        public static MethodBodyBlock Create(BlobReader reader);
+        public byte[] GetILBytes();
+        public ImmutableArray<byte> GetILContent();
+        public BlobReader GetILReader();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodDebugInformation {
+        public DocumentHandle Document { get; }
+        public StandaloneSignatureHandle LocalSignature { get; }
+        public BlobHandle SequencePointsBlob { get; }
+        public SequencePointCollection GetSequencePoints();
+        public MethodDefinitionHandle GetStateMachineKickoffMethod();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodDebugInformationHandle : IEquatable<MethodDebugInformationHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(MethodDebugInformationHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(MethodDebugInformationHandle left, MethodDebugInformationHandle right);
+        public static explicit operator MethodDebugInformationHandle (EntityHandle handle);
+        public static explicit operator MethodDebugInformationHandle (Handle handle);
+        public static implicit operator Handle (MethodDebugInformationHandle handle);
+        public static implicit operator EntityHandle (MethodDebugInformationHandle handle);
+        public static bool operator !=(MethodDebugInformationHandle left, MethodDebugInformationHandle right);
+        public MethodDefinitionHandle ToDefinitionHandle();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodDebugInformationHandleCollection : IEnumerable, IEnumerable<MethodDebugInformationHandle>, IReadOnlyCollection<MethodDebugInformationHandle> {
+        public int Count { get; }
+        public MethodDebugInformationHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<MethodDebugInformationHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.MethodDebugInformationHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<MethodDebugInformationHandle> {
+            public MethodDebugInformationHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodDefinition {
+        public MethodAttributes Attributes { get; }
+        public MethodImplAttributes ImplAttributes { get; }
+        public StringHandle Name { get; }
+        public int RelativeVirtualAddress { get; }
+        public BlobHandle Signature { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public DeclarativeSecurityAttributeHandleCollection GetDeclarativeSecurityAttributes();
+        public TypeDefinitionHandle GetDeclaringType();
+        public GenericParameterHandleCollection GetGenericParameters();
+        public MethodImport GetImport();
+        public ParameterHandleCollection GetParameters();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodDefinitionHandle : IEquatable<MethodDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(MethodDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(MethodDefinitionHandle left, MethodDefinitionHandle right);
+        public static explicit operator MethodDefinitionHandle (EntityHandle handle);
+        public static explicit operator MethodDefinitionHandle (Handle handle);
+        public static implicit operator Handle (MethodDefinitionHandle handle);
+        public static implicit operator EntityHandle (MethodDefinitionHandle handle);
+        public static bool operator !=(MethodDefinitionHandle left, MethodDefinitionHandle right);
+        public MethodDebugInformationHandle ToDebugInformationHandle();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodDefinitionHandleCollection : IEnumerable, IEnumerable<MethodDefinitionHandle>, IReadOnlyCollection<MethodDefinitionHandle> {
+        public int Count { get; }
+        public MethodDefinitionHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<MethodDefinitionHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.MethodDefinitionHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<MethodDefinitionHandle> {
+            public MethodDefinitionHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodImplementation {
+        public EntityHandle MethodBody { get; }
+        public EntityHandle MethodDeclaration { get; }
+        public TypeDefinitionHandle Type { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodImplementationHandle : IEquatable<MethodImplementationHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(MethodImplementationHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(MethodImplementationHandle left, MethodImplementationHandle right);
+        public static explicit operator MethodImplementationHandle (EntityHandle handle);
+        public static explicit operator MethodImplementationHandle (Handle handle);
+        public static implicit operator Handle (MethodImplementationHandle handle);
+        public static implicit operator EntityHandle (MethodImplementationHandle handle);
+        public static bool operator !=(MethodImplementationHandle left, MethodImplementationHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodImplementationHandleCollection : IEnumerable, IEnumerable<MethodImplementationHandle>, IReadOnlyCollection<MethodImplementationHandle> {
+        public int Count { get; }
+        public MethodImplementationHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<MethodImplementationHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.MethodImplementationHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<MethodImplementationHandle> {
+            public MethodImplementationHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodImport {
+        public MethodImportAttributes Attributes { get; }
+        public ModuleReferenceHandle Module { get; }
+        public StringHandle Name { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodSpecification {
+        public EntityHandle Method { get; }
+        public BlobHandle Signature { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodSpecificationHandle : IEquatable<MethodSpecificationHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(MethodSpecificationHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(MethodSpecificationHandle left, MethodSpecificationHandle right);
+        public static explicit operator MethodSpecificationHandle (EntityHandle handle);
+        public static explicit operator MethodSpecificationHandle (Handle handle);
+        public static implicit operator Handle (MethodSpecificationHandle handle);
+        public static implicit operator EntityHandle (MethodSpecificationHandle handle);
+        public static bool operator !=(MethodSpecificationHandle left, MethodSpecificationHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ModuleDefinition {
+        public GuidHandle BaseGenerationId { get; }
+        public int Generation { get; }
+        public GuidHandle GenerationId { get; }
+        public GuidHandle Mvid { get; }
+        public StringHandle Name { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ModuleDefinitionHandle : IEquatable<ModuleDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ModuleDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(ModuleDefinitionHandle left, ModuleDefinitionHandle right);
+        public static explicit operator ModuleDefinitionHandle (EntityHandle handle);
+        public static explicit operator ModuleDefinitionHandle (Handle handle);
+        public static implicit operator Handle (ModuleDefinitionHandle handle);
+        public static implicit operator EntityHandle (ModuleDefinitionHandle handle);
+        public static bool operator !=(ModuleDefinitionHandle left, ModuleDefinitionHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ModuleReference {
+        public StringHandle Name { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ModuleReferenceHandle : IEquatable<ModuleReferenceHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ModuleReferenceHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(ModuleReferenceHandle left, ModuleReferenceHandle right);
+        public static explicit operator ModuleReferenceHandle (EntityHandle handle);
+        public static explicit operator ModuleReferenceHandle (Handle handle);
+        public static implicit operator Handle (ModuleReferenceHandle handle);
+        public static implicit operator EntityHandle (ModuleReferenceHandle handle);
+        public static bool operator !=(ModuleReferenceHandle left, ModuleReferenceHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct NamespaceDefinition {
+        public ImmutableArray<ExportedTypeHandle> ExportedTypes { get; }
+        public StringHandle Name { get; }
+        public ImmutableArray<NamespaceDefinitionHandle> NamespaceDefinitions { get; }
+        public NamespaceDefinitionHandle Parent { get; }
+        public ImmutableArray<TypeDefinitionHandle> TypeDefinitions { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct NamespaceDefinitionHandle : IEquatable<NamespaceDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(NamespaceDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(NamespaceDefinitionHandle left, NamespaceDefinitionHandle right);
+        public static explicit operator NamespaceDefinitionHandle (Handle handle);
+        public static implicit operator Handle (NamespaceDefinitionHandle handle);
+        public static bool operator !=(NamespaceDefinitionHandle left, NamespaceDefinitionHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct Parameter {
+        public ParameterAttributes Attributes { get; }
+        public StringHandle Name { get; }
+        public int SequenceNumber { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public ConstantHandle GetDefaultValue();
+        public BlobHandle GetMarshallingDescriptor();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ParameterHandle : IEquatable<ParameterHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(ParameterHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(ParameterHandle left, ParameterHandle right);
+        public static explicit operator ParameterHandle (EntityHandle handle);
+        public static explicit operator ParameterHandle (Handle handle);
+        public static implicit operator Handle (ParameterHandle handle);
+        public static implicit operator EntityHandle (ParameterHandle handle);
+        public static bool operator !=(ParameterHandle left, ParameterHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ParameterHandleCollection : IEnumerable, IEnumerable<ParameterHandle>, IReadOnlyCollection<ParameterHandle> {
+        public int Count { get; }
+        public ParameterHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<ParameterHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.ParameterHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<ParameterHandle> {
+            public ParameterHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public static class PEReaderExtensions {
+        public static MetadataReader GetMetadataReader(this PEReader peReader);
+        public static MetadataReader GetMetadataReader(this PEReader peReader, MetadataReaderOptions options);
+        public static MetadataReader GetMetadataReader(this PEReader peReader, MetadataReaderOptions options, MetadataStringDecoder utf8Decoder);
+        public static MethodBodyBlock GetMethodBody(this PEReader peReader, int relativeVirtualAddress);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct PropertyAccessors {
+        public MethodDefinitionHandle Getter { get; }
+        public MethodDefinitionHandle Setter { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct PropertyDefinition {
+        public PropertyAttributes Attributes { get; }
+        public StringHandle Name { get; }
+        public BlobHandle Signature { get; }
+        public PropertyAccessors GetAccessors();
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public ConstantHandle GetDefaultValue();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct PropertyDefinitionHandle : IEquatable<PropertyDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(PropertyDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(PropertyDefinitionHandle left, PropertyDefinitionHandle right);
+        public static explicit operator PropertyDefinitionHandle (EntityHandle handle);
+        public static explicit operator PropertyDefinitionHandle (Handle handle);
+        public static implicit operator Handle (PropertyDefinitionHandle handle);
+        public static implicit operator EntityHandle (PropertyDefinitionHandle handle);
+        public static bool operator !=(PropertyDefinitionHandle left, PropertyDefinitionHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct PropertyDefinitionHandleCollection : IEnumerable, IEnumerable<PropertyDefinitionHandle>, IReadOnlyCollection<PropertyDefinitionHandle> {
+        public int Count { get; }
+        public PropertyDefinitionHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<PropertyDefinitionHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.PropertyDefinitionHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<PropertyDefinitionHandle> {
+            public PropertyDefinitionHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SequencePoint : IEquatable<SequencePoint> {
+        public const int HiddenLine = 16707566;
+        public DocumentHandle Document { get; }
+        public int EndColumn { get; }
+        public int EndLine { get; }
+        public bool IsHidden { get; }
+        public int Offset { get; }
+        public int StartColumn { get; }
+        public int StartLine { get; }
+        public override bool Equals(object obj);
+        public bool Equals(SequencePoint other);
+        public override int GetHashCode();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SequencePointCollection : IEnumerable, IEnumerable<SequencePoint> {
+        public SequencePointCollection.Enumerator GetEnumerator();
+        IEnumerator<SequencePoint> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.SequencePoint>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<SequencePoint> {
+            public SequencePoint Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            public void Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    public enum SerializationTypeCode : byte {
+        Boolean = (byte)2,
+        Byte = (byte)5,
+        Char = (byte)3,
+        Double = (byte)13,
+        Enum = (byte)85,
+        Int16 = (byte)6,
+        Int32 = (byte)8,
+        Int64 = (byte)10,
+        Invalid = (byte)0,
+        SByte = (byte)4,
+        Single = (byte)12,
+        String = (byte)14,
+        SZArray = (byte)29,
+        TaggedObject = (byte)81,
+        Type = (byte)80,
+        UInt16 = (byte)7,
+        UInt32 = (byte)9,
+        UInt64 = (byte)11,
+    }
+    public enum SignatureAttributes : byte {
+        ExplicitThis = (byte)64,
+        Generic = (byte)16,
+        Instance = (byte)32,
+        None = (byte)0,
+    }
+    public enum SignatureCallingConvention : byte {
+        CDecl = (byte)1,
+        Default = (byte)0,
+        FastCall = (byte)4,
+        StdCall = (byte)2,
+        ThisCall = (byte)3,
+        VarArgs = (byte)5,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SignatureHeader : IEquatable<SignatureHeader> {
+        public const byte CallingConventionOrKindMask = (byte)15;
+        public SignatureHeader(byte rawValue);
+        public SignatureHeader(SignatureKind kind, SignatureCallingConvention convention, SignatureAttributes attributes);
+        public SignatureAttributes Attributes { get; }
+        public SignatureCallingConvention CallingConvention { get; }
+        public bool HasExplicitThis { get; }
+        public bool IsGeneric { get; }
+        public bool IsInstance { get; }
+        public SignatureKind Kind { get; }
+        public byte RawValue { get; }
+        public override bool Equals(object obj);
+        public bool Equals(SignatureHeader other);
+        public override int GetHashCode();
+        public static bool operator ==(SignatureHeader left, SignatureHeader right);
+        public static bool operator !=(SignatureHeader left, SignatureHeader right);
+        public override string ToString();
+    }
+    public enum SignatureKind : byte {
+        Field = (byte)6,
+        LocalVariables = (byte)7,
+        Method = (byte)0,
+        MethodSpecification = (byte)10,
+        Property = (byte)8,
+    }
+    public enum SignatureTypeCode : byte {
+        Array = (byte)20,
+        Boolean = (byte)2,
+        ByReference = (byte)16,
+        Byte = (byte)5,
+        Char = (byte)3,
+        Double = (byte)13,
+        FunctionPointer = (byte)27,
+        GenericMethodParameter = (byte)30,
+        GenericTypeInstance = (byte)21,
+        GenericTypeParameter = (byte)19,
+        Int16 = (byte)6,
+        Int32 = (byte)8,
+        Int64 = (byte)10,
+        IntPtr = (byte)24,
+        Invalid = (byte)0,
+        Object = (byte)28,
+        OptionalModifier = (byte)32,
+        Pinned = (byte)69,
+        Pointer = (byte)15,
+        RequiredModifier = (byte)31,
+        SByte = (byte)4,
+        Sentinel = (byte)65,
+        Single = (byte)12,
+        String = (byte)14,
+        SZArray = (byte)29,
+        TypedReference = (byte)22,
+        TypeHandle = (byte)64,
+        UInt16 = (byte)7,
+        UInt32 = (byte)9,
+        UInt64 = (byte)11,
+        UIntPtr = (byte)25,
+        Void = (byte)1,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct StandaloneSignature {
+        public BlobHandle Signature { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public StandaloneSignatureKind GetKind();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct StandaloneSignatureHandle : IEquatable<StandaloneSignatureHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(StandaloneSignatureHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(StandaloneSignatureHandle left, StandaloneSignatureHandle right);
+        public static explicit operator StandaloneSignatureHandle (EntityHandle handle);
+        public static explicit operator StandaloneSignatureHandle (Handle handle);
+        public static implicit operator Handle (StandaloneSignatureHandle handle);
+        public static implicit operator EntityHandle (StandaloneSignatureHandle handle);
+        public static bool operator !=(StandaloneSignatureHandle left, StandaloneSignatureHandle right);
+    }
+    public enum StandaloneSignatureKind {
+        LocalVariables = 1,
+        Method = 0,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct StringHandle : IEquatable<StringHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(StringHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(StringHandle left, StringHandle right);
+        public static explicit operator StringHandle (Handle handle);
+        public static implicit operator Handle (StringHandle handle);
+        public static bool operator !=(StringHandle left, StringHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TypeDefinition {
+        public TypeAttributes Attributes { get; }
+        public EntityHandle BaseType { get; }
+        public StringHandle Name { get; }
+        public StringHandle Namespace { get; }
+        public NamespaceDefinitionHandle NamespaceDefinition { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+        public DeclarativeSecurityAttributeHandleCollection GetDeclarativeSecurityAttributes();
+        public TypeDefinitionHandle GetDeclaringType();
+        public EventDefinitionHandleCollection GetEvents();
+        public FieldDefinitionHandleCollection GetFields();
+        public GenericParameterHandleCollection GetGenericParameters();
+        public InterfaceImplementationHandleCollection GetInterfaceImplementations();
+        public TypeLayout GetLayout();
+        public MethodImplementationHandleCollection GetMethodImplementations();
+        public MethodDefinitionHandleCollection GetMethods();
+        public ImmutableArray<TypeDefinitionHandle> GetNestedTypes();
+        public PropertyDefinitionHandleCollection GetProperties();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TypeDefinitionHandle : IEquatable<TypeDefinitionHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(TypeDefinitionHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(TypeDefinitionHandle left, TypeDefinitionHandle right);
+        public static explicit operator TypeDefinitionHandle (EntityHandle handle);
+        public static explicit operator TypeDefinitionHandle (Handle handle);
+        public static implicit operator Handle (TypeDefinitionHandle handle);
+        public static implicit operator EntityHandle (TypeDefinitionHandle handle);
+        public static bool operator !=(TypeDefinitionHandle left, TypeDefinitionHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TypeDefinitionHandleCollection : IEnumerable, IEnumerable<TypeDefinitionHandle>, IReadOnlyCollection<TypeDefinitionHandle> {
+        public int Count { get; }
+        public TypeDefinitionHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<TypeDefinitionHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.TypeDefinitionHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<TypeDefinitionHandle> {
+            public TypeDefinitionHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TypeLayout {
+        public TypeLayout(int size, int packingSize);
+        public bool IsDefault { get; }
+        public int PackingSize { get; }
+        public int Size { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TypeReference {
+        public StringHandle Name { get; }
+        public StringHandle Namespace { get; }
+        public EntityHandle ResolutionScope { get; }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TypeReferenceHandle : IEquatable<TypeReferenceHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(TypeReferenceHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(TypeReferenceHandle left, TypeReferenceHandle right);
+        public static explicit operator TypeReferenceHandle (EntityHandle handle);
+        public static explicit operator TypeReferenceHandle (Handle handle);
+        public static implicit operator Handle (TypeReferenceHandle handle);
+        public static implicit operator EntityHandle (TypeReferenceHandle handle);
+        public static bool operator !=(TypeReferenceHandle left, TypeReferenceHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TypeReferenceHandleCollection : IEnumerable, IEnumerable<TypeReferenceHandle>, IReadOnlyCollection<TypeReferenceHandle> {
+        public int Count { get; }
+        public TypeReferenceHandleCollection.Enumerator GetEnumerator();
+        IEnumerator<TypeReferenceHandle> System.Collections.Generic.IEnumerable<System.Reflection.Metadata.TypeReferenceHandle>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<TypeReferenceHandle> {
+            public TypeReferenceHandle Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+            void System.IDisposable.Dispose();
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TypeSpecification {
+        public BlobHandle Signature { get; }
+        public CustomAttributeHandleCollection GetCustomAttributes();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct TypeSpecificationHandle : IEquatable<TypeSpecificationHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(TypeSpecificationHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(TypeSpecificationHandle left, TypeSpecificationHandle right);
+        public static explicit operator TypeSpecificationHandle (EntityHandle handle);
+        public static explicit operator TypeSpecificationHandle (Handle handle);
+        public static implicit operator Handle (TypeSpecificationHandle handle);
+        public static implicit operator EntityHandle (TypeSpecificationHandle handle);
+        public static bool operator !=(TypeSpecificationHandle left, TypeSpecificationHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct UserStringHandle : IEquatable<UserStringHandle> {
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(UserStringHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(UserStringHandle left, UserStringHandle right);
+        public static explicit operator UserStringHandle (Handle handle);
+        public static implicit operator Handle (UserStringHandle handle);
+        public static bool operator !=(UserStringHandle left, UserStringHandle right);
+    }
+}
```

