"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeProperties = exports.randomString = exports.supportsInlineSVG = exports.isSupportedEnvironment = exports.canUseDOM = exports.STATUS = void 0;
var exenv_1 = require("exenv");
exports.STATUS = {
    FAILED: 'failed',
    LOADED: 'loaded',
    LOADING: 'loading',
    PENDING: 'pending',
    READY: 'ready',
    UNSUPPORTED: 'unsupported',
};
function canUseDOM() {
    return exenv_1.canUseDOM;
}
exports.canUseDOM = canUseDOM;
function isSupportedEnvironment() {
    return supportsInlineSVG() && typeof window !== 'undefined' && window !== null;
}
exports.isSupportedEnvironment = isSupportedEnvironment;
function supportsInlineSVG() {
    /* istanbul ignore next */
    if (!document) {
        return false;
    }
    var div = document.createElement('div');
    div.innerHTML = '<svg />';
    return !!div.firstChild && div.firstChild.namespaceURI === 'http://www.w3.org/2000/svg';
}
exports.supportsInlineSVG = supportsInlineSVG;
function randomString(length) {
    var letters = 'abcdefghijklmnopqrstuvwxyz';
    var numbers = '1234567890';
    var charset = "" + letters + letters.toUpperCase() + numbers;
    var randomCharacter = function (character) {
        return character[Math.floor(Math.random() * character.length)];
    };
    var R = '';
    for (var i = 0; i < length; i++) {
        R += randomCharacter(charset);
    }
    return R;
}
exports.randomString = randomString;
/**
 *  Remove properties from an object
 */
function removeProperties(input) {
    var filter = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        filter[_i - 1] = arguments[_i];
    }
    var output = {};
    for (var key in input) {
        /* istanbul ignore else */
        if ({}.hasOwnProperty.call(input, key)) {
            if (!filter.includes(key)) {
                output[key] = input[key];
            }
        }
    }
    return output;
}
exports.removeProperties = removeProperties;
//# sourceMappingURL=helpers.js.map