import { TypeScriptResolversPluginConfig } from './config';
import { FieldDefinitionNode, ListTypeNode, NamedTypeNode, NonNullTypeNode, GraphQLSchema, EnumTypeDefinitionNode } from 'graphql';
import { ParsedResolversConfig, BaseResolversVisitor, DeclarationKind } from '@graphql-codegen/visitor-plugin-common';
export declare const ENUM_RESOLVERS_SIGNATURE = "export type EnumResolverSignature<T, AllowedValues = any> = { [key in keyof T]?: AllowedValues };";
export interface ParsedTypeScriptResolversConfig extends ParsedResolversConfig {
    useIndexSignature: boolean;
    wrapFieldDefinitions: boolean;
    allowParentTypeOverride: boolean;
    optionalInfoArgument: boolean;
}
export declare class TypeScriptResolversVisitor extends BaseResolversVisitor<TypeScriptResolversPluginConfig, ParsedTypeScriptResolversConfig> {
    constructor(pluginConfig: TypeScriptResolversPluginConfig, schema: GraphQLSchema);
    protected transformParentGenericType(parentType: string): string;
    protected formatRootResolver(schemaTypeName: string, resolverType: string, declarationKind: DeclarationKind): string;
    private clearOptional;
    ListType(node: ListTypeNode): string;
    protected wrapWithListType(str: string): string;
    protected getParentTypeForSignature(node: FieldDefinitionNode): "ParentType" | "UnwrappedObject<ParentType>";
    NamedType(node: NamedTypeNode): string;
    NonNullType(node: NonNullTypeNode): string;
    protected getPunctuation(_declarationKind: DeclarationKind): string;
    protected buildEnumResolverContentBlock(node: EnumTypeDefinitionNode, mappedEnumType: string): string;
    protected buildEnumResolversExplicitMappedValues(node: EnumTypeDefinitionNode, valuesMapping: {
        [valueName: string]: string | number;
    }): string;
}
