"use strict";exports.__esModule=true;exports.default=void 0;var _webpack=require("next/dist/compiled/webpack/webpack");var _constants=require("../../../next-server/lib/constants");var _getRouteFromEntrypoint=_interopRequireDefault(require("../../../next-server/server/get-route-from-entrypoint"));function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}// This plugin creates a pages-manifest.json from page entrypoints.
// This is used for mapping paths like `/` to `.next/server/static/<buildid>/pages/index.js` when doing SSR
// It's also used by next export to provide defaultPathMap
class PagesManifestPlugin{constructor({serverless,dev}){this.serverless=void 0;this.dev=void 0;this.serverless=serverless;this.dev=dev;}createAssets(compilation,assets){const entrypoints=compilation.entrypoints;const pages={};for(const entrypoint of entrypoints.values()){const pagePath=(0,_getRouteFromEntrypoint.default)(entrypoint.name);if(!pagePath){continue;}const files=entrypoint.getFiles().filter(file=>!file.includes('webpack-runtime')&&file.endsWith('.js'));if(!_webpack.isWebpack5&&files.length>1){console.log(`Found more than one file in server entrypoint ${entrypoint.name}`,files);continue;}// Write filename, replace any backslashes in path (on windows) with forwardslashes for cross-platform consistency.
pages[pagePath]=files[files.length-1];if(_webpack.isWebpack5&&!this.dev){pages[pagePath]=pages[pagePath].slice(3);}pages[pagePath]=pages[pagePath].replace(/\\/g,'/');}assets[`${_webpack.isWebpack5&&!this.dev?'../':''}`+_constants.PAGES_MANIFEST]=new _webpack.sources.RawSource(JSON.stringify(pages,null,2));}apply(compiler){if(_webpack.isWebpack5){compiler.hooks.make.tap('NextJsPagesManifest',compilation=>{// @ts-ignore TODO: Remove ignore when webpack 5 is stable
compilation.hooks.processAssets.tap({name:'NextJsPagesManifest',// @ts-ignore TODO: Remove ignore when webpack 5 is stable
stage:_webpack.webpack.Compilation.PROCESS_ASSETS_STAGE_ADDITIONS},assets=>{this.createAssets(compilation,assets);});});return;}compiler.hooks.emit.tap('NextJsPagesManifest',compilation=>{this.createAssets(compilation,compilation.assets);});}}exports.default=PagesManifestPlugin;
//# sourceMappingURL=pages-manifest-plugin.js.map