"use strict";exports.__esModule=true;exports.formatResults=formatResults;exports.MessageSeverity=void 0;var _chalk=_interopRequireDefault(require("chalk"));var _path=_interopRequireDefault(require("path"));function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}// eslint-disable-next-line no-shadow
let MessageSeverity;exports.MessageSeverity=MessageSeverity;(function(MessageSeverity){MessageSeverity[MessageSeverity["Warning"]=1]="Warning";MessageSeverity[MessageSeverity["Error"]=2]="Error";})(MessageSeverity||(exports.MessageSeverity=MessageSeverity={}));function formatMessage(dir,messages,filePath){let fileName=_path.default.posix.normalize(_path.default.relative(dir,filePath).replace(/\\/g,'/'));if(!fileName.startsWith('.')){fileName='./'+fileName;}let output='\n'+_chalk.default.cyan(fileName);let nextPluginWarningCount=0;let nextPluginErrorCount=0;for(let i=0;i<messages.length;i++){const{message,severity,line,column,ruleId}=messages[i];output=output+'\n';if(line&&column){output=output+_chalk.default.yellow(line.toString())+':'+_chalk.default.yellow(column.toString())+'  ';}if(ruleId!=null&&ruleId.includes('@next/next')){if(severity===MessageSeverity.Warning){nextPluginWarningCount+=1;}else{nextPluginErrorCount+=1;}}if(severity===MessageSeverity.Warning){output+=_chalk.default.yellow.bold('Warning')+': ';}else{output+=_chalk.default.red.bold('Error')+': ';}output+=message;if(ruleId){output+='  '+_chalk.default.gray.bold(ruleId);}}return{output,nextPluginErrorCount,nextPluginWarningCount};}function formatResults(baseDir,results){let totalNextPluginErrorCount=0;let totalNextPluginWarningCount=0;const formattedResults=results.filter(({messages})=>messages==null?void 0:messages.length).map(({messages,filePath})=>{const res=formatMessage(baseDir,messages,filePath);totalNextPluginErrorCount+=res.nextPluginErrorCount;totalNextPluginWarningCount+=res.nextPluginWarningCount;return res.output;}).join('\n');return{output:formattedResults.length>0?formattedResults+`\n\n${_chalk.default.bold('Need to disable some ESLint rules? Learn more here:')} https://nextjs.org/docs/basic-features/eslint#disabling-rules\n`:'',totalNextPluginErrorCount,totalNextPluginWarningCount};}
//# sourceMappingURL=customFormatter.js.map