"use strict";exports.__esModule=true;exports.runLintCheck=runLintCheck;var _fs=require("fs");var _chalk=_interopRequireDefault(require("chalk"));var _path=_interopRequireDefault(require("path"));var _findUp=_interopRequireDefault(require("next/dist/compiled/find-up"));var _semver=_interopRequireDefault(require("next/dist/compiled/semver"));var CommentJson=_interopRequireWildcard(require("next/dist/compiled/comment-json"));var _customFormatter=require("./customFormatter");var _writeDefaultConfig=require("./writeDefaultConfig");var _findPagesDir=require("../find-pages-dir");var _hasNecessaryDependencies=require("../has-necessary-dependencies");var Log=_interopRequireWildcard(require("../../build/output/log"));function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}function _getRequireWildcardCache(){if(typeof WeakMap!=="function")return null;var cache=new WeakMap();_getRequireWildcardCache=function(){return cache;};return cache;}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj;}if(obj===null||typeof obj!=="object"&&typeof obj!=="function"){return{default:obj};}var cache=_getRequireWildcardCache();if(cache&&cache.has(obj)){return cache.get(obj);}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc);}else{newObj[key]=obj[key];}}}newObj.default=obj;if(cache){cache.set(obj,newObj);}return newObj;}async function lint(deps,baseDir,lintDirs,eslintrcFile,pkgJsonPath,eslintOptions=null,reportErrorsOnly=false){var _ESLint$getErrorResul;// Load ESLint after we're sure it exists:
const mod=await Promise.resolve(`${deps.resolved.get('eslint')}`).then(s=>_interopRequireWildcard(require(s)));const{ESLint}=mod;let eslintVersion=ESLint==null?void 0:ESLint.version;if(!ESLint){var _mod$CLIEngine;eslintVersion=mod==null?void 0:(_mod$CLIEngine=mod.CLIEngine)==null?void 0:_mod$CLIEngine.version;if(!eslintVersion||_semver.default.lt(eslintVersion,'7.0.0')){return`${_chalk.default.red('error')} - Your project has an older version of ESLint installed${eslintVersion?' ('+eslintVersion+')':''}. Please upgrade to ESLint version 7 or later`;}return`${_chalk.default.red('error')} - ESLint class not found. Please upgrade to ESLint version 7 or later`;}let options={useEslintrc:true,baseConfig:{},extensions:['.js','.jsx','.ts','.tsx'],...eslintOptions};let eslint=new ESLint(options);let nextEslintPluginIsEnabled=false;const pagesDirRules=['@next/next/no-html-link-for-pages'];for(const configFile of[eslintrcFile,pkgJsonPath]){var _completeConfig$plugi;if(!configFile)continue;const completeConfig=await eslint.calculateConfigForFile(configFile);if((_completeConfig$plugi=completeConfig.plugins)!=null&&_completeConfig$plugi.includes('@next/next')){nextEslintPluginIsEnabled=true;break;}}const pagesDir=(0,_findPagesDir.findPagesDir)(baseDir);if(nextEslintPluginIsEnabled){let updatedPagesDir=false;for(const rule of pagesDirRules){var _rules,_rules2;if(!((_rules=options.baseConfig.rules)!=null&&_rules[rule])&&!((_rules2=options.baseConfig.rules)!=null&&_rules2[rule.replace('@next/next','@next/babel-plugin-next')])){if(!options.baseConfig.rules){options.baseConfig.rules={};}options.baseConfig.rules[rule]=[1,pagesDir];updatedPagesDir=true;}}if(updatedPagesDir){eslint=new ESLint(options);}}const lintStart=process.hrtime();let results=await eslint.lintFiles(lintDirs);if(options.fix)await ESLint.outputFixes(results);if(reportErrorsOnly)results=await ESLint.getErrorResults(results);// Only return errors if --quiet flag is used
const formattedResult=(0,_customFormatter.formatResults)(baseDir,results);const lintEnd=process.hrtime(lintStart);return{output:formattedResult.output,isError:((_ESLint$getErrorResul=ESLint.getErrorResults(results))==null?void 0:_ESLint$getErrorResul.length)>0,eventInfo:{durationInSeconds:lintEnd[0],eslintVersion:eslintVersion,lintedFilesCount:results.length,lintFix:!!options.fix,nextEslintPluginVersion:nextEslintPluginIsEnabled?require(_path.default.join(_path.default.dirname(deps.resolved.get('eslint-config-next')),'package.json')).version:null,nextEslintPluginErrorsCount:formattedResult.totalNextPluginErrorCount,nextEslintPluginWarningsCount:formattedResult.totalNextPluginWarningCount}};}async function runLintCheck(baseDir,lintDirs,lintDuringBuild=false,eslintOptions=null,reportErrorsOnly=false){try{var _await$findUp,_await$findUp2;// Find user's .eslintrc file
const eslintrcFile=(_await$findUp=await(0,_findUp.default)(['.eslintrc.js','.eslintrc.yaml','.eslintrc.yml','.eslintrc.json','.eslintrc'],{cwd:baseDir}))!=null?_await$findUp:null;const pkgJsonPath=(_await$findUp2=await(0,_findUp.default)('package.json',{cwd:baseDir}))!=null?_await$findUp2:null;let packageJsonConfig=null;if(pkgJsonPath){const pkgJsonContent=await _fs.promises.readFile(pkgJsonPath,{encoding:'utf8'});packageJsonConfig=CommentJson.parse(pkgJsonContent);}// Warning displayed if no ESLint configuration is present during build
if(lintDuringBuild&&!eslintrcFile&&!packageJsonConfig.eslintConfig){Log.warn(`No ESLint configuration detected. Run ${_chalk.default.bold.cyan('next lint')} to begin setup`);return null;}// Ensure ESLint and necessary plugins and configs are installed:
const deps=await(0,_hasNecessaryDependencies.hasNecessaryDependencies)(baseDir,false,true,lintDuringBuild);// Write default ESLint config if none is present
// Check for /pages and src/pages is to make sure this happens in Next.js folder
if((0,_findPagesDir.existsSync)(_path.default.join(baseDir,'pages'))||(0,_findPagesDir.existsSync)(_path.default.join(baseDir,'src/pages'))){await(0,_writeDefaultConfig.writeDefaultConfig)(eslintrcFile,pkgJsonPath,packageJsonConfig);}// Run ESLint
return await lint(deps,baseDir,lintDirs,eslintrcFile,pkgJsonPath,eslintOptions,reportErrorsOnly);}catch(err){throw err;}}
//# sourceMappingURL=runLintCheck.js.map