"use strict";exports.__esModule=true;exports.getTypeScriptConfiguration=getTypeScriptConfiguration;var _chalk=_interopRequireDefault(require("chalk"));var _os=_interopRequireDefault(require("os"));var _path2=_interopRequireDefault(require("path"));var _fatalError=require("../fatal-error");function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}async function getTypeScriptConfiguration(ts,tsConfigPath,metaOnly){try{var _result$errors;const formatDiagnosticsHost={getCanonicalFileName:fileName=>fileName,getCurrentDirectory:ts.sys.getCurrentDirectory,getNewLine:()=>_os.default.EOL};const{config,error}=ts.readConfigFile(tsConfigPath,ts.sys.readFile);if(error){throw new _fatalError.FatalError(ts.formatDiagnostic(error,formatDiagnosticsHost));}let configToParse=config;const result=ts.parseJsonConfigFileContent(configToParse,// When only interested in meta info,
// avoid enumerating all files (for performance reasons)
metaOnly?{...ts.sys,readDirectory(_path,extensions,_excludes,_includes,_depth){return[extensions?`file${extensions[0]}`:`file.ts`];}}:ts.sys,_path2.default.dirname(tsConfigPath));if(result.errors){result.errors=result.errors.filter(({code})=>// No inputs were found in config file
code!==18003);}if((_result$errors=result.errors)!=null&&_result$errors.length){throw new _fatalError.FatalError(ts.formatDiagnostic(result.errors[0],formatDiagnosticsHost));}return result;}catch(err){if((err==null?void 0:err.name)==='SyntaxError'){var _err$message;const reason='\n'+((_err$message=err==null?void 0:err.message)!=null?_err$message:'');throw new _fatalError.FatalError(_chalk.default.red.bold('Could not parse',_chalk.default.cyan('tsconfig.json')+'.'+' Please make sure it contains syntactically correct JSON.')+reason);}throw err;}}
//# sourceMappingURL=getTypeScriptConfiguration.js.map